'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var React = require('react');
var React__default = _interopDefault(React);

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

var AB = function AB(_ref) {
  var children = _ref.children,
      p = _objectWithoutPropertiesLoose(_ref, ["children"]);

  return React__default.createElement("button", Object.assign({
    type: "button"
  }, p, {
    className: "rtf--ab"
  }), children);
};

var MB = function MB(_ref2) {
  var children = _ref2.children,
      p = _objectWithoutPropertiesLoose(_ref2, ["children"]);

  return React__default.createElement("button", Object.assign({
    type: "button",
    className: "rtf--mb"
  }, p), children);
};
var defaultStyles = {
  bottom: 24,
  right: 24
};

var Fab = function Fab(_ref3) {
  var _ref3$event = _ref3.event,
      event = _ref3$event === void 0 ? 'hover' : _ref3$event,
      _ref3$style = _ref3.style,
      style = _ref3$style === void 0 ? defaultStyles : _ref3$style,
      _ref3$alwaysShowTitle = _ref3.alwaysShowTitle,
      alwaysShowTitle = _ref3$alwaysShowTitle === void 0 ? false : _ref3$alwaysShowTitle,
      children = _ref3.children,
      icon = _ref3.icon,
      mainButtonStyles = _ref3.mainButtonStyles,
      onClick = _ref3.onClick,
      text = _ref3.text,
      p = _objectWithoutPropertiesLoose(_ref3, ["event", "style", "alwaysShowTitle", "children", "icon", "mainButtonStyles", "onClick", "text"]);

  var _useState = React.useState(false),
      isOpen = _useState[0],
      setIsOpen = _useState[1];

  var ariaHidden = alwaysShowTitle || !isOpen;
  var interpolatedEvent = 'ontouchstart' in window ? 'click' : event;

  var open = function open() {
    return setIsOpen(true);
  };

  var close = function close() {
    return setIsOpen(false);
  };

  var enter = function enter() {
    return interpolatedEvent === 'hover' && open();
  };

  var leave = function leave() {
    return interpolatedEvent === 'hover' && close();
  };

  var toggle = function toggle(e) {
    if (onClick) {
      return onClick(e);
    }

    e.persist();
    return interpolatedEvent === 'click' ? isOpen ? close() : open() : null;
  };

  var actionOnClick = function actionOnClick(e, userFunc) {
    e.persist();
    setIsOpen(false);
    setTimeout(function () {
      userFunc(e);
    }, 1);
  };

  var rc = function rc() {
    return React__default.Children.map(children, function (ch, i) {
      if (React__default.isValidElement(ch)) {
        return React__default.createElement("li", {
          className: "rtf--ab__c " + ('top' in style ? 'top' : '')
        }, React__default.cloneElement(ch, _extends({
          'data-testid': "action-button-" + i,
          'aria-label': ch.props.text || "Menu button " + (i + 1),
          'aria-hidden': ariaHidden,
          tabIndex: isOpen ? 0 : -1
        }, ch.props, {
          onClick: function onClick(e) {
            if (ch.props.onClick) actionOnClick(e, ch.props.onClick);
          }
        })), ch.props.text && React__default.createElement("span", {
          className: ('right' in style ? 'right' : '') + " " + (alwaysShowTitle ? 'always-show' : ''),
          "aria-hidden": ariaHidden
        }, ch.props.text));
      }

      return null;
    });
  };

  return React__default.createElement("ul", Object.assign({
    onMouseEnter: enter,
    onMouseLeave: leave,
    className: "rtf " + (isOpen ? 'open' : 'closed'),
    "data-testid": "fab",
    style: style
  }, p), React__default.createElement("li", {
    className: "rtf--mb__c"
  }, React__default.createElement(MB, {
    onClick: toggle,
    style: mainButtonStyles,
    "data-testid": "main-button",
    role: "button",
    "aria-label": "Floating menu",
    tabIndex: 0
  }, icon), text && React__default.createElement("span", {
    className: ('right' in style ? 'right' : '') + " " + (alwaysShowTitle ? 'always-show' : ''),
    "aria-hidden": ariaHidden
  }, text), React__default.createElement("ul", null, rc())));
};

exports.Action = AB;
exports.Fab = Fab;
exports.MB = MB;
//# sourceMappingURL=react-tiny-fab.cjs.development.js.map
