"use strict";
/**
  * @reach/rect v0.18.0
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */


// src/reach-rect.tsx
import * as React from "react";
import observeRect from "@reach/observe-rect";
import {
  useIsomorphicLayoutEffect as useLayoutEffect,
  isBoolean,
  isFunction
} from "@reach/utils";
var Rect = ({ onChange, observe = true, children }) => {
  const ref = React.useRef(null);
  const rect = useRect(ref, { observe, onChange });
  return children({ ref, rect });
};
Rect.displayName = "Rect";
function useRect(nodeRef, observeOrOptions, deprecated_onChange) {
  let observe;
  let onChange;
  if (isBoolean(observeOrOptions)) {
    observe = observeOrOptions;
  } else {
    observe = observeOrOptions?.observe ?? true;
    onChange = observeOrOptions?.onChange;
  }
  if (isFunction(deprecated_onChange)) {
    onChange = deprecated_onChange;
  }
  if (true) {
    React.useEffect(() => {
      if (isBoolean(observeOrOptions)) {
        console.warn("Passing `observe` as the second argument to `useRect` is deprecated and will be removed in a future version of Reach UI. Instead, you can pass an object of options with an `observe` property as the second argument (`useRect(ref, { observe })`).\nSee https://reach.tech/rect#userect-observe");
      }
    }, [observeOrOptions]);
    React.useEffect(() => {
      if (isFunction(deprecated_onChange)) {
        console.warn("Passing `onChange` as the third argument to `useRect` is deprecated and will be removed in a future version of Reach UI. Instead, you can pass an object of options with an `onChange` property as the second argument (`useRect(ref, { onChange })`).\nSee https://reach.tech/rect#userect-onchange");
      }
    }, [deprecated_onChange]);
  }
  let [element, setElement] = React.useState(nodeRef.current);
  let initialRectIsSet = React.useRef(false);
  let initialRefIsSet = React.useRef(false);
  let [rect, setRect] = React.useState(null);
  let onChangeRef = React.useRef(onChange);
  useLayoutEffect(() => {
    onChangeRef.current = onChange;
    if (nodeRef.current !== element) {
      setElement(nodeRef.current);
    }
  });
  useLayoutEffect(() => {
    if (element && !initialRectIsSet.current) {
      initialRectIsSet.current = true;
      setRect(element.getBoundingClientRect());
    }
  }, [element]);
  useLayoutEffect(() => {
    if (!observe) {
      return;
    }
    let elem = element;
    if (!initialRefIsSet.current) {
      initialRefIsSet.current = true;
      elem = nodeRef.current;
    }
    if (!elem) {
      if (true) {
        console.warn("You need to place the ref");
      }
      return;
    }
    let observer = observeRect(elem, (rect2) => {
      onChangeRef.current?.(rect2);
      setRect(rect2);
    });
    observer.observe();
    return () => {
      observer.unobserve();
    };
  }, [observe, element, nodeRef]);
  return rect;
}
export {
  Rect,
  useRect
};
