"use strict";
/**
  * @reach/portal v0.18.0
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */


// src/reach-portal.tsx
import * as React from "react";
import {
  useForceUpdate,
  useIsomorphicLayoutEffect as useLayoutEffect
} from "@reach/utils";
import { createPortal } from "react-dom";
var PortalImpl = ({
  children,
  type = "reach-portal",
  containerRef
}) => {
  let mountNode = React.useRef(null);
  let portalNode = React.useRef(null);
  let forceUpdate = useForceUpdate();
  if (true) {
    React.useEffect(() => {
      if (containerRef != null) {
        if (typeof containerRef !== "object" || !("current" in containerRef)) {
          console.warn("@reach/portal: Invalid value passed to the `containerRef` of a `Portal`. The portal will be appended to the document body, but if you want to attach it to another DOM node you must pass a valid React ref object to `containerRef`.");
        } else if (containerRef.current == null) {
          console.warn("@reach/portal: A ref was passed to the `containerRef` prop of a `Portal`, but no DOM node was attached to it. Be sure to pass the ref to a DOM component.\n\nIf you are forwarding the ref from another component, be sure to use the React.forwardRef API. See https://reactjs.org/docs/forwarding-refs.html.");
        }
      }
    }, [containerRef]);
  }
  useLayoutEffect(() => {
    if (!mountNode.current)
      return;
    let ownerDocument = mountNode.current.ownerDocument;
    let body = containerRef?.current || ownerDocument.body;
    portalNode.current = ownerDocument?.createElement(type);
    body.appendChild(portalNode.current);
    forceUpdate();
    return () => {
      if (portalNode.current && body) {
        body.removeChild(portalNode.current);
      }
    };
  }, [type, forceUpdate, containerRef]);
  return portalNode.current ? createPortal(children, portalNode.current) : /* @__PURE__ */ React.createElement("span", {
    ref: mountNode
  });
};
var Portal = ({
  unstable_skipInitialRender,
  ...props
}) => {
  let [hydrated, setHydrated] = React.useState(false);
  React.useEffect(() => {
    if (unstable_skipInitialRender) {
      setHydrated(true);
    }
  }, [unstable_skipInitialRender]);
  if (unstable_skipInitialRender && !hydrated) {
    return null;
  }
  return /* @__PURE__ */ React.createElement(PortalImpl, {
    ...props
  });
};
Portal.displayName = "Portal";
export {
  Portal
};
