/**
  * @reach/auto-id v0.18.0
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */

/**
 * useId
 *
 * Autogenerate IDs to facilitate WAI-ARIA and server rendering.
 *
 * Note: The returned ID will initially be `null` and will update after a
 * component mounts. Users may need to supply their own ID if they need
 * consistent values for SSR.
 *
 * @see Docs https://reach.tech/auto-id
 */
declare function useId(idFromProps: string): string;
declare function useId(idFromProps: number): number;
declare function useId(idFromProps: string | number): string | number;
declare function useId(idFromProps: string | undefined | null): string | undefined;
declare function useId(idFromProps: number | undefined | null): number | undefined;
declare function useId(idFromProps: string | number | undefined | null): string | number | undefined;
declare function useId(): string | undefined;

export { useId };
