[![package:web](https://github.com/dart-lang/web/actions/workflows/web.yaml/badge.svg)](https://github.com/dart-lang/web/actions/workflows/web.yaml)
[![pub package](https://img.shields.io/pub/v/web.svg)](https://pub.dev/packages/web)
[![package publisher](https://img.shields.io/pub/publisher/web.svg)](https://pub.dev/packages/web/publisher)

Lightweight browser API bindings built around
[JS interop](https://dart.dev/interop/js-interop).

## What's this?

This package exposes browser APIs. It's generated from the Web IDL definitions
and uses recent Dart language features for zero-overhead bindings.

This package is intended to replace
[`dart:html`](https://api.dart.dev/stable/dart-html/dart-html-library.html) and
similar Dart SDK libraries. It will support access to browser APIs from Dart
code compiled to either JavaScript or WebAssembly.

## Usage

```dart
import 'package:web/web.dart';

void main() {
  final div = document.querySelector('div')!;
  div.text = 'Text set at ${DateTime.now()}';
}
```

## Migrating to package:web

`package:web` is replacing `dart:html` and other web libraries as Dart's 
long-term web interop solution. To learn how to migrate from `dart:html`
APIs to `package:web`, see our
[migration guide](https://dart.dev/go/package-web).

## Generation

This package is generated by `web_generator`. See the
[`README`](https://github.com/dart-lang/web/tree/main/web_generator) for more
details on the conventions used to generate this package and how to run the
different tools to generate bindings and update various package dependencies.
