## MIME types

Supported media types and file extensions.

<!-- start table -->

| MIME type                                | Default     | Additional          |
| ---------------------------------------- | ----------- | ------------------- |
| application/andrew-inset                 | ez          |                     |
| application/applixware                   | aw          |                     |
| application/atom+xml                     | atom        |                     |
| application/atomcat+xml                  | atomcat     |                     |
| application/atomsvc+xml                  | atomsvc     |                     |
| application/ccxml+xml                    | ccxml       |                     |
| application/cdmi-capability              | cdmia       |                     |
| application/cdmi-container               | cdmic       |                     |
| application/cdmi-domain                  | cdmid       |                     |
| application/cdmi-object                  | cdmio       |                     |
| application/cdmi-queue                   | cdmiq       |                     |
| application/cu-seeme                     | cu          |                     |
| application/davmount+xml                 | davmount    |                     |
| application/dicom                        | dcm         |                     |
| application/docbook+xml                  | dbk         |                     |
| application/dssc+der                     | dssc        |                     |
| application/dssc+xml                     | xdssc       |                     |
| application/ecmascript                   | ecma        |                     |
| application/emma+xml                     | emma        |                     |
| application/epub+zip                     | epub        |                     |
| application/exi                          | exi         |                     |
| application/font-tdpfr                   | pfr         |                     |
| application/gml+xml                      | gml         |                     |
| application/gpx+xml                      | gpx         |                     |
| application/gxf                          | gxf         |                     |
| application/hyperstudio                  | stk         |                     |
| application/inkml+xml                    | inkml       | ink                 |
| application/ipfix                        | ipfix       |                     |
| application/java-archive                 | jar         |                     |
| application/java-serialized-object       | ser         |                     |
| application/java-vm                      | class       |                     |
| application/json                         | json        |                     |
| application/jsonml+json                  | jsonml      |                     |
| application/lost+xml                     | lostxml     |                     |
| application/mac-binhex40                 | hqx         |                     |
| application/mac-compactpro               | cpt         |                     |
| application/mads+xml                     | mads        |                     |
| application/manifest+json                | webmanifest |                     |
| application/marc                         | mrc         |                     |
| application/marcxml+xml                  | mrcx        |                     |
| application/mathematica                  | nb          | ma, mb              |
| application/mathml+xml                   | mathml      |                     |
| application/mbox                         | mbox        |                     |
| application/mediaservercontrol+xml       | mscml       |                     |
| application/metalink+xml                 | metalink    |                     |
| application/metalink4+xml                | meta4       |                     |
| application/mets+xml                     | mets        |                     |
| application/mods+xml                     | mods        |                     |
| application/mp21                         | mp21        | m21                 |
| application/mp4                          | mp4s        |                     |
| application/msword                       | doc         | dot                 |
| application/mxf                          | mxf         |                     |
| application/octet-stream                 | so          | bin, bpk, deploy, dist, distz, dms, dump, elc, lrf, mar, pkg |
| application/oda                          | oda         |                     |
| application/oebps-package+xml            | opf         |                     |
| application/ogg                          | ogx         |                     |
| application/omdoc+xml                    | omdoc       |                     |
| application/onenote                      | onetoc2     | onepkg, onetmp, onetoc |
| application/oxps                         | oxps        |                     |
| application/patch-ops-error+xml          | xer         |                     |
| application/pdf                          | pdf         |                     |
| application/pgp-encrypted                | pgp         |                     |
| application/pgp-signature                | sig         | asc                 |
| application/pics-rules                   | prf         |                     |
| application/pkcs10                       | p10         |                     |
| application/pkcs7-mime                   | p7m         | p7c                 |
| application/pkcs7-signature              | p7s         |                     |
| application/pkcs8                        | p8          |                     |
| application/pkix-attr-cert               | ac          |                     |
| application/pkix-cert                    | cer         |                     |
| application/pkix-crl                     | crl         |                     |
| application/pkix-pkipath                 | pkipath     |                     |
| application/pkixcmp                      | pki         |                     |
| application/pls+xml                      | pls         |                     |
| application/postscript                   | ps          | ai, eps             |
| application/prs.cww                      | cww         |                     |
| application/pskc+xml                     | pskcxml     |                     |
| application/rdf+xml                      | rdf         |                     |
| application/reginfo+xml                  | rif         |                     |
| application/relax-ng-compact-syntax      | rnc         |                     |
| application/resource-lists+xml           | rl          |                     |
| application/resource-lists-diff+xml      | rld         |                     |
| application/rls-services+xml             | rs          |                     |
| application/rpki-ghostbusters            | gbr         |                     |
| application/rpki-manifest                | mft         |                     |
| application/rpki-roa                     | roa         |                     |
| application/rsd+xml                      | rsd         |                     |
| application/rss+xml                      | rss         |                     |
| application/rtf                          | rtf         |                     |
| application/sbml+xml                     | sbml        |                     |
| application/scvp-cv-request              | scq         |                     |
| application/scvp-cv-response             | scs         |                     |
| application/scvp-vp-request              | spq         |                     |
| application/scvp-vp-response             | spp         |                     |
| application/sdp                          | sdp         |                     |
| application/set-payment-initiation       | setpay      |                     |
| application/set-registration-initiation  | setreg      |                     |
| application/shf+xml                      | shf         |                     |
| application/smil+xml                     | smil        | smi                 |
| application/sparql-query                 | rq          |                     |
| application/sparql-results+xml           | srx         |                     |
| application/srgs                         | gram        |                     |
| application/srgs+xml                     | grxml       |                     |
| application/sru+xml                      | sru         |                     |
| application/ssdl+xml                     | ssdl        |                     |
| application/ssml+xml                     | ssml        |                     |
| application/tei+xml                      | teicorpus   | tei                 |
| application/thraud+xml                   | tfi         |                     |
| application/timestamped-data             | tsd         |                     |
| application/toml                         | toml        |                     |
| application/vnd.3gpp.pic-bw-large        | plb         |                     |
| application/vnd.3gpp.pic-bw-small        | psb         |                     |
| application/vnd.3gpp.pic-bw-var          | pvb         |                     |
| application/vnd.3gpp2.tcap               | tcap        |                     |
| application/vnd.3m.post-it-notes         | pwn         |                     |
| application/vnd.accpac.simply.aso        | aso         |                     |
| application/vnd.accpac.simply.imp        | imp         |                     |
| application/vnd.acucobol                 | acu         |                     |
| application/vnd.acucorp                  | atc         | acutc               |
| application/vnd.adobe.air-application-installer-package+zip | air         |                     |
| application/vnd.adobe.formscentral.fcdt  | fcdt        |                     |
| application/vnd.adobe.fxp                | fxpl        | fxp                 |
| application/vnd.adobe.xdp+xml            | xdp         |                     |
| application/vnd.adobe.xfdf               | xfdf        |                     |
| application/vnd.ahead.space              | ahead       |                     |
| application/vnd.airzip.filesecure.azf    | azf         |                     |
| application/vnd.airzip.filesecure.azs    | azs         |                     |
| application/vnd.amazon.ebook             | azw         |                     |
| application/vnd.americandynamics.acc     | acc         |                     |
| application/vnd.amiga.ami                | ami         |                     |
| application/vnd.android.package-archive  | apk         |                     |
| application/vnd.anser-web-certificate-issue-initiation | cii         |                     |
| application/vnd.anser-web-funds-transfer-initiation | fti         |                     |
| application/vnd.antix.game-component     | atx         |                     |
| application/vnd.apple.installer+xml      | mpkg        |                     |
| application/vnd.apple.mpegurl            | m3u8        |                     |
| application/vnd.aristanetworks.swi       | swi         |                     |
| application/vnd.astraea-software.iota    | iota        |                     |
| application/vnd.audiograph               | aep         |                     |
| application/vnd.blueice.multipass        | mpm         |                     |
| application/vnd.bmi                      | bmi         |                     |
| application/vnd.businessobjects          | rep         |                     |
| application/vnd.chemdraw+xml             | cdxml       |                     |
| application/vnd.chipnuts.karaoke-mmd     | mmd         |                     |
| application/vnd.cinderella               | cdy         |                     |
| application/vnd.claymore                 | cla         |                     |
| application/vnd.cloanto.rp9              | rp9         |                     |
| application/vnd.clonk.c4group            | c4u         | c4d, c4f, c4g, c4p  |
| application/vnd.cluetrust.cartomobile-config | c11amc      |                     |
| application/vnd.cluetrust.cartomobile-config-pkg | c11amz      |                     |
| application/vnd.commonspace              | csp         |                     |
| application/vnd.contact.cmsg             | cdbcmsg     |                     |
| application/vnd.cosmocaller              | cmc         |                     |
| application/vnd.crick.clicker            | clkx        |                     |
| application/vnd.crick.clicker.keyboard   | clkk        |                     |
| application/vnd.crick.clicker.palette    | clkp        |                     |
| application/vnd.crick.clicker.template   | clkt        |                     |
| application/vnd.crick.clicker.wordbank   | clkw        |                     |
| application/vnd.criticaltools.wbs+xml    | wbs         |                     |
| application/vnd.ctc-posml                | pml         |                     |
| application/vnd.cups-ppd                 | ppd         |                     |
| application/vnd.curl.car                 | car         |                     |
| application/vnd.curl.pcurl               | pcurl       |                     |
| application/vnd.data-vision.rdz          | rdz         |                     |
| application/vnd.dece.data                | uvvf        | uvd, uvf, uvvd      |
| application/vnd.dece.ttml+xml            | uvvt        | uvt                 |
| application/vnd.dece.unspecified         | uvx         | uvvx                |
| application/vnd.dece.zip                 | uvz         | uvvz                |
| application/vnd.denovo.fcselayout-link   | fe\_launch  |                     |
| application/vnd.dna                      | dna         |                     |
| application/vnd.dolby.mlp                | mlp         |                     |
| application/vnd.dpgraph                  | dpg         |                     |
| application/vnd.dreamfactory             | dfac        |                     |
| application/vnd.ds-keypoint              | kpxx        |                     |
| application/vnd.dvb.ait                  | ait         |                     |
| application/vnd.dvb.service              | svc         |                     |
| application/vnd.dynageo                  | geo         |                     |
| application/vnd.ecowin.chart             | mag         |                     |
| application/vnd.enliven                  | nml         |                     |
| application/vnd.epson.esf                | esf         |                     |
| application/vnd.epson.msf                | msf         |                     |
| application/vnd.epson.quickanime         | qam         |                     |
| application/vnd.epson.salt               | slt         |                     |
| application/vnd.epson.ssf                | ssf         |                     |
| application/vnd.eszigno3+xml             | et3         | es3                 |
| application/vnd.ezpix-album              | ez2         |                     |
| application/vnd.ezpix-package            | ez3         |                     |
| application/vnd.fdf                      | fdf         |                     |
| application/vnd.fdsn.mseed               | mseed       |                     |
| application/vnd.fdsn.seed                | seed        | dataless            |
| application/vnd.flographit               | gph         |                     |
| application/vnd.fluxtime.clip            | ftc         |                     |
| application/vnd.framemaker               | maker       | book, fm, frame     |
| application/vnd.frogans.fnc              | fnc         |                     |
| application/vnd.frogans.ltf              | ltf         |                     |
| application/vnd.fsc.weblaunch            | fsc         |                     |
| application/vnd.fujitsu.oasys            | oas         |                     |
| application/vnd.fujitsu.oasys2           | oa2         |                     |
| application/vnd.fujitsu.oasys3           | oa3         |                     |
| application/vnd.fujitsu.oasysgp          | fg5         |                     |
| application/vnd.fujitsu.oasysprs         | bh2         |                     |
| application/vnd.fujixerox.ddd            | ddd         |                     |
| application/vnd.fujixerox.docuworks      | xdw         |                     |
| application/vnd.fujixerox.docuworks.binder | xbd         |                     |
| application/vnd.fuzzysheet               | fzs         |                     |
| application/vnd.genomatix.tuxedo         | txd         |                     |
| application/vnd.geogebra.file            | ggb         |                     |
| application/vnd.geogebra.tool            | ggt         |                     |
| application/vnd.geometry-explorer        | gre         | gex                 |
| application/vnd.geonext                  | gxt         |                     |
| application/vnd.geoplan                  | g2w         |                     |
| application/vnd.geospace                 | g3w         |                     |
| application/vnd.gmx                      | gmx         |                     |
| application/vnd.google-earth.kml+xml     | kml         |                     |
| application/vnd.google-earth.kmz         | kmz         |                     |
| application/vnd.grafeq                   | gqs         | gqf                 |
| application/vnd.groove-account           | gac         |                     |
| application/vnd.groove-help              | ghf         |                     |
| application/vnd.groove-identity-message  | gim         |                     |
| application/vnd.groove-injector          | grv         |                     |
| application/vnd.groove-tool-message      | gtm         |                     |
| application/vnd.groove-tool-template     | tpl         |                     |
| application/vnd.groove-vcard             | vcg         |                     |
| application/vnd.hal+xml                  | hal         |                     |
| application/vnd.handheld-entertainment+xml | zmm         |                     |
| application/vnd.hbci                     | hbci        |                     |
| application/vnd.hhe.lesson-player        | les         |                     |
| application/vnd.hp-hpgl                  | hpgl        |                     |
| application/vnd.hp-hpid                  | hpid        |                     |
| application/vnd.hp-hps                   | hps         |                     |
| application/vnd.hp-jlyt                  | jlt         |                     |
| application/vnd.hp-pcl                   | pcl         |                     |
| application/vnd.hp-pclxl                 | pclxl       |                     |
| application/vnd.hydrostatix.sof-data     | sfd-hdstx   |                     |
| application/vnd.ibm.minipay              | mpy         |                     |
| application/vnd.ibm.modcap               | listafp     | afp, list3820       |
| application/vnd.ibm.rights-management    | irm         |                     |
| application/vnd.ibm.secure-container     | sc          |                     |
| application/vnd.iccprofile               | icm         | icc                 |
| application/vnd.igloader                 | igl         |                     |
| application/vnd.immervision-ivp          | ivp         |                     |
| application/vnd.immervision-ivu          | ivu         |                     |
| application/vnd.insors.igm               | igm         |                     |
| application/vnd.intercon.formnet         | xpx         | xpw                 |
| application/vnd.intergeo                 | i2g         |                     |
| application/vnd.intu.qbo                 | qbo         |                     |
| application/vnd.intu.qfx                 | qfx         |                     |
| application/vnd.ipunplugged.rcprofile    | rcprofile   |                     |
| application/vnd.irepository.package+xml  | irp         |                     |
| application/vnd.is-xpr                   | xpr         |                     |
| application/vnd.isac.fcs                 | fcs         |                     |
| application/vnd.jam                      | jam         |                     |
| application/vnd.jcp.javame.midlet-rms    | rms         |                     |
| application/vnd.jisp                     | jisp        |                     |
| application/vnd.joost.joda-archive       | joda        |                     |
| application/vnd.kahootz                  | ktz         | ktr                 |
| application/vnd.kde.karbon               | karbon      |                     |
| application/vnd.kde.kchart               | chrt        |                     |
| application/vnd.kde.kformula             | kfo         |                     |
| application/vnd.kde.kivio                | flw         |                     |
| application/vnd.kde.kontour              | kon         |                     |
| application/vnd.kde.kpresenter           | kpt         | kpr                 |
| application/vnd.kde.kspread              | ksp         |                     |
| application/vnd.kde.kword                | kwt         | kwd                 |
| application/vnd.kenameaapp               | htke        |                     |
| application/vnd.kidspiration             | kia         |                     |
| application/vnd.kinar                    | knp         | kne                 |
| application/vnd.koan                     | skt         | skd, skm, skp       |
| application/vnd.kodak-descriptor         | sse         |                     |
| application/vnd.las.las+xml              | lasxml      |                     |
| application/vnd.llamagraphics.life-balance.desktop | lbd         |                     |
| application/vnd.llamagraphics.life-balance.exchange+xml | lbe         |                     |
| application/vnd.lotus-1-2-3              | 123         |                     |
| application/vnd.lotus-approach           | apr         |                     |
| application/vnd.lotus-freelance          | pre         |                     |
| application/vnd.lotus-notes              | nsf         |                     |
| application/vnd.lotus-organizer          | org         |                     |
| application/vnd.lotus-screencam          | scm         |                     |
| application/vnd.lotus-wordpro            | lwp         |                     |
| application/vnd.macports.portpkg         | portpkg     |                     |
| application/vnd.mcd                      | mcd         |                     |
| application/vnd.medcalcdata              | mc1         |                     |
| application/vnd.mediastation.cdkey       | cdkey       |                     |
| application/vnd.mfer                     | mwf         |                     |
| application/vnd.mfmp                     | mfm         |                     |
| application/vnd.micrografx.flo           | flo         |                     |
| application/vnd.micrografx.igx           | igx         |                     |
| application/vnd.mif                      | mif         |                     |
| application/vnd.mobius.daf               | daf         |                     |
| application/vnd.mobius.dis               | dis         |                     |
| application/vnd.mobius.mbk               | mbk         |                     |
| application/vnd.mobius.mqy               | mqy         |                     |
| application/vnd.mobius.msl               | msl         |                     |
| application/vnd.mobius.plc               | plc         |                     |
| application/vnd.mobius.txf               | txf         |                     |
| application/vnd.mophun.application       | mpn         |                     |
| application/vnd.mophun.certificate       | mpc         |                     |
| application/vnd.mozilla.xul+xml          | xul         |                     |
| application/vnd.ms-artgalry              | cil         |                     |
| application/vnd.ms-cab-compressed        | cab         |                     |
| application/vnd.ms-excel                 | xls         | xla, xlc, xlm, xlt, xlw |
| application/vnd.ms-excel.addin.macroenabled.12 | xlam        |                     |
| application/vnd.ms-excel.sheet.binary.macroenabled.12 | xlsb        |                     |
| application/vnd.ms-excel.sheet.macroenabled.12 | xlsm        |                     |
| application/vnd.ms-excel.template.macroenabled.12 | xltm        |                     |
| application/vnd.ms-fontobject            | eot         |                     |
| application/vnd.ms-htmlhelp              | chm         |                     |
| application/vnd.ms-ims                   | ims         |                     |
| application/vnd.ms-lrm                   | lrm         |                     |
| application/vnd.ms-officetheme           | thmx        |                     |
| application/vnd.ms-pki.seccat            | cat         |                     |
| application/vnd.ms-pki.stl               | stl         |                     |
| application/vnd.ms-powerpoint            | ppt         | pot, pps            |
| application/vnd.ms-powerpoint.addin.macroenabled.12 | ppam        |                     |
| application/vnd.ms-powerpoint.presentation.macroenabled.12 | pptm        |                     |
| application/vnd.ms-powerpoint.slide.macroenabled.12 | sldm        |                     |
| application/vnd.ms-powerpoint.slideshow.macroenabled.12 | ppsm        |                     |
| application/vnd.ms-powerpoint.template.macroenabled.12 | potm        |                     |
| application/vnd.ms-project               | mpt         | mpp                 |
| application/vnd.ms-word.document.macroenabled.12 | docm        |                     |
| application/vnd.ms-word.template.macroenabled.12 | dotm        |                     |
| application/vnd.ms-works                 | wps         | wcm, wdb, wks       |
| application/vnd.ms-wpl                   | wpl         |                     |
| application/vnd.ms-xpsdocument           | xps         |                     |
| application/vnd.mseq                     | mseq        |                     |
| application/vnd.musician                 | mus         |                     |
| application/vnd.muvee.style              | msty        |                     |
| application/vnd.mynfc                    | taglet      |                     |
| application/vnd.neurolanguage.nlu        | nlu         |                     |
| application/vnd.nitf                     | ntf         | nitf                |
| application/vnd.noblenet-directory       | nnd         |                     |
| application/vnd.noblenet-sealer          | nns         |                     |
| application/vnd.noblenet-web             | nnw         |                     |
| application/vnd.nokia.n-gage.data        | ngdat       |                     |
| application/vnd.nokia.n-gage.symbian.install | n-gage      |                     |
| application/vnd.nokia.radio-preset       | rpst        |                     |
| application/vnd.nokia.radio-presets      | rpss        |                     |
| application/vnd.novadigm.edm             | edm         |                     |
| application/vnd.novadigm.edx             | edx         |                     |
| application/vnd.novadigm.ext             | ext         |                     |
| application/vnd.oasis.opendocument.chart | odc         |                     |
| application/vnd.oasis.opendocument.chart-template | otc         |                     |
| application/vnd.oasis.opendocument.database | odb         |                     |
| application/vnd.oasis.opendocument.formula | odf         |                     |
| application/vnd.oasis.opendocument.formula-template | odft        |                     |
| application/vnd.oasis.opendocument.graphics | odg         |                     |
| application/vnd.oasis.opendocument.graphics-template | otg         |                     |
| application/vnd.oasis.opendocument.image | odi         |                     |
| application/vnd.oasis.opendocument.image-template | oti         |                     |
| application/vnd.oasis.opendocument.presentation | odp         |                     |
| application/vnd.oasis.opendocument.presentation-template | otp         |                     |
| application/vnd.oasis.opendocument.spreadsheet | ods         |                     |
| application/vnd.oasis.opendocument.spreadsheet-template | ots         |                     |
| application/vnd.oasis.opendocument.text  | odt         |                     |
| application/vnd.oasis.opendocument.text-master | odm         |                     |
| application/vnd.oasis.opendocument.text-template | ott         |                     |
| application/vnd.oasis.opendocument.text-web | oth         |                     |
| application/vnd.olpc-sugar               | xo          |                     |
| application/vnd.oma.dd2+xml              | dd2         |                     |
| application/vnd.openofficeorg.extension  | oxt         |                     |
| application/vnd.openxmlformats-officedocument.presentationml.presentation | pptx        |                     |
| application/vnd.openxmlformats-officedocument.presentationml.slide | sldx        |                     |
| application/vnd.openxmlformats-officedocument.presentationml.slideshow | ppsx        |                     |
| application/vnd.openxmlformats-officedocument.presentationml.template | potx        |                     |
| application/vnd.openxmlformats-officedocument.spreadsheetml.sheet | xlsx        |                     |
| application/vnd.openxmlformats-officedocument.spreadsheetml.template | xltx        |                     |
| application/vnd.openxmlformats-officedocument.wordprocessingml.document | docx        |                     |
| application/vnd.openxmlformats-officedocument.wordprocessingml.template | dotx        |                     |
| application/vnd.osgeo.mapguide.package   | mgp         |                     |
| application/vnd.osgi.dp                  | dp          |                     |
| application/vnd.osgi.subsystem           | esa         |                     |
| application/vnd.palm                     | pqa         | oprc, pdb           |
| application/vnd.pawaafile                | paw         |                     |
| application/vnd.pg.format                | str         |                     |
| application/vnd.pg.osasli                | ei6         |                     |
| application/vnd.picsel                   | efif        |                     |
| application/vnd.pmi.widget               | wg          |                     |
| application/vnd.pocketlearn              | plf         |                     |
| application/vnd.powerbuilder6            | pbd         |                     |
| application/vnd.previewsystems.box       | box         |                     |
| application/vnd.proteus.magazine         | mgz         |                     |
| application/vnd.publishare-delta-tree    | qps         |                     |
| application/vnd.pvi.ptid1                | ptid        |                     |
| application/vnd.quark.quarkxpress        | qxt         | qwd, qwt, qxb, qxd, qxl |
| application/vnd.realvnc.bed              | bed         |                     |
| application/vnd.recordare.musicxml       | mxl         |                     |
| application/vnd.recordare.musicxml+xml   | musicxml    |                     |
| application/vnd.rig.cryptonote           | cryptonote  |                     |
| application/vnd.rim.cod                  | cod         |                     |
| application/vnd.rn-realmedia             | rm          |                     |
| application/vnd.rn-realmedia-vbr         | rmvb        |                     |
| application/vnd.route66.link66+xml       | link66      |                     |
| application/vnd.sailingtracker.track     | st          |                     |
| application/vnd.seemail                  | see         |                     |
| application/vnd.sema                     | sema        |                     |
| application/vnd.semd                     | semd        |                     |
| application/vnd.semf                     | semf        |                     |
| application/vnd.shana.informed.formdata  | ifm         |                     |
| application/vnd.shana.informed.formtemplate | itp         |                     |
| application/vnd.shana.informed.interchange | iif         |                     |
| application/vnd.shana.informed.package   | ipk         |                     |
| application/vnd.simtech-mindmapper       | twds        | twd                 |
| application/vnd.smaf                     | mmf         |                     |
| application/vnd.smart.teacher            | teacher     |                     |
| application/vnd.solent.sdkm+xml          | sdkm        | sdkd                |
| application/vnd.spotfire.dxp             | dxp         |                     |
| application/vnd.spotfire.sfs             | sfs         |                     |
| application/vnd.stardivision.calc        | sdc         |                     |
| application/vnd.stardivision.draw        | sda         |                     |
| application/vnd.stardivision.impress     | sdd         |                     |
| application/vnd.stardivision.math        | smf         |                     |
| application/vnd.stardivision.writer      | vor         | sdw                 |
| application/vnd.stardivision.writer-global | sgl         |                     |
| application/vnd.stepmania.package        | smzip       |                     |
| application/vnd.stepmania.stepchart      | sm          |                     |
| application/vnd.sun.xml.calc             | sxc         |                     |
| application/vnd.sun.xml.calc.template    | stc         |                     |
| application/vnd.sun.xml.draw             | sxd         |                     |
| application/vnd.sun.xml.draw.template    | std         |                     |
| application/vnd.sun.xml.impress          | sxi         |                     |
| application/vnd.sun.xml.impress.template | sti         |                     |
| application/vnd.sun.xml.math             | sxm         |                     |
| application/vnd.sun.xml.writer           | sxw         |                     |
| application/vnd.sun.xml.writer.global    | sxg         |                     |
| application/vnd.sun.xml.writer.template  | stw         |                     |
| application/vnd.sus-calendar             | susp        | sus                 |
| application/vnd.svd                      | svd         |                     |
| application/vnd.symbian.install          | sisx        | sis                 |
| application/vnd.syncml+xml               | xsm         |                     |
| application/vnd.syncml.dm+wbxml          | bdm         |                     |
| application/vnd.syncml.dm+xml            | xdm         |                     |
| application/vnd.tao.intent-module-archive | tao         |                     |
| application/vnd.tcpdump.pcap             | pcap        | cap, dmp            |
| application/vnd.tmobile-livetv           | tmo         |                     |
| application/vnd.trid.tpt                 | tpt         |                     |
| application/vnd.triscape.mxs             | mxs         |                     |
| application/vnd.trueapp                  | tra         |                     |
| application/vnd.ufdl                     | ufdl        | ufd                 |
| application/vnd.uiq.theme                | utz         |                     |
| application/vnd.umajin                   | umj         |                     |
| application/vnd.unity                    | unityweb    |                     |
| application/vnd.uoml+xml                 | uoml        |                     |
| application/vnd.vcx                      | vcx         |                     |
| application/vnd.visio                    | vsw         | vsd, vss, vst       |
| application/vnd.visionary                | vis         |                     |
| application/vnd.vsf                      | vsf         |                     |
| application/vnd.wap.wbxml                | wbxml       |                     |
| application/vnd.wap.wmlc                 | wmlc        |                     |
| application/vnd.wap.wmlscriptc           | wmlsc       |                     |
| application/vnd.webturbo                 | wtb         |                     |
| application/vnd.wolfram.player           | nbp         |                     |
| application/vnd.wordperfect              | wpd         |                     |
| application/vnd.wqd                      | wqd         |                     |
| application/vnd.wt.stf                   | stf         |                     |
| application/vnd.xara                     | xar         |                     |
| application/vnd.xfdl                     | xfdl        |                     |
| application/vnd.yamaha.hv-dic            | hvd         |                     |
| application/vnd.yamaha.hv-script         | hvs         |                     |
| application/vnd.yamaha.hv-voice          | hvp         |                     |
| application/vnd.yamaha.openscoreformat   | osf         |                     |
| application/vnd.yamaha.openscoreformat.osfpvg+xml | osfpvg      |                     |
| application/vnd.yamaha.smaf-audio        | saf         |                     |
| application/vnd.yamaha.smaf-phrase       | spf         |                     |
| application/vnd.yellowriver-custom-menu  | cmp         |                     |
| application/vnd.zul                      | zirz        | zir                 |
| application/vnd.zzazz.deck+xml           | zaz         |                     |
| application/voicexml+xml                 | vxml        |                     |
| application/wasm                         | wasm        |                     |
| application/widget                       | wgt         |                     |
| application/winhlp                       | hlp         |                     |
| application/wsdl+xml                     | wsdl        |                     |
| application/wspolicy+xml                 | wspolicy    |                     |
| application/x-7z-compressed              | 7z          |                     |
| application/x-abiword                    | abw         |                     |
| application/x-ace-compressed             | ace         |                     |
| application/x-apple-diskimage            | dmg         |                     |
| application/x-authorware-bin             | x32         | aab, u32, vox       |
| application/x-authorware-map             | aam         |                     |
| application/x-authorware-seg             | aas         |                     |
| application/x-bcpio                      | bcpio       |                     |
| application/x-bittorrent                 | torrent     |                     |
| application/x-blorb                      | blorb       | blb                 |
| application/x-bzip                       | bz          |                     |
| application/x-bzip2                      | bz2         | boz                 |
| application/x-cbr                        | cbz         | cb7, cba, cbr, cbt  |
| application/x-cdlink                     | vcd         |                     |
| application/x-cfs-compressed             | cfs         |                     |
| application/x-chat                       | chat        |                     |
| application/x-chess-pgn                  | pgn         |                     |
| application/x-conference                 | nsc         |                     |
| application/x-cpio                       | cpio        |                     |
| application/x-csh                        | csh         |                     |
| application/x-debian-package             | deb         | udeb                |
| application/x-dgc-compressed             | dgc         |                     |
| application/x-director                   | w3d         | cct, cst, cxt, dcr, dir, dxr, fgd, swa |
| application/x-doom                       | wad         |                     |
| application/x-dtbncx+xml                 | ncx         |                     |
| application/x-dtbook+xml                 | dtb         |                     |
| application/x-dtbresource+xml            | res         |                     |
| application/x-dvi                        | dvi         |                     |
| application/x-envoy                      | evy         |                     |
| application/x-eva                        | eva         |                     |
| application/x-font-bdf                   | bdf         |                     |
| application/x-font-ghostscript           | gsf         |                     |
| application/x-font-linux-psf             | psf         |                     |
| application/x-font-otf                   | otf         |                     |
| application/x-font-pcf                   | pcf         |                     |
| application/x-font-snf                   | snf         |                     |
| application/x-font-ttf                   | ttf         | ttc                 |
| application/x-font-type1                 | pfm         | afm, pfa, pfb       |
| application/x-font-woff                  | woff        |                     |
| application/x-freearc                    | arc         |                     |
| application/x-futuresplash               | spl         |                     |
| application/x-gca-compressed             | gca         |                     |
| application/x-glulx                      | ulx         |                     |
| application/x-gnumeric                   | gnumeric    |                     |
| application/x-gramps-xml                 | gramps      |                     |
| application/x-gtar                       | gtar        |                     |
| application/x-hdf                        | hdf         |                     |
| application/x-install-instructions       | install     |                     |
| application/x-iso9660-image              | iso         |                     |
| application/x-java-jnlp-file             | jnlp        |                     |
| application/x-latex                      | latex       |                     |
| application/x-lzh-compressed             | lzh         | lha                 |
| application/x-mie                        | mie         |                     |
| application/x-mobipocket-ebook           | prc         | mobi                |
| application/x-ms-application             | application |                     |
| application/x-ms-shortcut                | lnk         |                     |
| application/x-ms-wmd                     | wmd         |                     |
| application/x-ms-wmz                     | wmz         |                     |
| application/x-ms-xbap                    | xbap        |                     |
| application/x-msaccess                   | mdb         |                     |
| application/x-msbinder                   | obd         |                     |
| application/x-mscardfile                 | crd         |                     |
| application/x-msclip                     | clp         |                     |
| application/x-msdownload                 | msi         | bat, com, dll, exe  |
| application/x-msmediaview                | mvb         | m13, m14            |
| application/x-msmetafile                 | wmf         | emf, emz            |
| application/x-msmoney                    | mny         |                     |
| application/x-mspublisher                | pub         |                     |
| application/x-msschedule                 | scd         |                     |
| application/x-msterminal                 | trm         |                     |
| application/x-mswrite                    | wri         |                     |
| application/x-netcdf                     | nc          | cdf                 |
| application/x-nzb                        | nzb         |                     |
| application/x-pkcs12                     | pfx         | p12                 |
| application/x-pkcs7-certificates         | spc         | p7b                 |
| application/x-pkcs7-certreqresp          | p7r         |                     |
| application/x-rar-compressed             | rar         |                     |
| application/x-research-info-systems      | ris         |                     |
| application/x-sh                         | sh          |                     |
| application/x-shar                       | shar        |                     |
| application/x-shockwave-flash            | swf         |                     |
| application/x-silverlight-app            | xap         |                     |
| application/x-sql                        | sql         |                     |
| application/x-stuffit                    | sit         |                     |
| application/x-stuffitx                   | sitx        |                     |
| application/x-subrip                     | srt         |                     |
| application/x-sv4cpio                    | sv4cpio     |                     |
| application/x-sv4crc                     | sv4crc      |                     |
| application/x-t3vm-image                 | t3          |                     |
| application/x-tads                       | gam         |                     |
| application/x-tar                        | tar         |                     |
| application/x-tcl                        | tcl         |                     |
| application/x-tex                        | tex         |                     |
| application/x-tex-tfm                    | tfm         |                     |
| application/x-texinfo                    | texinfo     | texi                |
| application/x-tgif                       | obj         |                     |
| application/x-ustar                      | ustar       |                     |
| application/x-wais-source                | src         |                     |
| application/x-x509-ca-cert               | der         | crt                 |
| application/x-xfig                       | fig         |                     |
| application/x-xliff+xml                  | xlf         |                     |
| application/x-xpinstall                  | xpi         |                     |
| application/x-xz                         | xz          |                     |
| application/x-zmachine                   | z8          | z1, z2, z3, z4, z5, z6, z7 |
| application/xaml+xml                     | xaml        |                     |
| application/xcap-diff+xml                | xdf         |                     |
| application/xenc+xml                     | xenc        |                     |
| application/xhtml+xml                    | xhtml       | xht                 |
| application/xml                          | xml         | xsl                 |
| application/xml-dtd                      | dtd         |                     |
| application/xop+xml                      | xop         |                     |
| application/xproc+xml                    | xpl         |                     |
| application/xslt+xml                     | xslt        |                     |
| application/xspf+xml                     | xspf        |                     |
| application/xv+xml                       | xvml        | mxml, xhvml, xvm    |
| application/yang                         | yang        |                     |
| application/yin+xml                      | yin         |                     |
| application/zip                          | zip         |                     |
| audio/aac                                | aac         |                     |
| audio/adpcm                              | adp         |                     |
| audio/basic                              | snd         | au                  |
| audio/midi                               | mid         | kar, midi, rmi      |
| audio/mp4                                | m4a         | m4b, mp4a           |
| audio/mpeg                               | mpga        | m2a, m3a, mp2, mp2a, mp3 |
| audio/ogg                                | ogg         | oga, spx            |
| audio/s3m                                | s3m         |                     |
| audio/silk                               | sil         |                     |
| audio/vnd.dece.audio                     | uvva        | uva                 |
| audio/vnd.digital-winds                  | eol         |                     |
| audio/vnd.dra                            | dra         |                     |
| audio/vnd.dts                            | dts         |                     |
| audio/vnd.dts.hd                         | dtshd       |                     |
| audio/vnd.lucent.voice                   | lvp         |                     |
| audio/vnd.ms-playready.media.pya         | pya         |                     |
| audio/vnd.nuera.ecelp4800                | ecelp4800   |                     |
| audio/vnd.nuera.ecelp7470                | ecelp7470   |                     |
| audio/vnd.nuera.ecelp9600                | ecelp9600   |                     |
| audio/vnd.rip                            | rip         |                     |
| audio/webm                               | weba        |                     |
| audio/x-aiff                             | aif         | aifc, aiff          |
| audio/x-caf                              | caf         |                     |
| audio/x-flac                             | flac        |                     |
| audio/x-matroska                         | mka         |                     |
| audio/x-mpegurl                          | m3u         |                     |
| audio/x-ms-wax                           | wax         |                     |
| audio/x-ms-wma                           | wma         |                     |
| audio/x-pn-realaudio                     | ram         | ra                  |
| audio/x-pn-realaudio-plugin              | rmp         |                     |
| audio/x-wav                              | wav         |                     |
| audio/xm                                 | xm          |                     |
| chemical/x-cdx                           | cdx         |                     |
| chemical/x-cif                           | cif         |                     |
| chemical/x-cmdf                          | cmdf        |                     |
| chemical/x-cml                           | cml         |                     |
| chemical/x-csml                          | csml        |                     |
| chemical/x-xyz                           | xyz         |                     |
| font/woff2                               | woff2       |                     |
| image/avif                               | avif        |                     |
| image/bmp                                | bmp         |                     |
| image/cgm                                | cgm         |                     |
| image/g3fax                              | g3          |                     |
| image/gif                                | gif         |                     |
| image/heic                               | heic        |                     |
| image/heif                               | heif        |                     |
| image/ief                                | ief         |                     |
| image/jpeg                               | jpg         | jpe, jpeg           |
| image/ktx                                | ktx         |                     |
| image/png                                | png         |                     |
| image/prs.btif                           | btif        |                     |
| image/sgi                                | sgi         |                     |
| image/svg+xml                            | svg         | svgz                |
| image/tiff                               | tif         | tiff                |
| image/vnd.adobe.photoshop                | psd         |                     |
| image/vnd.dece.graphic                   | uvvi        | uvg, uvi, uvvg      |
| image/vnd.djvu                           | djvu        | djv                 |
| image/vnd.dwg                            | dwg         |                     |
| image/vnd.dxf                            | dxf         |                     |
| image/vnd.fastbidsheet                   | fbs         |                     |
| image/vnd.fpx                            | fpx         |                     |
| image/vnd.fst                            | fst         |                     |
| image/vnd.fujixerox.edmics-mmr           | mmr         |                     |
| image/vnd.fujixerox.edmics-rlc           | rlc         |                     |
| image/vnd.ms-modi                        | mdi         |                     |
| image/vnd.ms-photo                       | wdp         |                     |
| image/vnd.net-fpx                        | npx         |                     |
| image/vnd.wap.wbmp                       | wbmp        |                     |
| image/vnd.xiff                           | xif         |                     |
| image/webp                               | webp        |                     |
| image/x-3ds                              | 3ds         |                     |
| image/x-cmu-raster                       | ras         |                     |
| image/x-cmx                              | cmx         |                     |
| image/x-freehand                         | fhc         | fh, fh4, fh5, fh7   |
| image/x-icon                             | ico         |                     |
| image/x-mrsid-image                      | sid         |                     |
| image/x-pcx                              | pcx         |                     |
| image/x-pict                             | pic         | pct                 |
| image/x-portable-anymap                  | pnm         |                     |
| image/x-portable-bitmap                  | pbm         |                     |
| image/x-portable-graymap                 | pgm         |                     |
| image/x-portable-pixmap                  | ppm         |                     |
| image/x-rgb                              | rgb         |                     |
| image/x-tga                              | tga         |                     |
| image/x-xbitmap                          | xbm         |                     |
| image/x-xpixmap                          | xpm         |                     |
| image/x-xwindowdump                      | xwd         |                     |
| message/rfc822                           | mime        | eml                 |
| model/gltf+json                          | gltf        |                     |
| model/gltf-binary                        | glb         |                     |
| model/iges                               | igs         | iges                |
| model/mesh                               | silo        | mesh, msh           |
| model/vnd.collada+xml                    | dae         |                     |
| model/vnd.dwf                            | dwf         |                     |
| model/vnd.gdl                            | gdl         |                     |
| model/vnd.gtw                            | gtw         |                     |
| model/vnd.mts                            | mts         |                     |
| model/vnd.vtu                            | vtu         |                     |
| model/vrml                               | vrml        | wrl                 |
| model/x3d+binary                         | x3dbz       | x3db                |
| model/x3d+vrml                           | x3dvz       | x3dv                |
| model/x3d+xml                            | x3dz        | x3d                 |
| text/cache-manifest                      | appcache    |                     |
| text/calendar                            | ics         | ifb                 |
| text/css                                 | css         |                     |
| text/csv                                 | csv         |                     |
| text/html                                | html        | htm                 |
| text/javascript                          | js          | mjs                 |
| text/markdown                            | md          | markdown            |
| text/n3                                  | n3          |                     |
| text/plain                               | txt         | conf, def, in, list, log, text |
| text/prs.lines.tag                       | dsc         |                     |
| text/richtext                            | rtx         |                     |
| text/sgml                                | sgml        | sgm                 |
| text/tab-separated-values                | tsv         |                     |
| text/troff                               | tr          | man, me, ms, roff, t |
| text/turtle                              | ttl         |                     |
| text/uri-list                            | urls        | uri, uris           |
| text/vcard                               | vcard       |                     |
| text/vnd.curl                            | curl        |                     |
| text/vnd.curl.dcurl                      | dcurl       |                     |
| text/vnd.curl.mcurl                      | mcurl       |                     |
| text/vnd.curl.scurl                      | scurl       |                     |
| text/vnd.dvb.subtitle                    | sub         |                     |
| text/vnd.fly                             | fly         |                     |
| text/vnd.fmi.flexstor                    | flx         |                     |
| text/vnd.graphviz                        | gv          |                     |
| text/vnd.in3d.3dml                       | 3dml        |                     |
| text/vnd.in3d.spot                       | spot        |                     |
| text/vnd.sun.j2me.app-descriptor         | jad         |                     |
| text/vnd.wap.wml                         | wml         |                     |
| text/vnd.wap.wmlscript                   | wmls        |                     |
| text/x-asm                               | asm         | s                   |
| text/x-c                                 | c           | cc, cpp, cxx, dic, h, hh |
| text/x-dart                              | dart        |                     |
| text/x-fortran                           | for         | f, f77, f90         |
| text/x-java-source                       | java        |                     |
| text/x-nfo                               | nfo         |                     |
| text/x-opml                              | opml        |                     |
| text/x-pascal                            | pas         | p                   |
| text/x-setext                            | etx         |                     |
| text/x-sfv                               | sfv         |                     |
| text/x-uuencode                          | uu          |                     |
| text/x-vcalendar                         | vcs         |                     |
| text/x-vcard                             | vcf         |                     |
| video/3gpp                               | 3gp         |                     |
| video/3gpp2                              | 3g2         |                     |
| video/h261                               | h261        |                     |
| video/h263                               | h263        |                     |
| video/h264                               | h264        |                     |
| video/jpeg                               | jpgv        |                     |
| video/jpm                                | jpm         | jpgm                |
| video/mj2                                | mjp2        | mj2                 |
| video/mp4                                | mp4         | mp4v, mpg4          |
| video/mpeg                               | mpg         | m1v, m2v, mpe, mpeg |
| video/ogg                                | ogv         |                     |
| video/quicktime                          | mov         | qt                  |
| video/vnd.dece.hd                        | uvvh        | uvh                 |
| video/vnd.dece.mobile                    | uvvm        | uvm                 |
| video/vnd.dece.pd                        | uvvp        | uvp                 |
| video/vnd.dece.sd                        | uvvs        | uvs                 |
| video/vnd.dece.video                     | uvvv        | uvv                 |
| video/vnd.dvb.file                       | dvb         |                     |
| video/vnd.fvt                            | fvt         |                     |
| video/vnd.mpegurl                        | mxu         | m4u                 |
| video/vnd.ms-playready.media.pyv         | pyv         |                     |
| video/vnd.uvvu.mp4                       | uvvu        | uvu                 |
| video/vnd.vivo                           | viv         |                     |
| video/webm                               | webm        |                     |
| video/x-f4v                              | f4v         |                     |
| video/x-fli                              | fli         |                     |
| video/x-flv                              | flv         |                     |
| video/x-m4v                              | m4v         |                     |
| video/x-matroska                         | mkv         | mk3d, mks           |
| video/x-mng                              | mng         |                     |
| video/x-ms-asf                           | asx         | asf                 |
| video/x-ms-vob                           | vob         |                     |
| video/x-ms-wm                            | wm          |                     |
| video/x-ms-wmv                           | wmv         |                     |
| video/x-ms-wmx                           | wmx         |                     |
| video/x-ms-wvx                           | wvx         |                     |
| video/x-msvideo                          | avi         |                     |
| video/x-sgi-movie                        | movie       |                     |
| video/x-smv                              | smv         |                     |
| x-conference/x-cooltalk                  | ice         |                     |

<!-- end table -->
