// Copyright (c) 2013, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:convert';

import 'package:pub/src/exit_codes.dart' as exit_codes;
import 'package:shelf/shelf.dart' as shelf;
import 'package:test/test.dart';

import '../descriptor.dart' as d;
import '../test_pub.dart';
import 'utils.dart';

void main() {
  test('--force publishes if there are warnings', () async {
    await d.validPackage().create();
    final pkg = packageMap('test_pkg', '1.0.0', null, null, {
      'sdk': defaultSdkConstraint,
    });
    pkg['dependencies'] = {'foo': 'any'};
    await d.dir(appPath, [d.pubspec(pkg)]).create();

    (await servePackages()).serve('foo', '1.0.0');

    await d.credentialsFile(globalServer, 'access-token').create();
    final pub = await startPublish(globalServer, args: ['--force']);

    handleUploadForm(globalServer);
    handleUpload(globalServer);

    globalServer.expect('GET', '/create', (request) {
      return shelf.Response.ok(
        jsonEncode({
          'success': {'message': 'Package test_pkg 1.0.0 uploaded!'},
        }),
      );
    });

    await pub.shouldExit(exit_codes.SUCCESS);
    final stdoutLines = await pub.stdout.rest.toList();
    expect(
      stdoutLines,
      allOf([
        contains('Package validation found the following potential issue:'),
        contains(
          '* Your dependency on "foo" should have a version constraint. '
          'For example:',
        ),
        contains('Message from server: Package test_pkg 1.0.0 uploaded!'),
      ]),
    );
  });
}
