// Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:path/path.dart' as p;
import 'package:pub/src/io.dart';
import 'package:test/test.dart';

import '../../descriptor.dart' as d;
import '../../test_pub.dart';

void main() {
  test('activating a path package deactivates the hosted one', () async {
    final server = await servePackages();
    server.serve(
      'foo',
      '1.0.0',
      contents: [
        d.dir('bin', [d.file('foo.dart', "main(args) => print('hosted');")]),
      ],
    );

    await d.dir('foo', [
      d.libPubspec('foo', '2.0.0'),
      d.dir('bin', [d.file('foo.dart', "main() => print('path');")]),
    ]).create();

    await runPub(args: ['global', 'activate', 'foo']);

    final path = canonicalize(p.join(d.sandbox, 'foo'));
    await runPub(
      args: ['global', 'activate', '-spath', '../foo'],
      output: allOf([
        contains('Package foo is currently active at version 1.0.0.'),
        contains('Activated foo 2.0.0 at path "$path".'),
      ]),
    );

    // Should now run the path one.
    final pub = await pubRun(global: true, args: ['foo']);
    expect(pub.stdout, emitsThrough('path'));
    await pub.shouldExit();
  });
}
