// Copyright (c) 2025, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:io';

import 'package:jnigen/jnigen.dart';
import 'package:path/path.dart';
import 'package:test/test.dart';

void main() {
  test('Warn if non-jnigen-generated files exist in directory', () async {
    final root = await Directory.current.createTemp();
    final nonGenerated =
        await File.fromUri(root.uri.resolve('non_gen.dart')).create();
    await nonGenerated.writeAsString('void main() {}');
    final generated = await File.fromUri(root.uri.resolve('gen.dart')).create();
    await generated
        .writeAsString('// AUTO GENERATED BY JNIGEN 1.2.3. DO NOT EDIT!\n');
    final sourcePath =
        join(Directory.current.path, 'test', 'simple_package_test', 'java');
    print(sourcePath);
    await expectLater(
      () => generateJniBindings(
        Config(
          outputConfig: OutputConfig(
              dartConfig: DartCodeOutputConfig(
                  path: root.uri, structure: OutputStructure.packageStructure)),
          classes: ['com.github.dart_lang.jnigen.simple_package'],
          sourcePath: [Uri.directory(sourcePath)],
        ),
      ),
      throwsA(allOf([
        isA<StateError>(),
        predicate(
            (error) => error.toString().contains('not generated by JNIgen')),
        predicate((error) => error.toString().contains('non_gen.dart')),
      ])),
    );
    await root.delete(recursive: true);
  });
}
