// Copyright (c) 2024, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

@OnPlatform({'mac-os': Timeout.factor(2), 'windows': Timeout.factor(10)})
library;

import 'package:test/test.dart';

import '../build_runner/helpers.dart';
import '../helpers.dart';

void main() async {
  const name = 'reuse_dynamic_library';

  test(
    '$name build',
    () => inTempDir((tempUri) async {
      await copyTestProjects(targetUri: tempUri);
      final packageUri = tempUri.resolve('$name/');

      await runPubGet(workingDirectory: packageUri, logger: logger);

      final logMessages = <String>[];
      final result = (await build(
        packageUri,
        logger,
        dartExecutable,
        capturedLogs: logMessages,
        buildAssetTypes: [BuildAssetType.code],
      )).success;

      expect(result.encodedAssets.length, 2);
    }),
  );
}
