// Part of the LLVM Project, under the Apache License v2.0 with LLVM
// Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

// ignore_for_file: camel_case_types, non_constant_identifier_names

// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'custom_import.dart' as custom_import;
import 'dart:ffi' as ffi;

/// Holds bindings to LibClang.
class LibClang {
  /// Holds the symbol lookup function.
  final ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
  _lookup;

  /// The symbols are looked up in [dynamicLibrary].
  LibClang(ffi.DynamicLibrary dynamicLibrary) : _lookup = dynamicLibrary.lookup;

  /// The symbols are looked up with [lookup].
  LibClang.fromLookup(
    ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName) lookup,
  ) : _lookup = lookup;

  /// Retrieve the character data associated with the given string.
  ffi.Pointer<ffi.Char> clang_getCString(CXString string) {
    return _clang_getCString(string);
  }

  late final _clang_getCStringPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCString>>('clang_getCString');
  late final _clang_getCString = _clang_getCStringPtr
      .asFunction<DartClang_getCString>();

  /// Free the given string.
  void clang_disposeString(CXString string) {
    return _clang_disposeString(string);
  }

  late final _clang_disposeStringPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeString>>(
        'clang_disposeString',
      );
  late final _clang_disposeString = _clang_disposeStringPtr
      .asFunction<DartClang_disposeString>();

  /// Free the given string set.
  void clang_disposeStringSet(ffi.Pointer<CXStringSet> set$) {
    return _clang_disposeStringSet(set$);
  }

  late final _clang_disposeStringSetPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeStringSet>>(
        'clang_disposeStringSet',
      );
  late final _clang_disposeStringSet = _clang_disposeStringSetPtr
      .asFunction<DartClang_disposeStringSet>();

  /// Provides a shared context for creating translation units.
  ///
  /// It provides two options:
  ///
  /// - excludeDeclarationsFromPCH: When non-zero, allows enumeration of "local"
  /// declarations (when loading any new translation units). A "local" declaration
  /// is one that belongs in the translation unit itself and not in a precompiled
  /// header that was used by the translation unit. If zero, all declarations
  /// will be enumerated.
  ///
  /// Here is an example:
  ///
  /// \code
  /// // excludeDeclsFromPCH = 1, displayDiagnostics=1
  /// Idx = clang_createIndex(1, 1);
  ///
  /// // IndexTest.pch was produced with the following command:
  /// // "clang -x c IndexTest.h -emit-ast -o IndexTest.pch"
  /// TU = clang_createTranslationUnit(Idx, "IndexTest.pch");
  ///
  /// // This will load all the symbols from 'IndexTest.pch'
  /// clang_visitChildren(clang_getTranslationUnitCursor(TU),
  /// TranslationUnitVisitor, 0);
  /// clang_disposeTranslationUnit(TU);
  ///
  /// // This will load all the symbols from 'IndexTest.c', excluding symbols
  /// // from 'IndexTest.pch'.
  /// char *args[] = { "-Xclang", "-include-pch=IndexTest.pch" };
  /// TU = clang_createTranslationUnitFromSourceFile(Idx, "IndexTest.c", 2, args,
  /// 0, 0);
  /// clang_visitChildren(clang_getTranslationUnitCursor(TU),
  /// TranslationUnitVisitor, 0);
  /// clang_disposeTranslationUnit(TU);
  /// \endcode
  ///
  /// This process of creating the 'pch', loading it separately, and using it (via
  /// -include-pch) allows 'excludeDeclsFromPCH' to remove redundant callbacks
  /// (which gives the indexer the same performance benefit as the compiler).
  CXIndex clang_createIndex(
    int excludeDeclarationsFromPCH,
    int displayDiagnostics,
  ) {
    return _clang_createIndex(excludeDeclarationsFromPCH, displayDiagnostics);
  }

  late final _clang_createIndexPtr =
      _lookup<ffi.NativeFunction<NativeClang_createIndex>>('clang_createIndex');
  late final _clang_createIndex = _clang_createIndexPtr
      .asFunction<DartClang_createIndex>();

  /// Destroy the given index.
  ///
  /// The index must not be destroyed until all of the translation units created
  /// within that index have been destroyed.
  void clang_disposeIndex(CXIndex index) {
    return _clang_disposeIndex(index);
  }

  late final _clang_disposeIndexPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeIndex>>(
        'clang_disposeIndex',
      );
  late final _clang_disposeIndex = _clang_disposeIndexPtr
      .asFunction<DartClang_disposeIndex>();

  /// Sets general options associated with a CXIndex.
  ///
  /// For example:
  /// \code
  /// CXIndex idx = ...;
  /// clang_CXIndex_setGlobalOptions(idx,
  /// clang_CXIndex_getGlobalOptions(idx) |
  /// CXGlobalOpt_ThreadBackgroundPriorityForIndexing);
  /// \endcode
  ///
  /// \param options A bitmask of options, a bitwise OR of CXGlobalOpt_XXX flags.
  void clang_CXIndex_setGlobalOptions(CXIndex arg0, int options) {
    return _clang_CXIndex_setGlobalOptions(arg0, options);
  }

  late final _clang_CXIndex_setGlobalOptionsPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXIndex_setGlobalOptions>>(
        'clang_CXIndex_setGlobalOptions',
      );
  late final _clang_CXIndex_setGlobalOptions =
      _clang_CXIndex_setGlobalOptionsPtr
          .asFunction<DartClang_CXIndex_setGlobalOptions>();

  /// Gets the general options associated with a CXIndex.
  ///
  /// \returns A bitmask of options, a bitwise OR of CXGlobalOpt_XXX flags that
  /// are associated with the given CXIndex object.
  int clang_CXIndex_getGlobalOptions(CXIndex arg0) {
    return _clang_CXIndex_getGlobalOptions(arg0);
  }

  late final _clang_CXIndex_getGlobalOptionsPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXIndex_getGlobalOptions>>(
        'clang_CXIndex_getGlobalOptions',
      );
  late final _clang_CXIndex_getGlobalOptions =
      _clang_CXIndex_getGlobalOptionsPtr
          .asFunction<DartClang_CXIndex_getGlobalOptions>();

  /// Sets the invocation emission path option in a CXIndex.
  ///
  /// The invocation emission path specifies a path which will contain log
  /// files for certain libclang invocations. A null value (default) implies that
  /// libclang invocations are not logged..
  void clang_CXIndex_setInvocationEmissionPathOption(
    CXIndex arg0,
    ffi.Pointer<ffi.Char> Path,
  ) {
    return _clang_CXIndex_setInvocationEmissionPathOption(arg0, Path);
  }

  late final _clang_CXIndex_setInvocationEmissionPathOptionPtr =
      _lookup<
        ffi.NativeFunction<NativeClang_CXIndex_setInvocationEmissionPathOption>
      >('clang_CXIndex_setInvocationEmissionPathOption');
  late final _clang_CXIndex_setInvocationEmissionPathOption =
      _clang_CXIndex_setInvocationEmissionPathOptionPtr
          .asFunction<DartClang_CXIndex_setInvocationEmissionPathOption>();

  /// Retrieve the complete file and path name of the given file.
  CXString clang_getFileName(CXFile SFile) {
    return _clang_getFileName(SFile);
  }

  late final _clang_getFileNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_getFileName>>('clang_getFileName');
  late final _clang_getFileName = _clang_getFileNamePtr
      .asFunction<DartClang_getFileName>();

  /// Retrieve the last modification time of the given file.
  int clang_getFileTime(CXFile SFile) {
    return _clang_getFileTime(SFile);
  }

  late final _clang_getFileTimePtr =
      _lookup<ffi.NativeFunction<NativeClang_getFileTime>>('clang_getFileTime');
  late final _clang_getFileTime = _clang_getFileTimePtr
      .asFunction<DartClang_getFileTime>();

  /// Retrieve the unique ID for the given \c file.
  ///
  /// \param file the file to get the ID for.
  /// \param outID stores the returned CXFileUniqueID.
  /// \returns If there was a failure getting the unique ID, returns non-zero,
  /// otherwise returns 0.
  int clang_getFileUniqueID(CXFile file, ffi.Pointer<CXFileUniqueID> outID) {
    return _clang_getFileUniqueID(file, outID);
  }

  late final _clang_getFileUniqueIDPtr =
      _lookup<ffi.NativeFunction<NativeClang_getFileUniqueID>>(
        'clang_getFileUniqueID',
      );
  late final _clang_getFileUniqueID = _clang_getFileUniqueIDPtr
      .asFunction<DartClang_getFileUniqueID>();

  /// Determine whether the given header is guarded against
  /// multiple inclusions, either with the conventional
  /// \#ifndef/\#define/\#endif macro guards or with \#pragma once.
  int clang_isFileMultipleIncludeGuarded(CXTranslationUnit tu, CXFile file) {
    return _clang_isFileMultipleIncludeGuarded(tu, file);
  }

  late final _clang_isFileMultipleIncludeGuardedPtr =
      _lookup<ffi.NativeFunction<NativeClang_isFileMultipleIncludeGuarded>>(
        'clang_isFileMultipleIncludeGuarded',
      );
  late final _clang_isFileMultipleIncludeGuarded =
      _clang_isFileMultipleIncludeGuardedPtr
          .asFunction<DartClang_isFileMultipleIncludeGuarded>();

  /// Retrieve a file handle within the given translation unit.
  ///
  /// \param tu the translation unit
  ///
  /// \param file_name the name of the file.
  ///
  /// \returns the file handle for the named file in the translation unit \p tu,
  /// or a NULL file handle if the file was not a part of this translation unit.
  CXFile clang_getFile(CXTranslationUnit tu, ffi.Pointer<ffi.Char> file_name) {
    return _clang_getFile(tu, file_name);
  }

  late final _clang_getFilePtr =
      _lookup<ffi.NativeFunction<NativeClang_getFile>>('clang_getFile');
  late final _clang_getFile = _clang_getFilePtr.asFunction<DartClang_getFile>();

  /// Retrieve the buffer associated with the given file.
  ///
  /// \param tu the translation unit
  ///
  /// \param file the file for which to retrieve the buffer.
  ///
  /// \param size [out] if non-NULL, will be set to the size of the buffer.
  ///
  /// \returns a pointer to the buffer in memory that holds the contents of
  /// \p file, or a NULL pointer when the file is not loaded.
  ffi.Pointer<ffi.Char> clang_getFileContents(
    CXTranslationUnit tu,
    CXFile file,
    ffi.Pointer<ffi.Size> size,
  ) {
    return _clang_getFileContents(tu, file, size);
  }

  late final _clang_getFileContentsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getFileContents>>(
        'clang_getFileContents',
      );
  late final _clang_getFileContents = _clang_getFileContentsPtr
      .asFunction<DartClang_getFileContents>();

  /// Returns non-zero if the \c file1 and \c file2 point to the same file,
  /// or they are both NULL.
  int clang_File_isEqual(CXFile file1, CXFile file2) {
    return _clang_File_isEqual(file1, file2);
  }

  late final _clang_File_isEqualPtr =
      _lookup<ffi.NativeFunction<NativeClang_File_isEqual>>(
        'clang_File_isEqual',
      );
  late final _clang_File_isEqual = _clang_File_isEqualPtr
      .asFunction<DartClang_File_isEqual>();

  /// Returns the real path name of \c file.
  ///
  /// An empty string may be returned. Use \c clang_getFileName() in that case.
  CXString clang_File_tryGetRealPathName(CXFile file) {
    return _clang_File_tryGetRealPathName(file);
  }

  late final _clang_File_tryGetRealPathNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_File_tryGetRealPathName>>(
        'clang_File_tryGetRealPathName',
      );
  late final _clang_File_tryGetRealPathName = _clang_File_tryGetRealPathNamePtr
      .asFunction<DartClang_File_tryGetRealPathName>();

  /// Retrieve a NULL (invalid) source location.
  CXSourceLocation clang_getNullLocation() {
    return _clang_getNullLocation();
  }

  late final _clang_getNullLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getNullLocation>>(
        'clang_getNullLocation',
      );
  late final _clang_getNullLocation = _clang_getNullLocationPtr
      .asFunction<DartClang_getNullLocation>();

  /// Determine whether two source locations, which must refer into
  /// the same translation unit, refer to exactly the same point in the source
  /// code.
  ///
  /// \returns non-zero if the source locations refer to the same location, zero
  /// if they refer to different locations.
  int clang_equalLocations(CXSourceLocation loc1, CXSourceLocation loc2) {
    return _clang_equalLocations(loc1, loc2);
  }

  late final _clang_equalLocationsPtr =
      _lookup<ffi.NativeFunction<NativeClang_equalLocations>>(
        'clang_equalLocations',
      );
  late final _clang_equalLocations = _clang_equalLocationsPtr
      .asFunction<DartClang_equalLocations>();

  /// Retrieves the source location associated with a given file/line/column
  /// in a particular translation unit.
  CXSourceLocation clang_getLocation(
    CXTranslationUnit tu,
    CXFile file,
    int line,
    int column,
  ) {
    return _clang_getLocation(tu, file, line, column);
  }

  late final _clang_getLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getLocation>>('clang_getLocation');
  late final _clang_getLocation = _clang_getLocationPtr
      .asFunction<DartClang_getLocation>();

  /// Retrieves the source location associated with a given character offset
  /// in a particular translation unit.
  CXSourceLocation clang_getLocationForOffset(
    CXTranslationUnit tu,
    CXFile file,
    int offset,
  ) {
    return _clang_getLocationForOffset(tu, file, offset);
  }

  late final _clang_getLocationForOffsetPtr =
      _lookup<ffi.NativeFunction<NativeClang_getLocationForOffset>>(
        'clang_getLocationForOffset',
      );
  late final _clang_getLocationForOffset = _clang_getLocationForOffsetPtr
      .asFunction<DartClang_getLocationForOffset>();

  /// Returns non-zero if the given source location is in a system header.
  int clang_Location_isInSystemHeader(CXSourceLocation location) {
    return _clang_Location_isInSystemHeader(location);
  }

  late final _clang_Location_isInSystemHeaderPtr =
      _lookup<ffi.NativeFunction<NativeClang_Location_isInSystemHeader>>(
        'clang_Location_isInSystemHeader',
      );
  late final _clang_Location_isInSystemHeader =
      _clang_Location_isInSystemHeaderPtr
          .asFunction<DartClang_Location_isInSystemHeader>();

  /// Returns non-zero if the given source location is in the main file of
  /// the corresponding translation unit.
  int clang_Location_isFromMainFile(CXSourceLocation location) {
    return _clang_Location_isFromMainFile(location);
  }

  late final _clang_Location_isFromMainFilePtr =
      _lookup<ffi.NativeFunction<NativeClang_Location_isFromMainFile>>(
        'clang_Location_isFromMainFile',
      );
  late final _clang_Location_isFromMainFile = _clang_Location_isFromMainFilePtr
      .asFunction<DartClang_Location_isFromMainFile>();

  /// Retrieve a NULL (invalid) source range.
  CXSourceRange clang_getNullRange() {
    return _clang_getNullRange();
  }

  late final _clang_getNullRangePtr =
      _lookup<ffi.NativeFunction<NativeClang_getNullRange>>(
        'clang_getNullRange',
      );
  late final _clang_getNullRange = _clang_getNullRangePtr
      .asFunction<DartClang_getNullRange>();

  /// Retrieve a source range given the beginning and ending source
  /// locations.
  CXSourceRange clang_getRange(CXSourceLocation begin, CXSourceLocation end) {
    return _clang_getRange(begin, end);
  }

  late final _clang_getRangePtr =
      _lookup<ffi.NativeFunction<NativeClang_getRange>>('clang_getRange');
  late final _clang_getRange = _clang_getRangePtr
      .asFunction<DartClang_getRange>();

  /// Determine whether two ranges are equivalent.
  ///
  /// \returns non-zero if the ranges are the same, zero if they differ.
  int clang_equalRanges(CXSourceRange range1, CXSourceRange range2) {
    return _clang_equalRanges(range1, range2);
  }

  late final _clang_equalRangesPtr =
      _lookup<ffi.NativeFunction<NativeClang_equalRanges>>('clang_equalRanges');
  late final _clang_equalRanges = _clang_equalRangesPtr
      .asFunction<DartClang_equalRanges>();

  /// Returns non-zero if \p range is null.
  int clang_Range_isNull(CXSourceRange range) {
    return _clang_Range_isNull(range);
  }

  late final _clang_Range_isNullPtr =
      _lookup<ffi.NativeFunction<NativeClang_Range_isNull>>(
        'clang_Range_isNull',
      );
  late final _clang_Range_isNull = _clang_Range_isNullPtr
      .asFunction<DartClang_Range_isNull>();

  /// Retrieve the file, line, column, and offset represented by
  /// the given source location.
  ///
  /// If the location refers into a macro expansion, retrieves the
  /// location of the macro expansion.
  ///
  /// \param location the location within a source file that will be decomposed
  /// into its parts.
  ///
  /// \param file [out] if non-NULL, will be set to the file to which the given
  /// source location points.
  ///
  /// \param line [out] if non-NULL, will be set to the line to which the given
  /// source location points.
  ///
  /// \param column [out] if non-NULL, will be set to the column to which the given
  /// source location points.
  ///
  /// \param offset [out] if non-NULL, will be set to the offset into the
  /// buffer to which the given source location points.
  void clang_getExpansionLocation(
    CXSourceLocation location,
    ffi.Pointer<CXFile> file,
    ffi.Pointer<ffi.UnsignedInt> line,
    ffi.Pointer<ffi.UnsignedInt> column,
    ffi.Pointer<ffi.UnsignedInt> offset,
  ) {
    return _clang_getExpansionLocation(location, file, line, column, offset);
  }

  late final _clang_getExpansionLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getExpansionLocation>>(
        'clang_getExpansionLocation',
      );
  late final _clang_getExpansionLocation = _clang_getExpansionLocationPtr
      .asFunction<DartClang_getExpansionLocation>();

  /// Retrieve the file, line and column represented by the given source
  /// location, as specified in a # line directive.
  ///
  /// Example: given the following source code in a file somefile.c
  ///
  /// \code
  /// #123 "dummy.c" 1
  ///
  /// static int func(void)
  /// {
  /// return 0;
  /// }
  /// \endcode
  ///
  /// the location information returned by this function would be
  ///
  /// File: dummy.c Line: 124 Column: 12
  ///
  /// whereas clang_getExpansionLocation would have returned
  ///
  /// File: somefile.c Line: 3 Column: 12
  ///
  /// \param location the location within a source file that will be decomposed
  /// into its parts.
  ///
  /// \param filename [out] if non-NULL, will be set to the filename of the
  /// source location. Note that filenames returned will be for "virtual" files,
  /// which don't necessarily exist on the machine running clang - e.g. when
  /// parsing preprocessed output obtained from a different environment. If
  /// a non-NULL value is passed in, remember to dispose of the returned value
  /// using \c clang_disposeString() once you've finished with it. For an invalid
  /// source location, an empty string is returned.
  ///
  /// \param line [out] if non-NULL, will be set to the line number of the
  /// source location. For an invalid source location, zero is returned.
  ///
  /// \param column [out] if non-NULL, will be set to the column number of the
  /// source location. For an invalid source location, zero is returned.
  void clang_getPresumedLocation(
    CXSourceLocation location,
    ffi.Pointer<CXString> filename,
    ffi.Pointer<ffi.UnsignedInt> line,
    ffi.Pointer<ffi.UnsignedInt> column,
  ) {
    return _clang_getPresumedLocation(location, filename, line, column);
  }

  late final _clang_getPresumedLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getPresumedLocation>>(
        'clang_getPresumedLocation',
      );
  late final _clang_getPresumedLocation = _clang_getPresumedLocationPtr
      .asFunction<DartClang_getPresumedLocation>();

  /// Legacy API to retrieve the file, line, column, and offset represented
  /// by the given source location.
  ///
  /// This interface has been replaced by the newer interface
  /// #clang_getExpansionLocation(). See that interface's documentation for
  /// details.
  void clang_getInstantiationLocation(
    CXSourceLocation location,
    ffi.Pointer<CXFile> file,
    ffi.Pointer<ffi.UnsignedInt> line,
    ffi.Pointer<ffi.UnsignedInt> column,
    ffi.Pointer<ffi.UnsignedInt> offset,
  ) {
    return _clang_getInstantiationLocation(
      location,
      file,
      line,
      column,
      offset,
    );
  }

  late final _clang_getInstantiationLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getInstantiationLocation>>(
        'clang_getInstantiationLocation',
      );
  late final _clang_getInstantiationLocation =
      _clang_getInstantiationLocationPtr
          .asFunction<DartClang_getInstantiationLocation>();

  /// Retrieve the file, line, column, and offset represented by
  /// the given source location.
  ///
  /// If the location refers into a macro instantiation, return where the
  /// location was originally spelled in the source file.
  ///
  /// \param location the location within a source file that will be decomposed
  /// into its parts.
  ///
  /// \param file [out] if non-NULL, will be set to the file to which the given
  /// source location points.
  ///
  /// \param line [out] if non-NULL, will be set to the line to which the given
  /// source location points.
  ///
  /// \param column [out] if non-NULL, will be set to the column to which the given
  /// source location points.
  ///
  /// \param offset [out] if non-NULL, will be set to the offset into the
  /// buffer to which the given source location points.
  void clang_getSpellingLocation(
    CXSourceLocation location,
    ffi.Pointer<CXFile> file,
    ffi.Pointer<ffi.UnsignedInt> line,
    ffi.Pointer<ffi.UnsignedInt> column,
    ffi.Pointer<ffi.UnsignedInt> offset,
  ) {
    return _clang_getSpellingLocation(location, file, line, column, offset);
  }

  late final _clang_getSpellingLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getSpellingLocation>>(
        'clang_getSpellingLocation',
      );
  late final _clang_getSpellingLocation = _clang_getSpellingLocationPtr
      .asFunction<DartClang_getSpellingLocation>();

  /// Retrieve the file, line, column, and offset represented by
  /// the given source location.
  ///
  /// If the location refers into a macro expansion, return where the macro was
  /// expanded or where the macro argument was written, if the location points at
  /// a macro argument.
  ///
  /// \param location the location within a source file that will be decomposed
  /// into its parts.
  ///
  /// \param file [out] if non-NULL, will be set to the file to which the given
  /// source location points.
  ///
  /// \param line [out] if non-NULL, will be set to the line to which the given
  /// source location points.
  ///
  /// \param column [out] if non-NULL, will be set to the column to which the given
  /// source location points.
  ///
  /// \param offset [out] if non-NULL, will be set to the offset into the
  /// buffer to which the given source location points.
  void clang_getFileLocation(
    CXSourceLocation location,
    ffi.Pointer<CXFile> file,
    ffi.Pointer<ffi.UnsignedInt> line,
    ffi.Pointer<ffi.UnsignedInt> column,
    ffi.Pointer<ffi.UnsignedInt> offset,
  ) {
    return _clang_getFileLocation(location, file, line, column, offset);
  }

  late final _clang_getFileLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getFileLocation>>(
        'clang_getFileLocation',
      );
  late final _clang_getFileLocation = _clang_getFileLocationPtr
      .asFunction<DartClang_getFileLocation>();

  /// Retrieve a source location representing the first character within a
  /// source range.
  CXSourceLocation clang_getRangeStart(CXSourceRange range) {
    return _clang_getRangeStart(range);
  }

  late final _clang_getRangeStartPtr =
      _lookup<ffi.NativeFunction<NativeClang_getRangeStart>>(
        'clang_getRangeStart',
      );
  late final _clang_getRangeStart = _clang_getRangeStartPtr
      .asFunction<DartClang_getRangeStart>();

  /// Retrieve a source location representing the last character within a
  /// source range.
  CXSourceLocation clang_getRangeEnd(CXSourceRange range) {
    return _clang_getRangeEnd(range);
  }

  late final _clang_getRangeEndPtr =
      _lookup<ffi.NativeFunction<NativeClang_getRangeEnd>>('clang_getRangeEnd');
  late final _clang_getRangeEnd = _clang_getRangeEndPtr
      .asFunction<DartClang_getRangeEnd>();

  /// Retrieve all ranges that were skipped by the preprocessor.
  ///
  /// The preprocessor will skip lines when they are surrounded by an
  /// if/ifdef/ifndef directive whose condition does not evaluate to true.
  ffi.Pointer<CXSourceRangeList> clang_getSkippedRanges(
    CXTranslationUnit tu,
    CXFile file,
  ) {
    return _clang_getSkippedRanges(tu, file);
  }

  late final _clang_getSkippedRangesPtr =
      _lookup<ffi.NativeFunction<NativeClang_getSkippedRanges>>(
        'clang_getSkippedRanges',
      );
  late final _clang_getSkippedRanges = _clang_getSkippedRangesPtr
      .asFunction<DartClang_getSkippedRanges>();

  /// Retrieve all ranges from all files that were skipped by the
  /// preprocessor.
  ///
  /// The preprocessor will skip lines when they are surrounded by an
  /// if/ifdef/ifndef directive whose condition does not evaluate to true.
  ffi.Pointer<CXSourceRangeList> clang_getAllSkippedRanges(
    CXTranslationUnit tu,
  ) {
    return _clang_getAllSkippedRanges(tu);
  }

  late final _clang_getAllSkippedRangesPtr =
      _lookup<ffi.NativeFunction<NativeClang_getAllSkippedRanges>>(
        'clang_getAllSkippedRanges',
      );
  late final _clang_getAllSkippedRanges = _clang_getAllSkippedRangesPtr
      .asFunction<DartClang_getAllSkippedRanges>();

  /// Destroy the given \c CXSourceRangeList.
  void clang_disposeSourceRangeList(ffi.Pointer<CXSourceRangeList> ranges) {
    return _clang_disposeSourceRangeList(ranges);
  }

  late final _clang_disposeSourceRangeListPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeSourceRangeList>>(
        'clang_disposeSourceRangeList',
      );
  late final _clang_disposeSourceRangeList = _clang_disposeSourceRangeListPtr
      .asFunction<DartClang_disposeSourceRangeList>();

  /// Determine the number of diagnostics in a CXDiagnosticSet.
  int clang_getNumDiagnosticsInSet(CXDiagnosticSet Diags) {
    return _clang_getNumDiagnosticsInSet(Diags);
  }

  late final _clang_getNumDiagnosticsInSetPtr =
      _lookup<ffi.NativeFunction<NativeClang_getNumDiagnosticsInSet>>(
        'clang_getNumDiagnosticsInSet',
      );
  late final _clang_getNumDiagnosticsInSet = _clang_getNumDiagnosticsInSetPtr
      .asFunction<DartClang_getNumDiagnosticsInSet>();

  /// Retrieve a diagnostic associated with the given CXDiagnosticSet.
  ///
  /// \param Diags the CXDiagnosticSet to query.
  /// \param Index the zero-based diagnostic number to retrieve.
  ///
  /// \returns the requested diagnostic. This diagnostic must be freed
  /// via a call to \c clang_disposeDiagnostic().
  CXDiagnostic clang_getDiagnosticInSet(CXDiagnosticSet Diags, int Index) {
    return _clang_getDiagnosticInSet(Diags, Index);
  }

  late final _clang_getDiagnosticInSetPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticInSet>>(
        'clang_getDiagnosticInSet',
      );
  late final _clang_getDiagnosticInSet = _clang_getDiagnosticInSetPtr
      .asFunction<DartClang_getDiagnosticInSet>();

  /// Deserialize a set of diagnostics from a Clang diagnostics bitcode
  /// file.
  ///
  /// \param file The name of the file to deserialize.
  /// \param error A pointer to a enum value recording if there was a problem
  /// deserializing the diagnostics.
  /// \param errorString A pointer to a CXString for recording the error string
  /// if the file was not successfully loaded.
  ///
  /// \returns A loaded CXDiagnosticSet if successful, and NULL otherwise.  These
  /// diagnostics should be released using clang_disposeDiagnosticSet().
  CXDiagnosticSet clang_loadDiagnostics(
    ffi.Pointer<ffi.Char> file,
    ffi.Pointer<ffi.UnsignedInt> error,
    ffi.Pointer<CXString> errorString,
  ) {
    return _clang_loadDiagnostics(file, error, errorString);
  }

  late final _clang_loadDiagnosticsPtr =
      _lookup<ffi.NativeFunction<NativeClang_loadDiagnostics>>(
        'clang_loadDiagnostics',
      );
  late final _clang_loadDiagnostics = _clang_loadDiagnosticsPtr
      .asFunction<DartClang_loadDiagnostics>();

  /// Release a CXDiagnosticSet and all of its contained diagnostics.
  void clang_disposeDiagnosticSet(CXDiagnosticSet Diags) {
    return _clang_disposeDiagnosticSet(Diags);
  }

  late final _clang_disposeDiagnosticSetPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeDiagnosticSet>>(
        'clang_disposeDiagnosticSet',
      );
  late final _clang_disposeDiagnosticSet = _clang_disposeDiagnosticSetPtr
      .asFunction<DartClang_disposeDiagnosticSet>();

  /// Retrieve the child diagnostics of a CXDiagnostic.
  ///
  /// This CXDiagnosticSet does not need to be released by
  /// clang_disposeDiagnosticSet.
  CXDiagnosticSet clang_getChildDiagnostics(CXDiagnostic D) {
    return _clang_getChildDiagnostics(D);
  }

  late final _clang_getChildDiagnosticsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getChildDiagnostics>>(
        'clang_getChildDiagnostics',
      );
  late final _clang_getChildDiagnostics = _clang_getChildDiagnosticsPtr
      .asFunction<DartClang_getChildDiagnostics>();

  /// Determine the number of diagnostics produced for the given
  /// translation unit.
  int clang_getNumDiagnostics(CXTranslationUnit Unit) {
    return _clang_getNumDiagnostics(Unit);
  }

  late final _clang_getNumDiagnosticsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getNumDiagnostics>>(
        'clang_getNumDiagnostics',
      );
  late final _clang_getNumDiagnostics = _clang_getNumDiagnosticsPtr
      .asFunction<DartClang_getNumDiagnostics>();

  /// Retrieve a diagnostic associated with the given translation unit.
  ///
  /// \param Unit the translation unit to query.
  /// \param Index the zero-based diagnostic number to retrieve.
  ///
  /// \returns the requested diagnostic. This diagnostic must be freed
  /// via a call to \c clang_disposeDiagnostic().
  CXDiagnostic clang_getDiagnostic(CXTranslationUnit Unit, int Index) {
    return _clang_getDiagnostic(Unit, Index);
  }

  late final _clang_getDiagnosticPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnostic>>(
        'clang_getDiagnostic',
      );
  late final _clang_getDiagnostic = _clang_getDiagnosticPtr
      .asFunction<DartClang_getDiagnostic>();

  /// Retrieve the complete set of diagnostics associated with a
  /// translation unit.
  ///
  /// \param Unit the translation unit to query.
  CXDiagnosticSet clang_getDiagnosticSetFromTU(CXTranslationUnit Unit) {
    return _clang_getDiagnosticSetFromTU(Unit);
  }

  late final _clang_getDiagnosticSetFromTUPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticSetFromTU>>(
        'clang_getDiagnosticSetFromTU',
      );
  late final _clang_getDiagnosticSetFromTU = _clang_getDiagnosticSetFromTUPtr
      .asFunction<DartClang_getDiagnosticSetFromTU>();

  /// Destroy a diagnostic.
  void clang_disposeDiagnostic(CXDiagnostic Diagnostic) {
    return _clang_disposeDiagnostic(Diagnostic);
  }

  late final _clang_disposeDiagnosticPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeDiagnostic>>(
        'clang_disposeDiagnostic',
      );
  late final _clang_disposeDiagnostic = _clang_disposeDiagnosticPtr
      .asFunction<DartClang_disposeDiagnostic>();

  /// Format the given diagnostic in a manner that is suitable for display.
  ///
  /// This routine will format the given diagnostic to a string, rendering
  /// the diagnostic according to the various options given. The
  /// \c clang_defaultDiagnosticDisplayOptions() function returns the set of
  /// options that most closely mimics the behavior of the clang compiler.
  ///
  /// \param Diagnostic The diagnostic to print.
  ///
  /// \param Options A set of options that control the diagnostic display,
  /// created by combining \c CXDiagnosticDisplayOptions values.
  ///
  /// \returns A new string containing for formatted diagnostic.
  CXString clang_formatDiagnostic(CXDiagnostic Diagnostic, int Options) {
    return _clang_formatDiagnostic(Diagnostic, Options);
  }

  late final _clang_formatDiagnosticPtr =
      _lookup<ffi.NativeFunction<NativeClang_formatDiagnostic>>(
        'clang_formatDiagnostic',
      );
  late final _clang_formatDiagnostic = _clang_formatDiagnosticPtr
      .asFunction<DartClang_formatDiagnostic>();

  /// Retrieve the set of display options most similar to the
  /// default behavior of the clang compiler.
  ///
  /// \returns A set of display options suitable for use with \c
  /// clang_formatDiagnostic().
  int clang_defaultDiagnosticDisplayOptions() {
    return _clang_defaultDiagnosticDisplayOptions();
  }

  late final _clang_defaultDiagnosticDisplayOptionsPtr =
      _lookup<ffi.NativeFunction<NativeClang_defaultDiagnosticDisplayOptions>>(
        'clang_defaultDiagnosticDisplayOptions',
      );
  late final _clang_defaultDiagnosticDisplayOptions =
      _clang_defaultDiagnosticDisplayOptionsPtr
          .asFunction<DartClang_defaultDiagnosticDisplayOptions>();

  /// Determine the severity of the given diagnostic.
  CXDiagnosticSeverity clang_getDiagnosticSeverity(CXDiagnostic arg0) {
    return CXDiagnosticSeverity.fromValue(_clang_getDiagnosticSeverity(arg0));
  }

  late final _clang_getDiagnosticSeverityPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticSeverity>>(
        'clang_getDiagnosticSeverity',
      );
  late final _clang_getDiagnosticSeverity = _clang_getDiagnosticSeverityPtr
      .asFunction<DartClang_getDiagnosticSeverity>();

  /// Retrieve the source location of the given diagnostic.
  ///
  /// This location is where Clang would print the caret ('^') when
  /// displaying the diagnostic on the command line.
  CXSourceLocation clang_getDiagnosticLocation(CXDiagnostic arg0) {
    return _clang_getDiagnosticLocation(arg0);
  }

  late final _clang_getDiagnosticLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticLocation>>(
        'clang_getDiagnosticLocation',
      );
  late final _clang_getDiagnosticLocation = _clang_getDiagnosticLocationPtr
      .asFunction<DartClang_getDiagnosticLocation>();

  /// Retrieve the text of the given diagnostic.
  CXString clang_getDiagnosticSpelling(CXDiagnostic arg0) {
    return _clang_getDiagnosticSpelling(arg0);
  }

  late final _clang_getDiagnosticSpellingPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticSpelling>>(
        'clang_getDiagnosticSpelling',
      );
  late final _clang_getDiagnosticSpelling = _clang_getDiagnosticSpellingPtr
      .asFunction<DartClang_getDiagnosticSpelling>();

  /// Retrieve the name of the command-line option that enabled this
  /// diagnostic.
  ///
  /// \param Diag The diagnostic to be queried.
  ///
  /// \param Disable If non-NULL, will be set to the option that disables this
  /// diagnostic (if any).
  ///
  /// \returns A string that contains the command-line option used to enable this
  /// warning, such as "-Wconversion" or "-pedantic".
  CXString clang_getDiagnosticOption(
    CXDiagnostic Diag,
    ffi.Pointer<CXString> Disable,
  ) {
    return _clang_getDiagnosticOption(Diag, Disable);
  }

  late final _clang_getDiagnosticOptionPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticOption>>(
        'clang_getDiagnosticOption',
      );
  late final _clang_getDiagnosticOption = _clang_getDiagnosticOptionPtr
      .asFunction<DartClang_getDiagnosticOption>();

  /// Retrieve the category number for this diagnostic.
  ///
  /// Diagnostics can be categorized into groups along with other, related
  /// diagnostics (e.g., diagnostics under the same warning flag). This routine
  /// retrieves the category number for the given diagnostic.
  ///
  /// \returns The number of the category that contains this diagnostic, or zero
  /// if this diagnostic is uncategorized.
  int clang_getDiagnosticCategory(CXDiagnostic arg0) {
    return _clang_getDiagnosticCategory(arg0);
  }

  late final _clang_getDiagnosticCategoryPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticCategory>>(
        'clang_getDiagnosticCategory',
      );
  late final _clang_getDiagnosticCategory = _clang_getDiagnosticCategoryPtr
      .asFunction<DartClang_getDiagnosticCategory>();

  /// Retrieve the name of a particular diagnostic category.  This
  /// is now deprecated.  Use clang_getDiagnosticCategoryText()
  /// instead.
  ///
  /// \param Category A diagnostic category number, as returned by
  /// \c clang_getDiagnosticCategory().
  ///
  /// \returns The name of the given diagnostic category.
  CXString clang_getDiagnosticCategoryName(int Category) {
    return _clang_getDiagnosticCategoryName(Category);
  }

  late final _clang_getDiagnosticCategoryNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticCategoryName>>(
        'clang_getDiagnosticCategoryName',
      );
  late final _clang_getDiagnosticCategoryName =
      _clang_getDiagnosticCategoryNamePtr
          .asFunction<DartClang_getDiagnosticCategoryName>();

  /// Retrieve the diagnostic category text for a given diagnostic.
  ///
  /// \returns The text of the given diagnostic category.
  CXString clang_getDiagnosticCategoryText(CXDiagnostic arg0) {
    return _clang_getDiagnosticCategoryText(arg0);
  }

  late final _clang_getDiagnosticCategoryTextPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticCategoryText>>(
        'clang_getDiagnosticCategoryText',
      );
  late final _clang_getDiagnosticCategoryText =
      _clang_getDiagnosticCategoryTextPtr
          .asFunction<DartClang_getDiagnosticCategoryText>();

  /// Determine the number of source ranges associated with the given
  /// diagnostic.
  int clang_getDiagnosticNumRanges(CXDiagnostic arg0) {
    return _clang_getDiagnosticNumRanges(arg0);
  }

  late final _clang_getDiagnosticNumRangesPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticNumRanges>>(
        'clang_getDiagnosticNumRanges',
      );
  late final _clang_getDiagnosticNumRanges = _clang_getDiagnosticNumRangesPtr
      .asFunction<DartClang_getDiagnosticNumRanges>();

  /// Retrieve a source range associated with the diagnostic.
  ///
  /// A diagnostic's source ranges highlight important elements in the source
  /// code. On the command line, Clang displays source ranges by
  /// underlining them with '~' characters.
  ///
  /// \param Diagnostic the diagnostic whose range is being extracted.
  ///
  /// \param Range the zero-based index specifying which range to
  ///
  /// \returns the requested source range.
  CXSourceRange clang_getDiagnosticRange(CXDiagnostic Diagnostic, int Range) {
    return _clang_getDiagnosticRange(Diagnostic, Range);
  }

  late final _clang_getDiagnosticRangePtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticRange>>(
        'clang_getDiagnosticRange',
      );
  late final _clang_getDiagnosticRange = _clang_getDiagnosticRangePtr
      .asFunction<DartClang_getDiagnosticRange>();

  /// Determine the number of fix-it hints associated with the
  /// given diagnostic.
  int clang_getDiagnosticNumFixIts(CXDiagnostic Diagnostic) {
    return _clang_getDiagnosticNumFixIts(Diagnostic);
  }

  late final _clang_getDiagnosticNumFixItsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticNumFixIts>>(
        'clang_getDiagnosticNumFixIts',
      );
  late final _clang_getDiagnosticNumFixIts = _clang_getDiagnosticNumFixItsPtr
      .asFunction<DartClang_getDiagnosticNumFixIts>();

  /// Retrieve the replacement information for a given fix-it.
  ///
  /// Fix-its are described in terms of a source range whose contents
  /// should be replaced by a string. This approach generalizes over
  /// three kinds of operations: removal of source code (the range covers
  /// the code to be removed and the replacement string is empty),
  /// replacement of source code (the range covers the code to be
  /// replaced and the replacement string provides the new code), and
  /// insertion (both the start and end of the range point at the
  /// insertion location, and the replacement string provides the text to
  /// insert).
  ///
  /// \param Diagnostic The diagnostic whose fix-its are being queried.
  ///
  /// \param FixIt The zero-based index of the fix-it.
  ///
  /// \param ReplacementRange The source range whose contents will be
  /// replaced with the returned replacement string. Note that source
  /// ranges are half-open ranges [a, b), so the source code should be
  /// replaced from a and up to (but not including) b.
  ///
  /// \returns A string containing text that should be replace the source
  /// code indicated by the \c ReplacementRange.
  CXString clang_getDiagnosticFixIt(
    CXDiagnostic Diagnostic,
    int FixIt,
    ffi.Pointer<CXSourceRange> ReplacementRange,
  ) {
    return _clang_getDiagnosticFixIt(Diagnostic, FixIt, ReplacementRange);
  }

  late final _clang_getDiagnosticFixItPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDiagnosticFixIt>>(
        'clang_getDiagnosticFixIt',
      );
  late final _clang_getDiagnosticFixIt = _clang_getDiagnosticFixItPtr
      .asFunction<DartClang_getDiagnosticFixIt>();

  /// Get the original translation unit source file name.
  CXString clang_getTranslationUnitSpelling(CXTranslationUnit CTUnit) {
    return _clang_getTranslationUnitSpelling(CTUnit);
  }

  late final _clang_getTranslationUnitSpellingPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTranslationUnitSpelling>>(
        'clang_getTranslationUnitSpelling',
      );
  late final _clang_getTranslationUnitSpelling =
      _clang_getTranslationUnitSpellingPtr
          .asFunction<DartClang_getTranslationUnitSpelling>();

  /// Return the CXTranslationUnit for a given source file and the provided
  /// command line arguments one would pass to the compiler.
  ///
  /// Note: The 'source_filename' argument is optional.  If the caller provides a
  /// NULL pointer, the name of the source file is expected to reside in the
  /// specified command line arguments.
  ///
  /// Note: When encountered in 'clang_command_line_args', the following options
  /// are ignored:
  ///
  /// '-c'
  /// '-emit-ast'
  /// '-fsyntax-only'
  /// '-o \<output file>'  (both '-o' and '\<output file>' are ignored)
  ///
  /// \param CIdx The index object with which the translation unit will be
  /// associated.
  ///
  /// \param source_filename The name of the source file to load, or NULL if the
  /// source file is included in \p clang_command_line_args.
  ///
  /// \param num_clang_command_line_args The number of command-line arguments in
  /// \p clang_command_line_args.
  ///
  /// \param clang_command_line_args The command-line arguments that would be
  /// passed to the \c clang executable if it were being invoked out-of-process.
  /// These command-line options will be parsed and will affect how the translation
  /// unit is parsed. Note that the following options are ignored: '-c',
  /// '-emit-ast', '-fsyntax-only' (which is the default), and '-o \<output file>'.
  ///
  /// \param num_unsaved_files the number of unsaved file entries in \p
  /// unsaved_files.
  ///
  /// \param unsaved_files the files that have not yet been saved to disk
  /// but may be required for code completion, including the contents of
  /// those files.  The contents and name of these files (as specified by
  /// CXUnsavedFile) are copied when necessary, so the client only needs to
  /// guarantee their validity until the call to this function returns.
  CXTranslationUnit clang_createTranslationUnitFromSourceFile(
    CXIndex CIdx,
    ffi.Pointer<ffi.Char> source_filename,
    int num_clang_command_line_args,
    ffi.Pointer<ffi.Pointer<ffi.Char>> clang_command_line_args,
    int num_unsaved_files,
    ffi.Pointer<CXUnsavedFile> unsaved_files,
  ) {
    return _clang_createTranslationUnitFromSourceFile(
      CIdx,
      source_filename,
      num_clang_command_line_args,
      clang_command_line_args,
      num_unsaved_files,
      unsaved_files,
    );
  }

  late final _clang_createTranslationUnitFromSourceFilePtr =
      _lookup<
        ffi.NativeFunction<NativeClang_createTranslationUnitFromSourceFile>
      >('clang_createTranslationUnitFromSourceFile');
  late final _clang_createTranslationUnitFromSourceFile =
      _clang_createTranslationUnitFromSourceFilePtr
          .asFunction<DartClang_createTranslationUnitFromSourceFile>();

  /// Same as \c clang_createTranslationUnit2, but returns
  /// the \c CXTranslationUnit instead of an error code.  In case of an error this
  /// routine returns a \c NULL \c CXTranslationUnit, without further detailed
  /// error codes.
  CXTranslationUnit clang_createTranslationUnit(
    CXIndex CIdx,
    ffi.Pointer<ffi.Char> ast_filename,
  ) {
    return _clang_createTranslationUnit(CIdx, ast_filename);
  }

  late final _clang_createTranslationUnitPtr =
      _lookup<ffi.NativeFunction<NativeClang_createTranslationUnit>>(
        'clang_createTranslationUnit',
      );
  late final _clang_createTranslationUnit = _clang_createTranslationUnitPtr
      .asFunction<DartClang_createTranslationUnit>();

  /// Create a translation unit from an AST file (\c -emit-ast).
  ///
  /// \param[out] out_TU A non-NULL pointer to store the created
  /// \c CXTranslationUnit.
  ///
  /// \returns Zero on success, otherwise returns an error code.
  CXErrorCode clang_createTranslationUnit2(
    CXIndex CIdx,
    ffi.Pointer<ffi.Char> ast_filename,
    ffi.Pointer<CXTranslationUnit> out_TU,
  ) {
    return CXErrorCode.fromValue(
      _clang_createTranslationUnit2(CIdx, ast_filename, out_TU),
    );
  }

  late final _clang_createTranslationUnit2Ptr =
      _lookup<ffi.NativeFunction<NativeClang_createTranslationUnit2>>(
        'clang_createTranslationUnit2',
      );
  late final _clang_createTranslationUnit2 = _clang_createTranslationUnit2Ptr
      .asFunction<DartClang_createTranslationUnit2>();

  /// Returns the set of flags that is suitable for parsing a translation
  /// unit that is being edited.
  ///
  /// The set of flags returned provide options for \c clang_parseTranslationUnit()
  /// to indicate that the translation unit is likely to be reparsed many times,
  /// either explicitly (via \c clang_reparseTranslationUnit()) or implicitly
  /// (e.g., by code completion (\c clang_codeCompletionAt())). The returned flag
  /// set contains an unspecified set of optimizations (e.g., the precompiled
  /// preamble) geared toward improving the performance of these routines. The
  /// set of optimizations enabled may change from one version to the next.
  int clang_defaultEditingTranslationUnitOptions() {
    return _clang_defaultEditingTranslationUnitOptions();
  }

  late final _clang_defaultEditingTranslationUnitOptionsPtr =
      _lookup<
        ffi.NativeFunction<NativeClang_defaultEditingTranslationUnitOptions>
      >('clang_defaultEditingTranslationUnitOptions');
  late final _clang_defaultEditingTranslationUnitOptions =
      _clang_defaultEditingTranslationUnitOptionsPtr
          .asFunction<DartClang_defaultEditingTranslationUnitOptions>();

  /// Same as \c clang_parseTranslationUnit2, but returns
  /// the \c CXTranslationUnit instead of an error code.  In case of an error this
  /// routine returns a \c NULL \c CXTranslationUnit, without further detailed
  /// error codes.
  CXTranslationUnit clang_parseTranslationUnit(
    CXIndex CIdx,
    ffi.Pointer<ffi.Char> source_filename,
    ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
    int num_command_line_args,
    ffi.Pointer<CXUnsavedFile> unsaved_files,
    int num_unsaved_files,
    int options,
  ) {
    return _clang_parseTranslationUnit(
      CIdx,
      source_filename,
      command_line_args,
      num_command_line_args,
      unsaved_files,
      num_unsaved_files,
      options,
    );
  }

  late final _clang_parseTranslationUnitPtr =
      _lookup<ffi.NativeFunction<NativeClang_parseTranslationUnit>>(
        'clang_parseTranslationUnit',
      );
  late final _clang_parseTranslationUnit = _clang_parseTranslationUnitPtr
      .asFunction<DartClang_parseTranslationUnit>();

  /// Parse the given source file and the translation unit corresponding
  /// to that file.
  ///
  /// This routine is the main entry point for the Clang C API, providing the
  /// ability to parse a source file into a translation unit that can then be
  /// queried by other functions in the API. This routine accepts a set of
  /// command-line arguments so that the compilation can be configured in the same
  /// way that the compiler is configured on the command line.
  ///
  /// \param CIdx The index object with which the translation unit will be
  /// associated.
  ///
  /// \param source_filename The name of the source file to load, or NULL if the
  /// source file is included in \c command_line_args.
  ///
  /// \param command_line_args The command-line arguments that would be
  /// passed to the \c clang executable if it were being invoked out-of-process.
  /// These command-line options will be parsed and will affect how the translation
  /// unit is parsed. Note that the following options are ignored: '-c',
  /// '-emit-ast', '-fsyntax-only' (which is the default), and '-o \<output file>'.
  ///
  /// \param num_command_line_args The number of command-line arguments in
  /// \c command_line_args.
  ///
  /// \param unsaved_files the files that have not yet been saved to disk
  /// but may be required for parsing, including the contents of
  /// those files.  The contents and name of these files (as specified by
  /// CXUnsavedFile) are copied when necessary, so the client only needs to
  /// guarantee their validity until the call to this function returns.
  ///
  /// \param num_unsaved_files the number of unsaved file entries in \p
  /// unsaved_files.
  ///
  /// \param options A bitmask of options that affects how the translation unit
  /// is managed but not its compilation. This should be a bitwise OR of the
  /// CXTranslationUnit_XXX flags.
  ///
  /// \param[out] out_TU A non-NULL pointer to store the created
  /// \c CXTranslationUnit, describing the parsed code and containing any
  /// diagnostics produced by the compiler.
  ///
  /// \returns Zero on success, otherwise returns an error code.
  CXErrorCode clang_parseTranslationUnit2(
    CXIndex CIdx,
    ffi.Pointer<ffi.Char> source_filename,
    ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
    int num_command_line_args,
    ffi.Pointer<CXUnsavedFile> unsaved_files,
    int num_unsaved_files,
    int options,
    ffi.Pointer<CXTranslationUnit> out_TU,
  ) {
    return CXErrorCode.fromValue(
      _clang_parseTranslationUnit2(
        CIdx,
        source_filename,
        command_line_args,
        num_command_line_args,
        unsaved_files,
        num_unsaved_files,
        options,
        out_TU,
      ),
    );
  }

  late final _clang_parseTranslationUnit2Ptr =
      _lookup<ffi.NativeFunction<NativeClang_parseTranslationUnit2>>(
        'clang_parseTranslationUnit2',
      );
  late final _clang_parseTranslationUnit2 = _clang_parseTranslationUnit2Ptr
      .asFunction<DartClang_parseTranslationUnit2>();

  /// Same as clang_parseTranslationUnit2 but requires a full command line
  /// for \c command_line_args including argv[0]. This is useful if the standard
  /// library paths are relative to the binary.
  CXErrorCode clang_parseTranslationUnit2FullArgv(
    CXIndex CIdx,
    ffi.Pointer<ffi.Char> source_filename,
    ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
    int num_command_line_args,
    ffi.Pointer<CXUnsavedFile> unsaved_files,
    int num_unsaved_files,
    int options,
    ffi.Pointer<CXTranslationUnit> out_TU,
  ) {
    return CXErrorCode.fromValue(
      _clang_parseTranslationUnit2FullArgv(
        CIdx,
        source_filename,
        command_line_args,
        num_command_line_args,
        unsaved_files,
        num_unsaved_files,
        options,
        out_TU,
      ),
    );
  }

  late final _clang_parseTranslationUnit2FullArgvPtr =
      _lookup<ffi.NativeFunction<NativeClang_parseTranslationUnit2FullArgv>>(
        'clang_parseTranslationUnit2FullArgv',
      );
  late final _clang_parseTranslationUnit2FullArgv =
      _clang_parseTranslationUnit2FullArgvPtr
          .asFunction<DartClang_parseTranslationUnit2FullArgv>();

  /// Returns the set of flags that is suitable for saving a translation
  /// unit.
  ///
  /// The set of flags returned provide options for
  /// \c clang_saveTranslationUnit() by default. The returned flag
  /// set contains an unspecified set of options that save translation units with
  /// the most commonly-requested data.
  int clang_defaultSaveOptions(CXTranslationUnit TU) {
    return _clang_defaultSaveOptions(TU);
  }

  late final _clang_defaultSaveOptionsPtr =
      _lookup<ffi.NativeFunction<NativeClang_defaultSaveOptions>>(
        'clang_defaultSaveOptions',
      );
  late final _clang_defaultSaveOptions = _clang_defaultSaveOptionsPtr
      .asFunction<DartClang_defaultSaveOptions>();

  /// Saves a translation unit into a serialized representation of
  /// that translation unit on disk.
  ///
  /// Any translation unit that was parsed without error can be saved
  /// into a file. The translation unit can then be deserialized into a
  /// new \c CXTranslationUnit with \c clang_createTranslationUnit() or,
  /// if it is an incomplete translation unit that corresponds to a
  /// header, used as a precompiled header when parsing other translation
  /// units.
  ///
  /// \param TU The translation unit to save.
  ///
  /// \param FileName The file to which the translation unit will be saved.
  ///
  /// \param options A bitmask of options that affects how the translation unit
  /// is saved. This should be a bitwise OR of the
  /// CXSaveTranslationUnit_XXX flags.
  ///
  /// \returns A value that will match one of the enumerators of the CXSaveError
  /// enumeration. Zero (CXSaveError_None) indicates that the translation unit was
  /// saved successfully, while a non-zero value indicates that a problem occurred.
  int clang_saveTranslationUnit(
    CXTranslationUnit TU,
    ffi.Pointer<ffi.Char> FileName,
    int options,
  ) {
    return _clang_saveTranslationUnit(TU, FileName, options);
  }

  late final _clang_saveTranslationUnitPtr =
      _lookup<ffi.NativeFunction<NativeClang_saveTranslationUnit>>(
        'clang_saveTranslationUnit',
      );
  late final _clang_saveTranslationUnit = _clang_saveTranslationUnitPtr
      .asFunction<DartClang_saveTranslationUnit>();

  /// Suspend a translation unit in order to free memory associated with it.
  ///
  /// A suspended translation unit uses significantly less memory but on the other
  /// side does not support any other calls than \c clang_reparseTranslationUnit
  /// to resume it or \c clang_disposeTranslationUnit to dispose it completely.
  int clang_suspendTranslationUnit(CXTranslationUnit arg0) {
    return _clang_suspendTranslationUnit(arg0);
  }

  late final _clang_suspendTranslationUnitPtr =
      _lookup<ffi.NativeFunction<NativeClang_suspendTranslationUnit>>(
        'clang_suspendTranslationUnit',
      );
  late final _clang_suspendTranslationUnit = _clang_suspendTranslationUnitPtr
      .asFunction<DartClang_suspendTranslationUnit>();

  /// Destroy the specified CXTranslationUnit object.
  void clang_disposeTranslationUnit(CXTranslationUnit arg0) {
    return _clang_disposeTranslationUnit(arg0);
  }

  late final _clang_disposeTranslationUnitPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeTranslationUnit>>(
        'clang_disposeTranslationUnit',
      );
  late final _clang_disposeTranslationUnit = _clang_disposeTranslationUnitPtr
      .asFunction<DartClang_disposeTranslationUnit>();

  /// Returns the set of flags that is suitable for reparsing a translation
  /// unit.
  ///
  /// The set of flags returned provide options for
  /// \c clang_reparseTranslationUnit() by default. The returned flag
  /// set contains an unspecified set of optimizations geared toward common uses
  /// of reparsing. The set of optimizations enabled may change from one version
  /// to the next.
  int clang_defaultReparseOptions(CXTranslationUnit TU) {
    return _clang_defaultReparseOptions(TU);
  }

  late final _clang_defaultReparseOptionsPtr =
      _lookup<ffi.NativeFunction<NativeClang_defaultReparseOptions>>(
        'clang_defaultReparseOptions',
      );
  late final _clang_defaultReparseOptions = _clang_defaultReparseOptionsPtr
      .asFunction<DartClang_defaultReparseOptions>();

  /// Reparse the source files that produced this translation unit.
  ///
  /// This routine can be used to re-parse the source files that originally
  /// created the given translation unit, for example because those source files
  /// have changed (either on disk or as passed via \p unsaved_files). The
  /// source code will be reparsed with the same command-line options as it
  /// was originally parsed.
  ///
  /// Reparsing a translation unit invalidates all cursors and source locations
  /// that refer into that translation unit. This makes reparsing a translation
  /// unit semantically equivalent to destroying the translation unit and then
  /// creating a new translation unit with the same command-line arguments.
  /// However, it may be more efficient to reparse a translation
  /// unit using this routine.
  ///
  /// \param TU The translation unit whose contents will be re-parsed. The
  /// translation unit must originally have been built with
  /// \c clang_createTranslationUnitFromSourceFile().
  ///
  /// \param num_unsaved_files The number of unsaved file entries in \p
  /// unsaved_files.
  ///
  /// \param unsaved_files The files that have not yet been saved to disk
  /// but may be required for parsing, including the contents of
  /// those files.  The contents and name of these files (as specified by
  /// CXUnsavedFile) are copied when necessary, so the client only needs to
  /// guarantee their validity until the call to this function returns.
  ///
  /// \param options A bitset of options composed of the flags in CXReparse_Flags.
  /// The function \c clang_defaultReparseOptions() produces a default set of
  /// options recommended for most uses, based on the translation unit.
  ///
  /// \returns 0 if the sources could be reparsed.  A non-zero error code will be
  /// returned if reparsing was impossible, such that the translation unit is
  /// invalid. In such cases, the only valid call for \c TU is
  /// \c clang_disposeTranslationUnit(TU).  The error codes returned by this
  /// routine are described by the \c CXErrorCode enum.
  int clang_reparseTranslationUnit(
    CXTranslationUnit TU,
    int num_unsaved_files,
    ffi.Pointer<CXUnsavedFile> unsaved_files,
    int options,
  ) {
    return _clang_reparseTranslationUnit(
      TU,
      num_unsaved_files,
      unsaved_files,
      options,
    );
  }

  late final _clang_reparseTranslationUnitPtr =
      _lookup<ffi.NativeFunction<NativeClang_reparseTranslationUnit>>(
        'clang_reparseTranslationUnit',
      );
  late final _clang_reparseTranslationUnit = _clang_reparseTranslationUnitPtr
      .asFunction<DartClang_reparseTranslationUnit>();

  /// Returns the human-readable null-terminated C string that represents
  /// the name of the memory category.  This string should never be freed.
  ffi.Pointer<ffi.Char> clang_getTUResourceUsageName(
    CXTUResourceUsageKind kind,
  ) {
    return _clang_getTUResourceUsageName(kind.value);
  }

  late final _clang_getTUResourceUsageNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_getTUResourceUsageName>>(
        'clang_getTUResourceUsageName',
      );
  late final _clang_getTUResourceUsageName = _clang_getTUResourceUsageNamePtr
      .asFunction<DartClang_getTUResourceUsageName>();

  /// Return the memory usage of a translation unit.  This object
  /// should be released with clang_disposeCXTUResourceUsage().
  CXTUResourceUsage clang_getCXTUResourceUsage(CXTranslationUnit TU) {
    return _clang_getCXTUResourceUsage(TU);
  }

  late final _clang_getCXTUResourceUsagePtr =
      _lookup<ffi.NativeFunction<NativeClang_getCXTUResourceUsage>>(
        'clang_getCXTUResourceUsage',
      );
  late final _clang_getCXTUResourceUsage = _clang_getCXTUResourceUsagePtr
      .asFunction<DartClang_getCXTUResourceUsage>();

  void clang_disposeCXTUResourceUsage(CXTUResourceUsage usage) {
    return _clang_disposeCXTUResourceUsage(usage);
  }

  late final _clang_disposeCXTUResourceUsagePtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeCXTUResourceUsage>>(
        'clang_disposeCXTUResourceUsage',
      );
  late final _clang_disposeCXTUResourceUsage =
      _clang_disposeCXTUResourceUsagePtr
          .asFunction<DartClang_disposeCXTUResourceUsage>();

  /// Get target information for this translation unit.
  ///
  /// The CXTargetInfo object cannot outlive the CXTranslationUnit object.
  CXTargetInfo clang_getTranslationUnitTargetInfo(CXTranslationUnit CTUnit) {
    return _clang_getTranslationUnitTargetInfo(CTUnit);
  }

  late final _clang_getTranslationUnitTargetInfoPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTranslationUnitTargetInfo>>(
        'clang_getTranslationUnitTargetInfo',
      );
  late final _clang_getTranslationUnitTargetInfo =
      _clang_getTranslationUnitTargetInfoPtr
          .asFunction<DartClang_getTranslationUnitTargetInfo>();

  /// Destroy the CXTargetInfo object.
  void clang_TargetInfo_dispose(CXTargetInfo Info) {
    return _clang_TargetInfo_dispose(Info);
  }

  late final _clang_TargetInfo_disposePtr =
      _lookup<ffi.NativeFunction<NativeClang_TargetInfo_dispose>>(
        'clang_TargetInfo_dispose',
      );
  late final _clang_TargetInfo_dispose = _clang_TargetInfo_disposePtr
      .asFunction<DartClang_TargetInfo_dispose>();

  /// Get the normalized target triple as a string.
  ///
  /// Returns the empty string in case of any error.
  CXString clang_TargetInfo_getTriple(CXTargetInfo Info) {
    return _clang_TargetInfo_getTriple(Info);
  }

  late final _clang_TargetInfo_getTriplePtr =
      _lookup<ffi.NativeFunction<NativeClang_TargetInfo_getTriple>>(
        'clang_TargetInfo_getTriple',
      );
  late final _clang_TargetInfo_getTriple = _clang_TargetInfo_getTriplePtr
      .asFunction<DartClang_TargetInfo_getTriple>();

  /// Get the pointer width of the target in bits.
  ///
  /// Returns -1 in case of error.
  int clang_TargetInfo_getPointerWidth(CXTargetInfo Info) {
    return _clang_TargetInfo_getPointerWidth(Info);
  }

  late final _clang_TargetInfo_getPointerWidthPtr =
      _lookup<ffi.NativeFunction<NativeClang_TargetInfo_getPointerWidth>>(
        'clang_TargetInfo_getPointerWidth',
      );
  late final _clang_TargetInfo_getPointerWidth =
      _clang_TargetInfo_getPointerWidthPtr
          .asFunction<DartClang_TargetInfo_getPointerWidth>();

  /// Retrieve the NULL cursor, which represents no entity.
  CXCursor clang_getNullCursor() {
    return _clang_getNullCursor();
  }

  late final _clang_getNullCursorPtr =
      _lookup<ffi.NativeFunction<NativeClang_getNullCursor>>(
        'clang_getNullCursor',
      );
  late final _clang_getNullCursor = _clang_getNullCursorPtr
      .asFunction<DartClang_getNullCursor>();

  /// Retrieve the cursor that represents the given translation unit.
  ///
  /// The translation unit cursor can be used to start traversing the
  /// various declarations within the given translation unit.
  CXCursor clang_getTranslationUnitCursor(CXTranslationUnit arg0) {
    return _clang_getTranslationUnitCursor(arg0);
  }

  late final _clang_getTranslationUnitCursorPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTranslationUnitCursor>>(
        'clang_getTranslationUnitCursor',
      );
  late final _clang_getTranslationUnitCursor =
      _clang_getTranslationUnitCursorPtr
          .asFunction<DartClang_getTranslationUnitCursor>();

  /// Determine whether two cursors are equivalent.
  int clang_equalCursors(CXCursor arg0, CXCursor arg1) {
    return _clang_equalCursors(arg0, arg1);
  }

  late final _clang_equalCursorsPtr =
      _lookup<ffi.NativeFunction<NativeClang_equalCursors>>(
        'clang_equalCursors',
      );
  late final _clang_equalCursors = _clang_equalCursorsPtr
      .asFunction<DartClang_equalCursors>();

  /// Returns non-zero if \p cursor is null.
  int clang_Cursor_isNull(CXCursor cursor) {
    return _clang_Cursor_isNull(cursor);
  }

  late final _clang_Cursor_isNullPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isNull>>(
        'clang_Cursor_isNull',
      );
  late final _clang_Cursor_isNull = _clang_Cursor_isNullPtr
      .asFunction<DartClang_Cursor_isNull>();

  /// Compute a hash value for the given cursor.
  int clang_hashCursor(CXCursor arg0) {
    return _clang_hashCursor(arg0);
  }

  late final _clang_hashCursorPtr =
      _lookup<ffi.NativeFunction<NativeClang_hashCursor>>('clang_hashCursor');
  late final _clang_hashCursor = _clang_hashCursorPtr
      .asFunction<DartClang_hashCursor>();

  /// Retrieve the kind of the given cursor.
  CXCursorKind clang_getCursorKind(CXCursor arg0) {
    return CXCursorKind.fromValue(_clang_getCursorKind(arg0));
  }

  late final _clang_getCursorKindPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorKind>>(
        'clang_getCursorKind',
      );
  late final _clang_getCursorKind = _clang_getCursorKindPtr
      .asFunction<DartClang_getCursorKind>();

  /// Determine whether the given cursor kind represents a declaration.
  int clang_isDeclaration(CXCursorKind arg0) {
    return _clang_isDeclaration(arg0.value);
  }

  late final _clang_isDeclarationPtr =
      _lookup<ffi.NativeFunction<NativeClang_isDeclaration>>(
        'clang_isDeclaration',
      );
  late final _clang_isDeclaration = _clang_isDeclarationPtr
      .asFunction<DartClang_isDeclaration>();

  /// Determine whether the given declaration is invalid.
  ///
  /// A declaration is invalid if it could not be parsed successfully.
  ///
  /// \returns non-zero if the cursor represents a declaration and it is
  /// invalid, otherwise NULL.
  int clang_isInvalidDeclaration(CXCursor arg0) {
    return _clang_isInvalidDeclaration(arg0);
  }

  late final _clang_isInvalidDeclarationPtr =
      _lookup<ffi.NativeFunction<NativeClang_isInvalidDeclaration>>(
        'clang_isInvalidDeclaration',
      );
  late final _clang_isInvalidDeclaration = _clang_isInvalidDeclarationPtr
      .asFunction<DartClang_isInvalidDeclaration>();

  /// Determine whether the given cursor kind represents a simple
  /// reference.
  ///
  /// Note that other kinds of cursors (such as expressions) can also refer to
  /// other cursors. Use clang_getCursorReferenced() to determine whether a
  /// particular cursor refers to another entity.
  int clang_isReference(CXCursorKind arg0) {
    return _clang_isReference(arg0.value);
  }

  late final _clang_isReferencePtr =
      _lookup<ffi.NativeFunction<NativeClang_isReference>>('clang_isReference');
  late final _clang_isReference = _clang_isReferencePtr
      .asFunction<DartClang_isReference>();

  /// Determine whether the given cursor kind represents an expression.
  int clang_isExpression(CXCursorKind arg0) {
    return _clang_isExpression(arg0.value);
  }

  late final _clang_isExpressionPtr =
      _lookup<ffi.NativeFunction<NativeClang_isExpression>>(
        'clang_isExpression',
      );
  late final _clang_isExpression = _clang_isExpressionPtr
      .asFunction<DartClang_isExpression>();

  /// Determine whether the given cursor kind represents a statement.
  int clang_isStatement(CXCursorKind arg0) {
    return _clang_isStatement(arg0.value);
  }

  late final _clang_isStatementPtr =
      _lookup<ffi.NativeFunction<NativeClang_isStatement>>('clang_isStatement');
  late final _clang_isStatement = _clang_isStatementPtr
      .asFunction<DartClang_isStatement>();

  /// Determine whether the given cursor kind represents an attribute.
  int clang_isAttribute(CXCursorKind arg0) {
    return _clang_isAttribute(arg0.value);
  }

  late final _clang_isAttributePtr =
      _lookup<ffi.NativeFunction<NativeClang_isAttribute>>('clang_isAttribute');
  late final _clang_isAttribute = _clang_isAttributePtr
      .asFunction<DartClang_isAttribute>();

  /// Determine whether the given cursor has any attributes.
  int clang_Cursor_hasAttrs(CXCursor C) {
    return _clang_Cursor_hasAttrs(C);
  }

  late final _clang_Cursor_hasAttrsPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_hasAttrs>>(
        'clang_Cursor_hasAttrs',
      );
  late final _clang_Cursor_hasAttrs = _clang_Cursor_hasAttrsPtr
      .asFunction<DartClang_Cursor_hasAttrs>();

  /// Determine whether the given cursor kind represents an invalid
  /// cursor.
  int clang_isInvalid(CXCursorKind arg0) {
    return _clang_isInvalid(arg0.value);
  }

  late final _clang_isInvalidPtr =
      _lookup<ffi.NativeFunction<NativeClang_isInvalid>>('clang_isInvalid');
  late final _clang_isInvalid = _clang_isInvalidPtr
      .asFunction<DartClang_isInvalid>();

  /// Determine whether the given cursor kind represents a translation
  /// unit.
  int clang_isTranslationUnit(CXCursorKind arg0) {
    return _clang_isTranslationUnit(arg0.value);
  }

  late final _clang_isTranslationUnitPtr =
      _lookup<ffi.NativeFunction<NativeClang_isTranslationUnit>>(
        'clang_isTranslationUnit',
      );
  late final _clang_isTranslationUnit = _clang_isTranslationUnitPtr
      .asFunction<DartClang_isTranslationUnit>();

  /// Determine whether the given cursor represents a preprocessing
  /// element, such as a preprocessor directive or macro instantiation.
  int clang_isPreprocessing(CXCursorKind arg0) {
    return _clang_isPreprocessing(arg0.value);
  }

  late final _clang_isPreprocessingPtr =
      _lookup<ffi.NativeFunction<NativeClang_isPreprocessing>>(
        'clang_isPreprocessing',
      );
  late final _clang_isPreprocessing = _clang_isPreprocessingPtr
      .asFunction<DartClang_isPreprocessing>();

  /// Determine whether the given cursor represents a currently
  /// unexposed piece of the AST (e.g., CXCursor_UnexposedStmt).
  int clang_isUnexposed(CXCursorKind arg0) {
    return _clang_isUnexposed(arg0.value);
  }

  late final _clang_isUnexposedPtr =
      _lookup<ffi.NativeFunction<NativeClang_isUnexposed>>('clang_isUnexposed');
  late final _clang_isUnexposed = _clang_isUnexposedPtr
      .asFunction<DartClang_isUnexposed>();

  /// Determine the linkage of the entity referred to by a given cursor.
  CXLinkageKind clang_getCursorLinkage(CXCursor cursor) {
    return CXLinkageKind.fromValue(_clang_getCursorLinkage(cursor));
  }

  late final _clang_getCursorLinkagePtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorLinkage>>(
        'clang_getCursorLinkage',
      );
  late final _clang_getCursorLinkage = _clang_getCursorLinkagePtr
      .asFunction<DartClang_getCursorLinkage>();

  /// Describe the visibility of the entity referred to by a cursor.
  ///
  /// This returns the default visibility if not explicitly specified by
  /// a visibility attribute. The default visibility may be changed by
  /// commandline arguments.
  ///
  /// \param cursor The cursor to query.
  ///
  /// \returns The visibility of the cursor.
  CXVisibilityKind clang_getCursorVisibility(CXCursor cursor) {
    return CXVisibilityKind.fromValue(_clang_getCursorVisibility(cursor));
  }

  late final _clang_getCursorVisibilityPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorVisibility>>(
        'clang_getCursorVisibility',
      );
  late final _clang_getCursorVisibility = _clang_getCursorVisibilityPtr
      .asFunction<DartClang_getCursorVisibility>();

  /// Determine the availability of the entity that this cursor refers to,
  /// taking the current target platform into account.
  ///
  /// \param cursor The cursor to query.
  ///
  /// \returns The availability of the cursor.
  CXAvailabilityKind clang_getCursorAvailability(CXCursor cursor) {
    return CXAvailabilityKind.fromValue(_clang_getCursorAvailability(cursor));
  }

  late final _clang_getCursorAvailabilityPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorAvailability>>(
        'clang_getCursorAvailability',
      );
  late final _clang_getCursorAvailability = _clang_getCursorAvailabilityPtr
      .asFunction<DartClang_getCursorAvailability>();

  /// Determine the availability of the entity that this cursor refers to
  /// on any platforms for which availability information is known.
  ///
  /// \param cursor The cursor to query.
  ///
  /// \param always_deprecated If non-NULL, will be set to indicate whether the
  /// entity is deprecated on all platforms.
  ///
  /// \param deprecated_message If non-NULL, will be set to the message text
  /// provided along with the unconditional deprecation of this entity. The client
  /// is responsible for deallocating this string.
  ///
  /// \param always_unavailable If non-NULL, will be set to indicate whether the
  /// entity is unavailable on all platforms.
  ///
  /// \param unavailable_message If non-NULL, will be set to the message text
  /// provided along with the unconditional unavailability of this entity. The
  /// client is responsible for deallocating this string.
  ///
  /// \param availability If non-NULL, an array of CXPlatformAvailability instances
  /// that will be populated with platform availability information, up to either
  /// the number of platforms for which availability information is available (as
  /// returned by this function) or \c availability_size, whichever is smaller.
  ///
  /// \param availability_size The number of elements available in the
  /// \c availability array.
  ///
  /// \returns The number of platforms (N) for which availability information is
  /// available (which is unrelated to \c availability_size).
  ///
  /// Note that the client is responsible for calling
  /// \c clang_disposeCXPlatformAvailability to free each of the
  /// platform-availability structures returned. There are
  /// \c min(N, availability_size) such structures.
  int clang_getCursorPlatformAvailability(
    CXCursor cursor,
    ffi.Pointer<ffi.Int> always_deprecated,
    ffi.Pointer<CXString> deprecated_message,
    ffi.Pointer<ffi.Int> always_unavailable,
    ffi.Pointer<CXString> unavailable_message,
    ffi.Pointer<CXPlatformAvailability> availability,
    int availability_size,
  ) {
    return _clang_getCursorPlatformAvailability(
      cursor,
      always_deprecated,
      deprecated_message,
      always_unavailable,
      unavailable_message,
      availability,
      availability_size,
    );
  }

  late final _clang_getCursorPlatformAvailabilityPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorPlatformAvailability>>(
        'clang_getCursorPlatformAvailability',
      );
  late final _clang_getCursorPlatformAvailability =
      _clang_getCursorPlatformAvailabilityPtr
          .asFunction<DartClang_getCursorPlatformAvailability>();

  /// Free the memory associated with a \c CXPlatformAvailability structure.
  void clang_disposeCXPlatformAvailability(
    ffi.Pointer<CXPlatformAvailability> availability,
  ) {
    return _clang_disposeCXPlatformAvailability(availability);
  }

  late final _clang_disposeCXPlatformAvailabilityPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeCXPlatformAvailability>>(
        'clang_disposeCXPlatformAvailability',
      );
  late final _clang_disposeCXPlatformAvailability =
      _clang_disposeCXPlatformAvailabilityPtr
          .asFunction<DartClang_disposeCXPlatformAvailability>();

  /// Determine the "language" of the entity referred to by a given cursor.
  CXLanguageKind clang_getCursorLanguage(CXCursor cursor) {
    return CXLanguageKind.fromValue(_clang_getCursorLanguage(cursor));
  }

  late final _clang_getCursorLanguagePtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorLanguage>>(
        'clang_getCursorLanguage',
      );
  late final _clang_getCursorLanguage = _clang_getCursorLanguagePtr
      .asFunction<DartClang_getCursorLanguage>();

  /// Determine the "thread-local storage (TLS) kind" of the declaration
  /// referred to by a cursor.
  CXTLSKind clang_getCursorTLSKind(CXCursor cursor) {
    return CXTLSKind.fromValue(_clang_getCursorTLSKind(cursor));
  }

  late final _clang_getCursorTLSKindPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorTLSKind>>(
        'clang_getCursorTLSKind',
      );
  late final _clang_getCursorTLSKind = _clang_getCursorTLSKindPtr
      .asFunction<DartClang_getCursorTLSKind>();

  /// Returns the translation unit that a cursor originated from.
  CXTranslationUnit clang_Cursor_getTranslationUnit(CXCursor arg0) {
    return _clang_Cursor_getTranslationUnit(arg0);
  }

  late final _clang_Cursor_getTranslationUnitPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getTranslationUnit>>(
        'clang_Cursor_getTranslationUnit',
      );
  late final _clang_Cursor_getTranslationUnit =
      _clang_Cursor_getTranslationUnitPtr
          .asFunction<DartClang_Cursor_getTranslationUnit>();

  /// Creates an empty CXCursorSet.
  CXCursorSet clang_createCXCursorSet() {
    return _clang_createCXCursorSet();
  }

  late final _clang_createCXCursorSetPtr =
      _lookup<ffi.NativeFunction<NativeClang_createCXCursorSet>>(
        'clang_createCXCursorSet',
      );
  late final _clang_createCXCursorSet = _clang_createCXCursorSetPtr
      .asFunction<DartClang_createCXCursorSet>();

  /// Disposes a CXCursorSet and releases its associated memory.
  void clang_disposeCXCursorSet(CXCursorSet cset) {
    return _clang_disposeCXCursorSet(cset);
  }

  late final _clang_disposeCXCursorSetPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeCXCursorSet>>(
        'clang_disposeCXCursorSet',
      );
  late final _clang_disposeCXCursorSet = _clang_disposeCXCursorSetPtr
      .asFunction<DartClang_disposeCXCursorSet>();

  /// Queries a CXCursorSet to see if it contains a specific CXCursor.
  ///
  /// \returns non-zero if the set contains the specified cursor.
  int clang_CXCursorSet_contains(CXCursorSet cset, CXCursor cursor) {
    return _clang_CXCursorSet_contains(cset, cursor);
  }

  late final _clang_CXCursorSet_containsPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXCursorSet_contains>>(
        'clang_CXCursorSet_contains',
      );
  late final _clang_CXCursorSet_contains = _clang_CXCursorSet_containsPtr
      .asFunction<DartClang_CXCursorSet_contains>();

  /// Inserts a CXCursor into a CXCursorSet.
  ///
  /// \returns zero if the CXCursor was already in the set, and non-zero otherwise.
  int clang_CXCursorSet_insert(CXCursorSet cset, CXCursor cursor) {
    return _clang_CXCursorSet_insert(cset, cursor);
  }

  late final _clang_CXCursorSet_insertPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXCursorSet_insert>>(
        'clang_CXCursorSet_insert',
      );
  late final _clang_CXCursorSet_insert = _clang_CXCursorSet_insertPtr
      .asFunction<DartClang_CXCursorSet_insert>();

  /// Determine the semantic parent of the given cursor.
  ///
  /// The semantic parent of a cursor is the cursor that semantically contains
  /// the given \p cursor. For many declarations, the lexical and semantic parents
  /// are equivalent (the lexical parent is returned by
  /// \c clang_getCursorLexicalParent()). They diverge when declarations or
  /// definitions are provided out-of-line. For example:
  ///
  /// \code
  /// class C {
  /// void f();
  /// };
  ///
  /// void C::f() { }
  /// \endcode
  ///
  /// In the out-of-line definition of \c C::f, the semantic parent is
  /// the class \c C, of which this function is a member. The lexical parent is
  /// the place where the declaration actually occurs in the source code; in this
  /// case, the definition occurs in the translation unit. In general, the
  /// lexical parent for a given entity can change without affecting the semantics
  /// of the program, and the lexical parent of different declarations of the
  /// same entity may be different. Changing the semantic parent of a declaration,
  /// on the other hand, can have a major impact on semantics, and redeclarations
  /// of a particular entity should all have the same semantic context.
  ///
  /// In the example above, both declarations of \c C::f have \c C as their
  /// semantic context, while the lexical context of the first \c C::f is \c C
  /// and the lexical context of the second \c C::f is the translation unit.
  ///
  /// For global declarations, the semantic parent is the translation unit.
  CXCursor clang_getCursorSemanticParent(CXCursor cursor) {
    return _clang_getCursorSemanticParent(cursor);
  }

  late final _clang_getCursorSemanticParentPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorSemanticParent>>(
        'clang_getCursorSemanticParent',
      );
  late final _clang_getCursorSemanticParent = _clang_getCursorSemanticParentPtr
      .asFunction<DartClang_getCursorSemanticParent>();

  /// Determine the lexical parent of the given cursor.
  ///
  /// The lexical parent of a cursor is the cursor in which the given \p cursor
  /// was actually written. For many declarations, the lexical and semantic parents
  /// are equivalent (the semantic parent is returned by
  /// \c clang_getCursorSemanticParent()). They diverge when declarations or
  /// definitions are provided out-of-line. For example:
  ///
  /// \code
  /// class C {
  /// void f();
  /// };
  ///
  /// void C::f() { }
  /// \endcode
  ///
  /// In the out-of-line definition of \c C::f, the semantic parent is
  /// the class \c C, of which this function is a member. The lexical parent is
  /// the place where the declaration actually occurs in the source code; in this
  /// case, the definition occurs in the translation unit. In general, the
  /// lexical parent for a given entity can change without affecting the semantics
  /// of the program, and the lexical parent of different declarations of the
  /// same entity may be different. Changing the semantic parent of a declaration,
  /// on the other hand, can have a major impact on semantics, and redeclarations
  /// of a particular entity should all have the same semantic context.
  ///
  /// In the example above, both declarations of \c C::f have \c C as their
  /// semantic context, while the lexical context of the first \c C::f is \c C
  /// and the lexical context of the second \c C::f is the translation unit.
  ///
  /// For declarations written in the global scope, the lexical parent is
  /// the translation unit.
  CXCursor clang_getCursorLexicalParent(CXCursor cursor) {
    return _clang_getCursorLexicalParent(cursor);
  }

  late final _clang_getCursorLexicalParentPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorLexicalParent>>(
        'clang_getCursorLexicalParent',
      );
  late final _clang_getCursorLexicalParent = _clang_getCursorLexicalParentPtr
      .asFunction<DartClang_getCursorLexicalParent>();

  /// Determine the set of methods that are overridden by the given
  /// method.
  ///
  /// In both Objective-C and C++, a method (aka virtual member function,
  /// in C++) can override a virtual method in a base class. For
  /// Objective-C, a method is said to override any method in the class's
  /// base class, its protocols, or its categories' protocols, that has the same
  /// selector and is of the same kind (class or instance).
  /// If no such method exists, the search continues to the class's superclass,
  /// its protocols, and its categories, and so on. A method from an Objective-C
  /// implementation is considered to override the same methods as its
  /// corresponding method in the interface.
  ///
  /// For C++, a virtual member function overrides any virtual member
  /// function with the same signature that occurs in its base
  /// classes. With multiple inheritance, a virtual member function can
  /// override several virtual member functions coming from different
  /// base classes.
  ///
  /// In all cases, this function determines the immediate overridden
  /// method, rather than all of the overridden methods. For example, if
  /// a method is originally declared in a class A, then overridden in B
  /// (which in inherits from A) and also in C (which inherited from B),
  /// then the only overridden method returned from this function when
  /// invoked on C's method will be B's method. The client may then
  /// invoke this function again, given the previously-found overridden
  /// methods, to map out the complete method-override set.
  ///
  /// \param cursor A cursor representing an Objective-C or C++
  /// method. This routine will compute the set of methods that this
  /// method overrides.
  ///
  /// \param overridden A pointer whose pointee will be replaced with a
  /// pointer to an array of cursors, representing the set of overridden
  /// methods. If there are no overridden methods, the pointee will be
  /// set to NULL. The pointee must be freed via a call to
  /// \c clang_disposeOverriddenCursors().
  ///
  /// \param num_overridden A pointer to the number of overridden
  /// functions, will be set to the number of overridden functions in the
  /// array pointed to by \p overridden.
  void clang_getOverriddenCursors(
    CXCursor cursor,
    ffi.Pointer<ffi.Pointer<CXCursor>> overridden,
    ffi.Pointer<ffi.UnsignedInt> num_overridden,
  ) {
    return _clang_getOverriddenCursors(cursor, overridden, num_overridden);
  }

  late final _clang_getOverriddenCursorsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getOverriddenCursors>>(
        'clang_getOverriddenCursors',
      );
  late final _clang_getOverriddenCursors = _clang_getOverriddenCursorsPtr
      .asFunction<DartClang_getOverriddenCursors>();

  /// Free the set of overridden cursors returned by \c
  /// clang_getOverriddenCursors().
  void clang_disposeOverriddenCursors(ffi.Pointer<CXCursor> overridden) {
    return _clang_disposeOverriddenCursors(overridden);
  }

  late final _clang_disposeOverriddenCursorsPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeOverriddenCursors>>(
        'clang_disposeOverriddenCursors',
      );
  late final _clang_disposeOverriddenCursors =
      _clang_disposeOverriddenCursorsPtr
          .asFunction<DartClang_disposeOverriddenCursors>();

  /// Retrieve the file that is included by the given inclusion directive
  /// cursor.
  CXFile clang_getIncludedFile(CXCursor cursor) {
    return _clang_getIncludedFile(cursor);
  }

  late final _clang_getIncludedFilePtr =
      _lookup<ffi.NativeFunction<NativeClang_getIncludedFile>>(
        'clang_getIncludedFile',
      );
  late final _clang_getIncludedFile = _clang_getIncludedFilePtr
      .asFunction<DartClang_getIncludedFile>();

  /// Map a source location to the cursor that describes the entity at that
  /// location in the source code.
  ///
  /// clang_getCursor() maps an arbitrary source location within a translation
  /// unit down to the most specific cursor that describes the entity at that
  /// location. For example, given an expression \c x + y, invoking
  /// clang_getCursor() with a source location pointing to "x" will return the
  /// cursor for "x"; similarly for "y". If the cursor points anywhere between
  /// "x" or "y" (e.g., on the + or the whitespace around it), clang_getCursor()
  /// will return a cursor referring to the "+" expression.
  ///
  /// \returns a cursor representing the entity at the given source location, or
  /// a NULL cursor if no such entity can be found.
  CXCursor clang_getCursor(CXTranslationUnit arg0, CXSourceLocation arg1) {
    return _clang_getCursor(arg0, arg1);
  }

  late final _clang_getCursorPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursor>>('clang_getCursor');
  late final _clang_getCursor = _clang_getCursorPtr
      .asFunction<DartClang_getCursor>();

  /// Retrieve the physical location of the source constructor referenced
  /// by the given cursor.
  ///
  /// The location of a declaration is typically the location of the name of that
  /// declaration, where the name of that declaration would occur if it is
  /// unnamed, or some keyword that introduces that particular declaration.
  /// The location of a reference is where that reference occurs within the
  /// source code.
  CXSourceLocation clang_getCursorLocation(CXCursor arg0) {
    return _clang_getCursorLocation(arg0);
  }

  late final _clang_getCursorLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorLocation>>(
        'clang_getCursorLocation',
      );
  late final _clang_getCursorLocation = _clang_getCursorLocationPtr
      .asFunction<DartClang_getCursorLocation>();

  /// Retrieve the physical extent of the source construct referenced by
  /// the given cursor.
  ///
  /// The extent of a cursor starts with the file/line/column pointing at the
  /// first character within the source construct that the cursor refers to and
  /// ends with the last character within that source construct. For a
  /// declaration, the extent covers the declaration itself. For a reference,
  /// the extent covers the location of the reference (e.g., where the referenced
  /// entity was actually used).
  CXSourceRange clang_getCursorExtent(CXCursor arg0) {
    return _clang_getCursorExtent(arg0);
  }

  late final _clang_getCursorExtentPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorExtent>>(
        'clang_getCursorExtent',
      );
  late final _clang_getCursorExtent = _clang_getCursorExtentPtr
      .asFunction<DartClang_getCursorExtent>();

  /// Retrieve the type of a CXCursor (if any).
  CXType clang_getCursorType(CXCursor C) {
    return _clang_getCursorType(C);
  }

  late final _clang_getCursorTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorType>>(
        'clang_getCursorType',
      );
  late final _clang_getCursorType = _clang_getCursorTypePtr
      .asFunction<DartClang_getCursorType>();

  /// Pretty-print the underlying type using the rules of the
  /// language of the translation unit from which it came.
  ///
  /// If the type is invalid, an empty string is returned.
  CXString clang_getTypeSpelling(CXType CT) {
    return _clang_getTypeSpelling(CT);
  }

  late final _clang_getTypeSpellingPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTypeSpelling>>(
        'clang_getTypeSpelling',
      );
  late final _clang_getTypeSpelling = _clang_getTypeSpellingPtr
      .asFunction<DartClang_getTypeSpelling>();

  /// Retrieve the underlying type of a typedef declaration.
  ///
  /// If the cursor does not reference a typedef declaration, an invalid type is
  /// returned.
  CXType clang_getTypedefDeclUnderlyingType(CXCursor C) {
    return _clang_getTypedefDeclUnderlyingType(C);
  }

  late final _clang_getTypedefDeclUnderlyingTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getTypedefDeclUnderlyingType>>(
        'clang_getTypedefDeclUnderlyingType',
      );
  late final _clang_getTypedefDeclUnderlyingType =
      _clang_getTypedefDeclUnderlyingTypePtr
          .asFunction<DartClang_getTypedefDeclUnderlyingType>();

  /// Retrieve the integer type of an enum declaration.
  ///
  /// If the cursor does not reference an enum declaration, an invalid type is
  /// returned.
  CXType clang_getEnumDeclIntegerType(CXCursor C) {
    return _clang_getEnumDeclIntegerType(C);
  }

  late final _clang_getEnumDeclIntegerTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getEnumDeclIntegerType>>(
        'clang_getEnumDeclIntegerType',
      );
  late final _clang_getEnumDeclIntegerType = _clang_getEnumDeclIntegerTypePtr
      .asFunction<DartClang_getEnumDeclIntegerType>();

  /// Retrieve the integer value of an enum constant declaration as a signed
  /// long long.
  ///
  /// If the cursor does not reference an enum constant declaration, LLONG_MIN is returned.
  /// Since this is also potentially a valid constant value, the kind of the cursor
  /// must be verified before calling this function.
  int clang_getEnumConstantDeclValue(CXCursor C) {
    return _clang_getEnumConstantDeclValue(C);
  }

  late final _clang_getEnumConstantDeclValuePtr =
      _lookup<ffi.NativeFunction<NativeClang_getEnumConstantDeclValue>>(
        'clang_getEnumConstantDeclValue',
      );
  late final _clang_getEnumConstantDeclValue =
      _clang_getEnumConstantDeclValuePtr
          .asFunction<DartClang_getEnumConstantDeclValue>();

  /// Retrieve the integer value of an enum constant declaration as an unsigned
  /// long long.
  ///
  /// If the cursor does not reference an enum constant declaration, ULLONG_MAX is returned.
  /// Since this is also potentially a valid constant value, the kind of the cursor
  /// must be verified before calling this function.
  int clang_getEnumConstantDeclUnsignedValue(CXCursor C) {
    return _clang_getEnumConstantDeclUnsignedValue(C);
  }

  late final _clang_getEnumConstantDeclUnsignedValuePtr =
      _lookup<ffi.NativeFunction<NativeClang_getEnumConstantDeclUnsignedValue>>(
        'clang_getEnumConstantDeclUnsignedValue',
      );
  late final _clang_getEnumConstantDeclUnsignedValue =
      _clang_getEnumConstantDeclUnsignedValuePtr
          .asFunction<DartClang_getEnumConstantDeclUnsignedValue>();

  /// Retrieve the bit width of a bit field declaration as an integer.
  ///
  /// If a cursor that is not a bit field declaration is passed in, -1 is returned.
  int clang_getFieldDeclBitWidth(CXCursor C) {
    return _clang_getFieldDeclBitWidth(C);
  }

  late final _clang_getFieldDeclBitWidthPtr =
      _lookup<ffi.NativeFunction<NativeClang_getFieldDeclBitWidth>>(
        'clang_getFieldDeclBitWidth',
      );
  late final _clang_getFieldDeclBitWidth = _clang_getFieldDeclBitWidthPtr
      .asFunction<DartClang_getFieldDeclBitWidth>();

  /// Retrieve the number of non-variadic arguments associated with a given
  /// cursor.
  ///
  /// The number of arguments can be determined for calls as well as for
  /// declarations of functions or methods. For other cursors -1 is returned.
  int clang_Cursor_getNumArguments(CXCursor C) {
    return _clang_Cursor_getNumArguments(C);
  }

  late final _clang_Cursor_getNumArgumentsPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getNumArguments>>(
        'clang_Cursor_getNumArguments',
      );
  late final _clang_Cursor_getNumArguments = _clang_Cursor_getNumArgumentsPtr
      .asFunction<DartClang_Cursor_getNumArguments>();

  /// Retrieve the argument cursor of a function or method.
  ///
  /// The argument cursor can be determined for calls as well as for declarations
  /// of functions or methods. For other cursors and for invalid indices, an
  /// invalid cursor is returned.
  CXCursor clang_Cursor_getArgument(CXCursor C, int i) {
    return _clang_Cursor_getArgument(C, i);
  }

  late final _clang_Cursor_getArgumentPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getArgument>>(
        'clang_Cursor_getArgument',
      );
  late final _clang_Cursor_getArgument = _clang_Cursor_getArgumentPtr
      .asFunction<DartClang_Cursor_getArgument>();

  /// Returns the number of template args of a function decl representing a
  /// template specialization.
  ///
  /// If the argument cursor cannot be converted into a template function
  /// declaration, -1 is returned.
  ///
  /// For example, for the following declaration and specialization:
  /// template <typename T, int kInt, bool kBool>
  /// void foo() { ... }
  ///
  /// template <>
  /// void foo<float, -7, true>();
  ///
  /// The value 3 would be returned from this call.
  int clang_Cursor_getNumTemplateArguments(CXCursor C) {
    return _clang_Cursor_getNumTemplateArguments(C);
  }

  late final _clang_Cursor_getNumTemplateArgumentsPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getNumTemplateArguments>>(
        'clang_Cursor_getNumTemplateArguments',
      );
  late final _clang_Cursor_getNumTemplateArguments =
      _clang_Cursor_getNumTemplateArgumentsPtr
          .asFunction<DartClang_Cursor_getNumTemplateArguments>();

  /// Retrieve the kind of the I'th template argument of the CXCursor C.
  ///
  /// If the argument CXCursor does not represent a FunctionDecl, an invalid
  /// template argument kind is returned.
  ///
  /// For example, for the following declaration and specialization:
  /// template <typename T, int kInt, bool kBool>
  /// void foo() { ... }
  ///
  /// template <>
  /// void foo<float, -7, true>();
  ///
  /// For I = 0, 1, and 2, Type, Integral, and Integral will be returned,
  /// respectively.
  CXTemplateArgumentKind clang_Cursor_getTemplateArgumentKind(
    CXCursor C,
    int I,
  ) {
    return CXTemplateArgumentKind.fromValue(
      _clang_Cursor_getTemplateArgumentKind(C, I),
    );
  }

  late final _clang_Cursor_getTemplateArgumentKindPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getTemplateArgumentKind>>(
        'clang_Cursor_getTemplateArgumentKind',
      );
  late final _clang_Cursor_getTemplateArgumentKind =
      _clang_Cursor_getTemplateArgumentKindPtr
          .asFunction<DartClang_Cursor_getTemplateArgumentKind>();

  /// Retrieve a CXType representing the type of a TemplateArgument of a
  /// function decl representing a template specialization.
  ///
  /// If the argument CXCursor does not represent a FunctionDecl whose I'th
  /// template argument has a kind of CXTemplateArgKind_Integral, an invalid type
  /// is returned.
  ///
  /// For example, for the following declaration and specialization:
  /// template <typename T, int kInt, bool kBool>
  /// void foo() { ... }
  ///
  /// template <>
  /// void foo<float, -7, true>();
  ///
  /// If called with I = 0, "float", will be returned.
  /// Invalid types will be returned for I == 1 or 2.
  CXType clang_Cursor_getTemplateArgumentType(CXCursor C, int I) {
    return _clang_Cursor_getTemplateArgumentType(C, I);
  }

  late final _clang_Cursor_getTemplateArgumentTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getTemplateArgumentType>>(
        'clang_Cursor_getTemplateArgumentType',
      );
  late final _clang_Cursor_getTemplateArgumentType =
      _clang_Cursor_getTemplateArgumentTypePtr
          .asFunction<DartClang_Cursor_getTemplateArgumentType>();

  /// Retrieve the value of an Integral TemplateArgument (of a function
  /// decl representing a template specialization) as a signed long long.
  ///
  /// It is undefined to call this function on a CXCursor that does not represent a
  /// FunctionDecl or whose I'th template argument is not an integral value.
  ///
  /// For example, for the following declaration and specialization:
  /// template <typename T, int kInt, bool kBool>
  /// void foo() { ... }
  ///
  /// template <>
  /// void foo<float, -7, true>();
  ///
  /// If called with I = 1 or 2, -7 or true will be returned, respectively.
  /// For I == 0, this function's behavior is undefined.
  int clang_Cursor_getTemplateArgumentValue(CXCursor C, int I) {
    return _clang_Cursor_getTemplateArgumentValue(C, I);
  }

  late final _clang_Cursor_getTemplateArgumentValuePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getTemplateArgumentValue>>(
        'clang_Cursor_getTemplateArgumentValue',
      );
  late final _clang_Cursor_getTemplateArgumentValue =
      _clang_Cursor_getTemplateArgumentValuePtr
          .asFunction<DartClang_Cursor_getTemplateArgumentValue>();

  /// Retrieve the value of an Integral TemplateArgument (of a function
  /// decl representing a template specialization) as an unsigned long long.
  ///
  /// It is undefined to call this function on a CXCursor that does not represent a
  /// FunctionDecl or whose I'th template argument is not an integral value.
  ///
  /// For example, for the following declaration and specialization:
  /// template <typename T, int kInt, bool kBool>
  /// void foo() { ... }
  ///
  /// template <>
  /// void foo<float, 2147483649, true>();
  ///
  /// If called with I = 1 or 2, 2147483649 or true will be returned, respectively.
  /// For I == 0, this function's behavior is undefined.
  int clang_Cursor_getTemplateArgumentUnsignedValue(CXCursor C, int I) {
    return _clang_Cursor_getTemplateArgumentUnsignedValue(C, I);
  }

  late final _clang_Cursor_getTemplateArgumentUnsignedValuePtr =
      _lookup<
        ffi.NativeFunction<NativeClang_Cursor_getTemplateArgumentUnsignedValue>
      >('clang_Cursor_getTemplateArgumentUnsignedValue');
  late final _clang_Cursor_getTemplateArgumentUnsignedValue =
      _clang_Cursor_getTemplateArgumentUnsignedValuePtr
          .asFunction<DartClang_Cursor_getTemplateArgumentUnsignedValue>();

  /// Determine whether two CXTypes represent the same type.
  ///
  /// \returns non-zero if the CXTypes represent the same type and
  /// zero otherwise.
  int clang_equalTypes(CXType A, CXType B) {
    return _clang_equalTypes(A, B);
  }

  late final _clang_equalTypesPtr =
      _lookup<ffi.NativeFunction<NativeClang_equalTypes>>('clang_equalTypes');
  late final _clang_equalTypes = _clang_equalTypesPtr
      .asFunction<DartClang_equalTypes>();

  /// Return the canonical type for a CXType.
  ///
  /// Clang's type system explicitly models typedefs and all the ways
  /// a specific type can be represented.  The canonical type is the underlying
  /// type with all the "sugar" removed.  For example, if 'T' is a typedef
  /// for 'int', the canonical type for 'T' would be 'int'.
  CXType clang_getCanonicalType(CXType T) {
    return _clang_getCanonicalType(T);
  }

  late final _clang_getCanonicalTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getCanonicalType>>(
        'clang_getCanonicalType',
      );
  late final _clang_getCanonicalType = _clang_getCanonicalTypePtr
      .asFunction<DartClang_getCanonicalType>();

  /// Determine whether a CXType has the "const" qualifier set,
  /// without looking through typedefs that may have added "const" at a
  /// different level.
  int clang_isConstQualifiedType(CXType T) {
    return _clang_isConstQualifiedType(T);
  }

  late final _clang_isConstQualifiedTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_isConstQualifiedType>>(
        'clang_isConstQualifiedType',
      );
  late final _clang_isConstQualifiedType = _clang_isConstQualifiedTypePtr
      .asFunction<DartClang_isConstQualifiedType>();

  /// Determine whether a  CXCursor that is a macro, is
  /// function like.
  int clang_Cursor_isMacroFunctionLike(CXCursor C) {
    return _clang_Cursor_isMacroFunctionLike(C);
  }

  late final _clang_Cursor_isMacroFunctionLikePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isMacroFunctionLike>>(
        'clang_Cursor_isMacroFunctionLike',
      );
  late final _clang_Cursor_isMacroFunctionLike =
      _clang_Cursor_isMacroFunctionLikePtr
          .asFunction<DartClang_Cursor_isMacroFunctionLike>();

  /// Determine whether a  CXCursor that is a macro, is a
  /// builtin one.
  int clang_Cursor_isMacroBuiltin(CXCursor C) {
    return _clang_Cursor_isMacroBuiltin(C);
  }

  late final _clang_Cursor_isMacroBuiltinPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isMacroBuiltin>>(
        'clang_Cursor_isMacroBuiltin',
      );
  late final _clang_Cursor_isMacroBuiltin = _clang_Cursor_isMacroBuiltinPtr
      .asFunction<DartClang_Cursor_isMacroBuiltin>();

  /// Determine whether a  CXCursor that is a function declaration, is an
  /// inline declaration.
  int clang_Cursor_isFunctionInlined(CXCursor C) {
    return _clang_Cursor_isFunctionInlined(C);
  }

  late final _clang_Cursor_isFunctionInlinedPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isFunctionInlined>>(
        'clang_Cursor_isFunctionInlined',
      );
  late final _clang_Cursor_isFunctionInlined =
      _clang_Cursor_isFunctionInlinedPtr
          .asFunction<DartClang_Cursor_isFunctionInlined>();

  /// Determine whether a CXType has the "volatile" qualifier set,
  /// without looking through typedefs that may have added "volatile" at
  /// a different level.
  int clang_isVolatileQualifiedType(CXType T) {
    return _clang_isVolatileQualifiedType(T);
  }

  late final _clang_isVolatileQualifiedTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_isVolatileQualifiedType>>(
        'clang_isVolatileQualifiedType',
      );
  late final _clang_isVolatileQualifiedType = _clang_isVolatileQualifiedTypePtr
      .asFunction<DartClang_isVolatileQualifiedType>();

  /// Determine whether a CXType has the "restrict" qualifier set,
  /// without looking through typedefs that may have added "restrict" at a
  /// different level.
  int clang_isRestrictQualifiedType(CXType T) {
    return _clang_isRestrictQualifiedType(T);
  }

  late final _clang_isRestrictQualifiedTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_isRestrictQualifiedType>>(
        'clang_isRestrictQualifiedType',
      );
  late final _clang_isRestrictQualifiedType = _clang_isRestrictQualifiedTypePtr
      .asFunction<DartClang_isRestrictQualifiedType>();

  /// Returns the address space of the given type.
  int clang_getAddressSpace(CXType T) {
    return _clang_getAddressSpace(T);
  }

  late final _clang_getAddressSpacePtr =
      _lookup<ffi.NativeFunction<NativeClang_getAddressSpace>>(
        'clang_getAddressSpace',
      );
  late final _clang_getAddressSpace = _clang_getAddressSpacePtr
      .asFunction<DartClang_getAddressSpace>();

  /// Returns the typedef name of the given type.
  CXString clang_getTypedefName(CXType CT) {
    return _clang_getTypedefName(CT);
  }

  late final _clang_getTypedefNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_getTypedefName>>(
        'clang_getTypedefName',
      );
  late final _clang_getTypedefName = _clang_getTypedefNamePtr
      .asFunction<DartClang_getTypedefName>();

  /// For pointer types, returns the type of the pointee.
  CXType clang_getPointeeType(CXType T) {
    return _clang_getPointeeType(T);
  }

  late final _clang_getPointeeTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getPointeeType>>(
        'clang_getPointeeType',
      );
  late final _clang_getPointeeType = _clang_getPointeeTypePtr
      .asFunction<DartClang_getPointeeType>();

  /// Return the cursor for the declaration of the given type.
  CXCursor clang_getTypeDeclaration(CXType T) {
    return _clang_getTypeDeclaration(T);
  }

  late final _clang_getTypeDeclarationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTypeDeclaration>>(
        'clang_getTypeDeclaration',
      );
  late final _clang_getTypeDeclaration = _clang_getTypeDeclarationPtr
      .asFunction<DartClang_getTypeDeclaration>();

  /// Returns the Objective-C type encoding for the specified declaration.
  CXString clang_getDeclObjCTypeEncoding(CXCursor C) {
    return _clang_getDeclObjCTypeEncoding(C);
  }

  late final _clang_getDeclObjCTypeEncodingPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDeclObjCTypeEncoding>>(
        'clang_getDeclObjCTypeEncoding',
      );
  late final _clang_getDeclObjCTypeEncoding = _clang_getDeclObjCTypeEncodingPtr
      .asFunction<DartClang_getDeclObjCTypeEncoding>();

  /// Returns the Objective-C type encoding for the specified CXType.
  CXString clang_Type_getObjCEncoding(CXType type) {
    return _clang_Type_getObjCEncoding(type);
  }

  late final _clang_Type_getObjCEncodingPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getObjCEncoding>>(
        'clang_Type_getObjCEncoding',
      );
  late final _clang_Type_getObjCEncoding = _clang_Type_getObjCEncodingPtr
      .asFunction<DartClang_Type_getObjCEncoding>();

  /// Retrieve the spelling of a given CXTypeKind.
  CXString clang_getTypeKindSpelling(CXTypeKind K) {
    return _clang_getTypeKindSpelling(K.value);
  }

  late final _clang_getTypeKindSpellingPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTypeKindSpelling>>(
        'clang_getTypeKindSpelling',
      );
  late final _clang_getTypeKindSpelling = _clang_getTypeKindSpellingPtr
      .asFunction<DartClang_getTypeKindSpelling>();

  /// Retrieve the calling convention associated with a function type.
  ///
  /// If a non-function type is passed in, CXCallingConv_Invalid is returned.
  CXCallingConv clang_getFunctionTypeCallingConv(CXType T) {
    return CXCallingConv.fromValue(_clang_getFunctionTypeCallingConv(T));
  }

  late final _clang_getFunctionTypeCallingConvPtr =
      _lookup<ffi.NativeFunction<NativeClang_getFunctionTypeCallingConv>>(
        'clang_getFunctionTypeCallingConv',
      );
  late final _clang_getFunctionTypeCallingConv =
      _clang_getFunctionTypeCallingConvPtr
          .asFunction<DartClang_getFunctionTypeCallingConv>();

  /// Retrieve the return type associated with a function type.
  ///
  /// If a non-function type is passed in, an invalid type is returned.
  CXType clang_getResultType(CXType T) {
    return _clang_getResultType(T);
  }

  late final _clang_getResultTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getResultType>>(
        'clang_getResultType',
      );
  late final _clang_getResultType = _clang_getResultTypePtr
      .asFunction<DartClang_getResultType>();

  /// Retrieve the exception specification type associated with a function type.
  /// This is a value of type CXCursor_ExceptionSpecificationKind.
  ///
  /// If a non-function type is passed in, an error code of -1 is returned.
  int clang_getExceptionSpecificationType(CXType T) {
    return _clang_getExceptionSpecificationType(T);
  }

  late final _clang_getExceptionSpecificationTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getExceptionSpecificationType>>(
        'clang_getExceptionSpecificationType',
      );
  late final _clang_getExceptionSpecificationType =
      _clang_getExceptionSpecificationTypePtr
          .asFunction<DartClang_getExceptionSpecificationType>();

  /// Retrieve the number of non-variadic parameters associated with a
  /// function type.
  ///
  /// If a non-function type is passed in, -1 is returned.
  int clang_getNumArgTypes(CXType T) {
    return _clang_getNumArgTypes(T);
  }

  late final _clang_getNumArgTypesPtr =
      _lookup<ffi.NativeFunction<NativeClang_getNumArgTypes>>(
        'clang_getNumArgTypes',
      );
  late final _clang_getNumArgTypes = _clang_getNumArgTypesPtr
      .asFunction<DartClang_getNumArgTypes>();

  /// Retrieve the type of a parameter of a function type.
  ///
  /// If a non-function type is passed in or the function does not have enough
  /// parameters, an invalid type is returned.
  CXType clang_getArgType(CXType T, int i) {
    return _clang_getArgType(T, i);
  }

  late final _clang_getArgTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getArgType>>('clang_getArgType');
  late final _clang_getArgType = _clang_getArgTypePtr
      .asFunction<DartClang_getArgType>();

  /// Retrieves the base type of the ObjCObjectType.
  ///
  /// If the type is not an ObjC object, an invalid type is returned.
  CXType clang_Type_getObjCObjectBaseType(CXType T) {
    return _clang_Type_getObjCObjectBaseType(T);
  }

  late final _clang_Type_getObjCObjectBaseTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getObjCObjectBaseType>>(
        'clang_Type_getObjCObjectBaseType',
      );
  late final _clang_Type_getObjCObjectBaseType =
      _clang_Type_getObjCObjectBaseTypePtr
          .asFunction<DartClang_Type_getObjCObjectBaseType>();

  /// Retrieve the number of protocol references associated with an ObjC object/id.
  ///
  /// If the type is not an ObjC object, 0 is returned.
  int clang_Type_getNumObjCProtocolRefs(CXType T) {
    return _clang_Type_getNumObjCProtocolRefs(T);
  }

  late final _clang_Type_getNumObjCProtocolRefsPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getNumObjCProtocolRefs>>(
        'clang_Type_getNumObjCProtocolRefs',
      );
  late final _clang_Type_getNumObjCProtocolRefs =
      _clang_Type_getNumObjCProtocolRefsPtr
          .asFunction<DartClang_Type_getNumObjCProtocolRefs>();

  /// Retrieve the decl for a protocol reference for an ObjC object/id.
  ///
  /// If the type is not an ObjC object or there are not enough protocol
  /// references, an invalid cursor is returned.
  CXCursor clang_Type_getObjCProtocolDecl(CXType T, int i) {
    return _clang_Type_getObjCProtocolDecl(T, i);
  }

  late final _clang_Type_getObjCProtocolDeclPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getObjCProtocolDecl>>(
        'clang_Type_getObjCProtocolDecl',
      );
  late final _clang_Type_getObjCProtocolDecl =
      _clang_Type_getObjCProtocolDeclPtr
          .asFunction<DartClang_Type_getObjCProtocolDecl>();

  /// Retreive the number of type arguments associated with an ObjC object.
  ///
  /// If the type is not an ObjC object, 0 is returned.
  int clang_Type_getNumObjCTypeArgs(CXType T) {
    return _clang_Type_getNumObjCTypeArgs(T);
  }

  late final _clang_Type_getNumObjCTypeArgsPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getNumObjCTypeArgs>>(
        'clang_Type_getNumObjCTypeArgs',
      );
  late final _clang_Type_getNumObjCTypeArgs = _clang_Type_getNumObjCTypeArgsPtr
      .asFunction<DartClang_Type_getNumObjCTypeArgs>();

  /// Retrieve a type argument associated with an ObjC object.
  ///
  /// If the type is not an ObjC or the index is not valid,
  /// an invalid type is returned.
  CXType clang_Type_getObjCTypeArg(CXType T, int i) {
    return _clang_Type_getObjCTypeArg(T, i);
  }

  late final _clang_Type_getObjCTypeArgPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getObjCTypeArg>>(
        'clang_Type_getObjCTypeArg',
      );
  late final _clang_Type_getObjCTypeArg = _clang_Type_getObjCTypeArgPtr
      .asFunction<DartClang_Type_getObjCTypeArg>();

  /// Return 1 if the CXType is a variadic function type, and 0 otherwise.
  int clang_isFunctionTypeVariadic(CXType T) {
    return _clang_isFunctionTypeVariadic(T);
  }

  late final _clang_isFunctionTypeVariadicPtr =
      _lookup<ffi.NativeFunction<NativeClang_isFunctionTypeVariadic>>(
        'clang_isFunctionTypeVariadic',
      );
  late final _clang_isFunctionTypeVariadic = _clang_isFunctionTypeVariadicPtr
      .asFunction<DartClang_isFunctionTypeVariadic>();

  /// Retrieve the return type associated with a given cursor.
  ///
  /// This only returns a valid type if the cursor refers to a function or method.
  CXType clang_getCursorResultType(CXCursor C) {
    return _clang_getCursorResultType(C);
  }

  late final _clang_getCursorResultTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorResultType>>(
        'clang_getCursorResultType',
      );
  late final _clang_getCursorResultType = _clang_getCursorResultTypePtr
      .asFunction<DartClang_getCursorResultType>();

  /// Retrieve the exception specification type associated with a given cursor.
  /// This is a value of type CXCursor_ExceptionSpecificationKind.
  ///
  /// This only returns a valid result if the cursor refers to a function or method.
  int clang_getCursorExceptionSpecificationType(CXCursor C) {
    return _clang_getCursorExceptionSpecificationType(C);
  }

  late final _clang_getCursorExceptionSpecificationTypePtr =
      _lookup<
        ffi.NativeFunction<NativeClang_getCursorExceptionSpecificationType>
      >('clang_getCursorExceptionSpecificationType');
  late final _clang_getCursorExceptionSpecificationType =
      _clang_getCursorExceptionSpecificationTypePtr
          .asFunction<DartClang_getCursorExceptionSpecificationType>();

  /// Return 1 if the CXType is a POD (plain old data) type, and 0
  /// otherwise.
  int clang_isPODType(CXType T) {
    return _clang_isPODType(T);
  }

  late final _clang_isPODTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_isPODType>>('clang_isPODType');
  late final _clang_isPODType = _clang_isPODTypePtr
      .asFunction<DartClang_isPODType>();

  /// Return the element type of an array, complex, or vector type.
  ///
  /// If a type is passed in that is not an array, complex, or vector type,
  /// an invalid type is returned.
  CXType clang_getElementType(CXType T) {
    return _clang_getElementType(T);
  }

  late final _clang_getElementTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getElementType>>(
        'clang_getElementType',
      );
  late final _clang_getElementType = _clang_getElementTypePtr
      .asFunction<DartClang_getElementType>();

  /// Return the number of elements of an array or vector type.
  ///
  /// If a type is passed in that is not an array or vector type,
  /// -1 is returned.
  int clang_getNumElements(CXType T) {
    return _clang_getNumElements(T);
  }

  late final _clang_getNumElementsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getNumElements>>(
        'clang_getNumElements',
      );
  late final _clang_getNumElements = _clang_getNumElementsPtr
      .asFunction<DartClang_getNumElements>();

  /// Return the element type of an array type.
  ///
  /// If a non-array type is passed in, an invalid type is returned.
  CXType clang_getArrayElementType(CXType T) {
    return _clang_getArrayElementType(T);
  }

  late final _clang_getArrayElementTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getArrayElementType>>(
        'clang_getArrayElementType',
      );
  late final _clang_getArrayElementType = _clang_getArrayElementTypePtr
      .asFunction<DartClang_getArrayElementType>();

  /// Return the array size of a constant array.
  ///
  /// If a non-array type is passed in, -1 is returned.
  int clang_getArraySize(CXType T) {
    return _clang_getArraySize(T);
  }

  late final _clang_getArraySizePtr =
      _lookup<ffi.NativeFunction<NativeClang_getArraySize>>(
        'clang_getArraySize',
      );
  late final _clang_getArraySize = _clang_getArraySizePtr
      .asFunction<DartClang_getArraySize>();

  /// Retrieve the type named by the qualified-id.
  ///
  /// If a non-elaborated type is passed in, an invalid type is returned.
  CXType clang_Type_getNamedType(CXType T) {
    return _clang_Type_getNamedType(T);
  }

  late final _clang_Type_getNamedTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getNamedType>>(
        'clang_Type_getNamedType',
      );
  late final _clang_Type_getNamedType = _clang_Type_getNamedTypePtr
      .asFunction<DartClang_Type_getNamedType>();

  /// Determine if a typedef is 'transparent' tag.
  ///
  /// A typedef is considered 'transparent' if it shares a name and spelling
  /// location with its underlying tag type, as is the case with the NS_ENUM macro.
  ///
  /// \returns non-zero if transparent and zero otherwise.
  int clang_Type_isTransparentTagTypedef(CXType T) {
    return _clang_Type_isTransparentTagTypedef(T);
  }

  late final _clang_Type_isTransparentTagTypedefPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_isTransparentTagTypedef>>(
        'clang_Type_isTransparentTagTypedef',
      );
  late final _clang_Type_isTransparentTagTypedef =
      _clang_Type_isTransparentTagTypedefPtr
          .asFunction<DartClang_Type_isTransparentTagTypedef>();

  /// Retrieve the nullability kind of a pointer type.
  CXTypeNullabilityKind clang_Type_getNullability(CXType T) {
    return CXTypeNullabilityKind.fromValue(_clang_Type_getNullability(T));
  }

  late final _clang_Type_getNullabilityPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getNullability>>(
        'clang_Type_getNullability',
      );
  late final _clang_Type_getNullability = _clang_Type_getNullabilityPtr
      .asFunction<DartClang_Type_getNullability>();

  /// Return the alignment of a type in bytes as per C++[expr.alignof]
  /// standard.
  ///
  /// If the type declaration is invalid, CXTypeLayoutError_Invalid is returned.
  /// If the type declaration is an incomplete type, CXTypeLayoutError_Incomplete
  /// is returned.
  /// If the type declaration is a dependent type, CXTypeLayoutError_Dependent is
  /// returned.
  /// If the type declaration is not a constant size type,
  /// CXTypeLayoutError_NotConstantSize is returned.
  int clang_Type_getAlignOf(CXType T) {
    return _clang_Type_getAlignOf(T);
  }

  late final _clang_Type_getAlignOfPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getAlignOf>>(
        'clang_Type_getAlignOf',
      );
  late final _clang_Type_getAlignOf = _clang_Type_getAlignOfPtr
      .asFunction<DartClang_Type_getAlignOf>();

  /// Return the class type of an member pointer type.
  ///
  /// If a non-member-pointer type is passed in, an invalid type is returned.
  CXType clang_Type_getClassType(CXType T) {
    return _clang_Type_getClassType(T);
  }

  late final _clang_Type_getClassTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getClassType>>(
        'clang_Type_getClassType',
      );
  late final _clang_Type_getClassType = _clang_Type_getClassTypePtr
      .asFunction<DartClang_Type_getClassType>();

  /// Return the size of a type in bytes as per C++[expr.sizeof] standard.
  ///
  /// If the type declaration is invalid, CXTypeLayoutError_Invalid is returned.
  /// If the type declaration is an incomplete type, CXTypeLayoutError_Incomplete
  /// is returned.
  /// If the type declaration is a dependent type, CXTypeLayoutError_Dependent is
  /// returned.
  int clang_Type_getSizeOf(CXType T) {
    return _clang_Type_getSizeOf(T);
  }

  late final _clang_Type_getSizeOfPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getSizeOf>>(
        'clang_Type_getSizeOf',
      );
  late final _clang_Type_getSizeOf = _clang_Type_getSizeOfPtr
      .asFunction<DartClang_Type_getSizeOf>();

  /// Return the offset of a field named S in a record of type T in bits
  /// as it would be returned by __offsetof__ as per C++11[18.2p4]
  ///
  /// If the cursor is not a record field declaration, CXTypeLayoutError_Invalid
  /// is returned.
  /// If the field's type declaration is an incomplete type,
  /// CXTypeLayoutError_Incomplete is returned.
  /// If the field's type declaration is a dependent type,
  /// CXTypeLayoutError_Dependent is returned.
  /// If the field's name S is not found,
  /// CXTypeLayoutError_InvalidFieldName is returned.
  int clang_Type_getOffsetOf(CXType T, ffi.Pointer<ffi.Char> S) {
    return _clang_Type_getOffsetOf(T, S);
  }

  late final _clang_Type_getOffsetOfPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getOffsetOf>>(
        'clang_Type_getOffsetOf',
      );
  late final _clang_Type_getOffsetOf = _clang_Type_getOffsetOfPtr
      .asFunction<DartClang_Type_getOffsetOf>();

  /// Return the type that was modified by this attributed type.
  ///
  /// If the type is not an attributed type, an invalid type is returned.
  CXType clang_Type_getModifiedType(CXType T) {
    return _clang_Type_getModifiedType(T);
  }

  late final _clang_Type_getModifiedTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getModifiedType>>(
        'clang_Type_getModifiedType',
      );
  late final _clang_Type_getModifiedType = _clang_Type_getModifiedTypePtr
      .asFunction<DartClang_Type_getModifiedType>();

  /// Return the offset of the field represented by the Cursor.
  ///
  /// If the cursor is not a field declaration, -1 is returned.
  /// If the cursor semantic parent is not a record field declaration,
  /// CXTypeLayoutError_Invalid is returned.
  /// If the field's type declaration is an incomplete type,
  /// CXTypeLayoutError_Incomplete is returned.
  /// If the field's type declaration is a dependent type,
  /// CXTypeLayoutError_Dependent is returned.
  /// If the field's name S is not found,
  /// CXTypeLayoutError_InvalidFieldName is returned.
  int clang_Cursor_getOffsetOfField(CXCursor C) {
    return _clang_Cursor_getOffsetOfField(C);
  }

  late final _clang_Cursor_getOffsetOfFieldPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getOffsetOfField>>(
        'clang_Cursor_getOffsetOfField',
      );
  late final _clang_Cursor_getOffsetOfField = _clang_Cursor_getOffsetOfFieldPtr
      .asFunction<DartClang_Cursor_getOffsetOfField>();

  /// Determine whether the given cursor represents an anonymous
  /// tag or namespace
  int clang_Cursor_isAnonymous(CXCursor C) {
    return _clang_Cursor_isAnonymous(C);
  }

  late final _clang_Cursor_isAnonymousPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isAnonymous>>(
        'clang_Cursor_isAnonymous',
      );
  late final _clang_Cursor_isAnonymous = _clang_Cursor_isAnonymousPtr
      .asFunction<DartClang_Cursor_isAnonymous>();

  /// Determine whether the given cursor represents an anonymous record
  /// declaration.
  int clang_Cursor_isAnonymousRecordDecl(CXCursor C) {
    return _clang_Cursor_isAnonymousRecordDecl(C);
  }

  late final _clang_Cursor_isAnonymousRecordDeclPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isAnonymousRecordDecl>>(
        'clang_Cursor_isAnonymousRecordDecl',
      );
  late final _clang_Cursor_isAnonymousRecordDecl =
      _clang_Cursor_isAnonymousRecordDeclPtr
          .asFunction<DartClang_Cursor_isAnonymousRecordDecl>();

  /// Determine whether the given cursor represents an inline namespace
  /// declaration.
  int clang_Cursor_isInlineNamespace(CXCursor C) {
    return _clang_Cursor_isInlineNamespace(C);
  }

  late final _clang_Cursor_isInlineNamespacePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isInlineNamespace>>(
        'clang_Cursor_isInlineNamespace',
      );
  late final _clang_Cursor_isInlineNamespace =
      _clang_Cursor_isInlineNamespacePtr
          .asFunction<DartClang_Cursor_isInlineNamespace>();

  /// Returns the number of template arguments for given template
  /// specialization, or -1 if type \c T is not a template specialization.
  int clang_Type_getNumTemplateArguments(CXType T) {
    return _clang_Type_getNumTemplateArguments(T);
  }

  late final _clang_Type_getNumTemplateArgumentsPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getNumTemplateArguments>>(
        'clang_Type_getNumTemplateArguments',
      );
  late final _clang_Type_getNumTemplateArguments =
      _clang_Type_getNumTemplateArgumentsPtr
          .asFunction<DartClang_Type_getNumTemplateArguments>();

  /// Returns the type template argument of a template class specialization
  /// at given index.
  ///
  /// This function only returns template type arguments and does not handle
  /// template template arguments or variadic packs.
  CXType clang_Type_getTemplateArgumentAsType(CXType T, int i) {
    return _clang_Type_getTemplateArgumentAsType(T, i);
  }

  late final _clang_Type_getTemplateArgumentAsTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getTemplateArgumentAsType>>(
        'clang_Type_getTemplateArgumentAsType',
      );
  late final _clang_Type_getTemplateArgumentAsType =
      _clang_Type_getTemplateArgumentAsTypePtr
          .asFunction<DartClang_Type_getTemplateArgumentAsType>();

  /// Retrieve the ref-qualifier kind of a function or method.
  ///
  /// The ref-qualifier is returned for C++ functions or methods. For other types
  /// or non-C++ declarations, CXRefQualifier_None is returned.
  CXRefQualifierKind clang_Type_getCXXRefQualifier(CXType T) {
    return CXRefQualifierKind.fromValue(_clang_Type_getCXXRefQualifier(T));
  }

  late final _clang_Type_getCXXRefQualifierPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_getCXXRefQualifier>>(
        'clang_Type_getCXXRefQualifier',
      );
  late final _clang_Type_getCXXRefQualifier = _clang_Type_getCXXRefQualifierPtr
      .asFunction<DartClang_Type_getCXXRefQualifier>();

  /// Returns non-zero if the cursor specifies a Record member that is a
  /// bitfield.
  int clang_Cursor_isBitField(CXCursor C) {
    return _clang_Cursor_isBitField(C);
  }

  late final _clang_Cursor_isBitFieldPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isBitField>>(
        'clang_Cursor_isBitField',
      );
  late final _clang_Cursor_isBitField = _clang_Cursor_isBitFieldPtr
      .asFunction<DartClang_Cursor_isBitField>();

  /// Returns 1 if the base class specified by the cursor with kind
  /// CX_CXXBaseSpecifier is virtual.
  int clang_isVirtualBase(CXCursor arg0) {
    return _clang_isVirtualBase(arg0);
  }

  late final _clang_isVirtualBasePtr =
      _lookup<ffi.NativeFunction<NativeClang_isVirtualBase>>(
        'clang_isVirtualBase',
      );
  late final _clang_isVirtualBase = _clang_isVirtualBasePtr
      .asFunction<DartClang_isVirtualBase>();

  /// Returns the access control level for the referenced object.
  ///
  /// If the cursor refers to a C++ declaration, its access control level within its
  /// parent scope is returned. Otherwise, if the cursor refers to a base specifier or
  /// access specifier, the specifier itself is returned.
  CX_CXXAccessSpecifier clang_getCXXAccessSpecifier(CXCursor arg0) {
    return CX_CXXAccessSpecifier.fromValue(_clang_getCXXAccessSpecifier(arg0));
  }

  late final _clang_getCXXAccessSpecifierPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCXXAccessSpecifier>>(
        'clang_getCXXAccessSpecifier',
      );
  late final _clang_getCXXAccessSpecifier = _clang_getCXXAccessSpecifierPtr
      .asFunction<DartClang_getCXXAccessSpecifier>();

  /// Returns the storage class for a function or variable declaration.
  ///
  /// If the passed in Cursor is not a function or variable declaration,
  /// CX_SC_Invalid is returned else the storage class.
  CX_StorageClass clang_Cursor_getStorageClass(CXCursor arg0) {
    return CX_StorageClass.fromValue(_clang_Cursor_getStorageClass(arg0));
  }

  late final _clang_Cursor_getStorageClassPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getStorageClass>>(
        'clang_Cursor_getStorageClass',
      );
  late final _clang_Cursor_getStorageClass = _clang_Cursor_getStorageClassPtr
      .asFunction<DartClang_Cursor_getStorageClass>();

  /// Determine the number of overloaded declarations referenced by a
  /// \c CXCursor_OverloadedDeclRef cursor.
  ///
  /// \param cursor The cursor whose overloaded declarations are being queried.
  ///
  /// \returns The number of overloaded declarations referenced by \c cursor. If it
  /// is not a \c CXCursor_OverloadedDeclRef cursor, returns 0.
  int clang_getNumOverloadedDecls(CXCursor cursor) {
    return _clang_getNumOverloadedDecls(cursor);
  }

  late final _clang_getNumOverloadedDeclsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getNumOverloadedDecls>>(
        'clang_getNumOverloadedDecls',
      );
  late final _clang_getNumOverloadedDecls = _clang_getNumOverloadedDeclsPtr
      .asFunction<DartClang_getNumOverloadedDecls>();

  /// Retrieve a cursor for one of the overloaded declarations referenced
  /// by a \c CXCursor_OverloadedDeclRef cursor.
  ///
  /// \param cursor The cursor whose overloaded declarations are being queried.
  ///
  /// \param index The zero-based index into the set of overloaded declarations in
  /// the cursor.
  ///
  /// \returns A cursor representing the declaration referenced by the given
  /// \c cursor at the specified \c index. If the cursor does not have an
  /// associated set of overloaded declarations, or if the index is out of bounds,
  /// returns \c clang_getNullCursor();
  CXCursor clang_getOverloadedDecl(CXCursor cursor, int index) {
    return _clang_getOverloadedDecl(cursor, index);
  }

  late final _clang_getOverloadedDeclPtr =
      _lookup<ffi.NativeFunction<NativeClang_getOverloadedDecl>>(
        'clang_getOverloadedDecl',
      );
  late final _clang_getOverloadedDecl = _clang_getOverloadedDeclPtr
      .asFunction<DartClang_getOverloadedDecl>();

  /// For cursors representing an iboutletcollection attribute,
  /// this function returns the collection element type.
  CXType clang_getIBOutletCollectionType(CXCursor arg0) {
    return _clang_getIBOutletCollectionType(arg0);
  }

  late final _clang_getIBOutletCollectionTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_getIBOutletCollectionType>>(
        'clang_getIBOutletCollectionType',
      );
  late final _clang_getIBOutletCollectionType =
      _clang_getIBOutletCollectionTypePtr
          .asFunction<DartClang_getIBOutletCollectionType>();

  /// Visit the children of a particular cursor.
  ///
  /// This function visits all the direct children of the given cursor,
  /// invoking the given \p visitor function with the cursors of each
  /// visited child. The traversal may be recursive, if the visitor returns
  /// \c CXChildVisit_Recurse. The traversal may also be ended prematurely, if
  /// the visitor returns \c CXChildVisit_Break.
  ///
  /// \param parent the cursor whose child may be visited. All kinds of
  /// cursors can be visited, including invalid cursors (which, by
  /// definition, have no children).
  ///
  /// \param visitor the visitor function that will be invoked for each
  /// child of \p parent.
  ///
  /// \param client_data pointer data supplied by the client, which will
  /// be passed to the visitor each time it is invoked.
  ///
  /// \returns a non-zero value if the traversal was terminated
  /// prematurely by the visitor returning \c CXChildVisit_Break.
  int clang_visitChildren(
    CXCursor parent,
    CXCursorVisitor visitor,
    CXClientData client_data,
  ) {
    return _clang_visitChildren(parent, visitor, client_data);
  }

  late final _clang_visitChildrenPtr =
      _lookup<ffi.NativeFunction<NativeClang_visitChildren>>(
        'clang_visitChildren',
      );
  late final _clang_visitChildren = _clang_visitChildrenPtr
      .asFunction<DartClang_visitChildren>();

  /// Retrieve a Unified Symbol Resolution (USR) for the entity referenced
  /// by the given cursor.
  ///
  /// A Unified Symbol Resolution (USR) is a string that identifies a particular
  /// entity (function, class, variable, etc.) within a program. USRs can be
  /// compared across translation units to determine, e.g., when references in
  /// one translation refer to an entity defined in another translation unit.
  CXString clang_getCursorUSR(CXCursor arg0) {
    return _clang_getCursorUSR(arg0);
  }

  late final _clang_getCursorUSRPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorUSR>>(
        'clang_getCursorUSR',
      );
  late final _clang_getCursorUSR = _clang_getCursorUSRPtr
      .asFunction<DartClang_getCursorUSR>();

  /// Construct a USR for a specified Objective-C class.
  CXString clang_constructUSR_ObjCClass(ffi.Pointer<ffi.Char> class_name) {
    return _clang_constructUSR_ObjCClass(class_name);
  }

  late final _clang_constructUSR_ObjCClassPtr =
      _lookup<ffi.NativeFunction<NativeClang_constructUSR_ObjCClass>>(
        'clang_constructUSR_ObjCClass',
      );
  late final _clang_constructUSR_ObjCClass = _clang_constructUSR_ObjCClassPtr
      .asFunction<DartClang_constructUSR_ObjCClass>();

  /// Construct a USR for a specified Objective-C category.
  CXString clang_constructUSR_ObjCCategory(
    ffi.Pointer<ffi.Char> class_name,
    ffi.Pointer<ffi.Char> category_name,
  ) {
    return _clang_constructUSR_ObjCCategory(class_name, category_name);
  }

  late final _clang_constructUSR_ObjCCategoryPtr =
      _lookup<ffi.NativeFunction<NativeClang_constructUSR_ObjCCategory>>(
        'clang_constructUSR_ObjCCategory',
      );
  late final _clang_constructUSR_ObjCCategory =
      _clang_constructUSR_ObjCCategoryPtr
          .asFunction<DartClang_constructUSR_ObjCCategory>();

  /// Construct a USR for a specified Objective-C protocol.
  CXString clang_constructUSR_ObjCProtocol(
    ffi.Pointer<ffi.Char> protocol_name,
  ) {
    return _clang_constructUSR_ObjCProtocol(protocol_name);
  }

  late final _clang_constructUSR_ObjCProtocolPtr =
      _lookup<ffi.NativeFunction<NativeClang_constructUSR_ObjCProtocol>>(
        'clang_constructUSR_ObjCProtocol',
      );
  late final _clang_constructUSR_ObjCProtocol =
      _clang_constructUSR_ObjCProtocolPtr
          .asFunction<DartClang_constructUSR_ObjCProtocol>();

  /// Construct a USR for a specified Objective-C instance variable and
  /// the USR for its containing class.
  CXString clang_constructUSR_ObjCIvar(
    ffi.Pointer<ffi.Char> name,
    CXString classUSR,
  ) {
    return _clang_constructUSR_ObjCIvar(name, classUSR);
  }

  late final _clang_constructUSR_ObjCIvarPtr =
      _lookup<ffi.NativeFunction<NativeClang_constructUSR_ObjCIvar>>(
        'clang_constructUSR_ObjCIvar',
      );
  late final _clang_constructUSR_ObjCIvar = _clang_constructUSR_ObjCIvarPtr
      .asFunction<DartClang_constructUSR_ObjCIvar>();

  /// Construct a USR for a specified Objective-C method and
  /// the USR for its containing class.
  CXString clang_constructUSR_ObjCMethod(
    ffi.Pointer<ffi.Char> name,
    int isInstanceMethod,
    CXString classUSR,
  ) {
    return _clang_constructUSR_ObjCMethod(name, isInstanceMethod, classUSR);
  }

  late final _clang_constructUSR_ObjCMethodPtr =
      _lookup<ffi.NativeFunction<NativeClang_constructUSR_ObjCMethod>>(
        'clang_constructUSR_ObjCMethod',
      );
  late final _clang_constructUSR_ObjCMethod = _clang_constructUSR_ObjCMethodPtr
      .asFunction<DartClang_constructUSR_ObjCMethod>();

  /// Construct a USR for a specified Objective-C property and the USR
  /// for its containing class.
  CXString clang_constructUSR_ObjCProperty(
    ffi.Pointer<ffi.Char> property,
    CXString classUSR,
  ) {
    return _clang_constructUSR_ObjCProperty(property, classUSR);
  }

  late final _clang_constructUSR_ObjCPropertyPtr =
      _lookup<ffi.NativeFunction<NativeClang_constructUSR_ObjCProperty>>(
        'clang_constructUSR_ObjCProperty',
      );
  late final _clang_constructUSR_ObjCProperty =
      _clang_constructUSR_ObjCPropertyPtr
          .asFunction<DartClang_constructUSR_ObjCProperty>();

  /// Retrieve a name for the entity referenced by this cursor.
  CXString clang_getCursorSpelling(CXCursor arg0) {
    return _clang_getCursorSpelling(arg0);
  }

  late final _clang_getCursorSpellingPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorSpelling>>(
        'clang_getCursorSpelling',
      );
  late final _clang_getCursorSpelling = _clang_getCursorSpellingPtr
      .asFunction<DartClang_getCursorSpelling>();

  /// Retrieve a range for a piece that forms the cursors spelling name.
  /// Most of the times there is only one range for the complete spelling but for
  /// Objective-C methods and Objective-C message expressions, there are multiple
  /// pieces for each selector identifier.
  ///
  /// \param pieceIndex the index of the spelling name piece. If this is greater
  /// than the actual number of pieces, it will return a NULL (invalid) range.
  ///
  /// \param options Reserved.
  CXSourceRange clang_Cursor_getSpellingNameRange(
    CXCursor arg0,
    int pieceIndex,
    int options,
  ) {
    return _clang_Cursor_getSpellingNameRange(arg0, pieceIndex, options);
  }

  late final _clang_Cursor_getSpellingNameRangePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getSpellingNameRange>>(
        'clang_Cursor_getSpellingNameRange',
      );
  late final _clang_Cursor_getSpellingNameRange =
      _clang_Cursor_getSpellingNameRangePtr
          .asFunction<DartClang_Cursor_getSpellingNameRange>();

  /// Get a property value for the given printing policy.
  int clang_PrintingPolicy_getProperty(
    CXPrintingPolicy Policy,
    CXPrintingPolicyProperty Property,
  ) {
    return _clang_PrintingPolicy_getProperty(Policy, Property.value);
  }

  late final _clang_PrintingPolicy_getPropertyPtr =
      _lookup<ffi.NativeFunction<NativeClang_PrintingPolicy_getProperty>>(
        'clang_PrintingPolicy_getProperty',
      );
  late final _clang_PrintingPolicy_getProperty =
      _clang_PrintingPolicy_getPropertyPtr
          .asFunction<DartClang_PrintingPolicy_getProperty>();

  /// Set a property value for the given printing policy.
  void clang_PrintingPolicy_setProperty(
    CXPrintingPolicy Policy,
    CXPrintingPolicyProperty Property,
    int Value,
  ) {
    return _clang_PrintingPolicy_setProperty(Policy, Property.value, Value);
  }

  late final _clang_PrintingPolicy_setPropertyPtr =
      _lookup<ffi.NativeFunction<NativeClang_PrintingPolicy_setProperty>>(
        'clang_PrintingPolicy_setProperty',
      );
  late final _clang_PrintingPolicy_setProperty =
      _clang_PrintingPolicy_setPropertyPtr
          .asFunction<DartClang_PrintingPolicy_setProperty>();

  /// Retrieve the default policy for the cursor.
  ///
  /// The policy should be released after use with \c
  /// clang_PrintingPolicy_dispose.
  CXPrintingPolicy clang_getCursorPrintingPolicy(CXCursor arg0) {
    return _clang_getCursorPrintingPolicy(arg0);
  }

  late final _clang_getCursorPrintingPolicyPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorPrintingPolicy>>(
        'clang_getCursorPrintingPolicy',
      );
  late final _clang_getCursorPrintingPolicy = _clang_getCursorPrintingPolicyPtr
      .asFunction<DartClang_getCursorPrintingPolicy>();

  /// Release a printing policy.
  void clang_PrintingPolicy_dispose(CXPrintingPolicy Policy) {
    return _clang_PrintingPolicy_dispose(Policy);
  }

  late final _clang_PrintingPolicy_disposePtr =
      _lookup<ffi.NativeFunction<NativeClang_PrintingPolicy_dispose>>(
        'clang_PrintingPolicy_dispose',
      );
  late final _clang_PrintingPolicy_dispose = _clang_PrintingPolicy_disposePtr
      .asFunction<DartClang_PrintingPolicy_dispose>();

  /// Pretty print declarations.
  ///
  /// \param Cursor The cursor representing a declaration.
  ///
  /// \param Policy The policy to control the entities being printed. If
  /// NULL, a default policy is used.
  ///
  /// \returns The pretty printed declaration or the empty string for
  /// other cursors.
  CXString clang_getCursorPrettyPrinted(
    CXCursor Cursor,
    CXPrintingPolicy Policy,
  ) {
    return _clang_getCursorPrettyPrinted(Cursor, Policy);
  }

  late final _clang_getCursorPrettyPrintedPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorPrettyPrinted>>(
        'clang_getCursorPrettyPrinted',
      );
  late final _clang_getCursorPrettyPrinted = _clang_getCursorPrettyPrintedPtr
      .asFunction<DartClang_getCursorPrettyPrinted>();

  /// Retrieve the display name for the entity referenced by this cursor.
  ///
  /// The display name contains extra information that helps identify the cursor,
  /// such as the parameters of a function or template or the arguments of a
  /// class template specialization.
  CXString clang_getCursorDisplayName(CXCursor arg0) {
    return _clang_getCursorDisplayName(arg0);
  }

  late final _clang_getCursorDisplayNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorDisplayName>>(
        'clang_getCursorDisplayName',
      );
  late final _clang_getCursorDisplayName = _clang_getCursorDisplayNamePtr
      .asFunction<DartClang_getCursorDisplayName>();

  /// For a cursor that is a reference, retrieve a cursor representing the
  /// entity that it references.
  ///
  /// Reference cursors refer to other entities in the AST. For example, an
  /// Objective-C superclass reference cursor refers to an Objective-C class.
  /// This function produces the cursor for the Objective-C class from the
  /// cursor for the superclass reference. If the input cursor is a declaration or
  /// definition, it returns that declaration or definition unchanged.
  /// Otherwise, returns the NULL cursor.
  CXCursor clang_getCursorReferenced(CXCursor arg0) {
    return _clang_getCursorReferenced(arg0);
  }

  late final _clang_getCursorReferencedPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorReferenced>>(
        'clang_getCursorReferenced',
      );
  late final _clang_getCursorReferenced = _clang_getCursorReferencedPtr
      .asFunction<DartClang_getCursorReferenced>();

  /// For a cursor that is either a reference to or a declaration
  /// of some entity, retrieve a cursor that describes the definition of
  /// that entity.
  ///
  /// Some entities can be declared multiple times within a translation
  /// unit, but only one of those declarations can also be a
  /// definition. For example, given:
  ///
  /// \code
  /// int f(int, int);
  /// int g(int x, int y) { return f(x, y); }
  /// int f(int a, int b) { return a + b; }
  /// int f(int, int);
  /// \endcode
  ///
  /// there are three declarations of the function "f", but only the
  /// second one is a definition. The clang_getCursorDefinition()
  /// function will take any cursor pointing to a declaration of "f"
  /// (the first or fourth lines of the example) or a cursor referenced
  /// that uses "f" (the call to "f' inside "g") and will return a
  /// declaration cursor pointing to the definition (the second "f"
  /// declaration).
  ///
  /// If given a cursor for which there is no corresponding definition,
  /// e.g., because there is no definition of that entity within this
  /// translation unit, returns a NULL cursor.
  CXCursor clang_getCursorDefinition(CXCursor arg0) {
    return _clang_getCursorDefinition(arg0);
  }

  late final _clang_getCursorDefinitionPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorDefinition>>(
        'clang_getCursorDefinition',
      );
  late final _clang_getCursorDefinition = _clang_getCursorDefinitionPtr
      .asFunction<DartClang_getCursorDefinition>();

  /// Determine whether the declaration pointed to by this cursor
  /// is also a definition of that entity.
  int clang_isCursorDefinition(CXCursor arg0) {
    return _clang_isCursorDefinition(arg0);
  }

  late final _clang_isCursorDefinitionPtr =
      _lookup<ffi.NativeFunction<NativeClang_isCursorDefinition>>(
        'clang_isCursorDefinition',
      );
  late final _clang_isCursorDefinition = _clang_isCursorDefinitionPtr
      .asFunction<DartClang_isCursorDefinition>();

  /// Retrieve the canonical cursor corresponding to the given cursor.
  ///
  /// In the C family of languages, many kinds of entities can be declared several
  /// times within a single translation unit. For example, a structure type can
  /// be forward-declared (possibly multiple times) and later defined:
  ///
  /// \code
  /// struct X;
  /// struct X;
  /// struct X {
  /// int member;
  /// };
  /// \endcode
  ///
  /// The declarations and the definition of \c X are represented by three
  /// different cursors, all of which are declarations of the same underlying
  /// entity. One of these cursor is considered the "canonical" cursor, which
  /// is effectively the representative for the underlying entity. One can
  /// determine if two cursors are declarations of the same underlying entity by
  /// comparing their canonical cursors.
  ///
  /// \returns The canonical cursor for the entity referred to by the given cursor.
  CXCursor clang_getCanonicalCursor(CXCursor arg0) {
    return _clang_getCanonicalCursor(arg0);
  }

  late final _clang_getCanonicalCursorPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCanonicalCursor>>(
        'clang_getCanonicalCursor',
      );
  late final _clang_getCanonicalCursor = _clang_getCanonicalCursorPtr
      .asFunction<DartClang_getCanonicalCursor>();

  /// If the cursor points to a selector identifier in an Objective-C
  /// method or message expression, this returns the selector index.
  ///
  /// After getting a cursor with #clang_getCursor, this can be called to
  /// determine if the location points to a selector identifier.
  ///
  /// \returns The selector index if the cursor is an Objective-C method or message
  /// expression and the cursor is pointing to a selector identifier, or -1
  /// otherwise.
  int clang_Cursor_getObjCSelectorIndex(CXCursor arg0) {
    return _clang_Cursor_getObjCSelectorIndex(arg0);
  }

  late final _clang_Cursor_getObjCSelectorIndexPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getObjCSelectorIndex>>(
        'clang_Cursor_getObjCSelectorIndex',
      );
  late final _clang_Cursor_getObjCSelectorIndex =
      _clang_Cursor_getObjCSelectorIndexPtr
          .asFunction<DartClang_Cursor_getObjCSelectorIndex>();

  /// Given a cursor pointing to a C++ method call or an Objective-C
  /// message, returns non-zero if the method/message is "dynamic", meaning:
  ///
  /// For a C++ method: the call is virtual.
  /// For an Objective-C message: the receiver is an object instance, not 'super'
  /// or a specific class.
  ///
  /// If the method/message is "static" or the cursor does not point to a
  /// method/message, it will return zero.
  int clang_Cursor_isDynamicCall(CXCursor C) {
    return _clang_Cursor_isDynamicCall(C);
  }

  late final _clang_Cursor_isDynamicCallPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isDynamicCall>>(
        'clang_Cursor_isDynamicCall',
      );
  late final _clang_Cursor_isDynamicCall = _clang_Cursor_isDynamicCallPtr
      .asFunction<DartClang_Cursor_isDynamicCall>();

  /// Given a cursor pointing to an Objective-C message or property
  /// reference, or C++ method call, returns the CXType of the receiver.
  CXType clang_Cursor_getReceiverType(CXCursor C) {
    return _clang_Cursor_getReceiverType(C);
  }

  late final _clang_Cursor_getReceiverTypePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getReceiverType>>(
        'clang_Cursor_getReceiverType',
      );
  late final _clang_Cursor_getReceiverType = _clang_Cursor_getReceiverTypePtr
      .asFunction<DartClang_Cursor_getReceiverType>();

  /// Given a cursor that represents a property declaration, return the
  /// associated property attributes. The bits are formed from
  /// \c CXObjCPropertyAttrKind.
  ///
  /// \param reserved Reserved for future use, pass 0.
  int clang_Cursor_getObjCPropertyAttributes(CXCursor C, int reserved) {
    return _clang_Cursor_getObjCPropertyAttributes(C, reserved);
  }

  late final _clang_Cursor_getObjCPropertyAttributesPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getObjCPropertyAttributes>>(
        'clang_Cursor_getObjCPropertyAttributes',
      );
  late final _clang_Cursor_getObjCPropertyAttributes =
      _clang_Cursor_getObjCPropertyAttributesPtr
          .asFunction<DartClang_Cursor_getObjCPropertyAttributes>();

  /// Given a cursor that represents a property declaration, return the
  /// name of the method that implements the getter.
  CXString clang_Cursor_getObjCPropertyGetterName(CXCursor C) {
    return _clang_Cursor_getObjCPropertyGetterName(C);
  }

  late final _clang_Cursor_getObjCPropertyGetterNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getObjCPropertyGetterName>>(
        'clang_Cursor_getObjCPropertyGetterName',
      );
  late final _clang_Cursor_getObjCPropertyGetterName =
      _clang_Cursor_getObjCPropertyGetterNamePtr
          .asFunction<DartClang_Cursor_getObjCPropertyGetterName>();

  /// Given a cursor that represents a property declaration, return the
  /// name of the method that implements the setter, if any.
  CXString clang_Cursor_getObjCPropertySetterName(CXCursor C) {
    return _clang_Cursor_getObjCPropertySetterName(C);
  }

  late final _clang_Cursor_getObjCPropertySetterNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getObjCPropertySetterName>>(
        'clang_Cursor_getObjCPropertySetterName',
      );
  late final _clang_Cursor_getObjCPropertySetterName =
      _clang_Cursor_getObjCPropertySetterNamePtr
          .asFunction<DartClang_Cursor_getObjCPropertySetterName>();

  /// Given a cursor that represents an Objective-C method or parameter
  /// declaration, return the associated Objective-C qualifiers for the return
  /// type or the parameter respectively. The bits are formed from
  /// CXObjCDeclQualifierKind.
  int clang_Cursor_getObjCDeclQualifiers(CXCursor C) {
    return _clang_Cursor_getObjCDeclQualifiers(C);
  }

  late final _clang_Cursor_getObjCDeclQualifiersPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getObjCDeclQualifiers>>(
        'clang_Cursor_getObjCDeclQualifiers',
      );
  late final _clang_Cursor_getObjCDeclQualifiers =
      _clang_Cursor_getObjCDeclQualifiersPtr
          .asFunction<DartClang_Cursor_getObjCDeclQualifiers>();

  /// Given a cursor that represents an Objective-C method or property
  /// declaration, return non-zero if the declaration was affected by "\@optional".
  /// Returns zero if the cursor is not such a declaration or it is "\@required".
  int clang_Cursor_isObjCOptional(CXCursor C) {
    return _clang_Cursor_isObjCOptional(C);
  }

  late final _clang_Cursor_isObjCOptionalPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isObjCOptional>>(
        'clang_Cursor_isObjCOptional',
      );
  late final _clang_Cursor_isObjCOptional = _clang_Cursor_isObjCOptionalPtr
      .asFunction<DartClang_Cursor_isObjCOptional>();

  /// Returns non-zero if the given cursor is a variadic function or method.
  int clang_Cursor_isVariadic(CXCursor C) {
    return _clang_Cursor_isVariadic(C);
  }

  late final _clang_Cursor_isVariadicPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isVariadic>>(
        'clang_Cursor_isVariadic',
      );
  late final _clang_Cursor_isVariadic = _clang_Cursor_isVariadicPtr
      .asFunction<DartClang_Cursor_isVariadic>();

  /// Returns non-zero if the given cursor points to a symbol marked with
  /// external_source_symbol attribute.
  ///
  /// \param language If non-NULL, and the attribute is present, will be set to
  /// the 'language' string from the attribute.
  ///
  /// \param definedIn If non-NULL, and the attribute is present, will be set to
  /// the 'definedIn' string from the attribute.
  ///
  /// \param isGenerated If non-NULL, and the attribute is present, will be set to
  /// non-zero if the 'generated_declaration' is set in the attribute.
  int clang_Cursor_isExternalSymbol(
    CXCursor C,
    ffi.Pointer<CXString> language,
    ffi.Pointer<CXString> definedIn,
    ffi.Pointer<ffi.UnsignedInt> isGenerated,
  ) {
    return _clang_Cursor_isExternalSymbol(C, language, definedIn, isGenerated);
  }

  late final _clang_Cursor_isExternalSymbolPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_isExternalSymbol>>(
        'clang_Cursor_isExternalSymbol',
      );
  late final _clang_Cursor_isExternalSymbol = _clang_Cursor_isExternalSymbolPtr
      .asFunction<DartClang_Cursor_isExternalSymbol>();

  /// Given a cursor that represents a declaration, return the associated
  /// comment's source range.  The range may include multiple consecutive comments
  /// with whitespace in between.
  CXSourceRange clang_Cursor_getCommentRange(CXCursor C) {
    return _clang_Cursor_getCommentRange(C);
  }

  late final _clang_Cursor_getCommentRangePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getCommentRange>>(
        'clang_Cursor_getCommentRange',
      );
  late final _clang_Cursor_getCommentRange = _clang_Cursor_getCommentRangePtr
      .asFunction<DartClang_Cursor_getCommentRange>();

  /// Given a cursor that represents a declaration, return the associated
  /// comment text, including comment markers.
  CXString clang_Cursor_getRawCommentText(CXCursor C) {
    return _clang_Cursor_getRawCommentText(C);
  }

  late final _clang_Cursor_getRawCommentTextPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getRawCommentText>>(
        'clang_Cursor_getRawCommentText',
      );
  late final _clang_Cursor_getRawCommentText =
      _clang_Cursor_getRawCommentTextPtr
          .asFunction<DartClang_Cursor_getRawCommentText>();

  /// Given a cursor that represents a documentable entity (e.g.,
  /// declaration), return the associated \paragraph; otherwise return the
  /// first paragraph.
  CXString clang_Cursor_getBriefCommentText(CXCursor C) {
    return _clang_Cursor_getBriefCommentText(C);
  }

  late final _clang_Cursor_getBriefCommentTextPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getBriefCommentText>>(
        'clang_Cursor_getBriefCommentText',
      );
  late final _clang_Cursor_getBriefCommentText =
      _clang_Cursor_getBriefCommentTextPtr
          .asFunction<DartClang_Cursor_getBriefCommentText>();

  /// Retrieve the CXString representing the mangled name of the cursor.
  CXString clang_Cursor_getMangling(CXCursor arg0) {
    return _clang_Cursor_getMangling(arg0);
  }

  late final _clang_Cursor_getManglingPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getMangling>>(
        'clang_Cursor_getMangling',
      );
  late final _clang_Cursor_getMangling = _clang_Cursor_getManglingPtr
      .asFunction<DartClang_Cursor_getMangling>();

  /// Retrieve the CXStrings representing the mangled symbols of the C++
  /// constructor or destructor at the cursor.
  ffi.Pointer<CXStringSet> clang_Cursor_getCXXManglings(CXCursor arg0) {
    return _clang_Cursor_getCXXManglings(arg0);
  }

  late final _clang_Cursor_getCXXManglingsPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getCXXManglings>>(
        'clang_Cursor_getCXXManglings',
      );
  late final _clang_Cursor_getCXXManglings = _clang_Cursor_getCXXManglingsPtr
      .asFunction<DartClang_Cursor_getCXXManglings>();

  /// Retrieve the CXStrings representing the mangled symbols of the ObjC
  /// class interface or implementation at the cursor.
  ffi.Pointer<CXStringSet> clang_Cursor_getObjCManglings(CXCursor arg0) {
    return _clang_Cursor_getObjCManglings(arg0);
  }

  late final _clang_Cursor_getObjCManglingsPtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getObjCManglings>>(
        'clang_Cursor_getObjCManglings',
      );
  late final _clang_Cursor_getObjCManglings = _clang_Cursor_getObjCManglingsPtr
      .asFunction<DartClang_Cursor_getObjCManglings>();

  /// Given a CXCursor_ModuleImportDecl cursor, return the associated module.
  CXModule clang_Cursor_getModule(CXCursor C) {
    return _clang_Cursor_getModule(C);
  }

  late final _clang_Cursor_getModulePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_getModule>>(
        'clang_Cursor_getModule',
      );
  late final _clang_Cursor_getModule = _clang_Cursor_getModulePtr
      .asFunction<DartClang_Cursor_getModule>();

  /// Given a CXFile header file, return the module that contains it, if one
  /// exists.
  CXModule clang_getModuleForFile(CXTranslationUnit arg0, CXFile arg1) {
    return _clang_getModuleForFile(arg0, arg1);
  }

  late final _clang_getModuleForFilePtr =
      _lookup<ffi.NativeFunction<NativeClang_getModuleForFile>>(
        'clang_getModuleForFile',
      );
  late final _clang_getModuleForFile = _clang_getModuleForFilePtr
      .asFunction<DartClang_getModuleForFile>();

  /// \param Module a module object.
  ///
  /// \returns the module file where the provided module object came from.
  CXFile clang_Module_getASTFile(CXModule Module) {
    return _clang_Module_getASTFile(Module);
  }

  late final _clang_Module_getASTFilePtr =
      _lookup<ffi.NativeFunction<NativeClang_Module_getASTFile>>(
        'clang_Module_getASTFile',
      );
  late final _clang_Module_getASTFile = _clang_Module_getASTFilePtr
      .asFunction<DartClang_Module_getASTFile>();

  /// \param Module a module object.
  ///
  /// \returns the parent of a sub-module or NULL if the given module is top-level,
  /// e.g. for 'std.vector' it will return the 'std' module.
  CXModule clang_Module_getParent(CXModule Module) {
    return _clang_Module_getParent(Module);
  }

  late final _clang_Module_getParentPtr =
      _lookup<ffi.NativeFunction<NativeClang_Module_getParent>>(
        'clang_Module_getParent',
      );
  late final _clang_Module_getParent = _clang_Module_getParentPtr
      .asFunction<DartClang_Module_getParent>();

  /// \param Module a module object.
  ///
  /// \returns the name of the module, e.g. for the 'std.vector' sub-module it
  /// will return "vector".
  CXString clang_Module_getName(CXModule Module) {
    return _clang_Module_getName(Module);
  }

  late final _clang_Module_getNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_Module_getName>>(
        'clang_Module_getName',
      );
  late final _clang_Module_getName = _clang_Module_getNamePtr
      .asFunction<DartClang_Module_getName>();

  /// \param Module a module object.
  ///
  /// \returns the full name of the module, e.g. "std.vector".
  CXString clang_Module_getFullName(CXModule Module) {
    return _clang_Module_getFullName(Module);
  }

  late final _clang_Module_getFullNamePtr =
      _lookup<ffi.NativeFunction<NativeClang_Module_getFullName>>(
        'clang_Module_getFullName',
      );
  late final _clang_Module_getFullName = _clang_Module_getFullNamePtr
      .asFunction<DartClang_Module_getFullName>();

  /// \param Module a module object.
  ///
  /// \returns non-zero if the module is a system one.
  int clang_Module_isSystem(CXModule Module) {
    return _clang_Module_isSystem(Module);
  }

  late final _clang_Module_isSystemPtr =
      _lookup<ffi.NativeFunction<NativeClang_Module_isSystem>>(
        'clang_Module_isSystem',
      );
  late final _clang_Module_isSystem = _clang_Module_isSystemPtr
      .asFunction<DartClang_Module_isSystem>();

  /// \param Module a module object.
  ///
  /// \returns the number of top level headers associated with this module.
  int clang_Module_getNumTopLevelHeaders(
    CXTranslationUnit arg0,
    CXModule Module,
  ) {
    return _clang_Module_getNumTopLevelHeaders(arg0, Module);
  }

  late final _clang_Module_getNumTopLevelHeadersPtr =
      _lookup<ffi.NativeFunction<NativeClang_Module_getNumTopLevelHeaders>>(
        'clang_Module_getNumTopLevelHeaders',
      );
  late final _clang_Module_getNumTopLevelHeaders =
      _clang_Module_getNumTopLevelHeadersPtr
          .asFunction<DartClang_Module_getNumTopLevelHeaders>();

  /// \param Module a module object.
  ///
  /// \param Index top level header index (zero-based).
  ///
  /// \returns the specified top level header associated with the module.
  CXFile clang_Module_getTopLevelHeader(
    CXTranslationUnit arg0,
    CXModule Module,
    int Index,
  ) {
    return _clang_Module_getTopLevelHeader(arg0, Module, Index);
  }

  late final _clang_Module_getTopLevelHeaderPtr =
      _lookup<ffi.NativeFunction<NativeClang_Module_getTopLevelHeader>>(
        'clang_Module_getTopLevelHeader',
      );
  late final _clang_Module_getTopLevelHeader =
      _clang_Module_getTopLevelHeaderPtr
          .asFunction<DartClang_Module_getTopLevelHeader>();

  /// Determine if a C++ constructor is a converting constructor.
  int clang_CXXConstructor_isConvertingConstructor(CXCursor C) {
    return _clang_CXXConstructor_isConvertingConstructor(C);
  }

  late final _clang_CXXConstructor_isConvertingConstructorPtr =
      _lookup<
        ffi.NativeFunction<NativeClang_CXXConstructor_isConvertingConstructor>
      >('clang_CXXConstructor_isConvertingConstructor');
  late final _clang_CXXConstructor_isConvertingConstructor =
      _clang_CXXConstructor_isConvertingConstructorPtr
          .asFunction<DartClang_CXXConstructor_isConvertingConstructor>();

  /// Determine if a C++ constructor is a copy constructor.
  int clang_CXXConstructor_isCopyConstructor(CXCursor C) {
    return _clang_CXXConstructor_isCopyConstructor(C);
  }

  late final _clang_CXXConstructor_isCopyConstructorPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXXConstructor_isCopyConstructor>>(
        'clang_CXXConstructor_isCopyConstructor',
      );
  late final _clang_CXXConstructor_isCopyConstructor =
      _clang_CXXConstructor_isCopyConstructorPtr
          .asFunction<DartClang_CXXConstructor_isCopyConstructor>();

  /// Determine if a C++ constructor is the default constructor.
  int clang_CXXConstructor_isDefaultConstructor(CXCursor C) {
    return _clang_CXXConstructor_isDefaultConstructor(C);
  }

  late final _clang_CXXConstructor_isDefaultConstructorPtr =
      _lookup<
        ffi.NativeFunction<NativeClang_CXXConstructor_isDefaultConstructor>
      >('clang_CXXConstructor_isDefaultConstructor');
  late final _clang_CXXConstructor_isDefaultConstructor =
      _clang_CXXConstructor_isDefaultConstructorPtr
          .asFunction<DartClang_CXXConstructor_isDefaultConstructor>();

  /// Determine if a C++ constructor is a move constructor.
  int clang_CXXConstructor_isMoveConstructor(CXCursor C) {
    return _clang_CXXConstructor_isMoveConstructor(C);
  }

  late final _clang_CXXConstructor_isMoveConstructorPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXXConstructor_isMoveConstructor>>(
        'clang_CXXConstructor_isMoveConstructor',
      );
  late final _clang_CXXConstructor_isMoveConstructor =
      _clang_CXXConstructor_isMoveConstructorPtr
          .asFunction<DartClang_CXXConstructor_isMoveConstructor>();

  /// Determine if a C++ field is declared 'mutable'.
  int clang_CXXField_isMutable(CXCursor C) {
    return _clang_CXXField_isMutable(C);
  }

  late final _clang_CXXField_isMutablePtr =
      _lookup<ffi.NativeFunction<NativeClang_CXXField_isMutable>>(
        'clang_CXXField_isMutable',
      );
  late final _clang_CXXField_isMutable = _clang_CXXField_isMutablePtr
      .asFunction<DartClang_CXXField_isMutable>();

  /// Determine if a C++ method is declared '= default'.
  int clang_CXXMethod_isDefaulted(CXCursor C) {
    return _clang_CXXMethod_isDefaulted(C);
  }

  late final _clang_CXXMethod_isDefaultedPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXXMethod_isDefaulted>>(
        'clang_CXXMethod_isDefaulted',
      );
  late final _clang_CXXMethod_isDefaulted = _clang_CXXMethod_isDefaultedPtr
      .asFunction<DartClang_CXXMethod_isDefaulted>();

  /// Determine if a C++ member function or member function template is
  /// pure virtual.
  int clang_CXXMethod_isPureVirtual(CXCursor C) {
    return _clang_CXXMethod_isPureVirtual(C);
  }

  late final _clang_CXXMethod_isPureVirtualPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXXMethod_isPureVirtual>>(
        'clang_CXXMethod_isPureVirtual',
      );
  late final _clang_CXXMethod_isPureVirtual = _clang_CXXMethod_isPureVirtualPtr
      .asFunction<DartClang_CXXMethod_isPureVirtual>();

  /// Determine if a C++ member function or member function template is
  /// declared 'static'.
  int clang_CXXMethod_isStatic(CXCursor C) {
    return _clang_CXXMethod_isStatic(C);
  }

  late final _clang_CXXMethod_isStaticPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXXMethod_isStatic>>(
        'clang_CXXMethod_isStatic',
      );
  late final _clang_CXXMethod_isStatic = _clang_CXXMethod_isStaticPtr
      .asFunction<DartClang_CXXMethod_isStatic>();

  /// Determine if a C++ member function or member function template is
  /// explicitly declared 'virtual' or if it overrides a virtual method from
  /// one of the base classes.
  int clang_CXXMethod_isVirtual(CXCursor C) {
    return _clang_CXXMethod_isVirtual(C);
  }

  late final _clang_CXXMethod_isVirtualPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXXMethod_isVirtual>>(
        'clang_CXXMethod_isVirtual',
      );
  late final _clang_CXXMethod_isVirtual = _clang_CXXMethod_isVirtualPtr
      .asFunction<DartClang_CXXMethod_isVirtual>();

  /// Determine if a C++ record is abstract, i.e. whether a class or struct
  /// has a pure virtual member function.
  int clang_CXXRecord_isAbstract(CXCursor C) {
    return _clang_CXXRecord_isAbstract(C);
  }

  late final _clang_CXXRecord_isAbstractPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXXRecord_isAbstract>>(
        'clang_CXXRecord_isAbstract',
      );
  late final _clang_CXXRecord_isAbstract = _clang_CXXRecord_isAbstractPtr
      .asFunction<DartClang_CXXRecord_isAbstract>();

  /// Determine if an enum declaration refers to a scoped enum.
  int clang_EnumDecl_isScoped(CXCursor C) {
    return _clang_EnumDecl_isScoped(C);
  }

  late final _clang_EnumDecl_isScopedPtr =
      _lookup<ffi.NativeFunction<NativeClang_EnumDecl_isScoped>>(
        'clang_EnumDecl_isScoped',
      );
  late final _clang_EnumDecl_isScoped = _clang_EnumDecl_isScopedPtr
      .asFunction<DartClang_EnumDecl_isScoped>();

  /// Determine if a C++ member function or member function template is
  /// declared 'const'.
  int clang_CXXMethod_isConst(CXCursor C) {
    return _clang_CXXMethod_isConst(C);
  }

  late final _clang_CXXMethod_isConstPtr =
      _lookup<ffi.NativeFunction<NativeClang_CXXMethod_isConst>>(
        'clang_CXXMethod_isConst',
      );
  late final _clang_CXXMethod_isConst = _clang_CXXMethod_isConstPtr
      .asFunction<DartClang_CXXMethod_isConst>();

  /// Given a cursor that represents a template, determine
  /// the cursor kind of the specializations would be generated by instantiating
  /// the template.
  ///
  /// This routine can be used to determine what flavor of function template,
  /// class template, or class template partial specialization is stored in the
  /// cursor. For example, it can describe whether a class template cursor is
  /// declared with "struct", "class" or "union".
  ///
  /// \param C The cursor to query. This cursor should represent a template
  /// declaration.
  ///
  /// \returns The cursor kind of the specializations that would be generated
  /// by instantiating the template \p C. If \p C is not a template, returns
  /// \c CXCursor_NoDeclFound.
  CXCursorKind clang_getTemplateCursorKind(CXCursor C) {
    return CXCursorKind.fromValue(_clang_getTemplateCursorKind(C));
  }

  late final _clang_getTemplateCursorKindPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTemplateCursorKind>>(
        'clang_getTemplateCursorKind',
      );
  late final _clang_getTemplateCursorKind = _clang_getTemplateCursorKindPtr
      .asFunction<DartClang_getTemplateCursorKind>();

  /// Given a cursor that may represent a specialization or instantiation
  /// of a template, retrieve the cursor that represents the template that it
  /// specializes or from which it was instantiated.
  ///
  /// This routine determines the template involved both for explicit
  /// specializations of templates and for implicit instantiations of the template,
  /// both of which are referred to as "specializations". For a class template
  /// specialization (e.g., \c std::vector<bool>), this routine will return
  /// either the primary template (\c std::vector) or, if the specialization was
  /// instantiated from a class template partial specialization, the class template
  /// partial specialization. For a class template partial specialization and a
  /// function template specialization (including instantiations), this
  /// this routine will return the specialized template.
  ///
  /// For members of a class template (e.g., member functions, member classes, or
  /// static data members), returns the specialized or instantiated member.
  /// Although not strictly "templates" in the C++ language, members of class
  /// templates have the same notions of specializations and instantiations that
  /// templates do, so this routine treats them similarly.
  ///
  /// \param C A cursor that may be a specialization of a template or a member
  /// of a template.
  ///
  /// \returns If the given cursor is a specialization or instantiation of a
  /// template or a member thereof, the template or member that it specializes or
  /// from which it was instantiated. Otherwise, returns a NULL cursor.
  CXCursor clang_getSpecializedCursorTemplate(CXCursor C) {
    return _clang_getSpecializedCursorTemplate(C);
  }

  late final _clang_getSpecializedCursorTemplatePtr =
      _lookup<ffi.NativeFunction<NativeClang_getSpecializedCursorTemplate>>(
        'clang_getSpecializedCursorTemplate',
      );
  late final _clang_getSpecializedCursorTemplate =
      _clang_getSpecializedCursorTemplatePtr
          .asFunction<DartClang_getSpecializedCursorTemplate>();

  /// Given a cursor that references something else, return the source range
  /// covering that reference.
  ///
  /// \param C A cursor pointing to a member reference, a declaration reference, or
  /// an operator call.
  /// \param NameFlags A bitset with three independent flags:
  /// CXNameRange_WantQualifier, CXNameRange_WantTemplateArgs, and
  /// CXNameRange_WantSinglePiece.
  /// \param PieceIndex For contiguous names or when passing the flag
  /// CXNameRange_WantSinglePiece, only one piece with index 0 is
  /// available. When the CXNameRange_WantSinglePiece flag is not passed for a
  /// non-contiguous names, this index can be used to retrieve the individual
  /// pieces of the name. See also CXNameRange_WantSinglePiece.
  ///
  /// \returns The piece of the name pointed to by the given cursor. If there is no
  /// name, or if the PieceIndex is out-of-range, a null-cursor will be returned.
  CXSourceRange clang_getCursorReferenceNameRange(
    CXCursor C,
    int NameFlags,
    int PieceIndex,
  ) {
    return _clang_getCursorReferenceNameRange(C, NameFlags, PieceIndex);
  }

  late final _clang_getCursorReferenceNameRangePtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorReferenceNameRange>>(
        'clang_getCursorReferenceNameRange',
      );
  late final _clang_getCursorReferenceNameRange =
      _clang_getCursorReferenceNameRangePtr
          .asFunction<DartClang_getCursorReferenceNameRange>();

  /// Get the raw lexical token starting with the given location.
  ///
  /// \param TU the translation unit whose text is being tokenized.
  ///
  /// \param Location the source location with which the token starts.
  ///
  /// \returns The token starting with the given location or NULL if no such token
  /// exist. The returned pointer must be freed with clang_disposeTokens before the
  /// translation unit is destroyed.
  ffi.Pointer<CXToken> clang_getToken(
    CXTranslationUnit TU,
    CXSourceLocation Location,
  ) {
    return _clang_getToken(TU, Location);
  }

  late final _clang_getTokenPtr =
      _lookup<ffi.NativeFunction<NativeClang_getToken>>('clang_getToken');
  late final _clang_getToken = _clang_getTokenPtr
      .asFunction<DartClang_getToken>();

  /// Determine the kind of the given token.
  CXTokenKind clang_getTokenKind(CXToken arg0) {
    return CXTokenKind.fromValue(_clang_getTokenKind(arg0));
  }

  late final _clang_getTokenKindPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTokenKind>>(
        'clang_getTokenKind',
      );
  late final _clang_getTokenKind = _clang_getTokenKindPtr
      .asFunction<DartClang_getTokenKind>();

  /// Determine the spelling of the given token.
  ///
  /// The spelling of a token is the textual representation of that token, e.g.,
  /// the text of an identifier or keyword.
  CXString clang_getTokenSpelling(CXTranslationUnit arg0, CXToken arg1) {
    return _clang_getTokenSpelling(arg0, arg1);
  }

  late final _clang_getTokenSpellingPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTokenSpelling>>(
        'clang_getTokenSpelling',
      );
  late final _clang_getTokenSpelling = _clang_getTokenSpellingPtr
      .asFunction<DartClang_getTokenSpelling>();

  /// Retrieve the source location of the given token.
  CXSourceLocation clang_getTokenLocation(
    CXTranslationUnit arg0,
    CXToken arg1,
  ) {
    return _clang_getTokenLocation(arg0, arg1);
  }

  late final _clang_getTokenLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTokenLocation>>(
        'clang_getTokenLocation',
      );
  late final _clang_getTokenLocation = _clang_getTokenLocationPtr
      .asFunction<DartClang_getTokenLocation>();

  /// Retrieve a source range that covers the given token.
  CXSourceRange clang_getTokenExtent(CXTranslationUnit arg0, CXToken arg1) {
    return _clang_getTokenExtent(arg0, arg1);
  }

  late final _clang_getTokenExtentPtr =
      _lookup<ffi.NativeFunction<NativeClang_getTokenExtent>>(
        'clang_getTokenExtent',
      );
  late final _clang_getTokenExtent = _clang_getTokenExtentPtr
      .asFunction<DartClang_getTokenExtent>();

  /// Tokenize the source code described by the given range into raw
  /// lexical tokens.
  ///
  /// \param TU the translation unit whose text is being tokenized.
  ///
  /// \param Range the source range in which text should be tokenized. All of the
  /// tokens produced by tokenization will fall within this source range,
  ///
  /// \param Tokens this pointer will be set to point to the array of tokens
  /// that occur within the given source range. The returned pointer must be
  /// freed with clang_disposeTokens() before the translation unit is destroyed.
  ///
  /// \param NumTokens will be set to the number of tokens in the \c *Tokens
  /// array.
  void clang_tokenize(
    CXTranslationUnit TU,
    CXSourceRange Range,
    ffi.Pointer<ffi.Pointer<CXToken>> Tokens,
    ffi.Pointer<ffi.UnsignedInt> NumTokens,
  ) {
    return _clang_tokenize(TU, Range, Tokens, NumTokens);
  }

  late final _clang_tokenizePtr =
      _lookup<ffi.NativeFunction<NativeClang_tokenize>>('clang_tokenize');
  late final _clang_tokenize = _clang_tokenizePtr
      .asFunction<DartClang_tokenize>();

  /// Annotate the given set of tokens by providing cursors for each token
  /// that can be mapped to a specific entity within the abstract syntax tree.
  ///
  /// This token-annotation routine is equivalent to invoking
  /// clang_getCursor() for the source locations of each of the
  /// tokens. The cursors provided are filtered, so that only those
  /// cursors that have a direct correspondence to the token are
  /// accepted. For example, given a function call \c f(x),
  /// clang_getCursor() would provide the following cursors:
  ///
  /// * when the cursor is over the 'f', a DeclRefExpr cursor referring to 'f'.
  /// * when the cursor is over the '(' or the ')', a CallExpr referring to 'f'.
  /// * when the cursor is over the 'x', a DeclRefExpr cursor referring to 'x'.
  ///
  /// Only the first and last of these cursors will occur within the
  /// annotate, since the tokens "f" and "x' directly refer to a function
  /// and a variable, respectively, but the parentheses are just a small
  /// part of the full syntax of the function call expression, which is
  /// not provided as an annotation.
  ///
  /// \param TU the translation unit that owns the given tokens.
  ///
  /// \param Tokens the set of tokens to annotate.
  ///
  /// \param NumTokens the number of tokens in \p Tokens.
  ///
  /// \param Cursors an array of \p NumTokens cursors, whose contents will be
  /// replaced with the cursors corresponding to each token.
  void clang_annotateTokens(
    CXTranslationUnit TU,
    ffi.Pointer<CXToken> Tokens,
    int NumTokens,
    ffi.Pointer<CXCursor> Cursors,
  ) {
    return _clang_annotateTokens(TU, Tokens, NumTokens, Cursors);
  }

  late final _clang_annotateTokensPtr =
      _lookup<ffi.NativeFunction<NativeClang_annotateTokens>>(
        'clang_annotateTokens',
      );
  late final _clang_annotateTokens = _clang_annotateTokensPtr
      .asFunction<DartClang_annotateTokens>();

  /// Free the given set of tokens.
  void clang_disposeTokens(
    CXTranslationUnit TU,
    ffi.Pointer<CXToken> Tokens,
    int NumTokens,
  ) {
    return _clang_disposeTokens(TU, Tokens, NumTokens);
  }

  late final _clang_disposeTokensPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeTokens>>(
        'clang_disposeTokens',
      );
  late final _clang_disposeTokens = _clang_disposeTokensPtr
      .asFunction<DartClang_disposeTokens>();

  /// \defgroup CINDEX_DEBUG Debugging facilities
  ///
  /// These routines are used for testing and debugging, only, and should not
  /// be relied upon.
  ///
  /// @{
  CXString clang_getCursorKindSpelling(CXCursorKind Kind) {
    return _clang_getCursorKindSpelling(Kind.value);
  }

  late final _clang_getCursorKindSpellingPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorKindSpelling>>(
        'clang_getCursorKindSpelling',
      );
  late final _clang_getCursorKindSpelling = _clang_getCursorKindSpellingPtr
      .asFunction<DartClang_getCursorKindSpelling>();

  void clang_getDefinitionSpellingAndExtent(
    CXCursor arg0,
    ffi.Pointer<ffi.Pointer<ffi.Char>> startBuf,
    ffi.Pointer<ffi.Pointer<ffi.Char>> endBuf,
    ffi.Pointer<ffi.UnsignedInt> startLine,
    ffi.Pointer<ffi.UnsignedInt> startColumn,
    ffi.Pointer<ffi.UnsignedInt> endLine,
    ffi.Pointer<ffi.UnsignedInt> endColumn,
  ) {
    return _clang_getDefinitionSpellingAndExtent(
      arg0,
      startBuf,
      endBuf,
      startLine,
      startColumn,
      endLine,
      endColumn,
    );
  }

  late final _clang_getDefinitionSpellingAndExtentPtr =
      _lookup<ffi.NativeFunction<NativeClang_getDefinitionSpellingAndExtent>>(
        'clang_getDefinitionSpellingAndExtent',
      );
  late final _clang_getDefinitionSpellingAndExtent =
      _clang_getDefinitionSpellingAndExtentPtr
          .asFunction<DartClang_getDefinitionSpellingAndExtent>();

  void clang_enableStackTraces() {
    return _clang_enableStackTraces();
  }

  late final _clang_enableStackTracesPtr =
      _lookup<ffi.NativeFunction<NativeClang_enableStackTraces>>(
        'clang_enableStackTraces',
      );
  late final _clang_enableStackTraces = _clang_enableStackTracesPtr
      .asFunction<DartClang_enableStackTraces>();

  void clang_executeOnThread(
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
    fn,
    ffi.Pointer<ffi.Void> user_data,
    int stack_size,
  ) {
    return _clang_executeOnThread(fn, user_data, stack_size);
  }

  late final _clang_executeOnThreadPtr =
      _lookup<ffi.NativeFunction<NativeClang_executeOnThread>>(
        'clang_executeOnThread',
      );
  late final _clang_executeOnThread = _clang_executeOnThreadPtr
      .asFunction<DartClang_executeOnThread>();

  /// Determine the kind of a particular chunk within a completion string.
  ///
  /// \param completion_string the completion string to query.
  ///
  /// \param chunk_number the 0-based index of the chunk in the completion string.
  ///
  /// \returns the kind of the chunk at the index \c chunk_number.
  CXCompletionChunkKind clang_getCompletionChunkKind(
    CXCompletionString completion_string,
    int chunk_number,
  ) {
    return CXCompletionChunkKind.fromValue(
      _clang_getCompletionChunkKind(completion_string, chunk_number),
    );
  }

  late final _clang_getCompletionChunkKindPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionChunkKind>>(
        'clang_getCompletionChunkKind',
      );
  late final _clang_getCompletionChunkKind = _clang_getCompletionChunkKindPtr
      .asFunction<DartClang_getCompletionChunkKind>();

  /// Retrieve the text associated with a particular chunk within a
  /// completion string.
  ///
  /// \param completion_string the completion string to query.
  ///
  /// \param chunk_number the 0-based index of the chunk in the completion string.
  ///
  /// \returns the text associated with the chunk at index \c chunk_number.
  CXString clang_getCompletionChunkText(
    CXCompletionString completion_string,
    int chunk_number,
  ) {
    return _clang_getCompletionChunkText(completion_string, chunk_number);
  }

  late final _clang_getCompletionChunkTextPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionChunkText>>(
        'clang_getCompletionChunkText',
      );
  late final _clang_getCompletionChunkText = _clang_getCompletionChunkTextPtr
      .asFunction<DartClang_getCompletionChunkText>();

  /// Retrieve the completion string associated with a particular chunk
  /// within a completion string.
  ///
  /// \param completion_string the completion string to query.
  ///
  /// \param chunk_number the 0-based index of the chunk in the completion string.
  ///
  /// \returns the completion string associated with the chunk at index
  /// \c chunk_number.
  CXCompletionString clang_getCompletionChunkCompletionString(
    CXCompletionString completion_string,
    int chunk_number,
  ) {
    return _clang_getCompletionChunkCompletionString(
      completion_string,
      chunk_number,
    );
  }

  late final _clang_getCompletionChunkCompletionStringPtr =
      _lookup<
        ffi.NativeFunction<NativeClang_getCompletionChunkCompletionString>
      >('clang_getCompletionChunkCompletionString');
  late final _clang_getCompletionChunkCompletionString =
      _clang_getCompletionChunkCompletionStringPtr
          .asFunction<DartClang_getCompletionChunkCompletionString>();

  /// Retrieve the number of chunks in the given code-completion string.
  int clang_getNumCompletionChunks(CXCompletionString completion_string) {
    return _clang_getNumCompletionChunks(completion_string);
  }

  late final _clang_getNumCompletionChunksPtr =
      _lookup<ffi.NativeFunction<NativeClang_getNumCompletionChunks>>(
        'clang_getNumCompletionChunks',
      );
  late final _clang_getNumCompletionChunks = _clang_getNumCompletionChunksPtr
      .asFunction<DartClang_getNumCompletionChunks>();

  /// Determine the priority of this code completion.
  ///
  /// The priority of a code completion indicates how likely it is that this
  /// particular completion is the completion that the user will select. The
  /// priority is selected by various internal heuristics.
  ///
  /// \param completion_string The completion string to query.
  ///
  /// \returns The priority of this completion string. Smaller values indicate
  /// higher-priority (more likely) completions.
  int clang_getCompletionPriority(CXCompletionString completion_string) {
    return _clang_getCompletionPriority(completion_string);
  }

  late final _clang_getCompletionPriorityPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionPriority>>(
        'clang_getCompletionPriority',
      );
  late final _clang_getCompletionPriority = _clang_getCompletionPriorityPtr
      .asFunction<DartClang_getCompletionPriority>();

  /// Determine the availability of the entity that this code-completion
  /// string refers to.
  ///
  /// \param completion_string The completion string to query.
  ///
  /// \returns The availability of the completion string.
  CXAvailabilityKind clang_getCompletionAvailability(
    CXCompletionString completion_string,
  ) {
    return CXAvailabilityKind.fromValue(
      _clang_getCompletionAvailability(completion_string),
    );
  }

  late final _clang_getCompletionAvailabilityPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionAvailability>>(
        'clang_getCompletionAvailability',
      );
  late final _clang_getCompletionAvailability =
      _clang_getCompletionAvailabilityPtr
          .asFunction<DartClang_getCompletionAvailability>();

  /// Retrieve the number of annotations associated with the given
  /// completion string.
  ///
  /// \param completion_string the completion string to query.
  ///
  /// \returns the number of annotations associated with the given completion
  /// string.
  int clang_getCompletionNumAnnotations(CXCompletionString completion_string) {
    return _clang_getCompletionNumAnnotations(completion_string);
  }

  late final _clang_getCompletionNumAnnotationsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionNumAnnotations>>(
        'clang_getCompletionNumAnnotations',
      );
  late final _clang_getCompletionNumAnnotations =
      _clang_getCompletionNumAnnotationsPtr
          .asFunction<DartClang_getCompletionNumAnnotations>();

  /// Retrieve the annotation associated with the given completion string.
  ///
  /// \param completion_string the completion string to query.
  ///
  /// \param annotation_number the 0-based index of the annotation of the
  /// completion string.
  ///
  /// \returns annotation string associated with the completion at index
  /// \c annotation_number, or a NULL string if that annotation is not available.
  CXString clang_getCompletionAnnotation(
    CXCompletionString completion_string,
    int annotation_number,
  ) {
    return _clang_getCompletionAnnotation(completion_string, annotation_number);
  }

  late final _clang_getCompletionAnnotationPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionAnnotation>>(
        'clang_getCompletionAnnotation',
      );
  late final _clang_getCompletionAnnotation = _clang_getCompletionAnnotationPtr
      .asFunction<DartClang_getCompletionAnnotation>();

  /// Retrieve the parent context of the given completion string.
  ///
  /// The parent context of a completion string is the semantic parent of
  /// the declaration (if any) that the code completion represents. For example,
  /// a code completion for an Objective-C method would have the method's class
  /// or protocol as its context.
  ///
  /// \param completion_string The code completion string whose parent is
  /// being queried.
  ///
  /// \param kind DEPRECATED: always set to CXCursor_NotImplemented if non-NULL.
  ///
  /// \returns The name of the completion parent, e.g., "NSObject" if
  /// the completion string represents a method in the NSObject class.
  CXString clang_getCompletionParent(
    CXCompletionString completion_string,
    ffi.Pointer<ffi.UnsignedInt> kind,
  ) {
    return _clang_getCompletionParent(completion_string, kind);
  }

  late final _clang_getCompletionParentPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionParent>>(
        'clang_getCompletionParent',
      );
  late final _clang_getCompletionParent = _clang_getCompletionParentPtr
      .asFunction<DartClang_getCompletionParent>();

  /// Retrieve the brief documentation comment attached to the declaration
  /// that corresponds to the given completion string.
  CXString clang_getCompletionBriefComment(
    CXCompletionString completion_string,
  ) {
    return _clang_getCompletionBriefComment(completion_string);
  }

  late final _clang_getCompletionBriefCommentPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionBriefComment>>(
        'clang_getCompletionBriefComment',
      );
  late final _clang_getCompletionBriefComment =
      _clang_getCompletionBriefCommentPtr
          .asFunction<DartClang_getCompletionBriefComment>();

  /// Retrieve a completion string for an arbitrary declaration or macro
  /// definition cursor.
  ///
  /// \param cursor The cursor to query.
  ///
  /// \returns A non-context-sensitive completion string for declaration and macro
  /// definition cursors, or NULL for other kinds of cursors.
  CXCompletionString clang_getCursorCompletionString(CXCursor cursor) {
    return _clang_getCursorCompletionString(cursor);
  }

  late final _clang_getCursorCompletionStringPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCursorCompletionString>>(
        'clang_getCursorCompletionString',
      );
  late final _clang_getCursorCompletionString =
      _clang_getCursorCompletionStringPtr
          .asFunction<DartClang_getCursorCompletionString>();

  /// Retrieve the number of fix-its for the given completion index.
  ///
  /// Calling this makes sense only if CXCodeComplete_IncludeCompletionsWithFixIts
  /// option was set.
  ///
  /// \param results The structure keeping all completion results
  ///
  /// \param completion_index The index of the completion
  ///
  /// \return The number of fix-its which must be applied before the completion at
  /// completion_index can be applied
  int clang_getCompletionNumFixIts(
    ffi.Pointer<CXCodeCompleteResults> results,
    int completion_index,
  ) {
    return _clang_getCompletionNumFixIts(results, completion_index);
  }

  late final _clang_getCompletionNumFixItsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionNumFixIts>>(
        'clang_getCompletionNumFixIts',
      );
  late final _clang_getCompletionNumFixIts = _clang_getCompletionNumFixItsPtr
      .asFunction<DartClang_getCompletionNumFixIts>();

  /// Fix-its that *must* be applied before inserting the text for the
  /// corresponding completion.
  ///
  /// By default, clang_codeCompleteAt() only returns completions with empty
  /// fix-its. Extra completions with non-empty fix-its should be explicitly
  /// requested by setting CXCodeComplete_IncludeCompletionsWithFixIts.
  ///
  /// For the clients to be able to compute position of the cursor after applying
  /// fix-its, the following conditions are guaranteed to hold for
  /// replacement_range of the stored fix-its:
  /// - Ranges in the fix-its are guaranteed to never contain the completion
  /// point (or identifier under completion point, if any) inside them, except
  /// at the start or at the end of the range.
  /// - If a fix-it range starts or ends with completion point (or starts or
  /// ends after the identifier under completion point), it will contain at
  /// least one character. It allows to unambiguously recompute completion
  /// point after applying the fix-it.
  ///
  /// The intuition is that provided fix-its change code around the identifier we
  /// complete, but are not allowed to touch the identifier itself or the
  /// completion point. One example of completions with corrections are the ones
  /// replacing '.' with '->' and vice versa:
  ///
  /// std::unique_ptr<std::vector<int>> vec_ptr;
  /// In 'vec_ptr.^', one of the completions is 'push_back', it requires
  /// replacing '.' with '->'.
  /// In 'vec_ptr->^', one of the completions is 'release', it requires
  /// replacing '->' with '.'.
  ///
  /// \param results The structure keeping all completion results
  ///
  /// \param completion_index The index of the completion
  ///
  /// \param fixit_index The index of the fix-it for the completion at
  /// completion_index
  ///
  /// \param replacement_range The fix-it range that must be replaced before the
  /// completion at completion_index can be applied
  ///
  /// \returns The fix-it string that must replace the code at replacement_range
  /// before the completion at completion_index can be applied
  CXString clang_getCompletionFixIt(
    ffi.Pointer<CXCodeCompleteResults> results,
    int completion_index,
    int fixit_index,
    ffi.Pointer<CXSourceRange> replacement_range,
  ) {
    return _clang_getCompletionFixIt(
      results,
      completion_index,
      fixit_index,
      replacement_range,
    );
  }

  late final _clang_getCompletionFixItPtr =
      _lookup<ffi.NativeFunction<NativeClang_getCompletionFixIt>>(
        'clang_getCompletionFixIt',
      );
  late final _clang_getCompletionFixIt = _clang_getCompletionFixItPtr
      .asFunction<DartClang_getCompletionFixIt>();

  /// Returns a default set of code-completion options that can be
  /// passed to\c clang_codeCompleteAt().
  int clang_defaultCodeCompleteOptions() {
    return _clang_defaultCodeCompleteOptions();
  }

  late final _clang_defaultCodeCompleteOptionsPtr =
      _lookup<ffi.NativeFunction<NativeClang_defaultCodeCompleteOptions>>(
        'clang_defaultCodeCompleteOptions',
      );
  late final _clang_defaultCodeCompleteOptions =
      _clang_defaultCodeCompleteOptionsPtr
          .asFunction<DartClang_defaultCodeCompleteOptions>();

  /// Perform code completion at a given location in a translation unit.
  ///
  /// This function performs code completion at a particular file, line, and
  /// column within source code, providing results that suggest potential
  /// code snippets based on the context of the completion. The basic model
  /// for code completion is that Clang will parse a complete source file,
  /// performing syntax checking up to the location where code-completion has
  /// been requested. At that point, a special code-completion token is passed
  /// to the parser, which recognizes this token and determines, based on the
  /// current location in the C/Objective-C/C++ grammar and the state of
  /// semantic analysis, what completions to provide. These completions are
  /// returned via a new \c CXCodeCompleteResults structure.
  ///
  /// Code completion itself is meant to be triggered by the client when the
  /// user types punctuation characters or whitespace, at which point the
  /// code-completion location will coincide with the cursor. For example, if \c p
  /// is a pointer, code-completion might be triggered after the "-" and then
  /// after the ">" in \c p->. When the code-completion location is after the ">",
  /// the completion results will provide, e.g., the members of the struct that
  /// "p" points to. The client is responsible for placing the cursor at the
  /// beginning of the token currently being typed, then filtering the results
  /// based on the contents of the token. For example, when code-completing for
  /// the expression \c p->get, the client should provide the location just after
  /// the ">" (e.g., pointing at the "g") to this code-completion hook. Then, the
  /// client can filter the results based on the current token text ("get"), only
  /// showing those results that start with "get". The intent of this interface
  /// is to separate the relatively high-latency acquisition of code-completion
  /// results from the filtering of results on a per-character basis, which must
  /// have a lower latency.
  ///
  /// \param TU The translation unit in which code-completion should
  /// occur. The source files for this translation unit need not be
  /// completely up-to-date (and the contents of those source files may
  /// be overridden via \p unsaved_files). Cursors referring into the
  /// translation unit may be invalidated by this invocation.
  ///
  /// \param complete_filename The name of the source file where code
  /// completion should be performed. This filename may be any file
  /// included in the translation unit.
  ///
  /// \param complete_line The line at which code-completion should occur.
  ///
  /// \param complete_column The column at which code-completion should occur.
  /// Note that the column should point just after the syntactic construct that
  /// initiated code completion, and not in the middle of a lexical token.
  ///
  /// \param unsaved_files the Files that have not yet been saved to disk
  /// but may be required for parsing or code completion, including the
  /// contents of those files.  The contents and name of these files (as
  /// specified by CXUnsavedFile) are copied when necessary, so the
  /// client only needs to guarantee their validity until the call to
  /// this function returns.
  ///
  /// \param num_unsaved_files The number of unsaved file entries in \p
  /// unsaved_files.
  ///
  /// \param options Extra options that control the behavior of code
  /// completion, expressed as a bitwise OR of the enumerators of the
  /// CXCodeComplete_Flags enumeration. The
  /// \c clang_defaultCodeCompleteOptions() function returns a default set
  /// of code-completion options.
  ///
  /// \returns If successful, a new \c CXCodeCompleteResults structure
  /// containing code-completion results, which should eventually be
  /// freed with \c clang_disposeCodeCompleteResults(). If code
  /// completion fails, returns NULL.
  ffi.Pointer<CXCodeCompleteResults> clang_codeCompleteAt(
    CXTranslationUnit TU,
    ffi.Pointer<ffi.Char> complete_filename,
    int complete_line,
    int complete_column,
    ffi.Pointer<CXUnsavedFile> unsaved_files,
    int num_unsaved_files,
    int options,
  ) {
    return _clang_codeCompleteAt(
      TU,
      complete_filename,
      complete_line,
      complete_column,
      unsaved_files,
      num_unsaved_files,
      options,
    );
  }

  late final _clang_codeCompleteAtPtr =
      _lookup<ffi.NativeFunction<NativeClang_codeCompleteAt>>(
        'clang_codeCompleteAt',
      );
  late final _clang_codeCompleteAt = _clang_codeCompleteAtPtr
      .asFunction<DartClang_codeCompleteAt>();

  /// Sort the code-completion results in case-insensitive alphabetical
  /// order.
  ///
  /// \param Results The set of results to sort.
  /// \param NumResults The number of results in \p Results.
  void clang_sortCodeCompletionResults(
    ffi.Pointer<CXCompletionResult> Results,
    int NumResults,
  ) {
    return _clang_sortCodeCompletionResults(Results, NumResults);
  }

  late final _clang_sortCodeCompletionResultsPtr =
      _lookup<ffi.NativeFunction<NativeClang_sortCodeCompletionResults>>(
        'clang_sortCodeCompletionResults',
      );
  late final _clang_sortCodeCompletionResults =
      _clang_sortCodeCompletionResultsPtr
          .asFunction<DartClang_sortCodeCompletionResults>();

  /// Free the given set of code-completion results.
  void clang_disposeCodeCompleteResults(
    ffi.Pointer<CXCodeCompleteResults> Results,
  ) {
    return _clang_disposeCodeCompleteResults(Results);
  }

  late final _clang_disposeCodeCompleteResultsPtr =
      _lookup<ffi.NativeFunction<NativeClang_disposeCodeCompleteResults>>(
        'clang_disposeCodeCompleteResults',
      );
  late final _clang_disposeCodeCompleteResults =
      _clang_disposeCodeCompleteResultsPtr
          .asFunction<DartClang_disposeCodeCompleteResults>();

  /// Determine the number of diagnostics produced prior to the
  /// location where code completion was performed.
  int clang_codeCompleteGetNumDiagnostics(
    ffi.Pointer<CXCodeCompleteResults> Results,
  ) {
    return _clang_codeCompleteGetNumDiagnostics(Results);
  }

  late final _clang_codeCompleteGetNumDiagnosticsPtr =
      _lookup<ffi.NativeFunction<NativeClang_codeCompleteGetNumDiagnostics>>(
        'clang_codeCompleteGetNumDiagnostics',
      );
  late final _clang_codeCompleteGetNumDiagnostics =
      _clang_codeCompleteGetNumDiagnosticsPtr
          .asFunction<DartClang_codeCompleteGetNumDiagnostics>();

  /// Retrieve a diagnostic associated with the given code completion.
  ///
  /// \param Results the code completion results to query.
  /// \param Index the zero-based diagnostic number to retrieve.
  ///
  /// \returns the requested diagnostic. This diagnostic must be freed
  /// via a call to \c clang_disposeDiagnostic().
  CXDiagnostic clang_codeCompleteGetDiagnostic(
    ffi.Pointer<CXCodeCompleteResults> Results,
    int Index,
  ) {
    return _clang_codeCompleteGetDiagnostic(Results, Index);
  }

  late final _clang_codeCompleteGetDiagnosticPtr =
      _lookup<ffi.NativeFunction<NativeClang_codeCompleteGetDiagnostic>>(
        'clang_codeCompleteGetDiagnostic',
      );
  late final _clang_codeCompleteGetDiagnostic =
      _clang_codeCompleteGetDiagnosticPtr
          .asFunction<DartClang_codeCompleteGetDiagnostic>();

  /// Determines what completions are appropriate for the context
  /// the given code completion.
  ///
  /// \param Results the code completion results to query
  ///
  /// \returns the kinds of completions that are appropriate for use
  /// along with the given code completion results.
  int clang_codeCompleteGetContexts(
    ffi.Pointer<CXCodeCompleteResults> Results,
  ) {
    return _clang_codeCompleteGetContexts(Results);
  }

  late final _clang_codeCompleteGetContextsPtr =
      _lookup<ffi.NativeFunction<NativeClang_codeCompleteGetContexts>>(
        'clang_codeCompleteGetContexts',
      );
  late final _clang_codeCompleteGetContexts = _clang_codeCompleteGetContextsPtr
      .asFunction<DartClang_codeCompleteGetContexts>();

  /// Returns the cursor kind for the container for the current code
  /// completion context. The container is only guaranteed to be set for
  /// contexts where a container exists (i.e. member accesses or Objective-C
  /// message sends); if there is not a container, this function will return
  /// CXCursor_InvalidCode.
  ///
  /// \param Results the code completion results to query
  ///
  /// \param IsIncomplete on return, this value will be false if Clang has complete
  /// information about the container. If Clang does not have complete
  /// information, this value will be true.
  ///
  /// \returns the container kind, or CXCursor_InvalidCode if there is not a
  /// container
  CXCursorKind clang_codeCompleteGetContainerKind(
    ffi.Pointer<CXCodeCompleteResults> Results,
    ffi.Pointer<ffi.UnsignedInt> IsIncomplete,
  ) {
    return CXCursorKind.fromValue(
      _clang_codeCompleteGetContainerKind(Results, IsIncomplete),
    );
  }

  late final _clang_codeCompleteGetContainerKindPtr =
      _lookup<ffi.NativeFunction<NativeClang_codeCompleteGetContainerKind>>(
        'clang_codeCompleteGetContainerKind',
      );
  late final _clang_codeCompleteGetContainerKind =
      _clang_codeCompleteGetContainerKindPtr
          .asFunction<DartClang_codeCompleteGetContainerKind>();

  /// Returns the USR for the container for the current code completion
  /// context. If there is not a container for the current context, this
  /// function will return the empty string.
  ///
  /// \param Results the code completion results to query
  ///
  /// \returns the USR for the container
  CXString clang_codeCompleteGetContainerUSR(
    ffi.Pointer<CXCodeCompleteResults> Results,
  ) {
    return _clang_codeCompleteGetContainerUSR(Results);
  }

  late final _clang_codeCompleteGetContainerUSRPtr =
      _lookup<ffi.NativeFunction<NativeClang_codeCompleteGetContainerUSR>>(
        'clang_codeCompleteGetContainerUSR',
      );
  late final _clang_codeCompleteGetContainerUSR =
      _clang_codeCompleteGetContainerUSRPtr
          .asFunction<DartClang_codeCompleteGetContainerUSR>();

  /// Returns the currently-entered selector for an Objective-C message
  /// send, formatted like "initWithFoo:bar:". Only guaranteed to return a
  /// non-empty string for CXCompletionContext_ObjCInstanceMessage and
  /// CXCompletionContext_ObjCClassMessage.
  ///
  /// \param Results the code completion results to query
  ///
  /// \returns the selector (or partial selector) that has been entered thus far
  /// for an Objective-C message send.
  CXString clang_codeCompleteGetObjCSelector(
    ffi.Pointer<CXCodeCompleteResults> Results,
  ) {
    return _clang_codeCompleteGetObjCSelector(Results);
  }

  late final _clang_codeCompleteGetObjCSelectorPtr =
      _lookup<ffi.NativeFunction<NativeClang_codeCompleteGetObjCSelector>>(
        'clang_codeCompleteGetObjCSelector',
      );
  late final _clang_codeCompleteGetObjCSelector =
      _clang_codeCompleteGetObjCSelectorPtr
          .asFunction<DartClang_codeCompleteGetObjCSelector>();

  /// Return a version string, suitable for showing to a user, but not
  /// intended to be parsed (the format is not guaranteed to be stable).
  CXString clang_getClangVersion() {
    return _clang_getClangVersion();
  }

  late final _clang_getClangVersionPtr =
      _lookup<ffi.NativeFunction<NativeClang_getClangVersion>>(
        'clang_getClangVersion',
      );
  late final _clang_getClangVersion = _clang_getClangVersionPtr
      .asFunction<DartClang_getClangVersion>();

  /// Enable/disable crash recovery.
  ///
  /// \param isEnabled Flag to indicate if crash recovery is enabled.  A non-zero
  /// value enables crash recovery, while 0 disables it.
  void clang_toggleCrashRecovery(int isEnabled) {
    return _clang_toggleCrashRecovery(isEnabled);
  }

  late final _clang_toggleCrashRecoveryPtr =
      _lookup<ffi.NativeFunction<NativeClang_toggleCrashRecovery>>(
        'clang_toggleCrashRecovery',
      );
  late final _clang_toggleCrashRecovery = _clang_toggleCrashRecoveryPtr
      .asFunction<DartClang_toggleCrashRecovery>();

  /// Visit the set of preprocessor inclusions in a translation unit.
  /// The visitor function is called with the provided data for every included
  /// file.  This does not include headers included by the PCH file (unless one
  /// is inspecting the inclusions in the PCH file itself).
  void clang_getInclusions(
    CXTranslationUnit tu,
    CXInclusionVisitor visitor,
    CXClientData client_data,
  ) {
    return _clang_getInclusions(tu, visitor, client_data);
  }

  late final _clang_getInclusionsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getInclusions>>(
        'clang_getInclusions',
      );
  late final _clang_getInclusions = _clang_getInclusionsPtr
      .asFunction<DartClang_getInclusions>();

  /// If cursor is a statement declaration tries to evaluate the
  /// statement and if its variable, tries to evaluate its initializer,
  /// into its corresponding type.
  CXEvalResult clang_Cursor_Evaluate(CXCursor C) {
    return _clang_Cursor_Evaluate(C);
  }

  late final _clang_Cursor_EvaluatePtr =
      _lookup<ffi.NativeFunction<NativeClang_Cursor_Evaluate>>(
        'clang_Cursor_Evaluate',
      );
  late final _clang_Cursor_Evaluate = _clang_Cursor_EvaluatePtr
      .asFunction<DartClang_Cursor_Evaluate>();

  /// Returns the kind of the evaluated result.
  CXEvalResultKind clang_EvalResult_getKind(CXEvalResult E) {
    return CXEvalResultKind.fromValue(_clang_EvalResult_getKind(E));
  }

  late final _clang_EvalResult_getKindPtr =
      _lookup<ffi.NativeFunction<NativeClang_EvalResult_getKind>>(
        'clang_EvalResult_getKind',
      );
  late final _clang_EvalResult_getKind = _clang_EvalResult_getKindPtr
      .asFunction<DartClang_EvalResult_getKind>();

  /// Returns the evaluation result as integer if the
  /// kind is Int.
  int clang_EvalResult_getAsInt(CXEvalResult E) {
    return _clang_EvalResult_getAsInt(E);
  }

  late final _clang_EvalResult_getAsIntPtr =
      _lookup<ffi.NativeFunction<NativeClang_EvalResult_getAsInt>>(
        'clang_EvalResult_getAsInt',
      );
  late final _clang_EvalResult_getAsInt = _clang_EvalResult_getAsIntPtr
      .asFunction<DartClang_EvalResult_getAsInt>();

  /// Returns the evaluation result as a long long integer if the
  /// kind is Int. This prevents overflows that may happen if the result is
  /// returned with clang_EvalResult_getAsInt.
  int clang_EvalResult_getAsLongLong(CXEvalResult E) {
    return _clang_EvalResult_getAsLongLong(E);
  }

  late final _clang_EvalResult_getAsLongLongPtr =
      _lookup<ffi.NativeFunction<NativeClang_EvalResult_getAsLongLong>>(
        'clang_EvalResult_getAsLongLong',
      );
  late final _clang_EvalResult_getAsLongLong =
      _clang_EvalResult_getAsLongLongPtr
          .asFunction<DartClang_EvalResult_getAsLongLong>();

  /// Returns a non-zero value if the kind is Int and the evaluation
  /// result resulted in an unsigned integer.
  int clang_EvalResult_isUnsignedInt(CXEvalResult E) {
    return _clang_EvalResult_isUnsignedInt(E);
  }

  late final _clang_EvalResult_isUnsignedIntPtr =
      _lookup<ffi.NativeFunction<NativeClang_EvalResult_isUnsignedInt>>(
        'clang_EvalResult_isUnsignedInt',
      );
  late final _clang_EvalResult_isUnsignedInt =
      _clang_EvalResult_isUnsignedIntPtr
          .asFunction<DartClang_EvalResult_isUnsignedInt>();

  /// Returns the evaluation result as an unsigned integer if
  /// the kind is Int and clang_EvalResult_isUnsignedInt is non-zero.
  int clang_EvalResult_getAsUnsigned(CXEvalResult E) {
    return _clang_EvalResult_getAsUnsigned(E);
  }

  late final _clang_EvalResult_getAsUnsignedPtr =
      _lookup<ffi.NativeFunction<NativeClang_EvalResult_getAsUnsigned>>(
        'clang_EvalResult_getAsUnsigned',
      );
  late final _clang_EvalResult_getAsUnsigned =
      _clang_EvalResult_getAsUnsignedPtr
          .asFunction<DartClang_EvalResult_getAsUnsigned>();

  /// Returns the evaluation result as double if the
  /// kind is double.
  double clang_EvalResult_getAsDouble(CXEvalResult E) {
    return _clang_EvalResult_getAsDouble(E);
  }

  late final _clang_EvalResult_getAsDoublePtr =
      _lookup<ffi.NativeFunction<NativeClang_EvalResult_getAsDouble>>(
        'clang_EvalResult_getAsDouble',
      );
  late final _clang_EvalResult_getAsDouble = _clang_EvalResult_getAsDoublePtr
      .asFunction<DartClang_EvalResult_getAsDouble>();

  /// Returns the evaluation result as a constant string if the
  /// kind is other than Int or float. User must not free this pointer,
  /// instead call clang_EvalResult_dispose on the CXEvalResult returned
  /// by clang_Cursor_Evaluate.
  ffi.Pointer<ffi.Char> clang_EvalResult_getAsStr(CXEvalResult E) {
    return _clang_EvalResult_getAsStr(E);
  }

  late final _clang_EvalResult_getAsStrPtr =
      _lookup<ffi.NativeFunction<NativeClang_EvalResult_getAsStr>>(
        'clang_EvalResult_getAsStr',
      );
  late final _clang_EvalResult_getAsStr = _clang_EvalResult_getAsStrPtr
      .asFunction<DartClang_EvalResult_getAsStr>();

  /// Disposes the created Eval memory.
  void clang_EvalResult_dispose(CXEvalResult E) {
    return _clang_EvalResult_dispose(E);
  }

  late final _clang_EvalResult_disposePtr =
      _lookup<ffi.NativeFunction<NativeClang_EvalResult_dispose>>(
        'clang_EvalResult_dispose',
      );
  late final _clang_EvalResult_dispose = _clang_EvalResult_disposePtr
      .asFunction<DartClang_EvalResult_dispose>();

  /// Retrieve a remapping.
  ///
  /// \param path the path that contains metadata about remappings.
  ///
  /// \returns the requested remapping. This remapping must be freed
  /// via a call to \c clang_remap_dispose(). Can return NULL if an error occurred.
  CXRemapping clang_getRemappings(ffi.Pointer<ffi.Char> path) {
    return _clang_getRemappings(path);
  }

  late final _clang_getRemappingsPtr =
      _lookup<ffi.NativeFunction<NativeClang_getRemappings>>(
        'clang_getRemappings',
      );
  late final _clang_getRemappings = _clang_getRemappingsPtr
      .asFunction<DartClang_getRemappings>();

  /// Retrieve a remapping.
  ///
  /// \param filePaths pointer to an array of file paths containing remapping info.
  ///
  /// \param numFiles number of file paths.
  ///
  /// \returns the requested remapping. This remapping must be freed
  /// via a call to \c clang_remap_dispose(). Can return NULL if an error occurred.
  CXRemapping clang_getRemappingsFromFileList(
    ffi.Pointer<ffi.Pointer<ffi.Char>> filePaths,
    int numFiles,
  ) {
    return _clang_getRemappingsFromFileList(filePaths, numFiles);
  }

  late final _clang_getRemappingsFromFileListPtr =
      _lookup<ffi.NativeFunction<NativeClang_getRemappingsFromFileList>>(
        'clang_getRemappingsFromFileList',
      );
  late final _clang_getRemappingsFromFileList =
      _clang_getRemappingsFromFileListPtr
          .asFunction<DartClang_getRemappingsFromFileList>();

  /// Determine the number of remappings.
  int clang_remap_getNumFiles(CXRemapping arg0) {
    return _clang_remap_getNumFiles(arg0);
  }

  late final _clang_remap_getNumFilesPtr =
      _lookup<ffi.NativeFunction<NativeClang_remap_getNumFiles>>(
        'clang_remap_getNumFiles',
      );
  late final _clang_remap_getNumFiles = _clang_remap_getNumFilesPtr
      .asFunction<DartClang_remap_getNumFiles>();

  /// Get the original and the associated filename from the remapping.
  ///
  /// \param original If non-NULL, will be set to the original filename.
  ///
  /// \param transformed If non-NULL, will be set to the filename that the original
  /// is associated with.
  void clang_remap_getFilenames(
    CXRemapping arg0,
    int index,
    ffi.Pointer<CXString> original,
    ffi.Pointer<CXString> transformed,
  ) {
    return _clang_remap_getFilenames(arg0, index, original, transformed);
  }

  late final _clang_remap_getFilenamesPtr =
      _lookup<ffi.NativeFunction<NativeClang_remap_getFilenames>>(
        'clang_remap_getFilenames',
      );
  late final _clang_remap_getFilenames = _clang_remap_getFilenamesPtr
      .asFunction<DartClang_remap_getFilenames>();

  /// Dispose the remapping.
  void clang_remap_dispose(CXRemapping arg0) {
    return _clang_remap_dispose(arg0);
  }

  late final _clang_remap_disposePtr =
      _lookup<ffi.NativeFunction<NativeClang_remap_dispose>>(
        'clang_remap_dispose',
      );
  late final _clang_remap_dispose = _clang_remap_disposePtr
      .asFunction<DartClang_remap_dispose>();

  /// Find references of a declaration in a specific file.
  ///
  /// \param cursor pointing to a declaration or a reference of one.
  ///
  /// \param file to search for references.
  ///
  /// \param visitor callback that will receive pairs of CXCursor/CXSourceRange for
  /// each reference found.
  /// The CXSourceRange will point inside the file; if the reference is inside
  /// a macro (and not a macro argument) the CXSourceRange will be invalid.
  ///
  /// \returns one of the CXResult enumerators.
  CXResult clang_findReferencesInFile(
    CXCursor cursor,
    CXFile file,
    CXCursorAndRangeVisitor visitor,
  ) {
    return CXResult.fromValue(
      _clang_findReferencesInFile(cursor, file, visitor),
    );
  }

  late final _clang_findReferencesInFilePtr =
      _lookup<ffi.NativeFunction<NativeClang_findReferencesInFile>>(
        'clang_findReferencesInFile',
      );
  late final _clang_findReferencesInFile = _clang_findReferencesInFilePtr
      .asFunction<DartClang_findReferencesInFile>();

  /// Find #import/#include directives in a specific file.
  ///
  /// \param TU translation unit containing the file to query.
  ///
  /// \param file to search for #import/#include directives.
  ///
  /// \param visitor callback that will receive pairs of CXCursor/CXSourceRange for
  /// each directive found.
  ///
  /// \returns one of the CXResult enumerators.
  CXResult clang_findIncludesInFile(
    CXTranslationUnit TU,
    CXFile file,
    CXCursorAndRangeVisitor visitor,
  ) {
    return CXResult.fromValue(_clang_findIncludesInFile(TU, file, visitor));
  }

  late final _clang_findIncludesInFilePtr =
      _lookup<ffi.NativeFunction<NativeClang_findIncludesInFile>>(
        'clang_findIncludesInFile',
      );
  late final _clang_findIncludesInFile = _clang_findIncludesInFilePtr
      .asFunction<DartClang_findIncludesInFile>();

  int clang_index_isEntityObjCContainerKind(CXIdxEntityKind arg0) {
    return _clang_index_isEntityObjCContainerKind(arg0.value);
  }

  late final _clang_index_isEntityObjCContainerKindPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_isEntityObjCContainerKind>>(
        'clang_index_isEntityObjCContainerKind',
      );
  late final _clang_index_isEntityObjCContainerKind =
      _clang_index_isEntityObjCContainerKindPtr
          .asFunction<DartClang_index_isEntityObjCContainerKind>();

  ffi.Pointer<CXIdxObjCContainerDeclInfo> clang_index_getObjCContainerDeclInfo(
    ffi.Pointer<CXIdxDeclInfo> arg0,
  ) {
    return _clang_index_getObjCContainerDeclInfo(arg0);
  }

  late final _clang_index_getObjCContainerDeclInfoPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_getObjCContainerDeclInfo>>(
        'clang_index_getObjCContainerDeclInfo',
      );
  late final _clang_index_getObjCContainerDeclInfo =
      _clang_index_getObjCContainerDeclInfoPtr
          .asFunction<DartClang_index_getObjCContainerDeclInfo>();

  ffi.Pointer<CXIdxObjCInterfaceDeclInfo> clang_index_getObjCInterfaceDeclInfo(
    ffi.Pointer<CXIdxDeclInfo> arg0,
  ) {
    return _clang_index_getObjCInterfaceDeclInfo(arg0);
  }

  late final _clang_index_getObjCInterfaceDeclInfoPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_getObjCInterfaceDeclInfo>>(
        'clang_index_getObjCInterfaceDeclInfo',
      );
  late final _clang_index_getObjCInterfaceDeclInfo =
      _clang_index_getObjCInterfaceDeclInfoPtr
          .asFunction<DartClang_index_getObjCInterfaceDeclInfo>();

  ffi.Pointer<CXIdxObjCCategoryDeclInfo> clang_index_getObjCCategoryDeclInfo(
    ffi.Pointer<CXIdxDeclInfo> arg0,
  ) {
    return _clang_index_getObjCCategoryDeclInfo(arg0);
  }

  late final _clang_index_getObjCCategoryDeclInfoPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_getObjCCategoryDeclInfo>>(
        'clang_index_getObjCCategoryDeclInfo',
      );
  late final _clang_index_getObjCCategoryDeclInfo =
      _clang_index_getObjCCategoryDeclInfoPtr
          .asFunction<DartClang_index_getObjCCategoryDeclInfo>();

  ffi.Pointer<CXIdxObjCProtocolRefListInfo>
  clang_index_getObjCProtocolRefListInfo(ffi.Pointer<CXIdxDeclInfo> arg0) {
    return _clang_index_getObjCProtocolRefListInfo(arg0);
  }

  late final _clang_index_getObjCProtocolRefListInfoPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_getObjCProtocolRefListInfo>>(
        'clang_index_getObjCProtocolRefListInfo',
      );
  late final _clang_index_getObjCProtocolRefListInfo =
      _clang_index_getObjCProtocolRefListInfoPtr
          .asFunction<DartClang_index_getObjCProtocolRefListInfo>();

  ffi.Pointer<CXIdxObjCPropertyDeclInfo> clang_index_getObjCPropertyDeclInfo(
    ffi.Pointer<CXIdxDeclInfo> arg0,
  ) {
    return _clang_index_getObjCPropertyDeclInfo(arg0);
  }

  late final _clang_index_getObjCPropertyDeclInfoPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_getObjCPropertyDeclInfo>>(
        'clang_index_getObjCPropertyDeclInfo',
      );
  late final _clang_index_getObjCPropertyDeclInfo =
      _clang_index_getObjCPropertyDeclInfoPtr
          .asFunction<DartClang_index_getObjCPropertyDeclInfo>();

  ffi.Pointer<CXIdxIBOutletCollectionAttrInfo>
  clang_index_getIBOutletCollectionAttrInfo(ffi.Pointer<CXIdxAttrInfo> arg0) {
    return _clang_index_getIBOutletCollectionAttrInfo(arg0);
  }

  late final _clang_index_getIBOutletCollectionAttrInfoPtr =
      _lookup<
        ffi.NativeFunction<NativeClang_index_getIBOutletCollectionAttrInfo>
      >('clang_index_getIBOutletCollectionAttrInfo');
  late final _clang_index_getIBOutletCollectionAttrInfo =
      _clang_index_getIBOutletCollectionAttrInfoPtr
          .asFunction<DartClang_index_getIBOutletCollectionAttrInfo>();

  ffi.Pointer<CXIdxCXXClassDeclInfo> clang_index_getCXXClassDeclInfo(
    ffi.Pointer<CXIdxDeclInfo> arg0,
  ) {
    return _clang_index_getCXXClassDeclInfo(arg0);
  }

  late final _clang_index_getCXXClassDeclInfoPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_getCXXClassDeclInfo>>(
        'clang_index_getCXXClassDeclInfo',
      );
  late final _clang_index_getCXXClassDeclInfo =
      _clang_index_getCXXClassDeclInfoPtr
          .asFunction<DartClang_index_getCXXClassDeclInfo>();

  /// For retrieving a custom CXIdxClientContainer attached to a
  /// container.
  CXIdxClientContainer clang_index_getClientContainer(
    ffi.Pointer<CXIdxContainerInfo> arg0,
  ) {
    return _clang_index_getClientContainer(arg0);
  }

  late final _clang_index_getClientContainerPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_getClientContainer>>(
        'clang_index_getClientContainer',
      );
  late final _clang_index_getClientContainer =
      _clang_index_getClientContainerPtr
          .asFunction<DartClang_index_getClientContainer>();

  /// For setting a custom CXIdxClientContainer attached to a
  /// container.
  void clang_index_setClientContainer(
    ffi.Pointer<CXIdxContainerInfo> arg0,
    CXIdxClientContainer arg1,
  ) {
    return _clang_index_setClientContainer(arg0, arg1);
  }

  late final _clang_index_setClientContainerPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_setClientContainer>>(
        'clang_index_setClientContainer',
      );
  late final _clang_index_setClientContainer =
      _clang_index_setClientContainerPtr
          .asFunction<DartClang_index_setClientContainer>();

  /// For retrieving a custom CXIdxClientEntity attached to an entity.
  CXIdxClientEntity clang_index_getClientEntity(
    ffi.Pointer<CXIdxEntityInfo> arg0,
  ) {
    return _clang_index_getClientEntity(arg0);
  }

  late final _clang_index_getClientEntityPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_getClientEntity>>(
        'clang_index_getClientEntity',
      );
  late final _clang_index_getClientEntity = _clang_index_getClientEntityPtr
      .asFunction<DartClang_index_getClientEntity>();

  /// For setting a custom CXIdxClientEntity attached to an entity.
  void clang_index_setClientEntity(
    ffi.Pointer<CXIdxEntityInfo> arg0,
    CXIdxClientEntity arg1,
  ) {
    return _clang_index_setClientEntity(arg0, arg1);
  }

  late final _clang_index_setClientEntityPtr =
      _lookup<ffi.NativeFunction<NativeClang_index_setClientEntity>>(
        'clang_index_setClientEntity',
      );
  late final _clang_index_setClientEntity = _clang_index_setClientEntityPtr
      .asFunction<DartClang_index_setClientEntity>();

  /// An indexing action/session, to be applied to one or multiple
  /// translation units.
  ///
  /// \param CIdx The index object with which the index action will be associated.
  CXIndexAction clang_IndexAction_create(CXIndex CIdx) {
    return _clang_IndexAction_create(CIdx);
  }

  late final _clang_IndexAction_createPtr =
      _lookup<ffi.NativeFunction<NativeClang_IndexAction_create>>(
        'clang_IndexAction_create',
      );
  late final _clang_IndexAction_create = _clang_IndexAction_createPtr
      .asFunction<DartClang_IndexAction_create>();

  /// Destroy the given index action.
  ///
  /// The index action must not be destroyed until all of the translation units
  /// created within that index action have been destroyed.
  void clang_IndexAction_dispose(CXIndexAction arg0) {
    return _clang_IndexAction_dispose(arg0);
  }

  late final _clang_IndexAction_disposePtr =
      _lookup<ffi.NativeFunction<NativeClang_IndexAction_dispose>>(
        'clang_IndexAction_dispose',
      );
  late final _clang_IndexAction_dispose = _clang_IndexAction_disposePtr
      .asFunction<DartClang_IndexAction_dispose>();

  /// Index the given source file and the translation unit corresponding
  /// to that file via callbacks implemented through #IndexerCallbacks.
  ///
  /// \param client_data pointer data supplied by the client, which will
  /// be passed to the invoked callbacks.
  ///
  /// \param index_callbacks Pointer to indexing callbacks that the client
  /// implements.
  ///
  /// \param index_callbacks_size Size of #IndexerCallbacks structure that gets
  /// passed in index_callbacks.
  ///
  /// \param index_options A bitmask of options that affects how indexing is
  /// performed. This should be a bitwise OR of the CXIndexOpt_XXX flags.
  ///
  /// \param[out] out_TU pointer to store a \c CXTranslationUnit that can be
  /// reused after indexing is finished. Set to \c NULL if you do not require it.
  ///
  /// \returns 0 on success or if there were errors from which the compiler could
  /// recover.  If there is a failure from which there is no recovery, returns
  /// a non-zero \c CXErrorCode.
  ///
  /// The rest of the parameters are the same as #clang_parseTranslationUnit.
  int clang_indexSourceFile(
    CXIndexAction arg0,
    CXClientData client_data,
    ffi.Pointer<IndexerCallbacks> index_callbacks,
    int index_callbacks_size,
    int index_options,
    ffi.Pointer<ffi.Char> source_filename,
    ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
    int num_command_line_args,
    ffi.Pointer<CXUnsavedFile> unsaved_files,
    int num_unsaved_files,
    ffi.Pointer<CXTranslationUnit> out_TU,
    int TU_options,
  ) {
    return _clang_indexSourceFile(
      arg0,
      client_data,
      index_callbacks,
      index_callbacks_size,
      index_options,
      source_filename,
      command_line_args,
      num_command_line_args,
      unsaved_files,
      num_unsaved_files,
      out_TU,
      TU_options,
    );
  }

  late final _clang_indexSourceFilePtr =
      _lookup<ffi.NativeFunction<NativeClang_indexSourceFile>>(
        'clang_indexSourceFile',
      );
  late final _clang_indexSourceFile = _clang_indexSourceFilePtr
      .asFunction<DartClang_indexSourceFile>();

  /// Same as clang_indexSourceFile but requires a full command line
  /// for \c command_line_args including argv[0]. This is useful if the standard
  /// library paths are relative to the binary.
  int clang_indexSourceFileFullArgv(
    CXIndexAction arg0,
    CXClientData client_data,
    ffi.Pointer<IndexerCallbacks> index_callbacks,
    int index_callbacks_size,
    int index_options,
    ffi.Pointer<ffi.Char> source_filename,
    ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
    int num_command_line_args,
    ffi.Pointer<CXUnsavedFile> unsaved_files,
    int num_unsaved_files,
    ffi.Pointer<CXTranslationUnit> out_TU,
    int TU_options,
  ) {
    return _clang_indexSourceFileFullArgv(
      arg0,
      client_data,
      index_callbacks,
      index_callbacks_size,
      index_options,
      source_filename,
      command_line_args,
      num_command_line_args,
      unsaved_files,
      num_unsaved_files,
      out_TU,
      TU_options,
    );
  }

  late final _clang_indexSourceFileFullArgvPtr =
      _lookup<ffi.NativeFunction<NativeClang_indexSourceFileFullArgv>>(
        'clang_indexSourceFileFullArgv',
      );
  late final _clang_indexSourceFileFullArgv = _clang_indexSourceFileFullArgvPtr
      .asFunction<DartClang_indexSourceFileFullArgv>();

  /// Index the given translation unit via callbacks implemented through
  /// #IndexerCallbacks.
  ///
  /// The order of callback invocations is not guaranteed to be the same as
  /// when indexing a source file. The high level order will be:
  ///
  /// -Preprocessor callbacks invocations
  /// -Declaration/reference callbacks invocations
  /// -Diagnostic callback invocations
  ///
  /// The parameters are the same as #clang_indexSourceFile.
  ///
  /// \returns If there is a failure from which there is no recovery, returns
  /// non-zero, otherwise returns 0.
  int clang_indexTranslationUnit(
    CXIndexAction arg0,
    CXClientData client_data,
    ffi.Pointer<IndexerCallbacks> index_callbacks,
    int index_callbacks_size,
    int index_options,
    CXTranslationUnit arg5,
  ) {
    return _clang_indexTranslationUnit(
      arg0,
      client_data,
      index_callbacks,
      index_callbacks_size,
      index_options,
      arg5,
    );
  }

  late final _clang_indexTranslationUnitPtr =
      _lookup<ffi.NativeFunction<NativeClang_indexTranslationUnit>>(
        'clang_indexTranslationUnit',
      );
  late final _clang_indexTranslationUnit = _clang_indexTranslationUnitPtr
      .asFunction<DartClang_indexTranslationUnit>();

  /// Retrieve the CXIdxFile, file, line, column, and offset represented by
  /// the given CXIdxLoc.
  ///
  /// If the location refers into a macro expansion, retrieves the
  /// location of the macro expansion and if it refers into a macro argument
  /// retrieves the location of the argument.
  void clang_indexLoc_getFileLocation(
    CXIdxLoc loc,
    ffi.Pointer<CXIdxClientFile> indexFile,
    ffi.Pointer<CXFile> file,
    ffi.Pointer<ffi.UnsignedInt> line,
    ffi.Pointer<ffi.UnsignedInt> column,
    ffi.Pointer<ffi.UnsignedInt> offset,
  ) {
    return _clang_indexLoc_getFileLocation(
      loc,
      indexFile,
      file,
      line,
      column,
      offset,
    );
  }

  late final _clang_indexLoc_getFileLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_indexLoc_getFileLocation>>(
        'clang_indexLoc_getFileLocation',
      );
  late final _clang_indexLoc_getFileLocation =
      _clang_indexLoc_getFileLocationPtr
          .asFunction<DartClang_indexLoc_getFileLocation>();

  /// Retrieve the CXSourceLocation represented by the given CXIdxLoc.
  CXSourceLocation clang_indexLoc_getCXSourceLocation(CXIdxLoc loc) {
    return _clang_indexLoc_getCXSourceLocation(loc);
  }

  late final _clang_indexLoc_getCXSourceLocationPtr =
      _lookup<ffi.NativeFunction<NativeClang_indexLoc_getCXSourceLocation>>(
        'clang_indexLoc_getCXSourceLocation',
      );
  late final _clang_indexLoc_getCXSourceLocation =
      _clang_indexLoc_getCXSourceLocationPtr
          .asFunction<DartClang_indexLoc_getCXSourceLocation>();

  /// Visit the fields of a particular type.
  ///
  /// This function visits all the direct fields of the given cursor,
  /// invoking the given \p visitor function with the cursors of each
  /// visited field. The traversal may be ended prematurely, if
  /// the visitor returns \c CXFieldVisit_Break.
  ///
  /// \param T the record type whose field may be visited.
  ///
  /// \param visitor the visitor function that will be invoked for each
  /// field of \p T.
  ///
  /// \param client_data pointer data supplied by the client, which will
  /// be passed to the visitor each time it is invoked.
  ///
  /// \returns a non-zero value if the traversal was terminated
  /// prematurely by the visitor returning \c CXFieldVisit_Break.
  int clang_Type_visitFields(
    CXType T,
    CXFieldVisitor visitor,
    CXClientData client_data,
  ) {
    return _clang_Type_visitFields(T, visitor, client_data);
  }

  late final _clang_Type_visitFieldsPtr =
      _lookup<ffi.NativeFunction<NativeClang_Type_visitFields>>(
        'clang_Type_visitFields',
      );
  late final _clang_Type_visitFields = _clang_Type_visitFieldsPtr
      .asFunction<DartClang_Type_visitFields>();

  late final addresses = _SymbolAddresses(this);
}

class _SymbolAddresses {
  final LibClang _library;
  _SymbolAddresses(this._library);
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCString>>
  get clang_getCString => _library._clang_getCStringPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeString>>
  get clang_disposeString => _library._clang_disposeStringPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeStringSet>>
  get clang_disposeStringSet => _library._clang_disposeStringSetPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_createIndex>>
  get clang_createIndex => _library._clang_createIndexPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeIndex>>
  get clang_disposeIndex => _library._clang_disposeIndexPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXIndex_setGlobalOptions>>
  get clang_CXIndex_setGlobalOptions =>
      _library._clang_CXIndex_setGlobalOptionsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXIndex_getGlobalOptions>>
  get clang_CXIndex_getGlobalOptions =>
      _library._clang_CXIndex_getGlobalOptionsPtr;
  ffi.Pointer<
    ffi.NativeFunction<NativeClang_CXIndex_setInvocationEmissionPathOption>
  >
  get clang_CXIndex_setInvocationEmissionPathOption =>
      _library._clang_CXIndex_setInvocationEmissionPathOptionPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getFileName>>
  get clang_getFileName => _library._clang_getFileNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getFileTime>>
  get clang_getFileTime => _library._clang_getFileTimePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getFileUniqueID>>
  get clang_getFileUniqueID => _library._clang_getFileUniqueIDPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isFileMultipleIncludeGuarded>>
  get clang_isFileMultipleIncludeGuarded =>
      _library._clang_isFileMultipleIncludeGuardedPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getFile>> get clang_getFile =>
      _library._clang_getFilePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getFileContents>>
  get clang_getFileContents => _library._clang_getFileContentsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_File_isEqual>>
  get clang_File_isEqual => _library._clang_File_isEqualPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_File_tryGetRealPathName>>
  get clang_File_tryGetRealPathName =>
      _library._clang_File_tryGetRealPathNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getNullLocation>>
  get clang_getNullLocation => _library._clang_getNullLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_equalLocations>>
  get clang_equalLocations => _library._clang_equalLocationsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getLocation>>
  get clang_getLocation => _library._clang_getLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getLocationForOffset>>
  get clang_getLocationForOffset => _library._clang_getLocationForOffsetPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Location_isInSystemHeader>>
  get clang_Location_isInSystemHeader =>
      _library._clang_Location_isInSystemHeaderPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Location_isFromMainFile>>
  get clang_Location_isFromMainFile =>
      _library._clang_Location_isFromMainFilePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getNullRange>>
  get clang_getNullRange => _library._clang_getNullRangePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getRange>> get clang_getRange =>
      _library._clang_getRangePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_equalRanges>>
  get clang_equalRanges => _library._clang_equalRangesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Range_isNull>>
  get clang_Range_isNull => _library._clang_Range_isNullPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getExpansionLocation>>
  get clang_getExpansionLocation => _library._clang_getExpansionLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getPresumedLocation>>
  get clang_getPresumedLocation => _library._clang_getPresumedLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getInstantiationLocation>>
  get clang_getInstantiationLocation =>
      _library._clang_getInstantiationLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getSpellingLocation>>
  get clang_getSpellingLocation => _library._clang_getSpellingLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getFileLocation>>
  get clang_getFileLocation => _library._clang_getFileLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getRangeStart>>
  get clang_getRangeStart => _library._clang_getRangeStartPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getRangeEnd>>
  get clang_getRangeEnd => _library._clang_getRangeEndPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getSkippedRanges>>
  get clang_getSkippedRanges => _library._clang_getSkippedRangesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getAllSkippedRanges>>
  get clang_getAllSkippedRanges => _library._clang_getAllSkippedRangesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeSourceRangeList>>
  get clang_disposeSourceRangeList => _library._clang_disposeSourceRangeListPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getNumDiagnosticsInSet>>
  get clang_getNumDiagnosticsInSet => _library._clang_getNumDiagnosticsInSetPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticInSet>>
  get clang_getDiagnosticInSet => _library._clang_getDiagnosticInSetPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_loadDiagnostics>>
  get clang_loadDiagnostics => _library._clang_loadDiagnosticsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeDiagnosticSet>>
  get clang_disposeDiagnosticSet => _library._clang_disposeDiagnosticSetPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getChildDiagnostics>>
  get clang_getChildDiagnostics => _library._clang_getChildDiagnosticsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getNumDiagnostics>>
  get clang_getNumDiagnostics => _library._clang_getNumDiagnosticsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnostic>>
  get clang_getDiagnostic => _library._clang_getDiagnosticPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticSetFromTU>>
  get clang_getDiagnosticSetFromTU => _library._clang_getDiagnosticSetFromTUPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeDiagnostic>>
  get clang_disposeDiagnostic => _library._clang_disposeDiagnosticPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_formatDiagnostic>>
  get clang_formatDiagnostic => _library._clang_formatDiagnosticPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_defaultDiagnosticDisplayOptions>>
  get clang_defaultDiagnosticDisplayOptions =>
      _library._clang_defaultDiagnosticDisplayOptionsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticSeverity>>
  get clang_getDiagnosticSeverity => _library._clang_getDiagnosticSeverityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticLocation>>
  get clang_getDiagnosticLocation => _library._clang_getDiagnosticLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticSpelling>>
  get clang_getDiagnosticSpelling => _library._clang_getDiagnosticSpellingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticOption>>
  get clang_getDiagnosticOption => _library._clang_getDiagnosticOptionPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticCategory>>
  get clang_getDiagnosticCategory => _library._clang_getDiagnosticCategoryPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticCategoryName>>
  get clang_getDiagnosticCategoryName =>
      _library._clang_getDiagnosticCategoryNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticCategoryText>>
  get clang_getDiagnosticCategoryText =>
      _library._clang_getDiagnosticCategoryTextPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticNumRanges>>
  get clang_getDiagnosticNumRanges => _library._clang_getDiagnosticNumRangesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticRange>>
  get clang_getDiagnosticRange => _library._clang_getDiagnosticRangePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticNumFixIts>>
  get clang_getDiagnosticNumFixIts => _library._clang_getDiagnosticNumFixItsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDiagnosticFixIt>>
  get clang_getDiagnosticFixIt => _library._clang_getDiagnosticFixItPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTranslationUnitSpelling>>
  get clang_getTranslationUnitSpelling =>
      _library._clang_getTranslationUnitSpellingPtr;
  ffi.Pointer<
    ffi.NativeFunction<NativeClang_createTranslationUnitFromSourceFile>
  >
  get clang_createTranslationUnitFromSourceFile =>
      _library._clang_createTranslationUnitFromSourceFilePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_createTranslationUnit>>
  get clang_createTranslationUnit => _library._clang_createTranslationUnitPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_createTranslationUnit2>>
  get clang_createTranslationUnit2 => _library._clang_createTranslationUnit2Ptr;
  ffi.Pointer<
    ffi.NativeFunction<NativeClang_defaultEditingTranslationUnitOptions>
  >
  get clang_defaultEditingTranslationUnitOptions =>
      _library._clang_defaultEditingTranslationUnitOptionsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_parseTranslationUnit>>
  get clang_parseTranslationUnit => _library._clang_parseTranslationUnitPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_parseTranslationUnit2>>
  get clang_parseTranslationUnit2 => _library._clang_parseTranslationUnit2Ptr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_parseTranslationUnit2FullArgv>>
  get clang_parseTranslationUnit2FullArgv =>
      _library._clang_parseTranslationUnit2FullArgvPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_defaultSaveOptions>>
  get clang_defaultSaveOptions => _library._clang_defaultSaveOptionsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_saveTranslationUnit>>
  get clang_saveTranslationUnit => _library._clang_saveTranslationUnitPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_suspendTranslationUnit>>
  get clang_suspendTranslationUnit => _library._clang_suspendTranslationUnitPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeTranslationUnit>>
  get clang_disposeTranslationUnit => _library._clang_disposeTranslationUnitPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_defaultReparseOptions>>
  get clang_defaultReparseOptions => _library._clang_defaultReparseOptionsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_reparseTranslationUnit>>
  get clang_reparseTranslationUnit => _library._clang_reparseTranslationUnitPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTUResourceUsageName>>
  get clang_getTUResourceUsageName => _library._clang_getTUResourceUsageNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCXTUResourceUsage>>
  get clang_getCXTUResourceUsage => _library._clang_getCXTUResourceUsagePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeCXTUResourceUsage>>
  get clang_disposeCXTUResourceUsage =>
      _library._clang_disposeCXTUResourceUsagePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTranslationUnitTargetInfo>>
  get clang_getTranslationUnitTargetInfo =>
      _library._clang_getTranslationUnitTargetInfoPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_TargetInfo_dispose>>
  get clang_TargetInfo_dispose => _library._clang_TargetInfo_disposePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_TargetInfo_getTriple>>
  get clang_TargetInfo_getTriple => _library._clang_TargetInfo_getTriplePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_TargetInfo_getPointerWidth>>
  get clang_TargetInfo_getPointerWidth =>
      _library._clang_TargetInfo_getPointerWidthPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getNullCursor>>
  get clang_getNullCursor => _library._clang_getNullCursorPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTranslationUnitCursor>>
  get clang_getTranslationUnitCursor =>
      _library._clang_getTranslationUnitCursorPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_equalCursors>>
  get clang_equalCursors => _library._clang_equalCursorsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isNull>>
  get clang_Cursor_isNull => _library._clang_Cursor_isNullPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_hashCursor>>
  get clang_hashCursor => _library._clang_hashCursorPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorKind>>
  get clang_getCursorKind => _library._clang_getCursorKindPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isDeclaration>>
  get clang_isDeclaration => _library._clang_isDeclarationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isInvalidDeclaration>>
  get clang_isInvalidDeclaration => _library._clang_isInvalidDeclarationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isReference>>
  get clang_isReference => _library._clang_isReferencePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isExpression>>
  get clang_isExpression => _library._clang_isExpressionPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isStatement>>
  get clang_isStatement => _library._clang_isStatementPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isAttribute>>
  get clang_isAttribute => _library._clang_isAttributePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_hasAttrs>>
  get clang_Cursor_hasAttrs => _library._clang_Cursor_hasAttrsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isInvalid>> get clang_isInvalid =>
      _library._clang_isInvalidPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isTranslationUnit>>
  get clang_isTranslationUnit => _library._clang_isTranslationUnitPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isPreprocessing>>
  get clang_isPreprocessing => _library._clang_isPreprocessingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isUnexposed>>
  get clang_isUnexposed => _library._clang_isUnexposedPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorLinkage>>
  get clang_getCursorLinkage => _library._clang_getCursorLinkagePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorVisibility>>
  get clang_getCursorVisibility => _library._clang_getCursorVisibilityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorAvailability>>
  get clang_getCursorAvailability => _library._clang_getCursorAvailabilityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorPlatformAvailability>>
  get clang_getCursorPlatformAvailability =>
      _library._clang_getCursorPlatformAvailabilityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeCXPlatformAvailability>>
  get clang_disposeCXPlatformAvailability =>
      _library._clang_disposeCXPlatformAvailabilityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorLanguage>>
  get clang_getCursorLanguage => _library._clang_getCursorLanguagePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorTLSKind>>
  get clang_getCursorTLSKind => _library._clang_getCursorTLSKindPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getTranslationUnit>>
  get clang_Cursor_getTranslationUnit =>
      _library._clang_Cursor_getTranslationUnitPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_createCXCursorSet>>
  get clang_createCXCursorSet => _library._clang_createCXCursorSetPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeCXCursorSet>>
  get clang_disposeCXCursorSet => _library._clang_disposeCXCursorSetPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXCursorSet_contains>>
  get clang_CXCursorSet_contains => _library._clang_CXCursorSet_containsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXCursorSet_insert>>
  get clang_CXCursorSet_insert => _library._clang_CXCursorSet_insertPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorSemanticParent>>
  get clang_getCursorSemanticParent =>
      _library._clang_getCursorSemanticParentPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorLexicalParent>>
  get clang_getCursorLexicalParent => _library._clang_getCursorLexicalParentPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getOverriddenCursors>>
  get clang_getOverriddenCursors => _library._clang_getOverriddenCursorsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeOverriddenCursors>>
  get clang_disposeOverriddenCursors =>
      _library._clang_disposeOverriddenCursorsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getIncludedFile>>
  get clang_getIncludedFile => _library._clang_getIncludedFilePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursor>> get clang_getCursor =>
      _library._clang_getCursorPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorLocation>>
  get clang_getCursorLocation => _library._clang_getCursorLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorExtent>>
  get clang_getCursorExtent => _library._clang_getCursorExtentPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorType>>
  get clang_getCursorType => _library._clang_getCursorTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTypeSpelling>>
  get clang_getTypeSpelling => _library._clang_getTypeSpellingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTypedefDeclUnderlyingType>>
  get clang_getTypedefDeclUnderlyingType =>
      _library._clang_getTypedefDeclUnderlyingTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getEnumDeclIntegerType>>
  get clang_getEnumDeclIntegerType => _library._clang_getEnumDeclIntegerTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getEnumConstantDeclValue>>
  get clang_getEnumConstantDeclValue =>
      _library._clang_getEnumConstantDeclValuePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getEnumConstantDeclUnsignedValue>>
  get clang_getEnumConstantDeclUnsignedValue =>
      _library._clang_getEnumConstantDeclUnsignedValuePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getFieldDeclBitWidth>>
  get clang_getFieldDeclBitWidth => _library._clang_getFieldDeclBitWidthPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getNumArguments>>
  get clang_Cursor_getNumArguments => _library._clang_Cursor_getNumArgumentsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getArgument>>
  get clang_Cursor_getArgument => _library._clang_Cursor_getArgumentPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getNumTemplateArguments>>
  get clang_Cursor_getNumTemplateArguments =>
      _library._clang_Cursor_getNumTemplateArgumentsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getTemplateArgumentKind>>
  get clang_Cursor_getTemplateArgumentKind =>
      _library._clang_Cursor_getTemplateArgumentKindPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getTemplateArgumentType>>
  get clang_Cursor_getTemplateArgumentType =>
      _library._clang_Cursor_getTemplateArgumentTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getTemplateArgumentValue>>
  get clang_Cursor_getTemplateArgumentValue =>
      _library._clang_Cursor_getTemplateArgumentValuePtr;
  ffi.Pointer<
    ffi.NativeFunction<NativeClang_Cursor_getTemplateArgumentUnsignedValue>
  >
  get clang_Cursor_getTemplateArgumentUnsignedValue =>
      _library._clang_Cursor_getTemplateArgumentUnsignedValuePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_equalTypes>>
  get clang_equalTypes => _library._clang_equalTypesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCanonicalType>>
  get clang_getCanonicalType => _library._clang_getCanonicalTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isConstQualifiedType>>
  get clang_isConstQualifiedType => _library._clang_isConstQualifiedTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isMacroFunctionLike>>
  get clang_Cursor_isMacroFunctionLike =>
      _library._clang_Cursor_isMacroFunctionLikePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isMacroBuiltin>>
  get clang_Cursor_isMacroBuiltin => _library._clang_Cursor_isMacroBuiltinPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isFunctionInlined>>
  get clang_Cursor_isFunctionInlined =>
      _library._clang_Cursor_isFunctionInlinedPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isVolatileQualifiedType>>
  get clang_isVolatileQualifiedType =>
      _library._clang_isVolatileQualifiedTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isRestrictQualifiedType>>
  get clang_isRestrictQualifiedType =>
      _library._clang_isRestrictQualifiedTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getAddressSpace>>
  get clang_getAddressSpace => _library._clang_getAddressSpacePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTypedefName>>
  get clang_getTypedefName => _library._clang_getTypedefNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getPointeeType>>
  get clang_getPointeeType => _library._clang_getPointeeTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTypeDeclaration>>
  get clang_getTypeDeclaration => _library._clang_getTypeDeclarationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDeclObjCTypeEncoding>>
  get clang_getDeclObjCTypeEncoding =>
      _library._clang_getDeclObjCTypeEncodingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getObjCEncoding>>
  get clang_Type_getObjCEncoding => _library._clang_Type_getObjCEncodingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTypeKindSpelling>>
  get clang_getTypeKindSpelling => _library._clang_getTypeKindSpellingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getFunctionTypeCallingConv>>
  get clang_getFunctionTypeCallingConv =>
      _library._clang_getFunctionTypeCallingConvPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getResultType>>
  get clang_getResultType => _library._clang_getResultTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getExceptionSpecificationType>>
  get clang_getExceptionSpecificationType =>
      _library._clang_getExceptionSpecificationTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getNumArgTypes>>
  get clang_getNumArgTypes => _library._clang_getNumArgTypesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getArgType>>
  get clang_getArgType => _library._clang_getArgTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getObjCObjectBaseType>>
  get clang_Type_getObjCObjectBaseType =>
      _library._clang_Type_getObjCObjectBaseTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getNumObjCProtocolRefs>>
  get clang_Type_getNumObjCProtocolRefs =>
      _library._clang_Type_getNumObjCProtocolRefsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getObjCProtocolDecl>>
  get clang_Type_getObjCProtocolDecl =>
      _library._clang_Type_getObjCProtocolDeclPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getNumObjCTypeArgs>>
  get clang_Type_getNumObjCTypeArgs =>
      _library._clang_Type_getNumObjCTypeArgsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getObjCTypeArg>>
  get clang_Type_getObjCTypeArg => _library._clang_Type_getObjCTypeArgPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isFunctionTypeVariadic>>
  get clang_isFunctionTypeVariadic => _library._clang_isFunctionTypeVariadicPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorResultType>>
  get clang_getCursorResultType => _library._clang_getCursorResultTypePtr;
  ffi.Pointer<
    ffi.NativeFunction<NativeClang_getCursorExceptionSpecificationType>
  >
  get clang_getCursorExceptionSpecificationType =>
      _library._clang_getCursorExceptionSpecificationTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isPODType>> get clang_isPODType =>
      _library._clang_isPODTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getElementType>>
  get clang_getElementType => _library._clang_getElementTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getNumElements>>
  get clang_getNumElements => _library._clang_getNumElementsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getArrayElementType>>
  get clang_getArrayElementType => _library._clang_getArrayElementTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getArraySize>>
  get clang_getArraySize => _library._clang_getArraySizePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getNamedType>>
  get clang_Type_getNamedType => _library._clang_Type_getNamedTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_isTransparentTagTypedef>>
  get clang_Type_isTransparentTagTypedef =>
      _library._clang_Type_isTransparentTagTypedefPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getNullability>>
  get clang_Type_getNullability => _library._clang_Type_getNullabilityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getAlignOf>>
  get clang_Type_getAlignOf => _library._clang_Type_getAlignOfPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getClassType>>
  get clang_Type_getClassType => _library._clang_Type_getClassTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getSizeOf>>
  get clang_Type_getSizeOf => _library._clang_Type_getSizeOfPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getOffsetOf>>
  get clang_Type_getOffsetOf => _library._clang_Type_getOffsetOfPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getModifiedType>>
  get clang_Type_getModifiedType => _library._clang_Type_getModifiedTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getOffsetOfField>>
  get clang_Cursor_getOffsetOfField =>
      _library._clang_Cursor_getOffsetOfFieldPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isAnonymous>>
  get clang_Cursor_isAnonymous => _library._clang_Cursor_isAnonymousPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isAnonymousRecordDecl>>
  get clang_Cursor_isAnonymousRecordDecl =>
      _library._clang_Cursor_isAnonymousRecordDeclPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isInlineNamespace>>
  get clang_Cursor_isInlineNamespace =>
      _library._clang_Cursor_isInlineNamespacePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getNumTemplateArguments>>
  get clang_Type_getNumTemplateArguments =>
      _library._clang_Type_getNumTemplateArgumentsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getTemplateArgumentAsType>>
  get clang_Type_getTemplateArgumentAsType =>
      _library._clang_Type_getTemplateArgumentAsTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_getCXXRefQualifier>>
  get clang_Type_getCXXRefQualifier =>
      _library._clang_Type_getCXXRefQualifierPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isBitField>>
  get clang_Cursor_isBitField => _library._clang_Cursor_isBitFieldPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isVirtualBase>>
  get clang_isVirtualBase => _library._clang_isVirtualBasePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCXXAccessSpecifier>>
  get clang_getCXXAccessSpecifier => _library._clang_getCXXAccessSpecifierPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getStorageClass>>
  get clang_Cursor_getStorageClass => _library._clang_Cursor_getStorageClassPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getNumOverloadedDecls>>
  get clang_getNumOverloadedDecls => _library._clang_getNumOverloadedDeclsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getOverloadedDecl>>
  get clang_getOverloadedDecl => _library._clang_getOverloadedDeclPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getIBOutletCollectionType>>
  get clang_getIBOutletCollectionType =>
      _library._clang_getIBOutletCollectionTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_visitChildren>>
  get clang_visitChildren => _library._clang_visitChildrenPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorUSR>>
  get clang_getCursorUSR => _library._clang_getCursorUSRPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_constructUSR_ObjCClass>>
  get clang_constructUSR_ObjCClass => _library._clang_constructUSR_ObjCClassPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_constructUSR_ObjCCategory>>
  get clang_constructUSR_ObjCCategory =>
      _library._clang_constructUSR_ObjCCategoryPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_constructUSR_ObjCProtocol>>
  get clang_constructUSR_ObjCProtocol =>
      _library._clang_constructUSR_ObjCProtocolPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_constructUSR_ObjCIvar>>
  get clang_constructUSR_ObjCIvar => _library._clang_constructUSR_ObjCIvarPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_constructUSR_ObjCMethod>>
  get clang_constructUSR_ObjCMethod =>
      _library._clang_constructUSR_ObjCMethodPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_constructUSR_ObjCProperty>>
  get clang_constructUSR_ObjCProperty =>
      _library._clang_constructUSR_ObjCPropertyPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorSpelling>>
  get clang_getCursorSpelling => _library._clang_getCursorSpellingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getSpellingNameRange>>
  get clang_Cursor_getSpellingNameRange =>
      _library._clang_Cursor_getSpellingNameRangePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_PrintingPolicy_getProperty>>
  get clang_PrintingPolicy_getProperty =>
      _library._clang_PrintingPolicy_getPropertyPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_PrintingPolicy_setProperty>>
  get clang_PrintingPolicy_setProperty =>
      _library._clang_PrintingPolicy_setPropertyPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorPrintingPolicy>>
  get clang_getCursorPrintingPolicy =>
      _library._clang_getCursorPrintingPolicyPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_PrintingPolicy_dispose>>
  get clang_PrintingPolicy_dispose => _library._clang_PrintingPolicy_disposePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorPrettyPrinted>>
  get clang_getCursorPrettyPrinted => _library._clang_getCursorPrettyPrintedPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorDisplayName>>
  get clang_getCursorDisplayName => _library._clang_getCursorDisplayNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorReferenced>>
  get clang_getCursorReferenced => _library._clang_getCursorReferencedPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorDefinition>>
  get clang_getCursorDefinition => _library._clang_getCursorDefinitionPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_isCursorDefinition>>
  get clang_isCursorDefinition => _library._clang_isCursorDefinitionPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCanonicalCursor>>
  get clang_getCanonicalCursor => _library._clang_getCanonicalCursorPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getObjCSelectorIndex>>
  get clang_Cursor_getObjCSelectorIndex =>
      _library._clang_Cursor_getObjCSelectorIndexPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isDynamicCall>>
  get clang_Cursor_isDynamicCall => _library._clang_Cursor_isDynamicCallPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getReceiverType>>
  get clang_Cursor_getReceiverType => _library._clang_Cursor_getReceiverTypePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getObjCPropertyAttributes>>
  get clang_Cursor_getObjCPropertyAttributes =>
      _library._clang_Cursor_getObjCPropertyAttributesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getObjCPropertyGetterName>>
  get clang_Cursor_getObjCPropertyGetterName =>
      _library._clang_Cursor_getObjCPropertyGetterNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getObjCPropertySetterName>>
  get clang_Cursor_getObjCPropertySetterName =>
      _library._clang_Cursor_getObjCPropertySetterNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getObjCDeclQualifiers>>
  get clang_Cursor_getObjCDeclQualifiers =>
      _library._clang_Cursor_getObjCDeclQualifiersPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isObjCOptional>>
  get clang_Cursor_isObjCOptional => _library._clang_Cursor_isObjCOptionalPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isVariadic>>
  get clang_Cursor_isVariadic => _library._clang_Cursor_isVariadicPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_isExternalSymbol>>
  get clang_Cursor_isExternalSymbol =>
      _library._clang_Cursor_isExternalSymbolPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getCommentRange>>
  get clang_Cursor_getCommentRange => _library._clang_Cursor_getCommentRangePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getRawCommentText>>
  get clang_Cursor_getRawCommentText =>
      _library._clang_Cursor_getRawCommentTextPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getBriefCommentText>>
  get clang_Cursor_getBriefCommentText =>
      _library._clang_Cursor_getBriefCommentTextPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getMangling>>
  get clang_Cursor_getMangling => _library._clang_Cursor_getManglingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getCXXManglings>>
  get clang_Cursor_getCXXManglings => _library._clang_Cursor_getCXXManglingsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getObjCManglings>>
  get clang_Cursor_getObjCManglings =>
      _library._clang_Cursor_getObjCManglingsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_getModule>>
  get clang_Cursor_getModule => _library._clang_Cursor_getModulePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getModuleForFile>>
  get clang_getModuleForFile => _library._clang_getModuleForFilePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Module_getASTFile>>
  get clang_Module_getASTFile => _library._clang_Module_getASTFilePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Module_getParent>>
  get clang_Module_getParent => _library._clang_Module_getParentPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Module_getName>>
  get clang_Module_getName => _library._clang_Module_getNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Module_getFullName>>
  get clang_Module_getFullName => _library._clang_Module_getFullNamePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Module_isSystem>>
  get clang_Module_isSystem => _library._clang_Module_isSystemPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Module_getNumTopLevelHeaders>>
  get clang_Module_getNumTopLevelHeaders =>
      _library._clang_Module_getNumTopLevelHeadersPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Module_getTopLevelHeader>>
  get clang_Module_getTopLevelHeader =>
      _library._clang_Module_getTopLevelHeaderPtr;
  ffi.Pointer<
    ffi.NativeFunction<NativeClang_CXXConstructor_isConvertingConstructor>
  >
  get clang_CXXConstructor_isConvertingConstructor =>
      _library._clang_CXXConstructor_isConvertingConstructorPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXXConstructor_isCopyConstructor>>
  get clang_CXXConstructor_isCopyConstructor =>
      _library._clang_CXXConstructor_isCopyConstructorPtr;
  ffi.Pointer<
    ffi.NativeFunction<NativeClang_CXXConstructor_isDefaultConstructor>
  >
  get clang_CXXConstructor_isDefaultConstructor =>
      _library._clang_CXXConstructor_isDefaultConstructorPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXXConstructor_isMoveConstructor>>
  get clang_CXXConstructor_isMoveConstructor =>
      _library._clang_CXXConstructor_isMoveConstructorPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXXField_isMutable>>
  get clang_CXXField_isMutable => _library._clang_CXXField_isMutablePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXXMethod_isDefaulted>>
  get clang_CXXMethod_isDefaulted => _library._clang_CXXMethod_isDefaultedPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXXMethod_isPureVirtual>>
  get clang_CXXMethod_isPureVirtual =>
      _library._clang_CXXMethod_isPureVirtualPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXXMethod_isStatic>>
  get clang_CXXMethod_isStatic => _library._clang_CXXMethod_isStaticPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXXMethod_isVirtual>>
  get clang_CXXMethod_isVirtual => _library._clang_CXXMethod_isVirtualPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXXRecord_isAbstract>>
  get clang_CXXRecord_isAbstract => _library._clang_CXXRecord_isAbstractPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_EnumDecl_isScoped>>
  get clang_EnumDecl_isScoped => _library._clang_EnumDecl_isScopedPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_CXXMethod_isConst>>
  get clang_CXXMethod_isConst => _library._clang_CXXMethod_isConstPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTemplateCursorKind>>
  get clang_getTemplateCursorKind => _library._clang_getTemplateCursorKindPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getSpecializedCursorTemplate>>
  get clang_getSpecializedCursorTemplate =>
      _library._clang_getSpecializedCursorTemplatePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorReferenceNameRange>>
  get clang_getCursorReferenceNameRange =>
      _library._clang_getCursorReferenceNameRangePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getToken>> get clang_getToken =>
      _library._clang_getTokenPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTokenKind>>
  get clang_getTokenKind => _library._clang_getTokenKindPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTokenSpelling>>
  get clang_getTokenSpelling => _library._clang_getTokenSpellingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTokenLocation>>
  get clang_getTokenLocation => _library._clang_getTokenLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getTokenExtent>>
  get clang_getTokenExtent => _library._clang_getTokenExtentPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_tokenize>> get clang_tokenize =>
      _library._clang_tokenizePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_annotateTokens>>
  get clang_annotateTokens => _library._clang_annotateTokensPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeTokens>>
  get clang_disposeTokens => _library._clang_disposeTokensPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorKindSpelling>>
  get clang_getCursorKindSpelling => _library._clang_getCursorKindSpellingPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getDefinitionSpellingAndExtent>>
  get clang_getDefinitionSpellingAndExtent =>
      _library._clang_getDefinitionSpellingAndExtentPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_enableStackTraces>>
  get clang_enableStackTraces => _library._clang_enableStackTracesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_executeOnThread>>
  get clang_executeOnThread => _library._clang_executeOnThreadPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionChunkKind>>
  get clang_getCompletionChunkKind => _library._clang_getCompletionChunkKindPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionChunkText>>
  get clang_getCompletionChunkText => _library._clang_getCompletionChunkTextPtr;
  ffi.Pointer<
    ffi.NativeFunction<NativeClang_getCompletionChunkCompletionString>
  >
  get clang_getCompletionChunkCompletionString =>
      _library._clang_getCompletionChunkCompletionStringPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getNumCompletionChunks>>
  get clang_getNumCompletionChunks => _library._clang_getNumCompletionChunksPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionPriority>>
  get clang_getCompletionPriority => _library._clang_getCompletionPriorityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionAvailability>>
  get clang_getCompletionAvailability =>
      _library._clang_getCompletionAvailabilityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionNumAnnotations>>
  get clang_getCompletionNumAnnotations =>
      _library._clang_getCompletionNumAnnotationsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionAnnotation>>
  get clang_getCompletionAnnotation =>
      _library._clang_getCompletionAnnotationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionParent>>
  get clang_getCompletionParent => _library._clang_getCompletionParentPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionBriefComment>>
  get clang_getCompletionBriefComment =>
      _library._clang_getCompletionBriefCommentPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCursorCompletionString>>
  get clang_getCursorCompletionString =>
      _library._clang_getCursorCompletionStringPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionNumFixIts>>
  get clang_getCompletionNumFixIts => _library._clang_getCompletionNumFixItsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getCompletionFixIt>>
  get clang_getCompletionFixIt => _library._clang_getCompletionFixItPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_defaultCodeCompleteOptions>>
  get clang_defaultCodeCompleteOptions =>
      _library._clang_defaultCodeCompleteOptionsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_codeCompleteAt>>
  get clang_codeCompleteAt => _library._clang_codeCompleteAtPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_sortCodeCompletionResults>>
  get clang_sortCodeCompletionResults =>
      _library._clang_sortCodeCompletionResultsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_disposeCodeCompleteResults>>
  get clang_disposeCodeCompleteResults =>
      _library._clang_disposeCodeCompleteResultsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_codeCompleteGetNumDiagnostics>>
  get clang_codeCompleteGetNumDiagnostics =>
      _library._clang_codeCompleteGetNumDiagnosticsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_codeCompleteGetDiagnostic>>
  get clang_codeCompleteGetDiagnostic =>
      _library._clang_codeCompleteGetDiagnosticPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_codeCompleteGetContexts>>
  get clang_codeCompleteGetContexts =>
      _library._clang_codeCompleteGetContextsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_codeCompleteGetContainerKind>>
  get clang_codeCompleteGetContainerKind =>
      _library._clang_codeCompleteGetContainerKindPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_codeCompleteGetContainerUSR>>
  get clang_codeCompleteGetContainerUSR =>
      _library._clang_codeCompleteGetContainerUSRPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_codeCompleteGetObjCSelector>>
  get clang_codeCompleteGetObjCSelector =>
      _library._clang_codeCompleteGetObjCSelectorPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getClangVersion>>
  get clang_getClangVersion => _library._clang_getClangVersionPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_toggleCrashRecovery>>
  get clang_toggleCrashRecovery => _library._clang_toggleCrashRecoveryPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getInclusions>>
  get clang_getInclusions => _library._clang_getInclusionsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Cursor_Evaluate>>
  get clang_Cursor_Evaluate => _library._clang_Cursor_EvaluatePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_EvalResult_getKind>>
  get clang_EvalResult_getKind => _library._clang_EvalResult_getKindPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_EvalResult_getAsInt>>
  get clang_EvalResult_getAsInt => _library._clang_EvalResult_getAsIntPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_EvalResult_getAsLongLong>>
  get clang_EvalResult_getAsLongLong =>
      _library._clang_EvalResult_getAsLongLongPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_EvalResult_isUnsignedInt>>
  get clang_EvalResult_isUnsignedInt =>
      _library._clang_EvalResult_isUnsignedIntPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_EvalResult_getAsUnsigned>>
  get clang_EvalResult_getAsUnsigned =>
      _library._clang_EvalResult_getAsUnsignedPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_EvalResult_getAsDouble>>
  get clang_EvalResult_getAsDouble => _library._clang_EvalResult_getAsDoublePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_EvalResult_getAsStr>>
  get clang_EvalResult_getAsStr => _library._clang_EvalResult_getAsStrPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_EvalResult_dispose>>
  get clang_EvalResult_dispose => _library._clang_EvalResult_disposePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getRemappings>>
  get clang_getRemappings => _library._clang_getRemappingsPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_getRemappingsFromFileList>>
  get clang_getRemappingsFromFileList =>
      _library._clang_getRemappingsFromFileListPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_remap_getNumFiles>>
  get clang_remap_getNumFiles => _library._clang_remap_getNumFilesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_remap_getFilenames>>
  get clang_remap_getFilenames => _library._clang_remap_getFilenamesPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_remap_dispose>>
  get clang_remap_dispose => _library._clang_remap_disposePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_findReferencesInFile>>
  get clang_findReferencesInFile => _library._clang_findReferencesInFilePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_findIncludesInFile>>
  get clang_findIncludesInFile => _library._clang_findIncludesInFilePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_isEntityObjCContainerKind>>
  get clang_index_isEntityObjCContainerKind =>
      _library._clang_index_isEntityObjCContainerKindPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_getObjCContainerDeclInfo>>
  get clang_index_getObjCContainerDeclInfo =>
      _library._clang_index_getObjCContainerDeclInfoPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_getObjCInterfaceDeclInfo>>
  get clang_index_getObjCInterfaceDeclInfo =>
      _library._clang_index_getObjCInterfaceDeclInfoPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_getObjCCategoryDeclInfo>>
  get clang_index_getObjCCategoryDeclInfo =>
      _library._clang_index_getObjCCategoryDeclInfoPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_getObjCProtocolRefListInfo>>
  get clang_index_getObjCProtocolRefListInfo =>
      _library._clang_index_getObjCProtocolRefListInfoPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_getObjCPropertyDeclInfo>>
  get clang_index_getObjCPropertyDeclInfo =>
      _library._clang_index_getObjCPropertyDeclInfoPtr;
  ffi.Pointer<
    ffi.NativeFunction<NativeClang_index_getIBOutletCollectionAttrInfo>
  >
  get clang_index_getIBOutletCollectionAttrInfo =>
      _library._clang_index_getIBOutletCollectionAttrInfoPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_getCXXClassDeclInfo>>
  get clang_index_getCXXClassDeclInfo =>
      _library._clang_index_getCXXClassDeclInfoPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_getClientContainer>>
  get clang_index_getClientContainer =>
      _library._clang_index_getClientContainerPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_setClientContainer>>
  get clang_index_setClientContainer =>
      _library._clang_index_setClientContainerPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_getClientEntity>>
  get clang_index_getClientEntity => _library._clang_index_getClientEntityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_index_setClientEntity>>
  get clang_index_setClientEntity => _library._clang_index_setClientEntityPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_IndexAction_create>>
  get clang_IndexAction_create => _library._clang_IndexAction_createPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_IndexAction_dispose>>
  get clang_IndexAction_dispose => _library._clang_IndexAction_disposePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_indexSourceFile>>
  get clang_indexSourceFile => _library._clang_indexSourceFilePtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_indexSourceFileFullArgv>>
  get clang_indexSourceFileFullArgv =>
      _library._clang_indexSourceFileFullArgvPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_indexTranslationUnit>>
  get clang_indexTranslationUnit => _library._clang_indexTranslationUnitPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_indexLoc_getFileLocation>>
  get clang_indexLoc_getFileLocation =>
      _library._clang_indexLoc_getFileLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_indexLoc_getCXSourceLocation>>
  get clang_indexLoc_getCXSourceLocation =>
      _library._clang_indexLoc_getCXSourceLocationPtr;
  ffi.Pointer<ffi.NativeFunction<NativeClang_Type_visitFields>>
  get clang_Type_visitFields => _library._clang_Type_visitFieldsPtr;
}

/// A character string.
///
/// The \c CXString type is used to return strings from the interface when
/// the ownership of that string might differ from one call to the next.
/// Use \c clang_getCString() to retrieve the string data and, once finished
/// with the string data, call \c clang_disposeString() to free the string.
final class CXString extends ffi.Struct {
  external ffi.Pointer<ffi.Void> data;

  @ffi.UnsignedInt()
  external int private_flags;
}

final class CXStringSet extends ffi.Struct {
  external ffi.Pointer<CXString> Strings;

  @ffi.UnsignedInt()
  external int Count;
}

typedef NativeClang_getCString =
    ffi.Pointer<ffi.Char> Function(CXString string);
typedef DartClang_getCString = ffi.Pointer<ffi.Char> Function(CXString string);
typedef NativeClang_disposeString = ffi.Void Function(CXString string);
typedef DartClang_disposeString = void Function(CXString string);
typedef NativeClang_disposeStringSet =
    ffi.Void Function(ffi.Pointer<CXStringSet> set);
typedef DartClang_disposeStringSet =
    void Function(ffi.Pointer<CXStringSet> set);

/// An "index" that consists of a set of translation units that would
/// typically be linked together into an executable or library.
typedef CXIndex = ffi.Pointer<ffi.Void>;

final class CXTargetInfoImpl extends ffi.Opaque {}

/// An opaque type representing target information for a given translation
/// unit.
typedef CXTargetInfo = ffi.Pointer<CXTargetInfoImpl>;

final class CXTranslationUnitImpl extends ffi.Opaque {}

/// A single translation unit, which resides in an index.
typedef CXTranslationUnit = ffi.Pointer<CXTranslationUnitImpl>;

/// Opaque pointer representing client data that will be passed through
/// to various callbacks and visitors.
typedef CXClientData = ffi.Pointer<ffi.Void>;

/// Provides the contents of a file that has not yet been saved to disk.
///
/// Each CXUnsavedFile instance provides the name of a file on the
/// system along with the current contents of that file that have not
/// yet been saved to disk.
final class CXUnsavedFile extends ffi.Struct {
  /// The file whose contents have not yet been saved.
  ///
  /// This file must already exist in the file system.
  external ffi.Pointer<ffi.Char> Filename;

  /// A buffer containing the unsaved contents of this file.
  external ffi.Pointer<ffi.Char> Contents;

  /// The length of the unsaved contents of this buffer.
  @ffi.UnsignedLong()
  external int Length;
}

/// Describes the availability of a particular entity, which indicates
/// whether the use of this entity will result in a warning or error due to
/// it being deprecated or unavailable.
enum CXAvailabilityKind {
  /// The entity is available.
  CXAvailability_Available(0),

  /// The entity is available, but has been deprecated (and its use is
  /// not recommended).
  CXAvailability_Deprecated(1),

  /// The entity is not available; any use of it will be an error.
  CXAvailability_NotAvailable(2),

  /// The entity is available, but not accessible; any use of it will be
  /// an error.
  CXAvailability_NotAccessible(3);

  final int value;
  const CXAvailabilityKind(this.value);

  static CXAvailabilityKind fromValue(int value) => switch (value) {
    0 => CXAvailability_Available,
    1 => CXAvailability_Deprecated,
    2 => CXAvailability_NotAvailable,
    3 => CXAvailability_NotAccessible,
    _ => throw ArgumentError('Unknown value for CXAvailabilityKind: $value'),
  };
}

/// Describes a version number of the form major.minor.subminor.
final class CXVersion extends ffi.Struct {
  /// The major version number, e.g., the '10' in '10.7.3'. A negative
  /// value indicates that there is no version number at all.
  @ffi.Int()
  external int Major;

  /// The minor version number, e.g., the '7' in '10.7.3'. This value
  /// will be negative if no minor version number was provided, e.g., for
  /// version '10'.
  @ffi.Int()
  external int Minor;

  /// The subminor version number, e.g., the '3' in '10.7.3'. This value
  /// will be negative if no minor or subminor version number was provided,
  /// e.g., in version '10' or '10.7'.
  @ffi.Int()
  external int Subminor;
}

typedef NativeClang_createIndex =
    CXIndex Function(
      ffi.Int excludeDeclarationsFromPCH,
      ffi.Int displayDiagnostics,
    );
typedef DartClang_createIndex =
    CXIndex Function(int excludeDeclarationsFromPCH, int displayDiagnostics);
typedef NativeClang_disposeIndex = ffi.Void Function(CXIndex index);
typedef DartClang_disposeIndex = void Function(CXIndex index);

enum CXGlobalOptFlags {
  /// Used to indicate that no special CXIndex options are needed.
  CXGlobalOpt_None(0),

  /// Used to indicate that threads that libclang creates for indexing
  /// purposes should use background priority.
  ///
  /// Affects #clang_indexSourceFile, #clang_indexTranslationUnit,
  /// #clang_parseTranslationUnit, #clang_saveTranslationUnit.
  CXGlobalOpt_ThreadBackgroundPriorityForIndexing(1),

  /// Used to indicate that threads that libclang creates for editing
  /// purposes should use background priority.
  ///
  /// Affects #clang_reparseTranslationUnit, #clang_codeCompleteAt,
  /// #clang_annotateTokens
  CXGlobalOpt_ThreadBackgroundPriorityForEditing(2),

  /// Used to indicate that all threads that libclang creates should use
  /// background priority.
  CXGlobalOpt_ThreadBackgroundPriorityForAll(3);

  final int value;
  const CXGlobalOptFlags(this.value);

  static CXGlobalOptFlags fromValue(int value) => switch (value) {
    0 => CXGlobalOpt_None,
    1 => CXGlobalOpt_ThreadBackgroundPriorityForIndexing,
    2 => CXGlobalOpt_ThreadBackgroundPriorityForEditing,
    3 => CXGlobalOpt_ThreadBackgroundPriorityForAll,
    _ => throw ArgumentError('Unknown value for CXGlobalOptFlags: $value'),
  };
}

typedef NativeClang_CXIndex_setGlobalOptions =
    ffi.Void Function(CXIndex, ffi.UnsignedInt options);
typedef DartClang_CXIndex_setGlobalOptions =
    void Function(CXIndex, int options);
typedef NativeClang_CXIndex_getGlobalOptions =
    ffi.UnsignedInt Function(CXIndex);
typedef DartClang_CXIndex_getGlobalOptions = int Function(CXIndex);
typedef NativeClang_CXIndex_setInvocationEmissionPathOption =
    ffi.Void Function(CXIndex, ffi.Pointer<ffi.Char> Path);
typedef DartClang_CXIndex_setInvocationEmissionPathOption =
    void Function(CXIndex, ffi.Pointer<ffi.Char> Path);

/// A particular source file that is part of a translation unit.
typedef CXFile = ffi.Pointer<ffi.Void>;
typedef NativeClang_getFileName = CXString Function(CXFile SFile);
typedef DartClang_getFileName = CXString Function(CXFile SFile);
typedef NativeClang_getFileTime = ffi.Int64 Function(CXFile SFile);
typedef DartClang_getFileTime = int Function(CXFile SFile);

/// Uniquely identifies a CXFile, that refers to the same underlying file,
/// across an indexing session.
final class CXFileUniqueID extends ffi.Struct {
  @ffi.Array.multi([3])
  external ffi.Array<ffi.UnsignedLongLong> data;
}

typedef NativeClang_getFileUniqueID =
    ffi.Int Function(CXFile file, ffi.Pointer<CXFileUniqueID> outID);
typedef DartClang_getFileUniqueID =
    int Function(CXFile file, ffi.Pointer<CXFileUniqueID> outID);
typedef NativeClang_isFileMultipleIncludeGuarded =
    ffi.UnsignedInt Function(CXTranslationUnit tu, CXFile file);
typedef DartClang_isFileMultipleIncludeGuarded =
    int Function(CXTranslationUnit tu, CXFile file);
typedef NativeClang_getFile =
    CXFile Function(CXTranslationUnit tu, ffi.Pointer<ffi.Char> file_name);
typedef DartClang_getFile =
    CXFile Function(CXTranslationUnit tu, ffi.Pointer<ffi.Char> file_name);
typedef NativeClang_getFileContents =
    ffi.Pointer<ffi.Char> Function(
      CXTranslationUnit tu,
      CXFile file,
      ffi.Pointer<ffi.Size> size,
    );
typedef DartClang_getFileContents =
    ffi.Pointer<ffi.Char> Function(
      CXTranslationUnit tu,
      CXFile file,
      ffi.Pointer<ffi.Size> size,
    );
typedef NativeClang_File_isEqual = ffi.Int Function(CXFile file1, CXFile file2);
typedef DartClang_File_isEqual = int Function(CXFile file1, CXFile file2);
typedef NativeClang_File_tryGetRealPathName = CXString Function(CXFile file);
typedef DartClang_File_tryGetRealPathName = CXString Function(CXFile file);

/// Identifies a specific source location within a translation
/// unit.
///
/// Use clang_getExpansionLocation() or clang_getSpellingLocation()
/// to map a source location to a particular file, line, and column.
final class CXSourceLocation extends ffi.Struct {
  @ffi.Array.multi([2])
  external ffi.Array<ffi.Pointer<ffi.Void>> ptr_data;

  @ffi.UnsignedInt()
  external int int_data;
}

/// Identifies a half-open character range in the source code.
///
/// Use clang_getRangeStart() and clang_getRangeEnd() to retrieve the
/// starting and end locations from a source range, respectively.
final class CXSourceRange extends ffi.Struct {
  @ffi.Array.multi([2])
  external ffi.Array<ffi.Pointer<ffi.Void>> ptr_data;

  @ffi.UnsignedInt()
  external int begin_int_data;

  @ffi.UnsignedInt()
  external int end_int_data;
}

typedef NativeClang_getNullLocation = CXSourceLocation Function();
typedef DartClang_getNullLocation = CXSourceLocation Function();
typedef NativeClang_equalLocations =
    ffi.UnsignedInt Function(CXSourceLocation loc1, CXSourceLocation loc2);
typedef DartClang_equalLocations =
    int Function(CXSourceLocation loc1, CXSourceLocation loc2);
typedef NativeClang_getLocation =
    CXSourceLocation Function(
      CXTranslationUnit tu,
      CXFile file,
      ffi.UnsignedInt line,
      ffi.UnsignedInt column,
    );
typedef DartClang_getLocation =
    CXSourceLocation Function(
      CXTranslationUnit tu,
      CXFile file,
      int line,
      int column,
    );
typedef NativeClang_getLocationForOffset =
    CXSourceLocation Function(
      CXTranslationUnit tu,
      CXFile file,
      ffi.UnsignedInt offset,
    );
typedef DartClang_getLocationForOffset =
    CXSourceLocation Function(CXTranslationUnit tu, CXFile file, int offset);
typedef NativeClang_Location_isInSystemHeader =
    ffi.Int Function(CXSourceLocation location);
typedef DartClang_Location_isInSystemHeader =
    int Function(CXSourceLocation location);
typedef NativeClang_Location_isFromMainFile =
    ffi.Int Function(CXSourceLocation location);
typedef DartClang_Location_isFromMainFile =
    int Function(CXSourceLocation location);
typedef NativeClang_getNullRange = CXSourceRange Function();
typedef DartClang_getNullRange = CXSourceRange Function();
typedef NativeClang_getRange =
    CXSourceRange Function(CXSourceLocation begin, CXSourceLocation end);
typedef DartClang_getRange =
    CXSourceRange Function(CXSourceLocation begin, CXSourceLocation end);
typedef NativeClang_equalRanges =
    ffi.UnsignedInt Function(CXSourceRange range1, CXSourceRange range2);
typedef DartClang_equalRanges =
    int Function(CXSourceRange range1, CXSourceRange range2);
typedef NativeClang_Range_isNull = ffi.Int Function(CXSourceRange range);
typedef DartClang_Range_isNull = int Function(CXSourceRange range);
typedef NativeClang_getExpansionLocation =
    ffi.Void Function(
      CXSourceLocation location,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef DartClang_getExpansionLocation =
    void Function(
      CXSourceLocation location,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef NativeClang_getPresumedLocation =
    ffi.Void Function(
      CXSourceLocation location,
      ffi.Pointer<CXString> filename,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
    );
typedef DartClang_getPresumedLocation =
    void Function(
      CXSourceLocation location,
      ffi.Pointer<CXString> filename,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
    );
typedef NativeClang_getInstantiationLocation =
    ffi.Void Function(
      CXSourceLocation location,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef DartClang_getInstantiationLocation =
    void Function(
      CXSourceLocation location,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef NativeClang_getSpellingLocation =
    ffi.Void Function(
      CXSourceLocation location,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef DartClang_getSpellingLocation =
    void Function(
      CXSourceLocation location,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef NativeClang_getFileLocation =
    ffi.Void Function(
      CXSourceLocation location,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef DartClang_getFileLocation =
    void Function(
      CXSourceLocation location,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef NativeClang_getRangeStart =
    CXSourceLocation Function(CXSourceRange range);
typedef DartClang_getRangeStart =
    CXSourceLocation Function(CXSourceRange range);
typedef NativeClang_getRangeEnd =
    CXSourceLocation Function(CXSourceRange range);
typedef DartClang_getRangeEnd = CXSourceLocation Function(CXSourceRange range);

/// Identifies an array of ranges.
final class CXSourceRangeList extends ffi.Struct {
  /// The number of ranges in the \c ranges array.
  @ffi.UnsignedInt()
  external int count;

  /// An array of \c CXSourceRanges.
  external ffi.Pointer<CXSourceRange> ranges;
}

typedef NativeClang_getSkippedRanges =
    ffi.Pointer<CXSourceRangeList> Function(CXTranslationUnit tu, CXFile file);
typedef DartClang_getSkippedRanges =
    ffi.Pointer<CXSourceRangeList> Function(CXTranslationUnit tu, CXFile file);
typedef NativeClang_getAllSkippedRanges =
    ffi.Pointer<CXSourceRangeList> Function(CXTranslationUnit tu);
typedef DartClang_getAllSkippedRanges =
    ffi.Pointer<CXSourceRangeList> Function(CXTranslationUnit tu);
typedef NativeClang_disposeSourceRangeList =
    ffi.Void Function(ffi.Pointer<CXSourceRangeList> ranges);
typedef DartClang_disposeSourceRangeList =
    void Function(ffi.Pointer<CXSourceRangeList> ranges);

/// Describes the severity of a particular diagnostic.
enum CXDiagnosticSeverity {
  /// A diagnostic that has been suppressed, e.g., by a command-line
  /// option.
  CXDiagnostic_Ignored(0),

  /// This diagnostic is a note that should be attached to the
  /// previous (non-note) diagnostic.
  CXDiagnostic_Note(1),

  /// This diagnostic indicates suspicious code that may not be
  /// wrong.
  CXDiagnostic_Warning(2),

  /// This diagnostic indicates that the code is ill-formed.
  CXDiagnostic_Error(3),

  /// This diagnostic indicates that the code is ill-formed such
  /// that future parser recovery is unlikely to produce useful
  /// results.
  CXDiagnostic_Fatal(4);

  final int value;
  const CXDiagnosticSeverity(this.value);

  static CXDiagnosticSeverity fromValue(int value) => switch (value) {
    0 => CXDiagnostic_Ignored,
    1 => CXDiagnostic_Note,
    2 => CXDiagnostic_Warning,
    3 => CXDiagnostic_Error,
    4 => CXDiagnostic_Fatal,
    _ => throw ArgumentError('Unknown value for CXDiagnosticSeverity: $value'),
  };
}

/// A single diagnostic, containing the diagnostic's severity,
/// location, text, source ranges, and fix-it hints.
typedef CXDiagnostic = ffi.Pointer<ffi.Void>;

/// A group of CXDiagnostics.
typedef CXDiagnosticSet = ffi.Pointer<ffi.Void>;
typedef NativeClang_getNumDiagnosticsInSet =
    ffi.UnsignedInt Function(CXDiagnosticSet Diags);
typedef DartClang_getNumDiagnosticsInSet = int Function(CXDiagnosticSet Diags);
typedef NativeClang_getDiagnosticInSet =
    CXDiagnostic Function(CXDiagnosticSet Diags, ffi.UnsignedInt Index);
typedef DartClang_getDiagnosticInSet =
    CXDiagnostic Function(CXDiagnosticSet Diags, int Index);

/// Describes the kind of error that occurred (if any) in a call to
/// \c clang_loadDiagnostics.
enum CXLoadDiag_Error {
  /// Indicates that no error occurred.
  CXLoadDiag_None(0),

  /// Indicates that an unknown error occurred while attempting to
  /// deserialize diagnostics.
  CXLoadDiag_Unknown(1),

  /// Indicates that the file containing the serialized diagnostics
  /// could not be opened.
  CXLoadDiag_CannotLoad(2),

  /// Indicates that the serialized diagnostics file is invalid or
  /// corrupt.
  CXLoadDiag_InvalidFile(3);

  final int value;
  const CXLoadDiag_Error(this.value);

  static CXLoadDiag_Error fromValue(int value) => switch (value) {
    0 => CXLoadDiag_None,
    1 => CXLoadDiag_Unknown,
    2 => CXLoadDiag_CannotLoad,
    3 => CXLoadDiag_InvalidFile,
    _ => throw ArgumentError('Unknown value for CXLoadDiag_Error: $value'),
  };
}

typedef NativeClang_loadDiagnostics =
    CXDiagnosticSet Function(
      ffi.Pointer<ffi.Char> file,
      ffi.Pointer<ffi.UnsignedInt> error,
      ffi.Pointer<CXString> errorString,
    );
typedef DartClang_loadDiagnostics =
    CXDiagnosticSet Function(
      ffi.Pointer<ffi.Char> file,
      ffi.Pointer<ffi.UnsignedInt> error,
      ffi.Pointer<CXString> errorString,
    );
typedef NativeClang_disposeDiagnosticSet =
    ffi.Void Function(CXDiagnosticSet Diags);
typedef DartClang_disposeDiagnosticSet = void Function(CXDiagnosticSet Diags);
typedef NativeClang_getChildDiagnostics =
    CXDiagnosticSet Function(CXDiagnostic D);
typedef DartClang_getChildDiagnostics =
    CXDiagnosticSet Function(CXDiagnostic D);
typedef NativeClang_getNumDiagnostics =
    ffi.UnsignedInt Function(CXTranslationUnit Unit);
typedef DartClang_getNumDiagnostics = int Function(CXTranslationUnit Unit);
typedef NativeClang_getDiagnostic =
    CXDiagnostic Function(CXTranslationUnit Unit, ffi.UnsignedInt Index);
typedef DartClang_getDiagnostic =
    CXDiagnostic Function(CXTranslationUnit Unit, int Index);
typedef NativeClang_getDiagnosticSetFromTU =
    CXDiagnosticSet Function(CXTranslationUnit Unit);
typedef DartClang_getDiagnosticSetFromTU =
    CXDiagnosticSet Function(CXTranslationUnit Unit);
typedef NativeClang_disposeDiagnostic =
    ffi.Void Function(CXDiagnostic Diagnostic);
typedef DartClang_disposeDiagnostic = void Function(CXDiagnostic Diagnostic);
typedef NativeClang_formatDiagnostic =
    CXString Function(CXDiagnostic Diagnostic, ffi.UnsignedInt Options);
typedef DartClang_formatDiagnostic =
    CXString Function(CXDiagnostic Diagnostic, int Options);
typedef NativeClang_defaultDiagnosticDisplayOptions =
    ffi.UnsignedInt Function();
typedef DartClang_defaultDiagnosticDisplayOptions = int Function();
typedef NativeClang_getDiagnosticSeverity =
    ffi.UnsignedInt Function(CXDiagnostic);
typedef DartClang_getDiagnosticSeverity = int Function(CXDiagnostic);
typedef NativeClang_getDiagnosticLocation =
    CXSourceLocation Function(CXDiagnostic);
typedef DartClang_getDiagnosticLocation =
    CXSourceLocation Function(CXDiagnostic);
typedef NativeClang_getDiagnosticSpelling = CXString Function(CXDiagnostic);
typedef DartClang_getDiagnosticSpelling = CXString Function(CXDiagnostic);
typedef NativeClang_getDiagnosticOption =
    CXString Function(CXDiagnostic Diag, ffi.Pointer<CXString> Disable);
typedef DartClang_getDiagnosticOption =
    CXString Function(CXDiagnostic Diag, ffi.Pointer<CXString> Disable);
typedef NativeClang_getDiagnosticCategory =
    ffi.UnsignedInt Function(CXDiagnostic);
typedef DartClang_getDiagnosticCategory = int Function(CXDiagnostic);
typedef NativeClang_getDiagnosticCategoryName =
    CXString Function(ffi.UnsignedInt Category);
typedef DartClang_getDiagnosticCategoryName = CXString Function(int Category);
typedef NativeClang_getDiagnosticCategoryText = CXString Function(CXDiagnostic);
typedef DartClang_getDiagnosticCategoryText = CXString Function(CXDiagnostic);
typedef NativeClang_getDiagnosticNumRanges =
    ffi.UnsignedInt Function(CXDiagnostic);
typedef DartClang_getDiagnosticNumRanges = int Function(CXDiagnostic);
typedef NativeClang_getDiagnosticRange =
    CXSourceRange Function(CXDiagnostic Diagnostic, ffi.UnsignedInt Range);
typedef DartClang_getDiagnosticRange =
    CXSourceRange Function(CXDiagnostic Diagnostic, int Range);
typedef NativeClang_getDiagnosticNumFixIts =
    ffi.UnsignedInt Function(CXDiagnostic Diagnostic);
typedef DartClang_getDiagnosticNumFixIts =
    int Function(CXDiagnostic Diagnostic);
typedef NativeClang_getDiagnosticFixIt =
    CXString Function(
      CXDiagnostic Diagnostic,
      ffi.UnsignedInt FixIt,
      ffi.Pointer<CXSourceRange> ReplacementRange,
    );
typedef DartClang_getDiagnosticFixIt =
    CXString Function(
      CXDiagnostic Diagnostic,
      int FixIt,
      ffi.Pointer<CXSourceRange> ReplacementRange,
    );
typedef NativeClang_getTranslationUnitSpelling =
    CXString Function(CXTranslationUnit CTUnit);
typedef DartClang_getTranslationUnitSpelling =
    CXString Function(CXTranslationUnit CTUnit);
typedef NativeClang_createTranslationUnitFromSourceFile =
    CXTranslationUnit Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Int num_clang_command_line_args,
      ffi.Pointer<ffi.Pointer<ffi.Char>> clang_command_line_args,
      ffi.UnsignedInt num_unsaved_files,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
    );
typedef DartClang_createTranslationUnitFromSourceFile =
    CXTranslationUnit Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> source_filename,
      int num_clang_command_line_args,
      ffi.Pointer<ffi.Pointer<ffi.Char>> clang_command_line_args,
      int num_unsaved_files,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
    );
typedef NativeClang_createTranslationUnit =
    CXTranslationUnit Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> ast_filename,
    );
typedef DartClang_createTranslationUnit =
    CXTranslationUnit Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> ast_filename,
    );

/// Error codes returned by libclang routines.
///
/// Zero (\c CXError_Success) is the only error code indicating success.  Other
/// error codes, including not yet assigned non-zero values, indicate errors.
enum CXErrorCode {
  /// No error.
  CXError_Success(0),

  /// A generic error code, no further details are available.
  ///
  /// Errors of this kind can get their own specific error codes in future
  /// libclang versions.
  CXError_Failure(1),

  /// libclang crashed while performing the requested operation.
  CXError_Crashed(2),

  /// The function detected that the arguments violate the function
  /// contract.
  CXError_InvalidArguments(3),

  /// An AST deserialization error has occurred.
  CXError_ASTReadError(4);

  final int value;
  const CXErrorCode(this.value);

  static CXErrorCode fromValue(int value) => switch (value) {
    0 => CXError_Success,
    1 => CXError_Failure,
    2 => CXError_Crashed,
    3 => CXError_InvalidArguments,
    4 => CXError_ASTReadError,
    _ => throw ArgumentError('Unknown value for CXErrorCode: $value'),
  };
}

typedef NativeClang_createTranslationUnit2 =
    ffi.UnsignedInt Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> ast_filename,
      ffi.Pointer<CXTranslationUnit> out_TU,
    );
typedef DartClang_createTranslationUnit2 =
    int Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> ast_filename,
      ffi.Pointer<CXTranslationUnit> out_TU,
    );
typedef NativeClang_defaultEditingTranslationUnitOptions =
    ffi.UnsignedInt Function();
typedef DartClang_defaultEditingTranslationUnitOptions = int Function();
typedef NativeClang_parseTranslationUnit =
    CXTranslationUnit Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      ffi.Int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      ffi.UnsignedInt num_unsaved_files,
      ffi.UnsignedInt options,
    );
typedef DartClang_parseTranslationUnit =
    CXTranslationUnit Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      int num_unsaved_files,
      int options,
    );
typedef NativeClang_parseTranslationUnit2 =
    ffi.UnsignedInt Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      ffi.Int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      ffi.UnsignedInt num_unsaved_files,
      ffi.UnsignedInt options,
      ffi.Pointer<CXTranslationUnit> out_TU,
    );
typedef DartClang_parseTranslationUnit2 =
    int Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      int num_unsaved_files,
      int options,
      ffi.Pointer<CXTranslationUnit> out_TU,
    );
typedef NativeClang_parseTranslationUnit2FullArgv =
    ffi.UnsignedInt Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      ffi.Int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      ffi.UnsignedInt num_unsaved_files,
      ffi.UnsignedInt options,
      ffi.Pointer<CXTranslationUnit> out_TU,
    );
typedef DartClang_parseTranslationUnit2FullArgv =
    int Function(
      CXIndex CIdx,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      int num_unsaved_files,
      int options,
      ffi.Pointer<CXTranslationUnit> out_TU,
    );
typedef NativeClang_defaultSaveOptions =
    ffi.UnsignedInt Function(CXTranslationUnit TU);
typedef DartClang_defaultSaveOptions = int Function(CXTranslationUnit TU);
typedef NativeClang_saveTranslationUnit =
    ffi.Int Function(
      CXTranslationUnit TU,
      ffi.Pointer<ffi.Char> FileName,
      ffi.UnsignedInt options,
    );
typedef DartClang_saveTranslationUnit =
    int Function(
      CXTranslationUnit TU,
      ffi.Pointer<ffi.Char> FileName,
      int options,
    );
typedef NativeClang_suspendTranslationUnit =
    ffi.UnsignedInt Function(CXTranslationUnit);
typedef DartClang_suspendTranslationUnit = int Function(CXTranslationUnit);
typedef NativeClang_disposeTranslationUnit =
    ffi.Void Function(CXTranslationUnit);
typedef DartClang_disposeTranslationUnit = void Function(CXTranslationUnit);
typedef NativeClang_defaultReparseOptions =
    ffi.UnsignedInt Function(CXTranslationUnit TU);
typedef DartClang_defaultReparseOptions = int Function(CXTranslationUnit TU);
typedef NativeClang_reparseTranslationUnit =
    ffi.Int Function(
      CXTranslationUnit TU,
      ffi.UnsignedInt num_unsaved_files,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      ffi.UnsignedInt options,
    );
typedef DartClang_reparseTranslationUnit =
    int Function(
      CXTranslationUnit TU,
      int num_unsaved_files,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      int options,
    );

/// Categorizes how memory is being used by a translation unit.
enum CXTUResourceUsageKind {
  CXTUResourceUsage_AST(1),
  CXTUResourceUsage_Identifiers(2),
  CXTUResourceUsage_Selectors(3),
  CXTUResourceUsage_GlobalCompletionResults(4),
  CXTUResourceUsage_SourceManagerContentCache(5),
  CXTUResourceUsage_AST_SideTables(6),
  CXTUResourceUsage_SourceManager_Membuffer_Malloc(7),
  CXTUResourceUsage_SourceManager_Membuffer_MMap(8),
  CXTUResourceUsage_ExternalASTSource_Membuffer_Malloc(9),
  CXTUResourceUsage_ExternalASTSource_Membuffer_MMap(10),
  CXTUResourceUsage_Preprocessor(11),
  CXTUResourceUsage_PreprocessingRecord(12),
  CXTUResourceUsage_SourceManager_DataStructures(13),
  CXTUResourceUsage_Preprocessor_HeaderSearch(14);

  static const CXTUResourceUsage_MEMORY_IN_BYTES_BEGIN = CXTUResourceUsage_AST;
  static const CXTUResourceUsage_MEMORY_IN_BYTES_END =
      CXTUResourceUsage_Preprocessor_HeaderSearch;
  static const CXTUResourceUsage_First = CXTUResourceUsage_AST;
  static const CXTUResourceUsage_Last =
      CXTUResourceUsage_Preprocessor_HeaderSearch;

  final int value;
  const CXTUResourceUsageKind(this.value);

  static CXTUResourceUsageKind fromValue(int value) => switch (value) {
    1 => CXTUResourceUsage_AST,
    2 => CXTUResourceUsage_Identifiers,
    3 => CXTUResourceUsage_Selectors,
    4 => CXTUResourceUsage_GlobalCompletionResults,
    5 => CXTUResourceUsage_SourceManagerContentCache,
    6 => CXTUResourceUsage_AST_SideTables,
    7 => CXTUResourceUsage_SourceManager_Membuffer_Malloc,
    8 => CXTUResourceUsage_SourceManager_Membuffer_MMap,
    9 => CXTUResourceUsage_ExternalASTSource_Membuffer_Malloc,
    10 => CXTUResourceUsage_ExternalASTSource_Membuffer_MMap,
    11 => CXTUResourceUsage_Preprocessor,
    12 => CXTUResourceUsage_PreprocessingRecord,
    13 => CXTUResourceUsage_SourceManager_DataStructures,
    14 => CXTUResourceUsage_Preprocessor_HeaderSearch,
    _ => throw ArgumentError('Unknown value for CXTUResourceUsageKind: $value'),
  };

  @override
  String toString() {
    if (this == CXTUResourceUsage_AST)
      return "CXTUResourceUsageKind.CXTUResourceUsage_AST, CXTUResourceUsageKind.CXTUResourceUsage_MEMORY_IN_BYTES_BEGIN, CXTUResourceUsageKind.CXTUResourceUsage_First";
    if (this == CXTUResourceUsage_Preprocessor_HeaderSearch)
      return "CXTUResourceUsageKind.CXTUResourceUsage_Preprocessor_HeaderSearch, CXTUResourceUsageKind.CXTUResourceUsage_MEMORY_IN_BYTES_END, CXTUResourceUsageKind.CXTUResourceUsage_Last";
    return super.toString();
  }
}

typedef NativeClang_getTUResourceUsageName =
    ffi.Pointer<ffi.Char> Function(ffi.UnsignedInt kind);
typedef DartClang_getTUResourceUsageName =
    ffi.Pointer<ffi.Char> Function(int kind);

final class CXTUResourceUsageEntry extends ffi.Struct {
  @ffi.UnsignedInt()
  external int kindAsInt;

  CXTUResourceUsageKind get kind => CXTUResourceUsageKind.fromValue(kindAsInt);

  @ffi.UnsignedLong()
  external int amount;
}

/// The memory usage of a CXTranslationUnit, broken into categories.
final class CXTUResourceUsage extends ffi.Struct {
  external ffi.Pointer<ffi.Void> data;

  @ffi.UnsignedInt()
  external int numEntries;

  external ffi.Pointer<CXTUResourceUsageEntry> entries;
}

typedef NativeClang_getCXTUResourceUsage =
    CXTUResourceUsage Function(CXTranslationUnit TU);
typedef DartClang_getCXTUResourceUsage =
    CXTUResourceUsage Function(CXTranslationUnit TU);
typedef NativeClang_disposeCXTUResourceUsage =
    ffi.Void Function(CXTUResourceUsage usage);
typedef DartClang_disposeCXTUResourceUsage =
    void Function(CXTUResourceUsage usage);
typedef NativeClang_getTranslationUnitTargetInfo =
    CXTargetInfo Function(CXTranslationUnit CTUnit);
typedef DartClang_getTranslationUnitTargetInfo =
    CXTargetInfo Function(CXTranslationUnit CTUnit);
typedef NativeClang_TargetInfo_dispose = ffi.Void Function(CXTargetInfo Info);
typedef DartClang_TargetInfo_dispose = void Function(CXTargetInfo Info);
typedef NativeClang_TargetInfo_getTriple = CXString Function(CXTargetInfo Info);
typedef DartClang_TargetInfo_getTriple = CXString Function(CXTargetInfo Info);
typedef NativeClang_TargetInfo_getPointerWidth =
    ffi.Int Function(CXTargetInfo Info);
typedef DartClang_TargetInfo_getPointerWidth = int Function(CXTargetInfo Info);

/// Describes the kind of entity that a cursor refers to.
enum CXCursorKind {
  /// A declaration whose specific kind is not exposed via this
  /// interface.
  ///
  /// Unexposed declarations have the same operations as any other kind
  /// of declaration; one can extract their location information,
  /// spelling, find their definitions, etc. However, the specific kind
  /// of the declaration is not reported.
  CXCursor_UnexposedDecl(1),

  /// A C or C++ struct.
  CXCursor_StructDecl(2),

  /// A C or C++ union.
  CXCursor_UnionDecl(3),

  /// A C++ class.
  CXCursor_ClassDecl(4),

  /// An enumeration.
  CXCursor_EnumDecl(5),

  /// A field (in C) or non-static data member (in C++) in a
  /// struct, union, or C++ class.
  CXCursor_FieldDecl(6),

  /// An enumerator constant.
  CXCursor_EnumConstantDecl(7),

  /// A function.
  CXCursor_FunctionDecl(8),

  /// A variable.
  CXCursor_VarDecl(9),

  /// A function or method parameter.
  CXCursor_ParmDecl(10),

  /// An Objective-C \@interface.
  CXCursor_ObjCInterfaceDecl(11),

  /// An Objective-C \@interface for a category.
  CXCursor_ObjCCategoryDecl(12),

  /// An Objective-C \@protocol declaration.
  CXCursor_ObjCProtocolDecl(13),

  /// An Objective-C \@property declaration.
  CXCursor_ObjCPropertyDecl(14),

  /// An Objective-C instance variable.
  CXCursor_ObjCIvarDecl(15),

  /// An Objective-C instance method.
  CXCursor_ObjCInstanceMethodDecl(16),

  /// An Objective-C class method.
  CXCursor_ObjCClassMethodDecl(17),

  /// An Objective-C \@implementation.
  CXCursor_ObjCImplementationDecl(18),

  /// An Objective-C \@implementation for a category.
  CXCursor_ObjCCategoryImplDecl(19),

  /// A typedef.
  CXCursor_TypedefDecl(20),

  /// A C++ class method.
  CXCursor_CXXMethod(21),

  /// A C++ namespace.
  CXCursor_Namespace(22),

  /// A linkage specification, e.g. 'extern "C"'.
  CXCursor_LinkageSpec(23),

  /// A C++ constructor.
  CXCursor_Constructor(24),

  /// A C++ destructor.
  CXCursor_Destructor(25),

  /// A C++ conversion function.
  CXCursor_ConversionFunction(26),

  /// A C++ template type parameter.
  CXCursor_TemplateTypeParameter(27),

  /// A C++ non-type template parameter.
  CXCursor_NonTypeTemplateParameter(28),

  /// A C++ template template parameter.
  CXCursor_TemplateTemplateParameter(29),

  /// A C++ function template.
  CXCursor_FunctionTemplate(30),

  /// A C++ class template.
  CXCursor_ClassTemplate(31),

  /// A C++ class template partial specialization.
  CXCursor_ClassTemplatePartialSpecialization(32),

  /// A C++ namespace alias declaration.
  CXCursor_NamespaceAlias(33),

  /// A C++ using directive.
  CXCursor_UsingDirective(34),

  /// A C++ using declaration.
  CXCursor_UsingDeclaration(35),

  /// A C++ alias declaration
  CXCursor_TypeAliasDecl(36),

  /// An Objective-C \@synthesize definition.
  CXCursor_ObjCSynthesizeDecl(37),

  /// An Objective-C \@dynamic definition.
  CXCursor_ObjCDynamicDecl(38),

  /// An access specifier.
  CXCursor_CXXAccessSpecifier(39),
  CXCursor_FirstRef(40),
  CXCursor_ObjCProtocolRef(41),
  CXCursor_ObjCClassRef(42),

  /// A reference to a type declaration.
  ///
  /// A type reference occurs anywhere where a type is named but not
  /// declared. For example, given:
  ///
  /// \code
  /// typedef unsigned size_type;
  /// size_type size;
  /// \endcode
  ///
  /// The typedef is a declaration of size_type (CXCursor_TypedefDecl),
  /// while the type of the variable "size" is referenced. The cursor
  /// referenced by the type of size is the typedef for size_type.
  CXCursor_TypeRef(43),
  CXCursor_CXXBaseSpecifier(44),

  /// A reference to a class template, function template, template
  /// template parameter, or class template partial specialization.
  CXCursor_TemplateRef(45),

  /// A reference to a namespace or namespace alias.
  CXCursor_NamespaceRef(46),

  /// A reference to a member of a struct, union, or class that occurs in
  /// some non-expression context, e.g., a designated initializer.
  CXCursor_MemberRef(47),

  /// A reference to a labeled statement.
  ///
  /// This cursor kind is used to describe the jump to "start_over" in the
  /// goto statement in the following example:
  ///
  /// \code
  /// start_over:
  /// ++counter;
  ///
  /// goto start_over;
  /// \endcode
  ///
  /// A label reference cursor refers to a label statement.
  CXCursor_LabelRef(48),

  /// A reference to a set of overloaded functions or function templates
  /// that has not yet been resolved to a specific function or function template.
  ///
  /// An overloaded declaration reference cursor occurs in C++ templates where
  /// a dependent name refers to a function. For example:
  ///
  /// \code
  /// template<typename T> void swap(T&, T&);
  ///
  /// struct X { ... };
  /// void swap(X&, X&);
  ///
  /// template<typename T>
  /// void reverse(T* first, T* last) {
  /// while (first < last - 1) {
  /// swap(*first, *--last);
  /// ++first;
  /// }
  /// }
  ///
  /// struct Y { };
  /// void swap(Y&, Y&);
  /// \endcode
  ///
  /// Here, the identifier "swap" is associated with an overloaded declaration
  /// reference. In the template definition, "swap" refers to either of the two
  /// "swap" functions declared above, so both results will be available. At
  /// instantiation time, "swap" may also refer to other functions found via
  /// argument-dependent lookup (e.g., the "swap" function at the end of the
  /// example).
  ///
  /// The functions \c clang_getNumOverloadedDecls() and
  /// \c clang_getOverloadedDecl() can be used to retrieve the definitions
  /// referenced by this cursor.
  CXCursor_OverloadedDeclRef(49),

  /// A reference to a variable that occurs in some non-expression
  /// context, e.g., a C++ lambda capture list.
  CXCursor_VariableRef(50),
  CXCursor_FirstInvalid(70),
  CXCursor_NoDeclFound(71),
  CXCursor_NotImplemented(72),
  CXCursor_InvalidCode(73),
  CXCursor_FirstExpr(100),

  /// An expression that refers to some value declaration, such
  /// as a function, variable, or enumerator.
  CXCursor_DeclRefExpr(101),

  /// An expression that refers to a member of a struct, union,
  /// class, Objective-C class, etc.
  CXCursor_MemberRefExpr(102),

  /// An expression that calls a function.
  CXCursor_CallExpr(103),

  /// An expression that sends a message to an Objective-C
  /// object or class.
  CXCursor_ObjCMessageExpr(104),

  /// An expression that represents a block literal.
  CXCursor_BlockExpr(105),

  /// An integer literal.
  CXCursor_IntegerLiteral(106),

  /// A floating point number literal.
  CXCursor_FloatingLiteral(107),

  /// An imaginary number literal.
  CXCursor_ImaginaryLiteral(108),

  /// A string literal.
  CXCursor_StringLiteral(109),

  /// A character literal.
  CXCursor_CharacterLiteral(110),

  /// A parenthesized expression, e.g. "(1)".
  ///
  /// This AST node is only formed if full location information is requested.
  CXCursor_ParenExpr(111),

  /// This represents the unary-expression's (except sizeof and
  /// alignof).
  CXCursor_UnaryOperator(112),

  /// [C99 6.5.2.1] Array Subscripting.
  CXCursor_ArraySubscriptExpr(113),

  /// A builtin binary operation expression such as "x + y" or
  /// "x <= y".
  CXCursor_BinaryOperator(114),

  /// Compound assignment such as "+=".
  CXCursor_CompoundAssignOperator(115),

  /// The ?: ternary operator.
  CXCursor_ConditionalOperator(116),

  /// An explicit cast in C (C99 6.5.4) or a C-style cast in C++
  /// (C++ [expr.cast]), which uses the syntax (Type)expr.
  ///
  /// For example: (int)f.
  CXCursor_CStyleCastExpr(117),

  /// [C99 6.5.2.5]
  CXCursor_CompoundLiteralExpr(118),

  /// Describes an C or C++ initializer list.
  CXCursor_InitListExpr(119),

  /// The GNU address of label extension, representing &&label.
  CXCursor_AddrLabelExpr(120),

  /// This is the GNU Statement Expression extension: ({int X=4; X;})
  CXCursor_StmtExpr(121),

  /// Represents a C11 generic selection.
  CXCursor_GenericSelectionExpr(122),

  /// Implements the GNU __null extension, which is a name for a null
  /// pointer constant that has integral type (e.g., int or long) and is the same
  /// size and alignment as a pointer.
  ///
  /// The __null extension is typically only used by system headers, which define
  /// NULL as __null in C++ rather than using 0 (which is an integer that may not
  /// match the size of a pointer).
  CXCursor_GNUNullExpr(123),

  /// C++'s static_cast<> expression.
  CXCursor_CXXStaticCastExpr(124),

  /// C++'s dynamic_cast<> expression.
  CXCursor_CXXDynamicCastExpr(125),

  /// C++'s reinterpret_cast<> expression.
  CXCursor_CXXReinterpretCastExpr(126),

  /// C++'s const_cast<> expression.
  CXCursor_CXXConstCastExpr(127),

  /// Represents an explicit C++ type conversion that uses "functional"
  /// notion (C++ [expr.type.conv]).
  ///
  /// Example:
  /// \code
  /// x = int(0.5);
  /// \endcode
  CXCursor_CXXFunctionalCastExpr(128),

  /// A C++ typeid expression (C++ [expr.typeid]).
  CXCursor_CXXTypeidExpr(129),

  /// [C++ 2.13.5] C++ Boolean Literal.
  CXCursor_CXXBoolLiteralExpr(130),

  /// [C++0x 2.14.7] C++ Pointer Literal.
  CXCursor_CXXNullPtrLiteralExpr(131),

  /// Represents the "this" expression in C++
  CXCursor_CXXThisExpr(132),

  /// [C++ 15] C++ Throw Expression.
  ///
  /// This handles 'throw' and 'throw' assignment-expression. When
  /// assignment-expression isn't present, Op will be null.
  CXCursor_CXXThrowExpr(133),

  /// A new expression for memory allocation and constructor calls, e.g:
  /// "new CXXNewExpr(foo)".
  CXCursor_CXXNewExpr(134),

  /// A delete expression for memory deallocation and destructor calls,
  /// e.g. "delete[] pArray".
  CXCursor_CXXDeleteExpr(135),

  /// A unary expression. (noexcept, sizeof, or other traits)
  CXCursor_UnaryExpr(136),

  /// An Objective-C string literal i.e. @"foo".
  CXCursor_ObjCStringLiteral(137),

  /// An Objective-C \@encode expression.
  CXCursor_ObjCEncodeExpr(138),

  /// An Objective-C \@selector expression.
  CXCursor_ObjCSelectorExpr(139),

  /// An Objective-C \@protocol expression.
  CXCursor_ObjCProtocolExpr(140),

  /// An Objective-C "bridged" cast expression, which casts between
  /// Objective-C pointers and C pointers, transferring ownership in the process.
  ///
  /// \code
  /// NSString *str = (__bridge_transfer NSString *)CFCreateString();
  /// \endcode
  CXCursor_ObjCBridgedCastExpr(141),

  /// Represents a C++0x pack expansion that produces a sequence of
  /// expressions.
  ///
  /// A pack expansion expression contains a pattern (which itself is an
  /// expression) followed by an ellipsis. For example:
  ///
  /// \code
  /// template<typename F, typename ...Types>
  /// void forward(F f, Types &&...args) {
  /// f(static_cast<Types&&>(args)...);
  /// }
  /// \endcode
  CXCursor_PackExpansionExpr(142),

  /// Represents an expression that computes the length of a parameter
  /// pack.
  ///
  /// \code
  /// template<typename ...Types>
  /// struct count {
  /// static const unsigned value = sizeof...(Types);
  /// };
  /// \endcode
  CXCursor_SizeOfPackExpr(143),
  CXCursor_LambdaExpr(144),

  /// Objective-c Boolean Literal.
  CXCursor_ObjCBoolLiteralExpr(145),

  /// Represents the "self" expression in an Objective-C method.
  CXCursor_ObjCSelfExpr(146),

  /// OpenMP 4.0 [2.4, Array Section].
  CXCursor_OMPArraySectionExpr(147),

  /// Represents an @available(...) check.
  CXCursor_ObjCAvailabilityCheckExpr(148),

  /// Fixed point literal
  CXCursor_FixedPointLiteral(149),
  CXCursor_FirstStmt(200),

  /// A labelled statement in a function.
  ///
  /// This cursor kind is used to describe the "start_over:" label statement in
  /// the following example:
  ///
  /// \code
  /// start_over:
  /// ++counter;
  /// \endcode
  CXCursor_LabelStmt(201),

  /// A group of statements like { stmt stmt }.
  ///
  /// This cursor kind is used to describe compound statements, e.g. function
  /// bodies.
  CXCursor_CompoundStmt(202),

  /// A case statement.
  CXCursor_CaseStmt(203),

  /// A default statement.
  CXCursor_DefaultStmt(204),

  /// An if statement
  CXCursor_IfStmt(205),

  /// A switch statement.
  CXCursor_SwitchStmt(206),

  /// A while statement.
  CXCursor_WhileStmt(207),

  /// A do statement.
  CXCursor_DoStmt(208),

  /// A for statement.
  CXCursor_ForStmt(209),

  /// A goto statement.
  CXCursor_GotoStmt(210),

  /// An indirect goto statement.
  CXCursor_IndirectGotoStmt(211),

  /// A continue statement.
  CXCursor_ContinueStmt(212),

  /// A break statement.
  CXCursor_BreakStmt(213),

  /// A return statement.
  CXCursor_ReturnStmt(214),

  /// A GCC inline assembly statement extension.
  CXCursor_GCCAsmStmt(215),

  /// Objective-C's overall \@try-\@catch-\@finally statement.
  CXCursor_ObjCAtTryStmt(216),

  /// Objective-C's \@catch statement.
  CXCursor_ObjCAtCatchStmt(217),

  /// Objective-C's \@finally statement.
  CXCursor_ObjCAtFinallyStmt(218),

  /// Objective-C's \@throw statement.
  CXCursor_ObjCAtThrowStmt(219),

  /// Objective-C's \@synchronized statement.
  CXCursor_ObjCAtSynchronizedStmt(220),

  /// Objective-C's autorelease pool statement.
  CXCursor_ObjCAutoreleasePoolStmt(221),

  /// Objective-C's collection statement.
  CXCursor_ObjCForCollectionStmt(222),

  /// C++'s catch statement.
  CXCursor_CXXCatchStmt(223),

  /// C++'s try statement.
  CXCursor_CXXTryStmt(224),

  /// C++'s for (* : *) statement.
  CXCursor_CXXForRangeStmt(225),

  /// Windows Structured Exception Handling's try statement.
  CXCursor_SEHTryStmt(226),

  /// Windows Structured Exception Handling's except statement.
  CXCursor_SEHExceptStmt(227),

  /// Windows Structured Exception Handling's finally statement.
  CXCursor_SEHFinallyStmt(228),

  /// A MS inline assembly statement extension.
  CXCursor_MSAsmStmt(229),

  /// The null statement ";": C99 6.8.3p3.
  ///
  /// This cursor kind is used to describe the null statement.
  CXCursor_NullStmt(230),

  /// Adaptor class for mixing declarations with statements and
  /// expressions.
  CXCursor_DeclStmt(231),

  /// OpenMP parallel directive.
  CXCursor_OMPParallelDirective(232),

  /// OpenMP SIMD directive.
  CXCursor_OMPSimdDirective(233),

  /// OpenMP for directive.
  CXCursor_OMPForDirective(234),

  /// OpenMP sections directive.
  CXCursor_OMPSectionsDirective(235),

  /// OpenMP section directive.
  CXCursor_OMPSectionDirective(236),

  /// OpenMP single directive.
  CXCursor_OMPSingleDirective(237),

  /// OpenMP parallel for directive.
  CXCursor_OMPParallelForDirective(238),

  /// OpenMP parallel sections directive.
  CXCursor_OMPParallelSectionsDirective(239),

  /// OpenMP task directive.
  CXCursor_OMPTaskDirective(240),

  /// OpenMP master directive.
  CXCursor_OMPMasterDirective(241),

  /// OpenMP critical directive.
  CXCursor_OMPCriticalDirective(242),

  /// OpenMP taskyield directive.
  CXCursor_OMPTaskyieldDirective(243),

  /// OpenMP barrier directive.
  CXCursor_OMPBarrierDirective(244),

  /// OpenMP taskwait directive.
  CXCursor_OMPTaskwaitDirective(245),

  /// OpenMP flush directive.
  CXCursor_OMPFlushDirective(246),

  /// Windows Structured Exception Handling's leave statement.
  CXCursor_SEHLeaveStmt(247),

  /// OpenMP ordered directive.
  CXCursor_OMPOrderedDirective(248),

  /// OpenMP atomic directive.
  CXCursor_OMPAtomicDirective(249),

  /// OpenMP for SIMD directive.
  CXCursor_OMPForSimdDirective(250),

  /// OpenMP parallel for SIMD directive.
  CXCursor_OMPParallelForSimdDirective(251),

  /// OpenMP target directive.
  CXCursor_OMPTargetDirective(252),

  /// OpenMP teams directive.
  CXCursor_OMPTeamsDirective(253),

  /// OpenMP taskgroup directive.
  CXCursor_OMPTaskgroupDirective(254),

  /// OpenMP cancellation point directive.
  CXCursor_OMPCancellationPointDirective(255),

  /// OpenMP cancel directive.
  CXCursor_OMPCancelDirective(256),

  /// OpenMP target data directive.
  CXCursor_OMPTargetDataDirective(257),

  /// OpenMP taskloop directive.
  CXCursor_OMPTaskLoopDirective(258),

  /// OpenMP taskloop simd directive.
  CXCursor_OMPTaskLoopSimdDirective(259),

  /// OpenMP distribute directive.
  CXCursor_OMPDistributeDirective(260),

  /// OpenMP target enter data directive.
  CXCursor_OMPTargetEnterDataDirective(261),

  /// OpenMP target exit data directive.
  CXCursor_OMPTargetExitDataDirective(262),

  /// OpenMP target parallel directive.
  CXCursor_OMPTargetParallelDirective(263),

  /// OpenMP target parallel for directive.
  CXCursor_OMPTargetParallelForDirective(264),

  /// OpenMP target update directive.
  CXCursor_OMPTargetUpdateDirective(265),

  /// OpenMP distribute parallel for directive.
  CXCursor_OMPDistributeParallelForDirective(266),

  /// OpenMP distribute parallel for simd directive.
  CXCursor_OMPDistributeParallelForSimdDirective(267),

  /// OpenMP distribute simd directive.
  CXCursor_OMPDistributeSimdDirective(268),

  /// OpenMP target parallel for simd directive.
  CXCursor_OMPTargetParallelForSimdDirective(269),

  /// OpenMP target simd directive.
  CXCursor_OMPTargetSimdDirective(270),

  /// OpenMP teams distribute directive.
  CXCursor_OMPTeamsDistributeDirective(271),

  /// OpenMP teams distribute simd directive.
  CXCursor_OMPTeamsDistributeSimdDirective(272),

  /// OpenMP teams distribute parallel for simd directive.
  CXCursor_OMPTeamsDistributeParallelForSimdDirective(273),

  /// OpenMP teams distribute parallel for directive.
  CXCursor_OMPTeamsDistributeParallelForDirective(274),

  /// OpenMP target teams directive.
  CXCursor_OMPTargetTeamsDirective(275),

  /// OpenMP target teams distribute directive.
  CXCursor_OMPTargetTeamsDistributeDirective(276),

  /// OpenMP target teams distribute parallel for directive.
  CXCursor_OMPTargetTeamsDistributeParallelForDirective(277),

  /// OpenMP target teams distribute parallel for simd directive.
  CXCursor_OMPTargetTeamsDistributeParallelForSimdDirective(278),

  /// OpenMP target teams distribute simd directive.
  CXCursor_OMPTargetTeamsDistributeSimdDirective(279),

  /// C++2a std::bit_cast expression.
  CXCursor_BuiltinBitCastExpr(280),

  /// OpenMP master taskloop directive.
  CXCursor_OMPMasterTaskLoopDirective(281),

  /// OpenMP parallel master taskloop directive.
  CXCursor_OMPParallelMasterTaskLoopDirective(282),

  /// OpenMP master taskloop simd directive.
  CXCursor_OMPMasterTaskLoopSimdDirective(283),

  /// OpenMP parallel master taskloop simd directive.
  CXCursor_OMPParallelMasterTaskLoopSimdDirective(284),

  /// OpenMP parallel master directive.
  CXCursor_OMPParallelMasterDirective(285),

  /// Cursor that represents the translation unit itself.
  ///
  /// The translation unit cursor exists primarily to act as the root
  /// cursor for traversing the contents of a translation unit.
  CXCursor_TranslationUnit(300),
  CXCursor_FirstAttr(400),
  CXCursor_IBActionAttr(401),
  CXCursor_IBOutletAttr(402),
  CXCursor_IBOutletCollectionAttr(403),
  CXCursor_CXXFinalAttr(404),
  CXCursor_CXXOverrideAttr(405),
  CXCursor_AnnotateAttr(406),
  CXCursor_AsmLabelAttr(407),
  CXCursor_PackedAttr(408),
  CXCursor_PureAttr(409),
  CXCursor_ConstAttr(410),
  CXCursor_NoDuplicateAttr(411),
  CXCursor_CUDAConstantAttr(412),
  CXCursor_CUDADeviceAttr(413),
  CXCursor_CUDAGlobalAttr(414),
  CXCursor_CUDAHostAttr(415),
  CXCursor_CUDASharedAttr(416),
  CXCursor_VisibilityAttr(417),
  CXCursor_DLLExport(418),
  CXCursor_DLLImport(419),
  CXCursor_NSReturnsRetained(420),
  CXCursor_NSReturnsNotRetained(421),
  CXCursor_NSReturnsAutoreleased(422),
  CXCursor_NSConsumesSelf(423),
  CXCursor_NSConsumed(424),
  CXCursor_ObjCException(425),
  CXCursor_ObjCNSObject(426),
  CXCursor_ObjCIndependentClass(427),
  CXCursor_ObjCPreciseLifetime(428),
  CXCursor_ObjCReturnsInnerPointer(429),
  CXCursor_ObjCRequiresSuper(430),
  CXCursor_ObjCRootClass(431),
  CXCursor_ObjCSubclassingRestricted(432),
  CXCursor_ObjCExplicitProtocolImpl(433),
  CXCursor_ObjCDesignatedInitializer(434),
  CXCursor_ObjCRuntimeVisible(435),
  CXCursor_ObjCBoxable(436),
  CXCursor_FlagEnum(437),
  CXCursor_ConvergentAttr(438),
  CXCursor_WarnUnusedAttr(439),
  CXCursor_WarnUnusedResultAttr(440),
  CXCursor_AlignedAttr(441),
  CXCursor_PreprocessingDirective(500),
  CXCursor_MacroDefinition(501),
  CXCursor_MacroExpansion(502),
  CXCursor_InclusionDirective(503),

  /// A module import declaration.
  CXCursor_ModuleImportDecl(600),
  CXCursor_TypeAliasTemplateDecl(601),

  /// A static_assert or _Static_assert node
  CXCursor_StaticAssert(602),

  /// a friend declaration.
  CXCursor_FriendDecl(603),

  /// A code completion overload candidate.
  CXCursor_OverloadCandidate(700);

  static const CXCursor_FirstDecl = CXCursor_UnexposedDecl;
  static const CXCursor_LastDecl = CXCursor_CXXAccessSpecifier;
  static const CXCursor_ObjCSuperClassRef = CXCursor_FirstRef;
  static const CXCursor_LastRef = CXCursor_VariableRef;
  static const CXCursor_InvalidFile = CXCursor_FirstInvalid;
  static const CXCursor_LastInvalid = CXCursor_InvalidCode;

  /// An expression whose specific kind is not exposed via this
  /// interface.
  ///
  /// Unexposed expressions have the same operations as any other kind
  /// of expression; one can extract their location information,
  /// spelling, children, etc. However, the specific kind of the
  /// expression is not reported.
  static const CXCursor_UnexposedExpr = CXCursor_FirstExpr;
  static const CXCursor_LastExpr = CXCursor_FixedPointLiteral;

  /// A statement whose specific kind is not exposed via this
  /// interface.
  ///
  /// Unexposed statements have the same operations as any other kind of
  /// statement; one can extract their location information, spelling,
  /// children, etc. However, the specific kind of the statement is not
  /// reported.
  static const CXCursor_UnexposedStmt = CXCursor_FirstStmt;
  static const CXCursor_AsmStmt = CXCursor_GCCAsmStmt;
  static const CXCursor_LastStmt = CXCursor_OMPParallelMasterDirective;

  /// An attribute whose specific kind is not exposed via this
  /// interface.
  static const CXCursor_UnexposedAttr = CXCursor_FirstAttr;
  static const CXCursor_LastAttr = CXCursor_AlignedAttr;
  static const CXCursor_MacroInstantiation = CXCursor_MacroExpansion;
  static const CXCursor_FirstPreprocessing = CXCursor_PreprocessingDirective;
  static const CXCursor_LastPreprocessing = CXCursor_InclusionDirective;
  static const CXCursor_FirstExtraDecl = CXCursor_ModuleImportDecl;
  static const CXCursor_LastExtraDecl = CXCursor_FriendDecl;

  final int value;
  const CXCursorKind(this.value);

  static CXCursorKind fromValue(int value) => switch (value) {
    1 => CXCursor_UnexposedDecl,
    2 => CXCursor_StructDecl,
    3 => CXCursor_UnionDecl,
    4 => CXCursor_ClassDecl,
    5 => CXCursor_EnumDecl,
    6 => CXCursor_FieldDecl,
    7 => CXCursor_EnumConstantDecl,
    8 => CXCursor_FunctionDecl,
    9 => CXCursor_VarDecl,
    10 => CXCursor_ParmDecl,
    11 => CXCursor_ObjCInterfaceDecl,
    12 => CXCursor_ObjCCategoryDecl,
    13 => CXCursor_ObjCProtocolDecl,
    14 => CXCursor_ObjCPropertyDecl,
    15 => CXCursor_ObjCIvarDecl,
    16 => CXCursor_ObjCInstanceMethodDecl,
    17 => CXCursor_ObjCClassMethodDecl,
    18 => CXCursor_ObjCImplementationDecl,
    19 => CXCursor_ObjCCategoryImplDecl,
    20 => CXCursor_TypedefDecl,
    21 => CXCursor_CXXMethod,
    22 => CXCursor_Namespace,
    23 => CXCursor_LinkageSpec,
    24 => CXCursor_Constructor,
    25 => CXCursor_Destructor,
    26 => CXCursor_ConversionFunction,
    27 => CXCursor_TemplateTypeParameter,
    28 => CXCursor_NonTypeTemplateParameter,
    29 => CXCursor_TemplateTemplateParameter,
    30 => CXCursor_FunctionTemplate,
    31 => CXCursor_ClassTemplate,
    32 => CXCursor_ClassTemplatePartialSpecialization,
    33 => CXCursor_NamespaceAlias,
    34 => CXCursor_UsingDirective,
    35 => CXCursor_UsingDeclaration,
    36 => CXCursor_TypeAliasDecl,
    37 => CXCursor_ObjCSynthesizeDecl,
    38 => CXCursor_ObjCDynamicDecl,
    39 => CXCursor_CXXAccessSpecifier,
    40 => CXCursor_FirstRef,
    41 => CXCursor_ObjCProtocolRef,
    42 => CXCursor_ObjCClassRef,
    43 => CXCursor_TypeRef,
    44 => CXCursor_CXXBaseSpecifier,
    45 => CXCursor_TemplateRef,
    46 => CXCursor_NamespaceRef,
    47 => CXCursor_MemberRef,
    48 => CXCursor_LabelRef,
    49 => CXCursor_OverloadedDeclRef,
    50 => CXCursor_VariableRef,
    70 => CXCursor_FirstInvalid,
    71 => CXCursor_NoDeclFound,
    72 => CXCursor_NotImplemented,
    73 => CXCursor_InvalidCode,
    100 => CXCursor_FirstExpr,
    101 => CXCursor_DeclRefExpr,
    102 => CXCursor_MemberRefExpr,
    103 => CXCursor_CallExpr,
    104 => CXCursor_ObjCMessageExpr,
    105 => CXCursor_BlockExpr,
    106 => CXCursor_IntegerLiteral,
    107 => CXCursor_FloatingLiteral,
    108 => CXCursor_ImaginaryLiteral,
    109 => CXCursor_StringLiteral,
    110 => CXCursor_CharacterLiteral,
    111 => CXCursor_ParenExpr,
    112 => CXCursor_UnaryOperator,
    113 => CXCursor_ArraySubscriptExpr,
    114 => CXCursor_BinaryOperator,
    115 => CXCursor_CompoundAssignOperator,
    116 => CXCursor_ConditionalOperator,
    117 => CXCursor_CStyleCastExpr,
    118 => CXCursor_CompoundLiteralExpr,
    119 => CXCursor_InitListExpr,
    120 => CXCursor_AddrLabelExpr,
    121 => CXCursor_StmtExpr,
    122 => CXCursor_GenericSelectionExpr,
    123 => CXCursor_GNUNullExpr,
    124 => CXCursor_CXXStaticCastExpr,
    125 => CXCursor_CXXDynamicCastExpr,
    126 => CXCursor_CXXReinterpretCastExpr,
    127 => CXCursor_CXXConstCastExpr,
    128 => CXCursor_CXXFunctionalCastExpr,
    129 => CXCursor_CXXTypeidExpr,
    130 => CXCursor_CXXBoolLiteralExpr,
    131 => CXCursor_CXXNullPtrLiteralExpr,
    132 => CXCursor_CXXThisExpr,
    133 => CXCursor_CXXThrowExpr,
    134 => CXCursor_CXXNewExpr,
    135 => CXCursor_CXXDeleteExpr,
    136 => CXCursor_UnaryExpr,
    137 => CXCursor_ObjCStringLiteral,
    138 => CXCursor_ObjCEncodeExpr,
    139 => CXCursor_ObjCSelectorExpr,
    140 => CXCursor_ObjCProtocolExpr,
    141 => CXCursor_ObjCBridgedCastExpr,
    142 => CXCursor_PackExpansionExpr,
    143 => CXCursor_SizeOfPackExpr,
    144 => CXCursor_LambdaExpr,
    145 => CXCursor_ObjCBoolLiteralExpr,
    146 => CXCursor_ObjCSelfExpr,
    147 => CXCursor_OMPArraySectionExpr,
    148 => CXCursor_ObjCAvailabilityCheckExpr,
    149 => CXCursor_FixedPointLiteral,
    200 => CXCursor_FirstStmt,
    201 => CXCursor_LabelStmt,
    202 => CXCursor_CompoundStmt,
    203 => CXCursor_CaseStmt,
    204 => CXCursor_DefaultStmt,
    205 => CXCursor_IfStmt,
    206 => CXCursor_SwitchStmt,
    207 => CXCursor_WhileStmt,
    208 => CXCursor_DoStmt,
    209 => CXCursor_ForStmt,
    210 => CXCursor_GotoStmt,
    211 => CXCursor_IndirectGotoStmt,
    212 => CXCursor_ContinueStmt,
    213 => CXCursor_BreakStmt,
    214 => CXCursor_ReturnStmt,
    215 => CXCursor_GCCAsmStmt,
    216 => CXCursor_ObjCAtTryStmt,
    217 => CXCursor_ObjCAtCatchStmt,
    218 => CXCursor_ObjCAtFinallyStmt,
    219 => CXCursor_ObjCAtThrowStmt,
    220 => CXCursor_ObjCAtSynchronizedStmt,
    221 => CXCursor_ObjCAutoreleasePoolStmt,
    222 => CXCursor_ObjCForCollectionStmt,
    223 => CXCursor_CXXCatchStmt,
    224 => CXCursor_CXXTryStmt,
    225 => CXCursor_CXXForRangeStmt,
    226 => CXCursor_SEHTryStmt,
    227 => CXCursor_SEHExceptStmt,
    228 => CXCursor_SEHFinallyStmt,
    229 => CXCursor_MSAsmStmt,
    230 => CXCursor_NullStmt,
    231 => CXCursor_DeclStmt,
    232 => CXCursor_OMPParallelDirective,
    233 => CXCursor_OMPSimdDirective,
    234 => CXCursor_OMPForDirective,
    235 => CXCursor_OMPSectionsDirective,
    236 => CXCursor_OMPSectionDirective,
    237 => CXCursor_OMPSingleDirective,
    238 => CXCursor_OMPParallelForDirective,
    239 => CXCursor_OMPParallelSectionsDirective,
    240 => CXCursor_OMPTaskDirective,
    241 => CXCursor_OMPMasterDirective,
    242 => CXCursor_OMPCriticalDirective,
    243 => CXCursor_OMPTaskyieldDirective,
    244 => CXCursor_OMPBarrierDirective,
    245 => CXCursor_OMPTaskwaitDirective,
    246 => CXCursor_OMPFlushDirective,
    247 => CXCursor_SEHLeaveStmt,
    248 => CXCursor_OMPOrderedDirective,
    249 => CXCursor_OMPAtomicDirective,
    250 => CXCursor_OMPForSimdDirective,
    251 => CXCursor_OMPParallelForSimdDirective,
    252 => CXCursor_OMPTargetDirective,
    253 => CXCursor_OMPTeamsDirective,
    254 => CXCursor_OMPTaskgroupDirective,
    255 => CXCursor_OMPCancellationPointDirective,
    256 => CXCursor_OMPCancelDirective,
    257 => CXCursor_OMPTargetDataDirective,
    258 => CXCursor_OMPTaskLoopDirective,
    259 => CXCursor_OMPTaskLoopSimdDirective,
    260 => CXCursor_OMPDistributeDirective,
    261 => CXCursor_OMPTargetEnterDataDirective,
    262 => CXCursor_OMPTargetExitDataDirective,
    263 => CXCursor_OMPTargetParallelDirective,
    264 => CXCursor_OMPTargetParallelForDirective,
    265 => CXCursor_OMPTargetUpdateDirective,
    266 => CXCursor_OMPDistributeParallelForDirective,
    267 => CXCursor_OMPDistributeParallelForSimdDirective,
    268 => CXCursor_OMPDistributeSimdDirective,
    269 => CXCursor_OMPTargetParallelForSimdDirective,
    270 => CXCursor_OMPTargetSimdDirective,
    271 => CXCursor_OMPTeamsDistributeDirective,
    272 => CXCursor_OMPTeamsDistributeSimdDirective,
    273 => CXCursor_OMPTeamsDistributeParallelForSimdDirective,
    274 => CXCursor_OMPTeamsDistributeParallelForDirective,
    275 => CXCursor_OMPTargetTeamsDirective,
    276 => CXCursor_OMPTargetTeamsDistributeDirective,
    277 => CXCursor_OMPTargetTeamsDistributeParallelForDirective,
    278 => CXCursor_OMPTargetTeamsDistributeParallelForSimdDirective,
    279 => CXCursor_OMPTargetTeamsDistributeSimdDirective,
    280 => CXCursor_BuiltinBitCastExpr,
    281 => CXCursor_OMPMasterTaskLoopDirective,
    282 => CXCursor_OMPParallelMasterTaskLoopDirective,
    283 => CXCursor_OMPMasterTaskLoopSimdDirective,
    284 => CXCursor_OMPParallelMasterTaskLoopSimdDirective,
    285 => CXCursor_OMPParallelMasterDirective,
    300 => CXCursor_TranslationUnit,
    400 => CXCursor_FirstAttr,
    401 => CXCursor_IBActionAttr,
    402 => CXCursor_IBOutletAttr,
    403 => CXCursor_IBOutletCollectionAttr,
    404 => CXCursor_CXXFinalAttr,
    405 => CXCursor_CXXOverrideAttr,
    406 => CXCursor_AnnotateAttr,
    407 => CXCursor_AsmLabelAttr,
    408 => CXCursor_PackedAttr,
    409 => CXCursor_PureAttr,
    410 => CXCursor_ConstAttr,
    411 => CXCursor_NoDuplicateAttr,
    412 => CXCursor_CUDAConstantAttr,
    413 => CXCursor_CUDADeviceAttr,
    414 => CXCursor_CUDAGlobalAttr,
    415 => CXCursor_CUDAHostAttr,
    416 => CXCursor_CUDASharedAttr,
    417 => CXCursor_VisibilityAttr,
    418 => CXCursor_DLLExport,
    419 => CXCursor_DLLImport,
    420 => CXCursor_NSReturnsRetained,
    421 => CXCursor_NSReturnsNotRetained,
    422 => CXCursor_NSReturnsAutoreleased,
    423 => CXCursor_NSConsumesSelf,
    424 => CXCursor_NSConsumed,
    425 => CXCursor_ObjCException,
    426 => CXCursor_ObjCNSObject,
    427 => CXCursor_ObjCIndependentClass,
    428 => CXCursor_ObjCPreciseLifetime,
    429 => CXCursor_ObjCReturnsInnerPointer,
    430 => CXCursor_ObjCRequiresSuper,
    431 => CXCursor_ObjCRootClass,
    432 => CXCursor_ObjCSubclassingRestricted,
    433 => CXCursor_ObjCExplicitProtocolImpl,
    434 => CXCursor_ObjCDesignatedInitializer,
    435 => CXCursor_ObjCRuntimeVisible,
    436 => CXCursor_ObjCBoxable,
    437 => CXCursor_FlagEnum,
    438 => CXCursor_ConvergentAttr,
    439 => CXCursor_WarnUnusedAttr,
    440 => CXCursor_WarnUnusedResultAttr,
    441 => CXCursor_AlignedAttr,
    500 => CXCursor_PreprocessingDirective,
    501 => CXCursor_MacroDefinition,
    502 => CXCursor_MacroExpansion,
    503 => CXCursor_InclusionDirective,
    600 => CXCursor_ModuleImportDecl,
    601 => CXCursor_TypeAliasTemplateDecl,
    602 => CXCursor_StaticAssert,
    603 => CXCursor_FriendDecl,
    700 => CXCursor_OverloadCandidate,
    _ => throw ArgumentError('Unknown value for CXCursorKind: $value'),
  };

  @override
  String toString() {
    if (this == CXCursor_UnexposedDecl)
      return "CXCursorKind.CXCursor_UnexposedDecl, CXCursorKind.CXCursor_FirstDecl";
    if (this == CXCursor_CXXAccessSpecifier)
      return "CXCursorKind.CXCursor_CXXAccessSpecifier, CXCursorKind.CXCursor_LastDecl";
    if (this == CXCursor_FirstRef)
      return "CXCursorKind.CXCursor_FirstRef, CXCursorKind.CXCursor_ObjCSuperClassRef";
    if (this == CXCursor_VariableRef)
      return "CXCursorKind.CXCursor_VariableRef, CXCursorKind.CXCursor_LastRef";
    if (this == CXCursor_FirstInvalid)
      return "CXCursorKind.CXCursor_FirstInvalid, CXCursorKind.CXCursor_InvalidFile";
    if (this == CXCursor_InvalidCode)
      return "CXCursorKind.CXCursor_InvalidCode, CXCursorKind.CXCursor_LastInvalid";
    if (this == CXCursor_FirstExpr)
      return "CXCursorKind.CXCursor_FirstExpr, CXCursorKind.CXCursor_UnexposedExpr";
    if (this == CXCursor_FixedPointLiteral)
      return "CXCursorKind.CXCursor_FixedPointLiteral, CXCursorKind.CXCursor_LastExpr";
    if (this == CXCursor_FirstStmt)
      return "CXCursorKind.CXCursor_FirstStmt, CXCursorKind.CXCursor_UnexposedStmt";
    if (this == CXCursor_GCCAsmStmt)
      return "CXCursorKind.CXCursor_GCCAsmStmt, CXCursorKind.CXCursor_AsmStmt";
    if (this == CXCursor_OMPParallelMasterDirective)
      return "CXCursorKind.CXCursor_OMPParallelMasterDirective, CXCursorKind.CXCursor_LastStmt";
    if (this == CXCursor_FirstAttr)
      return "CXCursorKind.CXCursor_FirstAttr, CXCursorKind.CXCursor_UnexposedAttr";
    if (this == CXCursor_AlignedAttr)
      return "CXCursorKind.CXCursor_AlignedAttr, CXCursorKind.CXCursor_LastAttr";
    if (this == CXCursor_PreprocessingDirective)
      return "CXCursorKind.CXCursor_PreprocessingDirective, CXCursorKind.CXCursor_FirstPreprocessing";
    if (this == CXCursor_MacroExpansion)
      return "CXCursorKind.CXCursor_MacroExpansion, CXCursorKind.CXCursor_MacroInstantiation";
    if (this == CXCursor_InclusionDirective)
      return "CXCursorKind.CXCursor_InclusionDirective, CXCursorKind.CXCursor_LastPreprocessing";
    if (this == CXCursor_ModuleImportDecl)
      return "CXCursorKind.CXCursor_ModuleImportDecl, CXCursorKind.CXCursor_FirstExtraDecl";
    if (this == CXCursor_FriendDecl)
      return "CXCursorKind.CXCursor_FriendDecl, CXCursorKind.CXCursor_LastExtraDecl";
    return super.toString();
  }
}

/// A cursor representing some element in the abstract syntax tree for
/// a translation unit.
///
/// The cursor abstraction unifies the different kinds of entities in a
/// program--declaration, statements, expressions, references to declarations,
/// etc.--under a single "cursor" abstraction with a common set of operations.
/// Common operation for a cursor include: getting the physical location in
/// a source file where the cursor points, getting the name associated with a
/// cursor, and retrieving cursors for any child nodes of a particular cursor.
///
/// Cursors can be produced in two specific ways.
/// clang_getTranslationUnitCursor() produces a cursor for a translation unit,
/// from which one can use clang_visitChildren() to explore the rest of the
/// translation unit. clang_getCursor() maps from a physical source location
/// to the entity that resides at that location, allowing one to map from the
/// source code into the AST.
final class CXCursor extends ffi.Struct {
  @ffi.UnsignedInt()
  external int kindAsInt;

  CXCursorKind get kind => CXCursorKind.fromValue(kindAsInt);

  @ffi.Int()
  external int xdata;

  @ffi.Array.multi([3])
  external ffi.Array<ffi.Pointer<ffi.Void>> data;
}

typedef NativeClang_getNullCursor = CXCursor Function();
typedef DartClang_getNullCursor = CXCursor Function();
typedef NativeClang_getTranslationUnitCursor =
    CXCursor Function(CXTranslationUnit);
typedef DartClang_getTranslationUnitCursor =
    CXCursor Function(CXTranslationUnit);
typedef NativeClang_equalCursors = ffi.UnsignedInt Function(CXCursor, CXCursor);
typedef DartClang_equalCursors = int Function(CXCursor, CXCursor);
typedef NativeClang_Cursor_isNull = ffi.Int Function(CXCursor cursor);
typedef DartClang_Cursor_isNull = int Function(CXCursor cursor);
typedef NativeClang_hashCursor = ffi.UnsignedInt Function(CXCursor);
typedef DartClang_hashCursor = int Function(CXCursor);
typedef NativeClang_getCursorKind = ffi.UnsignedInt Function(CXCursor);
typedef DartClang_getCursorKind = int Function(CXCursor);
typedef NativeClang_isDeclaration = ffi.UnsignedInt Function(ffi.UnsignedInt);
typedef DartClang_isDeclaration = int Function(int);
typedef NativeClang_isInvalidDeclaration = ffi.UnsignedInt Function(CXCursor);
typedef DartClang_isInvalidDeclaration = int Function(CXCursor);
typedef NativeClang_isReference = ffi.UnsignedInt Function(ffi.UnsignedInt);
typedef DartClang_isReference = int Function(int);
typedef NativeClang_isExpression = ffi.UnsignedInt Function(ffi.UnsignedInt);
typedef DartClang_isExpression = int Function(int);
typedef NativeClang_isStatement = ffi.UnsignedInt Function(ffi.UnsignedInt);
typedef DartClang_isStatement = int Function(int);
typedef NativeClang_isAttribute = ffi.UnsignedInt Function(ffi.UnsignedInt);
typedef DartClang_isAttribute = int Function(int);
typedef NativeClang_Cursor_hasAttrs = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_hasAttrs = int Function(CXCursor C);
typedef NativeClang_isInvalid = ffi.UnsignedInt Function(ffi.UnsignedInt);
typedef DartClang_isInvalid = int Function(int);
typedef NativeClang_isTranslationUnit =
    ffi.UnsignedInt Function(ffi.UnsignedInt);
typedef DartClang_isTranslationUnit = int Function(int);
typedef NativeClang_isPreprocessing = ffi.UnsignedInt Function(ffi.UnsignedInt);
typedef DartClang_isPreprocessing = int Function(int);
typedef NativeClang_isUnexposed = ffi.UnsignedInt Function(ffi.UnsignedInt);
typedef DartClang_isUnexposed = int Function(int);

/// Describe the linkage of the entity referred to by a cursor.
enum CXLinkageKind {
  /// This value indicates that no linkage information is available
  /// for a provided CXCursor.
  CXLinkage_Invalid(0),

  /// This is the linkage for variables, parameters, and so on that
  /// have automatic storage.  This covers normal (non-extern) local variables.
  CXLinkage_NoLinkage(1),

  /// This is the linkage for static variables and static functions.
  CXLinkage_Internal(2),

  /// This is the linkage for entities with external linkage that live
  /// in C++ anonymous namespaces.
  CXLinkage_UniqueExternal(3),

  /// This is the linkage for entities with true, external linkage.
  CXLinkage_External(4);

  final int value;
  const CXLinkageKind(this.value);

  static CXLinkageKind fromValue(int value) => switch (value) {
    0 => CXLinkage_Invalid,
    1 => CXLinkage_NoLinkage,
    2 => CXLinkage_Internal,
    3 => CXLinkage_UniqueExternal,
    4 => CXLinkage_External,
    _ => throw ArgumentError('Unknown value for CXLinkageKind: $value'),
  };
}

typedef NativeClang_getCursorLinkage =
    ffi.UnsignedInt Function(CXCursor cursor);
typedef DartClang_getCursorLinkage = int Function(CXCursor cursor);

enum CXVisibilityKind {
  /// This value indicates that no visibility information is available
  /// for a provided CXCursor.
  CXVisibility_Invalid(0),

  /// Symbol not seen by the linker.
  CXVisibility_Hidden(1),

  /// Symbol seen by the linker but resolves to a symbol inside this object.
  CXVisibility_Protected(2),

  /// Symbol seen by the linker and acts like a normal symbol.
  CXVisibility_Default(3);

  final int value;
  const CXVisibilityKind(this.value);

  static CXVisibilityKind fromValue(int value) => switch (value) {
    0 => CXVisibility_Invalid,
    1 => CXVisibility_Hidden,
    2 => CXVisibility_Protected,
    3 => CXVisibility_Default,
    _ => throw ArgumentError('Unknown value for CXVisibilityKind: $value'),
  };
}

typedef NativeClang_getCursorVisibility =
    ffi.UnsignedInt Function(CXCursor cursor);
typedef DartClang_getCursorVisibility = int Function(CXCursor cursor);
typedef NativeClang_getCursorAvailability =
    ffi.UnsignedInt Function(CXCursor cursor);
typedef DartClang_getCursorAvailability = int Function(CXCursor cursor);

/// Describes the availability of a given entity on a particular platform, e.g.,
/// a particular class might only be available on Mac OS 10.7 or newer.
final class CXPlatformAvailability extends ffi.Struct {
  /// A string that describes the platform for which this structure
  /// provides availability information.
  ///
  /// Possible values are "ios" or "macos".
  external CXString Platform;

  /// The version number in which this entity was introduced.
  external CXVersion Introduced;

  /// The version number in which this entity was deprecated (but is
  /// still available).
  external CXVersion Deprecated;

  /// The version number in which this entity was obsoleted, and therefore
  /// is no longer available.
  external CXVersion Obsoleted;

  /// Whether the entity is unconditionally unavailable on this platform.
  @ffi.Int()
  external int Unavailable;

  /// An optional message to provide to a user of this API, e.g., to
  /// suggest replacement APIs.
  external CXString Message;
}

typedef NativeClang_getCursorPlatformAvailability =
    ffi.Int Function(
      CXCursor cursor,
      ffi.Pointer<ffi.Int> always_deprecated,
      ffi.Pointer<CXString> deprecated_message,
      ffi.Pointer<ffi.Int> always_unavailable,
      ffi.Pointer<CXString> unavailable_message,
      ffi.Pointer<CXPlatformAvailability> availability,
      ffi.Int availability_size,
    );
typedef DartClang_getCursorPlatformAvailability =
    int Function(
      CXCursor cursor,
      ffi.Pointer<ffi.Int> always_deprecated,
      ffi.Pointer<CXString> deprecated_message,
      ffi.Pointer<ffi.Int> always_unavailable,
      ffi.Pointer<CXString> unavailable_message,
      ffi.Pointer<CXPlatformAvailability> availability,
      int availability_size,
    );
typedef NativeClang_disposeCXPlatformAvailability =
    ffi.Void Function(ffi.Pointer<CXPlatformAvailability> availability);
typedef DartClang_disposeCXPlatformAvailability =
    void Function(ffi.Pointer<CXPlatformAvailability> availability);

/// Describe the "language" of the entity referred to by a cursor.
enum CXLanguageKind {
  CXLanguage_Invalid(0),
  CXLanguage_C(1),
  CXLanguage_ObjC(2),
  CXLanguage_CPlusPlus(3);

  final int value;
  const CXLanguageKind(this.value);

  static CXLanguageKind fromValue(int value) => switch (value) {
    0 => CXLanguage_Invalid,
    1 => CXLanguage_C,
    2 => CXLanguage_ObjC,
    3 => CXLanguage_CPlusPlus,
    _ => throw ArgumentError('Unknown value for CXLanguageKind: $value'),
  };
}

typedef NativeClang_getCursorLanguage =
    ffi.UnsignedInt Function(CXCursor cursor);
typedef DartClang_getCursorLanguage = int Function(CXCursor cursor);

/// Describe the "thread-local storage (TLS) kind" of the declaration
/// referred to by a cursor.
enum CXTLSKind {
  CXTLS_None(0),
  CXTLS_Dynamic(1),
  CXTLS_Static(2);

  final int value;
  const CXTLSKind(this.value);

  static CXTLSKind fromValue(int value) => switch (value) {
    0 => CXTLS_None,
    1 => CXTLS_Dynamic,
    2 => CXTLS_Static,
    _ => throw ArgumentError('Unknown value for CXTLSKind: $value'),
  };
}

typedef NativeClang_getCursorTLSKind =
    ffi.UnsignedInt Function(CXCursor cursor);
typedef DartClang_getCursorTLSKind = int Function(CXCursor cursor);
typedef NativeClang_Cursor_getTranslationUnit =
    CXTranslationUnit Function(CXCursor);
typedef DartClang_Cursor_getTranslationUnit =
    CXTranslationUnit Function(CXCursor);

/// A fast container representing a set of CXCursors.
typedef CXCursorSet = ffi.Pointer<custom_import.CXCursorSetImpl>;
typedef NativeClang_createCXCursorSet = CXCursorSet Function();
typedef DartClang_createCXCursorSet = CXCursorSet Function();
typedef NativeClang_disposeCXCursorSet = ffi.Void Function(CXCursorSet cset);
typedef DartClang_disposeCXCursorSet = void Function(CXCursorSet cset);
typedef NativeClang_CXCursorSet_contains =
    ffi.UnsignedInt Function(CXCursorSet cset, CXCursor cursor);
typedef DartClang_CXCursorSet_contains =
    int Function(CXCursorSet cset, CXCursor cursor);
typedef NativeClang_CXCursorSet_insert =
    ffi.UnsignedInt Function(CXCursorSet cset, CXCursor cursor);
typedef DartClang_CXCursorSet_insert =
    int Function(CXCursorSet cset, CXCursor cursor);
typedef NativeClang_getCursorSemanticParent =
    CXCursor Function(CXCursor cursor);
typedef DartClang_getCursorSemanticParent = CXCursor Function(CXCursor cursor);
typedef NativeClang_getCursorLexicalParent = CXCursor Function(CXCursor cursor);
typedef DartClang_getCursorLexicalParent = CXCursor Function(CXCursor cursor);
typedef NativeClang_getOverriddenCursors =
    ffi.Void Function(
      CXCursor cursor,
      ffi.Pointer<ffi.Pointer<CXCursor>> overridden,
      ffi.Pointer<ffi.UnsignedInt> num_overridden,
    );
typedef DartClang_getOverriddenCursors =
    void Function(
      CXCursor cursor,
      ffi.Pointer<ffi.Pointer<CXCursor>> overridden,
      ffi.Pointer<ffi.UnsignedInt> num_overridden,
    );
typedef NativeClang_disposeOverriddenCursors =
    ffi.Void Function(ffi.Pointer<CXCursor> overridden);
typedef DartClang_disposeOverriddenCursors =
    void Function(ffi.Pointer<CXCursor> overridden);
typedef NativeClang_getIncludedFile = CXFile Function(CXCursor cursor);
typedef DartClang_getIncludedFile = CXFile Function(CXCursor cursor);
typedef NativeClang_getCursor =
    CXCursor Function(CXTranslationUnit, CXSourceLocation);
typedef DartClang_getCursor =
    CXCursor Function(CXTranslationUnit, CXSourceLocation);
typedef NativeClang_getCursorLocation = CXSourceLocation Function(CXCursor);
typedef DartClang_getCursorLocation = CXSourceLocation Function(CXCursor);
typedef NativeClang_getCursorExtent = CXSourceRange Function(CXCursor);
typedef DartClang_getCursorExtent = CXSourceRange Function(CXCursor);

/// Describes the kind of type
enum CXTypeKind {
  /// Represents an invalid type (e.g., where no type is available).
  CXType_Invalid(0),

  /// A type whose specific kind is not exposed via this
  /// interface.
  CXType_Unexposed(1),
  CXType_Void(2),
  CXType_Bool(3),
  CXType_Char_U(4),
  CXType_UChar(5),
  CXType_Char16(6),
  CXType_Char32(7),
  CXType_UShort(8),
  CXType_UInt(9),
  CXType_ULong(10),
  CXType_ULongLong(11),
  CXType_UInt128(12),
  CXType_Char_S(13),
  CXType_SChar(14),
  CXType_WChar(15),
  CXType_Short(16),
  CXType_Int(17),
  CXType_Long(18),
  CXType_LongLong(19),
  CXType_Int128(20),
  CXType_Float(21),
  CXType_Double(22),
  CXType_LongDouble(23),
  CXType_NullPtr(24),
  CXType_Overload(25),
  CXType_Dependent(26),
  CXType_ObjCId(27),
  CXType_ObjCClass(28),
  CXType_ObjCSel(29),
  CXType_Float128(30),
  CXType_Half(31),
  CXType_Float16(32),
  CXType_ShortAccum(33),
  CXType_Accum(34),
  CXType_LongAccum(35),
  CXType_UShortAccum(36),
  CXType_UAccum(37),
  CXType_ULongAccum(38),
  CXType_Complex(100),
  CXType_Pointer(101),
  CXType_BlockPointer(102),
  CXType_LValueReference(103),
  CXType_RValueReference(104),
  CXType_Record(105),
  CXType_Enum(106),
  CXType_Typedef(107),
  CXType_ObjCInterface(108),
  CXType_ObjCObjectPointer(109),
  CXType_FunctionNoProto(110),
  CXType_FunctionProto(111),
  CXType_ConstantArray(112),
  CXType_Vector(113),
  CXType_IncompleteArray(114),
  CXType_VariableArray(115),
  CXType_DependentSizedArray(116),
  CXType_MemberPointer(117),
  CXType_Auto(118),

  /// Represents a type that was referred to using an elaborated type keyword.
  ///
  /// E.g., struct S, or via a qualified name, e.g., N::M::type, or both.
  CXType_Elaborated(119),
  CXType_Pipe(120),
  CXType_OCLImage1dRO(121),
  CXType_OCLImage1dArrayRO(122),
  CXType_OCLImage1dBufferRO(123),
  CXType_OCLImage2dRO(124),
  CXType_OCLImage2dArrayRO(125),
  CXType_OCLImage2dDepthRO(126),
  CXType_OCLImage2dArrayDepthRO(127),
  CXType_OCLImage2dMSAARO(128),
  CXType_OCLImage2dArrayMSAARO(129),
  CXType_OCLImage2dMSAADepthRO(130),
  CXType_OCLImage2dArrayMSAADepthRO(131),
  CXType_OCLImage3dRO(132),
  CXType_OCLImage1dWO(133),
  CXType_OCLImage1dArrayWO(134),
  CXType_OCLImage1dBufferWO(135),
  CXType_OCLImage2dWO(136),
  CXType_OCLImage2dArrayWO(137),
  CXType_OCLImage2dDepthWO(138),
  CXType_OCLImage2dArrayDepthWO(139),
  CXType_OCLImage2dMSAAWO(140),
  CXType_OCLImage2dArrayMSAAWO(141),
  CXType_OCLImage2dMSAADepthWO(142),
  CXType_OCLImage2dArrayMSAADepthWO(143),
  CXType_OCLImage3dWO(144),
  CXType_OCLImage1dRW(145),
  CXType_OCLImage1dArrayRW(146),
  CXType_OCLImage1dBufferRW(147),
  CXType_OCLImage2dRW(148),
  CXType_OCLImage2dArrayRW(149),
  CXType_OCLImage2dDepthRW(150),
  CXType_OCLImage2dArrayDepthRW(151),
  CXType_OCLImage2dMSAARW(152),
  CXType_OCLImage2dArrayMSAARW(153),
  CXType_OCLImage2dMSAADepthRW(154),
  CXType_OCLImage2dArrayMSAADepthRW(155),
  CXType_OCLImage3dRW(156),
  CXType_OCLSampler(157),
  CXType_OCLEvent(158),
  CXType_OCLQueue(159),
  CXType_OCLReserveID(160),
  CXType_ObjCObject(161),
  CXType_ObjCTypeParam(162),
  CXType_Attributed(163),
  CXType_OCLIntelSubgroupAVCMcePayload(164),
  CXType_OCLIntelSubgroupAVCImePayload(165),
  CXType_OCLIntelSubgroupAVCRefPayload(166),
  CXType_OCLIntelSubgroupAVCSicPayload(167),
  CXType_OCLIntelSubgroupAVCMceResult(168),
  CXType_OCLIntelSubgroupAVCImeResult(169),
  CXType_OCLIntelSubgroupAVCRefResult(170),
  CXType_OCLIntelSubgroupAVCSicResult(171),
  CXType_OCLIntelSubgroupAVCImeResultSingleRefStreamout(172),
  CXType_OCLIntelSubgroupAVCImeResultDualRefStreamout(173),
  CXType_OCLIntelSubgroupAVCImeSingleRefStreamin(174),
  CXType_OCLIntelSubgroupAVCImeDualRefStreamin(175),
  CXType_ExtVector(176);

  static const CXType_FirstBuiltin = CXType_Void;
  static const CXType_LastBuiltin = CXType_ULongAccum;

  final int value;
  const CXTypeKind(this.value);

  static CXTypeKind fromValue(int value) => switch (value) {
    0 => CXType_Invalid,
    1 => CXType_Unexposed,
    2 => CXType_Void,
    3 => CXType_Bool,
    4 => CXType_Char_U,
    5 => CXType_UChar,
    6 => CXType_Char16,
    7 => CXType_Char32,
    8 => CXType_UShort,
    9 => CXType_UInt,
    10 => CXType_ULong,
    11 => CXType_ULongLong,
    12 => CXType_UInt128,
    13 => CXType_Char_S,
    14 => CXType_SChar,
    15 => CXType_WChar,
    16 => CXType_Short,
    17 => CXType_Int,
    18 => CXType_Long,
    19 => CXType_LongLong,
    20 => CXType_Int128,
    21 => CXType_Float,
    22 => CXType_Double,
    23 => CXType_LongDouble,
    24 => CXType_NullPtr,
    25 => CXType_Overload,
    26 => CXType_Dependent,
    27 => CXType_ObjCId,
    28 => CXType_ObjCClass,
    29 => CXType_ObjCSel,
    30 => CXType_Float128,
    31 => CXType_Half,
    32 => CXType_Float16,
    33 => CXType_ShortAccum,
    34 => CXType_Accum,
    35 => CXType_LongAccum,
    36 => CXType_UShortAccum,
    37 => CXType_UAccum,
    38 => CXType_ULongAccum,
    100 => CXType_Complex,
    101 => CXType_Pointer,
    102 => CXType_BlockPointer,
    103 => CXType_LValueReference,
    104 => CXType_RValueReference,
    105 => CXType_Record,
    106 => CXType_Enum,
    107 => CXType_Typedef,
    108 => CXType_ObjCInterface,
    109 => CXType_ObjCObjectPointer,
    110 => CXType_FunctionNoProto,
    111 => CXType_FunctionProto,
    112 => CXType_ConstantArray,
    113 => CXType_Vector,
    114 => CXType_IncompleteArray,
    115 => CXType_VariableArray,
    116 => CXType_DependentSizedArray,
    117 => CXType_MemberPointer,
    118 => CXType_Auto,
    119 => CXType_Elaborated,
    120 => CXType_Pipe,
    121 => CXType_OCLImage1dRO,
    122 => CXType_OCLImage1dArrayRO,
    123 => CXType_OCLImage1dBufferRO,
    124 => CXType_OCLImage2dRO,
    125 => CXType_OCLImage2dArrayRO,
    126 => CXType_OCLImage2dDepthRO,
    127 => CXType_OCLImage2dArrayDepthRO,
    128 => CXType_OCLImage2dMSAARO,
    129 => CXType_OCLImage2dArrayMSAARO,
    130 => CXType_OCLImage2dMSAADepthRO,
    131 => CXType_OCLImage2dArrayMSAADepthRO,
    132 => CXType_OCLImage3dRO,
    133 => CXType_OCLImage1dWO,
    134 => CXType_OCLImage1dArrayWO,
    135 => CXType_OCLImage1dBufferWO,
    136 => CXType_OCLImage2dWO,
    137 => CXType_OCLImage2dArrayWO,
    138 => CXType_OCLImage2dDepthWO,
    139 => CXType_OCLImage2dArrayDepthWO,
    140 => CXType_OCLImage2dMSAAWO,
    141 => CXType_OCLImage2dArrayMSAAWO,
    142 => CXType_OCLImage2dMSAADepthWO,
    143 => CXType_OCLImage2dArrayMSAADepthWO,
    144 => CXType_OCLImage3dWO,
    145 => CXType_OCLImage1dRW,
    146 => CXType_OCLImage1dArrayRW,
    147 => CXType_OCLImage1dBufferRW,
    148 => CXType_OCLImage2dRW,
    149 => CXType_OCLImage2dArrayRW,
    150 => CXType_OCLImage2dDepthRW,
    151 => CXType_OCLImage2dArrayDepthRW,
    152 => CXType_OCLImage2dMSAARW,
    153 => CXType_OCLImage2dArrayMSAARW,
    154 => CXType_OCLImage2dMSAADepthRW,
    155 => CXType_OCLImage2dArrayMSAADepthRW,
    156 => CXType_OCLImage3dRW,
    157 => CXType_OCLSampler,
    158 => CXType_OCLEvent,
    159 => CXType_OCLQueue,
    160 => CXType_OCLReserveID,
    161 => CXType_ObjCObject,
    162 => CXType_ObjCTypeParam,
    163 => CXType_Attributed,
    164 => CXType_OCLIntelSubgroupAVCMcePayload,
    165 => CXType_OCLIntelSubgroupAVCImePayload,
    166 => CXType_OCLIntelSubgroupAVCRefPayload,
    167 => CXType_OCLIntelSubgroupAVCSicPayload,
    168 => CXType_OCLIntelSubgroupAVCMceResult,
    169 => CXType_OCLIntelSubgroupAVCImeResult,
    170 => CXType_OCLIntelSubgroupAVCRefResult,
    171 => CXType_OCLIntelSubgroupAVCSicResult,
    172 => CXType_OCLIntelSubgroupAVCImeResultSingleRefStreamout,
    173 => CXType_OCLIntelSubgroupAVCImeResultDualRefStreamout,
    174 => CXType_OCLIntelSubgroupAVCImeSingleRefStreamin,
    175 => CXType_OCLIntelSubgroupAVCImeDualRefStreamin,
    176 => CXType_ExtVector,
    _ => throw ArgumentError('Unknown value for CXTypeKind: $value'),
  };

  @override
  String toString() {
    if (this == CXType_Void)
      return "CXTypeKind.CXType_Void, CXTypeKind.CXType_FirstBuiltin";
    if (this == CXType_ULongAccum)
      return "CXTypeKind.CXType_ULongAccum, CXTypeKind.CXType_LastBuiltin";
    return super.toString();
  }
}

/// Describes the calling convention of a function type
enum CXCallingConv {
  CXCallingConv_Default(0),
  CXCallingConv_C(1),
  CXCallingConv_X86StdCall(2),
  CXCallingConv_X86FastCall(3),
  CXCallingConv_X86ThisCall(4),
  CXCallingConv_X86Pascal(5),
  CXCallingConv_AAPCS(6),
  CXCallingConv_AAPCS_VFP(7),
  CXCallingConv_X86RegCall(8),
  CXCallingConv_IntelOclBicc(9),
  CXCallingConv_Win64(10),
  CXCallingConv_X86_64SysV(11),
  CXCallingConv_X86VectorCall(12),
  CXCallingConv_Swift(13),
  CXCallingConv_PreserveMost(14),
  CXCallingConv_PreserveAll(15),
  CXCallingConv_AArch64VectorCall(16),
  CXCallingConv_Invalid(100),
  CXCallingConv_Unexposed(200);

  static const CXCallingConv_X86_64Win64 = CXCallingConv_Win64;

  final int value;
  const CXCallingConv(this.value);

  static CXCallingConv fromValue(int value) => switch (value) {
    0 => CXCallingConv_Default,
    1 => CXCallingConv_C,
    2 => CXCallingConv_X86StdCall,
    3 => CXCallingConv_X86FastCall,
    4 => CXCallingConv_X86ThisCall,
    5 => CXCallingConv_X86Pascal,
    6 => CXCallingConv_AAPCS,
    7 => CXCallingConv_AAPCS_VFP,
    8 => CXCallingConv_X86RegCall,
    9 => CXCallingConv_IntelOclBicc,
    10 => CXCallingConv_Win64,
    11 => CXCallingConv_X86_64SysV,
    12 => CXCallingConv_X86VectorCall,
    13 => CXCallingConv_Swift,
    14 => CXCallingConv_PreserveMost,
    15 => CXCallingConv_PreserveAll,
    16 => CXCallingConv_AArch64VectorCall,
    100 => CXCallingConv_Invalid,
    200 => CXCallingConv_Unexposed,
    _ => throw ArgumentError('Unknown value for CXCallingConv: $value'),
  };

  @override
  String toString() {
    if (this == CXCallingConv_Win64)
      return "CXCallingConv.CXCallingConv_Win64, CXCallingConv.CXCallingConv_X86_64Win64";
    return super.toString();
  }
}

/// The type of an element in the abstract syntax tree.
final class CXType extends ffi.Struct {
  @ffi.UnsignedInt()
  external int kindAsInt;

  CXTypeKind get kind => CXTypeKind.fromValue(kindAsInt);

  @ffi.Array.multi([2])
  external ffi.Array<ffi.Pointer<ffi.Void>> data;
}

typedef NativeClang_getCursorType = CXType Function(CXCursor C);
typedef DartClang_getCursorType = CXType Function(CXCursor C);
typedef NativeClang_getTypeSpelling = CXString Function(CXType CT);
typedef DartClang_getTypeSpelling = CXString Function(CXType CT);
typedef NativeClang_getTypedefDeclUnderlyingType = CXType Function(CXCursor C);
typedef DartClang_getTypedefDeclUnderlyingType = CXType Function(CXCursor C);
typedef NativeClang_getEnumDeclIntegerType = CXType Function(CXCursor C);
typedef DartClang_getEnumDeclIntegerType = CXType Function(CXCursor C);
typedef NativeClang_getEnumConstantDeclValue =
    ffi.LongLong Function(CXCursor C);
typedef DartClang_getEnumConstantDeclValue = int Function(CXCursor C);
typedef NativeClang_getEnumConstantDeclUnsignedValue =
    ffi.UnsignedLongLong Function(CXCursor C);
typedef DartClang_getEnumConstantDeclUnsignedValue = int Function(CXCursor C);
typedef NativeClang_getFieldDeclBitWidth = ffi.Int Function(CXCursor C);
typedef DartClang_getFieldDeclBitWidth = int Function(CXCursor C);
typedef NativeClang_Cursor_getNumArguments = ffi.Int Function(CXCursor C);
typedef DartClang_Cursor_getNumArguments = int Function(CXCursor C);
typedef NativeClang_Cursor_getArgument =
    CXCursor Function(CXCursor C, ffi.UnsignedInt i);
typedef DartClang_Cursor_getArgument = CXCursor Function(CXCursor C, int i);

/// Describes the kind of a template argument.
///
/// See the definition of llvm::clang::TemplateArgument::ArgKind for full
/// element descriptions.
enum CXTemplateArgumentKind {
  CXTemplateArgumentKind_Null(0),
  CXTemplateArgumentKind_Type(1),
  CXTemplateArgumentKind_Declaration(2),
  CXTemplateArgumentKind_NullPtr(3),
  CXTemplateArgumentKind_Integral(4),
  CXTemplateArgumentKind_Template(5),
  CXTemplateArgumentKind_TemplateExpansion(6),
  CXTemplateArgumentKind_Expression(7),
  CXTemplateArgumentKind_Pack(8),
  CXTemplateArgumentKind_Invalid(9);

  final int value;
  const CXTemplateArgumentKind(this.value);

  static CXTemplateArgumentKind fromValue(int value) => switch (value) {
    0 => CXTemplateArgumentKind_Null,
    1 => CXTemplateArgumentKind_Type,
    2 => CXTemplateArgumentKind_Declaration,
    3 => CXTemplateArgumentKind_NullPtr,
    4 => CXTemplateArgumentKind_Integral,
    5 => CXTemplateArgumentKind_Template,
    6 => CXTemplateArgumentKind_TemplateExpansion,
    7 => CXTemplateArgumentKind_Expression,
    8 => CXTemplateArgumentKind_Pack,
    9 => CXTemplateArgumentKind_Invalid,
    _ => throw ArgumentError(
      'Unknown value for CXTemplateArgumentKind: $value',
    ),
  };
}

typedef NativeClang_Cursor_getNumTemplateArguments =
    ffi.Int Function(CXCursor C);
typedef DartClang_Cursor_getNumTemplateArguments = int Function(CXCursor C);
typedef NativeClang_Cursor_getTemplateArgumentKind =
    ffi.UnsignedInt Function(CXCursor C, ffi.UnsignedInt I);
typedef DartClang_Cursor_getTemplateArgumentKind =
    int Function(CXCursor C, int I);
typedef NativeClang_Cursor_getTemplateArgumentType =
    CXType Function(CXCursor C, ffi.UnsignedInt I);
typedef DartClang_Cursor_getTemplateArgumentType =
    CXType Function(CXCursor C, int I);
typedef NativeClang_Cursor_getTemplateArgumentValue =
    ffi.LongLong Function(CXCursor C, ffi.UnsignedInt I);
typedef DartClang_Cursor_getTemplateArgumentValue =
    int Function(CXCursor C, int I);
typedef NativeClang_Cursor_getTemplateArgumentUnsignedValue =
    ffi.UnsignedLongLong Function(CXCursor C, ffi.UnsignedInt I);
typedef DartClang_Cursor_getTemplateArgumentUnsignedValue =
    int Function(CXCursor C, int I);
typedef NativeClang_equalTypes = ffi.UnsignedInt Function(CXType A, CXType B);
typedef DartClang_equalTypes = int Function(CXType A, CXType B);
typedef NativeClang_getCanonicalType = CXType Function(CXType T);
typedef DartClang_getCanonicalType = CXType Function(CXType T);
typedef NativeClang_isConstQualifiedType = ffi.UnsignedInt Function(CXType T);
typedef DartClang_isConstQualifiedType = int Function(CXType T);
typedef NativeClang_Cursor_isMacroFunctionLike =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_isMacroFunctionLike = int Function(CXCursor C);
typedef NativeClang_Cursor_isMacroBuiltin =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_isMacroBuiltin = int Function(CXCursor C);
typedef NativeClang_Cursor_isFunctionInlined =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_isFunctionInlined = int Function(CXCursor C);
typedef NativeClang_isVolatileQualifiedType =
    ffi.UnsignedInt Function(CXType T);
typedef DartClang_isVolatileQualifiedType = int Function(CXType T);
typedef NativeClang_isRestrictQualifiedType =
    ffi.UnsignedInt Function(CXType T);
typedef DartClang_isRestrictQualifiedType = int Function(CXType T);
typedef NativeClang_getAddressSpace = ffi.UnsignedInt Function(CXType T);
typedef DartClang_getAddressSpace = int Function(CXType T);
typedef NativeClang_getTypedefName = CXString Function(CXType CT);
typedef DartClang_getTypedefName = CXString Function(CXType CT);
typedef NativeClang_getPointeeType = CXType Function(CXType T);
typedef DartClang_getPointeeType = CXType Function(CXType T);
typedef NativeClang_getTypeDeclaration = CXCursor Function(CXType T);
typedef DartClang_getTypeDeclaration = CXCursor Function(CXType T);
typedef NativeClang_getDeclObjCTypeEncoding = CXString Function(CXCursor C);
typedef DartClang_getDeclObjCTypeEncoding = CXString Function(CXCursor C);
typedef NativeClang_Type_getObjCEncoding = CXString Function(CXType type);
typedef DartClang_Type_getObjCEncoding = CXString Function(CXType type);
typedef NativeClang_getTypeKindSpelling = CXString Function(ffi.UnsignedInt K);
typedef DartClang_getTypeKindSpelling = CXString Function(int K);
typedef NativeClang_getFunctionTypeCallingConv =
    ffi.UnsignedInt Function(CXType T);
typedef DartClang_getFunctionTypeCallingConv = int Function(CXType T);
typedef NativeClang_getResultType = CXType Function(CXType T);
typedef DartClang_getResultType = CXType Function(CXType T);
typedef NativeClang_getExceptionSpecificationType = ffi.Int Function(CXType T);
typedef DartClang_getExceptionSpecificationType = int Function(CXType T);
typedef NativeClang_getNumArgTypes = ffi.Int Function(CXType T);
typedef DartClang_getNumArgTypes = int Function(CXType T);
typedef NativeClang_getArgType = CXType Function(CXType T, ffi.UnsignedInt i);
typedef DartClang_getArgType = CXType Function(CXType T, int i);
typedef NativeClang_Type_getObjCObjectBaseType = CXType Function(CXType T);
typedef DartClang_Type_getObjCObjectBaseType = CXType Function(CXType T);
typedef NativeClang_Type_getNumObjCProtocolRefs =
    ffi.UnsignedInt Function(CXType T);
typedef DartClang_Type_getNumObjCProtocolRefs = int Function(CXType T);
typedef NativeClang_Type_getObjCProtocolDecl =
    CXCursor Function(CXType T, ffi.UnsignedInt i);
typedef DartClang_Type_getObjCProtocolDecl = CXCursor Function(CXType T, int i);
typedef NativeClang_Type_getNumObjCTypeArgs =
    ffi.UnsignedInt Function(CXType T);
typedef DartClang_Type_getNumObjCTypeArgs = int Function(CXType T);
typedef NativeClang_Type_getObjCTypeArg =
    CXType Function(CXType T, ffi.UnsignedInt i);
typedef DartClang_Type_getObjCTypeArg = CXType Function(CXType T, int i);
typedef NativeClang_isFunctionTypeVariadic = ffi.UnsignedInt Function(CXType T);
typedef DartClang_isFunctionTypeVariadic = int Function(CXType T);
typedef NativeClang_getCursorResultType = CXType Function(CXCursor C);
typedef DartClang_getCursorResultType = CXType Function(CXCursor C);
typedef NativeClang_getCursorExceptionSpecificationType =
    ffi.Int Function(CXCursor C);
typedef DartClang_getCursorExceptionSpecificationType =
    int Function(CXCursor C);
typedef NativeClang_isPODType = ffi.UnsignedInt Function(CXType T);
typedef DartClang_isPODType = int Function(CXType T);
typedef NativeClang_getElementType = CXType Function(CXType T);
typedef DartClang_getElementType = CXType Function(CXType T);
typedef NativeClang_getNumElements = ffi.LongLong Function(CXType T);
typedef DartClang_getNumElements = int Function(CXType T);
typedef NativeClang_getArrayElementType = CXType Function(CXType T);
typedef DartClang_getArrayElementType = CXType Function(CXType T);
typedef NativeClang_getArraySize = ffi.LongLong Function(CXType T);
typedef DartClang_getArraySize = int Function(CXType T);
typedef NativeClang_Type_getNamedType = CXType Function(CXType T);
typedef DartClang_Type_getNamedType = CXType Function(CXType T);
typedef NativeClang_Type_isTransparentTagTypedef =
    ffi.UnsignedInt Function(CXType T);
typedef DartClang_Type_isTransparentTagTypedef = int Function(CXType T);

enum CXTypeNullabilityKind {
  /// Values of this type can never be null.
  CXTypeNullability_NonNull(0),

  /// Values of this type can be null.
  CXTypeNullability_Nullable(1),

  /// Whether values of this type can be null is (explicitly)
  /// unspecified. This captures a (fairly rare) case where we
  /// can't conclude anything about the nullability of the type even
  /// though it has been considered.
  CXTypeNullability_Unspecified(2),

  /// Nullability is not applicable to this type.
  CXTypeNullability_Invalid(3);

  final int value;
  const CXTypeNullabilityKind(this.value);

  static CXTypeNullabilityKind fromValue(int value) => switch (value) {
    0 => CXTypeNullability_NonNull,
    1 => CXTypeNullability_Nullable,
    2 => CXTypeNullability_Unspecified,
    3 => CXTypeNullability_Invalid,
    _ => throw ArgumentError('Unknown value for CXTypeNullabilityKind: $value'),
  };
}

typedef NativeClang_Type_getNullability = ffi.UnsignedInt Function(CXType T);
typedef DartClang_Type_getNullability = int Function(CXType T);
typedef NativeClang_Type_getAlignOf = ffi.LongLong Function(CXType T);
typedef DartClang_Type_getAlignOf = int Function(CXType T);
typedef NativeClang_Type_getClassType = CXType Function(CXType T);
typedef DartClang_Type_getClassType = CXType Function(CXType T);
typedef NativeClang_Type_getSizeOf = ffi.LongLong Function(CXType T);
typedef DartClang_Type_getSizeOf = int Function(CXType T);
typedef NativeClang_Type_getOffsetOf =
    ffi.LongLong Function(CXType T, ffi.Pointer<ffi.Char> S);
typedef DartClang_Type_getOffsetOf =
    int Function(CXType T, ffi.Pointer<ffi.Char> S);
typedef NativeClang_Type_getModifiedType = CXType Function(CXType T);
typedef DartClang_Type_getModifiedType = CXType Function(CXType T);
typedef NativeClang_Cursor_getOffsetOfField = ffi.LongLong Function(CXCursor C);
typedef DartClang_Cursor_getOffsetOfField = int Function(CXCursor C);
typedef NativeClang_Cursor_isAnonymous = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_isAnonymous = int Function(CXCursor C);
typedef NativeClang_Cursor_isAnonymousRecordDecl =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_isAnonymousRecordDecl = int Function(CXCursor C);
typedef NativeClang_Cursor_isInlineNamespace =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_isInlineNamespace = int Function(CXCursor C);

enum CXRefQualifierKind {
  /// No ref-qualifier was provided.
  CXRefQualifier_None(0),

  /// An lvalue ref-qualifier was provided (\c &).
  CXRefQualifier_LValue(1),

  /// An rvalue ref-qualifier was provided (\c &&).
  CXRefQualifier_RValue(2);

  final int value;
  const CXRefQualifierKind(this.value);

  static CXRefQualifierKind fromValue(int value) => switch (value) {
    0 => CXRefQualifier_None,
    1 => CXRefQualifier_LValue,
    2 => CXRefQualifier_RValue,
    _ => throw ArgumentError('Unknown value for CXRefQualifierKind: $value'),
  };
}

typedef NativeClang_Type_getNumTemplateArguments = ffi.Int Function(CXType T);
typedef DartClang_Type_getNumTemplateArguments = int Function(CXType T);
typedef NativeClang_Type_getTemplateArgumentAsType =
    CXType Function(CXType T, ffi.UnsignedInt i);
typedef DartClang_Type_getTemplateArgumentAsType =
    CXType Function(CXType T, int i);
typedef NativeClang_Type_getCXXRefQualifier =
    ffi.UnsignedInt Function(CXType T);
typedef DartClang_Type_getCXXRefQualifier = int Function(CXType T);
typedef NativeClang_Cursor_isBitField = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_isBitField = int Function(CXCursor C);
typedef NativeClang_isVirtualBase = ffi.UnsignedInt Function(CXCursor);
typedef DartClang_isVirtualBase = int Function(CXCursor);

/// Represents the C++ access control level to a base class for a
/// cursor with kind CX_CXXBaseSpecifier.
enum CX_CXXAccessSpecifier {
  CX_CXXInvalidAccessSpecifier(0),
  CX_CXXPublic(1),
  CX_CXXProtected(2),
  CX_CXXPrivate(3);

  final int value;
  const CX_CXXAccessSpecifier(this.value);

  static CX_CXXAccessSpecifier fromValue(int value) => switch (value) {
    0 => CX_CXXInvalidAccessSpecifier,
    1 => CX_CXXPublic,
    2 => CX_CXXProtected,
    3 => CX_CXXPrivate,
    _ => throw ArgumentError('Unknown value for CX_CXXAccessSpecifier: $value'),
  };
}

typedef NativeClang_getCXXAccessSpecifier = ffi.UnsignedInt Function(CXCursor);
typedef DartClang_getCXXAccessSpecifier = int Function(CXCursor);

/// Represents the storage classes as declared in the source. CX_SC_Invalid
/// was added for the case that the passed cursor in not a declaration.
enum CX_StorageClass {
  CX_SC_Invalid(0),
  CX_SC_None(1),
  CX_SC_Extern(2),
  CX_SC_Static(3),
  CX_SC_PrivateExtern(4),
  CX_SC_OpenCLWorkGroupLocal(5),
  CX_SC_Auto(6),
  CX_SC_Register(7);

  final int value;
  const CX_StorageClass(this.value);

  static CX_StorageClass fromValue(int value) => switch (value) {
    0 => CX_SC_Invalid,
    1 => CX_SC_None,
    2 => CX_SC_Extern,
    3 => CX_SC_Static,
    4 => CX_SC_PrivateExtern,
    5 => CX_SC_OpenCLWorkGroupLocal,
    6 => CX_SC_Auto,
    7 => CX_SC_Register,
    _ => throw ArgumentError('Unknown value for CX_StorageClass: $value'),
  };
}

typedef NativeClang_Cursor_getStorageClass = ffi.UnsignedInt Function(CXCursor);
typedef DartClang_Cursor_getStorageClass = int Function(CXCursor);
typedef NativeClang_getNumOverloadedDecls =
    ffi.UnsignedInt Function(CXCursor cursor);
typedef DartClang_getNumOverloadedDecls = int Function(CXCursor cursor);
typedef NativeClang_getOverloadedDecl =
    CXCursor Function(CXCursor cursor, ffi.UnsignedInt index);
typedef DartClang_getOverloadedDecl =
    CXCursor Function(CXCursor cursor, int index);
typedef NativeClang_getIBOutletCollectionType = CXType Function(CXCursor);
typedef DartClang_getIBOutletCollectionType = CXType Function(CXCursor);

/// Describes how the traversal of the children of a particular
/// cursor should proceed after visiting a particular child cursor.
///
/// A value of this enumeration type should be returned by each
/// \c CXCursorVisitor to indicate how clang_visitChildren() proceed.
enum CXChildVisitResult {
  /// Terminates the cursor traversal.
  CXChildVisit_Break(0),

  /// Continues the cursor traversal with the next sibling of
  /// the cursor just visited, without visiting its children.
  CXChildVisit_Continue(1),

  /// Recursively traverse the children of this cursor, using
  /// the same visitor and client data.
  CXChildVisit_Recurse(2);

  final int value;
  const CXChildVisitResult(this.value);

  static CXChildVisitResult fromValue(int value) => switch (value) {
    0 => CXChildVisit_Break,
    1 => CXChildVisit_Continue,
    2 => CXChildVisit_Recurse,
    _ => throw ArgumentError('Unknown value for CXChildVisitResult: $value'),
  };
}

typedef CXCursorVisitorFunction =
    ffi.UnsignedInt Function(
      CXCursor cursor,
      CXCursor parent,
      CXClientData client_data,
    );
typedef DartCXCursorVisitorFunction =
    CXChildVisitResult Function(
      CXCursor cursor,
      CXCursor parent,
      CXClientData client_data,
    );

/// Visitor invoked for each cursor found by a traversal.
///
/// This visitor function will be invoked for each cursor found by
/// clang_visitCursorChildren(). Its first argument is the cursor being
/// visited, its second argument is the parent visitor for that cursor,
/// and its third argument is the client data provided to
/// clang_visitCursorChildren().
///
/// The visitor should return one of the \c CXChildVisitResult values
/// to direct clang_visitCursorChildren().
typedef CXCursorVisitor =
    ffi.Pointer<ffi.NativeFunction<CXCursorVisitorFunction>>;
typedef NativeClang_visitChildren =
    ffi.UnsignedInt Function(
      CXCursor parent,
      CXCursorVisitor visitor,
      CXClientData client_data,
    );
typedef DartClang_visitChildren =
    int Function(
      CXCursor parent,
      CXCursorVisitor visitor,
      CXClientData client_data,
    );
typedef NativeClang_getCursorUSR = CXString Function(CXCursor);
typedef DartClang_getCursorUSR = CXString Function(CXCursor);
typedef NativeClang_constructUSR_ObjCClass =
    CXString Function(ffi.Pointer<ffi.Char> class_name);
typedef DartClang_constructUSR_ObjCClass =
    CXString Function(ffi.Pointer<ffi.Char> class_name);
typedef NativeClang_constructUSR_ObjCCategory =
    CXString Function(
      ffi.Pointer<ffi.Char> class_name,
      ffi.Pointer<ffi.Char> category_name,
    );
typedef DartClang_constructUSR_ObjCCategory =
    CXString Function(
      ffi.Pointer<ffi.Char> class_name,
      ffi.Pointer<ffi.Char> category_name,
    );
typedef NativeClang_constructUSR_ObjCProtocol =
    CXString Function(ffi.Pointer<ffi.Char> protocol_name);
typedef DartClang_constructUSR_ObjCProtocol =
    CXString Function(ffi.Pointer<ffi.Char> protocol_name);
typedef NativeClang_constructUSR_ObjCIvar =
    CXString Function(ffi.Pointer<ffi.Char> name, CXString classUSR);
typedef DartClang_constructUSR_ObjCIvar =
    CXString Function(ffi.Pointer<ffi.Char> name, CXString classUSR);
typedef NativeClang_constructUSR_ObjCMethod =
    CXString Function(
      ffi.Pointer<ffi.Char> name,
      ffi.UnsignedInt isInstanceMethod,
      CXString classUSR,
    );
typedef DartClang_constructUSR_ObjCMethod =
    CXString Function(
      ffi.Pointer<ffi.Char> name,
      int isInstanceMethod,
      CXString classUSR,
    );
typedef NativeClang_constructUSR_ObjCProperty =
    CXString Function(ffi.Pointer<ffi.Char> property, CXString classUSR);
typedef DartClang_constructUSR_ObjCProperty =
    CXString Function(ffi.Pointer<ffi.Char> property, CXString classUSR);
typedef NativeClang_getCursorSpelling = CXString Function(CXCursor);
typedef DartClang_getCursorSpelling = CXString Function(CXCursor);
typedef NativeClang_Cursor_getSpellingNameRange =
    CXSourceRange Function(
      CXCursor,
      ffi.UnsignedInt pieceIndex,
      ffi.UnsignedInt options,
    );
typedef DartClang_Cursor_getSpellingNameRange =
    CXSourceRange Function(CXCursor, int pieceIndex, int options);

/// Opaque pointer representing a policy that controls pretty printing
/// for \c clang_getCursorPrettyPrinted.
typedef CXPrintingPolicy = ffi.Pointer<ffi.Void>;

/// Properties for the printing policy.
///
/// See \c clang::PrintingPolicy for more information.
enum CXPrintingPolicyProperty {
  CXPrintingPolicy_Indentation(0),
  CXPrintingPolicy_SuppressSpecifiers(1),
  CXPrintingPolicy_SuppressTagKeyword(2),
  CXPrintingPolicy_IncludeTagDefinition(3),
  CXPrintingPolicy_SuppressScope(4),
  CXPrintingPolicy_SuppressUnwrittenScope(5),
  CXPrintingPolicy_SuppressInitializers(6),
  CXPrintingPolicy_ConstantArraySizeAsWritten(7),
  CXPrintingPolicy_AnonymousTagLocations(8),
  CXPrintingPolicy_SuppressStrongLifetime(9),
  CXPrintingPolicy_SuppressLifetimeQualifiers(10),
  CXPrintingPolicy_SuppressTemplateArgsInCXXConstructors(11),
  CXPrintingPolicy_Bool(12),
  CXPrintingPolicy_Restrict(13),
  CXPrintingPolicy_Alignof(14),
  CXPrintingPolicy_UnderscoreAlignof(15),
  CXPrintingPolicy_UseVoidForZeroParams(16),
  CXPrintingPolicy_TerseOutput(17),
  CXPrintingPolicy_PolishForDeclaration(18),
  CXPrintingPolicy_Half(19),
  CXPrintingPolicy_MSWChar(20),
  CXPrintingPolicy_IncludeNewlines(21),
  CXPrintingPolicy_MSVCFormatting(22),
  CXPrintingPolicy_ConstantsAsWritten(23),
  CXPrintingPolicy_SuppressImplicitBase(24),
  CXPrintingPolicy_FullyQualifiedName(25);

  static const CXPrintingPolicy_LastProperty =
      CXPrintingPolicy_FullyQualifiedName;

  final int value;
  const CXPrintingPolicyProperty(this.value);

  static CXPrintingPolicyProperty fromValue(int value) => switch (value) {
    0 => CXPrintingPolicy_Indentation,
    1 => CXPrintingPolicy_SuppressSpecifiers,
    2 => CXPrintingPolicy_SuppressTagKeyword,
    3 => CXPrintingPolicy_IncludeTagDefinition,
    4 => CXPrintingPolicy_SuppressScope,
    5 => CXPrintingPolicy_SuppressUnwrittenScope,
    6 => CXPrintingPolicy_SuppressInitializers,
    7 => CXPrintingPolicy_ConstantArraySizeAsWritten,
    8 => CXPrintingPolicy_AnonymousTagLocations,
    9 => CXPrintingPolicy_SuppressStrongLifetime,
    10 => CXPrintingPolicy_SuppressLifetimeQualifiers,
    11 => CXPrintingPolicy_SuppressTemplateArgsInCXXConstructors,
    12 => CXPrintingPolicy_Bool,
    13 => CXPrintingPolicy_Restrict,
    14 => CXPrintingPolicy_Alignof,
    15 => CXPrintingPolicy_UnderscoreAlignof,
    16 => CXPrintingPolicy_UseVoidForZeroParams,
    17 => CXPrintingPolicy_TerseOutput,
    18 => CXPrintingPolicy_PolishForDeclaration,
    19 => CXPrintingPolicy_Half,
    20 => CXPrintingPolicy_MSWChar,
    21 => CXPrintingPolicy_IncludeNewlines,
    22 => CXPrintingPolicy_MSVCFormatting,
    23 => CXPrintingPolicy_ConstantsAsWritten,
    24 => CXPrintingPolicy_SuppressImplicitBase,
    25 => CXPrintingPolicy_FullyQualifiedName,
    _ => throw ArgumentError(
      'Unknown value for CXPrintingPolicyProperty: $value',
    ),
  };

  @override
  String toString() {
    if (this == CXPrintingPolicy_FullyQualifiedName)
      return "CXPrintingPolicyProperty.CXPrintingPolicy_FullyQualifiedName, CXPrintingPolicyProperty.CXPrintingPolicy_LastProperty";
    return super.toString();
  }
}

typedef NativeClang_PrintingPolicy_getProperty =
    ffi.UnsignedInt Function(CXPrintingPolicy Policy, ffi.UnsignedInt Property);
typedef DartClang_PrintingPolicy_getProperty =
    int Function(CXPrintingPolicy Policy, int Property);
typedef NativeClang_PrintingPolicy_setProperty =
    ffi.Void Function(
      CXPrintingPolicy Policy,
      ffi.UnsignedInt Property,
      ffi.UnsignedInt Value,
    );
typedef DartClang_PrintingPolicy_setProperty =
    void Function(CXPrintingPolicy Policy, int Property, int Value);
typedef NativeClang_getCursorPrintingPolicy =
    CXPrintingPolicy Function(CXCursor);
typedef DartClang_getCursorPrintingPolicy = CXPrintingPolicy Function(CXCursor);
typedef NativeClang_PrintingPolicy_dispose =
    ffi.Void Function(CXPrintingPolicy Policy);
typedef DartClang_PrintingPolicy_dispose =
    void Function(CXPrintingPolicy Policy);
typedef NativeClang_getCursorPrettyPrinted =
    CXString Function(CXCursor Cursor, CXPrintingPolicy Policy);
typedef DartClang_getCursorPrettyPrinted =
    CXString Function(CXCursor Cursor, CXPrintingPolicy Policy);
typedef NativeClang_getCursorDisplayName = CXString Function(CXCursor);
typedef DartClang_getCursorDisplayName = CXString Function(CXCursor);
typedef NativeClang_getCursorReferenced = CXCursor Function(CXCursor);
typedef DartClang_getCursorReferenced = CXCursor Function(CXCursor);
typedef NativeClang_getCursorDefinition = CXCursor Function(CXCursor);
typedef DartClang_getCursorDefinition = CXCursor Function(CXCursor);
typedef NativeClang_isCursorDefinition = ffi.UnsignedInt Function(CXCursor);
typedef DartClang_isCursorDefinition = int Function(CXCursor);
typedef NativeClang_getCanonicalCursor = CXCursor Function(CXCursor);
typedef DartClang_getCanonicalCursor = CXCursor Function(CXCursor);
typedef NativeClang_Cursor_getObjCSelectorIndex = ffi.Int Function(CXCursor);
typedef DartClang_Cursor_getObjCSelectorIndex = int Function(CXCursor);
typedef NativeClang_Cursor_isDynamicCall = ffi.Int Function(CXCursor C);
typedef DartClang_Cursor_isDynamicCall = int Function(CXCursor C);
typedef NativeClang_Cursor_getReceiverType = CXType Function(CXCursor C);
typedef DartClang_Cursor_getReceiverType = CXType Function(CXCursor C);
typedef NativeClang_Cursor_getObjCPropertyAttributes =
    ffi.UnsignedInt Function(CXCursor C, ffi.UnsignedInt reserved);
typedef DartClang_Cursor_getObjCPropertyAttributes =
    int Function(CXCursor C, int reserved);
typedef NativeClang_Cursor_getObjCPropertyGetterName =
    CXString Function(CXCursor C);
typedef DartClang_Cursor_getObjCPropertyGetterName =
    CXString Function(CXCursor C);
typedef NativeClang_Cursor_getObjCPropertySetterName =
    CXString Function(CXCursor C);
typedef DartClang_Cursor_getObjCPropertySetterName =
    CXString Function(CXCursor C);
typedef NativeClang_Cursor_getObjCDeclQualifiers =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_getObjCDeclQualifiers = int Function(CXCursor C);
typedef NativeClang_Cursor_isObjCOptional =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_isObjCOptional = int Function(CXCursor C);
typedef NativeClang_Cursor_isVariadic = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_Cursor_isVariadic = int Function(CXCursor C);
typedef NativeClang_Cursor_isExternalSymbol =
    ffi.UnsignedInt Function(
      CXCursor C,
      ffi.Pointer<CXString> language,
      ffi.Pointer<CXString> definedIn,
      ffi.Pointer<ffi.UnsignedInt> isGenerated,
    );
typedef DartClang_Cursor_isExternalSymbol =
    int Function(
      CXCursor C,
      ffi.Pointer<CXString> language,
      ffi.Pointer<CXString> definedIn,
      ffi.Pointer<ffi.UnsignedInt> isGenerated,
    );
typedef NativeClang_Cursor_getCommentRange = CXSourceRange Function(CXCursor C);
typedef DartClang_Cursor_getCommentRange = CXSourceRange Function(CXCursor C);
typedef NativeClang_Cursor_getRawCommentText = CXString Function(CXCursor C);
typedef DartClang_Cursor_getRawCommentText = CXString Function(CXCursor C);
typedef NativeClang_Cursor_getBriefCommentText = CXString Function(CXCursor C);
typedef DartClang_Cursor_getBriefCommentText = CXString Function(CXCursor C);
typedef NativeClang_Cursor_getMangling = CXString Function(CXCursor);
typedef DartClang_Cursor_getMangling = CXString Function(CXCursor);
typedef NativeClang_Cursor_getCXXManglings =
    ffi.Pointer<CXStringSet> Function(CXCursor);
typedef DartClang_Cursor_getCXXManglings =
    ffi.Pointer<CXStringSet> Function(CXCursor);
typedef NativeClang_Cursor_getObjCManglings =
    ffi.Pointer<CXStringSet> Function(CXCursor);
typedef DartClang_Cursor_getObjCManglings =
    ffi.Pointer<CXStringSet> Function(CXCursor);

/// \defgroup CINDEX_MODULE Module introspection
///
/// The functions in this group provide access to information about modules.
///
/// @{
typedef CXModule = ffi.Pointer<ffi.Void>;
typedef NativeClang_Cursor_getModule = CXModule Function(CXCursor C);
typedef DartClang_Cursor_getModule = CXModule Function(CXCursor C);
typedef NativeClang_getModuleForFile =
    CXModule Function(CXTranslationUnit, CXFile);
typedef DartClang_getModuleForFile =
    CXModule Function(CXTranslationUnit, CXFile);
typedef NativeClang_Module_getASTFile = CXFile Function(CXModule Module);
typedef DartClang_Module_getASTFile = CXFile Function(CXModule Module);
typedef NativeClang_Module_getParent = CXModule Function(CXModule Module);
typedef DartClang_Module_getParent = CXModule Function(CXModule Module);
typedef NativeClang_Module_getName = CXString Function(CXModule Module);
typedef DartClang_Module_getName = CXString Function(CXModule Module);
typedef NativeClang_Module_getFullName = CXString Function(CXModule Module);
typedef DartClang_Module_getFullName = CXString Function(CXModule Module);
typedef NativeClang_Module_isSystem = ffi.Int Function(CXModule Module);
typedef DartClang_Module_isSystem = int Function(CXModule Module);
typedef NativeClang_Module_getNumTopLevelHeaders =
    ffi.UnsignedInt Function(CXTranslationUnit, CXModule Module);
typedef DartClang_Module_getNumTopLevelHeaders =
    int Function(CXTranslationUnit, CXModule Module);
typedef NativeClang_Module_getTopLevelHeader =
    CXFile Function(CXTranslationUnit, CXModule Module, ffi.UnsignedInt Index);
typedef DartClang_Module_getTopLevelHeader =
    CXFile Function(CXTranslationUnit, CXModule Module, int Index);
typedef NativeClang_CXXConstructor_isConvertingConstructor =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXConstructor_isConvertingConstructor =
    int Function(CXCursor C);
typedef NativeClang_CXXConstructor_isCopyConstructor =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXConstructor_isCopyConstructor = int Function(CXCursor C);
typedef NativeClang_CXXConstructor_isDefaultConstructor =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXConstructor_isDefaultConstructor =
    int Function(CXCursor C);
typedef NativeClang_CXXConstructor_isMoveConstructor =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXConstructor_isMoveConstructor = int Function(CXCursor C);
typedef NativeClang_CXXField_isMutable = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXField_isMutable = int Function(CXCursor C);
typedef NativeClang_CXXMethod_isDefaulted =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXMethod_isDefaulted = int Function(CXCursor C);
typedef NativeClang_CXXMethod_isPureVirtual =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXMethod_isPureVirtual = int Function(CXCursor C);
typedef NativeClang_CXXMethod_isStatic = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXMethod_isStatic = int Function(CXCursor C);
typedef NativeClang_CXXMethod_isVirtual = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXMethod_isVirtual = int Function(CXCursor C);
typedef NativeClang_CXXRecord_isAbstract = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXRecord_isAbstract = int Function(CXCursor C);
typedef NativeClang_EnumDecl_isScoped = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_EnumDecl_isScoped = int Function(CXCursor C);
typedef NativeClang_CXXMethod_isConst = ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_CXXMethod_isConst = int Function(CXCursor C);
typedef NativeClang_getTemplateCursorKind =
    ffi.UnsignedInt Function(CXCursor C);
typedef DartClang_getTemplateCursorKind = int Function(CXCursor C);
typedef NativeClang_getSpecializedCursorTemplate =
    CXCursor Function(CXCursor C);
typedef DartClang_getSpecializedCursorTemplate = CXCursor Function(CXCursor C);
typedef NativeClang_getCursorReferenceNameRange =
    CXSourceRange Function(
      CXCursor C,
      ffi.UnsignedInt NameFlags,
      ffi.UnsignedInt PieceIndex,
    );
typedef DartClang_getCursorReferenceNameRange =
    CXSourceRange Function(CXCursor C, int NameFlags, int PieceIndex);

/// Describes a kind of token.
enum CXTokenKind {
  /// A token that contains some kind of punctuation.
  CXToken_Punctuation(0),

  /// A language keyword.
  CXToken_Keyword(1),

  /// An identifier (that is not a keyword).
  CXToken_Identifier(2),

  /// A numeric, string, or character literal.
  CXToken_Literal(3),

  /// A comment.
  CXToken_Comment(4);

  final int value;
  const CXTokenKind(this.value);

  static CXTokenKind fromValue(int value) => switch (value) {
    0 => CXToken_Punctuation,
    1 => CXToken_Keyword,
    2 => CXToken_Identifier,
    3 => CXToken_Literal,
    4 => CXToken_Comment,
    _ => throw ArgumentError('Unknown value for CXTokenKind: $value'),
  };
}

/// Describes a single preprocessing token.
final class CXToken extends ffi.Struct {
  @ffi.Array.multi([4])
  external ffi.Array<ffi.UnsignedInt> int_data;

  external ffi.Pointer<ffi.Void> ptr_data;
}

typedef NativeClang_getToken =
    ffi.Pointer<CXToken> Function(
      CXTranslationUnit TU,
      CXSourceLocation Location,
    );
typedef DartClang_getToken =
    ffi.Pointer<CXToken> Function(
      CXTranslationUnit TU,
      CXSourceLocation Location,
    );
typedef NativeClang_getTokenKind = ffi.UnsignedInt Function(CXToken);
typedef DartClang_getTokenKind = int Function(CXToken);
typedef NativeClang_getTokenSpelling =
    CXString Function(CXTranslationUnit, CXToken);
typedef DartClang_getTokenSpelling =
    CXString Function(CXTranslationUnit, CXToken);
typedef NativeClang_getTokenLocation =
    CXSourceLocation Function(CXTranslationUnit, CXToken);
typedef DartClang_getTokenLocation =
    CXSourceLocation Function(CXTranslationUnit, CXToken);
typedef NativeClang_getTokenExtent =
    CXSourceRange Function(CXTranslationUnit, CXToken);
typedef DartClang_getTokenExtent =
    CXSourceRange Function(CXTranslationUnit, CXToken);
typedef NativeClang_tokenize =
    ffi.Void Function(
      CXTranslationUnit TU,
      CXSourceRange Range,
      ffi.Pointer<ffi.Pointer<CXToken>> Tokens,
      ffi.Pointer<ffi.UnsignedInt> NumTokens,
    );
typedef DartClang_tokenize =
    void Function(
      CXTranslationUnit TU,
      CXSourceRange Range,
      ffi.Pointer<ffi.Pointer<CXToken>> Tokens,
      ffi.Pointer<ffi.UnsignedInt> NumTokens,
    );
typedef NativeClang_annotateTokens =
    ffi.Void Function(
      CXTranslationUnit TU,
      ffi.Pointer<CXToken> Tokens,
      ffi.UnsignedInt NumTokens,
      ffi.Pointer<CXCursor> Cursors,
    );
typedef DartClang_annotateTokens =
    void Function(
      CXTranslationUnit TU,
      ffi.Pointer<CXToken> Tokens,
      int NumTokens,
      ffi.Pointer<CXCursor> Cursors,
    );
typedef NativeClang_disposeTokens =
    ffi.Void Function(
      CXTranslationUnit TU,
      ffi.Pointer<CXToken> Tokens,
      ffi.UnsignedInt NumTokens,
    );
typedef DartClang_disposeTokens =
    void Function(
      CXTranslationUnit TU,
      ffi.Pointer<CXToken> Tokens,
      int NumTokens,
    );
typedef NativeClang_getCursorKindSpelling =
    CXString Function(ffi.UnsignedInt Kind);
typedef DartClang_getCursorKindSpelling = CXString Function(int Kind);
typedef NativeClang_getDefinitionSpellingAndExtent =
    ffi.Void Function(
      CXCursor,
      ffi.Pointer<ffi.Pointer<ffi.Char>> startBuf,
      ffi.Pointer<ffi.Pointer<ffi.Char>> endBuf,
      ffi.Pointer<ffi.UnsignedInt> startLine,
      ffi.Pointer<ffi.UnsignedInt> startColumn,
      ffi.Pointer<ffi.UnsignedInt> endLine,
      ffi.Pointer<ffi.UnsignedInt> endColumn,
    );
typedef DartClang_getDefinitionSpellingAndExtent =
    void Function(
      CXCursor,
      ffi.Pointer<ffi.Pointer<ffi.Char>> startBuf,
      ffi.Pointer<ffi.Pointer<ffi.Char>> endBuf,
      ffi.Pointer<ffi.UnsignedInt> startLine,
      ffi.Pointer<ffi.UnsignedInt> startColumn,
      ffi.Pointer<ffi.UnsignedInt> endLine,
      ffi.Pointer<ffi.UnsignedInt> endColumn,
    );
typedef NativeClang_enableStackTraces = ffi.Void Function();
typedef DartClang_enableStackTraces = void Function();
typedef NativeClang_executeOnThread =
    ffi.Void Function(
      ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
      fn,
      ffi.Pointer<ffi.Void> user_data,
      ffi.UnsignedInt stack_size,
    );
typedef DartClang_executeOnThread =
    void Function(
      ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
      fn,
      ffi.Pointer<ffi.Void> user_data,
      int stack_size,
    );

/// A semantic string that describes a code-completion result.
///
/// A semantic string that describes the formatting of a code-completion
/// result as a single "template" of text that should be inserted into the
/// source buffer when a particular code-completion result is selected.
/// Each semantic string is made up of some number of "chunks", each of which
/// contains some text along with a description of what that text means, e.g.,
/// the name of the entity being referenced, whether the text chunk is part of
/// the template, or whether it is a "placeholder" that the user should replace
/// with actual code,of a specific kind. See \c CXCompletionChunkKind for a
/// description of the different kinds of chunks.
typedef CXCompletionString = ffi.Pointer<ffi.Void>;

/// A single result of code completion.
final class CXCompletionResult extends ffi.Struct {
  /// The kind of entity that this completion refers to.
  ///
  /// The cursor kind will be a macro, keyword, or a declaration (one of the
  /// *Decl cursor kinds), describing the entity that the completion is
  /// referring to.
  ///
  /// \todo In the future, we would like to provide a full cursor, to allow
  /// the client to extract additional information from declaration.
  @ffi.UnsignedInt()
  external int CursorKindAsInt;

  CXCursorKind get CursorKind => CXCursorKind.fromValue(CursorKindAsInt);

  /// The code-completion string that describes how to insert this
  /// code-completion result into the editing buffer.
  external CXCompletionString CompletionString;
}

/// Describes a single piece of text within a code-completion string.
///
/// Each "chunk" within a code-completion string (\c CXCompletionString) is
/// either a piece of text with a specific "kind" that describes how that text
/// should be interpreted by the client or is another completion string.
enum CXCompletionChunkKind {
  /// A code-completion string that describes "optional" text that
  /// could be a part of the template (but is not required).
  ///
  /// The Optional chunk is the only kind of chunk that has a code-completion
  /// string for its representation, which is accessible via
  /// \c clang_getCompletionChunkCompletionString(). The code-completion string
  /// describes an additional part of the template that is completely optional.
  /// For example, optional chunks can be used to describe the placeholders for
  /// arguments that match up with defaulted function parameters, e.g. given:
  ///
  /// \code
  /// void f(int x, float y = 3.14, double z = 2.71828);
  /// \endcode
  ///
  /// The code-completion string for this function would contain:
  /// - a TypedText chunk for "f".
  /// - a LeftParen chunk for "(".
  /// - a Placeholder chunk for "int x"
  /// - an Optional chunk containing the remaining defaulted arguments, e.g.,
  /// - a Comma chunk for ","
  /// - a Placeholder chunk for "float y"
  /// - an Optional chunk containing the last defaulted argument:
  /// - a Comma chunk for ","
  /// - a Placeholder chunk for "double z"
  /// - a RightParen chunk for ")"
  ///
  /// There are many ways to handle Optional chunks. Two simple approaches are:
  /// - Completely ignore optional chunks, in which case the template for the
  /// function "f" would only include the first parameter ("int x").
  /// - Fully expand all optional chunks, in which case the template for the
  /// function "f" would have all of the parameters.
  CXCompletionChunk_Optional(0),

  /// Text that a user would be expected to type to get this
  /// code-completion result.
  ///
  /// There will be exactly one "typed text" chunk in a semantic string, which
  /// will typically provide the spelling of a keyword or the name of a
  /// declaration that could be used at the current code point. Clients are
  /// expected to filter the code-completion results based on the text in this
  /// chunk.
  CXCompletionChunk_TypedText(1),

  /// Text that should be inserted as part of a code-completion result.
  ///
  /// A "text" chunk represents text that is part of the template to be
  /// inserted into user code should this particular code-completion result
  /// be selected.
  CXCompletionChunk_Text(2),

  /// Placeholder text that should be replaced by the user.
  ///
  /// A "placeholder" chunk marks a place where the user should insert text
  /// into the code-completion template. For example, placeholders might mark
  /// the function parameters for a function declaration, to indicate that the
  /// user should provide arguments for each of those parameters. The actual
  /// text in a placeholder is a suggestion for the text to display before
  /// the user replaces the placeholder with real code.
  CXCompletionChunk_Placeholder(3),

  /// Informative text that should be displayed but never inserted as
  /// part of the template.
  ///
  /// An "informative" chunk contains annotations that can be displayed to
  /// help the user decide whether a particular code-completion result is the
  /// right option, but which is not part of the actual template to be inserted
  /// by code completion.
  CXCompletionChunk_Informative(4),

  /// Text that describes the current parameter when code-completion is
  /// referring to function call, message send, or template specialization.
  ///
  /// A "current parameter" chunk occurs when code-completion is providing
  /// information about a parameter corresponding to the argument at the
  /// code-completion point. For example, given a function
  ///
  /// \code
  /// int add(int x, int y);
  /// \endcode
  ///
  /// and the source code \c add(, where the code-completion point is after the
  /// "(", the code-completion string will contain a "current parameter" chunk
  /// for "int x", indicating that the current argument will initialize that
  /// parameter. After typing further, to \c add(17, (where the code-completion
  /// point is after the ","), the code-completion string will contain a
  /// "current parameter" chunk to "int y".
  CXCompletionChunk_CurrentParameter(5),

  /// A left parenthesis ('('), used to initiate a function call or
  /// signal the beginning of a function parameter list.
  CXCompletionChunk_LeftParen(6),

  /// A right parenthesis (')'), used to finish a function call or
  /// signal the end of a function parameter list.
  CXCompletionChunk_RightParen(7),

  /// A left bracket ('[').
  CXCompletionChunk_LeftBracket(8),

  /// A right bracket (']').
  CXCompletionChunk_RightBracket(9),

  /// A left brace ('{').
  CXCompletionChunk_LeftBrace(10),

  /// A right brace ('}').
  CXCompletionChunk_RightBrace(11),

  /// A left angle bracket ('<').
  CXCompletionChunk_LeftAngle(12),

  /// A right angle bracket ('>').
  CXCompletionChunk_RightAngle(13),

  /// A comma separator (',').
  CXCompletionChunk_Comma(14),

  /// Text that specifies the result type of a given result.
  ///
  /// This special kind of informative chunk is not meant to be inserted into
  /// the text buffer. Rather, it is meant to illustrate the type that an
  /// expression using the given completion string would have.
  CXCompletionChunk_ResultType(15),

  /// A colon (':').
  CXCompletionChunk_Colon(16),

  /// A semicolon (';').
  CXCompletionChunk_SemiColon(17),

  /// An '=' sign.
  CXCompletionChunk_Equal(18),

  /// Horizontal space (' ').
  CXCompletionChunk_HorizontalSpace(19),

  /// Vertical space ('\\n'), after which it is generally a good idea to
  /// perform indentation.
  CXCompletionChunk_VerticalSpace(20);

  final int value;
  const CXCompletionChunkKind(this.value);

  static CXCompletionChunkKind fromValue(int value) => switch (value) {
    0 => CXCompletionChunk_Optional,
    1 => CXCompletionChunk_TypedText,
    2 => CXCompletionChunk_Text,
    3 => CXCompletionChunk_Placeholder,
    4 => CXCompletionChunk_Informative,
    5 => CXCompletionChunk_CurrentParameter,
    6 => CXCompletionChunk_LeftParen,
    7 => CXCompletionChunk_RightParen,
    8 => CXCompletionChunk_LeftBracket,
    9 => CXCompletionChunk_RightBracket,
    10 => CXCompletionChunk_LeftBrace,
    11 => CXCompletionChunk_RightBrace,
    12 => CXCompletionChunk_LeftAngle,
    13 => CXCompletionChunk_RightAngle,
    14 => CXCompletionChunk_Comma,
    15 => CXCompletionChunk_ResultType,
    16 => CXCompletionChunk_Colon,
    17 => CXCompletionChunk_SemiColon,
    18 => CXCompletionChunk_Equal,
    19 => CXCompletionChunk_HorizontalSpace,
    20 => CXCompletionChunk_VerticalSpace,
    _ => throw ArgumentError('Unknown value for CXCompletionChunkKind: $value'),
  };
}

typedef NativeClang_getCompletionChunkKind =
    ffi.UnsignedInt Function(
      CXCompletionString completion_string,
      ffi.UnsignedInt chunk_number,
    );
typedef DartClang_getCompletionChunkKind =
    int Function(CXCompletionString completion_string, int chunk_number);
typedef NativeClang_getCompletionChunkText =
    CXString Function(
      CXCompletionString completion_string,
      ffi.UnsignedInt chunk_number,
    );
typedef DartClang_getCompletionChunkText =
    CXString Function(CXCompletionString completion_string, int chunk_number);
typedef NativeClang_getCompletionChunkCompletionString =
    CXCompletionString Function(
      CXCompletionString completion_string,
      ffi.UnsignedInt chunk_number,
    );
typedef DartClang_getCompletionChunkCompletionString =
    CXCompletionString Function(
      CXCompletionString completion_string,
      int chunk_number,
    );
typedef NativeClang_getNumCompletionChunks =
    ffi.UnsignedInt Function(CXCompletionString completion_string);
typedef DartClang_getNumCompletionChunks =
    int Function(CXCompletionString completion_string);
typedef NativeClang_getCompletionPriority =
    ffi.UnsignedInt Function(CXCompletionString completion_string);
typedef DartClang_getCompletionPriority =
    int Function(CXCompletionString completion_string);
typedef NativeClang_getCompletionAvailability =
    ffi.UnsignedInt Function(CXCompletionString completion_string);
typedef DartClang_getCompletionAvailability =
    int Function(CXCompletionString completion_string);
typedef NativeClang_getCompletionNumAnnotations =
    ffi.UnsignedInt Function(CXCompletionString completion_string);
typedef DartClang_getCompletionNumAnnotations =
    int Function(CXCompletionString completion_string);
typedef NativeClang_getCompletionAnnotation =
    CXString Function(
      CXCompletionString completion_string,
      ffi.UnsignedInt annotation_number,
    );
typedef DartClang_getCompletionAnnotation =
    CXString Function(
      CXCompletionString completion_string,
      int annotation_number,
    );
typedef NativeClang_getCompletionParent =
    CXString Function(
      CXCompletionString completion_string,
      ffi.Pointer<ffi.UnsignedInt> kind,
    );
typedef DartClang_getCompletionParent =
    CXString Function(
      CXCompletionString completion_string,
      ffi.Pointer<ffi.UnsignedInt> kind,
    );
typedef NativeClang_getCompletionBriefComment =
    CXString Function(CXCompletionString completion_string);
typedef DartClang_getCompletionBriefComment =
    CXString Function(CXCompletionString completion_string);
typedef NativeClang_getCursorCompletionString =
    CXCompletionString Function(CXCursor cursor);
typedef DartClang_getCursorCompletionString =
    CXCompletionString Function(CXCursor cursor);

/// Contains the results of code-completion.
///
/// This data structure contains the results of code completion, as
/// produced by \c clang_codeCompleteAt(). Its contents must be freed by
/// \c clang_disposeCodeCompleteResults.
final class CXCodeCompleteResults extends ffi.Struct {
  /// The code-completion results.
  external ffi.Pointer<CXCompletionResult> Results;

  /// The number of code-completion results stored in the
  /// \c Results array.
  @ffi.UnsignedInt()
  external int NumResults;
}

typedef NativeClang_getCompletionNumFixIts =
    ffi.UnsignedInt Function(
      ffi.Pointer<CXCodeCompleteResults> results,
      ffi.UnsignedInt completion_index,
    );
typedef DartClang_getCompletionNumFixIts =
    int Function(
      ffi.Pointer<CXCodeCompleteResults> results,
      int completion_index,
    );
typedef NativeClang_getCompletionFixIt =
    CXString Function(
      ffi.Pointer<CXCodeCompleteResults> results,
      ffi.UnsignedInt completion_index,
      ffi.UnsignedInt fixit_index,
      ffi.Pointer<CXSourceRange> replacement_range,
    );
typedef DartClang_getCompletionFixIt =
    CXString Function(
      ffi.Pointer<CXCodeCompleteResults> results,
      int completion_index,
      int fixit_index,
      ffi.Pointer<CXSourceRange> replacement_range,
    );
typedef NativeClang_defaultCodeCompleteOptions = ffi.UnsignedInt Function();
typedef DartClang_defaultCodeCompleteOptions = int Function();
typedef NativeClang_codeCompleteAt =
    ffi.Pointer<CXCodeCompleteResults> Function(
      CXTranslationUnit TU,
      ffi.Pointer<ffi.Char> complete_filename,
      ffi.UnsignedInt complete_line,
      ffi.UnsignedInt complete_column,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      ffi.UnsignedInt num_unsaved_files,
      ffi.UnsignedInt options,
    );
typedef DartClang_codeCompleteAt =
    ffi.Pointer<CXCodeCompleteResults> Function(
      CXTranslationUnit TU,
      ffi.Pointer<ffi.Char> complete_filename,
      int complete_line,
      int complete_column,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      int num_unsaved_files,
      int options,
    );
typedef NativeClang_sortCodeCompletionResults =
    ffi.Void Function(
      ffi.Pointer<CXCompletionResult> Results,
      ffi.UnsignedInt NumResults,
    );
typedef DartClang_sortCodeCompletionResults =
    void Function(ffi.Pointer<CXCompletionResult> Results, int NumResults);
typedef NativeClang_disposeCodeCompleteResults =
    ffi.Void Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef DartClang_disposeCodeCompleteResults =
    void Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef NativeClang_codeCompleteGetNumDiagnostics =
    ffi.UnsignedInt Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef DartClang_codeCompleteGetNumDiagnostics =
    int Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef NativeClang_codeCompleteGetDiagnostic =
    CXDiagnostic Function(
      ffi.Pointer<CXCodeCompleteResults> Results,
      ffi.UnsignedInt Index,
    );
typedef DartClang_codeCompleteGetDiagnostic =
    CXDiagnostic Function(
      ffi.Pointer<CXCodeCompleteResults> Results,
      int Index,
    );
typedef NativeClang_codeCompleteGetContexts =
    ffi.UnsignedLongLong Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef DartClang_codeCompleteGetContexts =
    int Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef NativeClang_codeCompleteGetContainerKind =
    ffi.UnsignedInt Function(
      ffi.Pointer<CXCodeCompleteResults> Results,
      ffi.Pointer<ffi.UnsignedInt> IsIncomplete,
    );
typedef DartClang_codeCompleteGetContainerKind =
    int Function(
      ffi.Pointer<CXCodeCompleteResults> Results,
      ffi.Pointer<ffi.UnsignedInt> IsIncomplete,
    );
typedef NativeClang_codeCompleteGetContainerUSR =
    CXString Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef DartClang_codeCompleteGetContainerUSR =
    CXString Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef NativeClang_codeCompleteGetObjCSelector =
    CXString Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef DartClang_codeCompleteGetObjCSelector =
    CXString Function(ffi.Pointer<CXCodeCompleteResults> Results);
typedef NativeClang_getClangVersion = CXString Function();
typedef DartClang_getClangVersion = CXString Function();
typedef NativeClang_toggleCrashRecovery =
    ffi.Void Function(ffi.UnsignedInt isEnabled);
typedef DartClang_toggleCrashRecovery = void Function(int isEnabled);
typedef CXInclusionVisitorFunction =
    ffi.Void Function(
      CXFile included_file,
      ffi.Pointer<CXSourceLocation> inclusion_stack,
      ffi.UnsignedInt include_len,
      CXClientData client_data,
    );
typedef DartCXInclusionVisitorFunction =
    void Function(
      CXFile included_file,
      ffi.Pointer<CXSourceLocation> inclusion_stack,
      int include_len,
      CXClientData client_data,
    );

/// Visitor invoked for each file in a translation unit
/// (used with clang_getInclusions()).
///
/// This visitor function will be invoked by clang_getInclusions() for each
/// file included (either at the top-level or by \#include directives) within
/// a translation unit.  The first argument is the file being included, and
/// the second and third arguments provide the inclusion stack.  The
/// array is sorted in order of immediate inclusion.  For example,
/// the first element refers to the location that included 'included_file'.
typedef CXInclusionVisitor =
    ffi.Pointer<ffi.NativeFunction<CXInclusionVisitorFunction>>;
typedef NativeClang_getInclusions =
    ffi.Void Function(
      CXTranslationUnit tu,
      CXInclusionVisitor visitor,
      CXClientData client_data,
    );
typedef DartClang_getInclusions =
    void Function(
      CXTranslationUnit tu,
      CXInclusionVisitor visitor,
      CXClientData client_data,
    );

enum CXEvalResultKind {
  CXEval_Int(1),
  CXEval_Float(2),
  CXEval_ObjCStrLiteral(3),
  CXEval_StrLiteral(4),
  CXEval_CFStr(5),
  CXEval_Other(6),
  CXEval_UnExposed(0);

  final int value;
  const CXEvalResultKind(this.value);

  static CXEvalResultKind fromValue(int value) => switch (value) {
    1 => CXEval_Int,
    2 => CXEval_Float,
    3 => CXEval_ObjCStrLiteral,
    4 => CXEval_StrLiteral,
    5 => CXEval_CFStr,
    6 => CXEval_Other,
    0 => CXEval_UnExposed,
    _ => throw ArgumentError('Unknown value for CXEvalResultKind: $value'),
  };
}

/// Evaluation result of a cursor
typedef CXEvalResult = ffi.Pointer<ffi.Void>;
typedef NativeClang_Cursor_Evaluate = CXEvalResult Function(CXCursor C);
typedef DartClang_Cursor_Evaluate = CXEvalResult Function(CXCursor C);
typedef NativeClang_EvalResult_getKind =
    ffi.UnsignedInt Function(CXEvalResult E);
typedef DartClang_EvalResult_getKind = int Function(CXEvalResult E);
typedef NativeClang_EvalResult_getAsInt = ffi.Int Function(CXEvalResult E);
typedef DartClang_EvalResult_getAsInt = int Function(CXEvalResult E);
typedef NativeClang_EvalResult_getAsLongLong =
    ffi.LongLong Function(CXEvalResult E);
typedef DartClang_EvalResult_getAsLongLong = int Function(CXEvalResult E);
typedef NativeClang_EvalResult_isUnsignedInt =
    ffi.UnsignedInt Function(CXEvalResult E);
typedef DartClang_EvalResult_isUnsignedInt = int Function(CXEvalResult E);
typedef NativeClang_EvalResult_getAsUnsigned =
    ffi.UnsignedLongLong Function(CXEvalResult E);
typedef DartClang_EvalResult_getAsUnsigned = int Function(CXEvalResult E);
typedef NativeClang_EvalResult_getAsDouble =
    ffi.Double Function(CXEvalResult E);
typedef DartClang_EvalResult_getAsDouble = double Function(CXEvalResult E);
typedef NativeClang_EvalResult_getAsStr =
    ffi.Pointer<ffi.Char> Function(CXEvalResult E);
typedef DartClang_EvalResult_getAsStr =
    ffi.Pointer<ffi.Char> Function(CXEvalResult E);
typedef NativeClang_EvalResult_dispose = ffi.Void Function(CXEvalResult E);
typedef DartClang_EvalResult_dispose = void Function(CXEvalResult E);

/// A remapping of original source files and their translated files.
typedef CXRemapping = ffi.Pointer<ffi.Void>;
typedef NativeClang_getRemappings =
    CXRemapping Function(ffi.Pointer<ffi.Char> path);
typedef DartClang_getRemappings =
    CXRemapping Function(ffi.Pointer<ffi.Char> path);
typedef NativeClang_getRemappingsFromFileList =
    CXRemapping Function(
      ffi.Pointer<ffi.Pointer<ffi.Char>> filePaths,
      ffi.UnsignedInt numFiles,
    );
typedef DartClang_getRemappingsFromFileList =
    CXRemapping Function(
      ffi.Pointer<ffi.Pointer<ffi.Char>> filePaths,
      int numFiles,
    );
typedef NativeClang_remap_getNumFiles = ffi.UnsignedInt Function(CXRemapping);
typedef DartClang_remap_getNumFiles = int Function(CXRemapping);
typedef NativeClang_remap_getFilenames =
    ffi.Void Function(
      CXRemapping,
      ffi.UnsignedInt index,
      ffi.Pointer<CXString> original,
      ffi.Pointer<CXString> transformed,
    );
typedef DartClang_remap_getFilenames =
    void Function(
      CXRemapping,
      int index,
      ffi.Pointer<CXString> original,
      ffi.Pointer<CXString> transformed,
    );
typedef NativeClang_remap_dispose = ffi.Void Function(CXRemapping);
typedef DartClang_remap_dispose = void Function(CXRemapping);

/// \defgroup CINDEX_HIGH Higher level API functions
///
/// @{
enum CXVisitorResult {
  CXVisit_Break(0),
  CXVisit_Continue(1);

  final int value;
  const CXVisitorResult(this.value);

  static CXVisitorResult fromValue(int value) => switch (value) {
    0 => CXVisit_Break,
    1 => CXVisit_Continue,
    _ => throw ArgumentError('Unknown value for CXVisitorResult: $value'),
  };
}

final class CXCursorAndRangeVisitor extends ffi.Struct {
  external ffi.Pointer<ffi.Void> context;

  external ffi.Pointer<
    ffi.NativeFunction<
      ffi.UnsignedInt Function(ffi.Pointer<ffi.Void>, CXCursor, CXSourceRange)
    >
  >
  visit;
}

enum CXResult {
  /// Function returned successfully.
  CXResult_Success(0),

  /// One of the parameters was invalid for the function.
  CXResult_Invalid(1),

  /// The function was terminated by a callback (e.g. it returned
  /// CXVisit_Break)
  CXResult_VisitBreak(2);

  final int value;
  const CXResult(this.value);

  static CXResult fromValue(int value) => switch (value) {
    0 => CXResult_Success,
    1 => CXResult_Invalid,
    2 => CXResult_VisitBreak,
    _ => throw ArgumentError('Unknown value for CXResult: $value'),
  };
}

typedef NativeClang_findReferencesInFile =
    ffi.UnsignedInt Function(
      CXCursor cursor,
      CXFile file,
      CXCursorAndRangeVisitor visitor,
    );
typedef DartClang_findReferencesInFile =
    int Function(CXCursor cursor, CXFile file, CXCursorAndRangeVisitor visitor);
typedef NativeClang_findIncludesInFile =
    ffi.UnsignedInt Function(
      CXTranslationUnit TU,
      CXFile file,
      CXCursorAndRangeVisitor visitor,
    );
typedef DartClang_findIncludesInFile =
    int Function(
      CXTranslationUnit TU,
      CXFile file,
      CXCursorAndRangeVisitor visitor,
    );

/// The client's data object that is associated with a CXFile.
typedef CXIdxClientFile = ffi.Pointer<ffi.Void>;

/// The client's data object that is associated with a semantic entity.
typedef CXIdxClientEntity = ffi.Pointer<ffi.Void>;

/// The client's data object that is associated with a semantic container
/// of entities.
typedef CXIdxClientContainer = ffi.Pointer<ffi.Void>;

/// The client's data object that is associated with an AST file (PCH
/// or module).
typedef CXIdxClientASTFile = ffi.Pointer<ffi.Void>;

/// Source location passed to index callbacks.
final class CXIdxLoc extends ffi.Struct {
  @ffi.Array.multi([2])
  external ffi.Array<ffi.Pointer<ffi.Void>> ptr_data;

  @ffi.UnsignedInt()
  external int int_data;
}

/// Data for ppIncludedFile callback.
final class CXIdxIncludedFileInfo extends ffi.Struct {
  /// Location of '#' in the \#include/\#import directive.
  external CXIdxLoc hashLoc;

  /// Filename as written in the \#include/\#import directive.
  external ffi.Pointer<ffi.Char> filename;

  /// The actual file that the \#include/\#import directive resolved to.
  external CXFile file;

  @ffi.Int()
  external int isImport;

  @ffi.Int()
  external int isAngled;

  /// Non-zero if the directive was automatically turned into a module
  /// import.
  @ffi.Int()
  external int isModuleImport;
}

/// Data for IndexerCallbacks#importedASTFile.
final class CXIdxImportedASTFileInfo extends ffi.Struct {
  /// Top level AST file containing the imported PCH, module or submodule.
  external CXFile file;

  /// The imported module or NULL if the AST file is a PCH.
  external CXModule module;

  /// Location where the file is imported. Applicable only for modules.
  external CXIdxLoc loc;

  /// Non-zero if an inclusion directive was automatically turned into
  /// a module import. Applicable only for modules.
  @ffi.Int()
  external int isImplicit;
}

enum CXIdxEntityKind {
  CXIdxEntity_Unexposed(0),
  CXIdxEntity_Typedef(1),
  CXIdxEntity_Function(2),
  CXIdxEntity_Variable(3),
  CXIdxEntity_Field(4),
  CXIdxEntity_EnumConstant(5),
  CXIdxEntity_ObjCClass(6),
  CXIdxEntity_ObjCProtocol(7),
  CXIdxEntity_ObjCCategory(8),
  CXIdxEntity_ObjCInstanceMethod(9),
  CXIdxEntity_ObjCClassMethod(10),
  CXIdxEntity_ObjCProperty(11),
  CXIdxEntity_ObjCIvar(12),
  CXIdxEntity_Enum(13),
  CXIdxEntity_Struct(14),
  CXIdxEntity_Union(15),
  CXIdxEntity_CXXClass(16),
  CXIdxEntity_CXXNamespace(17),
  CXIdxEntity_CXXNamespaceAlias(18),
  CXIdxEntity_CXXStaticVariable(19),
  CXIdxEntity_CXXStaticMethod(20),
  CXIdxEntity_CXXInstanceMethod(21),
  CXIdxEntity_CXXConstructor(22),
  CXIdxEntity_CXXDestructor(23),
  CXIdxEntity_CXXConversionFunction(24),
  CXIdxEntity_CXXTypeAlias(25),
  CXIdxEntity_CXXInterface(26);

  final int value;
  const CXIdxEntityKind(this.value);

  static CXIdxEntityKind fromValue(int value) => switch (value) {
    0 => CXIdxEntity_Unexposed,
    1 => CXIdxEntity_Typedef,
    2 => CXIdxEntity_Function,
    3 => CXIdxEntity_Variable,
    4 => CXIdxEntity_Field,
    5 => CXIdxEntity_EnumConstant,
    6 => CXIdxEntity_ObjCClass,
    7 => CXIdxEntity_ObjCProtocol,
    8 => CXIdxEntity_ObjCCategory,
    9 => CXIdxEntity_ObjCInstanceMethod,
    10 => CXIdxEntity_ObjCClassMethod,
    11 => CXIdxEntity_ObjCProperty,
    12 => CXIdxEntity_ObjCIvar,
    13 => CXIdxEntity_Enum,
    14 => CXIdxEntity_Struct,
    15 => CXIdxEntity_Union,
    16 => CXIdxEntity_CXXClass,
    17 => CXIdxEntity_CXXNamespace,
    18 => CXIdxEntity_CXXNamespaceAlias,
    19 => CXIdxEntity_CXXStaticVariable,
    20 => CXIdxEntity_CXXStaticMethod,
    21 => CXIdxEntity_CXXInstanceMethod,
    22 => CXIdxEntity_CXXConstructor,
    23 => CXIdxEntity_CXXDestructor,
    24 => CXIdxEntity_CXXConversionFunction,
    25 => CXIdxEntity_CXXTypeAlias,
    26 => CXIdxEntity_CXXInterface,
    _ => throw ArgumentError('Unknown value for CXIdxEntityKind: $value'),
  };
}

enum CXIdxEntityLanguage {
  CXIdxEntityLang_None(0),
  CXIdxEntityLang_C(1),
  CXIdxEntityLang_ObjC(2),
  CXIdxEntityLang_CXX(3),
  CXIdxEntityLang_Swift(4);

  final int value;
  const CXIdxEntityLanguage(this.value);

  static CXIdxEntityLanguage fromValue(int value) => switch (value) {
    0 => CXIdxEntityLang_None,
    1 => CXIdxEntityLang_C,
    2 => CXIdxEntityLang_ObjC,
    3 => CXIdxEntityLang_CXX,
    4 => CXIdxEntityLang_Swift,
    _ => throw ArgumentError('Unknown value for CXIdxEntityLanguage: $value'),
  };
}

/// Extra C++ template information for an entity. This can apply to:
/// CXIdxEntity_Function
/// CXIdxEntity_CXXClass
/// CXIdxEntity_CXXStaticMethod
/// CXIdxEntity_CXXInstanceMethod
/// CXIdxEntity_CXXConstructor
/// CXIdxEntity_CXXConversionFunction
/// CXIdxEntity_CXXTypeAlias
enum CXIdxEntityCXXTemplateKind {
  CXIdxEntity_NonTemplate(0),
  CXIdxEntity_Template(1),
  CXIdxEntity_TemplatePartialSpecialization(2),
  CXIdxEntity_TemplateSpecialization(3);

  final int value;
  const CXIdxEntityCXXTemplateKind(this.value);

  static CXIdxEntityCXXTemplateKind fromValue(int value) => switch (value) {
    0 => CXIdxEntity_NonTemplate,
    1 => CXIdxEntity_Template,
    2 => CXIdxEntity_TemplatePartialSpecialization,
    3 => CXIdxEntity_TemplateSpecialization,
    _ => throw ArgumentError(
      'Unknown value for CXIdxEntityCXXTemplateKind: $value',
    ),
  };
}

enum CXIdxAttrKind {
  CXIdxAttr_Unexposed(0),
  CXIdxAttr_IBAction(1),
  CXIdxAttr_IBOutlet(2),
  CXIdxAttr_IBOutletCollection(3);

  final int value;
  const CXIdxAttrKind(this.value);

  static CXIdxAttrKind fromValue(int value) => switch (value) {
    0 => CXIdxAttr_Unexposed,
    1 => CXIdxAttr_IBAction,
    2 => CXIdxAttr_IBOutlet,
    3 => CXIdxAttr_IBOutletCollection,
    _ => throw ArgumentError('Unknown value for CXIdxAttrKind: $value'),
  };
}

final class CXIdxAttrInfo extends ffi.Struct {
  @ffi.UnsignedInt()
  external int kindAsInt;

  CXIdxAttrKind get kind => CXIdxAttrKind.fromValue(kindAsInt);

  external CXCursor cursor;

  external CXIdxLoc loc;
}

final class CXIdxEntityInfo extends ffi.Struct {
  @ffi.UnsignedInt()
  external int kindAsInt;

  CXIdxEntityKind get kind => CXIdxEntityKind.fromValue(kindAsInt);

  @ffi.UnsignedInt()
  external int templateKindAsInt;

  CXIdxEntityCXXTemplateKind get templateKind =>
      CXIdxEntityCXXTemplateKind.fromValue(templateKindAsInt);

  @ffi.UnsignedInt()
  external int langAsInt;

  CXIdxEntityLanguage get lang => CXIdxEntityLanguage.fromValue(langAsInt);

  external ffi.Pointer<ffi.Char> name;

  external ffi.Pointer<ffi.Char> USR;

  external CXCursor cursor;

  external ffi.Pointer<ffi.Pointer<CXIdxAttrInfo>> attributes;

  @ffi.UnsignedInt()
  external int numAttributes;
}

final class CXIdxContainerInfo extends ffi.Struct {
  external CXCursor cursor;
}

final class CXIdxIBOutletCollectionAttrInfo extends ffi.Struct {
  external ffi.Pointer<CXIdxAttrInfo> attrInfo;

  external ffi.Pointer<CXIdxEntityInfo> objcClass;

  external CXCursor classCursor;

  external CXIdxLoc classLoc;
}

final class CXIdxDeclInfo extends ffi.Struct {
  external ffi.Pointer<CXIdxEntityInfo> entityInfo;

  external CXCursor cursor;

  external CXIdxLoc loc;

  external ffi.Pointer<CXIdxContainerInfo> semanticContainer;

  /// Generally same as #semanticContainer but can be different in
  /// cases like out-of-line C++ member functions.
  external ffi.Pointer<CXIdxContainerInfo> lexicalContainer;

  @ffi.Int()
  external int isRedeclaration;

  @ffi.Int()
  external int isDefinition;

  @ffi.Int()
  external int isContainer;

  external ffi.Pointer<CXIdxContainerInfo> declAsContainer;

  /// Whether the declaration exists in code or was created implicitly
  /// by the compiler, e.g. implicit Objective-C methods for properties.
  @ffi.Int()
  external int isImplicit;

  external ffi.Pointer<ffi.Pointer<CXIdxAttrInfo>> attributes;

  @ffi.UnsignedInt()
  external int numAttributes;

  @ffi.UnsignedInt()
  external int flags;
}

enum CXIdxObjCContainerKind {
  CXIdxObjCContainer_ForwardRef(0),
  CXIdxObjCContainer_Interface(1),
  CXIdxObjCContainer_Implementation(2);

  final int value;
  const CXIdxObjCContainerKind(this.value);

  static CXIdxObjCContainerKind fromValue(int value) => switch (value) {
    0 => CXIdxObjCContainer_ForwardRef,
    1 => CXIdxObjCContainer_Interface,
    2 => CXIdxObjCContainer_Implementation,
    _ => throw ArgumentError(
      'Unknown value for CXIdxObjCContainerKind: $value',
    ),
  };
}

final class CXIdxObjCContainerDeclInfo extends ffi.Struct {
  external ffi.Pointer<CXIdxDeclInfo> declInfo;

  @ffi.UnsignedInt()
  external int kindAsInt;

  CXIdxObjCContainerKind get kind =>
      CXIdxObjCContainerKind.fromValue(kindAsInt);
}

final class CXIdxBaseClassInfo extends ffi.Struct {
  external ffi.Pointer<CXIdxEntityInfo> base;

  external CXCursor cursor;

  external CXIdxLoc loc;
}

final class CXIdxObjCProtocolRefInfo extends ffi.Struct {
  external ffi.Pointer<CXIdxEntityInfo> protocol;

  external CXCursor cursor;

  external CXIdxLoc loc;
}

final class CXIdxObjCProtocolRefListInfo extends ffi.Struct {
  external ffi.Pointer<ffi.Pointer<CXIdxObjCProtocolRefInfo>> protocols;

  @ffi.UnsignedInt()
  external int numProtocols;
}

final class CXIdxObjCInterfaceDeclInfo extends ffi.Struct {
  external ffi.Pointer<CXIdxObjCContainerDeclInfo> containerInfo;

  external ffi.Pointer<CXIdxBaseClassInfo> superInfo;

  external ffi.Pointer<CXIdxObjCProtocolRefListInfo> protocols;
}

final class CXIdxObjCCategoryDeclInfo extends ffi.Struct {
  external ffi.Pointer<CXIdxObjCContainerDeclInfo> containerInfo;

  external ffi.Pointer<CXIdxEntityInfo> objcClass;

  external CXCursor classCursor;

  external CXIdxLoc classLoc;

  external ffi.Pointer<CXIdxObjCProtocolRefListInfo> protocols;
}

final class CXIdxObjCPropertyDeclInfo extends ffi.Struct {
  external ffi.Pointer<CXIdxDeclInfo> declInfo;

  external ffi.Pointer<CXIdxEntityInfo> getter;

  external ffi.Pointer<CXIdxEntityInfo> setter;
}

final class CXIdxCXXClassDeclInfo extends ffi.Struct {
  external ffi.Pointer<CXIdxDeclInfo> declInfo;

  external ffi.Pointer<ffi.Pointer<CXIdxBaseClassInfo>> bases;

  @ffi.UnsignedInt()
  external int numBases;
}

/// Data for IndexerCallbacks#indexEntityReference.
///
/// This may be deprecated in a future version as this duplicates
/// the \c CXSymbolRole_Implicit bit in \c CXSymbolRole.
enum CXIdxEntityRefKind {
  /// The entity is referenced directly in user's code.
  CXIdxEntityRef_Direct(1),

  /// An implicit reference, e.g. a reference of an Objective-C method
  /// via the dot syntax.
  CXIdxEntityRef_Implicit(2);

  final int value;
  const CXIdxEntityRefKind(this.value);

  static CXIdxEntityRefKind fromValue(int value) => switch (value) {
    1 => CXIdxEntityRef_Direct,
    2 => CXIdxEntityRef_Implicit,
    _ => throw ArgumentError('Unknown value for CXIdxEntityRefKind: $value'),
  };
}

/// Roles that are attributed to symbol occurrences.
///
/// Internal: this currently mirrors low 9 bits of clang::index::SymbolRole with
/// higher bits zeroed. These high bits may be exposed in the future.
enum CXSymbolRole {
  CXSymbolRole_None(0),
  CXSymbolRole_Declaration(1),
  CXSymbolRole_Definition(2),
  CXSymbolRole_Reference(4),
  CXSymbolRole_Read(8),
  CXSymbolRole_Write(16),
  CXSymbolRole_Call(32),
  CXSymbolRole_Dynamic(64),
  CXSymbolRole_AddressOf(128),
  CXSymbolRole_Implicit(256);

  final int value;
  const CXSymbolRole(this.value);

  static CXSymbolRole fromValue(int value) => switch (value) {
    0 => CXSymbolRole_None,
    1 => CXSymbolRole_Declaration,
    2 => CXSymbolRole_Definition,
    4 => CXSymbolRole_Reference,
    8 => CXSymbolRole_Read,
    16 => CXSymbolRole_Write,
    32 => CXSymbolRole_Call,
    64 => CXSymbolRole_Dynamic,
    128 => CXSymbolRole_AddressOf,
    256 => CXSymbolRole_Implicit,
    _ => throw ArgumentError('Unknown value for CXSymbolRole: $value'),
  };
}

/// Data for IndexerCallbacks#indexEntityReference.
final class CXIdxEntityRefInfo extends ffi.Struct {
  @ffi.UnsignedInt()
  external int kindAsInt;

  CXIdxEntityRefKind get kind => CXIdxEntityRefKind.fromValue(kindAsInt);

  /// Reference cursor.
  external CXCursor cursor;

  external CXIdxLoc loc;

  /// The entity that gets referenced.
  external ffi.Pointer<CXIdxEntityInfo> referencedEntity;

  /// Immediate "parent" of the reference. For example:
  ///
  /// \code
  /// Foo *var;
  /// \endcode
  ///
  /// The parent of reference of type 'Foo' is the variable 'var'.
  /// For references inside statement bodies of functions/methods,
  /// the parentEntity will be the function/method.
  external ffi.Pointer<CXIdxEntityInfo> parentEntity;

  /// Lexical container context of the reference.
  external ffi.Pointer<CXIdxContainerInfo> container;

  /// Sets of symbol roles of the reference.
  @ffi.UnsignedInt()
  external int roleAsInt;

  CXSymbolRole get role => CXSymbolRole.fromValue(roleAsInt);
}

/// A group of callbacks used by #clang_indexSourceFile and
/// #clang_indexTranslationUnit.
final class IndexerCallbacks extends ffi.Struct {
  /// Called periodically to check whether indexing should be aborted.
  /// Should return 0 to continue, and non-zero to abort.
  external ffi.Pointer<
    ffi.NativeFunction<
      ffi.Int Function(CXClientData client_data, ffi.Pointer<ffi.Void> reserved)
    >
  >
  abortQuery;

  /// Called at the end of indexing; passes the complete diagnostic set.
  external ffi.Pointer<
    ffi.NativeFunction<
      ffi.Void Function(CXClientData, CXDiagnosticSet, ffi.Pointer<ffi.Void>)
    >
  >
  diagnostic;

  external ffi.Pointer<
    ffi.NativeFunction<
      CXIdxClientFile Function(
        CXClientData client_data,
        CXFile mainFile,
        ffi.Pointer<ffi.Void> reserved,
      )
    >
  >
  enteredMainFile;

  /// Called when a file gets \#included/\#imported.
  external ffi.Pointer<
    ffi.NativeFunction<
      CXIdxClientFile Function(CXClientData, ffi.Pointer<CXIdxIncludedFileInfo>)
    >
  >
  ppIncludedFile;

  /// Called when a AST file (PCH or module) gets imported.
  ///
  /// AST files will not get indexed (there will not be callbacks to index all
  /// the entities in an AST file). The recommended action is that, if the AST
  /// file is not already indexed, to initiate a new indexing job specific to
  /// the AST file.
  external ffi.Pointer<
    ffi.NativeFunction<
      CXIdxClientASTFile Function(
        CXClientData,
        ffi.Pointer<CXIdxImportedASTFileInfo>,
      )
    >
  >
  importedASTFile;

  /// Called at the beginning of indexing a translation unit.
  external ffi.Pointer<
    ffi.NativeFunction<
      CXIdxClientContainer Function(
        CXClientData client_data,
        ffi.Pointer<ffi.Void> reserved,
      )
    >
  >
  startedTranslationUnit;

  external ffi.Pointer<
    ffi.NativeFunction<
      ffi.Void Function(CXClientData, ffi.Pointer<CXIdxDeclInfo>)
    >
  >
  indexDeclaration;

  /// Called to index a reference of an entity.
  external ffi.Pointer<
    ffi.NativeFunction<
      ffi.Void Function(CXClientData, ffi.Pointer<CXIdxEntityRefInfo>)
    >
  >
  indexEntityReference;
}

typedef NativeClang_index_isEntityObjCContainerKind =
    ffi.Int Function(ffi.UnsignedInt);
typedef DartClang_index_isEntityObjCContainerKind = int Function(int);
typedef NativeClang_index_getObjCContainerDeclInfo =
    ffi.Pointer<CXIdxObjCContainerDeclInfo> Function(
      ffi.Pointer<CXIdxDeclInfo>,
    );
typedef DartClang_index_getObjCContainerDeclInfo =
    ffi.Pointer<CXIdxObjCContainerDeclInfo> Function(
      ffi.Pointer<CXIdxDeclInfo>,
    );
typedef NativeClang_index_getObjCInterfaceDeclInfo =
    ffi.Pointer<CXIdxObjCInterfaceDeclInfo> Function(
      ffi.Pointer<CXIdxDeclInfo>,
    );
typedef DartClang_index_getObjCInterfaceDeclInfo =
    ffi.Pointer<CXIdxObjCInterfaceDeclInfo> Function(
      ffi.Pointer<CXIdxDeclInfo>,
    );
typedef NativeClang_index_getObjCCategoryDeclInfo =
    ffi.Pointer<CXIdxObjCCategoryDeclInfo> Function(ffi.Pointer<CXIdxDeclInfo>);
typedef DartClang_index_getObjCCategoryDeclInfo =
    ffi.Pointer<CXIdxObjCCategoryDeclInfo> Function(ffi.Pointer<CXIdxDeclInfo>);
typedef NativeClang_index_getObjCProtocolRefListInfo =
    ffi.Pointer<CXIdxObjCProtocolRefListInfo> Function(
      ffi.Pointer<CXIdxDeclInfo>,
    );
typedef DartClang_index_getObjCProtocolRefListInfo =
    ffi.Pointer<CXIdxObjCProtocolRefListInfo> Function(
      ffi.Pointer<CXIdxDeclInfo>,
    );
typedef NativeClang_index_getObjCPropertyDeclInfo =
    ffi.Pointer<CXIdxObjCPropertyDeclInfo> Function(ffi.Pointer<CXIdxDeclInfo>);
typedef DartClang_index_getObjCPropertyDeclInfo =
    ffi.Pointer<CXIdxObjCPropertyDeclInfo> Function(ffi.Pointer<CXIdxDeclInfo>);
typedef NativeClang_index_getIBOutletCollectionAttrInfo =
    ffi.Pointer<CXIdxIBOutletCollectionAttrInfo> Function(
      ffi.Pointer<CXIdxAttrInfo>,
    );
typedef DartClang_index_getIBOutletCollectionAttrInfo =
    ffi.Pointer<CXIdxIBOutletCollectionAttrInfo> Function(
      ffi.Pointer<CXIdxAttrInfo>,
    );
typedef NativeClang_index_getCXXClassDeclInfo =
    ffi.Pointer<CXIdxCXXClassDeclInfo> Function(ffi.Pointer<CXIdxDeclInfo>);
typedef DartClang_index_getCXXClassDeclInfo =
    ffi.Pointer<CXIdxCXXClassDeclInfo> Function(ffi.Pointer<CXIdxDeclInfo>);
typedef NativeClang_index_getClientContainer =
    CXIdxClientContainer Function(ffi.Pointer<CXIdxContainerInfo>);
typedef DartClang_index_getClientContainer =
    CXIdxClientContainer Function(ffi.Pointer<CXIdxContainerInfo>);
typedef NativeClang_index_setClientContainer =
    ffi.Void Function(ffi.Pointer<CXIdxContainerInfo>, CXIdxClientContainer);
typedef DartClang_index_setClientContainer =
    void Function(ffi.Pointer<CXIdxContainerInfo>, CXIdxClientContainer);
typedef NativeClang_index_getClientEntity =
    CXIdxClientEntity Function(ffi.Pointer<CXIdxEntityInfo>);
typedef DartClang_index_getClientEntity =
    CXIdxClientEntity Function(ffi.Pointer<CXIdxEntityInfo>);
typedef NativeClang_index_setClientEntity =
    ffi.Void Function(ffi.Pointer<CXIdxEntityInfo>, CXIdxClientEntity);
typedef DartClang_index_setClientEntity =
    void Function(ffi.Pointer<CXIdxEntityInfo>, CXIdxClientEntity);

/// An indexing action/session, to be applied to one or multiple
/// translation units.
typedef CXIndexAction = ffi.Pointer<ffi.Void>;
typedef NativeClang_IndexAction_create = CXIndexAction Function(CXIndex CIdx);
typedef DartClang_IndexAction_create = CXIndexAction Function(CXIndex CIdx);
typedef NativeClang_IndexAction_dispose = ffi.Void Function(CXIndexAction);
typedef DartClang_IndexAction_dispose = void Function(CXIndexAction);
typedef NativeClang_indexSourceFile =
    ffi.Int Function(
      CXIndexAction,
      CXClientData client_data,
      ffi.Pointer<IndexerCallbacks> index_callbacks,
      ffi.UnsignedInt index_callbacks_size,
      ffi.UnsignedInt index_options,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      ffi.Int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      ffi.UnsignedInt num_unsaved_files,
      ffi.Pointer<CXTranslationUnit> out_TU,
      ffi.UnsignedInt TU_options,
    );
typedef DartClang_indexSourceFile =
    int Function(
      CXIndexAction,
      CXClientData client_data,
      ffi.Pointer<IndexerCallbacks> index_callbacks,
      int index_callbacks_size,
      int index_options,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      int num_unsaved_files,
      ffi.Pointer<CXTranslationUnit> out_TU,
      int TU_options,
    );
typedef NativeClang_indexSourceFileFullArgv =
    ffi.Int Function(
      CXIndexAction,
      CXClientData client_data,
      ffi.Pointer<IndexerCallbacks> index_callbacks,
      ffi.UnsignedInt index_callbacks_size,
      ffi.UnsignedInt index_options,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      ffi.Int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      ffi.UnsignedInt num_unsaved_files,
      ffi.Pointer<CXTranslationUnit> out_TU,
      ffi.UnsignedInt TU_options,
    );
typedef DartClang_indexSourceFileFullArgv =
    int Function(
      CXIndexAction,
      CXClientData client_data,
      ffi.Pointer<IndexerCallbacks> index_callbacks,
      int index_callbacks_size,
      int index_options,
      ffi.Pointer<ffi.Char> source_filename,
      ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
      int num_command_line_args,
      ffi.Pointer<CXUnsavedFile> unsaved_files,
      int num_unsaved_files,
      ffi.Pointer<CXTranslationUnit> out_TU,
      int TU_options,
    );
typedef NativeClang_indexTranslationUnit =
    ffi.Int Function(
      CXIndexAction,
      CXClientData client_data,
      ffi.Pointer<IndexerCallbacks> index_callbacks,
      ffi.UnsignedInt index_callbacks_size,
      ffi.UnsignedInt index_options,
      CXTranslationUnit,
    );
typedef DartClang_indexTranslationUnit =
    int Function(
      CXIndexAction,
      CXClientData client_data,
      ffi.Pointer<IndexerCallbacks> index_callbacks,
      int index_callbacks_size,
      int index_options,
      CXTranslationUnit,
    );
typedef NativeClang_indexLoc_getFileLocation =
    ffi.Void Function(
      CXIdxLoc loc,
      ffi.Pointer<CXIdxClientFile> indexFile,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef DartClang_indexLoc_getFileLocation =
    void Function(
      CXIdxLoc loc,
      ffi.Pointer<CXIdxClientFile> indexFile,
      ffi.Pointer<CXFile> file,
      ffi.Pointer<ffi.UnsignedInt> line,
      ffi.Pointer<ffi.UnsignedInt> column,
      ffi.Pointer<ffi.UnsignedInt> offset,
    );
typedef NativeClang_indexLoc_getCXSourceLocation =
    CXSourceLocation Function(CXIdxLoc loc);
typedef DartClang_indexLoc_getCXSourceLocation =
    CXSourceLocation Function(CXIdxLoc loc);
typedef CXFieldVisitorFunction =
    ffi.UnsignedInt Function(CXCursor C, CXClientData client_data);
typedef DartCXFieldVisitorFunction =
    CXVisitorResult Function(CXCursor C, CXClientData client_data);

/// Visitor invoked for each field found by a traversal.
///
/// This visitor function will be invoked for each field found by
/// \c clang_Type_visitFields. Its first argument is the cursor being
/// visited, its second argument is the client data provided to
/// \c clang_Type_visitFields.
///
/// The visitor should return one of the \c CXVisitorResult values
/// to direct \c clang_Type_visitFields.
typedef CXFieldVisitor =
    ffi.Pointer<ffi.NativeFunction<CXFieldVisitorFunction>>;
typedef NativeClang_Type_visitFields =
    ffi.UnsignedInt Function(
      CXType T,
      CXFieldVisitor visitor,
      CXClientData client_data,
    );
typedef DartClang_Type_visitFields =
    int Function(CXType T, CXFieldVisitor visitor, CXClientData client_data);

const int CINDEX_VERSION_MAJOR = 0;

const int CINDEX_VERSION_MINOR = 59;

const int CINDEX_VERSION = 59;

const String CINDEX_VERSION_STRING = '0.59';
