# stb_image

This project is a minimal, cross-platform demonstration of how to use Dart's
[build hooks][], with code assets and `dart:ffi` to call a simple function from a
popular C library. This project uses `stbi_info` from the `stb_image.h` library
to read an image's dimensions and color channels without loading the entire file
into memory.

[build hooks]: https://dart.dev/tools/hooks

## How it works

The native code is built by the [`hook/build.dart`](hook/build.dart), which is
run by the Dart SDK CLI tools. This build hook compiles the C code from
[`third_party/stb_image.c`](third_party/stb_image.c) into a dynamic library.

The Dart FFI bindings to the C code are generated by
[`tool/ffigen.dart`](tool/ffigen.dart). FFIgen generates Dart FFI bindings from
[`third_party/stb_image.h`](third_party/stb_image.h) into [`lib/src/third_party/stb_image.g.dart`](lib/src/third_party/stb_image.g.dart).

The Dart code in [`lib/stb_image.dart`](lib/stb_image.dart) uses the
generated FFI bindings to provide a Dart API (not exposing any C types).
