# sqlite_prebuilt

An example for `package:code_assets` demonstrating how to bundle a pre-built
sqlite3 dynamic library from the host system. (See [../sqlite](../sqlite) for
an example that builds the dynamic library from source.)

This project is a minimal, cross-platform demonstration of how to use Dart's
[build hooks][], with code assets and `dart:ffi` to call a simple function from a
popular C library. This project uses `sqlite3_libversion` from the `sqlite3` library.

The SQLite source (amalgamation) and prebuilt binaries for Windows can be found
on https://www.sqlite.org/download.html.

[build hooks]: https://dart.dev/tools/hooks

## How it works

The native code is downloaded or located on the host machine by the
[`hook/build.dart`](hook/build.dart), which is run by the Dart SDK CLI tools.
This build hook downloads a pre-built sqlite3 dynamic library for Windows, it
expects sqlite to be installed via HomeBrew on MacOS, and looks for the default
system location on Linux.

The Dart FFI bindings to the C code are generated by
[`tool/ffigen.dart`](tool/ffigen.dart). FFIgen generates Dart FFI bindings from
[`third_party/sqlite/sqlite3.h`](third_party/sqlite/sqlite3.h) into
[`lib/src/third_party/sqlite3.g.dart`](lib/src/third_party/sqlite3.g.dart).

The Dart code in [`lib/src/sqlite_prebuilt.dart`](lib/src/sqlite_prebuilt.dart)
uses the generated FFI bindings to provide a Dart API (not exposing any C
types) for the users of this package.
