# sqlite

An example for `package:code_assets` demonstrating how to bundle a locally built
sqlite3 dynamic library.  (See [../sqlite_prebuilt](../sqlite_prebuilt) for an
example that that uses a prebuilt dynamic library.)

This project is a minimal, cross-platform demonstration of how to use Dart's
[build hooks][], with code assets and `dart:ffi` to call a simple function from a
popular C library. This project uses `sqlite3_libversion` from the `sqlite3`
library.

The SQLite source (amalgamation) can be found on
https://www.sqlite.org/download.html.

[build hooks]: https://dart.dev/tools/hooks

## How it works

The native code is built by the [`hook/build.dart`](hook/build.dart), which is
run by the Dart SDK CLI tools. This build hook compiles the C code from
[`third_party/sqlite/sqlite3.c`](third_party/sqlite/sqlite3.c) into a dynamic library.

The Dart FFI bindings to the C code are generated by
[`tool/ffigen.dart`](tool/ffigen.dart). FFIgen generates Dart FFI bindings from
[`third_party/sqlite/sqlite3.h`](third_party/sqlite/sqlite3.h) into
[`lib/src/third_party/sqlite3.g.dart`](lib/src/third_party/sqlite3.g.dart).

The Dart code in [`lib/src/sqlite.dart`](lib/src/sqlite.dart) uses the
generated FFI bindings to provide a Dart API (not exposing any C types) for the
users of this package.
