# mini_audio

This project is a minimal, cross-platform demonstration of how to use Dart's
[build hooks][], with code assets and `dart:ffi` to call a simple function from
a popular C library. This project uses the `miniaudio` library to play audio
files.

[build hooks]: https://dart.dev/tools/hooks

## How it works

The native code is built by the [`hook/build.dart`](hook/build.dart), which is
run by the Dart SDK CLI tools. This build hook compiles the C code from
[`third_party/miniaudio.c`](third_party/miniaudio.c) into a dynamic library.

The Dart FFI bindings to the C code are generated by
[`tool/ffigen.dart`](tool/ffigen.dart). FFIgen generates Dart FFI bindings from
[`third_party/miniaudio.h`](third_party/miniaudio.h) into
[`lib/src/third_party/miniaudio.g.dart`](lib/src/third_party/miniaudio.g.dart).

The Dart code in [`lib/src/mini_audio.dart`](lib/src/mini_audio.dart) uses the
generated FFI bindings to provide a Dart API (not exposing any C types).
