# host_name

A cross-platform Dart package for retrieving the local machine's hostname on
major desktop and mobile platforms.

This project is a minimal, cross-platform demonstration of how to use Dart's
[build hooks][], with code assets and `dart:ffi` to call a simple function from
a system API. This project uses `gethostname` from the system APIs. Note that
Windows has a different system API than the Unix-based systems.

[build hooks]: https://dart.dev/tools/hooks

## How it works

The build hook ([`hook/build.dart`](hook/build.dart)) declares how the system
APIs should be called. On Unix-systems the native code should already be loaded
into the process, and on Windows the system API is available in a `.dll` which
is available on every Windows machine.

The Dart FFI bindings to the C code are generated by
[`tool/ffigen.dart`](tool/ffigen.dart). FFIgen generates Dart FFI bindings from
[`src/unix.h`](src/unix.h) and [`src/windows.h`](src/windows.h) into
[`lib/src/third_party/unix.dart`](lib/src/third_party/unix.dart) and
[`lib/src/third_party/windows.dart`](lib/src/third_party/windows.dart). Note
that the system APIs for Windows are not available on Unix and vice versa.
Hence, `tool/ffigen.dart` _only_ generates the bindings it can. If extra system
APIs are added, FFIgen will need to be re-run on multiple machines. This is
expected with cross-platform system APIs that differ on different platforms.

The Dart code in [`lib/src/host_name.dart`](lib/src/host_name.dart) uses the
generated FFI bindings to provide a Dart API (not exposing any C types).
