// Copyright (c) 2025, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// snippet-start
import 'package:code_assets/code_assets.dart';
import 'package:hooks/hooks.dart';

void main(List<String> args) async {
  await build(args, (input, output) async {
    final packageName = input.packageName;
    final assetPath = input.outputDirectory.resolve('...');

    output.assets.code.add(
      CodeAsset(
        package: packageName,
        name: '...',
        linkMode: DynamicLoadingBundled(),
        file: assetPath,
      ),
    );
  });
}

// snippet-end
