// MIT License
//
// Copyright (c) Microsoft Corporation.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE

// This file has been automatically generated. Please do not edit it manually.
// To regenerate the file, use the script
// "pkg/analysis_server/tool/lsp_spec/generate_all.dart".

// ignore_for_file: constant_identifier_names

import 'dart:convert' show JsonEncoder;

import 'package:collection/collection.dart';
import 'package:language_server_protocol/json_parsing.dart';
import 'package:language_server_protocol/protocol_special.dart';
import 'package:language_server_protocol/protocol_custom_generated.dart';

const jsonEncoder = JsonEncoder.withIndent('    ');

bool _canParseBool(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && value is! bool) {
      reporter.reportError('must be of type bool');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolCallHierarchyOptionsCallHierarchyRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !CallHierarchyOptions.canParse(value, reporter) &&
            !CallHierarchyRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, CallHierarchyOptions, CallHierarchyRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolCodeActionOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool && !CodeActionOptions.canParse(value, reporter))) {
      reporter.reportError('must be of type Either2<bool, CodeActionOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolDeclarationOptionsDeclarationRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !DeclarationOptions.canParse(value, reporter) &&
            !DeclarationRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, DeclarationOptions, DeclarationRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolDefinitionOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool && !DefinitionOptions.canParse(value, reporter))) {
      reporter.reportError('must be of type Either2<bool, DefinitionOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolDocumentColorOptionsDocumentColorRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !DocumentColorOptions.canParse(value, reporter) &&
            !DocumentColorRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, DocumentColorOptions, DocumentColorRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolDocumentFormattingOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !DocumentFormattingOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<bool, DocumentFormattingOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolDocumentHighlightOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !DocumentHighlightOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<bool, DocumentHighlightOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolDocumentRangeFormattingOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !DocumentRangeFormattingOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<bool, DocumentRangeFormattingOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolDocumentSymbolOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool && !DocumentSymbolOptions.canParse(value, reporter))) {
      reporter
          .reportError('must be of type Either2<bool, DocumentSymbolOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolFoldingRangeOptionsFoldingRangeRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !FoldingRangeOptions.canParse(value, reporter) &&
            !FoldingRangeRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, FoldingRangeOptions, FoldingRangeRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolHoverOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool && !HoverOptions.canParse(value, reporter))) {
      reporter.reportError('must be of type Either2<bool, HoverOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolImplementationOptionsImplementationRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !ImplementationOptions.canParse(value, reporter) &&
            !ImplementationRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, ImplementationOptions, ImplementationRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolInlayHintOptionsInlayHintRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !InlayHintOptions.canParse(value, reporter) &&
            !InlayHintRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, InlayHintOptions, InlayHintRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolInlineValueOptionsInlineValueRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !InlineValueOptions.canParse(value, reporter) &&
            !InlineValueRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, InlineValueOptions, InlineValueRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool
    _canParseBoolLinkedEditingRangeOptionsLinkedEditingRangeRegistrationOptions(
        Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
        {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !LinkedEditingRangeOptions.canParse(value, reporter) &&
            !LinkedEditingRangeRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, LinkedEditingRangeOptions, LinkedEditingRangeRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolMonikerOptionsMonikerRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !MonikerOptions.canParse(value, reporter) &&
            !MonikerRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, MonikerOptions, MonikerRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolReferenceOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool && !ReferenceOptions.canParse(value, reporter))) {
      reporter.reportError('must be of type Either2<bool, ReferenceOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolRenameOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool && !RenameOptions.canParse(value, reporter))) {
      reporter.reportError('must be of type Either2<bool, RenameOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolSaveOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool && !SaveOptions.canParse(value, reporter))) {
      reporter.reportError('must be of type Either2<bool, SaveOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolSelectionRangeOptionsSelectionRangeRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !SelectionRangeOptions.canParse(value, reporter) &&
            !SelectionRangeRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, SelectionRangeOptions, SelectionRangeRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolSemanticTokensClientCapabilitiesRequestsFull(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !SemanticTokensClientCapabilitiesRequestsFull.canParse(
                value, reporter))) {
      reporter.reportError(
          'must be of type Either2<bool, SemanticTokensClientCapabilitiesRequestsFull>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolSemanticTokensClientCapabilitiesRequestsRange(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !SemanticTokensClientCapabilitiesRequestsRange.canParse(
                value, reporter))) {
      reporter.reportError(
          'must be of type Either2<bool, SemanticTokensClientCapabilitiesRequestsRange>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolSemanticTokensFullDelta(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !SemanticTokensFullDelta.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<bool, SemanticTokensFullDelta>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolSemanticTokensOptionsRange(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !SemanticTokensOptionsRange.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<bool, SemanticTokensOptionsRange>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolString(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && (value is! bool && value is! String)) {
      reporter.reportError('must be of type Either2<bool, String>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolTypeDefinitionOptionsTypeDefinitionRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !TypeDefinitionOptions.canParse(value, reporter) &&
            !TypeDefinitionRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, TypeDefinitionOptions, TypeDefinitionRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolTypeHierarchyOptionsTypeHierarchyRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool &&
            !TypeHierarchyOptions.canParse(value, reporter) &&
            !TypeHierarchyRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either3<bool, TypeHierarchyOptions, TypeHierarchyRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseBoolWorkspaceSymbolOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! bool && !WorkspaceSymbolOptions.canParse(value, reporter))) {
      reporter
          .reportError('must be of type Either2<bool, WorkspaceSymbolOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCallHierarchyClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CallHierarchyClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCallHierarchyItem(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CallHierarchyItem.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseClientCodeActionKindOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ClientCodeActionKindOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseClientCompletionItemOptionsKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ClientCompletionItemOptionsKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseClientInfo(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ClientInfo.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseClientSemanticTokensRequestOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ClientSemanticTokensRequestOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeActionClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeActionClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeActionClientCapabilitiesCodeActionLiteralSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeActionClientCapabilitiesCodeActionLiteralSupport.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeActionClientCapabilitiesResolveSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeActionClientCapabilitiesResolveSupport.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeActionContext(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeActionContext.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeActionDisabled(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeActionDisabled.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeActionKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeActionKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeActionTriggerKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeActionTriggerKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeDescription(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeDescription.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeLensClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeLensClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeLensOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeLensOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCodeLensWorkspaceClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CodeLensWorkspaceClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseColor(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && !Color.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCommand(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && !Command.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionClientCapabilitiesCompletionItem(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionClientCapabilitiesCompletionItem.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionClientCapabilitiesCompletionList(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionClientCapabilitiesCompletionList.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionContext(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionContext.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionItemDefaults(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionItemDefaults.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionItemInsertTextModeSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionItemInsertTextModeSupport.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionItemKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionItemKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionItemLabelDetails(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionItemLabelDetails.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionItemResolutionInfo(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionItemResolutionInfo.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionItemResolveSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionItemResolveSupport.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionItemTagSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionItemTagSupport.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCompletionTriggerKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CompletionTriggerKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseCreateFileOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !CreateFileOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDeclarationClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DeclarationClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDefinitionClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DefinitionClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDeleteFileOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DeleteFileOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDiagnosticClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DiagnosticClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDiagnosticOptionsDiagnosticRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (!DiagnosticOptions.canParse(value, reporter) &&
            !DiagnosticRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<DiagnosticOptions, DiagnosticRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDiagnosticSeverity(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DiagnosticSeverity.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDiagnosticWorkspaceClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DiagnosticWorkspaceClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDidChangeConfigurationClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DidChangeConfigurationClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDidChangeWatchedFilesClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DidChangeWatchedFilesClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentColorClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentColorClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentFormattingClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentFormattingClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentHighlightClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentHighlightClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentHighlightKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentHighlightKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentLinkClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentLinkClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentLinkOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentLinkOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentOnTypeFormattingClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentOnTypeFormattingClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentOnTypeFormattingOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentOnTypeFormattingOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentRangeFormattingClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentRangeFormattingClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentSymbolClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentSymbolClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentSymbolClientCapabilitiesSymbolKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentSymbolClientCapabilitiesSymbolKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseDocumentSymbolClientCapabilitiesTagSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !DocumentSymbolClientCapabilitiesTagSupport.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseEditRangeWithInsertReplaceRange(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (!EditRangeWithInsertReplace.canParse(value, reporter) &&
            !Range.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<EditRangeWithInsertReplace, Range>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseExecuteCommandClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ExecuteCommandClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseExecuteCommandOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ExecuteCommandOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseExecutionSummary(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ExecutionSummary.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFailureHandlingKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FailureHandlingKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFileChangeType(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FileChangeType.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFileOperationClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FileOperationClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFileOperationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FileOperationOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFileOperationPattern(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FileOperationPattern.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFileOperationPatternKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FileOperationPatternKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFileOperationPatternOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FileOperationPatternOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFileOperationRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FileOperationRegistrationOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFoldingRangeClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FoldingRangeClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFoldingRangeClientCapabilitiesFoldingRange(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FoldingRangeClientCapabilitiesFoldingRange.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFoldingRangeClientCapabilitiesFoldingRangeKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FoldingRangeClientCapabilitiesFoldingRangeKind.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFoldingRangeKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FoldingRangeKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseFormattingOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !FormattingOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseGeneralClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !GeneralClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseGeneralClientCapabilitiesStaleRequestSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !GeneralClientCapabilitiesStaleRequestSupport.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseHoverClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !HoverClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseImplementationClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ImplementationClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInlayHintClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !InlayHintClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInlayHintClientCapabilitiesResolveSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !InlayHintClientCapabilitiesResolveSupport.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInlayHintKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !InlayHintKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInlayHintWorkspaceClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !InlayHintWorkspaceClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInlineValueClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !InlineValueClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInlineValueContext(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !InlineValueContext.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInlineValueWorkspaceClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !InlineValueWorkspaceClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInsertReplaceEditTextEdit(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (!InsertReplaceEdit.canParse(value, reporter) &&
            !TextEdit.canParse(value, reporter))) {
      reporter
          .reportError('must be of type Either2<InsertReplaceEdit, TextEdit>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInsertTextFormat(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !InsertTextFormat.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInsertTextMode(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !InsertTextMode.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseInt(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && value is! int) {
      reporter.reportError('must be of type int');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseIntString(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && (value is! int && value is! String)) {
      reporter.reportError('must be of type Either2<int, String>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseLinkedEditingRangeClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !LinkedEditingRangeClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListAnnotatedTextEditSnippetTextEditTextEdit(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !AnnotatedTextEdit.canParse(item, reporter) &&
                !SnippetTextEdit.canParse(item, reporter) &&
                !TextEdit.canParse(item, reporter)))) {
      reporter.reportError(
          'must be of type List<Either3<AnnotatedTextEdit, SnippetTextEdit, TextEdit>>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListCodeActionKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !CodeActionKind.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<CodeActionKind>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListCompletionItem(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !CompletionItem.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<CompletionItem>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListCompletionItemKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value
                .any((item) => !CompletionItemKind.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<CompletionItemKind>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListCompletionItemTag(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !CompletionItemTag.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<CompletionItemTag>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListConfigurationItem(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !ConfigurationItem.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<ConfigurationItem>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListCreateFileDeleteFileRenameFileTextDocumentEdit(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !CreateFile.canParse(item, reporter) &&
                !DeleteFile.canParse(item, reporter) &&
                !RenameFile.canParse(item, reporter) &&
                !TextDocumentEdit.canParse(item, reporter)))) {
      reporter.reportError(
          'must be of type List<Either4<CreateFile, DeleteFile, RenameFile, TextDocumentEdit>>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListDiagnostic(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !Diagnostic.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<Diagnostic>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListDiagnosticRelatedInformation(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !DiagnosticRelatedInformation.canParse(item, reporter)))) {
      reporter
          .reportError('must be of type List<DiagnosticRelatedInformation>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListDiagnosticTag(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !DiagnosticTag.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<DiagnosticTag>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListDocumentSymbol(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !DocumentSymbol.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<DocumentSymbol>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListFileCreate(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !FileCreate.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<FileCreate>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListFileDelete(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !FileDelete.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<FileDelete>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListFileEvent(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !FileEvent.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<FileEvent>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListFileOperationFilter(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any(
                (item) => !FileOperationFilter.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<FileOperationFilter>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListFileRename(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !FileRename.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<FileRename>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListFileSystemWatcher(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !FileSystemWatcher.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<FileSystemWatcher>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListFoldingRangeKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !FoldingRangeKind.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<FoldingRangeKind>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListInlayHintLabelPartString(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !InlayHintLabelPart.canParse(item, reporter)) &&
                value is! String)) {
      reporter.reportError(
          'must be of type Either2<List<InlayHintLabelPart>, String>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListInsertTextMode(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !InsertTextMode.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<InsertTextMode>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListInt(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> || value.any((item) => item is! int))) {
      reporter.reportError('must be of type List<int>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListMarkupKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !MarkupKind.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<MarkupKind>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListMessageActionItem(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !MessageActionItem.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<MessageActionItem>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListNotebookCell(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !NotebookCell.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<NotebookCell>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListNotebookDocumentChangeEventCellsTextContent(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !NotebookDocumentChangeEventCellsTextContent.canParse(
                    item, reporter)))) {
      reporter.reportError(
          'must be of type List<NotebookDocumentChangeEventCellsTextContent>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListNotebookDocumentSyncOptionsNotebookSelector2Cells(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !NotebookDocumentSyncOptionsNotebookSelector2Cells.canParse(
                    item, reporter)))) {
      reporter.reportError(
          'must be of type List<NotebookDocumentSyncOptionsNotebookSelector2Cells>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListNotebookDocumentSyncOptionsNotebookSelectorCells(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !NotebookDocumentSyncOptionsNotebookSelectorCells.canParse(
                    item, reporter)))) {
      reporter.reportError(
          'must be of type List<NotebookDocumentSyncOptionsNotebookSelectorCells>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool
    _canParseListNotebookDocumentSyncOptionsNotebookSelectorNotebookDocumentSyncOptionsNotebookSelector2(
        Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
        {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !NotebookDocumentSyncOptionsNotebookSelector.canParse(
                    item, reporter) &&
                !NotebookDocumentSyncOptionsNotebookSelector2.canParse(
                    item, reporter)))) {
      reporter.reportError(
          'must be of type List<Either2<NotebookDocumentSyncOptionsNotebookSelector, NotebookDocumentSyncOptionsNotebookSelector2>>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListObjectNullable(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> || value.any((item) => false))) {
      reporter.reportError('must be of type List<LSPAny>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListParameterInformation(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any(
                (item) => !ParameterInformation.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<ParameterInformation>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListPosition(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !Position.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<Position>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListPositionEncodingKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any(
                (item) => !PositionEncodingKind.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<PositionEncodingKind>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListPreviousResultId(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !PreviousResultId.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<PreviousResultId>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListRange(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !Range.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<Range>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListRegistration(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !Registration.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<Registration>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListResourceOperationKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any(
                (item) => !ResourceOperationKind.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<ResourceOperationKind>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListSemanticTokensEdit(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value
                .any((item) => !SemanticTokensEdit.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<SemanticTokensEdit>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListSignatureInformation(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any(
                (item) => !SignatureInformation.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<SignatureInformation>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListString(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> || value.any((item) => item is! String))) {
      reporter.reportError('must be of type List<String>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListSymbolKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !SymbolKind.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<SymbolKind>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListSymbolTag(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !SymbolTag.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<SymbolTag>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool
    _canParseListTextDocumentContentChangePartialTextDocumentContentChangeWholeDocument(
        Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
        {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !TextDocumentContentChangePartial.canParse(item, reporter) &&
                !TextDocumentContentChangeWholeDocument.canParse(
                    item, reporter)))) {
      reporter
          .reportError('must be of type List<TextDocumentContentChangeEvent>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListTextDocumentFilterScheme(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !TextDocumentFilterScheme.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<TextDocumentFilterScheme>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListTextDocumentIdentifier(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any(
                (item) => !TextDocumentIdentifier.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<TextDocumentIdentifier>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListTextDocumentItem(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !TextDocumentItem.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<TextDocumentItem>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListTextEdit(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !TextEdit.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<TextEdit>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListTokenFormat(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !TokenFormat.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<TokenFormat>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListUnregistration(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !Unregistration.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<Unregistration>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseListWorkspaceFolder(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) => !WorkspaceFolder.canParse(item, reporter)))) {
      reporter.reportError('must be of type List<WorkspaceFolder>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool
    _canParseListWorkspaceFullDocumentDiagnosticReportWorkspaceUnchangedDocumentDiagnosticReport(
        Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
        {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! List<Object?> ||
            value.any((item) =>
                !WorkspaceFullDocumentDiagnosticReport.canParse(
                    item, reporter) &&
                !WorkspaceUnchangedDocumentDiagnosticReport.canParse(
                    item, reporter)))) {
      reporter.reportError(
          'must be of type List<WorkspaceDocumentDiagnosticReport>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseLiteral(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined,
    required bool allowsNull,
    required String literal}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && value != literal) {
      reporter.reportError("must be the literal '$literal'");
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseLocation(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && !Location.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseLocationWorkspaceSymbolLocation(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (!Location.canParse(value, reporter) &&
            !WorkspaceSymbolLocation.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<Location, WorkspaceSymbolLocation>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseMapStringChangeAnnotation(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! Map ||
            (value.keys.any((item) =>
                item is! String ||
                value.values.any(
                    (item) => !ChangeAnnotation.canParse(item, reporter)))))) {
      reporter.reportError(
          'must be of type Map<ChangeAnnotationIdentifier, ChangeAnnotation>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool
    _canParseMapUriFullDocumentDiagnosticReportUnchangedDocumentDiagnosticReport(
        Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
        {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! Map ||
            (value.keys.any((item) =>
                (item is! String || Uri.tryParse(item) == null) ||
                value.values.any((item) =>
                    !FullDocumentDiagnosticReport.canParse(item, reporter) &&
                    !UnchangedDocumentDiagnosticReport.canParse(
                        item, reporter)))))) {
      reporter.reportError(
          'must be of type Map<DocumentUri, Either2<FullDocumentDiagnosticReport, UnchangedDocumentDiagnosticReport>>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseMapUriListTextEdit(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! Map ||
            (value.keys.any((item) =>
                (item is! String || Uri.tryParse(item) == null) ||
                value.values.any((item) =>
                    item is! List<Object?> ||
                    item.any(
                        (item) => !TextEdit.canParse(item, reporter))))))) {
      reporter.reportError('must be of type Map<DocumentUri, List<TextEdit>>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseMarkdownClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !MarkdownClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseMarkupContentString(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (!MarkupContent.canParse(value, reporter) && value is! String)) {
      reporter.reportError('must be of type Either2<MarkupContent, String>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseMarkupKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !MarkupKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseMessageType(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !MessageType.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseMonikerClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !MonikerClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseMonikerKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !MonikerKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNotebookCellArrayChange(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !NotebookCellArrayChange.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNotebookCellKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !NotebookCellKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNotebookDocument(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !NotebookDocument.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNotebookDocumentChangeEvent(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !NotebookDocumentChangeEvent.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNotebookDocumentChangeEventCells(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !NotebookDocumentChangeEventCells.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNotebookDocumentChangeEventCellsStructure(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !NotebookDocumentChangeEventCellsStructure.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNotebookDocumentClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !NotebookDocumentClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool
    _canParseNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3String(
        Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
        {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (!NotebookDocumentFilter1.canParse(value, reporter) &&
            !NotebookDocumentFilter2.canParse(value, reporter) &&
            !NotebookDocumentFilter3.canParse(value, reporter) &&
            value is! String)) {
      reporter.reportError(
          'must be of type Either2<NotebookDocumentFilter, String>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNotebookDocumentIdentifier(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !NotebookDocumentIdentifier.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNotebookDocumentSyncClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !NotebookDocumentSyncClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool
    _canParseNotebookDocumentSyncOptionsNotebookDocumentSyncRegistrationOptions(
        Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
        {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (!NotebookDocumentSyncOptions.canParse(value, reporter) &&
            !NotebookDocumentSyncRegistrationOptions.canParse(
                value, reporter))) {
      reporter.reportError(
          'must be of type Either2<NotebookDocumentSyncOptions, NotebookDocumentSyncRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseNum(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && value is! num) {
      reporter.reportError('must be of type num');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseObject(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && value == null) {
      reporter.reportError('must be of type Object');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseOptionalVersionedTextDocumentIdentifier(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !OptionalVersionedTextDocumentIdentifier.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParsePosition(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && !Position.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParsePositionEncodingKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !PositionEncodingKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParsePrepareSupportDefaultBehavior(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !PrepareSupportDefaultBehavior.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParsePublishDiagnosticsClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !PublishDiagnosticsClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParsePublishDiagnosticsClientCapabilitiesTagSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !PublishDiagnosticsClientCapabilitiesTagSupport.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseRange(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && !Range.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseReferenceClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ReferenceClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseReferenceContext(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ReferenceContext.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseRegularExpressionsClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !RegularExpressionsClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseRenameClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !RenameClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseRenameFileOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !RenameFileOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSelectionRange(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SelectionRange.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSelectionRangeClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SelectionRangeClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSemanticTokensClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SemanticTokensClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSemanticTokensLegend(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SemanticTokensLegend.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSemanticTokensOptionsSemanticTokensRegistrationOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (!SemanticTokensOptions.canParse(value, reporter) &&
            !SemanticTokensRegistrationOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<SemanticTokensOptions, SemanticTokensRegistrationOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSemanticTokensWorkspaceClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SemanticTokensWorkspaceClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseServerCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ServerCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseServerCompletionItemOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ServerCompletionItemOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseServerInfo(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ServerInfo.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseShowDocumentClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ShowDocumentClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseShowMessageRequestClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ShowMessageRequestClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseShowMessageRequestClientCapabilitiesMessageActionItem(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !ShowMessageRequestClientCapabilitiesMessageActionItem.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSignatureHelp(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SignatureHelp.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSignatureHelpClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SignatureHelpClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSignatureHelpClientCapabilitiesSignatureInformation(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SignatureHelpClientCapabilitiesSignatureInformation.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSignatureHelpContext(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SignatureHelpContext.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSignatureHelpOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SignatureHelpOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSignatureHelpTriggerKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SignatureHelpTriggerKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSignatureInformationParameterInformation(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SignatureInformationParameterInformation.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseString(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && value is! String) {
      reporter.reportError('must be of type String');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseStringRelativePattern(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! String && !RelativePattern.canParse(value, reporter))) {
      reporter
          .reportError('must be of type Either2<LspPattern, RelativePattern>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseSymbolKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !SymbolKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTextDocumentClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TextDocumentClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTextDocumentIdentifier(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TextDocumentIdentifier.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTextDocumentItem(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TextDocumentItem.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTextDocumentSaveReason(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TextDocumentSaveReason.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTextDocumentSyncClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TextDocumentSyncClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTextDocumentSyncKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TextDocumentSyncKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTextDocumentSyncKindTextDocumentSyncOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (!TextDocumentSyncKind.canParse(value, reporter) &&
            !TextDocumentSyncOptions.canParse(value, reporter))) {
      reporter.reportError(
          'must be of type Either2<TextDocumentSyncKind, TextDocumentSyncOptions>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTextEdit(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && !TextEdit.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTraceValue(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TraceValue.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTypeDefinitionClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TypeDefinitionClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTypeHierarchyClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TypeHierarchyClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTypeHierarchyItem(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TypeHierarchyItem.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseTypeHierarchyItemInfo(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !TypeHierarchyItemInfo.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseUniquenessLevel(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !UniquenessLevel.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseUri(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        (value is! String || Uri.tryParse(value) == null)) {
      reporter.reportError('must be of type Uri');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseUriWorkspaceFolder(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        ((value is! String || Uri.tryParse(value) == null) &&
            !WorkspaceFolder.canParse(value, reporter))) {
      reporter.reportError('must be of type Either2<LSPUri, WorkspaceFolder>');
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseVersionedNotebookDocumentIdentifier(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !VersionedNotebookDocumentIdentifier.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseVersionedTextDocumentIdentifier(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !VersionedTextDocumentIdentifier.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWatchKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) && !WatchKind.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWindowClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WindowClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceEdit(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceEdit.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceEditClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceEditClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceEditClientCapabilitiesChangeAnnotationSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceEditClientCapabilitiesChangeAnnotationSupport.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceFoldersChangeEvent(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceFoldersChangeEvent.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceFoldersServerCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceFoldersServerCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceOptions(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceOptions.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceSymbolClientCapabilities(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceSymbolClientCapabilities.canParse(value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceSymbolClientCapabilitiesResolveSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceSymbolClientCapabilitiesResolveSupport.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceSymbolClientCapabilitiesSymbolKind(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceSymbolClientCapabilitiesSymbolKind.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

bool _canParseWorkspaceSymbolClientCapabilitiesTagSupport(
    Map<String, Object?> map, LspJsonReporter reporter, String fieldName,
    {required bool allowsUndefined, required bool allowsNull}) {
  reporter.push(fieldName);
  try {
    if (!allowsUndefined && !map.containsKey(fieldName)) {
      reporter.reportError('must not be undefined');
      return false;
    }
    final value = map[fieldName];
    final nullCheck = allowsNull || allowsUndefined;
    if (!nullCheck && value == null) {
      reporter.reportError('must not be null');
      return false;
    }
    if ((!nullCheck || value != null) &&
        !WorkspaceSymbolClientCapabilitiesTagSupport.canParse(
            value, reporter)) {
      return false;
    }
  } finally {
    reporter.pop();
  }
  return true;
}

Either3<AnnotatedTextEdit, SnippetTextEdit, TextEdit>
    _eitherAnnotatedTextEditSnippetTextEditTextEdit(Object? value) {
  return AnnotatedTextEdit.canParse(value, nullLspJsonReporter)
      ? Either3.t1(AnnotatedTextEdit.fromJson(value as Map<String, Object?>))
      : SnippetTextEdit.canParse(value, nullLspJsonReporter)
          ? Either3.t2(SnippetTextEdit.fromJson(value as Map<String, Object?>))
          : TextEdit.canParse(value, nullLspJsonReporter)
              ? Either3.t3(TextEdit.fromJson(value as Map<String, Object?>))
              : throw '$value was not one of (AnnotatedTextEdit, SnippetTextEdit, TextEdit)';
}

Either3<bool, CallHierarchyOptions, CallHierarchyRegistrationOptions>
    _eitherBoolCallHierarchyOptionsCallHierarchyRegistrationOptions(
        Object? value) {
  return value is bool
      ? Either3.t1(value)
      : CallHierarchyOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              CallHierarchyOptions.fromJson(value as Map<String, Object?>))
          : CallHierarchyRegistrationOptions.canParse(
                  value, nullLspJsonReporter)
              ? Either3.t3(CallHierarchyRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, CallHierarchyOptions, CallHierarchyRegistrationOptions)';
}

Either2<bool, CodeActionOptions> _eitherBoolCodeActionOptions(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : CodeActionOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(
              CodeActionOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, CodeActionOptions)';
}

Either3<bool, DeclarationOptions, DeclarationRegistrationOptions>
    _eitherBoolDeclarationOptionsDeclarationRegistrationOptions(Object? value) {
  return value is bool
      ? Either3.t1(value)
      : DeclarationOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              DeclarationOptions.fromJson(value as Map<String, Object?>))
          : DeclarationRegistrationOptions.canParse(value, nullLspJsonReporter)
              ? Either3.t3(DeclarationRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, DeclarationOptions, DeclarationRegistrationOptions)';
}

Either2<bool, DefinitionOptions> _eitherBoolDefinitionOptions(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : DefinitionOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(
              DefinitionOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, DefinitionOptions)';
}

Either3<bool, DocumentColorOptions, DocumentColorRegistrationOptions>
    _eitherBoolDocumentColorOptionsDocumentColorRegistrationOptions(
        Object? value) {
  return value is bool
      ? Either3.t1(value)
      : DocumentColorOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              DocumentColorOptions.fromJson(value as Map<String, Object?>))
          : DocumentColorRegistrationOptions.canParse(
                  value, nullLspJsonReporter)
              ? Either3.t3(DocumentColorRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, DocumentColorOptions, DocumentColorRegistrationOptions)';
}

Either2<bool, DocumentFormattingOptions> _eitherBoolDocumentFormattingOptions(
    Object? value) {
  return value is bool
      ? Either2.t1(value)
      : DocumentFormattingOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(
              DocumentFormattingOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, DocumentFormattingOptions)';
}

Either2<bool, DocumentHighlightOptions> _eitherBoolDocumentHighlightOptions(
    Object? value) {
  return value is bool
      ? Either2.t1(value)
      : DocumentHighlightOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(
              DocumentHighlightOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, DocumentHighlightOptions)';
}

Either2<bool, DocumentRangeFormattingOptions>
    _eitherBoolDocumentRangeFormattingOptions(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : DocumentRangeFormattingOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(DocumentRangeFormattingOptions.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (bool, DocumentRangeFormattingOptions)';
}

Either2<bool, DocumentSymbolOptions> _eitherBoolDocumentSymbolOptions(
    Object? value) {
  return value is bool
      ? Either2.t1(value)
      : DocumentSymbolOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(
              DocumentSymbolOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, DocumentSymbolOptions)';
}

Either3<bool, FoldingRangeOptions, FoldingRangeRegistrationOptions>
    _eitherBoolFoldingRangeOptionsFoldingRangeRegistrationOptions(
        Object? value) {
  return value is bool
      ? Either3.t1(value)
      : FoldingRangeOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              FoldingRangeOptions.fromJson(value as Map<String, Object?>))
          : FoldingRangeRegistrationOptions.canParse(value, nullLspJsonReporter)
              ? Either3.t3(FoldingRangeRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, FoldingRangeOptions, FoldingRangeRegistrationOptions)';
}

Either2<bool, HoverOptions> _eitherBoolHoverOptions(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : HoverOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(HoverOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, HoverOptions)';
}

Either3<bool, ImplementationOptions, ImplementationRegistrationOptions>
    _eitherBoolImplementationOptionsImplementationRegistrationOptions(
        Object? value) {
  return value is bool
      ? Either3.t1(value)
      : ImplementationOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              ImplementationOptions.fromJson(value as Map<String, Object?>))
          : ImplementationRegistrationOptions.canParse(
                  value, nullLspJsonReporter)
              ? Either3.t3(ImplementationRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, ImplementationOptions, ImplementationRegistrationOptions)';
}

Either3<bool, InlayHintOptions, InlayHintRegistrationOptions>
    _eitherBoolInlayHintOptionsInlayHintRegistrationOptions(Object? value) {
  return value is bool
      ? Either3.t1(value)
      : InlayHintOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(InlayHintOptions.fromJson(value as Map<String, Object?>))
          : InlayHintRegistrationOptions.canParse(value, nullLspJsonReporter)
              ? Either3.t3(InlayHintRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, InlayHintOptions, InlayHintRegistrationOptions)';
}

Either3<bool, InlineValueOptions, InlineValueRegistrationOptions>
    _eitherBoolInlineValueOptionsInlineValueRegistrationOptions(Object? value) {
  return value is bool
      ? Either3.t1(value)
      : InlineValueOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              InlineValueOptions.fromJson(value as Map<String, Object?>))
          : InlineValueRegistrationOptions.canParse(value, nullLspJsonReporter)
              ? Either3.t3(InlineValueRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, InlineValueOptions, InlineValueRegistrationOptions)';
}

Either3<bool, LinkedEditingRangeOptions, LinkedEditingRangeRegistrationOptions>
    _eitherBoolLinkedEditingRangeOptionsLinkedEditingRangeRegistrationOptions(
        Object? value) {
  return value is bool
      ? Either3.t1(value)
      : LinkedEditingRangeOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              LinkedEditingRangeOptions.fromJson(value as Map<String, Object?>))
          : LinkedEditingRangeRegistrationOptions.canParse(
                  value, nullLspJsonReporter)
              ? Either3.t3(LinkedEditingRangeRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, LinkedEditingRangeOptions, LinkedEditingRangeRegistrationOptions)';
}

Either3<bool, MonikerOptions, MonikerRegistrationOptions>
    _eitherBoolMonikerOptionsMonikerRegistrationOptions(Object? value) {
  return value is bool
      ? Either3.t1(value)
      : MonikerOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(MonikerOptions.fromJson(value as Map<String, Object?>))
          : MonikerRegistrationOptions.canParse(value, nullLspJsonReporter)
              ? Either3.t3(MonikerRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, MonikerOptions, MonikerRegistrationOptions)';
}

Either2<bool, ReferenceOptions> _eitherBoolReferenceOptions(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : ReferenceOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(ReferenceOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, ReferenceOptions)';
}

Either2<bool, RenameOptions> _eitherBoolRenameOptions(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : RenameOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(RenameOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, RenameOptions)';
}

Either2<bool, SaveOptions> _eitherBoolSaveOptions(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : SaveOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(SaveOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, SaveOptions)';
}

Either3<bool, SelectionRangeOptions, SelectionRangeRegistrationOptions>
    _eitherBoolSelectionRangeOptionsSelectionRangeRegistrationOptions(
        Object? value) {
  return value is bool
      ? Either3.t1(value)
      : SelectionRangeOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              SelectionRangeOptions.fromJson(value as Map<String, Object?>))
          : SelectionRangeRegistrationOptions.canParse(
                  value, nullLspJsonReporter)
              ? Either3.t3(SelectionRangeRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, SelectionRangeOptions, SelectionRangeRegistrationOptions)';
}

Either2<bool, SemanticTokensClientCapabilitiesRequestsFull>
    _eitherBoolSemanticTokensClientCapabilitiesRequestsFull(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : SemanticTokensClientCapabilitiesRequestsFull.canParse(
              value, nullLspJsonReporter)
          ? Either2.t2(SemanticTokensClientCapabilitiesRequestsFull.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (bool, SemanticTokensClientCapabilitiesRequestsFull)';
}

Either2<bool, SemanticTokensClientCapabilitiesRequestsRange>
    _eitherBoolSemanticTokensClientCapabilitiesRequestsRange(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : SemanticTokensClientCapabilitiesRequestsRange.canParse(
              value, nullLspJsonReporter)
          ? Either2.t2(SemanticTokensClientCapabilitiesRequestsRange.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (bool, SemanticTokensClientCapabilitiesRequestsRange)';
}

Either2<bool, SemanticTokensFullDelta> _eitherBoolSemanticTokensFullDelta(
    Object? value) {
  return value is bool
      ? Either2.t1(value)
      : SemanticTokensFullDelta.canParse(value, nullLspJsonReporter)
          ? Either2.t2(
              SemanticTokensFullDelta.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, SemanticTokensFullDelta)';
}

Either2<bool, SemanticTokensOptionsRange> _eitherBoolSemanticTokensOptionsRange(
    Object? value) {
  return value is bool
      ? Either2.t1(value)
      : SemanticTokensOptionsRange.canParse(value, nullLspJsonReporter)
          ? Either2.t2(SemanticTokensOptionsRange.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (bool, SemanticTokensOptionsRange)';
}

Either2<bool, String> _eitherBoolString(Object? value) {
  return value is bool
      ? Either2.t1(value)
      : value is String
          ? Either2.t2(value)
          : throw '$value was not one of (bool, String)';
}

Either3<bool, TypeDefinitionOptions, TypeDefinitionRegistrationOptions>
    _eitherBoolTypeDefinitionOptionsTypeDefinitionRegistrationOptions(
        Object? value) {
  return value is bool
      ? Either3.t1(value)
      : TypeDefinitionOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              TypeDefinitionOptions.fromJson(value as Map<String, Object?>))
          : TypeDefinitionRegistrationOptions.canParse(
                  value, nullLspJsonReporter)
              ? Either3.t3(TypeDefinitionRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, TypeDefinitionOptions, TypeDefinitionRegistrationOptions)';
}

Either3<bool, TypeHierarchyOptions, TypeHierarchyRegistrationOptions>
    _eitherBoolTypeHierarchyOptionsTypeHierarchyRegistrationOptions(
        Object? value) {
  return value is bool
      ? Either3.t1(value)
      : TypeHierarchyOptions.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              TypeHierarchyOptions.fromJson(value as Map<String, Object?>))
          : TypeHierarchyRegistrationOptions.canParse(
                  value, nullLspJsonReporter)
              ? Either3.t3(TypeHierarchyRegistrationOptions.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (bool, TypeHierarchyOptions, TypeHierarchyRegistrationOptions)';
}

Either2<bool, WorkspaceSymbolOptions> _eitherBoolWorkspaceSymbolOptions(
    Object? value) {
  return value is bool
      ? Either2.t1(value)
      : WorkspaceSymbolOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(
              WorkspaceSymbolOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (bool, WorkspaceSymbolOptions)';
}

Either4<CreateFile, DeleteFile, RenameFile, TextDocumentEdit>
    _eitherCreateFileDeleteFileRenameFileTextDocumentEdit(Object? value) {
  return CreateFile.canParse(value, nullLspJsonReporter)
      ? Either4.t1(CreateFile.fromJson(value as Map<String, Object?>))
      : DeleteFile.canParse(value, nullLspJsonReporter)
          ? Either4.t2(DeleteFile.fromJson(value as Map<String, Object?>))
          : RenameFile.canParse(value, nullLspJsonReporter)
              ? Either4.t3(RenameFile.fromJson(value as Map<String, Object?>))
              : TextDocumentEdit.canParse(value, nullLspJsonReporter)
                  ? Either4.t4(
                      TextDocumentEdit.fromJson(value as Map<String, Object?>))
                  : throw '$value was not one of (CreateFile, DeleteFile, RenameFile, TextDocumentEdit)';
}

Either2<DiagnosticOptions, DiagnosticRegistrationOptions>
    _eitherDiagnosticOptionsDiagnosticRegistrationOptions(Object? value) {
  return DiagnosticOptions.canParse(value, nullLspJsonReporter)
      ? Either2.t1(DiagnosticOptions.fromJson(value as Map<String, Object?>))
      : DiagnosticRegistrationOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(DiagnosticRegistrationOptions.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (DiagnosticOptions, DiagnosticRegistrationOptions)';
}

Either2<EditRangeWithInsertReplace, Range>
    _eitherEditRangeWithInsertReplaceRange(Object? value) {
  return EditRangeWithInsertReplace.canParse(value, nullLspJsonReporter)
      ? Either2.t1(
          EditRangeWithInsertReplace.fromJson(value as Map<String, Object?>))
      : Range.canParse(value, nullLspJsonReporter)
          ? Either2.t2(Range.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (EditRangeWithInsertReplace, Range)';
}

Either2<FullDocumentDiagnosticReport, UnchangedDocumentDiagnosticReport>
    _eitherFullDocumentDiagnosticReportUnchangedDocumentDiagnosticReport(
        Object? value) {
  return FullDocumentDiagnosticReport.canParse(value, nullLspJsonReporter)
      ? Either2.t1(
          FullDocumentDiagnosticReport.fromJson(value as Map<String, Object?>))
      : UnchangedDocumentDiagnosticReport.canParse(value, nullLspJsonReporter)
          ? Either2.t2(UnchangedDocumentDiagnosticReport.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (FullDocumentDiagnosticReport, UnchangedDocumentDiagnosticReport)';
}

Either2<InsertReplaceEdit, TextEdit> _eitherInsertReplaceEditTextEdit(
    Object? value) {
  return InsertReplaceEdit.canParse(value, nullLspJsonReporter)
      ? Either2.t1(InsertReplaceEdit.fromJson(value as Map<String, Object?>))
      : TextEdit.canParse(value, nullLspJsonReporter)
          ? Either2.t2(TextEdit.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (InsertReplaceEdit, TextEdit)';
}

Either2<int, String> _eitherIntString(Object? value) {
  return value is int
      ? Either2.t1(value)
      : value is String
          ? Either2.t2(value)
          : throw '$value was not one of (int, String)';
}

Either2<List<InlayHintLabelPart>, String> _eitherListInlayHintLabelPartString(
    Object? value) {
  return value is List<Object?> &&
          value.every(
              (item) => InlayHintLabelPart.canParse(item, nullLspJsonReporter))
      ? Either2.t1(value
          .map((item) =>
              InlayHintLabelPart.fromJson(item as Map<String, Object?>))
          .toList())
      : value is String
          ? Either2.t2(value)
          : throw '$value was not one of (List<InlayHintLabelPart>, String)';
}

Either2<Location, WorkspaceSymbolLocation>
    _eitherLocationWorkspaceSymbolLocation(Object? value) {
  return Location.canParse(value, nullLspJsonReporter)
      ? Either2.t1(Location.fromJson(value as Map<String, Object?>))
      : WorkspaceSymbolLocation.canParse(value, nullLspJsonReporter)
          ? Either2.t2(
              WorkspaceSymbolLocation.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (Location, WorkspaceSymbolLocation)';
}

Either2<MarkupContent, String> _eitherMarkupContentString(Object? value) {
  return MarkupContent.canParse(value, nullLspJsonReporter)
      ? Either2.t1(MarkupContent.fromJson(value as Map<String, Object?>))
      : value is String
          ? Either2.t2(value)
          : throw '$value was not one of (MarkupContent, String)';
}

Either3<NotebookDocumentFilter1, NotebookDocumentFilter2,
        NotebookDocumentFilter3>
    _eitherNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3(
        Object? value) {
  return NotebookDocumentFilter1.canParse(value, nullLspJsonReporter)
      ? Either3.t1(
          NotebookDocumentFilter1.fromJson(value as Map<String, Object?>))
      : NotebookDocumentFilter2.canParse(value, nullLspJsonReporter)
          ? Either3.t2(
              NotebookDocumentFilter2.fromJson(value as Map<String, Object?>))
          : NotebookDocumentFilter3.canParse(value, nullLspJsonReporter)
              ? Either3.t3(NotebookDocumentFilter3.fromJson(
                  value as Map<String, Object?>))
              : throw '$value was not one of (NotebookDocumentFilter1, NotebookDocumentFilter2, NotebookDocumentFilter3)';
}

Either2<NotebookDocumentFilter, String>
    _eitherNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3String(
        Object? value) {
  return NotebookDocumentFilter1.canParse(value, nullLspJsonReporter) ||
          NotebookDocumentFilter2.canParse(value, nullLspJsonReporter) ||
          NotebookDocumentFilter3.canParse(value, nullLspJsonReporter)
      ? Either2.t1(
          _eitherNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3(
              value))
      : value is String
          ? Either2.t2(value)
          : throw '$value was not one of (NotebookDocumentFilter, String)';
}

Either2<NotebookDocumentSyncOptions, NotebookDocumentSyncRegistrationOptions>
    _eitherNotebookDocumentSyncOptionsNotebookDocumentSyncRegistrationOptions(
        Object? value) {
  return NotebookDocumentSyncOptions.canParse(value, nullLspJsonReporter)
      ? Either2.t1(
          NotebookDocumentSyncOptions.fromJson(value as Map<String, Object?>))
      : NotebookDocumentSyncRegistrationOptions.canParse(
              value, nullLspJsonReporter)
          ? Either2.t2(NotebookDocumentSyncRegistrationOptions.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (NotebookDocumentSyncOptions, NotebookDocumentSyncRegistrationOptions)';
}

Either2<NotebookDocumentSyncOptionsNotebookSelector,
        NotebookDocumentSyncOptionsNotebookSelector2>
    _eitherNotebookDocumentSyncOptionsNotebookSelectorNotebookDocumentSyncOptionsNotebookSelector2(
        Object? value) {
  return NotebookDocumentSyncOptionsNotebookSelector.canParse(
          value, nullLspJsonReporter)
      ? Either2.t1(NotebookDocumentSyncOptionsNotebookSelector.fromJson(
          value as Map<String, Object?>))
      : NotebookDocumentSyncOptionsNotebookSelector2.canParse(
              value, nullLspJsonReporter)
          ? Either2.t2(NotebookDocumentSyncOptionsNotebookSelector2.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (NotebookDocumentSyncOptionsNotebookSelector, NotebookDocumentSyncOptionsNotebookSelector2)';
}

Either2<SemanticTokensOptions, SemanticTokensRegistrationOptions>
    _eitherSemanticTokensOptionsSemanticTokensRegistrationOptions(
        Object? value) {
  return SemanticTokensOptions.canParse(value, nullLspJsonReporter)
      ? Either2.t1(
          SemanticTokensOptions.fromJson(value as Map<String, Object?>))
      : SemanticTokensRegistrationOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(SemanticTokensRegistrationOptions.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (SemanticTokensOptions, SemanticTokensRegistrationOptions)';
}

Either2<LspPattern, RelativePattern> _eitherStringRelativePattern(
    Object? value) {
  return value is String
      ? Either2.t1(value)
      : RelativePattern.canParse(value, nullLspJsonReporter)
          ? Either2.t2(RelativePattern.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (LspPattern, RelativePattern)';
}

Either2<TextDocumentContentChangePartial,
        TextDocumentContentChangeWholeDocument>
    _eitherTextDocumentContentChangePartialTextDocumentContentChangeWholeDocument(
        Object? value) {
  return TextDocumentContentChangePartial.canParse(value, nullLspJsonReporter)
      ? Either2.t1(TextDocumentContentChangePartial.fromJson(
          value as Map<String, Object?>))
      : TextDocumentContentChangeWholeDocument.canParse(
              value, nullLspJsonReporter)
          ? Either2.t2(TextDocumentContentChangeWholeDocument.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (TextDocumentContentChangePartial, TextDocumentContentChangeWholeDocument)';
}

Either2<TextDocumentSyncKind, TextDocumentSyncOptions>
    _eitherTextDocumentSyncKindTextDocumentSyncOptions(Object? value) {
  return TextDocumentSyncKind.canParse(value, nullLspJsonReporter)
      ? Either2.t1(TextDocumentSyncKind.fromJson(value as int))
      : TextDocumentSyncOptions.canParse(value, nullLspJsonReporter)
          ? Either2.t2(
              TextDocumentSyncOptions.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (TextDocumentSyncKind, TextDocumentSyncOptions)';
}

Either2<LSPUri, WorkspaceFolder> _eitherUriWorkspaceFolder(Object? value) {
  return (value is String && Uri.tryParse(value) != null)
      ? Either2.t1(Uri.parse(value))
      : WorkspaceFolder.canParse(value, nullLspJsonReporter)
          ? Either2.t2(WorkspaceFolder.fromJson(value as Map<String, Object?>))
          : throw '$value was not one of (LSPUri, WorkspaceFolder)';
}

Either2<WorkspaceFullDocumentDiagnosticReport,
        WorkspaceUnchangedDocumentDiagnosticReport>
    _eitherWorkspaceFullDocumentDiagnosticReportWorkspaceUnchangedDocumentDiagnosticReport(
        Object? value) {
  return WorkspaceFullDocumentDiagnosticReport.canParse(
          value, nullLspJsonReporter)
      ? Either2.t1(WorkspaceFullDocumentDiagnosticReport.fromJson(
          value as Map<String, Object?>))
      : WorkspaceUnchangedDocumentDiagnosticReport.canParse(
              value, nullLspJsonReporter)
          ? Either2.t2(WorkspaceUnchangedDocumentDiagnosticReport.fromJson(
              value as Map<String, Object?>))
          : throw '$value was not one of (WorkspaceFullDocumentDiagnosticReport, WorkspaceUnchangedDocumentDiagnosticReport)';
}

/// Result for a request to resolve the incoming calls for a given
/// `CallHierarchyItem`.
///
/// @since 3.16.0
typedef CallHierarchyIncomingCallsResult = List<CallHierarchyIncomingCall>?;

/// Result for a request to resolve the outgoing calls for a given
/// `CallHierarchyItem`.
///
/// @since 3.16.0
typedef CallHierarchyOutgoingCallsResult = List<CallHierarchyOutgoingCall>?;

/// An identifier to refer to a change annotation stored with a workspace edit.
typedef ChangeAnnotationIdentifier = String;

typedef CodeActionLiteralSupportCodeActionKind = ClientCodeActionKindOptions;

/// The declaration of a symbol representation as one or many [Location].
typedef Declaration = Either2<List<Location>, Location>;

/// Information about where a symbol is declared.
///
/// Provides additional metadata over normal [Location] declarations, including
/// the range of the declaring symbol.
///
/// Servers should prefer returning `DeclarationLink` over `Declaration` if
/// supported by the client.
typedef DeclarationLink = LocationLink;

/// The definition of a symbol represented as one or many [Location]. For most
/// programming languages there is only one location at which a symbol is
/// defined.
///
/// Servers should prefer returning `DefinitionLink` over `Definition` if
/// supported by the client.
typedef Definition = Either2<List<Location>, Location>;

/// Information about where a symbol is defined.
///
/// Provides additional metadata over normal [Location] definitions, including
/// the range of the defining symbol
typedef DefinitionLink = LocationLink;

/// The result of a document diagnostic pull request. A report can either be a
/// full report containing all diagnostics for the requested document or an
/// unchanged report indicating that nothing has changed in terms of diagnostics
/// in comparison to the last pull request.
///
/// @since 3.17.0
typedef DocumentDiagnosticReport = Either2<RelatedFullDocumentDiagnosticReport,
    RelatedUnchangedDocumentDiagnosticReport>;

/// A document filter describes a top level text document or a notebook cell
/// document.
///
/// @since 3.17.0 - proposed support for NotebookCellTextDocumentFilter.
typedef DocumentFilter
    = Either2<NotebookCellTextDocumentFilter, TextDocumentFilter>;

/// A document selector is the combination of one or many document filters.
///
/// @sample `let sel:DocumentSelector = [{ language: 'typescript' }, { language:
/// 'json', pattern: '**∕tsconfig.json' }]`;
///
/// The use of a string as a document filter is deprecated @since 3.16.0.
typedef DocumentSelector = List<TextDocumentFilterScheme>;

/// The glob pattern. Either a string pattern or a relative pattern.
///
/// @since 3.17.0
typedef GlobPattern = Either2<LspPattern, RelativePattern>;

/// Inline value information can be provided by different means:
/// - directly as a text value (class InlineValueText).
/// - as a name to use for a variable lookup (class InlineValueVariableLookup)
/// - as an evaluatable expression (class InlineValueEvaluatableExpression) The
/// InlineValue types combines all inline value types into one type.
///
/// @since 3.17.0
typedef InlineValue = Either3<InlineValueEvaluatableExpression, InlineValueText,
    InlineValueVariableLookup>;

/// LSP arrays.
/// @since 3.17.0
typedef LSPArray = List<LSPAny>;

/// The glob pattern to watch relative to the base path. Glob patterns can have
/// the following syntax:
/// - `*` to match one or more characters in a path segment
/// - `?` to match on one character in a path segment
/// - `**` to match any number of path segments, including none
/// - `{}` to group conditions (e.g. `**​/*.{ts,js}` matches all TypeScript and
/// JavaScript files)
/// - `[]` to declare a range of characters to match in a path segment (e.g.,
/// `example.[0-9]` to match on `example.0`, `example.1`, …)
/// - `[!...]` to negate a range of characters to match in a path segment (e.g.,
/// `example.[!0-9]` to match on `example.a`, `example.b`, but not `example.0`)
///
/// @since 3.17.0
typedef LspPattern = String;

/// A notebook document filter denotes a notebook document by different
/// properties. The properties will be match against the notebook's URI (same as
/// with documents)
///
/// @since 3.17.0
typedef NotebookDocumentFilter = Either3<NotebookDocumentFilter1,
    NotebookDocumentFilter2, NotebookDocumentFilter3>;

typedef PrepareRenameResult
    = Either3<PrepareRenamePlaceholder, PrepareRenameResult2, Range>;

typedef ProgressToken = Either2<int, String>;

/// Result for a request to provide commands for the given text document and
/// range.
typedef TextDocumentCodeActionResult
    = List<Either2<CodeActionLiteral, Command>>?;

/// Result for a request to provide code lens for the given text document.
typedef TextDocumentCodeLensResult = List<CodeLens>?;

/// Result for request to request completion at a given text document position.
/// The request's parameter is of type [TextDocumentPosition] the response is of
/// type [CompletionItem] or [CompletionList] or a [Future] that resolves to
/// such.
///
/// The request can delay the computation of the [CompletionItem.detail] and
/// [CompletionItem.documentation] properties to the `completionItem/resolve`
/// request. However, properties that are needed for the initial sorting and
/// filtering, like `sortText`,
/// `filterText`, `insertText`, and `textEdit`, must not be changed during
/// resolve.
typedef TextDocumentCompletionResult
    = Either2<CompletionList, List<CompletionItem>>?;

/// An event describing a change to a text document. If only a text is provided
/// it is considered to be the full content of the document.
typedef TextDocumentContentChangeEvent = Either2<
    TextDocumentContentChangePartial, TextDocumentContentChangeWholeDocument>;

typedef TextDocumentContentChangeEvent2
    = TextDocumentContentChangeWholeDocument;

/// Result for a request to resolve the type definition locations of a symbol at
/// a given text document position. The request's parameter is of type
/// [TextDocumentPositionParams] the response is of type [Declaration] or a
/// typed array of [DeclarationLink] or a [Future] that resolves to such.
typedef TextDocumentDeclarationResult
    = Either2<Declaration, List<DeclarationLink>>?;

/// Result for a request to resolve the definition location of a symbol at a
/// given text document position. The request's parameter is of type
/// [TextDocumentPosition] the response is of either type [Definition] or a
/// typed array of
/// [DefinitionLink] or a [Future] that resolves to such.
typedef TextDocumentDefinitionResult
    = Either2<Definition, List<DefinitionLink>>?;

/// Result for request to resolve a [DocumentHighlight] for a given text
/// document position. The request's parameter is of type [TextDocumentPosition]
/// the request response is an array of type [DocumentHighlight] or a [Future]
/// that resolves to such.
typedef TextDocumentDocumentHighlightResult = List<DocumentHighlight>?;

/// Result for a request to provide document links
typedef TextDocumentDocumentLinkResult = List<DocumentLink>?;

/// Result for a request to list all symbols found in a given text document. The
/// request's parameter is of type [TextDocumentIdentifier] the response is of
/// type [SymbolInformation] or a [Future] that resolves to such.
typedef TextDocumentDocumentSymbolResult
    = Either2<List<DocumentSymbol>, List<SymbolInformation>>?;

/// A document filter denotes a document by different properties like the
/// [TextDocument.languageId], the [Uri.scheme] of its resource, or a
/// glob-pattern that is applied to the [TextDocument.fileName].
///
/// Glob patterns can have the following syntax:
/// - `*` to match one or more characters in a path segment
/// - `?` to match on one character in a path segment
/// - `**` to match any number of path segments, including none
/// - `{}` to group sub patterns into an OR expression. (e.g. `**​/*.{ts,js}`
/// matches all TypeScript and JavaScript files)
/// - `[]` to declare a range of characters to match in a path segment (e.g.,
/// `example.[0-9]` to match on `example.0`, `example.1`, …)
/// - `[!...]` to negate a range of characters to match in a path segment (e.g.,
/// `example.[!0-9]` to match on `example.a`, `example.b`, but not `example.0`)
///
/// @sample A language filter that applies to typescript files on disk: `{
/// language: 'typescript', scheme: 'file' }`
/// @sample A language filter that applies to all package.json paths: `{
/// language: 'json', pattern: '**package.json' }`
///
/// @since 3.17.0
typedef TextDocumentFilter = Either3<TextDocumentFilter1,
    TextDocumentFilterScheme, TextDocumentFilter3>;

/// Result for a request to provide folding ranges in a document. The request's
/// parameter is of type [FoldingRangeParams], the response is of type
/// [FoldingRangeList] or a [Future] that resolves to such.
typedef TextDocumentFoldingRangeResult = List<FoldingRange>?;

/// Result for a request to format a whole document.
typedef TextDocumentFormattingResult = List<TextEdit>?;

/// Result for request to request hover information at a given text document
/// position. The request's parameter is of type [TextDocumentPosition] the
/// response is of type [Hover] or a [Future] that resolves to such.
typedef TextDocumentHoverResult = Hover?;

/// Result for a request to resolve the implementation locations of a symbol at
/// a given text document position. The request's parameter is of type
/// [TextDocumentPositionParams] the response is of type [Definition] or a
/// [Future] that resolves to such.
typedef TextDocumentImplementationResult
    = Either2<Definition, List<DefinitionLink>>?;

/// Result for a request to provide inlay hints in a document. The request's
/// parameter is of type [InlayHintsParams], the response is of type
/// [InlayHint] or a [Future] that resolves to such.
///
/// @since 3.17.0
typedef TextDocumentInlayHintResult = List<InlayHint>?;

/// Result for a request to provide inline values in a document. The request's
/// parameter is of type [InlineValueParams], the response is of type
/// [InlineValue] or a [Future] that resolves to such.
///
/// @since 3.17.0
typedef TextDocumentInlineValueResult = List<InlineValue>?;

/// Result for a request to provide ranges that can be edited together.
///
/// @since 3.16.0
typedef TextDocumentLinkedEditingRangeResult = LinkedEditingRanges?;

/// Result for a request to get the moniker of a symbol at a given text document
/// position. The request parameter is of type [TextDocumentPositionParams]. The
/// response is of type [Moniker] or `null`.
typedef TextDocumentMonikerResult = List<Moniker>?;

/// Result for a request to format a document on type.
typedef TextDocumentOnTypeFormattingResult = List<TextEdit>?;

/// Result for a request to result a `CallHierarchyItem` in a document at a
/// given position. Can be used as an input to an incoming or outgoing call
/// hierarchy.
///
/// @since 3.16.0
typedef TextDocumentPrepareCallHierarchyResult = List<CallHierarchyItem>?;

/// Result for a request to test and perform the setup necessary for a rename.
///
/// @since 3.16 - support for default behavior
typedef TextDocumentPrepareRenameResult = PrepareRenameResult?;

/// Result for a request to result a `TypeHierarchyItem` in a document at a
/// given position. Can be used as an input to a subtypes or supertypes type
/// hierarchy.
///
/// @since 3.17.0
typedef TextDocumentPrepareTypeHierarchyResult = List<TypeHierarchyItem>?;

/// Result for a request to format a range in a document.
typedef TextDocumentRangeFormattingResult = List<TextEdit>?;

/// Result for a request to resolve project-wide references for the symbol
/// denoted by the given text document position. The request's parameter is of
/// type [ReferenceParams] the response is of type
/// [Location] or a [Future] that resolves to such.
typedef TextDocumentReferencesResult = List<Location>?;

/// Result for a request to rename a symbol.
typedef TextDocumentRenameResult = WorkspaceEdit?;

/// Result for a request to provide selection ranges in a document. The
/// request's parameter is of type [SelectionRangeParams], the response is of
/// type [SelectionRange] or a [Future] that resolves to such.
typedef TextDocumentSelectionRangeResult = List<SelectionRange>?;

/// Result for @since 3.16.0
typedef TextDocumentSemanticTokensFullDeltaResult
    = Either2<SemanticTokens, SemanticTokensDelta>?;

/// Result for @since 3.16.0
typedef TextDocumentSemanticTokensFullResult = SemanticTokens?;

/// Result for @since 3.16.0
typedef TextDocumentSemanticTokensRangeResult = SemanticTokens?;

typedef TextDocumentSignatureHelpResult = SignatureHelp?;

/// Result for a request to resolve the type definition locations of a symbol at
/// a given text document position. The request's parameter is of type
/// [TextDocumentPositionParams] the response is of type [Definition] or a
/// [Future] that resolves to such.
typedef TextDocumentTypeDefinitionResult
    = Either2<Definition, List<DefinitionLink>>?;

/// Result for a document will save request is sent from the client to the
/// server before the document is actually saved. The request can return an
/// array of TextEdits which will be applied to the text document before it is
/// saved. Please note that clients might drop results if computing the text
/// edits took too long or if a server constantly fails on this request. This is
/// done to keep the save fast and reliable.
typedef TextDocumentWillSaveWaitUntilResult = List<TextEdit>?;

/// Result for a request to resolve the subtypes for a given
/// `TypeHierarchyItem`.
///
/// @since 3.17.0
typedef TypeHierarchySubtypesResult = List<TypeHierarchyItem>?;

/// Result for a request to resolve the supertypes for a given
/// `TypeHierarchyItem`.
///
/// @since 3.17.0
typedef TypeHierarchySupertypesResult = List<TypeHierarchyItem>?;

/// Result for the show message request is sent from the server to the client to
/// show a message and a set of options actions to the user.
typedef WindowShowMessageRequestResult = MessageActionItem?;

/// A workspace diagnostic document report.
///
/// @since 3.17.0
typedef WorkspaceDocumentDiagnosticReport = Either2<
    WorkspaceFullDocumentDiagnosticReport,
    WorkspaceUnchangedDocumentDiagnosticReport>;

/// Result for a request send from the client to the server to execute a
/// command. The request might return a workspace edit which the client will
/// apply to the workspace.
typedef WorkspaceExecuteCommandResult = LSPAny?;

/// Result for a request to list project-wide symbols matching the query string
/// given by the [WorkspaceSymbolParams]. The response is of type
/// [SymbolInformation] or a [Future] that resolves to such.
///
/// @since 3.17.0 - support for WorkspaceSymbol in the returned data. Clients
///  need to advertise support for WorkspaceSymbols via the client capability
///  `workspace.symbol.resolveSupport`.
typedef WorkspaceSymbolResult
    = Either2<List<SymbolInformation>, List<WorkspaceSymbol>>?;

/// Result for the will create files request is sent from the client to the
/// server before files are actually created as long as the creation is
/// triggered from within the client.
///
/// The request can return a `WorkspaceEdit` which will be applied to workspace
/// before the files are created. Hence the `WorkspaceEdit` can not manipulate
/// the content of the file to be created.
///
/// @since 3.16.0
typedef WorkspaceWillCreateFilesResult = WorkspaceEdit?;

/// Result for the did delete files notification is sent from the client to the
/// server when files were deleted from within the client.
///
/// @since 3.16.0
typedef WorkspaceWillDeleteFilesResult = WorkspaceEdit?;

/// Result for the will rename files request is sent from the client to the
/// server before files are actually renamed as long as the rename is triggered
/// from within the client.
///
/// @since 3.16.0
typedef WorkspaceWillRenameFilesResult = WorkspaceEdit?;

/// Result for the `workspace/workspaceFolders` is sent from the server to the
/// client to fetch the open workspace folders.
typedef WorkspaceWorkspaceFoldersResult = List<WorkspaceFolder>?;

/// A special text edit with an additional change annotation.
///
/// @since 3.16.0.
class AnnotatedTextEdit implements TextEdit, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    AnnotatedTextEdit.canParse,
    AnnotatedTextEdit.fromJson,
  );

  /// The actual identifier of the change annotation
  final ChangeAnnotationIdentifier annotationId;

  /// The string to be inserted. For delete operations use an empty string.
  @override
  final String newText;

  /// The range of the text document to be manipulated. To insert text into a
  /// document create a range where start === end.
  @override
  final Range range;
  AnnotatedTextEdit({
    required this.annotationId,
    required this.newText,
    required this.range,
  });
  @override
  int get hashCode => Object.hash(
        annotationId,
        newText,
        range,
      );

  @override
  bool operator ==(Object other) {
    return other is AnnotatedTextEdit &&
        other.runtimeType == AnnotatedTextEdit &&
        annotationId == other.annotationId &&
        newText == other.newText &&
        range == other.range;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['annotationId'] = annotationId;
    result['newText'] = newText;
    result['range'] = range.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'annotationId',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'newText',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type AnnotatedTextEdit');
      return false;
    }
  }

  static AnnotatedTextEdit fromJson(Map<String, Object?> json) {
    final annotationIdJson = json['annotationId'];
    final annotationId = annotationIdJson as String;
    final newTextJson = json['newText'];
    final newText = newTextJson as String;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    return AnnotatedTextEdit(
      annotationId: annotationId,
      newText: newText,
      range: range,
    );
  }
}

/// The parameters passed via an apply workspace edit request.
class ApplyWorkspaceEditParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ApplyWorkspaceEditParams.canParse,
    ApplyWorkspaceEditParams.fromJson,
  );

  /// The edits to apply.
  final WorkspaceEdit edit;

  /// An optional label of the workspace edit. This label is presented in the
  /// user interface for example on an undo stack to undo the workspace edit.
  final String? label;

  ApplyWorkspaceEditParams({
    required this.edit,
    this.label,
  });
  @override
  int get hashCode => Object.hash(
        edit,
        label,
      );

  @override
  bool operator ==(Object other) {
    return other is ApplyWorkspaceEditParams &&
        other.runtimeType == ApplyWorkspaceEditParams &&
        edit == other.edit &&
        label == other.label;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['edit'] = edit.toJson();
    if (label != null) {
      result['label'] = label;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseWorkspaceEdit(obj, reporter, 'edit',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'label',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ApplyWorkspaceEditParams');
      return false;
    }
  }

  static ApplyWorkspaceEditParams fromJson(Map<String, Object?> json) {
    final editJson = json['edit'];
    final edit = WorkspaceEdit.fromJson(editJson as Map<String, Object?>);
    final labelJson = json['label'];
    final label = labelJson as String?;
    return ApplyWorkspaceEditParams(
      edit: edit,
      label: label,
    );
  }
}

/// The result returned from the apply workspace edit request.
///
/// @since 3.17 renamed from ApplyWorkspaceEditResponse
class ApplyWorkspaceEditResult implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ApplyWorkspaceEditResult.canParse,
    ApplyWorkspaceEditResult.fromJson,
  );

  /// Indicates whether the edit was applied or not.
  final bool applied;

  /// Depending on the client's failure handling strategy `failedChange` might
  /// contain the index of the change that failed. This property is only
  /// available if the client signals a `failureHandlingStrategy` in its client
  /// capabilities.
  final int? failedChange;

  /// An optional textual description for why the edit was not applied. This may
  /// be used by the server for diagnostic logging or to provide a suitable
  /// error for a request that triggered the edit.
  final String? failureReason;
  ApplyWorkspaceEditResult({
    required this.applied,
    this.failedChange,
    this.failureReason,
  });
  @override
  int get hashCode => Object.hash(
        applied,
        failedChange,
        failureReason,
      );

  @override
  bool operator ==(Object other) {
    return other is ApplyWorkspaceEditResult &&
        other.runtimeType == ApplyWorkspaceEditResult &&
        applied == other.applied &&
        failedChange == other.failedChange &&
        failureReason == other.failureReason;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['applied'] = applied;
    if (failedChange != null) {
      result['failedChange'] = failedChange;
    }
    if (failureReason != null) {
      result['failureReason'] = failureReason;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'applied',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseInt(obj, reporter, 'failedChange',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'failureReason',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ApplyWorkspaceEditResult');
      return false;
    }
  }

  static ApplyWorkspaceEditResult fromJson(Map<String, Object?> json) {
    final appliedJson = json['applied'];
    final applied = appliedJson as bool;
    final failedChangeJson = json['failedChange'];
    final failedChange = failedChangeJson as int?;
    final failureReasonJson = json['failureReason'];
    final failureReason = failureReasonJson as String?;
    return ApplyWorkspaceEditResult(
      applied: applied,
      failedChange: failedChange,
      failureReason: failureReason,
    );
  }
}

/// A base for all symbol information.
class BaseSymbolInformation implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    BaseSymbolInformation.canParse,
    BaseSymbolInformation.fromJson,
  );

  /// The name of the symbol containing this symbol. This information is for
  /// user interface purposes (e.g. to render a qualifier in the user interface
  /// if necessary). It can't be used to re-infer a hierarchy for the document
  /// symbols.
  final String? containerName;

  /// The kind of this symbol.
  final SymbolKind kind;

  /// The name of this symbol.
  final String name;

  /// Tags for this symbol.
  ///
  /// @since 3.16.0
  final List<SymbolTag>? tags;
  BaseSymbolInformation({
    this.containerName,
    required this.kind,
    required this.name,
    this.tags,
  });
  @override
  int get hashCode => Object.hash(
        containerName,
        kind,
        name,
        lspHashCode(tags),
      );

  @override
  bool operator ==(Object other) {
    return other is BaseSymbolInformation &&
        other.runtimeType == BaseSymbolInformation &&
        containerName == other.containerName &&
        kind == other.kind &&
        name == other.name &&
        const DeepCollectionEquality().equals(tags, other.tags);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (containerName != null) {
      result['containerName'] = containerName;
    }
    result['kind'] = kind.toJson();
    result['name'] = name;
    if (tags != null) {
      result['tags'] = tags?.map((item) => item.toJson()).toList();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'containerName',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseSymbolKind(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'name',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseListSymbolTag(obj, reporter, 'tags',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type BaseSymbolInformation');
      return false;
    }
  }

  static BaseSymbolInformation fromJson(Map<String, Object?> json) {
    if (SymbolInformation.canParse(json, nullLspJsonReporter)) {
      return SymbolInformation.fromJson(json);
    }
    if (WorkspaceSymbol.canParse(json, nullLspJsonReporter)) {
      return WorkspaceSymbol.fromJson(json);
    }
    final containerNameJson = json['containerName'];
    final containerName = containerNameJson as String?;
    final kindJson = json['kind'];
    final kind = SymbolKind.fromJson(kindJson as int);
    final nameJson = json['name'];
    final name = nameJson as String;
    final tagsJson = json['tags'];
    final tags = (tagsJson as List<Object?>?)
        ?.map((item) => SymbolTag.fromJson(item as int))
        .toList();
    return BaseSymbolInformation(
      containerName: containerName,
      kind: kind,
      name: name,
      tags: tags,
    );
  }
}

/// @since 3.16.0
class CallHierarchyClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CallHierarchyClientCapabilities.canParse,
    CallHierarchyClientCapabilities.fromJson,
  );

  /// Whether implementation supports dynamic registration. If this is set to
  /// `true` the client supports the new `(TextDocumentRegistrationOptions &
  /// StaticRegistrationOptions)` return value for the corresponding server
  /// capability as well.
  final bool? dynamicRegistration;

  CallHierarchyClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is CallHierarchyClientCapabilities &&
        other.runtimeType == CallHierarchyClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CallHierarchyClientCapabilities');
      return false;
    }
  }

  static CallHierarchyClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return CallHierarchyClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// Represents an incoming call, e.g. a caller of a method or constructor.
///
/// @since 3.16.0
class CallHierarchyIncomingCall implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CallHierarchyIncomingCall.canParse,
    CallHierarchyIncomingCall.fromJson,
  );

  /// The item that makes the call.
  final CallHierarchyItem from;

  /// The ranges at which the calls appear. This is relative to the caller
  /// denoted by [CallHierarchyIncomingCall.from].
  final List<Range> fromRanges;

  CallHierarchyIncomingCall({
    required this.from,
    required this.fromRanges,
  });
  @override
  int get hashCode => Object.hash(
        from,
        lspHashCode(fromRanges),
      );

  @override
  bool operator ==(Object other) {
    return other is CallHierarchyIncomingCall &&
        other.runtimeType == CallHierarchyIncomingCall &&
        from == other.from &&
        const DeepCollectionEquality().equals(fromRanges, other.fromRanges);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['from'] = from.toJson();
    result['fromRanges'] = fromRanges.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCallHierarchyItem(obj, reporter, 'from',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseListRange(obj, reporter, 'fromRanges',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CallHierarchyIncomingCall');
      return false;
    }
  }

  static CallHierarchyIncomingCall fromJson(Map<String, Object?> json) {
    final fromJson = json['from'];
    final from = CallHierarchyItem.fromJson(fromJson as Map<String, Object?>);
    final fromRangesJson = json['fromRanges'];
    final fromRanges = (fromRangesJson as List<Object?>)
        .map((item) => Range.fromJson(item as Map<String, Object?>))
        .toList();
    return CallHierarchyIncomingCall(
      from: from,
      fromRanges: fromRanges,
    );
  }
}

/// The parameter of a `callHierarchy/incomingCalls` request.
///
/// @since 3.16.0
class CallHierarchyIncomingCallsParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CallHierarchyIncomingCallsParams.canParse,
    CallHierarchyIncomingCallsParams.fromJson,
  );

  final CallHierarchyItem item;

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  CallHierarchyIncomingCallsParams({
    required this.item,
    this.partialResultToken,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        item,
        partialResultToken,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is CallHierarchyIncomingCallsParams &&
        other.runtimeType == CallHierarchyIncomingCallsParams &&
        item == other.item &&
        partialResultToken == other.partialResultToken &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['item'] = item.toJson();
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCallHierarchyItem(obj, reporter, 'item',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CallHierarchyIncomingCallsParams');
      return false;
    }
  }

  static CallHierarchyIncomingCallsParams fromJson(Map<String, Object?> json) {
    final itemJson = json['item'];
    final item = CallHierarchyItem.fromJson(itemJson as Map<String, Object?>);
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return CallHierarchyIncomingCallsParams(
      item: item,
      partialResultToken: partialResultToken,
      workDoneToken: workDoneToken,
    );
  }
}

/// Represents programming constructs like functions or constructors in the
/// context of call hierarchy.
///
/// @since 3.16.0
class CallHierarchyItem implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CallHierarchyItem.canParse,
    CallHierarchyItem.fromJson,
  );

  /// A data entry field that is preserved between a call hierarchy prepare and
  /// incoming calls or outgoing calls requests.
  final LSPAny data;

  /// More detail for this item, e.g. the signature of a function.
  final String? detail;

  /// The kind of this item.
  final SymbolKind kind;

  /// The name of this item.
  final String name;

  /// The range enclosing this symbol not including leading/trailing whitespace
  /// but everything else, e.g. comments and code.
  final Range range;

  /// The range that should be selected and revealed when this symbol is being
  /// picked, e.g. the name of a function. Must be contained by the
  /// [CallHierarchyItem.range].
  final Range selectionRange;

  /// Tags for this item.
  final List<SymbolTag>? tags;

  /// The resource identifier of this item.
  final DocumentUri uri;
  CallHierarchyItem({
    this.data,
    this.detail,
    required this.kind,
    required this.name,
    required this.range,
    required this.selectionRange,
    this.tags,
    required this.uri,
  });
  @override
  int get hashCode => Object.hash(
        data,
        detail,
        kind,
        name,
        range,
        selectionRange,
        lspHashCode(tags),
        uri,
      );

  @override
  bool operator ==(Object other) {
    return other is CallHierarchyItem &&
        other.runtimeType == CallHierarchyItem &&
        data == other.data &&
        detail == other.detail &&
        kind == other.kind &&
        name == other.name &&
        range == other.range &&
        selectionRange == other.selectionRange &&
        const DeepCollectionEquality().equals(tags, other.tags) &&
        uri == other.uri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (data != null) {
      result['data'] = data;
    }
    if (detail != null) {
      result['detail'] = detail;
    }
    result['kind'] = kind.toJson();
    result['name'] = name;
    result['range'] = range.toJson();
    result['selectionRange'] = selectionRange.toJson();
    if (tags != null) {
      result['tags'] = tags?.map((item) => item.toJson()).toList();
    }
    result['uri'] = uri.toString();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'detail',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseSymbolKind(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'name',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'selectionRange',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseListSymbolTag(obj, reporter, 'tags',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CallHierarchyItem');
      return false;
    }
  }

  static CallHierarchyItem fromJson(Map<String, Object?> json) {
    final dataJson = json['data'];
    final data = dataJson;
    final detailJson = json['detail'];
    final detail = detailJson as String?;
    final kindJson = json['kind'];
    final kind = SymbolKind.fromJson(kindJson as int);
    final nameJson = json['name'];
    final name = nameJson as String;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final selectionRangeJson = json['selectionRange'];
    final selectionRange =
        Range.fromJson(selectionRangeJson as Map<String, Object?>);
    final tagsJson = json['tags'];
    final tags = (tagsJson as List<Object?>?)
        ?.map((item) => SymbolTag.fromJson(item as int))
        .toList();
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    return CallHierarchyItem(
      data: data,
      detail: detail,
      kind: kind,
      name: name,
      range: range,
      selectionRange: selectionRange,
      tags: tags,
      uri: uri,
    );
  }
}

/// Call hierarchy options used during static registration.
///
/// @since 3.16.0
class CallHierarchyOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CallHierarchyOptions.canParse,
    CallHierarchyOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  CallHierarchyOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is CallHierarchyOptions &&
        other.runtimeType == CallHierarchyOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CallHierarchyOptions');
      return false;
    }
  }

  static CallHierarchyOptions fromJson(Map<String, Object?> json) {
    if (CallHierarchyRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return CallHierarchyRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return CallHierarchyOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Represents an outgoing call, e.g. calling a getter from a method or a method
/// from a constructor etc.
///
/// @since 3.16.0
class CallHierarchyOutgoingCall implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CallHierarchyOutgoingCall.canParse,
    CallHierarchyOutgoingCall.fromJson,
  );

  /// The range at which this item is called. This is the range relative to the
  /// caller, e.g the item passed to
  /// [CallHierarchyItemProvider.provideCallHierarchyOutgoingCalls] and not
  /// [CallHierarchyOutgoingCall.to].
  final List<Range> fromRanges;

  /// The item that is called.
  final CallHierarchyItem to;

  CallHierarchyOutgoingCall({
    required this.fromRanges,
    required this.to,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(fromRanges),
        to,
      );

  @override
  bool operator ==(Object other) {
    return other is CallHierarchyOutgoingCall &&
        other.runtimeType == CallHierarchyOutgoingCall &&
        const DeepCollectionEquality().equals(fromRanges, other.fromRanges) &&
        to == other.to;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['fromRanges'] = fromRanges.map((item) => item.toJson()).toList();
    result['to'] = to.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListRange(obj, reporter, 'fromRanges',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseCallHierarchyItem(obj, reporter, 'to',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CallHierarchyOutgoingCall');
      return false;
    }
  }

  static CallHierarchyOutgoingCall fromJson(Map<String, Object?> json) {
    final fromRangesJson = json['fromRanges'];
    final fromRanges = (fromRangesJson as List<Object?>)
        .map((item) => Range.fromJson(item as Map<String, Object?>))
        .toList();
    final toJson = json['to'];
    final to = CallHierarchyItem.fromJson(toJson as Map<String, Object?>);
    return CallHierarchyOutgoingCall(
      fromRanges: fromRanges,
      to: to,
    );
  }
}

/// The parameter of a `callHierarchy/outgoingCalls` request.
///
/// @since 3.16.0
class CallHierarchyOutgoingCallsParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CallHierarchyOutgoingCallsParams.canParse,
    CallHierarchyOutgoingCallsParams.fromJson,
  );

  final CallHierarchyItem item;

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  CallHierarchyOutgoingCallsParams({
    required this.item,
    this.partialResultToken,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        item,
        partialResultToken,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is CallHierarchyOutgoingCallsParams &&
        other.runtimeType == CallHierarchyOutgoingCallsParams &&
        item == other.item &&
        partialResultToken == other.partialResultToken &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['item'] = item.toJson();
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCallHierarchyItem(obj, reporter, 'item',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CallHierarchyOutgoingCallsParams');
      return false;
    }
  }

  static CallHierarchyOutgoingCallsParams fromJson(Map<String, Object?> json) {
    final itemJson = json['item'];
    final item = CallHierarchyItem.fromJson(itemJson as Map<String, Object?>);
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return CallHierarchyOutgoingCallsParams(
      item: item,
      partialResultToken: partialResultToken,
      workDoneToken: workDoneToken,
    );
  }
}

/// The parameter of a `textDocument/prepareCallHierarchy` request.
///
/// @since 3.16.0
class CallHierarchyPrepareParams
    implements TextDocumentPositionParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CallHierarchyPrepareParams.canParse,
    CallHierarchyPrepareParams.fromJson,
  );

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  CallHierarchyPrepareParams({
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is CallHierarchyPrepareParams &&
        other.runtimeType == CallHierarchyPrepareParams &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CallHierarchyPrepareParams');
      return false;
    }
  }

  static CallHierarchyPrepareParams fromJson(Map<String, Object?> json) {
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return CallHierarchyPrepareParams(
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Call hierarchy options used during static or dynamic registration.
///
/// @since 3.16.0
class CallHierarchyRegistrationOptions
    implements
        CallHierarchyOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CallHierarchyRegistrationOptions.canParse,
    CallHierarchyRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  @override
  final bool? workDoneProgress;
  CallHierarchyRegistrationOptions({
    this.documentSelector,
    this.id,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is CallHierarchyRegistrationOptions &&
        other.runtimeType == CallHierarchyRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CallHierarchyRegistrationOptions');
      return false;
    }
  }

  static CallHierarchyRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return CallHierarchyRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      workDoneProgress: workDoneProgress,
    );
  }
}

class CancelParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CancelParams.canParse,
    CancelParams.fromJson,
  );

  /// The request id to cancel.
  final Either2<int, String> id;

  CancelParams({
    required this.id,
  });

  @override
  int get hashCode => id.hashCode;

  @override
  bool operator ==(Object other) {
    return other is CancelParams &&
        other.runtimeType == CancelParams &&
        id == other.id;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['id'] = id;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseIntString(obj, reporter, 'id',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CancelParams');
      return false;
    }
  }

  static CancelParams fromJson(Map<String, Object?> json) {
    final idJson = json['id'];
    final id = _eitherIntString(idJson);
    return CancelParams(
      id: id,
    );
  }
}

/// Additional information that describes document changes.
///
/// @since 3.16.0
class ChangeAnnotation implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ChangeAnnotation.canParse,
    ChangeAnnotation.fromJson,
  );

  /// A human-readable string which is rendered less prominent in the user
  /// interface.
  final String? description;

  /// A human-readable string describing the actual change. The string is
  /// rendered prominent in the user interface.
  final String label;

  /// A flag which indicates that user confirmation is needed before applying
  /// the change.
  final bool? needsConfirmation;
  ChangeAnnotation({
    this.description,
    required this.label,
    this.needsConfirmation,
  });
  @override
  int get hashCode => Object.hash(
        description,
        label,
        needsConfirmation,
      );

  @override
  bool operator ==(Object other) {
    return other is ChangeAnnotation &&
        other.runtimeType == ChangeAnnotation &&
        description == other.description &&
        label == other.label &&
        needsConfirmation == other.needsConfirmation;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (description != null) {
      result['description'] = description;
    }
    result['label'] = label;
    if (needsConfirmation != null) {
      result['needsConfirmation'] = needsConfirmation;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'description',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'label',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'needsConfirmation',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ChangeAnnotation');
      return false;
    }
  }

  static ChangeAnnotation fromJson(Map<String, Object?> json) {
    final descriptionJson = json['description'];
    final description = descriptionJson as String?;
    final labelJson = json['label'];
    final label = labelJson as String;
    final needsConfirmationJson = json['needsConfirmation'];
    final needsConfirmation = needsConfirmationJson as bool?;
    return ChangeAnnotation(
      description: description,
      label: label,
      needsConfirmation: needsConfirmation,
    );
  }
}

/// Defines the capabilities provided by the client.
class ClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ClientCapabilities.canParse,
    ClientCapabilities.fromJson,
  );

  /// Experimental client capabilities.
  final LSPAny experimental;

  /// General client capabilities.
  ///
  /// @since 3.16.0
  final GeneralClientCapabilities? general;

  /// Capabilities specific to the notebook document support.
  ///
  /// @since 3.17.0
  final NotebookDocumentClientCapabilities? notebookDocument;

  /// Text document specific client capabilities.
  final TextDocumentClientCapabilities? textDocument;

  /// Window specific client capabilities.
  final WindowClientCapabilities? window;

  /// Workspace specific client capabilities.
  final WorkspaceClientCapabilities? workspace;
  ClientCapabilities({
    this.experimental,
    this.general,
    this.notebookDocument,
    this.textDocument,
    this.window,
    this.workspace,
  });
  @override
  int get hashCode => Object.hash(
        experimental,
        general,
        notebookDocument,
        textDocument,
        window,
        workspace,
      );

  @override
  bool operator ==(Object other) {
    return other is ClientCapabilities &&
        other.runtimeType == ClientCapabilities &&
        experimental == other.experimental &&
        general == other.general &&
        notebookDocument == other.notebookDocument &&
        textDocument == other.textDocument &&
        window == other.window &&
        workspace == other.workspace;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (experimental != null) {
      result['experimental'] = experimental;
    }
    if (general != null) {
      result['general'] = general?.toJson();
    }
    if (notebookDocument != null) {
      result['notebookDocument'] = notebookDocument?.toJson();
    }
    if (textDocument != null) {
      result['textDocument'] = textDocument?.toJson();
    }
    if (window != null) {
      result['window'] = window?.toJson();
    }
    if (workspace != null) {
      result['workspace'] = workspace?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseGeneralClientCapabilities(obj, reporter, 'general',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseNotebookDocumentClientCapabilities(
          obj, reporter, 'notebookDocument',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentClientCapabilities(
          obj, reporter, 'textDocument',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseWindowClientCapabilities(obj, reporter, 'window',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseWorkspaceClientCapabilities(obj, reporter, 'workspace',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ClientCapabilities');
      return false;
    }
  }

  static ClientCapabilities fromJson(Map<String, Object?> json) {
    final experimentalJson = json['experimental'];
    final experimental = experimentalJson;
    final generalJson = json['general'];
    final general = generalJson != null
        ? GeneralClientCapabilities.fromJson(
            generalJson as Map<String, Object?>)
        : null;
    final notebookDocumentJson = json['notebookDocument'];
    final notebookDocument = notebookDocumentJson != null
        ? NotebookDocumentClientCapabilities.fromJson(
            notebookDocumentJson as Map<String, Object?>)
        : null;
    final textDocumentJson = json['textDocument'];
    final textDocument = textDocumentJson != null
        ? TextDocumentClientCapabilities.fromJson(
            textDocumentJson as Map<String, Object?>)
        : null;
    final windowJson = json['window'];
    final window = windowJson != null
        ? WindowClientCapabilities.fromJson(windowJson as Map<String, Object?>)
        : null;
    final workspaceJson = json['workspace'];
    final workspace = workspaceJson != null
        ? WorkspaceClientCapabilities.fromJson(
            workspaceJson as Map<String, Object?>)
        : null;
    return ClientCapabilities(
      experimental: experimental,
      general: general,
      notebookDocument: notebookDocument,
      textDocument: textDocument,
      window: window,
      workspace: workspace,
    );
  }
}

class ClientCodeActionKindOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ClientCodeActionKindOptions.canParse,
    ClientCodeActionKindOptions.fromJson,
  );

  /// The code action kind values the client supports. When this property exists
  /// the client also guarantees that it will handle values outside its set
  /// gracefully and falls back to a default value when unknown.
  final List<CodeActionKind> valueSet;

  ClientCodeActionKindOptions({
    required this.valueSet,
  });

  @override
  int get hashCode => lspHashCode(valueSet);

  @override
  bool operator ==(Object other) {
    return other is ClientCodeActionKindOptions &&
        other.runtimeType == ClientCodeActionKindOptions &&
        const DeepCollectionEquality().equals(valueSet, other.valueSet);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['valueSet'] = valueSet.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListCodeActionKind(obj, reporter, 'valueSet',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type ClientCodeActionKindOptions');
      return false;
    }
  }

  static ClientCodeActionKindOptions fromJson(Map<String, Object?> json) {
    final valueSetJson = json['valueSet'];
    final valueSet = (valueSetJson as List<Object?>)
        .map((item) => CodeActionKind.fromJson(item as String))
        .toList();
    return ClientCodeActionKindOptions(
      valueSet: valueSet,
    );
  }
}

class ClientCompletionItemOptionsKind implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ClientCompletionItemOptionsKind.canParse,
    ClientCompletionItemOptionsKind.fromJson,
  );

  /// The completion item kind values the client supports. When this property
  /// exists the client also guarantees that it will handle values outside its
  /// set gracefully and falls back to a default value when unknown.
  ///
  /// If this property is not present the client only supports the completion
  /// items kinds from `Text` to `Reference` as defined in the initial version
  /// of the protocol.
  final List<CompletionItemKind>? valueSet;

  ClientCompletionItemOptionsKind({
    this.valueSet,
  });

  @override
  int get hashCode => lspHashCode(valueSet);

  @override
  bool operator ==(Object other) {
    return other is ClientCompletionItemOptionsKind &&
        other.runtimeType == ClientCompletionItemOptionsKind &&
        const DeepCollectionEquality().equals(valueSet, other.valueSet);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (valueSet != null) {
      result['valueSet'] = valueSet?.map((item) => item.toJson()).toList();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListCompletionItemKind(obj, reporter, 'valueSet',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ClientCompletionItemOptionsKind');
      return false;
    }
  }

  static ClientCompletionItemOptionsKind fromJson(Map<String, Object?> json) {
    final valueSetJson = json['valueSet'];
    final valueSet = (valueSetJson as List<Object?>?)
        ?.map((item) => CompletionItemKind.fromJson(item as int))
        .toList();
    return ClientCompletionItemOptionsKind(
      valueSet: valueSet,
    );
  }
}

class ClientInfo implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ClientInfo.canParse,
    ClientInfo.fromJson,
  );

  /// The name of the client as defined by the client.
  final String name;

  /// The client's version as defined by the client.
  final String? version;

  ClientInfo({
    required this.name,
    this.version,
  });
  @override
  int get hashCode => Object.hash(
        name,
        version,
      );

  @override
  bool operator ==(Object other) {
    return other is ClientInfo &&
        other.runtimeType == ClientInfo &&
        name == other.name &&
        version == other.version;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['name'] = name;
    if (version != null) {
      result['version'] = version;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'name',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'version',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ClientInfo');
      return false;
    }
  }

  static ClientInfo fromJson(Map<String, Object?> json) {
    final nameJson = json['name'];
    final name = nameJson as String;
    final versionJson = json['version'];
    final version = versionJson as String?;
    return ClientInfo(
      name: name,
      version: version,
    );
  }
}

class ClientSemanticTokensRequestOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ClientSemanticTokensRequestOptions.canParse,
    ClientSemanticTokensRequestOptions.fromJson,
  );

  /// The client will send the `textDocument/semanticTokens/full` request if the
  /// server provides a corresponding handler.
  final Either2<bool, SemanticTokensClientCapabilitiesRequestsFull>? full;

  /// The client will send the `textDocument/semanticTokens/range` request if
  /// the server provides a corresponding handler.
  final Either2<bool, SemanticTokensClientCapabilitiesRequestsRange>? range;

  ClientSemanticTokensRequestOptions({
    this.full,
    this.range,
  });
  @override
  int get hashCode => Object.hash(
        full,
        range,
      );

  @override
  bool operator ==(Object other) {
    return other is ClientSemanticTokensRequestOptions &&
        other.runtimeType == ClientSemanticTokensRequestOptions &&
        full == other.full &&
        range == other.range;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (full != null) {
      result['full'] = full;
    }
    if (range != null) {
      result['range'] = range;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBoolSemanticTokensClientCapabilitiesRequestsFull(
          obj, reporter, 'full',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBoolSemanticTokensClientCapabilitiesRequestsRange(
          obj, reporter, 'range',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type ClientSemanticTokensRequestOptions');
      return false;
    }
  }

  static ClientSemanticTokensRequestOptions fromJson(
      Map<String, Object?> json) {
    final fullJson = json['full'];
    final full = fullJson == null
        ? null
        : _eitherBoolSemanticTokensClientCapabilitiesRequestsFull(fullJson);
    final rangeJson = json['range'];
    final range = rangeJson == null
        ? null
        : _eitherBoolSemanticTokensClientCapabilitiesRequestsRange(rangeJson);
    return ClientSemanticTokensRequestOptions(
      full: full,
      range: range,
    );
  }
}

/// The Client Capabilities of a [CodeActionRequest].
class CodeActionClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeActionClientCapabilities.canParse,
    CodeActionClientCapabilities.fromJson,
  );

  /// The client support code action literals of type `CodeAction` as a valid
  /// response of the `textDocument/codeAction` request. If the property is not
  /// set the request can only return `Command` literals.
  ///
  /// @since 3.8.0
  final CodeActionClientCapabilitiesCodeActionLiteralSupport?
      codeActionLiteralSupport;

  /// Whether code action supports the `data` property which is preserved
  /// between a `textDocument/codeAction` and a `codeAction/resolve` request.
  ///
  /// @since 3.16.0
  final bool? dataSupport;

  /// Whether code action supports the `disabled` property.
  ///
  /// @since 3.16.0
  final bool? disabledSupport;

  /// Whether code action supports dynamic registration.
  final bool? dynamicRegistration;

  /// Whether the client honors the change annotations in text edits and
  /// resource operations returned via the `CodeAction#edit` property by for
  /// example presenting the workspace edit in the user interface and asking for
  /// confirmation.
  ///
  /// @since 3.16.0
  final bool? honorsChangeAnnotations;

  /// Whether code action supports the `isPreferred` property.
  ///
  /// @since 3.15.0
  final bool? isPreferredSupport;

  /// Whether the client supports resolving additional code action properties
  /// via a separate `codeAction/resolve` request.
  ///
  /// @since 3.16.0
  final CodeActionClientCapabilitiesResolveSupport? resolveSupport;
  CodeActionClientCapabilities({
    this.codeActionLiteralSupport,
    this.dataSupport,
    this.disabledSupport,
    this.dynamicRegistration,
    this.honorsChangeAnnotations,
    this.isPreferredSupport,
    this.resolveSupport,
  });
  @override
  int get hashCode => Object.hash(
        codeActionLiteralSupport,
        dataSupport,
        disabledSupport,
        dynamicRegistration,
        honorsChangeAnnotations,
        isPreferredSupport,
        resolveSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeActionClientCapabilities &&
        other.runtimeType == CodeActionClientCapabilities &&
        codeActionLiteralSupport == other.codeActionLiteralSupport &&
        dataSupport == other.dataSupport &&
        disabledSupport == other.disabledSupport &&
        dynamicRegistration == other.dynamicRegistration &&
        honorsChangeAnnotations == other.honorsChangeAnnotations &&
        isPreferredSupport == other.isPreferredSupport &&
        resolveSupport == other.resolveSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (codeActionLiteralSupport != null) {
      result['codeActionLiteralSupport'] = codeActionLiteralSupport?.toJson();
    }
    if (dataSupport != null) {
      result['dataSupport'] = dataSupport;
    }
    if (disabledSupport != null) {
      result['disabledSupport'] = disabledSupport;
    }
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (honorsChangeAnnotations != null) {
      result['honorsChangeAnnotations'] = honorsChangeAnnotations;
    }
    if (isPreferredSupport != null) {
      result['isPreferredSupport'] = isPreferredSupport;
    }
    if (resolveSupport != null) {
      result['resolveSupport'] = resolveSupport?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCodeActionClientCapabilitiesCodeActionLiteralSupport(
          obj, reporter, 'codeActionLiteralSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'dataSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'disabledSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'honorsChangeAnnotations',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'isPreferredSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseCodeActionClientCapabilitiesResolveSupport(
          obj, reporter, 'resolveSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeActionClientCapabilities');
      return false;
    }
  }

  static CodeActionClientCapabilities fromJson(Map<String, Object?> json) {
    final codeActionLiteralSupportJson = json['codeActionLiteralSupport'];
    final codeActionLiteralSupport = codeActionLiteralSupportJson != null
        ? CodeActionClientCapabilitiesCodeActionLiteralSupport.fromJson(
            codeActionLiteralSupportJson as Map<String, Object?>)
        : null;
    final dataSupportJson = json['dataSupport'];
    final dataSupport = dataSupportJson as bool?;
    final disabledSupportJson = json['disabledSupport'];
    final disabledSupport = disabledSupportJson as bool?;
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final honorsChangeAnnotationsJson = json['honorsChangeAnnotations'];
    final honorsChangeAnnotations = honorsChangeAnnotationsJson as bool?;
    final isPreferredSupportJson = json['isPreferredSupport'];
    final isPreferredSupport = isPreferredSupportJson as bool?;
    final resolveSupportJson = json['resolveSupport'];
    final resolveSupport = resolveSupportJson != null
        ? CodeActionClientCapabilitiesResolveSupport.fromJson(
            resolveSupportJson as Map<String, Object?>)
        : null;
    return CodeActionClientCapabilities(
      codeActionLiteralSupport: codeActionLiteralSupport,
      dataSupport: dataSupport,
      disabledSupport: disabledSupport,
      dynamicRegistration: dynamicRegistration,
      honorsChangeAnnotations: honorsChangeAnnotations,
      isPreferredSupport: isPreferredSupport,
      resolveSupport: resolveSupport,
    );
  }
}

class CodeActionClientCapabilitiesCodeActionLiteralSupport
    implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeActionClientCapabilitiesCodeActionLiteralSupport.canParse,
    CodeActionClientCapabilitiesCodeActionLiteralSupport.fromJson,
  );

  /// The code action kind is support with the following value set.
  final ClientCodeActionKindOptions codeActionKind;

  CodeActionClientCapabilitiesCodeActionLiteralSupport({
    required this.codeActionKind,
  });

  @override
  int get hashCode => codeActionKind.hashCode;

  @override
  bool operator ==(Object other) {
    return other is CodeActionClientCapabilitiesCodeActionLiteralSupport &&
        other.runtimeType ==
            CodeActionClientCapabilitiesCodeActionLiteralSupport &&
        codeActionKind == other.codeActionKind;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['codeActionKind'] = codeActionKind.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseClientCodeActionKindOptions(
          obj, reporter, 'codeActionKind',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type CodeActionClientCapabilitiesCodeActionLiteralSupport');
      return false;
    }
  }

  static CodeActionClientCapabilitiesCodeActionLiteralSupport fromJson(
      Map<String, Object?> json) {
    final codeActionKindJson = json['codeActionKind'];
    final codeActionKind = ClientCodeActionKindOptions.fromJson(
        codeActionKindJson as Map<String, Object?>);
    return CodeActionClientCapabilitiesCodeActionLiteralSupport(
      codeActionKind: codeActionKind,
    );
  }
}

class CodeActionClientCapabilitiesResolveSupport implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeActionClientCapabilitiesResolveSupport.canParse,
    CodeActionClientCapabilitiesResolveSupport.fromJson,
  );

  /// The properties that a client can resolve lazily.
  final List<String> properties;

  CodeActionClientCapabilitiesResolveSupport({
    required this.properties,
  });

  @override
  int get hashCode => lspHashCode(properties);

  @override
  bool operator ==(Object other) {
    return other is CodeActionClientCapabilitiesResolveSupport &&
        other.runtimeType == CodeActionClientCapabilitiesResolveSupport &&
        const DeepCollectionEquality().equals(properties, other.properties);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['properties'] = properties;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListString(obj, reporter, 'properties',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type CodeActionClientCapabilitiesResolveSupport');
      return false;
    }
  }

  static CodeActionClientCapabilitiesResolveSupport fromJson(
      Map<String, Object?> json) {
    final propertiesJson = json['properties'];
    final properties = (propertiesJson as List<Object?>)
        .map((item) => item as String)
        .toList();
    return CodeActionClientCapabilitiesResolveSupport(
      properties: properties,
    );
  }
}

/// Contains additional diagnostic information about the context in which a
/// [CodeActionProvider.provideCodeActions] is run.
class CodeActionContext implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeActionContext.canParse,
    CodeActionContext.fromJson,
  );

  /// An array of diagnostics known on the client side overlapping the range
  /// provided to the `textDocument/codeAction` request. They are provided so
  /// that the server knows which errors are currently presented to the user for
  /// the given range. There is no guarantee that these accurately reflect the
  /// error state of the resource. The primary parameter to compute code actions
  /// is the provided range.
  final List<Diagnostic> diagnostics;

  /// Requested kind of actions to return.
  ///
  /// Actions not of this kind are filtered out by the client before being
  /// shown. So servers can omit computing them.
  final List<CodeActionKind>? only;

  /// The reason why code actions were requested.
  ///
  /// @since 3.17.0
  final CodeActionTriggerKind? triggerKind;
  CodeActionContext({
    required this.diagnostics,
    this.only,
    this.triggerKind,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(diagnostics),
        lspHashCode(only),
        triggerKind,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeActionContext &&
        other.runtimeType == CodeActionContext &&
        const DeepCollectionEquality().equals(diagnostics, other.diagnostics) &&
        const DeepCollectionEquality().equals(only, other.only) &&
        triggerKind == other.triggerKind;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['diagnostics'] = diagnostics.map((item) => item.toJson()).toList();
    if (only != null) {
      result['only'] = only?.map((item) => item.toJson()).toList();
    }
    if (triggerKind != null) {
      result['triggerKind'] = triggerKind?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListDiagnostic(obj, reporter, 'diagnostics',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseListCodeActionKind(obj, reporter, 'only',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseCodeActionTriggerKind(obj, reporter, 'triggerKind',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeActionContext');
      return false;
    }
  }

  static CodeActionContext fromJson(Map<String, Object?> json) {
    final diagnosticsJson = json['diagnostics'];
    final diagnostics = (diagnosticsJson as List<Object?>)
        .map((item) => Diagnostic.fromJson(item as Map<String, Object?>))
        .toList();
    final onlyJson = json['only'];
    final only = (onlyJson as List<Object?>?)
        ?.map((item) => CodeActionKind.fromJson(item as String))
        .toList();
    final triggerKindJson = json['triggerKind'];
    final triggerKind = triggerKindJson != null
        ? CodeActionTriggerKind.fromJson(triggerKindJson as int)
        : null;
    return CodeActionContext(
      diagnostics: diagnostics,
      only: only,
      triggerKind: triggerKind,
    );
  }
}

class CodeActionDisabled implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeActionDisabled.canParse,
    CodeActionDisabled.fromJson,
  );

  /// Human readable description of why the code action is currently disabled.
  ///
  /// This is displayed in the code actions UI.
  final String reason;

  CodeActionDisabled({
    required this.reason,
  });

  @override
  int get hashCode => reason.hashCode;

  @override
  bool operator ==(Object other) {
    return other is CodeActionDisabled &&
        other.runtimeType == CodeActionDisabled &&
        reason == other.reason;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['reason'] = reason;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseString(obj, reporter, 'reason',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeActionDisabled');
      return false;
    }
  }

  static CodeActionDisabled fromJson(Map<String, Object?> json) {
    final reasonJson = json['reason'];
    final reason = reasonJson as String;
    return CodeActionDisabled(
      reason: reason,
    );
  }
}

/// A set of predefined code action kinds
class CodeActionKind implements ToJsonable {
  /// Empty kind.
  static const Empty = CodeActionKind('');

  /// Base kind for quickfix actions: 'quickfix'
  static const QuickFix = CodeActionKind('quickfix');

  /// Base kind for refactoring actions: 'refactor'
  static const Refactor = CodeActionKind('refactor');

  /// Base kind for refactoring extraction actions: 'refactor.extract'
  ///
  /// Example extract actions:
  ///
  /// - Extract method
  /// - Extract function
  /// - Extract variable
  /// - Extract interface from class
  /// - ...
  static const RefactorExtract = CodeActionKind('refactor.extract');

  /// Base kind for refactoring inline actions: 'refactor.inline'
  ///
  /// Example inline actions:
  ///
  /// - Inline function
  /// - Inline variable
  /// - Inline constant
  /// - ...
  static const RefactorInline = CodeActionKind('refactor.inline');

  /// Base kind for refactoring rewrite actions: 'refactor.rewrite'
  ///
  /// Example rewrite actions:
  ///
  /// - Convert JavaScript function to class
  /// - Add or remove parameter
  /// - Encapsulate field
  /// - Make method static
  /// - Move method to base class
  /// - ...
  static const RefactorRewrite = CodeActionKind('refactor.rewrite');

  /// Base kind for source actions: `source`
  ///
  /// Source code actions apply to the entire file.
  static const Source = CodeActionKind('source');

  /// Base kind for auto-fix source actions: `source.fixAll`.
  ///
  /// Fix all actions automatically fix errors that have a clear fix that do not
  /// require user input. They should not suppress errors or perform unsafe
  /// fixes such as generating new types or classes.
  ///
  /// @since 3.15.0
  static const SourceFixAll = CodeActionKind('source.fixAll');

  /// Base kind for an organize imports source action: `source.organizeImports`
  static const SourceOrganizeImports = CodeActionKind('source.organizeImports');
  final String _value;
  const CodeActionKind(this._value);
  const CodeActionKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is CodeActionKind && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is String;
}

/// A code action represents a change that can be performed in code, e.g. to fix
/// a problem or to refactor code.
///
/// A CodeAction must set either `edit` and/or a `command`. If both are
/// supplied, the `edit` is applied first, then the `command` is executed.
class CodeActionLiteral implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeActionLiteral.canParse,
    CodeActionLiteral.fromJson,
  );

  /// A command this code action executes. If a code action provides an edit and
  /// a command, first the edit is executed and then the command.
  final Command? command;

  /// A data entry field that is preserved on a code action between a
  /// `textDocument/codeAction` and a `codeAction/resolve` request.
  ///
  /// @since 3.16.0
  final LSPAny data;

  /// The diagnostics that this code action resolves.
  final List<Diagnostic>? diagnostics;

  /// Marks that the code action cannot currently be applied.
  ///
  /// Clients should follow the following guidelines regarding disabled code
  /// actions:
  ///
  ///   - Disabled code actions are not shown in automatic
  /// [lightbulbs](https://code.visualstudio.com/docs/editor/editingevolved#_code-action)
  ///     code action menus.
  ///
  ///   - Disabled actions are shown as faded out in the code action menu when
  /// the user requests a more specific type
  ///     of code action, such as refactorings.
  ///
  ///   - If the user has a
  /// [keybinding](https://code.visualstudio.com/docs/editor/refactoring#_keybindings-for-code-actions)
  ///     that auto applies a code action and only disabled code actions are
  /// returned, the client should show the user an
  ///     error message with `reason` in the editor.
  ///
  /// @since 3.16.0
  final CodeActionDisabled? disabled;

  /// The workspace edit this code action performs.
  final WorkspaceEdit? edit;

  /// Marks this as a preferred action. Preferred actions are used by the `auto
  /// fix` command and can be targeted by keybindings.
  ///
  /// A quick fix should be marked preferred if it properly addresses the
  /// underlying error. A refactoring should be marked preferred if it is the
  /// most reasonable choice of actions to take.
  ///
  /// @since 3.15.0
  final bool? isPreferred;

  /// The kind of the code action.
  ///
  /// Used to filter code actions.
  final CodeActionKind? kind;

  /// A short, human-readable, title for this code action.
  final String title;
  CodeActionLiteral({
    this.command,
    this.data,
    this.diagnostics,
    this.disabled,
    this.edit,
    this.isPreferred,
    this.kind,
    required this.title,
  });
  @override
  int get hashCode => Object.hash(
        command,
        data,
        lspHashCode(diagnostics),
        disabled,
        edit,
        isPreferred,
        kind,
        title,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeActionLiteral &&
        other.runtimeType == CodeActionLiteral &&
        command == other.command &&
        data == other.data &&
        const DeepCollectionEquality().equals(diagnostics, other.diagnostics) &&
        disabled == other.disabled &&
        edit == other.edit &&
        isPreferred == other.isPreferred &&
        kind == other.kind &&
        title == other.title;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (command != null) {
      result['command'] = command?.toJson();
    }
    if (data != null) {
      result['data'] = data;
    }
    if (diagnostics != null) {
      result['diagnostics'] =
          diagnostics?.map((item) => item.toJson()).toList();
    }
    if (disabled != null) {
      result['disabled'] = disabled?.toJson();
    }
    if (edit != null) {
      result['edit'] = edit?.toJson();
    }
    if (isPreferred != null) {
      result['isPreferred'] = isPreferred;
    }
    if (kind != null) {
      result['kind'] = kind?.toJson();
    }
    result['title'] = title;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCommand(obj, reporter, 'command',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListDiagnostic(obj, reporter, 'diagnostics',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseCodeActionDisabled(obj, reporter, 'disabled',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseWorkspaceEdit(obj, reporter, 'edit',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'isPreferred',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseCodeActionKind(obj, reporter, 'kind',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'title',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeActionLiteral');
      return false;
    }
  }

  static CodeActionLiteral fromJson(Map<String, Object?> json) {
    final commandJson = json['command'];
    final command = commandJson != null
        ? Command.fromJson(commandJson as Map<String, Object?>)
        : null;
    final dataJson = json['data'];
    final data = dataJson;
    final diagnosticsJson = json['diagnostics'];
    final diagnostics = (diagnosticsJson as List<Object?>?)
        ?.map((item) => Diagnostic.fromJson(item as Map<String, Object?>))
        .toList();
    final disabledJson = json['disabled'];
    final disabled = disabledJson != null
        ? CodeActionDisabled.fromJson(disabledJson as Map<String, Object?>)
        : null;
    final editJson = json['edit'];
    final edit = editJson != null
        ? WorkspaceEdit.fromJson(editJson as Map<String, Object?>)
        : null;
    final isPreferredJson = json['isPreferred'];
    final isPreferred = isPreferredJson as bool?;
    final kindJson = json['kind'];
    final kind =
        kindJson != null ? CodeActionKind.fromJson(kindJson as String) : null;
    final titleJson = json['title'];
    final title = titleJson as String;
    return CodeActionLiteral(
      command: command,
      data: data,
      diagnostics: diagnostics,
      disabled: disabled,
      edit: edit,
      isPreferred: isPreferred,
      kind: kind,
      title: title,
    );
  }
}

/// Provider options for a [CodeActionRequest].
class CodeActionOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeActionOptions.canParse,
    CodeActionOptions.fromJson,
  );

  /// CodeActionKinds that this server may return.
  ///
  /// The list of kinds may be generic, such as `CodeActionKind.Refactor`, or
  /// the server may list out every specific kind they provide.
  final List<CodeActionKind>? codeActionKinds;

  /// The server provides support to resolve additional information for a code
  /// action.
  ///
  /// @since 3.16.0
  final bool? resolveProvider;

  @override
  final bool? workDoneProgress;
  CodeActionOptions({
    this.codeActionKinds,
    this.resolveProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(codeActionKinds),
        resolveProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeActionOptions &&
        other.runtimeType == CodeActionOptions &&
        const DeepCollectionEquality()
            .equals(codeActionKinds, other.codeActionKinds) &&
        resolveProvider == other.resolveProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (codeActionKinds != null) {
      result['codeActionKinds'] =
          codeActionKinds?.map((item) => item.toJson()).toList();
    }
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListCodeActionKind(obj, reporter, 'codeActionKinds',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeActionOptions');
      return false;
    }
  }

  static CodeActionOptions fromJson(Map<String, Object?> json) {
    if (CodeActionRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return CodeActionRegistrationOptions.fromJson(json);
    }
    final codeActionKindsJson = json['codeActionKinds'];
    final codeActionKinds = (codeActionKindsJson as List<Object?>?)
        ?.map((item) => CodeActionKind.fromJson(item as String))
        .toList();
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return CodeActionOptions(
      codeActionKinds: codeActionKinds,
      resolveProvider: resolveProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// The parameters of a [CodeActionRequest].
class CodeActionParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeActionParams.canParse,
    CodeActionParams.fromJson,
  );

  /// Context carrying additional information.
  final CodeActionContext context;

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The range for which the command was invoked.
  final Range range;

  /// The document in which the command was invoked.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  CodeActionParams({
    required this.context,
    this.partialResultToken,
    required this.range,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        context,
        partialResultToken,
        range,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeActionParams &&
        other.runtimeType == CodeActionParams &&
        context == other.context &&
        partialResultToken == other.partialResultToken &&
        range == other.range &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['context'] = context.toJson();
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['range'] = range.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCodeActionContext(obj, reporter, 'context',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeActionParams');
      return false;
    }
  }

  static CodeActionParams fromJson(Map<String, Object?> json) {
    final contextJson = json['context'];
    final context =
        CodeActionContext.fromJson(contextJson as Map<String, Object?>);
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return CodeActionParams(
      context: context,
      partialResultToken: partialResultToken,
      range: range,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [CodeActionRequest].
class CodeActionRegistrationOptions
    implements CodeActionOptions, TextDocumentRegistrationOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeActionRegistrationOptions.canParse,
    CodeActionRegistrationOptions.fromJson,
  );

  /// CodeActionKinds that this server may return.
  ///
  /// The list of kinds may be generic, such as `CodeActionKind.Refactor`, or
  /// the server may list out every specific kind they provide.
  @override
  final List<CodeActionKind>? codeActionKinds;

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The server provides support to resolve additional information for a code
  /// action.
  ///
  /// @since 3.16.0
  @override
  final bool? resolveProvider;
  @override
  final bool? workDoneProgress;
  CodeActionRegistrationOptions({
    this.codeActionKinds,
    this.documentSelector,
    this.resolveProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(codeActionKinds),
        lspHashCode(documentSelector),
        resolveProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeActionRegistrationOptions &&
        other.runtimeType == CodeActionRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(codeActionKinds, other.codeActionKinds) &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        resolveProvider == other.resolveProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (codeActionKinds != null) {
      result['codeActionKinds'] =
          codeActionKinds?.map((item) => item.toJson()).toList();
    }
    result['documentSelector'] = documentSelector;
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListCodeActionKind(obj, reporter, 'codeActionKinds',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeActionRegistrationOptions');
      return false;
    }
  }

  static CodeActionRegistrationOptions fromJson(Map<String, Object?> json) {
    final codeActionKindsJson = json['codeActionKinds'];
    final codeActionKinds = (codeActionKindsJson as List<Object?>?)
        ?.map((item) => CodeActionKind.fromJson(item as String))
        .toList();
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return CodeActionRegistrationOptions(
      codeActionKinds: codeActionKinds,
      documentSelector: documentSelector,
      resolveProvider: resolveProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// The reason why code actions were requested.
///
/// @since 3.17.0
class CodeActionTriggerKind implements ToJsonable {
  /// Code actions were requested automatically.
  ///
  /// This typically happens when current selection in a file changes, but can
  /// also be triggered when file content changes.
  static const Automatic = CodeActionTriggerKind(2);

  /// Code actions were explicitly requested by the user or by an extension.
  static const Invoked = CodeActionTriggerKind(1);

  final int _value;

  const CodeActionTriggerKind(this._value);
  const CodeActionTriggerKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is CodeActionTriggerKind && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// Structure to capture a description for an error code.
///
/// @since 3.16.0
class CodeDescription implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeDescription.canParse,
    CodeDescription.fromJson,
  );

  /// An URI to open with more information about the diagnostic error.
  final LSPUri href;

  CodeDescription({
    required this.href,
  });

  @override
  int get hashCode => href.hashCode;

  @override
  bool operator ==(Object other) {
    return other is CodeDescription &&
        other.runtimeType == CodeDescription &&
        href == other.href;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['href'] = href.toString();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseUri(obj, reporter, 'href',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeDescription');
      return false;
    }
  }

  static CodeDescription fromJson(Map<String, Object?> json) {
    final hrefJson = json['href'];
    final href = Uri.parse(hrefJson as String);
    return CodeDescription(
      href: href,
    );
  }
}

/// A code lens represents a [Command] that should be shown along with source
/// text, like the number of references, a way to run tests, etc.
///
/// A code lens is _unresolved_ when no command is associated to it. For
/// performance reasons the creation of a code lens and resolving should be done
/// in two stages.
class CodeLens implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeLens.canParse,
    CodeLens.fromJson,
  );

  /// The command this code lens represents.
  final Command? command;

  /// A data entry field that is preserved on a code lens item between a
  /// [CodeLensRequest] and a [CodeLensResolveRequest]
  final LSPAny data;

  /// The range in which this code lens is valid. Should only span a single
  /// line.
  final Range range;
  CodeLens({
    this.command,
    this.data,
    required this.range,
  });
  @override
  int get hashCode => Object.hash(
        command,
        data,
        range,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeLens &&
        other.runtimeType == CodeLens &&
        command == other.command &&
        data == other.data &&
        range == other.range;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (command != null) {
      result['command'] = command?.toJson();
    }
    if (data != null) {
      result['data'] = data;
    }
    result['range'] = range.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCommand(obj, reporter, 'command',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeLens');
      return false;
    }
  }

  static CodeLens fromJson(Map<String, Object?> json) {
    final commandJson = json['command'];
    final command = commandJson != null
        ? Command.fromJson(commandJson as Map<String, Object?>)
        : null;
    final dataJson = json['data'];
    final data = dataJson;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    return CodeLens(
      command: command,
      data: data,
      range: range,
    );
  }
}

/// The client capabilities  of a [CodeLensRequest].
class CodeLensClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeLensClientCapabilities.canParse,
    CodeLensClientCapabilities.fromJson,
  );

  /// Whether code lens supports dynamic registration.
  final bool? dynamicRegistration;

  CodeLensClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is CodeLensClientCapabilities &&
        other.runtimeType == CodeLensClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeLensClientCapabilities');
      return false;
    }
  }

  static CodeLensClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return CodeLensClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// Code Lens provider options of a [CodeLensRequest].
class CodeLensOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeLensOptions.canParse,
    CodeLensOptions.fromJson,
  );

  /// Code lens has a resolve provider as well.
  final bool? resolveProvider;

  @override
  final bool? workDoneProgress;

  CodeLensOptions({
    this.resolveProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        resolveProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeLensOptions &&
        other.runtimeType == CodeLensOptions &&
        resolveProvider == other.resolveProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeLensOptions');
      return false;
    }
  }

  static CodeLensOptions fromJson(Map<String, Object?> json) {
    if (CodeLensRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return CodeLensRegistrationOptions.fromJson(json);
    }
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return CodeLensOptions(
      resolveProvider: resolveProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// The parameters of a [CodeLensRequest].
class CodeLensParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeLensParams.canParse,
    CodeLensParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The document to request code lens for.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  CodeLensParams({
    this.partialResultToken,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeLensParams &&
        other.runtimeType == CodeLensParams &&
        partialResultToken == other.partialResultToken &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeLensParams');
      return false;
    }
  }

  static CodeLensParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return CodeLensParams(
      partialResultToken: partialResultToken,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [CodeLensRequest].
class CodeLensRegistrationOptions
    implements CodeLensOptions, TextDocumentRegistrationOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeLensRegistrationOptions.canParse,
    CodeLensRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// Code lens has a resolve provider as well.
  @override
  final bool? resolveProvider;

  @override
  final bool? workDoneProgress;
  CodeLensRegistrationOptions({
    this.documentSelector,
    this.resolveProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        resolveProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is CodeLensRegistrationOptions &&
        other.runtimeType == CodeLensRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        resolveProvider == other.resolveProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CodeLensRegistrationOptions');
      return false;
    }
  }

  static CodeLensRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return CodeLensRegistrationOptions(
      documentSelector: documentSelector,
      resolveProvider: resolveProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// @since 3.16.0
class CodeLensWorkspaceClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CodeLensWorkspaceClientCapabilities.canParse,
    CodeLensWorkspaceClientCapabilities.fromJson,
  );

  /// Whether the client implementation supports a refresh request sent from the
  /// server to the client.
  ///
  /// Note that this event is global and will force the client to refresh all
  /// code lenses currently shown. It should be used with absolute care and is
  /// useful for situation where a server for example detect a project wide
  /// change that requires such a calculation.
  final bool? refreshSupport;

  CodeLensWorkspaceClientCapabilities({
    this.refreshSupport,
  });

  @override
  int get hashCode => refreshSupport.hashCode;

  @override
  bool operator ==(Object other) {
    return other is CodeLensWorkspaceClientCapabilities &&
        other.runtimeType == CodeLensWorkspaceClientCapabilities &&
        refreshSupport == other.refreshSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (refreshSupport != null) {
      result['refreshSupport'] = refreshSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'refreshSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type CodeLensWorkspaceClientCapabilities');
      return false;
    }
  }

  static CodeLensWorkspaceClientCapabilities fromJson(
      Map<String, Object?> json) {
    final refreshSupportJson = json['refreshSupport'];
    final refreshSupport = refreshSupportJson as bool?;
    return CodeLensWorkspaceClientCapabilities(
      refreshSupport: refreshSupport,
    );
  }
}

/// Represents a color in RGBA space.
class Color implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    Color.canParse,
    Color.fromJson,
  );

  /// The alpha component of this color in the range [0-1].
  final num alpha;

  /// The blue component of this color in the range [0-1].
  final num blue;

  /// The green component of this color in the range [0-1].
  final num green;

  /// The red component of this color in the range [0-1].
  final num red;
  Color({
    required this.alpha,
    required this.blue,
    required this.green,
    required this.red,
  });
  @override
  int get hashCode => Object.hash(
        alpha,
        blue,
        green,
        red,
      );

  @override
  bool operator ==(Object other) {
    return other is Color &&
        other.runtimeType == Color &&
        alpha == other.alpha &&
        blue == other.blue &&
        green == other.green &&
        red == other.red;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['alpha'] = alpha;
    result['blue'] = blue;
    result['green'] = green;
    result['red'] = red;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseNum(obj, reporter, 'alpha',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseNum(obj, reporter, 'blue',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseNum(obj, reporter, 'green',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseNum(obj, reporter, 'red',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type Color');
      return false;
    }
  }

  static Color fromJson(Map<String, Object?> json) {
    final alphaJson = json['alpha'];
    final alpha = alphaJson as num;
    final blueJson = json['blue'];
    final blue = blueJson as num;
    final greenJson = json['green'];
    final green = greenJson as num;
    final redJson = json['red'];
    final red = redJson as num;
    return Color(
      alpha: alpha,
      blue: blue,
      green: green,
      red: red,
    );
  }
}

/// Represents a color range from a document.
class ColorInformation implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ColorInformation.canParse,
    ColorInformation.fromJson,
  );

  /// The actual color value for this color range.
  final Color color;

  /// The range in the document where this color appears.
  final Range range;

  ColorInformation({
    required this.color,
    required this.range,
  });
  @override
  int get hashCode => Object.hash(
        color,
        range,
      );

  @override
  bool operator ==(Object other) {
    return other is ColorInformation &&
        other.runtimeType == ColorInformation &&
        color == other.color &&
        range == other.range;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['color'] = color.toJson();
    result['range'] = range.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseColor(obj, reporter, 'color',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type ColorInformation');
      return false;
    }
  }

  static ColorInformation fromJson(Map<String, Object?> json) {
    final colorJson = json['color'];
    final color = Color.fromJson(colorJson as Map<String, Object?>);
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    return ColorInformation(
      color: color,
      range: range,
    );
  }
}

class ColorPresentation implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ColorPresentation.canParse,
    ColorPresentation.fromJson,
  );

  /// An optional array of additional [TextEdit] that are applied when selecting
  /// this color presentation. Edits must not overlap with the main
  /// [ColorPresentation.textEdit] nor with themselves.
  final List<TextEdit>? additionalTextEdits;

  /// The label of this color presentation. It will be shown on the color picker
  /// header. By default this is also the text that is inserted when selecting
  /// this color presentation.
  final String label;

  /// An [TextEdit] which is applied to a document when selecting this
  /// presentation for the color.  When `falsy` the [ColorPresentation.label] is
  /// used.
  final TextEdit? textEdit;
  ColorPresentation({
    this.additionalTextEdits,
    required this.label,
    this.textEdit,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(additionalTextEdits),
        label,
        textEdit,
      );

  @override
  bool operator ==(Object other) {
    return other is ColorPresentation &&
        other.runtimeType == ColorPresentation &&
        const DeepCollectionEquality()
            .equals(additionalTextEdits, other.additionalTextEdits) &&
        label == other.label &&
        textEdit == other.textEdit;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (additionalTextEdits != null) {
      result['additionalTextEdits'] =
          additionalTextEdits?.map((item) => item.toJson()).toList();
    }
    result['label'] = label;
    if (textEdit != null) {
      result['textEdit'] = textEdit?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextEdit(obj, reporter, 'additionalTextEdits',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'label',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseTextEdit(obj, reporter, 'textEdit',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ColorPresentation');
      return false;
    }
  }

  static ColorPresentation fromJson(Map<String, Object?> json) {
    final additionalTextEditsJson = json['additionalTextEdits'];
    final additionalTextEdits = (additionalTextEditsJson as List<Object?>?)
        ?.map((item) => TextEdit.fromJson(item as Map<String, Object?>))
        .toList();
    final labelJson = json['label'];
    final label = labelJson as String;
    final textEditJson = json['textEdit'];
    final textEdit = textEditJson != null
        ? TextEdit.fromJson(textEditJson as Map<String, Object?>)
        : null;
    return ColorPresentation(
      additionalTextEdits: additionalTextEdits,
      label: label,
      textEdit: textEdit,
    );
  }
}

/// Parameters for a [ColorPresentationRequest].
class ColorPresentationParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ColorPresentationParams.canParse,
    ColorPresentationParams.fromJson,
  );

  /// The color to request presentations for.
  final Color color;

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The range where the color would be inserted. Serves as a context.
  final Range range;

  /// The text document.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  ColorPresentationParams({
    required this.color,
    this.partialResultToken,
    required this.range,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        color,
        partialResultToken,
        range,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is ColorPresentationParams &&
        other.runtimeType == ColorPresentationParams &&
        color == other.color &&
        partialResultToken == other.partialResultToken &&
        range == other.range &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['color'] = color.toJson();
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['range'] = range.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseColor(obj, reporter, 'color',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ColorPresentationParams');
      return false;
    }
  }

  static ColorPresentationParams fromJson(Map<String, Object?> json) {
    final colorJson = json['color'];
    final color = Color.fromJson(colorJson as Map<String, Object?>);
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return ColorPresentationParams(
      color: color,
      partialResultToken: partialResultToken,
      range: range,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Represents a reference to a command. Provides a title which will be used to
/// represent a command in the UI and, optionally,
/// an array of arguments which will be passed to the command handler function
/// when invoked.
class Command implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    Command.canParse,
    Command.fromJson,
  );

  /// Arguments that the command handler should be invoked with.
  final List<LSPAny>? arguments;

  /// The identifier of the actual command handler.
  final String command;

  /// Title of the command, like `save`.
  final String title;
  Command({
    this.arguments,
    required this.command,
    required this.title,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(arguments),
        command,
        title,
      );

  @override
  bool operator ==(Object other) {
    return other is Command &&
        other.runtimeType == Command &&
        const DeepCollectionEquality().equals(arguments, other.arguments) &&
        command == other.command &&
        title == other.title;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (arguments != null) {
      result['arguments'] = arguments;
    }
    result['command'] = command;
    result['title'] = title;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListObjectNullable(obj, reporter, 'arguments',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'command',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'title',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type Command');
      return false;
    }
  }

  static Command fromJson(Map<String, Object?> json) {
    final argumentsJson = json['arguments'];
    final arguments =
        (argumentsJson as List<Object?>?)?.map((item) => item).toList();
    final commandJson = json['command'];
    final command = commandJson as String;
    final titleJson = json['title'];
    final title = titleJson as String;
    return Command(
      arguments: arguments,
      command: command,
      title: title,
    );
  }
}

/// Completion client capabilities
class CompletionClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionClientCapabilities.canParse,
    CompletionClientCapabilities.fromJson,
  );

  /// The client supports the following `CompletionItem` specific capabilities.
  final CompletionClientCapabilitiesCompletionItem? completionItem;

  final ClientCompletionItemOptionsKind? completionItemKind;

  /// The client supports the following `CompletionList` specific capabilities.
  ///
  /// @since 3.17.0
  final CompletionClientCapabilitiesCompletionList? completionList;

  /// The client supports to send additional context information for a
  /// `textDocument/completion` request.
  final bool? contextSupport;

  /// Whether completion supports dynamic registration.
  final bool? dynamicRegistration;

  /// Defines how the client handles whitespace and indentation when accepting a
  /// completion item that uses multi line text in either `insertText` or
  /// `textEdit`.
  ///
  /// @since 3.17.0
  final InsertTextMode? insertTextMode;
  CompletionClientCapabilities({
    this.completionItem,
    this.completionItemKind,
    this.completionList,
    this.contextSupport,
    this.dynamicRegistration,
    this.insertTextMode,
  });
  @override
  int get hashCode => Object.hash(
        completionItem,
        completionItemKind,
        completionList,
        contextSupport,
        dynamicRegistration,
        insertTextMode,
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionClientCapabilities &&
        other.runtimeType == CompletionClientCapabilities &&
        completionItem == other.completionItem &&
        completionItemKind == other.completionItemKind &&
        completionList == other.completionList &&
        contextSupport == other.contextSupport &&
        dynamicRegistration == other.dynamicRegistration &&
        insertTextMode == other.insertTextMode;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (completionItem != null) {
      result['completionItem'] = completionItem?.toJson();
    }
    if (completionItemKind != null) {
      result['completionItemKind'] = completionItemKind?.toJson();
    }
    if (completionList != null) {
      result['completionList'] = completionList?.toJson();
    }
    if (contextSupport != null) {
      result['contextSupport'] = contextSupport;
    }
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (insertTextMode != null) {
      result['insertTextMode'] = insertTextMode?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCompletionClientCapabilitiesCompletionItem(
          obj, reporter, 'completionItem',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseClientCompletionItemOptionsKind(
          obj, reporter, 'completionItemKind',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseCompletionClientCapabilitiesCompletionList(
          obj, reporter, 'completionList',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'contextSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseInsertTextMode(obj, reporter, 'insertTextMode',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionClientCapabilities');
      return false;
    }
  }

  static CompletionClientCapabilities fromJson(Map<String, Object?> json) {
    final completionItemJson = json['completionItem'];
    final completionItem = completionItemJson != null
        ? CompletionClientCapabilitiesCompletionItem.fromJson(
            completionItemJson as Map<String, Object?>)
        : null;
    final completionItemKindJson = json['completionItemKind'];
    final completionItemKind = completionItemKindJson != null
        ? ClientCompletionItemOptionsKind.fromJson(
            completionItemKindJson as Map<String, Object?>)
        : null;
    final completionListJson = json['completionList'];
    final completionList = completionListJson != null
        ? CompletionClientCapabilitiesCompletionList.fromJson(
            completionListJson as Map<String, Object?>)
        : null;
    final contextSupportJson = json['contextSupport'];
    final contextSupport = contextSupportJson as bool?;
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final insertTextModeJson = json['insertTextMode'];
    final insertTextMode = insertTextModeJson != null
        ? InsertTextMode.fromJson(insertTextModeJson as int)
        : null;
    return CompletionClientCapabilities(
      completionItem: completionItem,
      completionItemKind: completionItemKind,
      completionList: completionList,
      contextSupport: contextSupport,
      dynamicRegistration: dynamicRegistration,
      insertTextMode: insertTextMode,
    );
  }
}

class CompletionClientCapabilitiesCompletionItem implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionClientCapabilitiesCompletionItem.canParse,
    CompletionClientCapabilitiesCompletionItem.fromJson,
  );

  /// Client supports commit characters on a completion item.
  final bool? commitCharactersSupport;

  /// Client supports the deprecated property on a completion item.
  final bool? deprecatedSupport;

  /// Client supports the following content formats for the documentation
  /// property. The order describes the preferred format of the client.
  final List<MarkupKind>? documentationFormat;

  /// Client support insert replace edit to control different behavior if a
  /// completion item is inserted in the text or should replace text.
  ///
  /// @since 3.16.0
  final bool? insertReplaceSupport;

  /// The client supports the `insertTextMode` property on a completion item to
  /// override the whitespace handling mode as defined by the client (see
  /// `insertTextMode`).
  ///
  /// @since 3.16.0
  final CompletionItemInsertTextModeSupport? insertTextModeSupport;

  /// The client has support for completion item label details (see also
  /// `CompletionItemLabelDetails`).
  ///
  /// @since 3.17.0
  final bool? labelDetailsSupport;

  /// Client supports the preselect property on a completion item.
  final bool? preselectSupport;

  /// Indicates which properties a client can resolve lazily on a completion
  /// item. Before version 3.16.0 only the predefined properties `documentation`
  /// and `details` could be resolved lazily.
  ///
  /// @since 3.16.0
  final CompletionItemResolveSupport? resolveSupport;

  /// Client supports snippets as insert text.
  ///
  /// A snippet can define tab stops and placeholders with `$1`, `$2` and
  /// `${3:foo}`. `$0` defines the final tab stop, it defaults to the end of the
  /// snippet. Placeholders with equal identifiers are linked,
  /// that is typing in one will update others too.
  final bool? snippetSupport;

  /// Client supports the tag property on a completion item. Clients supporting
  /// tags have to handle unknown tags gracefully. Clients especially need to
  /// preserve unknown tags when sending a completion item back to the server in
  /// a resolve call.
  ///
  /// @since 3.15.0
  final CompletionItemTagSupport? tagSupport;
  CompletionClientCapabilitiesCompletionItem({
    this.commitCharactersSupport,
    this.deprecatedSupport,
    this.documentationFormat,
    this.insertReplaceSupport,
    this.insertTextModeSupport,
    this.labelDetailsSupport,
    this.preselectSupport,
    this.resolveSupport,
    this.snippetSupport,
    this.tagSupport,
  });
  @override
  int get hashCode => Object.hash(
        commitCharactersSupport,
        deprecatedSupport,
        lspHashCode(documentationFormat),
        insertReplaceSupport,
        insertTextModeSupport,
        labelDetailsSupport,
        preselectSupport,
        resolveSupport,
        snippetSupport,
        tagSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionClientCapabilitiesCompletionItem &&
        other.runtimeType == CompletionClientCapabilitiesCompletionItem &&
        commitCharactersSupport == other.commitCharactersSupport &&
        deprecatedSupport == other.deprecatedSupport &&
        const DeepCollectionEquality()
            .equals(documentationFormat, other.documentationFormat) &&
        insertReplaceSupport == other.insertReplaceSupport &&
        insertTextModeSupport == other.insertTextModeSupport &&
        labelDetailsSupport == other.labelDetailsSupport &&
        preselectSupport == other.preselectSupport &&
        resolveSupport == other.resolveSupport &&
        snippetSupport == other.snippetSupport &&
        tagSupport == other.tagSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (commitCharactersSupport != null) {
      result['commitCharactersSupport'] = commitCharactersSupport;
    }
    if (deprecatedSupport != null) {
      result['deprecatedSupport'] = deprecatedSupport;
    }
    if (documentationFormat != null) {
      result['documentationFormat'] =
          documentationFormat?.map((item) => item.toJson()).toList();
    }
    if (insertReplaceSupport != null) {
      result['insertReplaceSupport'] = insertReplaceSupport;
    }
    if (insertTextModeSupport != null) {
      result['insertTextModeSupport'] = insertTextModeSupport?.toJson();
    }
    if (labelDetailsSupport != null) {
      result['labelDetailsSupport'] = labelDetailsSupport;
    }
    if (preselectSupport != null) {
      result['preselectSupport'] = preselectSupport;
    }
    if (resolveSupport != null) {
      result['resolveSupport'] = resolveSupport?.toJson();
    }
    if (snippetSupport != null) {
      result['snippetSupport'] = snippetSupport;
    }
    if (tagSupport != null) {
      result['tagSupport'] = tagSupport?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'commitCharactersSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'deprecatedSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListMarkupKind(obj, reporter, 'documentationFormat',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'insertReplaceSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseCompletionItemInsertTextModeSupport(
          obj, reporter, 'insertTextModeSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'labelDetailsSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'preselectSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseCompletionItemResolveSupport(
          obj, reporter, 'resolveSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'snippetSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseCompletionItemTagSupport(obj, reporter, 'tagSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type CompletionClientCapabilitiesCompletionItem');
      return false;
    }
  }

  static CompletionClientCapabilitiesCompletionItem fromJson(
      Map<String, Object?> json) {
    final commitCharactersSupportJson = json['commitCharactersSupport'];
    final commitCharactersSupport = commitCharactersSupportJson as bool?;
    final deprecatedSupportJson = json['deprecatedSupport'];
    final deprecatedSupport = deprecatedSupportJson as bool?;
    final documentationFormatJson = json['documentationFormat'];
    final documentationFormat = (documentationFormatJson as List<Object?>?)
        ?.map((item) => MarkupKind.fromJson(item as String))
        .toList();
    final insertReplaceSupportJson = json['insertReplaceSupport'];
    final insertReplaceSupport = insertReplaceSupportJson as bool?;
    final insertTextModeSupportJson = json['insertTextModeSupport'];
    final insertTextModeSupport = insertTextModeSupportJson != null
        ? CompletionItemInsertTextModeSupport.fromJson(
            insertTextModeSupportJson as Map<String, Object?>)
        : null;
    final labelDetailsSupportJson = json['labelDetailsSupport'];
    final labelDetailsSupport = labelDetailsSupportJson as bool?;
    final preselectSupportJson = json['preselectSupport'];
    final preselectSupport = preselectSupportJson as bool?;
    final resolveSupportJson = json['resolveSupport'];
    final resolveSupport = resolveSupportJson != null
        ? CompletionItemResolveSupport.fromJson(
            resolveSupportJson as Map<String, Object?>)
        : null;
    final snippetSupportJson = json['snippetSupport'];
    final snippetSupport = snippetSupportJson as bool?;
    final tagSupportJson = json['tagSupport'];
    final tagSupport = tagSupportJson != null
        ? CompletionItemTagSupport.fromJson(
            tagSupportJson as Map<String, Object?>)
        : null;
    return CompletionClientCapabilitiesCompletionItem(
      commitCharactersSupport: commitCharactersSupport,
      deprecatedSupport: deprecatedSupport,
      documentationFormat: documentationFormat,
      insertReplaceSupport: insertReplaceSupport,
      insertTextModeSupport: insertTextModeSupport,
      labelDetailsSupport: labelDetailsSupport,
      preselectSupport: preselectSupport,
      resolveSupport: resolveSupport,
      snippetSupport: snippetSupport,
      tagSupport: tagSupport,
    );
  }
}

class CompletionClientCapabilitiesCompletionList implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionClientCapabilitiesCompletionList.canParse,
    CompletionClientCapabilitiesCompletionList.fromJson,
  );

  /// The client supports the following itemDefaults on a completion list.
  ///
  /// The value lists the supported property names of the
  /// `CompletionList.itemDefaults` object. If omitted no properties are
  /// supported.
  ///
  /// @since 3.17.0
  final List<String>? itemDefaults;

  CompletionClientCapabilitiesCompletionList({
    this.itemDefaults,
  });

  @override
  int get hashCode => lspHashCode(itemDefaults);

  @override
  bool operator ==(Object other) {
    return other is CompletionClientCapabilitiesCompletionList &&
        other.runtimeType == CompletionClientCapabilitiesCompletionList &&
        const DeepCollectionEquality().equals(itemDefaults, other.itemDefaults);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (itemDefaults != null) {
      result['itemDefaults'] = itemDefaults;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListString(obj, reporter, 'itemDefaults',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type CompletionClientCapabilitiesCompletionList');
      return false;
    }
  }

  static CompletionClientCapabilitiesCompletionList fromJson(
      Map<String, Object?> json) {
    final itemDefaultsJson = json['itemDefaults'];
    final itemDefaults = (itemDefaultsJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    return CompletionClientCapabilitiesCompletionList(
      itemDefaults: itemDefaults,
    );
  }
}

/// Contains additional information about the context in which a completion
/// request is triggered.
class CompletionContext implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionContext.canParse,
    CompletionContext.fromJson,
  );

  /// The trigger character (a single character) that has trigger code complete.
  /// Is undefined if `triggerKind !== CompletionTriggerKind.TriggerCharacter`
  final String? triggerCharacter;

  /// How the completion was triggered.
  final CompletionTriggerKind triggerKind;

  CompletionContext({
    this.triggerCharacter,
    required this.triggerKind,
  });
  @override
  int get hashCode => Object.hash(
        triggerCharacter,
        triggerKind,
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionContext &&
        other.runtimeType == CompletionContext &&
        triggerCharacter == other.triggerCharacter &&
        triggerKind == other.triggerKind;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (triggerCharacter != null) {
      result['triggerCharacter'] = triggerCharacter;
    }
    result['triggerKind'] = triggerKind.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'triggerCharacter',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseCompletionTriggerKind(obj, reporter, 'triggerKind',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionContext');
      return false;
    }
  }

  static CompletionContext fromJson(Map<String, Object?> json) {
    final triggerCharacterJson = json['triggerCharacter'];
    final triggerCharacter = triggerCharacterJson as String?;
    final triggerKindJson = json['triggerKind'];
    final triggerKind = CompletionTriggerKind.fromJson(triggerKindJson as int);
    return CompletionContext(
      triggerCharacter: triggerCharacter,
      triggerKind: triggerKind,
    );
  }
}

/// A completion item represents a text snippet that is proposed to complete
/// text that is being typed.
class CompletionItem implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionItem.canParse,
    CompletionItem.fromJson,
  );

  /// An optional array of additional [TextEdit] that are applied when selecting
  /// this completion. Edits must not overlap (including the same insert
  /// position) with the main [CompletionItem.textEdit] nor with themselves.
  ///
  /// Additional text edits should be used to change text unrelated to the
  /// current cursor position (for example adding an import statement at the top
  /// of the file if the completion item will insert an unqualified type).
  final List<TextEdit>? additionalTextEdits;

  /// An optional [Command] that is executed *after* inserting this completion.
  /// *Note* that additional modifications to the current document should be
  /// described with the
  /// [CompletionItem.additionalTextEdits]-property.
  final Command? command;

  /// An optional set of characters that when pressed while this completion is
  /// active will accept it first and then type that character. *Note* that all
  /// commit characters should have `length=1` and that superfluous characters
  /// will be ignored.
  final List<String>? commitCharacters;

  /// A data entry field that is preserved on a completion item between a
  /// [CompletionRequest] and a [CompletionResolveRequest].
  final CompletionItemResolutionInfo? data;

  /// Indicates if this item is deprecated.
  /// @deprecated Use `tags` instead.
  final bool? deprecated;

  /// A human-readable string with additional information about this item, like
  /// type or symbol information.
  final String? detail;

  /// A human-readable string that represents a doc-comment.
  final Either2<MarkupContent, String>? documentation;

  /// A string that should be used when filtering a set of completion items.
  /// When `falsy` the [CompletionItem.label] is used.
  final String? filterText;

  /// A string that should be inserted into a document when selecting this
  /// completion. When `falsy` the [CompletionItem.label] is used.
  ///
  /// The `insertText` is subject to interpretation by the client side. Some
  /// tools might not take the string literally. For example VS Code when code
  /// complete is requested in this example `con<cursor position>` and a
  /// completion item with an `insertText` of `console` is provided it will only
  /// insert `sole`. Therefore it is recommended to use `textEdit` instead since
  /// it avoids additional client side interpretation.
  final String? insertText;

  /// The format of the insert text. The format applies to both the `insertText`
  /// property and the `newText` property of a provided `textEdit`. If omitted
  /// defaults to `InsertTextFormat.PlainText`.
  ///
  /// Please note that the insertTextFormat doesn't apply to
  /// `additionalTextEdits`.
  final InsertTextFormat? insertTextFormat;

  /// How whitespace and indentation is handled during completion item
  /// insertion. If not provided the clients default value depends on the
  /// `textDocument.completion.insertTextMode` client capability.
  ///
  /// @since 3.16.0
  final InsertTextMode? insertTextMode;

  /// The kind of this completion item. Based of the kind an icon is chosen by
  /// the editor.
  final CompletionItemKind? kind;

  /// The label of this completion item.
  ///
  /// The label property is also by default the text that is inserted when
  /// selecting this completion.
  ///
  /// If label details are provided the label itself should be an unqualified
  /// name of the completion item.
  final String label;

  /// Additional details for the label
  ///
  /// @since 3.17.0
  final CompletionItemLabelDetails? labelDetails;

  /// Select this item when showing.
  ///
  /// *Note* that only one completion item can be selected and that the tool /
  /// client decides which item that is. The rule is that the *first*
  /// item of those that match best is selected.
  final bool? preselect;

  /// A string that should be used when comparing this item with other items.
  /// When `falsy` the [CompletionItem.label] is used.
  final String? sortText;

  /// Tags for this completion item.
  ///
  /// @since 3.15.0
  final List<CompletionItemTag>? tags;

  /// An [TextEdit] which is applied to a document when selecting this
  /// completion. When an edit is provided the value of
  /// [CompletionItem.insertText] is ignored.
  ///
  /// Most editors support two different operations when accepting a completion
  /// item. One is to insert a completion text and the other is to replace an
  /// existing text with a completion text. Since this can usually not be
  /// predetermined by a server it can report both ranges. Clients need to
  /// signal support for `InsertReplaceEdits` via the
  /// `textDocument.completion.insertReplaceSupport` client capability property.
  ///
  /// *Note 1:* The text edit's range as well as both ranges from an insert
  /// replace edit must be a [single line] and they must contain the position at
  /// which completion has been requested.
  /// *Note 2:* If an `InsertReplaceEdit` is returned the edit's insert range
  /// must be a prefix of the edit's replace range, that means it must be
  /// contained and starting at the same position.
  ///
  /// @since 3.16.0 additional type `InsertReplaceEdit`
  final Either2<InsertReplaceEdit, TextEdit>? textEdit;

  /// The edit text used if the completion item is part of a CompletionList and
  /// CompletionList defines an item default for the text edit range.
  ///
  /// Clients will only honor this property if they opt into completion list
  /// item defaults using the capability `completionList.itemDefaults`.
  ///
  /// If not provided and a list's default range is provided the label property
  /// is used as a text.
  ///
  /// @since 3.17.0
  final String? textEditText;
  CompletionItem({
    this.additionalTextEdits,
    this.command,
    this.commitCharacters,
    this.data,
    this.deprecated,
    this.detail,
    this.documentation,
    this.filterText,
    this.insertText,
    this.insertTextFormat,
    this.insertTextMode,
    this.kind,
    required this.label,
    this.labelDetails,
    this.preselect,
    this.sortText,
    this.tags,
    this.textEdit,
    this.textEditText,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(additionalTextEdits),
        command,
        lspHashCode(commitCharacters),
        data,
        deprecated,
        detail,
        documentation,
        filterText,
        insertText,
        insertTextFormat,
        insertTextMode,
        kind,
        label,
        labelDetails,
        preselect,
        sortText,
        lspHashCode(tags),
        textEdit,
        textEditText,
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionItem &&
        other.runtimeType == CompletionItem &&
        const DeepCollectionEquality()
            .equals(additionalTextEdits, other.additionalTextEdits) &&
        command == other.command &&
        const DeepCollectionEquality()
            .equals(commitCharacters, other.commitCharacters) &&
        data == other.data &&
        deprecated == other.deprecated &&
        detail == other.detail &&
        documentation == other.documentation &&
        filterText == other.filterText &&
        insertText == other.insertText &&
        insertTextFormat == other.insertTextFormat &&
        insertTextMode == other.insertTextMode &&
        kind == other.kind &&
        label == other.label &&
        labelDetails == other.labelDetails &&
        preselect == other.preselect &&
        sortText == other.sortText &&
        const DeepCollectionEquality().equals(tags, other.tags) &&
        textEdit == other.textEdit &&
        textEditText == other.textEditText;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (additionalTextEdits != null) {
      result['additionalTextEdits'] =
          additionalTextEdits?.map((item) => item.toJson()).toList();
    }
    if (command != null) {
      result['command'] = command?.toJson();
    }
    if (commitCharacters != null) {
      result['commitCharacters'] = commitCharacters;
    }
    if (data != null) {
      result['data'] = data?.toJson();
    }
    if (deprecated != null) {
      result['deprecated'] = deprecated;
    }
    if (detail != null) {
      result['detail'] = detail;
    }
    if (documentation != null) {
      result['documentation'] = documentation;
    }
    if (filterText != null) {
      result['filterText'] = filterText;
    }
    if (insertText != null) {
      result['insertText'] = insertText;
    }
    if (insertTextFormat != null) {
      result['insertTextFormat'] = insertTextFormat?.toJson();
    }
    if (insertTextMode != null) {
      result['insertTextMode'] = insertTextMode?.toJson();
    }
    if (kind != null) {
      result['kind'] = kind?.toJson();
    }
    result['label'] = label;
    if (labelDetails != null) {
      result['labelDetails'] = labelDetails?.toJson();
    }
    if (preselect != null) {
      result['preselect'] = preselect;
    }
    if (sortText != null) {
      result['sortText'] = sortText;
    }
    if (tags != null) {
      result['tags'] = tags?.map((item) => item.toJson()).toList();
    }
    if (textEdit != null) {
      result['textEdit'] = textEdit;
    }
    if (textEditText != null) {
      result['textEditText'] = textEditText;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextEdit(obj, reporter, 'additionalTextEdits',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseCommand(obj, reporter, 'command',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListString(obj, reporter, 'commitCharacters',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseCompletionItemResolutionInfo(obj, reporter, 'data',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'deprecated',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'detail',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseMarkupContentString(obj, reporter, 'documentation',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'filterText',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'insertText',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseInsertTextFormat(obj, reporter, 'insertTextFormat',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseInsertTextMode(obj, reporter, 'insertTextMode',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseCompletionItemKind(obj, reporter, 'kind',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'label',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseCompletionItemLabelDetails(obj, reporter, 'labelDetails',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'preselect',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'sortText',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListCompletionItemTag(obj, reporter, 'tags',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseInsertReplaceEditTextEdit(obj, reporter, 'textEdit',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'textEditText',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionItem');
      return false;
    }
  }

  static CompletionItem fromJson(Map<String, Object?> json) {
    final additionalTextEditsJson = json['additionalTextEdits'];
    final additionalTextEdits = (additionalTextEditsJson as List<Object?>?)
        ?.map((item) => TextEdit.fromJson(item as Map<String, Object?>))
        .toList();
    final commandJson = json['command'];
    final command = commandJson != null
        ? Command.fromJson(commandJson as Map<String, Object?>)
        : null;
    final commitCharactersJson = json['commitCharacters'];
    final commitCharacters = (commitCharactersJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    final dataJson = json['data'];
    final data = dataJson != null
        ? CompletionItemResolutionInfo.fromJson(
            dataJson as Map<String, Object?>)
        : null;
    final deprecatedJson = json['deprecated'];
    final deprecated = deprecatedJson as bool?;
    final detailJson = json['detail'];
    final detail = detailJson as String?;
    final documentationJson = json['documentation'];
    final documentation = documentationJson == null
        ? null
        : _eitherMarkupContentString(documentationJson);
    final filterTextJson = json['filterText'];
    final filterText = filterTextJson as String?;
    final insertTextJson = json['insertText'];
    final insertText = insertTextJson as String?;
    final insertTextFormatJson = json['insertTextFormat'];
    final insertTextFormat = insertTextFormatJson != null
        ? InsertTextFormat.fromJson(insertTextFormatJson as int)
        : null;
    final insertTextModeJson = json['insertTextMode'];
    final insertTextMode = insertTextModeJson != null
        ? InsertTextMode.fromJson(insertTextModeJson as int)
        : null;
    final kindJson = json['kind'];
    final kind =
        kindJson != null ? CompletionItemKind.fromJson(kindJson as int) : null;
    final labelJson = json['label'];
    final label = labelJson as String;
    final labelDetailsJson = json['labelDetails'];
    final labelDetails = labelDetailsJson != null
        ? CompletionItemLabelDetails.fromJson(
            labelDetailsJson as Map<String, Object?>)
        : null;
    final preselectJson = json['preselect'];
    final preselect = preselectJson as bool?;
    final sortTextJson = json['sortText'];
    final sortText = sortTextJson as String?;
    final tagsJson = json['tags'];
    final tags = (tagsJson as List<Object?>?)
        ?.map((item) => CompletionItemTag.fromJson(item as int))
        .toList();
    final textEditJson = json['textEdit'];
    final textEdit = textEditJson == null
        ? null
        : _eitherInsertReplaceEditTextEdit(textEditJson);
    final textEditTextJson = json['textEditText'];
    final textEditText = textEditTextJson as String?;
    return CompletionItem(
      additionalTextEdits: additionalTextEdits,
      command: command,
      commitCharacters: commitCharacters,
      data: data,
      deprecated: deprecated,
      detail: detail,
      documentation: documentation,
      filterText: filterText,
      insertText: insertText,
      insertTextFormat: insertTextFormat,
      insertTextMode: insertTextMode,
      kind: kind,
      label: label,
      labelDetails: labelDetails,
      preselect: preselect,
      sortText: sortText,
      tags: tags,
      textEdit: textEdit,
      textEditText: textEditText,
    );
  }
}

class CompletionItemDefaults implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionItemDefaults.canParse,
    CompletionItemDefaults.fromJson,
  );

  /// A default commit character set.
  ///
  /// @since 3.17.0
  final List<String>? commitCharacters;

  /// A default data value.
  ///
  /// @since 3.17.0
  final LSPAny data;

  /// A default edit range.
  ///
  /// @since 3.17.0
  final Either2<EditRangeWithInsertReplace, Range>? editRange;

  /// A default insert text format.
  ///
  /// @since 3.17.0
  final InsertTextFormat? insertTextFormat;

  /// A default insert text mode.
  ///
  /// @since 3.17.0
  final InsertTextMode? insertTextMode;
  CompletionItemDefaults({
    this.commitCharacters,
    this.data,
    this.editRange,
    this.insertTextFormat,
    this.insertTextMode,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(commitCharacters),
        data,
        editRange,
        insertTextFormat,
        insertTextMode,
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionItemDefaults &&
        other.runtimeType == CompletionItemDefaults &&
        const DeepCollectionEquality()
            .equals(commitCharacters, other.commitCharacters) &&
        data == other.data &&
        editRange == other.editRange &&
        insertTextFormat == other.insertTextFormat &&
        insertTextMode == other.insertTextMode;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (commitCharacters != null) {
      result['commitCharacters'] = commitCharacters;
    }
    if (data != null) {
      result['data'] = data;
    }
    if (editRange != null) {
      result['editRange'] = editRange;
    }
    if (insertTextFormat != null) {
      result['insertTextFormat'] = insertTextFormat?.toJson();
    }
    if (insertTextMode != null) {
      result['insertTextMode'] = insertTextMode?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListString(obj, reporter, 'commitCharacters',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseEditRangeWithInsertReplaceRange(obj, reporter, 'editRange',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseInsertTextFormat(obj, reporter, 'insertTextFormat',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseInsertTextMode(obj, reporter, 'insertTextMode',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionItemDefaults');
      return false;
    }
  }

  static CompletionItemDefaults fromJson(Map<String, Object?> json) {
    final commitCharactersJson = json['commitCharacters'];
    final commitCharacters = (commitCharactersJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    final dataJson = json['data'];
    final data = dataJson;
    final editRangeJson = json['editRange'];
    final editRange = editRangeJson == null
        ? null
        : _eitherEditRangeWithInsertReplaceRange(editRangeJson);
    final insertTextFormatJson = json['insertTextFormat'];
    final insertTextFormat = insertTextFormatJson != null
        ? InsertTextFormat.fromJson(insertTextFormatJson as int)
        : null;
    final insertTextModeJson = json['insertTextMode'];
    final insertTextMode = insertTextModeJson != null
        ? InsertTextMode.fromJson(insertTextModeJson as int)
        : null;
    return CompletionItemDefaults(
      commitCharacters: commitCharacters,
      data: data,
      editRange: editRange,
      insertTextFormat: insertTextFormat,
      insertTextMode: insertTextMode,
    );
  }
}

class CompletionItemInsertTextModeSupport implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionItemInsertTextModeSupport.canParse,
    CompletionItemInsertTextModeSupport.fromJson,
  );

  final List<InsertTextMode> valueSet;

  CompletionItemInsertTextModeSupport({
    required this.valueSet,
  });

  @override
  int get hashCode => lspHashCode(valueSet);

  @override
  bool operator ==(Object other) {
    return other is CompletionItemInsertTextModeSupport &&
        other.runtimeType == CompletionItemInsertTextModeSupport &&
        const DeepCollectionEquality().equals(valueSet, other.valueSet);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['valueSet'] = valueSet.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListInsertTextMode(obj, reporter, 'valueSet',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type CompletionItemInsertTextModeSupport');
      return false;
    }
  }

  static CompletionItemInsertTextModeSupport fromJson(
      Map<String, Object?> json) {
    final valueSetJson = json['valueSet'];
    final valueSet = (valueSetJson as List<Object?>)
        .map((item) => InsertTextMode.fromJson(item as int))
        .toList();
    return CompletionItemInsertTextModeSupport(
      valueSet: valueSet,
    );
  }
}

/// The kind of a completion entry.
class CompletionItemKind implements ToJsonable {
  static const Class = CompletionItemKind(7);
  static const Color = CompletionItemKind(16);

  static const Constant = CompletionItemKind(21);

  static const Constructor = CompletionItemKind(4);
  static const Enum = CompletionItemKind(13);
  static const EnumMember = CompletionItemKind(20);
  static const Event = CompletionItemKind(23);
  static const Field = CompletionItemKind(5);
  static const File = CompletionItemKind(17);
  static const Folder = CompletionItemKind(19);
  static const Function = CompletionItemKind(3);
  static const Interface = CompletionItemKind(8);
  static const Keyword = CompletionItemKind(14);
  static const Method = CompletionItemKind(2);
  static const Module = CompletionItemKind(9);
  static const Operator = CompletionItemKind(24);
  static const Property = CompletionItemKind(10);
  static const Reference = CompletionItemKind(18);
  static const Snippet = CompletionItemKind(15);
  static const Struct = CompletionItemKind(22);
  static const Text = CompletionItemKind(1);
  static const TypeParameter = CompletionItemKind(25);
  static const Unit = CompletionItemKind(11);
  static const Value = CompletionItemKind(12);
  static const Variable = CompletionItemKind(6);
  final int _value;
  const CompletionItemKind(this._value);
  const CompletionItemKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is CompletionItemKind && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// Additional details for a completion item label.
///
/// @since 3.17.0
class CompletionItemLabelDetails implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionItemLabelDetails.canParse,
    CompletionItemLabelDetails.fromJson,
  );

  /// An optional string which is rendered less prominently after
  /// [CompletionItem.detail]. Should be used for fully qualified names and file
  /// paths.
  final String? description;

  /// An optional string which is rendered less prominently directly after
  /// [CompletionItem.label],
  /// without any spacing. Should be used for function signatures and type
  /// annotations.
  final String? detail;

  CompletionItemLabelDetails({
    this.description,
    this.detail,
  });
  @override
  int get hashCode => Object.hash(
        description,
        detail,
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionItemLabelDetails &&
        other.runtimeType == CompletionItemLabelDetails &&
        description == other.description &&
        detail == other.detail;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (description != null) {
      result['description'] = description;
    }
    if (detail != null) {
      result['detail'] = detail;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'description',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'detail',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionItemLabelDetails');
      return false;
    }
  }

  static CompletionItemLabelDetails fromJson(Map<String, Object?> json) {
    final descriptionJson = json['description'];
    final description = descriptionJson as String?;
    final detailJson = json['detail'];
    final detail = detailJson as String?;
    return CompletionItemLabelDetails(
      description: description,
      detail: detail,
    );
  }
}

class CompletionItemResolveSupport implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionItemResolveSupport.canParse,
    CompletionItemResolveSupport.fromJson,
  );

  /// The properties that a client can resolve lazily.
  final List<String> properties;

  CompletionItemResolveSupport({
    required this.properties,
  });

  @override
  int get hashCode => lspHashCode(properties);

  @override
  bool operator ==(Object other) {
    return other is CompletionItemResolveSupport &&
        other.runtimeType == CompletionItemResolveSupport &&
        const DeepCollectionEquality().equals(properties, other.properties);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['properties'] = properties;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListString(obj, reporter, 'properties',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionItemResolveSupport');
      return false;
    }
  }

  static CompletionItemResolveSupport fromJson(Map<String, Object?> json) {
    final propertiesJson = json['properties'];
    final properties = (propertiesJson as List<Object?>)
        .map((item) => item as String)
        .toList();
    return CompletionItemResolveSupport(
      properties: properties,
    );
  }
}

/// Completion item tags are extra annotations that tweak the rendering of a
/// completion item.
///
/// @since 3.15.0
class CompletionItemTag implements ToJsonable {
  /// Render a completion as obsolete, usually using a strike-out.
  static const Deprecated = CompletionItemTag(1);
  final int _value;

  const CompletionItemTag(this._value);

  const CompletionItemTag.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is CompletionItemTag && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

class CompletionItemTagSupport implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionItemTagSupport.canParse,
    CompletionItemTagSupport.fromJson,
  );

  /// The tags supported by the client.
  final List<CompletionItemTag> valueSet;

  CompletionItemTagSupport({
    required this.valueSet,
  });

  @override
  int get hashCode => lspHashCode(valueSet);

  @override
  bool operator ==(Object other) {
    return other is CompletionItemTagSupport &&
        other.runtimeType == CompletionItemTagSupport &&
        const DeepCollectionEquality().equals(valueSet, other.valueSet);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['valueSet'] = valueSet.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListCompletionItemTag(obj, reporter, 'valueSet',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionItemTagSupport');
      return false;
    }
  }

  static CompletionItemTagSupport fromJson(Map<String, Object?> json) {
    final valueSetJson = json['valueSet'];
    final valueSet = (valueSetJson as List<Object?>)
        .map((item) => CompletionItemTag.fromJson(item as int))
        .toList();
    return CompletionItemTagSupport(
      valueSet: valueSet,
    );
  }
}

/// Represents a collection of [CompletionItem] to be presented in the editor.
class CompletionList implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionList.canParse,
    CompletionList.fromJson,
  );

  /// This list it not complete. Further typing results in recomputing this
  /// list.
  ///
  /// Recomputed lists have all their items replaced (not appended) in the
  /// incomplete completion sessions.
  final bool isIncomplete;

  /// In many cases the items of an actual completion result share the same
  /// value for properties like `commitCharacters` or the range of a text edit.
  /// A completion list can therefore define item defaults which will be used if
  /// a completion item itself doesn't specify the value.
  ///
  /// If a completion list specifies a default value and a completion item also
  /// specifies a corresponding value the one from the item is used.
  ///
  /// Servers are only allowed to return default values if the client signals
  /// support for this via the `completionList.itemDefaults` capability.
  ///
  /// @since 3.17.0
  final CompletionItemDefaults? itemDefaults;

  /// The completion items.
  final List<CompletionItem> items;
  CompletionList({
    required this.isIncomplete,
    this.itemDefaults,
    required this.items,
  });
  @override
  int get hashCode => Object.hash(
        isIncomplete,
        itemDefaults,
        lspHashCode(items),
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionList &&
        other.runtimeType == CompletionList &&
        isIncomplete == other.isIncomplete &&
        itemDefaults == other.itemDefaults &&
        const DeepCollectionEquality().equals(items, other.items);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['isIncomplete'] = isIncomplete;
    if (itemDefaults != null) {
      result['itemDefaults'] = itemDefaults?.toJson();
    }
    result['items'] = items.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'isIncomplete',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseCompletionItemDefaults(obj, reporter, 'itemDefaults',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseListCompletionItem(obj, reporter, 'items',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionList');
      return false;
    }
  }

  static CompletionList fromJson(Map<String, Object?> json) {
    final isIncompleteJson = json['isIncomplete'];
    final isIncomplete = isIncompleteJson as bool;
    final itemDefaultsJson = json['itemDefaults'];
    final itemDefaults = itemDefaultsJson != null
        ? CompletionItemDefaults.fromJson(
            itemDefaultsJson as Map<String, Object?>)
        : null;
    final itemsJson = json['items'];
    final items = (itemsJson as List<Object?>)
        .map((item) => CompletionItem.fromJson(item as Map<String, Object?>))
        .toList();
    return CompletionList(
      isIncomplete: isIncomplete,
      itemDefaults: itemDefaults,
      items: items,
    );
  }
}

/// Completion options.
class CompletionOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionOptions.canParse,
    CompletionOptions.fromJson,
  );

  /// The list of all possible characters that commit a completion. This field
  /// can be used if clients don't support individual commit characters per
  /// completion item. See
  /// `ClientCapabilities.textDocument.completion.completionItem.commitCharactersSupport`
  ///
  /// If a server provides both `allCommitCharacters` and commit characters on
  /// an individual completion item the ones on the completion item win.
  ///
  /// @since 3.2.0
  final List<String>? allCommitCharacters;

  /// The server supports the following `CompletionItem` specific capabilities.
  ///
  /// @since 3.17.0
  final ServerCompletionItemOptions? completionItem;

  /// The server provides support to resolve additional information for a
  /// completion item.
  final bool? resolveProvider;

  /// Most tools trigger completion request automatically without explicitly
  /// requesting it using a keyboard shortcut (e.g. Ctrl+Space). Typically they
  /// do so when the user starts to type an identifier. For example if the user
  /// types `c` in a JavaScript file code complete will automatically pop up
  /// present `console` besides others as a completion item. Characters that
  /// make up identifiers don't need to be listed here.
  ///
  /// If code complete should automatically be trigger on characters not being
  /// valid inside an identifier (for example `.` in JavaScript) list them in
  /// `triggerCharacters`.
  final List<String>? triggerCharacters;
  @override
  final bool? workDoneProgress;
  CompletionOptions({
    this.allCommitCharacters,
    this.completionItem,
    this.resolveProvider,
    this.triggerCharacters,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(allCommitCharacters),
        completionItem,
        resolveProvider,
        lspHashCode(triggerCharacters),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionOptions &&
        other.runtimeType == CompletionOptions &&
        const DeepCollectionEquality()
            .equals(allCommitCharacters, other.allCommitCharacters) &&
        completionItem == other.completionItem &&
        resolveProvider == other.resolveProvider &&
        const DeepCollectionEquality()
            .equals(triggerCharacters, other.triggerCharacters) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (allCommitCharacters != null) {
      result['allCommitCharacters'] = allCommitCharacters;
    }
    if (completionItem != null) {
      result['completionItem'] = completionItem?.toJson();
    }
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (triggerCharacters != null) {
      result['triggerCharacters'] = triggerCharacters;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListString(obj, reporter, 'allCommitCharacters',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseServerCompletionItemOptions(obj, reporter, 'completionItem',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListString(obj, reporter, 'triggerCharacters',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionOptions');
      return false;
    }
  }

  static CompletionOptions fromJson(Map<String, Object?> json) {
    if (CompletionRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return CompletionRegistrationOptions.fromJson(json);
    }
    final allCommitCharactersJson = json['allCommitCharacters'];
    final allCommitCharacters = (allCommitCharactersJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    final completionItemJson = json['completionItem'];
    final completionItem = completionItemJson != null
        ? ServerCompletionItemOptions.fromJson(
            completionItemJson as Map<String, Object?>)
        : null;
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final triggerCharactersJson = json['triggerCharacters'];
    final triggerCharacters = (triggerCharactersJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return CompletionOptions(
      allCommitCharacters: allCommitCharacters,
      completionItem: completionItem,
      resolveProvider: resolveProvider,
      triggerCharacters: triggerCharacters,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Completion parameters
class CompletionParams
    implements
        PartialResultParams,
        TextDocumentPositionParams,
        WorkDoneProgressParams,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionParams.canParse,
    CompletionParams.fromJson,
  );

  /// The completion context. This is only available it the client specifies to
  /// send this using the client capability
  /// `textDocument.completion.contextSupport === true`
  final CompletionContext? context;

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  CompletionParams({
    this.context,
    this.partialResultToken,
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        context,
        partialResultToken,
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionParams &&
        other.runtimeType == CompletionParams &&
        context == other.context &&
        partialResultToken == other.partialResultToken &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (context != null) {
      result['context'] = context?.toJson();
    }
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCompletionContext(obj, reporter, 'context',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionParams');
      return false;
    }
  }

  static CompletionParams fromJson(Map<String, Object?> json) {
    final contextJson = json['context'];
    final context = contextJson != null
        ? CompletionContext.fromJson(contextJson as Map<String, Object?>)
        : null;
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return CompletionParams(
      context: context,
      partialResultToken: partialResultToken,
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [CompletionRequest].
class CompletionRegistrationOptions
    implements CompletionOptions, TextDocumentRegistrationOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CompletionRegistrationOptions.canParse,
    CompletionRegistrationOptions.fromJson,
  );

  /// The list of all possible characters that commit a completion. This field
  /// can be used if clients don't support individual commit characters per
  /// completion item. See
  /// `ClientCapabilities.textDocument.completion.completionItem.commitCharactersSupport`
  ///
  /// If a server provides both `allCommitCharacters` and commit characters on
  /// an individual completion item the ones on the completion item win.
  ///
  /// @since 3.2.0
  @override
  final List<String>? allCommitCharacters;

  /// The server supports the following `CompletionItem` specific capabilities.
  ///
  /// @since 3.17.0
  @override
  final ServerCompletionItemOptions? completionItem;

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The server provides support to resolve additional information for a
  /// completion item.
  @override
  final bool? resolveProvider;

  /// Most tools trigger completion request automatically without explicitly
  /// requesting it using a keyboard shortcut (e.g. Ctrl+Space). Typically they
  /// do so when the user starts to type an identifier. For example if the user
  /// types `c` in a JavaScript file code complete will automatically pop up
  /// present `console` besides others as a completion item. Characters that
  /// make up identifiers don't need to be listed here.
  ///
  /// If code complete should automatically be trigger on characters not being
  /// valid inside an identifier (for example `.` in JavaScript) list them in
  /// `triggerCharacters`.
  @override
  final List<String>? triggerCharacters;
  @override
  final bool? workDoneProgress;
  CompletionRegistrationOptions({
    this.allCommitCharacters,
    this.completionItem,
    this.documentSelector,
    this.resolveProvider,
    this.triggerCharacters,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(allCommitCharacters),
        completionItem,
        lspHashCode(documentSelector),
        resolveProvider,
        lspHashCode(triggerCharacters),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is CompletionRegistrationOptions &&
        other.runtimeType == CompletionRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(allCommitCharacters, other.allCommitCharacters) &&
        completionItem == other.completionItem &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        resolveProvider == other.resolveProvider &&
        const DeepCollectionEquality()
            .equals(triggerCharacters, other.triggerCharacters) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (allCommitCharacters != null) {
      result['allCommitCharacters'] = allCommitCharacters;
    }
    if (completionItem != null) {
      result['completionItem'] = completionItem?.toJson();
    }
    result['documentSelector'] = documentSelector;
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (triggerCharacters != null) {
      result['triggerCharacters'] = triggerCharacters;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListString(obj, reporter, 'allCommitCharacters',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseServerCompletionItemOptions(obj, reporter, 'completionItem',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListString(obj, reporter, 'triggerCharacters',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CompletionRegistrationOptions');
      return false;
    }
  }

  static CompletionRegistrationOptions fromJson(Map<String, Object?> json) {
    final allCommitCharactersJson = json['allCommitCharacters'];
    final allCommitCharacters = (allCommitCharactersJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    final completionItemJson = json['completionItem'];
    final completionItem = completionItemJson != null
        ? ServerCompletionItemOptions.fromJson(
            completionItemJson as Map<String, Object?>)
        : null;
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final triggerCharactersJson = json['triggerCharacters'];
    final triggerCharacters = (triggerCharactersJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return CompletionRegistrationOptions(
      allCommitCharacters: allCommitCharacters,
      completionItem: completionItem,
      documentSelector: documentSelector,
      resolveProvider: resolveProvider,
      triggerCharacters: triggerCharacters,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// How a completion was triggered
class CompletionTriggerKind implements ToJsonable {
  /// Completion was triggered by typing an identifier (24x7 code complete),
  /// manual invocation (e.g Ctrl+Space) or via API.
  static const Invoked = CompletionTriggerKind._(1);

  /// Completion was triggered by a trigger character specified by the
  /// `triggerCharacters` properties of the `CompletionRegistrationOptions`.
  static const TriggerCharacter = CompletionTriggerKind._(2);

  /// Completion was re-triggered as current completion list is incomplete
  static const TriggerForIncompleteCompletions = CompletionTriggerKind._(3);

  final int _value;
  const CompletionTriggerKind.fromJson(this._value);
  const CompletionTriggerKind._(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is CompletionTriggerKind && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    switch (obj) {
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }
}

class ConfigurationItem implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ConfigurationItem.canParse,
    ConfigurationItem.fromJson,
  );

  /// The scope to get the configuration section for.
  final LSPUri? scopeUri;

  /// The configuration section asked for.
  final String? section;

  ConfigurationItem({
    this.scopeUri,
    this.section,
  });
  @override
  int get hashCode => Object.hash(
        scopeUri,
        section,
      );

  @override
  bool operator ==(Object other) {
    return other is ConfigurationItem &&
        other.runtimeType == ConfigurationItem &&
        scopeUri == other.scopeUri &&
        section == other.section;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (scopeUri != null) {
      result['scopeUri'] = scopeUri?.toString();
    }
    if (section != null) {
      result['section'] = section;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseUri(obj, reporter, 'scopeUri',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'section',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ConfigurationItem');
      return false;
    }
  }

  static ConfigurationItem fromJson(Map<String, Object?> json) {
    final scopeUriJson = json['scopeUri'];
    final scopeUri =
        scopeUriJson != null ? Uri.parse(scopeUriJson as String) : null;
    final sectionJson = json['section'];
    final section = sectionJson as String?;
    return ConfigurationItem(
      scopeUri: scopeUri,
      section: section,
    );
  }
}

/// The parameters of a configuration request.
class ConfigurationParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ConfigurationParams.canParse,
    ConfigurationParams.fromJson,
  );

  final List<ConfigurationItem> items;

  ConfigurationParams({
    required this.items,
  });

  @override
  int get hashCode => lspHashCode(items);

  @override
  bool operator ==(Object other) {
    return other is ConfigurationParams &&
        other.runtimeType == ConfigurationParams &&
        const DeepCollectionEquality().equals(items, other.items);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['items'] = items.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListConfigurationItem(obj, reporter, 'items',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type ConfigurationParams');
      return false;
    }
  }

  static ConfigurationParams fromJson(Map<String, Object?> json) {
    final itemsJson = json['items'];
    final items = (itemsJson as List<Object?>)
        .map((item) => ConfigurationItem.fromJson(item as Map<String, Object?>))
        .toList();
    return ConfigurationParams(
      items: items,
    );
  }
}

/// Create file operation.
class CreateFile implements ResourceOperation, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CreateFile.canParse,
    CreateFile.fromJson,
  );

  /// An optional annotation identifier describing the operation.
  ///
  /// @since 3.16.0
  @override
  final ChangeAnnotationIdentifier? annotationId;

  /// A create
  @override
  final String kind;

  /// Additional options
  final CreateFileOptions? options;

  /// The resource to create.
  final DocumentUri uri;
  CreateFile({
    this.annotationId,
    this.kind = 'create',
    this.options,
    required this.uri,
  }) {
    if (kind != 'create') {
      throw 'kind may only be the literal \'create\'';
    }
  }
  @override
  int get hashCode => Object.hash(
        annotationId,
        kind,
        options,
        uri,
      );

  @override
  bool operator ==(Object other) {
    return other is CreateFile &&
        other.runtimeType == CreateFile &&
        annotationId == other.annotationId &&
        kind == other.kind &&
        options == other.options &&
        uri == other.uri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (annotationId != null) {
      result['annotationId'] = annotationId;
    }
    result['kind'] = kind;
    if (options != null) {
      result['options'] = options?.toJson();
    }
    result['uri'] = uri.toString();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'annotationId',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseLiteral(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false, literal: 'create')) {
        return false;
      }
      if (!_canParseCreateFileOptions(obj, reporter, 'options',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CreateFile');
      return false;
    }
  }

  static CreateFile fromJson(Map<String, Object?> json) {
    final annotationIdJson = json['annotationId'];
    final annotationId = annotationIdJson as String?;
    final kindJson = json['kind'];
    final kind = kindJson as String;
    final optionsJson = json['options'];
    final options = optionsJson != null
        ? CreateFileOptions.fromJson(optionsJson as Map<String, Object?>)
        : null;
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    return CreateFile(
      annotationId: annotationId,
      kind: kind,
      options: options,
      uri: uri,
    );
  }
}

/// Options to create a file.
class CreateFileOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CreateFileOptions.canParse,
    CreateFileOptions.fromJson,
  );

  /// Ignore if exists.
  final bool? ignoreIfExists;

  /// Overwrite existing file. Overwrite wins over `ignoreIfExists`
  final bool? overwrite;

  CreateFileOptions({
    this.ignoreIfExists,
    this.overwrite,
  });
  @override
  int get hashCode => Object.hash(
        ignoreIfExists,
        overwrite,
      );

  @override
  bool operator ==(Object other) {
    return other is CreateFileOptions &&
        other.runtimeType == CreateFileOptions &&
        ignoreIfExists == other.ignoreIfExists &&
        overwrite == other.overwrite;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (ignoreIfExists != null) {
      result['ignoreIfExists'] = ignoreIfExists;
    }
    if (overwrite != null) {
      result['overwrite'] = overwrite;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'ignoreIfExists',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'overwrite',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type CreateFileOptions');
      return false;
    }
  }

  static CreateFileOptions fromJson(Map<String, Object?> json) {
    final ignoreIfExistsJson = json['ignoreIfExists'];
    final ignoreIfExists = ignoreIfExistsJson as bool?;
    final overwriteJson = json['overwrite'];
    final overwrite = overwriteJson as bool?;
    return CreateFileOptions(
      ignoreIfExists: ignoreIfExists,
      overwrite: overwrite,
    );
  }
}

/// The parameters sent in notifications/requests for user-initiated creation of
/// files.
///
/// @since 3.16.0
class CreateFilesParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    CreateFilesParams.canParse,
    CreateFilesParams.fromJson,
  );

  /// An array of all files/folders created in this operation.
  final List<FileCreate> files;

  CreateFilesParams({
    required this.files,
  });

  @override
  int get hashCode => lspHashCode(files);

  @override
  bool operator ==(Object other) {
    return other is CreateFilesParams &&
        other.runtimeType == CreateFilesParams &&
        const DeepCollectionEquality().equals(files, other.files);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['files'] = files.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListFileCreate(obj, reporter, 'files',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type CreateFilesParams');
      return false;
    }
  }

  static CreateFilesParams fromJson(Map<String, Object?> json) {
    final filesJson = json['files'];
    final files = (filesJson as List<Object?>)
        .map((item) => FileCreate.fromJson(item as Map<String, Object?>))
        .toList();
    return CreateFilesParams(
      files: files,
    );
  }
}

/// @since 3.14.0
class DeclarationClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DeclarationClientCapabilities.canParse,
    DeclarationClientCapabilities.fromJson,
  );

  /// Whether declaration supports dynamic registration. If this is set to
  /// `true` the client supports the new `DeclarationRegistrationOptions` return
  /// value for the corresponding server capability as well.
  final bool? dynamicRegistration;

  /// The client supports additional metadata in the form of declaration links.
  final bool? linkSupport;

  DeclarationClientCapabilities({
    this.dynamicRegistration,
    this.linkSupport,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        linkSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is DeclarationClientCapabilities &&
        other.runtimeType == DeclarationClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        linkSupport == other.linkSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (linkSupport != null) {
      result['linkSupport'] = linkSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'linkSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DeclarationClientCapabilities');
      return false;
    }
  }

  static DeclarationClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final linkSupportJson = json['linkSupport'];
    final linkSupport = linkSupportJson as bool?;
    return DeclarationClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      linkSupport: linkSupport,
    );
  }
}

class DeclarationOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DeclarationOptions.canParse,
    DeclarationOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  DeclarationOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DeclarationOptions &&
        other.runtimeType == DeclarationOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DeclarationOptions');
      return false;
    }
  }

  static DeclarationOptions fromJson(Map<String, Object?> json) {
    if (DeclarationRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return DeclarationRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DeclarationOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

class DeclarationParams
    implements
        PartialResultParams,
        TextDocumentPositionParams,
        WorkDoneProgressParams,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DeclarationParams.canParse,
    DeclarationParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  DeclarationParams({
    this.partialResultToken,
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is DeclarationParams &&
        other.runtimeType == DeclarationParams &&
        partialResultToken == other.partialResultToken &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DeclarationParams');
      return false;
    }
  }

  static DeclarationParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return DeclarationParams(
      partialResultToken: partialResultToken,
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

class DeclarationRegistrationOptions
    implements
        DeclarationOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DeclarationRegistrationOptions.canParse,
    DeclarationRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  @override
  final bool? workDoneProgress;
  DeclarationRegistrationOptions({
    this.documentSelector,
    this.id,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DeclarationRegistrationOptions &&
        other.runtimeType == DeclarationRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DeclarationRegistrationOptions');
      return false;
    }
  }

  static DeclarationRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DeclarationRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Client Capabilities for a [DefinitionRequest].
class DefinitionClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DefinitionClientCapabilities.canParse,
    DefinitionClientCapabilities.fromJson,
  );

  /// Whether definition supports dynamic registration.
  final bool? dynamicRegistration;

  /// The client supports additional metadata in the form of definition links.
  ///
  /// @since 3.14.0
  final bool? linkSupport;

  DefinitionClientCapabilities({
    this.dynamicRegistration,
    this.linkSupport,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        linkSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is DefinitionClientCapabilities &&
        other.runtimeType == DefinitionClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        linkSupport == other.linkSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (linkSupport != null) {
      result['linkSupport'] = linkSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'linkSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DefinitionClientCapabilities');
      return false;
    }
  }

  static DefinitionClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final linkSupportJson = json['linkSupport'];
    final linkSupport = linkSupportJson as bool?;
    return DefinitionClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      linkSupport: linkSupport,
    );
  }
}

/// Server Capabilities for a [DefinitionRequest].
class DefinitionOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DefinitionOptions.canParse,
    DefinitionOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  DefinitionOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DefinitionOptions &&
        other.runtimeType == DefinitionOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DefinitionOptions');
      return false;
    }
  }

  static DefinitionOptions fromJson(Map<String, Object?> json) {
    if (DefinitionRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return DefinitionRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DefinitionOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Parameters for a [DefinitionRequest].
class DefinitionParams
    implements
        PartialResultParams,
        TextDocumentPositionParams,
        WorkDoneProgressParams,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DefinitionParams.canParse,
    DefinitionParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  DefinitionParams({
    this.partialResultToken,
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is DefinitionParams &&
        other.runtimeType == DefinitionParams &&
        partialResultToken == other.partialResultToken &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DefinitionParams');
      return false;
    }
  }

  static DefinitionParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return DefinitionParams(
      partialResultToken: partialResultToken,
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [DefinitionRequest].
class DefinitionRegistrationOptions
    implements DefinitionOptions, TextDocumentRegistrationOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DefinitionRegistrationOptions.canParse,
    DefinitionRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  @override
  final bool? workDoneProgress;

  DefinitionRegistrationOptions({
    this.documentSelector,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DefinitionRegistrationOptions &&
        other.runtimeType == DefinitionRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DefinitionRegistrationOptions');
      return false;
    }
  }

  static DefinitionRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DefinitionRegistrationOptions(
      documentSelector: documentSelector,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Delete file operation
class DeleteFile implements ResourceOperation, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DeleteFile.canParse,
    DeleteFile.fromJson,
  );

  /// An optional annotation identifier describing the operation.
  ///
  /// @since 3.16.0
  @override
  final ChangeAnnotationIdentifier? annotationId;

  /// A delete
  @override
  final String kind;

  /// Delete options.
  final DeleteFileOptions? options;

  /// The file to delete.
  final DocumentUri uri;
  DeleteFile({
    this.annotationId,
    this.kind = 'delete',
    this.options,
    required this.uri,
  }) {
    if (kind != 'delete') {
      throw 'kind may only be the literal \'delete\'';
    }
  }
  @override
  int get hashCode => Object.hash(
        annotationId,
        kind,
        options,
        uri,
      );

  @override
  bool operator ==(Object other) {
    return other is DeleteFile &&
        other.runtimeType == DeleteFile &&
        annotationId == other.annotationId &&
        kind == other.kind &&
        options == other.options &&
        uri == other.uri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (annotationId != null) {
      result['annotationId'] = annotationId;
    }
    result['kind'] = kind;
    if (options != null) {
      result['options'] = options?.toJson();
    }
    result['uri'] = uri.toString();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'annotationId',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseLiteral(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false, literal: 'delete')) {
        return false;
      }
      if (!_canParseDeleteFileOptions(obj, reporter, 'options',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DeleteFile');
      return false;
    }
  }

  static DeleteFile fromJson(Map<String, Object?> json) {
    final annotationIdJson = json['annotationId'];
    final annotationId = annotationIdJson as String?;
    final kindJson = json['kind'];
    final kind = kindJson as String;
    final optionsJson = json['options'];
    final options = optionsJson != null
        ? DeleteFileOptions.fromJson(optionsJson as Map<String, Object?>)
        : null;
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    return DeleteFile(
      annotationId: annotationId,
      kind: kind,
      options: options,
      uri: uri,
    );
  }
}

/// Delete file options
class DeleteFileOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DeleteFileOptions.canParse,
    DeleteFileOptions.fromJson,
  );

  /// Ignore the operation if the file doesn't exist.
  final bool? ignoreIfNotExists;

  /// Delete the content recursively if a folder is denoted.
  final bool? recursive;

  DeleteFileOptions({
    this.ignoreIfNotExists,
    this.recursive,
  });
  @override
  int get hashCode => Object.hash(
        ignoreIfNotExists,
        recursive,
      );

  @override
  bool operator ==(Object other) {
    return other is DeleteFileOptions &&
        other.runtimeType == DeleteFileOptions &&
        ignoreIfNotExists == other.ignoreIfNotExists &&
        recursive == other.recursive;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (ignoreIfNotExists != null) {
      result['ignoreIfNotExists'] = ignoreIfNotExists;
    }
    if (recursive != null) {
      result['recursive'] = recursive;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'ignoreIfNotExists',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'recursive',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DeleteFileOptions');
      return false;
    }
  }

  static DeleteFileOptions fromJson(Map<String, Object?> json) {
    final ignoreIfNotExistsJson = json['ignoreIfNotExists'];
    final ignoreIfNotExists = ignoreIfNotExistsJson as bool?;
    final recursiveJson = json['recursive'];
    final recursive = recursiveJson as bool?;
    return DeleteFileOptions(
      ignoreIfNotExists: ignoreIfNotExists,
      recursive: recursive,
    );
  }
}

/// The parameters sent in notifications/requests for user-initiated deletes of
/// files.
///
/// @since 3.16.0
class DeleteFilesParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DeleteFilesParams.canParse,
    DeleteFilesParams.fromJson,
  );

  /// An array of all files/folders deleted in this operation.
  final List<FileDelete> files;

  DeleteFilesParams({
    required this.files,
  });

  @override
  int get hashCode => lspHashCode(files);

  @override
  bool operator ==(Object other) {
    return other is DeleteFilesParams &&
        other.runtimeType == DeleteFilesParams &&
        const DeepCollectionEquality().equals(files, other.files);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['files'] = files.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListFileDelete(obj, reporter, 'files',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DeleteFilesParams');
      return false;
    }
  }

  static DeleteFilesParams fromJson(Map<String, Object?> json) {
    final filesJson = json['files'];
    final files = (filesJson as List<Object?>)
        .map((item) => FileDelete.fromJson(item as Map<String, Object?>))
        .toList();
    return DeleteFilesParams(
      files: files,
    );
  }
}

/// Represents a diagnostic, such as a compiler error or warning. Diagnostic
/// objects are only valid in the scope of a resource.
class Diagnostic implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    Diagnostic.canParse,
    Diagnostic.fromJson,
  );

  /// The diagnostic's code, which usually appear in the user interface.
  final String? code;

  /// An optional property to describe the error code. Requires the code field
  /// (above) to be present/not null.
  ///
  /// @since 3.16.0
  final CodeDescription? codeDescription;

  /// A data entry field that is preserved between a
  /// `textDocument/publishDiagnostics` notification and
  /// `textDocument/codeAction` request.
  ///
  /// @since 3.16.0
  final LSPAny data;

  /// The diagnostic's message. It usually appears in the user interface
  final String message;

  /// The range at which the message applies
  final Range range;

  /// An array of related diagnostic information, e.g. when symbol-names within
  /// a scope collide all definitions can be marked via this property.
  final List<DiagnosticRelatedInformation>? relatedInformation;

  /// The diagnostic's severity. Can be omitted. If omitted it is up to the
  /// client to interpret diagnostics as error, warning, info or hint.
  final DiagnosticSeverity? severity;

  /// A human-readable string describing the source of this diagnostic, e.g.
  /// 'typescript' or 'super lint'. It usually appears in the user interface.
  final String? source;

  /// Additional metadata about the diagnostic.
  ///
  /// @since 3.15.0
  final List<DiagnosticTag>? tags;
  Diagnostic({
    this.code,
    this.codeDescription,
    this.data,
    required this.message,
    required this.range,
    this.relatedInformation,
    this.severity,
    this.source,
    this.tags,
  });
  @override
  int get hashCode => Object.hash(
        code,
        codeDescription,
        data,
        message,
        range,
        lspHashCode(relatedInformation),
        severity,
        source,
        lspHashCode(tags),
      );

  @override
  bool operator ==(Object other) {
    return other is Diagnostic &&
        other.runtimeType == Diagnostic &&
        code == other.code &&
        codeDescription == other.codeDescription &&
        data == other.data &&
        message == other.message &&
        range == other.range &&
        const DeepCollectionEquality()
            .equals(relatedInformation, other.relatedInformation) &&
        severity == other.severity &&
        source == other.source &&
        const DeepCollectionEquality().equals(tags, other.tags);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (code != null) {
      result['code'] = code;
    }
    if (codeDescription != null) {
      result['codeDescription'] = codeDescription?.toJson();
    }
    if (data != null) {
      result['data'] = data;
    }
    result['message'] = message;
    result['range'] = range.toJson();
    if (relatedInformation != null) {
      result['relatedInformation'] =
          relatedInformation?.map((item) => item.toJson()).toList();
    }
    if (severity != null) {
      result['severity'] = severity?.toJson();
    }
    if (source != null) {
      result['source'] = source;
    }
    if (tags != null) {
      result['tags'] = tags?.map((item) => item.toJson()).toList();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'code',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseCodeDescription(obj, reporter, 'codeDescription',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'message',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseListDiagnosticRelatedInformation(
          obj, reporter, 'relatedInformation',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseDiagnosticSeverity(obj, reporter, 'severity',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'source',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseListDiagnosticTag(obj, reporter, 'tags',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type Diagnostic');
      return false;
    }
  }

  static Diagnostic fromJson(Map<String, Object?> json) {
    final codeJson = json['code'];
    final code = codeJson as String?;
    final codeDescriptionJson = json['codeDescription'];
    final codeDescription = codeDescriptionJson != null
        ? CodeDescription.fromJson(codeDescriptionJson as Map<String, Object?>)
        : null;
    final dataJson = json['data'];
    final data = dataJson;
    final messageJson = json['message'];
    final message = messageJson as String;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final relatedInformationJson = json['relatedInformation'];
    final relatedInformation = (relatedInformationJson as List<Object?>?)
        ?.map((item) =>
            DiagnosticRelatedInformation.fromJson(item as Map<String, Object?>))
        .toList();
    final severityJson = json['severity'];
    final severity = severityJson != null
        ? DiagnosticSeverity.fromJson(severityJson as int)
        : null;
    final sourceJson = json['source'];
    final source = sourceJson as String?;
    final tagsJson = json['tags'];
    final tags = (tagsJson as List<Object?>?)
        ?.map((item) => DiagnosticTag.fromJson(item as int))
        .toList();
    return Diagnostic(
      code: code,
      codeDescription: codeDescription,
      data: data,
      message: message,
      range: range,
      relatedInformation: relatedInformation,
      severity: severity,
      source: source,
      tags: tags,
    );
  }
}

/// Client capabilities specific to diagnostic pull requests.
///
/// @since 3.17.0
class DiagnosticClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DiagnosticClientCapabilities.canParse,
    DiagnosticClientCapabilities.fromJson,
  );

  /// Whether implementation supports dynamic registration. If this is set to
  /// `true` the client supports the new `(TextDocumentRegistrationOptions &
  /// StaticRegistrationOptions)` return value for the corresponding server
  /// capability as well.
  final bool? dynamicRegistration;

  /// Whether the clients supports related documents for document diagnostic
  /// pulls.
  final bool? relatedDocumentSupport;

  DiagnosticClientCapabilities({
    this.dynamicRegistration,
    this.relatedDocumentSupport,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        relatedDocumentSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is DiagnosticClientCapabilities &&
        other.runtimeType == DiagnosticClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        relatedDocumentSupport == other.relatedDocumentSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (relatedDocumentSupport != null) {
      result['relatedDocumentSupport'] = relatedDocumentSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'relatedDocumentSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DiagnosticClientCapabilities');
      return false;
    }
  }

  static DiagnosticClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final relatedDocumentSupportJson = json['relatedDocumentSupport'];
    final relatedDocumentSupport = relatedDocumentSupportJson as bool?;
    return DiagnosticClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      relatedDocumentSupport: relatedDocumentSupport,
    );
  }
}

/// Diagnostic options.
///
/// @since 3.17.0
class DiagnosticOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DiagnosticOptions.canParse,
    DiagnosticOptions.fromJson,
  );

  /// An optional identifier under which the diagnostics are managed by the
  /// client.
  final String? identifier;

  /// Whether the language has inter file dependencies meaning that editing code
  /// in one file can result in a different diagnostic set in another file.
  /// Inter file dependencies are common for most programming languages and
  /// typically uncommon for linters.
  final bool interFileDependencies;

  @override
  final bool? workDoneProgress;

  /// The server provides support for workspace diagnostics as well.
  final bool workspaceDiagnostics;
  DiagnosticOptions({
    this.identifier,
    required this.interFileDependencies,
    this.workDoneProgress,
    required this.workspaceDiagnostics,
  });
  @override
  int get hashCode => Object.hash(
        identifier,
        interFileDependencies,
        workDoneProgress,
        workspaceDiagnostics,
      );

  @override
  bool operator ==(Object other) {
    return other is DiagnosticOptions &&
        other.runtimeType == DiagnosticOptions &&
        identifier == other.identifier &&
        interFileDependencies == other.interFileDependencies &&
        workDoneProgress == other.workDoneProgress &&
        workspaceDiagnostics == other.workspaceDiagnostics;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (identifier != null) {
      result['identifier'] = identifier;
    }
    result['interFileDependencies'] = interFileDependencies;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    result['workspaceDiagnostics'] = workspaceDiagnostics;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'identifier',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'interFileDependencies',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workspaceDiagnostics',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DiagnosticOptions');
      return false;
    }
  }

  static DiagnosticOptions fromJson(Map<String, Object?> json) {
    if (DiagnosticRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return DiagnosticRegistrationOptions.fromJson(json);
    }
    final identifierJson = json['identifier'];
    final identifier = identifierJson as String?;
    final interFileDependenciesJson = json['interFileDependencies'];
    final interFileDependencies = interFileDependenciesJson as bool;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    final workspaceDiagnosticsJson = json['workspaceDiagnostics'];
    final workspaceDiagnostics = workspaceDiagnosticsJson as bool;
    return DiagnosticOptions(
      identifier: identifier,
      interFileDependencies: interFileDependencies,
      workDoneProgress: workDoneProgress,
      workspaceDiagnostics: workspaceDiagnostics,
    );
  }
}

/// Diagnostic registration options.
///
/// @since 3.17.0
class DiagnosticRegistrationOptions
    implements
        DiagnosticOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DiagnosticRegistrationOptions.canParse,
    DiagnosticRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  /// An optional identifier under which the diagnostics are managed by the
  /// client.
  @override
  final String? identifier;

  /// Whether the language has inter file dependencies meaning that editing code
  /// in one file can result in a different diagnostic set in another file.
  /// Inter file dependencies are common for most programming languages and
  /// typically uncommon for linters.
  @override
  final bool interFileDependencies;
  @override
  final bool? workDoneProgress;

  /// The server provides support for workspace diagnostics as well.
  @override
  final bool workspaceDiagnostics;
  DiagnosticRegistrationOptions({
    this.documentSelector,
    this.id,
    this.identifier,
    required this.interFileDependencies,
    this.workDoneProgress,
    required this.workspaceDiagnostics,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        identifier,
        interFileDependencies,
        workDoneProgress,
        workspaceDiagnostics,
      );

  @override
  bool operator ==(Object other) {
    return other is DiagnosticRegistrationOptions &&
        other.runtimeType == DiagnosticRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        identifier == other.identifier &&
        interFileDependencies == other.interFileDependencies &&
        workDoneProgress == other.workDoneProgress &&
        workspaceDiagnostics == other.workspaceDiagnostics;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (identifier != null) {
      result['identifier'] = identifier;
    }
    result['interFileDependencies'] = interFileDependencies;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    result['workspaceDiagnostics'] = workspaceDiagnostics;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'identifier',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'interFileDependencies',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workspaceDiagnostics',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DiagnosticRegistrationOptions');
      return false;
    }
  }

  static DiagnosticRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final identifierJson = json['identifier'];
    final identifier = identifierJson as String?;
    final interFileDependenciesJson = json['interFileDependencies'];
    final interFileDependencies = interFileDependenciesJson as bool;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    final workspaceDiagnosticsJson = json['workspaceDiagnostics'];
    final workspaceDiagnostics = workspaceDiagnosticsJson as bool;
    return DiagnosticRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      identifier: identifier,
      interFileDependencies: interFileDependencies,
      workDoneProgress: workDoneProgress,
      workspaceDiagnostics: workspaceDiagnostics,
    );
  }
}

/// Represents a related message and source code location for a diagnostic. This
/// should be used to point to code locations that cause or related to a
/// diagnostics, e.g when duplicating a symbol in a scope.
class DiagnosticRelatedInformation implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DiagnosticRelatedInformation.canParse,
    DiagnosticRelatedInformation.fromJson,
  );

  /// The location of this related diagnostic information.
  final Location location;

  /// The message of this related diagnostic information.
  final String message;

  DiagnosticRelatedInformation({
    required this.location,
    required this.message,
  });
  @override
  int get hashCode => Object.hash(
        location,
        message,
      );

  @override
  bool operator ==(Object other) {
    return other is DiagnosticRelatedInformation &&
        other.runtimeType == DiagnosticRelatedInformation &&
        location == other.location &&
        message == other.message;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['location'] = location.toJson();
    result['message'] = message;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseLocation(obj, reporter, 'location',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'message',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DiagnosticRelatedInformation');
      return false;
    }
  }

  static DiagnosticRelatedInformation fromJson(Map<String, Object?> json) {
    final locationJson = json['location'];
    final location = Location.fromJson(locationJson as Map<String, Object?>);
    final messageJson = json['message'];
    final message = messageJson as String;
    return DiagnosticRelatedInformation(
      location: location,
      message: message,
    );
  }
}

/// Cancellation data returned from a diagnostic request.
///
/// @since 3.17.0
class DiagnosticServerCancellationData implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DiagnosticServerCancellationData.canParse,
    DiagnosticServerCancellationData.fromJson,
  );

  final bool retriggerRequest;

  DiagnosticServerCancellationData({
    required this.retriggerRequest,
  });

  @override
  int get hashCode => retriggerRequest.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DiagnosticServerCancellationData &&
        other.runtimeType == DiagnosticServerCancellationData &&
        retriggerRequest == other.retriggerRequest;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['retriggerRequest'] = retriggerRequest;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'retriggerRequest',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DiagnosticServerCancellationData');
      return false;
    }
  }

  static DiagnosticServerCancellationData fromJson(Map<String, Object?> json) {
    final retriggerRequestJson = json['retriggerRequest'];
    final retriggerRequest = retriggerRequestJson as bool;
    return DiagnosticServerCancellationData(
      retriggerRequest: retriggerRequest,
    );
  }
}

/// The diagnostic's severity.
class DiagnosticSeverity implements ToJsonable {
  /// Reports an error.
  static const Error = DiagnosticSeverity(1);

  /// Reports a hint.
  static const Hint = DiagnosticSeverity(4);

  /// Reports an information.
  static const Information = DiagnosticSeverity(3);

  /// Reports a warning.
  static const Warning = DiagnosticSeverity(2);
  final int _value;
  const DiagnosticSeverity(this._value);
  const DiagnosticSeverity.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is DiagnosticSeverity && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// The diagnostic tags.
///
/// @since 3.15.0
class DiagnosticTag implements ToJsonable {
  /// Deprecated or obsolete code.
  ///
  /// Clients are allowed to rendered diagnostics with this tag strike through.
  static const Deprecated = DiagnosticTag(2);

  /// Unused or unnecessary code.
  ///
  /// Clients are allowed to render diagnostics with this tag faded out instead
  /// of having an error squiggle.
  static const Unnecessary = DiagnosticTag(1);

  final int _value;

  const DiagnosticTag(this._value);
  const DiagnosticTag.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is DiagnosticTag && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// Workspace client capabilities specific to diagnostic pull requests.
///
/// @since 3.17.0
class DiagnosticWorkspaceClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DiagnosticWorkspaceClientCapabilities.canParse,
    DiagnosticWorkspaceClientCapabilities.fromJson,
  );

  /// Whether the client implementation supports a refresh request sent from the
  /// server to the client.
  ///
  /// Note that this event is global and will force the client to refresh all
  /// pulled diagnostics currently shown. It should be used with absolute care
  /// and is useful for situation where a server for example detects a project
  /// wide change that requires such a calculation.
  final bool? refreshSupport;

  DiagnosticWorkspaceClientCapabilities({
    this.refreshSupport,
  });

  @override
  int get hashCode => refreshSupport.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DiagnosticWorkspaceClientCapabilities &&
        other.runtimeType == DiagnosticWorkspaceClientCapabilities &&
        refreshSupport == other.refreshSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (refreshSupport != null) {
      result['refreshSupport'] = refreshSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'refreshSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type DiagnosticWorkspaceClientCapabilities');
      return false;
    }
  }

  static DiagnosticWorkspaceClientCapabilities fromJson(
      Map<String, Object?> json) {
    final refreshSupportJson = json['refreshSupport'];
    final refreshSupport = refreshSupportJson as bool?;
    return DiagnosticWorkspaceClientCapabilities(
      refreshSupport: refreshSupport,
    );
  }
}

class DidChangeConfigurationClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidChangeConfigurationClientCapabilities.canParse,
    DidChangeConfigurationClientCapabilities.fromJson,
  );

  /// Did change configuration notification supports dynamic registration.
  final bool? dynamicRegistration;

  DidChangeConfigurationClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DidChangeConfigurationClientCapabilities &&
        other.runtimeType == DidChangeConfigurationClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type DidChangeConfigurationClientCapabilities');
      return false;
    }
  }

  static DidChangeConfigurationClientCapabilities fromJson(
      Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return DidChangeConfigurationClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// The parameters of a change configuration notification.
class DidChangeConfigurationParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidChangeConfigurationParams.canParse,
    DidChangeConfigurationParams.fromJson,
  );

  /// The actual changed settings
  final LSPAny settings;

  DidChangeConfigurationParams({
    this.settings,
  });

  @override
  int get hashCode => settings.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DidChangeConfigurationParams &&
        other.runtimeType == DidChangeConfigurationParams &&
        settings == other.settings;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['settings'] = settings;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return true;
    } else {
      reporter.reportError('must be of type DidChangeConfigurationParams');
      return false;
    }
  }

  static DidChangeConfigurationParams fromJson(Map<String, Object?> json) {
    final settingsJson = json['settings'];
    final settings = settingsJson;
    return DidChangeConfigurationParams(
      settings: settings,
    );
  }
}

/// The params sent in a change notebook document notification.
///
/// @since 3.17.0
class DidChangeNotebookDocumentParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidChangeNotebookDocumentParams.canParse,
    DidChangeNotebookDocumentParams.fromJson,
  );

  /// The actual changes to the notebook document.
  ///
  /// The changes describe single state changes to the notebook document. So if
  /// there are two changes c1 (at array index 0) and c2 (at array index 1) for
  /// a notebook in state S then c1 moves the notebook from S to S' and c2 from
  /// S' to S''. So c1 is computed on the state S and c2 is computed on the
  /// state S'.
  ///
  /// To mirror the content of a notebook using change events use the following
  /// approach:
  /// - start with the same initial content
  /// - apply the 'notebookDocument/didChange' notifications in the order you
  /// receive them.
  /// - apply the `NotebookChangeEvent`s in a single notification in the order
  ///   you receive them.
  final NotebookDocumentChangeEvent change;

  /// The notebook document that did change. The version number points to the
  /// version after all provided changes have been applied. If only the text
  /// document content of a cell changes the notebook version doesn't
  /// necessarily have to change.
  final VersionedNotebookDocumentIdentifier notebookDocument;

  DidChangeNotebookDocumentParams({
    required this.change,
    required this.notebookDocument,
  });
  @override
  int get hashCode => Object.hash(
        change,
        notebookDocument,
      );

  @override
  bool operator ==(Object other) {
    return other is DidChangeNotebookDocumentParams &&
        other.runtimeType == DidChangeNotebookDocumentParams &&
        change == other.change &&
        notebookDocument == other.notebookDocument;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['change'] = change.toJson();
    result['notebookDocument'] = notebookDocument.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseNotebookDocumentChangeEvent(obj, reporter, 'change',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseVersionedNotebookDocumentIdentifier(
          obj, reporter, 'notebookDocument',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidChangeNotebookDocumentParams');
      return false;
    }
  }

  static DidChangeNotebookDocumentParams fromJson(Map<String, Object?> json) {
    final changeJson = json['change'];
    final change = NotebookDocumentChangeEvent.fromJson(
        changeJson as Map<String, Object?>);
    final notebookDocumentJson = json['notebookDocument'];
    final notebookDocument = VersionedNotebookDocumentIdentifier.fromJson(
        notebookDocumentJson as Map<String, Object?>);
    return DidChangeNotebookDocumentParams(
      change: change,
      notebookDocument: notebookDocument,
    );
  }
}

/// The change text document notification's parameters.
class DidChangeTextDocumentParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidChangeTextDocumentParams.canParse,
    DidChangeTextDocumentParams.fromJson,
  );

  /// The actual content changes. The content changes describe single state
  /// changes to the document. So if there are two content changes c1 (at array
  /// index 0) and c2 (at array index 1) for a document in state S then c1 moves
  /// the document from S to S' and c2 from S' to S''. So c1 is computed on the
  /// state S and c2 is computed on the state S'.
  ///
  /// To mirror the content of a document using change events use the following
  /// approach:
  /// - start with the same initial content
  /// - apply the 'textDocument/didChange' notifications in the order you
  /// receive them.
  /// - apply the `TextDocumentContentChangeEvent`s in a single notification in
  /// the order
  ///   you receive them.
  final List<TextDocumentContentChangeEvent> contentChanges;

  /// The document that did change. The version number points to the version
  /// after all provided content changes have been applied.
  final VersionedTextDocumentIdentifier textDocument;

  DidChangeTextDocumentParams({
    required this.contentChanges,
    required this.textDocument,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(contentChanges),
        textDocument,
      );

  @override
  bool operator ==(Object other) {
    return other is DidChangeTextDocumentParams &&
        other.runtimeType == DidChangeTextDocumentParams &&
        const DeepCollectionEquality()
            .equals(contentChanges, other.contentChanges) &&
        textDocument == other.textDocument;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['contentChanges'] = contentChanges;
    result['textDocument'] = textDocument.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentContentChangePartialTextDocumentContentChangeWholeDocument(
          obj, reporter, 'contentChanges',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseVersionedTextDocumentIdentifier(
          obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidChangeTextDocumentParams');
      return false;
    }
  }

  static DidChangeTextDocumentParams fromJson(Map<String, Object?> json) {
    final contentChangesJson = json['contentChanges'];
    final contentChanges = (contentChangesJson as List<Object?>)
        .map((item) =>
            _eitherTextDocumentContentChangePartialTextDocumentContentChangeWholeDocument(
                item))
        .toList();
    final textDocumentJson = json['textDocument'];
    final textDocument = VersionedTextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    return DidChangeTextDocumentParams(
      contentChanges: contentChanges,
      textDocument: textDocument,
    );
  }
}

class DidChangeWatchedFilesClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidChangeWatchedFilesClientCapabilities.canParse,
    DidChangeWatchedFilesClientCapabilities.fromJson,
  );

  /// Did change watched files notification supports dynamic registration.
  /// Please note that the current protocol doesn't support static configuration
  /// for file changes from the server side.
  final bool? dynamicRegistration;

  /// Whether the client has support for [RelativePattern] or not.
  ///
  /// @since 3.17.0
  final bool? relativePatternSupport;

  DidChangeWatchedFilesClientCapabilities({
    this.dynamicRegistration,
    this.relativePatternSupport,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        relativePatternSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is DidChangeWatchedFilesClientCapabilities &&
        other.runtimeType == DidChangeWatchedFilesClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        relativePatternSupport == other.relativePatternSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (relativePatternSupport != null) {
      result['relativePatternSupport'] = relativePatternSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'relativePatternSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type DidChangeWatchedFilesClientCapabilities');
      return false;
    }
  }

  static DidChangeWatchedFilesClientCapabilities fromJson(
      Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final relativePatternSupportJson = json['relativePatternSupport'];
    final relativePatternSupport = relativePatternSupportJson as bool?;
    return DidChangeWatchedFilesClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      relativePatternSupport: relativePatternSupport,
    );
  }
}

/// The watched files change notification's parameters.
class DidChangeWatchedFilesParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidChangeWatchedFilesParams.canParse,
    DidChangeWatchedFilesParams.fromJson,
  );

  /// The actual file events.
  final List<FileEvent> changes;

  DidChangeWatchedFilesParams({
    required this.changes,
  });

  @override
  int get hashCode => lspHashCode(changes);

  @override
  bool operator ==(Object other) {
    return other is DidChangeWatchedFilesParams &&
        other.runtimeType == DidChangeWatchedFilesParams &&
        const DeepCollectionEquality().equals(changes, other.changes);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['changes'] = changes.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListFileEvent(obj, reporter, 'changes',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidChangeWatchedFilesParams');
      return false;
    }
  }

  static DidChangeWatchedFilesParams fromJson(Map<String, Object?> json) {
    final changesJson = json['changes'];
    final changes = (changesJson as List<Object?>)
        .map((item) => FileEvent.fromJson(item as Map<String, Object?>))
        .toList();
    return DidChangeWatchedFilesParams(
      changes: changes,
    );
  }
}

/// Describe options to be used when registered for text document change events.
class DidChangeWatchedFilesRegistrationOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidChangeWatchedFilesRegistrationOptions.canParse,
    DidChangeWatchedFilesRegistrationOptions.fromJson,
  );

  /// The watchers to register.
  final List<FileSystemWatcher> watchers;

  DidChangeWatchedFilesRegistrationOptions({
    required this.watchers,
  });

  @override
  int get hashCode => lspHashCode(watchers);

  @override
  bool operator ==(Object other) {
    return other is DidChangeWatchedFilesRegistrationOptions &&
        other.runtimeType == DidChangeWatchedFilesRegistrationOptions &&
        const DeepCollectionEquality().equals(watchers, other.watchers);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['watchers'] = watchers.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListFileSystemWatcher(obj, reporter, 'watchers',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type DidChangeWatchedFilesRegistrationOptions');
      return false;
    }
  }

  static DidChangeWatchedFilesRegistrationOptions fromJson(
      Map<String, Object?> json) {
    final watchersJson = json['watchers'];
    final watchers = (watchersJson as List<Object?>)
        .map((item) => FileSystemWatcher.fromJson(item as Map<String, Object?>))
        .toList();
    return DidChangeWatchedFilesRegistrationOptions(
      watchers: watchers,
    );
  }
}

/// The parameters of a `workspace/didChangeWorkspaceFolders` notification.
class DidChangeWorkspaceFoldersParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidChangeWorkspaceFoldersParams.canParse,
    DidChangeWorkspaceFoldersParams.fromJson,
  );

  /// The actual workspace folder change event.
  final WorkspaceFoldersChangeEvent event;

  DidChangeWorkspaceFoldersParams({
    required this.event,
  });

  @override
  int get hashCode => event.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DidChangeWorkspaceFoldersParams &&
        other.runtimeType == DidChangeWorkspaceFoldersParams &&
        event == other.event;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['event'] = event.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseWorkspaceFoldersChangeEvent(obj, reporter, 'event',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidChangeWorkspaceFoldersParams');
      return false;
    }
  }

  static DidChangeWorkspaceFoldersParams fromJson(Map<String, Object?> json) {
    final eventJson = json['event'];
    final event =
        WorkspaceFoldersChangeEvent.fromJson(eventJson as Map<String, Object?>);
    return DidChangeWorkspaceFoldersParams(
      event: event,
    );
  }
}

/// The params sent in a close notebook document notification.
///
/// @since 3.17.0
class DidCloseNotebookDocumentParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidCloseNotebookDocumentParams.canParse,
    DidCloseNotebookDocumentParams.fromJson,
  );

  /// The text documents that represent the content of a notebook cell that got
  /// closed.
  final List<TextDocumentIdentifier> cellTextDocuments;

  /// The notebook document that got closed.
  final NotebookDocumentIdentifier notebookDocument;

  DidCloseNotebookDocumentParams({
    required this.cellTextDocuments,
    required this.notebookDocument,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(cellTextDocuments),
        notebookDocument,
      );

  @override
  bool operator ==(Object other) {
    return other is DidCloseNotebookDocumentParams &&
        other.runtimeType == DidCloseNotebookDocumentParams &&
        const DeepCollectionEquality()
            .equals(cellTextDocuments, other.cellTextDocuments) &&
        notebookDocument == other.notebookDocument;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['cellTextDocuments'] =
        cellTextDocuments.map((item) => item.toJson()).toList();
    result['notebookDocument'] = notebookDocument.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentIdentifier(
          obj, reporter, 'cellTextDocuments',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseNotebookDocumentIdentifier(
          obj, reporter, 'notebookDocument',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidCloseNotebookDocumentParams');
      return false;
    }
  }

  static DidCloseNotebookDocumentParams fromJson(Map<String, Object?> json) {
    final cellTextDocumentsJson = json['cellTextDocuments'];
    final cellTextDocuments = (cellTextDocumentsJson as List<Object?>)
        .map((item) =>
            TextDocumentIdentifier.fromJson(item as Map<String, Object?>))
        .toList();
    final notebookDocumentJson = json['notebookDocument'];
    final notebookDocument = NotebookDocumentIdentifier.fromJson(
        notebookDocumentJson as Map<String, Object?>);
    return DidCloseNotebookDocumentParams(
      cellTextDocuments: cellTextDocuments,
      notebookDocument: notebookDocument,
    );
  }
}

/// The parameters sent in a close text document notification
class DidCloseTextDocumentParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidCloseTextDocumentParams.canParse,
    DidCloseTextDocumentParams.fromJson,
  );

  /// The document that was closed.
  final TextDocumentIdentifier textDocument;

  DidCloseTextDocumentParams({
    required this.textDocument,
  });

  @override
  int get hashCode => textDocument.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DidCloseTextDocumentParams &&
        other.runtimeType == DidCloseTextDocumentParams &&
        textDocument == other.textDocument;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['textDocument'] = textDocument.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidCloseTextDocumentParams');
      return false;
    }
  }

  static DidCloseTextDocumentParams fromJson(Map<String, Object?> json) {
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    return DidCloseTextDocumentParams(
      textDocument: textDocument,
    );
  }
}

/// The params sent in an open notebook document notification.
///
/// @since 3.17.0
class DidOpenNotebookDocumentParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidOpenNotebookDocumentParams.canParse,
    DidOpenNotebookDocumentParams.fromJson,
  );

  /// The text documents that represent the content of a notebook cell.
  final List<TextDocumentItem> cellTextDocuments;

  /// The notebook document that got opened.
  final NotebookDocument notebookDocument;

  DidOpenNotebookDocumentParams({
    required this.cellTextDocuments,
    required this.notebookDocument,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(cellTextDocuments),
        notebookDocument,
      );

  @override
  bool operator ==(Object other) {
    return other is DidOpenNotebookDocumentParams &&
        other.runtimeType == DidOpenNotebookDocumentParams &&
        const DeepCollectionEquality()
            .equals(cellTextDocuments, other.cellTextDocuments) &&
        notebookDocument == other.notebookDocument;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['cellTextDocuments'] =
        cellTextDocuments.map((item) => item.toJson()).toList();
    result['notebookDocument'] = notebookDocument.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentItem(obj, reporter, 'cellTextDocuments',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseNotebookDocument(obj, reporter, 'notebookDocument',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidOpenNotebookDocumentParams');
      return false;
    }
  }

  static DidOpenNotebookDocumentParams fromJson(Map<String, Object?> json) {
    final cellTextDocumentsJson = json['cellTextDocuments'];
    final cellTextDocuments = (cellTextDocumentsJson as List<Object?>)
        .map((item) => TextDocumentItem.fromJson(item as Map<String, Object?>))
        .toList();
    final notebookDocumentJson = json['notebookDocument'];
    final notebookDocument =
        NotebookDocument.fromJson(notebookDocumentJson as Map<String, Object?>);
    return DidOpenNotebookDocumentParams(
      cellTextDocuments: cellTextDocuments,
      notebookDocument: notebookDocument,
    );
  }
}

/// The parameters sent in an open text document notification
class DidOpenTextDocumentParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidOpenTextDocumentParams.canParse,
    DidOpenTextDocumentParams.fromJson,
  );

  /// The document that was opened.
  final TextDocumentItem textDocument;

  DidOpenTextDocumentParams({
    required this.textDocument,
  });

  @override
  int get hashCode => textDocument.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DidOpenTextDocumentParams &&
        other.runtimeType == DidOpenTextDocumentParams &&
        textDocument == other.textDocument;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['textDocument'] = textDocument.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseTextDocumentItem(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidOpenTextDocumentParams');
      return false;
    }
  }

  static DidOpenTextDocumentParams fromJson(Map<String, Object?> json) {
    final textDocumentJson = json['textDocument'];
    final textDocument =
        TextDocumentItem.fromJson(textDocumentJson as Map<String, Object?>);
    return DidOpenTextDocumentParams(
      textDocument: textDocument,
    );
  }
}

/// The params sent in a save notebook document notification.
///
/// @since 3.17.0
class DidSaveNotebookDocumentParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidSaveNotebookDocumentParams.canParse,
    DidSaveNotebookDocumentParams.fromJson,
  );

  /// The notebook document that got saved.
  final NotebookDocumentIdentifier notebookDocument;

  DidSaveNotebookDocumentParams({
    required this.notebookDocument,
  });

  @override
  int get hashCode => notebookDocument.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DidSaveNotebookDocumentParams &&
        other.runtimeType == DidSaveNotebookDocumentParams &&
        notebookDocument == other.notebookDocument;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['notebookDocument'] = notebookDocument.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseNotebookDocumentIdentifier(
          obj, reporter, 'notebookDocument',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidSaveNotebookDocumentParams');
      return false;
    }
  }

  static DidSaveNotebookDocumentParams fromJson(Map<String, Object?> json) {
    final notebookDocumentJson = json['notebookDocument'];
    final notebookDocument = NotebookDocumentIdentifier.fromJson(
        notebookDocumentJson as Map<String, Object?>);
    return DidSaveNotebookDocumentParams(
      notebookDocument: notebookDocument,
    );
  }
}

/// The parameters sent in a save text document notification
class DidSaveTextDocumentParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DidSaveTextDocumentParams.canParse,
    DidSaveTextDocumentParams.fromJson,
  );

  /// Optional the content when saved. Depends on the includeText value when the
  /// save notification was requested.
  final String? text;

  /// The document that was saved.
  final TextDocumentIdentifier textDocument;

  DidSaveTextDocumentParams({
    this.text,
    required this.textDocument,
  });
  @override
  int get hashCode => Object.hash(
        text,
        textDocument,
      );

  @override
  bool operator ==(Object other) {
    return other is DidSaveTextDocumentParams &&
        other.runtimeType == DidSaveTextDocumentParams &&
        text == other.text &&
        textDocument == other.textDocument;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (text != null) {
      result['text'] = text;
    }
    result['textDocument'] = textDocument.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'text',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DidSaveTextDocumentParams');
      return false;
    }
  }

  static DidSaveTextDocumentParams fromJson(Map<String, Object?> json) {
    final textJson = json['text'];
    final text = textJson as String?;
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    return DidSaveTextDocumentParams(
      text: text,
      textDocument: textDocument,
    );
  }
}

class DocumentColorClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentColorClientCapabilities.canParse,
    DocumentColorClientCapabilities.fromJson,
  );

  /// Whether implementation supports dynamic registration. If this is set to
  /// `true` the client supports the new `DocumentColorRegistrationOptions`
  /// return value for the corresponding server capability as well.
  final bool? dynamicRegistration;

  DocumentColorClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DocumentColorClientCapabilities &&
        other.runtimeType == DocumentColorClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentColorClientCapabilities');
      return false;
    }
  }

  static DocumentColorClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return DocumentColorClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

class DocumentColorOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentColorOptions.canParse,
    DocumentColorOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  DocumentColorOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DocumentColorOptions &&
        other.runtimeType == DocumentColorOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentColorOptions');
      return false;
    }
  }

  static DocumentColorOptions fromJson(Map<String, Object?> json) {
    if (DocumentColorRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return DocumentColorRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentColorOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Parameters for a [DocumentColorRequest].
class DocumentColorParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentColorParams.canParse,
    DocumentColorParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The text document.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  DocumentColorParams({
    this.partialResultToken,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentColorParams &&
        other.runtimeType == DocumentColorParams &&
        partialResultToken == other.partialResultToken &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentColorParams');
      return false;
    }
  }

  static DocumentColorParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return DocumentColorParams(
      partialResultToken: partialResultToken,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

class DocumentColorRegistrationOptions
    implements
        DocumentColorOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentColorRegistrationOptions.canParse,
    DocumentColorRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  @override
  final bool? workDoneProgress;
  DocumentColorRegistrationOptions({
    this.documentSelector,
    this.id,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentColorRegistrationOptions &&
        other.runtimeType == DocumentColorRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentColorRegistrationOptions');
      return false;
    }
  }

  static DocumentColorRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentColorRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Parameters of the document diagnostic request.
///
/// @since 3.17.0
class DocumentDiagnosticParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentDiagnosticParams.canParse,
    DocumentDiagnosticParams.fromJson,
  );

  /// The additional identifier  provided during registration.
  final String? identifier;

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The result id of a previous response if provided.
  final String? previousResultId;

  /// The text document.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  DocumentDiagnosticParams({
    this.identifier,
    this.partialResultToken,
    this.previousResultId,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        identifier,
        partialResultToken,
        previousResultId,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentDiagnosticParams &&
        other.runtimeType == DocumentDiagnosticParams &&
        identifier == other.identifier &&
        partialResultToken == other.partialResultToken &&
        previousResultId == other.previousResultId &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (identifier != null) {
      result['identifier'] = identifier;
    }
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    if (previousResultId != null) {
      result['previousResultId'] = previousResultId;
    }
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'identifier',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'previousResultId',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentDiagnosticParams');
      return false;
    }
  }

  static DocumentDiagnosticParams fromJson(Map<String, Object?> json) {
    final identifierJson = json['identifier'];
    final identifier = identifierJson as String?;
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final previousResultIdJson = json['previousResultId'];
    final previousResultId = previousResultIdJson as String?;
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return DocumentDiagnosticParams(
      identifier: identifier,
      partialResultToken: partialResultToken,
      previousResultId: previousResultId,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// The document diagnostic report kinds.
///
/// @since 3.17.0
class DocumentDiagnosticReportKind implements ToJsonable {
  /// A diagnostic report with a full set of problems.
  static const Full = DocumentDiagnosticReportKind('full');

  /// A report indicating that the last returned report is still accurate.
  static const Unchanged = DocumentDiagnosticReportKind('unchanged');

  final String _value;

  const DocumentDiagnosticReportKind(this._value);
  const DocumentDiagnosticReportKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is DocumentDiagnosticReportKind && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is String;
}

/// A partial result for a document diagnostic report.
///
/// @since 3.17.0
class DocumentDiagnosticReportPartialResult implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentDiagnosticReportPartialResult.canParse,
    DocumentDiagnosticReportPartialResult.fromJson,
  );

  final Map<
      DocumentUri,
      Either2<FullDocumentDiagnosticReport,
          UnchangedDocumentDiagnosticReport>> relatedDocuments;

  DocumentDiagnosticReportPartialResult({
    required this.relatedDocuments,
  });

  @override
  int get hashCode => lspHashCode(relatedDocuments);

  @override
  bool operator ==(Object other) {
    return other is DocumentDiagnosticReportPartialResult &&
        other.runtimeType == DocumentDiagnosticReportPartialResult &&
        const DeepCollectionEquality()
            .equals(relatedDocuments, other.relatedDocuments);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['relatedDocuments'] =
        relatedDocuments.map((key, value) => MapEntry(key.toString(), value));
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseMapUriFullDocumentDiagnosticReportUnchangedDocumentDiagnosticReport(
          obj, reporter, 'relatedDocuments',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type DocumentDiagnosticReportPartialResult');
      return false;
    }
  }

  static DocumentDiagnosticReportPartialResult fromJson(
      Map<String, Object?> json) {
    final relatedDocumentsJson = json['relatedDocuments'];
    final relatedDocuments = (relatedDocumentsJson as Map<Object, Object?>).map(
        (key, value) => MapEntry(
            Uri.parse(key as String),
            _eitherFullDocumentDiagnosticReportUnchangedDocumentDiagnosticReport(
                value)));
    return DocumentDiagnosticReportPartialResult(
      relatedDocuments: relatedDocuments,
    );
  }
}

/// Client capabilities of a [DocumentFormattingRequest].
class DocumentFormattingClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentFormattingClientCapabilities.canParse,
    DocumentFormattingClientCapabilities.fromJson,
  );

  /// Whether formatting supports dynamic registration.
  final bool? dynamicRegistration;

  DocumentFormattingClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DocumentFormattingClientCapabilities &&
        other.runtimeType == DocumentFormattingClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type DocumentFormattingClientCapabilities');
      return false;
    }
  }

  static DocumentFormattingClientCapabilities fromJson(
      Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return DocumentFormattingClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// Provider options for a [DocumentFormattingRequest].
class DocumentFormattingOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentFormattingOptions.canParse,
    DocumentFormattingOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  DocumentFormattingOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DocumentFormattingOptions &&
        other.runtimeType == DocumentFormattingOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentFormattingOptions');
      return false;
    }
  }

  static DocumentFormattingOptions fromJson(Map<String, Object?> json) {
    if (DocumentFormattingRegistrationOptions.canParse(
        json, nullLspJsonReporter)) {
      return DocumentFormattingRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentFormattingOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// The parameters of a [DocumentFormattingRequest].
class DocumentFormattingParams implements WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentFormattingParams.canParse,
    DocumentFormattingParams.fromJson,
  );

  /// The format options.
  final FormattingOptions options;

  /// The document to format.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  DocumentFormattingParams({
    required this.options,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        options,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentFormattingParams &&
        other.runtimeType == DocumentFormattingParams &&
        options == other.options &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['options'] = options.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseFormattingOptions(obj, reporter, 'options',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentFormattingParams');
      return false;
    }
  }

  static DocumentFormattingParams fromJson(Map<String, Object?> json) {
    final optionsJson = json['options'];
    final options =
        FormattingOptions.fromJson(optionsJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return DocumentFormattingParams(
      options: options,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [DocumentFormattingRequest].
class DocumentFormattingRegistrationOptions
    implements
        DocumentFormattingOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentFormattingRegistrationOptions.canParse,
    DocumentFormattingRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  @override
  final bool? workDoneProgress;

  DocumentFormattingRegistrationOptions({
    this.documentSelector,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentFormattingRegistrationOptions &&
        other.runtimeType == DocumentFormattingRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type DocumentFormattingRegistrationOptions');
      return false;
    }
  }

  static DocumentFormattingRegistrationOptions fromJson(
      Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentFormattingRegistrationOptions(
      documentSelector: documentSelector,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// A document highlight is a range inside a text document which deserves
/// special attention. Usually a document highlight is visualized by changing
/// the background color of its range.
class DocumentHighlight implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentHighlight.canParse,
    DocumentHighlight.fromJson,
  );

  /// The highlight kind, default is [DocumentHighlightKind.Text].
  final DocumentHighlightKind? kind;

  /// The range this highlight applies to.
  final Range range;

  DocumentHighlight({
    this.kind,
    required this.range,
  });
  @override
  int get hashCode => Object.hash(
        kind,
        range,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentHighlight &&
        other.runtimeType == DocumentHighlight &&
        kind == other.kind &&
        range == other.range;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (kind != null) {
      result['kind'] = kind?.toJson();
    }
    result['range'] = range.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseDocumentHighlightKind(obj, reporter, 'kind',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentHighlight');
      return false;
    }
  }

  static DocumentHighlight fromJson(Map<String, Object?> json) {
    final kindJson = json['kind'];
    final kind = kindJson != null
        ? DocumentHighlightKind.fromJson(kindJson as int)
        : null;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    return DocumentHighlight(
      kind: kind,
      range: range,
    );
  }
}

/// Client Capabilities for a [DocumentHighlightRequest].
class DocumentHighlightClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentHighlightClientCapabilities.canParse,
    DocumentHighlightClientCapabilities.fromJson,
  );

  /// Whether document highlight supports dynamic registration.
  final bool? dynamicRegistration;

  DocumentHighlightClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DocumentHighlightClientCapabilities &&
        other.runtimeType == DocumentHighlightClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type DocumentHighlightClientCapabilities');
      return false;
    }
  }

  static DocumentHighlightClientCapabilities fromJson(
      Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return DocumentHighlightClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// A document highlight kind.
class DocumentHighlightKind implements ToJsonable {
  /// Read-access of a symbol, like reading a variable.
  static const Read = DocumentHighlightKind(2);

  /// A textual occurrence.
  static const Text = DocumentHighlightKind(1);

  /// Write-access of a symbol, like writing to a variable.
  static const Write = DocumentHighlightKind(3);

  final int _value;
  const DocumentHighlightKind(this._value);
  const DocumentHighlightKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is DocumentHighlightKind && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// Provider options for a [DocumentHighlightRequest].
class DocumentHighlightOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentHighlightOptions.canParse,
    DocumentHighlightOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  DocumentHighlightOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DocumentHighlightOptions &&
        other.runtimeType == DocumentHighlightOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentHighlightOptions');
      return false;
    }
  }

  static DocumentHighlightOptions fromJson(Map<String, Object?> json) {
    if (DocumentHighlightRegistrationOptions.canParse(
        json, nullLspJsonReporter)) {
      return DocumentHighlightRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentHighlightOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Parameters for a [DocumentHighlightRequest].
class DocumentHighlightParams
    implements
        PartialResultParams,
        TextDocumentPositionParams,
        WorkDoneProgressParams,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentHighlightParams.canParse,
    DocumentHighlightParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  DocumentHighlightParams({
    this.partialResultToken,
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentHighlightParams &&
        other.runtimeType == DocumentHighlightParams &&
        partialResultToken == other.partialResultToken &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentHighlightParams');
      return false;
    }
  }

  static DocumentHighlightParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return DocumentHighlightParams(
      partialResultToken: partialResultToken,
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [DocumentHighlightRequest].
class DocumentHighlightRegistrationOptions
    implements
        DocumentHighlightOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentHighlightRegistrationOptions.canParse,
    DocumentHighlightRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  @override
  final bool? workDoneProgress;

  DocumentHighlightRegistrationOptions({
    this.documentSelector,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentHighlightRegistrationOptions &&
        other.runtimeType == DocumentHighlightRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type DocumentHighlightRegistrationOptions');
      return false;
    }
  }

  static DocumentHighlightRegistrationOptions fromJson(
      Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentHighlightRegistrationOptions(
      documentSelector: documentSelector,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// A document link is a range in a text document that links to an internal or
/// external resource, like another text document or a web site.
class DocumentLink implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentLink.canParse,
    DocumentLink.fromJson,
  );

  /// A data entry field that is preserved on a document link between a
  /// DocumentLinkRequest and a DocumentLinkResolveRequest.
  final LSPAny data;

  /// The range this link applies to.
  final Range range;

  /// The uri this link points to. If missing a resolve request is sent later.
  final LSPUri? target;

  /// The tooltip text when you hover over this link.
  ///
  /// If a tooltip is provided, is will be displayed in a string that includes
  /// instructions on how to trigger the link, such as `{0} (ctrl + click)`. The
  /// specific instructions vary depending on OS,
  /// user settings, and localization.
  ///
  /// @since 3.15.0
  final String? tooltip;
  DocumentLink({
    this.data,
    required this.range,
    this.target,
    this.tooltip,
  });
  @override
  int get hashCode => Object.hash(
        data,
        range,
        target,
        tooltip,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentLink &&
        other.runtimeType == DocumentLink &&
        data == other.data &&
        range == other.range &&
        target == other.target &&
        tooltip == other.tooltip;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (data != null) {
      result['data'] = data;
    }
    result['range'] = range.toJson();
    if (target != null) {
      result['target'] = target?.toString();
    }
    if (tooltip != null) {
      result['tooltip'] = tooltip;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseUri(obj, reporter, 'target',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'tooltip',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentLink');
      return false;
    }
  }

  static DocumentLink fromJson(Map<String, Object?> json) {
    final dataJson = json['data'];
    final data = dataJson;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final targetJson = json['target'];
    final target = targetJson != null ? Uri.parse(targetJson as String) : null;
    final tooltipJson = json['tooltip'];
    final tooltip = tooltipJson as String?;
    return DocumentLink(
      data: data,
      range: range,
      target: target,
      tooltip: tooltip,
    );
  }
}

/// The client capabilities of a [DocumentLinkRequest].
class DocumentLinkClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentLinkClientCapabilities.canParse,
    DocumentLinkClientCapabilities.fromJson,
  );

  /// Whether document link supports dynamic registration.
  final bool? dynamicRegistration;

  /// Whether the client supports the `tooltip` property on `DocumentLink`.
  ///
  /// @since 3.15.0
  final bool? tooltipSupport;

  DocumentLinkClientCapabilities({
    this.dynamicRegistration,
    this.tooltipSupport,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        tooltipSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentLinkClientCapabilities &&
        other.runtimeType == DocumentLinkClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        tooltipSupport == other.tooltipSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (tooltipSupport != null) {
      result['tooltipSupport'] = tooltipSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'tooltipSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentLinkClientCapabilities');
      return false;
    }
  }

  static DocumentLinkClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final tooltipSupportJson = json['tooltipSupport'];
    final tooltipSupport = tooltipSupportJson as bool?;
    return DocumentLinkClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      tooltipSupport: tooltipSupport,
    );
  }
}

/// Provider options for a [DocumentLinkRequest].
class DocumentLinkOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentLinkOptions.canParse,
    DocumentLinkOptions.fromJson,
  );

  /// Document links have a resolve provider as well.
  final bool? resolveProvider;

  @override
  final bool? workDoneProgress;

  DocumentLinkOptions({
    this.resolveProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        resolveProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentLinkOptions &&
        other.runtimeType == DocumentLinkOptions &&
        resolveProvider == other.resolveProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentLinkOptions');
      return false;
    }
  }

  static DocumentLinkOptions fromJson(Map<String, Object?> json) {
    if (DocumentLinkRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return DocumentLinkRegistrationOptions.fromJson(json);
    }
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentLinkOptions(
      resolveProvider: resolveProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// The parameters of a [DocumentLinkRequest].
class DocumentLinkParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentLinkParams.canParse,
    DocumentLinkParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The document to provide document links for.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  DocumentLinkParams({
    this.partialResultToken,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentLinkParams &&
        other.runtimeType == DocumentLinkParams &&
        partialResultToken == other.partialResultToken &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentLinkParams');
      return false;
    }
  }

  static DocumentLinkParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return DocumentLinkParams(
      partialResultToken: partialResultToken,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [DocumentLinkRequest].
class DocumentLinkRegistrationOptions
    implements
        DocumentLinkOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentLinkRegistrationOptions.canParse,
    DocumentLinkRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// Document links have a resolve provider as well.
  @override
  final bool? resolveProvider;

  @override
  final bool? workDoneProgress;
  DocumentLinkRegistrationOptions({
    this.documentSelector,
    this.resolveProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        resolveProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentLinkRegistrationOptions &&
        other.runtimeType == DocumentLinkRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        resolveProvider == other.resolveProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentLinkRegistrationOptions');
      return false;
    }
  }

  static DocumentLinkRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentLinkRegistrationOptions(
      documentSelector: documentSelector,
      resolveProvider: resolveProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Client capabilities of a [DocumentOnTypeFormattingRequest].
class DocumentOnTypeFormattingClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentOnTypeFormattingClientCapabilities.canParse,
    DocumentOnTypeFormattingClientCapabilities.fromJson,
  );

  /// Whether on type formatting supports dynamic registration.
  final bool? dynamicRegistration;

  DocumentOnTypeFormattingClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DocumentOnTypeFormattingClientCapabilities &&
        other.runtimeType == DocumentOnTypeFormattingClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type DocumentOnTypeFormattingClientCapabilities');
      return false;
    }
  }

  static DocumentOnTypeFormattingClientCapabilities fromJson(
      Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return DocumentOnTypeFormattingClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// Provider options for a [DocumentOnTypeFormattingRequest].
class DocumentOnTypeFormattingOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentOnTypeFormattingOptions.canParse,
    DocumentOnTypeFormattingOptions.fromJson,
  );

  /// A character on which formatting should be triggered, like `{`.
  final String firstTriggerCharacter;

  /// More trigger characters.
  final List<String>? moreTriggerCharacter;

  DocumentOnTypeFormattingOptions({
    required this.firstTriggerCharacter,
    this.moreTriggerCharacter,
  });
  @override
  int get hashCode => Object.hash(
        firstTriggerCharacter,
        lspHashCode(moreTriggerCharacter),
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentOnTypeFormattingOptions &&
        other.runtimeType == DocumentOnTypeFormattingOptions &&
        firstTriggerCharacter == other.firstTriggerCharacter &&
        const DeepCollectionEquality()
            .equals(moreTriggerCharacter, other.moreTriggerCharacter);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['firstTriggerCharacter'] = firstTriggerCharacter;
    if (moreTriggerCharacter != null) {
      result['moreTriggerCharacter'] = moreTriggerCharacter;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'firstTriggerCharacter',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseListString(obj, reporter, 'moreTriggerCharacter',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentOnTypeFormattingOptions');
      return false;
    }
  }

  static DocumentOnTypeFormattingOptions fromJson(Map<String, Object?> json) {
    if (DocumentOnTypeFormattingRegistrationOptions.canParse(
        json, nullLspJsonReporter)) {
      return DocumentOnTypeFormattingRegistrationOptions.fromJson(json);
    }
    final firstTriggerCharacterJson = json['firstTriggerCharacter'];
    final firstTriggerCharacter = firstTriggerCharacterJson as String;
    final moreTriggerCharacterJson = json['moreTriggerCharacter'];
    final moreTriggerCharacter = (moreTriggerCharacterJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    return DocumentOnTypeFormattingOptions(
      firstTriggerCharacter: firstTriggerCharacter,
      moreTriggerCharacter: moreTriggerCharacter,
    );
  }
}

/// The parameters of a [DocumentOnTypeFormattingRequest].
class DocumentOnTypeFormattingParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentOnTypeFormattingParams.canParse,
    DocumentOnTypeFormattingParams.fromJson,
  );

  /// The character that has been typed that triggered the formatting on type
  /// request. That is not necessarily the last character that got inserted into
  /// the document since the client could auto insert characters as well (e.g.
  /// like automatic brace completion).
  final String ch;

  /// The formatting options.
  final FormattingOptions options;

  /// The position around which the on type formatting should happen. This is
  /// not necessarily the exact position where the character denoted by the
  /// property `ch` got typed.
  final Position position;

  /// The document to format.
  final TextDocumentIdentifier textDocument;
  DocumentOnTypeFormattingParams({
    required this.ch,
    required this.options,
    required this.position,
    required this.textDocument,
  });
  @override
  int get hashCode => Object.hash(
        ch,
        options,
        position,
        textDocument,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentOnTypeFormattingParams &&
        other.runtimeType == DocumentOnTypeFormattingParams &&
        ch == other.ch &&
        options == other.options &&
        position == other.position &&
        textDocument == other.textDocument;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['ch'] = ch;
    result['options'] = options.toJson();
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'ch',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseFormattingOptions(obj, reporter, 'options',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentOnTypeFormattingParams');
      return false;
    }
  }

  static DocumentOnTypeFormattingParams fromJson(Map<String, Object?> json) {
    final chJson = json['ch'];
    final ch = chJson as String;
    final optionsJson = json['options'];
    final options =
        FormattingOptions.fromJson(optionsJson as Map<String, Object?>);
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    return DocumentOnTypeFormattingParams(
      ch: ch,
      options: options,
      position: position,
      textDocument: textDocument,
    );
  }
}

/// Registration options for a [DocumentOnTypeFormattingRequest].
class DocumentOnTypeFormattingRegistrationOptions
    implements
        DocumentOnTypeFormattingOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentOnTypeFormattingRegistrationOptions.canParse,
    DocumentOnTypeFormattingRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// A character on which formatting should be triggered, like `{`.
  @override
  final String firstTriggerCharacter;

  /// More trigger characters.
  @override
  final List<String>? moreTriggerCharacter;
  DocumentOnTypeFormattingRegistrationOptions({
    this.documentSelector,
    required this.firstTriggerCharacter,
    this.moreTriggerCharacter,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        firstTriggerCharacter,
        lspHashCode(moreTriggerCharacter),
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentOnTypeFormattingRegistrationOptions &&
        other.runtimeType == DocumentOnTypeFormattingRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        firstTriggerCharacter == other.firstTriggerCharacter &&
        const DeepCollectionEquality()
            .equals(moreTriggerCharacter, other.moreTriggerCharacter);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    result['firstTriggerCharacter'] = firstTriggerCharacter;
    if (moreTriggerCharacter != null) {
      result['moreTriggerCharacter'] = moreTriggerCharacter;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'firstTriggerCharacter',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseListString(obj, reporter, 'moreTriggerCharacter',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type DocumentOnTypeFormattingRegistrationOptions');
      return false;
    }
  }

  static DocumentOnTypeFormattingRegistrationOptions fromJson(
      Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final firstTriggerCharacterJson = json['firstTriggerCharacter'];
    final firstTriggerCharacter = firstTriggerCharacterJson as String;
    final moreTriggerCharacterJson = json['moreTriggerCharacter'];
    final moreTriggerCharacter = (moreTriggerCharacterJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    return DocumentOnTypeFormattingRegistrationOptions(
      documentSelector: documentSelector,
      firstTriggerCharacter: firstTriggerCharacter,
      moreTriggerCharacter: moreTriggerCharacter,
    );
  }
}

/// Client capabilities of a [DocumentRangeFormattingRequest].
class DocumentRangeFormattingClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentRangeFormattingClientCapabilities.canParse,
    DocumentRangeFormattingClientCapabilities.fromJson,
  );

  /// Whether range formatting supports dynamic registration.
  final bool? dynamicRegistration;

  DocumentRangeFormattingClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DocumentRangeFormattingClientCapabilities &&
        other.runtimeType == DocumentRangeFormattingClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type DocumentRangeFormattingClientCapabilities');
      return false;
    }
  }

  static DocumentRangeFormattingClientCapabilities fromJson(
      Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return DocumentRangeFormattingClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// Provider options for a [DocumentRangeFormattingRequest].
class DocumentRangeFormattingOptions
    implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentRangeFormattingOptions.canParse,
    DocumentRangeFormattingOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  DocumentRangeFormattingOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is DocumentRangeFormattingOptions &&
        other.runtimeType == DocumentRangeFormattingOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentRangeFormattingOptions');
      return false;
    }
  }

  static DocumentRangeFormattingOptions fromJson(Map<String, Object?> json) {
    if (DocumentRangeFormattingRegistrationOptions.canParse(
        json, nullLspJsonReporter)) {
      return DocumentRangeFormattingRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentRangeFormattingOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// The parameters of a [DocumentRangeFormattingRequest].
class DocumentRangeFormattingParams
    implements WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentRangeFormattingParams.canParse,
    DocumentRangeFormattingParams.fromJson,
  );

  /// The format options
  final FormattingOptions options;

  /// The range to format
  final Range range;

  /// The document to format.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  DocumentRangeFormattingParams({
    required this.options,
    required this.range,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        options,
        range,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentRangeFormattingParams &&
        other.runtimeType == DocumentRangeFormattingParams &&
        options == other.options &&
        range == other.range &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['options'] = options.toJson();
    result['range'] = range.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseFormattingOptions(obj, reporter, 'options',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentRangeFormattingParams');
      return false;
    }
  }

  static DocumentRangeFormattingParams fromJson(Map<String, Object?> json) {
    final optionsJson = json['options'];
    final options =
        FormattingOptions.fromJson(optionsJson as Map<String, Object?>);
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return DocumentRangeFormattingParams(
      options: options,
      range: range,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [DocumentRangeFormattingRequest].
class DocumentRangeFormattingRegistrationOptions
    implements
        DocumentRangeFormattingOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentRangeFormattingRegistrationOptions.canParse,
    DocumentRangeFormattingRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  @override
  final bool? workDoneProgress;

  DocumentRangeFormattingRegistrationOptions({
    this.documentSelector,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentRangeFormattingRegistrationOptions &&
        other.runtimeType == DocumentRangeFormattingRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type DocumentRangeFormattingRegistrationOptions');
      return false;
    }
  }

  static DocumentRangeFormattingRegistrationOptions fromJson(
      Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentRangeFormattingRegistrationOptions(
      documentSelector: documentSelector,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Represents programming constructs like variables, classes, interfaces etc.
/// that appear in a document. Document symbols can be hierarchical and they
/// have two ranges: one that encloses its definition and one that points to its
/// most interesting range, e.g. the range of an identifier.
class DocumentSymbol implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentSymbol.canParse,
    DocumentSymbol.fromJson,
  );

  /// Children of this symbol, e.g. properties of a class.
  final List<DocumentSymbol>? children;

  /// Indicates if this symbol is deprecated.
  ///
  /// @deprecated Use tags instead
  final bool? deprecated;

  /// More detail for this symbol, e.g the signature of a function.
  final String? detail;

  /// The kind of this symbol.
  final SymbolKind kind;

  /// The name of this symbol. Will be displayed in the user interface and
  /// therefore must not be an empty string or a string only consisting of white
  /// spaces.
  final String name;

  /// The range enclosing this symbol not including leading/trailing whitespace
  /// but everything else like comments. This information is typically used to
  /// determine if the clients cursor is inside the symbol to reveal in the
  /// symbol in the UI.
  final Range range;

  /// The range that should be selected and revealed when this symbol is being
  /// picked, e.g the name of a function. Must be contained by the `range`.
  final Range selectionRange;

  /// Tags for this document symbol.
  ///
  /// @since 3.16.0
  final List<SymbolTag>? tags;
  DocumentSymbol({
    this.children,
    this.deprecated,
    this.detail,
    required this.kind,
    required this.name,
    required this.range,
    required this.selectionRange,
    this.tags,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(children),
        deprecated,
        detail,
        kind,
        name,
        range,
        selectionRange,
        lspHashCode(tags),
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentSymbol &&
        other.runtimeType == DocumentSymbol &&
        const DeepCollectionEquality().equals(children, other.children) &&
        deprecated == other.deprecated &&
        detail == other.detail &&
        kind == other.kind &&
        name == other.name &&
        range == other.range &&
        selectionRange == other.selectionRange &&
        const DeepCollectionEquality().equals(tags, other.tags);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (children != null) {
      result['children'] = children?.map((item) => item.toJson()).toList();
    }
    if (deprecated != null) {
      result['deprecated'] = deprecated;
    }
    if (detail != null) {
      result['detail'] = detail;
    }
    result['kind'] = kind.toJson();
    result['name'] = name;
    result['range'] = range.toJson();
    result['selectionRange'] = selectionRange.toJson();
    if (tags != null) {
      result['tags'] = tags?.map((item) => item.toJson()).toList();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListDocumentSymbol(obj, reporter, 'children',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'deprecated',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'detail',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseSymbolKind(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'name',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'selectionRange',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseListSymbolTag(obj, reporter, 'tags',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentSymbol');
      return false;
    }
  }

  static DocumentSymbol fromJson(Map<String, Object?> json) {
    final childrenJson = json['children'];
    final children = (childrenJson as List<Object?>?)
        ?.map((item) => DocumentSymbol.fromJson(item as Map<String, Object?>))
        .toList();
    final deprecatedJson = json['deprecated'];
    final deprecated = deprecatedJson as bool?;
    final detailJson = json['detail'];
    final detail = detailJson as String?;
    final kindJson = json['kind'];
    final kind = SymbolKind.fromJson(kindJson as int);
    final nameJson = json['name'];
    final name = nameJson as String;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final selectionRangeJson = json['selectionRange'];
    final selectionRange =
        Range.fromJson(selectionRangeJson as Map<String, Object?>);
    final tagsJson = json['tags'];
    final tags = (tagsJson as List<Object?>?)
        ?.map((item) => SymbolTag.fromJson(item as int))
        .toList();
    return DocumentSymbol(
      children: children,
      deprecated: deprecated,
      detail: detail,
      kind: kind,
      name: name,
      range: range,
      selectionRange: selectionRange,
      tags: tags,
    );
  }
}

/// Client Capabilities for a [DocumentSymbolRequest].
class DocumentSymbolClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentSymbolClientCapabilities.canParse,
    DocumentSymbolClientCapabilities.fromJson,
  );

  /// Whether document symbol supports dynamic registration.
  final bool? dynamicRegistration;

  /// The client supports hierarchical document symbols.
  final bool? hierarchicalDocumentSymbolSupport;

  /// The client supports an additional label presented in the UI when
  /// registering a document symbol provider.
  ///
  /// @since 3.16.0
  final bool? labelSupport;

  /// Specific capabilities for the `SymbolKind` in the
  /// `textDocument/documentSymbol` request.
  final DocumentSymbolClientCapabilitiesSymbolKind? symbolKind;

  /// The client supports tags on `SymbolInformation`. Tags are supported on
  /// `DocumentSymbol` if `hierarchicalDocumentSymbolSupport` is set to true.
  /// Clients supporting tags have to handle unknown tags gracefully.
  ///
  /// @since 3.16.0
  final DocumentSymbolClientCapabilitiesTagSupport? tagSupport;
  DocumentSymbolClientCapabilities({
    this.dynamicRegistration,
    this.hierarchicalDocumentSymbolSupport,
    this.labelSupport,
    this.symbolKind,
    this.tagSupport,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        hierarchicalDocumentSymbolSupport,
        labelSupport,
        symbolKind,
        tagSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentSymbolClientCapabilities &&
        other.runtimeType == DocumentSymbolClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        hierarchicalDocumentSymbolSupport ==
            other.hierarchicalDocumentSymbolSupport &&
        labelSupport == other.labelSupport &&
        symbolKind == other.symbolKind &&
        tagSupport == other.tagSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (hierarchicalDocumentSymbolSupport != null) {
      result['hierarchicalDocumentSymbolSupport'] =
          hierarchicalDocumentSymbolSupport;
    }
    if (labelSupport != null) {
      result['labelSupport'] = labelSupport;
    }
    if (symbolKind != null) {
      result['symbolKind'] = symbolKind?.toJson();
    }
    if (tagSupport != null) {
      result['tagSupport'] = tagSupport?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'hierarchicalDocumentSymbolSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'labelSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseDocumentSymbolClientCapabilitiesSymbolKind(
          obj, reporter, 'symbolKind',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseDocumentSymbolClientCapabilitiesTagSupport(
          obj, reporter, 'tagSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentSymbolClientCapabilities');
      return false;
    }
  }

  static DocumentSymbolClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final hierarchicalDocumentSymbolSupportJson =
        json['hierarchicalDocumentSymbolSupport'];
    final hierarchicalDocumentSymbolSupport =
        hierarchicalDocumentSymbolSupportJson as bool?;
    final labelSupportJson = json['labelSupport'];
    final labelSupport = labelSupportJson as bool?;
    final symbolKindJson = json['symbolKind'];
    final symbolKind = symbolKindJson != null
        ? DocumentSymbolClientCapabilitiesSymbolKind.fromJson(
            symbolKindJson as Map<String, Object?>)
        : null;
    final tagSupportJson = json['tagSupport'];
    final tagSupport = tagSupportJson != null
        ? DocumentSymbolClientCapabilitiesTagSupport.fromJson(
            tagSupportJson as Map<String, Object?>)
        : null;
    return DocumentSymbolClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      hierarchicalDocumentSymbolSupport: hierarchicalDocumentSymbolSupport,
      labelSupport: labelSupport,
      symbolKind: symbolKind,
      tagSupport: tagSupport,
    );
  }
}

class DocumentSymbolClientCapabilitiesSymbolKind implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentSymbolClientCapabilitiesSymbolKind.canParse,
    DocumentSymbolClientCapabilitiesSymbolKind.fromJson,
  );

  /// The symbol kind values the client supports. When this property exists the
  /// client also guarantees that it will handle values outside its set
  /// gracefully and falls back to a default value when unknown.
  ///
  /// If this property is not present the client only supports the symbol kinds
  /// from `File` to `Array` as defined in the initial version of the protocol.
  final List<SymbolKind>? valueSet;

  DocumentSymbolClientCapabilitiesSymbolKind({
    this.valueSet,
  });

  @override
  int get hashCode => lspHashCode(valueSet);

  @override
  bool operator ==(Object other) {
    return other is DocumentSymbolClientCapabilitiesSymbolKind &&
        other.runtimeType == DocumentSymbolClientCapabilitiesSymbolKind &&
        const DeepCollectionEquality().equals(valueSet, other.valueSet);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (valueSet != null) {
      result['valueSet'] = valueSet?.map((item) => item.toJson()).toList();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListSymbolKind(obj, reporter, 'valueSet',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type DocumentSymbolClientCapabilitiesSymbolKind');
      return false;
    }
  }

  static DocumentSymbolClientCapabilitiesSymbolKind fromJson(
      Map<String, Object?> json) {
    final valueSetJson = json['valueSet'];
    final valueSet = (valueSetJson as List<Object?>?)
        ?.map((item) => SymbolKind.fromJson(item as int))
        .toList();
    return DocumentSymbolClientCapabilitiesSymbolKind(
      valueSet: valueSet,
    );
  }
}

class DocumentSymbolClientCapabilitiesTagSupport implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentSymbolClientCapabilitiesTagSupport.canParse,
    DocumentSymbolClientCapabilitiesTagSupport.fromJson,
  );

  /// The tags supported by the client.
  final List<SymbolTag> valueSet;

  DocumentSymbolClientCapabilitiesTagSupport({
    required this.valueSet,
  });

  @override
  int get hashCode => lspHashCode(valueSet);

  @override
  bool operator ==(Object other) {
    return other is DocumentSymbolClientCapabilitiesTagSupport &&
        other.runtimeType == DocumentSymbolClientCapabilitiesTagSupport &&
        const DeepCollectionEquality().equals(valueSet, other.valueSet);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['valueSet'] = valueSet.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListSymbolTag(obj, reporter, 'valueSet',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type DocumentSymbolClientCapabilitiesTagSupport');
      return false;
    }
  }

  static DocumentSymbolClientCapabilitiesTagSupport fromJson(
      Map<String, Object?> json) {
    final valueSetJson = json['valueSet'];
    final valueSet = (valueSetJson as List<Object?>)
        .map((item) => SymbolTag.fromJson(item as int))
        .toList();
    return DocumentSymbolClientCapabilitiesTagSupport(
      valueSet: valueSet,
    );
  }
}

/// Provider options for a [DocumentSymbolRequest].
class DocumentSymbolOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentSymbolOptions.canParse,
    DocumentSymbolOptions.fromJson,
  );

  /// A human-readable string that is shown when multiple outlines trees are
  /// shown for the same document.
  ///
  /// @since 3.16.0
  final String? label;

  @override
  final bool? workDoneProgress;

  DocumentSymbolOptions({
    this.label,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        label,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentSymbolOptions &&
        other.runtimeType == DocumentSymbolOptions &&
        label == other.label &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (label != null) {
      result['label'] = label;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'label',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentSymbolOptions');
      return false;
    }
  }

  static DocumentSymbolOptions fromJson(Map<String, Object?> json) {
    if (DocumentSymbolRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return DocumentSymbolRegistrationOptions.fromJson(json);
    }
    final labelJson = json['label'];
    final label = labelJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentSymbolOptions(
      label: label,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Parameters for a [DocumentSymbolRequest].
class DocumentSymbolParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentSymbolParams.canParse,
    DocumentSymbolParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The text document.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  DocumentSymbolParams({
    this.partialResultToken,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentSymbolParams &&
        other.runtimeType == DocumentSymbolParams &&
        partialResultToken == other.partialResultToken &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentSymbolParams');
      return false;
    }
  }

  static DocumentSymbolParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return DocumentSymbolParams(
      partialResultToken: partialResultToken,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [DocumentSymbolRequest].
class DocumentSymbolRegistrationOptions
    implements
        DocumentSymbolOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    DocumentSymbolRegistrationOptions.canParse,
    DocumentSymbolRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// A human-readable string that is shown when multiple outlines trees are
  /// shown for the same document.
  ///
  /// @since 3.16.0
  @override
  final String? label;

  @override
  final bool? workDoneProgress;
  DocumentSymbolRegistrationOptions({
    this.documentSelector,
    this.label,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        label,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is DocumentSymbolRegistrationOptions &&
        other.runtimeType == DocumentSymbolRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        label == other.label &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (label != null) {
      result['label'] = label;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'label',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type DocumentSymbolRegistrationOptions');
      return false;
    }
  }

  static DocumentSymbolRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final labelJson = json['label'];
    final label = labelJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return DocumentSymbolRegistrationOptions(
      documentSelector: documentSelector,
      label: label,
      workDoneProgress: workDoneProgress,
    );
  }
}

class EditRangeWithInsertReplace implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    EditRangeWithInsertReplace.canParse,
    EditRangeWithInsertReplace.fromJson,
  );

  final Range insert;

  final Range replace;

  EditRangeWithInsertReplace({
    required this.insert,
    required this.replace,
  });
  @override
  int get hashCode => Object.hash(
        insert,
        replace,
      );

  @override
  bool operator ==(Object other) {
    return other is EditRangeWithInsertReplace &&
        other.runtimeType == EditRangeWithInsertReplace &&
        insert == other.insert &&
        replace == other.replace;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['insert'] = insert.toJson();
    result['replace'] = replace.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseRange(obj, reporter, 'insert',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'replace',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type EditRangeWithInsertReplace');
      return false;
    }
  }

  static EditRangeWithInsertReplace fromJson(Map<String, Object?> json) {
    final insertJson = json['insert'];
    final insert = Range.fromJson(insertJson as Map<String, Object?>);
    final replaceJson = json['replace'];
    final replace = Range.fromJson(replaceJson as Map<String, Object?>);
    return EditRangeWithInsertReplace(
      insert: insert,
      replace: replace,
    );
  }
}

/// Predefined error codes.
class ErrorCodes implements ToJsonable {
  /// The server detected that the content of a document got modified outside
  /// normal conditions. A server should NOT send this error code if it detects
  /// a content change in it unprocessed messages. The result even computed on
  /// an older state might still be useful for the client.
  ///
  /// If a client decides that a result is not of any use anymore the client
  /// should cancel the request.
  static const ContentModified = ErrorCodes(-32801);
  static const InternalError = ErrorCodes(-32603);

  static const InvalidParams = ErrorCodes(-32602);

  static const InvalidRequest = ErrorCodes(-32600);
  static const MethodNotFound = ErrorCodes(-32601);
  static const ParseError = ErrorCodes(-32700);

  /// The client has canceled a request and a server as detected the cancel.
  static const RequestCancelled = ErrorCodes(-32800);

  /// A request failed but it was syntactically correct, e.g the method name was
  /// known and the parameters were valid. The error message should contain
  /// human readable information about why the request failed.
  ///
  /// @since 3.17.0
  static const RequestFailed = ErrorCodes(-32803);

  /// The server cancelled the request. This error code should only be used for
  /// requests that explicitly support being server cancellable.
  ///
  /// @since 3.17.0
  static const ServerCancelled = ErrorCodes(-32802);

  /// Error code indicating that a server received a notification or request
  /// before the server has received the `initialize` request.
  static const ServerNotInitialized = ErrorCodes(-32002);
  static const UnknownErrorCode = ErrorCodes(-32001);
  final int _value;
  const ErrorCodes(this._value);
  const ErrorCodes.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is ErrorCodes && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// The client capabilities of a [ExecuteCommandRequest].
class ExecuteCommandClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ExecuteCommandClientCapabilities.canParse,
    ExecuteCommandClientCapabilities.fromJson,
  );

  /// Execute command supports dynamic registration.
  final bool? dynamicRegistration;

  ExecuteCommandClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is ExecuteCommandClientCapabilities &&
        other.runtimeType == ExecuteCommandClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ExecuteCommandClientCapabilities');
      return false;
    }
  }

  static ExecuteCommandClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return ExecuteCommandClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// The server capabilities of a [ExecuteCommandRequest].
class ExecuteCommandOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ExecuteCommandOptions.canParse,
    ExecuteCommandOptions.fromJson,
  );

  /// The commands to be executed on the server
  final List<String> commands;

  @override
  final bool? workDoneProgress;

  ExecuteCommandOptions({
    required this.commands,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(commands),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is ExecuteCommandOptions &&
        other.runtimeType == ExecuteCommandOptions &&
        const DeepCollectionEquality().equals(commands, other.commands) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['commands'] = commands;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListString(obj, reporter, 'commands',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ExecuteCommandOptions');
      return false;
    }
  }

  static ExecuteCommandOptions fromJson(Map<String, Object?> json) {
    if (ExecuteCommandRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return ExecuteCommandRegistrationOptions.fromJson(json);
    }
    final commandsJson = json['commands'];
    final commands =
        (commandsJson as List<Object?>).map((item) => item as String).toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return ExecuteCommandOptions(
      commands: commands,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// The parameters of a [ExecuteCommandRequest].
class ExecuteCommandParams implements WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ExecuteCommandParams.canParse,
    ExecuteCommandParams.fromJson,
  );

  /// Arguments that the command should be invoked with.
  final List<LSPAny>? arguments;

  /// The identifier of the actual command handler.
  final String command;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  ExecuteCommandParams({
    this.arguments,
    required this.command,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(arguments),
        command,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is ExecuteCommandParams &&
        other.runtimeType == ExecuteCommandParams &&
        const DeepCollectionEquality().equals(arguments, other.arguments) &&
        command == other.command &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (arguments != null) {
      result['arguments'] = arguments;
    }
    result['command'] = command;
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListObjectNullable(obj, reporter, 'arguments',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'command',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ExecuteCommandParams');
      return false;
    }
  }

  static ExecuteCommandParams fromJson(Map<String, Object?> json) {
    final argumentsJson = json['arguments'];
    final arguments =
        (argumentsJson as List<Object?>?)?.map((item) => item).toList();
    final commandJson = json['command'];
    final command = commandJson as String;
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return ExecuteCommandParams(
      arguments: arguments,
      command: command,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [ExecuteCommandRequest].
class ExecuteCommandRegistrationOptions
    implements ExecuteCommandOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ExecuteCommandRegistrationOptions.canParse,
    ExecuteCommandRegistrationOptions.fromJson,
  );

  /// The commands to be executed on the server
  @override
  final List<String> commands;

  @override
  final bool? workDoneProgress;

  ExecuteCommandRegistrationOptions({
    required this.commands,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(commands),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is ExecuteCommandRegistrationOptions &&
        other.runtimeType == ExecuteCommandRegistrationOptions &&
        const DeepCollectionEquality().equals(commands, other.commands) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['commands'] = commands;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListString(obj, reporter, 'commands',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ExecuteCommandRegistrationOptions');
      return false;
    }
  }

  static ExecuteCommandRegistrationOptions fromJson(Map<String, Object?> json) {
    final commandsJson = json['commands'];
    final commands =
        (commandsJson as List<Object?>).map((item) => item as String).toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return ExecuteCommandRegistrationOptions(
      commands: commands,
      workDoneProgress: workDoneProgress,
    );
  }
}

class ExecutionSummary implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ExecutionSummary.canParse,
    ExecutionSummary.fromJson,
  );

  /// A strict monotonically increasing value indicating the execution order of
  /// a cell inside a notebook.
  final int executionOrder;

  /// Whether the execution was successful or not if known by the client.
  final bool? success;

  ExecutionSummary({
    required this.executionOrder,
    this.success,
  });
  @override
  int get hashCode => Object.hash(
        executionOrder,
        success,
      );

  @override
  bool operator ==(Object other) {
    return other is ExecutionSummary &&
        other.runtimeType == ExecutionSummary &&
        executionOrder == other.executionOrder &&
        success == other.success;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['executionOrder'] = executionOrder;
    if (success != null) {
      result['success'] = success;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseInt(obj, reporter, 'executionOrder',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'success',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ExecutionSummary');
      return false;
    }
  }

  static ExecutionSummary fromJson(Map<String, Object?> json) {
    final executionOrderJson = json['executionOrder'];
    final executionOrder = executionOrderJson as int;
    final successJson = json['success'];
    final success = successJson as bool?;
    return ExecutionSummary(
      executionOrder: executionOrder,
      success: success,
    );
  }
}

class FailureHandlingKind implements ToJsonable {
  /// Applying the workspace change is simply aborted if one of the changes
  /// provided fails. All operations executed before the failing operation stay
  /// executed.
  static const Abort = FailureHandlingKind._('abort');

  /// If the workspace edit contains only textual file changes they are executed
  /// transactional. If resource changes (create, rename or delete file) are
  /// part of the change the failure handling strategy is abort.
  static const TextOnlyTransactional =
      FailureHandlingKind._('textOnlyTransactional');

  /// All operations are executed transactional. That means they either all
  /// succeed or no changes at all are applied to the workspace.
  static const Transactional = FailureHandlingKind._('transactional');

  /// The client tries to undo the operations already executed. But there is no
  /// guarantee that this is succeeding.
  static const Undo = FailureHandlingKind._('undo');
  final String _value;
  const FailureHandlingKind.fromJson(this._value);
  const FailureHandlingKind._(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is FailureHandlingKind && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    switch (obj) {
      case 'abort':
      case 'textOnlyTransactional':
      case 'transactional':
      case 'undo':
        return true;
    }
    return false;
  }
}

/// The file event type
class FileChangeType implements ToJsonable {
  /// The file got changed.
  static const Changed = FileChangeType(2);

  /// The file got created.
  static const Created = FileChangeType(1);

  /// The file got deleted.
  static const Deleted = FileChangeType(3);

  final int _value;
  const FileChangeType(this._value);
  const FileChangeType.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is FileChangeType && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// Represents information on a file/folder create.
///
/// @since 3.16.0
class FileCreate implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileCreate.canParse,
    FileCreate.fromJson,
  );

  /// A file:// URI for the location of the file/folder being created.
  final String uri;

  FileCreate({
    required this.uri,
  });

  @override
  int get hashCode => uri.hashCode;

  @override
  bool operator ==(Object other) {
    return other is FileCreate &&
        other.runtimeType == FileCreate &&
        uri == other.uri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['uri'] = uri;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseString(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileCreate');
      return false;
    }
  }

  static FileCreate fromJson(Map<String, Object?> json) {
    final uriJson = json['uri'];
    final uri = uriJson as String;
    return FileCreate(
      uri: uri,
    );
  }
}

/// Represents information on a file/folder delete.
///
/// @since 3.16.0
class FileDelete implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileDelete.canParse,
    FileDelete.fromJson,
  );

  /// A file:// URI for the location of the file/folder being deleted.
  final String uri;

  FileDelete({
    required this.uri,
  });

  @override
  int get hashCode => uri.hashCode;

  @override
  bool operator ==(Object other) {
    return other is FileDelete &&
        other.runtimeType == FileDelete &&
        uri == other.uri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['uri'] = uri;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseString(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileDelete');
      return false;
    }
  }

  static FileDelete fromJson(Map<String, Object?> json) {
    final uriJson = json['uri'];
    final uri = uriJson as String;
    return FileDelete(
      uri: uri,
    );
  }
}

/// An event describing a file change.
class FileEvent implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileEvent.canParse,
    FileEvent.fromJson,
  );

  /// The change type.
  final FileChangeType type;

  /// The file's uri.
  final DocumentUri uri;

  FileEvent({
    required this.type,
    required this.uri,
  });
  @override
  int get hashCode => Object.hash(
        type,
        uri,
      );

  @override
  bool operator ==(Object other) {
    return other is FileEvent &&
        other.runtimeType == FileEvent &&
        type == other.type &&
        uri == other.uri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['type'] = type.toJson();
    result['uri'] = uri.toString();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseFileChangeType(obj, reporter, 'type',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileEvent');
      return false;
    }
  }

  static FileEvent fromJson(Map<String, Object?> json) {
    final typeJson = json['type'];
    final type = FileChangeType.fromJson(typeJson as int);
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    return FileEvent(
      type: type,
      uri: uri,
    );
  }
}

/// Capabilities relating to events from file operations by the user in the
/// client.
///
/// These events do not come from the file system, they come from user
/// operations like renaming a file in the UI.
///
/// @since 3.16.0
class FileOperationClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileOperationClientCapabilities.canParse,
    FileOperationClientCapabilities.fromJson,
  );

  /// The client has support for sending didCreateFiles notifications.
  final bool? didCreate;

  /// The client has support for sending didDeleteFiles notifications.
  final bool? didDelete;

  /// The client has support for sending didRenameFiles notifications.
  final bool? didRename;

  /// Whether the client supports dynamic registration for file
  /// requests/notifications.
  final bool? dynamicRegistration;

  /// The client has support for sending willCreateFiles requests.
  final bool? willCreate;

  /// The client has support for sending willDeleteFiles requests.
  final bool? willDelete;

  /// The client has support for sending willRenameFiles requests.
  final bool? willRename;
  FileOperationClientCapabilities({
    this.didCreate,
    this.didDelete,
    this.didRename,
    this.dynamicRegistration,
    this.willCreate,
    this.willDelete,
    this.willRename,
  });
  @override
  int get hashCode => Object.hash(
        didCreate,
        didDelete,
        didRename,
        dynamicRegistration,
        willCreate,
        willDelete,
        willRename,
      );

  @override
  bool operator ==(Object other) {
    return other is FileOperationClientCapabilities &&
        other.runtimeType == FileOperationClientCapabilities &&
        didCreate == other.didCreate &&
        didDelete == other.didDelete &&
        didRename == other.didRename &&
        dynamicRegistration == other.dynamicRegistration &&
        willCreate == other.willCreate &&
        willDelete == other.willDelete &&
        willRename == other.willRename;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (didCreate != null) {
      result['didCreate'] = didCreate;
    }
    if (didDelete != null) {
      result['didDelete'] = didDelete;
    }
    if (didRename != null) {
      result['didRename'] = didRename;
    }
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (willCreate != null) {
      result['willCreate'] = willCreate;
    }
    if (willDelete != null) {
      result['willDelete'] = willDelete;
    }
    if (willRename != null) {
      result['willRename'] = willRename;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'didCreate',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'didDelete',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'didRename',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'willCreate',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'willDelete',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'willRename',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileOperationClientCapabilities');
      return false;
    }
  }

  static FileOperationClientCapabilities fromJson(Map<String, Object?> json) {
    final didCreateJson = json['didCreate'];
    final didCreate = didCreateJson as bool?;
    final didDeleteJson = json['didDelete'];
    final didDelete = didDeleteJson as bool?;
    final didRenameJson = json['didRename'];
    final didRename = didRenameJson as bool?;
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final willCreateJson = json['willCreate'];
    final willCreate = willCreateJson as bool?;
    final willDeleteJson = json['willDelete'];
    final willDelete = willDeleteJson as bool?;
    final willRenameJson = json['willRename'];
    final willRename = willRenameJson as bool?;
    return FileOperationClientCapabilities(
      didCreate: didCreate,
      didDelete: didDelete,
      didRename: didRename,
      dynamicRegistration: dynamicRegistration,
      willCreate: willCreate,
      willDelete: willDelete,
      willRename: willRename,
    );
  }
}

/// A filter to describe in which file operation requests or notifications the
/// server is interested in receiving.
///
/// @since 3.16.0
class FileOperationFilter implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileOperationFilter.canParse,
    FileOperationFilter.fromJson,
  );

  /// The actual file operation pattern.
  final FileOperationPattern pattern;

  /// A Uri scheme like `file` or `untitled`.
  final String? scheme;

  FileOperationFilter({
    required this.pattern,
    this.scheme,
  });
  @override
  int get hashCode => Object.hash(
        pattern,
        scheme,
      );

  @override
  bool operator ==(Object other) {
    return other is FileOperationFilter &&
        other.runtimeType == FileOperationFilter &&
        pattern == other.pattern &&
        scheme == other.scheme;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['pattern'] = pattern.toJson();
    if (scheme != null) {
      result['scheme'] = scheme;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseFileOperationPattern(obj, reporter, 'pattern',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'scheme',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileOperationFilter');
      return false;
    }
  }

  static FileOperationFilter fromJson(Map<String, Object?> json) {
    final patternJson = json['pattern'];
    final pattern =
        FileOperationPattern.fromJson(patternJson as Map<String, Object?>);
    final schemeJson = json['scheme'];
    final scheme = schemeJson as String?;
    return FileOperationFilter(
      pattern: pattern,
      scheme: scheme,
    );
  }
}

/// Options for notifications/requests for user operations on files.
///
/// @since 3.16.0
class FileOperationOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileOperationOptions.canParse,
    FileOperationOptions.fromJson,
  );

  /// The server is interested in receiving didCreateFiles notifications.
  final FileOperationRegistrationOptions? didCreate;

  /// The server is interested in receiving didDeleteFiles file notifications.
  final FileOperationRegistrationOptions? didDelete;

  /// The server is interested in receiving didRenameFiles notifications.
  final FileOperationRegistrationOptions? didRename;

  /// The server is interested in receiving willCreateFiles requests.
  final FileOperationRegistrationOptions? willCreate;

  /// The server is interested in receiving willDeleteFiles file requests.
  final FileOperationRegistrationOptions? willDelete;

  /// The server is interested in receiving willRenameFiles requests.
  final FileOperationRegistrationOptions? willRename;
  FileOperationOptions({
    this.didCreate,
    this.didDelete,
    this.didRename,
    this.willCreate,
    this.willDelete,
    this.willRename,
  });
  @override
  int get hashCode => Object.hash(
        didCreate,
        didDelete,
        didRename,
        willCreate,
        willDelete,
        willRename,
      );

  @override
  bool operator ==(Object other) {
    return other is FileOperationOptions &&
        other.runtimeType == FileOperationOptions &&
        didCreate == other.didCreate &&
        didDelete == other.didDelete &&
        didRename == other.didRename &&
        willCreate == other.willCreate &&
        willDelete == other.willDelete &&
        willRename == other.willRename;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (didCreate != null) {
      result['didCreate'] = didCreate?.toJson();
    }
    if (didDelete != null) {
      result['didDelete'] = didDelete?.toJson();
    }
    if (didRename != null) {
      result['didRename'] = didRename?.toJson();
    }
    if (willCreate != null) {
      result['willCreate'] = willCreate?.toJson();
    }
    if (willDelete != null) {
      result['willDelete'] = willDelete?.toJson();
    }
    if (willRename != null) {
      result['willRename'] = willRename?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseFileOperationRegistrationOptions(obj, reporter, 'didCreate',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseFileOperationRegistrationOptions(obj, reporter, 'didDelete',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseFileOperationRegistrationOptions(obj, reporter, 'didRename',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseFileOperationRegistrationOptions(
          obj, reporter, 'willCreate',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseFileOperationRegistrationOptions(
          obj, reporter, 'willDelete',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseFileOperationRegistrationOptions(
          obj, reporter, 'willRename',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileOperationOptions');
      return false;
    }
  }

  static FileOperationOptions fromJson(Map<String, Object?> json) {
    final didCreateJson = json['didCreate'];
    final didCreate = didCreateJson != null
        ? FileOperationRegistrationOptions.fromJson(
            didCreateJson as Map<String, Object?>)
        : null;
    final didDeleteJson = json['didDelete'];
    final didDelete = didDeleteJson != null
        ? FileOperationRegistrationOptions.fromJson(
            didDeleteJson as Map<String, Object?>)
        : null;
    final didRenameJson = json['didRename'];
    final didRename = didRenameJson != null
        ? FileOperationRegistrationOptions.fromJson(
            didRenameJson as Map<String, Object?>)
        : null;
    final willCreateJson = json['willCreate'];
    final willCreate = willCreateJson != null
        ? FileOperationRegistrationOptions.fromJson(
            willCreateJson as Map<String, Object?>)
        : null;
    final willDeleteJson = json['willDelete'];
    final willDelete = willDeleteJson != null
        ? FileOperationRegistrationOptions.fromJson(
            willDeleteJson as Map<String, Object?>)
        : null;
    final willRenameJson = json['willRename'];
    final willRename = willRenameJson != null
        ? FileOperationRegistrationOptions.fromJson(
            willRenameJson as Map<String, Object?>)
        : null;
    return FileOperationOptions(
      didCreate: didCreate,
      didDelete: didDelete,
      didRename: didRename,
      willCreate: willCreate,
      willDelete: willDelete,
      willRename: willRename,
    );
  }
}

/// A pattern to describe in which file operation requests or notifications the
/// server is interested in receiving.
///
/// @since 3.16.0
class FileOperationPattern implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileOperationPattern.canParse,
    FileOperationPattern.fromJson,
  );

  /// The glob pattern to match. Glob patterns can have the following syntax:
  /// - `*` to match one or more characters in a path segment
  /// - `?` to match on one character in a path segment
  /// - `**` to match any number of path segments, including none
  /// - `{}` to group sub patterns into an OR expression. (e.g. `**​/*.{ts,js}`
  /// matches all TypeScript and JavaScript files)
  /// - `[]` to declare a range of characters to match in a path segment (e.g.,
  /// `example.[0-9]` to match on `example.0`, `example.1`, …)
  /// - `[!...]` to negate a range of characters to match in a path segment
  /// (e.g., `example.[!0-9]` to match on `example.a`, `example.b`, but not
  /// `example.0`)
  final String glob;

  /// Whether to match files or folders with this pattern.
  ///
  /// Matches both if undefined.
  final FileOperationPatternKind? matches;

  /// Additional options used during matching.
  final FileOperationPatternOptions? options;
  FileOperationPattern({
    required this.glob,
    this.matches,
    this.options,
  });
  @override
  int get hashCode => Object.hash(
        glob,
        matches,
        options,
      );

  @override
  bool operator ==(Object other) {
    return other is FileOperationPattern &&
        other.runtimeType == FileOperationPattern &&
        glob == other.glob &&
        matches == other.matches &&
        options == other.options;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['glob'] = glob;
    if (matches != null) {
      result['matches'] = matches?.toJson();
    }
    if (options != null) {
      result['options'] = options?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'glob',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseFileOperationPatternKind(obj, reporter, 'matches',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseFileOperationPatternOptions(obj, reporter, 'options',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileOperationPattern');
      return false;
    }
  }

  static FileOperationPattern fromJson(Map<String, Object?> json) {
    final globJson = json['glob'];
    final glob = globJson as String;
    final matchesJson = json['matches'];
    final matches = matchesJson != null
        ? FileOperationPatternKind.fromJson(matchesJson as String)
        : null;
    final optionsJson = json['options'];
    final options = optionsJson != null
        ? FileOperationPatternOptions.fromJson(
            optionsJson as Map<String, Object?>)
        : null;
    return FileOperationPattern(
      glob: glob,
      matches: matches,
      options: options,
    );
  }
}

/// A pattern kind describing if a glob pattern matches a file a folder or both.
///
/// @since 3.16.0
class FileOperationPatternKind implements ToJsonable {
  /// The pattern matches a file only.
  static const file = FileOperationPatternKind('file');

  /// The pattern matches a folder only.
  static const folder = FileOperationPatternKind('folder');

  final String _value;

  const FileOperationPatternKind(this._value);
  const FileOperationPatternKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is FileOperationPatternKind && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is String;
}

/// Matching options for the file operation pattern.
///
/// @since 3.16.0
class FileOperationPatternOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileOperationPatternOptions.canParse,
    FileOperationPatternOptions.fromJson,
  );

  /// The pattern should be matched ignoring casing.
  final bool? ignoreCase;

  FileOperationPatternOptions({
    this.ignoreCase,
  });

  @override
  int get hashCode => ignoreCase.hashCode;

  @override
  bool operator ==(Object other) {
    return other is FileOperationPatternOptions &&
        other.runtimeType == FileOperationPatternOptions &&
        ignoreCase == other.ignoreCase;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (ignoreCase != null) {
      result['ignoreCase'] = ignoreCase;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'ignoreCase',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileOperationPatternOptions');
      return false;
    }
  }

  static FileOperationPatternOptions fromJson(Map<String, Object?> json) {
    final ignoreCaseJson = json['ignoreCase'];
    final ignoreCase = ignoreCaseJson as bool?;
    return FileOperationPatternOptions(
      ignoreCase: ignoreCase,
    );
  }
}

/// The options to register for file operations.
///
/// @since 3.16.0
class FileOperationRegistrationOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileOperationRegistrationOptions.canParse,
    FileOperationRegistrationOptions.fromJson,
  );

  /// The actual filters.
  final List<FileOperationFilter> filters;

  FileOperationRegistrationOptions({
    required this.filters,
  });

  @override
  int get hashCode => lspHashCode(filters);

  @override
  bool operator ==(Object other) {
    return other is FileOperationRegistrationOptions &&
        other.runtimeType == FileOperationRegistrationOptions &&
        const DeepCollectionEquality().equals(filters, other.filters);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['filters'] = filters.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListFileOperationFilter(obj, reporter, 'filters',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileOperationRegistrationOptions');
      return false;
    }
  }

  static FileOperationRegistrationOptions fromJson(Map<String, Object?> json) {
    final filtersJson = json['filters'];
    final filters = (filtersJson as List<Object?>)
        .map((item) =>
            FileOperationFilter.fromJson(item as Map<String, Object?>))
        .toList();
    return FileOperationRegistrationOptions(
      filters: filters,
    );
  }
}

/// Represents information on a file/folder rename.
///
/// @since 3.16.0
class FileRename implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileRename.canParse,
    FileRename.fromJson,
  );

  /// A file:// URI for the new location of the file/folder being renamed.
  final String newUri;

  /// A file:// URI for the original location of the file/folder being renamed.
  final String oldUri;

  FileRename({
    required this.newUri,
    required this.oldUri,
  });
  @override
  int get hashCode => Object.hash(
        newUri,
        oldUri,
      );

  @override
  bool operator ==(Object other) {
    return other is FileRename &&
        other.runtimeType == FileRename &&
        newUri == other.newUri &&
        oldUri == other.oldUri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['newUri'] = newUri;
    result['oldUri'] = oldUri;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'newUri',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'oldUri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileRename');
      return false;
    }
  }

  static FileRename fromJson(Map<String, Object?> json) {
    final newUriJson = json['newUri'];
    final newUri = newUriJson as String;
    final oldUriJson = json['oldUri'];
    final oldUri = oldUriJson as String;
    return FileRename(
      newUri: newUri,
      oldUri: oldUri,
    );
  }
}

class FileSystemWatcher implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FileSystemWatcher.canParse,
    FileSystemWatcher.fromJson,
  );

  /// The glob pattern to watch. See [GlobPattern] for more detail.
  ///
  /// @since 3.17.0 support for relative patterns.
  final GlobPattern globPattern;

  /// The kind of events of interest. If omitted it defaults to WatchKind.Create
  /// | WatchKind.Change | WatchKind.Delete which is 7.
  final WatchKind? kind;

  FileSystemWatcher({
    required this.globPattern,
    this.kind,
  });
  @override
  int get hashCode => Object.hash(
        globPattern,
        kind,
      );

  @override
  bool operator ==(Object other) {
    return other is FileSystemWatcher &&
        other.runtimeType == FileSystemWatcher &&
        globPattern == other.globPattern &&
        kind == other.kind;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['globPattern'] = globPattern;
    if (kind != null) {
      result['kind'] = kind?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseStringRelativePattern(obj, reporter, 'globPattern',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseWatchKind(obj, reporter, 'kind',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FileSystemWatcher');
      return false;
    }
  }

  static FileSystemWatcher fromJson(Map<String, Object?> json) {
    final globPatternJson = json['globPattern'];
    final globPattern = _eitherStringRelativePattern(globPatternJson);
    final kindJson = json['kind'];
    final kind = kindJson != null ? WatchKind.fromJson(kindJson as int) : null;
    return FileSystemWatcher(
      globPattern: globPattern,
      kind: kind,
    );
  }
}

/// Represents a folding range. To be valid, start and end line must be bigger
/// than zero and smaller than the number of lines in the document. Clients are
/// free to ignore invalid ranges.
class FoldingRange implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FoldingRange.canParse,
    FoldingRange.fromJson,
  );

  /// The text that the client should show when the specified range is
  /// collapsed. If not defined or not supported by the client, a default will
  /// be chosen by the client.
  ///
  /// @since 3.17.0
  final String? collapsedText;

  /// The zero-based character offset before the folded range ends. If not
  /// defined, defaults to the length of the end line.
  final int? endCharacter;

  /// The zero-based end line of the range to fold. The folded area ends with
  /// the line's last character. To be valid, the end must be zero or larger and
  /// smaller than the number of lines in the document.
  final int endLine;

  /// Describes the kind of the folding range such as 'comment' or 'region'. The
  /// kind is used to categorize folding ranges and used by commands like 'Fold
  /// all comments'.
  /// See [FoldingRangeKind] for an enumeration of standardized kinds.
  final FoldingRangeKind? kind;

  /// The zero-based character offset from where the folded range starts. If not
  /// defined, defaults to the length of the start line.
  final int? startCharacter;

  /// The zero-based start line of the range to fold. The folded area starts
  /// after the line's last character. To be valid, the end must be zero or
  /// larger and smaller than the number of lines in the document.
  final int startLine;
  FoldingRange({
    this.collapsedText,
    this.endCharacter,
    required this.endLine,
    this.kind,
    this.startCharacter,
    required this.startLine,
  });
  @override
  int get hashCode => Object.hash(
        collapsedText,
        endCharacter,
        endLine,
        kind,
        startCharacter,
        startLine,
      );

  @override
  bool operator ==(Object other) {
    return other is FoldingRange &&
        other.runtimeType == FoldingRange &&
        collapsedText == other.collapsedText &&
        endCharacter == other.endCharacter &&
        endLine == other.endLine &&
        kind == other.kind &&
        startCharacter == other.startCharacter &&
        startLine == other.startLine;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (collapsedText != null) {
      result['collapsedText'] = collapsedText;
    }
    if (endCharacter != null) {
      result['endCharacter'] = endCharacter;
    }
    result['endLine'] = endLine;
    if (kind != null) {
      result['kind'] = kind?.toJson();
    }
    if (startCharacter != null) {
      result['startCharacter'] = startCharacter;
    }
    result['startLine'] = startLine;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'collapsedText',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseInt(obj, reporter, 'endCharacter',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseInt(obj, reporter, 'endLine',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseFoldingRangeKind(obj, reporter, 'kind',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseInt(obj, reporter, 'startCharacter',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseInt(obj, reporter, 'startLine',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type FoldingRange');
      return false;
    }
  }

  static FoldingRange fromJson(Map<String, Object?> json) {
    final collapsedTextJson = json['collapsedText'];
    final collapsedText = collapsedTextJson as String?;
    final endCharacterJson = json['endCharacter'];
    final endCharacter = endCharacterJson as int?;
    final endLineJson = json['endLine'];
    final endLine = endLineJson as int;
    final kindJson = json['kind'];
    final kind =
        kindJson != null ? FoldingRangeKind.fromJson(kindJson as String) : null;
    final startCharacterJson = json['startCharacter'];
    final startCharacter = startCharacterJson as int?;
    final startLineJson = json['startLine'];
    final startLine = startLineJson as int;
    return FoldingRange(
      collapsedText: collapsedText,
      endCharacter: endCharacter,
      endLine: endLine,
      kind: kind,
      startCharacter: startCharacter,
      startLine: startLine,
    );
  }
}

class FoldingRangeClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FoldingRangeClientCapabilities.canParse,
    FoldingRangeClientCapabilities.fromJson,
  );

  /// Whether implementation supports dynamic registration for folding range
  /// providers. If this is set to `true` the client supports the new
  /// `FoldingRangeRegistrationOptions` return value for the corresponding
  /// server capability as well.
  final bool? dynamicRegistration;

  /// Specific options for the folding range.
  ///
  /// @since 3.17.0
  final FoldingRangeClientCapabilitiesFoldingRange? foldingRange;

  /// Specific options for the folding range kind.
  ///
  /// @since 3.17.0
  final FoldingRangeClientCapabilitiesFoldingRangeKind? foldingRangeKind;

  /// If set, the client signals that it only supports folding complete lines.
  /// If set, client will ignore specified `startCharacter` and `endCharacter`
  /// properties in a FoldingRange.
  final bool? lineFoldingOnly;

  /// The maximum number of folding ranges that the client prefers to receive
  /// per document. The value serves as a hint, servers are free to follow the
  /// limit.
  final int? rangeLimit;
  FoldingRangeClientCapabilities({
    this.dynamicRegistration,
    this.foldingRange,
    this.foldingRangeKind,
    this.lineFoldingOnly,
    this.rangeLimit,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        foldingRange,
        foldingRangeKind,
        lineFoldingOnly,
        rangeLimit,
      );

  @override
  bool operator ==(Object other) {
    return other is FoldingRangeClientCapabilities &&
        other.runtimeType == FoldingRangeClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        foldingRange == other.foldingRange &&
        foldingRangeKind == other.foldingRangeKind &&
        lineFoldingOnly == other.lineFoldingOnly &&
        rangeLimit == other.rangeLimit;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (foldingRange != null) {
      result['foldingRange'] = foldingRange?.toJson();
    }
    if (foldingRangeKind != null) {
      result['foldingRangeKind'] = foldingRangeKind?.toJson();
    }
    if (lineFoldingOnly != null) {
      result['lineFoldingOnly'] = lineFoldingOnly;
    }
    if (rangeLimit != null) {
      result['rangeLimit'] = rangeLimit;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseFoldingRangeClientCapabilitiesFoldingRange(
          obj, reporter, 'foldingRange',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseFoldingRangeClientCapabilitiesFoldingRangeKind(
          obj, reporter, 'foldingRangeKind',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'lineFoldingOnly',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseInt(obj, reporter, 'rangeLimit',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FoldingRangeClientCapabilities');
      return false;
    }
  }

  static FoldingRangeClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final foldingRangeJson = json['foldingRange'];
    final foldingRange = foldingRangeJson != null
        ? FoldingRangeClientCapabilitiesFoldingRange.fromJson(
            foldingRangeJson as Map<String, Object?>)
        : null;
    final foldingRangeKindJson = json['foldingRangeKind'];
    final foldingRangeKind = foldingRangeKindJson != null
        ? FoldingRangeClientCapabilitiesFoldingRangeKind.fromJson(
            foldingRangeKindJson as Map<String, Object?>)
        : null;
    final lineFoldingOnlyJson = json['lineFoldingOnly'];
    final lineFoldingOnly = lineFoldingOnlyJson as bool?;
    final rangeLimitJson = json['rangeLimit'];
    final rangeLimit = rangeLimitJson as int?;
    return FoldingRangeClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      foldingRange: foldingRange,
      foldingRangeKind: foldingRangeKind,
      lineFoldingOnly: lineFoldingOnly,
      rangeLimit: rangeLimit,
    );
  }
}

class FoldingRangeClientCapabilitiesFoldingRange implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FoldingRangeClientCapabilitiesFoldingRange.canParse,
    FoldingRangeClientCapabilitiesFoldingRange.fromJson,
  );

  /// If set, the client signals that it supports setting collapsedText on
  /// folding ranges to display custom labels instead of the default text.
  ///
  /// @since 3.17.0
  final bool? collapsedText;

  FoldingRangeClientCapabilitiesFoldingRange({
    this.collapsedText,
  });

  @override
  int get hashCode => collapsedText.hashCode;

  @override
  bool operator ==(Object other) {
    return other is FoldingRangeClientCapabilitiesFoldingRange &&
        other.runtimeType == FoldingRangeClientCapabilitiesFoldingRange &&
        collapsedText == other.collapsedText;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (collapsedText != null) {
      result['collapsedText'] = collapsedText;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'collapsedText',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type FoldingRangeClientCapabilitiesFoldingRange');
      return false;
    }
  }

  static FoldingRangeClientCapabilitiesFoldingRange fromJson(
      Map<String, Object?> json) {
    final collapsedTextJson = json['collapsedText'];
    final collapsedText = collapsedTextJson as bool?;
    return FoldingRangeClientCapabilitiesFoldingRange(
      collapsedText: collapsedText,
    );
  }
}

class FoldingRangeClientCapabilitiesFoldingRangeKind implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FoldingRangeClientCapabilitiesFoldingRangeKind.canParse,
    FoldingRangeClientCapabilitiesFoldingRangeKind.fromJson,
  );

  /// The folding range kind values the client supports. When this property
  /// exists the client also guarantees that it will handle values outside its
  /// set gracefully and falls back to a default value when unknown.
  final List<FoldingRangeKind>? valueSet;

  FoldingRangeClientCapabilitiesFoldingRangeKind({
    this.valueSet,
  });

  @override
  int get hashCode => lspHashCode(valueSet);

  @override
  bool operator ==(Object other) {
    return other is FoldingRangeClientCapabilitiesFoldingRangeKind &&
        other.runtimeType == FoldingRangeClientCapabilitiesFoldingRangeKind &&
        const DeepCollectionEquality().equals(valueSet, other.valueSet);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (valueSet != null) {
      result['valueSet'] = valueSet?.map((item) => item.toJson()).toList();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListFoldingRangeKind(obj, reporter, 'valueSet',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type FoldingRangeClientCapabilitiesFoldingRangeKind');
      return false;
    }
  }

  static FoldingRangeClientCapabilitiesFoldingRangeKind fromJson(
      Map<String, Object?> json) {
    final valueSetJson = json['valueSet'];
    final valueSet = (valueSetJson as List<Object?>?)
        ?.map((item) => FoldingRangeKind.fromJson(item as String))
        .toList();
    return FoldingRangeClientCapabilitiesFoldingRangeKind(
      valueSet: valueSet,
    );
  }
}

/// A set of predefined range kinds.
class FoldingRangeKind implements ToJsonable {
  /// Folding range for a comment
  static const Comment = FoldingRangeKind('comment');

  /// Folding range for an import or include
  static const Imports = FoldingRangeKind('imports');

  /// Folding range for a region (e.g. `#region`)
  static const Region = FoldingRangeKind('region');

  final String _value;
  const FoldingRangeKind(this._value);
  const FoldingRangeKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is FoldingRangeKind && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is String;
}

class FoldingRangeOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FoldingRangeOptions.canParse,
    FoldingRangeOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  FoldingRangeOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is FoldingRangeOptions &&
        other.runtimeType == FoldingRangeOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FoldingRangeOptions');
      return false;
    }
  }

  static FoldingRangeOptions fromJson(Map<String, Object?> json) {
    if (FoldingRangeRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return FoldingRangeRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return FoldingRangeOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Parameters for a [FoldingRangeRequest].
class FoldingRangeParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FoldingRangeParams.canParse,
    FoldingRangeParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The text document.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  FoldingRangeParams({
    this.partialResultToken,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is FoldingRangeParams &&
        other.runtimeType == FoldingRangeParams &&
        partialResultToken == other.partialResultToken &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FoldingRangeParams');
      return false;
    }
  }

  static FoldingRangeParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return FoldingRangeParams(
      partialResultToken: partialResultToken,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

class FoldingRangeRegistrationOptions
    implements
        FoldingRangeOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FoldingRangeRegistrationOptions.canParse,
    FoldingRangeRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  @override
  final bool? workDoneProgress;
  FoldingRangeRegistrationOptions({
    this.documentSelector,
    this.id,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is FoldingRangeRegistrationOptions &&
        other.runtimeType == FoldingRangeRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FoldingRangeRegistrationOptions');
      return false;
    }
  }

  static FoldingRangeRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return FoldingRangeRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Value-object describing what options formatting should use.
class FormattingOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FormattingOptions.canParse,
    FormattingOptions.fromJson,
  );

  /// Insert a newline character at the end of the file if one does not exist.
  ///
  /// @since 3.15.0
  final bool? insertFinalNewline;

  /// Prefer spaces over tabs.
  final bool insertSpaces;

  /// Size of a tab in spaces.
  final int tabSize;

  /// Trim all newlines after the final newline at the end of the file.
  ///
  /// @since 3.15.0
  final bool? trimFinalNewlines;

  /// Trim trailing whitespace on a line.
  ///
  /// @since 3.15.0
  final bool? trimTrailingWhitespace;
  FormattingOptions({
    this.insertFinalNewline,
    required this.insertSpaces,
    required this.tabSize,
    this.trimFinalNewlines,
    this.trimTrailingWhitespace,
  });
  @override
  int get hashCode => Object.hash(
        insertFinalNewline,
        insertSpaces,
        tabSize,
        trimFinalNewlines,
        trimTrailingWhitespace,
      );

  @override
  bool operator ==(Object other) {
    return other is FormattingOptions &&
        other.runtimeType == FormattingOptions &&
        insertFinalNewline == other.insertFinalNewline &&
        insertSpaces == other.insertSpaces &&
        tabSize == other.tabSize &&
        trimFinalNewlines == other.trimFinalNewlines &&
        trimTrailingWhitespace == other.trimTrailingWhitespace;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (insertFinalNewline != null) {
      result['insertFinalNewline'] = insertFinalNewline;
    }
    result['insertSpaces'] = insertSpaces;
    result['tabSize'] = tabSize;
    if (trimFinalNewlines != null) {
      result['trimFinalNewlines'] = trimFinalNewlines;
    }
    if (trimTrailingWhitespace != null) {
      result['trimTrailingWhitespace'] = trimTrailingWhitespace;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'insertFinalNewline',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'insertSpaces',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseInt(obj, reporter, 'tabSize',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'trimFinalNewlines',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'trimTrailingWhitespace',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FormattingOptions');
      return false;
    }
  }

  static FormattingOptions fromJson(Map<String, Object?> json) {
    final insertFinalNewlineJson = json['insertFinalNewline'];
    final insertFinalNewline = insertFinalNewlineJson as bool?;
    final insertSpacesJson = json['insertSpaces'];
    final insertSpaces = insertSpacesJson as bool;
    final tabSizeJson = json['tabSize'];
    final tabSize = tabSizeJson as int;
    final trimFinalNewlinesJson = json['trimFinalNewlines'];
    final trimFinalNewlines = trimFinalNewlinesJson as bool?;
    final trimTrailingWhitespaceJson = json['trimTrailingWhitespace'];
    final trimTrailingWhitespace = trimTrailingWhitespaceJson as bool?;
    return FormattingOptions(
      insertFinalNewline: insertFinalNewline,
      insertSpaces: insertSpaces,
      tabSize: tabSize,
      trimFinalNewlines: trimFinalNewlines,
      trimTrailingWhitespace: trimTrailingWhitespace,
    );
  }
}

/// A diagnostic report with a full set of problems.
///
/// @since 3.17.0
class FullDocumentDiagnosticReport implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    FullDocumentDiagnosticReport.canParse,
    FullDocumentDiagnosticReport.fromJson,
  );

  /// The actual items.
  final List<Diagnostic> items;

  /// A full document diagnostic report.
  final String kind;

  /// An optional result id. If provided it will be sent on the next diagnostic
  /// request for the same document.
  final String? resultId;
  FullDocumentDiagnosticReport({
    required this.items,
    this.kind = 'full',
    this.resultId,
  }) {
    if (kind != 'full') {
      throw 'kind may only be the literal \'full\'';
    }
  }
  @override
  int get hashCode => Object.hash(
        lspHashCode(items),
        kind,
        resultId,
      );

  @override
  bool operator ==(Object other) {
    return other is FullDocumentDiagnosticReport &&
        other.runtimeType == FullDocumentDiagnosticReport &&
        const DeepCollectionEquality().equals(items, other.items) &&
        kind == other.kind &&
        resultId == other.resultId;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['items'] = items.map((item) => item.toJson()).toList();
    result['kind'] = kind;
    if (resultId != null) {
      result['resultId'] = resultId;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListDiagnostic(obj, reporter, 'items',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseLiteral(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false, literal: 'full')) {
        return false;
      }
      return _canParseString(obj, reporter, 'resultId',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type FullDocumentDiagnosticReport');
      return false;
    }
  }

  static FullDocumentDiagnosticReport fromJson(Map<String, Object?> json) {
    if (WorkspaceFullDocumentDiagnosticReport.canParse(
        json, nullLspJsonReporter)) {
      return WorkspaceFullDocumentDiagnosticReport.fromJson(json);
    }
    if (RelatedFullDocumentDiagnosticReport.canParse(
        json, nullLspJsonReporter)) {
      return RelatedFullDocumentDiagnosticReport.fromJson(json);
    }
    final itemsJson = json['items'];
    final items = (itemsJson as List<Object?>)
        .map((item) => Diagnostic.fromJson(item as Map<String, Object?>))
        .toList();
    final kindJson = json['kind'];
    final kind = kindJson as String;
    final resultIdJson = json['resultId'];
    final resultId = resultIdJson as String?;
    return FullDocumentDiagnosticReport(
      items: items,
      kind: kind,
      resultId: resultId,
    );
  }
}

/// General client capabilities.
///
/// @since 3.16.0
class GeneralClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    GeneralClientCapabilities.canParse,
    GeneralClientCapabilities.fromJson,
  );

  /// Client capabilities specific to the client's markdown parser.
  ///
  /// @since 3.16.0
  final MarkdownClientCapabilities? markdown;

  /// The position encodings supported by the client. Client and server have to
  /// agree on the same position encoding to ensure that offsets (e.g. character
  /// position in a line) are interpreted the same on both sides.
  ///
  /// To keep the protocol backwards compatible the following applies: if the
  /// value 'utf-16' is missing from the array of position encodings servers can
  /// assume that the client supports UTF-16. UTF-16 is therefore a mandatory
  /// encoding.
  ///
  /// If omitted it defaults to ['utf-16'].
  ///
  /// Implementation considerations: since the conversion from one encoding into
  /// another requires the content of the file / line the conversion is best
  /// done where the file is read which is usually on the server side.
  ///
  /// @since 3.17.0
  final List<PositionEncodingKind>? positionEncodings;

  /// Client capabilities specific to regular expressions.
  ///
  /// @since 3.16.0
  final RegularExpressionsClientCapabilities? regularExpressions;

  /// Client capability that signals how the client handles stale requests (e.g.
  /// a request for which the client will not process the response anymore since
  /// the information is outdated).
  ///
  /// @since 3.17.0
  final GeneralClientCapabilitiesStaleRequestSupport? staleRequestSupport;
  GeneralClientCapabilities({
    this.markdown,
    this.positionEncodings,
    this.regularExpressions,
    this.staleRequestSupport,
  });
  @override
  int get hashCode => Object.hash(
        markdown,
        lspHashCode(positionEncodings),
        regularExpressions,
        staleRequestSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is GeneralClientCapabilities &&
        other.runtimeType == GeneralClientCapabilities &&
        markdown == other.markdown &&
        const DeepCollectionEquality()
            .equals(positionEncodings, other.positionEncodings) &&
        regularExpressions == other.regularExpressions &&
        staleRequestSupport == other.staleRequestSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (markdown != null) {
      result['markdown'] = markdown?.toJson();
    }
    if (positionEncodings != null) {
      result['positionEncodings'] =
          positionEncodings?.map((item) => item.toJson()).toList();
    }
    if (regularExpressions != null) {
      result['regularExpressions'] = regularExpressions?.toJson();
    }
    if (staleRequestSupport != null) {
      result['staleRequestSupport'] = staleRequestSupport?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseMarkdownClientCapabilities(obj, reporter, 'markdown',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListPositionEncodingKind(obj, reporter, 'positionEncodings',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseRegularExpressionsClientCapabilities(
          obj, reporter, 'regularExpressions',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseGeneralClientCapabilitiesStaleRequestSupport(
          obj, reporter, 'staleRequestSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type GeneralClientCapabilities');
      return false;
    }
  }

  static GeneralClientCapabilities fromJson(Map<String, Object?> json) {
    final markdownJson = json['markdown'];
    final markdown = markdownJson != null
        ? MarkdownClientCapabilities.fromJson(
            markdownJson as Map<String, Object?>)
        : null;
    final positionEncodingsJson = json['positionEncodings'];
    final positionEncodings = (positionEncodingsJson as List<Object?>?)
        ?.map((item) => PositionEncodingKind.fromJson(item as String))
        .toList();
    final regularExpressionsJson = json['regularExpressions'];
    final regularExpressions = regularExpressionsJson != null
        ? RegularExpressionsClientCapabilities.fromJson(
            regularExpressionsJson as Map<String, Object?>)
        : null;
    final staleRequestSupportJson = json['staleRequestSupport'];
    final staleRequestSupport = staleRequestSupportJson != null
        ? GeneralClientCapabilitiesStaleRequestSupport.fromJson(
            staleRequestSupportJson as Map<String, Object?>)
        : null;
    return GeneralClientCapabilities(
      markdown: markdown,
      positionEncodings: positionEncodings,
      regularExpressions: regularExpressions,
      staleRequestSupport: staleRequestSupport,
    );
  }
}

class GeneralClientCapabilitiesStaleRequestSupport implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    GeneralClientCapabilitiesStaleRequestSupport.canParse,
    GeneralClientCapabilitiesStaleRequestSupport.fromJson,
  );

  /// The client will actively cancel the request.
  final bool cancel;

  /// The list of requests for which the client will retry the request if it
  /// receives a response with error code `ContentModified`
  final List<String> retryOnContentModified;

  GeneralClientCapabilitiesStaleRequestSupport({
    required this.cancel,
    required this.retryOnContentModified,
  });
  @override
  int get hashCode => Object.hash(
        cancel,
        lspHashCode(retryOnContentModified),
      );

  @override
  bool operator ==(Object other) {
    return other is GeneralClientCapabilitiesStaleRequestSupport &&
        other.runtimeType == GeneralClientCapabilitiesStaleRequestSupport &&
        cancel == other.cancel &&
        const DeepCollectionEquality()
            .equals(retryOnContentModified, other.retryOnContentModified);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['cancel'] = cancel;
    result['retryOnContentModified'] = retryOnContentModified;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'cancel',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseListString(obj, reporter, 'retryOnContentModified',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type GeneralClientCapabilitiesStaleRequestSupport');
      return false;
    }
  }

  static GeneralClientCapabilitiesStaleRequestSupport fromJson(
      Map<String, Object?> json) {
    final cancelJson = json['cancel'];
    final cancel = cancelJson as bool;
    final retryOnContentModifiedJson = json['retryOnContentModified'];
    final retryOnContentModified = (retryOnContentModifiedJson as List<Object?>)
        .map((item) => item as String)
        .toList();
    return GeneralClientCapabilitiesStaleRequestSupport(
      cancel: cancel,
      retryOnContentModified: retryOnContentModified,
    );
  }
}

/// The result of a hover request.
class Hover implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    Hover.canParse,
    Hover.fromJson,
  );

  /// The hover's content
  final Either2<MarkupContent, String> contents;

  /// An optional range inside the text document that is used to visualize the
  /// hover, e.g. by changing the background color.
  final Range? range;

  Hover({
    required this.contents,
    this.range,
  });
  @override
  int get hashCode => Object.hash(
        contents,
        range,
      );

  @override
  bool operator ==(Object other) {
    return other is Hover &&
        other.runtimeType == Hover &&
        contents == other.contents &&
        range == other.range;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['contents'] = contents;
    if (range != null) {
      result['range'] = range?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseMarkupContentString(obj, reporter, 'contents',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'range',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type Hover');
      return false;
    }
  }

  static Hover fromJson(Map<String, Object?> json) {
    final contentsJson = json['contents'];
    final contents = _eitherMarkupContentString(contentsJson);
    final rangeJson = json['range'];
    final range = rangeJson != null
        ? Range.fromJson(rangeJson as Map<String, Object?>)
        : null;
    return Hover(
      contents: contents,
      range: range,
    );
  }
}

class HoverClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    HoverClientCapabilities.canParse,
    HoverClientCapabilities.fromJson,
  );

  /// Client supports the following content formats for the content property.
  /// The order describes the preferred format of the client.
  final List<MarkupKind>? contentFormat;

  /// Whether hover supports dynamic registration.
  final bool? dynamicRegistration;

  HoverClientCapabilities({
    this.contentFormat,
    this.dynamicRegistration,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(contentFormat),
        dynamicRegistration,
      );

  @override
  bool operator ==(Object other) {
    return other is HoverClientCapabilities &&
        other.runtimeType == HoverClientCapabilities &&
        const DeepCollectionEquality()
            .equals(contentFormat, other.contentFormat) &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (contentFormat != null) {
      result['contentFormat'] =
          contentFormat?.map((item) => item.toJson()).toList();
    }
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListMarkupKind(obj, reporter, 'contentFormat',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type HoverClientCapabilities');
      return false;
    }
  }

  static HoverClientCapabilities fromJson(Map<String, Object?> json) {
    final contentFormatJson = json['contentFormat'];
    final contentFormat = (contentFormatJson as List<Object?>?)
        ?.map((item) => MarkupKind.fromJson(item as String))
        .toList();
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return HoverClientCapabilities(
      contentFormat: contentFormat,
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// Hover options.
class HoverOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    HoverOptions.canParse,
    HoverOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  HoverOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is HoverOptions &&
        other.runtimeType == HoverOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type HoverOptions');
      return false;
    }
  }

  static HoverOptions fromJson(Map<String, Object?> json) {
    if (HoverRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return HoverRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return HoverOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Parameters for a [HoverRequest].
class HoverParams
    implements TextDocumentPositionParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    HoverParams.canParse,
    HoverParams.fromJson,
  );

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  HoverParams({
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is HoverParams &&
        other.runtimeType == HoverParams &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type HoverParams');
      return false;
    }
  }

  static HoverParams fromJson(Map<String, Object?> json) {
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return HoverParams(
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [HoverRequest].
class HoverRegistrationOptions
    implements HoverOptions, TextDocumentRegistrationOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    HoverRegistrationOptions.canParse,
    HoverRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  @override
  final bool? workDoneProgress;

  HoverRegistrationOptions({
    this.documentSelector,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is HoverRegistrationOptions &&
        other.runtimeType == HoverRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type HoverRegistrationOptions');
      return false;
    }
  }

  static HoverRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return HoverRegistrationOptions(
      documentSelector: documentSelector,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// @since 3.6.0
class ImplementationClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ImplementationClientCapabilities.canParse,
    ImplementationClientCapabilities.fromJson,
  );

  /// Whether implementation supports dynamic registration. If this is set to
  /// `true` the client supports the new `ImplementationRegistrationOptions`
  /// return value for the corresponding server capability as well.
  final bool? dynamicRegistration;

  /// The client supports additional metadata in the form of definition links.
  ///
  /// @since 3.14.0
  final bool? linkSupport;

  ImplementationClientCapabilities({
    this.dynamicRegistration,
    this.linkSupport,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        linkSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is ImplementationClientCapabilities &&
        other.runtimeType == ImplementationClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        linkSupport == other.linkSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (linkSupport != null) {
      result['linkSupport'] = linkSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'linkSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ImplementationClientCapabilities');
      return false;
    }
  }

  static ImplementationClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final linkSupportJson = json['linkSupport'];
    final linkSupport = linkSupportJson as bool?;
    return ImplementationClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      linkSupport: linkSupport,
    );
  }
}

class ImplementationOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ImplementationOptions.canParse,
    ImplementationOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  ImplementationOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is ImplementationOptions &&
        other.runtimeType == ImplementationOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ImplementationOptions');
      return false;
    }
  }

  static ImplementationOptions fromJson(Map<String, Object?> json) {
    if (ImplementationRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return ImplementationRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return ImplementationOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

class ImplementationParams
    implements
        PartialResultParams,
        TextDocumentPositionParams,
        WorkDoneProgressParams,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ImplementationParams.canParse,
    ImplementationParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  ImplementationParams({
    this.partialResultToken,
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is ImplementationParams &&
        other.runtimeType == ImplementationParams &&
        partialResultToken == other.partialResultToken &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ImplementationParams');
      return false;
    }
  }

  static ImplementationParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return ImplementationParams(
      partialResultToken: partialResultToken,
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

class ImplementationRegistrationOptions
    implements
        ImplementationOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ImplementationRegistrationOptions.canParse,
    ImplementationRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  @override
  final bool? workDoneProgress;
  ImplementationRegistrationOptions({
    this.documentSelector,
    this.id,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is ImplementationRegistrationOptions &&
        other.runtimeType == ImplementationRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ImplementationRegistrationOptions');
      return false;
    }
  }

  static ImplementationRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return ImplementationRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      workDoneProgress: workDoneProgress,
    );
  }
}

class InitializedParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InitializedParams.canParse,
    InitializedParams.fromJson,
  );

  @override
  int get hashCode => 42;

  @override
  bool operator ==(Object other) {
    return other is InitializedParams && other.runtimeType == InitializedParams;
  }

  @override
  Map<String, Object?> toJson() => {};

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return true;
    } else {
      reporter.reportError('must be of type InitializedParams');
      return false;
    }
  }

  static InitializedParams fromJson(Map<String, Object?> json) {
    return InitializedParams();
  }
}

/// The initialize parameters
class InitializeParams implements WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InitializeParams.canParse,
    InitializeParams.fromJson,
  );

  /// The capabilities provided by the client (editor or tool)
  final ClientCapabilities capabilities;

  /// Information about the client
  ///
  /// @since 3.15.0
  final ClientInfo? clientInfo;

  /// User provided initialization options.
  final LSPAny initializationOptions;

  /// The locale the client is currently showing the user interface in. This
  /// must not necessarily be the locale of the operating system.
  ///
  /// Uses IETF language tags as the value's syntax (See
  /// https://en.wikipedia.org/wiki/IETF_language_tag)
  ///
  /// @since 3.16.0
  final String? locale;

  /// The process Id of the parent process that started the server.
  ///
  /// Is `null` if the process has not been started by another process. If the
  /// parent process is not alive then the server should exit.
  final int? processId;

  /// The rootPath of the workspace. Is null if no folder is open.
  ///
  /// @deprecated in favour of rootUri.
  final String? rootPath;

  /// The rootUri of the workspace. Is null if no folder is open. If both
  /// `rootPath` and `rootUri` are set `rootUri` wins.
  ///
  /// @deprecated in favour of workspaceFolders.
  final DocumentUri? rootUri;

  /// The initial trace setting. If omitted trace is disabled ('off').
  final TraceValue? trace;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;

  /// The workspace folders configured in the client when the server starts.
  ///
  /// This property is only available if the client supports workspace folders.
  /// It can be `null` if the client supports workspace folders but none are
  /// configured.
  ///
  /// @since 3.6.0
  final List<WorkspaceFolder>? workspaceFolders;
  InitializeParams({
    required this.capabilities,
    this.clientInfo,
    this.initializationOptions,
    this.locale,
    this.processId,
    this.rootPath,
    this.rootUri,
    this.trace,
    this.workDoneToken,
    this.workspaceFolders,
  });
  @override
  int get hashCode => Object.hash(
        capabilities,
        clientInfo,
        initializationOptions,
        locale,
        processId,
        rootPath,
        rootUri,
        trace,
        workDoneToken,
        lspHashCode(workspaceFolders),
      );

  @override
  bool operator ==(Object other) {
    return other is InitializeParams &&
        other.runtimeType == InitializeParams &&
        capabilities == other.capabilities &&
        clientInfo == other.clientInfo &&
        initializationOptions == other.initializationOptions &&
        locale == other.locale &&
        processId == other.processId &&
        rootPath == other.rootPath &&
        rootUri == other.rootUri &&
        trace == other.trace &&
        workDoneToken == other.workDoneToken &&
        const DeepCollectionEquality()
            .equals(workspaceFolders, other.workspaceFolders);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['capabilities'] = capabilities.toJson();
    if (clientInfo != null) {
      result['clientInfo'] = clientInfo?.toJson();
    }
    if (initializationOptions != null) {
      result['initializationOptions'] = initializationOptions;
    }
    if (locale != null) {
      result['locale'] = locale;
    }
    result['processId'] = processId;
    if (rootPath != null) {
      result['rootPath'] = rootPath;
    }
    result['rootUri'] = rootUri?.toString();
    if (trace != null) {
      result['trace'] = trace?.toJson();
    }
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    if (workspaceFolders != null) {
      result['workspaceFolders'] =
          workspaceFolders?.map((item) => item.toJson()).toList();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseClientCapabilities(obj, reporter, 'capabilities',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseClientInfo(obj, reporter, 'clientInfo',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'locale',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseInt(obj, reporter, 'processId',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'rootPath',
          allowsUndefined: true, allowsNull: true)) {
        return false;
      }
      if (!_canParseUri(obj, reporter, 'rootUri',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseTraceValue(obj, reporter, 'trace',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseListWorkspaceFolder(obj, reporter, 'workspaceFolders',
          allowsUndefined: true, allowsNull: true);
    } else {
      reporter.reportError('must be of type InitializeParams');
      return false;
    }
  }

  static InitializeParams fromJson(Map<String, Object?> json) {
    final capabilitiesJson = json['capabilities'];
    final capabilities =
        ClientCapabilities.fromJson(capabilitiesJson as Map<String, Object?>);
    final clientInfoJson = json['clientInfo'];
    final clientInfo = clientInfoJson != null
        ? ClientInfo.fromJson(clientInfoJson as Map<String, Object?>)
        : null;
    final initializationOptionsJson = json['initializationOptions'];
    final initializationOptions = initializationOptionsJson;
    final localeJson = json['locale'];
    final locale = localeJson as String?;
    final processIdJson = json['processId'];
    final processId = processIdJson as int?;
    final rootPathJson = json['rootPath'];
    final rootPath = rootPathJson as String?;
    final rootUriJson = json['rootUri'];
    final rootUri =
        rootUriJson != null ? Uri.parse(rootUriJson as String) : null;
    final traceJson = json['trace'];
    final trace =
        traceJson != null ? TraceValue.fromJson(traceJson as String) : null;
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    final workspaceFoldersJson = json['workspaceFolders'];
    final workspaceFolders = (workspaceFoldersJson as List<Object?>?)
        ?.map((item) => WorkspaceFolder.fromJson(item as Map<String, Object?>))
        .toList();
    return InitializeParams(
      capabilities: capabilities,
      clientInfo: clientInfo,
      initializationOptions: initializationOptions,
      locale: locale,
      processId: processId,
      rootPath: rootPath,
      rootUri: rootUri,
      trace: trace,
      workDoneToken: workDoneToken,
      workspaceFolders: workspaceFolders,
    );
  }
}

/// The result returned from an initialize request.
class InitializeResult implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InitializeResult.canParse,
    InitializeResult.fromJson,
  );

  /// The capabilities the language server provides.
  final ServerCapabilities capabilities;

  /// Information about the server.
  ///
  /// @since 3.15.0
  final ServerInfo? serverInfo;

  InitializeResult({
    required this.capabilities,
    this.serverInfo,
  });
  @override
  int get hashCode => Object.hash(
        capabilities,
        serverInfo,
      );

  @override
  bool operator ==(Object other) {
    return other is InitializeResult &&
        other.runtimeType == InitializeResult &&
        capabilities == other.capabilities &&
        serverInfo == other.serverInfo;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['capabilities'] = capabilities.toJson();
    if (serverInfo != null) {
      result['serverInfo'] = serverInfo?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseServerCapabilities(obj, reporter, 'capabilities',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseServerInfo(obj, reporter, 'serverInfo',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InitializeResult');
      return false;
    }
  }

  static InitializeResult fromJson(Map<String, Object?> json) {
    final capabilitiesJson = json['capabilities'];
    final capabilities =
        ServerCapabilities.fromJson(capabilitiesJson as Map<String, Object?>);
    final serverInfoJson = json['serverInfo'];
    final serverInfo = serverInfoJson != null
        ? ServerInfo.fromJson(serverInfoJson as Map<String, Object?>)
        : null;
    return InitializeResult(
      capabilities: capabilities,
      serverInfo: serverInfo,
    );
  }
}

/// Inlay hint information.
///
/// @since 3.17.0
class InlayHint implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlayHint.canParse,
    InlayHint.fromJson,
  );

  /// A data entry field that is preserved on an inlay hint between a
  /// `textDocument/inlayHint` and a `inlayHint/resolve` request.
  final LSPAny data;

  /// The kind of this hint. Can be omitted in which case the client should fall
  /// back to a reasonable default.
  final InlayHintKind? kind;

  /// The label of this hint. A human readable string or an array of
  /// InlayHintLabelPart label parts.
  ///
  /// *Note* that neither the string nor the label part can be empty.
  final Either2<List<InlayHintLabelPart>, String> label;

  /// Render padding before the hint.
  ///
  /// Note: Padding should use the editor's background color, not the background
  /// color of the hint itself. That means padding can be used to visually
  /// align/separate an inlay hint.
  final bool? paddingLeft;

  /// Render padding after the hint.
  ///
  /// Note: Padding should use the editor's background color, not the background
  /// color of the hint itself. That means padding can be used to visually
  /// align/separate an inlay hint.
  final bool? paddingRight;

  /// The position of this hint.
  final Position position;

  /// Optional text edits that are performed when accepting this inlay hint.
  ///
  /// *Note* that edits are expected to change the document so that the inlay
  /// hint (or its nearest variant) is now part of the document and the inlay
  /// hint itself is now obsolete.
  final List<TextEdit>? textEdits;

  /// The tooltip text when you hover over this item.
  final Either2<MarkupContent, String>? tooltip;
  InlayHint({
    this.data,
    this.kind,
    required this.label,
    this.paddingLeft,
    this.paddingRight,
    required this.position,
    this.textEdits,
    this.tooltip,
  });
  @override
  int get hashCode => Object.hash(
        data,
        kind,
        label,
        paddingLeft,
        paddingRight,
        position,
        lspHashCode(textEdits),
        tooltip,
      );

  @override
  bool operator ==(Object other) {
    return other is InlayHint &&
        other.runtimeType == InlayHint &&
        data == other.data &&
        kind == other.kind &&
        label == other.label &&
        paddingLeft == other.paddingLeft &&
        paddingRight == other.paddingRight &&
        position == other.position &&
        const DeepCollectionEquality().equals(textEdits, other.textEdits) &&
        tooltip == other.tooltip;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (data != null) {
      result['data'] = data;
    }
    if (kind != null) {
      result['kind'] = kind?.toJson();
    }
    result['label'] = label;
    if (paddingLeft != null) {
      result['paddingLeft'] = paddingLeft;
    }
    if (paddingRight != null) {
      result['paddingRight'] = paddingRight;
    }
    result['position'] = position.toJson();
    if (textEdits != null) {
      result['textEdits'] = textEdits?.map((item) => item.toJson()).toList();
    }
    if (tooltip != null) {
      result['tooltip'] = tooltip;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseInlayHintKind(obj, reporter, 'kind',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListInlayHintLabelPartString(obj, reporter, 'label',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'paddingLeft',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'paddingRight',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseListTextEdit(obj, reporter, 'textEdits',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseMarkupContentString(obj, reporter, 'tooltip',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlayHint');
      return false;
    }
  }

  static InlayHint fromJson(Map<String, Object?> json) {
    final dataJson = json['data'];
    final data = dataJson;
    final kindJson = json['kind'];
    final kind =
        kindJson != null ? InlayHintKind.fromJson(kindJson as int) : null;
    final labelJson = json['label'];
    final label = _eitherListInlayHintLabelPartString(labelJson);
    final paddingLeftJson = json['paddingLeft'];
    final paddingLeft = paddingLeftJson as bool?;
    final paddingRightJson = json['paddingRight'];
    final paddingRight = paddingRightJson as bool?;
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textEditsJson = json['textEdits'];
    final textEdits = (textEditsJson as List<Object?>?)
        ?.map((item) => TextEdit.fromJson(item as Map<String, Object?>))
        .toList();
    final tooltipJson = json['tooltip'];
    final tooltip =
        tooltipJson == null ? null : _eitherMarkupContentString(tooltipJson);
    return InlayHint(
      data: data,
      kind: kind,
      label: label,
      paddingLeft: paddingLeft,
      paddingRight: paddingRight,
      position: position,
      textEdits: textEdits,
      tooltip: tooltip,
    );
  }
}

/// Inlay hint client capabilities.
///
/// @since 3.17.0
class InlayHintClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlayHintClientCapabilities.canParse,
    InlayHintClientCapabilities.fromJson,
  );

  /// Whether inlay hints support dynamic registration.
  final bool? dynamicRegistration;

  /// Indicates which properties a client can resolve lazily on an inlay hint.
  final InlayHintClientCapabilitiesResolveSupport? resolveSupport;

  InlayHintClientCapabilities({
    this.dynamicRegistration,
    this.resolveSupport,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        resolveSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is InlayHintClientCapabilities &&
        other.runtimeType == InlayHintClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        resolveSupport == other.resolveSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (resolveSupport != null) {
      result['resolveSupport'] = resolveSupport?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseInlayHintClientCapabilitiesResolveSupport(
          obj, reporter, 'resolveSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlayHintClientCapabilities');
      return false;
    }
  }

  static InlayHintClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final resolveSupportJson = json['resolveSupport'];
    final resolveSupport = resolveSupportJson != null
        ? InlayHintClientCapabilitiesResolveSupport.fromJson(
            resolveSupportJson as Map<String, Object?>)
        : null;
    return InlayHintClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      resolveSupport: resolveSupport,
    );
  }
}

class InlayHintClientCapabilitiesResolveSupport implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlayHintClientCapabilitiesResolveSupport.canParse,
    InlayHintClientCapabilitiesResolveSupport.fromJson,
  );

  /// The properties that a client can resolve lazily.
  final List<String> properties;

  InlayHintClientCapabilitiesResolveSupport({
    required this.properties,
  });

  @override
  int get hashCode => lspHashCode(properties);

  @override
  bool operator ==(Object other) {
    return other is InlayHintClientCapabilitiesResolveSupport &&
        other.runtimeType == InlayHintClientCapabilitiesResolveSupport &&
        const DeepCollectionEquality().equals(properties, other.properties);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['properties'] = properties;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListString(obj, reporter, 'properties',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type InlayHintClientCapabilitiesResolveSupport');
      return false;
    }
  }

  static InlayHintClientCapabilitiesResolveSupport fromJson(
      Map<String, Object?> json) {
    final propertiesJson = json['properties'];
    final properties = (propertiesJson as List<Object?>)
        .map((item) => item as String)
        .toList();
    return InlayHintClientCapabilitiesResolveSupport(
      properties: properties,
    );
  }
}

/// Inlay hint kinds.
///
/// @since 3.17.0
class InlayHintKind implements ToJsonable {
  /// An inlay hint that is for a parameter.
  static const Parameter = InlayHintKind(2);

  /// An inlay hint that for a type annotation.
  static const Type = InlayHintKind(1);

  final int _value;

  const InlayHintKind(this._value);
  const InlayHintKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is InlayHintKind && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// An inlay hint label part allows for interactive and composite labels of
/// inlay hints.
///
/// @since 3.17.0
class InlayHintLabelPart implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlayHintLabelPart.canParse,
    InlayHintLabelPart.fromJson,
  );

  /// An optional command for this label part.
  ///
  /// Depending on the client capability `inlayHint.resolveSupport` clients
  /// might resolve this property late using the resolve request.
  final Command? command;

  /// An optional source code location that represents this label part.
  ///
  /// The editor will use this location for the hover and for code navigation
  /// features: This part will become a clickable link that resolves to the
  /// definition of the symbol at the given location (not necessarily the
  /// location itself), it shows the hover that shows at the given location,
  /// and it shows a context menu with further code navigation commands.
  ///
  /// Depending on the client capability `inlayHint.resolveSupport` clients
  /// might resolve this property late using the resolve request.
  final Location? location;

  /// The tooltip text when you hover over this label part. Depending on the
  /// client capability `inlayHint.resolveSupport` clients might resolve this
  /// property late using the resolve request.
  final Either2<MarkupContent, String>? tooltip;

  /// The value of this label part.
  final String value;
  InlayHintLabelPart({
    this.command,
    this.location,
    this.tooltip,
    required this.value,
  });
  @override
  int get hashCode => Object.hash(
        command,
        location,
        tooltip,
        value,
      );

  @override
  bool operator ==(Object other) {
    return other is InlayHintLabelPart &&
        other.runtimeType == InlayHintLabelPart &&
        command == other.command &&
        location == other.location &&
        tooltip == other.tooltip &&
        value == other.value;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (command != null) {
      result['command'] = command?.toJson();
    }
    if (location != null) {
      result['location'] = location?.toJson();
    }
    if (tooltip != null) {
      result['tooltip'] = tooltip;
    }
    result['value'] = value;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseCommand(obj, reporter, 'command',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseLocation(obj, reporter, 'location',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseMarkupContentString(obj, reporter, 'tooltip',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'value',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlayHintLabelPart');
      return false;
    }
  }

  static InlayHintLabelPart fromJson(Map<String, Object?> json) {
    final commandJson = json['command'];
    final command = commandJson != null
        ? Command.fromJson(commandJson as Map<String, Object?>)
        : null;
    final locationJson = json['location'];
    final location = locationJson != null
        ? Location.fromJson(locationJson as Map<String, Object?>)
        : null;
    final tooltipJson = json['tooltip'];
    final tooltip =
        tooltipJson == null ? null : _eitherMarkupContentString(tooltipJson);
    final valueJson = json['value'];
    final value = valueJson as String;
    return InlayHintLabelPart(
      command: command,
      location: location,
      tooltip: tooltip,
      value: value,
    );
  }
}

/// Inlay hint options used during static registration.
///
/// @since 3.17.0
class InlayHintOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlayHintOptions.canParse,
    InlayHintOptions.fromJson,
  );

  /// The server provides support to resolve additional information for an inlay
  /// hint item.
  final bool? resolveProvider;

  @override
  final bool? workDoneProgress;

  InlayHintOptions({
    this.resolveProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        resolveProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is InlayHintOptions &&
        other.runtimeType == InlayHintOptions &&
        resolveProvider == other.resolveProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlayHintOptions');
      return false;
    }
  }

  static InlayHintOptions fromJson(Map<String, Object?> json) {
    if (InlayHintRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return InlayHintRegistrationOptions.fromJson(json);
    }
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return InlayHintOptions(
      resolveProvider: resolveProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// A parameter literal used in inlay hint requests.
///
/// @since 3.17.0
class InlayHintParams implements WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlayHintParams.canParse,
    InlayHintParams.fromJson,
  );

  /// The document range for which inlay hints should be computed.
  final Range range;

  /// The text document.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  InlayHintParams({
    required this.range,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        range,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is InlayHintParams &&
        other.runtimeType == InlayHintParams &&
        range == other.range &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['range'] = range.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlayHintParams');
      return false;
    }
  }

  static InlayHintParams fromJson(Map<String, Object?> json) {
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return InlayHintParams(
      range: range,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Inlay hint options used during static or dynamic registration.
///
/// @since 3.17.0
class InlayHintRegistrationOptions
    implements
        InlayHintOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlayHintRegistrationOptions.canParse,
    InlayHintRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  /// The server provides support to resolve additional information for an inlay
  /// hint item.
  @override
  final bool? resolveProvider;
  @override
  final bool? workDoneProgress;
  InlayHintRegistrationOptions({
    this.documentSelector,
    this.id,
    this.resolveProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        resolveProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is InlayHintRegistrationOptions &&
        other.runtimeType == InlayHintRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        resolveProvider == other.resolveProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (resolveProvider != null) {
      result['resolveProvider'] = resolveProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'resolveProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlayHintRegistrationOptions');
      return false;
    }
  }

  static InlayHintRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final resolveProviderJson = json['resolveProvider'];
    final resolveProvider = resolveProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return InlayHintRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      resolveProvider: resolveProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Client workspace capabilities specific to inlay hints.
///
/// @since 3.17.0
class InlayHintWorkspaceClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlayHintWorkspaceClientCapabilities.canParse,
    InlayHintWorkspaceClientCapabilities.fromJson,
  );

  /// Whether the client implementation supports a refresh request sent from the
  /// server to the client.
  ///
  /// Note that this event is global and will force the client to refresh all
  /// inlay hints currently shown. It should be used with absolute care and is
  /// useful for situation where a server for example detects a project wide
  /// change that requires such a calculation.
  final bool? refreshSupport;

  InlayHintWorkspaceClientCapabilities({
    this.refreshSupport,
  });

  @override
  int get hashCode => refreshSupport.hashCode;

  @override
  bool operator ==(Object other) {
    return other is InlayHintWorkspaceClientCapabilities &&
        other.runtimeType == InlayHintWorkspaceClientCapabilities &&
        refreshSupport == other.refreshSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (refreshSupport != null) {
      result['refreshSupport'] = refreshSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'refreshSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type InlayHintWorkspaceClientCapabilities');
      return false;
    }
  }

  static InlayHintWorkspaceClientCapabilities fromJson(
      Map<String, Object?> json) {
    final refreshSupportJson = json['refreshSupport'];
    final refreshSupport = refreshSupportJson as bool?;
    return InlayHintWorkspaceClientCapabilities(
      refreshSupport: refreshSupport,
    );
  }
}

/// Client capabilities specific to inline values.
///
/// @since 3.17.0
class InlineValueClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlineValueClientCapabilities.canParse,
    InlineValueClientCapabilities.fromJson,
  );

  /// Whether implementation supports dynamic registration for inline value
  /// providers.
  final bool? dynamicRegistration;

  InlineValueClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is InlineValueClientCapabilities &&
        other.runtimeType == InlineValueClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlineValueClientCapabilities');
      return false;
    }
  }

  static InlineValueClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return InlineValueClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// @since 3.17.0
class InlineValueContext implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlineValueContext.canParse,
    InlineValueContext.fromJson,
  );

  /// The stack frame (as a DAP Id) where the execution has stopped.
  final int frameId;

  /// The document range where execution has stopped. Typically the end position
  /// of the range denotes the line where the inline values are shown.
  final Range stoppedLocation;

  InlineValueContext({
    required this.frameId,
    required this.stoppedLocation,
  });
  @override
  int get hashCode => Object.hash(
        frameId,
        stoppedLocation,
      );

  @override
  bool operator ==(Object other) {
    return other is InlineValueContext &&
        other.runtimeType == InlineValueContext &&
        frameId == other.frameId &&
        stoppedLocation == other.stoppedLocation;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['frameId'] = frameId;
    result['stoppedLocation'] = stoppedLocation.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseInt(obj, reporter, 'frameId',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'stoppedLocation',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlineValueContext');
      return false;
    }
  }

  static InlineValueContext fromJson(Map<String, Object?> json) {
    final frameIdJson = json['frameId'];
    final frameId = frameIdJson as int;
    final stoppedLocationJson = json['stoppedLocation'];
    final stoppedLocation =
        Range.fromJson(stoppedLocationJson as Map<String, Object?>);
    return InlineValueContext(
      frameId: frameId,
      stoppedLocation: stoppedLocation,
    );
  }
}

/// Provide an inline value through an expression evaluation. If only a range is
/// specified, the expression will be extracted from the underlying document. An
/// optional expression can be used to override the extracted expression.
///
/// @since 3.17.0
class InlineValueEvaluatableExpression implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlineValueEvaluatableExpression.canParse,
    InlineValueEvaluatableExpression.fromJson,
  );

  /// If specified the expression overrides the extracted expression.
  final String? expression;

  /// The document range for which the inline value applies. The range is used
  /// to extract the evaluatable expression from the underlying document.
  final Range range;

  InlineValueEvaluatableExpression({
    this.expression,
    required this.range,
  });
  @override
  int get hashCode => Object.hash(
        expression,
        range,
      );

  @override
  bool operator ==(Object other) {
    return other is InlineValueEvaluatableExpression &&
        other.runtimeType == InlineValueEvaluatableExpression &&
        expression == other.expression &&
        range == other.range;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (expression != null) {
      result['expression'] = expression;
    }
    result['range'] = range.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'expression',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlineValueEvaluatableExpression');
      return false;
    }
  }

  static InlineValueEvaluatableExpression fromJson(Map<String, Object?> json) {
    final expressionJson = json['expression'];
    final expression = expressionJson as String?;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    return InlineValueEvaluatableExpression(
      expression: expression,
      range: range,
    );
  }
}

/// Inline value options used during static registration.
///
/// @since 3.17.0
class InlineValueOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlineValueOptions.canParse,
    InlineValueOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  InlineValueOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is InlineValueOptions &&
        other.runtimeType == InlineValueOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlineValueOptions');
      return false;
    }
  }

  static InlineValueOptions fromJson(Map<String, Object?> json) {
    if (InlineValueRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return InlineValueRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return InlineValueOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// A parameter literal used in inline value requests.
///
/// @since 3.17.0
class InlineValueParams implements WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlineValueParams.canParse,
    InlineValueParams.fromJson,
  );

  /// Additional information about the context in which inline values were
  /// requested.
  final InlineValueContext context;

  /// The document range for which inline values should be computed.
  final Range range;

  /// The text document.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  InlineValueParams({
    required this.context,
    required this.range,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        context,
        range,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is InlineValueParams &&
        other.runtimeType == InlineValueParams &&
        context == other.context &&
        range == other.range &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['context'] = context.toJson();
    result['range'] = range.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseInlineValueContext(obj, reporter, 'context',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlineValueParams');
      return false;
    }
  }

  static InlineValueParams fromJson(Map<String, Object?> json) {
    final contextJson = json['context'];
    final context =
        InlineValueContext.fromJson(contextJson as Map<String, Object?>);
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return InlineValueParams(
      context: context,
      range: range,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Inline value options used during static or dynamic registration.
///
/// @since 3.17.0
class InlineValueRegistrationOptions
    implements
        InlineValueOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlineValueRegistrationOptions.canParse,
    InlineValueRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  @override
  final bool? workDoneProgress;
  InlineValueRegistrationOptions({
    this.documentSelector,
    this.id,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is InlineValueRegistrationOptions &&
        other.runtimeType == InlineValueRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlineValueRegistrationOptions');
      return false;
    }
  }

  static InlineValueRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return InlineValueRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Provide inline value as text.
///
/// @since 3.17.0
class InlineValueText implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlineValueText.canParse,
    InlineValueText.fromJson,
  );

  /// The document range for which the inline value applies.
  final Range range;

  /// The text of the inline value.
  final String text;

  InlineValueText({
    required this.range,
    required this.text,
  });
  @override
  int get hashCode => Object.hash(
        range,
        text,
      );

  @override
  bool operator ==(Object other) {
    return other is InlineValueText &&
        other.runtimeType == InlineValueText &&
        range == other.range &&
        text == other.text;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['range'] = range.toJson();
    result['text'] = text;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'text',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlineValueText');
      return false;
    }
  }

  static InlineValueText fromJson(Map<String, Object?> json) {
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final textJson = json['text'];
    final text = textJson as String;
    return InlineValueText(
      range: range,
      text: text,
    );
  }
}

/// Provide inline value through a variable lookup. If only a range is
/// specified, the variable name will be extracted from the underlying document.
/// An optional variable name can be used to override the extracted name.
///
/// @since 3.17.0
class InlineValueVariableLookup implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlineValueVariableLookup.canParse,
    InlineValueVariableLookup.fromJson,
  );

  /// How to perform the lookup.
  final bool caseSensitiveLookup;

  /// The document range for which the inline value applies. The range is used
  /// to extract the variable name from the underlying document.
  final Range range;

  /// If specified the name of the variable to look up.
  final String? variableName;
  InlineValueVariableLookup({
    required this.caseSensitiveLookup,
    required this.range,
    this.variableName,
  });
  @override
  int get hashCode => Object.hash(
        caseSensitiveLookup,
        range,
        variableName,
      );

  @override
  bool operator ==(Object other) {
    return other is InlineValueVariableLookup &&
        other.runtimeType == InlineValueVariableLookup &&
        caseSensitiveLookup == other.caseSensitiveLookup &&
        range == other.range &&
        variableName == other.variableName;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['caseSensitiveLookup'] = caseSensitiveLookup;
    result['range'] = range.toJson();
    if (variableName != null) {
      result['variableName'] = variableName;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'caseSensitiveLookup',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'variableName',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type InlineValueVariableLookup');
      return false;
    }
  }

  static InlineValueVariableLookup fromJson(Map<String, Object?> json) {
    final caseSensitiveLookupJson = json['caseSensitiveLookup'];
    final caseSensitiveLookup = caseSensitiveLookupJson as bool;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final variableNameJson = json['variableName'];
    final variableName = variableNameJson as String?;
    return InlineValueVariableLookup(
      caseSensitiveLookup: caseSensitiveLookup,
      range: range,
      variableName: variableName,
    );
  }
}

/// Client workspace capabilities specific to inline values.
///
/// @since 3.17.0
class InlineValueWorkspaceClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InlineValueWorkspaceClientCapabilities.canParse,
    InlineValueWorkspaceClientCapabilities.fromJson,
  );

  /// Whether the client implementation supports a refresh request sent from the
  /// server to the client.
  ///
  /// Note that this event is global and will force the client to refresh all
  /// inline values currently shown. It should be used with absolute care and is
  /// useful for situation where a server for example detects a project wide
  /// change that requires such a calculation.
  final bool? refreshSupport;

  InlineValueWorkspaceClientCapabilities({
    this.refreshSupport,
  });

  @override
  int get hashCode => refreshSupport.hashCode;

  @override
  bool operator ==(Object other) {
    return other is InlineValueWorkspaceClientCapabilities &&
        other.runtimeType == InlineValueWorkspaceClientCapabilities &&
        refreshSupport == other.refreshSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (refreshSupport != null) {
      result['refreshSupport'] = refreshSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'refreshSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type InlineValueWorkspaceClientCapabilities');
      return false;
    }
  }

  static InlineValueWorkspaceClientCapabilities fromJson(
      Map<String, Object?> json) {
    final refreshSupportJson = json['refreshSupport'];
    final refreshSupport = refreshSupportJson as bool?;
    return InlineValueWorkspaceClientCapabilities(
      refreshSupport: refreshSupport,
    );
  }
}

/// A special text edit to provide an insert and a replace operation.
///
/// @since 3.16.0
class InsertReplaceEdit implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    InsertReplaceEdit.canParse,
    InsertReplaceEdit.fromJson,
  );

  /// The range if the insert is requested
  final Range insert;

  /// The string to be inserted.
  final String newText;

  /// The range if the replace is requested.
  final Range replace;
  InsertReplaceEdit({
    required this.insert,
    required this.newText,
    required this.replace,
  });
  @override
  int get hashCode => Object.hash(
        insert,
        newText,
        replace,
      );

  @override
  bool operator ==(Object other) {
    return other is InsertReplaceEdit &&
        other.runtimeType == InsertReplaceEdit &&
        insert == other.insert &&
        newText == other.newText &&
        replace == other.replace;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['insert'] = insert.toJson();
    result['newText'] = newText;
    result['replace'] = replace.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseRange(obj, reporter, 'insert',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'newText',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'replace',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type InsertReplaceEdit');
      return false;
    }
  }

  static InsertReplaceEdit fromJson(Map<String, Object?> json) {
    final insertJson = json['insert'];
    final insert = Range.fromJson(insertJson as Map<String, Object?>);
    final newTextJson = json['newText'];
    final newText = newTextJson as String;
    final replaceJson = json['replace'];
    final replace = Range.fromJson(replaceJson as Map<String, Object?>);
    return InsertReplaceEdit(
      insert: insert,
      newText: newText,
      replace: replace,
    );
  }
}

/// Defines whether the insert text in a completion item should be interpreted
/// as plain text or a snippet.
class InsertTextFormat implements ToJsonable {
  /// The primary text to be inserted is treated as a plain string.
  static const PlainText = InsertTextFormat._(1);

  /// The primary text to be inserted is treated as a snippet.
  ///
  /// A snippet can define tab stops and placeholders with `$1`, `$2` and
  /// `${3:foo}`. `$0` defines the final tab stop, it defaults to the end of the
  /// snippet. Placeholders with equal identifiers are linked,
  /// that is typing in one will update others too.
  ///
  /// See also:
  /// https://microsoft.github.io/language-server-protocol/specifications/specification-current/#snippet_syntax
  static const Snippet = InsertTextFormat._(2);

  final int _value;

  const InsertTextFormat.fromJson(this._value);
  const InsertTextFormat._(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is InsertTextFormat && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    switch (obj) {
      case 1:
      case 2:
        return true;
    }
    return false;
  }
}

/// How whitespace and indentation is handled during completion item insertion.
///
/// @since 3.16.0
class InsertTextMode implements ToJsonable {
  /// The editor adjusts leading whitespace of new lines so that they match the
  /// indentation up to the cursor of the line for which the item is accepted.
  ///
  /// Consider a line like this: <2tabs><cursor><3tabs>foo. Accepting a multi
  /// line completion item is indented using 2 tabs and all following lines
  /// inserted will be indented using 2 tabs as well.
  static const adjustIndentation = InsertTextMode(2);

  /// The insertion or replace strings is taken as it is. If the value is multi
  /// line the lines below the cursor will be inserted using the indentation
  /// defined in the string value. The client will not apply any kind of
  /// adjustments to the string.
  static const asIs = InsertTextMode(1);

  final int _value;

  const InsertTextMode(this._value);
  const InsertTextMode.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is InsertTextMode && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// Client capabilities for the linked editing range request.
///
/// @since 3.16.0
class LinkedEditingRangeClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    LinkedEditingRangeClientCapabilities.canParse,
    LinkedEditingRangeClientCapabilities.fromJson,
  );

  /// Whether implementation supports dynamic registration. If this is set to
  /// `true` the client supports the new `(TextDocumentRegistrationOptions &
  /// StaticRegistrationOptions)` return value for the corresponding server
  /// capability as well.
  final bool? dynamicRegistration;

  LinkedEditingRangeClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is LinkedEditingRangeClientCapabilities &&
        other.runtimeType == LinkedEditingRangeClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type LinkedEditingRangeClientCapabilities');
      return false;
    }
  }

  static LinkedEditingRangeClientCapabilities fromJson(
      Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return LinkedEditingRangeClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

class LinkedEditingRangeOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    LinkedEditingRangeOptions.canParse,
    LinkedEditingRangeOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  LinkedEditingRangeOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is LinkedEditingRangeOptions &&
        other.runtimeType == LinkedEditingRangeOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type LinkedEditingRangeOptions');
      return false;
    }
  }

  static LinkedEditingRangeOptions fromJson(Map<String, Object?> json) {
    if (LinkedEditingRangeRegistrationOptions.canParse(
        json, nullLspJsonReporter)) {
      return LinkedEditingRangeRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return LinkedEditingRangeOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

class LinkedEditingRangeParams
    implements TextDocumentPositionParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    LinkedEditingRangeParams.canParse,
    LinkedEditingRangeParams.fromJson,
  );

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  LinkedEditingRangeParams({
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is LinkedEditingRangeParams &&
        other.runtimeType == LinkedEditingRangeParams &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type LinkedEditingRangeParams');
      return false;
    }
  }

  static LinkedEditingRangeParams fromJson(Map<String, Object?> json) {
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return LinkedEditingRangeParams(
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

class LinkedEditingRangeRegistrationOptions
    implements
        LinkedEditingRangeOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    LinkedEditingRangeRegistrationOptions.canParse,
    LinkedEditingRangeRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  @override
  final bool? workDoneProgress;
  LinkedEditingRangeRegistrationOptions({
    this.documentSelector,
    this.id,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is LinkedEditingRangeRegistrationOptions &&
        other.runtimeType == LinkedEditingRangeRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type LinkedEditingRangeRegistrationOptions');
      return false;
    }
  }

  static LinkedEditingRangeRegistrationOptions fromJson(
      Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return LinkedEditingRangeRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// The result of a linked editing range request.
///
/// @since 3.16.0
class LinkedEditingRanges implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    LinkedEditingRanges.canParse,
    LinkedEditingRanges.fromJson,
  );

  /// A list of ranges that can be edited together. The ranges must have
  /// identical length and contain identical text content. The ranges cannot
  /// overlap.
  final List<Range> ranges;

  /// An optional word pattern (regular expression) that describes valid
  /// contents for the given ranges. If no pattern is provided, the client
  /// configuration's word pattern will be used.
  final String? wordPattern;

  LinkedEditingRanges({
    required this.ranges,
    this.wordPattern,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(ranges),
        wordPattern,
      );

  @override
  bool operator ==(Object other) {
    return other is LinkedEditingRanges &&
        other.runtimeType == LinkedEditingRanges &&
        const DeepCollectionEquality().equals(ranges, other.ranges) &&
        wordPattern == other.wordPattern;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['ranges'] = ranges.map((item) => item.toJson()).toList();
    if (wordPattern != null) {
      result['wordPattern'] = wordPattern;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListRange(obj, reporter, 'ranges',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'wordPattern',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type LinkedEditingRanges');
      return false;
    }
  }

  static LinkedEditingRanges fromJson(Map<String, Object?> json) {
    final rangesJson = json['ranges'];
    final ranges = (rangesJson as List<Object?>)
        .map((item) => Range.fromJson(item as Map<String, Object?>))
        .toList();
    final wordPatternJson = json['wordPattern'];
    final wordPattern = wordPatternJson as String?;
    return LinkedEditingRanges(
      ranges: ranges,
      wordPattern: wordPattern,
    );
  }
}

/// Represents a location inside a resource, such as a line inside a text file.
class Location implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    Location.canParse,
    Location.fromJson,
  );

  final Range range;

  final DocumentUri uri;

  Location({
    required this.range,
    required this.uri,
  });
  @override
  int get hashCode => Object.hash(
        range,
        uri,
      );

  @override
  bool operator ==(Object other) {
    return other is Location &&
        other.runtimeType == Location &&
        range == other.range &&
        uri == other.uri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['range'] = range.toJson();
    result['uri'] = uri.toString();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type Location');
      return false;
    }
  }

  static Location fromJson(Map<String, Object?> json) {
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    return Location(
      range: range,
      uri: uri,
    );
  }
}

/// Represents the connection of two locations. Provides additional metadata
/// over normal [Location],
/// including an origin range.
class LocationLink implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    LocationLink.canParse,
    LocationLink.fromJson,
  );

  /// Span of the origin of this link.
  ///
  /// Used as the underlined span for mouse interaction. Defaults to the word
  /// range at the definition position.
  final Range? originSelectionRange;

  /// The full target range of this link. If the target for example is a symbol
  /// then target range is the range enclosing this symbol not including
  /// leading/trailing whitespace but everything else like comments. This
  /// information is typically used to highlight the range in the editor.
  final Range targetRange;

  /// The range that should be selected and revealed when this link is being
  /// followed, e.g the name of a function. Must be contained by the
  /// `targetRange`. See also `DocumentSymbol#range`
  final Range targetSelectionRange;

  /// The target resource identifier of this link.
  final DocumentUri targetUri;
  LocationLink({
    this.originSelectionRange,
    required this.targetRange,
    required this.targetSelectionRange,
    required this.targetUri,
  });
  @override
  int get hashCode => Object.hash(
        originSelectionRange,
        targetRange,
        targetSelectionRange,
        targetUri,
      );

  @override
  bool operator ==(Object other) {
    return other is LocationLink &&
        other.runtimeType == LocationLink &&
        originSelectionRange == other.originSelectionRange &&
        targetRange == other.targetRange &&
        targetSelectionRange == other.targetSelectionRange &&
        targetUri == other.targetUri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (originSelectionRange != null) {
      result['originSelectionRange'] = originSelectionRange?.toJson();
    }
    result['targetRange'] = targetRange.toJson();
    result['targetSelectionRange'] = targetSelectionRange.toJson();
    result['targetUri'] = targetUri.toString();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseRange(obj, reporter, 'originSelectionRange',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'targetRange',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseRange(obj, reporter, 'targetSelectionRange',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseUri(obj, reporter, 'targetUri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type LocationLink');
      return false;
    }
  }

  static LocationLink fromJson(Map<String, Object?> json) {
    final originSelectionRangeJson = json['originSelectionRange'];
    final originSelectionRange = originSelectionRangeJson != null
        ? Range.fromJson(originSelectionRangeJson as Map<String, Object?>)
        : null;
    final targetRangeJson = json['targetRange'];
    final targetRange = Range.fromJson(targetRangeJson as Map<String, Object?>);
    final targetSelectionRangeJson = json['targetSelectionRange'];
    final targetSelectionRange =
        Range.fromJson(targetSelectionRangeJson as Map<String, Object?>);
    final targetUriJson = json['targetUri'];
    final targetUri = Uri.parse(targetUriJson as String);
    return LocationLink(
      originSelectionRange: originSelectionRange,
      targetRange: targetRange,
      targetSelectionRange: targetSelectionRange,
      targetUri: targetUri,
    );
  }
}

/// The log message parameters.
class LogMessageParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    LogMessageParams.canParse,
    LogMessageParams.fromJson,
  );

  /// The actual message.
  final String message;

  /// The message type. See [MessageType]
  final MessageType type;

  LogMessageParams({
    required this.message,
    required this.type,
  });
  @override
  int get hashCode => Object.hash(
        message,
        type,
      );

  @override
  bool operator ==(Object other) {
    return other is LogMessageParams &&
        other.runtimeType == LogMessageParams &&
        message == other.message &&
        type == other.type;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['message'] = message;
    result['type'] = type.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'message',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseMessageType(obj, reporter, 'type',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type LogMessageParams');
      return false;
    }
  }

  static LogMessageParams fromJson(Map<String, Object?> json) {
    final messageJson = json['message'];
    final message = messageJson as String;
    final typeJson = json['type'];
    final type = MessageType.fromJson(typeJson as int);
    return LogMessageParams(
      message: message,
      type: type,
    );
  }
}

class LogTraceParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    LogTraceParams.canParse,
    LogTraceParams.fromJson,
  );

  final String message;

  final String? verbose;

  LogTraceParams({
    required this.message,
    this.verbose,
  });
  @override
  int get hashCode => Object.hash(
        message,
        verbose,
      );

  @override
  bool operator ==(Object other) {
    return other is LogTraceParams &&
        other.runtimeType == LogTraceParams &&
        message == other.message &&
        verbose == other.verbose;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['message'] = message;
    if (verbose != null) {
      result['verbose'] = verbose;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'message',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'verbose',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type LogTraceParams');
      return false;
    }
  }

  static LogTraceParams fromJson(Map<String, Object?> json) {
    final messageJson = json['message'];
    final message = messageJson as String;
    final verboseJson = json['verbose'];
    final verbose = verboseJson as String?;
    return LogTraceParams(
      message: message,
      verbose: verbose,
    );
  }
}

/// Client capabilities specific to the used markdown parser.
///
/// @since 3.16.0
class MarkdownClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    MarkdownClientCapabilities.canParse,
    MarkdownClientCapabilities.fromJson,
  );

  /// A list of HTML tags that the client allows / supports in Markdown.
  ///
  /// @since 3.17.0
  final List<String>? allowedTags;

  /// The name of the parser.
  final String parser;

  /// The version of the parser.
  final String? version;
  MarkdownClientCapabilities({
    this.allowedTags,
    required this.parser,
    this.version,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(allowedTags),
        parser,
        version,
      );

  @override
  bool operator ==(Object other) {
    return other is MarkdownClientCapabilities &&
        other.runtimeType == MarkdownClientCapabilities &&
        const DeepCollectionEquality().equals(allowedTags, other.allowedTags) &&
        parser == other.parser &&
        version == other.version;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (allowedTags != null) {
      result['allowedTags'] = allowedTags;
    }
    result['parser'] = parser;
    if (version != null) {
      result['version'] = version;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListString(obj, reporter, 'allowedTags',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'parser',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'version',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type MarkdownClientCapabilities');
      return false;
    }
  }

  static MarkdownClientCapabilities fromJson(Map<String, Object?> json) {
    final allowedTagsJson = json['allowedTags'];
    final allowedTags = (allowedTagsJson as List<Object?>?)
        ?.map((item) => item as String)
        .toList();
    final parserJson = json['parser'];
    final parser = parserJson as String;
    final versionJson = json['version'];
    final version = versionJson as String?;
    return MarkdownClientCapabilities(
      allowedTags: allowedTags,
      parser: parser,
      version: version,
    );
  }
}

/// A `MarkupContent` literal represents a string value which content is
/// interpreted base on its kind flag. Currently the protocol supports
/// `plaintext` and `markdown` as markup kinds.
///
/// If the kind is `markdown` then the value can contain fenced code blocks like
/// in GitHub issues. See
/// https://help.github.com/articles/creating-and-highlighting-code-blocks/#syntax-highlighting
///
/// Here is an example how such a string can be constructed using JavaScript /
/// TypeScript:
/// ```ts let markdown: MarkdownContent = {
///  kind: MarkupKind.Markdown,
///  value: [
///    '# Header',
///    'Some text',
///    '```typescript',
///    'someCode();',
///    '```'
///  ].join('\n')
/// };
/// ```
///
/// *Please Note* that clients might sanitize the return markdown. A client
/// could decide to remove HTML from the markdown to avoid script execution.
class MarkupContent implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    MarkupContent.canParse,
    MarkupContent.fromJson,
  );

  /// The type of the Markup
  final MarkupKind kind;

  /// The content itself
  final String value;

  MarkupContent({
    required this.kind,
    required this.value,
  });
  @override
  int get hashCode => Object.hash(
        kind,
        value,
      );

  @override
  bool operator ==(Object other) {
    return other is MarkupContent &&
        other.runtimeType == MarkupContent &&
        kind == other.kind &&
        value == other.value;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['kind'] = kind.toJson();
    result['value'] = value;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseMarkupKind(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'value',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type MarkupContent');
      return false;
    }
  }

  static MarkupContent fromJson(Map<String, Object?> json) {
    final kindJson = json['kind'];
    final kind = MarkupKind.fromJson(kindJson as String);
    final valueJson = json['value'];
    final value = valueJson as String;
    return MarkupContent(
      kind: kind,
      value: value,
    );
  }
}

/// Describes the content type that a client supports in various result literals
/// like `Hover`, `ParameterInfo` or `CompletionItem`.
///
/// Please note that `MarkupKinds` must not start with a `$`. This kinds are
/// reserved for internal usage.
class MarkupKind implements ToJsonable {
  /// Markdown is supported as a content format
  static const Markdown = MarkupKind._('markdown');

  /// Plain text is supported as a content format
  static const PlainText = MarkupKind._('plaintext');

  final String _value;

  const MarkupKind.fromJson(this._value);
  const MarkupKind._(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is MarkupKind && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    switch (obj) {
      case 'markdown':
      case 'plaintext':
        return true;
    }
    return false;
  }
}

class MessageActionItem implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    MessageActionItem.canParse,
    MessageActionItem.fromJson,
  );

  /// A short title like 'Retry', 'Open Log' etc.
  final String title;

  MessageActionItem({
    required this.title,
  });

  @override
  int get hashCode => title.hashCode;

  @override
  bool operator ==(Object other) {
    return other is MessageActionItem &&
        other.runtimeType == MessageActionItem &&
        title == other.title;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['title'] = title;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseString(obj, reporter, 'title',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type MessageActionItem');
      return false;
    }
  }

  static MessageActionItem fromJson(Map<String, Object?> json) {
    final titleJson = json['title'];
    final title = titleJson as String;
    return MessageActionItem(
      title: title,
    );
  }
}

/// The message type
class MessageType implements ToJsonable {
  /// A debug message.
  ///
  /// @since 3.18.0
  static const Debug = MessageType(5);

  /// An error message.
  static const Error = MessageType(1);

  /// An information message.
  static const Info = MessageType(3);

  /// A log message.
  static const Log = MessageType(4);

  /// A warning message.
  static const Warning = MessageType(2);
  final int _value;
  const MessageType(this._value);
  const MessageType.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is MessageType && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// All standard LSP Methods read from the JSON spec.
class Method implements ToJsonable {
  /// Constant for the 'callHierarchy/incomingCalls' method.
  static const callHierarchy_incomingCalls =
      Method('callHierarchy/incomingCalls');

  /// Constant for the 'callHierarchy/outgoingCalls' method.
  static const callHierarchy_outgoingCalls =
      Method('callHierarchy/outgoingCalls');

  /// Constant for the '$/cancelRequest' method.
  static const cancelRequest = Method(r'$/cancelRequest');

  /// Constant for the 'client/registerCapability' method.
  static const client_registerCapability = Method('client/registerCapability');

  /// Constant for the 'client/unregisterCapability' method.
  static const client_unregisterCapability =
      Method('client/unregisterCapability');

  /// Constant for the 'codeAction/resolve' method.
  static const codeAction_resolve = Method('codeAction/resolve');

  /// Constant for the 'codeLens/resolve' method.
  static const codeLens_resolve = Method('codeLens/resolve');

  /// Constant for the 'completionItem/resolve' method.
  static const completionItem_resolve = Method('completionItem/resolve');

  /// Constant for the 'documentLink/resolve' method.
  static const documentLink_resolve = Method('documentLink/resolve');

  /// Constant for the 'exit' method.
  static const exit = Method('exit');

  /// Constant for the 'initialize' method.
  static const initialize = Method('initialize');

  /// Constant for the 'initialized' method.
  static const initialized = Method('initialized');

  /// Constant for the 'inlayHint/resolve' method.
  static const inlayHint_resolve = Method('inlayHint/resolve');

  /// Constant for the '$/logTrace' method.
  static const logTrace = Method(r'$/logTrace');

  /// Constant for the 'notebookDocument/didChange' method.
  static const notebookDocument_didChange =
      Method('notebookDocument/didChange');

  /// Constant for the 'notebookDocument/didClose' method.
  static const notebookDocument_didClose = Method('notebookDocument/didClose');

  /// Constant for the 'notebookDocument/didOpen' method.
  static const notebookDocument_didOpen = Method('notebookDocument/didOpen');

  /// Constant for the 'notebookDocument/didSave' method.
  static const notebookDocument_didSave = Method('notebookDocument/didSave');

  /// Constant for the '$/progress' method.
  static const progress = Method(r'$/progress');

  /// Constant for the '$/setTrace' method.
  static const setTrace = Method(r'$/setTrace');

  /// Constant for the 'shutdown' method.
  static const shutdown = Method('shutdown');

  /// Constant for the 'telemetry/event' method.
  static const telemetry_event = Method('telemetry/event');

  /// Constant for the 'textDocument/codeAction' method.
  static const textDocument_codeAction = Method('textDocument/codeAction');

  /// Constant for the 'textDocument/codeLens' method.
  static const textDocument_codeLens = Method('textDocument/codeLens');

  /// Constant for the 'textDocument/colorPresentation' method.
  static const textDocument_colorPresentation =
      Method('textDocument/colorPresentation');

  /// Constant for the 'textDocument/completion' method.
  static const textDocument_completion = Method('textDocument/completion');

  /// Constant for the 'textDocument/declaration' method.
  static const textDocument_declaration = Method('textDocument/declaration');

  /// Constant for the 'textDocument/definition' method.
  static const textDocument_definition = Method('textDocument/definition');

  /// Constant for the 'textDocument/diagnostic' method.
  static const textDocument_diagnostic = Method('textDocument/diagnostic');

  /// Constant for the 'textDocument/didChange' method.
  static const textDocument_didChange = Method('textDocument/didChange');

  /// Constant for the 'textDocument/didClose' method.
  static const textDocument_didClose = Method('textDocument/didClose');

  /// Constant for the 'textDocument/didOpen' method.
  static const textDocument_didOpen = Method('textDocument/didOpen');

  /// Constant for the 'textDocument/didSave' method.
  static const textDocument_didSave = Method('textDocument/didSave');

  /// Constant for the 'textDocument/documentColor' method.
  static const textDocument_documentColor =
      Method('textDocument/documentColor');

  /// Constant for the 'textDocument/documentHighlight' method.
  static const textDocument_documentHighlight =
      Method('textDocument/documentHighlight');

  /// Constant for the 'textDocument/documentLink' method.
  static const textDocument_documentLink = Method('textDocument/documentLink');

  /// Constant for the 'textDocument/documentSymbol' method.
  static const textDocument_documentSymbol =
      Method('textDocument/documentSymbol');

  /// Constant for the 'textDocument/foldingRange' method.
  static const textDocument_foldingRange = Method('textDocument/foldingRange');

  /// Constant for the 'textDocument/formatting' method.
  static const textDocument_formatting = Method('textDocument/formatting');

  /// Constant for the 'textDocument/hover' method.
  static const textDocument_hover = Method('textDocument/hover');

  /// Constant for the 'textDocument/implementation' method.
  static const textDocument_implementation =
      Method('textDocument/implementation');

  /// Constant for the 'textDocument/inlayHint' method.
  static const textDocument_inlayHint = Method('textDocument/inlayHint');

  /// Constant for the 'textDocument/inlineValue' method.
  static const textDocument_inlineValue = Method('textDocument/inlineValue');

  /// Constant for the 'textDocument/linkedEditingRange' method.
  static const textDocument_linkedEditingRange =
      Method('textDocument/linkedEditingRange');

  /// Constant for the 'textDocument/moniker' method.
  static const textDocument_moniker = Method('textDocument/moniker');

  /// Constant for the 'textDocument/onTypeFormatting' method.
  static const textDocument_onTypeFormatting =
      Method('textDocument/onTypeFormatting');

  /// Constant for the 'textDocument/prepareCallHierarchy' method.
  static const textDocument_prepareCallHierarchy =
      Method('textDocument/prepareCallHierarchy');

  /// Constant for the 'textDocument/prepareRename' method.
  static const textDocument_prepareRename =
      Method('textDocument/prepareRename');

  /// Constant for the 'textDocument/prepareTypeHierarchy' method.
  static const textDocument_prepareTypeHierarchy =
      Method('textDocument/prepareTypeHierarchy');

  /// Constant for the 'textDocument/publishDiagnostics' method.
  static const textDocument_publishDiagnostics =
      Method('textDocument/publishDiagnostics');

  /// Constant for the 'textDocument/rangeFormatting' method.
  static const textDocument_rangeFormatting =
      Method('textDocument/rangeFormatting');

  /// Constant for the 'textDocument/references' method.
  static const textDocument_references = Method('textDocument/references');

  /// Constant for the 'textDocument/rename' method.
  static const textDocument_rename = Method('textDocument/rename');

  /// Constant for the 'textDocument/selectionRange' method.
  static const textDocument_selectionRange =
      Method('textDocument/selectionRange');

  /// Constant for the 'textDocument/semanticTokens/full' method.
  static const textDocument_semanticTokens_full =
      Method('textDocument/semanticTokens/full');

  /// Constant for the 'textDocument/semanticTokens/full/delta' method.
  static const textDocument_semanticTokens_full_delta =
      Method('textDocument/semanticTokens/full/delta');

  /// Constant for the 'textDocument/semanticTokens/range' method.
  static const textDocument_semanticTokens_range =
      Method('textDocument/semanticTokens/range');

  /// Constant for the 'textDocument/signatureHelp' method.
  static const textDocument_signatureHelp =
      Method('textDocument/signatureHelp');

  /// Constant for the 'textDocument/typeDefinition' method.
  static const textDocument_typeDefinition =
      Method('textDocument/typeDefinition');

  /// Constant for the 'textDocument/willSave' method.
  static const textDocument_willSave = Method('textDocument/willSave');

  /// Constant for the 'textDocument/willSaveWaitUntil' method.
  static const textDocument_willSaveWaitUntil =
      Method('textDocument/willSaveWaitUntil');

  /// Constant for the 'typeHierarchy/subtypes' method.
  static const typeHierarchy_subtypes = Method('typeHierarchy/subtypes');

  /// Constant for the 'typeHierarchy/supertypes' method.
  static const typeHierarchy_supertypes = Method('typeHierarchy/supertypes');

  /// Constant for the 'window/logMessage' method.
  static const window_logMessage = Method('window/logMessage');

  /// Constant for the 'window/showDocument' method.
  static const window_showDocument = Method('window/showDocument');

  /// Constant for the 'window/showMessage' method.
  static const window_showMessage = Method('window/showMessage');

  /// Constant for the 'window/showMessageRequest' method.
  static const window_showMessageRequest = Method('window/showMessageRequest');

  /// Constant for the 'window/workDoneProgress/cancel' method.
  static const window_workDoneProgress_cancel =
      Method('window/workDoneProgress/cancel');

  /// Constant for the 'window/workDoneProgress/create' method.
  static const window_workDoneProgress_create =
      Method('window/workDoneProgress/create');

  /// Constant for the 'workspace/applyEdit' method.
  static const workspace_applyEdit = Method('workspace/applyEdit');

  /// Constant for the 'workspace/codeLens/refresh' method.
  static const workspace_codeLens_refresh =
      Method('workspace/codeLens/refresh');

  /// Constant for the 'workspace/configuration' method.
  static const workspace_configuration = Method('workspace/configuration');

  /// Constant for the 'workspace/diagnostic' method.
  static const workspace_diagnostic = Method('workspace/diagnostic');

  /// Constant for the 'workspace/diagnostic/refresh' method.
  static const workspace_diagnostic_refresh =
      Method('workspace/diagnostic/refresh');

  /// Constant for the 'workspace/didChangeConfiguration' method.
  static const workspace_didChangeConfiguration =
      Method('workspace/didChangeConfiguration');

  /// Constant for the 'workspace/didChangeWatchedFiles' method.
  static const workspace_didChangeWatchedFiles =
      Method('workspace/didChangeWatchedFiles');

  /// Constant for the 'workspace/didChangeWorkspaceFolders' method.
  static const workspace_didChangeWorkspaceFolders =
      Method('workspace/didChangeWorkspaceFolders');

  /// Constant for the 'workspace/didCreateFiles' method.
  static const workspace_didCreateFiles = Method('workspace/didCreateFiles');

  /// Constant for the 'workspace/didDeleteFiles' method.
  static const workspace_didDeleteFiles = Method('workspace/didDeleteFiles');

  /// Constant for the 'workspace/didRenameFiles' method.
  static const workspace_didRenameFiles = Method('workspace/didRenameFiles');

  /// Constant for the 'workspace/executeCommand' method.
  static const workspace_executeCommand = Method('workspace/executeCommand');

  /// Constant for the 'workspace/inlayHint/refresh' method.
  static const workspace_inlayHint_refresh =
      Method('workspace/inlayHint/refresh');

  /// Constant for the 'workspace/inlineValue/refresh' method.
  static const workspace_inlineValue_refresh =
      Method('workspace/inlineValue/refresh');

  /// Constant for the 'workspace/semanticTokens/refresh' method.
  static const workspace_semanticTokens_refresh =
      Method('workspace/semanticTokens/refresh');

  /// Constant for the 'workspace/symbol' method.
  static const workspace_symbol = Method('workspace/symbol');

  /// Constant for the 'workspace/willCreateFiles' method.
  static const workspace_willCreateFiles = Method('workspace/willCreateFiles');

  /// Constant for the 'workspace/willDeleteFiles' method.
  static const workspace_willDeleteFiles = Method('workspace/willDeleteFiles');

  /// Constant for the 'workspace/willRenameFiles' method.
  static const workspace_willRenameFiles = Method('workspace/willRenameFiles');

  /// Constant for the 'workspace/workspaceFolders' method.
  static const workspace_workspaceFolders =
      Method('workspace/workspaceFolders');

  /// Constant for the 'workspaceSymbol/resolve' method.
  static const workspaceSymbol_resolve = Method('workspaceSymbol/resolve');
  final String _value;
  const Method(this._value);
  const Method.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) => other is Method && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is String;
}

/// Moniker definition to match LSIF 0.5 moniker definition.
///
/// @since 3.16.0
class Moniker implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    Moniker.canParse,
    Moniker.fromJson,
  );

  /// The identifier of the moniker. The value is opaque in LSIF however schema
  /// owners are allowed to define the structure if they want.
  final String identifier;

  /// The moniker kind if known.
  final MonikerKind? kind;

  /// The scheme of the moniker. For example tsc or .Net
  final String scheme;

  /// The scope in which the moniker is unique
  final UniquenessLevel unique;
  Moniker({
    required this.identifier,
    this.kind,
    required this.scheme,
    required this.unique,
  });
  @override
  int get hashCode => Object.hash(
        identifier,
        kind,
        scheme,
        unique,
      );

  @override
  bool operator ==(Object other) {
    return other is Moniker &&
        other.runtimeType == Moniker &&
        identifier == other.identifier &&
        kind == other.kind &&
        scheme == other.scheme &&
        unique == other.unique;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['identifier'] = identifier;
    if (kind != null) {
      result['kind'] = kind?.toJson();
    }
    result['scheme'] = scheme;
    result['unique'] = unique.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'identifier',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseMonikerKind(obj, reporter, 'kind',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'scheme',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseUniquenessLevel(obj, reporter, 'unique',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type Moniker');
      return false;
    }
  }

  static Moniker fromJson(Map<String, Object?> json) {
    final identifierJson = json['identifier'];
    final identifier = identifierJson as String;
    final kindJson = json['kind'];
    final kind =
        kindJson != null ? MonikerKind.fromJson(kindJson as String) : null;
    final schemeJson = json['scheme'];
    final scheme = schemeJson as String;
    final uniqueJson = json['unique'];
    final unique = UniquenessLevel.fromJson(uniqueJson as String);
    return Moniker(
      identifier: identifier,
      kind: kind,
      scheme: scheme,
      unique: unique,
    );
  }
}

/// Client capabilities specific to the moniker request.
///
/// @since 3.16.0
class MonikerClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    MonikerClientCapabilities.canParse,
    MonikerClientCapabilities.fromJson,
  );

  /// Whether moniker supports dynamic registration. If this is set to `true`
  /// the client supports the new `MonikerRegistrationOptions` return value for
  /// the corresponding server capability as well.
  final bool? dynamicRegistration;

  MonikerClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is MonikerClientCapabilities &&
        other.runtimeType == MonikerClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type MonikerClientCapabilities');
      return false;
    }
  }

  static MonikerClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return MonikerClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// The moniker kind.
///
/// @since 3.16.0
class MonikerKind implements ToJsonable {
  /// The moniker represents a symbol that is exported from a project
  static const export = MonikerKind('export');

  /// The moniker represent a symbol that is imported into a project
  static const import = MonikerKind('import');

  /// The moniker represents a symbol that is local to a project (e.g. a local
  /// variable of a function, a class not visible outside the project, ...)
  static const local = MonikerKind('local');

  final String _value;
  const MonikerKind(this._value);
  const MonikerKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is MonikerKind && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is String;
}

class MonikerOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    MonikerOptions.canParse,
    MonikerOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  MonikerOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is MonikerOptions &&
        other.runtimeType == MonikerOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type MonikerOptions');
      return false;
    }
  }

  static MonikerOptions fromJson(Map<String, Object?> json) {
    if (MonikerRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return MonikerRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return MonikerOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

class MonikerParams
    implements
        PartialResultParams,
        TextDocumentPositionParams,
        WorkDoneProgressParams,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    MonikerParams.canParse,
    MonikerParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  MonikerParams({
    this.partialResultToken,
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is MonikerParams &&
        other.runtimeType == MonikerParams &&
        partialResultToken == other.partialResultToken &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type MonikerParams');
      return false;
    }
  }

  static MonikerParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return MonikerParams(
      partialResultToken: partialResultToken,
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

class MonikerRegistrationOptions
    implements MonikerOptions, TextDocumentRegistrationOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    MonikerRegistrationOptions.canParse,
    MonikerRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  @override
  final bool? workDoneProgress;

  MonikerRegistrationOptions({
    this.documentSelector,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is MonikerRegistrationOptions &&
        other.runtimeType == MonikerRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type MonikerRegistrationOptions');
      return false;
    }
  }

  static MonikerRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return MonikerRegistrationOptions(
      documentSelector: documentSelector,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// A notebook cell.
///
/// A cell's document URI must be unique across ALL notebook cells and can
/// therefore be used to uniquely identify a notebook cell or the cell's text
/// document.
///
/// @since 3.17.0
class NotebookCell implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookCell.canParse,
    NotebookCell.fromJson,
  );

  /// The URI of the cell's text document content.
  final DocumentUri document;

  /// Additional execution summary information if supported by the client.
  final ExecutionSummary? executionSummary;

  /// The cell's kind
  final NotebookCellKind kind;

  /// Additional metadata stored with the cell.
  ///
  /// Note: should always be an object literal (e.g. LSPObject)
  final LSPObject? metadata;
  NotebookCell({
    required this.document,
    this.executionSummary,
    required this.kind,
    this.metadata,
  });
  @override
  int get hashCode => Object.hash(
        document,
        executionSummary,
        kind,
        metadata,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookCell &&
        other.runtimeType == NotebookCell &&
        document == other.document &&
        executionSummary == other.executionSummary &&
        kind == other.kind &&
        metadata == other.metadata;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['document'] = document.toString();
    if (executionSummary != null) {
      result['executionSummary'] = executionSummary?.toJson();
    }
    result['kind'] = kind.toJson();
    if (metadata != null) {
      result['metadata'] = metadata;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseUri(obj, reporter, 'document',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseExecutionSummary(obj, reporter, 'executionSummary',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseNotebookCellKind(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseObject(obj, reporter, 'metadata',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookCell');
      return false;
    }
  }

  static NotebookCell fromJson(Map<String, Object?> json) {
    final documentJson = json['document'];
    final document = Uri.parse(documentJson as String);
    final executionSummaryJson = json['executionSummary'];
    final executionSummary = executionSummaryJson != null
        ? ExecutionSummary.fromJson(
            executionSummaryJson as Map<String, Object?>)
        : null;
    final kindJson = json['kind'];
    final kind = NotebookCellKind.fromJson(kindJson as int);
    final metadataJson = json['metadata'];
    final metadata = metadataJson;
    return NotebookCell(
      document: document,
      executionSummary: executionSummary,
      kind: kind,
      metadata: metadata,
    );
  }
}

/// A change describing how to move a `NotebookCell` array from state S to S'.
///
/// @since 3.17.0
class NotebookCellArrayChange implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookCellArrayChange.canParse,
    NotebookCellArrayChange.fromJson,
  );

  /// The new cells, if any
  final List<NotebookCell>? cells;

  /// The deleted cells
  final int deleteCount;

  /// The start oftest of the cell that changed.
  final int start;
  NotebookCellArrayChange({
    this.cells,
    required this.deleteCount,
    required this.start,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(cells),
        deleteCount,
        start,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookCellArrayChange &&
        other.runtimeType == NotebookCellArrayChange &&
        const DeepCollectionEquality().equals(cells, other.cells) &&
        deleteCount == other.deleteCount &&
        start == other.start;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (cells != null) {
      result['cells'] = cells?.map((item) => item.toJson()).toList();
    }
    result['deleteCount'] = deleteCount;
    result['start'] = start;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListNotebookCell(obj, reporter, 'cells',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseInt(obj, reporter, 'deleteCount',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseInt(obj, reporter, 'start',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookCellArrayChange');
      return false;
    }
  }

  static NotebookCellArrayChange fromJson(Map<String, Object?> json) {
    final cellsJson = json['cells'];
    final cells = (cellsJson as List<Object?>?)
        ?.map((item) => NotebookCell.fromJson(item as Map<String, Object?>))
        .toList();
    final deleteCountJson = json['deleteCount'];
    final deleteCount = deleteCountJson as int;
    final startJson = json['start'];
    final start = startJson as int;
    return NotebookCellArrayChange(
      cells: cells,
      deleteCount: deleteCount,
      start: start,
    );
  }
}

/// A notebook cell kind.
///
/// @since 3.17.0
class NotebookCellKind implements ToJsonable {
  /// A code-cell is source code.
  static const Code = NotebookCellKind(2);

  /// A markup-cell is formatted source that is used for display.
  static const Markup = NotebookCellKind(1);

  final int _value;

  const NotebookCellKind(this._value);
  const NotebookCellKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is NotebookCellKind && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// A notebook cell text document filter denotes a cell text document by
/// different properties.
///
/// @since 3.17.0
class NotebookCellTextDocumentFilter implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookCellTextDocumentFilter.canParse,
    NotebookCellTextDocumentFilter.fromJson,
  );

  /// A language id like `python`.
  ///
  /// Will be matched against the language id of the notebook cell document. '*'
  /// matches every language.
  final String? language;

  /// A filter that matches against the notebook containing the notebook cell.
  /// If a string value is provided it matches against the notebook type. '*'
  /// matches every notebook.
  final Either2<NotebookDocumentFilter, String> notebook;

  NotebookCellTextDocumentFilter({
    this.language,
    required this.notebook,
  });
  @override
  int get hashCode => Object.hash(
        language,
        notebook,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookCellTextDocumentFilter &&
        other.runtimeType == NotebookCellTextDocumentFilter &&
        language == other.language &&
        notebook == other.notebook;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (language != null) {
      result['language'] = language;
    }
    result['notebook'] = notebook;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'language',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3String(
          obj, reporter, 'notebook',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookCellTextDocumentFilter');
      return false;
    }
  }

  static NotebookCellTextDocumentFilter fromJson(Map<String, Object?> json) {
    final languageJson = json['language'];
    final language = languageJson as String?;
    final notebookJson = json['notebook'];
    final notebook =
        _eitherNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3String(
            notebookJson);
    return NotebookCellTextDocumentFilter(
      language: language,
      notebook: notebook,
    );
  }
}

/// A notebook document.
///
/// @since 3.17.0
class NotebookDocument implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocument.canParse,
    NotebookDocument.fromJson,
  );

  /// The cells of a notebook.
  final List<NotebookCell> cells;

  /// Additional metadata stored with the notebook document.
  ///
  /// Note: should always be an object literal (e.g. LSPObject)
  final LSPObject? metadata;

  /// The type of the notebook.
  final String notebookType;

  /// The notebook document's uri.
  final LSPUri uri;

  /// The version number of this document (it will increase after each change,
  /// including undo/redo).
  final int version;
  NotebookDocument({
    required this.cells,
    this.metadata,
    required this.notebookType,
    required this.uri,
    required this.version,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(cells),
        metadata,
        notebookType,
        uri,
        version,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocument &&
        other.runtimeType == NotebookDocument &&
        const DeepCollectionEquality().equals(cells, other.cells) &&
        metadata == other.metadata &&
        notebookType == other.notebookType &&
        uri == other.uri &&
        version == other.version;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['cells'] = cells.map((item) => item.toJson()).toList();
    if (metadata != null) {
      result['metadata'] = metadata;
    }
    result['notebookType'] = notebookType;
    result['uri'] = uri.toString();
    result['version'] = version;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListNotebookCell(obj, reporter, 'cells',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseObject(obj, reporter, 'metadata',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'notebookType',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseInt(obj, reporter, 'version',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookDocument');
      return false;
    }
  }

  static NotebookDocument fromJson(Map<String, Object?> json) {
    final cellsJson = json['cells'];
    final cells = (cellsJson as List<Object?>)
        .map((item) => NotebookCell.fromJson(item as Map<String, Object?>))
        .toList();
    final metadataJson = json['metadata'];
    final metadata = metadataJson;
    final notebookTypeJson = json['notebookType'];
    final notebookType = notebookTypeJson as String;
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    final versionJson = json['version'];
    final version = versionJson as int;
    return NotebookDocument(
      cells: cells,
      metadata: metadata,
      notebookType: notebookType,
      uri: uri,
      version: version,
    );
  }
}

/// A change event for a notebook document.
///
/// @since 3.17.0
class NotebookDocumentChangeEvent implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentChangeEvent.canParse,
    NotebookDocumentChangeEvent.fromJson,
  );

  /// Changes to cells
  final NotebookDocumentChangeEventCells? cells;

  /// The changed meta data if any.
  ///
  /// Note: should always be an object literal (e.g. LSPObject)
  final LSPObject? metadata;

  NotebookDocumentChangeEvent({
    this.cells,
    this.metadata,
  });
  @override
  int get hashCode => Object.hash(
        cells,
        metadata,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentChangeEvent &&
        other.runtimeType == NotebookDocumentChangeEvent &&
        cells == other.cells &&
        metadata == other.metadata;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (cells != null) {
      result['cells'] = cells?.toJson();
    }
    if (metadata != null) {
      result['metadata'] = metadata;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseNotebookDocumentChangeEventCells(obj, reporter, 'cells',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseObject(obj, reporter, 'metadata',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookDocumentChangeEvent');
      return false;
    }
  }

  static NotebookDocumentChangeEvent fromJson(Map<String, Object?> json) {
    final cellsJson = json['cells'];
    final cells = cellsJson != null
        ? NotebookDocumentChangeEventCells.fromJson(
            cellsJson as Map<String, Object?>)
        : null;
    final metadataJson = json['metadata'];
    final metadata = metadataJson;
    return NotebookDocumentChangeEvent(
      cells: cells,
      metadata: metadata,
    );
  }
}

class NotebookDocumentChangeEventCells implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentChangeEventCells.canParse,
    NotebookDocumentChangeEventCells.fromJson,
  );

  /// Changes to notebook cells properties like its kind, execution summary or
  /// metadata.
  final List<NotebookCell>? data;

  /// Changes to the cell structure to add or remove cells.
  final NotebookDocumentChangeEventCellsStructure? structure;

  /// Changes to the text content of notebook cells.
  final List<NotebookDocumentChangeEventCellsTextContent>? textContent;
  NotebookDocumentChangeEventCells({
    this.data,
    this.structure,
    this.textContent,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(data),
        structure,
        lspHashCode(textContent),
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentChangeEventCells &&
        other.runtimeType == NotebookDocumentChangeEventCells &&
        const DeepCollectionEquality().equals(data, other.data) &&
        structure == other.structure &&
        const DeepCollectionEquality().equals(textContent, other.textContent);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (data != null) {
      result['data'] = data?.map((item) => item.toJson()).toList();
    }
    if (structure != null) {
      result['structure'] = structure?.toJson();
    }
    if (textContent != null) {
      result['textContent'] =
          textContent?.map((item) => item.toJson()).toList();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListNotebookCell(obj, reporter, 'data',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseNotebookDocumentChangeEventCellsStructure(
          obj, reporter, 'structure',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseListNotebookDocumentChangeEventCellsTextContent(
          obj, reporter, 'textContent',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookDocumentChangeEventCells');
      return false;
    }
  }

  static NotebookDocumentChangeEventCells fromJson(Map<String, Object?> json) {
    final dataJson = json['data'];
    final data = (dataJson as List<Object?>?)
        ?.map((item) => NotebookCell.fromJson(item as Map<String, Object?>))
        .toList();
    final structureJson = json['structure'];
    final structure = structureJson != null
        ? NotebookDocumentChangeEventCellsStructure.fromJson(
            structureJson as Map<String, Object?>)
        : null;
    final textContentJson = json['textContent'];
    final textContent = (textContentJson as List<Object?>?)
        ?.map((item) => NotebookDocumentChangeEventCellsTextContent.fromJson(
            item as Map<String, Object?>))
        .toList();
    return NotebookDocumentChangeEventCells(
      data: data,
      structure: structure,
      textContent: textContent,
    );
  }
}

class NotebookDocumentChangeEventCellsStructure implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentChangeEventCellsStructure.canParse,
    NotebookDocumentChangeEventCellsStructure.fromJson,
  );

  /// The change to the cell array.
  final NotebookCellArrayChange array;

  /// Additional closed cell text documents.
  final List<TextDocumentIdentifier>? didClose;

  /// Additional opened cell text documents.
  final List<TextDocumentItem>? didOpen;
  NotebookDocumentChangeEventCellsStructure({
    required this.array,
    this.didClose,
    this.didOpen,
  });
  @override
  int get hashCode => Object.hash(
        array,
        lspHashCode(didClose),
        lspHashCode(didOpen),
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentChangeEventCellsStructure &&
        other.runtimeType == NotebookDocumentChangeEventCellsStructure &&
        array == other.array &&
        const DeepCollectionEquality().equals(didClose, other.didClose) &&
        const DeepCollectionEquality().equals(didOpen, other.didOpen);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['array'] = array.toJson();
    if (didClose != null) {
      result['didClose'] = didClose?.map((item) => item.toJson()).toList();
    }
    if (didOpen != null) {
      result['didOpen'] = didOpen?.map((item) => item.toJson()).toList();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseNotebookCellArrayChange(obj, reporter, 'array',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseListTextDocumentIdentifier(obj, reporter, 'didClose',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseListTextDocumentItem(obj, reporter, 'didOpen',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type NotebookDocumentChangeEventCellsStructure');
      return false;
    }
  }

  static NotebookDocumentChangeEventCellsStructure fromJson(
      Map<String, Object?> json) {
    final arrayJson = json['array'];
    final array =
        NotebookCellArrayChange.fromJson(arrayJson as Map<String, Object?>);
    final didCloseJson = json['didClose'];
    final didClose = (didCloseJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentIdentifier.fromJson(item as Map<String, Object?>))
        .toList();
    final didOpenJson = json['didOpen'];
    final didOpen = (didOpenJson as List<Object?>?)
        ?.map((item) => TextDocumentItem.fromJson(item as Map<String, Object?>))
        .toList();
    return NotebookDocumentChangeEventCellsStructure(
      array: array,
      didClose: didClose,
      didOpen: didOpen,
    );
  }
}

class NotebookDocumentChangeEventCellsTextContent implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentChangeEventCellsTextContent.canParse,
    NotebookDocumentChangeEventCellsTextContent.fromJson,
  );

  final List<TextDocumentContentChangeEvent> changes;

  final VersionedTextDocumentIdentifier document;

  NotebookDocumentChangeEventCellsTextContent({
    required this.changes,
    required this.document,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(changes),
        document,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentChangeEventCellsTextContent &&
        other.runtimeType == NotebookDocumentChangeEventCellsTextContent &&
        const DeepCollectionEquality().equals(changes, other.changes) &&
        document == other.document;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['changes'] = changes;
    result['document'] = document.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentContentChangePartialTextDocumentContentChangeWholeDocument(
          obj, reporter, 'changes',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseVersionedTextDocumentIdentifier(obj, reporter, 'document',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type NotebookDocumentChangeEventCellsTextContent');
      return false;
    }
  }

  static NotebookDocumentChangeEventCellsTextContent fromJson(
      Map<String, Object?> json) {
    final changesJson = json['changes'];
    final changes = (changesJson as List<Object?>)
        .map((item) =>
            _eitherTextDocumentContentChangePartialTextDocumentContentChangeWholeDocument(
                item))
        .toList();
    final documentJson = json['document'];
    final document = VersionedTextDocumentIdentifier.fromJson(
        documentJson as Map<String, Object?>);
    return NotebookDocumentChangeEventCellsTextContent(
      changes: changes,
      document: document,
    );
  }
}

/// Capabilities specific to the notebook document support.
///
/// @since 3.17.0
class NotebookDocumentClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentClientCapabilities.canParse,
    NotebookDocumentClientCapabilities.fromJson,
  );

  /// Capabilities specific to notebook document synchronization
  ///
  /// @since 3.17.0
  final NotebookDocumentSyncClientCapabilities synchronization;

  NotebookDocumentClientCapabilities({
    required this.synchronization,
  });

  @override
  int get hashCode => synchronization.hashCode;

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentClientCapabilities &&
        other.runtimeType == NotebookDocumentClientCapabilities &&
        synchronization == other.synchronization;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['synchronization'] = synchronization.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseNotebookDocumentSyncClientCapabilities(
          obj, reporter, 'synchronization',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type NotebookDocumentClientCapabilities');
      return false;
    }
  }

  static NotebookDocumentClientCapabilities fromJson(
      Map<String, Object?> json) {
    final synchronizationJson = json['synchronization'];
    final synchronization = NotebookDocumentSyncClientCapabilities.fromJson(
        synchronizationJson as Map<String, Object?>);
    return NotebookDocumentClientCapabilities(
      synchronization: synchronization,
    );
  }
}

class NotebookDocumentFilter1 implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentFilter1.canParse,
    NotebookDocumentFilter1.fromJson,
  );

  /// The type of the enclosing notebook.
  final String notebookType;

  /// A glob pattern.
  final String? pattern;

  /// A Uri [Uri.scheme], like `file` or `untitled`.
  final String? scheme;
  NotebookDocumentFilter1({
    required this.notebookType,
    this.pattern,
    this.scheme,
  });
  @override
  int get hashCode => Object.hash(
        notebookType,
        pattern,
        scheme,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentFilter1 &&
        other.runtimeType == NotebookDocumentFilter1 &&
        notebookType == other.notebookType &&
        pattern == other.pattern &&
        scheme == other.scheme;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['notebookType'] = notebookType;
    if (pattern != null) {
      result['pattern'] = pattern;
    }
    if (scheme != null) {
      result['scheme'] = scheme;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'notebookType',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'pattern',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'scheme',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookDocumentFilter1');
      return false;
    }
  }

  static NotebookDocumentFilter1 fromJson(Map<String, Object?> json) {
    final notebookTypeJson = json['notebookType'];
    final notebookType = notebookTypeJson as String;
    final patternJson = json['pattern'];
    final pattern = patternJson as String?;
    final schemeJson = json['scheme'];
    final scheme = schemeJson as String?;
    return NotebookDocumentFilter1(
      notebookType: notebookType,
      pattern: pattern,
      scheme: scheme,
    );
  }
}

class NotebookDocumentFilter2 implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentFilter2.canParse,
    NotebookDocumentFilter2.fromJson,
  );

  /// The type of the enclosing notebook.
  final String? notebookType;

  /// A glob pattern.
  final String? pattern;

  /// A Uri [Uri.scheme], like `file` or `untitled`.
  final String scheme;
  NotebookDocumentFilter2({
    this.notebookType,
    this.pattern,
    required this.scheme,
  });
  @override
  int get hashCode => Object.hash(
        notebookType,
        pattern,
        scheme,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentFilter2 &&
        other.runtimeType == NotebookDocumentFilter2 &&
        notebookType == other.notebookType &&
        pattern == other.pattern &&
        scheme == other.scheme;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (notebookType != null) {
      result['notebookType'] = notebookType;
    }
    if (pattern != null) {
      result['pattern'] = pattern;
    }
    result['scheme'] = scheme;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'notebookType',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'pattern',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'scheme',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookDocumentFilter2');
      return false;
    }
  }

  static NotebookDocumentFilter2 fromJson(Map<String, Object?> json) {
    final notebookTypeJson = json['notebookType'];
    final notebookType = notebookTypeJson as String?;
    final patternJson = json['pattern'];
    final pattern = patternJson as String?;
    final schemeJson = json['scheme'];
    final scheme = schemeJson as String;
    return NotebookDocumentFilter2(
      notebookType: notebookType,
      pattern: pattern,
      scheme: scheme,
    );
  }
}

class NotebookDocumentFilter3 implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentFilter3.canParse,
    NotebookDocumentFilter3.fromJson,
  );

  /// The type of the enclosing notebook.
  final String? notebookType;

  /// A glob pattern.
  final String pattern;

  /// A Uri [Uri.scheme], like `file` or `untitled`.
  final String? scheme;
  NotebookDocumentFilter3({
    this.notebookType,
    required this.pattern,
    this.scheme,
  });
  @override
  int get hashCode => Object.hash(
        notebookType,
        pattern,
        scheme,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentFilter3 &&
        other.runtimeType == NotebookDocumentFilter3 &&
        notebookType == other.notebookType &&
        pattern == other.pattern &&
        scheme == other.scheme;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (notebookType != null) {
      result['notebookType'] = notebookType;
    }
    result['pattern'] = pattern;
    if (scheme != null) {
      result['scheme'] = scheme;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'notebookType',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'pattern',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'scheme',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookDocumentFilter3');
      return false;
    }
  }

  static NotebookDocumentFilter3 fromJson(Map<String, Object?> json) {
    final notebookTypeJson = json['notebookType'];
    final notebookType = notebookTypeJson as String?;
    final patternJson = json['pattern'];
    final pattern = patternJson as String;
    final schemeJson = json['scheme'];
    final scheme = schemeJson as String?;
    return NotebookDocumentFilter3(
      notebookType: notebookType,
      pattern: pattern,
      scheme: scheme,
    );
  }
}

/// A literal to identify a notebook document in the client.
///
/// @since 3.17.0
class NotebookDocumentIdentifier implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentIdentifier.canParse,
    NotebookDocumentIdentifier.fromJson,
  );

  /// The notebook document's uri.
  final LSPUri uri;

  NotebookDocumentIdentifier({
    required this.uri,
  });

  @override
  int get hashCode => uri.hashCode;

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentIdentifier &&
        other.runtimeType == NotebookDocumentIdentifier &&
        uri == other.uri;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['uri'] = uri.toString();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookDocumentIdentifier');
      return false;
    }
  }

  static NotebookDocumentIdentifier fromJson(Map<String, Object?> json) {
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    return NotebookDocumentIdentifier(
      uri: uri,
    );
  }
}

/// Notebook specific client capabilities.
///
/// @since 3.17.0
class NotebookDocumentSyncClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentSyncClientCapabilities.canParse,
    NotebookDocumentSyncClientCapabilities.fromJson,
  );

  /// Whether implementation supports dynamic registration. If this is set to
  /// `true` the client supports the new `(TextDocumentRegistrationOptions &
  /// StaticRegistrationOptions)` return value for the corresponding server
  /// capability as well.
  final bool? dynamicRegistration;

  /// The client supports sending execution summary data per cell.
  final bool? executionSummarySupport;

  NotebookDocumentSyncClientCapabilities({
    this.dynamicRegistration,
    this.executionSummarySupport,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        executionSummarySupport,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentSyncClientCapabilities &&
        other.runtimeType == NotebookDocumentSyncClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        executionSummarySupport == other.executionSummarySupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (executionSummarySupport != null) {
      result['executionSummarySupport'] = executionSummarySupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'executionSummarySupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type NotebookDocumentSyncClientCapabilities');
      return false;
    }
  }

  static NotebookDocumentSyncClientCapabilities fromJson(
      Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final executionSummarySupportJson = json['executionSummarySupport'];
    final executionSummarySupport = executionSummarySupportJson as bool?;
    return NotebookDocumentSyncClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      executionSummarySupport: executionSummarySupport,
    );
  }
}

/// Options specific to a notebook plus its cells to be synced to the server.
///
/// If a selector provides a notebook document filter but no cell selector all
/// cells of a matching notebook document will be synced.
///
/// If a selector provides no notebook document filter but only a cell selector
/// all notebook document that contain at least one matching cell will be
/// synced.
///
/// @since 3.17.0
class NotebookDocumentSyncOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentSyncOptions.canParse,
    NotebookDocumentSyncOptions.fromJson,
  );

  /// The notebooks to be synced
  final List<
      Either2<NotebookDocumentSyncOptionsNotebookSelector,
          NotebookDocumentSyncOptionsNotebookSelector2>> notebookSelector;

  /// Whether save notification should be forwarded to the server. Will only be
  /// honored if mode === `notebook`.
  final bool? save;

  NotebookDocumentSyncOptions({
    required this.notebookSelector,
    this.save,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(notebookSelector),
        save,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentSyncOptions &&
        other.runtimeType == NotebookDocumentSyncOptions &&
        const DeepCollectionEquality()
            .equals(notebookSelector, other.notebookSelector) &&
        save == other.save;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['notebookSelector'] = notebookSelector;
    if (save != null) {
      result['save'] = save;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListNotebookDocumentSyncOptionsNotebookSelectorNotebookDocumentSyncOptionsNotebookSelector2(
          obj, reporter, 'notebookSelector',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'save',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type NotebookDocumentSyncOptions');
      return false;
    }
  }

  static NotebookDocumentSyncOptions fromJson(Map<String, Object?> json) {
    if (NotebookDocumentSyncRegistrationOptions.canParse(
        json, nullLspJsonReporter)) {
      return NotebookDocumentSyncRegistrationOptions.fromJson(json);
    }
    final notebookSelectorJson = json['notebookSelector'];
    final notebookSelector = (notebookSelectorJson as List<Object?>)
        .map((item) =>
            _eitherNotebookDocumentSyncOptionsNotebookSelectorNotebookDocumentSyncOptionsNotebookSelector2(
                item))
        .toList();
    final saveJson = json['save'];
    final save = saveJson as bool?;
    return NotebookDocumentSyncOptions(
      notebookSelector: notebookSelector,
      save: save,
    );
  }
}

class NotebookDocumentSyncOptionsNotebookSelector implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentSyncOptionsNotebookSelector.canParse,
    NotebookDocumentSyncOptionsNotebookSelector.fromJson,
  );

  /// The cells of the matching notebook to be synced.
  final List<NotebookDocumentSyncOptionsNotebookSelectorCells>? cells;

  /// The notebook to be synced If a string value is provided it matches against
  /// the notebook type. '*' matches every notebook.
  final Either2<NotebookDocumentFilter, String> notebook;

  NotebookDocumentSyncOptionsNotebookSelector({
    this.cells,
    required this.notebook,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(cells),
        notebook,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentSyncOptionsNotebookSelector &&
        other.runtimeType == NotebookDocumentSyncOptionsNotebookSelector &&
        const DeepCollectionEquality().equals(cells, other.cells) &&
        notebook == other.notebook;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (cells != null) {
      result['cells'] = cells?.map((item) => item.toJson()).toList();
    }
    result['notebook'] = notebook;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListNotebookDocumentSyncOptionsNotebookSelectorCells(
          obj, reporter, 'cells',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3String(
          obj, reporter, 'notebook',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type NotebookDocumentSyncOptionsNotebookSelector');
      return false;
    }
  }

  static NotebookDocumentSyncOptionsNotebookSelector fromJson(
      Map<String, Object?> json) {
    final cellsJson = json['cells'];
    final cells = (cellsJson as List<Object?>?)
        ?.map((item) =>
            NotebookDocumentSyncOptionsNotebookSelectorCells.fromJson(
                item as Map<String, Object?>))
        .toList();
    final notebookJson = json['notebook'];
    final notebook =
        _eitherNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3String(
            notebookJson);
    return NotebookDocumentSyncOptionsNotebookSelector(
      cells: cells,
      notebook: notebook,
    );
  }
}

class NotebookDocumentSyncOptionsNotebookSelector2 implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentSyncOptionsNotebookSelector2.canParse,
    NotebookDocumentSyncOptionsNotebookSelector2.fromJson,
  );

  /// The cells of the matching notebook to be synced.
  final List<NotebookDocumentSyncOptionsNotebookSelector2Cells> cells;

  /// The notebook to be synced If a string value is provided it matches against
  /// the notebook type. '*' matches every notebook.
  final Either2<NotebookDocumentFilter, String>? notebook;

  NotebookDocumentSyncOptionsNotebookSelector2({
    required this.cells,
    this.notebook,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(cells),
        notebook,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentSyncOptionsNotebookSelector2 &&
        other.runtimeType == NotebookDocumentSyncOptionsNotebookSelector2 &&
        const DeepCollectionEquality().equals(cells, other.cells) &&
        notebook == other.notebook;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['cells'] = cells.map((item) => item.toJson()).toList();
    if (notebook != null) {
      result['notebook'] = notebook;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListNotebookDocumentSyncOptionsNotebookSelector2Cells(
          obj, reporter, 'cells',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3String(
          obj, reporter, 'notebook',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type NotebookDocumentSyncOptionsNotebookSelector2');
      return false;
    }
  }

  static NotebookDocumentSyncOptionsNotebookSelector2 fromJson(
      Map<String, Object?> json) {
    final cellsJson = json['cells'];
    final cells = (cellsJson as List<Object?>)
        .map((item) =>
            NotebookDocumentSyncOptionsNotebookSelector2Cells.fromJson(
                item as Map<String, Object?>))
        .toList();
    final notebookJson = json['notebook'];
    final notebook = notebookJson == null
        ? null
        : _eitherNotebookDocumentFilter1NotebookDocumentFilter2NotebookDocumentFilter3String(
            notebookJson);
    return NotebookDocumentSyncOptionsNotebookSelector2(
      cells: cells,
      notebook: notebook,
    );
  }
}

class NotebookDocumentSyncOptionsNotebookSelector2Cells implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentSyncOptionsNotebookSelector2Cells.canParse,
    NotebookDocumentSyncOptionsNotebookSelector2Cells.fromJson,
  );

  final String language;

  NotebookDocumentSyncOptionsNotebookSelector2Cells({
    required this.language,
  });

  @override
  int get hashCode => language.hashCode;

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentSyncOptionsNotebookSelector2Cells &&
        other.runtimeType ==
            NotebookDocumentSyncOptionsNotebookSelector2Cells &&
        language == other.language;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['language'] = language;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseString(obj, reporter, 'language',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type NotebookDocumentSyncOptionsNotebookSelector2Cells');
      return false;
    }
  }

  static NotebookDocumentSyncOptionsNotebookSelector2Cells fromJson(
      Map<String, Object?> json) {
    final languageJson = json['language'];
    final language = languageJson as String;
    return NotebookDocumentSyncOptionsNotebookSelector2Cells(
      language: language,
    );
  }
}

class NotebookDocumentSyncOptionsNotebookSelectorCells implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentSyncOptionsNotebookSelectorCells.canParse,
    NotebookDocumentSyncOptionsNotebookSelectorCells.fromJson,
  );

  final String language;

  NotebookDocumentSyncOptionsNotebookSelectorCells({
    required this.language,
  });

  @override
  int get hashCode => language.hashCode;

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentSyncOptionsNotebookSelectorCells &&
        other.runtimeType == NotebookDocumentSyncOptionsNotebookSelectorCells &&
        language == other.language;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['language'] = language;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseString(obj, reporter, 'language',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type NotebookDocumentSyncOptionsNotebookSelectorCells');
      return false;
    }
  }

  static NotebookDocumentSyncOptionsNotebookSelectorCells fromJson(
      Map<String, Object?> json) {
    final languageJson = json['language'];
    final language = languageJson as String;
    return NotebookDocumentSyncOptionsNotebookSelectorCells(
      language: language,
    );
  }
}

/// Registration options specific to a notebook.
///
/// @since 3.17.0
class NotebookDocumentSyncRegistrationOptions
    implements
        NotebookDocumentSyncOptions,
        StaticRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    NotebookDocumentSyncRegistrationOptions.canParse,
    NotebookDocumentSyncRegistrationOptions.fromJson,
  );

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  /// The notebooks to be synced
  @override
  final List<
      Either2<NotebookDocumentSyncOptionsNotebookSelector,
          NotebookDocumentSyncOptionsNotebookSelector2>> notebookSelector;

  /// Whether save notification should be forwarded to the server. Will only be
  /// honored if mode === `notebook`.
  @override
  final bool? save;
  NotebookDocumentSyncRegistrationOptions({
    this.id,
    required this.notebookSelector,
    this.save,
  });
  @override
  int get hashCode => Object.hash(
        id,
        lspHashCode(notebookSelector),
        save,
      );

  @override
  bool operator ==(Object other) {
    return other is NotebookDocumentSyncRegistrationOptions &&
        other.runtimeType == NotebookDocumentSyncRegistrationOptions &&
        id == other.id &&
        const DeepCollectionEquality()
            .equals(notebookSelector, other.notebookSelector) &&
        save == other.save;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (id != null) {
      result['id'] = id;
    }
    result['notebookSelector'] = notebookSelector;
    if (save != null) {
      result['save'] = save;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListNotebookDocumentSyncOptionsNotebookSelectorNotebookDocumentSyncOptionsNotebookSelector2(
          obj, reporter, 'notebookSelector',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'save',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type NotebookDocumentSyncRegistrationOptions');
      return false;
    }
  }

  static NotebookDocumentSyncRegistrationOptions fromJson(
      Map<String, Object?> json) {
    final idJson = json['id'];
    final id = idJson as String?;
    final notebookSelectorJson = json['notebookSelector'];
    final notebookSelector = (notebookSelectorJson as List<Object?>)
        .map((item) =>
            _eitherNotebookDocumentSyncOptionsNotebookSelectorNotebookDocumentSyncOptionsNotebookSelector2(
                item))
        .toList();
    final saveJson = json['save'];
    final save = saveJson as bool?;
    return NotebookDocumentSyncRegistrationOptions(
      id: id,
      notebookSelector: notebookSelector,
      save: save,
    );
  }
}

/// A text document identifier to optionally denote a specific version of a text
/// document.
class OptionalVersionedTextDocumentIdentifier
    implements TextDocumentIdentifier, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    OptionalVersionedTextDocumentIdentifier.canParse,
    OptionalVersionedTextDocumentIdentifier.fromJson,
  );

  /// The text document's uri.
  @override
  final DocumentUri uri;

  /// The version number of this document. If a versioned text document
  /// identifier is sent from the server to the client and the file is not open
  /// in the editor (the server has not received an open notification before)
  /// the server can send `null` to indicate that the version is unknown and the
  /// content on disk is the truth (as specified with document content
  /// ownership).
  final int? version;

  OptionalVersionedTextDocumentIdentifier({
    required this.uri,
    this.version,
  });
  @override
  int get hashCode => Object.hash(
        uri,
        version,
      );

  @override
  bool operator ==(Object other) {
    return other is OptionalVersionedTextDocumentIdentifier &&
        other.runtimeType == OptionalVersionedTextDocumentIdentifier &&
        uri == other.uri &&
        version == other.version;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['uri'] = uri.toString();
    result['version'] = version;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseInt(obj, reporter, 'version',
          allowsUndefined: false, allowsNull: true);
    } else {
      reporter.reportError(
          'must be of type OptionalVersionedTextDocumentIdentifier');
      return false;
    }
  }

  static OptionalVersionedTextDocumentIdentifier fromJson(
      Map<String, Object?> json) {
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    final versionJson = json['version'];
    final version = versionJson as int?;
    return OptionalVersionedTextDocumentIdentifier(
      uri: uri,
      version: version,
    );
  }
}

/// Represents a parameter of a callable-signature. A parameter can have a label
/// and a doc-comment.
class ParameterInformation implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ParameterInformation.canParse,
    ParameterInformation.fromJson,
  );

  /// The human-readable doc-comment of this parameter. Will be shown in the UI
  /// but can be omitted.
  final Either2<MarkupContent, String>? documentation;

  /// The label of this parameter information.
  ///
  /// Either a string or an inclusive start and exclusive end offsets within its
  /// containing signature label. (see SignatureInformation.label). The offsets
  /// are based on a UTF-16 string representation as `Position` and `Range`
  /// does.
  ///
  /// *Note*: a label of type string should be a substring of its containing
  /// signature label. Its intended use case is to highlight the parameter label
  /// part in the `SignatureInformation.label`.
  final String label;

  ParameterInformation({
    this.documentation,
    required this.label,
  });
  @override
  int get hashCode => Object.hash(
        documentation,
        label,
      );

  @override
  bool operator ==(Object other) {
    return other is ParameterInformation &&
        other.runtimeType == ParameterInformation &&
        documentation == other.documentation &&
        label == other.label;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (documentation != null) {
      result['documentation'] = documentation;
    }
    result['label'] = label;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseMarkupContentString(obj, reporter, 'documentation',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'label',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type ParameterInformation');
      return false;
    }
  }

  static ParameterInformation fromJson(Map<String, Object?> json) {
    final documentationJson = json['documentation'];
    final documentation = documentationJson == null
        ? null
        : _eitherMarkupContentString(documentationJson);
    final labelJson = json['label'];
    final label = labelJson as String;
    return ParameterInformation(
      documentation: documentation,
      label: label,
    );
  }
}

class PartialResultParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    PartialResultParams.canParse,
    PartialResultParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  final ProgressToken? partialResultToken;

  PartialResultParams({
    this.partialResultToken,
  });

  @override
  int get hashCode => partialResultToken.hashCode;

  @override
  bool operator ==(Object other) {
    return other is PartialResultParams &&
        other.runtimeType == PartialResultParams &&
        partialResultToken == other.partialResultToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type PartialResultParams');
      return false;
    }
  }

  static PartialResultParams fromJson(Map<String, Object?> json) {
    if (CodeActionParams.canParse(json, nullLspJsonReporter)) {
      return CodeActionParams.fromJson(json);
    }
    if (ColorPresentationParams.canParse(json, nullLspJsonReporter)) {
      return ColorPresentationParams.fromJson(json);
    }
    if (SelectionRangeParams.canParse(json, nullLspJsonReporter)) {
      return SelectionRangeParams.fromJson(json);
    }
    if (SemanticTokensDeltaParams.canParse(json, nullLspJsonReporter)) {
      return SemanticTokensDeltaParams.fromJson(json);
    }
    if (SemanticTokensRangeParams.canParse(json, nullLspJsonReporter)) {
      return SemanticTokensRangeParams.fromJson(json);
    }
    if (DocumentDiagnosticParams.canParse(json, nullLspJsonReporter)) {
      return DocumentDiagnosticParams.fromJson(json);
    }
    if (WorkspaceDiagnosticParams.canParse(json, nullLspJsonReporter)) {
      return WorkspaceDiagnosticParams.fromJson(json);
    }
    if (CallHierarchyIncomingCallsParams.canParse(json, nullLspJsonReporter)) {
      return CallHierarchyIncomingCallsParams.fromJson(json);
    }
    if (CallHierarchyOutgoingCallsParams.canParse(json, nullLspJsonReporter)) {
      return CallHierarchyOutgoingCallsParams.fromJson(json);
    }
    if (CodeLensParams.canParse(json, nullLspJsonReporter)) {
      return CodeLensParams.fromJson(json);
    }
    if (DocumentColorParams.canParse(json, nullLspJsonReporter)) {
      return DocumentColorParams.fromJson(json);
    }
    if (DocumentLinkParams.canParse(json, nullLspJsonReporter)) {
      return DocumentLinkParams.fromJson(json);
    }
    if (DocumentSymbolParams.canParse(json, nullLspJsonReporter)) {
      return DocumentSymbolParams.fromJson(json);
    }
    if (FoldingRangeParams.canParse(json, nullLspJsonReporter)) {
      return FoldingRangeParams.fromJson(json);
    }
    if (ReferenceParams.canParse(json, nullLspJsonReporter)) {
      return ReferenceParams.fromJson(json);
    }
    if (SemanticTokensParams.canParse(json, nullLspJsonReporter)) {
      return SemanticTokensParams.fromJson(json);
    }
    if (TypeHierarchySubtypesParams.canParse(json, nullLspJsonReporter)) {
      return TypeHierarchySubtypesParams.fromJson(json);
    }
    if (TypeHierarchySupertypesParams.canParse(json, nullLspJsonReporter)) {
      return TypeHierarchySupertypesParams.fromJson(json);
    }
    if (WorkspaceSymbolParams.canParse(json, nullLspJsonReporter)) {
      return WorkspaceSymbolParams.fromJson(json);
    }
    if (CompletionParams.canParse(json, nullLspJsonReporter)) {
      return CompletionParams.fromJson(json);
    }
    if (DeclarationParams.canParse(json, nullLspJsonReporter)) {
      return DeclarationParams.fromJson(json);
    }
    if (DefinitionParams.canParse(json, nullLspJsonReporter)) {
      return DefinitionParams.fromJson(json);
    }
    if (DocumentHighlightParams.canParse(json, nullLspJsonReporter)) {
      return DocumentHighlightParams.fromJson(json);
    }
    if (ImplementationParams.canParse(json, nullLspJsonReporter)) {
      return ImplementationParams.fromJson(json);
    }
    if (MonikerParams.canParse(json, nullLspJsonReporter)) {
      return MonikerParams.fromJson(json);
    }
    if (TypeDefinitionParams.canParse(json, nullLspJsonReporter)) {
      return TypeDefinitionParams.fromJson(json);
    }
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    return PartialResultParams(
      partialResultToken: partialResultToken,
    );
  }
}

/// Position in a text document expressed as zero-based line and character
/// offset. Prior to 3.17 the offsets were always based on a UTF-16 string
/// representation. So a string of the form `a𐐀b` the character offset of the
/// character `a` is 0, the character offset of `𐐀` is 1 and the character
/// offset of b is 3 since `𐐀` is represented using two code units in UTF-16.
/// Since 3.17 clients and servers can agree on a different string encoding
/// representation (e.g. UTF-8). The client announces it's supported encoding
/// via the client capability
/// [`general.positionEncodings`](https://microsoft.github.io/language-server-protocol/specifications/specification-current/#clientCapabilities).
/// The value is an array of position encodings the client supports, with
/// decreasing preference (e.g. the encoding at index `0` is the most preferred
/// one). To stay backwards compatible the only mandatory encoding is UTF-16
/// represented via the string `utf-16`. The server can pick one of the
/// encodings offered by the client and signals that encoding back to the client
/// via the initialize result's property
/// [`capabilities.positionEncoding`](https://microsoft.github.io/language-server-protocol/specifications/specification-current/#serverCapabilities).
/// If the string value `utf-16` is missing from the client's capability
/// `general.positionEncodings` servers can safely assume that the client
/// supports UTF-16. If the server omits the position encoding in its initialize
/// result the encoding defaults to the string value `utf-16`. Implementation
/// considerations: since the conversion from one encoding into another requires
/// the content of the file / line the conversion is best done where the file is
/// read which is usually on the server side.
///
/// Positions are line end character agnostic. So you can not specify a position
/// that denotes `\r|\n` or `\n|` where `|` represents the character offset.
///
/// @since 3.17.0 - support for negotiated position encoding.
class Position implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    Position.canParse,
    Position.fromJson,
  );

  /// Character offset on a line in a document (zero-based).
  ///
  /// The meaning of this offset is determined by the negotiated
  /// `PositionEncodingKind`.
  ///
  /// If the character value is greater than the line length it defaults back to
  /// the line length.
  final int character;

  /// Line position in a document (zero-based).
  ///
  /// If a line number is greater than the number of lines in a document, it
  /// defaults back to the number of lines in the document. If a line number is
  /// negative, it defaults to 0.
  final int line;

  Position({
    required this.character,
    required this.line,
  });
  @override
  int get hashCode => Object.hash(
        character,
        line,
      );

  @override
  bool operator ==(Object other) {
    return other is Position &&
        other.runtimeType == Position &&
        character == other.character &&
        line == other.line;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['character'] = character;
    result['line'] = line;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseInt(obj, reporter, 'character',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseInt(obj, reporter, 'line',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type Position');
      return false;
    }
  }

  static Position fromJson(Map<String, Object?> json) {
    final characterJson = json['character'];
    final character = characterJson as int;
    final lineJson = json['line'];
    final line = lineJson as int;
    return Position(
      character: character,
      line: line,
    );
  }
}

/// A set of predefined position encoding kinds.
///
/// @since 3.17.0
class PositionEncodingKind implements ToJsonable {
  /// Character offsets count UTF-16 code units.
  ///
  /// This is the default and must always be supported by servers
  static const UTF16 = PositionEncodingKind('utf-16');

  /// Character offsets count UTF-32 code units.
  ///
  /// Implementation note: these are the same as Unicode codepoints,
  /// so this `PositionEncodingKind` may also be used for an encoding-agnostic
  /// representation of character offsets.
  static const UTF32 = PositionEncodingKind('utf-32');

  /// Character offsets count UTF-8 code units (e.g. bytes).
  static const UTF8 = PositionEncodingKind('utf-8');

  final String _value;
  const PositionEncodingKind(this._value);
  const PositionEncodingKind.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is PositionEncodingKind && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is String;
}

class PrepareRenameParams
    implements TextDocumentPositionParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    PrepareRenameParams.canParse,
    PrepareRenameParams.fromJson,
  );

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  PrepareRenameParams({
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is PrepareRenameParams &&
        other.runtimeType == PrepareRenameParams &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type PrepareRenameParams');
      return false;
    }
  }

  static PrepareRenameParams fromJson(Map<String, Object?> json) {
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return PrepareRenameParams(
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

class PrepareRenamePlaceholder implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    PrepareRenamePlaceholder.canParse,
    PrepareRenamePlaceholder.fromJson,
  );

  final String placeholder;

  final Range range;

  PrepareRenamePlaceholder({
    required this.placeholder,
    required this.range,
  });
  @override
  int get hashCode => Object.hash(
        placeholder,
        range,
      );

  @override
  bool operator ==(Object other) {
    return other is PrepareRenamePlaceholder &&
        other.runtimeType == PrepareRenamePlaceholder &&
        placeholder == other.placeholder &&
        range == other.range;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['placeholder'] = placeholder;
    result['range'] = range.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'placeholder',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type PrepareRenamePlaceholder');
      return false;
    }
  }

  static PrepareRenamePlaceholder fromJson(Map<String, Object?> json) {
    final placeholderJson = json['placeholder'];
    final placeholder = placeholderJson as String;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    return PrepareRenamePlaceholder(
      placeholder: placeholder,
      range: range,
    );
  }
}

class PrepareRenameResult2 implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    PrepareRenameResult2.canParse,
    PrepareRenameResult2.fromJson,
  );

  final bool defaultBehavior;

  PrepareRenameResult2({
    required this.defaultBehavior,
  });

  @override
  int get hashCode => defaultBehavior.hashCode;

  @override
  bool operator ==(Object other) {
    return other is PrepareRenameResult2 &&
        other.runtimeType == PrepareRenameResult2 &&
        defaultBehavior == other.defaultBehavior;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['defaultBehavior'] = defaultBehavior;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'defaultBehavior',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type PrepareRenameResult2');
      return false;
    }
  }

  static PrepareRenameResult2 fromJson(Map<String, Object?> json) {
    final defaultBehaviorJson = json['defaultBehavior'];
    final defaultBehavior = defaultBehaviorJson as bool;
    return PrepareRenameResult2(
      defaultBehavior: defaultBehavior,
    );
  }
}

class PrepareSupportDefaultBehavior implements ToJsonable {
  /// The client's default behavior is to select the identifier according the to
  /// language's syntax rule.
  static const Identifier = PrepareSupportDefaultBehavior(1);
  final int _value;

  const PrepareSupportDefaultBehavior(this._value);

  const PrepareSupportDefaultBehavior.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is PrepareSupportDefaultBehavior && other._value == _value;

  @override
  int toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is int;
}

/// A previous result id in a workspace pull request.
///
/// @since 3.17.0
class PreviousResultId implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    PreviousResultId.canParse,
    PreviousResultId.fromJson,
  );

  /// The URI for which the client knowns a result id.
  final DocumentUri uri;

  /// The value of the previous result id.
  final String value;

  PreviousResultId({
    required this.uri,
    required this.value,
  });
  @override
  int get hashCode => Object.hash(
        uri,
        value,
      );

  @override
  bool operator ==(Object other) {
    return other is PreviousResultId &&
        other.runtimeType == PreviousResultId &&
        uri == other.uri &&
        value == other.value;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['uri'] = uri.toString();
    result['value'] = value;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'value',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type PreviousResultId');
      return false;
    }
  }

  static PreviousResultId fromJson(Map<String, Object?> json) {
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    final valueJson = json['value'];
    final value = valueJson as String;
    return PreviousResultId(
      uri: uri,
      value: value,
    );
  }
}

class ProgressParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ProgressParams.canParse,
    ProgressParams.fromJson,
  );

  /// The progress token provided by the client or server.
  final ProgressToken token;

  /// The progress data.
  final LSPAny value;

  ProgressParams({
    required this.token,
    this.value,
  });
  @override
  int get hashCode => Object.hash(
        token,
        value,
      );

  @override
  bool operator ==(Object other) {
    return other is ProgressParams &&
        other.runtimeType == ProgressParams &&
        token == other.token &&
        value == other.value;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['token'] = token;
    result['value'] = value;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseIntString(obj, reporter, 'token',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type ProgressParams');
      return false;
    }
  }

  static ProgressParams fromJson(Map<String, Object?> json) {
    final tokenJson = json['token'];
    final token = _eitherIntString(tokenJson);
    final valueJson = json['value'];
    final value = valueJson;
    return ProgressParams(
      token: token,
      value: value,
    );
  }
}

/// The publish diagnostic client capabilities.
class PublishDiagnosticsClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    PublishDiagnosticsClientCapabilities.canParse,
    PublishDiagnosticsClientCapabilities.fromJson,
  );

  /// Client supports a codeDescription property
  ///
  /// @since 3.16.0
  final bool? codeDescriptionSupport;

  /// Whether code action supports the `data` property which is preserved
  /// between a `textDocument/publishDiagnostics` and `textDocument/codeAction`
  /// request.
  ///
  /// @since 3.16.0
  final bool? dataSupport;

  /// Whether the clients accepts diagnostics with related information.
  final bool? relatedInformation;

  /// Client supports the tag property to provide meta data about a diagnostic.
  /// Clients supporting tags have to handle unknown tags gracefully.
  ///
  /// @since 3.15.0
  final PublishDiagnosticsClientCapabilitiesTagSupport? tagSupport;

  /// Whether the client interprets the version property of the
  /// `textDocument/publishDiagnostics` notification's parameter.
  ///
  /// @since 3.15.0
  final bool? versionSupport;
  PublishDiagnosticsClientCapabilities({
    this.codeDescriptionSupport,
    this.dataSupport,
    this.relatedInformation,
    this.tagSupport,
    this.versionSupport,
  });
  @override
  int get hashCode => Object.hash(
        codeDescriptionSupport,
        dataSupport,
        relatedInformation,
        tagSupport,
        versionSupport,
      );

  @override
  bool operator ==(Object other) {
    return other is PublishDiagnosticsClientCapabilities &&
        other.runtimeType == PublishDiagnosticsClientCapabilities &&
        codeDescriptionSupport == other.codeDescriptionSupport &&
        dataSupport == other.dataSupport &&
        relatedInformation == other.relatedInformation &&
        tagSupport == other.tagSupport &&
        versionSupport == other.versionSupport;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (codeDescriptionSupport != null) {
      result['codeDescriptionSupport'] = codeDescriptionSupport;
    }
    if (dataSupport != null) {
      result['dataSupport'] = dataSupport;
    }
    if (relatedInformation != null) {
      result['relatedInformation'] = relatedInformation;
    }
    if (tagSupport != null) {
      result['tagSupport'] = tagSupport?.toJson();
    }
    if (versionSupport != null) {
      result['versionSupport'] = versionSupport;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'codeDescriptionSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'dataSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'relatedInformation',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParsePublishDiagnosticsClientCapabilitiesTagSupport(
          obj, reporter, 'tagSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'versionSupport',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type PublishDiagnosticsClientCapabilities');
      return false;
    }
  }

  static PublishDiagnosticsClientCapabilities fromJson(
      Map<String, Object?> json) {
    final codeDescriptionSupportJson = json['codeDescriptionSupport'];
    final codeDescriptionSupport = codeDescriptionSupportJson as bool?;
    final dataSupportJson = json['dataSupport'];
    final dataSupport = dataSupportJson as bool?;
    final relatedInformationJson = json['relatedInformation'];
    final relatedInformation = relatedInformationJson as bool?;
    final tagSupportJson = json['tagSupport'];
    final tagSupport = tagSupportJson != null
        ? PublishDiagnosticsClientCapabilitiesTagSupport.fromJson(
            tagSupportJson as Map<String, Object?>)
        : null;
    final versionSupportJson = json['versionSupport'];
    final versionSupport = versionSupportJson as bool?;
    return PublishDiagnosticsClientCapabilities(
      codeDescriptionSupport: codeDescriptionSupport,
      dataSupport: dataSupport,
      relatedInformation: relatedInformation,
      tagSupport: tagSupport,
      versionSupport: versionSupport,
    );
  }
}

class PublishDiagnosticsClientCapabilitiesTagSupport implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    PublishDiagnosticsClientCapabilitiesTagSupport.canParse,
    PublishDiagnosticsClientCapabilitiesTagSupport.fromJson,
  );

  /// The tags supported by the client.
  final List<DiagnosticTag> valueSet;

  PublishDiagnosticsClientCapabilitiesTagSupport({
    required this.valueSet,
  });

  @override
  int get hashCode => lspHashCode(valueSet);

  @override
  bool operator ==(Object other) {
    return other is PublishDiagnosticsClientCapabilitiesTagSupport &&
        other.runtimeType == PublishDiagnosticsClientCapabilitiesTagSupport &&
        const DeepCollectionEquality().equals(valueSet, other.valueSet);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['valueSet'] = valueSet.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListDiagnosticTag(obj, reporter, 'valueSet',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type PublishDiagnosticsClientCapabilitiesTagSupport');
      return false;
    }
  }

  static PublishDiagnosticsClientCapabilitiesTagSupport fromJson(
      Map<String, Object?> json) {
    final valueSetJson = json['valueSet'];
    final valueSet = (valueSetJson as List<Object?>)
        .map((item) => DiagnosticTag.fromJson(item as int))
        .toList();
    return PublishDiagnosticsClientCapabilitiesTagSupport(
      valueSet: valueSet,
    );
  }
}

/// The publish diagnostic notification's parameters.
class PublishDiagnosticsParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    PublishDiagnosticsParams.canParse,
    PublishDiagnosticsParams.fromJson,
  );

  /// An array of diagnostic information items.
  final List<Diagnostic> diagnostics;

  /// The URI for which diagnostic information is reported.
  final DocumentUri uri;

  /// Optional the version number of the document the diagnostics are published
  /// for.
  ///
  /// @since 3.15.0
  final int? version;
  PublishDiagnosticsParams({
    required this.diagnostics,
    required this.uri,
    this.version,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(diagnostics),
        uri,
        version,
      );

  @override
  bool operator ==(Object other) {
    return other is PublishDiagnosticsParams &&
        other.runtimeType == PublishDiagnosticsParams &&
        const DeepCollectionEquality().equals(diagnostics, other.diagnostics) &&
        uri == other.uri &&
        version == other.version;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['diagnostics'] = diagnostics.map((item) => item.toJson()).toList();
    result['uri'] = uri.toString();
    if (version != null) {
      result['version'] = version;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListDiagnostic(obj, reporter, 'diagnostics',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseUri(obj, reporter, 'uri',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseInt(obj, reporter, 'version',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type PublishDiagnosticsParams');
      return false;
    }
  }

  static PublishDiagnosticsParams fromJson(Map<String, Object?> json) {
    final diagnosticsJson = json['diagnostics'];
    final diagnostics = (diagnosticsJson as List<Object?>)
        .map((item) => Diagnostic.fromJson(item as Map<String, Object?>))
        .toList();
    final uriJson = json['uri'];
    final uri = Uri.parse(uriJson as String);
    final versionJson = json['version'];
    final version = versionJson as int?;
    return PublishDiagnosticsParams(
      diagnostics: diagnostics,
      uri: uri,
      version: version,
    );
  }
}

/// A range in a text document expressed as (zero-based) start and end
/// positions.
///
/// If you want to specify a range that contains a line including the line
/// ending character(s) then use an end position denoting the start of the next
/// line. For example:
/// ```ts
/// {
///     start: { line: 5, character: 23 }
///     end : { line 6, character : 0 }
/// }
/// ```
class Range implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    Range.canParse,
    Range.fromJson,
  );

  /// The range's end position.
  final Position end;

  /// The range's start position.
  final Position start;

  Range({
    required this.end,
    required this.start,
  });
  @override
  int get hashCode => Object.hash(
        end,
        start,
      );

  @override
  bool operator ==(Object other) {
    return other is Range &&
        other.runtimeType == Range &&
        end == other.end &&
        start == other.start;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['end'] = end.toJson();
    result['start'] = start.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParsePosition(obj, reporter, 'end',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParsePosition(obj, reporter, 'start',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type Range');
      return false;
    }
  }

  static Range fromJson(Map<String, Object?> json) {
    final endJson = json['end'];
    final end = Position.fromJson(endJson as Map<String, Object?>);
    final startJson = json['start'];
    final start = Position.fromJson(startJson as Map<String, Object?>);
    return Range(
      end: end,
      start: start,
    );
  }
}

/// Client Capabilities for a [ReferencesRequest].
class ReferenceClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ReferenceClientCapabilities.canParse,
    ReferenceClientCapabilities.fromJson,
  );

  /// Whether references supports dynamic registration.
  final bool? dynamicRegistration;

  ReferenceClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is ReferenceClientCapabilities &&
        other.runtimeType == ReferenceClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ReferenceClientCapabilities');
      return false;
    }
  }

  static ReferenceClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return ReferenceClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

/// Value-object that contains additional information when requesting
/// references.
class ReferenceContext implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ReferenceContext.canParse,
    ReferenceContext.fromJson,
  );

  /// Include the declaration of the current symbol.
  final bool includeDeclaration;

  ReferenceContext({
    required this.includeDeclaration,
  });

  @override
  int get hashCode => includeDeclaration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is ReferenceContext &&
        other.runtimeType == ReferenceContext &&
        includeDeclaration == other.includeDeclaration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['includeDeclaration'] = includeDeclaration;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'includeDeclaration',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type ReferenceContext');
      return false;
    }
  }

  static ReferenceContext fromJson(Map<String, Object?> json) {
    final includeDeclarationJson = json['includeDeclaration'];
    final includeDeclaration = includeDeclarationJson as bool;
    return ReferenceContext(
      includeDeclaration: includeDeclaration,
    );
  }
}

/// Reference options.
class ReferenceOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ReferenceOptions.canParse,
    ReferenceOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  ReferenceOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is ReferenceOptions &&
        other.runtimeType == ReferenceOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ReferenceOptions');
      return false;
    }
  }

  static ReferenceOptions fromJson(Map<String, Object?> json) {
    if (ReferenceRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return ReferenceRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return ReferenceOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// Parameters for a [ReferencesRequest].
class ReferenceParams
    implements
        PartialResultParams,
        TextDocumentPositionParams,
        WorkDoneProgressParams,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ReferenceParams.canParse,
    ReferenceParams.fromJson,
  );

  final ReferenceContext context;

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The position inside the text document.
  @override
  final Position position;

  /// The text document.
  @override
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  ReferenceParams({
    required this.context,
    this.partialResultToken,
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        context,
        partialResultToken,
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is ReferenceParams &&
        other.runtimeType == ReferenceParams &&
        context == other.context &&
        partialResultToken == other.partialResultToken &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['context'] = context.toJson();
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseReferenceContext(obj, reporter, 'context',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ReferenceParams');
      return false;
    }
  }

  static ReferenceParams fromJson(Map<String, Object?> json) {
    final contextJson = json['context'];
    final context =
        ReferenceContext.fromJson(contextJson as Map<String, Object?>);
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return ReferenceParams(
      context: context,
      partialResultToken: partialResultToken,
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [ReferencesRequest].
class ReferenceRegistrationOptions
    implements ReferenceOptions, TextDocumentRegistrationOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ReferenceRegistrationOptions.canParse,
    ReferenceRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  @override
  final bool? workDoneProgress;

  ReferenceRegistrationOptions({
    this.documentSelector,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is ReferenceRegistrationOptions &&
        other.runtimeType == ReferenceRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type ReferenceRegistrationOptions');
      return false;
    }
  }

  static ReferenceRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return ReferenceRegistrationOptions(
      documentSelector: documentSelector,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// General parameters to register for a notification or to register a provider.
class Registration implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    Registration.canParse,
    Registration.fromJson,
  );

  /// The id used to register the request. The id can be used to deregister the
  /// request again.
  final String id;

  /// The method / capability to register for.
  final String method;

  /// Options necessary for the registration.
  final LSPAny registerOptions;
  Registration({
    required this.id,
    required this.method,
    this.registerOptions,
  });
  @override
  int get hashCode => Object.hash(
        id,
        method,
        registerOptions,
      );

  @override
  bool operator ==(Object other) {
    return other is Registration &&
        other.runtimeType == Registration &&
        id == other.id &&
        method == other.method &&
        registerOptions == other.registerOptions;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['id'] = id;
    result['method'] = method;
    if (registerOptions != null) {
      result['registerOptions'] = registerOptions;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'method',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type Registration');
      return false;
    }
  }

  static Registration fromJson(Map<String, Object?> json) {
    final idJson = json['id'];
    final id = idJson as String;
    final methodJson = json['method'];
    final method = methodJson as String;
    final registerOptionsJson = json['registerOptions'];
    final registerOptions = registerOptionsJson;
    return Registration(
      id: id,
      method: method,
      registerOptions: registerOptions,
    );
  }
}

class RegistrationParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RegistrationParams.canParse,
    RegistrationParams.fromJson,
  );

  final List<Registration> registrations;

  RegistrationParams({
    required this.registrations,
  });

  @override
  int get hashCode => lspHashCode(registrations);

  @override
  bool operator ==(Object other) {
    return other is RegistrationParams &&
        other.runtimeType == RegistrationParams &&
        const DeepCollectionEquality()
            .equals(registrations, other.registrations);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['registrations'] =
        registrations.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListRegistration(obj, reporter, 'registrations',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type RegistrationParams');
      return false;
    }
  }

  static RegistrationParams fromJson(Map<String, Object?> json) {
    final registrationsJson = json['registrations'];
    final registrations = (registrationsJson as List<Object?>)
        .map((item) => Registration.fromJson(item as Map<String, Object?>))
        .toList();
    return RegistrationParams(
      registrations: registrations,
    );
  }
}

/// Client capabilities specific to regular expressions.
///
/// @since 3.16.0
class RegularExpressionsClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RegularExpressionsClientCapabilities.canParse,
    RegularExpressionsClientCapabilities.fromJson,
  );

  /// The engine's name.
  final String engine;

  /// The engine's version.
  final String? version;

  RegularExpressionsClientCapabilities({
    required this.engine,
    this.version,
  });
  @override
  int get hashCode => Object.hash(
        engine,
        version,
      );

  @override
  bool operator ==(Object other) {
    return other is RegularExpressionsClientCapabilities &&
        other.runtimeType == RegularExpressionsClientCapabilities &&
        engine == other.engine &&
        version == other.version;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['engine'] = engine;
    if (version != null) {
      result['version'] = version;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'engine',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'version',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type RegularExpressionsClientCapabilities');
      return false;
    }
  }

  static RegularExpressionsClientCapabilities fromJson(
      Map<String, Object?> json) {
    final engineJson = json['engine'];
    final engine = engineJson as String;
    final versionJson = json['version'];
    final version = versionJson as String?;
    return RegularExpressionsClientCapabilities(
      engine: engine,
      version: version,
    );
  }
}

/// A full diagnostic report with a set of related documents.
///
/// @since 3.17.0
class RelatedFullDocumentDiagnosticReport
    implements FullDocumentDiagnosticReport, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RelatedFullDocumentDiagnosticReport.canParse,
    RelatedFullDocumentDiagnosticReport.fromJson,
  );

  /// The actual items.
  @override
  final List<Diagnostic> items;

  /// A full document diagnostic report.
  @override
  final String kind;

  /// Diagnostics of related documents. This information is useful in
  /// programming languages where code in a file A can generate diagnostics in a
  /// file B which A depends on. An example of such a language is C/C++ where
  /// marco definitions in a file a.cpp and result in errors in a header file
  /// b.hpp.
  ///
  /// @since 3.17.0
  final Map<
      DocumentUri,
      Either2<FullDocumentDiagnosticReport,
          UnchangedDocumentDiagnosticReport>>? relatedDocuments;

  /// An optional result id. If provided it will be sent on the next diagnostic
  /// request for the same document.
  @override
  final String? resultId;
  RelatedFullDocumentDiagnosticReport({
    required this.items,
    this.kind = 'full',
    this.relatedDocuments,
    this.resultId,
  }) {
    if (kind != 'full') {
      throw 'kind may only be the literal \'full\'';
    }
  }
  @override
  int get hashCode => Object.hash(
        lspHashCode(items),
        kind,
        lspHashCode(relatedDocuments),
        resultId,
      );

  @override
  bool operator ==(Object other) {
    return other is RelatedFullDocumentDiagnosticReport &&
        other.runtimeType == RelatedFullDocumentDiagnosticReport &&
        const DeepCollectionEquality().equals(items, other.items) &&
        kind == other.kind &&
        const DeepCollectionEquality()
            .equals(relatedDocuments, other.relatedDocuments) &&
        resultId == other.resultId;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['items'] = items.map((item) => item.toJson()).toList();
    result['kind'] = kind;
    if (relatedDocuments != null) {
      result['relatedDocuments'] = relatedDocuments
          ?.map((key, value) => MapEntry(key.toString(), value));
    }
    if (resultId != null) {
      result['resultId'] = resultId;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListDiagnostic(obj, reporter, 'items',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseLiteral(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false, literal: 'full')) {
        return false;
      }
      if (!_canParseMapUriFullDocumentDiagnosticReportUnchangedDocumentDiagnosticReport(
          obj, reporter, 'relatedDocuments',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'resultId',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter
          .reportError('must be of type RelatedFullDocumentDiagnosticReport');
      return false;
    }
  }

  static RelatedFullDocumentDiagnosticReport fromJson(
      Map<String, Object?> json) {
    final itemsJson = json['items'];
    final items = (itemsJson as List<Object?>)
        .map((item) => Diagnostic.fromJson(item as Map<String, Object?>))
        .toList();
    final kindJson = json['kind'];
    final kind = kindJson as String;
    final relatedDocumentsJson = json['relatedDocuments'];
    final relatedDocuments = (relatedDocumentsJson as Map<Object, Object?>?)
        ?.map((key, value) => MapEntry(
            Uri.parse(key as String),
            _eitherFullDocumentDiagnosticReportUnchangedDocumentDiagnosticReport(
                value)));
    final resultIdJson = json['resultId'];
    final resultId = resultIdJson as String?;
    return RelatedFullDocumentDiagnosticReport(
      items: items,
      kind: kind,
      relatedDocuments: relatedDocuments,
      resultId: resultId,
    );
  }
}

/// An unchanged diagnostic report with a set of related documents.
///
/// @since 3.17.0
class RelatedUnchangedDocumentDiagnosticReport
    implements UnchangedDocumentDiagnosticReport, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RelatedUnchangedDocumentDiagnosticReport.canParse,
    RelatedUnchangedDocumentDiagnosticReport.fromJson,
  );

  /// A document diagnostic report indicating no changes to the last result. A
  /// server can only return `unchanged` if result ids are provided.
  @override
  final String kind;

  /// Diagnostics of related documents. This information is useful in
  /// programming languages where code in a file A can generate diagnostics in a
  /// file B which A depends on. An example of such a language is C/C++ where
  /// marco definitions in a file a.cpp and result in errors in a header file
  /// b.hpp.
  ///
  /// @since 3.17.0
  final Map<
      DocumentUri,
      Either2<FullDocumentDiagnosticReport,
          UnchangedDocumentDiagnosticReport>>? relatedDocuments;

  /// A result id which will be sent on the next diagnostic request for the same
  /// document.
  @override
  final String resultId;
  RelatedUnchangedDocumentDiagnosticReport({
    this.kind = 'unchanged',
    this.relatedDocuments,
    required this.resultId,
  }) {
    if (kind != 'unchanged') {
      throw 'kind may only be the literal \'unchanged\'';
    }
  }
  @override
  int get hashCode => Object.hash(
        kind,
        lspHashCode(relatedDocuments),
        resultId,
      );

  @override
  bool operator ==(Object other) {
    return other is RelatedUnchangedDocumentDiagnosticReport &&
        other.runtimeType == RelatedUnchangedDocumentDiagnosticReport &&
        kind == other.kind &&
        const DeepCollectionEquality()
            .equals(relatedDocuments, other.relatedDocuments) &&
        resultId == other.resultId;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['kind'] = kind;
    if (relatedDocuments != null) {
      result['relatedDocuments'] = relatedDocuments
          ?.map((key, value) => MapEntry(key.toString(), value));
    }
    result['resultId'] = resultId;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseLiteral(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false, literal: 'unchanged')) {
        return false;
      }
      if (!_canParseMapUriFullDocumentDiagnosticReportUnchangedDocumentDiagnosticReport(
          obj, reporter, 'relatedDocuments',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'resultId',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError(
          'must be of type RelatedUnchangedDocumentDiagnosticReport');
      return false;
    }
  }

  static RelatedUnchangedDocumentDiagnosticReport fromJson(
      Map<String, Object?> json) {
    final kindJson = json['kind'];
    final kind = kindJson as String;
    final relatedDocumentsJson = json['relatedDocuments'];
    final relatedDocuments = (relatedDocumentsJson as Map<Object, Object?>?)
        ?.map((key, value) => MapEntry(
            Uri.parse(key as String),
            _eitherFullDocumentDiagnosticReportUnchangedDocumentDiagnosticReport(
                value)));
    final resultIdJson = json['resultId'];
    final resultId = resultIdJson as String;
    return RelatedUnchangedDocumentDiagnosticReport(
      kind: kind,
      relatedDocuments: relatedDocuments,
      resultId: resultId,
    );
  }
}

/// A relative pattern is a helper to construct glob patterns that are matched
/// relatively to a base URI. The common value for a `baseUri` is a workspace
/// folder root, but it can be another absolute URI as well.
///
/// @since 3.17.0
class RelativePattern implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RelativePattern.canParse,
    RelativePattern.fromJson,
  );

  /// A workspace folder or a base URI to which this pattern will be matched
  /// against relatively.
  final Either2<LSPUri, WorkspaceFolder> baseUri;

  /// The actual glob pattern;
  final LspPattern pattern;

  RelativePattern({
    required this.baseUri,
    required this.pattern,
  });
  @override
  int get hashCode => Object.hash(
        baseUri,
        pattern,
      );

  @override
  bool operator ==(Object other) {
    return other is RelativePattern &&
        other.runtimeType == RelativePattern &&
        baseUri == other.baseUri &&
        pattern == other.pattern;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['baseUri'] = baseUri;
    result['pattern'] = pattern;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseUriWorkspaceFolder(obj, reporter, 'baseUri',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'pattern',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type RelativePattern');
      return false;
    }
  }

  static RelativePattern fromJson(Map<String, Object?> json) {
    final baseUriJson = json['baseUri'];
    final baseUri = _eitherUriWorkspaceFolder(baseUriJson);
    final patternJson = json['pattern'];
    final pattern = patternJson as String;
    return RelativePattern(
      baseUri: baseUri,
      pattern: pattern,
    );
  }
}

class RenameClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RenameClientCapabilities.canParse,
    RenameClientCapabilities.fromJson,
  );

  /// Whether rename supports dynamic registration.
  final bool? dynamicRegistration;

  /// Whether the client honors the change annotations in text edits and
  /// resource operations returned via the rename request's workspace edit by
  /// for example presenting the workspace edit in the user interface and asking
  /// for confirmation.
  ///
  /// @since 3.16.0
  final bool? honorsChangeAnnotations;

  /// Client supports testing for validity of rename operations before
  /// execution.
  ///
  /// @since 3.12.0
  final bool? prepareSupport;

  /// Client supports the default behavior result.
  ///
  /// The value indicates the default behavior used by the client.
  ///
  /// @since 3.16.0
  final PrepareSupportDefaultBehavior? prepareSupportDefaultBehavior;
  RenameClientCapabilities({
    this.dynamicRegistration,
    this.honorsChangeAnnotations,
    this.prepareSupport,
    this.prepareSupportDefaultBehavior,
  });
  @override
  int get hashCode => Object.hash(
        dynamicRegistration,
        honorsChangeAnnotations,
        prepareSupport,
        prepareSupportDefaultBehavior,
      );

  @override
  bool operator ==(Object other) {
    return other is RenameClientCapabilities &&
        other.runtimeType == RenameClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration &&
        honorsChangeAnnotations == other.honorsChangeAnnotations &&
        prepareSupport == other.prepareSupport &&
        prepareSupportDefaultBehavior == other.prepareSupportDefaultBehavior;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    if (honorsChangeAnnotations != null) {
      result['honorsChangeAnnotations'] = honorsChangeAnnotations;
    }
    if (prepareSupport != null) {
      result['prepareSupport'] = prepareSupport;
    }
    if (prepareSupportDefaultBehavior != null) {
      result['prepareSupportDefaultBehavior'] =
          prepareSupportDefaultBehavior?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'honorsChangeAnnotations',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'prepareSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParsePrepareSupportDefaultBehavior(
          obj, reporter, 'prepareSupportDefaultBehavior',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type RenameClientCapabilities');
      return false;
    }
  }

  static RenameClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final honorsChangeAnnotationsJson = json['honorsChangeAnnotations'];
    final honorsChangeAnnotations = honorsChangeAnnotationsJson as bool?;
    final prepareSupportJson = json['prepareSupport'];
    final prepareSupport = prepareSupportJson as bool?;
    final prepareSupportDefaultBehaviorJson =
        json['prepareSupportDefaultBehavior'];
    final prepareSupportDefaultBehavior =
        prepareSupportDefaultBehaviorJson != null
            ? PrepareSupportDefaultBehavior.fromJson(
                prepareSupportDefaultBehaviorJson as int)
            : null;
    return RenameClientCapabilities(
      dynamicRegistration: dynamicRegistration,
      honorsChangeAnnotations: honorsChangeAnnotations,
      prepareSupport: prepareSupport,
      prepareSupportDefaultBehavior: prepareSupportDefaultBehavior,
    );
  }
}

/// Rename file operation
class RenameFile implements ResourceOperation, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RenameFile.canParse,
    RenameFile.fromJson,
  );

  /// An optional annotation identifier describing the operation.
  ///
  /// @since 3.16.0
  @override
  final ChangeAnnotationIdentifier? annotationId;

  /// A rename
  @override
  final String kind;

  /// The new location.
  final DocumentUri newUri;

  /// The old (existing) location.
  final DocumentUri oldUri;

  /// Rename options.
  final RenameFileOptions? options;
  RenameFile({
    this.annotationId,
    this.kind = 'rename',
    required this.newUri,
    required this.oldUri,
    this.options,
  }) {
    if (kind != 'rename') {
      throw 'kind may only be the literal \'rename\'';
    }
  }
  @override
  int get hashCode => Object.hash(
        annotationId,
        kind,
        newUri,
        oldUri,
        options,
      );

  @override
  bool operator ==(Object other) {
    return other is RenameFile &&
        other.runtimeType == RenameFile &&
        annotationId == other.annotationId &&
        kind == other.kind &&
        newUri == other.newUri &&
        oldUri == other.oldUri &&
        options == other.options;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (annotationId != null) {
      result['annotationId'] = annotationId;
    }
    result['kind'] = kind;
    result['newUri'] = newUri.toString();
    result['oldUri'] = oldUri.toString();
    if (options != null) {
      result['options'] = options?.toJson();
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'annotationId',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseLiteral(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false, literal: 'rename')) {
        return false;
      }
      if (!_canParseUri(obj, reporter, 'newUri',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseUri(obj, reporter, 'oldUri',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseRenameFileOptions(obj, reporter, 'options',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type RenameFile');
      return false;
    }
  }

  static RenameFile fromJson(Map<String, Object?> json) {
    final annotationIdJson = json['annotationId'];
    final annotationId = annotationIdJson as String?;
    final kindJson = json['kind'];
    final kind = kindJson as String;
    final newUriJson = json['newUri'];
    final newUri = Uri.parse(newUriJson as String);
    final oldUriJson = json['oldUri'];
    final oldUri = Uri.parse(oldUriJson as String);
    final optionsJson = json['options'];
    final options = optionsJson != null
        ? RenameFileOptions.fromJson(optionsJson as Map<String, Object?>)
        : null;
    return RenameFile(
      annotationId: annotationId,
      kind: kind,
      newUri: newUri,
      oldUri: oldUri,
      options: options,
    );
  }
}

/// Rename file options
class RenameFileOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RenameFileOptions.canParse,
    RenameFileOptions.fromJson,
  );

  /// Ignores if target exists.
  final bool? ignoreIfExists;

  /// Overwrite target if existing. Overwrite wins over `ignoreIfExists`
  final bool? overwrite;

  RenameFileOptions({
    this.ignoreIfExists,
    this.overwrite,
  });
  @override
  int get hashCode => Object.hash(
        ignoreIfExists,
        overwrite,
      );

  @override
  bool operator ==(Object other) {
    return other is RenameFileOptions &&
        other.runtimeType == RenameFileOptions &&
        ignoreIfExists == other.ignoreIfExists &&
        overwrite == other.overwrite;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (ignoreIfExists != null) {
      result['ignoreIfExists'] = ignoreIfExists;
    }
    if (overwrite != null) {
      result['overwrite'] = overwrite;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'ignoreIfExists',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'overwrite',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type RenameFileOptions');
      return false;
    }
  }

  static RenameFileOptions fromJson(Map<String, Object?> json) {
    final ignoreIfExistsJson = json['ignoreIfExists'];
    final ignoreIfExists = ignoreIfExistsJson as bool?;
    final overwriteJson = json['overwrite'];
    final overwrite = overwriteJson as bool?;
    return RenameFileOptions(
      ignoreIfExists: ignoreIfExists,
      overwrite: overwrite,
    );
  }
}

/// The parameters sent in notifications/requests for user-initiated renames of
/// files.
///
/// @since 3.16.0
class RenameFilesParams implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RenameFilesParams.canParse,
    RenameFilesParams.fromJson,
  );

  /// An array of all files/folders renamed in this operation. When a folder is
  /// renamed, only the folder will be included, and not its children.
  final List<FileRename> files;

  RenameFilesParams({
    required this.files,
  });

  @override
  int get hashCode => lspHashCode(files);

  @override
  bool operator ==(Object other) {
    return other is RenameFilesParams &&
        other.runtimeType == RenameFilesParams &&
        const DeepCollectionEquality().equals(files, other.files);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['files'] = files.map((item) => item.toJson()).toList();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseListFileRename(obj, reporter, 'files',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type RenameFilesParams');
      return false;
    }
  }

  static RenameFilesParams fromJson(Map<String, Object?> json) {
    final filesJson = json['files'];
    final files = (filesJson as List<Object?>)
        .map((item) => FileRename.fromJson(item as Map<String, Object?>))
        .toList();
    return RenameFilesParams(
      files: files,
    );
  }
}

/// Provider options for a [RenameRequest].
class RenameOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RenameOptions.canParse,
    RenameOptions.fromJson,
  );

  /// Renames should be checked and tested before being executed.
  ///
  /// @since version 3.12.0
  final bool? prepareProvider;

  @override
  final bool? workDoneProgress;

  RenameOptions({
    this.prepareProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        prepareProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is RenameOptions &&
        other.runtimeType == RenameOptions &&
        prepareProvider == other.prepareProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (prepareProvider != null) {
      result['prepareProvider'] = prepareProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'prepareProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type RenameOptions');
      return false;
    }
  }

  static RenameOptions fromJson(Map<String, Object?> json) {
    if (RenameRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return RenameRegistrationOptions.fromJson(json);
    }
    final prepareProviderJson = json['prepareProvider'];
    final prepareProvider = prepareProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return RenameOptions(
      prepareProvider: prepareProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// The parameters of a [RenameRequest].
class RenameParams implements WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RenameParams.canParse,
    RenameParams.fromJson,
  );

  /// The new name of the symbol. If the given name is not valid the request
  /// must return a [ResponseError] with an appropriate message set.
  final String newName;

  /// The position at which this request was sent.
  final Position position;

  /// The document to rename.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  RenameParams({
    required this.newName,
    required this.position,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        newName,
        position,
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is RenameParams &&
        other.runtimeType == RenameParams &&
        newName == other.newName &&
        position == other.position &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['newName'] = newName;
    result['position'] = position.toJson();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'newName',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParsePosition(obj, reporter, 'position',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type RenameParams');
      return false;
    }
  }

  static RenameParams fromJson(Map<String, Object?> json) {
    final newNameJson = json['newName'];
    final newName = newNameJson as String;
    final positionJson = json['position'];
    final position = Position.fromJson(positionJson as Map<String, Object?>);
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return RenameParams(
      newName: newName,
      position: position,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

/// Registration options for a [RenameRequest].
class RenameRegistrationOptions
    implements RenameOptions, TextDocumentRegistrationOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    RenameRegistrationOptions.canParse,
    RenameRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// Renames should be checked and tested before being executed.
  ///
  /// @since version 3.12.0
  @override
  final bool? prepareProvider;

  @override
  final bool? workDoneProgress;
  RenameRegistrationOptions({
    this.documentSelector,
    this.prepareProvider,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        prepareProvider,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is RenameRegistrationOptions &&
        other.runtimeType == RenameRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        prepareProvider == other.prepareProvider &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (prepareProvider != null) {
      result['prepareProvider'] = prepareProvider;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'prepareProvider',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type RenameRegistrationOptions');
      return false;
    }
  }

  static RenameRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final prepareProviderJson = json['prepareProvider'];
    final prepareProvider = prepareProviderJson as bool?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return RenameRegistrationOptions(
      documentSelector: documentSelector,
      prepareProvider: prepareProvider,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// A generic resource operation.
class ResourceOperation implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    ResourceOperation.canParse,
    ResourceOperation.fromJson,
  );

  /// An optional annotation identifier describing the operation.
  ///
  /// @since 3.16.0
  final ChangeAnnotationIdentifier? annotationId;

  /// The resource operation kind.
  final String kind;

  ResourceOperation({
    this.annotationId,
    required this.kind,
  });
  @override
  int get hashCode => Object.hash(
        annotationId,
        kind,
      );

  @override
  bool operator ==(Object other) {
    return other is ResourceOperation &&
        other.runtimeType == ResourceOperation &&
        annotationId == other.annotationId &&
        kind == other.kind;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (annotationId != null) {
      result['annotationId'] = annotationId;
    }
    result['kind'] = kind;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseString(obj, reporter, 'annotationId',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'kind',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type ResourceOperation');
      return false;
    }
  }

  static ResourceOperation fromJson(Map<String, Object?> json) {
    if (RenameFile.canParse(json, nullLspJsonReporter)) {
      return RenameFile.fromJson(json);
    }
    if (CreateFile.canParse(json, nullLspJsonReporter)) {
      return CreateFile.fromJson(json);
    }
    if (DeleteFile.canParse(json, nullLspJsonReporter)) {
      return DeleteFile.fromJson(json);
    }
    final annotationIdJson = json['annotationId'];
    final annotationId = annotationIdJson as String?;
    final kindJson = json['kind'];
    final kind = kindJson as String;
    return ResourceOperation(
      annotationId: annotationId,
      kind: kind,
    );
  }
}

class ResourceOperationKind implements ToJsonable {
  /// Supports creating new files and folders.
  static const Create = ResourceOperationKind._('create');

  /// Supports deleting existing files and folders.
  static const Delete = ResourceOperationKind._('delete');

  /// Supports renaming existing files and folders.
  static const Rename = ResourceOperationKind._('rename');

  final String _value;
  const ResourceOperationKind.fromJson(this._value);
  const ResourceOperationKind._(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is ResourceOperationKind && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    switch (obj) {
      case 'create':
      case 'delete':
      case 'rename':
        return true;
    }
    return false;
  }
}

/// Save options.
class SaveOptions implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    SaveOptions.canParse,
    SaveOptions.fromJson,
  );

  /// The client is supposed to include the content on save.
  final bool? includeText;

  SaveOptions({
    this.includeText,
  });

  @override
  int get hashCode => includeText.hashCode;

  @override
  bool operator ==(Object other) {
    return other is SaveOptions &&
        other.runtimeType == SaveOptions &&
        includeText == other.includeText;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (includeText != null) {
      result['includeText'] = includeText;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'includeText',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type SaveOptions');
      return false;
    }
  }

  static SaveOptions fromJson(Map<String, Object?> json) {
    if (TextDocumentSaveRegistrationOptions.canParse(
        json, nullLspJsonReporter)) {
      return TextDocumentSaveRegistrationOptions.fromJson(json);
    }
    final includeTextJson = json['includeText'];
    final includeText = includeTextJson as bool?;
    return SaveOptions(
      includeText: includeText,
    );
  }
}

/// A selection range represents a part of a selection hierarchy. A selection
/// range may have a parent selection range that contains it.
class SelectionRange implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    SelectionRange.canParse,
    SelectionRange.fromJson,
  );

  /// The parent selection range containing this range. Therefore `parent.range`
  /// must contain `this.range`.
  final SelectionRange? parent;

  /// The [Range] of this selection range.
  final Range range;

  SelectionRange({
    this.parent,
    required this.range,
  });
  @override
  int get hashCode => Object.hash(
        parent,
        range,
      );

  @override
  bool operator ==(Object other) {
    return other is SelectionRange &&
        other.runtimeType == SelectionRange &&
        parent == other.parent &&
        range == other.range;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (parent != null) {
      result['parent'] = parent?.toJson();
    }
    result['range'] = range.toJson();
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseSelectionRange(obj, reporter, 'parent',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseRange(obj, reporter, 'range',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type SelectionRange');
      return false;
    }
  }

  static SelectionRange fromJson(Map<String, Object?> json) {
    final parentJson = json['parent'];
    final parent = parentJson != null
        ? SelectionRange.fromJson(parentJson as Map<String, Object?>)
        : null;
    final rangeJson = json['range'];
    final range = Range.fromJson(rangeJson as Map<String, Object?>);
    return SelectionRange(
      parent: parent,
      range: range,
    );
  }
}

class SelectionRangeClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    SelectionRangeClientCapabilities.canParse,
    SelectionRangeClientCapabilities.fromJson,
  );

  /// Whether implementation supports dynamic registration for selection range
  /// providers. If this is set to `true` the client supports the new
  /// `SelectionRangeRegistrationOptions` return value for the corresponding
  /// server capability as well.
  final bool? dynamicRegistration;

  SelectionRangeClientCapabilities({
    this.dynamicRegistration,
  });

  @override
  int get hashCode => dynamicRegistration.hashCode;

  @override
  bool operator ==(Object other) {
    return other is SelectionRangeClientCapabilities &&
        other.runtimeType == SelectionRangeClientCapabilities &&
        dynamicRegistration == other.dynamicRegistration;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type SelectionRangeClientCapabilities');
      return false;
    }
  }

  static SelectionRangeClientCapabilities fromJson(Map<String, Object?> json) {
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    return SelectionRangeClientCapabilities(
      dynamicRegistration: dynamicRegistration,
    );
  }
}

class SelectionRangeOptions implements WorkDoneProgressOptions, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    SelectionRangeOptions.canParse,
    SelectionRangeOptions.fromJson,
  );

  @override
  final bool? workDoneProgress;

  SelectionRangeOptions({
    this.workDoneProgress,
  });

  @override
  int get hashCode => workDoneProgress.hashCode;

  @override
  bool operator ==(Object other) {
    return other is SelectionRangeOptions &&
        other.runtimeType == SelectionRangeOptions &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type SelectionRangeOptions');
      return false;
    }
  }

  static SelectionRangeOptions fromJson(Map<String, Object?> json) {
    if (SelectionRangeRegistrationOptions.canParse(json, nullLspJsonReporter)) {
      return SelectionRangeRegistrationOptions.fromJson(json);
    }
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return SelectionRangeOptions(
      workDoneProgress: workDoneProgress,
    );
  }
}

/// A parameter literal used in selection range requests.
class SelectionRangeParams
    implements PartialResultParams, WorkDoneProgressParams, ToJsonable {
  static const jsonHandler = LspJsonHandler(
    SelectionRangeParams.canParse,
    SelectionRangeParams.fromJson,
  );

  /// An optional token that a server can use to report partial results (e.g.
  /// streaming) to the client.
  @override
  final ProgressToken? partialResultToken;

  /// The positions inside the text document.
  final List<Position> positions;

  /// The text document.
  final TextDocumentIdentifier textDocument;

  /// An optional token that a server can use to report work done progress.
  @override
  final ProgressToken? workDoneToken;
  SelectionRangeParams({
    this.partialResultToken,
    required this.positions,
    required this.textDocument,
    this.workDoneToken,
  });
  @override
  int get hashCode => Object.hash(
        partialResultToken,
        lspHashCode(positions),
        textDocument,
        workDoneToken,
      );

  @override
  bool operator ==(Object other) {
    return other is SelectionRangeParams &&
        other.runtimeType == SelectionRangeParams &&
        partialResultToken == other.partialResultToken &&
        const DeepCollectionEquality().equals(positions, other.positions) &&
        textDocument == other.textDocument &&
        workDoneToken == other.workDoneToken;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (partialResultToken != null) {
      result['partialResultToken'] = partialResultToken;
    }
    result['positions'] = positions.map((item) => item.toJson()).toList();
    result['textDocument'] = textDocument.toJson();
    if (workDoneToken != null) {
      result['workDoneToken'] = workDoneToken;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseIntString(obj, reporter, 'partialResultToken',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListPosition(obj, reporter, 'positions',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseTextDocumentIdentifier(obj, reporter, 'textDocument',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseIntString(obj, reporter, 'workDoneToken',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type SelectionRangeParams');
      return false;
    }
  }

  static SelectionRangeParams fromJson(Map<String, Object?> json) {
    final partialResultTokenJson = json['partialResultToken'];
    final partialResultToken = partialResultTokenJson == null
        ? null
        : _eitherIntString(partialResultTokenJson);
    final positionsJson = json['positions'];
    final positions = (positionsJson as List<Object?>)
        .map((item) => Position.fromJson(item as Map<String, Object?>))
        .toList();
    final textDocumentJson = json['textDocument'];
    final textDocument = TextDocumentIdentifier.fromJson(
        textDocumentJson as Map<String, Object?>);
    final workDoneTokenJson = json['workDoneToken'];
    final workDoneToken =
        workDoneTokenJson == null ? null : _eitherIntString(workDoneTokenJson);
    return SelectionRangeParams(
      partialResultToken: partialResultToken,
      positions: positions,
      textDocument: textDocument,
      workDoneToken: workDoneToken,
    );
  }
}

class SelectionRangeRegistrationOptions
    implements
        SelectionRangeOptions,
        StaticRegistrationOptions,
        TextDocumentRegistrationOptions,
        ToJsonable {
  static const jsonHandler = LspJsonHandler(
    SelectionRangeRegistrationOptions.canParse,
    SelectionRangeRegistrationOptions.fromJson,
  );

  /// A document selector to identify the scope of the registration. If set to
  /// null the document selector provided on the client side will be used.
  @override
  final List<TextDocumentFilterScheme>? documentSelector;

  /// The id used to register the request. The id can be used to deregister the
  /// request again. See also Registration#id.
  @override
  final String? id;

  @override
  final bool? workDoneProgress;
  SelectionRangeRegistrationOptions({
    this.documentSelector,
    this.id,
    this.workDoneProgress,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(documentSelector),
        id,
        workDoneProgress,
      );

  @override
  bool operator ==(Object other) {
    return other is SelectionRangeRegistrationOptions &&
        other.runtimeType == SelectionRangeRegistrationOptions &&
        const DeepCollectionEquality()
            .equals(documentSelector, other.documentSelector) &&
        id == other.id &&
        workDoneProgress == other.workDoneProgress;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['documentSelector'] = documentSelector;
    if (id != null) {
      result['id'] = id;
    }
    if (workDoneProgress != null) {
      result['workDoneProgress'] = workDoneProgress;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListTextDocumentFilterScheme(
          obj, reporter, 'documentSelector',
          allowsUndefined: false, allowsNull: true)) {
        return false;
      }
      if (!_canParseString(obj, reporter, 'id',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      return _canParseBool(obj, reporter, 'workDoneProgress',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type SelectionRangeRegistrationOptions');
      return false;
    }
  }

  static SelectionRangeRegistrationOptions fromJson(Map<String, Object?> json) {
    final documentSelectorJson = json['documentSelector'];
    final documentSelector = (documentSelectorJson as List<Object?>?)
        ?.map((item) =>
            TextDocumentFilterScheme.fromJson(item as Map<String, Object?>))
        .toList();
    final idJson = json['id'];
    final id = idJson as String?;
    final workDoneProgressJson = json['workDoneProgress'];
    final workDoneProgress = workDoneProgressJson as bool?;
    return SelectionRangeRegistrationOptions(
      documentSelector: documentSelector,
      id: id,
      workDoneProgress: workDoneProgress,
    );
  }
}

/// A set of predefined token modifiers. This set is not fixed an clients can
/// specify additional token types via the corresponding client capabilities.
///
/// @since 3.16.0
class SemanticTokenModifiers implements ToJsonable {
  static const abstract = SemanticTokenModifiers('abstract');
  static const async = SemanticTokenModifiers('async');

  static const declaration = SemanticTokenModifiers('declaration');

  static const defaultLibrary = SemanticTokenModifiers('defaultLibrary');
  static const definition = SemanticTokenModifiers('definition');
  static const deprecated = SemanticTokenModifiers('deprecated');
  static const documentation = SemanticTokenModifiers('documentation');
  static const modification = SemanticTokenModifiers('modification');
  static const readonly = SemanticTokenModifiers('readonly');
  static const static = SemanticTokenModifiers('static');
  final String _value;
  const SemanticTokenModifiers(this._value);
  const SemanticTokenModifiers.fromJson(this._value);
  @override
  int get hashCode => _value.hashCode;

  @override
  bool operator ==(Object other) =>
      other is SemanticTokenModifiers && other._value == _value;

  @override
  String toJson() => _value;

  @override
  String toString() => _value.toString();

  static bool canParse(Object? obj, LspJsonReporter reporter) => obj is String;
}

/// @since 3.16.0
class SemanticTokens implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    SemanticTokens.canParse,
    SemanticTokens.fromJson,
  );

  /// The actual tokens.
  final List<int> data;

  /// An optional result id. If provided and clients support delta updating the
  /// client will include the result id in the next semantic token request. A
  /// server can then instead of computing all semantic tokens again simply send
  /// a delta.
  final String? resultId;

  SemanticTokens({
    required this.data,
    this.resultId,
  });
  @override
  int get hashCode => Object.hash(
        lspHashCode(data),
        resultId,
      );

  @override
  bool operator ==(Object other) {
    return other is SemanticTokens &&
        other.runtimeType == SemanticTokens &&
        const DeepCollectionEquality().equals(data, other.data) &&
        resultId == other.resultId;
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    result['data'] = data;
    if (resultId != null) {
      result['resultId'] = resultId;
    }
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseListInt(obj, reporter, 'data',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseString(obj, reporter, 'resultId',
          allowsUndefined: true, allowsNull: false);
    } else {
      reporter.reportError('must be of type SemanticTokens');
      return false;
    }
  }

  static SemanticTokens fromJson(Map<String, Object?> json) {
    final dataJson = json['data'];
    final data =
        (dataJson as List<Object?>).map((item) => item as int).toList();
    final resultIdJson = json['resultId'];
    final resultId = resultIdJson as String?;
    return SemanticTokens(
      data: data,
      resultId: resultId,
    );
  }
}

/// @since 3.16.0
class SemanticTokensClientCapabilities implements ToJsonable {
  static const jsonHandler = LspJsonHandler(
    SemanticTokensClientCapabilities.canParse,
    SemanticTokensClientCapabilities.fromJson,
  );

  /// Whether the client uses semantic tokens to augment existing syntax tokens.
  /// If set to `true` client side created syntax tokens and semantic tokens are
  /// both used for colorization. If set to `false` the client only uses the
  /// returned semantic tokens for colorization.
  ///
  /// If the value is `undefined` then the client behavior is not specified.
  ///
  /// @since 3.17.0
  final bool? augmentsSyntaxTokens;

  /// Whether implementation supports dynamic registration. If this is set to
  /// `true` the client supports the new `(TextDocumentRegistrationOptions &
  /// StaticRegistrationOptions)` return value for the corresponding server
  /// capability as well.
  final bool? dynamicRegistration;

  /// The token formats the clients supports.
  final List<TokenFormat> formats;

  /// Whether the client supports tokens that can span multiple lines.
  final bool? multilineTokenSupport;

  /// Whether the client supports tokens that can overlap each other.
  final bool? overlappingTokenSupport;

  /// Which requests the client supports and might send to the server depending
  /// on the server's capability. Please note that clients might not show
  /// semantic tokens or degrade some of the user experience if a range or full
  /// request is advertised by the client but not provided by the server. If for
  /// example the client capability `requests.full` and `request.range` are both
  /// set to true but the server only provides a range provider the client might
  /// not render a minimap correctly or might even decide to not show any
  /// semantic tokens at all.
  final ClientSemanticTokensRequestOptions requests;

  /// Whether the client allows the server to actively cancel a semantic token
  /// request, e.g. supports returning LSPErrorCodes.ServerCancelled. If a
  /// server does the client needs to retrigger the request.
  ///
  /// @since 3.17.0
  final bool? serverCancelSupport;

  /// The token modifiers that the client supports.
  final List<String> tokenModifiers;

  /// The token types that the client supports.
  final List<String> tokenTypes;
  SemanticTokensClientCapabilities({
    this.augmentsSyntaxTokens,
    this.dynamicRegistration,
    required this.formats,
    this.multilineTokenSupport,
    this.overlappingTokenSupport,
    required this.requests,
    this.serverCancelSupport,
    required this.tokenModifiers,
    required this.tokenTypes,
  });
  @override
  int get hashCode => Object.hash(
        augmentsSyntaxTokens,
        dynamicRegistration,
        lspHashCode(formats),
        multilineTokenSupport,
        overlappingTokenSupport,
        requests,
        serverCancelSupport,
        lspHashCode(tokenModifiers),
        lspHashCode(tokenTypes),
      );

  @override
  bool operator ==(Object other) {
    return other is SemanticTokensClientCapabilities &&
        other.runtimeType == SemanticTokensClientCapabilities &&
        augmentsSyntaxTokens == other.augmentsSyntaxTokens &&
        dynamicRegistration == other.dynamicRegistration &&
        const DeepCollectionEquality().equals(formats, other.formats) &&
        multilineTokenSupport == other.multilineTokenSupport &&
        overlappingTokenSupport == other.overlappingTokenSupport &&
        requests == other.requests &&
        serverCancelSupport == other.serverCancelSupport &&
        const DeepCollectionEquality()
            .equals(tokenModifiers, other.tokenModifiers) &&
        const DeepCollectionEquality().equals(tokenTypes, other.tokenTypes);
  }

  @override
  Map<String, Object?> toJson() {
    var result = <String, Object?>{};
    if (augmentsSyntaxTokens != null) {
      result['augmentsSyntaxTokens'] = augmentsSyntaxTokens;
    }
    if (dynamicRegistration != null) {
      result['dynamicRegistration'] = dynamicRegistration;
    }
    result['formats'] = formats.map((item) => item.toJson()).toList();
    if (multilineTokenSupport != null) {
      result['multilineTokenSupport'] = multilineTokenSupport;
    }
    if (overlappingTokenSupport != null) {
      result['overlappingTokenSupport'] = overlappingTokenSupport;
    }
    result['requests'] = requests.toJson();
    if (serverCancelSupport != null) {
      result['serverCancelSupport'] = serverCancelSupport;
    }
    result['tokenModifiers'] = tokenModifiers;
    result['tokenTypes'] = tokenTypes;
    return result;
  }

  @override
  String toString() => jsonEncoder.convert(toJson());

  static bool canParse(Object? obj, LspJsonReporter reporter) {
    if (obj is Map<String, Object?>) {
      if (!_canParseBool(obj, reporter, 'augmentsSyntaxTokens',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'dynamicRegistration',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListTokenFormat(obj, reporter, 'formats',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'multilineTokenSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'overlappingTokenSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseClientSemanticTokensRequestOptions(
          obj, reporter, 'requests',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      if (!_canParseBool(obj, reporter, 'serverCancelSupport',
          allowsUndefined: true, allowsNull: false)) {
        return false;
      }
      if (!_canParseListString(obj, reporter, 'tokenModifiers',
          allowsUndefined: false, allowsNull: false)) {
        return false;
      }
      return _canParseListString(obj, reporter, 'tokenTypes',
          allowsUndefined: false, allowsNull: false);
    } else {
      reporter.reportError('must be of type SemanticTokensClientCapabilities');
      return false;
    }
  }

  static SemanticTokensClientCapabilities fromJson(Map<String, Object?> json) {
    final augmentsSyntaxTokensJson = json['augmentsSyntaxTokens'];
    final augmentsSyntaxTokens = augmentsSyntaxTokensJson as bool?;
    final dynamicRegistrationJson = json['dynamicRegistration'];
    final dynamicRegistration = dynamicRegistrationJson as bool?;
    final formatsJson = json['formats'];
    final formats = (formatsJson as List<Object?>)
        .map((item) => TokenFormat.fromJson(item as String))
        .toList();
    final multilineTokenSupportJson =