// Generated by package:messages_builder.

// ignore_for_file: library_prefixes, non_constant_identifier_names
// ignore_for_file: unused_import

import 'package:intl/intl.dart';
import 'package:messages/messages_json.dart';

import 'my_app_de_DE_empty.g.dart' deferred as my_app_de_DE_empty;
import 'my_app_en_US_empty.g.dart' deferred as my_app_en_US_empty;

class MyAppMessages {
  MyAppMessages(this._assetLoader);

  final Future<String> Function(String id) _assetLoader;

  String _currentLocale = 'en_US';

  final Map<String, MessageList> _messages = {};

  static const _dataFiles = {
    'de_DE': (
      'packages/my_application/assets/messages_de.arb.json',
      'xXViKglj'
    ),
    'en_US': ('packages/my_application/assets/messages.arb.json', 'h/qGCx3k')
  };

  String get currentLocale => _currentLocale;

  MessageList get _currentMessages => _messages[currentLocale]!;

  static Iterable<String> get knownLocales => _dataFiles.keys;

  Future<void> loadLocale(String locale) async {
    if (!_messages.containsKey(locale)) {
      final info = _dataFiles[locale];
      final dataFile = info?.$1;
      if (dataFile == null) {
        throw ArgumentError('Locale $locale is not in $knownLocales');
      }
      if (locale == 'de_DE') {
        await my_app_de_DE_empty.loadLibrary();
      } else if (locale == 'en_US') {
        await my_app_en_US_empty.loadLibrary();
      }

      final data = await _assetLoader(dataFile);
      final messageList = MessageListJson.fromString(data, _pluralSelector);
      if (messageList.preamble.hash != info?.$2) {
        throw ArgumentError('''
              Messages file for locale $locale has different hash "${messageList.preamble.hash}" than generated code "${info?.$2}".''');
      }
      _messages[locale] = messageList;
    }
    _currentLocale = locale;
  }

  Future<void> loadAllLocales() async {
    for (final locale in knownLocales) {
      await loadLocale(locale);
    }
  }

  String current_sale_name(String arg) =>
      _currentMessages.generateStringAtIndex(0, [arg]);
}

Message _pluralSelector(
  num howMany,
  String locale, {
  required Message other,
  Message? few,
  Message? many,
  Map<int, Message>? numberCases,
  Map<int, Message>? wordCases,
}) {
  return Intl.pluralLogic(
    howMany,
    few: few,
    many: many,
    zero: numberCases?[0] ?? wordCases?[0],
    one: numberCases?[1] ?? wordCases?[1],
    two: numberCases?[2] ?? wordCases?[2],
    other: other,
    locale: locale,
  );
}
