## Overview

This repository is home to Dart internationalization (i18n) and localization (l10n) related packages.

## Packages

| Package | Description | Issues | Version |
| --- | --- | --- | --- |
| [intl](pkgs/intl/) | Contains code to deal with internationalized/localized messages, date and number formatting and parsing, bi-directional text, and other internationalization issues. | [![issues](https://img.shields.io/badge/issues-4774bc)][intl_issues] | [![pub package](https://img.shields.io/pub/v/intl.svg)](https://pub.dev/packages/intl) |
| [intl4x](pkgs/intl4x/) | A lightweight modular library for internationalization (i18n) functionality. | [![issues](https://img.shields.io/badge/issues-4774bc)][intl4x_issues] | [![pub package](https://img.shields.io/pub/v/intl4x.svg)](https://pub.dev/packages/intl4x) |
| [intl_translation](pkgs/intl_translation/) | Contains code to deal with internationalized/localized messages, date and number formatting and parsing, bi-directional text, and other internationalization issues. | [![issues](https://img.shields.io/badge/issues-4774bc)][intl_translation_issues] | [![pub package](https://img.shields.io/pub/v/intl_translation.svg)](https://pub.dev/packages/intl_translation) |
| [messages](pkgs/messages/) | A lightweight modular library for localization (l10n) functionality. | [![issues](https://img.shields.io/badge/issues-4774bc)][messages_issues] |  |
| [messages_builder](pkgs/messages_builder/) | Build the messages for consumption by package:messages | [![issues](https://img.shields.io/badge/issues-4774bc)][messages_builder_issues] |  |
| [messages_serializer](pkgs/messages_serializer/) | Serialization of messages for package:messages. | [![issues](https://img.shields.io/badge/issues-4774bc)][messages_serializer_issues] |  |
| [messages_shrinker](pkgs/messages_shrinker/) | Removing unneeded messages from message data files for package:messages. | [![issues](https://img.shields.io/badge/issues-4774bc)][messages_shrinker_issues] | [![pub package](https://img.shields.io/pub/v/messages_shrinker.svg)](https://pub.dev/packages/messages_shrinker) |

[intl_issues]: https://github.com/dart-lang/i18n/issues?q=is%3Aissue+is%3Aopen+label%3Apackage%3Aintl
[intl4x_issues]: https://github.com/dart-lang/i18n/issues?q=is%3Aissue+is%3Aopen+label%3Apackage%3Aintl4x
[intl_translation_issues]: https://github.com/dart-lang/i18n/issues?q=is%3Aissue+is%3Aopen+label%3Apackage%3Aintl_translation
[messages_issues]: https://github.com/dart-lang/i18n/issues?q=is%3Aissue+is%3Aopen+label%3Apackage%3Amessages
[messages_builder_issues]: https://github.com/dart-lang/i18n/issues?q=is%3Aissue+is%3Aopen+label%3Apackage%3Amessages_builder
[messages_serializer_issues]: https://github.com/dart-lang/i18n/issues?q=is%3Aissue+is%3Aopen+label%3Apackage%3Amessages_serializer
[messages_shrinker_issues]: https://github.com/dart-lang/i18n/issues?q=is%3Aissue+is%3Aopen+label%3Apackage%3Amessages_shrinker

## Contribute

Let us know about [bugs and feature requests](https://github.com/dart-lang/i18n/issues), file a [pull request](https://github.com/dart-lang/i18n/pulls), or participate in the [discussions](https://github.com/dart-lang/i18n/discussions)!

## Publishing automation

For information about our publishing automation and release process, see
https://github.com/dart-lang/ecosystem/wiki/Publishing-automation.

For additional information about contributing, see our
[contributing](CONTRIBUTING.md) page.
