## Overview

This repository is home to general Dart Ecosystem tools and packages.

## Packages

| Package | Description | Version |
| --- | --- | --- |
| [blast_repo](pkgs/blast_repo/) | A tool to bulk validate and fix GitHub repos. |  |
| [canary](pkgs/canary/) | Test package upgrades against the ecosystem. |  |
| [corpus](pkgs/corpus/) | A tool to calculate the API usage for a package. |  |
| [dart_flutter_team_lints](pkgs/dart_flutter_team_lints/) | An analysis rule set used by the Dart and Flutter teams. | [![pub package](https://img.shields.io/pub/v/dart_flutter_team_lints.svg)](https://pub.dev/packages/dart_flutter_team_lints) |
| [firehose](pkgs/firehose/) | A tool to automate publishing of Pub packages from GitHub actions. | [![pub package](https://img.shields.io/pub/v/firehose.svg)](https://pub.dev/packages/firehose) |
| [puppy](pkgs/puppy/) | A grab bag of CLI tools for managing Dart code. |  |
| [repo_manage](pkgs/repo_manage/) | Miscellaneous issue, repo, and PR query tools. |  |
| [sdk_triage_bot](pkgs/sdk_triage_bot/) | A triage automation tool for dart-lang/sdk issues. |  |
| [trebuchet](pkgs/trebuchet/) | A tool for moving existing packages into monorepos. |  |

## Dart mono-repos

Here's an overview of the main Dart team repositories:

| Main repo | Description |
| --- | --- |
| [sdk](https://github.com/dart-lang/sdk) | The Dart SDK, including the VM, JS and Wasm compilers, analysis, core libraries, and more. |

| SLO mono-repos | Description |
| --- | --- |
| [core](https://github.com/dart-lang/core) | This repository is home to core Dart packages. |
| [tools](https://github.com/dart-lang/tools) | This repository is home to tooling related Dart packages. |
| [labs](https://github.com/dart-lang/labs) | This repository is home to Dart 'labs' packages. |

| Topic mono-repos | Description |
| --- | --- |
| [build](https://github.com/dart-lang/build) | A build system for Dart written in Dart |
| [ecosystem](https://github.com/dart-lang/ecosystem) | This repository is home to general Dart Ecosystem tools and packages. |
| [http](https://github.com/dart-lang/http) | A composable API for making HTTP requests in Dart. |
| [i18n](https://github.com/dart-lang/i18n) | A general mono-repo for Dart i18n and l10n packages. |
| [leak_tracker](https://github.com/dart-lang/leak_tracker) | A framework for memory leak tracking for Dart and Flutter applications. |
| [macros](https://github.com/dart-lang/macros) | A Dart mono-repo for macro development. |
| [native](https://github.com/dart-lang/native) | Dart packages related to FFI and native assets bundling. |
| [shelf](https://github.com/dart-lang/shelf) | Web server middleware for Dart |
| [test](https://github.com/dart-lang/test) | A library for writing unit tests in Dart. |
| [webdev](https://github.com/dart-lang/webdev) | A CLI for Dart web development. |

## Publishing automation

For information about our publishing automation and release process, see
https://github.com/dart-lang/ecosystem/wiki/Publishing-automation.

For additional information about contributing, see our
[contributing](CONTRIBUTING.md) page.
