#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn AddClusterGroupDependency(hdependentgroup: *const _HGROUP, hprovidergroup: *const _HGROUP) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddClusterGroupDependency(hdependentgroup: *const _HGROUP, hprovidergroup: *const _HGROUP) -> u32;
        }
        ::core::mem::transmute(AddClusterGroupDependency(::core::mem::transmute(hdependentgroup), ::core::mem::transmute(hprovidergroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn AddClusterGroupSetDependency(hdependentgroupset: *const _HGROUPSET, hprovidergroupset: *const _HGROUPSET) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddClusterGroupSetDependency(hdependentgroupset: *const _HGROUPSET, hprovidergroupset: *const _HGROUPSET) -> u32;
        }
        ::core::mem::transmute(AddClusterGroupSetDependency(::core::mem::transmute(hdependentgroupset), ::core::mem::transmute(hprovidergroupset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn AddClusterGroupToGroupSetDependency(hdependentgroup: *const _HGROUP, hprovidergroupset: *const _HGROUPSET) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddClusterGroupToGroupSetDependency(hdependentgroup: *const _HGROUP, hprovidergroupset: *const _HGROUPSET) -> u32;
        }
        ::core::mem::transmute(AddClusterGroupToGroupSetDependency(::core::mem::transmute(hdependentgroup), ::core::mem::transmute(hprovidergroupset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AddClusterNode<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpsznodename: Param1, pfnprogresscallback: PCLUSTER_SETUP_PROGRESS_CALLBACK, pvcallbackarg: *const ::core::ffi::c_void) -> *mut _HNODE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddClusterNode(hcluster: *const _HCLUSTER, lpsznodename: ::windows::core::PCWSTR, pfnprogresscallback: ::windows::core::RawPtr, pvcallbackarg: *const ::core::ffi::c_void) -> *mut _HNODE;
        }
        ::core::mem::transmute(AddClusterNode(::core::mem::transmute(hcluster), lpsznodename.into_param().abi(), ::core::mem::transmute(pfnprogresscallback), ::core::mem::transmute(pvcallbackarg)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AddClusterNodeEx<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpsznodename: Param1, dwflags: u32, pfnprogresscallback: PCLUSTER_SETUP_PROGRESS_CALLBACK, pvcallbackarg: *const ::core::ffi::c_void) -> *mut _HNODE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddClusterNodeEx(hcluster: *const _HCLUSTER, lpsznodename: ::windows::core::PCWSTR, dwflags: u32, pfnprogresscallback: ::windows::core::RawPtr, pvcallbackarg: *const ::core::ffi::c_void) -> *mut _HNODE;
        }
        ::core::mem::transmute(AddClusterNodeEx(::core::mem::transmute(hcluster), lpsznodename.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(pfnprogresscallback), ::core::mem::transmute(pvcallbackarg)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn AddClusterResourceDependency(hresource: *const _HRESOURCE, hdependson: *const _HRESOURCE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddClusterResourceDependency(hresource: *const _HRESOURCE, hdependson: *const _HRESOURCE) -> u32;
        }
        ::core::mem::transmute(AddClusterResourceDependency(::core::mem::transmute(hresource), ::core::mem::transmute(hdependson)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn AddClusterResourceNode(hresource: *const _HRESOURCE, hnode: *const _HNODE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddClusterResourceNode(hresource: *const _HRESOURCE, hnode: *const _HNODE) -> u32;
        }
        ::core::mem::transmute(AddClusterResourceNode(::core::mem::transmute(hresource), ::core::mem::transmute(hnode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AddClusterStorageNode<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param4: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param5: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpsznodename: Param1, pfnprogresscallback: PCLUSTER_SETUP_PROGRESS_CALLBACK, pvcallbackarg: *const ::core::ffi::c_void, lpszclusterstoragenodedescription: Param4, lpszclusterstoragenodelocation: Param5) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddClusterStorageNode(hcluster: *const _HCLUSTER, lpsznodename: ::windows::core::PCWSTR, pfnprogresscallback: ::windows::core::RawPtr, pvcallbackarg: *const ::core::ffi::c_void, lpszclusterstoragenodedescription: ::windows::core::PCWSTR, lpszclusterstoragenodelocation: ::windows::core::PCWSTR) -> u32;
        }
        ::core::mem::transmute(AddClusterStorageNode(::core::mem::transmute(hcluster), lpsznodename.into_param().abi(), ::core::mem::transmute(pfnprogresscallback), ::core::mem::transmute(pvcallbackarg), lpszclusterstoragenodedescription.into_param().abi(), lpszclusterstoragenodelocation.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn AddCrossClusterGroupSetDependency<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hdependentgroupset: *const _HGROUPSET, lpremoteclustername: Param1, lpremotegroupsetname: Param2) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddCrossClusterGroupSetDependency(hdependentgroupset: *const _HGROUPSET, lpremoteclustername: ::windows::core::PCWSTR, lpremotegroupsetname: ::windows::core::PCWSTR) -> u32;
        }
        ::core::mem::transmute(AddCrossClusterGroupSetDependency(::core::mem::transmute(hdependentgroupset), lpremoteclustername.into_param().abi(), lpremotegroupsetname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn AddResourceToClusterSharedVolumes(hresource: *const _HRESOURCE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AddResourceToClusterSharedVolumes(hresource: *const _HRESOURCE) -> u32;
        }
        ::core::mem::transmute(AddResourceToClusterSharedVolumes(::core::mem::transmute(hresource)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn BackupClusterDatabase<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszpathname: Param1) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn BackupClusterDatabase(hcluster: *const _HCLUSTER, lpszpathname: ::windows::core::PCWSTR) -> u32;
        }
        ::core::mem::transmute(BackupClusterDatabase(::core::mem::transmute(hcluster), lpszpathname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const BitLockerDecrypted: i32 = 4i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const BitLockerDecrypting: i32 = 16i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const BitLockerEnabled: i32 = 1i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const BitLockerPaused: i32 = 64i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const BitLockerStopped: i32 = 128i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const BitlockerEncrypted: i32 = 8i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const BitlockerEncrypting: i32 = 32i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CA_UPGRADE_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CLUSTER_BASE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLCTL_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_UNKNOWN: CLCTL_CODES = CLCTL_CODES(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_CHARACTERISTICS: CLCTL_CODES = CLCTL_CODES(5i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_FLAGS: CLCTL_CODES = CLCTL_CODES(9i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_CLASS_INFO: CLCTL_CODES = CLCTL_CODES(13i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_REQUIRED_DEPENDENCIES: CLCTL_CODES = CLCTL_CODES(17i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_ARB_TIMEOUT: CLCTL_CODES = CLCTL_CODES(21i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_FAILURE_INFO: CLCTL_CODES = CLCTL_CODES(25i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_NAME: CLCTL_CODES = CLCTL_CODES(41i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_RESOURCE_TYPE: CLCTL_CODES = CLCTL_CODES(45i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_NODE: CLCTL_CODES = CLCTL_CODES(49i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_NETWORK: CLCTL_CODES = CLCTL_CODES(53i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_ID: CLCTL_CODES = CLCTL_CODES(57i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_FQDN: CLCTL_CODES = CLCTL_CODES(61i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_CLUSTER_SERVICE_ACCOUNT_NAME: CLCTL_CODES = CLCTL_CODES(65i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CHECK_VOTER_EVICT: CLCTL_CODES = CLCTL_CODES(69i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CHECK_VOTER_DOWN: CLCTL_CODES = CLCTL_CODES(73i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SHUTDOWN: CLCTL_CODES = CLCTL_CODES(77i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ENUM_COMMON_PROPERTIES: CLCTL_CODES = CLCTL_CODES(81i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_RO_COMMON_PROPERTIES: CLCTL_CODES = CLCTL_CODES(85i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_COMMON_PROPERTIES: CLCTL_CODES = CLCTL_CODES(89i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_COMMON_PROPERTIES: CLCTL_CODES = CLCTL_CODES(4194398i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_VALIDATE_COMMON_PROPERTIES: CLCTL_CODES = CLCTL_CODES(97i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_COMMON_PROPERTY_FMTS: CLCTL_CODES = CLCTL_CODES(101i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_COMMON_RESOURCE_PROPERTY_FMTS: CLCTL_CODES = CLCTL_CODES(105i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ENUM_PRIVATE_PROPERTIES: CLCTL_CODES = CLCTL_CODES(121i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_RO_PRIVATE_PROPERTIES: CLCTL_CODES = CLCTL_CODES(125i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_PRIVATE_PROPERTIES: CLCTL_CODES = CLCTL_CODES(129i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_PRIVATE_PROPERTIES: CLCTL_CODES = CLCTL_CODES(4194438i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_VALIDATE_PRIVATE_PROPERTIES: CLCTL_CODES = CLCTL_CODES(137i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_PRIVATE_PROPERTY_FMTS: CLCTL_CODES = CLCTL_CODES(141i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_PRIVATE_RESOURCE_PROPERTY_FMTS: CLCTL_CODES = CLCTL_CODES(145i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ADD_REGISTRY_CHECKPOINT: CLCTL_CODES = CLCTL_CODES(4194466i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_DELETE_REGISTRY_CHECKPOINT: CLCTL_CODES = CLCTL_CODES(4194470i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_REGISTRY_CHECKPOINTS: CLCTL_CODES = CLCTL_CODES(169i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ADD_CRYPTO_CHECKPOINT: CLCTL_CODES = CLCTL_CODES(4194478i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_DELETE_CRYPTO_CHECKPOINT: CLCTL_CODES = CLCTL_CODES(4194482i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_CRYPTO_CHECKPOINTS: CLCTL_CODES = CLCTL_CODES(181i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_RESOURCE_UPGRADE_DLL: CLCTL_CODES = CLCTL_CODES(4194490i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ADD_REGISTRY_CHECKPOINT_64BIT: CLCTL_CODES = CLCTL_CODES(4194494i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ADD_REGISTRY_CHECKPOINT_32BIT: CLCTL_CODES = CLCTL_CODES(4194498i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_LOADBAL_PROCESS_LIST: CLCTL_CODES = CLCTL_CODES(201i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_ACCOUNT_ACCESS: CLCTL_CODES = CLCTL_CODES(4194546i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_NETWORK_NAME: CLCTL_CODES = CLCTL_CODES(361i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_GET_VIRTUAL_SERVER_TOKEN: CLCTL_CODES = CLCTL_CODES(365i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_REGISTER_DNS_RECORDS: CLCTL_CODES = CLCTL_CODES(370i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_DNS_NAME: CLCTL_CODES = CLCTL_CODES(373i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_SET_PWD_INFO: CLCTL_CODES = CLCTL_CODES(378i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_DELETE_CO: CLCTL_CODES = CLCTL_CODES(382i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_VALIDATE_VCO: CLCTL_CODES = CLCTL_CODES(385i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_RESET_VCO: CLCTL_CODES = CLCTL_CODES(389i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_REPAIR_VCO: CLCTL_CODES = CLCTL_CODES(397i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_DISK_INFO: CLCTL_CODES = CLCTL_CODES(401i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_AVAILABLE_DISKS: CLCTL_CODES = CLCTL_CODES(405i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_IS_PATH_VALID: CLCTL_CODES = CLCTL_CODES(409i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_SYNC_CLUSDISK_DB: CLCTL_CODES = CLCTL_CODES(4194718i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_DISK_NUMBER_INFO: CLCTL_CODES = CLCTL_CODES(417i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_QUERY_DELETE: CLCTL_CODES = CLCTL_CODES(441i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_IPADDRESS_RENEW_LEASE: CLCTL_CODES = CLCTL_CODES(4194750i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_IPADDRESS_RELEASE_LEASE: CLCTL_CODES = CLCTL_CODES(4194754i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_QUERY_MAINTENANCE_MODE: CLCTL_CODES = CLCTL_CODES(481i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_MAINTENANCE_MODE: CLCTL_CODES = CLCTL_CODES(4194790i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_SET_DRIVELETTER: CLCTL_CODES = CLCTL_CODES(4194794i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_DRIVELETTERS: CLCTL_CODES = CLCTL_CODES(493i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_DISK_INFO_EX: CLCTL_CODES = CLCTL_CODES(497i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX: CLCTL_CODES = CLCTL_CODES(501i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_DISK_INFO_EX2: CLCTL_CODES = CLCTL_CODES(505i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_CLUSPORT_DISK_COUNT: CLCTL_CODES = CLCTL_CODES(509i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_REMAP_DRIVELETTER: CLCTL_CODES = CLCTL_CODES(513i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_DISKID: CLCTL_CODES = CLCTL_CODES(517i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_IS_CLUSTERABLE: CLCTL_CODES = CLCTL_CODES(521i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_REMOVE_VM_OWNERSHIP: CLCTL_CODES = CLCTL_CODES(4194830i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_MOUNTPOINTS: CLCTL_CODES = CLCTL_CODES(529i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_DIRTY: CLCTL_CODES = CLCTL_CODES(537i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_SHARED_VOLUME_INFO: CLCTL_CODES = CLCTL_CODES(549i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_IS_CSV_FILE: CLCTL_CODES = CLCTL_CODES(553i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_RESOURCEID: CLCTL_CODES = CLCTL_CODES(557i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_VALIDATE_PATH: CLCTL_CODES = CLCTL_CODES(561i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_VALIDATE_NETNAME: CLCTL_CODES = CLCTL_CODES(565i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_VALIDATE_DIRECTORY: CLCTL_CODES = CLCTL_CODES(569i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_BATCH_BLOCK_KEY: CLCTL_CODES = CLCTL_CODES(574i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_BATCH_UNBLOCK_KEY: CLCTL_CODES = CLCTL_CODES(577i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FILESERVER_SHARE_ADD: CLCTL_CODES = CLCTL_CODES(4194886i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FILESERVER_SHARE_DEL: CLCTL_CODES = CLCTL_CODES(4194890i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FILESERVER_SHARE_MODIFY: CLCTL_CODES = CLCTL_CODES(4194894i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FILESERVER_SHARE_REPORT: CLCTL_CODES = CLCTL_CODES(593i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_GET_OU_FOR_VCO: CLCTL_CODES = CLCTL_CODES(4194926i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ENABLE_SHARED_VOLUME_DIRECTIO: CLCTL_CODES = CLCTL_CODES(4194954i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_DISABLE_SHARED_VOLUME_DIRECTIO: CLCTL_CODES = CLCTL_CODES(4194958i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_SHARED_VOLUME_ID: CLCTL_CODES = CLCTL_CODES(657i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_CSV_MAINTENANCE_MODE: CLCTL_CODES = CLCTL_CODES(4194966i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_SHARED_VOLUME_BACKUP_MODE: CLCTL_CODES = CLCTL_CODES(4194970i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES: CLCTL_CODES = CLCTL_CODES(669i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_SHARED_VOLUME_STATES: CLCTL_CODES = CLCTL_CODES(4194978i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_IS_SHARED_VOLUME: CLCTL_CODES = CLCTL_CODES(677i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_CLUSDB_TIMESTAMP: CLCTL_CODES = CLCTL_CODES(681i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_RW_MODIFY_NOOP: CLCTL_CODES = CLCTL_CODES(4194990i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_IS_QUORUM_BLOCKED: CLCTL_CODES = CLCTL_CODES(689i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_POOL_GET_DRIVE_INFO: CLCTL_CODES = CLCTL_CODES(693i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_GUM_LOCK_OWNER: CLCTL_CODES = CLCTL_CODES(697i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_STUCK_NODES: CLCTL_CODES = CLCTL_CODES(701i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_INJECT_GEM_FAULT: CLCTL_CODES = CLCTL_CODES(705i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_INTRODUCE_GEM_REPAIR_DELAY: CLCTL_CODES = CLCTL_CODES(709i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SEND_DUMMY_GEM_MESSAGES: CLCTL_CODES = CLCTL_CODES(713i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_BLOCK_GEM_SEND_RECV: CLCTL_CODES = CLCTL_CODES(717i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_GEMID_VECTOR: CLCTL_CODES = CLCTL_CODES(721i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ADD_CRYPTO_CHECKPOINT_EX: CLCTL_CODES = CLCTL_CODES(4195030i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GROUP_GET_LAST_MOVE_TIME: CLCTL_CODES = CLCTL_CODES(729i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_STORAGE_CONFIGURATION: CLCTL_CODES = CLCTL_CODES(4195042i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_STORAGE_CONFIGURATION: CLCTL_CODES = CLCTL_CODES(741i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_STORAGE_CONFIG_ATTRIBUTES: CLCTL_CODES = CLCTL_CODES(745i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REMOVE_NODE: CLCTL_CODES = CLCTL_CODES(4195054i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_IS_FEATURE_INSTALLED: CLCTL_CODES = CLCTL_CODES(753i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_IS_S2D_FEATURE_SUPPORTED: CLCTL_CODES = CLCTL_CODES(757i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_PHYSICAL_DISK_INFO: CLCTL_CODES = CLCTL_CODES(761i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_CLUSBFLT_PATHS: CLCTL_CODES = CLCTL_CODES(765i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_CLUSBFLT_PATHINFO: CLCTL_CODES = CLCTL_CODES(769i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CLEAR_NODE_CONNECTION_INFO: CLCTL_CODES = CLCTL_CODES(4195078i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_DNS_DOMAIN: CLCTL_CODES = CLCTL_CODES(4195082i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CTCTL_GET_ROUTESTATUS_BASIC: CLCTL_CODES = CLCTL_CODES(781i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CTCTL_GET_ROUTESTATUS_EXTENDED: CLCTL_CODES = CLCTL_CODES(785i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CTCTL_GET_FAULT_DOMAIN_STATE: CLCTL_CODES = CLCTL_CODES(789i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_SET_PWD_INFOEX: CLCTL_CODES = CLCTL_CODES(794i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX2_INT: CLCTL_CODES = CLCTL_CODES(8161i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS: CLCTL_CODES = CLCTL_CODES(8417i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN: CLCTL_CODES = CLCTL_CODES(4202726i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_RESOURCE_PREPARE_UPGRADE: CLCTL_CODES = CLCTL_CODES(4202730i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_RESOURCE_UPGRADE_COMPLETED: CLCTL_CODES = CLCTL_CODES(4202734i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY: CLCTL_CODES = CLCTL_CODES(8433i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY: CLCTL_CODES = CLCTL_CODES(4202742i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_ADD_REPLICATION_GROUP: CLCTL_CODES = CLCTL_CODES(8514i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_GET_LOG_INFO: CLCTL_CODES = CLCTL_CODES(8517i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_GET_ELIGIBLE_LOGDISKS: CLCTL_CODES = CLCTL_CODES(8521i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS: CLCTL_CODES = CLCTL_CODES(8525i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS: CLCTL_CODES = CLCTL_CODES(8529i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_GET_REPLICATED_DISKS: CLCTL_CODES = CLCTL_CODES(8533i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_GET_REPLICA_VOLUMES: CLCTL_CODES = CLCTL_CODES(8537i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_GET_LOG_VOLUME: CLCTL_CODES = CLCTL_CODES(8541i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_GET_RESOURCE_GROUP: CLCTL_CODES = CLCTL_CODES(8545i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REPLICATION_GET_REPLICATED_PARTITION_INFO: CLCTL_CODES = CLCTL_CODES(8549i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_STATE_CHANGE_TIME: CLCTL_CODES = CLCTL_CODES(11613i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_CLUSTER_S2D_ENABLED: CLCTL_CODES = CLCTL_CODES(4205922i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES: CLCTL_CODES = CLCTL_CODES(4205934i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GROUPSET_GET_GROUPS: CLCTL_CODES = CLCTL_CODES(11633i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GROUPSET_GET_PROVIDER_GROUPS: CLCTL_CODES = CLCTL_CODES(11637i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GROUPSET_GET_PROVIDER_GROUPSETS: CLCTL_CODES = CLCTL_CODES(11641i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GROUP_GET_PROVIDER_GROUPS: CLCTL_CODES = CLCTL_CODES(11645i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GROUP_GET_PROVIDER_GROUPSETS: CLCTL_CODES = CLCTL_CODES(11649i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GROUP_SET_CCF_FROM_MASTER: CLCTL_CODES = CLCTL_CODES(4205958i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_INFRASTRUCTURE_SOFS_BUFFER: CLCTL_CODES = CLCTL_CODES(11657i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_INFRASTRUCTURE_SOFS_BUFFER: CLCTL_CODES = CLCTL_CODES(4205966i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NOTIFY_INFRASTRUCTURE_SOFS_CHANGED: CLCTL_CODES = CLCTL_CODES(4205970i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SCALEOUT_COMMAND: CLCTL_CODES = CLCTL_CODES(4205974i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SCALEOUT_CONTROL: CLCTL_CODES = CLCTL_CODES(4205978i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SCALEOUT_GET_CLUSTERS: CLCTL_CODES = CLCTL_CODES(4205981i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_RELOAD_AUTOLOGGER_CONFIG: CLCTL_CODES = CLCTL_CODES(11730i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_RENAME_SHARED_VOLUME: CLCTL_CODES = CLCTL_CODES(11734i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STORAGE_RENAME_SHARED_VOLUME_GUID: CLCTL_CODES = CLCTL_CODES(11738i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ENUM_AFFINITY_RULE_NAMES: CLCTL_CODES = CLCTL_CODES(11741i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_NODES_IN_FD: CLCTL_CODES = CLCTL_CODES(11745i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FORCE_DB_FLUSH: CLCTL_CODES = CLCTL_CODES(4206054i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_DELETE: CLCTL_CODES = CLCTL_CODES(5242886i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_INSTALL_NODE: CLCTL_CODES = CLCTL_CODES(5242890i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_EVICT_NODE: CLCTL_CODES = CLCTL_CODES(5242894i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ADD_DEPENDENCY: CLCTL_CODES = CLCTL_CODES(5242898i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REMOVE_DEPENDENCY: CLCTL_CODES = CLCTL_CODES(5242902i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_ADD_OWNER: CLCTL_CODES = CLCTL_CODES(5242906i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_REMOVE_OWNER: CLCTL_CODES = CLCTL_CODES(5242910i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_SET_NAME: CLCTL_CODES = CLCTL_CODES(5242918i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CLUSTER_NAME_CHANGED: CLCTL_CODES = CLCTL_CODES(5242922i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CLUSTER_VERSION_CHANGED: CLCTL_CODES = CLCTL_CODES(5242926i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FIXUP_ON_UPGRADE: CLCTL_CODES = CLCTL_CODES(5242930i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STARTING_PHASE1: CLCTL_CODES = CLCTL_CODES(5242934i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STARTING_PHASE2: CLCTL_CODES = CLCTL_CODES(5242938i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_HOLD_IO: CLCTL_CODES = CLCTL_CODES(5242942i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_RESUME_IO: CLCTL_CODES = CLCTL_CODES(5242946i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FORCE_QUORUM: CLCTL_CODES = CLCTL_CODES(5242950i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_INITIALIZE: CLCTL_CODES = CLCTL_CODES(5242954i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_STATE_CHANGE_REASON: CLCTL_CODES = CLCTL_CODES(5242958i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_PROVIDER_STATE_CHANGE: CLCTL_CODES = CLCTL_CODES(5242962i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_LEAVING_GROUP: CLCTL_CODES = CLCTL_CODES(5242966i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_JOINING_GROUP: CLCTL_CODES = CLCTL_CODES(5242970i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FSWITNESS_GET_EPOCH_INFO: CLCTL_CODES = CLCTL_CODES(1048669i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FSWITNESS_SET_EPOCH_INFO: CLCTL_CODES = CLCTL_CODES(5242978i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_FSWITNESS_RELEASE_LOCK: CLCTL_CODES = CLCTL_CODES(5242982i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NETNAME_CREDS_NOTIFYCAM: CLCTL_CODES = CLCTL_CODES(5242986i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NOTIFY_QUORUM_STATUS: CLCTL_CODES = CLCTL_CODES(5243006i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NOTIFY_MONITOR_SHUTTING_DOWN: CLCTL_CODES = CLCTL_CODES(1048705i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_UNDELETE: CLCTL_CODES = CLCTL_CODES(5243014i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GET_OPERATION_CONTEXT: CLCTL_CODES = CLCTL_CODES(1057001i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NOTIFY_OWNER_CHANGE: CLCTL_CODES = CLCTL_CODES(5251362i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_VALIDATE_CHANGE_GROUP: CLCTL_CODES = CLCTL_CODES(1057061i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_CHECK_DRAIN_VETO: CLCTL_CODES = CLCTL_CODES(1057069i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_NOTIFY_DRAIN_COMPLETE: CLCTL_CODES = CLCTL_CODES(1057073i32);
impl ::core::marker::Copy for CLCTL_CODES {}
impl ::core::clone::Clone for CLCTL_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLCTL_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLCTL_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLCTL_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLCTL_CODES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_GLOBAL_SHIFT: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_INTERNAL_SHIFT: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_MODIFY_SHIFT: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLCTL_USER_SHIFT: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLOUD_WITNESS_CONTAINER_NAME: &'static str = "msft-cloud-witness";
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLRES_CALLBACK_FUNCTION_TABLE {
    pub LogEvent: PLOG_EVENT_ROUTINE,
    pub SetResourceStatusEx: PSET_RESOURCE_STATUS_ROUTINE_EX,
    pub SetResourceLockedMode: PSET_RESOURCE_LOCKED_MODE_ROUTINE,
    pub SignalFailure: PSIGNAL_FAILURE_ROUTINE,
    pub SetResourceInMemoryNodeLocalProperties: PSET_RESOURCE_INMEMORY_NODELOCAL_PROPERTIES_ROUTINE,
    pub EndControlCall: PEND_CONTROL_CALL,
    pub EndTypeControlCall: PEND_TYPE_CONTROL_CALL,
    pub ExtendControlCall: PEXTEND_RES_CONTROL_CALL,
    pub ExtendTypeControlCall: PEXTEND_RES_TYPE_CONTROL_CALL,
    pub RaiseResTypeNotification: PRAISE_RES_TYPE_NOTIFICATION,
    pub ChangeResourceProcessForDumps: PCHANGE_RESOURCE_PROCESS_FOR_DUMPS,
    pub ChangeResTypeProcessForDumps: PCHANGE_RES_TYPE_PROCESS_FOR_DUMPS,
    pub SetInternalState: PSET_INTERNAL_STATE,
    pub SetResourceLockedModeEx: PSET_RESOURCE_LOCKED_MODE_EX_ROUTINE,
    pub RequestDump: PREQUEST_DUMP_ROUTINE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLRES_CALLBACK_FUNCTION_TABLE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLRES_CALLBACK_FUNCTION_TABLE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLRES_CALLBACK_FUNCTION_TABLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLRES_CALLBACK_FUNCTION_TABLE")
            .field("LogEvent", &self.LogEvent.map(|f| f as usize))
            .field("SetResourceStatusEx", &self.SetResourceStatusEx.map(|f| f as usize))
            .field("SetResourceLockedMode", &self.SetResourceLockedMode.map(|f| f as usize))
            .field("SignalFailure", &self.SignalFailure.map(|f| f as usize))
            .field("SetResourceInMemoryNodeLocalProperties", &self.SetResourceInMemoryNodeLocalProperties.map(|f| f as usize))
            .field("EndControlCall", &self.EndControlCall.map(|f| f as usize))
            .field("EndTypeControlCall", &self.EndTypeControlCall.map(|f| f as usize))
            .field("ExtendControlCall", &self.ExtendControlCall.map(|f| f as usize))
            .field("ExtendTypeControlCall", &self.ExtendTypeControlCall.map(|f| f as usize))
            .field("RaiseResTypeNotification", &self.RaiseResTypeNotification.map(|f| f as usize))
            .field("ChangeResourceProcessForDumps", &self.ChangeResourceProcessForDumps.map(|f| f as usize))
            .field("ChangeResTypeProcessForDumps", &self.ChangeResTypeProcessForDumps.map(|f| f as usize))
            .field("SetInternalState", &self.SetInternalState.map(|f| f as usize))
            .field("SetResourceLockedModeEx", &self.SetResourceLockedModeEx.map(|f| f as usize))
            .field("RequestDump", &self.RequestDump.map(|f| f as usize))
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLRES_CALLBACK_FUNCTION_TABLE {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLRES_CALLBACK_FUNCTION_TABLE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLRES_CALLBACK_FUNCTION_TABLE>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLRES_CALLBACK_FUNCTION_TABLE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLRES_CALLBACK_FUNCTION_TABLE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub struct CLRES_FUNCTION_TABLE {
    pub TableSize: u32,
    pub Version: u32,
    pub Anonymous: CLRES_FUNCTION_TABLE_0,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::marker::Copy for CLRES_FUNCTION_TABLE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::clone::Clone for CLRES_FUNCTION_TABLE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::core::Abi for CLRES_FUNCTION_TABLE {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::PartialEq for CLRES_FUNCTION_TABLE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLRES_FUNCTION_TABLE>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::Eq for CLRES_FUNCTION_TABLE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::default::Default for CLRES_FUNCTION_TABLE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub union CLRES_FUNCTION_TABLE_0 {
    pub V1Functions: CLRES_V1_FUNCTIONS,
    pub V2Functions: CLRES_V2_FUNCTIONS,
    pub V3Functions: CLRES_V3_FUNCTIONS,
    pub V4Functions: CLRES_V4_FUNCTIONS,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::marker::Copy for CLRES_FUNCTION_TABLE_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::clone::Clone for CLRES_FUNCTION_TABLE_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::core::Abi for CLRES_FUNCTION_TABLE_0 {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::PartialEq for CLRES_FUNCTION_TABLE_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLRES_FUNCTION_TABLE_0>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::Eq for CLRES_FUNCTION_TABLE_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::default::Default for CLRES_FUNCTION_TABLE_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub struct CLRES_V1_FUNCTIONS {
    pub Open: POPEN_ROUTINE,
    pub Close: PCLOSE_ROUTINE,
    pub Online: PONLINE_ROUTINE,
    pub Offline: POFFLINE_ROUTINE,
    pub Terminate: PTERMINATE_ROUTINE,
    pub LooksAlive: PLOOKS_ALIVE_ROUTINE,
    pub IsAlive: PIS_ALIVE_ROUTINE,
    pub Arbitrate: PARBITRATE_ROUTINE,
    pub Release: PRELEASE_ROUTINE,
    pub ResourceControl: PRESOURCE_CONTROL_ROUTINE,
    pub ResourceTypeControl: PRESOURCE_TYPE_CONTROL_ROUTINE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::marker::Copy for CLRES_V1_FUNCTIONS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::clone::Clone for CLRES_V1_FUNCTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::fmt::Debug for CLRES_V1_FUNCTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLRES_V1_FUNCTIONS")
            .field("Open", &self.Open.map(|f| f as usize))
            .field("Close", &self.Close.map(|f| f as usize))
            .field("Online", &self.Online.map(|f| f as usize))
            .field("Offline", &self.Offline.map(|f| f as usize))
            .field("Terminate", &self.Terminate.map(|f| f as usize))
            .field("LooksAlive", &self.LooksAlive.map(|f| f as usize))
            .field("IsAlive", &self.IsAlive.map(|f| f as usize))
            .field("Arbitrate", &self.Arbitrate.map(|f| f as usize))
            .field("Release", &self.Release.map(|f| f as usize))
            .field("ResourceControl", &self.ResourceControl.map(|f| f as usize))
            .field("ResourceTypeControl", &self.ResourceTypeControl.map(|f| f as usize))
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::core::Abi for CLRES_V1_FUNCTIONS {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::PartialEq for CLRES_V1_FUNCTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLRES_V1_FUNCTIONS>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::Eq for CLRES_V1_FUNCTIONS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::default::Default for CLRES_V1_FUNCTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub struct CLRES_V2_FUNCTIONS {
    pub Open: POPEN_V2_ROUTINE,
    pub Close: PCLOSE_ROUTINE,
    pub Online: PONLINE_V2_ROUTINE,
    pub Offline: POFFLINE_V2_ROUTINE,
    pub Terminate: PTERMINATE_ROUTINE,
    pub LooksAlive: PLOOKS_ALIVE_ROUTINE,
    pub IsAlive: PIS_ALIVE_ROUTINE,
    pub Arbitrate: PARBITRATE_ROUTINE,
    pub Release: PRELEASE_ROUTINE,
    pub ResourceControl: PRESOURCE_CONTROL_ROUTINE,
    pub ResourceTypeControl: PRESOURCE_TYPE_CONTROL_ROUTINE,
    pub Cancel: PCANCEL_ROUTINE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::marker::Copy for CLRES_V2_FUNCTIONS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::clone::Clone for CLRES_V2_FUNCTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::fmt::Debug for CLRES_V2_FUNCTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLRES_V2_FUNCTIONS")
            .field("Open", &self.Open.map(|f| f as usize))
            .field("Close", &self.Close.map(|f| f as usize))
            .field("Online", &self.Online.map(|f| f as usize))
            .field("Offline", &self.Offline.map(|f| f as usize))
            .field("Terminate", &self.Terminate.map(|f| f as usize))
            .field("LooksAlive", &self.LooksAlive.map(|f| f as usize))
            .field("IsAlive", &self.IsAlive.map(|f| f as usize))
            .field("Arbitrate", &self.Arbitrate.map(|f| f as usize))
            .field("Release", &self.Release.map(|f| f as usize))
            .field("ResourceControl", &self.ResourceControl.map(|f| f as usize))
            .field("ResourceTypeControl", &self.ResourceTypeControl.map(|f| f as usize))
            .field("Cancel", &self.Cancel.map(|f| f as usize))
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::core::Abi for CLRES_V2_FUNCTIONS {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::PartialEq for CLRES_V2_FUNCTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLRES_V2_FUNCTIONS>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::Eq for CLRES_V2_FUNCTIONS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::default::Default for CLRES_V2_FUNCTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub struct CLRES_V3_FUNCTIONS {
    pub Open: POPEN_V2_ROUTINE,
    pub Close: PCLOSE_ROUTINE,
    pub Online: PONLINE_V2_ROUTINE,
    pub Offline: POFFLINE_V2_ROUTINE,
    pub Terminate: PTERMINATE_ROUTINE,
    pub LooksAlive: PLOOKS_ALIVE_ROUTINE,
    pub IsAlive: PIS_ALIVE_ROUTINE,
    pub Arbitrate: PARBITRATE_ROUTINE,
    pub Release: PRELEASE_ROUTINE,
    pub BeginResourceControl: PBEGIN_RESCALL_ROUTINE,
    pub BeginResourceTypeControl: PBEGIN_RESTYPECALL_ROUTINE,
    pub Cancel: PCANCEL_ROUTINE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::marker::Copy for CLRES_V3_FUNCTIONS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::clone::Clone for CLRES_V3_FUNCTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::fmt::Debug for CLRES_V3_FUNCTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLRES_V3_FUNCTIONS")
            .field("Open", &self.Open.map(|f| f as usize))
            .field("Close", &self.Close.map(|f| f as usize))
            .field("Online", &self.Online.map(|f| f as usize))
            .field("Offline", &self.Offline.map(|f| f as usize))
            .field("Terminate", &self.Terminate.map(|f| f as usize))
            .field("LooksAlive", &self.LooksAlive.map(|f| f as usize))
            .field("IsAlive", &self.IsAlive.map(|f| f as usize))
            .field("Arbitrate", &self.Arbitrate.map(|f| f as usize))
            .field("Release", &self.Release.map(|f| f as usize))
            .field("BeginResourceControl", &self.BeginResourceControl.map(|f| f as usize))
            .field("BeginResourceTypeControl", &self.BeginResourceTypeControl.map(|f| f as usize))
            .field("Cancel", &self.Cancel.map(|f| f as usize))
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::core::Abi for CLRES_V3_FUNCTIONS {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::PartialEq for CLRES_V3_FUNCTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLRES_V3_FUNCTIONS>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::Eq for CLRES_V3_FUNCTIONS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::default::Default for CLRES_V3_FUNCTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub struct CLRES_V4_FUNCTIONS {
    pub Open: POPEN_V2_ROUTINE,
    pub Close: PCLOSE_ROUTINE,
    pub Online: PONLINE_V2_ROUTINE,
    pub Offline: POFFLINE_V2_ROUTINE,
    pub Terminate: PTERMINATE_ROUTINE,
    pub LooksAlive: PLOOKS_ALIVE_ROUTINE,
    pub IsAlive: PIS_ALIVE_ROUTINE,
    pub Arbitrate: PARBITRATE_ROUTINE,
    pub Release: PRELEASE_ROUTINE,
    pub BeginResourceControl: PBEGIN_RESCALL_ROUTINE,
    pub BeginResourceTypeControl: PBEGIN_RESTYPECALL_ROUTINE,
    pub Cancel: PCANCEL_ROUTINE,
    pub BeginResourceControlAsUser: PBEGIN_RESCALL_AS_USER_ROUTINE,
    pub BeginResourceTypeControlAsUser: PBEGIN_RESTYPECALL_AS_USER_ROUTINE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::marker::Copy for CLRES_V4_FUNCTIONS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::clone::Clone for CLRES_V4_FUNCTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::fmt::Debug for CLRES_V4_FUNCTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLRES_V4_FUNCTIONS")
            .field("Open", &self.Open.map(|f| f as usize))
            .field("Close", &self.Close.map(|f| f as usize))
            .field("Online", &self.Online.map(|f| f as usize))
            .field("Offline", &self.Offline.map(|f| f as usize))
            .field("Terminate", &self.Terminate.map(|f| f as usize))
            .field("LooksAlive", &self.LooksAlive.map(|f| f as usize))
            .field("IsAlive", &self.IsAlive.map(|f| f as usize))
            .field("Arbitrate", &self.Arbitrate.map(|f| f as usize))
            .field("Release", &self.Release.map(|f| f as usize))
            .field("BeginResourceControl", &self.BeginResourceControl.map(|f| f as usize))
            .field("BeginResourceTypeControl", &self.BeginResourceTypeControl.map(|f| f as usize))
            .field("Cancel", &self.Cancel.map(|f| f as usize))
            .field("BeginResourceControlAsUser", &self.BeginResourceControlAsUser.map(|f| f as usize))
            .field("BeginResourceTypeControlAsUser", &self.BeginResourceTypeControlAsUser.map(|f| f as usize))
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::core::Abi for CLRES_V4_FUNCTIONS {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::PartialEq for CLRES_V4_FUNCTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLRES_V4_FUNCTIONS>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::Eq for CLRES_V4_FUNCTIONS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::default::Default for CLRES_V4_FUNCTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLRES_VERSION_V1_00: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLRES_VERSION_V2_00: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLRES_VERSION_V3_00: u32 = 768u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLRES_VERSION_V4_00: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUADMEX_OBJECT_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUADMEX_OT_NONE: CLUADMEX_OBJECT_TYPE = CLUADMEX_OBJECT_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUADMEX_OT_CLUSTER: CLUADMEX_OBJECT_TYPE = CLUADMEX_OBJECT_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUADMEX_OT_NODE: CLUADMEX_OBJECT_TYPE = CLUADMEX_OBJECT_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUADMEX_OT_GROUP: CLUADMEX_OBJECT_TYPE = CLUADMEX_OBJECT_TYPE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUADMEX_OT_RESOURCE: CLUADMEX_OBJECT_TYPE = CLUADMEX_OBJECT_TYPE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUADMEX_OT_RESOURCETYPE: CLUADMEX_OBJECT_TYPE = CLUADMEX_OBJECT_TYPE(5i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUADMEX_OT_NETWORK: CLUADMEX_OBJECT_TYPE = CLUADMEX_OBJECT_TYPE(6i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUADMEX_OT_NETINTERFACE: CLUADMEX_OBJECT_TYPE = CLUADMEX_OBJECT_TYPE(7i32);
impl ::core::marker::Copy for CLUADMEX_OBJECT_TYPE {}
impl ::core::clone::Clone for CLUADMEX_OBJECT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUADMEX_OBJECT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUADMEX_OBJECT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUADMEX_OBJECT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUADMEX_OBJECT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_CHANGE_ACCESS: i32 = 2i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_CHANGE_RESOURCE_GROUP_FORCE_MOVE_TO_CSV: u64 = 1u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_MOVE_FAILBACK: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_MOVE_HIGH_PRIORITY_START: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_MOVE_IGNORE_AFFINITY_RULE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_MOVE_IGNORE_RESOURCE_STATUS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_MOVE_QUEUE_ENABLED: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_MOVE_RETURN_TO_SOURCE_NODE_ON_ERROR: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_OFFLINE_IGNORE_RESOURCE_STATUS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_ONLINE_BEST_POSSIBLE_NODE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_ONLINE_IGNORE_AFFINITY_RULE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_ONLINE_IGNORE_RESOURCE_STATUS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_GROUP_ONLINE_SYNCHRONOUS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_NODE_AVOID_PLACEMENT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_NODE_PAUSE_REMAIN_ON_PAUSED_NODE_ON_MOVE_ERROR: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_NODE_PAUSE_RETRY_DRAIN_ON_FAILURE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_NO_ACCESS: i32 = 4i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_READ_ACCESS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_DO_NOT_UPDATE_PERSISTENT_STATE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_FORCE_WITH_TERMINATION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_IGNORE_RESOURCE_STATUS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_REASON_BEING_DELETED: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_REASON_BEING_RESTARTED: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_REASON_MOVING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_REASON_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_REASON_PREEMPTED: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_REASON_SHUTTING_DOWN: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_REASON_UNKNOWN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_OFFLINE_REASON_USER_REQUESTED: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_ONLINE_BEST_POSSIBLE_NODE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_ONLINE_DO_NOT_UPDATE_PERSISTENT_STATE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_ONLINE_IGNORE_AFFINITY_RULE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_ONLINE_IGNORE_RESOURCE_STATUS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_RESOURCE_ONLINE_NECESSARY_FOR_QUORUM: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_VALID_CHANGE_RESOURCE_GROUP_FLAGS: u64 = 1u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_VERSION: u32 = 2560u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_VERSION_RS3: u32 = 2560u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_VERSION_SERVER2008: u32 = 1536u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_VERSION_SERVER2008R2: u32 = 1792u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_VERSION_WINDOWS8: u32 = 1793u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_VERSION_WINDOWSBLUE: u32 = 1794u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSAPI_VERSION_WINTHRESHOLD: u32 = 1795u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_ACCESS_MODE_MASK: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_ACCESS_SHIFT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSCTL_AFFINITYRULE_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_AFFINITYRULE_GET_COMMON_PROPERTIES: CLUSCTL_AFFINITYRULE_CODES = CLUSCTL_AFFINITYRULE_CODES(150995033i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_AFFINITYRULE_GET_RO_COMMON_PROPERTIES: CLUSCTL_AFFINITYRULE_CODES = CLUSCTL_AFFINITYRULE_CODES(150995029i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_AFFINITYRULE_SET_COMMON_PROPERTIES: CLUSCTL_AFFINITYRULE_CODES = CLUSCTL_AFFINITYRULE_CODES(155189342i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_AFFINITYRULE_GET_ID: CLUSCTL_AFFINITYRULE_CODES = CLUSCTL_AFFINITYRULE_CODES(150995001i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_AFFINITYRULE_GET_GROUPNAMES: CLUSCTL_AFFINITYRULE_CODES = CLUSCTL_AFFINITYRULE_CODES(151006577i32);
impl ::core::marker::Copy for CLUSCTL_AFFINITYRULE_CODES {}
impl ::core::clone::Clone for CLUSCTL_AFFINITYRULE_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSCTL_AFFINITYRULE_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_AFFINITYRULE_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSCTL_AFFINITYRULE_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSCTL_AFFINITYRULE_CODES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSCTL_CLUSTER_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_UNKNOWN: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440512i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_FQDN: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440573i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_SET_STORAGE_CONFIGURATION: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121635554i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_STORAGE_CONFIGURATION: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117441253i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_STORAGE_CONFIG_ATTRIBUTES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117441257i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440593i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440597i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440601i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121634910i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440609i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440633i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440637i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440641i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121634950i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440649i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440613i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTY_FMTS: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440653i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_CHECK_VOTER_EVICT: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440581i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_CHECK_VOTER_DOWN: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440585i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_SHUTDOWN: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440589i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_BATCH_BLOCK_KEY: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117441086i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_BATCH_UNBLOCK_KEY: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117441089i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117441169i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_CLUSDB_TIMESTAMP: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117441193i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_GUM_LOCK_OWNER: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117441209i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_REMOVE_NODE: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121635566i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_SET_ACCOUNT_ACCESS: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121635058i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_CLEAR_NODE_CONNECTION_INFO: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121635590i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_SET_DNS_DOMAIN: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121635594i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_SET_CLUSTER_S2D_ENABLED: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121646434i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121646446i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_STORAGE_RENAME_SHARED_VOLUME: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117452246i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_STORAGE_RENAME_SHARED_VOLUME_GUID: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117452250i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_RELOAD_AUTOLOGGER_CONFIG: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117452242i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_ENUM_AFFINITY_RULE_NAMES: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117452253i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_NODES_IN_FD: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117452257i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_FORCE_FLUSH_DB: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(121646566i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLUSTER_GET_CLMUSR_TOKEN: CLUSCTL_CLUSTER_CODES = CLUSCTL_CLUSTER_CODES(117440877i32);
impl ::core::marker::Copy for CLUSCTL_CLUSTER_CODES {}
impl ::core::clone::Clone for CLUSCTL_CLUSTER_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSCTL_CLUSTER_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_CLUSTER_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSCTL_CLUSTER_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSCTL_CLUSTER_CODES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CONTROL_CODE_MASK: u32 = 4194303u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_FUNCTION_SHIFT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GET_OPERATION_CONTEXT_PARAMS_VERSION_1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSCTL_GROUPSET_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUPSET_GET_COMMON_PROPERTIES: CLUSCTL_GROUPSET_CODES = CLUSCTL_GROUPSET_CODES(134217817i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUPSET_GET_RO_COMMON_PROPERTIES: CLUSCTL_GROUPSET_CODES = CLUSCTL_GROUPSET_CODES(134217813i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUPSET_SET_COMMON_PROPERTIES: CLUSCTL_GROUPSET_CODES = CLUSCTL_GROUPSET_CODES(138412126i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUPSET_GET_GROUPS: CLUSCTL_GROUPSET_CODES = CLUSCTL_GROUPSET_CODES(134229361i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS: CLUSCTL_GROUPSET_CODES = CLUSCTL_GROUPSET_CODES(134229365i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS: CLUSCTL_GROUPSET_CODES = CLUSCTL_GROUPSET_CODES(134229369i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_PROVIDER_GROUPS: CLUSCTL_GROUPSET_CODES = CLUSCTL_GROUPSET_CODES(134229373i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_PROVIDER_GROUPSETS: CLUSCTL_GROUPSET_CODES = CLUSCTL_GROUPSET_CODES(134229377i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUPSET_GET_ID: CLUSCTL_GROUPSET_CODES = CLUSCTL_GROUPSET_CODES(134217785i32);
impl ::core::marker::Copy for CLUSCTL_GROUPSET_CODES {}
impl ::core::clone::Clone for CLUSCTL_GROUPSET_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSCTL_GROUPSET_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_GROUPSET_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSCTL_GROUPSET_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSCTL_GROUPSET_CODES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSCTL_GROUP_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_UNKNOWN: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331648i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_CHARACTERISTICS: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331653i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_FLAGS: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331657i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_NAME: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331689i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_ID: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331705i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_ENUM_COMMON_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331729i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_RO_COMMON_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331733i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_COMMON_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331737i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_SET_COMMON_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(54526046i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_VALIDATE_COMMON_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331745i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_ENUM_PRIVATE_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331769i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_RO_PRIVATE_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331773i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_PRIVATE_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331777i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_SET_PRIVATE_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(54526086i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_VALIDATE_PRIVATE_PROPERTIES: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331785i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_QUERY_DELETE: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50332089i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_COMMON_PROPERTY_FMTS: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331749i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_PRIVATE_PROPERTY_FMTS: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331789i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_FAILURE_INFO: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50331673i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_GET_LAST_MOVE_TIME: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(50332377i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_GROUP_SET_CCF_FROM_MASTER: CLUSCTL_GROUP_CODES = CLUSCTL_GROUP_CODES(54537606i32);
impl ::core::marker::Copy for CLUSCTL_GROUP_CODES {}
impl ::core::clone::Clone for CLUSCTL_GROUP_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSCTL_GROUP_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_GROUP_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSCTL_GROUP_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSCTL_GROUP_CODES").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT {
    pub GetTickCount64: u64,
    pub GetSystemTime: super::super::Foundation::SYSTEMTIME,
    pub NodeId: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT").field("GetTickCount64", &self.GetTickCount64).field("GetSystemTime", &self.GetSystemTime).field("NodeId", &self.NodeId).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUSCTL_GROUP_GET_LAST_MOVE_TIME_OUTPUT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSCTL_NETINTERFACE_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_UNKNOWN: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663296i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_CHARACTERISTICS: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663301i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_FLAGS: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663305i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_NAME: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663337i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_ID: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663353i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_NODE: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663345i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_NETWORK: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663349i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_ENUM_COMMON_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663377i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_RO_COMMON_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663381i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_COMMON_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663385i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_SET_COMMON_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(104857694i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_VALIDATE_COMMON_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663393i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_ENUM_PRIVATE_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663417i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_RO_PRIVATE_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663421i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_PRIVATE_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663425i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_SET_PRIVATE_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(104857734i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_VALIDATE_PRIVATE_PROPERTIES: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663433i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_COMMON_PROPERTY_FMTS: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663397i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETINTERFACE_GET_PRIVATE_PROPERTY_FMTS: CLUSCTL_NETINTERFACE_CODES = CLUSCTL_NETINTERFACE_CODES(100663437i32);
impl ::core::marker::Copy for CLUSCTL_NETINTERFACE_CODES {}
impl ::core::clone::Clone for CLUSCTL_NETINTERFACE_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSCTL_NETINTERFACE_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_NETINTERFACE_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSCTL_NETINTERFACE_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSCTL_NETINTERFACE_CODES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSCTL_NETWORK_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_UNKNOWN: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886080i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_CHARACTERISTICS: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886085i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_FLAGS: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886089i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_NAME: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886121i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_ID: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886137i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_ENUM_COMMON_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886161i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_RO_COMMON_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886165i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_COMMON_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886169i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_SET_COMMON_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(88080478i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_VALIDATE_COMMON_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886177i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_ENUM_PRIVATE_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886201i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_RO_PRIVATE_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886205i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_PRIVATE_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886209i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_SET_PRIVATE_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(88080518i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_VALIDATE_PRIVATE_PROPERTIES: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886217i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_COMMON_PROPERTY_FMTS: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886181i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NETWORK_GET_PRIVATE_PROPERTY_FMTS: CLUSCTL_NETWORK_CODES = CLUSCTL_NETWORK_CODES(83886221i32);
impl ::core::marker::Copy for CLUSCTL_NETWORK_CODES {}
impl ::core::clone::Clone for CLUSCTL_NETWORK_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSCTL_NETWORK_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_NETWORK_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSCTL_NETWORK_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSCTL_NETWORK_CODES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSCTL_NODE_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_UNKNOWN: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108864i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_CHARACTERISTICS: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108869i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_FLAGS: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108873i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_NAME: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108905i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_ID: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108921i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_ENUM_COMMON_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108945i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108949i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_COMMON_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108953i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_SET_COMMON_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(71303262i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108961i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108985i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108989i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_PRIVATE_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108993i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_SET_PRIVATE_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(71303302i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67109001i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_COMMON_PROPERTY_FMTS: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108965i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_PRIVATE_PROPERTY_FMTS: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67109005i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67108929i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_STUCK_NODES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67109565i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_INJECT_GEM_FAULT: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67109569i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_INTRODUCE_GEM_REPAIR_DELAY: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67109573i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_SEND_DUMMY_GEM_MESSAGES: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67109577i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_BLOCK_GEM_SEND_RECV: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67109581i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_NODE_GET_GEMID_VECTOR: CLUSCTL_NODE_CODES = CLUSCTL_NODE_CODES(67109585i32);
impl ::core::marker::Copy for CLUSCTL_NODE_CODES {}
impl ::core::clone::Clone for CLUSCTL_NODE_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSCTL_NODE_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_NODE_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSCTL_NODE_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSCTL_NODE_CODES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_OBJECT_MASK: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_OBJECT_SHIFT: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSCTL_RESOURCE_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_UNKNOWN: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777216i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_CHARACTERISTICS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777221i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_FLAGS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777225i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_CLASS_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777229i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777233i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_NAME: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777257i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_ID: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777273i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_RESOURCE_TYPE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777261i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777297i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777301i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777305i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971614i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777313i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777317i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777337i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777341i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777345i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971654i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777353i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777357i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971682i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971686i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777385i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971694i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971698i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT_EX: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20972246i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777397i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_LOADBAL_PROCESS_LIST: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777417i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_NETWORK_NAME: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777577i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NETNAME_GET_VIRTUAL_SERVER_TOKEN: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777581i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777594i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFOEX: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16778010i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NETNAME_DELETE_CO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777598i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777601i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NETNAME_RESET_VCO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777605i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NETNAME_REPAIR_VCO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777613i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777586i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_DNS_NAME: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777589i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777617i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_DISK_NUMBER_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777633i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777625i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_QUERY_DELETE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777657i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_UPGRADE_DLL: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971706i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971966i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971970i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971710i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20971714i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777697i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20972006i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20972010i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777713i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX2: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777721i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777745i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_DIRTY: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777753i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777765i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20972182i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20972170i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20972174i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20972186i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777885i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_FAILURE_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777241i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_DISKID: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777733i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_STATES: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20972194i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_IS_SHARED_VOLUME: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777893i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_IS_QUORUM_BLOCKED: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777905i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777909i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_RLUA_GET_VIRTUAL_SERVER_TOKEN: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777581i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_RLUA_SET_PWD_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16777594i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_RLUA_SET_PWD_INFOEX: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16778010i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_DELETE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020102i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_UNDELETE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020230i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_INSTALL_NODE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020106i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_EVICT_NODE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020110i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ADD_DEPENDENCY: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020114i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_REMOVE_DEPENDENCY: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020118i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_ADD_OWNER: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020122i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_REMOVE_OWNER: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020126i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SET_NAME: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020134i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_CLUSTER_NAME_CHANGED: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020138i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_CLUSTER_VERSION_CHANGED: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020142i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_FORCE_QUORUM: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020166i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_INITIALIZE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020170i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STATE_CHANGE_REASON: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020174i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_PROVIDER_STATE_CHANGE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020178i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_LEAVING_GROUP: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020182i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_JOINING_GROUP: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020186i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_FSWITNESS_GET_EPOCH_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(17825885i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_FSWITNESS_SET_EPOCH_INFO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020194i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_FSWITNESS_RELEASE_LOCK: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020198i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NETNAME_CREDS_NOTIFYCAM: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020202i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_OPERATION_CONTEXT: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(17834217i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_RW_MODIFY_NOOP: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20972206i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NOTIFY_QUORUM_STATUS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22020222i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NOTIFY_OWNER_CHANGE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(22028578i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_VALIDATE_CHANGE_GROUP: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(17834277i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_RENAME_SHARED_VOLUME: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16788950i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STORAGE_RENAME_SHARED_VOLUME_GUID: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16788954i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20979942i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20979958i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_PREPARE_UPGRADE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20979946i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_UPGRADE_COMPLETED: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20979950i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_STATE_CHANGE_TIME: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16788829i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_INFRASTRUCTURE_SOFS_BUFFER: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16788873i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SET_INFRASTRUCTURE_SOFS_BUFFER: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20983182i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SCALEOUT_COMMAND: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20983190i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SCALEOUT_CONTROL: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20983194i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_SCALEOUT_GET_CLUSTERS: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(20983197i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_CHECK_DRAIN_VETO: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(17834285i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_NOTIFY_DRAIN_COMPLETE: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(17834289i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_GET_NODES_IN_FD: CLUSCTL_RESOURCE_CODES = CLUSCTL_RESOURCE_CODES(16788961i32);
impl ::core::marker::Copy for CLUSCTL_RESOURCE_CODES {}
impl ::core::clone::Clone for CLUSCTL_RESOURCE_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSCTL_RESOURCE_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_RESOURCE_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSCTL_RESOURCE_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSCTL_RESOURCE_CODES").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT {
    pub dwSize: u32,
    pub dwVersion: u32,
    pub eReason: CLUSTER_RESOURCE_STATE_CHANGE_REASON,
}
impl ::core::marker::Copy for CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT {}
impl ::core::clone::Clone for CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT").field("dwSize", &self.dwSize).field("dwVersion", &self.dwVersion).field("eReason", &self.eReason).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT {}
impl ::core::default::Default for CLUSCTL_RESOURCE_STATE_CHANGE_REASON_STRUCT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_STATE_CHANGE_REASON_VERSION_1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSCTL_RESOURCE_TYPE_CODES(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_UNKNOWN: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554432i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554437i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_FLAGS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554441i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554445i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554449i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554453i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554513i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554517i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554521i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554529i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(37748830i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554533i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554537i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554553i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554557i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554561i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(37748870i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554569i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554573i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554577i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_REGISTRY_CHECKPOINTS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554601i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GET_CRYPTO_CHECKPOINTS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554613i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554837i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_SYNC_CLUSDISK_DB: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(37749150i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554997i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_NETNAME_GET_OU_FOR_VCO: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(37749358i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_PATH: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554993i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33555001i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_GEN_SCRIPT_VALIDATE_PATH: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554993i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_QUERY_DELETE: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554873i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554925i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554933i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554945i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554949i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_GET_RESOURCEID: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554989i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554953i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_REMOVE_VM_OWNERSHIP: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(37749262i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CSV_FILE: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(16777769i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_WITNESS_VALIDATE_PATH: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33554993i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_INSTALL_NODE: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(38797322i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_EVICT_NODE: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(38797326i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_CLUSTER_VERSION_CHANGED: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(38797358i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_FIXUP_ON_UPGRADE: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(38797362i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STARTING_PHASE1: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(38797366i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STARTING_PHASE2: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(38797370i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_HOLD_IO: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(38797374i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_RESUME_IO: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(38797378i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INT: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562593i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562953i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562957i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562961i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562965i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562969i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562973i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562977i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_PARTITION_INFO: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562981i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_INFO: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562949i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_REPLICATION_ADD_REPLICATION_GROUP: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562946i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562849i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(33562865i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_PREPARE_UPGRADE: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(37757162i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_UPGRADE_COMPLETED: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(37757166i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_NOTIFY_MONITOR_SHUTTING_DOWN: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(34603137i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_CHECK_DRAIN_VETO: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(34611501i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_NOTIFY_DRAIN_COMPLETE: CLUSCTL_RESOURCE_TYPE_CODES = CLUSCTL_RESOURCE_TYPE_CODES(34611505i32);
impl ::core::marker::Copy for CLUSCTL_RESOURCE_TYPE_CODES {}
impl ::core::clone::Clone for CLUSCTL_RESOURCE_TYPE_CODES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSCTL_RESOURCE_TYPE_CODES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_RESOURCE_TYPE_CODES {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSCTL_RESOURCE_TYPE_CODES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSCTL_RESOURCE_TYPE_CODES").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_FLAG_ADD_VOLUME_INFO: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_FLAG_FILTER_BY_POOL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_FLAG_INCLUDE_NON_SHARED_DISKS: u32 = 4u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT {
    pub dwFlags: u32,
    pub guidPoolFilter: ::windows::core::GUID,
}
impl ::core::marker::Copy for CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT {}
impl ::core::clone::Clone for CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT").field("dwFlags", &self.dwFlags).field("guidPoolFilter", &self.guidPoolFilter).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT {}
impl ::core::default::Default for CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INPUT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGROUPSET_STATUS_APPLICATION_READY: u64 = 8u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGROUPSET_STATUS_GROUPS_ONLINE: u64 = 2u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGROUPSET_STATUS_GROUPS_PENDING: u64 = 1u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGROUPSET_STATUS_OS_HEARTBEAT: u64 = 4u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSGROUP_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeCoreCluster: CLUSGROUP_TYPE = CLUSGROUP_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeAvailableStorage: CLUSGROUP_TYPE = CLUSGROUP_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeTemporary: CLUSGROUP_TYPE = CLUSGROUP_TYPE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeSharedVolume: CLUSGROUP_TYPE = CLUSGROUP_TYPE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeStoragePool: CLUSGROUP_TYPE = CLUSGROUP_TYPE(5i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeFileServer: CLUSGROUP_TYPE = CLUSGROUP_TYPE(100i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypePrintServer: CLUSGROUP_TYPE = CLUSGROUP_TYPE(101i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeDhcpServer: CLUSGROUP_TYPE = CLUSGROUP_TYPE(102i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeDtc: CLUSGROUP_TYPE = CLUSGROUP_TYPE(103i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeMsmq: CLUSGROUP_TYPE = CLUSGROUP_TYPE(104i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeWins: CLUSGROUP_TYPE = CLUSGROUP_TYPE(105i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeStandAloneDfs: CLUSGROUP_TYPE = CLUSGROUP_TYPE(106i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeGenericApplication: CLUSGROUP_TYPE = CLUSGROUP_TYPE(107i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeGenericService: CLUSGROUP_TYPE = CLUSGROUP_TYPE(108i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeGenericScript: CLUSGROUP_TYPE = CLUSGROUP_TYPE(109i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeIScsiNameService: CLUSGROUP_TYPE = CLUSGROUP_TYPE(110i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeVirtualMachine: CLUSGROUP_TYPE = CLUSGROUP_TYPE(111i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeTsSessionBroker: CLUSGROUP_TYPE = CLUSGROUP_TYPE(112i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeIScsiTarget: CLUSGROUP_TYPE = CLUSGROUP_TYPE(113i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeScaleoutFileServer: CLUSGROUP_TYPE = CLUSGROUP_TYPE(114i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeVMReplicaBroker: CLUSGROUP_TYPE = CLUSGROUP_TYPE(115i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeTaskScheduler: CLUSGROUP_TYPE = CLUSGROUP_TYPE(116i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeClusterUpdateAgent: CLUSGROUP_TYPE = CLUSGROUP_TYPE(117i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeScaleoutCluster: CLUSGROUP_TYPE = CLUSGROUP_TYPE(118i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeStorageReplica: CLUSGROUP_TYPE = CLUSGROUP_TYPE(119i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeVMReplicaCoordinator: CLUSGROUP_TYPE = CLUSGROUP_TYPE(120i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeCrossClusterOrchestrator: CLUSGROUP_TYPE = CLUSGROUP_TYPE(121i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeInfrastructureFileServer: CLUSGROUP_TYPE = CLUSGROUP_TYPE(122i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeCoreSddc: CLUSGROUP_TYPE = CLUSGROUP_TYPE(123i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusGroupTypeUnknown: CLUSGROUP_TYPE = CLUSGROUP_TYPE(9999i32);
impl ::core::marker::Copy for CLUSGROUP_TYPE {}
impl ::core::clone::Clone for CLUSGROUP_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSGROUP_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSGROUP_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSGROUP_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSGROUP_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_APPLICATION_READY: u64 = 1024u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_EMBEDDED_FAILURE: u64 = 32u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_LOCKED_MODE: u64 = 1u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_NETWORK_FAILURE: u64 = 128u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_OFFLINE_DUE_TO_ANTIAFFINITY_CONFLICT: u64 = 64u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_OFFLINE_NOT_LOCAL_DISK_OWNER: u64 = 2048u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_OS_HEARTBEAT: u64 = 512u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_PHYSICAL_RESOURCES_LACKING: u64 = 8u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_PREEMPTED: u64 = 2u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_UNMONITORED: u64 = 256u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_WAITING_FOR_DEPENDENCIES: u64 = 4096u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_WAITING_IN_QUEUE_FOR_MOVE: u64 = 4u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSGRP_STATUS_WAITING_TO_START: u64 = 16u64;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_BINARY {
    pub __AnonymousBase_clusapi_L5129_C41: CLUSPROP_VALUE,
    pub rgb: [u8; 1],
}
impl ::core::marker::Copy for CLUSPROP_BINARY {}
impl ::core::clone::Clone for CLUSPROP_BINARY {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_BINARY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_BINARY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_BINARY>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_BINARY {}
impl ::core::default::Default for CLUSPROP_BINARY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_SystemServices\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
pub union CLUSPROP_BUFFER_HELPER {
    pub pb: *mut u8,
    pub pw: *mut u16,
    pub pdw: *mut u32,
    pub pl: *mut i32,
    pub psz: ::windows::core::PWSTR,
    pub pList: *mut CLUSPROP_LIST,
    pub pSyntax: *mut CLUSPROP_SYNTAX,
    pub pName: *mut CLUSPROP_SZ,
    pub pValue: *mut CLUSPROP_VALUE,
    pub pBinaryValue: *mut CLUSPROP_BINARY,
    pub pWordValue: *mut CLUSPROP_WORD,
    pub pDwordValue: *mut CLUSPROP_DWORD,
    pub pLongValue: *mut CLUSPROP_LONG,
    pub pULargeIntegerValue: *mut CLUSPROP_ULARGE_INTEGER,
    pub pLargeIntegerValue: *mut CLUSPROP_LARGE_INTEGER,
    pub pStringValue: *mut CLUSPROP_SZ,
    pub pMultiSzValue: *mut CLUSPROP_SZ,
    pub pSecurityDescriptor: *mut CLUSPROP_SECURITY_DESCRIPTOR,
    pub pResourceClassValue: *mut CLUSPROP_RESOURCE_CLASS,
    pub pResourceClassInfoValue: *mut CLUSPROP_RESOURCE_CLASS_INFO,
    pub pDiskSignatureValue: *mut CLUSPROP_DWORD,
    pub pScsiAddressValue: *mut CLUSPROP_SCSI_ADDRESS,
    pub pDiskNumberValue: *mut CLUSPROP_DWORD,
    pub pPartitionInfoValue: *mut CLUSPROP_PARTITION_INFO,
    pub pRequiredDependencyValue: *mut CLUSPROP_REQUIRED_DEPENDENCY,
    pub pPartitionInfoValueEx: *mut CLUSPROP_PARTITION_INFO_EX,
    pub pPartitionInfoValueEx2: *mut CLUSPROP_PARTITION_INFO_EX2,
    pub pFileTimeValue: *mut CLUSPROP_FILETIME,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::core::marker::Copy for CLUSPROP_BUFFER_HELPER {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::core::clone::Clone for CLUSPROP_BUFFER_HELPER {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
unsafe impl ::windows::core::Abi for CLUSPROP_BUFFER_HELPER {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::core::cmp::PartialEq for CLUSPROP_BUFFER_HELPER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_BUFFER_HELPER>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::core::cmp::Eq for CLUSPROP_BUFFER_HELPER {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::core::default::Default for CLUSPROP_BUFFER_HELPER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_DWORD {
    pub __AnonymousBase_clusapi_L5149_C40: CLUSPROP_VALUE,
    pub dw: u32,
}
impl ::core::marker::Copy for CLUSPROP_DWORD {}
impl ::core::clone::Clone for CLUSPROP_DWORD {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_DWORD {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_DWORD {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_DWORD>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_DWORD {}
impl ::core::default::Default for CLUSPROP_DWORD {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUSPROP_FILETIME {
    pub __AnonymousBase_clusapi_L5225_C14: CLUSPROP_VALUE,
    pub ft: super::super::Foundation::FILETIME,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUSPROP_FILETIME {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUSPROP_FILETIME {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUSPROP_FILETIME {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUSPROP_FILETIME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_FILETIME>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUSPROP_FILETIME {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUSPROP_FILETIME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_FTSET_INFO {
    pub __AnonymousBase_clusapi_L5555_C14: CLUSPROP_VALUE,
    pub __AnonymousBase_clusapi_L5556_C14: CLUS_FTSET_INFO,
}
impl ::core::marker::Copy for CLUSPROP_FTSET_INFO {}
impl ::core::clone::Clone for CLUSPROP_FTSET_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_FTSET_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_FTSET_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_FTSET_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_FTSET_INFO {}
impl ::core::default::Default for CLUSPROP_FTSET_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSPROP_IPADDR_ENABLENETBIOS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_IPADDR_ENABLENETBIOS_DISABLED: CLUSPROP_IPADDR_ENABLENETBIOS = CLUSPROP_IPADDR_ENABLENETBIOS(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_IPADDR_ENABLENETBIOS_ENABLED: CLUSPROP_IPADDR_ENABLENETBIOS = CLUSPROP_IPADDR_ENABLENETBIOS(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_IPADDR_ENABLENETBIOS_TRACK_NIC: CLUSPROP_IPADDR_ENABLENETBIOS = CLUSPROP_IPADDR_ENABLENETBIOS(2i32);
impl ::core::marker::Copy for CLUSPROP_IPADDR_ENABLENETBIOS {}
impl ::core::clone::Clone for CLUSPROP_IPADDR_ENABLENETBIOS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSPROP_IPADDR_ENABLENETBIOS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_IPADDR_ENABLENETBIOS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSPROP_IPADDR_ENABLENETBIOS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSPROP_IPADDR_ENABLENETBIOS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_LARGE_INTEGER {
    pub __AnonymousBase_clusapi_L5199_C14: CLUSPROP_VALUE,
    pub li: i64,
}
impl ::core::marker::Copy for CLUSPROP_LARGE_INTEGER {}
impl ::core::clone::Clone for CLUSPROP_LARGE_INTEGER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_LARGE_INTEGER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_LARGE_INTEGER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_LARGE_INTEGER>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_LARGE_INTEGER {}
impl ::core::default::Default for CLUSPROP_LARGE_INTEGER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_LIST {
    pub nPropertyCount: u32,
    pub PropertyName: CLUSPROP_SZ,
}
impl ::core::marker::Copy for CLUSPROP_LIST {}
impl ::core::clone::Clone for CLUSPROP_LIST {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_LIST {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_LIST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_LIST>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_LIST {}
impl ::core::default::Default for CLUSPROP_LIST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_LONG {
    pub __AnonymousBase_clusapi_L5159_C39: CLUSPROP_VALUE,
    pub l: i32,
}
impl ::core::marker::Copy for CLUSPROP_LONG {}
impl ::core::clone::Clone for CLUSPROP_LONG {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_LONG {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_LONG {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_LONG>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_LONG {}
impl ::core::default::Default for CLUSPROP_LONG {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_PARTITION_INFO {
    pub __AnonymousBase_clusapi_L5507_C14: CLUSPROP_VALUE,
    pub __AnonymousBase_clusapi_L5508_C14: CLUS_PARTITION_INFO,
}
impl ::core::marker::Copy for CLUSPROP_PARTITION_INFO {}
impl ::core::clone::Clone for CLUSPROP_PARTITION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_PARTITION_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_PARTITION_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_PARTITION_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_PARTITION_INFO {}
impl ::core::default::Default for CLUSPROP_PARTITION_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_PARTITION_INFO_EX {
    pub __AnonymousBase_clusapi_L5519_C14: CLUSPROP_VALUE,
    pub __AnonymousBase_clusapi_L5520_C14: CLUS_PARTITION_INFO_EX,
}
impl ::core::marker::Copy for CLUSPROP_PARTITION_INFO_EX {}
impl ::core::clone::Clone for CLUSPROP_PARTITION_INFO_EX {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_PARTITION_INFO_EX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_PARTITION_INFO_EX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_PARTITION_INFO_EX>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_PARTITION_INFO_EX {}
impl ::core::default::Default for CLUSPROP_PARTITION_INFO_EX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_PARTITION_INFO_EX2 {
    pub __AnonymousBase_clusapi_L5533_C14: CLUSPROP_PARTITION_INFO_EX,
    pub __AnonymousBase_clusapi_L5534_C14: CLUS_PARTITION_INFO_EX2,
}
impl ::core::marker::Copy for CLUSPROP_PARTITION_INFO_EX2 {}
impl ::core::clone::Clone for CLUSPROP_PARTITION_INFO_EX2 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_PARTITION_INFO_EX2 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_PARTITION_INFO_EX2 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_PARTITION_INFO_EX2>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_PARTITION_INFO_EX2 {}
impl ::core::default::Default for CLUSPROP_PARTITION_INFO_EX2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSPROP_PIFLAGS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_PIFLAG_STICKY: CLUSPROP_PIFLAGS = CLUSPROP_PIFLAGS(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_PIFLAG_REMOVABLE: CLUSPROP_PIFLAGS = CLUSPROP_PIFLAGS(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_PIFLAG_USABLE: CLUSPROP_PIFLAGS = CLUSPROP_PIFLAGS(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_PIFLAG_DEFAULT_QUORUM: CLUSPROP_PIFLAGS = CLUSPROP_PIFLAGS(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_PIFLAG_USABLE_FOR_CSV: CLUSPROP_PIFLAGS = CLUSPROP_PIFLAGS(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_PIFLAG_ENCRYPTION_ENABLED: CLUSPROP_PIFLAGS = CLUSPROP_PIFLAGS(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_PIFLAG_RAW: CLUSPROP_PIFLAGS = CLUSPROP_PIFLAGS(64i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_PIFLAG_UNKNOWN: CLUSPROP_PIFLAGS = CLUSPROP_PIFLAGS(-2147483648i32);
impl ::core::marker::Copy for CLUSPROP_PIFLAGS {}
impl ::core::clone::Clone for CLUSPROP_PIFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSPROP_PIFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_PIFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSPROP_PIFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSPROP_PIFLAGS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub union CLUSPROP_REQUIRED_DEPENDENCY {
    pub Value: CLUSPROP_VALUE,
    pub ResClass: CLUSPROP_RESOURCE_CLASS,
    pub ResTypeName: CLUSPROP_SZ,
}
impl ::core::marker::Copy for CLUSPROP_REQUIRED_DEPENDENCY {}
impl ::core::clone::Clone for CLUSPROP_REQUIRED_DEPENDENCY {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_REQUIRED_DEPENDENCY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_REQUIRED_DEPENDENCY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_REQUIRED_DEPENDENCY>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_REQUIRED_DEPENDENCY {}
impl ::core::default::Default for CLUSPROP_REQUIRED_DEPENDENCY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_RESOURCE_CLASS {
    pub __AnonymousBase_clusapi_L5250_C14: CLUSPROP_VALUE,
    pub rc: CLUSTER_RESOURCE_CLASS,
}
impl ::core::marker::Copy for CLUSPROP_RESOURCE_CLASS {}
impl ::core::clone::Clone for CLUSPROP_RESOURCE_CLASS {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_RESOURCE_CLASS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_RESOURCE_CLASS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_RESOURCE_CLASS>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_RESOURCE_CLASS {}
impl ::core::default::Default for CLUSPROP_RESOURCE_CLASS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_RESOURCE_CLASS_INFO {
    pub __AnonymousBase_clusapi_L5261_C14: CLUSPROP_VALUE,
    pub __AnonymousBase_clusapi_L5262_C14: CLUS_RESOURCE_CLASS_INFO,
}
impl ::core::marker::Copy for CLUSPROP_RESOURCE_CLASS_INFO {}
impl ::core::clone::Clone for CLUSPROP_RESOURCE_CLASS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_RESOURCE_CLASS_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_RESOURCE_CLASS_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_RESOURCE_CLASS_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_RESOURCE_CLASS_INFO {}
impl ::core::default::Default for CLUSPROP_RESOURCE_CLASS_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_SCSI_ADDRESS {
    pub __AnonymousBase_clusapi_L5583_C14: CLUSPROP_VALUE,
    pub __AnonymousBase_clusapi_L5584_C14: CLUS_SCSI_ADDRESS,
}
impl ::core::marker::Copy for CLUSPROP_SCSI_ADDRESS {}
impl ::core::clone::Clone for CLUSPROP_SCSI_ADDRESS {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_SCSI_ADDRESS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_SCSI_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_SCSI_ADDRESS>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_SCSI_ADDRESS {}
impl ::core::default::Default for CLUSPROP_SCSI_ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_SystemServices\"`*"]
#[cfg(feature = "Win32_System_SystemServices")]
pub struct CLUSPROP_SECURITY_DESCRIPTOR {
    pub __AnonymousBase_clusapi_L5211_C54: CLUSPROP_VALUE,
    pub Anonymous: CLUSPROP_SECURITY_DESCRIPTOR_0,
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::marker::Copy for CLUSPROP_SECURITY_DESCRIPTOR {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::clone::Clone for CLUSPROP_SECURITY_DESCRIPTOR {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
unsafe impl ::windows::core::Abi for CLUSPROP_SECURITY_DESCRIPTOR {
    type Abi = Self;
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::cmp::PartialEq for CLUSPROP_SECURITY_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_SECURITY_DESCRIPTOR>()) == 0 }
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::cmp::Eq for CLUSPROP_SECURITY_DESCRIPTOR {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::default::Default for CLUSPROP_SECURITY_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_SystemServices\"`*"]
#[cfg(feature = "Win32_System_SystemServices")]
pub union CLUSPROP_SECURITY_DESCRIPTOR_0 {
    pub sd: super::super::System::SystemServices::SECURITY_DESCRIPTOR_RELATIVE,
    pub rgbSecurityDescriptor: [u8; 1],
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::marker::Copy for CLUSPROP_SECURITY_DESCRIPTOR_0 {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::clone::Clone for CLUSPROP_SECURITY_DESCRIPTOR_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
unsafe impl ::windows::core::Abi for CLUSPROP_SECURITY_DESCRIPTOR_0 {
    type Abi = Self;
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::cmp::PartialEq for CLUSPROP_SECURITY_DESCRIPTOR_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_SECURITY_DESCRIPTOR_0>()) == 0 }
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::cmp::Eq for CLUSPROP_SECURITY_DESCRIPTOR_0 {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::core::default::Default for CLUSPROP_SECURITY_DESCRIPTOR_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub union CLUSPROP_SYNTAX {
    pub dw: u32,
    pub Anonymous: CLUSPROP_SYNTAX_0,
}
impl ::core::marker::Copy for CLUSPROP_SYNTAX {}
impl ::core::clone::Clone for CLUSPROP_SYNTAX {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_SYNTAX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_SYNTAX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_SYNTAX>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_SYNTAX {}
impl ::core::default::Default for CLUSPROP_SYNTAX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_SYNTAX_0 {
    pub wFormat: u16,
    pub wType: u16,
}
impl ::core::marker::Copy for CLUSPROP_SYNTAX_0 {}
impl ::core::clone::Clone for CLUSPROP_SYNTAX_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSPROP_SYNTAX_0 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSPROP_SYNTAX_0").field("wFormat", &self.wFormat).field("wType", &self.wType).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_SYNTAX_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_SYNTAX_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_SYNTAX_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_SYNTAX_0 {}
impl ::core::default::Default for CLUSPROP_SYNTAX_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_SZ {
    pub __AnonymousBase_clusapi_L5169_C37: CLUSPROP_VALUE,
    pub sz: [u16; 1],
}
impl ::core::marker::Copy for CLUSPROP_SZ {}
impl ::core::clone::Clone for CLUSPROP_SZ {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_SZ {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_SZ {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_SZ>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_SZ {}
impl ::core::default::Default for CLUSPROP_SZ {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_ULARGE_INTEGER {
    pub __AnonymousBase_clusapi_L5186_C14: CLUSPROP_VALUE,
    pub li: u64,
}
impl ::core::marker::Copy for CLUSPROP_ULARGE_INTEGER {}
impl ::core::clone::Clone for CLUSPROP_ULARGE_INTEGER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_ULARGE_INTEGER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_ULARGE_INTEGER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_ULARGE_INTEGER>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_ULARGE_INTEGER {}
impl ::core::default::Default for CLUSPROP_ULARGE_INTEGER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_VALUE {
    pub Syntax: CLUSPROP_SYNTAX,
    pub cbLength: u32,
}
impl ::core::marker::Copy for CLUSPROP_VALUE {}
impl ::core::clone::Clone for CLUSPROP_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_VALUE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_VALUE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_VALUE>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_VALUE {}
impl ::core::default::Default for CLUSPROP_VALUE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSPROP_WORD {
    pub __AnonymousBase_clusapi_L5139_C39: CLUSPROP_VALUE,
    pub w: u16,
}
impl ::core::marker::Copy for CLUSPROP_WORD {}
impl ::core::clone::Clone for CLUSPROP_WORD {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSPROP_WORD {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSPROP_WORD {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSPROP_WORD>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSPROP_WORD {}
impl ::core::default::Default for CLUSPROP_WORD {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_DATABASE_ISOLATE_READ: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_DATABASE_SYNC_WRITE_TO_ALL_NODES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_KEYNAME_OBJECTGUIDS: &'static str = "ObjectGUIDs";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_AFFINITYRULE_ENABLED: &'static str = "Enabled";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_AFFINITYRULE_GROUPS: &'static str = "Groups";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_AFFINITYRULE_NAME: &'static str = "Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_AFFINITYRULE_TYPE: &'static str = "RuleType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CLOUDWITNESS_ACCOUNT_NAME: &'static str = "AccountName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CLOUDWITNESS_CONTAINER_NAME: &'static str = "ContainerName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CLOUDWITNESS_ENDPOINT_INFO: &'static str = "EndpointInfo";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CLOUDWITNESS_PRIMARY_KEY: &'static str = "PrimaryKey";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CLOUDWITNESS_PRIMARY_TOKEN: &'static str = "PrimaryToken";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CLUS_DEFAULT_NETWORK_ROLE: &'static str = "DefaultNetworkRole";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CLUS_DESC: &'static str = "Description";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CLUS_SD: &'static str = "Security Descriptor";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CROSS_SITE_DELAY: &'static str = "CrossSiteDelay";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CROSS_SITE_THRESHOLD: &'static str = "CrossSiteThreshold";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CROSS_SUBNET_DELAY: &'static str = "CrossSubnetDelay";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CROSS_SUBNET_THRESHOLD: &'static str = "CrossSubnetThreshold";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CSV_BLOCK_CACHE: &'static str = "BlockCacheSize";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_CSV_MDS_SD: &'static str = "SharedVolumeSecurityDescriptor";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_DATABASE_READ_WRITE_MODE: &'static str = "DatabaseReadWriteMode";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_DDA_DEVICE_ALLOCATIONS: &'static str = "DdaDeviceAllocations";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_DHCP_BACKUP_PATH: &'static str = "BackupPath";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_DHCP_DATABASE_PATH: &'static str = "DatabasePath";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_DRAIN_ON_SHUTDOWN: &'static str = "DrainOnShutdown";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_ENABLED_EVENT_LOGS: &'static str = "EnabledEventLogs";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FAILOVER_MOVE_MIGRATION_TYPE: &'static str = "FailoverMoveMigrationType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_CA_TIMEOUT: &'static str = "CATimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_HIDE_SUBDIR_SHARES: &'static str = "HideSubDirShares";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_IS_DFS_ROOT: &'static str = "IsDfsRoot";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_MAX_USERS: &'static str = "MaxUsers";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_PATH: &'static str = "Path";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_REMARK: &'static str = "Remark";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_SD: &'static str = "Security Descriptor";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_SERVER_NAME: &'static str = "ServerName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_SHARE_FLAGS: &'static str = "ShareFlags";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_SHARE_NAME: &'static str = "ShareName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FILESHR_SHARE_SUBDIRS: &'static str = "ShareSubDirs";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FIXQUORUM: &'static str = "FixQuorum";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FSWITNESS_ARB_DELAY: &'static str = "ArbitrationDelay";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FSWITNESS_IMPERSONATE_CNO: &'static str = "ImpersonateCNO";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FSWITNESS_SHARE_PATH: &'static str = "SharePath";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_FUNCTIONAL_LEVEL: &'static str = "ClusterFunctionalLevel";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GENAPP_COMMAND_LINE: &'static str = "CommandLine";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GENAPP_CURRENT_DIRECTORY: &'static str = "CurrentDirectory";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GENAPP_USE_NETWORK_NAME: &'static str = "UseNetworkName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GENSCRIPT_SCRIPT_FILEPATH: &'static str = "ScriptFilepath";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GENSVC_SERVICE_NAME: &'static str = "ServiceName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GENSVC_STARTUP_PARAMS: &'static str = "StartupParameters";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GENSVC_USE_NETWORK_NAME: &'static str = "UseNetworkName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GPUP_DEVICE_ALLOCATIONS: &'static str = "GpupDeviceAllocations";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_AVAILABILITY_SET_INDEX_TO_NODE_MAPPING: &'static str = "NodeDomainInfo";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_FAULT_DOMAINS: &'static str = "FaultDomains";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_IS_AVAILABILITY_SET: &'static str = "IsAvailabilitySet";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_IS_GLOBAL: &'static str = "IsGlobal";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_NAME: &'static str = "Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_RESERVE_NODE: &'static str = "ReserveSpareNode";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_STARTUP_COUNT: &'static str = "StartupCount";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_STARTUP_DELAY: &'static str = "StartupDelay";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_STARTUP_SETTING: &'static str = "StartupSetting";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_STATUS_INFORMATION: &'static str = "StatusInformation";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUPSET_UPDATE_DOMAINS: &'static str = "UpdateDomains";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GROUP_DEPENDENCY_TIMEOUT: &'static str = "GroupDependencyTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_ANTI_AFFINITY_CLASS_NAME: &'static str = "AntiAffinityClassNames";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_CCF_EPOCH: &'static str = "CCFEpoch";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_CCF_EPOCH_HIGH: &'static str = "CCFEpochHigh";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_COLD_START_SETTING: &'static str = "ColdStartSetting";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_DEFAULT_OWNER: &'static str = "DefaultOwner";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_DESC: &'static str = "Description";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_FAILBACK_TYPE: &'static str = "AutoFailbackType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_FAILBACK_WIN_END: &'static str = "FailbackWindowEnd";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_FAILBACK_WIN_START: &'static str = "FailbackWindowStart";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_FAILOVER_PERIOD: &'static str = "FailoverPeriod";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_FAILOVER_THRESHOLD: &'static str = "FailoverThreshold";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_FAULT_DOMAIN: &'static str = "FaultDomain";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_LOCK_MOVE: &'static str = "LockedFromMoving";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_NAME: &'static str = "Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_PERSISTENT_STATE: &'static str = "PersistentState";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_PLACEMENT_OPTIONS: &'static str = "PlacementOptions";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_PREFERRED_SITE: &'static str = "PreferredSite";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_PRIORITY: &'static str = "Priority";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_RESILIENCY_PERIOD: &'static str = "ResiliencyPeriod";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_START_DELAY: &'static str = "GroupStartDelay";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_STATUS_INFORMATION: &'static str = "StatusInformation";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_TYPE: &'static str = "GroupType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_GRP_UPDATE_DOMAIN: &'static str = "UpdateDomain";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IGNORE_PERSISTENT_STATE: &'static str = "IgnorePersistentStateOnStartup";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_ADDRESS: &'static str = "Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_DHCP_ADDRESS: &'static str = "DhcpAddress";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_DHCP_SERVER: &'static str = "DhcpServer";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_DHCP_SUBNET_MASK: &'static str = "DhcpSubnetMask";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_ENABLE_DHCP: &'static str = "EnableDhcp";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_ENABLE_NETBIOS: &'static str = "EnableNetBIOS";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_LEASE_OBTAINED_TIME: &'static str = "LeaseObtainedTime";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_LEASE_TERMINATES_TIME: &'static str = "LeaseExpiresTime";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_NETWORK: &'static str = "Network";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_OVERRIDE_ADDRMATCH: &'static str = "OverrideAddressMatch";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_PROBE_FAILURE_THRESHOLD: &'static str = "ProbeFailureThreshold";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_PROBE_PORT: &'static str = "ProbePort";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_SHARED_NETNAME: &'static str = "SharedNetname";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_SUBNET_MASK: &'static str = "SubnetMask";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_T1: &'static str = "T1";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPADDR_T2: &'static str = "T2";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPV6_NATIVE_ADDRESS: &'static str = "Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPV6_NATIVE_NETWORK: &'static str = "Network";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPV6_NATIVE_PREFIX_LENGTH: &'static str = "PrefixLength";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPV6_TUNNEL_ADDRESS: &'static str = "Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_IPV6_TUNNEL_TUNNELTYPE: &'static str = "TunnelType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_LAST_RECENT_EVENTS_RESET_TIME: &'static str = "RecentEventsResetTime";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_LOG_FILE_PATH: &'static str = "LogFilePath";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_MESSAGE_BUFFER_LENGTH: &'static str = "MessageBufferLength";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_MIXED_MODE: &'static str = "MixedMode";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETFT_IPSEC_ENABLED: &'static str = "NetftIPSecEnabled";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_ADAPTER_ID: &'static str = "AdapterId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_ADAPTER_NAME: &'static str = "Adapter";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_ADDRESS: &'static str = "Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_DESC: &'static str = "Description";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_DHCP_ENABLED: &'static str = "DhcpEnabled";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_IPV4_ADDRESSES: &'static str = "IPv4Addresses";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_IPV6_ADDRESSES: &'static str = "IPv6Addresses";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_NAME: &'static str = "Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_NETWORK: &'static str = "Network";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETIFACE_NODE: &'static str = "Node";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_AD_AWARE: &'static str = "ADAware";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_ALIASES: &'static str = "Aliases";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_CONTAINERGUID: &'static str = "CryptoContainerGUID";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_CREATING_DC: &'static str = "CreatingDC";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_DNN_DISABLE_CLONES: &'static str = "DisableClones";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_DNS_NAME: &'static str = "DnsName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_DNS_SUFFIX: &'static str = "DnsSuffix";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_EXCLUDE_NETWORKS: &'static str = "ExcludeNetworks";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_HOST_TTL: &'static str = "HostRecordTTL";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_IN_USE_NETWORKS: &'static str = "InUseNetworks";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_LAST_DNS_UPDATE: &'static str = "LastDNSUpdateTime";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_NAME: &'static str = "Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_OBJECT_ID: &'static str = "ObjectGUID";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_PUBLISH_PTR: &'static str = "PublishPTRRecords";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_REGISTER_ALL_IP: &'static str = "RegisterAllProvidersIP";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_REMAP_PIPE_NAMES: &'static str = "RemapPipeNames";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_REMOVEVCO_ONDELETE: &'static str = "DeleteVcoOnResCleanup";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_RESOURCE_DATA: &'static str = "ResourceData";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_STATUS_DNS: &'static str = "StatusDNS";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_STATUS_KERBEROS: &'static str = "StatusKerberos";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_STATUS_NETBIOS: &'static str = "StatusNetBIOS";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NETNAME_VCO_CONTAINER: &'static str = "VcoContainer";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_ADDRESS: &'static str = "Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_ADDRESS_MASK: &'static str = "AddressMask";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_AUTOMETRIC: &'static str = "AutoMetric";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_DESC: &'static str = "Description";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_IPV4_ADDRESSES: &'static str = "IPv4Addresses";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_IPV4_PREFIXLENGTHS: &'static str = "IPv4PrefixLengths";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_IPV6_ADDRESSES: &'static str = "IPv6Addresses";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_IPV6_PREFIXLENGTHS: &'static str = "IPv6PrefixLengths";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_METRIC: &'static str = "Metric";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_NAME: &'static str = "Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_RDMA_CAPABLE: &'static str = "RdmaCapable";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_ROLE: &'static str = "Role";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_RSS_CAPABLE: &'static str = "RssCapable";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NET_SPEED: &'static str = "LinkSpeed";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_BUILD_NUMBER: &'static str = "BuildNumber";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_CSDVERSION: &'static str = "CSDVersion";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_DESC: &'static str = "Description";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_DRAIN_STATUS: &'static str = "NodeDrainStatus";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_DRAIN_TARGET: &'static str = "NodeDrainTarget";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_DYNAMIC_WEIGHT: &'static str = "DynamicWeight";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_FAULT_DOMAIN: &'static str = "FaultDomain";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_FDID: &'static str = "FaultDomainId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_HIGHEST_VERSION: &'static str = "NodeHighestVersion";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_IS_PRIMARY: &'static str = "IsPrimary";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_LOWEST_VERSION: &'static str = "NodeLowestVersion";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_MAJOR_VERSION: &'static str = "MajorVersion";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_MANUFACTURER: &'static str = "Manufacturer";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_MINOR_VERSION: &'static str = "MinorVersion";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_MODEL: &'static str = "Model";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_NAME: &'static str = "NodeName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_NEEDS_PQ: &'static str = "NeedsPreventQuorum";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_SERIALNUMBER: &'static str = "SerialNumber";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_STATUS_INFO: &'static str = "StatusInformation";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_NODE_WEIGHT: &'static str = "NodeWeight";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_CSVBLOCKCACHE: &'static str = "EnableBlockCache";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_CSVSNAPSHOTAGELIMIT: &'static str = "SnapshotAgeLimit";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_CSVSNAPSHOTDIFFAREASIZE: &'static str = "SnapshotDiffSize";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_CSVWRITETHROUGH: &'static str = "CsvEnforceWriteThrough";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKARBINTERVAL: &'static str = "DiskArbInterval";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKARBTYPE: &'static str = "DiskArbType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKGUID: &'static str = "DiskGuid";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKIDGUID: &'static str = "DiskIdGuid";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKIDTYPE: &'static str = "DiskIdType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKIODELAY: &'static str = "MaxIoLatency";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKPATH: &'static str = "DiskPath";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKRECOVERYACTION: &'static str = "DiskRecoveryAction";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKRELOAD: &'static str = "DiskReload";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKRUNCHKDSK: &'static str = "DiskRunChkDsk";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKSIGNATURE: &'static str = "DiskSignature";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKUNIQUEIDS: &'static str = "DiskUniqueIds";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_DISKVOLUMEINFO: &'static str = "DiskVolumeInfo";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_FASTONLINEARBITRATE: &'static str = "FastOnlineArbitrate";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_MAINTMODE: &'static str = "MaintenanceMode";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_MIGRATEFIXUP: &'static str = "MigrateDriveLetters";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_SPACEIDGUID: &'static str = "VirtualDiskId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PHYSDISK_VOLSNAPACTIVATETIMEOUT: &'static str = "VolsnapActivateTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PLACEMENT_OPTIONS: &'static str = "PlacementOptions";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PLUMB_ALL_CROSS_SUBNET_ROUTES: &'static str = "PlumbAllCrossSubnetRoutes";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PREVENTQUORUM: &'static str = "PreventQuorum";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PRTSPOOL_DEFAULT_SPOOL_DIR: &'static str = "DefaultSpoolDirectory";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_PRTSPOOL_TIMEOUT: &'static str = "JobCompletionTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_QUARANTINE_DURATION: &'static str = "QuarantineDuration";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_QUARANTINE_THRESHOLD: &'static str = "QuarantineThreshold";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_QUORUM_ARBITRATION_TIMEOUT: &'static str = "QuorumArbitrationTimeMax";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESILIENCY_DEFAULT_SECONDS: &'static str = "ResiliencyDefaultPeriod";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESILIENCY_LEVEL: &'static str = "ResiliencyLevel";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_ADMIN_EXTENSIONS: &'static str = "AdminExtensions";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_DEADLOCK_TIMEOUT: &'static str = "DeadlockTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_DESC: &'static str = "Description";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_DLL_NAME: &'static str = "DllName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_DUMP_LOG_QUERY: &'static str = "DumpLogQuery";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_DUMP_POLICY: &'static str = "DumpPolicy";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_DUMP_SERVICES: &'static str = "DumpServices";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_ENABLED_EVENT_LOGS: &'static str = "EnabledEventLogs";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_IS_ALIVE: &'static str = "IsAlivePollInterval";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_LOOKS_ALIVE: &'static str = "LooksAlivePollInterval";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_MAX_MONITORS: &'static str = "MaximumMonitors";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_NAME: &'static str = "Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_PENDING_TIMEOUT: &'static str = "PendingTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_WPR_PROFILES: &'static str = "WprProfiles";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RESTYPE_WPR_START_AFTER: &'static str = "WprStartAfter";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_DATA1: &'static str = "ResourceSpecificData1";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_DATA2: &'static str = "ResourceSpecificData2";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_DEADLOCK_TIMEOUT: &'static str = "DeadlockTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_DESC: &'static str = "Description";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_EMBEDDED_FAILURE_ACTION: &'static str = "EmbeddedFailureAction";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_IS_ALIVE: &'static str = "IsAlivePollInterval";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_LAST_OPERATION_STATUS_CODE: &'static str = "LastOperationStatusCode";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_LOOKS_ALIVE: &'static str = "LooksAlivePollInterval";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_MONITOR_PID: &'static str = "MonitorProcessId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_NAME: &'static str = "Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_PENDING_TIMEOUT: &'static str = "PendingTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_PERSISTENT_STATE: &'static str = "PersistentState";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_RESTART_ACTION: &'static str = "RestartAction";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_RESTART_DELAY: &'static str = "RestartDelay";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_RESTART_PERIOD: &'static str = "RestartPeriod";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_RESTART_THRESHOLD: &'static str = "RestartThreshold";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_RETRY_PERIOD_ON_FAILURE: &'static str = "RetryPeriodOnFailure";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_SEPARATE_MONITOR: &'static str = "SeparateMonitor";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_STATUS: &'static str = "ResourceSpecificStatus";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_STATUS_INFORMATION: &'static str = "StatusInformation";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_RES_TYPE: &'static str = "Type";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_ROUTE_HISTORY_LENGTH: &'static str = "RouteHistoryLength";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_SAME_SUBNET_DELAY: &'static str = "SameSubnetDelay";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_SAME_SUBNET_THRESHOLD: &'static str = "SameSubnetThreshold";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_SHUTDOWN_TIMEOUT_MINUTES: &'static str = "ShutdownTimeoutInMinutes";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_SOFS_SMBASYMMETRYMODE: &'static str = "SmbAsymmetryMode";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_START_MEMORY: &'static str = "StartMemory";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_DESCRIPTION: &'static str = "VirtualDiskDescription";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_HEALTH: &'static str = "VirtualDiskHealth";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_NAME: &'static str = "VirtualDiskName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLARBITRATE: &'static str = "Arbitrate";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLCONSUMEDCAPACITY: &'static str = "ConsumedCapacity";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLDESC: &'static str = "Description";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLDRIVEIDS: &'static str = "DriveIds";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLHEALTH: &'static str = "Health";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLIDGUID: &'static str = "PoolId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLNAME: &'static str = "Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLQUORUMSHARE: &'static str = "PoolQuorumShare";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLQUORUMUSERACCOUNT: &'static str = "PoolQuorumUserAccount";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLREEVALTIMEOUT: &'static str = "ReEvaluatePlacementTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLSTATE: &'static str = "State";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_POOLTOTALCAPACITY: &'static str = "TotalCapacity";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_PROVISIONING: &'static str = "VirtualDiskProvisioning";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_RESILIENCYCOLUMNS: &'static str = "VirtualDiskResiliencyColumns";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_RESILIENCYINTERLEAVE: &'static str = "VirtualDiskResiliencyInterleave";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_RESILIENCYTYPE: &'static str = "VirtualDiskResiliencyType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_STORAGESPACE_STATE: &'static str = "VirtualDiskState";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_UPGRADE_VERSION: &'static str = "ClusterUpgradeVersion";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VIP_ADAPTER_NAME: &'static str = "AdapterName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VIP_ADDRESS: &'static str = "Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VIP_PREFIX_LENGTH: &'static str = "PrefixLength";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VIP_RDID: &'static str = "RDID";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VIP_VSID: &'static str = "VSID";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VIRTUAL_NUMA_COUNT: &'static str = "VirtualNumaCount";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VSSTASK_APPNAME: &'static str = "ApplicationName";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VSSTASK_APPPARAMS: &'static str = "ApplicationParams";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VSSTASK_CURRENTDIRECTORY: &'static str = "CurrentDirectory";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_VSSTASK_TRIGGERARRAY: &'static str = "TriggerArray";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_WINS_BACKUP_PATH: &'static str = "BackupPath";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_WINS_DATABASE_PATH: &'static str = "DatabasePath";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_NAME_WITNESS_DYNAMIC_WEIGHT: &'static str = "WitnessDynamicWeight";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_DO_NOT_COLLECT_WER_REPORT: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_DUMP_NOW: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_INSUFFICIENT_MEMORY: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_INSUFFICIENT_OTHER_RESOURCES: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_INSUFFICIENT_PROCESSOR: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_INVALID_PARAMETERS: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_NETWORK_NOT_AVAILABLE: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_OFFLINE_BUSY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_OFFLINE_DESTINATION_REJECTED: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_OFFLINE_DESTINATION_THROTTLED: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRESDLL_STATUS_OFFLINE_SOURCE_THROTTLED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_NAME_GET_OPERATION_CONTEXT_FLAGS: &'static str = "Flags";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_APPLICATION_READY: u64 = 256u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_EMBEDDED_FAILURE: u64 = 2u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_FAILED_DUE_TO_INSUFFICIENT_CPU: u64 = 4u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_FAILED_DUE_TO_INSUFFICIENT_GENERIC_RESOURCES: u64 = 16u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_FAILED_DUE_TO_INSUFFICIENT_MEMORY: u64 = 8u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_LOCKED_MODE: u64 = 1u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_NETWORK_FAILURE: u64 = 32u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_OFFLINE_NOT_LOCAL_DISK_OWNER: u64 = 512u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_OS_HEARTBEAT: u64 = 128u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSRES_STATUS_UNMONITORED: u64 = 64u64;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTERSET_OBJECT_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTERSET_OBJECT_TYPE_NONE: CLUSTERSET_OBJECT_TYPE = CLUSTERSET_OBJECT_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTERSET_OBJECT_TYPE_MEMBER: CLUSTERSET_OBJECT_TYPE = CLUSTERSET_OBJECT_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTERSET_OBJECT_TYPE_WORKLOAD: CLUSTERSET_OBJECT_TYPE = CLUSTERSET_OBJECT_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTERSET_OBJECT_TYPE_DATABASE: CLUSTERSET_OBJECT_TYPE = CLUSTERSET_OBJECT_TYPE(3i32);
impl ::core::marker::Copy for CLUSTERSET_OBJECT_TYPE {}
impl ::core::clone::Clone for CLUSTERSET_OBJECT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTERSET_OBJECT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTERSET_OBJECT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTERSET_OBJECT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTERSET_OBJECT_TYPE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTERVERSIONINFO {
    pub dwVersionInfoSize: u32,
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub BuildNumber: u16,
    pub szVendorId: [u16; 64],
    pub szCSDVersion: [u16; 64],
    pub dwClusterHighestVersion: u32,
    pub dwClusterLowestVersion: u32,
    pub dwFlags: u32,
    pub dwReserved: u32,
}
impl ::core::marker::Copy for CLUSTERVERSIONINFO {}
impl ::core::clone::Clone for CLUSTERVERSIONINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTERVERSIONINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTERVERSIONINFO")
            .field("dwVersionInfoSize", &self.dwVersionInfoSize)
            .field("MajorVersion", &self.MajorVersion)
            .field("MinorVersion", &self.MinorVersion)
            .field("BuildNumber", &self.BuildNumber)
            .field("szVendorId", &self.szVendorId)
            .field("szCSDVersion", &self.szCSDVersion)
            .field("dwClusterHighestVersion", &self.dwClusterHighestVersion)
            .field("dwClusterLowestVersion", &self.dwClusterLowestVersion)
            .field("dwFlags", &self.dwFlags)
            .field("dwReserved", &self.dwReserved)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTERVERSIONINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTERVERSIONINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTERVERSIONINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTERVERSIONINFO {}
impl ::core::default::Default for CLUSTERVERSIONINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTERVERSIONINFO_NT4 {
    pub dwVersionInfoSize: u32,
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub BuildNumber: u16,
    pub szVendorId: [u16; 64],
    pub szCSDVersion: [u16; 64],
}
impl ::core::marker::Copy for CLUSTERVERSIONINFO_NT4 {}
impl ::core::clone::Clone for CLUSTERVERSIONINFO_NT4 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTERVERSIONINFO_NT4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTERVERSIONINFO_NT4").field("dwVersionInfoSize", &self.dwVersionInfoSize).field("MajorVersion", &self.MajorVersion).field("MinorVersion", &self.MinorVersion).field("BuildNumber", &self.BuildNumber).field("szVendorId", &self.szVendorId).field("szCSDVersion", &self.szCSDVersion).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTERVERSIONINFO_NT4 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTERVERSIONINFO_NT4 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTERVERSIONINFO_NT4>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTERVERSIONINFO_NT4 {}
impl ::core::default::Default for CLUSTERVERSIONINFO_NT4 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ADD_EVICT_DELAY: &'static str = "AddEvictDelay";
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUSTER_AVAILABILITY_SET_CONFIG {
    pub dwVersion: u32,
    pub dwUpdateDomains: u32,
    pub dwFaultDomains: u32,
    pub bReserveSpareNode: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUSTER_AVAILABILITY_SET_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUSTER_AVAILABILITY_SET_CONFIG {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUSTER_AVAILABILITY_SET_CONFIG {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_AVAILABILITY_SET_CONFIG").field("dwVersion", &self.dwVersion).field("dwUpdateDomains", &self.dwUpdateDomains).field("dwFaultDomains", &self.dwFaultDomains).field("bReserveSpareNode", &self.bReserveSpareNode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUSTER_AVAILABILITY_SET_CONFIG {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUSTER_AVAILABILITY_SET_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_AVAILABILITY_SET_CONFIG>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUSTER_AVAILABILITY_SET_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUSTER_AVAILABILITY_SET_CONFIG {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_AVAILABILITY_SET_CONFIG_V1: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_BATCH_COMMAND {
    pub Command: CLUSTER_REG_COMMAND,
    pub dwOptions: u32,
    pub wzName: ::windows::core::PCWSTR,
    pub lpData: *const u8,
    pub cbData: u32,
}
impl ::core::marker::Copy for CLUSTER_BATCH_COMMAND {}
impl ::core::clone::Clone for CLUSTER_BATCH_COMMAND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_BATCH_COMMAND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_BATCH_COMMAND").field("Command", &self.Command).field("dwOptions", &self.dwOptions).field("wzName", &self.wzName).field("lpData", &self.lpData).field("cbData", &self.cbData).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_BATCH_COMMAND {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_BATCH_COMMAND {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_BATCH_COMMAND>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_BATCH_COMMAND {}
impl ::core::default::Default for CLUSTER_BATCH_COMMAND {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_STATE: CLUSTER_CHANGE = CLUSTER_CHANGE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_DELETED: CLUSTER_CHANGE = CLUSTER_CHANGE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_ADDED: CLUSTER_CHANGE = CLUSTER_CHANGE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_PROPERTY: CLUSTER_CHANGE = CLUSTER_CHANGE(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_NAME: CLUSTER_CHANGE = CLUSTER_CHANGE(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_ATTRIBUTES: CLUSTER_CHANGE = CLUSTER_CHANGE(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_VALUE: CLUSTER_CHANGE = CLUSTER_CHANGE(64i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_SUBTREE: CLUSTER_CHANGE = CLUSTER_CHANGE(128i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_STATE: CLUSTER_CHANGE = CLUSTER_CHANGE(256i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_DELETED: CLUSTER_CHANGE = CLUSTER_CHANGE(512i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_ADDED: CLUSTER_CHANGE = CLUSTER_CHANGE(1024i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_PROPERTY: CLUSTER_CHANGE = CLUSTER_CHANGE(2048i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_STATE: CLUSTER_CHANGE = CLUSTER_CHANGE(4096i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_DELETED: CLUSTER_CHANGE = CLUSTER_CHANGE(8192i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_ADDED: CLUSTER_CHANGE = CLUSTER_CHANGE(16384i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_PROPERTY: CLUSTER_CHANGE = CLUSTER_CHANGE(32768i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TYPE_DELETED: CLUSTER_CHANGE = CLUSTER_CHANGE(65536i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TYPE_ADDED: CLUSTER_CHANGE = CLUSTER_CHANGE(131072i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TYPE_PROPERTY: CLUSTER_CHANGE = CLUSTER_CHANGE(262144i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_RECONNECT: CLUSTER_CHANGE = CLUSTER_CHANGE(524288i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_STATE: CLUSTER_CHANGE = CLUSTER_CHANGE(1048576i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_DELETED: CLUSTER_CHANGE = CLUSTER_CHANGE(2097152i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_ADDED: CLUSTER_CHANGE = CLUSTER_CHANGE(4194304i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_PROPERTY: CLUSTER_CHANGE = CLUSTER_CHANGE(8388608i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_STATE: CLUSTER_CHANGE = CLUSTER_CHANGE(16777216i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_DELETED: CLUSTER_CHANGE = CLUSTER_CHANGE(33554432i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_ADDED: CLUSTER_CHANGE = CLUSTER_CHANGE(67108864i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_PROPERTY: CLUSTER_CHANGE = CLUSTER_CHANGE(134217728i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_QUORUM_STATE: CLUSTER_CHANGE = CLUSTER_CHANGE(268435456i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_STATE: CLUSTER_CHANGE = CLUSTER_CHANGE(536870912i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_PROPERTY: CLUSTER_CHANGE = CLUSTER_CHANGE(1073741824i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_HANDLE_CLOSE: CLUSTER_CHANGE = CLUSTER_CHANGE(-2147483648i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_ALL: CLUSTER_CHANGE = CLUSTER_CHANGE(-1i32);
impl ::core::marker::Copy for CLUSTER_CHANGE {}
impl ::core::clone::Clone for CLUSTER_CHANGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_CLUSTER_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_RECONNECT_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_STATE_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_GROUP_ADDED_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_HANDLE_CLOSE_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_NETWORK_ADDED_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_NODE_ADDED_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_RESOURCE_TYPE_ADDED_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(64i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_COMMON_PROPERTY_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(128i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_PRIVATE_PROPERTY_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(256i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_LOST_NOTIFICATIONS_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(512i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_RENAME_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(1024i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_MEMBERSHIP_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(2048i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_UPGRADED_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(4096i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_CLUSTER_ALL_V2: CLUSTER_CHANGE_CLUSTER_V2 = CLUSTER_CHANGE_CLUSTER_V2(8191i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_CLUSTER_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_CLUSTER_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_CLUSTER_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_CLUSTER_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_CLUSTER_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_CLUSTER_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_GROUPSET_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_DELETED_v2: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_COMMON_PROPERTY_V2: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_PRIVATE_PROPERTY_V2: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_STATE_V2: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_GROUP_ADDED: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_GROUP_REMOVED: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_DEPENDENCIES_V2: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(64i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_DEPENDENTS_V2: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(128i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_HANDLE_CLOSE_v2: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(256i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUPSET_ALL_V2: CLUSTER_CHANGE_GROUPSET_V2 = CLUSTER_CHANGE_GROUPSET_V2(511i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_GROUPSET_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_GROUPSET_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_GROUPSET_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_GROUPSET_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_GROUPSET_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_GROUPSET_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_GROUP_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_DELETED_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_COMMON_PROPERTY_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_PRIVATE_PROPERTY_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_STATE_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_OWNER_NODE_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_PREFERRED_OWNERS_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_RESOURCE_ADDED_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(64i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_RESOURCE_GAINED_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(128i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_RESOURCE_LOST_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(256i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_HANDLE_CLOSE_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(512i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_GROUP_ALL_V2: CLUSTER_CHANGE_GROUP_V2 = CLUSTER_CHANGE_GROUP_V2(1023i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_GROUP_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_GROUP_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_GROUP_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_GROUP_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_GROUP_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_GROUP_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_NETINTERFACE_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_DELETED_V2: CLUSTER_CHANGE_NETINTERFACE_V2 = CLUSTER_CHANGE_NETINTERFACE_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_COMMON_PROPERTY_V2: CLUSTER_CHANGE_NETINTERFACE_V2 = CLUSTER_CHANGE_NETINTERFACE_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_PRIVATE_PROPERTY_V2: CLUSTER_CHANGE_NETINTERFACE_V2 = CLUSTER_CHANGE_NETINTERFACE_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_STATE_V2: CLUSTER_CHANGE_NETINTERFACE_V2 = CLUSTER_CHANGE_NETINTERFACE_V2(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_HANDLE_CLOSE_V2: CLUSTER_CHANGE_NETINTERFACE_V2 = CLUSTER_CHANGE_NETINTERFACE_V2(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETINTERFACE_ALL_V2: CLUSTER_CHANGE_NETINTERFACE_V2 = CLUSTER_CHANGE_NETINTERFACE_V2(31i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_NETINTERFACE_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_NETINTERFACE_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_NETINTERFACE_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_NETINTERFACE_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_NETINTERFACE_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_NETINTERFACE_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_NETWORK_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_DELETED_V2: CLUSTER_CHANGE_NETWORK_V2 = CLUSTER_CHANGE_NETWORK_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_COMMON_PROPERTY_V2: CLUSTER_CHANGE_NETWORK_V2 = CLUSTER_CHANGE_NETWORK_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_PRIVATE_PROPERTY_V2: CLUSTER_CHANGE_NETWORK_V2 = CLUSTER_CHANGE_NETWORK_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_STATE_V2: CLUSTER_CHANGE_NETWORK_V2 = CLUSTER_CHANGE_NETWORK_V2(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_HANDLE_CLOSE_V2: CLUSTER_CHANGE_NETWORK_V2 = CLUSTER_CHANGE_NETWORK_V2(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NETWORK_ALL_V2: CLUSTER_CHANGE_NETWORK_V2 = CLUSTER_CHANGE_NETWORK_V2(31i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_NETWORK_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_NETWORK_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_NETWORK_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_NETWORK_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_NETWORK_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_NETWORK_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_UPGRADE_NODE_PREPARE: CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2 = CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_UPGRADE_NODE_COMMIT: CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2 = CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_UPGRADE_NODE_POSTCOMMIT: CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2 = CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_UPGRADE_ALL: CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2 = CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2(7i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_NODE_UPGRADE_PHASE_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_NODE_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_NETINTERFACE_ADDED_V2: CLUSTER_CHANGE_NODE_V2 = CLUSTER_CHANGE_NODE_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_DELETED_V2: CLUSTER_CHANGE_NODE_V2 = CLUSTER_CHANGE_NODE_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_COMMON_PROPERTY_V2: CLUSTER_CHANGE_NODE_V2 = CLUSTER_CHANGE_NODE_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_PRIVATE_PROPERTY_V2: CLUSTER_CHANGE_NODE_V2 = CLUSTER_CHANGE_NODE_V2(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_STATE_V2: CLUSTER_CHANGE_NODE_V2 = CLUSTER_CHANGE_NODE_V2(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_GROUP_GAINED_V2: CLUSTER_CHANGE_NODE_V2 = CLUSTER_CHANGE_NODE_V2(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_GROUP_LOST_V2: CLUSTER_CHANGE_NODE_V2 = CLUSTER_CHANGE_NODE_V2(64i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_HANDLE_CLOSE_V2: CLUSTER_CHANGE_NODE_V2 = CLUSTER_CHANGE_NODE_V2(128i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_NODE_ALL_V2: CLUSTER_CHANGE_NODE_V2 = CLUSTER_CHANGE_NODE_V2(255i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_NODE_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_NODE_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_NODE_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_NODE_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_NODE_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_NODE_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_QUORUM_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_QUORUM_STATE_V2: CLUSTER_CHANGE_QUORUM_V2 = CLUSTER_CHANGE_QUORUM_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_QUORUM_ALL_V2: CLUSTER_CHANGE_QUORUM_V2 = CLUSTER_CHANGE_QUORUM_V2(1i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_QUORUM_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_QUORUM_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_QUORUM_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_QUORUM_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_QUORUM_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_QUORUM_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_REGISTRY_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_ATTRIBUTES_V2: CLUSTER_CHANGE_REGISTRY_V2 = CLUSTER_CHANGE_REGISTRY_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_NAME_V2: CLUSTER_CHANGE_REGISTRY_V2 = CLUSTER_CHANGE_REGISTRY_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_SUBTREE_V2: CLUSTER_CHANGE_REGISTRY_V2 = CLUSTER_CHANGE_REGISTRY_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_VALUE_V2: CLUSTER_CHANGE_REGISTRY_V2 = CLUSTER_CHANGE_REGISTRY_V2(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_HANDLE_CLOSE_V2: CLUSTER_CHANGE_REGISTRY_V2 = CLUSTER_CHANGE_REGISTRY_V2(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_REGISTRY_ALL_V2: CLUSTER_CHANGE_REGISTRY_V2 = CLUSTER_CHANGE_REGISTRY_V2(31i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_REGISTRY_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_REGISTRY_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_REGISTRY_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_REGISTRY_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_REGISTRY_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_REGISTRY_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_RESOURCE_TYPE_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TYPE_DELETED_V2: CLUSTER_CHANGE_RESOURCE_TYPE_V2 = CLUSTER_CHANGE_RESOURCE_TYPE_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TYPE_COMMON_PROPERTY_V2: CLUSTER_CHANGE_RESOURCE_TYPE_V2 = CLUSTER_CHANGE_RESOURCE_TYPE_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TYPE_PRIVATE_PROPERTY_V2: CLUSTER_CHANGE_RESOURCE_TYPE_V2 = CLUSTER_CHANGE_RESOURCE_TYPE_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TYPE_POSSIBLE_OWNERS_V2: CLUSTER_CHANGE_RESOURCE_TYPE_V2 = CLUSTER_CHANGE_RESOURCE_TYPE_V2(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TYPE_DLL_UPGRADED_V2: CLUSTER_CHANGE_RESOURCE_TYPE_V2 = CLUSTER_CHANGE_RESOURCE_TYPE_V2(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_TYPE_SPECIFIC_V2: CLUSTER_CHANGE_RESOURCE_TYPE_V2 = CLUSTER_CHANGE_RESOURCE_TYPE_V2(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TYPE_ALL_V2: CLUSTER_CHANGE_RESOURCE_TYPE_V2 = CLUSTER_CHANGE_RESOURCE_TYPE_V2(63i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_RESOURCE_TYPE_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_RESOURCE_TYPE_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_RESOURCE_TYPE_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_RESOURCE_TYPE_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_RESOURCE_TYPE_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_RESOURCE_TYPE_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_RESOURCE_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_COMMON_PROPERTY_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_PRIVATE_PROPERTY_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_STATE_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_OWNER_GROUP_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_DEPENDENCIES_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_DEPENDENTS_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_POSSIBLE_OWNERS_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(64i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_DELETED_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(128i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_DLL_UPGRADED_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(256i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_HANDLE_CLOSE_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(512i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_TERMINAL_STATE_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(1024i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_RESOURCE_ALL_V2: CLUSTER_CHANGE_RESOURCE_V2 = CLUSTER_CHANGE_RESOURCE_V2(2047i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_RESOURCE_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_RESOURCE_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_RESOURCE_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_RESOURCE_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_RESOURCE_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_RESOURCE_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_SHARED_VOLUME_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_SHARED_VOLUME_STATE_V2: CLUSTER_CHANGE_SHARED_VOLUME_V2 = CLUSTER_CHANGE_SHARED_VOLUME_V2(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_SHARED_VOLUME_ADDED_V2: CLUSTER_CHANGE_SHARED_VOLUME_V2 = CLUSTER_CHANGE_SHARED_VOLUME_V2(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_SHARED_VOLUME_REMOVED_V2: CLUSTER_CHANGE_SHARED_VOLUME_V2 = CLUSTER_CHANGE_SHARED_VOLUME_V2(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_SHARED_VOLUME_ALL_V2: CLUSTER_CHANGE_SHARED_VOLUME_V2 = CLUSTER_CHANGE_SHARED_VOLUME_V2(7i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_SHARED_VOLUME_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_SHARED_VOLUME_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_SHARED_VOLUME_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_SHARED_VOLUME_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_SHARED_VOLUME_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_SHARED_VOLUME_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CHANGE_SPACEPORT_V2(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CHANGE_SPACEPORT_CUSTOM_PNP_V2: CLUSTER_CHANGE_SPACEPORT_V2 = CLUSTER_CHANGE_SPACEPORT_V2(1i32);
impl ::core::marker::Copy for CLUSTER_CHANGE_SPACEPORT_V2 {}
impl ::core::clone::Clone for CLUSTER_CHANGE_SPACEPORT_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CHANGE_SPACEPORT_V2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CHANGE_SPACEPORT_V2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CHANGE_SPACEPORT_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CHANGE_SPACEPORT_V2").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CLOUD_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CLOUD_TYPE_NONE: CLUSTER_CLOUD_TYPE = CLUSTER_CLOUD_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CLOUD_TYPE_AZURE: CLUSTER_CLOUD_TYPE = CLUSTER_CLOUD_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CLOUD_TYPE_MIXED: CLUSTER_CLOUD_TYPE = CLUSTER_CLOUD_TYPE(128i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CLOUD_TYPE_UNKNOWN: CLUSTER_CLOUD_TYPE = CLUSTER_CLOUD_TYPE(-1i32);
impl ::core::marker::Copy for CLUSTER_CLOUD_TYPE {}
impl ::core::clone::Clone for CLUSTER_CLOUD_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CLOUD_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CLOUD_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CLOUD_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CLOUD_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CONFIGURED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CONTROL_OBJECT(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_INVALID: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_RESOURCE: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_RESOURCE_TYPE: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_GROUP: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_NODE: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_NETWORK: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(5i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_NETINTERFACE: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(6i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_CLUSTER: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(7i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_GROUPSET: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_AFFINITYRULE: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(9i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_OBJECT_USER: CLUSTER_CONTROL_OBJECT = CLUSTER_CONTROL_OBJECT(128i32);
impl ::core::marker::Copy for CLUSTER_CONTROL_OBJECT {}
impl ::core::clone::Clone for CLUSTER_CONTROL_OBJECT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CONTROL_OBJECT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CONTROL_OBJECT {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CONTROL_OBJECT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CONTROL_OBJECT").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_CREATE_GROUP_INFO {
    pub dwVersion: u32,
    pub groupType: CLUSGROUP_TYPE,
}
impl ::core::marker::Copy for CLUSTER_CREATE_GROUP_INFO {}
impl ::core::clone::Clone for CLUSTER_CREATE_GROUP_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_CREATE_GROUP_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_CREATE_GROUP_INFO").field("dwVersion", &self.dwVersion).field("groupType", &self.groupType).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CREATE_GROUP_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_CREATE_GROUP_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_CREATE_GROUP_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_CREATE_GROUP_INFO {}
impl ::core::default::Default for CLUSTER_CREATE_GROUP_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CREATE_GROUP_INFO_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CREATE_GROUP_INFO_VERSION_1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CSA_VSS_STATE: &'static str = "BackupInProgress";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CSV_COMPATIBLE_FILTERS: &'static str = "SharedVolumeCompatibleFilters";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_CSV_INCOMPATIBLE_FILTERS: &'static str = "SharedVolumeIncompatibleFilters";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_CSV_VOLUME_FAULT_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const VolumeStateNoFaults: CLUSTER_CSV_VOLUME_FAULT_STATE = CLUSTER_CSV_VOLUME_FAULT_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const VolumeStateNoDirectIO: CLUSTER_CSV_VOLUME_FAULT_STATE = CLUSTER_CSV_VOLUME_FAULT_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const VolumeStateNoAccess: CLUSTER_CSV_VOLUME_FAULT_STATE = CLUSTER_CSV_VOLUME_FAULT_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const VolumeStateInMaintenance: CLUSTER_CSV_VOLUME_FAULT_STATE = CLUSTER_CSV_VOLUME_FAULT_STATE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const VolumeStateDismounted: CLUSTER_CSV_VOLUME_FAULT_STATE = CLUSTER_CSV_VOLUME_FAULT_STATE(8i32);
impl ::core::marker::Copy for CLUSTER_CSV_VOLUME_FAULT_STATE {}
impl ::core::clone::Clone for CLUSTER_CSV_VOLUME_FAULT_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_CSV_VOLUME_FAULT_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_CSV_VOLUME_FAULT_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_CSV_VOLUME_FAULT_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_CSV_VOLUME_FAULT_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_DELETE_ACCESS_CONTROL_ENTRY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENFORCED_ANTIAFFINITY: &'static str = "ClusterEnforcedAntiaffinity";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_ENUM(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_NODE: CLUSTER_ENUM = CLUSTER_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_RESTYPE: CLUSTER_ENUM = CLUSTER_ENUM(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_RESOURCE: CLUSTER_ENUM = CLUSTER_ENUM(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_GROUP: CLUSTER_ENUM = CLUSTER_ENUM(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_NETWORK: CLUSTER_ENUM = CLUSTER_ENUM(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_NETINTERFACE: CLUSTER_ENUM = CLUSTER_ENUM(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_SHARED_VOLUME_GROUP: CLUSTER_ENUM = CLUSTER_ENUM(536870912i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_SHARED_VOLUME_RESOURCE: CLUSTER_ENUM = CLUSTER_ENUM(1073741824i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_INTERNAL_NETWORK: CLUSTER_ENUM = CLUSTER_ENUM(-2147483648i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_ALL: CLUSTER_ENUM = CLUSTER_ENUM(63i32);
impl ::core::marker::Copy for CLUSTER_ENUM {}
impl ::core::clone::Clone for CLUSTER_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_ENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_ENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_ENUM_ITEM {
    pub dwVersion: u32,
    pub dwType: u32,
    pub cbId: u32,
    pub lpszId: ::windows::core::PWSTR,
    pub cbName: u32,
    pub lpszName: ::windows::core::PWSTR,
}
impl ::core::marker::Copy for CLUSTER_ENUM_ITEM {}
impl ::core::clone::Clone for CLUSTER_ENUM_ITEM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_ENUM_ITEM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_ENUM_ITEM").field("dwVersion", &self.dwVersion).field("dwType", &self.dwType).field("cbId", &self.cbId).field("lpszId", &self.lpszId).field("cbName", &self.cbName).field("lpszName", &self.lpszName).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_ENUM_ITEM {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_ENUM_ITEM {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_ENUM_ITEM>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_ENUM_ITEM {}
impl ::core::default::Default for CLUSTER_ENUM_ITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_ITEM_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_ENUM_ITEM_VERSION_1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_GROUP_AUTOFAILBACK_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterGroupPreventFailback: CLUSTER_GROUP_AUTOFAILBACK_TYPE = CLUSTER_GROUP_AUTOFAILBACK_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterGroupAllowFailback: CLUSTER_GROUP_AUTOFAILBACK_TYPE = CLUSTER_GROUP_AUTOFAILBACK_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterGroupFailbackTypeCount: CLUSTER_GROUP_AUTOFAILBACK_TYPE = CLUSTER_GROUP_AUTOFAILBACK_TYPE(2i32);
impl ::core::marker::Copy for CLUSTER_GROUP_AUTOFAILBACK_TYPE {}
impl ::core::clone::Clone for CLUSTER_GROUP_AUTOFAILBACK_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_GROUP_AUTOFAILBACK_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_GROUP_AUTOFAILBACK_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_GROUP_AUTOFAILBACK_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_GROUP_AUTOFAILBACK_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_GROUP_ENUM(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_GROUP_ENUM_CONTAINS: CLUSTER_GROUP_ENUM = CLUSTER_GROUP_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_GROUP_ENUM_NODES: CLUSTER_GROUP_ENUM = CLUSTER_GROUP_ENUM(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_GROUP_ENUM_ALL: CLUSTER_GROUP_ENUM = CLUSTER_GROUP_ENUM(3i32);
impl ::core::marker::Copy for CLUSTER_GROUP_ENUM {}
impl ::core::clone::Clone for CLUSTER_GROUP_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_GROUP_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_GROUP_ENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_GROUP_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_GROUP_ENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_GROUP_ENUM_ITEM {
    pub dwVersion: u32,
    pub cbId: u32,
    pub lpszId: ::windows::core::PWSTR,
    pub cbName: u32,
    pub lpszName: ::windows::core::PWSTR,
    pub state: CLUSTER_GROUP_STATE,
    pub cbOwnerNode: u32,
    pub lpszOwnerNode: ::windows::core::PWSTR,
    pub dwFlags: u32,
    pub cbProperties: u32,
    pub pProperties: *mut ::core::ffi::c_void,
    pub cbRoProperties: u32,
    pub pRoProperties: *mut ::core::ffi::c_void,
}
impl ::core::marker::Copy for CLUSTER_GROUP_ENUM_ITEM {}
impl ::core::clone::Clone for CLUSTER_GROUP_ENUM_ITEM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_GROUP_ENUM_ITEM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_GROUP_ENUM_ITEM")
            .field("dwVersion", &self.dwVersion)
            .field("cbId", &self.cbId)
            .field("lpszId", &self.lpszId)
            .field("cbName", &self.cbName)
            .field("lpszName", &self.lpszName)
            .field("state", &self.state)
            .field("cbOwnerNode", &self.cbOwnerNode)
            .field("lpszOwnerNode", &self.lpszOwnerNode)
            .field("dwFlags", &self.dwFlags)
            .field("cbProperties", &self.cbProperties)
            .field("pProperties", &self.pProperties)
            .field("cbRoProperties", &self.cbRoProperties)
            .field("pRoProperties", &self.pRoProperties)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_GROUP_ENUM_ITEM {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_GROUP_ENUM_ITEM {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_GROUP_ENUM_ITEM>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_GROUP_ENUM_ITEM {}
impl ::core::default::Default for CLUSTER_GROUP_ENUM_ITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_GROUP_ENUM_ITEM_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_GROUP_ENUM_ITEM_VERSION_1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_GROUP_PRIORITY(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const PriorityDisabled: CLUSTER_GROUP_PRIORITY = CLUSTER_GROUP_PRIORITY(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const PriorityLow: CLUSTER_GROUP_PRIORITY = CLUSTER_GROUP_PRIORITY(1000i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const PriorityMedium: CLUSTER_GROUP_PRIORITY = CLUSTER_GROUP_PRIORITY(2000i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const PriorityHigh: CLUSTER_GROUP_PRIORITY = CLUSTER_GROUP_PRIORITY(3000i32);
impl ::core::marker::Copy for CLUSTER_GROUP_PRIORITY {}
impl ::core::clone::Clone for CLUSTER_GROUP_PRIORITY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_GROUP_PRIORITY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_GROUP_PRIORITY {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_GROUP_PRIORITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_GROUP_PRIORITY").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_GROUP_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterGroupStateUnknown: CLUSTER_GROUP_STATE = CLUSTER_GROUP_STATE(-1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterGroupOnline: CLUSTER_GROUP_STATE = CLUSTER_GROUP_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterGroupOffline: CLUSTER_GROUP_STATE = CLUSTER_GROUP_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterGroupFailed: CLUSTER_GROUP_STATE = CLUSTER_GROUP_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterGroupPartialOnline: CLUSTER_GROUP_STATE = CLUSTER_GROUP_STATE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterGroupPending: CLUSTER_GROUP_STATE = CLUSTER_GROUP_STATE(4i32);
impl ::core::marker::Copy for CLUSTER_GROUP_STATE {}
impl ::core::clone::Clone for CLUSTER_GROUP_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_GROUP_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_GROUP_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_GROUP_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_GROUP_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_GROUP_WAIT_DELAY: &'static str = "ClusterGroupWaitDelay";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HANG_RECOVERY_ACTION_KEYNAME: &'static str = "HangRecoveryAction";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HANG_TIMEOUT_KEYNAME: &'static str = "ClusSvcHangTimeout";
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_HEALTH_FAULT {
    pub Id: ::windows::core::PWSTR,
    pub ErrorType: u32,
    pub ErrorCode: u32,
    pub Description: ::windows::core::PWSTR,
    pub Provider: ::windows::core::PWSTR,
    pub Flags: u32,
    pub Reserved: u32,
}
impl ::core::marker::Copy for CLUSTER_HEALTH_FAULT {}
impl ::core::clone::Clone for CLUSTER_HEALTH_FAULT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_HEALTH_FAULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_HEALTH_FAULT").field("Id", &self.Id).field("ErrorType", &self.ErrorType).field("ErrorCode", &self.ErrorCode).field("Description", &self.Description).field("Provider", &self.Provider).field("Flags", &self.Flags).field("Reserved", &self.Reserved).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_HEALTH_FAULT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_HEALTH_FAULT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_HEALTH_FAULT>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_HEALTH_FAULT {}
impl ::core::default::Default for CLUSTER_HEALTH_FAULT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_ARGS: u32 = 7u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_HEALTH_FAULT_ARRAY {
    pub numFaults: u32,
    pub faults: *mut CLUSTER_HEALTH_FAULT,
}
impl ::core::marker::Copy for CLUSTER_HEALTH_FAULT_ARRAY {}
impl ::core::clone::Clone for CLUSTER_HEALTH_FAULT_ARRAY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_HEALTH_FAULT_ARRAY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_HEALTH_FAULT_ARRAY").field("numFaults", &self.numFaults).field("faults", &self.faults).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_HEALTH_FAULT_ARRAY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_HEALTH_FAULT_ARRAY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_HEALTH_FAULT_ARRAY>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_HEALTH_FAULT_ARRAY {}
impl ::core::default::Default for CLUSTER_HEALTH_FAULT_ARRAY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_DESCRIPTION: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_DESCRIPTION_LABEL: &'static str = "Description";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_ERRORCODE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_ERRORCODE_LABEL: &'static str = "ErrorCode";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_ERRORTYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_ERRORTYPE_LABEL: &'static str = "ErrorType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_FLAGS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_FLAGS_LABEL: &'static str = "Flags";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_ID: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_ID_LABEL: &'static str = "Id";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_PROPERTY_NAME: &'static str = "ClusterHealth";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_PROVIDER: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_PROVIDER_LABEL: &'static str = "Provider";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_RESERVED: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_HEALTH_FAULT_RESERVED_LABEL: &'static str = "Reserved";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_INSTALLED: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_IP_ENTRY {
    pub lpszIpAddress: ::windows::core::PCWSTR,
    pub dwPrefixLength: u32,
}
impl ::core::marker::Copy for CLUSTER_IP_ENTRY {}
impl ::core::clone::Clone for CLUSTER_IP_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_IP_ENTRY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_IP_ENTRY").field("lpszIpAddress", &self.lpszIpAddress).field("dwPrefixLength", &self.dwPrefixLength).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_IP_ENTRY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_IP_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_IP_ENTRY>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_IP_ENTRY {}
impl ::core::default::Default for CLUSTER_IP_ENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUSTER_MEMBERSHIP_INFO {
    pub HasQuorum: super::super::Foundation::BOOL,
    pub UpnodesSize: u32,
    pub Upnodes: [u8; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUSTER_MEMBERSHIP_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUSTER_MEMBERSHIP_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUSTER_MEMBERSHIP_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_MEMBERSHIP_INFO").field("HasQuorum", &self.HasQuorum).field("UpnodesSize", &self.UpnodesSize).field("Upnodes", &self.Upnodes).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUSTER_MEMBERSHIP_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUSTER_MEMBERSHIP_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_MEMBERSHIP_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUSTER_MEMBERSHIP_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUSTER_MEMBERSHIP_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_MGMT_POINT_RESTYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_MGMT_POINT_RESTYPE_AUTO: CLUSTER_MGMT_POINT_RESTYPE = CLUSTER_MGMT_POINT_RESTYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_MGMT_POINT_RESTYPE_SNN: CLUSTER_MGMT_POINT_RESTYPE = CLUSTER_MGMT_POINT_RESTYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_MGMT_POINT_RESTYPE_DNN: CLUSTER_MGMT_POINT_RESTYPE = CLUSTER_MGMT_POINT_RESTYPE(2i32);
impl ::core::marker::Copy for CLUSTER_MGMT_POINT_RESTYPE {}
impl ::core::clone::Clone for CLUSTER_MGMT_POINT_RESTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_MGMT_POINT_RESTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_MGMT_POINT_RESTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_MGMT_POINT_RESTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_MGMT_POINT_RESTYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_MGMT_POINT_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_MGMT_POINT_TYPE_NONE: CLUSTER_MGMT_POINT_TYPE = CLUSTER_MGMT_POINT_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_MGMT_POINT_TYPE_CNO: CLUSTER_MGMT_POINT_TYPE = CLUSTER_MGMT_POINT_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_MGMT_POINT_TYPE_DNS_ONLY: CLUSTER_MGMT_POINT_TYPE = CLUSTER_MGMT_POINT_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_MGMT_POINT_TYPE_CNO_ONLY: CLUSTER_MGMT_POINT_TYPE = CLUSTER_MGMT_POINT_TYPE(3i32);
impl ::core::marker::Copy for CLUSTER_MGMT_POINT_TYPE {}
impl ::core::clone::Clone for CLUSTER_MGMT_POINT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_MGMT_POINT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_MGMT_POINT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_MGMT_POINT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_MGMT_POINT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NAME_AUTO_BALANCER_LEVEL: &'static str = "AutoBalancerLevel";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NAME_AUTO_BALANCER_MODE: &'static str = "AutoBalancerMode";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NAME_PREFERRED_SITE: &'static str = "PreferredSite";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NETINTERFACE_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetInterfaceStateUnknown: CLUSTER_NETINTERFACE_STATE = CLUSTER_NETINTERFACE_STATE(-1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetInterfaceUnavailable: CLUSTER_NETINTERFACE_STATE = CLUSTER_NETINTERFACE_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetInterfaceFailed: CLUSTER_NETINTERFACE_STATE = CLUSTER_NETINTERFACE_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetInterfaceUnreachable: CLUSTER_NETINTERFACE_STATE = CLUSTER_NETINTERFACE_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetInterfaceUp: CLUSTER_NETINTERFACE_STATE = CLUSTER_NETINTERFACE_STATE(3i32);
impl ::core::marker::Copy for CLUSTER_NETINTERFACE_STATE {}
impl ::core::clone::Clone for CLUSTER_NETINTERFACE_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NETINTERFACE_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NETINTERFACE_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NETINTERFACE_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NETINTERFACE_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NETWORK_ENUM(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NETWORK_ENUM_NETINTERFACES: CLUSTER_NETWORK_ENUM = CLUSTER_NETWORK_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NETWORK_ENUM_ALL: CLUSTER_NETWORK_ENUM = CLUSTER_NETWORK_ENUM(1i32);
impl ::core::marker::Copy for CLUSTER_NETWORK_ENUM {}
impl ::core::clone::Clone for CLUSTER_NETWORK_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NETWORK_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NETWORK_ENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NETWORK_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NETWORK_ENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NETWORK_ROLE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetworkRoleNone: CLUSTER_NETWORK_ROLE = CLUSTER_NETWORK_ROLE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetworkRoleInternalUse: CLUSTER_NETWORK_ROLE = CLUSTER_NETWORK_ROLE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetworkRoleClientAccess: CLUSTER_NETWORK_ROLE = CLUSTER_NETWORK_ROLE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetworkRoleInternalAndClient: CLUSTER_NETWORK_ROLE = CLUSTER_NETWORK_ROLE(3i32);
impl ::core::marker::Copy for CLUSTER_NETWORK_ROLE {}
impl ::core::clone::Clone for CLUSTER_NETWORK_ROLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NETWORK_ROLE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NETWORK_ROLE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NETWORK_ROLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NETWORK_ROLE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NETWORK_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetworkStateUnknown: CLUSTER_NETWORK_STATE = CLUSTER_NETWORK_STATE(-1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetworkUnavailable: CLUSTER_NETWORK_STATE = CLUSTER_NETWORK_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetworkDown: CLUSTER_NETWORK_STATE = CLUSTER_NETWORK_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetworkPartitioned: CLUSTER_NETWORK_STATE = CLUSTER_NETWORK_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNetworkUp: CLUSTER_NETWORK_STATE = CLUSTER_NETWORK_STATE(3i32);
impl ::core::marker::Copy for CLUSTER_NETWORK_STATE {}
impl ::core::clone::Clone for CLUSTER_NETWORK_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NETWORK_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NETWORK_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NETWORK_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NETWORK_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NODE_DRAIN_STATUS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeDrainStatusNotInitiated: CLUSTER_NODE_DRAIN_STATUS = CLUSTER_NODE_DRAIN_STATUS(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeDrainStatusInProgress: CLUSTER_NODE_DRAIN_STATUS = CLUSTER_NODE_DRAIN_STATUS(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeDrainStatusCompleted: CLUSTER_NODE_DRAIN_STATUS = CLUSTER_NODE_DRAIN_STATUS(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeDrainStatusFailed: CLUSTER_NODE_DRAIN_STATUS = CLUSTER_NODE_DRAIN_STATUS(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNodeDrainStatusCount: CLUSTER_NODE_DRAIN_STATUS = CLUSTER_NODE_DRAIN_STATUS(4i32);
impl ::core::marker::Copy for CLUSTER_NODE_DRAIN_STATUS {}
impl ::core::clone::Clone for CLUSTER_NODE_DRAIN_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NODE_DRAIN_STATUS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NODE_DRAIN_STATUS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NODE_DRAIN_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NODE_DRAIN_STATUS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NODE_ENUM(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NODE_ENUM_NETINTERFACES: CLUSTER_NODE_ENUM = CLUSTER_NODE_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NODE_ENUM_GROUPS: CLUSTER_NODE_ENUM = CLUSTER_NODE_ENUM(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NODE_ENUM_PREFERRED_GROUPS: CLUSTER_NODE_ENUM = CLUSTER_NODE_ENUM(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NODE_ENUM_ALL: CLUSTER_NODE_ENUM = CLUSTER_NODE_ENUM(3i32);
impl ::core::marker::Copy for CLUSTER_NODE_ENUM {}
impl ::core::clone::Clone for CLUSTER_NODE_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NODE_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NODE_ENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NODE_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NODE_ENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NODE_RESUME_FAILBACK_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const DoNotFailbackGroups: CLUSTER_NODE_RESUME_FAILBACK_TYPE = CLUSTER_NODE_RESUME_FAILBACK_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FailbackGroupsImmediately: CLUSTER_NODE_RESUME_FAILBACK_TYPE = CLUSTER_NODE_RESUME_FAILBACK_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FailbackGroupsPerPolicy: CLUSTER_NODE_RESUME_FAILBACK_TYPE = CLUSTER_NODE_RESUME_FAILBACK_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNodeResumeFailbackTypeCount: CLUSTER_NODE_RESUME_FAILBACK_TYPE = CLUSTER_NODE_RESUME_FAILBACK_TYPE(3i32);
impl ::core::marker::Copy for CLUSTER_NODE_RESUME_FAILBACK_TYPE {}
impl ::core::clone::Clone for CLUSTER_NODE_RESUME_FAILBACK_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NODE_RESUME_FAILBACK_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NODE_RESUME_FAILBACK_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NODE_RESUME_FAILBACK_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NODE_RESUME_FAILBACK_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NODE_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNodeStateUnknown: CLUSTER_NODE_STATE = CLUSTER_NODE_STATE(-1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNodeUp: CLUSTER_NODE_STATE = CLUSTER_NODE_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNodeDown: CLUSTER_NODE_STATE = CLUSTER_NODE_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNodePaused: CLUSTER_NODE_STATE = CLUSTER_NODE_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterNodeJoining: CLUSTER_NODE_STATE = CLUSTER_NODE_STATE(3i32);
impl ::core::marker::Copy for CLUSTER_NODE_STATE {}
impl ::core::clone::Clone for CLUSTER_NODE_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NODE_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NODE_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NODE_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NODE_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NODE_STATUS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeStatusNormal: CLUSTER_NODE_STATUS = CLUSTER_NODE_STATUS(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeStatusIsolated: CLUSTER_NODE_STATUS = CLUSTER_NODE_STATUS(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeStatusQuarantined: CLUSTER_NODE_STATUS = CLUSTER_NODE_STATUS(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeStatusDrainInProgress: CLUSTER_NODE_STATUS = CLUSTER_NODE_STATUS(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeStatusDrainCompleted: CLUSTER_NODE_STATUS = CLUSTER_NODE_STATUS(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeStatusDrainFailed: CLUSTER_NODE_STATUS = CLUSTER_NODE_STATUS(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeStatusAvoidPlacement: CLUSTER_NODE_STATUS = CLUSTER_NODE_STATUS(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const NodeStatusMax: CLUSTER_NODE_STATUS = CLUSTER_NODE_STATUS(51i32);
impl ::core::marker::Copy for CLUSTER_NODE_STATUS {}
impl ::core::clone::Clone for CLUSTER_NODE_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NODE_STATUS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NODE_STATUS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NODE_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NODE_STATUS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_NOTIFICATIONS_VERSION(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NOTIFICATIONS_V1: CLUSTER_NOTIFICATIONS_VERSION = CLUSTER_NOTIFICATIONS_VERSION(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_NOTIFICATIONS_V2: CLUSTER_NOTIFICATIONS_VERSION = CLUSTER_NOTIFICATIONS_VERSION(2i32);
impl ::core::marker::Copy for CLUSTER_NOTIFICATIONS_VERSION {}
impl ::core::clone::Clone for CLUSTER_NOTIFICATIONS_VERSION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_NOTIFICATIONS_VERSION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_NOTIFICATIONS_VERSION {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_NOTIFICATIONS_VERSION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_NOTIFICATIONS_VERSION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_OBJECT_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_NONE: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_CLUSTER: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_GROUP: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_RESOURCE: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_RESOURCE_TYPE: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_NETWORK_INTERFACE: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(5i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_NETWORK: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(6i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_NODE: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(7i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_REGISTRY: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_QUORUM: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(9i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_SHARED_VOLUME: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(10i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_GROUPSET: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(13i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_OBJECT_TYPE_AFFINITYRULE: CLUSTER_OBJECT_TYPE = CLUSTER_OBJECT_TYPE(16i32);
impl ::core::marker::Copy for CLUSTER_OBJECT_TYPE {}
impl ::core::clone::Clone for CLUSTER_OBJECT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_OBJECT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_OBJECT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_OBJECT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_OBJECT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_PROPERTY_FORMAT(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_UNKNOWN: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_BINARY: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_DWORD: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_SZ: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_EXPAND_SZ: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_MULTI_SZ: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(5i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_ULARGE_INTEGER: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(6i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_LONG: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(7i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_EXPANDED_SZ: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_SECURITY_DESCRIPTOR: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(9i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_LARGE_INTEGER: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(10i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_WORD: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(11i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_FILETIME: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(12i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_VALUE_LIST: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(13i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_PROPERTY_LIST: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(14i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_FORMAT_USER: CLUSTER_PROPERTY_FORMAT = CLUSTER_PROPERTY_FORMAT(32768i32);
impl ::core::marker::Copy for CLUSTER_PROPERTY_FORMAT {}
impl ::core::clone::Clone for CLUSTER_PROPERTY_FORMAT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_PROPERTY_FORMAT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_PROPERTY_FORMAT {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_PROPERTY_FORMAT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_PROPERTY_FORMAT").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_PROPERTY_SYNTAX(pub u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_ENDMARK: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(0u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_NAME: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(262147u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_RESCLASS: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(131074u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_SZ: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65539u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65540u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_DWORD: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65538u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_BINARY: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65537u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_MULTI_SZ: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65541u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_LONG: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65543u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65544u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_SECURITY_DESCRIPTOR: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65545u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_LARGE_INTEGER: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65546u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_ULARGE_INTEGER: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65542u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_WORD: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65547u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_PROPERTY_LIST: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65550u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_LIST_VALUE_FILETIME: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(65548u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_DISK_SIGNATURE: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(327682u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_SCSI_ADDRESS: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(393218u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_DISK_NUMBER: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(458754u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_PARTITION_INFO: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(524289u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_FTSET_INFO: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(589825u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_DISK_SERIALNUMBER: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(655363u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_DISK_GUID: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(720899u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_DISK_SIZE: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(786438u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_PARTITION_INFO_EX: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(851969u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_PARTITION_INFO_EX2: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(917505u32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_SYNTAX_STORAGE_DEVICE_ID_DESCRIPTOR: CLUSTER_PROPERTY_SYNTAX = CLUSTER_PROPERTY_SYNTAX(983041u32);
impl ::core::marker::Copy for CLUSTER_PROPERTY_SYNTAX {}
impl ::core::clone::Clone for CLUSTER_PROPERTY_SYNTAX {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_PROPERTY_SYNTAX {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_PROPERTY_SYNTAX {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_PROPERTY_SYNTAX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_PROPERTY_SYNTAX").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_PROPERTY_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_UNKNOWN: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(-1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_ENDMARK: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_LIST_VALUE: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_RESCLASS: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_RESERVED1: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_NAME: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_SIGNATURE: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(5i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_SCSI_ADDRESS: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(6i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_DISK_NUMBER: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(7i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_PARTITION_INFO: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_FTSET_INFO: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(9i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_DISK_SERIALNUMBER: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(10i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_DISK_GUID: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(11i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_DISK_SIZE: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(12i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_PARTITION_INFO_EX: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(13i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_PARTITION_INFO_EX2: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(14i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_STORAGE_DEVICE_ID_DESCRIPTOR: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(15i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSPROP_TYPE_USER: CLUSTER_PROPERTY_TYPE = CLUSTER_PROPERTY_TYPE(32768i32);
impl ::core::marker::Copy for CLUSTER_PROPERTY_TYPE {}
impl ::core::clone::Clone for CLUSTER_PROPERTY_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_PROPERTY_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_PROPERTY_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_PROPERTY_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_PROPERTY_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_QUORUM_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const OperationalQuorum: CLUSTER_QUORUM_TYPE = CLUSTER_QUORUM_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ModifyQuorum: CLUSTER_QUORUM_TYPE = CLUSTER_QUORUM_TYPE(1i32);
impl ::core::marker::Copy for CLUSTER_QUORUM_TYPE {}
impl ::core::clone::Clone for CLUSTER_QUORUM_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_QUORUM_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_QUORUM_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_QUORUM_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_QUORUM_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_QUORUM_VALUE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_QUORUM_MAINTAINED: CLUSTER_QUORUM_VALUE = CLUSTER_QUORUM_VALUE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_QUORUM_LOST: CLUSTER_QUORUM_VALUE = CLUSTER_QUORUM_VALUE(1i32);
impl ::core::marker::Copy for CLUSTER_QUORUM_VALUE {}
impl ::core::clone::Clone for CLUSTER_QUORUM_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_QUORUM_VALUE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_QUORUM_VALUE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_QUORUM_VALUE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_QUORUM_VALUE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_READ_BATCH_COMMAND {
    pub Command: CLUSTER_REG_COMMAND,
    pub dwOptions: u32,
    pub wzSubkeyName: ::windows::core::PCWSTR,
    pub wzValueName: ::windows::core::PCWSTR,
    pub lpData: *const u8,
    pub cbData: u32,
}
impl ::core::marker::Copy for CLUSTER_READ_BATCH_COMMAND {}
impl ::core::clone::Clone for CLUSTER_READ_BATCH_COMMAND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_READ_BATCH_COMMAND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_READ_BATCH_COMMAND").field("Command", &self.Command).field("dwOptions", &self.dwOptions).field("wzSubkeyName", &self.wzSubkeyName).field("wzValueName", &self.wzValueName).field("lpData", &self.lpData).field("cbData", &self.cbData).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_READ_BATCH_COMMAND {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_READ_BATCH_COMMAND {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_READ_BATCH_COMMAND>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_READ_BATCH_COMMAND {}
impl ::core::default::Default for CLUSTER_READ_BATCH_COMMAND {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_REG_COMMAND(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_COMMAND_NONE: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_SET_VALUE: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CREATE_KEY: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_DELETE_KEY: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_DELETE_VALUE: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_SET_KEY_SECURITY: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(5i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_VALUE_DELETED: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(6i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_READ_KEY: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(7i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_READ_VALUE: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_READ_ERROR: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(9i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CONTROL_COMMAND: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(10i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CONDITION_EXISTS: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(11i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CONDITION_NOT_EXISTS: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(12i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CONDITION_IS_EQUAL: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(13i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CONDITION_IS_NOT_EQUAL: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(14i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CONDITION_IS_GREATER_THAN: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(15i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CONDITION_IS_LESS_THAN: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CONDITION_KEY_EXISTS: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(17i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_CONDITION_KEY_NOT_EXISTS: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(18i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSREG_LAST_COMMAND: CLUSTER_REG_COMMAND = CLUSTER_REG_COMMAND(19i32);
impl ::core::marker::Copy for CLUSTER_REG_COMMAND {}
impl ::core::clone::Clone for CLUSTER_REG_COMMAND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_REG_COMMAND {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_REG_COMMAND {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_REG_COMMAND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_REG_COMMAND").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_REQUEST_REPLY_TIMEOUT: &'static str = "RequestReplyTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_RESOURCE_APPLICATION_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceApplicationStateUnknown: CLUSTER_RESOURCE_APPLICATION_STATE = CLUSTER_RESOURCE_APPLICATION_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceApplicationOSHeartBeat: CLUSTER_RESOURCE_APPLICATION_STATE = CLUSTER_RESOURCE_APPLICATION_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceApplicationReady: CLUSTER_RESOURCE_APPLICATION_STATE = CLUSTER_RESOURCE_APPLICATION_STATE(3i32);
impl ::core::marker::Copy for CLUSTER_RESOURCE_APPLICATION_STATE {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_APPLICATION_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_RESOURCE_APPLICATION_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_APPLICATION_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_APPLICATION_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_RESOURCE_APPLICATION_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_RESOURCE_CLASS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESCLASS_UNKNOWN: CLUSTER_RESOURCE_CLASS = CLUSTER_RESOURCE_CLASS(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESCLASS_STORAGE: CLUSTER_RESOURCE_CLASS = CLUSTER_RESOURCE_CLASS(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESCLASS_NETWORK: CLUSTER_RESOURCE_CLASS = CLUSTER_RESOURCE_CLASS(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESCLASS_USER: CLUSTER_RESOURCE_CLASS = CLUSTER_RESOURCE_CLASS(32768i32);
impl ::core::marker::Copy for CLUSTER_RESOURCE_CLASS {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_CLASS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_RESOURCE_CLASS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_CLASS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_RESOURCE_CLASS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_RESOURCE_CREATE_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_DEFAULT_MONITOR: CLUSTER_RESOURCE_CREATE_FLAGS = CLUSTER_RESOURCE_CREATE_FLAGS(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_SEPARATE_MONITOR: CLUSTER_RESOURCE_CREATE_FLAGS = CLUSTER_RESOURCE_CREATE_FLAGS(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_VALID_FLAGS: CLUSTER_RESOURCE_CREATE_FLAGS = CLUSTER_RESOURCE_CREATE_FLAGS(1i32);
impl ::core::marker::Copy for CLUSTER_RESOURCE_CREATE_FLAGS {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_CREATE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_RESOURCE_CREATE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_CREATE_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_CREATE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_RESOURCE_CREATE_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceEmbeddedFailureActionNone: CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION = CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceEmbeddedFailureActionLogOnly: CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION = CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceEmbeddedFailureActionRecover: CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION = CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION(2i32);
impl ::core::marker::Copy for CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_RESOURCE_EMBEDDED_FAILURE_ACTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_RESOURCE_ENUM(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_ENUM_DEPENDS: CLUSTER_RESOURCE_ENUM = CLUSTER_RESOURCE_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_ENUM_PROVIDES: CLUSTER_RESOURCE_ENUM = CLUSTER_RESOURCE_ENUM(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_ENUM_NODES: CLUSTER_RESOURCE_ENUM = CLUSTER_RESOURCE_ENUM(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_ENUM_ALL: CLUSTER_RESOURCE_ENUM = CLUSTER_RESOURCE_ENUM(7i32);
impl ::core::marker::Copy for CLUSTER_RESOURCE_ENUM {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_RESOURCE_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_ENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_RESOURCE_ENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_RESOURCE_ENUM_ITEM {
    pub dwVersion: u32,
    pub cbId: u32,
    pub lpszId: ::windows::core::PWSTR,
    pub cbName: u32,
    pub lpszName: ::windows::core::PWSTR,
    pub cbOwnerGroupName: u32,
    pub lpszOwnerGroupName: ::windows::core::PWSTR,
    pub cbOwnerGroupId: u32,
    pub lpszOwnerGroupId: ::windows::core::PWSTR,
    pub cbProperties: u32,
    pub pProperties: *mut ::core::ffi::c_void,
    pub cbRoProperties: u32,
    pub pRoProperties: *mut ::core::ffi::c_void,
}
impl ::core::marker::Copy for CLUSTER_RESOURCE_ENUM_ITEM {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_ENUM_ITEM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_ENUM_ITEM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_RESOURCE_ENUM_ITEM")
            .field("dwVersion", &self.dwVersion)
            .field("cbId", &self.cbId)
            .field("lpszId", &self.lpszId)
            .field("cbName", &self.cbName)
            .field("lpszName", &self.lpszName)
            .field("cbOwnerGroupName", &self.cbOwnerGroupName)
            .field("lpszOwnerGroupName", &self.lpszOwnerGroupName)
            .field("cbOwnerGroupId", &self.cbOwnerGroupId)
            .field("lpszOwnerGroupId", &self.lpszOwnerGroupId)
            .field("cbProperties", &self.cbProperties)
            .field("pProperties", &self.pProperties)
            .field("cbRoProperties", &self.cbRoProperties)
            .field("pRoProperties", &self.pRoProperties)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_ENUM_ITEM {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_RESOURCE_ENUM_ITEM {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_RESOURCE_ENUM_ITEM>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_RESOURCE_ENUM_ITEM {}
impl ::core::default::Default for CLUSTER_RESOURCE_ENUM_ITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_ENUM_ITEM_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_ENUM_ITEM_VERSION_1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_RESOURCE_RESTART_ACTION(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceDontRestart: CLUSTER_RESOURCE_RESTART_ACTION = CLUSTER_RESOURCE_RESTART_ACTION(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceRestartNoNotify: CLUSTER_RESOURCE_RESTART_ACTION = CLUSTER_RESOURCE_RESTART_ACTION(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceRestartNotify: CLUSTER_RESOURCE_RESTART_ACTION = CLUSTER_RESOURCE_RESTART_ACTION(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceRestartActionCount: CLUSTER_RESOURCE_RESTART_ACTION = CLUSTER_RESOURCE_RESTART_ACTION(3i32);
impl ::core::marker::Copy for CLUSTER_RESOURCE_RESTART_ACTION {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_RESTART_ACTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_RESOURCE_RESTART_ACTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_RESTART_ACTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_RESTART_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_RESOURCE_RESTART_ACTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_RESOURCE_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceStateUnknown: CLUSTER_RESOURCE_STATE = CLUSTER_RESOURCE_STATE(-1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceInherited: CLUSTER_RESOURCE_STATE = CLUSTER_RESOURCE_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceInitializing: CLUSTER_RESOURCE_STATE = CLUSTER_RESOURCE_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceOnline: CLUSTER_RESOURCE_STATE = CLUSTER_RESOURCE_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceOffline: CLUSTER_RESOURCE_STATE = CLUSTER_RESOURCE_STATE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceFailed: CLUSTER_RESOURCE_STATE = CLUSTER_RESOURCE_STATE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourcePending: CLUSTER_RESOURCE_STATE = CLUSTER_RESOURCE_STATE(128i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceOnlinePending: CLUSTER_RESOURCE_STATE = CLUSTER_RESOURCE_STATE(129i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterResourceOfflinePending: CLUSTER_RESOURCE_STATE = CLUSTER_RESOURCE_STATE(130i32);
impl ::core::marker::Copy for CLUSTER_RESOURCE_STATE {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_RESOURCE_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_RESOURCE_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_RESOURCE_STATE_CHANGE_REASON(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const eResourceStateChangeReasonUnknown: CLUSTER_RESOURCE_STATE_CHANGE_REASON = CLUSTER_RESOURCE_STATE_CHANGE_REASON(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const eResourceStateChangeReasonMove: CLUSTER_RESOURCE_STATE_CHANGE_REASON = CLUSTER_RESOURCE_STATE_CHANGE_REASON(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const eResourceStateChangeReasonFailover: CLUSTER_RESOURCE_STATE_CHANGE_REASON = CLUSTER_RESOURCE_STATE_CHANGE_REASON(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const eResourceStateChangeReasonFailedMove: CLUSTER_RESOURCE_STATE_CHANGE_REASON = CLUSTER_RESOURCE_STATE_CHANGE_REASON(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const eResourceStateChangeReasonShutdown: CLUSTER_RESOURCE_STATE_CHANGE_REASON = CLUSTER_RESOURCE_STATE_CHANGE_REASON(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const eResourceStateChangeReasonRundown: CLUSTER_RESOURCE_STATE_CHANGE_REASON = CLUSTER_RESOURCE_STATE_CHANGE_REASON(5i32);
impl ::core::marker::Copy for CLUSTER_RESOURCE_STATE_CHANGE_REASON {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_STATE_CHANGE_REASON {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_RESOURCE_STATE_CHANGE_REASON {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_STATE_CHANGE_REASON {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_STATE_CHANGE_REASON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_RESOURCE_STATE_CHANGE_REASON").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_RESOURCE_TYPE_ENUM(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_TYPE_ENUM_NODES: CLUSTER_RESOURCE_TYPE_ENUM = CLUSTER_RESOURCE_TYPE_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_TYPE_ENUM_RESOURCES: CLUSTER_RESOURCE_TYPE_ENUM = CLUSTER_RESOURCE_TYPE_ENUM(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RESOURCE_TYPE_ENUM_ALL: CLUSTER_RESOURCE_TYPE_ENUM = CLUSTER_RESOURCE_TYPE_ENUM(3i32);
impl ::core::marker::Copy for CLUSTER_RESOURCE_TYPE_ENUM {}
impl ::core::clone::Clone for CLUSTER_RESOURCE_TYPE_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_RESOURCE_TYPE_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_RESOURCE_TYPE_ENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_RESOURCE_TYPE_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_RESOURCE_TYPE_ENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_ROLE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleDHCP: CLUSTER_ROLE = CLUSTER_ROLE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleDTC: CLUSTER_ROLE = CLUSTER_ROLE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleFileServer: CLUSTER_ROLE = CLUSTER_ROLE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleGenericApplication: CLUSTER_ROLE = CLUSTER_ROLE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleGenericScript: CLUSTER_ROLE = CLUSTER_ROLE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleGenericService: CLUSTER_ROLE = CLUSTER_ROLE(5i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleISCSINameServer: CLUSTER_ROLE = CLUSTER_ROLE(6i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleMSMQ: CLUSTER_ROLE = CLUSTER_ROLE(7i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleNFS: CLUSTER_ROLE = CLUSTER_ROLE(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRolePrintServer: CLUSTER_ROLE = CLUSTER_ROLE(9i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleStandAloneNamespaceServer: CLUSTER_ROLE = CLUSTER_ROLE(10i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleVolumeShadowCopyServiceTask: CLUSTER_ROLE = CLUSTER_ROLE(11i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleWINS: CLUSTER_ROLE = CLUSTER_ROLE(12i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleTaskScheduler: CLUSTER_ROLE = CLUSTER_ROLE(13i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleNetworkFileSystem: CLUSTER_ROLE = CLUSTER_ROLE(14i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleDFSReplicatedFolder: CLUSTER_ROLE = CLUSTER_ROLE(15i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleDistributedFileSystem: CLUSTER_ROLE = CLUSTER_ROLE(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleDistributedNetworkName: CLUSTER_ROLE = CLUSTER_ROLE(17i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleFileShare: CLUSTER_ROLE = CLUSTER_ROLE(18i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleFileShareWitness: CLUSTER_ROLE = CLUSTER_ROLE(19i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleHardDisk: CLUSTER_ROLE = CLUSTER_ROLE(20i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleIPAddress: CLUSTER_ROLE = CLUSTER_ROLE(21i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleIPV6Address: CLUSTER_ROLE = CLUSTER_ROLE(22i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleIPV6TunnelAddress: CLUSTER_ROLE = CLUSTER_ROLE(23i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleISCSITargetServer: CLUSTER_ROLE = CLUSTER_ROLE(24i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleNetworkName: CLUSTER_ROLE = CLUSTER_ROLE(25i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRolePhysicalDisk: CLUSTER_ROLE = CLUSTER_ROLE(26i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleSODAFileServer: CLUSTER_ROLE = CLUSTER_ROLE(27i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleStoragePool: CLUSTER_ROLE = CLUSTER_ROLE(28i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleVirtualMachine: CLUSTER_ROLE = CLUSTER_ROLE(29i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleVirtualMachineConfiguration: CLUSTER_ROLE = CLUSTER_ROLE(30i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleVirtualMachineReplicaBroker: CLUSTER_ROLE = CLUSTER_ROLE(31i32);
impl ::core::marker::Copy for CLUSTER_ROLE {}
impl ::core::clone::Clone for CLUSTER_ROLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_ROLE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_ROLE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_ROLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_ROLE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_ROLE_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleUnknown: CLUSTER_ROLE_STATE = CLUSTER_ROLE_STATE(-1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleClustered: CLUSTER_ROLE_STATE = CLUSTER_ROLE_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterRoleUnclustered: CLUSTER_ROLE_STATE = CLUSTER_ROLE_STATE(1i32);
impl ::core::marker::Copy for CLUSTER_ROLE_STATE {}
impl ::core::clone::Clone for CLUSTER_ROLE_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_ROLE_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_ROLE_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_ROLE_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_ROLE_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_RUNNING: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_S2D_BUS_TYPES: &'static str = "S2DBusTypes";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_S2D_CACHE_BEHAVIOR_FLAGS: &'static str = "S2DCacheBehavior";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_S2D_CACHE_DESIRED_STATE: &'static str = "S2DCacheDesiredState";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_S2D_CACHE_FLASH_RESERVE_PERCENT: &'static str = "S2DCacheFlashReservePercent";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_S2D_CACHE_METADATA_RESERVE: &'static str = "S2DCacheMetadataReserveBytes";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_S2D_CACHE_PAGE_SIZE_KBYTES: &'static str = "S2DCachePageSizeKBytes";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_S2D_ENABLED: &'static str = "S2DEnabled";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_S2D_IO_LATENCY_THRESHOLD: &'static str = "S2DIOLatencyThreshold";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_S2D_OPTIMIZATIONS: &'static str = "S2DOptimizations";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_SETUP_PHASE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseInitialize: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseValidateNodeState: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(100i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseValidateNetft: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(102i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseValidateClusDisk: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(103i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseConfigureClusSvc: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(104i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseStartingClusSvc: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(105i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseQueryClusterNameAccount: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(106i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseValidateClusterNameAccount: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(107i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseCreateClusterAccount: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(108i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseConfigureClusterAccount: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(109i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseFormingCluster: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(200i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseAddClusterProperties: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(201i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseCreateResourceTypes: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(202i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseCreateGroups: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(203i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseCreateIPAddressResources: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(204i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseCreateNetworkName: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(205i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseClusterGroupOnline: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(206i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseGettingCurrentMembership: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(300i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseAddNodeToCluster: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(301i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseNodeUp: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(302i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseMoveGroup: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(400i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseDeleteGroup: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(401i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseCleanupCOs: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(402i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseOfflineGroup: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(403i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseEvictNode: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(404i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseCleanupNode: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(405i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseCoreGroupCleanup: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(406i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseFailureCleanup: CLUSTER_SETUP_PHASE = CLUSTER_SETUP_PHASE(999i32);
impl ::core::marker::Copy for CLUSTER_SETUP_PHASE {}
impl ::core::clone::Clone for CLUSTER_SETUP_PHASE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_SETUP_PHASE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SETUP_PHASE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_SETUP_PHASE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_SETUP_PHASE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_SETUP_PHASE_SEVERITY(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseInformational: CLUSTER_SETUP_PHASE_SEVERITY = CLUSTER_SETUP_PHASE_SEVERITY(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseWarning: CLUSTER_SETUP_PHASE_SEVERITY = CLUSTER_SETUP_PHASE_SEVERITY(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseFatal: CLUSTER_SETUP_PHASE_SEVERITY = CLUSTER_SETUP_PHASE_SEVERITY(3i32);
impl ::core::marker::Copy for CLUSTER_SETUP_PHASE_SEVERITY {}
impl ::core::clone::Clone for CLUSTER_SETUP_PHASE_SEVERITY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_SETUP_PHASE_SEVERITY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SETUP_PHASE_SEVERITY {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_SETUP_PHASE_SEVERITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_SETUP_PHASE_SEVERITY").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_SETUP_PHASE_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseStart: CLUSTER_SETUP_PHASE_TYPE = CLUSTER_SETUP_PHASE_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseContinue: CLUSTER_SETUP_PHASE_TYPE = CLUSTER_SETUP_PHASE_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseEnd: CLUSTER_SETUP_PHASE_TYPE = CLUSTER_SETUP_PHASE_TYPE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSetupPhaseReport: CLUSTER_SETUP_PHASE_TYPE = CLUSTER_SETUP_PHASE_TYPE(4i32);
impl ::core::marker::Copy for CLUSTER_SETUP_PHASE_TYPE {}
impl ::core::clone::Clone for CLUSTER_SETUP_PHASE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_SETUP_PHASE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SETUP_PHASE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_SETUP_PHASE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_SETUP_PHASE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_SET_ACCESS_TYPE_ALLOWED: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_SET_ACCESS_TYPE_DENIED: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUSTER_SET_PASSWORD_STATUS {
    pub NodeId: u32,
    pub SetAttempted: super::super::Foundation::BOOLEAN,
    pub ReturnStatus: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUSTER_SET_PASSWORD_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUSTER_SET_PASSWORD_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUSTER_SET_PASSWORD_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_SET_PASSWORD_STATUS").field("NodeId", &self.NodeId).field("SetAttempted", &self.SetAttempted).field("ReturnStatus", &self.ReturnStatus).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUSTER_SET_PASSWORD_STATUS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUSTER_SET_PASSWORD_STATUS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_SET_PASSWORD_STATUS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUSTER_SET_PASSWORD_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUSTER_SET_PASSWORD_STATUS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_SHARED_VOLUMES_ROOT: &'static str = "SharedVolumesRoot";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_SHARED_VOLUME_BACKUP_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const VolumeBackupNone: CLUSTER_SHARED_VOLUME_BACKUP_STATE = CLUSTER_SHARED_VOLUME_BACKUP_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const VolumeBackupInProgress: CLUSTER_SHARED_VOLUME_BACKUP_STATE = CLUSTER_SHARED_VOLUME_BACKUP_STATE(1i32);
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_BACKUP_STATE {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_BACKUP_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_BACKUP_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_BACKUP_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_SHARED_VOLUME_BACKUP_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_SHARED_VOLUME_BACKUP_STATE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT {
    pub __AnonymousBase_clusapi_L5475_C14: CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME,
    pub __AnonymousBase_clusapi_L5476_C14: CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME,
}
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT {}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_RENAME_GUID_INPUT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_SHARED_VOLUME_RENAME_INPUT {
    pub __AnonymousBase_clusapi_L5464_C14: CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME,
    pub __AnonymousBase_clusapi_L5465_C14: CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME,
}
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_RENAME_INPUT {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_RENAME_INPUT {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_RENAME_INPUT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_SHARED_VOLUME_RENAME_INPUT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_SHARED_VOLUME_RENAME_INPUT>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_SHARED_VOLUME_RENAME_INPUT {}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_RENAME_INPUT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME {
    pub NewVolumeName: [u16; 260],
    pub NewVolumeGuid: [u16; 50],
}
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME").field("NewVolumeName", &self.NewVolumeName).field("NewVolumeGuid", &self.NewVolumeGuid).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME {}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_RENAME_INPUT_GUID_NAME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME {
    pub NewVolumeName: [u16; 260],
}
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME").field("NewVolumeName", &self.NewVolumeName).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME {}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_RENAME_INPUT_NAME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSharedVolumeRenameInputTypeNone: CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE = CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSharedVolumeRenameInputTypeVolumeOffset: CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE = CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSharedVolumeRenameInputTypeVolumeId: CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE = CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSharedVolumeRenameInputTypeVolumeName: CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE = CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSharedVolumeRenameInputTypeVolumeGuid: CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE = CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE(4i32);
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME {
    pub InputType: CLUSTER_SHARED_VOLUME_RENAME_INPUT_TYPE,
    pub Anonymous: CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME_0,
}
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME {}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub union CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME_0 {
    pub VolumeOffset: u64,
    pub VolumeId: [u16; 260],
    pub VolumeName: [u16; 260],
    pub VolumeGuid: [u16; 50],
}
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME_0 {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME_0 {}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_RENAME_INPUT_VOLUME_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSharedVolumeSnapshotStateUnknown: CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE = CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSharedVolumePrepareForHWSnapshot: CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE = CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSharedVolumeHWSnapshotCompleted: CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE = CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterSharedVolumePrepareForFreeze: CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE = CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE(3i32);
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_SHARED_VOLUME_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const SharedVolumeStateUnavailable: CLUSTER_SHARED_VOLUME_STATE = CLUSTER_SHARED_VOLUME_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const SharedVolumeStatePaused: CLUSTER_SHARED_VOLUME_STATE = CLUSTER_SHARED_VOLUME_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const SharedVolumeStateActive: CLUSTER_SHARED_VOLUME_STATE = CLUSTER_SHARED_VOLUME_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const SharedVolumeStateActiveRedirected: CLUSTER_SHARED_VOLUME_STATE = CLUSTER_SHARED_VOLUME_STATE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const SharedVolumeStateActiveVolumeRedirected: CLUSTER_SHARED_VOLUME_STATE = CLUSTER_SHARED_VOLUME_STATE(4i32);
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_STATE {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_SHARED_VOLUME_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_SHARED_VOLUME_STATE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_SHARED_VOLUME_STATE_INFO {
    pub szVolumeName: [u16; 260],
    pub szNodeName: [u16; 260],
    pub VolumeState: CLUSTER_SHARED_VOLUME_STATE,
}
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_STATE_INFO {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_STATE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_SHARED_VOLUME_STATE_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_SHARED_VOLUME_STATE_INFO").field("szVolumeName", &self.szVolumeName).field("szNodeName", &self.szNodeName).field("VolumeState", &self.VolumeState).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_STATE_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_SHARED_VOLUME_STATE_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_SHARED_VOLUME_STATE_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_SHARED_VOLUME_STATE_INFO {}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_STATE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_SHARED_VOLUME_STATE_INFO_EX {
    pub szVolumeName: [u16; 260],
    pub szNodeName: [u16; 260],
    pub VolumeState: CLUSTER_SHARED_VOLUME_STATE,
    pub szVolumeFriendlyName: [u16; 260],
    pub RedirectedIOReason: u64,
    pub VolumeRedirectedIOReason: u64,
}
impl ::core::marker::Copy for CLUSTER_SHARED_VOLUME_STATE_INFO_EX {}
impl ::core::clone::Clone for CLUSTER_SHARED_VOLUME_STATE_INFO_EX {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_SHARED_VOLUME_STATE_INFO_EX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_SHARED_VOLUME_STATE_INFO_EX").field("szVolumeName", &self.szVolumeName).field("szNodeName", &self.szNodeName).field("VolumeState", &self.VolumeState).field("szVolumeFriendlyName", &self.szVolumeFriendlyName).field("RedirectedIOReason", &self.RedirectedIOReason).field("VolumeRedirectedIOReason", &self.VolumeRedirectedIOReason).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_SHARED_VOLUME_STATE_INFO_EX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_SHARED_VOLUME_STATE_INFO_EX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_SHARED_VOLUME_STATE_INFO_EX>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_SHARED_VOLUME_STATE_INFO_EX {}
impl ::core::default::Default for CLUSTER_SHARED_VOLUME_STATE_INFO_EX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_SHARED_VOLUME_VSS_WRITER_OPERATION_TIMEOUT: &'static str = "SharedVolumeVssWriterOperationTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_STORAGENODE_STATE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterStorageNodeStateUnknown: CLUSTER_STORAGENODE_STATE = CLUSTER_STORAGENODE_STATE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterStorageNodeUp: CLUSTER_STORAGENODE_STATE = CLUSTER_STORAGENODE_STATE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterStorageNodeDown: CLUSTER_STORAGENODE_STATE = CLUSTER_STORAGENODE_STATE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterStorageNodePaused: CLUSTER_STORAGENODE_STATE = CLUSTER_STORAGENODE_STATE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterStorageNodeStarting: CLUSTER_STORAGENODE_STATE = CLUSTER_STORAGENODE_STATE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterStorageNodeStopping: CLUSTER_STORAGENODE_STATE = CLUSTER_STORAGENODE_STATE(5i32);
impl ::core::marker::Copy for CLUSTER_STORAGENODE_STATE {}
impl ::core::clone::Clone for CLUSTER_STORAGENODE_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_STORAGENODE_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_STORAGENODE_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_STORAGENODE_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_STORAGENODE_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUSTER_UPGRADE_PHASE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterUpgradePhaseInitialize: CLUSTER_UPGRADE_PHASE = CLUSTER_UPGRADE_PHASE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterUpgradePhaseValidatingUpgrade: CLUSTER_UPGRADE_PHASE = CLUSTER_UPGRADE_PHASE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterUpgradePhaseUpgradingComponents: CLUSTER_UPGRADE_PHASE = CLUSTER_UPGRADE_PHASE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterUpgradePhaseInstallingNewComponents: CLUSTER_UPGRADE_PHASE = CLUSTER_UPGRADE_PHASE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ClusterUpgradePhaseUpgradeComplete: CLUSTER_UPGRADE_PHASE = CLUSTER_UPGRADE_PHASE(5i32);
impl ::core::marker::Copy for CLUSTER_UPGRADE_PHASE {}
impl ::core::clone::Clone for CLUSTER_UPGRADE_PHASE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUSTER_UPGRADE_PHASE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_UPGRADE_PHASE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUSTER_UPGRADE_PHASE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUSTER_UPGRADE_PHASE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_VALIDATE_CSV_FILENAME {
    pub szFileName: [u16; 1],
}
impl ::core::marker::Copy for CLUSTER_VALIDATE_CSV_FILENAME {}
impl ::core::clone::Clone for CLUSTER_VALIDATE_CSV_FILENAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_VALIDATE_CSV_FILENAME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_VALIDATE_CSV_FILENAME").field("szFileName", &self.szFileName).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_VALIDATE_CSV_FILENAME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_VALIDATE_CSV_FILENAME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_VALIDATE_CSV_FILENAME>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_VALIDATE_CSV_FILENAME {}
impl ::core::default::Default for CLUSTER_VALIDATE_CSV_FILENAME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_VALIDATE_DIRECTORY {
    pub szPath: [u16; 1],
}
impl ::core::marker::Copy for CLUSTER_VALIDATE_DIRECTORY {}
impl ::core::clone::Clone for CLUSTER_VALIDATE_DIRECTORY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_VALIDATE_DIRECTORY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_VALIDATE_DIRECTORY").field("szPath", &self.szPath).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_VALIDATE_DIRECTORY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_VALIDATE_DIRECTORY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_VALIDATE_DIRECTORY>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_VALIDATE_DIRECTORY {}
impl ::core::default::Default for CLUSTER_VALIDATE_DIRECTORY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_VALIDATE_NETNAME {
    pub szNetworkName: [u16; 1],
}
impl ::core::marker::Copy for CLUSTER_VALIDATE_NETNAME {}
impl ::core::clone::Clone for CLUSTER_VALIDATE_NETNAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_VALIDATE_NETNAME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_VALIDATE_NETNAME").field("szNetworkName", &self.szNetworkName).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_VALIDATE_NETNAME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_VALIDATE_NETNAME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_VALIDATE_NETNAME>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_VALIDATE_NETNAME {}
impl ::core::default::Default for CLUSTER_VALIDATE_NETNAME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUSTER_VALIDATE_PATH {
    pub szPath: [u16; 1],
}
impl ::core::marker::Copy for CLUSTER_VALIDATE_PATH {}
impl ::core::clone::Clone for CLUSTER_VALIDATE_PATH {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUSTER_VALIDATE_PATH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUSTER_VALIDATE_PATH").field("szPath", &self.szPath).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUSTER_VALIDATE_PATH {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUSTER_VALIDATE_PATH {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUSTER_VALIDATE_PATH>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUSTER_VALIDATE_PATH {}
impl ::core::default::Default for CLUSTER_VALIDATE_PATH {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_VERSION_FLAG_MIXED_MODE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_VERSION_UNKNOWN: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_WITNESS_DATABASE_WRITE_TIMEOUT: &'static str = "WitnessDatabaseWriteTimeout";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUSTER_WITNESS_FAILED_RESTART_INTERVAL: &'static str = "WitnessRestartInterval";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_ACCESS_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_ACCESS_READ: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_ACCESS_WRITE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUS_AFFINITY_RULE_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_AFFINITY_RULE_NONE: CLUS_AFFINITY_RULE_TYPE = CLUS_AFFINITY_RULE_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_AFFINITY_RULE_SAME_FAULT_DOMAIN: CLUS_AFFINITY_RULE_TYPE = CLUS_AFFINITY_RULE_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_AFFINITY_RULE_SAME_NODE: CLUS_AFFINITY_RULE_TYPE = CLUS_AFFINITY_RULE_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_AFFINITY_RULE_DIFFERENT_FAULT_DOMAIN: CLUS_AFFINITY_RULE_TYPE = CLUS_AFFINITY_RULE_TYPE(3i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_AFFINITY_RULE_DIFFERENT_NODE: CLUS_AFFINITY_RULE_TYPE = CLUS_AFFINITY_RULE_TYPE(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_AFFINITY_RULE_MIN: CLUS_AFFINITY_RULE_TYPE = CLUS_AFFINITY_RULE_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_AFFINITY_RULE_MAX: CLUS_AFFINITY_RULE_TYPE = CLUS_AFFINITY_RULE_TYPE(4i32);
impl ::core::marker::Copy for CLUS_AFFINITY_RULE_TYPE {}
impl ::core::clone::Clone for CLUS_AFFINITY_RULE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUS_AFFINITY_RULE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUS_AFFINITY_RULE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUS_AFFINITY_RULE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUS_AFFINITY_RULE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUS_CHARACTERISTICS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_UNKNOWN: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_QUORUM: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_DELETE_REQUIRES_ALL_NODES: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_LOCAL_QUORUM: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(4i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_LOCAL_QUORUM_DEBUG: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(8i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_REQUIRES_STATE_CHANGE_REASON: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(16i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_BROADCAST_DELETE: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(32i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_SINGLE_CLUSTER_INSTANCE: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(64i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_SINGLE_GROUP_INSTANCE: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(128i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_COEXIST_IN_SHARED_VOLUME_GROUP: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(256i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_PLACEMENT_DATA: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(512i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_MONITOR_DETACH: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(1024i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_MONITOR_REATTACH: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(2048i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_OPERATION_CONTEXT: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(4096i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_CLONES: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(8192i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_NOT_PREEMPTABLE: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(16384i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_NOTIFY_NEW_OWNER: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(32768i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_SUPPORTS_UNMONITORED_STATE: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(65536i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_INFRASTRUCTURE: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(131072i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_VETO_DRAIN: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(262144i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CHAR_DRAIN_LOCAL_OFFLINE: CLUS_CHARACTERISTICS = CLUS_CHARACTERISTICS(524288i32);
impl ::core::marker::Copy for CLUS_CHARACTERISTICS {}
impl ::core::clone::Clone for CLUS_CHARACTERISTICS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUS_CHARACTERISTICS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUS_CHARACTERISTICS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUS_CHARACTERISTICS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUS_CHARACTERISTICS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_CHKDSK_INFO {
    pub PartitionNumber: u32,
    pub ChkdskState: u32,
    pub FileIdCount: u32,
    pub FileIdList: [u64; 1],
}
impl ::core::marker::Copy for CLUS_CHKDSK_INFO {}
impl ::core::clone::Clone for CLUS_CHKDSK_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_CHKDSK_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_CHKDSK_INFO").field("PartitionNumber", &self.PartitionNumber).field("ChkdskState", &self.ChkdskState).field("FileIdCount", &self.FileIdCount).field("FileIdList", &self.FileIdList).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_CHKDSK_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_CHKDSK_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_CHKDSK_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_CHKDSK_INFO {}
impl ::core::default::Default for CLUS_CHKDSK_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_CREATE_CRYPT_CONTAINER_NOT_FOUND: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT {
    pub FileServerName: [u16; 16],
}
impl ::core::marker::Copy for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT {}
impl ::core::clone::Clone for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT").field("FileServerName", &self.FileServerName).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT {}
impl ::core::default::Default for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_INPUT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT {
    pub FileServerName: [u16; 260],
}
impl ::core::marker::Copy for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT {}
impl ::core::clone::Clone for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT").field("FileServerName", &self.FileServerName).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT {}
impl ::core::default::Default for CLUS_CREATE_INFRASTRUCTURE_FILESERVER_OUTPUT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUS_CSV_MAINTENANCE_MODE_INFO {
    pub InMaintenance: super::super::Foundation::BOOL,
    pub VolumeName: [u16; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUS_CSV_MAINTENANCE_MODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUS_CSV_MAINTENANCE_MODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUS_CSV_MAINTENANCE_MODE_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_CSV_MAINTENANCE_MODE_INFO").field("InMaintenance", &self.InMaintenance).field("VolumeName", &self.VolumeName).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUS_CSV_MAINTENANCE_MODE_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUS_CSV_MAINTENANCE_MODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_CSV_MAINTENANCE_MODE_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUS_CSV_MAINTENANCE_MODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUS_CSV_MAINTENANCE_MODE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_CSV_VOLUME_INFO {
    pub VolumeOffset: u64,
    pub PartitionNumber: u32,
    pub FaultState: CLUSTER_CSV_VOLUME_FAULT_STATE,
    pub BackupState: CLUSTER_SHARED_VOLUME_BACKUP_STATE,
    pub szVolumeFriendlyName: [u16; 260],
    pub szVolumeName: [u16; 50],
}
impl ::core::marker::Copy for CLUS_CSV_VOLUME_INFO {}
impl ::core::clone::Clone for CLUS_CSV_VOLUME_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_CSV_VOLUME_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_CSV_VOLUME_INFO").field("VolumeOffset", &self.VolumeOffset).field("PartitionNumber", &self.PartitionNumber).field("FaultState", &self.FaultState).field("BackupState", &self.BackupState).field("szVolumeFriendlyName", &self.szVolumeFriendlyName).field("szVolumeName", &self.szVolumeName).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_CSV_VOLUME_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_CSV_VOLUME_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_CSV_VOLUME_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_CSV_VOLUME_INFO {}
impl ::core::default::Default for CLUS_CSV_VOLUME_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_CSV_VOLUME_NAME {
    pub VolumeOffset: i64,
    pub szVolumeName: [u16; 260],
    pub szRootPath: [u16; 263],
}
impl ::core::marker::Copy for CLUS_CSV_VOLUME_NAME {}
impl ::core::clone::Clone for CLUS_CSV_VOLUME_NAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_CSV_VOLUME_NAME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_CSV_VOLUME_NAME").field("VolumeOffset", &self.VolumeOffset).field("szVolumeName", &self.szVolumeName).field("szRootPath", &self.szRootPath).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_CSV_VOLUME_NAME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_CSV_VOLUME_NAME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_CSV_VOLUME_NAME>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_CSV_VOLUME_NAME {}
impl ::core::default::Default for CLUS_CSV_VOLUME_NAME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_DISK_NUMBER_INFO {
    pub DiskNumber: u32,
    pub BytesPerSector: u32,
}
impl ::core::marker::Copy for CLUS_DISK_NUMBER_INFO {}
impl ::core::clone::Clone for CLUS_DISK_NUMBER_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_DISK_NUMBER_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_DISK_NUMBER_INFO").field("DiskNumber", &self.DiskNumber).field("BytesPerSector", &self.BytesPerSector).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_DISK_NUMBER_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_DISK_NUMBER_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_DISK_NUMBER_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_DISK_NUMBER_INFO {}
impl ::core::default::Default for CLUS_DISK_NUMBER_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUS_DNN_LEADER_STATUS {
    pub IsOnline: super::super::Foundation::BOOL,
    pub IsFileServerPresent: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUS_DNN_LEADER_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUS_DNN_LEADER_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUS_DNN_LEADER_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_DNN_LEADER_STATUS").field("IsOnline", &self.IsOnline).field("IsFileServerPresent", &self.IsFileServerPresent).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUS_DNN_LEADER_STATUS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUS_DNN_LEADER_STATUS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_DNN_LEADER_STATUS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUS_DNN_LEADER_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUS_DNN_LEADER_STATUS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_DNN_SODAFS_CLONE_STATUS {
    pub NodeId: u32,
    pub Status: CLUSTER_RESOURCE_STATE,
}
impl ::core::marker::Copy for CLUS_DNN_SODAFS_CLONE_STATUS {}
impl ::core::clone::Clone for CLUS_DNN_SODAFS_CLONE_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_DNN_SODAFS_CLONE_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_DNN_SODAFS_CLONE_STATUS").field("NodeId", &self.NodeId).field("Status", &self.Status).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_DNN_SODAFS_CLONE_STATUS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_DNN_SODAFS_CLONE_STATUS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_DNN_SODAFS_CLONE_STATUS>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_DNN_SODAFS_CLONE_STATUS {}
impl ::core::default::Default for CLUS_DNN_SODAFS_CLONE_STATUS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUS_FLAGS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_FLAG_CORE: CLUS_FLAGS = CLUS_FLAGS(1i32);
impl ::core::marker::Copy for CLUS_FLAGS {}
impl ::core::clone::Clone for CLUS_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUS_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUS_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUS_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUS_FLAGS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_FORCE_QUORUM_INFO {
    pub dwSize: u32,
    pub dwNodeBitMask: u32,
    pub dwMaxNumberofNodes: u32,
    pub multiszNodeList: [u16; 1],
}
impl ::core::marker::Copy for CLUS_FORCE_QUORUM_INFO {}
impl ::core::clone::Clone for CLUS_FORCE_QUORUM_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_FORCE_QUORUM_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_FORCE_QUORUM_INFO").field("dwSize", &self.dwSize).field("dwNodeBitMask", &self.dwNodeBitMask).field("dwMaxNumberofNodes", &self.dwMaxNumberofNodes).field("multiszNodeList", &self.multiszNodeList).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_FORCE_QUORUM_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_FORCE_QUORUM_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_FORCE_QUORUM_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_FORCE_QUORUM_INFO {}
impl ::core::default::Default for CLUS_FORCE_QUORUM_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_FTSET_INFO {
    pub dwRootSignature: u32,
    pub dwFtType: u32,
}
impl ::core::marker::Copy for CLUS_FTSET_INFO {}
impl ::core::clone::Clone for CLUS_FTSET_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_FTSET_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_FTSET_INFO").field("dwRootSignature", &self.dwRootSignature).field("dwFtType", &self.dwFtType).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_FTSET_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_FTSET_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_FTSET_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_FTSET_INFO {}
impl ::core::default::Default for CLUS_FTSET_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_GLOBAL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUS_GROUP_START_SETTING(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_GROUP_START_ALWAYS: CLUS_GROUP_START_SETTING = CLUS_GROUP_START_SETTING(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_GROUP_DO_NOT_START: CLUS_GROUP_START_SETTING = CLUS_GROUP_START_SETTING(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_GROUP_START_ALLOWED: CLUS_GROUP_START_SETTING = CLUS_GROUP_START_SETTING(2i32);
impl ::core::marker::Copy for CLUS_GROUP_START_SETTING {}
impl ::core::clone::Clone for CLUS_GROUP_START_SETTING {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUS_GROUP_START_SETTING {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUS_GROUP_START_SETTING {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUS_GROUP_START_SETTING {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUS_GROUP_START_SETTING").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_GRP_MOVE_ALLOWED: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_GRP_MOVE_LOCKED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_HYBRID_QUORUM: u32 = 1024u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUS_MAINTENANCE_MODE_INFO {
    pub InMaintenance: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUS_MAINTENANCE_MODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUS_MAINTENANCE_MODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUS_MAINTENANCE_MODE_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_MAINTENANCE_MODE_INFO").field("InMaintenance", &self.InMaintenance).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUS_MAINTENANCE_MODE_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUS_MAINTENANCE_MODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_MAINTENANCE_MODE_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUS_MAINTENANCE_MODE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUS_MAINTENANCE_MODE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUS_MAINTENANCE_MODE_INFOEX {
    pub InMaintenance: super::super::Foundation::BOOL,
    pub MaintainenceModeType: MAINTENANCE_MODE_TYPE_ENUM,
    pub InternalState: CLUSTER_RESOURCE_STATE,
    pub Signature: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUS_MAINTENANCE_MODE_INFOEX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUS_MAINTENANCE_MODE_INFOEX {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUS_MAINTENANCE_MODE_INFOEX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_MAINTENANCE_MODE_INFOEX").field("InMaintenance", &self.InMaintenance).field("MaintainenceModeType", &self.MaintainenceModeType).field("InternalState", &self.InternalState).field("Signature", &self.Signature).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUS_MAINTENANCE_MODE_INFOEX {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUS_MAINTENANCE_MODE_INFOEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_MAINTENANCE_MODE_INFOEX>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUS_MAINTENANCE_MODE_INFOEX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUS_MAINTENANCE_MODE_INFOEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_MODIFY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_CLUSTER_GROUPID: &'static str = "ClusterGroupId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_DATA_RESID: &'static str = "DataResourceId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_LOG_MULTIPLE: &'static str = "LogSizeMultiple";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_LOG_RESID: &'static str = "LogResourceId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_LOG_VOLUME: &'static str = "LogVolume";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_MINIMUM_LOG_SIZE: &'static str = "MinimumLogSizeInBytes";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_REPLICATION_GROUPID: &'static str = "ReplicationGroupId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_REPLICATION_GROUP_TYPE: &'static str = "ReplicationClusterGroupType";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_SOURCE_RESID: &'static str = "SourceResourceId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_SOURCE_VOLUMES: &'static str = "SourceVolumes";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_TARGET_RESID: &'static str = "TargetResourceId";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_TARGET_VOLUMES: &'static str = "TargetVolumes";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NAME_RES_TYPE_UNIT_LOG_SIZE_CHANGE: &'static str = "UnitOfLogSizeChangeInBytes";
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_NETNAME_IP_INFO_ENTRY {
    pub NodeId: u32,
    pub AddressSize: u32,
    pub Address: [u8; 1],
}
impl ::core::marker::Copy for CLUS_NETNAME_IP_INFO_ENTRY {}
impl ::core::clone::Clone for CLUS_NETNAME_IP_INFO_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_NETNAME_IP_INFO_ENTRY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_NETNAME_IP_INFO_ENTRY").field("NodeId", &self.NodeId).field("AddressSize", &self.AddressSize).field("Address", &self.Address).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_NETNAME_IP_INFO_ENTRY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_NETNAME_IP_INFO_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_NETNAME_IP_INFO_ENTRY>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_NETNAME_IP_INFO_ENTRY {}
impl ::core::default::Default for CLUS_NETNAME_IP_INFO_ENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL {
    pub szName: [u16; 64],
    pub NumEntries: u32,
    pub IpInfo: [CLUS_NETNAME_IP_INFO_ENTRY; 1],
}
impl ::core::marker::Copy for CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL {}
impl ::core::clone::Clone for CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL").field("szName", &self.szName).field("NumEntries", &self.NumEntries).field("IpInfo", &self.IpInfo).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL {}
impl ::core::default::Default for CLUS_NETNAME_IP_INFO_FOR_MULTICHANNEL {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_NETNAME_PWD_INFO {
    pub Flags: u32,
    pub Password: [u16; 16],
    pub CreatingDC: [u16; 258],
    pub ObjectGuid: [u16; 64],
}
impl ::core::marker::Copy for CLUS_NETNAME_PWD_INFO {}
impl ::core::clone::Clone for CLUS_NETNAME_PWD_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_NETNAME_PWD_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_NETNAME_PWD_INFO").field("Flags", &self.Flags).field("Password", &self.Password).field("CreatingDC", &self.CreatingDC).field("ObjectGuid", &self.ObjectGuid).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_NETNAME_PWD_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_NETNAME_PWD_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_NETNAME_PWD_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_NETNAME_PWD_INFO {}
impl ::core::default::Default for CLUS_NETNAME_PWD_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_NETNAME_PWD_INFOEX {
    pub Flags: u32,
    pub Password: [u16; 128],
    pub CreatingDC: [u16; 258],
    pub ObjectGuid: [u16; 64],
}
impl ::core::marker::Copy for CLUS_NETNAME_PWD_INFOEX {}
impl ::core::clone::Clone for CLUS_NETNAME_PWD_INFOEX {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_NETNAME_PWD_INFOEX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_NETNAME_PWD_INFOEX").field("Flags", &self.Flags).field("Password", &self.Password).field("CreatingDC", &self.CreatingDC).field("ObjectGuid", &self.ObjectGuid).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_NETNAME_PWD_INFOEX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_NETNAME_PWD_INFOEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_NETNAME_PWD_INFOEX>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_NETNAME_PWD_INFOEX {}
impl ::core::default::Default for CLUS_NETNAME_PWD_INFOEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUS_NETNAME_VS_TOKEN_INFO {
    pub ProcessID: u32,
    pub DesiredAccess: u32,
    pub InheritHandle: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUS_NETNAME_VS_TOKEN_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUS_NETNAME_VS_TOKEN_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUS_NETNAME_VS_TOKEN_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_NETNAME_VS_TOKEN_INFO").field("ProcessID", &self.ProcessID).field("DesiredAccess", &self.DesiredAccess).field("InheritHandle", &self.InheritHandle).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUS_NETNAME_VS_TOKEN_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUS_NETNAME_VS_TOKEN_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_NETNAME_VS_TOKEN_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUS_NETNAME_VS_TOKEN_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUS_NETNAME_VS_TOKEN_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NODE_MAJORITY_QUORUM: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NOT_GLOBAL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_NO_MODIFY: u32 = 0u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_PARTITION_INFO {
    pub dwFlags: u32,
    pub szDeviceName: [u16; 260],
    pub szVolumeLabel: [u16; 260],
    pub dwSerialNumber: u32,
    pub rgdwMaximumComponentLength: u32,
    pub dwFileSystemFlags: u32,
    pub szFileSystem: [u16; 32],
}
impl ::core::marker::Copy for CLUS_PARTITION_INFO {}
impl ::core::clone::Clone for CLUS_PARTITION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_PARTITION_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_PARTITION_INFO").field("dwFlags", &self.dwFlags).field("szDeviceName", &self.szDeviceName).field("szVolumeLabel", &self.szVolumeLabel).field("dwSerialNumber", &self.dwSerialNumber).field("rgdwMaximumComponentLength", &self.rgdwMaximumComponentLength).field("dwFileSystemFlags", &self.dwFileSystemFlags).field("szFileSystem", &self.szFileSystem).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_PARTITION_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_PARTITION_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_PARTITION_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_PARTITION_INFO {}
impl ::core::default::Default for CLUS_PARTITION_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_PARTITION_INFO_EX {
    pub dwFlags: u32,
    pub szDeviceName: [u16; 260],
    pub szVolumeLabel: [u16; 260],
    pub dwSerialNumber: u32,
    pub rgdwMaximumComponentLength: u32,
    pub dwFileSystemFlags: u32,
    pub szFileSystem: [u16; 32],
    pub TotalSizeInBytes: u64,
    pub FreeSizeInBytes: u64,
    pub DeviceNumber: u32,
    pub PartitionNumber: u32,
    pub VolumeGuid: ::windows::core::GUID,
}
impl ::core::marker::Copy for CLUS_PARTITION_INFO_EX {}
impl ::core::clone::Clone for CLUS_PARTITION_INFO_EX {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_PARTITION_INFO_EX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_PARTITION_INFO_EX")
            .field("dwFlags", &self.dwFlags)
            .field("szDeviceName", &self.szDeviceName)
            .field("szVolumeLabel", &self.szVolumeLabel)
            .field("dwSerialNumber", &self.dwSerialNumber)
            .field("rgdwMaximumComponentLength", &self.rgdwMaximumComponentLength)
            .field("dwFileSystemFlags", &self.dwFileSystemFlags)
            .field("szFileSystem", &self.szFileSystem)
            .field("TotalSizeInBytes", &self.TotalSizeInBytes)
            .field("FreeSizeInBytes", &self.FreeSizeInBytes)
            .field("DeviceNumber", &self.DeviceNumber)
            .field("PartitionNumber", &self.PartitionNumber)
            .field("VolumeGuid", &self.VolumeGuid)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_PARTITION_INFO_EX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_PARTITION_INFO_EX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_PARTITION_INFO_EX>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_PARTITION_INFO_EX {}
impl ::core::default::Default for CLUS_PARTITION_INFO_EX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_PARTITION_INFO_EX2 {
    pub GptPartitionId: ::windows::core::GUID,
    pub szPartitionName: [u16; 260],
    pub EncryptionFlags: u32,
}
impl ::core::marker::Copy for CLUS_PARTITION_INFO_EX2 {}
impl ::core::clone::Clone for CLUS_PARTITION_INFO_EX2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_PARTITION_INFO_EX2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_PARTITION_INFO_EX2").field("GptPartitionId", &self.GptPartitionId).field("szPartitionName", &self.szPartitionName).field("EncryptionFlags", &self.EncryptionFlags).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_PARTITION_INFO_EX2 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_PARTITION_INFO_EX2 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_PARTITION_INFO_EX2>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_PARTITION_INFO_EX2 {}
impl ::core::default::Default for CLUS_PARTITION_INFO_EX2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_PROVIDER_STATE_CHANGE_INFO {
    pub dwSize: u32,
    pub resourceState: CLUSTER_RESOURCE_STATE,
    pub szProviderId: [u16; 1],
}
impl ::core::marker::Copy for CLUS_PROVIDER_STATE_CHANGE_INFO {}
impl ::core::clone::Clone for CLUS_PROVIDER_STATE_CHANGE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_PROVIDER_STATE_CHANGE_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_PROVIDER_STATE_CHANGE_INFO").field("dwSize", &self.dwSize).field("resourceState", &self.resourceState).field("szProviderId", &self.szProviderId).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_PROVIDER_STATE_CHANGE_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_PROVIDER_STATE_CHANGE_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_PROVIDER_STATE_CHANGE_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_PROVIDER_STATE_CHANGE_INFO {}
impl ::core::default::Default for CLUS_PROVIDER_STATE_CHANGE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_OFFLINE_DO_NOT_UPDATE_PERSISTENT_STATE: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_OFFLINE_DUE_TO_EMBEDDED_FAILURE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_OFFLINE_IGNORE_NETWORK_CONNECTIVITY: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_OFFLINE_IGNORE_RESOURCE_STATUS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_OFFLINE_QUEUE_ENABLED: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_OFFLINE_RETURNING_TO_SOURCE_NODE_BECAUSE_OF_ERROR: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_OFFLINE_RETURN_TO_SOURCE_NODE_ON_ERROR: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_ONLINE_IGNORE_NETWORK_CONNECTIVITY: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_ONLINE_IGNORE_RESOURCE_STATUS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_ONLINE_RECOVER_MONITOR_STATE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_ONLINE_RESTORE_ONLINE_STATE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_ONLINE_RETURN_TO_SOURCE_NODE_ON_ERROR: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_OPEN_DONT_DELETE_TEMP_DISK: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESDLL_OPEN_RECOVER_MONITOR_STATE: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_RESOURCE_CLASS_INFO {
    pub Anonymous: CLUS_RESOURCE_CLASS_INFO_0,
}
impl ::core::marker::Copy for CLUS_RESOURCE_CLASS_INFO {}
impl ::core::clone::Clone for CLUS_RESOURCE_CLASS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUS_RESOURCE_CLASS_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_RESOURCE_CLASS_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_RESOURCE_CLASS_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_RESOURCE_CLASS_INFO {}
impl ::core::default::Default for CLUS_RESOURCE_CLASS_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub union CLUS_RESOURCE_CLASS_INFO_0 {
    pub Anonymous: CLUS_RESOURCE_CLASS_INFO_0_0,
    pub li: u64,
}
impl ::core::marker::Copy for CLUS_RESOURCE_CLASS_INFO_0 {}
impl ::core::clone::Clone for CLUS_RESOURCE_CLASS_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUS_RESOURCE_CLASS_INFO_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_RESOURCE_CLASS_INFO_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_RESOURCE_CLASS_INFO_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_RESOURCE_CLASS_INFO_0 {}
impl ::core::default::Default for CLUS_RESOURCE_CLASS_INFO_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_RESOURCE_CLASS_INFO_0_0 {
    pub Anonymous: CLUS_RESOURCE_CLASS_INFO_0_0_0,
    pub SubClass: u32,
}
impl ::core::marker::Copy for CLUS_RESOURCE_CLASS_INFO_0_0 {}
impl ::core::clone::Clone for CLUS_RESOURCE_CLASS_INFO_0_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUS_RESOURCE_CLASS_INFO_0_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_RESOURCE_CLASS_INFO_0_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_RESOURCE_CLASS_INFO_0_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_RESOURCE_CLASS_INFO_0_0 {}
impl ::core::default::Default for CLUS_RESOURCE_CLASS_INFO_0_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub union CLUS_RESOURCE_CLASS_INFO_0_0_0 {
    pub dw: u32,
    pub rc: CLUSTER_RESOURCE_CLASS,
}
impl ::core::marker::Copy for CLUS_RESOURCE_CLASS_INFO_0_0_0 {}
impl ::core::clone::Clone for CLUS_RESOURCE_CLASS_INFO_0_0_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUS_RESOURCE_CLASS_INFO_0_0_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_RESOURCE_CLASS_INFO_0_0_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_RESOURCE_CLASS_INFO_0_0_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_RESOURCE_CLASS_INFO_0_0_0 {}
impl ::core::default::Default for CLUS_RESOURCE_CLASS_INFO_0_0_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUS_RESSUBCLASS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESSUBCLASS_SHARED: CLUS_RESSUBCLASS = CLUS_RESSUBCLASS(-2147483648i32);
impl ::core::marker::Copy for CLUS_RESSUBCLASS {}
impl ::core::clone::Clone for CLUS_RESSUBCLASS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUS_RESSUBCLASS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUS_RESSUBCLASS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUS_RESSUBCLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUS_RESSUBCLASS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUS_RESSUBCLASS_NETWORK(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESSUBCLASS_NETWORK_INTERNET_PROTOCOL: CLUS_RESSUBCLASS_NETWORK = CLUS_RESSUBCLASS_NETWORK(-2147483648i32);
impl ::core::marker::Copy for CLUS_RESSUBCLASS_NETWORK {}
impl ::core::clone::Clone for CLUS_RESSUBCLASS_NETWORK {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUS_RESSUBCLASS_NETWORK {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUS_RESSUBCLASS_NETWORK {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUS_RESSUBCLASS_NETWORK {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUS_RESSUBCLASS_NETWORK").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CLUS_RESSUBCLASS_STORAGE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESSUBCLASS_STORAGE_SHARED_BUS: CLUS_RESSUBCLASS_STORAGE = CLUS_RESSUBCLASS_STORAGE(-2147483648i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESSUBCLASS_STORAGE_DISK: CLUS_RESSUBCLASS_STORAGE = CLUS_RESSUBCLASS_STORAGE(1073741824i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESSUBCLASS_STORAGE_REPLICATION: CLUS_RESSUBCLASS_STORAGE = CLUS_RESSUBCLASS_STORAGE(268435456i32);
impl ::core::marker::Copy for CLUS_RESSUBCLASS_STORAGE {}
impl ::core::clone::Clone for CLUS_RESSUBCLASS_STORAGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CLUS_RESSUBCLASS_STORAGE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CLUS_RESSUBCLASS_STORAGE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CLUS_RESSUBCLASS_STORAGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CLUS_RESSUBCLASS_STORAGE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_CAU: &'static str = "ClusterAwareUpdatingResource";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_CLOUD_WITNESS: &'static str = "Cloud Witness";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_CONTAINER: &'static str = "Container";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_CROSS_CLUSTER: &'static str = "Cross Cluster Dependency Orchestrator";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_DFS: &'static str = "Distributed File System";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_DFSR: &'static str = "DFS Replicated Folder";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_DHCP: &'static str = "DHCP Service";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_DNN: &'static str = "Distributed Network Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_FILESERVER: &'static str = "File Server";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_FILESHR: &'static str = "File Share";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_FSWITNESS: &'static str = "File Share Witness";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_GENAPP: &'static str = "Generic Application";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_GENSCRIPT: &'static str = "Generic Script";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_GENSVC: &'static str = "Generic Service";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_HARDDISK: &'static str = "Physical Disk";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_HCSVM: &'static str = "HCS Virtual Machine";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_HEALTH_SERVICE: &'static str = "Health Service";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_IPADDR: &'static str = "IP Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_IPV6_NATIVE: &'static str = "IPv6 Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_IPV6_TUNNEL: &'static str = "IPv6 Tunnel Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_ISCSITARGET: &'static str = "iSCSI Target Server";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_ISNS: &'static str = "Microsoft iSNS";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_MSDTC: &'static str = "Distributed Transaction Coordinator";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_MSMQ: &'static str = "Microsoft Message Queue Server";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_MSMQ_TRIGGER: &'static str = "MSMQTriggers";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_NAT: &'static str = "Nat";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_NETNAME: &'static str = "Network Name";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_NETWORK_FILE_SYSTEM: &'static str = "Network File System";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_NEW_MSMQ: &'static str = "MSMQ";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_NFS: &'static str = "NFS Share";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_NFS_MSNS: &'static str = "NFS Multi Server Namespace";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_NFS_V2: &'static str = "Network File System";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_NV_PROVIDER_ADDRESS: &'static str = "Provider Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_PHYS_DISK: &'static str = "Physical Disk";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_PRTSPLR: &'static str = "Print Spooler";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_SCALEOUT_MASTER: &'static str = "Scaleout Master";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_SCALEOUT_WORKER: &'static str = "Scaleout Worker";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_SDDC_MANAGEMENT: &'static str = "SDDC Management";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_SODAFILESERVER: &'static str = "Scale Out File Server";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_STORAGE_POLICIES: &'static str = "Storage Policies";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_STORAGE_POOL: &'static str = "Storage Pool";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_STORAGE_REPLICA: &'static str = "Storage Replica";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_STORQOS: &'static str = "Storage QoS Policy Manager";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_TASKSCHEDULER: &'static str = "Task Scheduler";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_VIRTUAL_IPV4: &'static str = "Disjoint IPv4 Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_VIRTUAL_IPV6: &'static str = "Disjoint IPv6 Address";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_VM: &'static str = "Virtual Machine";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_VMREPLICA_BROKER: &'static str = "Virtual Machine Replication Broker";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_VMREPLICA_COORDINATOR: &'static str = "Virtual Machine Replication Coordinator";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_VM_CONFIG: &'static str = "Virtual Machine Configuration";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_VM_WMI: &'static str = "Virtual Machine Cluster WMI";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_VSSTASK: &'static str = "Volume Shadow Copy Service Task";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RESTYPE_NAME_WINS: &'static str = "WINS Service";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RES_NAME_SCALEOUT_MASTER: &'static str = "Scaleout Master";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CLUS_RES_NAME_SCALEOUT_WORKER: &'static str = "Scaleout Worker";
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_SCSI_ADDRESS {
    pub Anonymous: CLUS_SCSI_ADDRESS_0,
}
impl ::core::marker::Copy for CLUS_SCSI_ADDRESS {}
impl ::core::clone::Clone for CLUS_SCSI_ADDRESS {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUS_SCSI_ADDRESS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_SCSI_ADDRESS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_SCSI_ADDRESS>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_SCSI_ADDRESS {}
impl ::core::default::Default for CLUS_SCSI_ADDRESS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub union CLUS_SCSI_ADDRESS_0 {
    pub Anonymous: CLUS_SCSI_ADDRESS_0_0,
    pub dw: u32,
}
impl ::core::marker::Copy for CLUS_SCSI_ADDRESS_0 {}
impl ::core::clone::Clone for CLUS_SCSI_ADDRESS_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CLUS_SCSI_ADDRESS_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_SCSI_ADDRESS_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_SCSI_ADDRESS_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_SCSI_ADDRESS_0 {}
impl ::core::default::Default for CLUS_SCSI_ADDRESS_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_SCSI_ADDRESS_0_0 {
    pub PortNumber: u8,
    pub PathId: u8,
    pub TargetId: u8,
    pub Lun: u8,
}
impl ::core::marker::Copy for CLUS_SCSI_ADDRESS_0_0 {}
impl ::core::clone::Clone for CLUS_SCSI_ADDRESS_0_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_SCSI_ADDRESS_0_0 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_SCSI_ADDRESS_0_0").field("PortNumber", &self.PortNumber).field("PathId", &self.PathId).field("TargetId", &self.TargetId).field("Lun", &self.Lun).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_SCSI_ADDRESS_0_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_SCSI_ADDRESS_0_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_SCSI_ADDRESS_0_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_SCSI_ADDRESS_0_0 {}
impl ::core::default::Default for CLUS_SCSI_ADDRESS_0_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUS_SET_MAINTENANCE_MODE_INPUT {
    pub InMaintenance: super::super::Foundation::BOOL,
    pub ExtraParameterSize: u32,
    pub ExtraParameter: [u8; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUS_SET_MAINTENANCE_MODE_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUS_SET_MAINTENANCE_MODE_INPUT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUS_SET_MAINTENANCE_MODE_INPUT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_SET_MAINTENANCE_MODE_INPUT").field("InMaintenance", &self.InMaintenance).field("ExtraParameterSize", &self.ExtraParameterSize).field("ExtraParameter", &self.ExtraParameter).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUS_SET_MAINTENANCE_MODE_INPUT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUS_SET_MAINTENANCE_MODE_INPUT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_SET_MAINTENANCE_MODE_INPUT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUS_SET_MAINTENANCE_MODE_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUS_SET_MAINTENANCE_MODE_INPUT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_SHARED_VOLUME_BACKUP_MODE {
    pub BackupState: CLUSTER_SHARED_VOLUME_BACKUP_STATE,
    pub DelayTimerInSecs: u32,
    pub VolumeName: [u16; 260],
}
impl ::core::marker::Copy for CLUS_SHARED_VOLUME_BACKUP_MODE {}
impl ::core::clone::Clone for CLUS_SHARED_VOLUME_BACKUP_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_SHARED_VOLUME_BACKUP_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_SHARED_VOLUME_BACKUP_MODE").field("BackupState", &self.BackupState).field("DelayTimerInSecs", &self.DelayTimerInSecs).field("VolumeName", &self.VolumeName).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_SHARED_VOLUME_BACKUP_MODE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_SHARED_VOLUME_BACKUP_MODE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_SHARED_VOLUME_BACKUP_MODE>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_SHARED_VOLUME_BACKUP_MODE {}
impl ::core::default::Default for CLUS_SHARED_VOLUME_BACKUP_MODE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUS_STARTING_PARAMS {
    pub dwSize: u32,
    pub bForm: super::super::Foundation::BOOL,
    pub bFirst: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUS_STARTING_PARAMS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUS_STARTING_PARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUS_STARTING_PARAMS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_STARTING_PARAMS").field("dwSize", &self.dwSize).field("bForm", &self.bForm).field("bFirst", &self.bFirst).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUS_STARTING_PARAMS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUS_STARTING_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_STARTING_PARAMS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUS_STARTING_PARAMS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUS_STARTING_PARAMS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS {
    pub AvailDrivelettersMask: u32,
}
impl ::core::marker::Copy for CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS {}
impl ::core::clone::Clone for CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS").field("AvailDrivelettersMask", &self.AvailDrivelettersMask).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS {}
impl ::core::default::Default for CLUS_STORAGE_GET_AVAILABLE_DRIVELETTERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_STORAGE_REMAP_DRIVELETTER {
    pub CurrentDriveLetterMask: u32,
    pub TargetDriveLetterMask: u32,
}
impl ::core::marker::Copy for CLUS_STORAGE_REMAP_DRIVELETTER {}
impl ::core::clone::Clone for CLUS_STORAGE_REMAP_DRIVELETTER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_STORAGE_REMAP_DRIVELETTER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_STORAGE_REMAP_DRIVELETTER").field("CurrentDriveLetterMask", &self.CurrentDriveLetterMask).field("TargetDriveLetterMask", &self.TargetDriveLetterMask).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_STORAGE_REMAP_DRIVELETTER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_STORAGE_REMAP_DRIVELETTER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_STORAGE_REMAP_DRIVELETTER>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_STORAGE_REMAP_DRIVELETTER {}
impl ::core::default::Default for CLUS_STORAGE_REMAP_DRIVELETTER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct CLUS_STORAGE_SET_DRIVELETTER {
    pub PartitionNumber: u32,
    pub DriveLetterMask: u32,
}
impl ::core::marker::Copy for CLUS_STORAGE_SET_DRIVELETTER {}
impl ::core::clone::Clone for CLUS_STORAGE_SET_DRIVELETTER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CLUS_STORAGE_SET_DRIVELETTER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_STORAGE_SET_DRIVELETTER").field("PartitionNumber", &self.PartitionNumber).field("DriveLetterMask", &self.DriveLetterMask).finish()
    }
}
unsafe impl ::windows::core::Abi for CLUS_STORAGE_SET_DRIVELETTER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CLUS_STORAGE_SET_DRIVELETTER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_STORAGE_SET_DRIVELETTER>()) == 0 }
    }
}
impl ::core::cmp::Eq for CLUS_STORAGE_SET_DRIVELETTER {}
impl ::core::default::Default for CLUS_STORAGE_SET_DRIVELETTER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CLUS_WORKER {
    pub hThread: super::super::Foundation::HANDLE,
    pub Terminate: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CLUS_WORKER {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CLUS_WORKER {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CLUS_WORKER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CLUS_WORKER").field("hThread", &self.hThread).field("Terminate", &self.Terminate).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CLUS_WORKER {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CLUS_WORKER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CLUS_WORKER>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CLUS_WORKER {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CLUS_WORKER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CREATEDC_PRESENT: u32 = 2u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CREATE_CLUSTER_CONFIG {
    pub dwVersion: u32,
    pub lpszClusterName: ::windows::core::PCWSTR,
    pub cNodes: u32,
    pub ppszNodeNames: *mut ::windows::core::PWSTR,
    pub cIpEntries: u32,
    pub pIpEntries: *mut CLUSTER_IP_ENTRY,
    pub fEmptyCluster: super::super::Foundation::BOOLEAN,
    pub managementPointType: CLUSTER_MGMT_POINT_TYPE,
    pub managementPointResType: CLUSTER_MGMT_POINT_RESTYPE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CREATE_CLUSTER_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CREATE_CLUSTER_CONFIG {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CREATE_CLUSTER_CONFIG {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CREATE_CLUSTER_CONFIG").field("dwVersion", &self.dwVersion).field("lpszClusterName", &self.lpszClusterName).field("cNodes", &self.cNodes).field("ppszNodeNames", &self.ppszNodeNames).field("cIpEntries", &self.cIpEntries).field("pIpEntries", &self.pIpEntries).field("fEmptyCluster", &self.fEmptyCluster).field("managementPointType", &self.managementPointType).field("managementPointResType", &self.managementPointResType).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CREATE_CLUSTER_CONFIG {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CREATE_CLUSTER_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CREATE_CLUSTER_CONFIG>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CREATE_CLUSTER_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CREATE_CLUSTER_CONFIG {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CREATE_CLUSTER_MAJOR_VERSION_MASK: u32 = 4294967040u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CREATE_CLUSTER_NAME_ACCOUNT {
    pub dwVersion: u32,
    pub lpszClusterName: ::windows::core::PCWSTR,
    pub dwFlags: u32,
    pub pszUserName: ::windows::core::PCWSTR,
    pub pszPassword: ::windows::core::PCWSTR,
    pub pszDomain: ::windows::core::PCWSTR,
    pub managementPointType: CLUSTER_MGMT_POINT_TYPE,
    pub managementPointResType: CLUSTER_MGMT_POINT_RESTYPE,
    pub bUpgradeVCOs: super::super::Foundation::BOOLEAN,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CREATE_CLUSTER_NAME_ACCOUNT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CREATE_CLUSTER_NAME_ACCOUNT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CREATE_CLUSTER_NAME_ACCOUNT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CREATE_CLUSTER_NAME_ACCOUNT").field("dwVersion", &self.dwVersion).field("lpszClusterName", &self.lpszClusterName).field("dwFlags", &self.dwFlags).field("pszUserName", &self.pszUserName).field("pszPassword", &self.pszPassword).field("pszDomain", &self.pszDomain).field("managementPointType", &self.managementPointType).field("managementPointResType", &self.managementPointResType).field("bUpgradeVCOs", &self.bUpgradeVCOs).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CREATE_CLUSTER_NAME_ACCOUNT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CREATE_CLUSTER_NAME_ACCOUNT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CREATE_CLUSTER_NAME_ACCOUNT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CREATE_CLUSTER_NAME_ACCOUNT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CREATE_CLUSTER_NAME_ACCOUNT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const CREATE_CLUSTER_VERSION: u32 = 1536u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CanResourceBeDependent(hresource: *const _HRESOURCE, hresourcedependent: *const _HRESOURCE) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CanResourceBeDependent(hresource: *const _HRESOURCE, hresourcedependent: *const _HRESOURCE) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CanResourceBeDependent(::core::mem::transmute(hresource), ::core::mem::transmute(hresourcedependent)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn CancelClusterGroupOperation(hgroup: *const _HGROUP, dwcancelflags_reserved: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CancelClusterGroupOperation(hgroup: *const _HGROUP, dwcancelflags_reserved: u32) -> u32;
        }
        ::core::mem::transmute(CancelClusterGroupOperation(::core::mem::transmute(hgroup), ::core::mem::transmute(dwcancelflags_reserved)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ChangeClusterResourceGroup(hresource: *const _HRESOURCE, hgroup: *const _HGROUP) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ChangeClusterResourceGroup(hresource: *const _HRESOURCE, hgroup: *const _HGROUP) -> u32;
        }
        ::core::mem::transmute(ChangeClusterResourceGroup(::core::mem::transmute(hresource), ::core::mem::transmute(hgroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ChangeClusterResourceGroupEx(hresource: *const _HRESOURCE, hgroup: *const _HGROUP, flags: u64) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ChangeClusterResourceGroupEx(hresource: *const _HRESOURCE, hgroup: *const _HGROUP, flags: u64) -> u32;
        }
        ::core::mem::transmute(ChangeClusterResourceGroupEx(::core::mem::transmute(hresource), ::core::mem::transmute(hgroup), ::core::mem::transmute(flags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CloseCluster(hcluster: *const _HCLUSTER) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseCluster(hcluster: *const _HCLUSTER) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CloseCluster(::core::mem::transmute(hcluster)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn CloseClusterCryptProvider(hcluscryptprovider: *const _HCLUSCRYPTPROVIDER) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseClusterCryptProvider(hcluscryptprovider: *const _HCLUSCRYPTPROVIDER) -> u32;
        }
        ::core::mem::transmute(CloseClusterCryptProvider(::core::mem::transmute(hcluscryptprovider)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CloseClusterGroup(hgroup: *const _HGROUP) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseClusterGroup(hgroup: *const _HGROUP) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CloseClusterGroup(::core::mem::transmute(hgroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CloseClusterGroupSet(hgroupset: *const _HGROUPSET) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseClusterGroupSet(hgroupset: *const _HGROUPSET) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CloseClusterGroupSet(::core::mem::transmute(hgroupset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CloseClusterNetInterface(hnetinterface: *const _HNETINTERFACE) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseClusterNetInterface(hnetinterface: *const _HNETINTERFACE) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CloseClusterNetInterface(::core::mem::transmute(hnetinterface)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CloseClusterNetwork(hnetwork: *const _HNETWORK) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseClusterNetwork(hnetwork: *const _HNETWORK) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CloseClusterNetwork(::core::mem::transmute(hnetwork)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CloseClusterNode(hnode: *const _HNODE) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseClusterNode(hnode: *const _HNODE) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CloseClusterNode(::core::mem::transmute(hnode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CloseClusterNotifyPort(hchange: *const _HCHANGE) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseClusterNotifyPort(hchange: *const _HCHANGE) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CloseClusterNotifyPort(::core::mem::transmute(hchange)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CloseClusterResource(hresource: *const _HRESOURCE) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CloseClusterResource(hresource: *const _HRESOURCE) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(CloseClusterResource(::core::mem::transmute(hresource)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusAddClusterHealthFault(hcluster: *const _HCLUSTER, failure: *const CLUSTER_HEALTH_FAULT, param2: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusAddClusterHealthFault(hcluster: *const _HCLUSTER, failure: *const CLUSTER_HEALTH_FAULT, param2: u32) -> u32;
        }
        ::core::mem::transmute(ClusAddClusterHealthFault(::core::mem::transmute(hcluster), ::core::mem::transmute(failure), ::core::mem::transmute(param2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const ClusApplication: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606e5_2631_11d1_89f1_00a0c90d061e);
pub const ClusCryptoKeys: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6072b_2631_11d1_89f1_00a0c90d061e);
pub const ClusDisk: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60723_2631_11d1_89f1_00a0c90d061e);
pub const ClusDisks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60725_2631_11d1_89f1_00a0c90d061e);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusGetClusterHealthFaults(hcluster: *const _HCLUSTER, objects: *mut CLUSTER_HEALTH_FAULT_ARRAY, flags: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusGetClusterHealthFaults(hcluster: *const _HCLUSTER, objects: *mut CLUSTER_HEALTH_FAULT_ARRAY, flags: u32) -> u32;
        }
        ::core::mem::transmute(ClusGetClusterHealthFaults(::core::mem::transmute(hcluster), ::core::mem::transmute(objects), ::core::mem::transmute(flags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const ClusNetInterface: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606ed_2631_11d1_89f1_00a0c90d061e);
pub const ClusNetInterfaces: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606ef_2631_11d1_89f1_00a0c90d061e);
pub const ClusNetwork: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f1_2631_11d1_89f1_00a0c90d061e);
pub const ClusNetworkNetInterfaces: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f5_2631_11d1_89f1_00a0c90d061e);
pub const ClusNetworks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f3_2631_11d1_89f1_00a0c90d061e);
pub const ClusNode: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f7_2631_11d1_89f1_00a0c90d061e);
pub const ClusNodeNetInterfaces: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606fb_2631_11d1_89f1_00a0c90d061e);
pub const ClusNodes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f9_2631_11d1_89f1_00a0c90d061e);
pub const ClusPartition: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6071f_2631_11d1_89f1_00a0c90d061e);
pub const ClusPartitionEx: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x53d51d26_b51b_4a79_b2c3_5048d93a98fc);
pub const ClusPartitions: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60721_2631_11d1_89f1_00a0c90d061e);
pub const ClusProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606ff_2631_11d1_89f1_00a0c90d061e);
pub const ClusProperty: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606fd_2631_11d1_89f1_00a0c90d061e);
pub const ClusPropertyValue: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60719_2631_11d1_89f1_00a0c90d061e);
pub const ClusPropertyValueData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6071d_2631_11d1_89f1_00a0c90d061e);
pub const ClusPropertyValues: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6071b_2631_11d1_89f1_00a0c90d061e);
pub const ClusRefObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60701_2631_11d1_89f1_00a0c90d061e);
pub const ClusRegistryKeys: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60729_2631_11d1_89f1_00a0c90d061e);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusRemoveClusterHealthFault<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, id: Param1, flags: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusRemoveClusterHealthFault(hcluster: *const _HCLUSTER, id: ::windows::core::PCWSTR, flags: u32) -> u32;
        }
        ::core::mem::transmute(ClusRemoveClusterHealthFault(::core::mem::transmute(hcluster), id.into_param().abi(), ::core::mem::transmute(flags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const ClusResDependencies: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60703_2631_11d1_89f1_00a0c90d061e);
pub const ClusResDependents: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6072d_2631_11d1_89f1_00a0c90d061e);
pub const ClusResGroup: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60705_2631_11d1_89f1_00a0c90d061e);
pub const ClusResGroupPreferredOwnerNodes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606e7_2631_11d1_89f1_00a0c90d061e);
pub const ClusResGroupResources: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606e9_2631_11d1_89f1_00a0c90d061e);
pub const ClusResGroups: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60707_2631_11d1_89f1_00a0c90d061e);
pub const ClusResPossibleOwnerNodes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6070d_2631_11d1_89f1_00a0c90d061e);
pub const ClusResType: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6070f_2631_11d1_89f1_00a0c90d061e);
pub const ClusResTypePossibleOwnerNodes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60717_2631_11d1_89f1_00a0c90d061e);
pub const ClusResTypeResources: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60713_2631_11d1_89f1_00a0c90d061e);
pub const ClusResTypes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60711_2631_11d1_89f1_00a0c90d061e);
pub const ClusResource: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60709_2631_11d1_89f1_00a0c90d061e);
pub const ClusResources: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6070b_2631_11d1_89f1_00a0c90d061e);
pub const ClusScsiAddress: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60727_2631_11d1_89f1_00a0c90d061e);
pub const ClusVersion: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60715_2631_11d1_89f1_00a0c90d061e);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusWorkerCheckTerminate(lpworker: *mut CLUS_WORKER) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusWorkerCheckTerminate(lpworker: *mut CLUS_WORKER) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(ClusWorkerCheckTerminate(::core::mem::transmute(lpworker)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusWorkerCreate(lpworker: *mut CLUS_WORKER, lpstartaddress: PWORKER_START_ROUTINE, lpparameter: *mut ::core::ffi::c_void) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusWorkerCreate(lpworker: *mut CLUS_WORKER, lpstartaddress: ::windows::core::RawPtr, lpparameter: *mut ::core::ffi::c_void) -> u32;
        }
        ::core::mem::transmute(ClusWorkerCreate(::core::mem::transmute(lpworker), ::core::mem::transmute(lpstartaddress), ::core::mem::transmute(lpparameter)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusWorkerTerminate(lpworker: *const CLUS_WORKER) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusWorkerTerminate(lpworker: *const CLUS_WORKER);
        }
        ClusWorkerTerminate(::core::mem::transmute(lpworker))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusWorkerTerminateEx<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(clusworker: *mut CLUS_WORKER, timeoutinmilliseconds: u32, waitonly: Param2) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusWorkerTerminateEx(clusworker: *mut CLUS_WORKER, timeoutinmilliseconds: u32, waitonly: super::super::Foundation::BOOL) -> u32;
        }
        ::core::mem::transmute(ClusWorkerTerminateEx(::core::mem::transmute(clusworker), ::core::mem::transmute(timeoutinmilliseconds), waitonly.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusWorkersTerminate<'a, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(clusworkers: &mut [*mut CLUS_WORKER], timeoutinmilliseconds: u32, waitonly: Param3) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusWorkersTerminate(clusworkers: *mut *mut CLUS_WORKER, clusworkerscount: usize, timeoutinmilliseconds: u32, waitonly: super::super::Foundation::BOOL) -> u32;
        }
        ::core::mem::transmute(ClusWorkersTerminate(::core::mem::transmute(::windows::core::as_mut_ptr_or_null(clusworkers)), clusworkers.len() as _, ::core::mem::transmute(timeoutinmilliseconds), waitonly.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const Cluster: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606e3_2631_11d1_89f1_00a0c90d061e);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterAddGroupToAffinityRule<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, rulename: Param1, hgroup: *const _HGROUP) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterAddGroupToAffinityRule(hcluster: *const _HCLUSTER, rulename: ::windows::core::PCWSTR, hgroup: *const _HGROUP) -> u32;
        }
        ::core::mem::transmute(ClusterAddGroupToAffinityRule(::core::mem::transmute(hcluster), rulename.into_param().abi(), ::core::mem::transmute(hgroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterAddGroupToGroupSet(hgroupset: *const _HGROUPSET, hgroup: *const _HGROUP) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterAddGroupToGroupSet(hgroupset: *const _HGROUPSET, hgroup: *const _HGROUP) -> u32;
        }
        ::core::mem::transmute(ClusterAddGroupToGroupSet(::core::mem::transmute(hgroupset), ::core::mem::transmute(hgroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterAddGroupToGroupSetWithDomains(hgroupset: *const _HGROUPSET, hgroup: *const _HGROUP, faultdomain: u32, updatedomain: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterAddGroupToGroupSetWithDomains(hgroupset: *const _HGROUPSET, hgroup: *const _HGROUP, faultdomain: u32, updatedomain: u32) -> u32;
        }
        ::core::mem::transmute(ClusterAddGroupToGroupSetWithDomains(::core::mem::transmute(hgroupset), ::core::mem::transmute(hgroup), ::core::mem::transmute(faultdomain), ::core::mem::transmute(updatedomain)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterAffinityRuleControl<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, affinityrulename: Param1, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, cbinbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, cboutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterAffinityRuleControl(hcluster: *const _HCLUSTER, affinityrulename: ::windows::core::PCWSTR, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, cbinbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, cboutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterAffinityRuleControl(::core::mem::transmute(hcluster), affinityrulename.into_param().abi(), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(cbinbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(cboutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterClearBackupStateForSharedVolume<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(lpszvolumepathname: Param0) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterClearBackupStateForSharedVolume(lpszvolumepathname: ::windows::core::PCWSTR) -> u32;
        }
        ::core::mem::transmute(ClusterClearBackupStateForSharedVolume(lpszvolumepathname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterCloseEnum(henum: *const _HCLUSENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterCloseEnum(henum: *const _HCLUSENUM) -> u32;
        }
        ::core::mem::transmute(ClusterCloseEnum(::core::mem::transmute(henum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterCloseEnumEx(hclusterenum: *const _HCLUSENUMEX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterCloseEnumEx(hclusterenum: *const _HCLUSENUMEX) -> u32;
        }
        ::core::mem::transmute(ClusterCloseEnumEx(::core::mem::transmute(hclusterenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterControl(hcluster: *const _HCLUSTER, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterControl(hcluster: *const _HCLUSTER, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterControl(::core::mem::transmute(hcluster), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(ninbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(noutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterCreateAffinityRule<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, rulename: Param1, ruletype: CLUS_AFFINITY_RULE_TYPE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterCreateAffinityRule(hcluster: *const _HCLUSTER, rulename: ::windows::core::PCWSTR, ruletype: CLUS_AFFINITY_RULE_TYPE) -> u32;
        }
        ::core::mem::transmute(ClusterCreateAffinityRule(::core::mem::transmute(hcluster), rulename.into_param().abi(), ::core::mem::transmute(ruletype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterDecrypt(hcluscryptprovider: *const _HCLUSCRYPTPROVIDER, pcryptinput: *const u8, cbcryptinput: u32, ppcryptoutput: *mut *mut u8, pcbcryptoutput: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterDecrypt(hcluscryptprovider: *const _HCLUSCRYPTPROVIDER, pcryptinput: *const u8, cbcryptinput: u32, ppcryptoutput: *mut *mut u8, pcbcryptoutput: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterDecrypt(::core::mem::transmute(hcluscryptprovider), ::core::mem::transmute(pcryptinput), ::core::mem::transmute(cbcryptinput), ::core::mem::transmute(ppcryptoutput), ::core::mem::transmute(pcbcryptoutput)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterEncrypt(hcluscryptprovider: *const _HCLUSCRYPTPROVIDER, pdata: &[u8], ppdata: *mut *mut u8, pcbdata: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterEncrypt(hcluscryptprovider: *const _HCLUSCRYPTPROVIDER, pdata: *const u8, cbdata: u32, ppdata: *mut *mut u8, pcbdata: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterEncrypt(::core::mem::transmute(hcluscryptprovider), ::core::mem::transmute(::windows::core::as_ptr_or_null(pdata)), pdata.len() as _, ::core::mem::transmute(ppdata), ::core::mem::transmute(pcbdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterEnum(henum: *const _HCLUSENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterEnum(henum: *const _HCLUSENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterEnum(::core::mem::transmute(henum), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpdwtype), ::core::mem::transmute(lpszname), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterEnumEx(hclusterenum: *const _HCLUSENUMEX, dwindex: u32, pitem: *mut CLUSTER_ENUM_ITEM, cbitem: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterEnumEx(hclusterenum: *const _HCLUSENUMEX, dwindex: u32, pitem: *mut CLUSTER_ENUM_ITEM, cbitem: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterEnumEx(::core::mem::transmute(hclusterenum), ::core::mem::transmute(dwindex), ::core::mem::transmute(pitem), ::core::mem::transmute(cbitem)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGetEnumCount(henum: *const _HCLUSENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGetEnumCount(henum: *const _HCLUSENUM) -> u32;
        }
        ::core::mem::transmute(ClusterGetEnumCount(::core::mem::transmute(henum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGetEnumCountEx(hclusterenum: *const _HCLUSENUMEX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGetEnumCountEx(hclusterenum: *const _HCLUSENUMEX) -> u32;
        }
        ::core::mem::transmute(ClusterGetEnumCountEx(::core::mem::transmute(hclusterenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusterGetVolumeNameForVolumeMountPoint<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(lpszvolumemountpoint: Param0, lpszvolumename: ::windows::core::PWSTR, cchbufferlength: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGetVolumeNameForVolumeMountPoint(lpszvolumemountpoint: ::windows::core::PCWSTR, lpszvolumename: ::windows::core::PWSTR, cchbufferlength: u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(ClusterGetVolumeNameForVolumeMountPoint(lpszvolumemountpoint.into_param().abi(), ::core::mem::transmute(lpszvolumename), ::core::mem::transmute(cchbufferlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusterGetVolumePathName<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(lpszfilename: Param0, lpszvolumepathname: ::windows::core::PWSTR, cchbufferlength: u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGetVolumePathName(lpszfilename: ::windows::core::PCWSTR, lpszvolumepathname: ::windows::core::PWSTR, cchbufferlength: u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(ClusterGetVolumePathName(lpszfilename.into_param().abi(), ::core::mem::transmute(lpszvolumepathname), ::core::mem::transmute(cchbufferlength)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupCloseEnum(hgroupenum: *const _HGROUPENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupCloseEnum(hgroupenum: *const _HGROUPENUM) -> u32;
        }
        ::core::mem::transmute(ClusterGroupCloseEnum(::core::mem::transmute(hgroupenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupCloseEnumEx(hgroupenumex: *const _HGROUPENUMEX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupCloseEnumEx(hgroupenumex: *const _HGROUPENUMEX) -> u32;
        }
        ::core::mem::transmute(ClusterGroupCloseEnumEx(::core::mem::transmute(hgroupenumex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupControl(hgroup: *const _HGROUP, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupControl(hgroup: *const _HGROUP, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterGroupControl(::core::mem::transmute(hgroup), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(ninbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(noutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupEnum(hgroupenum: *const _HGROUPENUM, dwindex: u32, lpdwtype: *mut u32, lpszresourcename: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupEnum(hgroupenum: *const _HGROUPENUM, dwindex: u32, lpdwtype: *mut u32, lpszresourcename: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterGroupEnum(::core::mem::transmute(hgroupenum), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpdwtype), ::core::mem::transmute(lpszresourcename), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupEnumEx(hgroupenumex: *const _HGROUPENUMEX, dwindex: u32, pitem: *mut CLUSTER_GROUP_ENUM_ITEM, cbitem: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupEnumEx(hgroupenumex: *const _HGROUPENUMEX, dwindex: u32, pitem: *mut CLUSTER_GROUP_ENUM_ITEM, cbitem: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterGroupEnumEx(::core::mem::transmute(hgroupenumex), ::core::mem::transmute(dwindex), ::core::mem::transmute(pitem), ::core::mem::transmute(cbitem)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupGetEnumCount(hgroupenum: *const _HGROUPENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupGetEnumCount(hgroupenum: *const _HGROUPENUM) -> u32;
        }
        ::core::mem::transmute(ClusterGroupGetEnumCount(::core::mem::transmute(hgroupenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupGetEnumCountEx(hgroupenumex: *const _HGROUPENUMEX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupGetEnumCountEx(hgroupenumex: *const _HGROUPENUMEX) -> u32;
        }
        ::core::mem::transmute(ClusterGroupGetEnumCountEx(::core::mem::transmute(hgroupenumex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupOpenEnum(hgroup: *const _HGROUP, dwtype: u32) -> *mut _HGROUPENUM {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupOpenEnum(hgroup: *const _HGROUP, dwtype: u32) -> *mut _HGROUPENUM;
        }
        ::core::mem::transmute(ClusterGroupOpenEnum(::core::mem::transmute(hgroup), ::core::mem::transmute(dwtype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupOpenEnumEx<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszproperties: Param1, cbproperties: u32, lpszroproperties: Param3, cbroproperties: u32, dwflags: u32) -> *mut _HGROUPENUMEX {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupOpenEnumEx(hcluster: *const _HCLUSTER, lpszproperties: ::windows::core::PCWSTR, cbproperties: u32, lpszroproperties: ::windows::core::PCWSTR, cbroproperties: u32, dwflags: u32) -> *mut _HGROUPENUMEX;
        }
        ::core::mem::transmute(ClusterGroupOpenEnumEx(::core::mem::transmute(hcluster), lpszproperties.into_param().abi(), ::core::mem::transmute(cbproperties), lpszroproperties.into_param().abi(), ::core::mem::transmute(cbroproperties), ::core::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupSetCloseEnum(hgroupsetenum: *mut _HGROUPSETENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupSetCloseEnum(hgroupsetenum: *mut _HGROUPSETENUM) -> u32;
        }
        ::core::mem::transmute(ClusterGroupSetCloseEnum(::core::mem::transmute(hgroupsetenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupSetControl(hgroupset: *const _HGROUPSET, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, cbinbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, cboutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupSetControl(hgroupset: *const _HGROUPSET, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, cbinbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, cboutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterGroupSetControl(::core::mem::transmute(hgroupset), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(cbinbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(cboutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupSetEnum(hgroupsetenum: *const _HGROUPSETENUM, dwindex: u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupSetEnum(hgroupsetenum: *const _HGROUPSETENUM, dwindex: u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterGroupSetEnum(::core::mem::transmute(hgroupsetenum), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpszname), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupSetGetEnumCount(hgroupsetenum: *mut _HGROUPSETENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupSetGetEnumCount(hgroupsetenum: *mut _HGROUPSETENUM) -> u32;
        }
        ::core::mem::transmute(ClusterGroupSetGetEnumCount(::core::mem::transmute(hgroupsetenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterGroupSetOpenEnum(hcluster: *mut _HCLUSTER) -> *mut _HGROUPSETENUM {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterGroupSetOpenEnum(hcluster: *mut _HCLUSTER) -> *mut _HGROUPSETENUM;
        }
        ::core::mem::transmute(ClusterGroupSetOpenEnum(::core::mem::transmute(hcluster)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusterIsPathOnSharedVolume<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(lpszpathname: Param0) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterIsPathOnSharedVolume(lpszpathname: ::windows::core::PCWSTR) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(ClusterIsPathOnSharedVolume(lpszpathname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const ClusterNames: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606eb_2631_11d1_89f1_00a0c90d061e);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNetInterfaceCloseEnum(hnetinterfaceenum: *const _HNETINTERFACEENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNetInterfaceCloseEnum(hnetinterfaceenum: *const _HNETINTERFACEENUM) -> u32;
        }
        ::core::mem::transmute(ClusterNetInterfaceCloseEnum(::core::mem::transmute(hnetinterfaceenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNetInterfaceControl(hnetinterface: *const _HNETINTERFACE, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNetInterfaceControl(hnetinterface: *const _HNETINTERFACE, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterNetInterfaceControl(::core::mem::transmute(hnetinterface), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(ninbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(noutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNetInterfaceEnum(hnetinterfaceenum: *const _HNETINTERFACEENUM, dwindex: u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNetInterfaceEnum(hnetinterfaceenum: *const _HNETINTERFACEENUM, dwindex: u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterNetInterfaceEnum(::core::mem::transmute(hnetinterfaceenum), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpszname), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNetInterfaceOpenEnum<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpsznodename: Param1, lpsznetworkname: Param2) -> *mut _HNETINTERFACEENUM {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNetInterfaceOpenEnum(hcluster: *const _HCLUSTER, lpsznodename: ::windows::core::PCWSTR, lpsznetworkname: ::windows::core::PCWSTR) -> *mut _HNETINTERFACEENUM;
        }
        ::core::mem::transmute(ClusterNetInterfaceOpenEnum(::core::mem::transmute(hcluster), lpsznodename.into_param().abi(), lpsznetworkname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNetworkCloseEnum(hnetworkenum: *const _HNETWORKENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNetworkCloseEnum(hnetworkenum: *const _HNETWORKENUM) -> u32;
        }
        ::core::mem::transmute(ClusterNetworkCloseEnum(::core::mem::transmute(hnetworkenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNetworkControl(hnetwork: *const _HNETWORK, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNetworkControl(hnetwork: *const _HNETWORK, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterNetworkControl(::core::mem::transmute(hnetwork), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(ninbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(noutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNetworkEnum(hnetworkenum: *const _HNETWORKENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNetworkEnum(hnetworkenum: *const _HNETWORKENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterNetworkEnum(::core::mem::transmute(hnetworkenum), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpdwtype), ::core::mem::transmute(lpszname), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNetworkGetEnumCount(hnetworkenum: *const _HNETWORKENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNetworkGetEnumCount(hnetworkenum: *const _HNETWORKENUM) -> u32;
        }
        ::core::mem::transmute(ClusterNetworkGetEnumCount(::core::mem::transmute(hnetworkenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNetworkOpenEnum(hnetwork: *const _HNETWORK, dwtype: u32) -> *mut _HNETWORKENUM {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNetworkOpenEnum(hnetwork: *const _HNETWORK, dwtype: u32) -> *mut _HNETWORKENUM;
        }
        ::core::mem::transmute(ClusterNetworkOpenEnum(::core::mem::transmute(hnetwork), ::core::mem::transmute(dwtype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeCloseEnum(hnodeenum: *const _HNODEENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeCloseEnum(hnodeenum: *const _HNODEENUM) -> u32;
        }
        ::core::mem::transmute(ClusterNodeCloseEnum(::core::mem::transmute(hnodeenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeCloseEnumEx(hnodeenum: *const _HNODEENUMEX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeCloseEnumEx(hnodeenum: *const _HNODEENUMEX) -> u32;
        }
        ::core::mem::transmute(ClusterNodeCloseEnumEx(::core::mem::transmute(hnodeenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeControl(hnode: *const _HNODE, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeControl(hnode: *const _HNODE, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterNodeControl(::core::mem::transmute(hnode), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(ninbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(noutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeEnum(hnodeenum: *const _HNODEENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeEnum(hnodeenum: *const _HNODEENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterNodeEnum(::core::mem::transmute(hnodeenum), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpdwtype), ::core::mem::transmute(lpszname), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeEnumEx(hnodeenum: *const _HNODEENUMEX, dwindex: u32, pitem: *mut CLUSTER_ENUM_ITEM, cbitem: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeEnumEx(hnodeenum: *const _HNODEENUMEX, dwindex: u32, pitem: *mut CLUSTER_ENUM_ITEM, cbitem: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterNodeEnumEx(::core::mem::transmute(hnodeenum), ::core::mem::transmute(dwindex), ::core::mem::transmute(pitem), ::core::mem::transmute(cbitem)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeGetEnumCount(hnodeenum: *const _HNODEENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeGetEnumCount(hnodeenum: *const _HNODEENUM) -> u32;
        }
        ::core::mem::transmute(ClusterNodeGetEnumCount(::core::mem::transmute(hnodeenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeGetEnumCountEx(hnodeenum: *const _HNODEENUMEX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeGetEnumCountEx(hnodeenum: *const _HNODEENUMEX) -> u32;
        }
        ::core::mem::transmute(ClusterNodeGetEnumCountEx(::core::mem::transmute(hnodeenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeOpenEnum(hnode: *const _HNODE, dwtype: u32) -> *mut _HNODEENUM {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeOpenEnum(hnode: *const _HNODE, dwtype: u32) -> *mut _HNODEENUM;
        }
        ::core::mem::transmute(ClusterNodeOpenEnum(::core::mem::transmute(hnode), ::core::mem::transmute(dwtype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeOpenEnumEx(hnode: *const _HNODE, dwtype: u32, poptions: *const ::core::ffi::c_void) -> *mut _HNODEENUMEX {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeOpenEnumEx(hnode: *const _HNODE, dwtype: u32, poptions: *const ::core::ffi::c_void) -> *mut _HNODEENUMEX;
        }
        ::core::mem::transmute(ClusterNodeOpenEnumEx(::core::mem::transmute(hnode), ::core::mem::transmute(dwtype), ::core::mem::transmute(poptions)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterNodeReplacement<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpsznodenamecurrent: Param1, lpsznodenamenew: Param2) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterNodeReplacement(hcluster: *const _HCLUSTER, lpsznodenamecurrent: ::windows::core::PCWSTR, lpsznodenamenew: ::windows::core::PCWSTR) -> u32;
        }
        ::core::mem::transmute(ClusterNodeReplacement(::core::mem::transmute(hcluster), lpsznodenamecurrent.into_param().abi(), lpsznodenamenew.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterOpenEnum(hcluster: *const _HCLUSTER, dwtype: u32) -> *mut _HCLUSENUM {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterOpenEnum(hcluster: *const _HCLUSTER, dwtype: u32) -> *mut _HCLUSENUM;
        }
        ::core::mem::transmute(ClusterOpenEnum(::core::mem::transmute(hcluster), ::core::mem::transmute(dwtype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterOpenEnumEx(hcluster: *const _HCLUSTER, dwtype: u32, poptions: *const ::core::ffi::c_void) -> *mut _HCLUSENUMEX {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterOpenEnumEx(hcluster: *const _HCLUSTER, dwtype: u32, poptions: *const ::core::ffi::c_void) -> *mut _HCLUSENUMEX;
        }
        ::core::mem::transmute(ClusterOpenEnumEx(::core::mem::transmute(hcluster), ::core::mem::transmute(dwtype), ::core::mem::transmute(poptions)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterPrepareSharedVolumeForBackup<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(lpszfilename: Param0, lpszvolumepathname: ::windows::core::PWSTR, lpcchvolumepathname: *mut u32, lpszvolumename: ::windows::core::PWSTR, lpcchvolumename: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterPrepareSharedVolumeForBackup(lpszfilename: ::windows::core::PCWSTR, lpszvolumepathname: ::windows::core::PWSTR, lpcchvolumepathname: *mut u32, lpszvolumename: ::windows::core::PWSTR, lpcchvolumename: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterPrepareSharedVolumeForBackup(lpszfilename.into_param().abi(), ::core::mem::transmute(lpszvolumepathname), ::core::mem::transmute(lpcchvolumepathname), ::core::mem::transmute(lpszvolumename), ::core::mem::transmute(lpcchvolumename)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegBatchAddCommand<'a, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hregbatch: *const _HREGBATCH, dwcommand: CLUSTER_REG_COMMAND, wzname: Param2, dwoptions: u32, lpdata: *const ::core::ffi::c_void, cbdata: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegBatchAddCommand(hregbatch: *const _HREGBATCH, dwcommand: CLUSTER_REG_COMMAND, wzname: ::windows::core::PCWSTR, dwoptions: u32, lpdata: *const ::core::ffi::c_void, cbdata: u32) -> i32;
        }
        ::core::mem::transmute(ClusterRegBatchAddCommand(::core::mem::transmute(hregbatch), ::core::mem::transmute(dwcommand), wzname.into_param().abi(), ::core::mem::transmute(dwoptions), ::core::mem::transmute(lpdata), ::core::mem::transmute(cbdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegBatchCloseNotification(hbatchnotification: *const _HREGBATCHNOTIFICATION) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegBatchCloseNotification(hbatchnotification: *const _HREGBATCHNOTIFICATION) -> i32;
        }
        ::core::mem::transmute(ClusterRegBatchCloseNotification(::core::mem::transmute(hbatchnotification)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegBatchReadCommand(hbatchnotification: *const _HREGBATCHNOTIFICATION, pbatchcommand: *mut CLUSTER_BATCH_COMMAND) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegBatchReadCommand(hbatchnotification: *const _HREGBATCHNOTIFICATION, pbatchcommand: *mut CLUSTER_BATCH_COMMAND) -> i32;
        }
        ::core::mem::transmute(ClusterRegBatchReadCommand(::core::mem::transmute(hbatchnotification), ::core::mem::transmute(pbatchcommand)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusterRegCloseBatch<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(hregbatch: *const _HREGBATCH, bcommit: Param1, failedcommandnumber: *mut i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCloseBatch(hregbatch: *const _HREGBATCH, bcommit: super::super::Foundation::BOOL, failedcommandnumber: *mut i32) -> i32;
        }
        ::core::mem::transmute(ClusterRegCloseBatch(::core::mem::transmute(hregbatch), bcommit.into_param().abi(), ::core::mem::transmute(failedcommandnumber)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegCloseBatchEx(hregbatch: *const _HREGBATCH, flags: u32, failedcommandnumber: *mut i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCloseBatchEx(hregbatch: *const _HREGBATCH, flags: u32, failedcommandnumber: *mut i32) -> i32;
        }
        ::core::mem::transmute(ClusterRegCloseBatchEx(::core::mem::transmute(hregbatch), ::core::mem::transmute(flags), ::core::mem::transmute(failedcommandnumber)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegCloseBatchNotifyPort(hbatchnotifyport: *const _HREGBATCHPORT) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCloseBatchNotifyPort(hbatchnotifyport: *const _HREGBATCHPORT) -> i32;
        }
        ::core::mem::transmute(ClusterRegCloseBatchNotifyPort(::core::mem::transmute(hbatchnotifyport)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegCloseKey<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>>(hkey: Param0) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCloseKey(hkey: super::super::System::Registry::HKEY) -> i32;
        }
        ::core::mem::transmute(ClusterRegCloseKey(hkey.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegCloseReadBatch(hregreadbatch: *const _HREGREADBATCH, phregreadbatchreply: *mut *mut _HREGREADBATCHREPLY) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCloseReadBatch(hregreadbatch: *const _HREGREADBATCH, phregreadbatchreply: *mut *mut _HREGREADBATCHREPLY) -> i32;
        }
        ::core::mem::transmute(ClusterRegCloseReadBatch(::core::mem::transmute(hregreadbatch), ::core::mem::transmute(phregreadbatchreply)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegCloseReadBatchEx(hregreadbatch: *const _HREGREADBATCH, flags: u32, phregreadbatchreply: *mut *mut _HREGREADBATCHREPLY) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCloseReadBatchEx(hregreadbatch: *const _HREGREADBATCH, flags: u32, phregreadbatchreply: *mut *mut _HREGREADBATCHREPLY) -> i32;
        }
        ::core::mem::transmute(ClusterRegCloseReadBatchEx(::core::mem::transmute(hregreadbatch), ::core::mem::transmute(flags), ::core::mem::transmute(phregreadbatchreply)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegCloseReadBatchReply(hregreadbatchreply: *const _HREGREADBATCHREPLY) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCloseReadBatchReply(hregreadbatchreply: *const _HREGREADBATCHREPLY) -> i32;
        }
        ::core::mem::transmute(ClusterRegCloseReadBatchReply(::core::mem::transmute(hregreadbatchreply)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegCreateBatch<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>>(hkey: Param0, phregbatch: *mut *mut _HREGBATCH) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCreateBatch(hkey: super::super::System::Registry::HKEY, phregbatch: *mut *mut _HREGBATCH) -> i32;
        }
        ::core::mem::transmute(ClusterRegCreateBatch(hkey.into_param().abi(), ::core::mem::transmute(phregbatch)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegCreateBatchNotifyPort<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>>(hkey: Param0, phbatchnotifyport: *mut *mut _HREGBATCHPORT) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCreateBatchNotifyPort(hkey: super::super::System::Registry::HKEY, phbatchnotifyport: *mut *mut _HREGBATCHPORT) -> i32;
        }
        ::core::mem::transmute(ClusterRegCreateBatchNotifyPort(hkey.into_param().abi(), ::core::mem::transmute(phbatchnotifyport)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_Security\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn ClusterRegCreateKey<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hkey: Param0, lpszsubkey: Param1, dwoptions: u32, samdesired: u32, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES, phkresult: *mut super::super::System::Registry::HKEY, lpdwdisposition: *mut u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCreateKey(hkey: super::super::System::Registry::HKEY, lpszsubkey: ::windows::core::PCWSTR, dwoptions: u32, samdesired: u32, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES, phkresult: *mut super::super::System::Registry::HKEY, lpdwdisposition: *mut u32) -> i32;
        }
        ::core::mem::transmute(ClusterRegCreateKey(hkey.into_param().abi(), lpszsubkey.into_param().abi(), ::core::mem::transmute(dwoptions), ::core::mem::transmute(samdesired), ::core::mem::transmute(lpsecurityattributes), ::core::mem::transmute(phkresult), ::core::mem::transmute(lpdwdisposition)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegCreateReadBatch<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>>(hkey: Param0, phregreadbatch: *mut *mut _HREGREADBATCH) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegCreateReadBatch(hkey: super::super::System::Registry::HKEY, phregreadbatch: *mut *mut _HREGREADBATCH) -> i32;
        }
        ::core::mem::transmute(ClusterRegCreateReadBatch(hkey.into_param().abi(), ::core::mem::transmute(phregreadbatch)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegDeleteKey<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hkey: Param0, lpszsubkey: Param1) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegDeleteKey(hkey: super::super::System::Registry::HKEY, lpszsubkey: ::windows::core::PCWSTR) -> i32;
        }
        ::core::mem::transmute(ClusterRegDeleteKey(hkey.into_param().abi(), lpszsubkey.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegDeleteValue<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hkey: Param0, lpszvaluename: Param1) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegDeleteValue(hkey: super::super::System::Registry::HKEY, lpszvaluename: ::windows::core::PCWSTR) -> u32;
        }
        ::core::mem::transmute(ClusterRegDeleteValue(hkey.into_param().abi(), lpszvaluename.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn ClusterRegEnumKey<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>>(hkey: Param0, dwindex: u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32, lpftlastwritetime: *mut super::super::Foundation::FILETIME) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegEnumKey(hkey: super::super::System::Registry::HKEY, dwindex: u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32, lpftlastwritetime: *mut super::super::Foundation::FILETIME) -> i32;
        }
        ::core::mem::transmute(ClusterRegEnumKey(hkey.into_param().abi(), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpszname), ::core::mem::transmute(lpcchname), ::core::mem::transmute(lpftlastwritetime)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegEnumValue<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>>(hkey: Param0, dwindex: u32, lpszvaluename: ::windows::core::PWSTR, lpcchvaluename: *mut u32, lpdwtype: *mut u32, lpdata: *mut u8, lpcbdata: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegEnumValue(hkey: super::super::System::Registry::HKEY, dwindex: u32, lpszvaluename: ::windows::core::PWSTR, lpcchvaluename: *mut u32, lpdwtype: *mut u32, lpdata: *mut u8, lpcbdata: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterRegEnumValue(hkey.into_param().abi(), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpszvaluename), ::core::mem::transmute(lpcchvaluename), ::core::mem::transmute(lpdwtype), ::core::mem::transmute(lpdata), ::core::mem::transmute(lpcbdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegGetBatchNotification(hbatchnotify: *const _HREGBATCHPORT, phbatchnotification: *mut *mut _HREGBATCHNOTIFICATION) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegGetBatchNotification(hbatchnotify: *const _HREGBATCHPORT, phbatchnotification: *mut *mut _HREGBATCHNOTIFICATION) -> i32;
        }
        ::core::mem::transmute(ClusterRegGetBatchNotification(::core::mem::transmute(hbatchnotify), ::core::mem::transmute(phbatchnotification)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_Security\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn ClusterRegGetKeySecurity<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>>(hkey: Param0, requestedinformation: u32, psecuritydescriptor: *mut super::super::Security::SECURITY_DESCRIPTOR, lpcbsecuritydescriptor: *mut u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegGetKeySecurity(hkey: super::super::System::Registry::HKEY, requestedinformation: u32, psecuritydescriptor: *mut super::super::Security::SECURITY_DESCRIPTOR, lpcbsecuritydescriptor: *mut u32) -> i32;
        }
        ::core::mem::transmute(ClusterRegGetKeySecurity(hkey.into_param().abi(), ::core::mem::transmute(requestedinformation), ::core::mem::transmute(psecuritydescriptor), ::core::mem::transmute(lpcbsecuritydescriptor)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegOpenKey<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hkey: Param0, lpszsubkey: Param1, samdesired: u32, phkresult: *mut super::super::System::Registry::HKEY) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegOpenKey(hkey: super::super::System::Registry::HKEY, lpszsubkey: ::windows::core::PCWSTR, samdesired: u32, phkresult: *mut super::super::System::Registry::HKEY) -> i32;
        }
        ::core::mem::transmute(ClusterRegOpenKey(hkey.into_param().abi(), lpszsubkey.into_param().abi(), ::core::mem::transmute(samdesired), ::core::mem::transmute(phkresult)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn ClusterRegQueryInfoKey<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>>(hkey: Param0, lpcsubkeys: *const u32, lpcchmaxsubkeylen: *const u32, lpcvalues: *const u32, lpcchmaxvaluenamelen: *const u32, lpcbmaxvaluelen: *const u32, lpcbsecuritydescriptor: *const u32, lpftlastwritetime: *const super::super::Foundation::FILETIME) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegQueryInfoKey(hkey: super::super::System::Registry::HKEY, lpcsubkeys: *const u32, lpcchmaxsubkeylen: *const u32, lpcvalues: *const u32, lpcchmaxvaluenamelen: *const u32, lpcbmaxvaluelen: *const u32, lpcbsecuritydescriptor: *const u32, lpftlastwritetime: *const super::super::Foundation::FILETIME) -> i32;
        }
        ::core::mem::transmute(ClusterRegQueryInfoKey(hkey.into_param().abi(), ::core::mem::transmute(lpcsubkeys), ::core::mem::transmute(lpcchmaxsubkeylen), ::core::mem::transmute(lpcvalues), ::core::mem::transmute(lpcchmaxvaluenamelen), ::core::mem::transmute(lpcbmaxvaluelen), ::core::mem::transmute(lpcbsecuritydescriptor), ::core::mem::transmute(lpftlastwritetime)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegQueryValue<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hkey: Param0, lpszvaluename: Param1, lpdwvaluetype: *mut u32, lpdata: *mut u8, lpcbdata: *mut u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegQueryValue(hkey: super::super::System::Registry::HKEY, lpszvaluename: ::windows::core::PCWSTR, lpdwvaluetype: *mut u32, lpdata: *mut u8, lpcbdata: *mut u32) -> i32;
        }
        ::core::mem::transmute(ClusterRegQueryValue(hkey.into_param().abi(), lpszvaluename.into_param().abi(), ::core::mem::transmute(lpdwvaluetype), ::core::mem::transmute(lpdata), ::core::mem::transmute(lpcbdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegReadBatchAddCommand<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hregreadbatch: *const _HREGREADBATCH, wzsubkeyname: Param1, wzvaluename: Param2) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegReadBatchAddCommand(hregreadbatch: *const _HREGREADBATCH, wzsubkeyname: ::windows::core::PCWSTR, wzvaluename: ::windows::core::PCWSTR) -> i32;
        }
        ::core::mem::transmute(ClusterRegReadBatchAddCommand(::core::mem::transmute(hregreadbatch), wzsubkeyname.into_param().abi(), wzvaluename.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegReadBatchReplyNextCommand(hregreadbatchreply: *const _HREGREADBATCHREPLY, pbatchcommand: *mut CLUSTER_READ_BATCH_COMMAND) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegReadBatchReplyNextCommand(hregreadbatchreply: *const _HREGREADBATCHREPLY, pbatchcommand: *mut CLUSTER_READ_BATCH_COMMAND) -> i32;
        }
        ::core::mem::transmute(ClusterRegReadBatchReplyNextCommand(::core::mem::transmute(hregreadbatchreply), ::core::mem::transmute(pbatchcommand)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_Security\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn ClusterRegSetKeySecurity<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>>(hkey: Param0, securityinformation: u32, psecuritydescriptor: *const super::super::Security::SECURITY_DESCRIPTOR) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegSetKeySecurity(hkey: super::super::System::Registry::HKEY, securityinformation: u32, psecuritydescriptor: *const super::super::Security::SECURITY_DESCRIPTOR) -> i32;
        }
        ::core::mem::transmute(ClusterRegSetKeySecurity(hkey.into_param().abi(), ::core::mem::transmute(securityinformation), ::core::mem::transmute(psecuritydescriptor)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ClusterRegSetValue<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hkey: Param0, lpszvaluename: Param1, dwtype: u32, lpdata: *const u8, cbdata: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegSetValue(hkey: super::super::System::Registry::HKEY, lpszvaluename: ::windows::core::PCWSTR, dwtype: u32, lpdata: *const u8, cbdata: u32) -> u32;
        }
        ::core::mem::transmute(ClusterRegSetValue(hkey.into_param().abi(), lpszvaluename.into_param().abi(), ::core::mem::transmute(dwtype), ::core::mem::transmute(lpdata), ::core::mem::transmute(cbdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRegSyncDatabase(hcluster: *const _HCLUSTER, flags: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRegSyncDatabase(hcluster: *const _HCLUSTER, flags: u32) -> i32;
        }
        ::core::mem::transmute(ClusterRegSyncDatabase(::core::mem::transmute(hcluster), ::core::mem::transmute(flags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRemoveAffinityRule<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, rulename: Param1) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRemoveAffinityRule(hcluster: *const _HCLUSTER, rulename: ::windows::core::PCWSTR) -> u32;
        }
        ::core::mem::transmute(ClusterRemoveAffinityRule(::core::mem::transmute(hcluster), rulename.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRemoveGroupFromAffinityRule<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, rulename: Param1, hgroup: *const _HGROUP) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRemoveGroupFromAffinityRule(hcluster: *const _HCLUSTER, rulename: ::windows::core::PCWSTR, hgroup: *const _HGROUP) -> u32;
        }
        ::core::mem::transmute(ClusterRemoveGroupFromAffinityRule(::core::mem::transmute(hcluster), rulename.into_param().abi(), ::core::mem::transmute(hgroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterRemoveGroupFromGroupSet(hgroup: *const _HGROUP) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterRemoveGroupFromGroupSet(hgroup: *const _HGROUP) -> u32;
        }
        ::core::mem::transmute(ClusterRemoveGroupFromGroupSet(::core::mem::transmute(hgroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceCloseEnum(hresenum: *const _HRESENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceCloseEnum(hresenum: *const _HRESENUM) -> u32;
        }
        ::core::mem::transmute(ClusterResourceCloseEnum(::core::mem::transmute(hresenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceCloseEnumEx(hresourceenumex: *const _HRESENUMEX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceCloseEnumEx(hresourceenumex: *const _HRESENUMEX) -> u32;
        }
        ::core::mem::transmute(ClusterResourceCloseEnumEx(::core::mem::transmute(hresourceenumex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceControl(hresource: *const _HRESOURCE, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, cbinbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, cboutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceControl(hresource: *const _HRESOURCE, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, cbinbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, cboutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterResourceControl(::core::mem::transmute(hresource), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(cbinbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(cboutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceControlAsUser(hresource: *const _HRESOURCE, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, cbinbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, cboutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceControlAsUser(hresource: *const _HRESOURCE, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, cbinbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, cboutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterResourceControlAsUser(::core::mem::transmute(hresource), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(cbinbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(cboutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceEnum(hresenum: *const _HRESENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceEnum(hresenum: *const _HRESENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterResourceEnum(::core::mem::transmute(hresenum), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpdwtype), ::core::mem::transmute(lpszname), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceEnumEx(hresourceenumex: *const _HRESENUMEX, dwindex: u32, pitem: *mut CLUSTER_RESOURCE_ENUM_ITEM, cbitem: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceEnumEx(hresourceenumex: *const _HRESENUMEX, dwindex: u32, pitem: *mut CLUSTER_RESOURCE_ENUM_ITEM, cbitem: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterResourceEnumEx(::core::mem::transmute(hresourceenumex), ::core::mem::transmute(dwindex), ::core::mem::transmute(pitem), ::core::mem::transmute(cbitem)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceGetEnumCount(hresenum: *const _HRESENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceGetEnumCount(hresenum: *const _HRESENUM) -> u32;
        }
        ::core::mem::transmute(ClusterResourceGetEnumCount(::core::mem::transmute(hresenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceGetEnumCountEx(hresourceenumex: *const _HRESENUMEX) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceGetEnumCountEx(hresourceenumex: *const _HRESENUMEX) -> u32;
        }
        ::core::mem::transmute(ClusterResourceGetEnumCountEx(::core::mem::transmute(hresourceenumex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceOpenEnum(hresource: *const _HRESOURCE, dwtype: u32) -> *mut _HRESENUM {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceOpenEnum(hresource: *const _HRESOURCE, dwtype: u32) -> *mut _HRESENUM;
        }
        ::core::mem::transmute(ClusterResourceOpenEnum(::core::mem::transmute(hresource), ::core::mem::transmute(dwtype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceOpenEnumEx<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszproperties: Param1, cbproperties: u32, lpszroproperties: Param3, cbroproperties: u32, dwflags: u32) -> *mut _HRESENUMEX {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceOpenEnumEx(hcluster: *const _HCLUSTER, lpszproperties: ::windows::core::PCWSTR, cbproperties: u32, lpszroproperties: ::windows::core::PCWSTR, cbroproperties: u32, dwflags: u32) -> *mut _HRESENUMEX;
        }
        ::core::mem::transmute(ClusterResourceOpenEnumEx(::core::mem::transmute(hcluster), lpszproperties.into_param().abi(), ::core::mem::transmute(cbproperties), lpszroproperties.into_param().abi(), ::core::mem::transmute(cbroproperties), ::core::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceTypeCloseEnum(hrestypeenum: *const _HRESTYPEENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceTypeCloseEnum(hrestypeenum: *const _HRESTYPEENUM) -> u32;
        }
        ::core::mem::transmute(ClusterResourceTypeCloseEnum(::core::mem::transmute(hrestypeenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceTypeControl<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszresourcetypename: Param1, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceTypeControl(hcluster: *const _HCLUSTER, lpszresourcetypename: ::windows::core::PCWSTR, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterResourceTypeControl(::core::mem::transmute(hcluster), lpszresourcetypename.into_param().abi(), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(ninbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(noutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceTypeControlAsUser<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszresourcetypename: Param1, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceTypeControlAsUser(hcluster: *const _HCLUSTER, lpszresourcetypename: ::windows::core::PCWSTR, hhostnode: *const _HNODE, dwcontrolcode: u32, lpinbuffer: *const ::core::ffi::c_void, ninbuffersize: u32, lpoutbuffer: *mut ::core::ffi::c_void, noutbuffersize: u32, lpbytesreturned: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterResourceTypeControlAsUser(::core::mem::transmute(hcluster), lpszresourcetypename.into_param().abi(), ::core::mem::transmute(hhostnode), ::core::mem::transmute(dwcontrolcode), ::core::mem::transmute(lpinbuffer), ::core::mem::transmute(ninbuffersize), ::core::mem::transmute(lpoutbuffer), ::core::mem::transmute(noutbuffersize), ::core::mem::transmute(lpbytesreturned)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceTypeEnum(hrestypeenum: *const _HRESTYPEENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceTypeEnum(hrestypeenum: *const _HRESTYPEENUM, dwindex: u32, lpdwtype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(ClusterResourceTypeEnum(::core::mem::transmute(hrestypeenum), ::core::mem::transmute(dwindex), ::core::mem::transmute(lpdwtype), ::core::mem::transmute(lpszname), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceTypeGetEnumCount(hrestypeenum: *const _HRESTYPEENUM) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceTypeGetEnumCount(hrestypeenum: *const _HRESTYPEENUM) -> u32;
        }
        ::core::mem::transmute(ClusterResourceTypeGetEnumCount(::core::mem::transmute(hrestypeenum)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterResourceTypeOpenEnum<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszresourcetypename: Param1, dwtype: u32) -> *mut _HRESTYPEENUM {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterResourceTypeOpenEnum(hcluster: *const _HCLUSTER, lpszresourcetypename: ::windows::core::PCWSTR, dwtype: u32) -> *mut _HRESTYPEENUM;
        }
        ::core::mem::transmute(ClusterResourceTypeOpenEnum(::core::mem::transmute(hcluster), lpszresourcetypename.into_param().abi(), ::core::mem::transmute(dwtype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterSetAccountAccess<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, szaccountsid: Param1, dwaccess: u32, dwcontroltype: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterSetAccountAccess(hcluster: *const _HCLUSTER, szaccountsid: ::windows::core::PCWSTR, dwaccess: u32, dwcontroltype: u32) -> u32;
        }
        ::core::mem::transmute(ClusterSetAccountAccess(::core::mem::transmute(hcluster), szaccountsid.into_param().abi(), ::core::mem::transmute(dwaccess), ::core::mem::transmute(dwcontroltype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn ClusterSharedVolumeSetSnapshotState<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::GUID>, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(guidsnapshotset: Param0, lpszvolumename: Param1, state: CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterSharedVolumeSetSnapshotState(guidsnapshotset: ::windows::core::GUID, lpszvolumename: ::windows::core::PCWSTR, state: CLUSTER_SHARED_VOLUME_SNAPSHOT_STATE) -> u32;
        }
        ::core::mem::transmute(ClusterSharedVolumeSetSnapshotState(guidsnapshotset.into_param().abi(), lpszvolumename.into_param().abi(), ::core::mem::transmute(state)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ClusterUpgradeFunctionalLevel<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(hcluster: *const _HCLUSTER, perform: Param1, pfnprogresscallback: PCLUSTER_UPGRADE_PROGRESS_CALLBACK, pvcallbackarg: *const ::core::ffi::c_void) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ClusterUpgradeFunctionalLevel(hcluster: *const _HCLUSTER, perform: super::super::Foundation::BOOL, pfnprogresscallback: ::windows::core::RawPtr, pvcallbackarg: *const ::core::ffi::c_void) -> u32;
        }
        ::core::mem::transmute(ClusterUpgradeFunctionalLevel(::core::mem::transmute(hcluster), perform.into_param().abi(), ::core::mem::transmute(pfnprogresscallback), ::core::mem::transmute(pvcallbackarg)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CreateCluster(pconfig: *const CREATE_CLUSTER_CONFIG, pfnprogresscallback: PCLUSTER_SETUP_PROGRESS_CALLBACK, pvcallbackarg: *const ::core::ffi::c_void) -> *mut _HCLUSTER {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateCluster(pconfig: *const CREATE_CLUSTER_CONFIG, pfnprogresscallback: ::windows::core::RawPtr, pvcallbackarg: *const ::core::ffi::c_void) -> *mut _HCLUSTER;
        }
        ::core::mem::transmute(CreateCluster(::core::mem::transmute(pconfig), ::core::mem::transmute(pfnprogresscallback), ::core::mem::transmute(pvcallbackarg)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CreateClusterAvailabilitySet<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpavailabilitysetname: Param1, pavailabilitysetconfig: *const CLUSTER_AVAILABILITY_SET_CONFIG) -> *mut _HGROUPSET {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateClusterAvailabilitySet(hcluster: *const _HCLUSTER, lpavailabilitysetname: ::windows::core::PCWSTR, pavailabilitysetconfig: *const CLUSTER_AVAILABILITY_SET_CONFIG) -> *mut _HGROUPSET;
        }
        ::core::mem::transmute(CreateClusterAvailabilitySet(::core::mem::transmute(hcluster), lpavailabilitysetname.into_param().abi(), ::core::mem::transmute(pavailabilitysetconfig)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn CreateClusterGroup<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszgroupname: Param1) -> *mut _HGROUP {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateClusterGroup(hcluster: *const _HCLUSTER, lpszgroupname: ::windows::core::PCWSTR) -> *mut _HGROUP;
        }
        ::core::mem::transmute(CreateClusterGroup(::core::mem::transmute(hcluster), lpszgroupname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn CreateClusterGroupEx<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszgroupname: Param1, pgroupinfo: *const CLUSTER_CREATE_GROUP_INFO) -> *mut _HGROUP {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateClusterGroupEx(hcluster: *const _HCLUSTER, lpszgroupname: ::windows::core::PCWSTR, pgroupinfo: *const CLUSTER_CREATE_GROUP_INFO) -> *mut _HGROUP;
        }
        ::core::mem::transmute(CreateClusterGroupEx(::core::mem::transmute(hcluster), lpszgroupname.into_param().abi(), ::core::mem::transmute(pgroupinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn CreateClusterGroupSet<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, groupsetname: Param1) -> *mut _HGROUPSET {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateClusterGroupSet(hcluster: *const _HCLUSTER, groupsetname: ::windows::core::PCWSTR) -> *mut _HGROUPSET;
        }
        ::core::mem::transmute(CreateClusterGroupSet(::core::mem::transmute(hcluster), groupsetname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CreateClusterNameAccount(hcluster: *const _HCLUSTER, pconfig: *const CREATE_CLUSTER_NAME_ACCOUNT, pfnprogresscallback: PCLUSTER_SETUP_PROGRESS_CALLBACK, pvcallbackarg: *const ::core::ffi::c_void) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateClusterNameAccount(hcluster: *const _HCLUSTER, pconfig: *const CREATE_CLUSTER_NAME_ACCOUNT, pfnprogresscallback: ::windows::core::RawPtr, pvcallbackarg: *const ::core::ffi::c_void) -> u32;
        }
        ::core::mem::transmute(CreateClusterNameAccount(::core::mem::transmute(hcluster), ::core::mem::transmute(pconfig), ::core::mem::transmute(pfnprogresscallback), ::core::mem::transmute(pvcallbackarg)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn CreateClusterNotifyPort(hchange: *const _HCHANGE, hcluster: *const _HCLUSTER, dwfilter: u32, dwnotifykey: usize) -> *mut _HCHANGE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateClusterNotifyPort(hchange: *const _HCHANGE, hcluster: *const _HCLUSTER, dwfilter: u32, dwnotifykey: usize) -> *mut _HCHANGE;
        }
        ::core::mem::transmute(CreateClusterNotifyPort(::core::mem::transmute(hchange), ::core::mem::transmute(hcluster), ::core::mem::transmute(dwfilter), ::core::mem::transmute(dwnotifykey)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn CreateClusterNotifyPortV2(hchange: *const _HCHANGE, hcluster: *const _HCLUSTER, filters: *const NOTIFY_FILTER_AND_TYPE, dwfiltercount: u32, dwnotifykey: usize) -> *mut _HCHANGE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateClusterNotifyPortV2(hchange: *const _HCHANGE, hcluster: *const _HCLUSTER, filters: *const NOTIFY_FILTER_AND_TYPE, dwfiltercount: u32, dwnotifykey: usize) -> *mut _HCHANGE;
        }
        ::core::mem::transmute(CreateClusterNotifyPortV2(::core::mem::transmute(hchange), ::core::mem::transmute(hcluster), ::core::mem::transmute(filters), ::core::mem::transmute(dwfiltercount), ::core::mem::transmute(dwnotifykey)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn CreateClusterResource<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hgroup: *const _HGROUP, lpszresourcename: Param1, lpszresourcetype: Param2, dwflags: u32) -> *mut _HRESOURCE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateClusterResource(hgroup: *const _HGROUP, lpszresourcename: ::windows::core::PCWSTR, lpszresourcetype: ::windows::core::PCWSTR, dwflags: u32) -> *mut _HRESOURCE;
        }
        ::core::mem::transmute(CreateClusterResource(::core::mem::transmute(hgroup), lpszresourcename.into_param().abi(), lpszresourcetype.into_param().abi(), ::core::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn CreateClusterResourceType<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param3: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszresourcetypename: Param1, lpszdisplayname: Param2, lpszresourcetypedll: Param3, dwlooksalivepollinterval: u32, dwisalivepollinterval: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateClusterResourceType(hcluster: *const _HCLUSTER, lpszresourcetypename: ::windows::core::PCWSTR, lpszdisplayname: ::windows::core::PCWSTR, lpszresourcetypedll: ::windows::core::PCWSTR, dwlooksalivepollinterval: u32, dwisalivepollinterval: u32) -> u32;
        }
        ::core::mem::transmute(CreateClusterResourceType(::core::mem::transmute(hcluster), lpszresourcetypename.into_param().abi(), lpszdisplayname.into_param().abi(), lpszresourcetypedll.into_param().abi(), ::core::mem::transmute(dwlooksalivepollinterval), ::core::mem::transmute(dwisalivepollinterval)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const DNS_LENGTH: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn DeleteClusterGroup(hgroup: *const _HGROUP) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DeleteClusterGroup(hgroup: *const _HGROUP) -> u32;
        }
        ::core::mem::transmute(DeleteClusterGroup(::core::mem::transmute(hgroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn DeleteClusterGroupSet(hgroupset: *const _HGROUPSET) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DeleteClusterGroupSet(hgroupset: *const _HGROUPSET) -> u32;
        }
        ::core::mem::transmute(DeleteClusterGroupSet(::core::mem::transmute(hgroupset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn DeleteClusterResource(hresource: *const _HRESOURCE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DeleteClusterResource(hresource: *const _HRESOURCE) -> u32;
        }
        ::core::mem::transmute(DeleteClusterResource(::core::mem::transmute(hresource)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn DeleteClusterResourceType<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpszresourcetypename: Param1) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DeleteClusterResourceType(hcluster: *const _HCLUSTER, lpszresourcetypename: ::windows::core::PCWSTR) -> u32;
        }
        ::core::mem::transmute(DeleteClusterResourceType(::core::mem::transmute(hcluster), lpszresourcetypename.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DestroyCluster<'a, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(hcluster: *const _HCLUSTER, pfnprogresscallback: PCLUSTER_SETUP_PROGRESS_CALLBACK, pvcallbackarg: *const ::core::ffi::c_void, fdeletevirtualcomputerobjects: Param3) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DestroyCluster(hcluster: *const _HCLUSTER, pfnprogresscallback: ::windows::core::RawPtr, pvcallbackarg: *const ::core::ffi::c_void, fdeletevirtualcomputerobjects: super::super::Foundation::BOOL) -> u32;
        }
        ::core::mem::transmute(DestroyCluster(::core::mem::transmute(hcluster), ::core::mem::transmute(pfnprogresscallback), ::core::mem::transmute(pvcallbackarg), fdeletevirtualcomputerobjects.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn DestroyClusterGroup(hgroup: *const _HGROUP) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DestroyClusterGroup(hgroup: *const _HGROUP) -> u32;
        }
        ::core::mem::transmute(DestroyClusterGroup(::core::mem::transmute(hgroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn DetermineCNOResTypeFromCluster(hcluster: *const _HCLUSTER, pcnorestype: *mut CLUSTER_MGMT_POINT_RESTYPE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DetermineCNOResTypeFromCluster(hcluster: *const _HCLUSTER, pcnorestype: *mut CLUSTER_MGMT_POINT_RESTYPE) -> u32;
        }
        ::core::mem::transmute(DetermineCNOResTypeFromCluster(::core::mem::transmute(hcluster), ::core::mem::transmute(pcnorestype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn DetermineCNOResTypeFromNodelist(cnodes: u32, ppsznodenames: *const ::windows::core::PWSTR, pcnorestype: *mut CLUSTER_MGMT_POINT_RESTYPE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DetermineCNOResTypeFromNodelist(cnodes: u32, ppsznodenames: *const ::windows::core::PWSTR, pcnorestype: *mut CLUSTER_MGMT_POINT_RESTYPE) -> u32;
        }
        ::core::mem::transmute(DetermineCNOResTypeFromNodelist(::core::mem::transmute(cnodes), ::core::mem::transmute(ppsznodenames), ::core::mem::transmute(pcnorestype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn DetermineClusterCloudTypeFromCluster(hcluster: *const _HCLUSTER, pcloudtype: *mut CLUSTER_CLOUD_TYPE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DetermineClusterCloudTypeFromCluster(hcluster: *const _HCLUSTER, pcloudtype: *mut CLUSTER_CLOUD_TYPE) -> u32;
        }
        ::core::mem::transmute(DetermineClusterCloudTypeFromCluster(::core::mem::transmute(hcluster), ::core::mem::transmute(pcloudtype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn DetermineClusterCloudTypeFromNodelist(cnodes: u32, ppsznodenames: *const ::windows::core::PWSTR, pcloudtype: *mut CLUSTER_CLOUD_TYPE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DetermineClusterCloudTypeFromNodelist(cnodes: u32, ppsznodenames: *const ::windows::core::PWSTR, pcloudtype: *mut CLUSTER_CLOUD_TYPE) -> u32;
        }
        ::core::mem::transmute(DetermineClusterCloudTypeFromNodelist(::core::mem::transmute(cnodes), ::core::mem::transmute(ppsznodenames), ::core::mem::transmute(pcloudtype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DomainNames: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606e1_2631_11d1_89f1_00a0c90d061e);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const ENABLE_CLUSTER_SHARED_VOLUMES: &'static str = "EnableSharedVolumes";
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn EvictClusterNode(hnode: *const _HNODE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EvictClusterNode(hnode: *const _HNODE) -> u32;
        }
        ::core::mem::transmute(EvictClusterNode(::core::mem::transmute(hnode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn EvictClusterNodeEx(hnode: *const _HNODE, dwtimeout: u32, phrcleanupstatus: *mut ::windows::core::HRESULT) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EvictClusterNodeEx(hnode: *const _HNODE, dwtimeout: u32, phrcleanupstatus: *mut ::windows::core::HRESULT) -> u32;
        }
        ::core::mem::transmute(EvictClusterNodeEx(::core::mem::transmute(hnode), ::core::mem::transmute(dwtimeout), ::core::mem::transmute(phrcleanupstatus)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FAILURE_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FAILURE_TYPE_GENERAL: FAILURE_TYPE = FAILURE_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FAILURE_TYPE_EMBEDDED: FAILURE_TYPE = FAILURE_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FAILURE_TYPE_NETWORK_LOSS: FAILURE_TYPE = FAILURE_TYPE(2i32);
impl ::core::marker::Copy for FAILURE_TYPE {}
impl ::core::clone::Clone for FAILURE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FAILURE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FAILURE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FAILURE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FAILURE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FE_UPGRADE_VERSION: u32 = 4u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct FILESHARE_CHANGE {
    pub Change: FILESHARE_CHANGE_ENUM,
    pub ShareName: [u16; 84],
}
impl ::core::marker::Copy for FILESHARE_CHANGE {}
impl ::core::clone::Clone for FILESHARE_CHANGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for FILESHARE_CHANGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("FILESHARE_CHANGE").field("Change", &self.Change).field("ShareName", &self.ShareName).finish()
    }
}
unsafe impl ::windows::core::Abi for FILESHARE_CHANGE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for FILESHARE_CHANGE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILESHARE_CHANGE>()) == 0 }
    }
}
impl ::core::cmp::Eq for FILESHARE_CHANGE {}
impl ::core::default::Default for FILESHARE_CHANGE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FILESHARE_CHANGE_ENUM(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FILESHARE_CHANGE_NONE: FILESHARE_CHANGE_ENUM = FILESHARE_CHANGE_ENUM(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FILESHARE_CHANGE_ADD: FILESHARE_CHANGE_ENUM = FILESHARE_CHANGE_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FILESHARE_CHANGE_DEL: FILESHARE_CHANGE_ENUM = FILESHARE_CHANGE_ENUM(2i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const FILESHARE_CHANGE_MODIFY: FILESHARE_CHANGE_ENUM = FILESHARE_CHANGE_ENUM(3i32);
impl ::core::marker::Copy for FILESHARE_CHANGE_ENUM {}
impl ::core::clone::Clone for FILESHARE_CHANGE_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FILESHARE_CHANGE_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FILESHARE_CHANGE_ENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for FILESHARE_CHANGE_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FILESHARE_CHANGE_ENUM").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct FILESHARE_CHANGE_LIST {
    pub NumEntries: u32,
    pub ChangeEntry: [FILESHARE_CHANGE; 1],
}
impl ::core::marker::Copy for FILESHARE_CHANGE_LIST {}
impl ::core::clone::Clone for FILESHARE_CHANGE_LIST {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for FILESHARE_CHANGE_LIST {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("FILESHARE_CHANGE_LIST").field("NumEntries", &self.NumEntries).field("ChangeEntry", &self.ChangeEntry).finish()
    }
}
unsafe impl ::windows::core::Abi for FILESHARE_CHANGE_LIST {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for FILESHARE_CHANGE_LIST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILESHARE_CHANGE_LIST>()) == 0 }
    }
}
impl ::core::cmp::Eq for FILESHARE_CHANGE_LIST {}
impl ::core::default::Default for FILESHARE_CHANGE_LIST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn FailClusterResource(hresource: *const _HRESOURCE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FailClusterResource(hresource: *const _HRESOURCE) -> u32;
        }
        ::core::mem::transmute(FailClusterResource(::core::mem::transmute(hresource)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn FreeClusterCrypt(pcryptinfo: *const ::core::ffi::c_void) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FreeClusterCrypt(pcryptinfo: *const ::core::ffi::c_void) -> u32;
        }
        ::core::mem::transmute(FreeClusterCrypt(::core::mem::transmute(pcryptinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn FreeClusterHealthFault(clusterhealthfault: *mut CLUSTER_HEALTH_FAULT) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FreeClusterHealthFault(clusterhealthfault: *mut CLUSTER_HEALTH_FAULT) -> u32;
        }
        ::core::mem::transmute(FreeClusterHealthFault(::core::mem::transmute(clusterhealthfault)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn FreeClusterHealthFaultArray(clusterhealthfaultarray: *mut CLUSTER_HEALTH_FAULT_ARRAY) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FreeClusterHealthFaultArray(clusterhealthfaultarray: *mut CLUSTER_HEALTH_FAULT_ARRAY) -> u32;
        }
        ::core::mem::transmute(FreeClusterHealthFaultArray(::core::mem::transmute(clusterhealthfaultarray)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct GET_OPERATION_CONTEXT_PARAMS {
    pub Size: u32,
    pub Version: u32,
    pub Type: RESDLL_CONTEXT_OPERATION_TYPE,
    pub Priority: u32,
}
impl ::core::marker::Copy for GET_OPERATION_CONTEXT_PARAMS {}
impl ::core::clone::Clone for GET_OPERATION_CONTEXT_PARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for GET_OPERATION_CONTEXT_PARAMS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("GET_OPERATION_CONTEXT_PARAMS").field("Size", &self.Size).field("Version", &self.Version).field("Type", &self.Type).field("Priority", &self.Priority).finish()
    }
}
unsafe impl ::windows::core::Abi for GET_OPERATION_CONTEXT_PARAMS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for GET_OPERATION_CONTEXT_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<GET_OPERATION_CONTEXT_PARAMS>()) == 0 }
    }
}
impl ::core::cmp::Eq for GET_OPERATION_CONTEXT_PARAMS {}
impl ::core::default::Default for GET_OPERATION_CONTEXT_PARAMS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GROUPSET_READY_SETTING_APPLICATION_READY: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GROUPSET_READY_SETTING_DELAY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GROUPSET_READY_SETTING_ONLINE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GROUPSET_READY_SETTING_OS_HEARTBEAT: u32 = 3u32;
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct GROUP_FAILURE_INFO {
    pub dwFailoverAttemptsRemaining: u32,
    pub dwFailoverPeriodRemaining: u32,
}
impl ::core::marker::Copy for GROUP_FAILURE_INFO {}
impl ::core::clone::Clone for GROUP_FAILURE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for GROUP_FAILURE_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("GROUP_FAILURE_INFO").field("dwFailoverAttemptsRemaining", &self.dwFailoverAttemptsRemaining).field("dwFailoverPeriodRemaining", &self.dwFailoverPeriodRemaining).finish()
    }
}
unsafe impl ::windows::core::Abi for GROUP_FAILURE_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for GROUP_FAILURE_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<GROUP_FAILURE_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for GROUP_FAILURE_INFO {}
impl ::core::default::Default for GROUP_FAILURE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub struct GROUP_FAILURE_INFO_BUFFER {
    pub dwVersion: u32,
    pub Info: GROUP_FAILURE_INFO,
}
impl ::core::marker::Copy for GROUP_FAILURE_INFO_BUFFER {}
impl ::core::clone::Clone for GROUP_FAILURE_INFO_BUFFER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for GROUP_FAILURE_INFO_BUFFER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("GROUP_FAILURE_INFO_BUFFER").field("dwVersion", &self.dwVersion).field("Info", &self.Info).finish()
    }
}
unsafe impl ::windows::core::Abi for GROUP_FAILURE_INFO_BUFFER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for GROUP_FAILURE_INFO_BUFFER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<GROUP_FAILURE_INFO_BUFFER>()) == 0 }
    }
}
impl ::core::cmp::Eq for GROUP_FAILURE_INFO_BUFFER {}
impl ::core::default::Default for GROUP_FAILURE_INFO_BUFFER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GROUP_FAILURE_INFO_VERSION_1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct GRP_PLACEMENT_OPTIONS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GRP_PLACEMENT_OPTIONS_MIN_VALUE: GRP_PLACEMENT_OPTIONS = GRP_PLACEMENT_OPTIONS(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GRP_PLACEMENT_OPTIONS_DEFAULT: GRP_PLACEMENT_OPTIONS = GRP_PLACEMENT_OPTIONS(0i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GRP_PLACEMENT_OPTIONS_DISABLE_AUTOBALANCING: GRP_PLACEMENT_OPTIONS = GRP_PLACEMENT_OPTIONS(1i32);
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GRP_PLACEMENT_OPTIONS_ALL: GRP_PLACEMENT_OPTIONS = GRP_PLACEMENT_OPTIONS(1i32);
impl ::core::marker::Copy for GRP_PLACEMENT_OPTIONS {}
impl ::core::clone::Clone for GRP_PLACEMENT_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for GRP_PLACEMENT_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for GRP_PLACEMENT_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for GRP_PLACEMENT_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("GRP_PLACEMENT_OPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const GUID_PRESENT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterFromGroup(hgroup: *const _HGROUP) -> *mut _HCLUSTER {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterFromGroup(hgroup: *const _HGROUP) -> *mut _HCLUSTER;
        }
        ::core::mem::transmute(GetClusterFromGroup(::core::mem::transmute(hgroup)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterFromNetInterface(hnetinterface: *const _HNETINTERFACE) -> *mut _HCLUSTER {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterFromNetInterface(hnetinterface: *const _HNETINTERFACE) -> *mut _HCLUSTER;
        }
        ::core::mem::transmute(GetClusterFromNetInterface(::core::mem::transmute(hnetinterface)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterFromNetwork(hnetwork: *const _HNETWORK) -> *mut _HCLUSTER {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterFromNetwork(hnetwork: *const _HNETWORK) -> *mut _HCLUSTER;
        }
        ::core::mem::transmute(GetClusterFromNetwork(::core::mem::transmute(hnetwork)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterFromNode(hnode: *const _HNODE) -> *mut _HCLUSTER {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterFromNode(hnode: *const _HNODE) -> *mut _HCLUSTER;
        }
        ::core::mem::transmute(GetClusterFromNode(::core::mem::transmute(hnode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterFromResource(hresource: *const _HRESOURCE) -> *mut _HCLUSTER {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterFromResource(hresource: *const _HRESOURCE) -> *mut _HCLUSTER;
        }
        ::core::mem::transmute(GetClusterFromResource(::core::mem::transmute(hresource)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn GetClusterGroupKey(hgroup: *const _HGROUP, samdesired: u32) -> super::super::System::Registry::HKEY {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterGroupKey(hgroup: *const _HGROUP, samdesired: u32) -> super::super::System::Registry::HKEY;
        }
        ::core::mem::transmute(GetClusterGroupKey(::core::mem::transmute(hgroup), ::core::mem::transmute(samdesired)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterGroupState(hgroup: *const _HGROUP, lpsznodename: ::windows::core::PWSTR, lpcchnodename: *mut u32) -> CLUSTER_GROUP_STATE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterGroupState(hgroup: *const _HGROUP, lpsznodename: ::windows::core::PWSTR, lpcchnodename: *mut u32) -> CLUSTER_GROUP_STATE;
        }
        ::core::mem::transmute(GetClusterGroupState(::core::mem::transmute(hgroup), ::core::mem::transmute(lpsznodename), ::core::mem::transmute(lpcchnodename)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterInformation(hcluster: *const _HCLUSTER, lpszclustername: ::windows::core::PWSTR, lpcchclustername: *mut u32, lpclusterinfo: *mut CLUSTERVERSIONINFO) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterInformation(hcluster: *const _HCLUSTER, lpszclustername: ::windows::core::PWSTR, lpcchclustername: *mut u32, lpclusterinfo: *mut CLUSTERVERSIONINFO) -> u32;
        }
        ::core::mem::transmute(GetClusterInformation(::core::mem::transmute(hcluster), ::core::mem::transmute(lpszclustername), ::core::mem::transmute(lpcchclustername), ::core::mem::transmute(lpclusterinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn GetClusterKey(hcluster: *const _HCLUSTER, samdesired: u32) -> super::super::System::Registry::HKEY {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterKey(hcluster: *const _HCLUSTER, samdesired: u32) -> super::super::System::Registry::HKEY;
        }
        ::core::mem::transmute(GetClusterKey(::core::mem::transmute(hcluster), ::core::mem::transmute(samdesired)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterNetInterface<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>, Param2: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpsznodename: Param1, lpsznetworkname: Param2, lpszinterfacename: ::windows::core::PWSTR, lpcchinterfacename: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNetInterface(hcluster: *const _HCLUSTER, lpsznodename: ::windows::core::PCWSTR, lpsznetworkname: ::windows::core::PCWSTR, lpszinterfacename: ::windows::core::PWSTR, lpcchinterfacename: *mut u32) -> u32;
        }
        ::core::mem::transmute(GetClusterNetInterface(::core::mem::transmute(hcluster), lpsznodename.into_param().abi(), lpsznetworkname.into_param().abi(), ::core::mem::transmute(lpszinterfacename), ::core::mem::transmute(lpcchinterfacename)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn GetClusterNetInterfaceKey(hnetinterface: *const _HNETINTERFACE, samdesired: u32) -> super::super::System::Registry::HKEY {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNetInterfaceKey(hnetinterface: *const _HNETINTERFACE, samdesired: u32) -> super::super::System::Registry::HKEY;
        }
        ::core::mem::transmute(GetClusterNetInterfaceKey(::core::mem::transmute(hnetinterface), ::core::mem::transmute(samdesired)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterNetInterfaceState(hnetinterface: *const _HNETINTERFACE) -> CLUSTER_NETINTERFACE_STATE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNetInterfaceState(hnetinterface: *const _HNETINTERFACE) -> CLUSTER_NETINTERFACE_STATE;
        }
        ::core::mem::transmute(GetClusterNetInterfaceState(::core::mem::transmute(hnetinterface)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterNetworkId(hnetwork: *const _HNETWORK, lpsznetworkid: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNetworkId(hnetwork: *const _HNETWORK, lpsznetworkid: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(GetClusterNetworkId(::core::mem::transmute(hnetwork), ::core::mem::transmute(lpsznetworkid), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn GetClusterNetworkKey(hnetwork: *const _HNETWORK, samdesired: u32) -> super::super::System::Registry::HKEY {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNetworkKey(hnetwork: *const _HNETWORK, samdesired: u32) -> super::super::System::Registry::HKEY;
        }
        ::core::mem::transmute(GetClusterNetworkKey(::core::mem::transmute(hnetwork), ::core::mem::transmute(samdesired)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterNetworkState(hnetwork: *const _HNETWORK) -> CLUSTER_NETWORK_STATE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNetworkState(hnetwork: *const _HNETWORK) -> CLUSTER_NETWORK_STATE;
        }
        ::core::mem::transmute(GetClusterNetworkState(::core::mem::transmute(hnetwork)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterNodeId(hnode: *const _HNODE, lpsznodeid: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNodeId(hnode: *const _HNODE, lpsznodeid: ::windows::core::PWSTR, lpcchname: *mut u32) -> u32;
        }
        ::core::mem::transmute(GetClusterNodeId(::core::mem::transmute(hnode), ::core::mem::transmute(lpsznodeid), ::core::mem::transmute(lpcchname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn GetClusterNodeKey(hnode: *const _HNODE, samdesired: u32) -> super::super::System::Registry::HKEY {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNodeKey(hnode: *const _HNODE, samdesired: u32) -> super::super::System::Registry::HKEY;
        }
        ::core::mem::transmute(GetClusterNodeKey(::core::mem::transmute(hnode), ::core::mem::transmute(samdesired)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterNodeState(hnode: *const _HNODE) -> CLUSTER_NODE_STATE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNodeState(hnode: *const _HNODE) -> CLUSTER_NODE_STATE;
        }
        ::core::mem::transmute(GetClusterNodeState(::core::mem::transmute(hnode)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterNotify(hchange: *const _HCHANGE, lpdwnotifykey: *mut usize, lpdwfiltertype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32, dwmilliseconds: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNotify(hchange: *const _HCHANGE, lpdwnotifykey: *mut usize, lpdwfiltertype: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32, dwmilliseconds: u32) -> u32;
        }
        ::core::mem::transmute(GetClusterNotify(::core::mem::transmute(hchange), ::core::mem::transmute(lpdwnotifykey), ::core::mem::transmute(lpdwfiltertype), ::core::mem::transmute(lpszname), ::core::mem::transmute(lpcchname), ::core::mem::transmute(dwmilliseconds)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterNotifyV2(hchange: *const _HCHANGE, lpdwnotifykey: *mut usize, pfilterandtype: *mut NOTIFY_FILTER_AND_TYPE, buffer: *mut u8, lpbbuffersize: *mut u32, lpszobjectid: ::windows::core::PWSTR, lpcchobjectid: *mut u32, lpszparentid: ::windows::core::PWSTR, lpcchparentid: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32, lpsztype: ::windows::core::PWSTR, lpcchtype: *mut u32, dwmilliseconds: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterNotifyV2(hchange: *const _HCHANGE, lpdwnotifykey: *mut usize, pfilterandtype: *mut NOTIFY_FILTER_AND_TYPE, buffer: *mut u8, lpbbuffersize: *mut u32, lpszobjectid: ::windows::core::PWSTR, lpcchobjectid: *mut u32, lpszparentid: ::windows::core::PWSTR, lpcchparentid: *mut u32, lpszname: ::windows::core::PWSTR, lpcchname: *mut u32, lpsztype: ::windows::core::PWSTR, lpcchtype: *mut u32, dwmilliseconds: u32) -> u32;
        }
        ::core::mem::transmute(GetClusterNotifyV2(
            ::core::mem::transmute(hchange),
            ::core::mem::transmute(lpdwnotifykey),
            ::core::mem::transmute(pfilterandtype),
            ::core::mem::transmute(buffer),
            ::core::mem::transmute(lpbbuffersize),
            ::core::mem::transmute(lpszobjectid),
            ::core::mem::transmute(lpcchobjectid),
            ::core::mem::transmute(lpszparentid),
            ::core::mem::transmute(lpcchparentid),
            ::core::mem::transmute(lpszname),
            ::core::mem::transmute(lpcchname),
            ::core::mem::transmute(lpsztype),
            ::core::mem::transmute(lpcchtype),
            ::core::mem::transmute(dwmilliseconds),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterQuorumResource(hcluster: *const _HCLUSTER, lpszresourcename: ::windows::core::PWSTR, lpcchresourcename: *mut u32, lpszdevicename: ::windows::core::PWSTR, lpcchdevicename: *mut u32, lpdwmaxquorumlogsize: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterQuorumResource(hcluster: *const _HCLUSTER, lpszresourcename: ::windows::core::PWSTR, lpcchresourcename: *mut u32, lpszdevicename: ::windows::core::PWSTR, lpcchdevicename: *mut u32, lpdwmaxquorumlogsize: *mut u32) -> u32;
        }
        ::core::mem::transmute(GetClusterQuorumResource(::core::mem::transmute(hcluster), ::core::mem::transmute(lpszresourcename), ::core::mem::transmute(lpcchresourcename), ::core::mem::transmute(lpszdevicename), ::core::mem::transmute(lpcchdevicename), ::core::mem::transmute(lpdwmaxquorumlogsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterResourceDependencyExpression(hresource: *const _HRESOURCE, lpszdependencyexpression: ::windows::core::PWSTR, lpcchdependencyexpression: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterResourceDependencyExpression(hresource: *const _HRESOURCE, lpszdependencyexpression: ::windows::core::PWSTR, lpcchdependencyexpression: *mut u32) -> u32;
        }
        ::core::mem::transmute(GetClusterResourceDependencyExpression(::core::mem::transmute(hresource), ::core::mem::transmute(lpszdependencyexpression), ::core::mem::transmute(lpcchdependencyexpression)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn GetClusterResourceKey(hresource: *const _HRESOURCE, samdesired: u32) -> super::super::System::Registry::HKEY {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterResourceKey(hresource: *const _HRESOURCE, samdesired: u32) -> super::super::System::Registry::HKEY;
        }
        ::core::mem::transmute(GetClusterResourceKey(::core::mem::transmute(hresource), ::core::mem::transmute(samdesired)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetClusterResourceNetworkName(hresource: *const _HRESOURCE, lpbuffer: ::windows::core::PWSTR, nsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterResourceNetworkName(hresource: *const _HRESOURCE, lpbuffer: ::windows::core::PWSTR, nsize: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetClusterResourceNetworkName(::core::mem::transmute(hresource), ::core::mem::transmute(lpbuffer), ::core::mem::transmute(nsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetClusterResourceState(hresource: *const _HRESOURCE, lpsznodename: ::windows::core::PWSTR, lpcchnodename: *mut u32, lpszgroupname: ::windows::core::PWSTR, lpcchgroupname: *mut u32) -> CLUSTER_RESOURCE_STATE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterResourceState(hresource: *const _HRESOURCE, lpsznodename: ::windows::core::PWSTR, lpcchnodename: *mut u32, lpszgroupname: ::windows::core::PWSTR, lpcchgroupname: *mut u32) -> CLUSTER_RESOURCE_STATE;
        }
        ::core::mem::transmute(GetClusterResourceState(::core::mem::transmute(hresource), ::core::mem::transmute(lpsznodename), ::core::mem::transmute(lpcchnodename), ::core::mem::transmute(lpszgroupname), ::core::mem::transmute(lpcchgroupname)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Registry\"`*"]
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn GetClusterResourceTypeKey<'a, Param1: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(hcluster: *const _HCLUSTER, lpsztypename: Param1, samdesired: u32) -> super::super::System::Registry::HKEY {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetClusterResourceTypeKey(hcluster: *const _HCLUSTER, lpsztypename: ::windows::core::PCWSTR, samdesired: u32) -> super::super::System::Registry::HKEY;
        }
        ::core::mem::transmute(GetClusterResourceTypeKey(::core::mem::transmute(hcluster), lpsztypename.into_param().abi(), ::core::mem::transmute(samdesired)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetNodeCloudTypeDW<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(ppsznodename: Param0, nodecloudtype: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNodeCloudTypeDW(ppsznodename: ::windows::core::PCWSTR, nodecloudtype: *mut u32) -> u32;
        }
        ::core::mem::transmute(GetNodeCloudTypeDW(ppsznodename.into_param().abi(), ::core::mem::transmute(nodecloudtype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[inline]
pub unsafe fn GetNodeClusterState<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::PCWSTR>>(lpsznodename: Param0, pdwclusterstate: *mut u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNodeClusterState(lpsznodename: ::windows::core::PCWSTR, pdwclusterstate: *mut u32) -> u32;
        }
        ::core::mem::transmute(GetNodeClusterState(lpsznodename.into_param().abi(), ::core::mem::transmute(pdwclusterstate)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetNotifyEventHandle(hchange: *const _HCHANGE, lphtargetevent: *mut super::super::Foundation::HANDLE) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNotifyEventHandle(hchange: *const _HCHANGE, lphtargetevent: *mut super::super::Foundation::HANDLE) -> u32;
        }
        ::core::mem::transmute(GetNotifyEventHandle(::core::mem::transmute(hchange), ::core::mem::transmute(lphtargetevent)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
pub const HCI_UPGRADE_BIT: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IGetClusterDataInfo(::windows::core::IUnknown);
impl IGetClusterDataInfo {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetClusterName(&self, lpszname: super::super::Foundation::BSTR, pcchname: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetClusterName)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpszname), ::core::mem::transmute(pcchname)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn GetClusterHandle(&self) -> *mut _HCLUSTER {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetClusterHandle)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn GetObjectCount(&self) -> i32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetObjectCount)(::core::mem::transmute_copy(self)))
    }
}
impl ::core::convert::From<IGetClusterDataInfo> for ::windows::core::IUnknown {
    fn from(value: IGetClusterDataInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetClusterDataInfo> for ::windows::core::IUnknown {
    fn from(value: &IGetClusterDataInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetClusterDataInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetClusterDataInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetClusterDataInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetClusterDataInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetClusterDataInfo {}
impl ::core::fmt::Debug for IGetClusterDataInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetClusterDataInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetClusterDataInfo {
    type Vtable = IGetClusterDataInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x97dede51_fc6b_11cf_b5f5_00a0c90ab505);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetClusterDataInfo_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetClusterName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpszname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, pcchname: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetClusterName: usize,
    pub GetClusterHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> *mut _HCLUSTER,
    pub GetObjectCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IGetClusterGroupInfo(::windows::core::IUnknown);
impl IGetClusterGroupInfo {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn GetGroupHandle(&self, lobjindex: i32) -> *mut _HGROUP {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetGroupHandle)(::core::mem::transmute_copy(self), ::core::mem::transmute(lobjindex)))
    }
}
impl ::core::convert::From<IGetClusterGroupInfo> for ::windows::core::IUnknown {
    fn from(value: IGetClusterGroupInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetClusterGroupInfo> for ::windows::core::IUnknown {
    fn from(value: &IGetClusterGroupInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetClusterGroupInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetClusterGroupInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetClusterGroupInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetClusterGroupInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetClusterGroupInfo {}
impl ::core::fmt::Debug for IGetClusterGroupInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetClusterGroupInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetClusterGroupInfo {
    type Vtable = IGetClusterGroupInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x97dede54_fc6b_11cf_b5f5_00a0c90ab505);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetClusterGroupInfo_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub GetGroupHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lobjindex: i32) -> *mut _HGROUP,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IGetClusterNetInterfaceInfo(::windows::core::IUnknown);
impl IGetClusterNetInterfaceInfo {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn GetNetInterfaceHandle(&self, lobjindex: i32) -> *mut _HNETINTERFACE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetNetInterfaceHandle)(::core::mem::transmute_copy(self), ::core::mem::transmute(lobjindex)))
    }
}
impl ::core::convert::From<IGetClusterNetInterfaceInfo> for ::windows::core::IUnknown {
    fn from(value: IGetClusterNetInterfaceInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetClusterNetInterfaceInfo> for ::windows::core::IUnknown {
    fn from(value: &IGetClusterNetInterfaceInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetClusterNetInterfaceInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetClusterNetInterfaceInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetClusterNetInterfaceInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetClusterNetInterfaceInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetClusterNetInterfaceInfo {}
impl ::core::fmt::Debug for IGetClusterNetInterfaceInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetClusterNetInterfaceInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetClusterNetInterfaceInfo {
    type Vtable = IGetClusterNetInterfaceInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x97dede57_fc6b_11cf_b5f5_00a0c90ab505);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetClusterNetInterfaceInfo_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub GetNetInterfaceHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lobjindex: i32) -> *mut _HNETINTERFACE,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IGetClusterNetworkInfo(::windows::core::IUnknown);
impl IGetClusterNetworkInfo {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn GetNetworkHandle(&self, lobjindex: i32) -> *mut _HNETWORK {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetNetworkHandle)(::core::mem::transmute_copy(self), ::core::mem::transmute(lobjindex)))
    }
}
impl ::core::convert::From<IGetClusterNetworkInfo> for ::windows::core::IUnknown {
    fn from(value: IGetClusterNetworkInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetClusterNetworkInfo> for ::windows::core::IUnknown {
    fn from(value: &IGetClusterNetworkInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetClusterNetworkInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetClusterNetworkInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetClusterNetworkInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetClusterNetworkInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetClusterNetworkInfo {}
impl ::core::fmt::Debug for IGetClusterNetworkInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetClusterNetworkInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetClusterNetworkInfo {
    type Vtable = IGetClusterNetworkInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x97dede56_fc6b_11cf_b5f5_00a0c90ab505);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetClusterNetworkInfo_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub GetNetworkHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lobjindex: i32) -> *mut _HNETWORK,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IGetClusterNodeInfo(::windows::core::IUnknown);
impl IGetClusterNodeInfo {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn GetNodeHandle(&self, lobjindex: i32) -> *mut _HNODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetNodeHandle)(::core::mem::transmute_copy(self), ::core::mem::transmute(lobjindex)))
    }
}
impl ::core::convert::From<IGetClusterNodeInfo> for ::windows::core::IUnknown {
    fn from(value: IGetClusterNodeInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetClusterNodeInfo> for ::windows::core::IUnknown {
    fn from(value: &IGetClusterNodeInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetClusterNodeInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetClusterNodeInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetClusterNodeInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetClusterNodeInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetClusterNodeInfo {}
impl ::core::fmt::Debug for IGetClusterNodeInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetClusterNodeInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetClusterNodeInfo {
    type Vtable = IGetClusterNodeInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x97dede53_fc6b_11cf_b5f5_00a0c90ab505);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetClusterNodeInfo_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub GetNodeHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lobjindex: i32) -> *mut _HNODE,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IGetClusterObjectInfo(::windows::core::IUnknown);
impl IGetClusterObjectInfo {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetObjectName(&self, lobjindex: i32, lpszname: super::super::Foundation::BSTR, pcchname: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetObjectName)(::core::mem::transmute_copy(self), ::core::mem::transmute(lobjindex), ::core::mem::transmute(lpszname), ::core::mem::transmute(pcchname)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn GetObjectType(&self, lobjindex: i32) -> CLUADMEX_OBJECT_TYPE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetObjectType)(::core::mem::transmute_copy(self), ::core::mem::transmute(lobjindex)))
    }
}
impl ::core::convert::From<IGetClusterObjectInfo> for ::windows::core::IUnknown {
    fn from(value: IGetClusterObjectInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetClusterObjectInfo> for ::windows::core::IUnknown {
    fn from(value: &IGetClusterObjectInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetClusterObjectInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetClusterObjectInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetClusterObjectInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetClusterObjectInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetClusterObjectInfo {}
impl ::core::fmt::Debug for IGetClusterObjectInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetClusterObjectInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetClusterObjectInfo {
    type Vtable = IGetClusterObjectInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x97dede52_fc6b_11cf_b5f5_00a0c90ab505);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetClusterObjectInfo_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetObjectName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lobjindex: i32, lpszname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, pcchname: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetObjectName: usize,
    pub GetObjectType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lobjindex: i32) -> CLUADMEX_OBJECT_TYPE,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IGetClusterResourceInfo(::windows::core::IUnknown);
impl IGetClusterResourceInfo {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn GetResourceHandle(&self, lobjindex: i32) -> *mut _HRESOURCE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetResourceHandle)(::core::mem::transmute_copy(self), ::core::mem::transmute(lobjindex)))
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetResourceTypeName(&self, lobjindex: i32, lpszrestypename: super::super::Foundation::BSTR, pcchrestypename: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetResourceTypeName)(::core::mem::transmute_copy(self), ::core::mem::transmute(lobjindex), ::core::mem::transmute(lpszrestypename), ::core::mem::transmute(pcchrestypename)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetResourceNetworkName(&self, lobjindex: i32, lpsznetname: super::super::Foundation::BSTR, pcchnetname: *mut u32) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetResourceNetworkName)(::core::mem::transmute_copy(self), ::core::mem::transmute(lobjindex), ::core::mem::transmute(lpsznetname), ::core::mem::transmute(pcchnetname)))
    }
}
impl ::core::convert::From<IGetClusterResourceInfo> for ::windows::core::IUnknown {
    fn from(value: IGetClusterResourceInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetClusterResourceInfo> for ::windows::core::IUnknown {
    fn from(value: &IGetClusterResourceInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetClusterResourceInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetClusterResourceInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetClusterResourceInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetClusterResourceInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetClusterResourceInfo {}
impl ::core::fmt::Debug for IGetClusterResourceInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetClusterResourceInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetClusterResourceInfo {
    type Vtable = IGetClusterResourceInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x97dede55_fc6b_11cf_b5f5_00a0c90ab505);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetClusterResourceInfo_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub GetResourceHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lobjindex: i32) -> *mut _HRESOURCE,
    #[cfg(feature = "Win32_Foundation")]
    pub GetResourceTypeName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lobjindex: i32, lpszrestypename: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, pcchrestypename: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetResourceTypeName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetResourceNetworkName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lobjindex: i32, lpsznetname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, pcchnetname: *mut u32) -> super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetResourceNetworkName: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IGetClusterUIInfo(::windows::core::IUnknown);
impl IGetClusterUIInfo {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetClusterName(&self, lpszname: super::super::Foundation::BSTR, pcchname: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetClusterName)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpszname), ::core::mem::transmute(pcchname)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn GetLocale(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetLocale)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetFont(&self) -> super::super::Graphics::Gdi::HFONT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetFont)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn GetIcon(&self) -> super::super::UI::WindowsAndMessaging::HICON {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetIcon)(::core::mem::transmute_copy(self)))
    }
}
impl ::core::convert::From<IGetClusterUIInfo> for ::windows::core::IUnknown {
    fn from(value: IGetClusterUIInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IGetClusterUIInfo> for ::windows::core::IUnknown {
    fn from(value: &IGetClusterUIInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IGetClusterUIInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IGetClusterUIInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IGetClusterUIInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetClusterUIInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetClusterUIInfo {}
impl ::core::fmt::Debug for IGetClusterUIInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetClusterUIInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IGetClusterUIInfo {
    type Vtable = IGetClusterUIInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x97dede50_fc6b_11cf_b5f5_00a0c90ab505);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetClusterUIInfo_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetClusterName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpszname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, pcchname: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetClusterName: usize,
    pub GetLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetFont: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::super::Graphics::Gdi::HFONT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetFont: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub GetIcon: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::super::UI::WindowsAndMessaging::HICON,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    GetIcon: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusApplication(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusApplication {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn DomainNames(&self) -> ::windows::core::Result<ISDomainNames> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DomainNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISDomainNames>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ClusterNames<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrdomainname: Param0) -> ::windows::core::Result<ISClusterNames> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ClusterNames)(::core::mem::transmute_copy(self), bstrdomainname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusterNames>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn OpenCluster<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrclustername: Param0) -> ::windows::core::Result<ISCluster> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).OpenCluster)(::core::mem::transmute_copy(self), bstrclustername.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISCluster>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusApplication> for ::windows::core::IUnknown {
    fn from(value: ISClusApplication) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusApplication> for ::windows::core::IUnknown {
    fn from(value: &ISClusApplication) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusApplication {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusApplication {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusApplication> for super::super::System::Com::IDispatch {
    fn from(value: ISClusApplication) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusApplication> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusApplication) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusApplication {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusApplication {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusApplication {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusApplication {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusApplication {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusApplication {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusApplication").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusApplication {
    type Vtable = ISClusApplication_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606e6_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusApplication_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub DomainNames: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdomains: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    DomainNames: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub ClusterNames: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdomainname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, ppclusters: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    ClusterNames: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub OpenCluster: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrclustername: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, pcluster: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    OpenCluster: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusCryptoKeys(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusCryptoKeys {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrcryptokey: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddItem)(::core::mem::transmute_copy(self), bstrcryptokey.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn RemoveItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusCryptoKeys> for ::windows::core::IUnknown {
    fn from(value: ISClusCryptoKeys) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusCryptoKeys> for ::windows::core::IUnknown {
    fn from(value: &ISClusCryptoKeys) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusCryptoKeys {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusCryptoKeys {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusCryptoKeys> for super::super::System::Com::IDispatch {
    fn from(value: ISClusCryptoKeys) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusCryptoKeys> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusCryptoKeys) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusCryptoKeys {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusCryptoKeys {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusCryptoKeys {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusCryptoKeys {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusCryptoKeys {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusCryptoKeys {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusCryptoKeys").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusCryptoKeys {
    type Vtable = ISClusCryptoKeys_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6072c_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusCryptoKeys_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pbstrcyrptokey: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub AddItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrcryptokey: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AddItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub RemoveItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    RemoveItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusDisk(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusDisk {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Signature(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Signature)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ScsiAddress(&self) -> ::windows::core::Result<ISClusScsiAddress> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ScsiAddress)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusScsiAddress>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn DiskNumber(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DiskNumber)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Partitions(&self) -> ::windows::core::Result<ISClusPartitions> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Partitions)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusPartitions>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusDisk> for ::windows::core::IUnknown {
    fn from(value: ISClusDisk) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusDisk> for ::windows::core::IUnknown {
    fn from(value: &ISClusDisk) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusDisk {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusDisk {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusDisk> for super::super::System::Com::IDispatch {
    fn from(value: ISClusDisk) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusDisk> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusDisk) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusDisk {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusDisk {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusDisk {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusDisk {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusDisk {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusDisk {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusDisk").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusDisk {
    type Vtable = ISClusDisk_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60724_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusDisk_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Signature: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plsignature: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub ScsiAddress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppscsiaddress: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ScsiAddress: usize,
    pub DiskNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pldisknumber: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Partitions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pppartitions: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Partitions: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusDisks(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusDisks {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusDisk> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusDisk>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusDisks> for ::windows::core::IUnknown {
    fn from(value: ISClusDisks) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusDisks> for ::windows::core::IUnknown {
    fn from(value: &ISClusDisks) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusDisks {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusDisks {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusDisks> for super::super::System::Com::IDispatch {
    fn from(value: ISClusDisks) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusDisks> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusDisks) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusDisks {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusDisks {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusDisks {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusDisks {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusDisks {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusDisks {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusDisks").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusDisks {
    type Vtable = ISClusDisks_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60726_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusDisks_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppdisk: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusNetInterface(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusNetInterface {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Handle(&self) -> ::windows::core::Result<usize> {
        let mut result__: usize = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Handle)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<usize>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn State(&self) -> ::windows::core::Result<CLUSTER_NETINTERFACE_STATE> {
        let mut result__: CLUSTER_NETINTERFACE_STATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).State)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_NETINTERFACE_STATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Cluster(&self) -> ::windows::core::Result<ISCluster> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Cluster)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISCluster>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetInterface> for ::windows::core::IUnknown {
    fn from(value: ISClusNetInterface) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetInterface> for ::windows::core::IUnknown {
    fn from(value: &ISClusNetInterface) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusNetInterface {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusNetInterface {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetInterface> for super::super::System::Com::IDispatch {
    fn from(value: ISClusNetInterface) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetInterface> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusNetInterface) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusNetInterface {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusNetInterface {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusNetInterface {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusNetInterface {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusNetInterface {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusNetInterface {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusNetInterface").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusNetInterface {
    type Vtable = ISClusNetInterface_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606ee_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusNetInterface_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonROProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateROProperties: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    pub Handle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phandle: *mut usize) -> ::windows::core::HRESULT,
    pub State: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwstate: *mut CLUSTER_NETINTERFACE_STATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Cluster: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcluster: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Cluster: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusNetInterfaces(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusNetInterfaces {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusNetInterface> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNetInterface>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetInterfaces> for ::windows::core::IUnknown {
    fn from(value: ISClusNetInterfaces) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetInterfaces> for ::windows::core::IUnknown {
    fn from(value: &ISClusNetInterfaces) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetInterfaces> for super::super::System::Com::IDispatch {
    fn from(value: ISClusNetInterfaces) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetInterfaces> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusNetInterfaces) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusNetInterfaces {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusNetInterfaces {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusNetInterfaces {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusNetInterfaces {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusNetInterfaces").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusNetInterfaces {
    type Vtable = ISClusNetInterfaces_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f0_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusNetInterfaces_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusnetinterface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusNetwork(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusNetwork {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Handle(&self) -> ::windows::core::Result<usize> {
        let mut result__: usize = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Handle)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<usize>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrnetworkname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetName)(::core::mem::transmute_copy(self), bstrnetworkname.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NetworkID(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).NetworkID)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn State(&self) -> ::windows::core::Result<CLUSTER_NETWORK_STATE> {
        let mut result__: CLUSTER_NETWORK_STATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).State)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_NETWORK_STATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn NetInterfaces(&self) -> ::windows::core::Result<ISClusNetworkNetInterfaces> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).NetInterfaces)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNetworkNetInterfaces>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Cluster(&self) -> ::windows::core::Result<ISCluster> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Cluster)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISCluster>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetwork> for ::windows::core::IUnknown {
    fn from(value: ISClusNetwork) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetwork> for ::windows::core::IUnknown {
    fn from(value: &ISClusNetwork) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusNetwork {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusNetwork {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetwork> for super::super::System::Com::IDispatch {
    fn from(value: ISClusNetwork) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetwork> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusNetwork) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusNetwork {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusNetwork {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusNetwork {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusNetwork {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusNetwork {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusNetwork {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusNetwork").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusNetwork {
    type Vtable = ISClusNetwork_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f2_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusNetwork_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonROProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateROProperties: usize,
    pub Handle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phandle: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrnetworkname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub NetworkID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrnetworkid: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    NetworkID: usize,
    pub State: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwstate: *mut CLUSTER_NETWORK_STATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub NetInterfaces: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppclusnetinterfaces: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    NetInterfaces: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Cluster: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcluster: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Cluster: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusNetworkNetInterfaces(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusNetworkNetInterfaces {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusNetInterface> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNetInterface>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetworkNetInterfaces> for ::windows::core::IUnknown {
    fn from(value: ISClusNetworkNetInterfaces) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetworkNetInterfaces> for ::windows::core::IUnknown {
    fn from(value: &ISClusNetworkNetInterfaces) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusNetworkNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusNetworkNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetworkNetInterfaces> for super::super::System::Com::IDispatch {
    fn from(value: ISClusNetworkNetInterfaces) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetworkNetInterfaces> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusNetworkNetInterfaces) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusNetworkNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusNetworkNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusNetworkNetInterfaces {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusNetworkNetInterfaces {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusNetworkNetInterfaces {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusNetworkNetInterfaces {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusNetworkNetInterfaces").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusNetworkNetInterfaces {
    type Vtable = ISClusNetworkNetInterfaces_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f6_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusNetworkNetInterfaces_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusnetinterface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusNetworks(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusNetworks {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusNetwork> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNetwork>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetworks> for ::windows::core::IUnknown {
    fn from(value: ISClusNetworks) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetworks> for ::windows::core::IUnknown {
    fn from(value: &ISClusNetworks) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusNetworks {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusNetworks {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNetworks> for super::super::System::Com::IDispatch {
    fn from(value: ISClusNetworks) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNetworks> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusNetworks) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusNetworks {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusNetworks {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusNetworks {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusNetworks {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusNetworks {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusNetworks {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusNetworks").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusNetworks {
    type Vtable = ISClusNetworks_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f4_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusNetworks_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusnetwork: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusNode(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusNode {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Handle(&self) -> ::windows::core::Result<usize> {
        let mut result__: usize = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Handle)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<usize>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NodeID(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).NodeID)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn State(&self) -> ::windows::core::Result<CLUSTER_NODE_STATE> {
        let mut result__: CLUSTER_NODE_STATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).State)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_NODE_STATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Pause(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Pause)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Resume(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Resume)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Evict(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Evict)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ResourceGroups(&self) -> ::windows::core::Result<ISClusResGroups> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ResourceGroups)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResGroups>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Cluster(&self) -> ::windows::core::Result<ISCluster> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Cluster)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISCluster>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn NetInterfaces(&self) -> ::windows::core::Result<ISClusNodeNetInterfaces> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).NetInterfaces)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNodeNetInterfaces>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNode> for ::windows::core::IUnknown {
    fn from(value: ISClusNode) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNode> for ::windows::core::IUnknown {
    fn from(value: &ISClusNode) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusNode {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusNode {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNode> for super::super::System::Com::IDispatch {
    fn from(value: ISClusNode) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNode> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusNode) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusNode {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusNode {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusNode {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusNode {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusNode {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusNode {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusNode").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusNode {
    type Vtable = ISClusNode_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606f8_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusNode_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonROProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateROProperties: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    pub Handle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phandle: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub NodeID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrnodeid: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    NodeID: usize,
    pub State: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwstate: *mut CLUSTER_NODE_STATE) -> ::windows::core::HRESULT,
    pub Pause: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Resume: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Evict: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub ResourceGroups: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppresourcegroups: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ResourceGroups: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Cluster: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcluster: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Cluster: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub NetInterfaces: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppclusnetinterfaces: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    NetInterfaces: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusNodeNetInterfaces(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusNodeNetInterfaces {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusNetInterface> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNetInterface>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNodeNetInterfaces> for ::windows::core::IUnknown {
    fn from(value: ISClusNodeNetInterfaces) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNodeNetInterfaces> for ::windows::core::IUnknown {
    fn from(value: &ISClusNodeNetInterfaces) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusNodeNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusNodeNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNodeNetInterfaces> for super::super::System::Com::IDispatch {
    fn from(value: ISClusNodeNetInterfaces) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNodeNetInterfaces> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusNodeNetInterfaces) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusNodeNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusNodeNetInterfaces {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusNodeNetInterfaces {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusNodeNetInterfaces {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusNodeNetInterfaces {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusNodeNetInterfaces {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusNodeNetInterfaces").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusNodeNetInterfaces {
    type Vtable = ISClusNodeNetInterfaces_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606fc_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusNodeNetInterfaces_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusnetinterface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusNodes(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusNodes {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusNode> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNode>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNodes> for ::windows::core::IUnknown {
    fn from(value: ISClusNodes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNodes> for ::windows::core::IUnknown {
    fn from(value: &ISClusNodes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusNodes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusNodes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusNodes> for super::super::System::Com::IDispatch {
    fn from(value: ISClusNodes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusNodes> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusNodes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusNodes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusNodes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusNodes {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusNodes {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusNodes {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusNodes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusNodes").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusNodes {
    type Vtable = ISClusNodes_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606fa_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusNodes_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppnode: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusPartition(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusPartition {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Flags(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Flags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeviceName(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DeviceName)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn VolumeLabel(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).VolumeLabel)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn SerialNumber(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).SerialNumber)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn MaximumComponentLength(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).MaximumComponentLength)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn FileSystemFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).FileSystemFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FileSystem(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).FileSystem)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPartition> for ::windows::core::IUnknown {
    fn from(value: ISClusPartition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPartition> for ::windows::core::IUnknown {
    fn from(value: &ISClusPartition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusPartition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusPartition {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPartition> for super::super::System::Com::IDispatch {
    fn from(value: ISClusPartition) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPartition> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusPartition) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusPartition {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusPartition {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusPartition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusPartition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusPartition {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusPartition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusPartition").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusPartition {
    type Vtable = ISClusPartition_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60720_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusPartition_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Flags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plflags: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub DeviceName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrdevicename: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DeviceName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub VolumeLabel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrvolumelabel: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    VolumeLabel: usize,
    pub SerialNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plserialnumber: *mut i32) -> ::windows::core::HRESULT,
    pub MaximumComponentLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmaximumcomponentlength: *mut i32) -> ::windows::core::HRESULT,
    pub FileSystemFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plfilesystemflags: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub FileSystem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrfilesystem: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    FileSystem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusPartitionEx(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusPartitionEx {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Flags(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Flags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeviceName(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.DeviceName)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn VolumeLabel(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.VolumeLabel)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn SerialNumber(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.SerialNumber)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn MaximumComponentLength(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.MaximumComponentLength)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn FileSystemFlags(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.FileSystemFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FileSystem(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.FileSystem)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn TotalSize(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).TotalSize)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn FreeSpace(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).FreeSpace)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn DeviceNumber(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DeviceNumber)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn PartitionNumber(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PartitionNumber)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn VolumeGuid(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).VolumeGuid)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPartitionEx> for ::windows::core::IUnknown {
    fn from(value: ISClusPartitionEx) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPartitionEx> for ::windows::core::IUnknown {
    fn from(value: &ISClusPartitionEx) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusPartitionEx {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusPartitionEx {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPartitionEx> for super::super::System::Com::IDispatch {
    fn from(value: ISClusPartitionEx) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPartitionEx> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusPartitionEx) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusPartitionEx {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusPartitionEx {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPartitionEx> for ISClusPartition {
    fn from(value: ISClusPartitionEx) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPartitionEx> for ISClusPartition {
    fn from(value: &ISClusPartitionEx) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ISClusPartition> for ISClusPartitionEx {
    fn into_param(self) -> ::windows::core::Param<'a, ISClusPartition> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ISClusPartition> for &'a ISClusPartitionEx {
    fn into_param(self) -> ::windows::core::Param<'a, ISClusPartition> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusPartitionEx {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusPartitionEx {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusPartitionEx {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusPartitionEx {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusPartitionEx").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusPartitionEx {
    type Vtable = ISClusPartitionEx_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8802d4fe_b32e_4ad1_9dbd_64f18e1166ce);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusPartitionEx_Vtbl {
    pub base: ISClusPartition_Vtbl,
    pub TotalSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pltotalsize: *mut i32) -> ::windows::core::HRESULT,
    pub FreeSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plfreespace: *mut i32) -> ::windows::core::HRESULT,
    pub DeviceNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pldevicenumber: *mut i32) -> ::windows::core::HRESULT,
    pub PartitionNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plpartitionnumber: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub VolumeGuid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrvolumeguid: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    VolumeGuid: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusPartitions(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusPartitions {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusPartition> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusPartition>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPartitions> for ::windows::core::IUnknown {
    fn from(value: ISClusPartitions) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPartitions> for ::windows::core::IUnknown {
    fn from(value: &ISClusPartitions) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusPartitions {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusPartitions {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPartitions> for super::super::System::Com::IDispatch {
    fn from(value: ISClusPartitions) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPartitions> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusPartitions) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusPartitions {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusPartitions {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusPartitions {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusPartitions {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusPartitions {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusPartitions {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusPartitions").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusPartitions {
    type Vtable = ISClusPartitions_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60722_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusPartitions_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pppartition: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusProperties(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusProperties {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusProperty> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperty>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, bstrname: Param0, varvalue: Param1) -> ::windows::core::Result<ISClusProperty> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), bstrname.into_param().abi(), varvalue.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperty>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn UseDefaultValue<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UseDefaultValue)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SaveChanges(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).SaveChanges)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ReadOnly(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ReadOnly)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Private(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Private)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Common(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Common)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Modified(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Modified)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusProperties> for ::windows::core::IUnknown {
    fn from(value: ISClusProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusProperties> for ::windows::core::IUnknown {
    fn from(value: &ISClusProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusProperties {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusProperties> for super::super::System::Com::IDispatch {
    fn from(value: ISClusProperties) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusProperties> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusProperties) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusProperties {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusProperties {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusProperties {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusProperties").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusProperties {
    type Vtable = ISClusProperties_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60700_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusProperties_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusproperty: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, varvalue: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pproperty: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub UseDefaultValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    UseDefaultValue: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SaveChanges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarstatuscode: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SaveChanges: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ReadOnly: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarreadonly: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ReadOnly: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Private: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarprivate: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Private: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Common: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarcommon: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Common: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Modified: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarmodified: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Modified: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusProperty(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusProperty {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Length(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Length)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn ValueCount(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ValueCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Values(&self) -> ::windows::core::Result<ISClusPropertyValues> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Values)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusPropertyValues>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Value(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Value)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetValue<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varvalue: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetValue)(::core::mem::transmute_copy(self), varvalue.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Type(&self) -> ::windows::core::Result<CLUSTER_PROPERTY_TYPE> {
        let mut result__: CLUSTER_PROPERTY_TYPE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Type)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_PROPERTY_TYPE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn SetType(&self, r#type: CLUSTER_PROPERTY_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetType)(::core::mem::transmute_copy(self), ::core::mem::transmute(r#type)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Format(&self) -> ::windows::core::Result<CLUSTER_PROPERTY_FORMAT> {
        let mut result__: CLUSTER_PROPERTY_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Format)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_PROPERTY_FORMAT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn SetFormat(&self, format: CLUSTER_PROPERTY_FORMAT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetFormat)(::core::mem::transmute_copy(self), ::core::mem::transmute(format)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ReadOnly(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ReadOnly)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Private(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Private)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Common(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Common)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Modified(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Modified)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn UseDefaultValue(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UseDefaultValue)(::core::mem::transmute_copy(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusProperty> for ::windows::core::IUnknown {
    fn from(value: ISClusProperty) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusProperty> for ::windows::core::IUnknown {
    fn from(value: &ISClusProperty) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusProperty {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusProperty {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusProperty> for super::super::System::Com::IDispatch {
    fn from(value: ISClusProperty) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusProperty> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusProperty) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusProperty {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusProperty {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusProperty {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusProperty {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusProperty {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusProperty {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusProperty").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusProperty {
    type Vtable = ISClusProperty_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606fe_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusProperty_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    pub Length: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plength: *mut i32) -> ::windows::core::HRESULT,
    pub ValueCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Values: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppclusterpropertyvalues: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Values: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Value: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarvalue: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Value: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varvalue: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetValue: usize,
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptype: *mut CLUSTER_PROPERTY_TYPE) -> ::windows::core::HRESULT,
    pub SetType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, r#type: CLUSTER_PROPERTY_TYPE) -> ::windows::core::HRESULT,
    pub Format: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pformat: *mut CLUSTER_PROPERTY_FORMAT) -> ::windows::core::HRESULT,
    pub SetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, format: CLUSTER_PROPERTY_FORMAT) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ReadOnly: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarreadonly: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ReadOnly: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Private: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarprivate: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Private: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Common: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarcommon: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Common: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Modified: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarmodified: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Modified: usize,
    pub UseDefaultValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusPropertyValue(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusPropertyValue {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Value(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Value)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetValue<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varvalue: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetValue)(::core::mem::transmute_copy(self), varvalue.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Type(&self) -> ::windows::core::Result<CLUSTER_PROPERTY_TYPE> {
        let mut result__: CLUSTER_PROPERTY_TYPE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Type)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_PROPERTY_TYPE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn SetType(&self, r#type: CLUSTER_PROPERTY_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetType)(::core::mem::transmute_copy(self), ::core::mem::transmute(r#type)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Format(&self) -> ::windows::core::Result<CLUSTER_PROPERTY_FORMAT> {
        let mut result__: CLUSTER_PROPERTY_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Format)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_PROPERTY_FORMAT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn SetFormat(&self, format: CLUSTER_PROPERTY_FORMAT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetFormat)(::core::mem::transmute_copy(self), ::core::mem::transmute(format)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Length(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Length)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn DataCount(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DataCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Data(&self) -> ::windows::core::Result<ISClusPropertyValueData> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Data)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusPropertyValueData>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPropertyValue> for ::windows::core::IUnknown {
    fn from(value: ISClusPropertyValue) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPropertyValue> for ::windows::core::IUnknown {
    fn from(value: &ISClusPropertyValue) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusPropertyValue {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusPropertyValue {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPropertyValue> for super::super::System::Com::IDispatch {
    fn from(value: ISClusPropertyValue) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPropertyValue> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusPropertyValue) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusPropertyValue {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusPropertyValue {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusPropertyValue {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusPropertyValue {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusPropertyValue {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusPropertyValue {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusPropertyValue").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusPropertyValue {
    type Vtable = ISClusPropertyValue_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6071a_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusPropertyValue_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Value: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarvalue: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Value: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varvalue: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetValue: usize,
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptype: *mut CLUSTER_PROPERTY_TYPE) -> ::windows::core::HRESULT,
    pub SetType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, r#type: CLUSTER_PROPERTY_TYPE) -> ::windows::core::HRESULT,
    pub Format: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pformat: *mut CLUSTER_PROPERTY_FORMAT) -> ::windows::core::HRESULT,
    pub SetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, format: CLUSTER_PROPERTY_FORMAT) -> ::windows::core::HRESULT,
    pub Length: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plength: *mut i32) -> ::windows::core::HRESULT,
    pub DataCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Data: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppclusterpropertyvaluedata: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Data: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusPropertyValueData(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusPropertyValueData {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varvalue: Param0) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), varvalue.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn RemoveItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPropertyValueData> for ::windows::core::IUnknown {
    fn from(value: ISClusPropertyValueData) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPropertyValueData> for ::windows::core::IUnknown {
    fn from(value: &ISClusPropertyValueData) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusPropertyValueData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusPropertyValueData {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPropertyValueData> for super::super::System::Com::IDispatch {
    fn from(value: ISClusPropertyValueData) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPropertyValueData> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusPropertyValueData) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusPropertyValueData {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusPropertyValueData {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusPropertyValueData {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusPropertyValueData {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusPropertyValueData {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusPropertyValueData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusPropertyValueData").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusPropertyValueData {
    type Vtable = ISClusPropertyValueData_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6071e_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusPropertyValueData_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pvarvalue: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varvalue: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pvardata: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub RemoveItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    RemoveItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusPropertyValues(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusPropertyValues {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusPropertyValue> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusPropertyValue>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, bstrname: Param0, varvalue: Param1) -> ::windows::core::Result<ISClusPropertyValue> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), bstrname.into_param().abi(), varvalue.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusPropertyValue>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn RemoveItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPropertyValues> for ::windows::core::IUnknown {
    fn from(value: ISClusPropertyValues) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPropertyValues> for ::windows::core::IUnknown {
    fn from(value: &ISClusPropertyValues) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusPropertyValues {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusPropertyValues {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusPropertyValues> for super::super::System::Com::IDispatch {
    fn from(value: ISClusPropertyValues) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusPropertyValues> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusPropertyValues) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusPropertyValues {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusPropertyValues {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusPropertyValues {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusPropertyValues {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusPropertyValues {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusPropertyValues {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusPropertyValues").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusPropertyValues {
    type Vtable = ISClusPropertyValues_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6071c_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusPropertyValues_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pppropertyvalue: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, varvalue: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pppropertyvalue: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub RemoveItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    RemoveItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusRefObject(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusRefObject {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Handle(&self) -> ::windows::core::Result<usize> {
        let mut result__: usize = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Handle)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<usize>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusRefObject> for ::windows::core::IUnknown {
    fn from(value: ISClusRefObject) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusRefObject> for ::windows::core::IUnknown {
    fn from(value: &ISClusRefObject) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusRefObject {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusRefObject {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusRefObject> for super::super::System::Com::IDispatch {
    fn from(value: ISClusRefObject) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusRefObject> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusRefObject) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusRefObject {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusRefObject {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusRefObject {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusRefObject {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusRefObject {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusRefObject {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusRefObject").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusRefObject {
    type Vtable = ISClusRefObject_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60702_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusRefObject_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Handle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phandle: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusRegistryKeys(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusRegistryKeys {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrregistrykey: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddItem)(::core::mem::transmute_copy(self), bstrregistrykey.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn RemoveItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusRegistryKeys> for ::windows::core::IUnknown {
    fn from(value: ISClusRegistryKeys) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusRegistryKeys> for ::windows::core::IUnknown {
    fn from(value: &ISClusRegistryKeys) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusRegistryKeys {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusRegistryKeys {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusRegistryKeys> for super::super::System::Com::IDispatch {
    fn from(value: ISClusRegistryKeys) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusRegistryKeys> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusRegistryKeys) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusRegistryKeys {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusRegistryKeys {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusRegistryKeys {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusRegistryKeys {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusRegistryKeys {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusRegistryKeys {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusRegistryKeys").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusRegistryKeys {
    type Vtable = ISClusRegistryKeys_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6072a_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusRegistryKeys_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pbstrregistrykey: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub AddItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrregistrykey: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AddItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub RemoveItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    RemoveItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResDependencies(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResDependencies {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrresourcename: Param0, bstrresourcetype: Param1, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), bstrresourcename.into_param().abi(), bstrresourcetype.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DeleteItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddItem<'a, Param0: ::windows::core::IntoParam<'a, ISClusResource>>(&self, presource: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddItem)(::core::mem::transmute_copy(self), presource.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn RemoveItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResDependencies> for ::windows::core::IUnknown {
    fn from(value: ISClusResDependencies) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResDependencies> for ::windows::core::IUnknown {
    fn from(value: &ISClusResDependencies) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResDependencies {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResDependencies {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResDependencies> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResDependencies) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResDependencies> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResDependencies) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResDependencies {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResDependencies {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResDependencies {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResDependencies {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResDependencies {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResDependencies {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResDependencies").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResDependencies {
    type Vtable = ISClusResDependencies_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60704_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResDependencies_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrresourcename: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, bstrresourcetype: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS, ppclusterresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DeleteItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DeleteItem: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub AddItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, presource: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub RemoveItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    RemoveItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResDependents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResDependents {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrresourcename: Param0, bstrresourcetype: Param1, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), bstrresourcename.into_param().abi(), bstrresourcetype.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DeleteItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddItem<'a, Param0: ::windows::core::IntoParam<'a, ISClusResource>>(&self, presource: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddItem)(::core::mem::transmute_copy(self), presource.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn RemoveItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResDependents> for ::windows::core::IUnknown {
    fn from(value: ISClusResDependents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResDependents> for ::windows::core::IUnknown {
    fn from(value: &ISClusResDependents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResDependents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResDependents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResDependents> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResDependents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResDependents> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResDependents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResDependents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResDependents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResDependents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResDependents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResDependents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResDependents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResDependents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResDependents {
    type Vtable = ISClusResDependents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6072e_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResDependents_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrresourcename: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, bstrresourcetype: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS, ppclusterresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DeleteItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DeleteItem: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub AddItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, presource: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub RemoveItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    RemoveItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResGroup(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResGroup {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Handle(&self) -> ::windows::core::Result<usize> {
        let mut result__: usize = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Handle)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<usize>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrgroupname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetName)(::core::mem::transmute_copy(self), bstrgroupname.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn State(&self) -> ::windows::core::Result<CLUSTER_GROUP_STATE> {
        let mut result__: CLUSTER_GROUP_STATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).State)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_GROUP_STATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OwnerNode(&self) -> ::windows::core::Result<ISClusNode> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).OwnerNode)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNode>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Resources(&self) -> ::windows::core::Result<ISClusResGroupResources> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Resources)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResGroupResources>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PreferredOwnerNodes(&self) -> ::windows::core::Result<ISClusResGroupPreferredOwnerNodes> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PreferredOwnerNodes)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResGroupPreferredOwnerNodes>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Delete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Delete)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Online<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vartimeout: Param0, varnode: Param1) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Online)(::core::mem::transmute_copy(self), vartimeout.into_param().abi(), varnode.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Move<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vartimeout: Param0, varnode: Param1) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Move)(::core::mem::transmute_copy(self), vartimeout.into_param().abi(), varnode.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Offline<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vartimeout: Param0) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Offline)(::core::mem::transmute_copy(self), vartimeout.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Cluster(&self) -> ::windows::core::Result<ISCluster> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Cluster)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISCluster>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResGroup> for ::windows::core::IUnknown {
    fn from(value: ISClusResGroup) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResGroup> for ::windows::core::IUnknown {
    fn from(value: &ISClusResGroup) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResGroup {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResGroup {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResGroup> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResGroup) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResGroup> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResGroup) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResGroup {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResGroup {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResGroup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResGroup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResGroup {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResGroup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResGroup").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResGroup {
    type Vtable = ISClusResGroup_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60706_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResGroup_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonROProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateROProperties: usize,
    pub Handle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phandle: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrgroupname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetName: usize,
    pub State: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwstate: *mut CLUSTER_GROUP_STATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub OwnerNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppownernode: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OwnerNode: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Resources: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppclustergroupresources: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Resources: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PreferredOwnerNodes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppownernodes: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PreferredOwnerNodes: usize,
    pub Delete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Online: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vartimeout: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, varnode: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pvarpending: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Online: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Move: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vartimeout: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, varnode: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pvarpending: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Move: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Offline: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vartimeout: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pvarpending: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Offline: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Cluster: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcluster: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Cluster: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResGroupPreferredOwnerNodes(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResGroupPreferredOwnerNodes {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusNode> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNode>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn InsertItem<'a, Param0: ::windows::core::IntoParam<'a, ISClusNode>>(&self, pnode: Param0, nposition: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InsertItem)(::core::mem::transmute_copy(self), pnode.into_param().abi(), ::core::mem::transmute(nposition)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn RemoveItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Modified(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Modified)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn SaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SaveChanges)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddItem<'a, Param0: ::windows::core::IntoParam<'a, ISClusNode>>(&self, pnode: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddItem)(::core::mem::transmute_copy(self), pnode.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResGroupPreferredOwnerNodes> for ::windows::core::IUnknown {
    fn from(value: ISClusResGroupPreferredOwnerNodes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResGroupPreferredOwnerNodes> for ::windows::core::IUnknown {
    fn from(value: &ISClusResGroupPreferredOwnerNodes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResGroupPreferredOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResGroupPreferredOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResGroupPreferredOwnerNodes> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResGroupPreferredOwnerNodes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResGroupPreferredOwnerNodes> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResGroupPreferredOwnerNodes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResGroupPreferredOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResGroupPreferredOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResGroupPreferredOwnerNodes {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResGroupPreferredOwnerNodes {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResGroupPreferredOwnerNodes {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResGroupPreferredOwnerNodes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResGroupPreferredOwnerNodes").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResGroupPreferredOwnerNodes {
    type Vtable = ISClusResGroupPreferredOwnerNodes_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606e8_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResGroupPreferredOwnerNodes_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppnode: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub InsertItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnode: ::windows::core::RawPtr, nposition: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    InsertItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub RemoveItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    RemoveItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Modified: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarmodified: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Modified: usize,
    pub SaveChanges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub AddItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnode: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResGroupResources(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResGroupResources {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrresourcename: Param0, bstrresourcetype: Param1, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), bstrresourcename.into_param().abi(), bstrresourcetype.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DeleteItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResGroupResources> for ::windows::core::IUnknown {
    fn from(value: ISClusResGroupResources) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResGroupResources> for ::windows::core::IUnknown {
    fn from(value: &ISClusResGroupResources) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResGroupResources {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResGroupResources {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResGroupResources> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResGroupResources) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResGroupResources> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResGroupResources) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResGroupResources {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResGroupResources {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResGroupResources {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResGroupResources {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResGroupResources {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResGroupResources {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResGroupResources").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResGroupResources {
    type Vtable = ISClusResGroupResources_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606ea_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResGroupResources_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrresourcename: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, bstrresourcetype: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS, ppclusterresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DeleteItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DeleteItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResGroups(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResGroups {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusResGroup> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResGroup>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrresourcegroupname: Param0) -> ::windows::core::Result<ISClusResGroup> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), bstrresourcegroupname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResGroup>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DeleteItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResGroups> for ::windows::core::IUnknown {
    fn from(value: ISClusResGroups) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResGroups> for ::windows::core::IUnknown {
    fn from(value: &ISClusResGroups) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResGroups {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResGroups {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResGroups> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResGroups) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResGroups> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResGroups) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResGroups {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResGroups {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResGroups {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResGroups {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResGroups {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResGroups {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResGroups").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResGroups {
    type Vtable = ISClusResGroups_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60708_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResGroups_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusresgroup: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrresourcegroupname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, ppresourcegroup: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DeleteItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DeleteItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResPossibleOwnerNodes(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResPossibleOwnerNodes {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusNode> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNode>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddItem<'a, Param0: ::windows::core::IntoParam<'a, ISClusNode>>(&self, pnode: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddItem)(::core::mem::transmute_copy(self), pnode.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn RemoveItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Modified(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Modified)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResPossibleOwnerNodes> for ::windows::core::IUnknown {
    fn from(value: ISClusResPossibleOwnerNodes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResPossibleOwnerNodes> for ::windows::core::IUnknown {
    fn from(value: &ISClusResPossibleOwnerNodes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResPossibleOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResPossibleOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResPossibleOwnerNodes> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResPossibleOwnerNodes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResPossibleOwnerNodes> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResPossibleOwnerNodes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResPossibleOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResPossibleOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResPossibleOwnerNodes {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResPossibleOwnerNodes {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResPossibleOwnerNodes {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResPossibleOwnerNodes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResPossibleOwnerNodes").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResPossibleOwnerNodes {
    type Vtable = ISClusResPossibleOwnerNodes_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6070e_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResPossibleOwnerNodes_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppnode: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub AddItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnode: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub RemoveItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    RemoveItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Modified: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarmodified: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Modified: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResType(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResType {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Delete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Delete)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Cluster(&self) -> ::windows::core::Result<ISCluster> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Cluster)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISCluster>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Resources(&self) -> ::windows::core::Result<ISClusResTypeResources> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Resources)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResTypeResources>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PossibleOwnerNodes(&self) -> ::windows::core::Result<ISClusResTypePossibleOwnerNodes> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PossibleOwnerNodes)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResTypePossibleOwnerNodes>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AvailableDisks(&self) -> ::windows::core::Result<ISClusDisks> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).AvailableDisks)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusDisks>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResType> for ::windows::core::IUnknown {
    fn from(value: ISClusResType) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResType> for ::windows::core::IUnknown {
    fn from(value: &ISClusResType) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResType {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResType {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResType> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResType) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResType> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResType) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResType {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResType {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResType {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResType {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResType {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResType").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResType {
    type Vtable = ISClusResType_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60710_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResType_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonROProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateROProperties: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    pub Delete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Cluster: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcluster: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Cluster: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Resources: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppclusterrestyperesources: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Resources: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PossibleOwnerNodes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppownernodes: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PossibleOwnerNodes: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub AvailableDisks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppavailabledisks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AvailableDisks: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResTypePossibleOwnerNodes(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResTypePossibleOwnerNodes {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusNode> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNode>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResTypePossibleOwnerNodes> for ::windows::core::IUnknown {
    fn from(value: ISClusResTypePossibleOwnerNodes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResTypePossibleOwnerNodes> for ::windows::core::IUnknown {
    fn from(value: &ISClusResTypePossibleOwnerNodes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResTypePossibleOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResTypePossibleOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResTypePossibleOwnerNodes> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResTypePossibleOwnerNodes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResTypePossibleOwnerNodes> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResTypePossibleOwnerNodes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResTypePossibleOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResTypePossibleOwnerNodes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResTypePossibleOwnerNodes {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResTypePossibleOwnerNodes {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResTypePossibleOwnerNodes {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResTypePossibleOwnerNodes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResTypePossibleOwnerNodes").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResTypePossibleOwnerNodes {
    type Vtable = ISClusResTypePossibleOwnerNodes_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60718_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResTypePossibleOwnerNodes_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppnode: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResTypeResources(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResTypeResources {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrresourcename: Param0, bstrgroupname: Param1, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), bstrresourcename.into_param().abi(), bstrgroupname.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DeleteItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResTypeResources> for ::windows::core::IUnknown {
    fn from(value: ISClusResTypeResources) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResTypeResources> for ::windows::core::IUnknown {
    fn from(value: &ISClusResTypeResources) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResTypeResources {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResTypeResources {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResTypeResources> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResTypeResources) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResTypeResources> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResTypeResources) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResTypeResources {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResTypeResources {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResTypeResources {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResTypeResources {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResTypeResources {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResTypeResources {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResTypeResources").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResTypeResources {
    type Vtable = ISClusResTypeResources_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60714_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResTypeResources_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrresourcename: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, bstrgroupname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS, ppclusterresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DeleteItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DeleteItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResTypes(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResTypes {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusResType> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResType>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrresourcetypename: Param0, bstrdisplayname: Param1, bstrresourcetypedll: Param2, dwlooksalivepollinterval: i32, dwisalivepollinterval: i32) -> ::windows::core::Result<ISClusResType> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), bstrresourcetypename.into_param().abi(), bstrdisplayname.into_param().abi(), bstrresourcetypedll.into_param().abi(), ::core::mem::transmute(dwlooksalivepollinterval), ::core::mem::transmute(dwisalivepollinterval), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResType>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DeleteItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResTypes> for ::windows::core::IUnknown {
    fn from(value: ISClusResTypes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResTypes> for ::windows::core::IUnknown {
    fn from(value: &ISClusResTypes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResTypes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResTypes {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResTypes> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResTypes) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResTypes> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResTypes) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResTypes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResTypes {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResTypes {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResTypes {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResTypes {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResTypes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResTypes").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResTypes {
    type Vtable = ISClusResTypes_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60712_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResTypes_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusrestype: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrresourcetypename: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, bstrdisplayname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, bstrresourcetypedll: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, dwlooksalivepollinterval: i32, dwisalivepollinterval: i32, ppresourcetype: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DeleteItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DeleteItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResource(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResource {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Handle(&self) -> ::windows::core::Result<usize> {
        let mut result__: usize = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Handle)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<usize>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrresourcename: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetName)(::core::mem::transmute_copy(self), bstrresourcename.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn State(&self) -> ::windows::core::Result<CLUSTER_RESOURCE_STATE> {
        let mut result__: CLUSTER_RESOURCE_STATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).State)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_RESOURCE_STATE>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn CoreFlag(&self) -> ::windows::core::Result<CLUS_FLAGS> {
        let mut result__: CLUS_FLAGS = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CoreFlag)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUS_FLAGS>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BecomeQuorumResource<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrdevicepath: Param0, lmaxlogsize: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).BecomeQuorumResource)(::core::mem::transmute_copy(self), bstrdevicepath.into_param().abi(), ::core::mem::transmute(lmaxlogsize)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Delete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Delete)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Fail(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Fail)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Online(&self, ntimeout: i32) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Online)(::core::mem::transmute_copy(self), ::core::mem::transmute(ntimeout), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Offline(&self, ntimeout: i32) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Offline)(::core::mem::transmute_copy(self), ::core::mem::transmute(ntimeout), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ChangeResourceGroup<'a, Param0: ::windows::core::IntoParam<'a, ISClusResGroup>>(&self, presourcegroup: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ChangeResourceGroup)(::core::mem::transmute_copy(self), presourcegroup.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddResourceNode<'a, Param0: ::windows::core::IntoParam<'a, ISClusNode>>(&self, pnode: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddResourceNode)(::core::mem::transmute_copy(self), pnode.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveResourceNode<'a, Param0: ::windows::core::IntoParam<'a, ISClusNode>>(&self, pnode: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveResourceNode)(::core::mem::transmute_copy(self), pnode.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CanResourceBeDependent<'a, Param0: ::windows::core::IntoParam<'a, ISClusResource>>(&self, presource: Param0) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CanResourceBeDependent)(::core::mem::transmute_copy(self), presource.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PossibleOwnerNodes(&self) -> ::windows::core::Result<ISClusResPossibleOwnerNodes> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PossibleOwnerNodes)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResPossibleOwnerNodes>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Dependencies(&self) -> ::windows::core::Result<ISClusResDependencies> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Dependencies)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResDependencies>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Dependents(&self) -> ::windows::core::Result<ISClusResDependents> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Dependents)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResDependents>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Group(&self) -> ::windows::core::Result<ISClusResGroup> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Group)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResGroup>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OwnerNode(&self) -> ::windows::core::Result<ISClusNode> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).OwnerNode)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNode>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Cluster(&self) -> ::windows::core::Result<ISCluster> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Cluster)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISCluster>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn ClassInfo(&self) -> ::windows::core::Result<CLUSTER_RESOURCE_CLASS> {
        let mut result__: CLUSTER_RESOURCE_CLASS = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ClassInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<CLUSTER_RESOURCE_CLASS>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Disk(&self) -> ::windows::core::Result<ISClusDisk> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Disk)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusDisk>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RegistryKeys(&self) -> ::windows::core::Result<ISClusRegistryKeys> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).RegistryKeys)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusRegistryKeys>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CryptoKeys(&self) -> ::windows::core::Result<ISClusCryptoKeys> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CryptoKeys)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusCryptoKeys>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn TypeName(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).TypeName)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Type(&self) -> ::windows::core::Result<ISClusResType> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Type)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResType>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MaintenanceMode(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).MaintenanceMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMaintenanceMode<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, bmaintenancemode: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetMaintenanceMode)(::core::mem::transmute_copy(self), bmaintenancemode.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResource> for ::windows::core::IUnknown {
    fn from(value: ISClusResource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResource> for ::windows::core::IUnknown {
    fn from(value: &ISClusResource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResource {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResource> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResource) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResource> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResource) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResource {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResource {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResource {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResource").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResource {
    type Vtable = ISClusResource_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6070a_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResource_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonROProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateROProperties: usize,
    pub Handle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phandle: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrresourcename: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetName: usize,
    pub State: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwstate: *mut CLUSTER_RESOURCE_STATE) -> ::windows::core::HRESULT,
    pub CoreFlag: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcoreflag: *mut CLUS_FLAGS) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub BecomeQuorumResource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdevicepath: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, lmaxlogsize: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    BecomeQuorumResource: usize,
    pub Delete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Fail: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Online: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ntimeout: i32, pvarpending: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Online: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Offline: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ntimeout: i32, pvarpending: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Offline: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ChangeResourceGroup: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, presourcegroup: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ChangeResourceGroup: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub AddResourceNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnode: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddResourceNode: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RemoveResourceNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnode: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RemoveResourceNode: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CanResourceBeDependent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, presource: ::windows::core::RawPtr, pvardependent: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CanResourceBeDependent: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PossibleOwnerNodes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppownernodes: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PossibleOwnerNodes: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Dependencies: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppresdependencies: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Dependencies: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Dependents: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppresdependents: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Dependents: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Group: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppresgroup: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Group: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub OwnerNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppownernode: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OwnerNode: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Cluster: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcluster: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Cluster: usize,
    pub ClassInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prcclassinfo: *mut CLUSTER_RESOURCE_CLASS) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Disk: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdisk: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Disk: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RegistryKeys: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppregistrykeys: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RegistryKeys: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CryptoKeys: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcryptokeys: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CryptoKeys: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub TypeName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrtypename: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    TypeName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppresourcetype: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Type: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub MaintenanceMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbmaintenancemode: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    MaintenanceMode: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetMaintenanceMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bmaintenancemode: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetMaintenanceMode: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusResources(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusResources {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrresourcename: Param0, bstrresourcetype: Param1, bstrgroupname: Param2, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateItem)(::core::mem::transmute_copy(self), bstrresourcename.into_param().abi(), bstrresourcetype.into_param().abi(), bstrgroupname.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DeleteItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DeleteItem)(::core::mem::transmute_copy(self), varindex.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResources> for ::windows::core::IUnknown {
    fn from(value: ISClusResources) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResources> for ::windows::core::IUnknown {
    fn from(value: &ISClusResources) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusResources {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusResources {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusResources> for super::super::System::Com::IDispatch {
    fn from(value: ISClusResources) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusResources> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusResources) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusResources {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusResources {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusResources {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusResources {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusResources {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusResources {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusResources").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusResources {
    type Vtable = ISClusResources_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e6070c_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusResources_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppclusresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CreateItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrresourcename: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, bstrresourcetype: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, bstrgroupname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, dwflags: CLUSTER_RESOURCE_CREATE_FLAGS, ppclusterresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CreateItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DeleteItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DeleteItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusScsiAddress(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusScsiAddress {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn PortNumber(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PortNumber)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn PathId(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PathId)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn TargetId(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).TargetId)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Lun(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Lun)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusScsiAddress> for ::windows::core::IUnknown {
    fn from(value: ISClusScsiAddress) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusScsiAddress> for ::windows::core::IUnknown {
    fn from(value: &ISClusScsiAddress) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusScsiAddress {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusScsiAddress {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusScsiAddress> for super::super::System::Com::IDispatch {
    fn from(value: ISClusScsiAddress) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusScsiAddress> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusScsiAddress) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusScsiAddress {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusScsiAddress {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusScsiAddress {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusScsiAddress {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusScsiAddress {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusScsiAddress {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusScsiAddress").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusScsiAddress {
    type Vtable = ISClusScsiAddress_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60728_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusScsiAddress_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub PortNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarportnumber: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    PortNumber: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub PathId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarpathid: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    PathId: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub TargetId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvartargetid: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    TargetId: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Lun: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarlun: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Lun: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusVersion(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusVersion {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn MajorVersion(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).MajorVersion)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn MinorVersion(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).MinorVersion)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn BuildNumber(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).BuildNumber)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn VendorId(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).VendorId)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CSDVersion(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CSDVersion)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn ClusterHighestVersion(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ClusterHighestVersion)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn ClusterLowestVersion(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ClusterLowestVersion)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Flags(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Flags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MixedVersion(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).MixedVersion)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusVersion> for ::windows::core::IUnknown {
    fn from(value: ISClusVersion) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusVersion> for ::windows::core::IUnknown {
    fn from(value: &ISClusVersion) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusVersion {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusVersion {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusVersion> for super::super::System::Com::IDispatch {
    fn from(value: ISClusVersion) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusVersion> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusVersion) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusVersion {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusVersion {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusVersion {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusVersion {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusVersion {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusVersion {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusVersion").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusVersion {
    type Vtable = ISClusVersion_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e60716_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusVersion_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrclustername: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    pub MajorVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnmajorversion: *mut i32) -> ::windows::core::HRESULT,
    pub MinorVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnminorversion: *mut i32) -> ::windows::core::HRESULT,
    pub BuildNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnbuildnumber: *mut i16) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub VendorId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrvendorid: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    VendorId: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub CSDVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcsdversion: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CSDVersion: usize,
    pub ClusterHighestVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnclusterhighestversion: *mut i32) -> ::windows::core::HRESULT,
    pub ClusterLowestVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnclusterlowestversion: *mut i32) -> ::windows::core::HRESULT,
    pub Flags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnflags: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub MixedVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarmixedversion: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    MixedVersion: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISCluster(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISCluster {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CommonROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CommonROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PrivateROProperties(&self) -> ::windows::core::Result<ISClusProperties> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).PrivateROProperties)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusProperties>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Handle(&self) -> ::windows::core::Result<usize> {
        let mut result__: usize = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Handle)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<usize>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Open<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrclustername: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Open)(::core::mem::transmute_copy(self), bstrclustername.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrclustername: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetName)(::core::mem::transmute_copy(self), bstrclustername.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Version(&self) -> ::windows::core::Result<ISClusVersion> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Version)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusVersion>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetQuorumResource<'a, Param0: ::windows::core::IntoParam<'a, ISClusResource>>(&self, pclusterresource: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetQuorumResource)(::core::mem::transmute_copy(self), pclusterresource.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn QuorumResource(&self) -> ::windows::core::Result<ISClusResource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).QuorumResource)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResource>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn QuorumLogSize(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).QuorumLogSize)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn SetQuorumLogSize(&self, nlogsize: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetQuorumLogSize)(::core::mem::transmute_copy(self), ::core::mem::transmute(nlogsize)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QuorumPath(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).QuorumPath)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetQuorumPath<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, ppath: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetQuorumPath)(::core::mem::transmute_copy(self), ppath.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Nodes(&self) -> ::windows::core::Result<ISClusNodes> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Nodes)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNodes>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ResourceGroups(&self) -> ::windows::core::Result<ISClusResGroups> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ResourceGroups)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResGroups>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Resources(&self) -> ::windows::core::Result<ISClusResources> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Resources)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResources>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ResourceTypes(&self) -> ::windows::core::Result<ISClusResTypes> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ResourceTypes)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusResTypes>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Networks(&self) -> ::windows::core::Result<ISClusNetworks> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Networks)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNetworks>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn NetInterfaces(&self) -> ::windows::core::Result<ISClusNetInterfaces> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).NetInterfaces)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ISClusNetInterfaces>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISCluster> for ::windows::core::IUnknown {
    fn from(value: ISCluster) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISCluster> for ::windows::core::IUnknown {
    fn from(value: &ISCluster) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISCluster {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISCluster {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISCluster> for super::super::System::Com::IDispatch {
    fn from(value: ISCluster) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISCluster> for super::super::System::Com::IDispatch {
    fn from(value: &ISCluster) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISCluster {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISCluster {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISCluster {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISCluster {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISCluster {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISCluster {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISCluster").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISCluster {
    type Vtable = ISCluster_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606e4_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISCluster_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CommonROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CommonROProperties: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PrivateROProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppproperties: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PrivateROProperties: usize,
    pub Handle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phandle: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Open: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrclustername: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Open: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrclustername: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Version: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppclusversion: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Version: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub SetQuorumResource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclusterresource: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetQuorumResource: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub QuorumResource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclusterresource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    QuorumResource: usize,
    pub QuorumLogSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnlogsize: *mut i32) -> ::windows::core::HRESULT,
    pub SetQuorumLogSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nlogsize: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub QuorumPath: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pppath: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QuorumPath: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetQuorumPath: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppath: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetQuorumPath: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Nodes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppnodes: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Nodes: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ResourceGroups: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppclusterresourcegroups: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ResourceGroups: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Resources: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppclusterresources: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Resources: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ResourceTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppresourcetypes: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ResourceTypes: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Networks: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppnetworks: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Networks: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub NetInterfaces: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppnetinterfaces: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    NetInterfaces: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISClusterNames(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISClusterNames {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DomainName(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).DomainName)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusterNames> for ::windows::core::IUnknown {
    fn from(value: ISClusterNames) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusterNames> for ::windows::core::IUnknown {
    fn from(value: &ISClusterNames) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISClusterNames {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISClusterNames {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISClusterNames> for super::super::System::Com::IDispatch {
    fn from(value: ISClusterNames) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISClusterNames> for super::super::System::Com::IDispatch {
    fn from(value: &ISClusterNames) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISClusterNames {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISClusterNames {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISClusterNames {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISClusterNames {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISClusterNames {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISClusterNames {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISClusterNames").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISClusterNames {
    type Vtable = ISClusterNames_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606ec_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISClusterNames_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pbstrclustername: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub DomainName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrdomainname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DomainName: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ISDomainNames(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ISDomainNames {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn Refresh(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Refresh)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, varindex: Param0) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), varindex.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISDomainNames> for ::windows::core::IUnknown {
    fn from(value: ISDomainNames) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISDomainNames> for ::windows::core::IUnknown {
    fn from(value: &ISDomainNames) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ISDomainNames {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a ISDomainNames {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<ISDomainNames> for super::super::System::Com::IDispatch {
    fn from(value: ISDomainNames) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&ISDomainNames> for super::super::System::Com::IDispatch {
    fn from(value: &ISDomainNames) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for ISDomainNames {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &'a ISDomainNames {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ISDomainNames {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ISDomainNames {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ISDomainNames {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ISDomainNames {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISDomainNames").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ISDomainNames {
    type Vtable = ISDomainNames_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2e606e2_2631_11d1_89f1_00a0c90d061e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ISDomainNames_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, retval: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varindex: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, pbstrdomainname: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IWCContextMenuCallback(::windows::core::IUnknown);
impl IWCContextMenuCallback {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`, `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddExtensionMenuItem<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, lpszname: Param0, lpszstatusbartext: Param1, ncommandid: u32, nsubmenucommandid: u32, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddExtensionMenuItem)(::core::mem::transmute_copy(self), lpszname.into_param().abi(), lpszstatusbartext.into_param().abi(), ::core::mem::transmute(ncommandid), ::core::mem::transmute(nsubmenucommandid), ::core::mem::transmute(uflags)).ok()
    }
}
impl ::core::convert::From<IWCContextMenuCallback> for ::windows::core::IUnknown {
    fn from(value: IWCContextMenuCallback) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IWCContextMenuCallback> for ::windows::core::IUnknown {
    fn from(value: &IWCContextMenuCallback) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IWCContextMenuCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &'a IWCContextMenuCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IWCContextMenuCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IWCContextMenuCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IWCContextMenuCallback {}
impl ::core::fmt::Debug for IWCContextMenuCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IWCContextMenuCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IWCContextMenuCallback {
    type Vtable = IWCContextMenuCallback_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x97dede64_fc6b_11cf_b5f5_00a0c90ab505);
}
#[repr(C)]
#[doc(hidden)]
pub struct IWCContextMenuCallback_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub AddExtensionMenuItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpszname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, lpszstatusbartext: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, ncommandid: u32, nsubmenucommandid: u32, uflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AddExtensionMenuItem: usize,
}
#[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
#[repr(transparent)]
pub struct IWCPropertySheetCallback(::windows::core::IUnknown);
impl IWCPropertySheetCallback {
    #[doc = "*Required features: `\"Win32_Networking_Clustering\"`*"]
    pub unsafe fn AddPropertySheetPage(&self, hpage: *const i32) -> ::wi