//! An example of using the simple API.

extern crate repng;

use std::fs::File;

fn main() {
    const TAU: f64 = 6.28319;
    const THIRD: f64 = TAU / 3.0;

    let width = 100;
    let height = 100;
    let mut rainbow = vec![0; width * height * 4];

    for y in 0..height {
        for x in 0..width {
            let off = 4 * (y * width + x);
            let del = TAU * (x + y) as f64 / (width + height) as f64;

            let r = ((del + 0.0 * THIRD).cos() + 1.0) * 127.5;
            let g = ((del + 1.0 * THIRD).cos() + 1.0) * 127.5;
            let b = ((del + 2.0 * THIRD).cos() + 1.0) * 127.5;

            rainbow[off + 0] = r as u8;
            rainbow[off + 1] = g as u8;
            rainbow[off + 2] = b as u8;
            rainbow[off + 3] = 255;
        }
    }

    repng::encode(
        File::create("rainbow.png").unwrap(),
        width as u32,
        height as u32,
        &rainbow,
    ).unwrap();
}
