//! An example of using the slightly more complicated API.

extern crate repng;

use repng::{Options, meta};
use std::fs::File;

fn main() {
    let mut enc = Options::smallest(480, 360)
        .build(File::create("flag.png").unwrap())
        .unwrap();

    meta::text(
        &mut enc,
        meta::Keyword::Author,
        "Ram Kaniyur",
    ).unwrap();

    let mut row = [255; 480 * 4];

    for x in 0..480 {
        let i = x * 4;

        if x < 160 {
            row[i] = 0;
        } else if x < 320 {
            row[i + 1] = 0;
        } else {
            row[i + 2] = 0;
        }
    }

    for _y in 0..360 {
        enc.write(&row).unwrap();
    }

    enc.finish().unwrap();
}
