"use strict";
/**
  * @reach/portal v0.18.0
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/reach-portal.tsx
var reach_portal_exports = {};
__export(reach_portal_exports, {
  Portal: () => Portal
});
module.exports = __toCommonJS(reach_portal_exports);
var React = __toESM(require("react"));
var import_utils = require("@reach/utils");
var import_react_dom = require("react-dom");
var PortalImpl = ({
  children,
  type = "reach-portal",
  containerRef
}) => {
  let mountNode = React.useRef(null);
  let portalNode = React.useRef(null);
  let forceUpdate = (0, import_utils.useForceUpdate)();
  if (true) {
    React.useEffect(() => {
      if (containerRef != null) {
        if (typeof containerRef !== "object" || !("current" in containerRef)) {
          console.warn("@reach/portal: Invalid value passed to the `containerRef` of a `Portal`. The portal will be appended to the document body, but if you want to attach it to another DOM node you must pass a valid React ref object to `containerRef`.");
        } else if (containerRef.current == null) {
          console.warn("@reach/portal: A ref was passed to the `containerRef` prop of a `Portal`, but no DOM node was attached to it. Be sure to pass the ref to a DOM component.\n\nIf you are forwarding the ref from another component, be sure to use the React.forwardRef API. See https://reactjs.org/docs/forwarding-refs.html.");
        }
      }
    }, [containerRef]);
  }
  (0, import_utils.useIsomorphicLayoutEffect)(() => {
    if (!mountNode.current)
      return;
    let ownerDocument = mountNode.current.ownerDocument;
    let body = (containerRef == null ? void 0 : containerRef.current) || ownerDocument.body;
    portalNode.current = ownerDocument == null ? void 0 : ownerDocument.createElement(type);
    body.appendChild(portalNode.current);
    forceUpdate();
    return () => {
      if (portalNode.current && body) {
        body.removeChild(portalNode.current);
      }
    };
  }, [type, forceUpdate, containerRef]);
  return portalNode.current ? (0, import_react_dom.createPortal)(children, portalNode.current) : /* @__PURE__ */ React.createElement("span", {
    ref: mountNode
  });
};
var Portal = (_a) => {
  var _b = _a, {
    unstable_skipInitialRender
  } = _b, props = __objRest(_b, [
    "unstable_skipInitialRender"
  ]);
  let [hydrated, setHydrated] = React.useState(false);
  React.useEffect(() => {
    if (unstable_skipInitialRender) {
      setHydrated(true);
    }
  }, [unstable_skipInitialRender]);
  if (unstable_skipInitialRender && !hydrated) {
    return null;
  }
  return /* @__PURE__ */ React.createElement(PortalImpl, __spreadValues({}, props));
};
Portal.displayName = "Portal";
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Portal
});
//# sourceMappingURL=reach-portal.cjs.dev.js.map