# Shared Params Types

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ChatModel">ChatModel</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ComparisonFilterParam">ComparisonFilterParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#CompoundFilterParam">CompoundFilterParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#CustomToolInputFormatUnionParam">CustomToolInputFormatUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#FunctionDefinitionParam">FunctionDefinitionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#FunctionParameters">FunctionParameters</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#Metadata">Metadata</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ReasoningParam">ReasoningParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ReasoningEffort">ReasoningEffort</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ResponseFormatJSONObjectParam">ResponseFormatJSONObjectParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ResponseFormatJSONSchemaParam">ResponseFormatJSONSchemaParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ResponseFormatTextParam">ResponseFormatTextParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ResponsesModel">ResponsesModel</a>

# Shared Response Types

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ChatModel">ChatModel</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ComparisonFilter">ComparisonFilter</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#CompoundFilter">CompoundFilter</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#CustomToolInputFormatUnion">CustomToolInputFormatUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ErrorObject">ErrorObject</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#FunctionDefinition">FunctionDefinition</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#FunctionParameters">FunctionParameters</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#Metadata">Metadata</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#Reasoning">Reasoning</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ReasoningEffort">ReasoningEffort</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ResponseFormatJSONObject">ResponseFormatJSONObject</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ResponseFormatJSONSchema">ResponseFormatJSONSchema</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ResponseFormatText">ResponseFormatText</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared">shared</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/shared#ResponsesModel">ResponsesModel</a>

# Completions

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Completion">Completion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CompletionChoice">CompletionChoice</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CompletionUsage">CompletionUsage</a>

Methods:

- <code title="post /completions">client.Completions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CompletionService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CompletionNewParams">CompletionNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Completion">Completion</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Chat

## Completions

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionAllowedToolChoiceParam">ChatCompletionAllowedToolChoiceParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionAssistantMessageParam">ChatCompletionAssistantMessageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionAudioParam">ChatCompletionAudioParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionContentPartUnionParam">ChatCompletionContentPartUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionContentPartImageParam">ChatCompletionContentPartImageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionContentPartInputAudioParam">ChatCompletionContentPartInputAudioParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionContentPartRefusalParam">ChatCompletionContentPartRefusalParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionContentPartTextParam">ChatCompletionContentPartTextParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionCustomToolParam">ChatCompletionCustomToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionDeveloperMessageParam">ChatCompletionDeveloperMessageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionFunctionCallOptionParam">ChatCompletionFunctionCallOptionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionFunctionMessageParam">ChatCompletionFunctionMessageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionFunctionToolParam">ChatCompletionFunctionToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessageCustomToolCallParam">ChatCompletionMessageCustomToolCallParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessageFunctionToolCallParam">ChatCompletionMessageFunctionToolCallParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessageParamUnion">ChatCompletionMessageParamUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessageToolCallUnionParam">ChatCompletionMessageToolCallUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionNamedToolChoiceParam">ChatCompletionNamedToolChoiceParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionNamedToolChoiceCustomParam">ChatCompletionNamedToolChoiceCustomParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionPredictionContentParam">ChatCompletionPredictionContentParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionStreamOptionsParam">ChatCompletionStreamOptionsParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionSystemMessageParam">ChatCompletionSystemMessageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionToolUnionParam">ChatCompletionToolUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionToolChoiceOptionUnionParam">ChatCompletionToolChoiceOptionUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionToolMessageParam">ChatCompletionToolMessageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionUserMessageParam">ChatCompletionUserMessageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionAllowedToolsParam">ChatCompletionAllowedToolsParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletion">ChatCompletion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionAudio">ChatCompletionAudio</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionChunk">ChatCompletionChunk</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionContentPartImage">ChatCompletionContentPartImage</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionContentPartText">ChatCompletionContentPartText</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionDeleted">ChatCompletionDeleted</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessage">ChatCompletionMessage</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessageCustomToolCall">ChatCompletionMessageCustomToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessageFunctionToolCall">ChatCompletionMessageFunctionToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessageToolCallUnion">ChatCompletionMessageToolCallUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionStoreMessage">ChatCompletionStoreMessage</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionTokenLogprob">ChatCompletionTokenLogprob</a>

Methods:

- <code title="post /chat/completions">client.Chat.Completions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionNewParams">ChatCompletionNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletion">ChatCompletion</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /chat/completions/{completion_id}">client.Chat.Completions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, completionID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletion">ChatCompletion</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /chat/completions/{completion_id}">client.Chat.Completions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionService.Update">Update</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, completionID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionUpdateParams">ChatCompletionUpdateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletion">ChatCompletion</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /chat/completions">client.Chat.Completions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionListParams">ChatCompletionListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletion">ChatCompletion</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /chat/completions/{completion_id}">client.Chat.Completions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, completionID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionDeleted">ChatCompletionDeleted</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

### Messages

Methods:

- <code title="get /chat/completions/{completion_id}/messages">client.Chat.Completions.Messages.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessageService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, completionID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionMessageListParams">ChatCompletionMessageListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ChatCompletionStoreMessage">ChatCompletionStoreMessage</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Embeddings

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#EmbeddingModel">EmbeddingModel</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CreateEmbeddingResponse">CreateEmbeddingResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Embedding">Embedding</a>

Methods:

- <code title="post /embeddings">client.Embeddings.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#EmbeddingService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#EmbeddingNewParams">EmbeddingNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CreateEmbeddingResponse">CreateEmbeddingResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Files

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FilePurpose">FilePurpose</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileDeleted">FileDeleted</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileObject">FileObject</a>

Methods:

- <code title="post /files">client.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileNewParams">FileNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileObject">FileObject</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /files/{file_id}">client.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileObject">FileObject</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /files">client.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileListParams">FileListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileObject">FileObject</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /files/{file_id}">client.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileDeleted">FileDeleted</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /files/{file_id}/content">client.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileService.Content">Content</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>) (http.Response, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Images

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageModel">ImageModel</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Image">Image</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageEditCompletedEvent">ImageEditCompletedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageEditPartialImageEvent">ImageEditPartialImageEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageEditStreamEventUnion">ImageEditStreamEventUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageGenCompletedEvent">ImageGenCompletedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageGenPartialImageEvent">ImageGenPartialImageEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageGenStreamEventUnion">ImageGenStreamEventUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImagesResponse">ImagesResponse</a>

Methods:

- <code title="post /images/variations">client.Images.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageService.NewVariation">NewVariation</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageNewVariationParams">ImageNewVariationParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImagesResponse">ImagesResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /images/edits">client.Images.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageService.Edit">Edit</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageEditParams">ImageEditParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImagesResponse">ImagesResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /images/generations">client.Images.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageService.Generate">Generate</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageGenerateParams">ImageGenerateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImagesResponse">ImagesResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Audio

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AudioModel">AudioModel</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AudioResponseFormat">AudioResponseFormat</a>

## Transcriptions

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TranscriptionInclude">TranscriptionInclude</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Transcription">Transcription</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TranscriptionStreamEventUnion">TranscriptionStreamEventUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TranscriptionTextDeltaEvent">TranscriptionTextDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TranscriptionTextDoneEvent">TranscriptionTextDoneEvent</a>

Methods:

- <code title="post /audio/transcriptions">client.Audio.Transcriptions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AudioTranscriptionService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AudioTranscriptionNewParams">AudioTranscriptionNewParams</a>) (Transcription, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## Translations

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Translation">Translation</a>

Methods:

- <code title="post /audio/translations">client.Audio.Translations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AudioTranslationService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AudioTranslationNewParams">AudioTranslationNewParams</a>) (Translation, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## Speech

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#SpeechModel">SpeechModel</a>

Methods:

- <code title="post /audio/speech">client.Audio.Speech.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AudioSpeechService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AudioSpeechNewParams">AudioSpeechNewParams</a>) (http.Response, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Moderations

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModerationImageURLInputParam">ModerationImageURLInputParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModerationModel">ModerationModel</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModerationMultiModalInputUnionParam">ModerationMultiModalInputUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModerationTextInputParam">ModerationTextInputParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Moderation">Moderation</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModerationNewResponse">ModerationNewResponse</a>

Methods:

- <code title="post /moderations">client.Moderations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModerationService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModerationNewParams">ModerationNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModerationNewResponse">ModerationNewResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Models

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Model">Model</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModelDeleted">ModelDeleted</a>

Methods:

- <code title="get /models/{model}">client.Models.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModelService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, model <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Model">Model</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /models">client.Models.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModelService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#Page">Page</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Model">Model</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /models/{model}">client.Models.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModelService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, model <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ModelDeleted">ModelDeleted</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# FineTuning

## Methods

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#DpoHyperparameters">DpoHyperparameters</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#DpoMethodParam">DpoMethodParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ReinforcementHyperparameters">ReinforcementHyperparameters</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ReinforcementMethodParam">ReinforcementMethodParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#SupervisedHyperparameters">SupervisedHyperparameters</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#SupervisedMethodParam">SupervisedMethodParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#DpoHyperparametersResp">DpoHyperparametersResp</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#DpoMethod">DpoMethod</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ReinforcementHyperparametersResp">ReinforcementHyperparametersResp</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ReinforcementMethod">ReinforcementMethod</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#SupervisedHyperparametersResp">SupervisedHyperparametersResp</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#SupervisedMethod">SupervisedMethod</a>

## Jobs

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJob">FineTuningJob</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobEvent">FineTuningJobEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobWandbIntegration">FineTuningJobWandbIntegration</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobWandbIntegrationObject">FineTuningJobWandbIntegrationObject</a>

Methods:

- <code title="post /fine_tuning/jobs">client.FineTuning.Jobs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobNewParams">FineTuningJobNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJob">FineTuningJob</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /fine_tuning/jobs/{fine_tuning_job_id}">client.FineTuning.Jobs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fineTuningJobID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJob">FineTuningJob</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /fine_tuning/jobs">client.FineTuning.Jobs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobListParams">FineTuningJobListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJob">FineTuningJob</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /fine_tuning/jobs/{fine_tuning_job_id}/cancel">client.FineTuning.Jobs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobService.Cancel">Cancel</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fineTuningJobID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJob">FineTuningJob</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /fine_tuning/jobs/{fine_tuning_job_id}/events">client.FineTuning.Jobs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobService.ListEvents">ListEvents</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fineTuningJobID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobListEventsParams">FineTuningJobListEventsParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobEvent">FineTuningJobEvent</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /fine_tuning/jobs/{fine_tuning_job_id}/pause">client.FineTuning.Jobs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobService.Pause">Pause</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fineTuningJobID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJob">FineTuningJob</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /fine_tuning/jobs/{fine_tuning_job_id}/resume">client.FineTuning.Jobs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobService.Resume">Resume</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fineTuningJobID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJob">FineTuningJob</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

### Checkpoints

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobCheckpoint">FineTuningJobCheckpoint</a>

Methods:

- <code title="get /fine_tuning/jobs/{fine_tuning_job_id}/checkpoints">client.FineTuning.Jobs.Checkpoints.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobCheckpointService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fineTuningJobID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobCheckpointListParams">FineTuningJobCheckpointListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningJobCheckpoint">FineTuningJobCheckpoint</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## Checkpoints

### Permissions

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionNewResponse">FineTuningCheckpointPermissionNewResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionGetResponse">FineTuningCheckpointPermissionGetResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionDeleteResponse">FineTuningCheckpointPermissionDeleteResponse</a>

Methods:

- <code title="post /fine_tuning/checkpoints/{fine_tuned_model_checkpoint}/permissions">client.FineTuning.Checkpoints.Permissions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fineTunedModelCheckpoint <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionNewParams">FineTuningCheckpointPermissionNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#Page">Page</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionNewResponse">FineTuningCheckpointPermissionNewResponse</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /fine_tuning/checkpoints/{fine_tuned_model_checkpoint}/permissions">client.FineTuning.Checkpoints.Permissions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fineTunedModelCheckpoint <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionGetParams">FineTuningCheckpointPermissionGetParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionGetResponse">FineTuningCheckpointPermissionGetResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /fine_tuning/checkpoints/{fine_tuned_model_checkpoint}/permissions/{permission_id}">client.FineTuning.Checkpoints.Permissions.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, fineTunedModelCheckpoint <a href="https://pkg.go.dev/builtin#string">string</a>, permissionID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningCheckpointPermissionDeleteResponse">FineTuningCheckpointPermissionDeleteResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## Alpha

### Graders

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningAlphaGraderRunResponse">FineTuningAlphaGraderRunResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningAlphaGraderValidateResponse">FineTuningAlphaGraderValidateResponse</a>

Methods:

- <code title="post /fine_tuning/alpha/graders/run">client.FineTuning.Alpha.Graders.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningAlphaGraderService.Run">Run</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningAlphaGraderRunParams">FineTuningAlphaGraderRunParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningAlphaGraderRunResponse">FineTuningAlphaGraderRunResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /fine_tuning/alpha/graders/validate">client.FineTuning.Alpha.Graders.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningAlphaGraderService.Validate">Validate</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningAlphaGraderValidateParams">FineTuningAlphaGraderValidateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FineTuningAlphaGraderValidateResponse">FineTuningAlphaGraderValidateResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Graders

## GraderModels

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#LabelModelGraderParam">LabelModelGraderParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MultiGraderParam">MultiGraderParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#PythonGraderParam">PythonGraderParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ScoreModelGraderParam">ScoreModelGraderParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#StringCheckGraderParam">StringCheckGraderParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TextSimilarityGraderParam">TextSimilarityGraderParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#LabelModelGrader">LabelModelGrader</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MultiGrader">MultiGrader</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#PythonGrader">PythonGrader</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ScoreModelGrader">ScoreModelGrader</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#StringCheckGrader">StringCheckGrader</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TextSimilarityGrader">TextSimilarityGrader</a>

# VectorStores

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AutoFileChunkingStrategyParam">AutoFileChunkingStrategyParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileChunkingStrategyParamUnion">FileChunkingStrategyParamUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#StaticFileChunkingStrategyParam">StaticFileChunkingStrategyParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#StaticFileChunkingStrategyObjectParam">StaticFileChunkingStrategyObjectParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileChunkingStrategyUnion">FileChunkingStrategyUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#OtherFileChunkingStrategyObject">OtherFileChunkingStrategyObject</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#StaticFileChunkingStrategy">StaticFileChunkingStrategy</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#StaticFileChunkingStrategyObject">StaticFileChunkingStrategyObject</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStore">VectorStore</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreDeleted">VectorStoreDeleted</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreSearchResponse">VectorStoreSearchResponse</a>

Methods:

- <code title="post /vector_stores">client.VectorStores.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreNewParams">VectorStoreNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStore">VectorStore</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /vector_stores/{vector_store_id}">client.VectorStores.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStore">VectorStore</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /vector_stores/{vector_store_id}">client.VectorStores.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreService.Update">Update</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreUpdateParams">VectorStoreUpdateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStore">VectorStore</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /vector_stores">client.VectorStores.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreListParams">VectorStoreListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStore">VectorStore</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /vector_stores/{vector_store_id}">client.VectorStores.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreDeleted">VectorStoreDeleted</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /vector_stores/{vector_store_id}/search">client.VectorStores.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreService.Search">Search</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreSearchParams">VectorStoreSearchParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#Page">Page</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreSearchResponse">VectorStoreSearchResponse</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## Files

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFile">VectorStoreFile</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileDeleted">VectorStoreFileDeleted</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileContentResponse">VectorStoreFileContentResponse</a>

Methods:

- <code title="post /vector_stores/{vector_store_id}/files">client.VectorStores.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileNewParams">VectorStoreFileNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFile">VectorStoreFile</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /vector_stores/{vector_store_id}/files/{file_id}">client.VectorStores.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFile">VectorStoreFile</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /vector_stores/{vector_store_id}/files/{file_id}">client.VectorStores.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileService.Update">Update</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileUpdateParams">VectorStoreFileUpdateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFile">VectorStoreFile</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /vector_stores/{vector_store_id}/files">client.VectorStores.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileListParams">VectorStoreFileListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFile">VectorStoreFile</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /vector_stores/{vector_store_id}/files/{file_id}">client.VectorStores.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileDeleted">VectorStoreFileDeleted</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /vector_stores/{vector_store_id}/files/{file_id}/content">client.VectorStores.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileService.Content">Content</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#Page">Page</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileContentResponse">VectorStoreFileContentResponse</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## FileBatches

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatch">VectorStoreFileBatch</a>

Methods:

- <code title="post /vector_stores/{vector_store_id}/file_batches">client.VectorStores.FileBatches.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatchService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatchNewParams">VectorStoreFileBatchNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatch">VectorStoreFileBatch</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /vector_stores/{vector_store_id}/file_batches/{batch_id}">client.VectorStores.FileBatches.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatchService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, batchID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatch">VectorStoreFileBatch</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /vector_stores/{vector_store_id}/file_batches/{batch_id}/cancel">client.VectorStores.FileBatches.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatchService.Cancel">Cancel</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, batchID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatch">VectorStoreFileBatch</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /vector_stores/{vector_store_id}/file_batches/{batch_id}/files">client.VectorStores.FileBatches.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatchService.ListFiles">ListFiles</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, vectorStoreID <a href="https://pkg.go.dev/builtin#string">string</a>, batchID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFileBatchListFilesParams">VectorStoreFileBatchListFilesParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#VectorStoreFile">VectorStoreFile</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Webhooks

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#BatchCancelledWebhookEvent">BatchCancelledWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#BatchCompletedWebhookEvent">BatchCompletedWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#BatchExpiredWebhookEvent">BatchExpiredWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#BatchFailedWebhookEvent">BatchFailedWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#EvalRunCanceledWebhookEvent">EvalRunCanceledWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#EvalRunFailedWebhookEvent">EvalRunFailedWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#EvalRunSucceededWebhookEvent">EvalRunSucceededWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#FineTuningJobCancelledWebhookEvent">FineTuningJobCancelledWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#FineTuningJobFailedWebhookEvent">FineTuningJobFailedWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#FineTuningJobSucceededWebhookEvent">FineTuningJobSucceededWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#RealtimeCallIncomingWebhookEvent">RealtimeCallIncomingWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#ResponseCancelledWebhookEvent">ResponseCancelledWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#ResponseCompletedWebhookEvent">ResponseCompletedWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#ResponseFailedWebhookEvent">ResponseFailedWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#ResponseIncompleteWebhookEvent">ResponseIncompleteWebhookEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#UnwrapWebhookEventUnion">UnwrapWebhookEventUnion</a>

Methods:

- <code>client.Webhooks.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#WebhookService.Unwrap">Unwrap</a>(body []<a href="https://pkg.go.dev/builtin#byte">byte</a>, headers <a href="https://pkg.go.dev/net/http">http</a>.<a href="https://pkg.go.dev/net/http#Header">Header</a>, opts ...<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option">option</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option#RequestOption">RequestOption</a>) (*<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#UnwrapWebhookEventUnion">UnwrapWebhookEventUnion</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code>client.Webhooks.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#WebhookService.UnwrapWithTolerance">UnwrapWithTolerance</a>(body []<a href="https://pkg.go.dev/builtin#byte">byte</a>, headers <a href="https://pkg.go.dev/net/http">http</a>.<a href="https://pkg.go.dev/net/http#Header">Header</a>, tolerance <a href="https://pkg.go.dev/time">time</a>.<a href="https://pkg.go.dev/time#Duration">Duration</a>, opts ...<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option">option</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option#RequestOption">RequestOption</a>) (*<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#UnwrapWebhookEventUnion">UnwrapWebhookEventUnion</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code>client.Webhooks.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#WebhookService.UnwrapWithToleranceAndTime">UnwrapWithToleranceAndTime</a>(body []<a href="https://pkg.go.dev/builtin#byte">byte</a>, headers <a href="https://pkg.go.dev/net/http">http</a>.<a href="https://pkg.go.dev/net/http#Header">Header</a>, tolerance <a href="https://pkg.go.dev/time">time</a>.<a href="https://pkg.go.dev/time#Duration">Duration</a>, now <a href="https://pkg.go.dev/time">time</a>.<a href="https://pkg.go.dev/time#Time">Time</a>, opts ...<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option">option</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option#RequestOption">RequestOption</a>) (*<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks">webhooks</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#UnwrapWebhookEventUnion">UnwrapWebhookEventUnion</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code>client.Webhooks.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#WebhookService.VerifySignature">VerifySignature</a>(body []<a href="https://pkg.go.dev/builtin#byte">byte</a>, headers <a href="https://pkg.go.dev/net/http">http</a>.<a href="https://pkg.go.dev/net/http#Header">Header</a>, opts ...<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option">option</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option#RequestOption">RequestOption</a>) <a href="https://pkg.go.dev/builtin#error">error</a></code>
- <code>client.Webhooks.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#WebhookService.VerifySignatureWithTolerance">VerifySignatureWithTolerance</a>(body []<a href="https://pkg.go.dev/builtin#byte">byte</a>, headers <a href="https://pkg.go.dev/net/http">http</a>.<a href="https://pkg.go.dev/net/http#Header">Header</a>, tolerance <a href="https://pkg.go.dev/time">time</a>.<a href="https://pkg.go.dev/time#Duration">Duration</a>, opts ...<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option">option</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option#RequestOption">RequestOption</a>) <a href="https://pkg.go.dev/builtin#error">error</a></code>
- <code>client.Webhooks.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/webhooks#WebhookService.VerifySignatureWithToleranceAndTime">VerifySignatureWithToleranceAndTime</a>(body []<a href="https://pkg.go.dev/builtin#byte">byte</a>, headers <a href="https://pkg.go.dev/net/http">http</a>.<a href="https://pkg.go.dev/net/http#Header">Header</a>, tolerance <a href="https://pkg.go.dev/time">time</a>.<a href="https://pkg.go.dev/time#Duration">Duration</a>, now <a href="https://pkg.go.dev/time">time</a>.<a href="https://pkg.go.dev/time#Time">Time</a>, opts ...<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option">option</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/option#RequestOption">RequestOption</a>) <a href="https://pkg.go.dev/builtin#error">error</a></code>

# Beta

## Assistants

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantToolUnionParam">AssistantToolUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CodeInterpreterToolParam">CodeInterpreterToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileSearchToolParam">FileSearchToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FunctionToolParam">FunctionToolParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Assistant">Assistant</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantDeleted">AssistantDeleted</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantStreamEventUnion">AssistantStreamEventUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantToolUnion">AssistantToolUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CodeInterpreterTool">CodeInterpreterTool</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileSearchTool">FileSearchTool</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FunctionTool">FunctionTool</a>

Methods:

- <code title="post /assistants">client.Beta.Assistants.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaAssistantService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaAssistantNewParams">BetaAssistantNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Assistant">Assistant</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /assistants/{assistant_id}">client.Beta.Assistants.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaAssistantService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, assistantID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Assistant">Assistant</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /assistants/{assistant_id}">client.Beta.Assistants.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaAssistantService.Update">Update</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, assistantID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaAssistantUpdateParams">BetaAssistantUpdateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Assistant">Assistant</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /assistants">client.Beta.Assistants.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaAssistantService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaAssistantListParams">BetaAssistantListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Assistant">Assistant</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /assistants/{assistant_id}">client.Beta.Assistants.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaAssistantService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, assistantID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantDeleted">AssistantDeleted</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## Threads

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantResponseFormatOptionUnionParam">AssistantResponseFormatOptionUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantToolChoiceParam">AssistantToolChoiceParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantToolChoiceFunctionParam">AssistantToolChoiceFunctionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantToolChoiceOptionUnionParam">AssistantToolChoiceOptionUnionParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantResponseFormatOptionUnion">AssistantResponseFormatOptionUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantToolChoice">AssistantToolChoice</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantToolChoiceFunction">AssistantToolChoiceFunction</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AssistantToolChoiceOptionUnion">AssistantToolChoiceOptionUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Thread">Thread</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ThreadDeleted">ThreadDeleted</a>

Methods:

- <code title="post /threads">client.Beta.Threads.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadNewParams">BetaThreadNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Thread">Thread</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /threads/{thread_id}">client.Beta.Threads.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Thread">Thread</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /threads/{thread_id}">client.Beta.Threads.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadService.Update">Update</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadUpdateParams">BetaThreadUpdateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Thread">Thread</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /threads/{thread_id}">client.Beta.Threads.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ThreadDeleted">ThreadDeleted</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /threads/runs">client.Beta.Threads.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadService.NewAndRun">NewAndRun</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadNewAndRunParams">BetaThreadNewAndRunParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Run">Run</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

### Runs

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RequiredActionFunctionToolCall">RequiredActionFunctionToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Run">Run</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RunStatus">RunStatus</a>

Methods:

- <code title="post /threads/{thread_id}/runs">client.Beta.Threads.Runs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, params <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunNewParams">BetaThreadRunNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Run">Run</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /threads/{thread_id}/runs/{run_id}">client.Beta.Threads.Runs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, runID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Run">Run</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /threads/{thread_id}/runs/{run_id}">client.Beta.Threads.Runs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunService.Update">Update</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, runID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunUpdateParams">BetaThreadRunUpdateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Run">Run</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /threads/{thread_id}/runs">client.Beta.Threads.Runs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunListParams">BetaThreadRunListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Run">Run</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /threads/{thread_id}/runs/{run_id}/cancel">client.Beta.Threads.Runs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunService.Cancel">Cancel</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, runID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Run">Run</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /threads/{thread_id}/runs/{run_id}/submit_tool_outputs">client.Beta.Threads.Runs.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunService.SubmitToolOutputs">SubmitToolOutputs</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, runID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunSubmitToolOutputsParams">BetaThreadRunSubmitToolOutputsParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Run">Run</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

#### Steps

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RunStepInclude">RunStepInclude</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CodeInterpreterLogs">CodeInterpreterLogs</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CodeInterpreterOutputImage">CodeInterpreterOutputImage</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CodeInterpreterToolCall">CodeInterpreterToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#CodeInterpreterToolCallDelta">CodeInterpreterToolCallDelta</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileSearchToolCall">FileSearchToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileSearchToolCallDelta">FileSearchToolCallDelta</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FunctionToolCall">FunctionToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FunctionToolCallDelta">FunctionToolCallDelta</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MessageCreationStepDetails">MessageCreationStepDetails</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RunStep">RunStep</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RunStepDelta">RunStepDelta</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RunStepDeltaEvent">RunStepDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RunStepDeltaMessageDelta">RunStepDeltaMessageDelta</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ToolCallUnion">ToolCallUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ToolCallDeltaUnion">ToolCallDeltaUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ToolCallDeltaObject">ToolCallDeltaObject</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ToolCallsStepDetails">ToolCallsStepDetails</a>

Methods:

- <code title="get /threads/{thread_id}/runs/{run_id}/steps/{step_id}">client.Beta.Threads.Runs.Steps.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunStepService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, runID <a href="https://pkg.go.dev/builtin#string">string</a>, stepID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunStepGetParams">BetaThreadRunStepGetParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RunStep">RunStep</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /threads/{thread_id}/runs/{run_id}/steps">client.Beta.Threads.Runs.Steps.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunStepService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, runID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadRunStepListParams">BetaThreadRunStepListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RunStep">RunStep</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

### Messages

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageFileParam">ImageFileParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageFileContentBlockParam">ImageFileContentBlockParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageURLParam">ImageURLParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageURLContentBlockParam">ImageURLContentBlockParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MessageContentPartParamUnion">MessageContentPartParamUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TextContentBlockParam">TextContentBlockParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AnnotationUnion">AnnotationUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#AnnotationDeltaUnion">AnnotationDeltaUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileCitationAnnotation">FileCitationAnnotation</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FileCitationDeltaAnnotation">FileCitationDeltaAnnotation</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FilePathAnnotation">FilePathAnnotation</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#FilePathDeltaAnnotation">FilePathDeltaAnnotation</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageFile">ImageFile</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageFileContentBlock">ImageFileContentBlock</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageFileDelta">ImageFileDelta</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageFileDeltaBlock">ImageFileDeltaBlock</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageURL">ImageURL</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageURLContentBlock">ImageURLContentBlock</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageURLDelta">ImageURLDelta</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ImageURLDeltaBlock">ImageURLDeltaBlock</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Message">Message</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MessageContentUnion">MessageContentUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MessageContentDeltaUnion">MessageContentDeltaUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MessageDeleted">MessageDeleted</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MessageDelta">MessageDelta</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MessageDeltaEvent">MessageDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RefusalContentBlock">RefusalContentBlock</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#RefusalDeltaBlock">RefusalDeltaBlock</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Text">Text</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TextContentBlock">TextContentBlock</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TextDelta">TextDelta</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#TextDeltaBlock">TextDeltaBlock</a>

Methods:

- <code title="post /threads/{thread_id}/messages">client.Beta.Threads.Messages.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadMessageService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadMessageNewParams">BetaThreadMessageNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Message">Message</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /threads/{thread_id}/messages/{message_id}">client.Beta.Threads.Messages.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadMessageService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, messageID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Message">Message</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /threads/{thread_id}/messages/{message_id}">client.Beta.Threads.Messages.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadMessageService.Update">Update</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, messageID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadMessageUpdateParams">BetaThreadMessageUpdateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Message">Message</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /threads/{thread_id}/messages">client.Beta.Threads.Messages.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadMessageService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadMessageListParams">BetaThreadMessageListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Message">Message</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /threads/{thread_id}/messages/{message_id}">client.Beta.Threads.Messages.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BetaThreadMessageService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, threadID <a href="https://pkg.go.dev/builtin#string">string</a>, messageID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#MessageDeleted">MessageDeleted</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Batches

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Batch">Batch</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BatchError">BatchError</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BatchRequestCounts">BatchRequestCounts</a>

Methods:

- <code title="post /batches">client.Batches.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BatchService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BatchNewParams">BatchNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Batch">Batch</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /batches/{batch_id}">client.Batches.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BatchService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, batchID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Batch">Batch</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /batches">client.Batches.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BatchService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BatchListParams">BatchListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Batch">Batch</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /batches/{batch_id}/cancel">client.Batches.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#BatchService.Cancel">Cancel</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, batchID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Batch">Batch</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Uploads

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Upload">Upload</a>

Methods:

- <code title="post /uploads">client.Uploads.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#UploadService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#UploadNewParams">UploadNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Upload">Upload</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /uploads/{upload_id}/cancel">client.Uploads.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#UploadService.Cancel">Cancel</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, uploadID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Upload">Upload</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /uploads/{upload_id}/complete">client.Uploads.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#UploadService.Complete">Complete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, uploadID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#UploadCompleteParams">UploadCompleteParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#Upload">Upload</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## Parts

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#UploadPart">UploadPart</a>

Methods:

- <code title="post /uploads/{upload_id}/parts">client.Uploads.Parts.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#UploadPartService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, uploadID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#UploadPartNewParams">UploadPartNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#UploadPart">UploadPart</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Responses

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ComputerToolParam">ComputerToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#CustomToolParam">CustomToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#EasyInputMessageParam">EasyInputMessageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#FileSearchToolParam">FileSearchToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#FunctionToolParam">FunctionToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCodeInterpreterToolCallParam">ResponseCodeInterpreterToolCallParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseComputerToolCallParam">ResponseComputerToolCallParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseComputerToolCallOutputScreenshotParam">ResponseComputerToolCallOutputScreenshotParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseConversationParam">ResponseConversationParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCustomToolCallParam">ResponseCustomToolCallParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCustomToolCallOutputParam">ResponseCustomToolCallOutputParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFileSearchToolCallParam">ResponseFileSearchToolCallParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFormatTextConfigUnionParam">ResponseFormatTextConfigUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFormatTextJSONSchemaConfigParam">ResponseFormatTextJSONSchemaConfigParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFunctionToolCallParam">ResponseFunctionToolCallParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFunctionWebSearchParam">ResponseFunctionWebSearchParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseIncludable">ResponseIncludable</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputParam">ResponseInputParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputAudioParam">ResponseInputAudioParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputContentUnionParam">ResponseInputContentUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputFileParam">ResponseInputFileParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputImageParam">ResponseInputImageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputItemUnionParam">ResponseInputItemUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputMessageContentListParam">ResponseInputMessageContentListParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputTextParam">ResponseInputTextParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputMessageParam">ResponseOutputMessageParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputRefusalParam">ResponseOutputRefusalParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputTextParam">ResponseOutputTextParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponsePromptParam">ResponsePromptParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseReasoningItemParam">ResponseReasoningItemParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseTextConfigParam">ResponseTextConfigParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolUnionParam">ToolUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceAllowedParam">ToolChoiceAllowedParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceCustomParam">ToolChoiceCustomParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceFunctionParam">ToolChoiceFunctionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceMcpParam">ToolChoiceMcpParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceOptions">ToolChoiceOptions</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceTypesParam">ToolChoiceTypesParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#WebSearchPreviewToolParam">WebSearchPreviewToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#WebSearchToolParam">WebSearchToolParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ComputerTool">ComputerTool</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#CustomTool">CustomTool</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#EasyInputMessage">EasyInputMessage</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#FileSearchTool">FileSearchTool</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#FunctionTool">FunctionTool</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#Response">Response</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseAudioDeltaEvent">ResponseAudioDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseAudioDoneEvent">ResponseAudioDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseAudioTranscriptDeltaEvent">ResponseAudioTranscriptDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseAudioTranscriptDoneEvent">ResponseAudioTranscriptDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCodeInterpreterCallCodeDeltaEvent">ResponseCodeInterpreterCallCodeDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCodeInterpreterCallCodeDoneEvent">ResponseCodeInterpreterCallCodeDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCodeInterpreterCallCompletedEvent">ResponseCodeInterpreterCallCompletedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCodeInterpreterCallInProgressEvent">ResponseCodeInterpreterCallInProgressEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCodeInterpreterCallInterpretingEvent">ResponseCodeInterpreterCallInterpretingEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCodeInterpreterToolCall">ResponseCodeInterpreterToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCompletedEvent">ResponseCompletedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseComputerToolCall">ResponseComputerToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseComputerToolCallOutputItem">ResponseComputerToolCallOutputItem</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseComputerToolCallOutputScreenshot">ResponseComputerToolCallOutputScreenshot</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseContentPartAddedEvent">ResponseContentPartAddedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseContentPartDoneEvent">ResponseContentPartDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCreatedEvent">ResponseCreatedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCustomToolCall">ResponseCustomToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCustomToolCallInputDeltaEvent">ResponseCustomToolCallInputDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCustomToolCallInputDoneEvent">ResponseCustomToolCallInputDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseCustomToolCallOutput">ResponseCustomToolCallOutput</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseError">ResponseError</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseErrorEvent">ResponseErrorEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFailedEvent">ResponseFailedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFileSearchCallCompletedEvent">ResponseFileSearchCallCompletedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFileSearchCallInProgressEvent">ResponseFileSearchCallInProgressEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFileSearchCallSearchingEvent">ResponseFileSearchCallSearchingEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFileSearchToolCall">ResponseFileSearchToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFormatTextConfigUnion">ResponseFormatTextConfigUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFormatTextJSONSchemaConfig">ResponseFormatTextJSONSchemaConfig</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFunctionCallArgumentsDeltaEvent">ResponseFunctionCallArgumentsDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFunctionCallArgumentsDoneEvent">ResponseFunctionCallArgumentsDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFunctionToolCall">ResponseFunctionToolCall</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFunctionToolCallItem">ResponseFunctionToolCallItem</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFunctionToolCallOutputItem">ResponseFunctionToolCallOutputItem</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseFunctionWebSearch">ResponseFunctionWebSearch</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseImageGenCallCompletedEvent">ResponseImageGenCallCompletedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseImageGenCallGeneratingEvent">ResponseImageGenCallGeneratingEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseImageGenCallInProgressEvent">ResponseImageGenCallInProgressEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseImageGenCallPartialImageEvent">ResponseImageGenCallPartialImageEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInProgressEvent">ResponseInProgressEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseIncompleteEvent">ResponseIncompleteEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputAudio">ResponseInputAudio</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputContentUnion">ResponseInputContentUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputFile">ResponseInputFile</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputImage">ResponseInputImage</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputItemUnion">ResponseInputItemUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputMessageContentList">ResponseInputMessageContentList</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputMessageItem">ResponseInputMessageItem</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseInputText">ResponseInputText</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseItemUnion">ResponseItemUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseMcpCallArgumentsDeltaEvent">ResponseMcpCallArgumentsDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseMcpCallArgumentsDoneEvent">ResponseMcpCallArgumentsDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseMcpCallCompletedEvent">ResponseMcpCallCompletedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseMcpCallFailedEvent">ResponseMcpCallFailedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseMcpCallInProgressEvent">ResponseMcpCallInProgressEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseMcpListToolsCompletedEvent">ResponseMcpListToolsCompletedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseMcpListToolsFailedEvent">ResponseMcpListToolsFailedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseMcpListToolsInProgressEvent">ResponseMcpListToolsInProgressEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputItemUnion">ResponseOutputItemUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputItemAddedEvent">ResponseOutputItemAddedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputItemDoneEvent">ResponseOutputItemDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputMessage">ResponseOutputMessage</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputRefusal">ResponseOutputRefusal</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputText">ResponseOutputText</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseOutputTextAnnotationAddedEvent">ResponseOutputTextAnnotationAddedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponsePrompt">ResponsePrompt</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseQueuedEvent">ResponseQueuedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseReasoningItem">ResponseReasoningItem</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseReasoningSummaryPartAddedEvent">ResponseReasoningSummaryPartAddedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseReasoningSummaryPartDoneEvent">ResponseReasoningSummaryPartDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseReasoningSummaryTextDeltaEvent">ResponseReasoningSummaryTextDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseReasoningSummaryTextDoneEvent">ResponseReasoningSummaryTextDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseReasoningTextDeltaEvent">ResponseReasoningTextDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseReasoningTextDoneEvent">ResponseReasoningTextDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseRefusalDeltaEvent">ResponseRefusalDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseRefusalDoneEvent">ResponseRefusalDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseStatus">ResponseStatus</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseStreamEventUnion">ResponseStreamEventUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseTextConfig">ResponseTextConfig</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseTextDeltaEvent">ResponseTextDeltaEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseTextDoneEvent">ResponseTextDoneEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseUsage">ResponseUsage</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseWebSearchCallCompletedEvent">ResponseWebSearchCallCompletedEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseWebSearchCallInProgressEvent">ResponseWebSearchCallInProgressEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseWebSearchCallSearchingEvent">ResponseWebSearchCallSearchingEvent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolUnion">ToolUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceAllowed">ToolChoiceAllowed</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceCustom">ToolChoiceCustom</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceFunction">ToolChoiceFunction</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceMcp">ToolChoiceMcp</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceOptions">ToolChoiceOptions</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ToolChoiceTypes">ToolChoiceTypes</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#WebSearchPreviewTool">WebSearchPreviewTool</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#WebSearchTool">WebSearchTool</a>

Methods:

- <code title="post /responses">client.Responses.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseNewParams">ResponseNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#Response">Response</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /responses/{response_id}">client.Responses.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, responseID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseGetParams">ResponseGetParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#Response">Response</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /responses/{response_id}">client.Responses.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, responseID <a href="https://pkg.go.dev/builtin#string">string</a>) <a href="https://pkg.go.dev/builtin#error">error</a></code>
- <code title="post /responses/{response_id}/cancel">client.Responses.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseService.Cancel">Cancel</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, responseID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#Response">Response</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## InputItems

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseItemList">ResponseItemList</a>

Methods:

- <code title="get /responses/{response_id}/input_items">client.Responses.InputItems.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#InputItemService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, responseID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#InputItemListParams">InputItemListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses">responses</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/responses#ResponseItemUnion">ResponseItemUnion</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Realtime

Params Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#AudioTranscriptionParam">AudioTranscriptionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#NoiseReductionType">NoiseReductionType</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeAudioConfigParam">RealtimeAudioConfigParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeAudioConfigInputParam">RealtimeAudioConfigInputParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeAudioConfigOutputParam">RealtimeAudioConfigOutputParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeAudioFormatsUnionParam">RealtimeAudioFormatsUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeAudioInputTurnDetectionUnionParam">RealtimeAudioInputTurnDetectionUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeFunctionToolParam">RealtimeFunctionToolParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeSessionCreateRequestParam">RealtimeSessionCreateRequestParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeToolChoiceConfigUnionParam">RealtimeToolChoiceConfigUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeToolsConfigParam">RealtimeToolsConfigParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeToolsConfigUnionParam">RealtimeToolsConfigUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTracingConfigUnionParam">RealtimeTracingConfigUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTranscriptionSessionAudioParam">RealtimeTranscriptionSessionAudioParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTranscriptionSessionAudioInputParam">RealtimeTranscriptionSessionAudioInputParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTranscriptionSessionAudioInputTurnDetectionUnionParam">RealtimeTranscriptionSessionAudioInputTurnDetectionUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTranscriptionSessionCreateRequestParam">RealtimeTranscriptionSessionCreateRequestParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTruncationUnionParam">RealtimeTruncationUnionParam</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTruncationRetentionRatioParam">RealtimeTruncationRetentionRatioParam</a>

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#AudioTranscription">AudioTranscription</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#NoiseReductionType">NoiseReductionType</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeAudioFormatsUnion">RealtimeAudioFormatsUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeFunctionTool">RealtimeFunctionTool</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTruncationUnion">RealtimeTruncationUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTruncationRetentionRatio">RealtimeTruncationRetentionRatio</a>

## ClientSecrets

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeSessionClientSecret">RealtimeSessionClientSecret</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeSessionCreateResponse">RealtimeSessionCreateResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTranscriptionSessionCreateResponse">RealtimeTranscriptionSessionCreateResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#RealtimeTranscriptionSessionTurnDetection">RealtimeTranscriptionSessionTurnDetection</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#ClientSecretNewResponse">ClientSecretNewResponse</a>

Methods:

- <code title="post /realtime/client_secrets">client.Realtime.ClientSecrets.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#ClientSecretService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#ClientSecretNewParams">ClientSecretNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime">realtime</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/realtime#ClientSecretNewResponse">ClientSecretNewResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Conversations

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ComputerScreenshotContent">ComputerScreenshotContent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#Conversation">Conversation</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationDeletedResource">ConversationDeletedResource</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#Message">Message</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#SummaryTextContent">SummaryTextContent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#TextContent">TextContent</a>

Methods:

- <code title="post /conversations">client.Conversations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationNewParams">ConversationNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#Conversation">Conversation</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /conversations/{conversation_id}">client.Conversations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#Conversation">Conversation</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /conversations/{conversation_id}">client.Conversations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationService.Update">Update</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationUpdateParams">ConversationUpdateParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#Conversation">Conversation</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /conversations/{conversation_id}">client.Conversations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationDeletedResource">ConversationDeletedResource</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## Items

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationItemUnion">ConversationItemUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationItemList">ConversationItemList</a>

Methods:

- <code title="post /conversations/{conversation_id}/items">client.Conversations.Items.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ItemService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, params <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ItemNewParams">ItemNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationItemList">ConversationItemList</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /conversations/{conversation_id}/items/{item_id}">client.Conversations.Items.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ItemService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, itemID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ItemGetParams">ItemGetParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationItemUnion">ConversationItemUnion</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /conversations/{conversation_id}/items">client.Conversations.Items.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ItemService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ItemListParams">ItemListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#ConversationCursorPage">ConversationCursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ConversationItemUnion">ConversationItemUnion</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /conversations/{conversation_id}/items/{item_id}">client.Conversations.Items.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#ItemService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, itemID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/conversations#Conversation">Conversation</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

# Containers

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerNewResponse">ContainerNewResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerGetResponse">ContainerGetResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerListResponse">ContainerListResponse</a>

Methods:

- <code title="post /containers">client.Containers.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerNewParams">ContainerNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerNewResponse">ContainerNewResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /containers/{container_id}">client.Containers.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, containerID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerGetResponse">ContainerGetResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /containers">client.Containers.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerListParams">ContainerListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerListResponse">ContainerListResponse</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /containers/{container_id}">client.Containers.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, containerID <a href="https://pkg.go.dev/builtin#string">string</a>) <a href="https://pkg.go.dev/builtin#error">error</a></code>

## Files

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileNewResponse">ContainerFileNewResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileGetResponse">ContainerFileGetResponse</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileListResponse">ContainerFileListResponse</a>

Methods:

- <code title="post /containers/{container_id}/files">client.Containers.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, containerID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileNewParams">ContainerFileNewParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileNewResponse">ContainerFileNewResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /containers/{container_id}/files/{file_id}">client.Containers.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, containerID <a href="https://pkg.go.dev/builtin#string">string</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileGetResponse">ContainerFileGetResponse</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /containers/{container_id}/files">client.Containers.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, containerID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileListParams">ContainerFileListParams</a>) (<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2/packages/pagination#CursorPage">CursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v2">openai</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileListResponse">ContainerFileListResponse</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /containers/{container_id}/files/{file_id}">client.Containers.Files.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, containerID <a href="https://pkg.go.dev/builtin#string">string</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>) <a href="https://pkg.go.dev/builtin#error">error</a></code>

### Content

Methods:

- <code title="get /containers/{container_id}/files/{file_id}/content">client.Containers.Files.Content.<a href="https://pkg.go.dev/github.com/openai/openai-go/v2#ContainerFileContentService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, containerID <a href="https://pkg.go.dev/builtin#string">string</a>, fileID <a href="https://pkg.go.dev/builtin#string">string</a>) (http.Response, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
