package zmiddlewares

import (
	"github.com/Potterli20/golem/pkg/logger"
	"github.com/google/uuid"
	"net/http"
)

const (
	RequestIDHeader = "X-Request-ID"
)

func RequestID() Middleware {
	return requestIDMiddleware
}

func requestIDMiddleware(next http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		requestID := r.Header.Get(RequestIDHeader)
		if requestID == "" {
			requestID = uuid.New().String()
			r.Header.Set(RequestIDHeader, requestID)
		}

		w.Header().Set(RequestIDHeader, requestID)
		rw := &responseWriter{ResponseWriter: w}
		newLogger := logger.NewLogger(logger.Field{
			Key:   logger.RequestIDKey,
			Value: requestID,
		})
		ctx := logger.ContextWithLogger(r.Context(), newLogger)
		next.ServeHTTP(rw, r.WithContext(ctx))
	})
}

func Logger(options LoggingMiddlewareOptions) Middleware {
	return LoggingMiddleware(options)
}
