package zdb

import (
	"context"
	"database/sql"

	"github.com/Potterli20/golem/pkg/zdb/zdbconfig"
	"github.com/stretchr/testify/mock"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
)

type MockZDatabase struct {
	mock.Mock
}

func (m *MockZDatabase) GetDbConnection() *gorm.DB {
	args := m.Called()
	return args.Get(0).(*gorm.DB)
}

func (m *MockZDatabase) Find(dest any, conds ...any) ZDatabase {
	args := m.Called(append([]any{dest}, conds...)...)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) First(dest any, conds ...any) ZDatabase {
	args := m.Called(append([]any{dest}, conds...)...)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) FirstOrCreate(dest any, conds ...any) ZDatabase {
	args := m.Called(append([]any{dest}, conds...)...)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Scan(dest any) ZDatabase {
	m.Called(dest)
	return m
}

func (m *MockZDatabase) Rows() (*sql.Rows, error) {
	args := m.Called()
	return args.Get(0).(*sql.Rows), args.Error(1)
}

func (m *MockZDatabase) ScanRows(rows *sql.Rows, result any) error {
	args := m.Called(rows, result)
	return args.Error(0)
}

func (m *MockZDatabase) Create(value any) ZDatabase {
	m.Called(value)
	return m
}

func (m *MockZDatabase) Updates(value any) ZDatabase {
	m.Called(value)
	return m
}

func (m *MockZDatabase) Update(column string, value any) ZDatabase {
	m.Called(column, value)
	return m
}

func (m *MockZDatabase) Delete(value any, conds ...any) ZDatabase {
	args := m.Called(append([]any{value}, conds...)...)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Raw(sql string, values ...any) ZDatabase {
	args := m.Called(append([]any{sql}, values...)...)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Select(query any, values ...any) ZDatabase {
	args := m.Called(append([]any{query}, values...)...)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Where(query any, values ...any) ZDatabase {
	args := m.Called(append([]any{query}, values...)...)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Joins(query string, values ...any) ZDatabase {
	args := m.Called(append([]any{query}, values...)...)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) UnionAll(subQuery1 ZDatabase, subQuery2 ZDatabase) ZDatabase {
	args := m.Called(subQuery1, subQuery2)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) UnionDistinct(subQuery1 ZDatabase, subQuery2 ZDatabase) ZDatabase {
	args := m.Called(subQuery1, subQuery2)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Limit(limit int) ZDatabase {
	args := m.Called(limit)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Offset(offset int) ZDatabase {
	args := m.Called(offset)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Exec(sql string, values ...any) ZDatabase {
	m.Called(sql, values)
	return m
}

func (m *MockZDatabase) Table(name string, args ...any) ZDatabase {
	m.Called(append([]any{name}, args...)...)
	return m
}

func (m *MockZDatabase) Transaction(fc func(tx ZDatabase) error, opts ...*sql.TxOptions) (err error) {
	args := m.Called(fc, opts)
	return args.Error(0)
}

func (m *MockZDatabase) Clauses(conds ...clause.Expression) ZDatabase {
	args := m.Called(conds)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Error() error {
	args := m.Called()
	return args.Error(0)
}

func (m *MockZDatabase) RowsAffected() int64 {
	args := m.Called()
	return args.Get(0).(int64)
}

func (m *MockZDatabase) Order(value any) ZDatabase {
	args := m.Called(value)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Distinct(params ...any) ZDatabase {
	args := m.Called(params)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Count(count *int64) ZDatabase {
	args := m.Called(count)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Scopes(funcs ...func(ZDatabase) ZDatabase) ZDatabase {
	args := m.Called(funcs)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) Group(name string) ZDatabase {
	args := m.Called(name)
	return args.Get(0).(ZDatabase)
}

func (m *MockZDatabase) GetDBStats() (sql.DBStats, error) {
	args := m.Called()
	return args.Get(0).(sql.DBStats), args.Error(1)
}

func (m *MockZDatabase) WithContext(ctx context.Context) ZDatabase {
	args := m.Called(ctx)
	return args.Get(0).(ZDatabase)
}

// MockDBConnector

type MockDBConnector struct {
	mock.Mock
}

func (m *MockDBConnector) NewInstance(dbType string, config *zdbconfig.Config) (ZDatabase, error) {
	args := m.Called(dbType, config)
	return args.Get(0).(ZDatabase), args.Error(1)
}

func (m *MockDBConnector) Connect(config *zdbconfig.Config) (*gorm.DB, error) {
	args := m.Called(config)
	return args.Get(0).(*gorm.DB), args.Error(1)
}

func (m *MockDBConnector) VerifyConnection(db *gorm.DB) error {
	args := m.Called(db)
	return args.Error(0)
}
