# [RustCrypto]: PKCS#8 (Private Keys)

[![crate][crate-image]][crate-link]
[![Docs][docs-image]][docs-link]
[![Build Status][build-image]][build-link]
![Apache2/MIT licensed][license-image]
![Rust Version][rustc-image]
[![Project Chat][chat-image]][chat-link]

Pure Rust implementation of Public-Key Cryptography Standards (PKCS) #8:
Private-Key Information Syntax Specification ([RFC 5208]).

[Documentation][docs-link]

## About PKCS#8

PKCS#8 is a format for cryptographic private keys, often containing pairs
of private and public keys.

You can identify a PKCS#8 private key encoded as PEM (i.e. text) by the
following:

```text
-----BEGIN PRIVATE KEY-----
```

PKCS#8 private keys can optionally be encrypted under a password using
key derivation algorithms like PBKDF2 and [scrypt], and encrypted with
ciphers like AES-CBC. When a PKCS#8 private key has been encrypted,
it starts with the following:

```text
-----BEGIN ENCRYPTED PRIVATE KEY-----
```

PKCS#8 private keys can also be serialized in an ASN.1-based binary format.
The PEM text encoding is a Base64 representation of this format.

## Supported Algorithms

This crate is implemented in an algorithm-agnostic manner with the goal of
enabling PKCS#8 support for any algorithm.

That said, it has been tested for interoperability against keys generated by
OpenSSL for the  following algorithms:

- ECC (`id-ecPublicKey`)
- Ed25519 (`id-Ed25519`)
- RSA (`id-rsaEncryption`)
- X25519 (`id-X25519`)

Please open an issue if you encounter trouble using it with a particular
algorithm, including the ones listed above or other algorithms.

## Minimum Supported Rust Version (MSRV) Policy

MSRV increases are not considered breaking changes and can happen in patch releases.

The crate MSRV accounts for all supported targets and crate feature combinations, excluding
explicitly unstable features.

## License

Licensed under either of:

 * [Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0)
 * [MIT license](http://opensource.org/licenses/MIT)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.

[//]: # (badges)

[crate-image]: https://img.shields.io/crates/v/pkcs8
[crate-link]: https://crates.io/crates/pkcs8
[docs-image]: https://docs.rs/pkcs8/badge.svg
[docs-link]: https://docs.rs/pkcs8/
[build-image]: https://github.com/RustCrypto/formats/actions/workflows/pkcs8.yml/badge.svg
[build-link]: https://github.com/RustCrypto/formats/actions/workflows/pkcs8.yml
[license-image]: https://img.shields.io/badge/license-Apache2.0/MIT-blue.svg
[rustc-image]: https://img.shields.io/badge/rustc-1.85+-blue.svg
[chat-image]: https://img.shields.io/badge/zulip-join_chat-blue.svg
[chat-link]: https://rustcrypto.zulipchat.com/#narrow/stream/300570-formats

[//]: # (links)

[RustCrypto]: https://github.com/rustcrypto
[RFC 5208]: https://tools.ietf.org/html/rfc5208
[scrypt]: https://en.wikipedia.org/wiki/Scrypt
