# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [8.0.1](https://github.com/ratatui/ansi-to-tui/compare/v8.0.0...v8.0.1) - 2026-01-10

### Fixed

- *(parser)* normalize CR and CRLF newlines ([#80](https://github.com/ratatui/ansi-to-tui/pull/80))

### Other

- *(deps)* bump lru from 0.16.2 to 0.16.3 ([#81](https://github.com/ratatui/ansi-to-tui/pull/81))
- add CR/LF characterization tests ([#79](https://github.com/ratatui/ansi-to-tui/pull/79))
- Add SGR tests; handle 27 and fix 107 ([#78](https://github.com/ratatui/ansi-to-tui/pull/78))
- add cargo workflow alongside Nix ([#77](https://github.com/ratatui/ansi-to-tui/pull/77))
- polish Ratatui docs and metadata ([#76](https://github.com/ratatui/ansi-to-tui/pull/76))
- update license ([#74](https://github.com/ratatui/ansi-to-tui/pull/74))

## [8.0.0](https://github.com/ratatui/ansi-to-tui/compare/v7.0.0...v8.0.0) - 2025-12-26

### Fixed

- Fix failing tests with disabled default features
  ([#63](https://github.com/ratatui/ansi-to-tui/pull/63))

### Other

- update ratatui-core to 0.1.0 ([#72](https://github.com/ratatui/ansi-to-tui/pull/72))
- enable trusted publishing ([#69](https://github.com/ratatui/ansi-to-tui/pull/69))
- set edition to 2024 ([#67](https://github.com/ratatui/ansi-to-tui/pull/67))
- unrelease 7.0.1 ([#65](https://github.com/ratatui/ansi-to-tui/pull/65))
- *(parser)* refresh deps and benchmarks ([#64](https://github.com/ratatui/ansi-to-tui/pull/64))
- update to ratatui-0.30 pre-release ([#60](https://github.com/ratatui/ansi-to-tui/pull/60))
- release v7.0.1 ([#59](https://github.com/ratatui/ansi-to-tui/pull/59))
- indicate in README that into_text is fallible
  ([#62](https://github.com/ratatui/ansi-to-tui/pull/62))
- Fix reset for underline/blink/italic/hidden
  ([#57](https://github.com/ratatui/ansi-to-tui/pull/57))

## [7.0.0](https://github.com/ratatui/ansi-to-tui/compare/v6.0.1...v7.0.0) - 2024-10-24

### Other
- *(bump)* Update lockfile and bump ratatui version to 0.29

## 3.0.0 (2023-03-21)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 6 commits contributed to the release.
 - 5 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - [update] Changelog and readme ([`8b38176`](https://github.com/sayanarijit/ansi-to-tui/commit/8b38176c630fe6d5c9502c3bc8b53f0f0eb25efe))
    - Update version ([`7617608`](https://github.com/sayanarijit/ansi-to-tui/commit/761760805afad70709b2158b04789b31ac4f12fc))
    - Move to ratatui ([`0446f08`](https://github.com/sayanarijit/ansi-to-tui/commit/0446f08857469fbcb770af125a3abd637ea1f777))
    - [feat] Bump version and update CHANGELOG.md ([`eec6f86`](https://github.com/sayanarijit/ansi-to-tui/commit/eec6f86e6ad66196370cb350f4451c829d6c5bb1))
    - [fix] properly reset styles ([`50f5be0`](https://github.com/sayanarijit/ansi-to-tui/commit/50f5be0ec5e9b49efebf6cb34a967b550843c61b))
    - [fix] Properly set background colors ([`f827e25`](https://github.com/sayanarijit/ansi-to-tui/commit/f827e25d7998d48f7bbf004440d7cb20b54b5d99))
</details>

## 2.0.1 (2023-03-16)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 11 commits contributed to the release over the course of 214 calendar days.
 - 238 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - [fix] Write changelog ([`4324447`](https://github.com/sayanarijit/ansi-to-tui/commit/4324447763d9760ee1364d78e3392fcefc078619))
    - Adjusting changelogs prior to release of ansi-to-tui v2.0.1 ([`874a3a8`](https://github.com/sayanarijit/ansi-to-tui/commit/874a3a8abf968b4112c454d231fa7dfb9c157a42))
    - [feat] CHANGELOGS Using cargo changelog ([`604e1d1`](https://github.com/sayanarijit/ansi-to-tui/commit/604e1d1ca493706c090c4535fb0be019757ed250))
    - [fix] Bump version prep for release ([`8e07c79`](https://github.com/sayanarijit/ansi-to-tui/commit/8e07c79c42b1b831570cd25027ec48bc83b30fc2))
    - Add fg/bg colors for 90-110 ANSI code range ([`1bd18a9`](https://github.com/sayanarijit/ansi-to-tui/commit/1bd18a9ab1424d2a1bd785515384aab4d58f07cf))
    - [fix] Don't include the empty spans but keep changing the style ([`acdb671`](https://github.com/sayanarijit/ansi-to-tui/commit/acdb671763c655727f7b5fee9d867ac977d97070))
    - [fix] Don't exclude empty spans ([`0d1e9bc`](https://github.com/sayanarijit/ansi-to-tui/commit/0d1e9bc1786886aec7e1f4ddf058b278793b928a))
    - Fix infinite loop on unsupported escape sequences ([`225669f`](https://github.com/sayanarijit/ansi-to-tui/commit/225669ff1849326dbd20d90639ce86243b8eb5dd))
    - Add test for infinitely looping cases ([`8a59123`](https://github.com/sayanarijit/ansi-to-tui/commit/8a5912326da52c7fed32e815339664d7acd61a64))
    - [update] Version bump ([`0f2ace5`](https://github.com/sayanarijit/ansi-to-tui/commit/0f2ace5449fce46fbf891e4899afc27226f3932e))
    - [fix] Don't hang on screen modes ([`189d9c5`](https://github.com/sayanarijit/ansi-to-tui/commit/189d9c5021e8b69c046be4a4c2cd78095154dc45))
</details>

## v1.0.1 (2022-07-20)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 2 commits contributed to the release.
 - 174 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Update the readme example ([`a527ba0`](https://github.com/sayanarijit/ansi-to-tui/commit/a527ba066f0a9bdc924849a9c086989ebda5f8c0))
    - Complete rewrite of the whole parser logic ([`0e28929`](https://github.com/sayanarijit/ansi-to-tui/commit/0e289299a123635185f9907a01a379a51009f52b))
</details>

## v0.5.0 (2022-01-27)

## 0.5.0-sayanarijit (2022-01-27)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 4 commits contributed to the release over the course of 109 calendar days.
 - 120 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Bump version to 0.5.0 for tui 0.17.0 ([`92736b3`](https://github.com/sayanarijit/ansi-to-tui/commit/92736b3a6d8cf1f6f0225ed3f95aabe1d27efcf8))
    - Possibly fix #10 ([`5127c8c`](https://github.com/sayanarijit/ansi-to-tui/commit/5127c8c2016b76c0c9c64cc60d187bea37e2e685))
    - Add drone build badge ([`2871347`](https://github.com/sayanarijit/ansi-to-tui/commit/28713475a094612bf894603c720095a243801b24))
    - Add .drone.yml ([`e08a9d8`](https://github.com/sayanarijit/ansi-to-tui/commit/e08a9d8281bcbc31a419b33897c79e62544acd98))
</details>

## v0.4.1 (2021-09-28)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 1 commit contributed to the release.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - V0.4.1 ([`5225ac3`](https://github.com/sayanarijit/ansi-to-tui/commit/5225ac3f4ab26329e0aff938e25e2d123c25d9f0))
</details>

## v0.3.1 (2021-09-28)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 6 commits contributed to the release over the course of 37 calendar days.
 - 119 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Update version and fix #9 release ([`e2d7656`](https://github.com/sayanarijit/ansi-to-tui/commit/e2d7656587d7edf313faa2201e0d1f261530b91a))
    - Remove redundant println! lines ([`c108aea`](https://github.com/sayanarijit/ansi-to-tui/commit/c108aea34e7e42ee1ed43c162d0720db546a814d))
    - Fix #9 Color reset not working ([`c159a29`](https://github.com/sayanarijit/ansi-to-tui/commit/c159a29de0ee518037eebfb2f789015379d83d8e))
    - Update readme #8 ([`869a5f4`](https://github.com/sayanarijit/ansi-to-tui/commit/869a5f48f23e4d55eb5c8db24101b0b653c2ca01))
    - Center 2nd column ([`7259a48`](https://github.com/sayanarijit/ansi-to-tui/commit/7259a483aa2654e518ff691a9cc487ca3110e024))
    - Give the README a new look ([`5555bfb`](https://github.com/sayanarijit/ansi-to-tui/commit/5555bfbe825711b9fbbaec3d539c7546da155edb))
</details>

## v0.3.0 (2021-06-01)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 1 commit contributed to the release.
 - 5 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Update tui to version v0.15.0 ([`f68a55d`](https://github.com/sayanarijit/ansi-to-tui/commit/f68a55de4ed496767b7063212e0430f66d78e03b))
</details>

## v0.2.1 (2021-05-27)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 5 commits contributed to the release over the course of 2 calendar days.
 - 2 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Remove println! and bump version ([`7f0ad21`](https://github.com/sayanarijit/ansi-to-tui/commit/7f0ad21e3701f110f0d56c666e561e1195be3ff6))
    - Remove println! ([`88da943`](https://github.com/sayanarijit/ansi-to-tui/commit/88da943d7300fdc1a867d1b03db33578f3ca7974))
    - Merge branch 'master' of gh:uttarayan21/ansi-to-tui ([`9bcd9c9`](https://github.com/sayanarijit/ansi-to-tui/commit/9bcd9c9d78f4fb33521aef08385b35f0013974c3))
    - Possible fix for #3 ([`7c41742`](https://github.com/sayanarijit/ansi-to-tui/commit/7c41742b2a8665a60c3798da0859b8087f695c9c))
    - Implement StdError and thus, supporting anyhow ([`47d7ac3`](https://github.com/sayanarijit/ansi-to-tui/commit/47d7ac37d830d676fafea8528d8080d53751b1fc))
</details>

## v0.2.0 (2021-05-24)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 2 commits contributed to the release.
 - 17 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Fix spelling in documentation and bump version ([`69a8b4c`](https://github.com/sayanarijit/ansi-to-tui/commit/69a8b4cbbb1d7c80592542674653ce8e13e444c8))
    - Fix for #2 ([`985fe88`](https://github.com/sayanarijit/ansi-to-tui/commit/985fe8811ec9d651e034235d88ce5cd68d7d660b))
</details>

## v0.1.9 (2021-05-07)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 8 commits contributed to the release over the course of 5 calendar days.
 - 6 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Removed AnsiColor enum ([`aa17233`](https://github.com/sayanarijit/ansi-to-tui/commit/aa1723376985bd4c457b8780d576daa09bf42d34))
    - Minor changes to documentation ([`de7091d`](https://github.com/sayanarijit/ansi-to-tui/commit/de7091daf5e333f7a4b8d3d5aa21b33d6c5b20e6))
    - Minor changes ([`d7fb6e6`](https://github.com/sayanarijit/ansi-to-tui/commit/d7fb6e6d451f7a5296a122db79ec4ef6f6565882))
    - Removed useless AnsiColor enum ([`c66ca17`](https://github.com/sayanarijit/ansi-to-tui/commit/c66ca173845267f834adc97c94a19842499caada))
    - Bump version number ([`6818ee5`](https://github.com/sayanarijit/ansi-to-tui/commit/6818ee5f6e06f59e4569e2bfced65fcd88a24aa2))
    - Keep empty newlines ([`6a80c08`](https://github.com/sayanarijit/ansi-to-tui/commit/6a80c086394e23e380acdfecf16b6159c44846ca))
    - Bump version to 0.1.7 ([`6203e87`](https://github.com/sayanarijit/ansi-to-tui/commit/6203e877974a83eadd273be329b45afc17246cd3))
    - Pub fn ansi_to_text_override_style ([`0694221`](https://github.com/sayanarijit/ansi-to-tui/commit/0694221f34a468ab9dd1070e7b2b363876e65791))
</details>

## v0.1.6 (2021-04-30)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 4 commits contributed to the release.
 - 1 day passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 1 unique issue was worked on: [#1](https://github.com/sayanarijit/ansi-to-tui/issues/1)

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **[#1](https://github.com/sayanarijit/ansi-to-tui/issues/1)**
    - Optimize output text size ([`28c9077`](https://github.com/sayanarijit/ansi-to-tui/commit/28c9077a767a14337d8636c1cd47513d53e88711))
 * **Uncategorized**
    - Prepare from release ([`8ad6643`](https://github.com/sayanarijit/ansi-to-tui/commit/8ad6643545b74a0ca0d2dfc3d9857923fe85df81))
    - Fix tests paths ([`a4e50fa`](https://github.com/sayanarijit/ansi-to-tui/commit/a4e50faef2f18328a65f61f066b67eec8fe88bf4))
    - Bump simdutf8 to v0.1.1 ([`2e47e63`](https://github.com/sayanarijit/ansi-to-tui/commit/2e47e63b3f9c03df5a62407e1a494400bfe55e0f))
</details>

## v0.1.5 (2021-04-29)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 18 commits contributed to the release over the course of 4 calendar days.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Newlines with empty buffers are now shown correctly ([`dce8cf1`](https://github.com/sayanarijit/ansi-to-tui/commit/dce8cf1e5194813936987c9e5cd18f488b8a9409))
    - Add additional test ([`371bd6f`](https://github.com/sayanarijit/ansi-to-tui/commit/371bd6fe5cb8f01c5f2aba1f62b3fa65c74150bc))
    - Change AsRef<[u8]> to IntoIterator<Item = u8> ([`83ccd02`](https://github.com/sayanarijit/ansi-to-tui/commit/83ccd025e021df414cda6fdfbbae8b5e2d49fe13))
    - Large refactor ([`51481fa`](https://github.com/sayanarijit/ansi-to-tui/commit/51481fa9323c45036083ccecd677f42bdb3af1b9))
    - Added tests ([`03b623e`](https://github.com/sayanarijit/ansi-to-tui/commit/03b623ec150bd25a55d98f24818c19cb9e20e931))
    - Add additional tests ([`39f69a2`](https://github.com/sayanarijit/ansi-to-tui/commit/39f69a24b139eb226cabc484ea61a28d86cea1e6))
    - Refactor ([`4c354d5`](https://github.com/sayanarijit/ansi-to-tui/commit/4c354d5c00ed5bbbd01aea3d3e3dfc4ec01aebd3))
    - Allow empty ([`47bc5dd`](https://github.com/sayanarijit/ansi-to-tui/commit/47bc5dd13b03b17da9df8cf746fac6fecfaf7858))
    - Added Documentation badge. ([`8972553`](https://github.com/sayanarijit/ansi-to-tui/commit/8972553bc2f3d77b9fcdb47290c3c67a01d908c5))
    - Added documentation workflow ([`628d8ab`](https://github.com/sayanarijit/ansi-to-tui/commit/628d8abff0993bb6b3afde4915a866a335c1b1d3))
    - Added unicode_width check ([`a3585ba`](https://github.com/sayanarijit/ansi-to-tui/commit/a3585bad0004a03223174bb94376e985813d8fd9))
    - Removed a lot of unnsecessary code. ([`6e2e4dd`](https://github.com/sayanarijit/ansi-to-tui/commit/6e2e4ddc0849f39721a27cfe5bdf55db6f9d7bbd))
    - Somewhat fixed ([`8581b1a`](https://github.com/sayanarijit/ansi-to-tui/commit/8581b1ab0f9840391505f808d24ece44e49a2ef4))
    - Temp fix ([`486c3c9`](https://github.com/sayanarijit/ansi-to-tui/commit/486c3c98ddce0a954e1807f277c9f2d40a8f62ca))
    - Possible fix ([`ec38cb3`](https://github.com/sayanarijit/ansi-to-tui/commit/ec38cb3e62ffcf06b33db28b57fbb6ab214571d1))
    - Pub use ansi::ansi_to_text ([`ed57ab3`](https://github.com/sayanarijit/ansi-to-tui/commit/ed57ab359825a04dcdf866cdd6f58bd4b15caea2))
    - Change from ansitui to ansi-to-tui ([`43b1562`](https://github.com/sayanarijit/ansi-to-tui/commit/43b15627111b8742749acf73232a18378423c05a))
    - Initial Commit. ([`4cd9c8f`](https://github.com/sayanarijit/ansi-to-tui/commit/4cd9c8fc0b5bf1d6fd1274dcf34561b76d186d32))
</details>
