/* automatically generated by rust-bindgen 0.72.0 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
pub const BSD: u32 = 199506;
pub const BSD4_3: u32 = 1;
pub const BSD4_4: u32 = 1;
pub const NeXTBSD: u32 = 1995064;
pub const NeXTBSD4_0: u32 = 0;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 0;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_ONLY_VERS_1050: u32 = 0;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_64_BIT_INO_T: &[u8; 9] = b"$INODE64\0";
pub const __DARWIN_SUF_1050: &[u8; 6] = b"$1050\0";
pub const __DARWIN_SUF_EXTSN: &[u8; 14] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __has_ptrcheck: u32 = 0;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_MACOS: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_IOS: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_TVOS: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_WATCHOS: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_MACCATALYST: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_DRIVERKIT: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_14_6: u32 = 101406;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __MAC_10_16: u32 = 101600;
pub const __MAC_11_0: u32 = 110000;
pub const __MAC_11_1: u32 = 110100;
pub const __MAC_11_3: u32 = 110300;
pub const __MAC_11_4: u32 = 110400;
pub const __MAC_11_5: u32 = 110500;
pub const __MAC_11_6: u32 = 110600;
pub const __MAC_12_0: u32 = 120000;
pub const __MAC_12_1: u32 = 120100;
pub const __MAC_12_2: u32 = 120200;
pub const __MAC_12_3: u32 = 120300;
pub const __MAC_13_0: u32 = 130000;
pub const __MAC_13_1: u32 = 130100;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_12_4: u32 = 120400;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __IPHONE_13_7: u32 = 130700;
pub const __IPHONE_14_0: u32 = 140000;
pub const __IPHONE_14_1: u32 = 140100;
pub const __IPHONE_14_2: u32 = 140200;
pub const __IPHONE_14_3: u32 = 140300;
pub const __IPHONE_14_5: u32 = 140500;
pub const __IPHONE_14_6: u32 = 140600;
pub const __IPHONE_14_7: u32 = 140700;
pub const __IPHONE_14_8: u32 = 140800;
pub const __IPHONE_15_0: u32 = 150000;
pub const __IPHONE_15_1: u32 = 150100;
pub const __IPHONE_15_2: u32 = 150200;
pub const __IPHONE_15_3: u32 = 150300;
pub const __IPHONE_15_4: u32 = 150400;
pub const __IPHONE_16_0: u32 = 160000;
pub const __IPHONE_16_1: u32 = 160100;
pub const __IPHONE_16_2: u32 = 160200;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_12_4: u32 = 120400;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __TVOS_14_0: u32 = 140000;
pub const __TVOS_14_1: u32 = 140100;
pub const __TVOS_14_2: u32 = 140200;
pub const __TVOS_14_3: u32 = 140300;
pub const __TVOS_14_5: u32 = 140500;
pub const __TVOS_14_6: u32 = 140600;
pub const __TVOS_14_7: u32 = 140700;
pub const __TVOS_15_0: u32 = 150000;
pub const __TVOS_15_1: u32 = 150100;
pub const __TVOS_15_2: u32 = 150200;
pub const __TVOS_15_3: u32 = 150300;
pub const __TVOS_15_4: u32 = 150400;
pub const __TVOS_16_0: u32 = 160000;
pub const __TVOS_16_1: u32 = 160100;
pub const __TVOS_16_2: u32 = 160200;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_5_3: u32 = 50300;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __WATCHOS_7_0: u32 = 70000;
pub const __WATCHOS_7_1: u32 = 70100;
pub const __WATCHOS_7_2: u32 = 70200;
pub const __WATCHOS_7_3: u32 = 70300;
pub const __WATCHOS_7_4: u32 = 70400;
pub const __WATCHOS_7_5: u32 = 70500;
pub const __WATCHOS_7_6: u32 = 70600;
pub const __WATCHOS_8_0: u32 = 80000;
pub const __WATCHOS_8_1: u32 = 80100;
pub const __WATCHOS_8_3: u32 = 80300;
pub const __WATCHOS_8_4: u32 = 80400;
pub const __WATCHOS_8_5: u32 = 80500;
pub const __WATCHOS_9_0: u32 = 90000;
pub const __WATCHOS_9_1: u32 = 90100;
pub const __WATCHOS_9_2: u32 = 90200;
pub const MAC_OS_X_VERSION_10_0: u32 = 1000;
pub const MAC_OS_X_VERSION_10_1: u32 = 1010;
pub const MAC_OS_X_VERSION_10_2: u32 = 1020;
pub const MAC_OS_X_VERSION_10_3: u32 = 1030;
pub const MAC_OS_X_VERSION_10_4: u32 = 1040;
pub const MAC_OS_X_VERSION_10_5: u32 = 1050;
pub const MAC_OS_X_VERSION_10_6: u32 = 1060;
pub const MAC_OS_X_VERSION_10_7: u32 = 1070;
pub const MAC_OS_X_VERSION_10_8: u32 = 1080;
pub const MAC_OS_X_VERSION_10_9: u32 = 1090;
pub const MAC_OS_X_VERSION_10_10: u32 = 101000;
pub const MAC_OS_X_VERSION_10_10_2: u32 = 101002;
pub const MAC_OS_X_VERSION_10_10_3: u32 = 101003;
pub const MAC_OS_X_VERSION_10_11: u32 = 101100;
pub const MAC_OS_X_VERSION_10_11_2: u32 = 101102;
pub const MAC_OS_X_VERSION_10_11_3: u32 = 101103;
pub const MAC_OS_X_VERSION_10_11_4: u32 = 101104;
pub const MAC_OS_X_VERSION_10_12: u32 = 101200;
pub const MAC_OS_X_VERSION_10_12_1: u32 = 101201;
pub const MAC_OS_X_VERSION_10_12_2: u32 = 101202;
pub const MAC_OS_X_VERSION_10_12_4: u32 = 101204;
pub const MAC_OS_X_VERSION_10_13: u32 = 101300;
pub const MAC_OS_X_VERSION_10_13_1: u32 = 101301;
pub const MAC_OS_X_VERSION_10_13_2: u32 = 101302;
pub const MAC_OS_X_VERSION_10_13_4: u32 = 101304;
pub const MAC_OS_X_VERSION_10_14: u32 = 101400;
pub const MAC_OS_X_VERSION_10_14_1: u32 = 101401;
pub const MAC_OS_X_VERSION_10_14_4: u32 = 101404;
pub const MAC_OS_X_VERSION_10_14_6: u32 = 101406;
pub const MAC_OS_X_VERSION_10_15: u32 = 101500;
pub const MAC_OS_X_VERSION_10_15_1: u32 = 101501;
pub const MAC_OS_X_VERSION_10_16: u32 = 101600;
pub const MAC_OS_VERSION_11_0: u32 = 110000;
pub const MAC_OS_VERSION_12_0: u32 = 120000;
pub const MAC_OS_VERSION_13_0: u32 = 130000;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __DRIVERKIT_20_0: u32 = 200000;
pub const __DRIVERKIT_21_0: u32 = 210000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 130100;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __DARWIN_FD_SETSIZE: u32 = 1024;
pub const __DARWIN_NBBY: u32 = 8;
pub const NBBY: u32 = 8;
pub const FD_SETSIZE: u32 = 1024;
pub const ARG_MAX: u32 = 1048576;
pub const CHILD_MAX: u32 = 266;
pub const GID_MAX: u32 = 2147483647;
pub const LINK_MAX: u32 = 32767;
pub const MAX_CANON: u32 = 1024;
pub const MAX_INPUT: u32 = 1024;
pub const NAME_MAX: u32 = 255;
pub const NGROUPS_MAX: u32 = 16;
pub const UID_MAX: u32 = 2147483647;
pub const OPEN_MAX: u32 = 10240;
pub const PATH_MAX: u32 = 1024;
pub const PIPE_BUF: u32 = 512;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const CHARCLASS_NAME_MAX: u32 = 14;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EQUIV_CLASS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 255;
pub const NZERO: u32 = 20;
pub const MAXCOMLEN: u32 = 16;
pub const MAXINTERP: u32 = 64;
pub const MAXLOGNAME: u32 = 255;
pub const MAXUPRC: u32 = 266;
pub const NCARGS: u32 = 1048576;
pub const NGROUPS: u32 = 16;
pub const NOFILE: u32 = 256;
pub const NOGROUP: u32 = 65535;
pub const MAXHOSTNAMELEN: u32 = 256;
pub const MAXDOMNAMELEN: u32 = 256;
pub const NBPG: u32 = 4096;
pub const PGOFSET: u32 = 4095;
pub const PGSHIFT: u32 = 12;
pub const DEV_BSIZE: u32 = 512;
pub const DEV_BSHIFT: u32 = 9;
pub const BLKDEV_IOSIZE: u32 = 2048;
pub const MAXPHYS: u32 = 131072;
pub const CLSIZE: u32 = 1;
pub const CLSIZELOG2: u32 = 0;
pub const MSIZESHIFT: u32 = 8;
pub const MSIZE: u32 = 256;
pub const MCLSHIFT: u32 = 11;
pub const MCLBYTES: u32 = 2048;
pub const MBIGCLSHIFT: u32 = 12;
pub const MBIGCLBYTES: u32 = 4096;
pub const M16KCLSHIFT: u32 = 14;
pub const M16KCLBYTES: u32 = 16384;
pub const MCLOFSET: u32 = 2047;
pub const NMBCLUSTERS: u32 = 512;
pub const __DARWIN_CLK_TCK: u32 = 100;
pub const CHAR_BIT: u32 = 8;
pub const MB_LEN_MAX: u32 = 6;
pub const CLK_TCK: u32 = 100;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MAX: u32 = 127;
pub const CHAR_MIN: i32 = -128;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: i32 = -1;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const LONG_BIT: u32 = 64;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const WORD_BIT: u32 = 32;
pub const SIZE_T_MAX: i32 = -1;
pub const UQUAD_MAX: i32 = -1;
pub const QUAD_MAX: u64 = 9223372036854775807;
pub const QUAD_MIN: i64 = -9223372036854775808;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_EQUIV_CLASS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_KEYS_MAX: u32 = 512;
pub const PTHREAD_STACK_MIN: u32 = 8192;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const OFF_MIN: i64 = -9223372036854775808;
pub const OFF_MAX: u64 = 9223372036854775807;
pub const PASS_MAX: u32 = 128;
pub const NL_ARGMAX: u32 = 9;
pub const NL_LANGMAX: u32 = 14;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_NMAX: u32 = 1;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 2048;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const IOV_MAX: u32 = 1024;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _I386_SIGNAL_H_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const FP_PREC_24B: u32 = 0;
pub const FP_PREC_53B: u32 = 2;
pub const FP_PREC_64B: u32 = 3;
pub const FP_RND_NEAR: u32 = 0;
pub const FP_RND_DOWN: u32 = 1;
pub const FP_RND_UP: u32 = 2;
pub const FP_CHOP: u32 = 3;
pub const FP_STATE_BYTES: u32 = 512;
pub const _X86_INSTRUCTION_STATE_MAX_INSN_BYTES: u32 = 2380;
pub const _X86_INSTRUCTION_STATE_CACHELINE_SIZE: u32 = 64;
pub const __LASTBRANCH_MAX: u32 = 32;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const PSWP: u32 = 0;
pub const PVM: u32 = 4;
pub const PINOD: u32 = 8;
pub const PRIBIO: u32 = 16;
pub const PVFS: u32 = 20;
pub const PZERO: u32 = 22;
pub const PSOCK: u32 = 24;
pub const PWAIT: u32 = 32;
pub const PLOCK: u32 = 36;
pub const PPAUSE: u32 = 40;
pub const PUSER: u32 = 50;
pub const MAXPRI: u32 = 127;
pub const PRIMASK: u32 = 255;
pub const PCATCH: u32 = 256;
pub const PTTYBLOCK: u32 = 512;
pub const PDROP: u32 = 1024;
pub const PSPIN: u32 = 2048;
pub const CMASK: u32 = 18;
pub const CLBYTES: u32 = 4096;
pub const CLOFSET: u32 = 4095;
pub const CLOFF: u32 = 4095;
pub const CLSHIFT: u32 = 12;
pub const CBLOCK: u32 = 64;
pub const CBQSIZE: u32 = 8;
pub const CROUND: u32 = 63;
pub const MAXBSIZE: u32 = 1048576;
pub const MAXPHYSIO: u32 = 131072;
pub const MAXFRAG: u32 = 8;
pub const MAXPHYSIO_WIRED: u32 = 16777216;
pub const MAXPATHLEN: u32 = 1024;
pub const MAXSYMLINKS: u32 = 32;
pub const FSHIFT: u32 = 11;
pub const FSCALE: u32 = 2048;
pub const ITIMER_REAL: u32 = 0;
pub const ITIMER_VIRTUAL: u32 = 1;
pub const ITIMER_PROF: u32 = 2;
pub const DST_NONE: u32 = 0;
pub const DST_USA: u32 = 1;
pub const DST_AUST: u32 = 2;
pub const DST_WET: u32 = 3;
pub const DST_MET: u32 = 4;
pub const DST_EET: u32 = 5;
pub const DST_CAN: u32 = 6;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const TIME_UTC: u32 = 1;
pub const AUDIT_RECORD_MAGIC: u32 = 2190085915;
pub const MAX_AUDIT_RECORDS: u32 = 20;
pub const MAXAUDITDATA: u32 = 32767;
pub const MAX_AUDIT_RECORD_SIZE: u32 = 32767;
pub const MIN_AUDIT_FILE_SIZE: u32 = 524288;
pub const AUDIT_HARD_LIMIT_FREE_BLOCKS: u32 = 4;
pub const AUDIT_TRIGGER_MIN: u32 = 1;
pub const AUDIT_TRIGGER_LOW_SPACE: u32 = 1;
pub const AUDIT_TRIGGER_ROTATE_KERNEL: u32 = 2;
pub const AUDIT_TRIGGER_READ_FILE: u32 = 3;
pub const AUDIT_TRIGGER_CLOSE_AND_DIE: u32 = 4;
pub const AUDIT_TRIGGER_NO_SPACE: u32 = 5;
pub const AUDIT_TRIGGER_ROTATE_USER: u32 = 6;
pub const AUDIT_TRIGGER_INITIALIZE: u32 = 7;
pub const AUDIT_TRIGGER_EXPIRE_TRAILS: u32 = 8;
pub const AUDIT_TRIGGER_MAX: u32 = 8;
pub const AUDITDEV_FILENAME: &[u8; 6] = b"audit\0";
pub const AUDIT_TRIGGER_FILE: &[u8; 11] = b"/dev/audit\0";
pub const AU_DEFAUDITSID: u32 = 0;
pub const AU_ASSIGN_ASID: i32 = -1;
pub const AUC_UNSET: u32 = 0;
pub const AUC_AUDITING: u32 = 1;
pub const AUC_NOAUDIT: u32 = 2;
pub const AUC_DISABLED: i32 = -1;
pub const A_OLDGETPOLICY: u32 = 2;
pub const A_OLDSETPOLICY: u32 = 3;
pub const A_GETKMASK: u32 = 4;
pub const A_SETKMASK: u32 = 5;
pub const A_OLDGETQCTRL: u32 = 6;
pub const A_OLDSETQCTRL: u32 = 7;
pub const A_GETCWD: u32 = 8;
pub const A_GETCAR: u32 = 9;
pub const A_GETSTAT: u32 = 12;
pub const A_SETSTAT: u32 = 13;
pub const A_SETUMASK: u32 = 14;
pub const A_SETSMASK: u32 = 15;
pub const A_OLDGETCOND: u32 = 20;
pub const A_OLDSETCOND: u32 = 21;
pub const A_GETCLASS: u32 = 22;
pub const A_SETCLASS: u32 = 23;
pub const A_GETPINFO: u32 = 24;
pub const A_SETPMASK: u32 = 25;
pub const A_SETFSIZE: u32 = 26;
pub const A_GETFSIZE: u32 = 27;
pub const A_GETPINFO_ADDR: u32 = 28;
pub const A_GETKAUDIT: u32 = 29;
pub const A_SETKAUDIT: u32 = 30;
pub const A_SENDTRIGGER: u32 = 31;
pub const A_GETSINFO_ADDR: u32 = 32;
pub const A_GETPOLICY: u32 = 33;
pub const A_SETPOLICY: u32 = 34;
pub const A_GETQCTRL: u32 = 35;
pub const A_SETQCTRL: u32 = 36;
pub const A_GETCOND: u32 = 37;
pub const A_SETCOND: u32 = 38;
pub const A_GETSFLAGS: u32 = 39;
pub const A_SETSFLAGS: u32 = 40;
pub const A_GETCTLMODE: u32 = 41;
pub const A_SETCTLMODE: u32 = 42;
pub const A_GETEXPAFTER: u32 = 43;
pub const A_SETEXPAFTER: u32 = 44;
pub const AUDIT_CNT: u32 = 1;
pub const AUDIT_AHLT: u32 = 2;
pub const AUDIT_ARGV: u32 = 4;
pub const AUDIT_ARGE: u32 = 8;
pub const AUDIT_SEQ: u32 = 16;
pub const AUDIT_WINDATA: u32 = 32;
pub const AUDIT_USER: u32 = 64;
pub const AUDIT_GROUP: u32 = 128;
pub const AUDIT_TRAIL: u32 = 256;
pub const AUDIT_PATH: u32 = 512;
pub const AUDIT_SCNT: u32 = 1024;
pub const AUDIT_PUBLIC: u32 = 2048;
pub const AUDIT_ZONENAME: u32 = 4096;
pub const AUDIT_PERZONE: u32 = 8192;
pub const AQ_HIWATER: u32 = 100;
pub const AQ_MAXHIGH: u32 = 10000;
pub const AQ_LOWATER: u32 = 10;
pub const AQ_BUFSZ: u32 = 32767;
pub const AQ_MAXBUFSZ: u32 = 1048576;
pub const AU_FS_MINFREE: u32 = 20;
pub const AU_IPv4: u32 = 4;
pub const AU_IPv6: u32 = 16;
pub const AU_CLASS_MASK_RESERVED: u32 = 268435456;
pub const __WORDSIZE: u32 = 64;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const TRUE: u32 = 1;
pub const FALSE: u32 = 0;
pub const MACH_PORT_NULL: u32 = 0;
pub const MACH_PORT_TYPE_DNREQUEST: u32 = 2147483648;
pub const MACH_PORT_TYPE_SPREQUEST: u32 = 1073741824;
pub const MACH_PORT_TYPE_SPREQUEST_DELAYED: u32 = 536870912;
pub const MACH_PORT_SRIGHTS_NONE: u32 = 0;
pub const MACH_PORT_SRIGHTS_PRESENT: u32 = 1;
pub const MACH_PORT_QLIMIT_ZERO: u32 = 0;
pub const MACH_PORT_QLIMIT_BASIC: u32 = 5;
pub const MACH_PORT_QLIMIT_SMALL: u32 = 16;
pub const MACH_PORT_QLIMIT_LARGE: u32 = 1024;
pub const MACH_PORT_QLIMIT_KERNEL: u32 = 65534;
pub const MACH_PORT_QLIMIT_MIN: u32 = 0;
pub const MACH_PORT_QLIMIT_DEFAULT: u32 = 5;
pub const MACH_PORT_QLIMIT_MAX: u32 = 1024;
pub const MACH_PORT_STATUS_FLAG_TEMPOWNER: u32 = 1;
pub const MACH_PORT_STATUS_FLAG_GUARDED: u32 = 2;
pub const MACH_PORT_STATUS_FLAG_STRICT_GUARD: u32 = 4;
pub const MACH_PORT_STATUS_FLAG_IMP_DONATION: u32 = 8;
pub const MACH_PORT_STATUS_FLAG_REVIVE: u32 = 16;
pub const MACH_PORT_STATUS_FLAG_TASKPTR: u32 = 32;
pub const MACH_PORT_STATUS_FLAG_GUARD_IMMOVABLE_RECEIVE: u32 = 64;
pub const MACH_PORT_STATUS_FLAG_NO_GRANT: u32 = 128;
pub const MACH_PORT_LIMITS_INFO: u32 = 1;
pub const MACH_PORT_RECEIVE_STATUS: u32 = 2;
pub const MACH_PORT_DNREQUESTS_SIZE: u32 = 3;
pub const MACH_PORT_TEMPOWNER: u32 = 4;
pub const MACH_PORT_IMPORTANCE_RECEIVER: u32 = 5;
pub const MACH_PORT_DENAP_RECEIVER: u32 = 6;
pub const MACH_PORT_INFO_EXT: u32 = 7;
pub const MACH_PORT_GUARD_INFO: u32 = 8;
pub const MACH_PORT_DNREQUESTS_SIZE_COUNT: u32 = 1;
pub const MACH_SERVICE_PORT_INFO_STRING_NAME_MAX_BUF_LEN: u32 = 255;
pub const MPO_CONTEXT_AS_GUARD: u32 = 1;
pub const MPO_QLIMIT: u32 = 2;
pub const MPO_TEMPOWNER: u32 = 4;
pub const MPO_IMPORTANCE_RECEIVER: u32 = 8;
pub const MPO_INSERT_SEND_RIGHT: u32 = 16;
pub const MPO_STRICT: u32 = 32;
pub const MPO_DENAP_RECEIVER: u32 = 64;
pub const MPO_IMMOVABLE_RECEIVE: u32 = 128;
pub const MPO_FILTER_MSG: u32 = 256;
pub const MPO_TG_BLOCK_TRACKING: u32 = 512;
pub const MPO_SERVICE_PORT: u32 = 1024;
pub const MPO_CONNECTION_PORT: u32 = 2048;
pub const MPO_REPLY_PORT: u32 = 4096;
pub const MPO_ENFORCE_REPLY_PORT_SEMANTICS: u32 = 8192;
pub const MPO_PROVISIONAL_REPLY_PORT: u32 = 16384;
pub const GUARD_TYPE_MACH_PORT: u32 = 1;
pub const MAX_FATAL_kGUARD_EXC_CODE: u32 = 128;
pub const MPG_FLAGS_NONE: u32 = 0;
pub const MAX_OPTIONAL_kGUARD_EXC_CODE: u32 = 524288;
pub const MPG_FLAGS_STRICT_REPLY_INVALID_REPLY_DISP: u64 = 72057594037927936;
pub const MPG_FLAGS_STRICT_REPLY_INVALID_REPLY_PORT: u64 = 144115188075855872;
pub const MPG_FLAGS_STRICT_REPLY_INVALID_VOUCHER: u64 = 288230376151711744;
pub const MPG_FLAGS_STRICT_REPLY_NO_BANK_ATTR: u64 = 576460752303423488;
pub const MPG_FLAGS_STRICT_REPLY_MISMATCHED_PERSONA: u64 = 1152921504606846976;
pub const MPG_FLAGS_STRICT_REPLY_MASK: i64 = -72057594037927936;
pub const MPG_FLAGS_MOD_REFS_PINNED_DEALLOC: u64 = 72057594037927936;
pub const MPG_FLAGS_MOD_REFS_PINNED_DESTROY: u64 = 144115188075855872;
pub const MPG_FLAGS_MOD_REFS_PINNED_COPYIN: u64 = 288230376151711744;
pub const MPG_FLAGS_IMMOVABLE_PINNED: u64 = 72057594037927936;
pub const MPG_STRICT: u32 = 1;
pub const MPG_IMMOVABLE_RECEIVE: u32 = 2;
pub const CRF_NOMEMBERD: u32 = 1;
pub const CRF_MAC_ENFORCE: u32 = 2;
pub const XUCRED_VERSION: u32 = 0;
pub const EVFILT_READ: i32 = -1;
pub const EVFILT_WRITE: i32 = -2;
pub const EVFILT_AIO: i32 = -3;
pub const EVFILT_VNODE: i32 = -4;
pub const EVFILT_PROC: i32 = -5;
pub const EVFILT_SIGNAL: i32 = -6;
pub const EVFILT_TIMER: i32 = -7;
pub const EVFILT_MACHPORT: i32 = -8;
pub const EVFILT_FS: i32 = -9;
pub const EVFILT_USER: i32 = -10;
pub const EVFILT_VM: i32 = -12;
pub const EVFILT_EXCEPT: i32 = -15;
pub const EVFILT_SYSCOUNT: u32 = 17;
pub const EVFILT_THREADMARKER: u32 = 17;
pub const KEVENT_FLAG_NONE: u32 = 0;
pub const KEVENT_FLAG_IMMEDIATE: u32 = 1;
pub const KEVENT_FLAG_ERROR_EVENTS: u32 = 2;
pub const EV_ADD: u32 = 1;
pub const EV_DELETE: u32 = 2;
pub const EV_ENABLE: u32 = 4;
pub const EV_DISABLE: u32 = 8;
pub const EV_ONESHOT: u32 = 16;
pub const EV_CLEAR: u32 = 32;
pub const EV_RECEIPT: u32 = 64;
pub const EV_DISPATCH: u32 = 128;
pub const EV_UDATA_SPECIFIC: u32 = 256;
pub const EV_DISPATCH2: u32 = 384;
pub const EV_VANISHED: u32 = 512;
pub const EV_SYSFLAGS: u32 = 61440;
pub const EV_FLAG0: u32 = 4096;
pub const EV_FLAG1: u32 = 8192;
pub const EV_EOF: u32 = 32768;
pub const EV_ERROR: u32 = 16384;
pub const EV_POLL: u32 = 4096;
pub const EV_OOBAND: u32 = 8192;
pub const NOTE_TRIGGER: u32 = 16777216;
pub const NOTE_FFNOP: u32 = 0;
pub const NOTE_FFAND: u32 = 1073741824;
pub const NOTE_FFOR: u32 = 2147483648;
pub const NOTE_FFCOPY: u32 = 3221225472;
pub const NOTE_FFCTRLMASK: u32 = 3221225472;
pub const NOTE_FFLAGSMASK: u32 = 16777215;
pub const NOTE_LOWAT: u32 = 1;
pub const NOTE_OOB: u32 = 2;
pub const NOTE_DELETE: u32 = 1;
pub const NOTE_WRITE: u32 = 2;
pub const NOTE_EXTEND: u32 = 4;
pub const NOTE_ATTRIB: u32 = 8;
pub const NOTE_LINK: u32 = 16;
pub const NOTE_RENAME: u32 = 32;
pub const NOTE_REVOKE: u32 = 64;
pub const NOTE_NONE: u32 = 128;
pub const NOTE_FUNLOCK: u32 = 256;
pub const NOTE_LEASE_DOWNGRADE: u32 = 512;
pub const NOTE_LEASE_RELEASE: u32 = 1024;
pub const NOTE_EXIT: u32 = 2147483648;
pub const NOTE_FORK: u32 = 1073741824;
pub const NOTE_EXEC: u32 = 536870912;
pub const NOTE_SIGNAL: u32 = 134217728;
pub const NOTE_EXITSTATUS: u32 = 67108864;
pub const NOTE_EXIT_DETAIL: u32 = 33554432;
pub const NOTE_PDATAMASK: u32 = 1048575;
pub const NOTE_PCTRLMASK: i32 = -1048576;
pub const NOTE_EXIT_DETAIL_MASK: u32 = 458752;
pub const NOTE_EXIT_DECRYPTFAIL: u32 = 65536;
pub const NOTE_EXIT_MEMORY: u32 = 131072;
pub const NOTE_EXIT_CSERROR: u32 = 262144;
pub const NOTE_VM_PRESSURE: u32 = 2147483648;
pub const NOTE_VM_PRESSURE_TERMINATE: u32 = 1073741824;
pub const NOTE_VM_PRESSURE_SUDDEN_TERMINATE: u32 = 536870912;
pub const NOTE_VM_ERROR: u32 = 268435456;
pub const NOTE_SECONDS: u32 = 1;
pub const NOTE_USECONDS: u32 = 2;
pub const NOTE_NSECONDS: u32 = 4;
pub const NOTE_ABSOLUTE: u32 = 8;
pub const NOTE_LEEWAY: u32 = 16;
pub const NOTE_CRITICAL: u32 = 32;
pub const NOTE_BACKGROUND: u32 = 64;
pub const NOTE_MACH_CONTINUOUS_TIME: u32 = 128;
pub const NOTE_MACHTIME: u32 = 256;
pub const NOTE_TRACK: u32 = 1;
pub const NOTE_TRACKERR: u32 = 2;
pub const NOTE_CHILD: u32 = 4;
pub const SIDL: u32 = 1;
pub const SRUN: u32 = 2;
pub const SSLEEP: u32 = 3;
pub const SSTOP: u32 = 4;
pub const SZOMB: u32 = 5;
pub const P_ADVLOCK: u32 = 1;
pub const P_CONTROLT: u32 = 2;
pub const P_LP64: u32 = 4;
pub const P_NOCLDSTOP: u32 = 8;
pub const P_PPWAIT: u32 = 16;
pub const P_PROFIL: u32 = 32;
pub const P_SELECT: u32 = 64;
pub const P_CONTINUED: u32 = 128;
pub const P_SUGID: u32 = 256;
pub const P_SYSTEM: u32 = 512;
pub const P_TIMEOUT: u32 = 1024;
pub const P_TRACED: u32 = 2048;
pub const P_DISABLE_ASLR: u32 = 4096;
pub const P_WEXIT: u32 = 8192;
pub const P_EXEC: u32 = 16384;
pub const P_OWEUPC: u32 = 32768;
pub const P_AFFINITY: u32 = 65536;
pub const P_TRANSLATED: u32 = 131072;
pub const P_CLASSIC: u32 = 131072;
pub const P_DELAYIDLESLEEP: u32 = 262144;
pub const P_CHECKOPENEVT: u32 = 524288;
pub const P_DEPENDENCY_CAPABLE: u32 = 1048576;
pub const P_REBOOT: u32 = 2097152;
pub const P_RESV6: u32 = 4194304;
pub const P_RESV7: u32 = 8388608;
pub const P_THCWD: u32 = 16777216;
pub const P_RESV9: u32 = 33554432;
pub const P_ADOPTPERSONA: u32 = 67108864;
pub const P_RESV11: u32 = 134217728;
pub const P_NOSHLIB: u32 = 268435456;
pub const P_FORCEQUOTA: u32 = 536870912;
pub const P_NOCLDWAIT: u32 = 1073741824;
pub const P_NOREMOTEHANG: u32 = 2147483648;
pub const P_INMEM: u32 = 0;
pub const P_NOSWAP: u32 = 0;
pub const P_PHYSIO: u32 = 0;
pub const P_FSTRACE: u32 = 0;
pub const P_SSTEP: u32 = 0;
pub const P_DIRTY_TRACK: u32 = 1;
pub const P_DIRTY_ALLOW_IDLE_EXIT: u32 = 2;
pub const P_DIRTY_DEFER: u32 = 4;
pub const P_DIRTY: u32 = 8;
pub const P_DIRTY_SHUTDOWN: u32 = 16;
pub const P_DIRTY_TERMINATED: u32 = 32;
pub const P_DIRTY_BUSY: u32 = 64;
pub const P_DIRTY_MARKED: u32 = 128;
pub const P_DIRTY_AGING_IN_PROGRESS: u32 = 256;
pub const P_DIRTY_LAUNCH_IN_PROGRESS: u32 = 512;
pub const P_DIRTY_DEFER_ALWAYS: u32 = 1024;
pub const P_DIRTY_IS_DIRTY: u32 = 24;
pub const P_DIRTY_IDLE_EXIT_ENABLED: u32 = 3;
pub const CTL_MAXNAME: u32 = 12;
pub const CTLTYPE: u32 = 15;
pub const CTLTYPE_NODE: u32 = 1;
pub const CTLTYPE_INT: u32 = 2;
pub const CTLTYPE_STRING: u32 = 3;
pub const CTLTYPE_QUAD: u32 = 4;
pub const CTLTYPE_OPAQUE: u32 = 5;
pub const CTLTYPE_STRUCT: u32 = 5;
pub const CTLFLAG_RD: u32 = 2147483648;
pub const CTLFLAG_WR: u32 = 1073741824;
pub const CTLFLAG_RW: u32 = 3221225472;
pub const CTLFLAG_NOLOCK: u32 = 536870912;
pub const CTLFLAG_ANYBODY: u32 = 268435456;
pub const CTLFLAG_SECURE: u32 = 134217728;
pub const CTLFLAG_MASKED: u32 = 67108864;
pub const CTLFLAG_NOAUTO: u32 = 33554432;
pub const CTLFLAG_KERN: u32 = 16777216;
pub const CTLFLAG_LOCKED: u32 = 8388608;
pub const CTLFLAG_OID2: u32 = 4194304;
pub const CTLFLAG_EXPERIMENT: u32 = 1048576;
pub const OID_AUTO: i32 = -1;
pub const OID_AUTO_START: u32 = 100;
pub const CTL_UNSPEC: u32 = 0;
pub const CTL_KERN: u32 = 1;
pub const CTL_VM: u32 = 2;
pub const CTL_VFS: u32 = 3;
pub const CTL_NET: u32 = 4;
pub const CTL_DEBUG: u32 = 5;
pub const CTL_HW: u32 = 6;
pub const CTL_MACHDEP: u32 = 7;
pub const CTL_USER: u32 = 8;
pub const CTL_MAXID: u32 = 9;
pub const KERN_OSTYPE: u32 = 1;
pub const KERN_OSRELEASE: u32 = 2;
pub const KERN_OSREV: u32 = 3;
pub const KERN_VERSION: u32 = 4;
pub const KERN_MAXVNODES: u32 = 5;
pub const KERN_MAXPROC: u32 = 6;
pub const KERN_MAXFILES: u32 = 7;
pub const KERN_ARGMAX: u32 = 8;
pub const KERN_SECURELVL: u32 = 9;
pub const KERN_HOSTNAME: u32 = 10;
pub const KERN_HOSTID: u32 = 11;
pub const KERN_CLOCKRATE: u32 = 12;
pub const KERN_VNODE: u32 = 13;
pub const KERN_PROC: u32 = 14;
pub const KERN_FILE: u32 = 15;
pub const KERN_PROF: u32 = 16;
pub const KERN_POSIX1: u32 = 17;
pub const KERN_NGROUPS: u32 = 18;
pub const KERN_JOB_CONTROL: u32 = 19;
pub const KERN_SAVED_IDS: u32 = 20;
pub const KERN_BOOTTIME: u32 = 21;
pub const KERN_NISDOMAINNAME: u32 = 22;
pub const KERN_DOMAINNAME: u32 = 22;
pub const KERN_MAXPARTITIONS: u32 = 23;
pub const KERN_KDEBUG: u32 = 24;
pub const KERN_UPDATEINTERVAL: u32 = 25;
pub const KERN_OSRELDATE: u32 = 26;
pub const KERN_NTP_PLL: u32 = 27;
pub const KERN_BOOTFILE: u32 = 28;
pub const KERN_MAXFILESPERPROC: u32 = 29;
pub const KERN_MAXPROCPERUID: u32 = 30;
pub const KERN_DUMPDEV: u32 = 31;
pub const KERN_IPC: u32 = 32;
pub const KERN_DUMMY: u32 = 33;
pub const KERN_PS_STRINGS: u32 = 34;
pub const KERN_USRSTACK32: u32 = 35;
pub const KERN_LOGSIGEXIT: u32 = 36;
pub const KERN_SYMFILE: u32 = 37;
pub const KERN_PROCARGS: u32 = 38;
pub const KERN_NETBOOT: u32 = 40;
pub const KERN_SYSV: u32 = 42;
pub const KERN_AFFINITY: u32 = 43;
pub const KERN_TRANSLATE: u32 = 44;
pub const KERN_CLASSIC: u32 = 44;
pub const KERN_EXEC: u32 = 45;
pub const KERN_CLASSICHANDLER: u32 = 45;
pub const KERN_AIOMAX: u32 = 46;
pub const KERN_AIOPROCMAX: u32 = 47;
pub const KERN_AIOTHREADS: u32 = 48;
pub const KERN_PROCARGS2: u32 = 49;
pub const KERN_COREFILE: u32 = 50;
pub const KERN_COREDUMP: u32 = 51;
pub const KERN_SUGID_COREDUMP: u32 = 52;
pub const KERN_PROCDELAYTERM: u32 = 53;
pub const KERN_SHREG_PRIVATIZABLE: u32 = 54;
pub const KERN_LOW_PRI_WINDOW: u32 = 56;
pub const KERN_LOW_PRI_DELAY: u32 = 57;
pub const KERN_POSIX: u32 = 58;
pub const KERN_USRSTACK64: u32 = 59;
pub const KERN_NX_PROTECTION: u32 = 60;
pub const KERN_TFP: u32 = 61;
pub const KERN_PROCNAME: u32 = 62;
pub const KERN_THALTSTACK: u32 = 63;
pub const KERN_SPECULATIVE_READS: u32 = 64;
pub const KERN_OSVERSION: u32 = 65;
pub const KERN_SAFEBOOT: u32 = 66;
pub const KERN_RAGEVNODE: u32 = 68;
pub const KERN_TTY: u32 = 69;
pub const KERN_CHECKOPENEVT: u32 = 70;
pub const KERN_THREADNAME: u32 = 71;
pub const KERN_MAXID: u32 = 72;
pub const KERN_USRSTACK: u32 = 59;
pub const KERN_RAGE_PROC: u32 = 1;
pub const KERN_RAGE_THREAD: u32 = 2;
pub const KERN_UNRAGE_PROC: u32 = 3;
pub const KERN_UNRAGE_THREAD: u32 = 4;
pub const KERN_OPENEVT_PROC: u32 = 1;
pub const KERN_UNOPENEVT_PROC: u32 = 2;
pub const KERN_TFP_POLICY: u32 = 1;
pub const KERN_TFP_POLICY_DENY: u32 = 0;
pub const KERN_TFP_POLICY_DEFAULT: u32 = 2;
pub const KERN_KDEFLAGS: u32 = 1;
pub const KERN_KDDFLAGS: u32 = 2;
pub const KERN_KDENABLE: u32 = 3;
pub const KERN_KDSETBUF: u32 = 4;
pub const KERN_KDGETBUF: u32 = 5;
pub const KERN_KDSETUP: u32 = 6;
pub const KERN_KDREMOVE: u32 = 7;
pub const KERN_KDSETREG: u32 = 8;
pub const KERN_KDGETREG: u32 = 9;
pub const KERN_KDREADTR: u32 = 10;
pub const KERN_KDPIDTR: u32 = 11;
pub const KERN_KDTHRMAP: u32 = 12;
pub const KERN_KDPIDEX: u32 = 14;
pub const KERN_KDSETRTCDEC: u32 = 15;
pub const KERN_KDGETENTROPY: u32 = 16;
pub const KERN_KDWRITETR: u32 = 17;
pub const KERN_KDWRITEMAP: u32 = 18;
pub const KERN_KDTEST: u32 = 19;
pub const KERN_KDREADCURTHRMAP: u32 = 21;
pub const KERN_KDSET_TYPEFILTER: u32 = 22;
pub const KERN_KDBUFWAIT: u32 = 23;
pub const KERN_KDCPUMAP: u32 = 24;
pub const KERN_KDCPUMAP_EXT: u32 = 25;
pub const KERN_KDSET_EDM: u32 = 26;
pub const KERN_KDGET_EDM: u32 = 27;
pub const KERN_KDWRITETR_V3: u32 = 28;
pub const KERN_PROC_ALL: u32 = 0;
pub const KERN_PROC_PID: u32 = 1;
pub const KERN_PROC_PGRP: u32 = 2;
pub const KERN_PROC_SESSION: u32 = 3;
pub const KERN_PROC_TTY: u32 = 4;
pub const KERN_PROC_UID: u32 = 5;
pub const KERN_PROC_RUID: u32 = 6;
pub const KERN_PROC_LCID: u32 = 7;
pub const KERN_VFSNSPACE_HANDLE_PROC: u32 = 1;
pub const KERN_VFSNSPACE_UNHANDLE_PROC: u32 = 2;
pub const WMESGLEN: u32 = 7;
pub const EPROC_CTTY: u32 = 1;
pub const EPROC_SLEADER: u32 = 2;
pub const COMAPT_MAXLOGNAME: u32 = 12;
pub const KIPC_MAXSOCKBUF: u32 = 1;
pub const KIPC_SOCKBUF_WASTE: u32 = 2;
pub const KIPC_SOMAXCONN: u32 = 3;
pub const KIPC_MAX_LINKHDR: u32 = 4;
pub const KIPC_MAX_PROTOHDR: u32 = 5;
pub const KIPC_MAX_HDR: u32 = 6;
pub const KIPC_MAX_DATALEN: u32 = 7;
pub const KIPC_MBSTAT: u32 = 8;
pub const KIPC_NMBCLUSTERS: u32 = 9;
pub const KIPC_SOQLIMITCOMPAT: u32 = 10;
pub const VM_METER: u32 = 1;
pub const VM_LOADAVG: u32 = 2;
pub const VM_MACHFACTOR: u32 = 4;
pub const VM_SWAPUSAGE: u32 = 5;
pub const VM_MAXID: u32 = 6;
pub const LSCALE: u32 = 1000;
pub const HW_MACHINE: u32 = 1;
pub const HW_MODEL: u32 = 2;
pub const HW_NCPU: u32 = 3;
pub const HW_BYTEORDER: u32 = 4;
pub const HW_PHYSMEM: u32 = 5;
pub const HW_USERMEM: u32 = 6;
pub const HW_PAGESIZE: u32 = 7;
pub const HW_DISKNAMES: u32 = 8;
pub const HW_DISKSTATS: u32 = 9;
pub const HW_EPOCH: u32 = 10;
pub const HW_FLOATINGPT: u32 = 11;
pub const HW_MACHINE_ARCH: u32 = 12;
pub const HW_VECTORUNIT: u32 = 13;
pub const HW_BUS_FREQ: u32 = 14;
pub const HW_CPU_FREQ: u32 = 15;
pub const HW_CACHELINE: u32 = 16;
pub const HW_L1ICACHESIZE: u32 = 17;
pub const HW_L1DCACHESIZE: u32 = 18;
pub const HW_L2SETTINGS: u32 = 19;
pub const HW_L2CACHESIZE: u32 = 20;
pub const HW_L3SETTINGS: u32 = 21;
pub const HW_L3CACHESIZE: u32 = 22;
pub const HW_TB_FREQ: u32 = 23;
pub const HW_MEMSIZE: u32 = 24;
pub const HW_AVAILCPU: u32 = 25;
pub const HW_TARGET: u32 = 26;
pub const HW_PRODUCT: u32 = 27;
pub const HW_MAXID: u32 = 28;
pub const USER_CS_PATH: u32 = 1;
pub const USER_BC_BASE_MAX: u32 = 2;
pub const USER_BC_DIM_MAX: u32 = 3;
pub const USER_BC_SCALE_MAX: u32 = 4;
pub const USER_BC_STRING_MAX: u32 = 5;
pub const USER_COLL_WEIGHTS_MAX: u32 = 6;
pub const USER_EXPR_NEST_MAX: u32 = 7;
pub const USER_LINE_MAX: u32 = 8;
pub const USER_RE_DUP_MAX: u32 = 9;
pub const USER_POSIX2_VERSION: u32 = 10;
pub const USER_POSIX2_C_BIND: u32 = 11;
pub const USER_POSIX2_C_DEV: u32 = 12;
pub const USER_POSIX2_CHAR_TERM: u32 = 13;
pub const USER_POSIX2_FORT_DEV: u32 = 14;
pub const USER_POSIX2_FORT_RUN: u32 = 15;
pub const USER_POSIX2_LOCALEDEF: u32 = 16;
pub const USER_POSIX2_SW_DEV: u32 = 17;
pub const USER_POSIX2_UPE: u32 = 18;
pub const USER_STREAM_MAX: u32 = 19;
pub const USER_TZNAME_MAX: u32 = 20;
pub const USER_MAXID: u32 = 21;
pub const CTL_DEBUG_NAME: u32 = 0;
pub const CTL_DEBUG_VALUE: u32 = 1;
pub const CTL_DEBUG_MAXID: u32 = 20;
pub const KEV_INET_SUBCLASS: u32 = 1;
pub const KEV_INET_NEW_ADDR: u32 = 1;
pub const KEV_INET_CHANGED_ADDR: u32 = 2;
pub const KEV_INET_ADDR_DELETED: u32 = 3;
pub const KEV_INET_SIFDSTADDR: u32 = 4;
pub const KEV_INET_SIFBRDADDR: u32 = 5;
pub const KEV_INET_SIFNETMASK: u32 = 6;
pub const KEV_INET_ARPCOLLISION: u32 = 7;
pub const KEV_INET_PORTINUSE: u32 = 8;
pub const KEV_INET_ARPRTRFAILURE: u32 = 9;
pub const KEV_INET_ARPRTRALIVE: u32 = 10;
pub const KEV_DL_SUBCLASS: u32 = 2;
pub const KEV_DL_SIFFLAGS: u32 = 1;
pub const KEV_DL_SIFMETRICS: u32 = 2;
pub const KEV_DL_SIFMTU: u32 = 3;
pub const KEV_DL_SIFPHYS: u32 = 4;
pub const KEV_DL_SIFMEDIA: u32 = 5;
pub const KEV_DL_SIFGENERIC: u32 = 6;
pub const KEV_DL_ADDMULTI: u32 = 7;
pub const KEV_DL_DELMULTI: u32 = 8;
pub const KEV_DL_IF_ATTACHED: u32 = 9;
pub const KEV_DL_IF_DETACHING: u32 = 10;
pub const KEV_DL_IF_DETACHED: u32 = 11;
pub const KEV_DL_LINK_OFF: u32 = 12;
pub const KEV_DL_LINK_ON: u32 = 13;
pub const KEV_DL_PROTO_ATTACHED: u32 = 14;
pub const KEV_DL_PROTO_DETACHED: u32 = 15;
pub const KEV_DL_LINK_ADDRESS_CHANGED: u32 = 16;
pub const KEV_DL_WAKEFLAGS_CHANGED: u32 = 17;
pub const KEV_DL_IF_IDLE_ROUTE_REFCNT: u32 = 18;
pub const KEV_DL_IFCAP_CHANGED: u32 = 19;
pub const KEV_DL_LINK_QUALITY_METRIC_CHANGED: u32 = 20;
pub const KEV_DL_NODE_PRESENCE: u32 = 21;
pub const KEV_DL_NODE_ABSENCE: u32 = 22;
pub const KEV_DL_PRIMARY_ELECTED: u32 = 23;
pub const KEV_DL_ISSUES: u32 = 24;
pub const KEV_DL_IFDELEGATE_CHANGED: u32 = 25;
pub const KEV_DL_AWDL_RESTRICTED: u32 = 26;
pub const KEV_DL_AWDL_UNRESTRICTED: u32 = 27;
pub const KEV_DL_RRC_STATE_CHANGED: u32 = 28;
pub const KEV_DL_QOS_MODE_CHANGED: u32 = 29;
pub const KEV_DL_LOW_POWER_MODE_CHANGED: u32 = 30;
pub const KEV_INET6_SUBCLASS: u32 = 6;
pub const KEV_INET6_NEW_USER_ADDR: u32 = 1;
pub const KEV_INET6_CHANGED_ADDR: u32 = 2;
pub const KEV_INET6_ADDR_DELETED: u32 = 3;
pub const KEV_INET6_NEW_LL_ADDR: u32 = 4;
pub const KEV_INET6_NEW_RTADV_ADDR: u32 = 5;
pub const KEV_INET6_DEFROUTER: u32 = 6;
pub const KEV_INET6_REQUEST_NAT64_PREFIX: u32 = 7;
pub const SOCK_STREAM: u32 = 1;
pub const SOCK_DGRAM: u32 = 2;
pub const SOCK_RAW: u32 = 3;
pub const SOCK_RDM: u32 = 4;
pub const SOCK_SEQPACKET: u32 = 5;
pub const SO_DEBUG: u32 = 1;
pub const SO_ACCEPTCONN: u32 = 2;
pub const SO_REUSEADDR: u32 = 4;
pub const SO_KEEPALIVE: u32 = 8;
pub const SO_DONTROUTE: u32 = 16;
pub const SO_BROADCAST: u32 = 32;
pub const SO_USELOOPBACK: u32 = 64;
pub const SO_LINGER: u32 = 128;
pub const SO_LINGER_SEC: u32 = 4224;
pub const SO_OOBINLINE: u32 = 256;
pub const SO_REUSEPORT: u32 = 512;
pub const SO_TIMESTAMP: u32 = 1024;
pub const SO_TIMESTAMP_MONOTONIC: u32 = 2048;
pub const SO_DONTTRUNC: u32 = 8192;
pub const SO_WANTMORE: u32 = 16384;
pub const SO_WANTOOBFLAG: u32 = 32768;
pub const SO_SNDBUF: u32 = 4097;
pub const SO_RCVBUF: u32 = 4098;
pub const SO_SNDLOWAT: u32 = 4099;
pub const SO_RCVLOWAT: u32 = 4100;
pub const SO_SNDTIMEO: u32 = 4101;
pub const SO_RCVTIMEO: u32 = 4102;
pub const SO_ERROR: u32 = 4103;
pub const SO_TYPE: u32 = 4104;
pub const SO_LABEL: u32 = 4112;
pub const SO_PEERLABEL: u32 = 4113;
pub const SO_NREAD: u32 = 4128;
pub const SO_NKE: u32 = 4129;
pub const SO_NOSIGPIPE: u32 = 4130;
pub const SO_NOADDRERR: u32 = 4131;
pub const SO_NWRITE: u32 = 4132;
pub const SO_REUSESHAREUID: u32 = 4133;
pub const SO_NOTIFYCONFLICT: u32 = 4134;
pub const SO_UPCALLCLOSEWAIT: u32 = 4135;
pub const SO_RANDOMPORT: u32 = 4226;
pub const SO_NP_EXTENSIONS: u32 = 4227;
pub const SO_NUMRCVPKT: u32 = 4370;
pub const SO_NET_SERVICE_TYPE: u32 = 4374;
pub const SO_NETSVC_MARKING_LEVEL: u32 = 4377;
pub const SO_RESOLVER_SIGNATURE: u32 = 4401;
pub const NET_SERVICE_TYPE_BE: u32 = 0;
pub const NET_SERVICE_TYPE_BK: u32 = 1;
pub const NET_SERVICE_TYPE_SIG: u32 = 2;
pub const NET_SERVICE_TYPE_VI: u32 = 3;
pub const NET_SERVICE_TYPE_VO: u32 = 4;
pub const NET_SERVICE_TYPE_RV: u32 = 5;
pub const NET_SERVICE_TYPE_AV: u32 = 6;
pub const NET_SERVICE_TYPE_OAM: u32 = 7;
pub const NET_SERVICE_TYPE_RD: u32 = 8;
pub const NETSVC_MRKNG_UNKNOWN: u32 = 0;
pub const NETSVC_MRKNG_LVL_L2: u32 = 1;
pub const NETSVC_MRKNG_LVL_L3L2_ALL: u32 = 2;
pub const NETSVC_MRKNG_LVL_L3L2_BK: u32 = 3;
pub const SAE_ASSOCID_ANY: u32 = 0;
pub const SAE_CONNID_ANY: u32 = 0;
pub const CONNECT_RESUME_ON_READ_WRITE: u32 = 1;
pub const CONNECT_DATA_IDEMPOTENT: u32 = 2;
pub const CONNECT_DATA_AUTHENTICATED: u32 = 4;
pub const SONPX_SETOPTSHUT: u32 = 1;
pub const SOL_SOCKET: u32 = 65535;
pub const AF_UNSPEC: u32 = 0;
pub const AF_UNIX: u32 = 1;
pub const AF_LOCAL: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_IMPLINK: u32 = 3;
pub const AF_PUP: u32 = 4;
pub const AF_CHAOS: u32 = 5;
pub const AF_NS: u32 = 6;
pub const AF_ISO: u32 = 7;
pub const AF_OSI: u32 = 7;
pub const AF_ECMA: u32 = 8;
pub const AF_DATAKIT: u32 = 9;
pub const AF_CCITT: u32 = 10;
pub const AF_SNA: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_DLI: u32 = 13;
pub const AF_LAT: u32 = 14;
pub const AF_HYLINK: u32 = 15;
pub const AF_APPLETALK: u32 = 16;
pub const AF_ROUTE: u32 = 17;
pub const AF_LINK: u32 = 18;
pub const pseudo_AF_XTP: u32 = 19;
pub const AF_COIP: u32 = 20;
pub const AF_CNT: u32 = 21;
pub const pseudo_AF_RTIP: u32 = 22;
pub const AF_IPX: u32 = 23;
pub const AF_SIP: u32 = 24;
pub const pseudo_AF_PIP: u32 = 25;
pub const AF_NDRV: u32 = 27;
pub const AF_ISDN: u32 = 28;
pub const AF_E164: u32 = 28;
pub const pseudo_AF_KEY: u32 = 29;
pub const AF_INET6: u32 = 30;
pub const AF_NATM: u32 = 31;
pub const AF_SYSTEM: u32 = 32;
pub const AF_NETBIOS: u32 = 33;
pub const AF_PPP: u32 = 34;
pub const pseudo_AF_HDRCMPLT: u32 = 35;
pub const AF_RESERVED_36: u32 = 36;
pub const AF_IEEE80211: u32 = 37;
pub const AF_UTUN: u32 = 38;
pub const AF_VSOCK: u32 = 40;
pub const AF_MAX: u32 = 41;
pub const SOCK_MAXADDRLEN: u32 = 255;
pub const _SS_MAXSIZE: u32 = 128;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_IMPLINK: u32 = 3;
pub const PF_PUP: u32 = 4;
pub const PF_CHAOS: u32 = 5;
pub const PF_NS: u32 = 6;
pub const PF_ISO: u32 = 7;
pub const PF_OSI: u32 = 7;
pub const PF_ECMA: u32 = 8;
pub const PF_DATAKIT: u32 = 9;
pub const PF_CCITT: u32 = 10;
pub const PF_SNA: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_DLI: u32 = 13;
pub const PF_LAT: u32 = 14;
pub const PF_HYLINK: u32 = 15;
pub const PF_APPLETALK: u32 = 16;
pub const PF_ROUTE: u32 = 17;
pub const PF_LINK: u32 = 18;
pub const PF_XTP: u32 = 19;
pub const PF_COIP: u32 = 20;
pub const PF_CNT: u32 = 21;
pub const PF_SIP: u32 = 24;
pub const PF_IPX: u32 = 23;
pub const PF_RTIP: u32 = 22;
pub const PF_PIP: u32 = 25;
pub const PF_NDRV: u32 = 27;
pub const PF_ISDN: u32 = 28;
pub const PF_KEY: u32 = 29;
pub const PF_INET6: u32 = 30;
pub const PF_NATM: u32 = 31;
pub const PF_SYSTEM: u32 = 32;
pub const PF_NETBIOS: u32 = 33;
pub const PF_PPP: u32 = 34;
pub const PF_RESERVED_36: u32 = 36;
pub const PF_UTUN: u32 = 38;
pub const PF_VSOCK: u32 = 40;
pub const PF_MAX: u32 = 41;
pub const NET_MAXID: u32 = 41;
pub const NET_RT_DUMP: u32 = 1;
pub const NET_RT_FLAGS: u32 = 2;
pub const NET_RT_IFLIST: u32 = 3;
pub const NET_RT_STAT: u32 = 4;
pub const NET_RT_TRASH: u32 = 5;
pub const NET_RT_IFLIST2: u32 = 6;
pub const NET_RT_DUMP2: u32 = 7;
pub const NET_RT_FLAGS_PRIV: u32 = 10;
pub const NET_RT_MAXID: u32 = 11;
pub const SOMAXCONN: u32 = 128;
pub const MSG_OOB: u32 = 1;
pub const MSG_PEEK: u32 = 2;
pub const MSG_DONTROUTE: u32 = 4;
pub const MSG_EOR: u32 = 8;
pub const MSG_TRUNC: u32 = 16;
pub const MSG_CTRUNC: u32 = 32;
pub const MSG_WAITALL: u32 = 64;
pub const MSG_DONTWAIT: u32 = 128;
pub const MSG_EOF: u32 = 256;
pub const MSG_WAITSTREAM: u32 = 512;
pub const MSG_FLUSH: u32 = 1024;
pub const MSG_HOLD: u32 = 2048;
pub const MSG_SEND: u32 = 4096;
pub const MSG_HAVEMORE: u32 = 8192;
pub const MSG_RCVMORE: u32 = 16384;
pub const MSG_NEEDSA: u32 = 65536;
pub const MSG_NOSIGNAL: u32 = 524288;
pub const SCM_RIGHTS: u32 = 1;
pub const SCM_TIMESTAMP: u32 = 2;
pub const SCM_CREDS: u32 = 3;
pub const SCM_TIMESTAMP_MONOTONIC: u32 = 4;
pub const SHUT_RD: u32 = 0;
pub const SHUT_WR: u32 = 1;
pub const SHUT_RDWR: u32 = 2;
pub const IPPROTO_IP: u32 = 0;
pub const IPPROTO_HOPOPTS: u32 = 0;
pub const IPPROTO_ICMP: u32 = 1;
pub const IPPROTO_IGMP: u32 = 2;
pub const IPPROTO_GGP: u32 = 3;
pub const IPPROTO_IPV4: u32 = 4;
pub const IPPROTO_IPIP: u32 = 4;
pub const IPPROTO_TCP: u32 = 6;
pub const IPPROTO_ST: u32 = 7;
pub const IPPROTO_EGP: u32 = 8;
pub const IPPROTO_PIGP: u32 = 9;
pub const IPPROTO_RCCMON: u32 = 10;
pub const IPPROTO_NVPII: u32 = 11;
pub const IPPROTO_PUP: u32 = 12;
pub const IPPROTO_ARGUS: u32 = 13;
pub const IPPROTO_EMCON: u32 = 14;
pub const IPPROTO_XNET: u32 = 15;
pub const IPPROTO_CHAOS: u32 = 16;
pub const IPPROTO_UDP: u32 = 17;
pub const IPPROTO_MUX: u32 = 18;
pub const IPPROTO_MEAS: u32 = 19;
pub const IPPROTO_HMP: u32 = 20;
pub const IPPROTO_PRM: u32 = 21;
pub const IPPROTO_IDP: u32 = 22;
pub const IPPROTO_TRUNK1: u32 = 23;
pub const IPPROTO_TRUNK2: u32 = 24;
pub const IPPROTO_LEAF1: u32 = 25;
pub const IPPROTO_LEAF2: u32 = 26;
pub const IPPROTO_RDP: u32 = 27;
pub const IPPROTO_IRTP: u32 = 28;
pub const IPPROTO_TP: u32 = 29;
pub const IPPROTO_BLT: u32 = 30;
pub const IPPROTO_NSP: u32 = 31;
pub const IPPROTO_INP: u32 = 32;
pub const IPPROTO_SEP: u32 = 33;
pub const IPPROTO_3PC: u32 = 34;
pub const IPPROTO_IDPR: u32 = 35;
pub const IPPROTO_XTP: u32 = 36;
pub const IPPROTO_DDP: u32 = 37;
pub const IPPROTO_CMTP: u32 = 38;
pub const IPPROTO_TPXX: u32 = 39;
pub const IPPROTO_IL: u32 = 40;
pub const IPPROTO_IPV6: u32 = 41;
pub const IPPROTO_SDRP: u32 = 42;
pub const IPPROTO_ROUTING: u32 = 43;
pub const IPPROTO_FRAGMENT: u32 = 44;
pub const IPPROTO_IDRP: u32 = 45;
pub const IPPROTO_RSVP: u32 = 46;
pub const IPPROTO_GRE: u32 = 47;
pub const IPPROTO_MHRP: u32 = 48;
pub const IPPROTO_BHA: u32 = 49;
pub const IPPROTO_ESP: u32 = 50;
pub const IPPROTO_AH: u32 = 51;
pub const IPPROTO_INLSP: u32 = 52;
pub const IPPROTO_SWIPE: u32 = 53;
pub const IPPROTO_NHRP: u32 = 54;
pub const IPPROTO_ICMPV6: u32 = 58;
pub const IPPROTO_NONE: u32 = 59;
pub const IPPROTO_DSTOPTS: u32 = 60;
pub const IPPROTO_AHIP: u32 = 61;
pub const IPPROTO_CFTP: u32 = 62;
pub const IPPROTO_HELLO: u32 = 63;
pub const IPPROTO_SATEXPAK: u32 = 64;
pub const IPPROTO_KRYPTOLAN: u32 = 65;
pub const IPPROTO_RVD: u32 = 66;
pub const IPPROTO_IPPC: u32 = 67;
pub const IPPROTO_ADFS: u32 = 68;
pub const IPPROTO_SATMON: u32 = 69;
pub const IPPROTO_VISA: u32 = 70;
pub const IPPROTO_IPCV: u32 = 71;
pub const IPPROTO_CPNX: u32 = 72;
pub const IPPROTO_CPHB: u32 = 73;
pub const IPPROTO_WSN: u32 = 74;
pub const IPPROTO_PVP: u32 = 75;
pub const IPPROTO_BRSATMON: u32 = 76;
pub const IPPROTO_ND: u32 = 77;
pub const IPPROTO_WBMON: u32 = 78;
pub const IPPROTO_WBEXPAK: u32 = 79;
pub const IPPROTO_EON: u32 = 80;
pub const IPPROTO_VMTP: u32 = 81;
pub const IPPROTO_SVMTP: u32 = 82;
pub const IPPROTO_VINES: u32 = 83;
pub const IPPROTO_TTP: u32 = 84;
pub const IPPROTO_IGP: u32 = 85;
pub const IPPROTO_DGP: u32 = 86;
pub const IPPROTO_TCF: u32 = 87;
pub const IPPROTO_IGRP: u32 = 88;
pub const IPPROTO_OSPFIGP: u32 = 89;
pub const IPPROTO_SRPC: u32 = 90;
pub const IPPROTO_LARP: u32 = 91;
pub const IPPROTO_MTP: u32 = 92;
pub const IPPROTO_AX25: u32 = 93;
pub const IPPROTO_IPEIP: u32 = 94;
pub const IPPROTO_MICP: u32 = 95;
pub const IPPROTO_SCCSP: u32 = 96;
pub const IPPROTO_ETHERIP: u32 = 97;
pub const IPPROTO_ENCAP: u32 = 98;
pub const IPPROTO_APES: u32 = 99;
pub const IPPROTO_GMTP: u32 = 100;
pub const IPPROTO_PIM: u32 = 103;
pub const IPPROTO_IPCOMP: u32 = 108;
pub const IPPROTO_PGM: u32 = 113;
pub const IPPROTO_SCTP: u32 = 132;
pub const IPPROTO_DIVERT: u32 = 254;
pub const IPPROTO_RAW: u32 = 255;
pub const IPPROTO_MAX: u32 = 256;
pub const IPPROTO_DONE: u32 = 257;
pub const __DARWIN_IPPORT_RESERVED: u32 = 1024;
pub const IPPORT_RESERVED: u32 = 1024;
pub const IPPORT_USERRESERVED: u32 = 5000;
pub const IPPORT_HIFIRSTAUTO: u32 = 49152;
pub const IPPORT_HILASTAUTO: u32 = 65535;
pub const IPPORT_RESERVEDSTART: u32 = 600;
pub const IN_CLASSA_NET: u32 = 4278190080;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_HOST: u32 = 16777215;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NET: u32 = 4294901760;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_HOST: u32 = 65535;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NET: u32 = 4294967040;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSC_HOST: u32 = 255;
pub const IN_CLASSD_NET: u32 = 4026531840;
pub const IN_CLASSD_NSHIFT: u32 = 28;
pub const IN_CLASSD_HOST: u32 = 268435455;
pub const INADDR_NONE: u32 = 4294967295;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const IP_OPTIONS: u32 = 1;
pub const IP_HDRINCL: u32 = 2;
pub const IP_TOS: u32 = 3;
pub const IP_TTL: u32 = 4;
pub const IP_RECVOPTS: u32 = 5;
pub const IP_RECVRETOPTS: u32 = 6;
pub const IP_RECVDSTADDR: u32 = 7;
pub const IP_RETOPTS: u32 = 8;
pub const IP_MULTICAST_IF: u32 = 9;
pub const IP_MULTICAST_TTL: u32 = 10;
pub const IP_MULTICAST_LOOP: u32 = 11;
pub const IP_ADD_MEMBERSHIP: u32 = 12;
pub const IP_DROP_MEMBERSHIP: u32 = 13;
pub const IP_MULTICAST_VIF: u32 = 14;
pub const IP_RSVP_ON: u32 = 15;
pub const IP_RSVP_OFF: u32 = 16;
pub const IP_RSVP_VIF_ON: u32 = 17;
pub const IP_RSVP_VIF_OFF: u32 = 18;
pub const IP_PORTRANGE: u32 = 19;
pub const IP_RECVIF: u32 = 20;
pub const IP_IPSEC_POLICY: u32 = 21;
pub const IP_FAITH: u32 = 22;
pub const IP_STRIPHDR: u32 = 23;
pub const IP_RECVTTL: u32 = 24;
pub const IP_BOUND_IF: u32 = 25;
pub const IP_PKTINFO: u32 = 26;
pub const IP_RECVPKTINFO: u32 = 26;
pub const IP_RECVTOS: u32 = 27;
pub const IP_DONTFRAG: u32 = 28;
pub const IP_FW_ADD: u32 = 40;
pub const IP_FW_DEL: u32 = 41;
pub const IP_FW_FLUSH: u32 = 42;
pub const IP_FW_ZERO: u32 = 43;
pub const IP_FW_GET: u32 = 44;
pub const IP_FW_RESETLOG: u32 = 45;
pub const IP_OLD_FW_ADD: u32 = 50;
pub const IP_OLD_FW_DEL: u32 = 51;
pub const IP_OLD_FW_FLUSH: u32 = 52;
pub const IP_OLD_FW_ZERO: u32 = 53;
pub const IP_OLD_FW_GET: u32 = 54;
pub const IP_NAT__XXX: u32 = 55;
pub const IP_OLD_FW_RESETLOG: u32 = 56;
pub const IP_DUMMYNET_CONFIGURE: u32 = 60;
pub const IP_DUMMYNET_DEL: u32 = 61;
pub const IP_DUMMYNET_FLUSH: u32 = 62;
pub const IP_DUMMYNET_GET: u32 = 64;
pub const IP_TRAFFIC_MGT_BACKGROUND: u32 = 65;
pub const IP_MULTICAST_IFINDEX: u32 = 66;
pub const IP_ADD_SOURCE_MEMBERSHIP: u32 = 70;
pub const IP_DROP_SOURCE_MEMBERSHIP: u32 = 71;
pub const IP_BLOCK_SOURCE: u32 = 72;
pub const IP_UNBLOCK_SOURCE: u32 = 73;
pub const IP_MSFILTER: u32 = 74;
pub const MCAST_JOIN_GROUP: u32 = 80;
pub const MCAST_LEAVE_GROUP: u32 = 81;
pub const MCAST_JOIN_SOURCE_GROUP: u32 = 82;
pub const MCAST_LEAVE_SOURCE_GROUP: u32 = 83;
pub const MCAST_BLOCK_SOURCE: u32 = 84;
pub const MCAST_UNBLOCK_SOURCE: u32 = 85;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MIN_MEMBERSHIPS: u32 = 31;
pub const IP_MAX_MEMBERSHIPS: u32 = 4095;
pub const IP_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IP_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IP_MAX_SOCK_MUTE_FILTER: u32 = 128;
pub const MCAST_UNDEFINED: u32 = 0;
pub const MCAST_INCLUDE: u32 = 1;
pub const MCAST_EXCLUDE: u32 = 2;
pub const IP_PORTRANGE_DEFAULT: u32 = 0;
pub const IP_PORTRANGE_HIGH: u32 = 1;
pub const IP_PORTRANGE_LOW: u32 = 2;
pub const IPPROTO_MAXID: u32 = 52;
pub const IPCTL_FORWARDING: u32 = 1;
pub const IPCTL_SENDREDIRECTS: u32 = 2;
pub const IPCTL_DEFTTL: u32 = 3;
pub const IPCTL_RTEXPIRE: u32 = 5;
pub const IPCTL_RTMINEXPIRE: u32 = 6;
pub const IPCTL_RTMAXCACHE: u32 = 7;
pub const IPCTL_SOURCEROUTE: u32 = 8;
pub const IPCTL_DIRECTEDBROADCAST: u32 = 9;
pub const IPCTL_INTRQMAXLEN: u32 = 10;
pub const IPCTL_INTRQDROPS: u32 = 11;
pub const IPCTL_STATS: u32 = 12;
pub const IPCTL_ACCEPTSOURCEROUTE: u32 = 13;
pub const IPCTL_FASTFORWARDING: u32 = 14;
pub const IPCTL_KEEPFAITH: u32 = 15;
pub const IPCTL_GIF_TTL: u32 = 16;
pub const IPCTL_MAXID: u32 = 17;
pub const __KAME_VERSION: &[u8; 18] = b"2009/apple-darwin\0";
pub const IPV6PORT_RESERVED: u32 = 1024;
pub const IPV6PORT_ANONMIN: u32 = 49152;
pub const IPV6PORT_ANONMAX: u32 = 65535;
pub const IPV6PORT_RESERVEDMIN: u32 = 600;
pub const IPV6PORT_RESERVEDMAX: u32 = 1023;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const __IPV6_ADDR_SCOPE_NODELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_INTFACELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_LINKLOCAL: u32 = 2;
pub const __IPV6_ADDR_SCOPE_SITELOCAL: u32 = 5;
pub const __IPV6_ADDR_SCOPE_ORGLOCAL: u32 = 8;
pub const __IPV6_ADDR_SCOPE_GLOBAL: u32 = 14;
pub const IPV6_ADDR_MC_FLAGS_TRANSIENT: u32 = 16;
pub const IPV6_ADDR_MC_FLAGS_PREFIX: u32 = 32;
pub const IPV6_ADDR_MC_FLAGS_UNICAST_BASED: u32 = 48;
pub const IPV6_SOCKOPT_RESERVED1: u32 = 3;
pub const IPV6_UNICAST_HOPS: u32 = 4;
pub const IPV6_MULTICAST_IF: u32 = 9;
pub const IPV6_MULTICAST_HOPS: u32 = 10;
pub const IPV6_MULTICAST_LOOP: u32 = 11;
pub const IPV6_JOIN_GROUP: u32 = 12;
pub const IPV6_LEAVE_GROUP: u32 = 13;
pub const IPV6_PORTRANGE: u32 = 14;
pub const ICMP6_FILTER: u32 = 18;
pub const IPV6_2292PKTINFO: u32 = 19;
pub const IPV6_2292HOPLIMIT: u32 = 20;
pub const IPV6_2292NEXTHOP: u32 = 21;
pub const IPV6_2292HOPOPTS: u32 = 22;
pub const IPV6_2292DSTOPTS: u32 = 23;
pub const IPV6_2292RTHDR: u32 = 24;
pub const IPV6_2292PKTOPTIONS: u32 = 25;
pub const IPV6_CHECKSUM: u32 = 26;
pub const IPV6_V6ONLY: u32 = 27;
pub const IPV6_BINDV6ONLY: u32 = 27;
pub const IPV6_IPSEC_POLICY: u32 = 28;
pub const IPV6_FAITH: u32 = 29;
pub const IPV6_FW_ADD: u32 = 30;
pub const IPV6_FW_DEL: u32 = 31;
pub const IPV6_FW_FLUSH: u32 = 32;
pub const IPV6_FW_ZERO: u32 = 33;
pub const IPV6_FW_GET: u32 = 34;
pub const IPV6_RECVTCLASS: u32 = 35;
pub const IPV6_TCLASS: u32 = 36;
pub const IPV6_BOUND_IF: u32 = 125;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IPV6_DEFAULT_MULTICAST_HOPS: u32 = 1;
pub const IPV6_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IPV6_MIN_MEMBERSHIPS: u32 = 31;
pub const IPV6_MAX_MEMBERSHIPS: u32 = 4095;
pub const IPV6_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IPV6_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IPV6_PORTRANGE_DEFAULT: u32 = 0;
pub const IPV6_PORTRANGE_HIGH: u32 = 1;
pub const IPV6_PORTRANGE_LOW: u32 = 2;
pub const IPV6PROTO_MAXID: u32 = 104;
pub const IPV6CTL_FORWARDING: u32 = 1;
pub const IPV6CTL_SENDREDIRECTS: u32 = 2;
pub const IPV6CTL_DEFHLIM: u32 = 3;
pub const IPV6CTL_FORWSRCRT: u32 = 5;
pub const IPV6CTL_STATS: u32 = 6;
pub const IPV6CTL_MRTSTATS: u32 = 7;
pub const IPV6CTL_MRTPROTO: u32 = 8;
pub const IPV6CTL_MAXFRAGPACKETS: u32 = 9;
pub const IPV6CTL_SOURCECHECK: u32 = 10;
pub const IPV6CTL_SOURCECHECK_LOGINT: u32 = 11;
pub const IPV6CTL_ACCEPT_RTADV: u32 = 12;
pub const IPV6CTL_KEEPFAITH: u32 = 13;
pub const IPV6CTL_LOG_INTERVAL: u32 = 14;
pub const IPV6CTL_HDRNESTLIMIT: u32 = 15;
pub const IPV6CTL_DAD_COUNT: u32 = 16;
pub const IPV6CTL_AUTO_FLOWLABEL: u32 = 17;
pub const IPV6CTL_DEFMCASTHLIM: u32 = 18;
pub const IPV6CTL_GIF_HLIM: u32 = 19;
pub const IPV6CTL_KAME_VERSION: u32 = 20;
pub const IPV6CTL_USE_DEPRECATED: u32 = 21;
pub const IPV6CTL_RR_PRUNE: u32 = 22;
pub const IPV6CTL_V6ONLY: u32 = 24;
pub const IPV6CTL_RTEXPIRE: u32 = 25;
pub const IPV6CTL_RTMINEXPIRE: u32 = 26;
pub const IPV6CTL_RTMAXCACHE: u32 = 27;
pub const IPV6CTL_USETEMPADDR: u32 = 32;
pub const IPV6CTL_TEMPPLTIME: u32 = 33;
pub const IPV6CTL_TEMPVLTIME: u32 = 34;
pub const IPV6CTL_AUTO_LINKLOCAL: u32 = 35;
pub const IPV6CTL_RIP6STATS: u32 = 36;
pub const IPV6CTL_PREFER_TEMPADDR: u32 = 37;
pub const IPV6CTL_ADDRCTLPOLICY: u32 = 38;
pub const IPV6CTL_USE_DEFAULTZONE: u32 = 39;
pub const IPV6CTL_MAXFRAGS: u32 = 41;
pub const IPV6CTL_MCAST_PMTU: u32 = 44;
pub const IPV6CTL_NEIGHBORGCTHRESH: u32 = 46;
pub const IPV6CTL_MAXIFPREFIXES: u32 = 47;
pub const IPV6CTL_MAXIFDEFROUTERS: u32 = 48;
pub const IPV6CTL_MAXDYNROUTES: u32 = 49;
pub const ICMPV6CTL_ND6_ONLINKNSRFC4861: u32 = 50;
pub const IPV6CTL_ULA_USETEMPADDR: u32 = 51;
pub const IPV6CTL_MAXID: u32 = 51;
pub const RTM_RTTUNIT: u32 = 1000000;
pub const RTF_UP: u32 = 1;
pub const RTF_GATEWAY: u32 = 2;
pub const RTF_HOST: u32 = 4;
pub const RTF_REJECT: u32 = 8;
pub const RTF_DYNAMIC: u32 = 16;
pub const RTF_MODIFIED: u32 = 32;
pub const RTF_DONE: u32 = 64;
pub const RTF_DELCLONE: u32 = 128;
pub const RTF_CLONING: u32 = 256;
pub const RTF_XRESOLVE: u32 = 512;
pub const RTF_LLINFO: u32 = 1024;
pub const RTF_LLDATA: u32 = 1024;
pub const RTF_STATIC: u32 = 2048;
pub const RTF_BLACKHOLE: u32 = 4096;
pub const RTF_NOIFREF: u32 = 8192;
pub const RTF_PROTO2: u32 = 16384;
pub const RTF_PROTO1: u32 = 32768;
pub const RTF_PRCLONING: u32 = 65536;
pub const RTF_WASCLONED: u32 = 131072;
pub const RTF_PROTO3: u32 = 262144;
pub const RTF_PINNED: u32 = 1048576;
pub const RTF_LOCAL: u32 = 2097152;
pub const RTF_BROADCAST: u32 = 4194304;
pub const RTF_MULTICAST: u32 = 8388608;
pub const RTF_IFSCOPE: u32 = 16777216;
pub const RTF_CONDEMNED: u32 = 33554432;
pub const RTF_IFREF: u32 = 67108864;
pub const RTF_PROXY: u32 = 134217728;
pub const RTF_ROUTER: u32 = 268435456;
pub const RTF_DEAD: u32 = 536870912;
pub const RTF_GLOBAL: u32 = 1073741824;
pub const RTPRF_OURS: u32 = 262144;
pub const RTF_BITS : & [u8 ; 223] = b"\x10\x01UP\x02GATEWAY\x03HOST\x04REJECT\x05DYNAMIC\x06MODIFIED\x07DONE\x08DELCLONE\tCLONING\nXRESOLVE\x0BLLINFO\x0CSTATIC\rBLACKHOLE\x0ENOIFREF\x0FPROTO2\x10PROTO1\x11PRCLONING\x12WASCLONED\x13PROTO3\x15PINNED\x16LOCAL\x17BROADCAST\x18MULTICAST\x19IFSCOPE\x1ACONDEMNED\x1BIFREF\x1CPROXY\x1DROUTER\x1FGLOBAL\0" ;
pub const RTM_VERSION: u32 = 5;
pub const RTM_ADD: u32 = 1;
pub const RTM_DELETE: u32 = 2;
pub const RTM_CHANGE: u32 = 3;
pub const RTM_GET: u32 = 4;
pub const RTM_LOSING: u32 = 5;
pub const RTM_REDIRECT: u32 = 6;
pub const RTM_MISS: u32 = 7;
pub const RTM_LOCK: u32 = 8;
pub const RTM_OLDADD: u32 = 9;
pub const RTM_OLDDEL: u32 = 10;
pub const RTM_RESOLVE: u32 = 11;
pub const RTM_NEWADDR: u32 = 12;
pub const RTM_DELADDR: u32 = 13;
pub const RTM_IFINFO: u32 = 14;
pub const RTM_NEWMADDR: u32 = 15;
pub const RTM_DELMADDR: u32 = 16;
pub const RTM_IFINFO2: u32 = 18;
pub const RTM_NEWMADDR2: u32 = 19;
pub const RTM_GET2: u32 = 20;
pub const RTV_MTU: u32 = 1;
pub const RTV_HOPCOUNT: u32 = 2;
pub const RTV_EXPIRE: u32 = 4;
pub const RTV_RPIPE: u32 = 8;
pub const RTV_SPIPE: u32 = 16;
pub const RTV_SSTHRESH: u32 = 32;
pub const RTV_RTT: u32 = 64;
pub const RTV_RTTVAR: u32 = 128;
pub const RTA_DST: u32 = 1;
pub const RTA_GATEWAY: u32 = 2;
pub const RTA_NETMASK: u32 = 4;
pub const RTA_GENMASK: u32 = 8;
pub const RTA_IFP: u32 = 16;
pub const RTA_IFA: u32 = 32;
pub const RTA_AUTHOR: u32 = 64;
pub const RTA_BRD: u32 = 128;
pub const RTAX_DST: u32 = 0;
pub const RTAX_GATEWAY: u32 = 1;
pub const RTAX_NETMASK: u32 = 2;
pub const RTAX_GENMASK: u32 = 3;
pub const RTAX_IFP: u32 = 4;
pub const RTAX_IFA: u32 = 5;
pub const RTAX_AUTHOR: u32 = 6;
pub const RTAX_BRD: u32 = 7;
pub const RTAX_MAX: u32 = 8;
pub const DLIL_SDLDATACOUNT: u32 = 12;
pub const IF_NAMESIZE: u32 = 16;
pub const APPLE_IF_FAM_LOOPBACK: u32 = 1;
pub const APPLE_IF_FAM_ETHERNET: u32 = 2;
pub const APPLE_IF_FAM_SLIP: u32 = 3;
pub const APPLE_IF_FAM_TUN: u32 = 4;
pub const APPLE_IF_FAM_VLAN: u32 = 5;
pub const APPLE_IF_FAM_PPP: u32 = 6;
pub const APPLE_IF_FAM_PVC: u32 = 7;
pub const APPLE_IF_FAM_DISC: u32 = 8;
pub const APPLE_IF_FAM_MDECAP: u32 = 9;
pub const APPLE_IF_FAM_GIF: u32 = 10;
pub const APPLE_IF_FAM_FAITH: u32 = 11;
pub const APPLE_IF_FAM_STF: u32 = 12;
pub const APPLE_IF_FAM_FIREWIRE: u32 = 13;
pub const APPLE_IF_FAM_BOND: u32 = 14;
pub const APPLE_IF_FAM_CELLULAR: u32 = 15;
pub const APPLE_IF_FAM_UNUSED_16: u32 = 16;
pub const APPLE_IF_FAM_UTUN: u32 = 17;
pub const APPLE_IF_FAM_IPSEC: u32 = 18;
pub const IF_MINMTU: u32 = 72;
pub const IF_MAXMTU: u32 = 65535;
pub const IFNAMSIZ: u32 = 16;
pub const IFF_UP: u32 = 1;
pub const IFF_BROADCAST: u32 = 2;
pub const IFF_DEBUG: u32 = 4;
pub const IFF_LOOPBACK: u32 = 8;
pub const IFF_POINTOPOINT: u32 = 16;
pub const IFF_NOTRAILERS: u32 = 32;
pub const IFF_RUNNING: u32 = 64;
pub const IFF_NOARP: u32 = 128;
pub const IFF_PROMISC: u32 = 256;
pub const IFF_ALLMULTI: u32 = 512;
pub const IFF_OACTIVE: u32 = 1024;
pub const IFF_SIMPLEX: u32 = 2048;
pub const IFF_LINK0: u32 = 4096;
pub const IFF_LINK1: u32 = 8192;
pub const IFF_LINK2: u32 = 16384;
pub const IFF_ALTPHYS: u32 = 16384;
pub const IFF_MULTICAST: u32 = 32768;
pub const IFCAP_RXCSUM: u32 = 1;
pub const IFCAP_TXCSUM: u32 = 2;
pub const IFCAP_VLAN_MTU: u32 = 4;
pub const IFCAP_VLAN_HWTAGGING: u32 = 8;
pub const IFCAP_JUMBO_MTU: u32 = 16;
pub const IFCAP_TSO4: u32 = 32;
pub const IFCAP_TSO6: u32 = 64;
pub const IFCAP_LRO: u32 = 128;
pub const IFCAP_AV: u32 = 256;
pub const IFCAP_TXSTATUS: u32 = 512;
pub const IFCAP_SKYWALK: u32 = 1024;
pub const IFCAP_HW_TIMESTAMP: u32 = 2048;
pub const IFCAP_SW_TIMESTAMP: u32 = 4096;
pub const IFCAP_CSUM_PARTIAL: u32 = 8192;
pub const IFCAP_CSUM_ZERO_INVERT: u32 = 16384;
pub const IFCAP_HWCSUM: u32 = 3;
pub const IFCAP_TSO: u32 = 96;
pub const IFCAP_VALID: u32 = 32767;
pub const IFQ_MAXLEN: u32 = 128;
pub const IFNET_SLOWHZ: u32 = 1;
pub const IFQ_DEF_C_TARGET_DELAY: u32 = 10000000;
pub const IFQ_DEF_C_UPDATE_INTERVAL: u32 = 100000000;
pub const IFQ_DEF_L4S_TARGET_DELAY: u32 = 2000000;
pub const IFQ_DEF_L4S_UPDATE_INTERVAL: u32 = 100000000;
pub const IFQ_LL_C_TARGET_DELAY: u32 = 10000000;
pub const IFQ_LL_C_UPDATE_INTERVAL: u32 = 100000000;
pub const IFQ_LL_L4S_TARGET_DELAY: u32 = 10000000;
pub const IFQ_LL_L4S_UPDATE_INTERVAL: u32 = 100000000;
pub const IF_WAKE_ON_MAGIC_PACKET: u32 = 1;
pub const IFRTYPE_FUNCTIONAL_UNKNOWN: u32 = 0;
pub const IFRTYPE_FUNCTIONAL_LOOPBACK: u32 = 1;
pub const IFRTYPE_FUNCTIONAL_WIRED: u32 = 2;
pub const IFRTYPE_FUNCTIONAL_WIFI_INFRA: u32 = 3;
pub const IFRTYPE_FUNCTIONAL_WIFI_AWDL: u32 = 4;
pub const IFRTYPE_FUNCTIONAL_CELLULAR: u32 = 5;
pub const IFRTYPE_FUNCTIONAL_INTCOPROC: u32 = 6;
pub const IFRTYPE_FUNCTIONAL_COMPANIONLINK: u32 = 7;
pub const IFRTYPE_FUNCTIONAL_LAST: u32 = 7;
pub const IFSTATMAX: u32 = 800;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __mbstate_t"][::std::mem::size_of::<__mbstate_t>() - 128usize];
    ["Alignment of __mbstate_t"][::std::mem::align_of::<__mbstate_t>() - 8usize];
    ["Offset of field: __mbstate_t::__mbstate8"]
        [::std::mem::offset_of!(__mbstate_t, __mbstate8) - 0usize];
    ["Offset of field: __mbstate_t::_mbstateL"]
        [::std::mem::offset_of!(__mbstate_t, _mbstateL) - 0usize];
};
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_pthread_handler_rec"]
        [::std::mem::size_of::<__darwin_pthread_handler_rec>() - 24usize];
    ["Alignment of __darwin_pthread_handler_rec"]
        [::std::mem::align_of::<__darwin_pthread_handler_rec>() - 8usize];
    ["Offset of field: __darwin_pthread_handler_rec::__routine"]
        [::std::mem::offset_of!(__darwin_pthread_handler_rec, __routine) - 0usize];
    ["Offset of field: __darwin_pthread_handler_rec::__arg"]
        [::std::mem::offset_of!(__darwin_pthread_handler_rec, __arg) - 8usize];
    ["Offset of field: __darwin_pthread_handler_rec::__next"]
        [::std::mem::offset_of!(__darwin_pthread_handler_rec, __next) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _opaque_pthread_attr_t"][::std::mem::size_of::<_opaque_pthread_attr_t>() - 64usize];
    ["Alignment of _opaque_pthread_attr_t"]
        [::std::mem::align_of::<_opaque_pthread_attr_t>() - 8usize];
    ["Offset of field: _opaque_pthread_attr_t::__sig"]
        [::std::mem::offset_of!(_opaque_pthread_attr_t, __sig) - 0usize];
    ["Offset of field: _opaque_pthread_attr_t::__opaque"]
        [::std::mem::offset_of!(_opaque_pthread_attr_t, __opaque) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _opaque_pthread_cond_t"][::std::mem::size_of::<_opaque_pthread_cond_t>() - 48usize];
    ["Alignment of _opaque_pthread_cond_t"]
        [::std::mem::align_of::<_opaque_pthread_cond_t>() - 8usize];
    ["Offset of field: _opaque_pthread_cond_t::__sig"]
        [::std::mem::offset_of!(_opaque_pthread_cond_t, __sig) - 0usize];
    ["Offset of field: _opaque_pthread_cond_t::__opaque"]
        [::std::mem::offset_of!(_opaque_pthread_cond_t, __opaque) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _opaque_pthread_condattr_t"]
        [::std::mem::size_of::<_opaque_pthread_condattr_t>() - 16usize];
    ["Alignment of _opaque_pthread_condattr_t"]
        [::std::mem::align_of::<_opaque_pthread_condattr_t>() - 8usize];
    ["Offset of field: _opaque_pthread_condattr_t::__sig"]
        [::std::mem::offset_of!(_opaque_pthread_condattr_t, __sig) - 0usize];
    ["Offset of field: _opaque_pthread_condattr_t::__opaque"]
        [::std::mem::offset_of!(_opaque_pthread_condattr_t, __opaque) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _opaque_pthread_mutex_t"][::std::mem::size_of::<_opaque_pthread_mutex_t>() - 64usize];
    ["Alignment of _opaque_pthread_mutex_t"]
        [::std::mem::align_of::<_opaque_pthread_mutex_t>() - 8usize];
    ["Offset of field: _opaque_pthread_mutex_t::__sig"]
        [::std::mem::offset_of!(_opaque_pthread_mutex_t, __sig) - 0usize];
    ["Offset of field: _opaque_pthread_mutex_t::__opaque"]
        [::std::mem::offset_of!(_opaque_pthread_mutex_t, __opaque) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _opaque_pthread_mutexattr_t"]
        [::std::mem::size_of::<_opaque_pthread_mutexattr_t>() - 16usize];
    ["Alignment of _opaque_pthread_mutexattr_t"]
        [::std::mem::align_of::<_opaque_pthread_mutexattr_t>() - 8usize];
    ["Offset of field: _opaque_pthread_mutexattr_t::__sig"]
        [::std::mem::offset_of!(_opaque_pthread_mutexattr_t, __sig) - 0usize];
    ["Offset of field: _opaque_pthread_mutexattr_t::__opaque"]
        [::std::mem::offset_of!(_opaque_pthread_mutexattr_t, __opaque) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _opaque_pthread_once_t"][::std::mem::size_of::<_opaque_pthread_once_t>() - 16usize];
    ["Alignment of _opaque_pthread_once_t"]
        [::std::mem::align_of::<_opaque_pthread_once_t>() - 8usize];
    ["Offset of field: _opaque_pthread_once_t::__sig"]
        [::std::mem::offset_of!(_opaque_pthread_once_t, __sig) - 0usize];
    ["Offset of field: _opaque_pthread_once_t::__opaque"]
        [::std::mem::offset_of!(_opaque_pthread_once_t, __opaque) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _opaque_pthread_rwlock_t"]
        [::std::mem::size_of::<_opaque_pthread_rwlock_t>() - 200usize];
    ["Alignment of _opaque_pthread_rwlock_t"]
        [::std::mem::align_of::<_opaque_pthread_rwlock_t>() - 8usize];
    ["Offset of field: _opaque_pthread_rwlock_t::__sig"]
        [::std::mem::offset_of!(_opaque_pthread_rwlock_t, __sig) - 0usize];
    ["Offset of field: _opaque_pthread_rwlock_t::__opaque"]
        [::std::mem::offset_of!(_opaque_pthread_rwlock_t, __opaque) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _opaque_pthread_rwlockattr_t"]
        [::std::mem::size_of::<_opaque_pthread_rwlockattr_t>() - 24usize];
    ["Alignment of _opaque_pthread_rwlockattr_t"]
        [::std::mem::align_of::<_opaque_pthread_rwlockattr_t>() - 8usize];
    ["Offset of field: _opaque_pthread_rwlockattr_t::__sig"]
        [::std::mem::offset_of!(_opaque_pthread_rwlockattr_t, __sig) - 0usize];
    ["Offset of field: _opaque_pthread_rwlockattr_t::__opaque"]
        [::std::mem::offset_of!(_opaque_pthread_rwlockattr_t, __opaque) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _opaque_pthread_t"][::std::mem::size_of::<_opaque_pthread_t>() - 8192usize];
    ["Alignment of _opaque_pthread_t"][::std::mem::align_of::<_opaque_pthread_t>() - 8usize];
    ["Offset of field: _opaque_pthread_t::__sig"]
        [::std::mem::offset_of!(_opaque_pthread_t, __sig) - 0usize];
    ["Offset of field: _opaque_pthread_t::__cleanup_stack"]
        [::std::mem::offset_of!(_opaque_pthread_t, __cleanup_stack) - 8usize];
    ["Offset of field: _opaque_pthread_t::__opaque"]
        [::std::mem::offset_of!(_opaque_pthread_t, __opaque) - 16usize];
};
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_quad_t = u_int64_t;
pub type quad_t = i64;
pub type qaddr_t = *mut quad_t;
pub type caddr_t = *mut ::std::os::raw::c_char;
pub type daddr_t = i32;
pub type dev_t = __darwin_dev_t;
pub type fixpt_t = u_int32_t;
pub type blkcnt_t = __darwin_blkcnt_t;
pub type blksize_t = __darwin_blksize_t;
pub type gid_t = __darwin_gid_t;
pub type in_addr_t = __uint32_t;
pub type in_port_t = __uint16_t;
pub type ino_t = __darwin_ino_t;
pub type ino64_t = __darwin_ino64_t;
pub type key_t = __int32_t;
pub type mode_t = __darwin_mode_t;
pub type nlink_t = __uint16_t;
pub type id_t = __darwin_id_t;
pub type pid_t = __darwin_pid_t;
pub type off_t = __darwin_off_t;
pub type segsz_t = i32;
pub type swblk_t = i32;
pub type uid_t = __darwin_uid_t;
pub type clock_t = __darwin_clock_t;
pub type time_t = __darwin_time_t;
pub type useconds_t = __darwin_useconds_t;
pub type suseconds_t = __darwin_suseconds_t;
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [__int32_t; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of fd_set"][::std::mem::size_of::<fd_set>() - 128usize];
    ["Alignment of fd_set"][::std::mem::align_of::<fd_set>() - 4usize];
    ["Offset of field: fd_set::fds_bits"][::std::mem::offset_of!(fd_set, fds_bits) - 0usize];
};
unsafe extern "C" {
    pub fn __darwin_check_fd_set_overflow(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type fd_mask = __int32_t;
pub type pthread_attr_t = __darwin_pthread_attr_t;
pub type pthread_cond_t = __darwin_pthread_cond_t;
pub type pthread_condattr_t = __darwin_pthread_condattr_t;
pub type pthread_mutex_t = __darwin_pthread_mutex_t;
pub type pthread_mutexattr_t = __darwin_pthread_mutexattr_t;
pub type pthread_once_t = __darwin_pthread_once_t;
pub type pthread_rwlock_t = __darwin_pthread_rwlock_t;
pub type pthread_rwlockattr_t = __darwin_pthread_rwlockattr_t;
pub type pthread_t = __darwin_pthread_t;
pub type pthread_key_t = __darwin_pthread_key_t;
pub type fsblkcnt_t = __darwin_fsblkcnt_t;
pub type fsfilcnt_t = __darwin_fsfilcnt_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::std::os::raw::c_uint,
    pub __ebx: ::std::os::raw::c_uint,
    pub __ecx: ::std::os::raw::c_uint,
    pub __edx: ::std::os::raw::c_uint,
    pub __edi: ::std::os::raw::c_uint,
    pub __esi: ::std::os::raw::c_uint,
    pub __ebp: ::std::os::raw::c_uint,
    pub __esp: ::std::os::raw::c_uint,
    pub __ss: ::std::os::raw::c_uint,
    pub __eflags: ::std::os::raw::c_uint,
    pub __eip: ::std::os::raw::c_uint,
    pub __cs: ::std::os::raw::c_uint,
    pub __ds: ::std::os::raw::c_uint,
    pub __es: ::std::os::raw::c_uint,
    pub __fs: ::std::os::raw::c_uint,
    pub __gs: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_i386_thread_state"]
        [::std::mem::size_of::<__darwin_i386_thread_state>() - 64usize];
    ["Alignment of __darwin_i386_thread_state"]
        [::std::mem::align_of::<__darwin_i386_thread_state>() - 4usize];
    ["Offset of field: __darwin_i386_thread_state::__eax"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __eax) - 0usize];
    ["Offset of field: __darwin_i386_thread_state::__ebx"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __ebx) - 4usize];
    ["Offset of field: __darwin_i386_thread_state::__ecx"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __ecx) - 8usize];
    ["Offset of field: __darwin_i386_thread_state::__edx"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __edx) - 12usize];
    ["Offset of field: __darwin_i386_thread_state::__edi"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __edi) - 16usize];
    ["Offset of field: __darwin_i386_thread_state::__esi"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __esi) - 20usize];
    ["Offset of field: __darwin_i386_thread_state::__ebp"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __ebp) - 24usize];
    ["Offset of field: __darwin_i386_thread_state::__esp"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __esp) - 28usize];
    ["Offset of field: __darwin_i386_thread_state::__ss"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __ss) - 32usize];
    ["Offset of field: __darwin_i386_thread_state::__eflags"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __eflags) - 36usize];
    ["Offset of field: __darwin_i386_thread_state::__eip"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __eip) - 40usize];
    ["Offset of field: __darwin_i386_thread_state::__cs"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __cs) - 44usize];
    ["Offset of field: __darwin_i386_thread_state::__ds"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __ds) - 48usize];
    ["Offset of field: __darwin_i386_thread_state::__es"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __es) - 52usize];
    ["Offset of field: __darwin_i386_thread_state::__fs"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __fs) - 56usize];
    ["Offset of field: __darwin_i386_thread_state::__gs"]
        [::std::mem::offset_of!(__darwin_i386_thread_state, __gs) - 60usize];
};
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_fp_control"][::std::mem::size_of::<__darwin_fp_control>() - 2usize];
    ["Alignment of __darwin_fp_control"][::std::mem::align_of::<__darwin_fp_control>() - 2usize];
};
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __invalid_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___invalid_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __denorm_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___denorm_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __zdiv_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___zdiv_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __ovrfl_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___ovrfl_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __undfl_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___undfl_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __precis_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___precis_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __pc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___pc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __pc_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                2u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___pc_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __rc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___rc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __rc_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                2u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___rc_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __pc: ::std::os::raw::c_ushort,
        __rc: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::std::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::std::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_fp_status"][::std::mem::size_of::<__darwin_fp_status>() - 2usize];
    ["Alignment of __darwin_fp_status"][::std::mem::align_of::<__darwin_fp_status>() - 2usize];
};
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __invalid_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___invalid_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __denorm_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___denorm_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __zdiv_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___zdiv_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __ovrfl_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___ovrfl_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __undfl_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___undfl_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __precis_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___precis_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __stkflt(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___stkflt(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __stkflt_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___stkflt_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __errsumm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___errsumm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __errsumm_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___errsumm_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __c0(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c0(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __c0_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___c0_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __c1(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c1(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __c1_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___c1_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __c2(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c2(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __c2_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___c2_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __tos(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set___tos(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __tos_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                11usize,
                3u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___tos_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                11usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __c3(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c3(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __c3_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___c3_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __busy(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___busy(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __busy_raw(this: *const Self) -> ::std::os::raw::c_ushort {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set___busy_raw(this: *mut Self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __stkflt: ::std::os::raw::c_ushort,
        __errsumm: ::std::os::raw::c_ushort,
        __c0: ::std::os::raw::c_ushort,
        __c1: ::std::os::raw::c_ushort,
        __c2: ::std::os::raw::c_ushort,
        __tos: ::std::os::raw::c_ushort,
        __c3: ::std::os::raw::c_ushort,
        __busy: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::std::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::std::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::std::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::std::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::std::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::std::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::std::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::std::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::std::os::raw::c_char; 10usize],
    pub __mmst_rsrv: [::std::os::raw::c_char; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mmst_reg"][::std::mem::size_of::<__darwin_mmst_reg>() - 16usize];
    ["Alignment of __darwin_mmst_reg"][::std::mem::align_of::<__darwin_mmst_reg>() - 1usize];
    ["Offset of field: __darwin_mmst_reg::__mmst_reg"]
        [::std::mem::offset_of!(__darwin_mmst_reg, __mmst_reg) - 0usize];
    ["Offset of field: __darwin_mmst_reg::__mmst_rsrv"]
        [::std::mem::offset_of!(__darwin_mmst_reg, __mmst_rsrv) - 10usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::std::os::raw::c_char; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_xmm_reg"][::std::mem::size_of::<__darwin_xmm_reg>() - 16usize];
    ["Alignment of __darwin_xmm_reg"][::std::mem::align_of::<__darwin_xmm_reg>() - 1usize];
    ["Offset of field: __darwin_xmm_reg::__xmm_reg"]
        [::std::mem::offset_of!(__darwin_xmm_reg, __xmm_reg) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::std::os::raw::c_char; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_ymm_reg"][::std::mem::size_of::<__darwin_ymm_reg>() - 32usize];
    ["Alignment of __darwin_ymm_reg"][::std::mem::align_of::<__darwin_ymm_reg>() - 1usize];
    ["Offset of field: __darwin_ymm_reg::__ymm_reg"]
        [::std::mem::offset_of!(__darwin_ymm_reg, __ymm_reg) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::std::os::raw::c_char; 64usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_zmm_reg"][::std::mem::size_of::<__darwin_zmm_reg>() - 64usize];
    ["Alignment of __darwin_zmm_reg"][::std::mem::align_of::<__darwin_zmm_reg>() - 1usize];
    ["Offset of field: __darwin_zmm_reg::__zmm_reg"]
        [::std::mem::offset_of!(__darwin_zmm_reg, __zmm_reg) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::std::os::raw::c_char; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_opmask_reg"][::std::mem::size_of::<__darwin_opmask_reg>() - 8usize];
    ["Alignment of __darwin_opmask_reg"][::std::mem::align_of::<__darwin_opmask_reg>() - 1usize];
    ["Offset of field: __darwin_opmask_reg::__opmask_reg"]
        [::std::mem::offset_of!(__darwin_opmask_reg, __opmask_reg) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_i386_float_state"]
        [::std::mem::size_of::<__darwin_i386_float_state>() - 524usize];
    ["Alignment of __darwin_i386_float_state"]
        [::std::mem::align_of::<__darwin_i386_float_state>() - 4usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_reserved"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_reserved) - 0usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_fcw"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_fcw) - 8usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_fsw"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_fsw) - 10usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_ftw"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_ftw) - 12usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_rsrv1"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_rsrv1) - 13usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_fop"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_fop) - 14usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_ip"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_ip) - 16usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_cs"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_cs) - 20usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_rsrv2"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_rsrv2) - 22usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_dp"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_dp) - 24usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_ds"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_ds) - 28usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_rsrv3"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_rsrv3) - 30usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_mxcsr"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_mxcsr) - 32usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_mxcsrmask"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_mxcsrmask) - 36usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_stmm0"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_stmm0) - 40usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_stmm1"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_stmm1) - 56usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_stmm2"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_stmm2) - 72usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_stmm3"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_stmm3) - 88usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_stmm4"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_stmm4) - 104usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_stmm5"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_stmm5) - 120usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_stmm6"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_stmm6) - 136usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_stmm7"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_stmm7) - 152usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_xmm0"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_xmm0) - 168usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_xmm1"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_xmm1) - 184usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_xmm2"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_xmm2) - 200usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_xmm3"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_xmm3) - 216usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_xmm4"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_xmm4) - 232usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_xmm5"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_xmm5) - 248usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_xmm6"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_xmm6) - 264usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_xmm7"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_xmm7) - 280usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_rsrv4"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_rsrv4) - 296usize];
    ["Offset of field: __darwin_i386_float_state::__fpu_reserved1"]
        [::std::mem::offset_of!(__darwin_i386_float_state, __fpu_reserved1) - 520usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_i386_avx_state"]
        [::std::mem::size_of::<__darwin_i386_avx_state>() - 716usize];
    ["Alignment of __darwin_i386_avx_state"]
        [::std::mem::align_of::<__darwin_i386_avx_state>() - 4usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_reserved"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_reserved) - 0usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_fcw"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_fcw) - 8usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_fsw"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_fsw) - 10usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ftw"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ftw) - 12usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_rsrv1"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_rsrv1) - 13usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_fop"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_fop) - 14usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ip"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ip) - 16usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_cs"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_cs) - 20usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_rsrv2"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_rsrv2) - 22usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_dp"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_dp) - 24usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ds"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ds) - 28usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_rsrv3"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_rsrv3) - 30usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_mxcsr"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_mxcsr) - 32usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_mxcsrmask"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_mxcsrmask) - 36usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_stmm0"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_stmm0) - 40usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_stmm1"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_stmm1) - 56usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_stmm2"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_stmm2) - 72usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_stmm3"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_stmm3) - 88usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_stmm4"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_stmm4) - 104usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_stmm5"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_stmm5) - 120usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_stmm6"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_stmm6) - 136usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_stmm7"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_stmm7) - 152usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_xmm0"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_xmm0) - 168usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_xmm1"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_xmm1) - 184usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_xmm2"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_xmm2) - 200usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_xmm3"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_xmm3) - 216usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_xmm4"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_xmm4) - 232usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_xmm5"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_xmm5) - 248usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_xmm6"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_xmm6) - 264usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_xmm7"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_xmm7) - 280usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_rsrv4"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_rsrv4) - 296usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_reserved1"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_reserved1) - 520usize];
    ["Offset of field: __darwin_i386_avx_state::__avx_reserved1"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __avx_reserved1) - 524usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ymmh0"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ymmh0) - 588usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ymmh1"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ymmh1) - 604usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ymmh2"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ymmh2) - 620usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ymmh3"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ymmh3) - 636usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ymmh4"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ymmh4) - 652usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ymmh5"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ymmh5) - 668usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ymmh6"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ymmh6) - 684usize];
    ["Offset of field: __darwin_i386_avx_state::__fpu_ymmh7"]
        [::std::mem::offset_of!(__darwin_i386_avx_state, __fpu_ymmh7) - 700usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_i386_avx512_state"]
        [::std::mem::size_of::<__darwin_i386_avx512_state>() - 1036usize];
    ["Alignment of __darwin_i386_avx512_state"]
        [::std::mem::align_of::<__darwin_i386_avx512_state>() - 4usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_reserved"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_reserved) - 0usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_fcw"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_fcw) - 8usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_fsw"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_fsw) - 10usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ftw"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ftw) - 12usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_rsrv1"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_rsrv1) - 13usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_fop"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_fop) - 14usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ip"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ip) - 16usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_cs"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_cs) - 20usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_rsrv2"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_rsrv2) - 22usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_dp"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_dp) - 24usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ds"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ds) - 28usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_rsrv3"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_rsrv3) - 30usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_mxcsr"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_mxcsr) - 32usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_mxcsrmask"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_mxcsrmask) - 36usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_stmm0"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_stmm0) - 40usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_stmm1"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_stmm1) - 56usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_stmm2"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_stmm2) - 72usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_stmm3"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_stmm3) - 88usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_stmm4"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_stmm4) - 104usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_stmm5"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_stmm5) - 120usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_stmm6"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_stmm6) - 136usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_stmm7"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_stmm7) - 152usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_xmm0"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_xmm0) - 168usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_xmm1"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_xmm1) - 184usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_xmm2"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_xmm2) - 200usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_xmm3"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_xmm3) - 216usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_xmm4"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_xmm4) - 232usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_xmm5"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_xmm5) - 248usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_xmm6"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_xmm6) - 264usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_xmm7"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_xmm7) - 280usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_rsrv4"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_rsrv4) - 296usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_reserved1"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_reserved1) - 520usize];
    ["Offset of field: __darwin_i386_avx512_state::__avx_reserved1"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __avx_reserved1) - 524usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ymmh0"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ymmh0) - 588usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ymmh1"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ymmh1) - 604usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ymmh2"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ymmh2) - 620usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ymmh3"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ymmh3) - 636usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ymmh4"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ymmh4) - 652usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ymmh5"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ymmh5) - 668usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ymmh6"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ymmh6) - 684usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_ymmh7"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_ymmh7) - 700usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_k0"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_k0) - 716usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_k1"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_k1) - 724usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_k2"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_k2) - 732usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_k3"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_k3) - 740usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_k4"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_k4) - 748usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_k5"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_k5) - 756usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_k6"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_k6) - 764usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_k7"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_k7) - 772usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_zmmh0"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_zmmh0) - 780usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_zmmh1"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_zmmh1) - 812usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_zmmh2"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_zmmh2) - 844usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_zmmh3"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_zmmh3) - 876usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_zmmh4"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_zmmh4) - 908usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_zmmh5"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_zmmh5) - 940usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_zmmh6"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_zmmh6) - 972usize];
    ["Offset of field: __darwin_i386_avx512_state::__fpu_zmmh7"]
        [::std::mem::offset_of!(__darwin_i386_avx512_state, __fpu_zmmh7) - 1004usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_i386_exception_state"]
        [::std::mem::size_of::<__darwin_i386_exception_state>() - 12usize];
    ["Alignment of __darwin_i386_exception_state"]
        [::std::mem::align_of::<__darwin_i386_exception_state>() - 4usize];
    ["Offset of field: __darwin_i386_exception_state::__trapno"]
        [::std::mem::offset_of!(__darwin_i386_exception_state, __trapno) - 0usize];
    ["Offset of field: __darwin_i386_exception_state::__cpu"]
        [::std::mem::offset_of!(__darwin_i386_exception_state, __cpu) - 2usize];
    ["Offset of field: __darwin_i386_exception_state::__err"]
        [::std::mem::offset_of!(__darwin_i386_exception_state, __err) - 4usize];
    ["Offset of field: __darwin_i386_exception_state::__faultvaddr"]
        [::std::mem::offset_of!(__darwin_i386_exception_state, __faultvaddr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::std::os::raw::c_uint,
    pub __dr1: ::std::os::raw::c_uint,
    pub __dr2: ::std::os::raw::c_uint,
    pub __dr3: ::std::os::raw::c_uint,
    pub __dr4: ::std::os::raw::c_uint,
    pub __dr5: ::std::os::raw::c_uint,
    pub __dr6: ::std::os::raw::c_uint,
    pub __dr7: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_x86_debug_state32"]
        [::std::mem::size_of::<__darwin_x86_debug_state32>() - 32usize];
    ["Alignment of __darwin_x86_debug_state32"]
        [::std::mem::align_of::<__darwin_x86_debug_state32>() - 4usize];
    ["Offset of field: __darwin_x86_debug_state32::__dr0"]
        [::std::mem::offset_of!(__darwin_x86_debug_state32, __dr0) - 0usize];
    ["Offset of field: __darwin_x86_debug_state32::__dr1"]
        [::std::mem::offset_of!(__darwin_x86_debug_state32, __dr1) - 4usize];
    ["Offset of field: __darwin_x86_debug_state32::__dr2"]
        [::std::mem::offset_of!(__darwin_x86_debug_state32, __dr2) - 8usize];
    ["Offset of field: __darwin_x86_debug_state32::__dr3"]
        [::std::mem::offset_of!(__darwin_x86_debug_state32, __dr3) - 12usize];
    ["Offset of field: __darwin_x86_debug_state32::__dr4"]
        [::std::mem::offset_of!(__darwin_x86_debug_state32, __dr4) - 16usize];
    ["Offset of field: __darwin_x86_debug_state32::__dr5"]
        [::std::mem::offset_of!(__darwin_x86_debug_state32, __dr5) - 20usize];
    ["Offset of field: __darwin_x86_debug_state32::__dr6"]
        [::std::mem::offset_of!(__darwin_x86_debug_state32, __dr6) - 24usize];
    ["Offset of field: __darwin_x86_debug_state32::__dr7"]
        [::std::mem::offset_of!(__darwin_x86_debug_state32, __dr7) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_instruction_state {
    pub __insn_stream_valid_bytes: ::std::os::raw::c_int,
    pub __insn_offset: ::std::os::raw::c_int,
    pub __out_of_synch: ::std::os::raw::c_int,
    pub __insn_bytes: [__uint8_t; 2380usize],
    pub __insn_cacheline: [__uint8_t; 64usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __x86_instruction_state"]
        [::std::mem::size_of::<__x86_instruction_state>() - 2456usize];
    ["Alignment of __x86_instruction_state"]
        [::std::mem::align_of::<__x86_instruction_state>() - 4usize];
    ["Offset of field: __x86_instruction_state::__insn_stream_valid_bytes"]
        [::std::mem::offset_of!(__x86_instruction_state, __insn_stream_valid_bytes) - 0usize];
    ["Offset of field: __x86_instruction_state::__insn_offset"]
        [::std::mem::offset_of!(__x86_instruction_state, __insn_offset) - 4usize];
    ["Offset of field: __x86_instruction_state::__out_of_synch"]
        [::std::mem::offset_of!(__x86_instruction_state, __out_of_synch) - 8usize];
    ["Offset of field: __x86_instruction_state::__insn_bytes"]
        [::std::mem::offset_of!(__x86_instruction_state, __insn_bytes) - 12usize];
    ["Offset of field: __x86_instruction_state::__insn_cacheline"]
        [::std::mem::offset_of!(__x86_instruction_state, __insn_cacheline) - 2392usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __last_branch_record {
    pub __from_ip: __uint64_t,
    pub __to_ip: __uint64_t,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __last_branch_record"][::std::mem::size_of::<__last_branch_record>() - 24usize];
    ["Alignment of __last_branch_record"][::std::mem::align_of::<__last_branch_record>() - 8usize];
    ["Offset of field: __last_branch_record::__from_ip"]
        [::std::mem::offset_of!(__last_branch_record, __from_ip) - 0usize];
    ["Offset of field: __last_branch_record::__to_ip"]
        [::std::mem::offset_of!(__last_branch_record, __to_ip) - 8usize];
};
impl __last_branch_record {
    #[inline]
    pub fn __mispredict(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___mispredict(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __mispredict_raw(this: *const Self) -> __uint32_t {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set___mispredict_raw(this: *mut Self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __tsx_abort(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___tsx_abort(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __tsx_abort_raw(this: *const Self) -> __uint32_t {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set___tsx_abort_raw(this: *mut Self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __in_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___in_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __in_tsx_raw(this: *const Self) -> __uint32_t {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set___in_tsx_raw(this: *mut Self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set___cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __cycle_count_raw(this: *const Self) -> __uint32_t {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                16u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set___cycle_count_raw(this: *mut Self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                16u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 13u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __reserved_raw(this: *const Self) -> __uint32_t {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                19usize,
                13u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set___reserved_raw(this: *mut Self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                19usize,
                13u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __mispredict: __uint32_t,
        __tsx_abort: __uint32_t,
        __in_tsx: __uint32_t,
        __cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __mispredict: u32 = unsafe { ::std::mem::transmute(__mispredict) };
            __mispredict as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __tsx_abort: u32 = unsafe { ::std::mem::transmute(__tsx_abort) };
            __tsx_abort as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __in_tsx: u32 = unsafe { ::std::mem::transmute(__in_tsx) };
            __in_tsx as u64
        });
        __bindgen_bitfield_unit.set(3usize, 16u8, {
            let __cycle_count: u32 = unsafe { ::std::mem::transmute(__cycle_count) };
            __cycle_count as u64
        });
        __bindgen_bitfield_unit.set(19usize, 13u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __last_branch_state {
    pub __lbr_count: ::std::os::raw::c_int,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __lbrs: [__last_branch_record; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __last_branch_state"][::std::mem::size_of::<__last_branch_state>() - 776usize];
    ["Alignment of __last_branch_state"][::std::mem::align_of::<__last_branch_state>() - 8usize];
    ["Offset of field: __last_branch_state::__lbr_count"]
        [::std::mem::offset_of!(__last_branch_state, __lbr_count) - 0usize];
    ["Offset of field: __last_branch_state::__lbrs"]
        [::std::mem::offset_of!(__last_branch_state, __lbrs) - 8usize];
};
impl __last_branch_state {
    #[inline]
    pub fn __lbr_supported_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __lbr_supported_tsx_raw(this: *const Self) -> __uint32_t {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set___lbr_supported_tsx_raw(this: *mut Self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __lbr_supported_cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __lbr_supported_cycle_count_raw(this: *const Self) -> __uint32_t {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set___lbr_supported_cycle_count_raw(this: *mut Self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __reserved_raw(this: *const Self) -> __uint32_t {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                30u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set___reserved_raw(this: *mut Self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                30u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __lbr_supported_tsx: __uint32_t,
        __lbr_supported_cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __lbr_supported_tsx: u32 = unsafe { ::std::mem::transmute(__lbr_supported_tsx) };
            __lbr_supported_tsx as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __lbr_supported_cycle_count: u32 =
                unsafe { ::std::mem::transmute(__lbr_supported_cycle_count) };
            __lbr_supported_cycle_count as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __x86_pagein_state"][::std::mem::size_of::<__x86_pagein_state>() - 4usize];
    ["Alignment of __x86_pagein_state"][::std::mem::align_of::<__x86_pagein_state>() - 4usize];
    ["Offset of field: __x86_pagein_state::__pagein_error"]
        [::std::mem::offset_of!(__x86_pagein_state, __pagein_error) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_x86_thread_state64"]
        [::std::mem::size_of::<__darwin_x86_thread_state64>() - 168usize];
    ["Alignment of __darwin_x86_thread_state64"]
        [::std::mem::align_of::<__darwin_x86_thread_state64>() - 8usize];
    ["Offset of field: __darwin_x86_thread_state64::__rax"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rax) - 0usize];
    ["Offset of field: __darwin_x86_thread_state64::__rbx"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rbx) - 8usize];
    ["Offset of field: __darwin_x86_thread_state64::__rcx"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rcx) - 16usize];
    ["Offset of field: __darwin_x86_thread_state64::__rdx"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rdx) - 24usize];
    ["Offset of field: __darwin_x86_thread_state64::__rdi"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rdi) - 32usize];
    ["Offset of field: __darwin_x86_thread_state64::__rsi"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rsi) - 40usize];
    ["Offset of field: __darwin_x86_thread_state64::__rbp"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rbp) - 48usize];
    ["Offset of field: __darwin_x86_thread_state64::__rsp"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rsp) - 56usize];
    ["Offset of field: __darwin_x86_thread_state64::__r8"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __r8) - 64usize];
    ["Offset of field: __darwin_x86_thread_state64::__r9"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __r9) - 72usize];
    ["Offset of field: __darwin_x86_thread_state64::__r10"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __r10) - 80usize];
    ["Offset of field: __darwin_x86_thread_state64::__r11"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __r11) - 88usize];
    ["Offset of field: __darwin_x86_thread_state64::__r12"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __r12) - 96usize];
    ["Offset of field: __darwin_x86_thread_state64::__r13"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __r13) - 104usize];
    ["Offset of field: __darwin_x86_thread_state64::__r14"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __r14) - 112usize];
    ["Offset of field: __darwin_x86_thread_state64::__r15"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __r15) - 120usize];
    ["Offset of field: __darwin_x86_thread_state64::__rip"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rip) - 128usize];
    ["Offset of field: __darwin_x86_thread_state64::__rflags"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __rflags) - 136usize];
    ["Offset of field: __darwin_x86_thread_state64::__cs"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __cs) - 144usize];
    ["Offset of field: __darwin_x86_thread_state64::__fs"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __fs) - 152usize];
    ["Offset of field: __darwin_x86_thread_state64::__gs"]
        [::std::mem::offset_of!(__darwin_x86_thread_state64, __gs) - 160usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_x86_thread_full_state64"]
        [::std::mem::size_of::<__darwin_x86_thread_full_state64>() - 200usize];
    ["Alignment of __darwin_x86_thread_full_state64"]
        [::std::mem::align_of::<__darwin_x86_thread_full_state64>() - 8usize];
    ["Offset of field: __darwin_x86_thread_full_state64::__ss64"]
        [::std::mem::offset_of!(__darwin_x86_thread_full_state64, __ss64) - 0usize];
    ["Offset of field: __darwin_x86_thread_full_state64::__ds"]
        [::std::mem::offset_of!(__darwin_x86_thread_full_state64, __ds) - 168usize];
    ["Offset of field: __darwin_x86_thread_full_state64::__es"]
        [::std::mem::offset_of!(__darwin_x86_thread_full_state64, __es) - 176usize];
    ["Offset of field: __darwin_x86_thread_full_state64::__ss"]
        [::std::mem::offset_of!(__darwin_x86_thread_full_state64, __ss) - 184usize];
    ["Offset of field: __darwin_x86_thread_full_state64::__gsbase"]
        [::std::mem::offset_of!(__darwin_x86_thread_full_state64, __gsbase) - 192usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_x86_float_state64"]
        [::std::mem::size_of::<__darwin_x86_float_state64>() - 524usize];
    ["Alignment of __darwin_x86_float_state64"]
        [::std::mem::align_of::<__darwin_x86_float_state64>() - 4usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_reserved"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_reserved) - 0usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_fcw"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_fcw) - 8usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_fsw"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_fsw) - 10usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_ftw"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_ftw) - 12usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_rsrv1"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_rsrv1) - 13usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_fop"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_fop) - 14usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_ip"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_ip) - 16usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_cs"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_cs) - 20usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_rsrv2"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_rsrv2) - 22usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_dp"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_dp) - 24usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_ds"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_ds) - 28usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_rsrv3"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_rsrv3) - 30usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_mxcsr"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_mxcsr) - 32usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_mxcsrmask"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_mxcsrmask) - 36usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_stmm0"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_stmm0) - 40usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_stmm1"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_stmm1) - 56usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_stmm2"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_stmm2) - 72usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_stmm3"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_stmm3) - 88usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_stmm4"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_stmm4) - 104usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_stmm5"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_stmm5) - 120usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_stmm6"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_stmm6) - 136usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_stmm7"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_stmm7) - 152usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm0"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm0) - 168usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm1"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm1) - 184usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm2"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm2) - 200usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm3"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm3) - 216usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm4"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm4) - 232usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm5"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm5) - 248usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm6"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm6) - 264usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm7"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm7) - 280usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm8"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm8) - 296usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm9"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm9) - 312usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm10"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm10) - 328usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm11"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm11) - 344usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm12"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm12) - 360usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm13"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm13) - 376usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm14"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm14) - 392usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_xmm15"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_xmm15) - 408usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_rsrv4"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_rsrv4) - 424usize];
    ["Offset of field: __darwin_x86_float_state64::__fpu_reserved1"]
        [::std::mem::offset_of!(__darwin_x86_float_state64, __fpu_reserved1) - 520usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_x86_avx_state64"]
        [::std::mem::size_of::<__darwin_x86_avx_state64>() - 844usize];
    ["Alignment of __darwin_x86_avx_state64"]
        [::std::mem::align_of::<__darwin_x86_avx_state64>() - 4usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_reserved"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_reserved) - 0usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_fcw"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_fcw) - 8usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_fsw"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_fsw) - 10usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ftw"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ftw) - 12usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_rsrv1"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_rsrv1) - 13usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_fop"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_fop) - 14usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ip"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ip) - 16usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_cs"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_cs) - 20usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_rsrv2"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_rsrv2) - 22usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_dp"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_dp) - 24usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ds"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ds) - 28usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_rsrv3"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_rsrv3) - 30usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_mxcsr"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_mxcsr) - 32usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_mxcsrmask"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_mxcsrmask) - 36usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_stmm0"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_stmm0) - 40usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_stmm1"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_stmm1) - 56usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_stmm2"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_stmm2) - 72usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_stmm3"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_stmm3) - 88usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_stmm4"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_stmm4) - 104usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_stmm5"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_stmm5) - 120usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_stmm6"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_stmm6) - 136usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_stmm7"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_stmm7) - 152usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm0"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm0) - 168usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm1"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm1) - 184usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm2"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm2) - 200usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm3"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm3) - 216usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm4"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm4) - 232usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm5"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm5) - 248usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm6"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm6) - 264usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm7"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm7) - 280usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm8"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm8) - 296usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm9"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm9) - 312usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm10"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm10) - 328usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm11"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm11) - 344usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm12"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm12) - 360usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm13"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm13) - 376usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm14"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm14) - 392usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_xmm15"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_xmm15) - 408usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_rsrv4"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_rsrv4) - 424usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_reserved1"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_reserved1) - 520usize];
    ["Offset of field: __darwin_x86_avx_state64::__avx_reserved1"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __avx_reserved1) - 524usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh0"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh0) - 588usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh1"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh1) - 604usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh2"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh2) - 620usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh3"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh3) - 636usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh4"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh4) - 652usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh5"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh5) - 668usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh6"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh6) - 684usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh7"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh7) - 700usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh8"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh8) - 716usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh9"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh9) - 732usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh10"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh10) - 748usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh11"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh11) - 764usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh12"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh12) - 780usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh13"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh13) - 796usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh14"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh14) - 812usize];
    ["Offset of field: __darwin_x86_avx_state64::__fpu_ymmh15"]
        [::std::mem::offset_of!(__darwin_x86_avx_state64, __fpu_ymmh15) - 828usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_x86_avx512_state64"]
        [::std::mem::size_of::<__darwin_x86_avx512_state64>() - 2444usize];
    ["Alignment of __darwin_x86_avx512_state64"]
        [::std::mem::align_of::<__darwin_x86_avx512_state64>() - 4usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_reserved"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_reserved) - 0usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_fcw"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_fcw) - 8usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_fsw"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_fsw) - 10usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ftw"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ftw) - 12usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_rsrv1"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_rsrv1) - 13usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_fop"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_fop) - 14usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ip"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ip) - 16usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_cs"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_cs) - 20usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_rsrv2"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_rsrv2) - 22usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_dp"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_dp) - 24usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ds"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ds) - 28usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_rsrv3"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_rsrv3) - 30usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_mxcsr"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_mxcsr) - 32usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_mxcsrmask"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_mxcsrmask) - 36usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_stmm0"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_stmm0) - 40usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_stmm1"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_stmm1) - 56usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_stmm2"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_stmm2) - 72usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_stmm3"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_stmm3) - 88usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_stmm4"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_stmm4) - 104usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_stmm5"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_stmm5) - 120usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_stmm6"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_stmm6) - 136usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_stmm7"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_stmm7) - 152usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm0"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm0) - 168usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm1"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm1) - 184usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm2"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm2) - 200usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm3"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm3) - 216usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm4"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm4) - 232usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm5"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm5) - 248usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm6"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm6) - 264usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm7"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm7) - 280usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm8"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm8) - 296usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm9"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm9) - 312usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm10"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm10) - 328usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm11"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm11) - 344usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm12"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm12) - 360usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm13"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm13) - 376usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm14"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm14) - 392usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_xmm15"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_xmm15) - 408usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_rsrv4"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_rsrv4) - 424usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_reserved1"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_reserved1) - 520usize];
    ["Offset of field: __darwin_x86_avx512_state64::__avx_reserved1"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __avx_reserved1) - 524usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh0"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh0) - 588usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh1"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh1) - 604usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh2"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh2) - 620usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh3"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh3) - 636usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh4"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh4) - 652usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh5"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh5) - 668usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh6"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh6) - 684usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh7"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh7) - 700usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh8"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh8) - 716usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh9"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh9) - 732usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh10"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh10) - 748usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh11"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh11) - 764usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh12"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh12) - 780usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh13"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh13) - 796usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh14"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh14) - 812usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_ymmh15"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_ymmh15) - 828usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_k0"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_k0) - 844usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_k1"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_k1) - 852usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_k2"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_k2) - 860usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_k3"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_k3) - 868usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_k4"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_k4) - 876usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_k5"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_k5) - 884usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_k6"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_k6) - 892usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_k7"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_k7) - 900usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh0"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh0) - 908usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh1"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh1) - 940usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh2"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh2) - 972usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh3"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh3) - 1004usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh4"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh4) - 1036usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh5"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh5) - 1068usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh6"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh6) - 1100usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh7"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh7) - 1132usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh8"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh8) - 1164usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh9"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh9) - 1196usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh10"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh10) - 1228usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh11"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh11) - 1260usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh12"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh12) - 1292usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh13"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh13) - 1324usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh14"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh14) - 1356usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmmh15"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmmh15) - 1388usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm16"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm16) - 1420usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm17"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm17) - 1484usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm18"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm18) - 1548usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm19"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm19) - 1612usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm20"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm20) - 1676usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm21"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm21) - 1740usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm22"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm22) - 1804usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm23"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm23) - 1868usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm24"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm24) - 1932usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm25"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm25) - 1996usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm26"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm26) - 2060usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm27"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm27) - 2124usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm28"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm28) - 2188usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm29"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm29) - 2252usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm30"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm30) - 2316usize];
    ["Offset of field: __darwin_x86_avx512_state64::__fpu_zmm31"]
        [::std::mem::offset_of!(__darwin_x86_avx512_state64, __fpu_zmm31) - 2380usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_x86_exception_state64"]
        [::std::mem::size_of::<__darwin_x86_exception_state64>() - 16usize];
    ["Alignment of __darwin_x86_exception_state64"]
        [::std::mem::align_of::<__darwin_x86_exception_state64>() - 8usize];
    ["Offset of field: __darwin_x86_exception_state64::__trapno"]
        [::std::mem::offset_of!(__darwin_x86_exception_state64, __trapno) - 0usize];
    ["Offset of field: __darwin_x86_exception_state64::__cpu"]
        [::std::mem::offset_of!(__darwin_x86_exception_state64, __cpu) - 2usize];
    ["Offset of field: __darwin_x86_exception_state64::__err"]
        [::std::mem::offset_of!(__darwin_x86_exception_state64, __err) - 4usize];
    ["Offset of field: __darwin_x86_exception_state64::__faultvaddr"]
        [::std::mem::offset_of!(__darwin_x86_exception_state64, __faultvaddr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_x86_debug_state64"]
        [::std::mem::size_of::<__darwin_x86_debug_state64>() - 64usize];
    ["Alignment of __darwin_x86_debug_state64"]
        [::std::mem::align_of::<__darwin_x86_debug_state64>() - 8usize];
    ["Offset of field: __darwin_x86_debug_state64::__dr0"]
        [::std::mem::offset_of!(__darwin_x86_debug_state64, __dr0) - 0usize];
    ["Offset of field: __darwin_x86_debug_state64::__dr1"]
        [::std::mem::offset_of!(__darwin_x86_debug_state64, __dr1) - 8usize];
    ["Offset of field: __darwin_x86_debug_state64::__dr2"]
        [::std::mem::offset_of!(__darwin_x86_debug_state64, __dr2) - 16usize];
    ["Offset of field: __darwin_x86_debug_state64::__dr3"]
        [::std::mem::offset_of!(__darwin_x86_debug_state64, __dr3) - 24usize];
    ["Offset of field: __darwin_x86_debug_state64::__dr4"]
        [::std::mem::offset_of!(__darwin_x86_debug_state64, __dr4) - 32usize];
    ["Offset of field: __darwin_x86_debug_state64::__dr5"]
        [::std::mem::offset_of!(__darwin_x86_debug_state64, __dr5) - 40usize];
    ["Offset of field: __darwin_x86_debug_state64::__dr6"]
        [::std::mem::offset_of!(__darwin_x86_debug_state64, __dr6) - 48usize];
    ["Offset of field: __darwin_x86_debug_state64::__dr7"]
        [::std::mem::offset_of!(__darwin_x86_debug_state64, __dr7) - 56usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_x86_cpmu_state64"]
        [::std::mem::size_of::<__darwin_x86_cpmu_state64>() - 128usize];
    ["Alignment of __darwin_x86_cpmu_state64"]
        [::std::mem::align_of::<__darwin_x86_cpmu_state64>() - 8usize];
    ["Offset of field: __darwin_x86_cpmu_state64::__ctrs"]
        [::std::mem::offset_of!(__darwin_x86_cpmu_state64, __ctrs) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_float_state,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mcontext32"][::std::mem::size_of::<__darwin_mcontext32>() - 600usize];
    ["Alignment of __darwin_mcontext32"][::std::mem::align_of::<__darwin_mcontext32>() - 4usize];
    ["Offset of field: __darwin_mcontext32::__es"]
        [::std::mem::offset_of!(__darwin_mcontext32, __es) - 0usize];
    ["Offset of field: __darwin_mcontext32::__ss"]
        [::std::mem::offset_of!(__darwin_mcontext32, __ss) - 12usize];
    ["Offset of field: __darwin_mcontext32::__fs"]
        [::std::mem::offset_of!(__darwin_mcontext32, __fs) - 76usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx_state,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mcontext_avx32"]
        [::std::mem::size_of::<__darwin_mcontext_avx32>() - 792usize];
    ["Alignment of __darwin_mcontext_avx32"]
        [::std::mem::align_of::<__darwin_mcontext_avx32>() - 4usize];
    ["Offset of field: __darwin_mcontext_avx32::__es"]
        [::std::mem::offset_of!(__darwin_mcontext_avx32, __es) - 0usize];
    ["Offset of field: __darwin_mcontext_avx32::__ss"]
        [::std::mem::offset_of!(__darwin_mcontext_avx32, __ss) - 12usize];
    ["Offset of field: __darwin_mcontext_avx32::__fs"]
        [::std::mem::offset_of!(__darwin_mcontext_avx32, __fs) - 76usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx512_state,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mcontext_avx512_32"]
        [::std::mem::size_of::<__darwin_mcontext_avx512_32>() - 1112usize];
    ["Alignment of __darwin_mcontext_avx512_32"]
        [::std::mem::align_of::<__darwin_mcontext_avx512_32>() - 4usize];
    ["Offset of field: __darwin_mcontext_avx512_32::__es"]
        [::std::mem::offset_of!(__darwin_mcontext_avx512_32, __es) - 0usize];
    ["Offset of field: __darwin_mcontext_avx512_32::__ss"]
        [::std::mem::offset_of!(__darwin_mcontext_avx512_32, __ss) - 12usize];
    ["Offset of field: __darwin_mcontext_avx512_32::__fs"]
        [::std::mem::offset_of!(__darwin_mcontext_avx512_32, __fs) - 76usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mcontext64"][::std::mem::size_of::<__darwin_mcontext64>() - 712usize];
    ["Alignment of __darwin_mcontext64"][::std::mem::align_of::<__darwin_mcontext64>() - 8usize];
    ["Offset of field: __darwin_mcontext64::__es"]
        [::std::mem::offset_of!(__darwin_mcontext64, __es) - 0usize];
    ["Offset of field: __darwin_mcontext64::__ss"]
        [::std::mem::offset_of!(__darwin_mcontext64, __ss) - 16usize];
    ["Offset of field: __darwin_mcontext64::__fs"]
        [::std::mem::offset_of!(__darwin_mcontext64, __fs) - 184usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mcontext64_full"]
        [::std::mem::size_of::<__darwin_mcontext64_full>() - 744usize];
    ["Alignment of __darwin_mcontext64_full"]
        [::std::mem::align_of::<__darwin_mcontext64_full>() - 8usize];
    ["Offset of field: __darwin_mcontext64_full::__es"]
        [::std::mem::offset_of!(__darwin_mcontext64_full, __es) - 0usize];
    ["Offset of field: __darwin_mcontext64_full::__ss"]
        [::std::mem::offset_of!(__darwin_mcontext64_full, __ss) - 16usize];
    ["Offset of field: __darwin_mcontext64_full::__fs"]
        [::std::mem::offset_of!(__darwin_mcontext64_full, __fs) - 216usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mcontext_avx64"]
        [::std::mem::size_of::<__darwin_mcontext_avx64>() - 1032usize];
    ["Alignment of __darwin_mcontext_avx64"]
        [::std::mem::align_of::<__darwin_mcontext_avx64>() - 8usize];
    ["Offset of field: __darwin_mcontext_avx64::__es"]
        [::std::mem::offset_of!(__darwin_mcontext_avx64, __es) - 0usize];
    ["Offset of field: __darwin_mcontext_avx64::__ss"]
        [::std::mem::offset_of!(__darwin_mcontext_avx64, __ss) - 16usize];
    ["Offset of field: __darwin_mcontext_avx64::__fs"]
        [::std::mem::offset_of!(__darwin_mcontext_avx64, __fs) - 184usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mcontext_avx64_full"]
        [::std::mem::size_of::<__darwin_mcontext_avx64_full>() - 1064usize];
    ["Alignment of __darwin_mcontext_avx64_full"]
        [::std::mem::align_of::<__darwin_mcontext_avx64_full>() - 8usize];
    ["Offset of field: __darwin_mcontext_avx64_full::__es"]
        [::std::mem::offset_of!(__darwin_mcontext_avx64_full, __es) - 0usize];
    ["Offset of field: __darwin_mcontext_avx64_full::__ss"]
        [::std::mem::offset_of!(__darwin_mcontext_avx64_full, __ss) - 16usize];
    ["Offset of field: __darwin_mcontext_avx64_full::__fs"]
        [::std::mem::offset_of!(__darwin_mcontext_avx64_full, __fs) - 216usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mcontext_avx512_64"]
        [::std::mem::size_of::<__darwin_mcontext_avx512_64>() - 2632usize];
    ["Alignment of __darwin_mcontext_avx512_64"]
        [::std::mem::align_of::<__darwin_mcontext_avx512_64>() - 8usize];
    ["Offset of field: __darwin_mcontext_avx512_64::__es"]
        [::std::mem::offset_of!(__darwin_mcontext_avx512_64, __es) - 0usize];
    ["Offset of field: __darwin_mcontext_avx512_64::__ss"]
        [::std::mem::offset_of!(__darwin_mcontext_avx512_64, __ss) - 16usize];
    ["Offset of field: __darwin_mcontext_avx512_64::__fs"]
        [::std::mem::offset_of!(__darwin_mcontext_avx512_64, __fs) - 184usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_mcontext_avx512_64_full"]
        [::std::mem::size_of::<__darwin_mcontext_avx512_64_full>() - 2664usize];
    ["Alignment of __darwin_mcontext_avx512_64_full"]
        [::std::mem::align_of::<__darwin_mcontext_avx512_64_full>() - 8usize];
    ["Offset of field: __darwin_mcontext_avx512_64_full::__es"]
        [::std::mem::offset_of!(__darwin_mcontext_avx512_64_full, __es) - 0usize];
    ["Offset of field: __darwin_mcontext_avx512_64_full::__ss"]
        [::std::mem::offset_of!(__darwin_mcontext_avx512_64_full, __ss) - 16usize];
    ["Offset of field: __darwin_mcontext_avx512_64_full::__fs"]
        [::std::mem::offset_of!(__darwin_mcontext_avx512_64_full, __fs) - 216usize];
};
pub type mcontext_t = *mut __darwin_mcontext64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_sigaltstack"][::std::mem::size_of::<__darwin_sigaltstack>() - 24usize];
    ["Alignment of __darwin_sigaltstack"][::std::mem::align_of::<__darwin_sigaltstack>() - 8usize];
    ["Offset of field: __darwin_sigaltstack::ss_sp"]
        [::std::mem::offset_of!(__darwin_sigaltstack, ss_sp) - 0usize];
    ["Offset of field: __darwin_sigaltstack::ss_size"]
        [::std::mem::offset_of!(__darwin_sigaltstack, ss_size) - 8usize];
    ["Offset of field: __darwin_sigaltstack::ss_flags"]
        [::std::mem::offset_of!(__darwin_sigaltstack, ss_flags) - 16usize];
};
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __darwin_ucontext"][::std::mem::size_of::<__darwin_ucontext>() - 56usize];
    ["Alignment of __darwin_ucontext"][::std::mem::align_of::<__darwin_ucontext>() - 8usize];
    ["Offset of field: __darwin_ucontext::uc_onstack"]
        [::std::mem::offset_of!(__darwin_ucontext, uc_onstack) - 0usize];
    ["Offset of field: __darwin_ucontext::uc_sigmask"]
        [::std::mem::offset_of!(__darwin_ucontext, uc_sigmask) - 4usize];
    ["Offset of field: __darwin_ucontext::uc_stack"]
        [::std::mem::offset_of!(__darwin_ucontext, uc_stack) - 8usize];
    ["Offset of field: __darwin_ucontext::uc_link"]
        [::std::mem::offset_of!(__darwin_ucontext, uc_link) - 32usize];
    ["Offset of field: __darwin_ucontext::uc_mcsize"]
        [::std::mem::offset_of!(__darwin_ucontext, uc_mcsize) - 40usize];
    ["Offset of field: __darwin_ucontext::uc_mcontext"]
        [::std::mem::offset_of!(__darwin_ucontext, uc_mcontext) - 48usize];
};
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigval"][::std::mem::size_of::<sigval>() - 8usize];
    ["Alignment of sigval"][::std::mem::align_of::<sigval>() - 8usize];
    ["Offset of field: sigval::sival_int"][::std::mem::offset_of!(sigval, sival_int) - 0usize];
    ["Offset of field: sigval::sival_ptr"][::std::mem::offset_of!(sigval, sival_ptr) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigevent"][::std::mem::size_of::<sigevent>() - 32usize];
    ["Alignment of sigevent"][::std::mem::align_of::<sigevent>() - 8usize];
    ["Offset of field: sigevent::sigev_notify"]
        [::std::mem::offset_of!(sigevent, sigev_notify) - 0usize];
    ["Offset of field: sigevent::sigev_signo"]
        [::std::mem::offset_of!(sigevent, sigev_signo) - 4usize];
    ["Offset of field: sigevent::sigev_value"]
        [::std::mem::offset_of!(sigevent, sigev_value) - 8usize];
    ["Offset of field: sigevent::sigev_notify_function"]
        [::std::mem::offset_of!(sigevent, sigev_notify_function) - 16usize];
    ["Offset of field: sigevent::sigev_notify_attributes"]
        [::std::mem::offset_of!(sigevent, sigev_notify_attributes) - 24usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __siginfo"][::std::mem::size_of::<__siginfo>() - 104usize];
    ["Alignment of __siginfo"][::std::mem::align_of::<__siginfo>() - 8usize];
    ["Offset of field: __siginfo::si_signo"][::std::mem::offset_of!(__siginfo, si_signo) - 0usize];
    ["Offset of field: __siginfo::si_errno"][::std::mem::offset_of!(__siginfo, si_errno) - 4usize];
    ["Offset of field: __siginfo::si_code"][::std::mem::offset_of!(__siginfo, si_code) - 8usize];
    ["Offset of field: __siginfo::si_pid"][::std::mem::offset_of!(__siginfo, si_pid) - 12usize];
    ["Offset of field: __siginfo::si_uid"][::std::mem::offset_of!(__siginfo, si_uid) - 16usize];
    ["Offset of field: __siginfo::si_status"]
        [::std::mem::offset_of!(__siginfo, si_status) - 20usize];
    ["Offset of field: __siginfo::si_addr"][::std::mem::offset_of!(__siginfo, si_addr) - 24usize];
    ["Offset of field: __siginfo::si_value"][::std::mem::offset_of!(__siginfo, si_value) - 32usize];
    ["Offset of field: __siginfo::si_band"][::std::mem::offset_of!(__siginfo, si_band) - 40usize];
    ["Offset of field: __siginfo::__pad"][::std::mem::offset_of!(__siginfo, __pad) - 48usize];
};
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __sigaction_u"][::std::mem::size_of::<__sigaction_u>() - 8usize];
    ["Alignment of __sigaction_u"][::std::mem::align_of::<__sigaction_u>() - 8usize];
    ["Offset of field: __sigaction_u::__sa_handler"]
        [::std::mem::offset_of!(__sigaction_u, __sa_handler) - 0usize];
    ["Offset of field: __sigaction_u::__sa_sigaction"]
        [::std::mem::offset_of!(__sigaction_u, __sa_sigaction) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __sigaction"][::std::mem::size_of::<__sigaction>() - 24usize];
    ["Alignment of __sigaction"][::std::mem::align_of::<__sigaction>() - 8usize];
    ["Offset of field: __sigaction::__sigaction_u"]
        [::std::mem::offset_of!(__sigaction, __sigaction_u) - 0usize];
    ["Offset of field: __sigaction::sa_tramp"]
        [::std::mem::offset_of!(__sigaction, sa_tramp) - 8usize];
    ["Offset of field: __sigaction::sa_mask"]
        [::std::mem::offset_of!(__sigaction, sa_mask) - 16usize];
    ["Offset of field: __sigaction::sa_flags"]
        [::std::mem::offset_of!(__sigaction, sa_flags) - 20usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigaction"][::std::mem::size_of::<sigaction>() - 16usize];
    ["Alignment of sigaction"][::std::mem::align_of::<sigaction>() - 8usize];
    ["Offset of field: sigaction::__sigaction_u"]
        [::std::mem::offset_of!(sigaction, __sigaction_u) - 0usize];
    ["Offset of field: sigaction::sa_mask"][::std::mem::offset_of!(sigaction, sa_mask) - 8usize];
    ["Offset of field: sigaction::sa_flags"][::std::mem::offset_of!(sigaction, sa_flags) - 12usize];
};
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigvec"][::std::mem::size_of::<sigvec>() - 16usize];
    ["Alignment of sigvec"][::std::mem::align_of::<sigvec>() - 8usize];
    ["Offset of field: sigvec::sv_handler"][::std::mem::offset_of!(sigvec, sv_handler) - 0usize];
    ["Offset of field: sigvec::sv_mask"][::std::mem::offset_of!(sigvec, sv_mask) - 8usize];
    ["Offset of field: sigvec::sv_flags"][::std::mem::offset_of!(sigvec, sv_flags) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigstack"][::std::mem::size_of::<sigstack>() - 16usize];
    ["Alignment of sigstack"][::std::mem::align_of::<sigstack>() - 8usize];
    ["Offset of field: sigstack::ss_sp"][::std::mem::offset_of!(sigstack, ss_sp) - 0usize];
    ["Offset of field: sigstack::ss_onstack"]
        [::std::mem::offset_of!(sigstack, ss_onstack) - 8usize];
};
unsafe extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __darwin_time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timespec"][::std::mem::size_of::<timespec>() - 16usize];
    ["Alignment of timespec"][::std::mem::align_of::<timespec>() - 8usize];
    ["Offset of field: timespec::tv_sec"][::std::mem::offset_of!(timespec, tv_sec) - 0usize];
    ["Offset of field: timespec::tv_nsec"][::std::mem::offset_of!(timespec, tv_nsec) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timeval"][::std::mem::size_of::<timeval>() - 16usize];
    ["Alignment of timeval"][::std::mem::align_of::<timeval>() - 8usize];
    ["Offset of field: timeval::tv_sec"][::std::mem::offset_of!(timeval, tv_sec) - 0usize];
    ["Offset of field: timeval::tv_usec"][::std::mem::offset_of!(timeval, tv_usec) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval64 {
    pub tv_sec: __int64_t,
    pub tv_usec: __int64_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timeval64"][::std::mem::size_of::<timeval64>() - 16usize];
    ["Alignment of timeval64"][::std::mem::align_of::<timeval64>() - 8usize];
    ["Offset of field: timeval64::tv_sec"][::std::mem::offset_of!(timeval64, tv_sec) - 0usize];
    ["Offset of field: timeval64::tv_usec"][::std::mem::offset_of!(timeval64, tv_usec) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerval {
    pub it_interval: timeval,
    pub it_value: timeval,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of itimerval"][::std::mem::size_of::<itimerval>() - 32usize];
    ["Alignment of itimerval"][::std::mem::align_of::<itimerval>() - 8usize];
    ["Offset of field: itimerval::it_interval"]
        [::std::mem::offset_of!(itimerval, it_interval) - 0usize];
    ["Offset of field: itimerval::it_value"][::std::mem::offset_of!(itimerval, it_value) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timezone {
    pub tz_minuteswest: ::std::os::raw::c_int,
    pub tz_dsttime: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timezone"][::std::mem::size_of::<timezone>() - 8usize];
    ["Alignment of timezone"][::std::mem::align_of::<timezone>() - 4usize];
    ["Offset of field: timezone::tz_minuteswest"]
        [::std::mem::offset_of!(timezone, tz_minuteswest) - 0usize];
    ["Offset of field: timezone::tz_dsttime"]
        [::std::mem::offset_of!(timezone, tz_dsttime) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct clockinfo {
    pub hz: ::std::os::raw::c_int,
    pub tick: ::std::os::raw::c_int,
    pub tickadj: ::std::os::raw::c_int,
    pub stathz: ::std::os::raw::c_int,
    pub profhz: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clockinfo"][::std::mem::size_of::<clockinfo>() - 20usize];
    ["Alignment of clockinfo"][::std::mem::align_of::<clockinfo>() - 4usize];
    ["Offset of field: clockinfo::hz"][::std::mem::offset_of!(clockinfo, hz) - 0usize];
    ["Offset of field: clockinfo::tick"][::std::mem::offset_of!(clockinfo, tick) - 4usize];
    ["Offset of field: clockinfo::tickadj"][::std::mem::offset_of!(clockinfo, tickadj) - 8usize];
    ["Offset of field: clockinfo::stathz"][::std::mem::offset_of!(clockinfo, stathz) - 12usize];
    ["Offset of field: clockinfo::profhz"][::std::mem::offset_of!(clockinfo, profhz) - 16usize];
};
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of tm"][::std::mem::size_of::<tm>() - 56usize];
    ["Alignment of tm"][::std::mem::align_of::<tm>() - 8usize];
    ["Offset of field: tm::tm_sec"][::std::mem::offset_of!(tm, tm_sec) - 0usize];
    ["Offset of field: tm::tm_min"][::std::mem::offset_of!(tm, tm_min) - 4usize];
    ["Offset of field: tm::tm_hour"][::std::mem::offset_of!(tm, tm_hour) - 8usize];
    ["Offset of field: tm::tm_mday"][::std::mem::offset_of!(tm, tm_mday) - 12usize];
    ["Offset of field: tm::tm_mon"][::std::mem::offset_of!(tm, tm_mon) - 16usize];
    ["Offset of field: tm::tm_year"][::std::mem::offset_of!(tm, tm_year) - 20usize];
    ["Offset of field: tm::tm_wday"][::std::mem::offset_of!(tm, tm_wday) - 24usize];
    ["Offset of field: tm::tm_yday"][::std::mem::offset_of!(tm, tm_yday) - 28usize];
    ["Offset of field: tm::tm_isdst"][::std::mem::offset_of!(tm, tm_isdst) - 32usize];
    ["Offset of field: tm::tm_gmtoff"][::std::mem::offset_of!(tm, tm_gmtoff) - 40usize];
    ["Offset of field: tm::tm_zone"][::std::mem::offset_of!(tm, tm_zone) - 48usize];
};
unsafe extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 0usize];
}
unsafe extern "C" {
    pub static mut getdate_err: ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
unsafe extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn asctime(arg1: *const tm) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn clock() -> clock_t;
}
unsafe extern "C" {
    pub fn ctime(arg1: *const time_t) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn difftime(arg1: time_t, arg2: time_t) -> f64;
}
unsafe extern "C" {
    pub fn getdate(arg1: *const ::std::os::raw::c_char) -> *mut tm;
}
unsafe extern "C" {
    pub fn gmtime(arg1: *const time_t) -> *mut tm;
}
unsafe extern "C" {
    pub fn localtime(arg1: *const time_t) -> *mut tm;
}
unsafe extern "C" {
    pub fn mktime(arg1: *mut tm) -> time_t;
}
unsafe extern "C" {
    pub fn strftime(
        arg1: *mut ::std::os::raw::c_char,
        arg2: usize,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
    ) -> usize;
}
unsafe extern "C" {
    pub fn strptime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut tm,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn time(arg1: *mut time_t) -> time_t;
}
unsafe extern "C" {
    pub fn tzset();
}
unsafe extern "C" {
    pub fn asctime_r(
        arg1: *const tm,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn ctime_r(
        arg1: *const time_t,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn gmtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
unsafe extern "C" {
    pub fn localtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
unsafe extern "C" {
    pub fn posix2time(arg1: time_t) -> time_t;
}
unsafe extern "C" {
    pub fn tzsetwall();
}
unsafe extern "C" {
    pub fn time2posix(arg1: time_t) -> time_t;
}
unsafe extern "C" {
    pub fn timelocal(arg1: *mut tm) -> time_t;
}
unsafe extern "C" {
    pub fn timegm(arg1: *mut tm) -> time_t;
}
unsafe extern "C" {
    pub fn nanosleep(__rqtp: *const timespec, __rmtp: *mut timespec) -> ::std::os::raw::c_int;
}
pub const clockid_t__CLOCK_REALTIME: clockid_t = 0;
pub const clockid_t__CLOCK_MONOTONIC: clockid_t = 6;
pub const clockid_t__CLOCK_MONOTONIC_RAW: clockid_t = 4;
pub const clockid_t__CLOCK_MONOTONIC_RAW_APPROX: clockid_t = 5;
pub const clockid_t__CLOCK_UPTIME_RAW: clockid_t = 8;
pub const clockid_t__CLOCK_UPTIME_RAW_APPROX: clockid_t = 9;
pub const clockid_t__CLOCK_PROCESS_CPUTIME_ID: clockid_t = 12;
pub const clockid_t__CLOCK_THREAD_CPUTIME_ID: clockid_t = 16;
pub type clockid_t = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn clock_getres(__clock_id: clockid_t, __res: *mut timespec) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn clock_gettime(__clock_id: clockid_t, __tp: *mut timespec) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn clock_gettime_nsec_np(__clock_id: clockid_t) -> __uint64_t;
}
unsafe extern "C" {
    pub fn clock_settime(__clock_id: clockid_t, __tp: *const timespec) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn timespec_get(ts: *mut timespec, base: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn adjtime(arg1: *const timeval, arg2: *mut timeval) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn futimes(arg1: ::std::os::raw::c_int, arg2: *const timeval) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn lutimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn settimeofday(arg1: *const timeval, arg2: *const timezone) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getitimer(arg1: ::std::os::raw::c_int, arg2: *mut itimerval) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn gettimeofday(
        arg1: *mut timeval,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_select$1050"]
    pub fn select(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn setitimer(
        arg1: ::std::os::raw::c_int,
        arg2: *const itimerval,
        arg3: *mut itimerval,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn utimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
pub type au_id_t = uid_t;
pub type au_asid_t = pid_t;
pub type au_event_t = u_int16_t;
pub type au_emod_t = u_int16_t;
pub type au_class_t = u_int32_t;
pub type au_asflgs_t = u_int64_t;
pub type au_ctlmode_t = ::std::os::raw::c_uchar;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_tid {
    pub port: dev_t,
    pub machine: u_int32_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of au_tid"][::std::mem::size_of::<au_tid>() - 8usize];
    ["Alignment of au_tid"][::std::mem::align_of::<au_tid>() - 4usize];
    ["Offset of field: au_tid::port"][::std::mem::offset_of!(au_tid, port) - 0usize];
    ["Offset of field: au_tid::machine"][::std::mem::offset_of!(au_tid, machine) - 4usize];
};
pub type au_tid_t = au_tid;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_tid_addr {
    pub at_port: dev_t,
    pub at_type: u_int32_t,
    pub at_addr: [u_int32_t; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of au_tid_addr"][::std::mem::size_of::<au_tid_addr>() - 24usize];
    ["Alignment of au_tid_addr"][::std::mem::align_of::<au_tid_addr>() - 4usize];
    ["Offset of field: au_tid_addr::at_port"]
        [::std::mem::offset_of!(au_tid_addr, at_port) - 0usize];
    ["Offset of field: au_tid_addr::at_type"]
        [::std::mem::offset_of!(au_tid_addr, at_type) - 4usize];
    ["Offset of field: au_tid_addr::at_addr"]
        [::std::mem::offset_of!(au_tid_addr, at_addr) - 8usize];
};
pub type au_tid_addr_t = au_tid_addr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_mask {
    pub am_success: ::std::os::raw::c_uint,
    pub am_failure: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of au_mask"][::std::mem::size_of::<au_mask>() - 8usize];
    ["Alignment of au_mask"][::std::mem::align_of::<au_mask>() - 4usize];
    ["Offset of field: au_mask::am_success"][::std::mem::offset_of!(au_mask, am_success) - 0usize];
    ["Offset of field: au_mask::am_failure"][::std::mem::offset_of!(au_mask, am_failure) - 4usize];
};
pub type au_mask_t = au_mask;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct auditinfo {
    pub ai_auid: au_id_t,
    pub ai_mask: au_mask_t,
    pub ai_termid: au_tid_t,
    pub ai_asid: au_asid_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of auditinfo"][::std::mem::size_of::<auditinfo>() - 24usize];
    ["Alignment of auditinfo"][::std::mem::align_of::<auditinfo>() - 4usize];
    ["Offset of field: auditinfo::ai_auid"][::std::mem::offset_of!(auditinfo, ai_auid) - 0usize];
    ["Offset of field: auditinfo::ai_mask"][::std::mem::offset_of!(auditinfo, ai_mask) - 4usize];
    ["Offset of field: auditinfo::ai_termid"]
        [::std::mem::offset_of!(auditinfo, ai_termid) - 12usize];
    ["Offset of field: auditinfo::ai_asid"][::std::mem::offset_of!(auditinfo, ai_asid) - 20usize];
};
pub type auditinfo_t = auditinfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct auditinfo_addr {
    pub ai_auid: au_id_t,
    pub ai_mask: au_mask_t,
    pub ai_termid: au_tid_addr_t,
    pub ai_asid: au_asid_t,
    pub ai_flags: au_asflgs_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of auditinfo_addr"][::std::mem::size_of::<auditinfo_addr>() - 48usize];
    ["Alignment of auditinfo_addr"][::std::mem::align_of::<auditinfo_addr>() - 8usize];
    ["Offset of field: auditinfo_addr::ai_auid"]
        [::std::mem::offset_of!(auditinfo_addr, ai_auid) - 0usize];
    ["Offset of field: auditinfo_addr::ai_mask"]
        [::std::mem::offset_of!(auditinfo_addr, ai_mask) - 4usize];
    ["Offset of field: auditinfo_addr::ai_termid"]
        [::std::mem::offset_of!(auditinfo_addr, ai_termid) - 12usize];
    ["Offset of field: auditinfo_addr::ai_asid"]
        [::std::mem::offset_of!(auditinfo_addr, ai_asid) - 36usize];
    ["Offset of field: auditinfo_addr::ai_flags"]
        [::std::mem::offset_of!(auditinfo_addr, ai_flags) - 40usize];
};
pub type auditinfo_addr_t = auditinfo_addr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct auditpinfo {
    pub ap_pid: pid_t,
    pub ap_auid: au_id_t,
    pub ap_mask: au_mask_t,
    pub ap_termid: au_tid_t,
    pub ap_asid: au_asid_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of auditpinfo"][::std::mem::size_of::<auditpinfo>() - 28usize];
    ["Alignment of auditpinfo"][::std::mem::align_of::<auditpinfo>() - 4usize];
    ["Offset of field: auditpinfo::ap_pid"][::std::mem::offset_of!(auditpinfo, ap_pid) - 0usize];
    ["Offset of field: auditpinfo::ap_auid"][::std::mem::offset_of!(auditpinfo, ap_auid) - 4usize];
    ["Offset of field: auditpinfo::ap_mask"][::std::mem::offset_of!(auditpinfo, ap_mask) - 8usize];
    ["Offset of field: auditpinfo::ap_termid"]
        [::std::mem::offset_of!(auditpinfo, ap_termid) - 16usize];
    ["Offset of field: auditpinfo::ap_asid"][::std::mem::offset_of!(auditpinfo, ap_asid) - 24usize];
};
pub type auditpinfo_t = auditpinfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct auditpinfo_addr {
    pub ap_pid: pid_t,
    pub ap_auid: au_id_t,
    pub ap_mask: au_mask_t,
    pub ap_termid: au_tid_addr_t,
    pub ap_asid: au_asid_t,
    pub ap_flags: au_asflgs_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of auditpinfo_addr"][::std::mem::size_of::<auditpinfo_addr>() - 56usize];
    ["Alignment of auditpinfo_addr"][::std::mem::align_of::<auditpinfo_addr>() - 8usize];
    ["Offset of field: auditpinfo_addr::ap_pid"]
        [::std::mem::offset_of!(auditpinfo_addr, ap_pid) - 0usize];
    ["Offset of field: auditpinfo_addr::ap_auid"]
        [::std::mem::offset_of!(auditpinfo_addr, ap_auid) - 4usize];
    ["Offset of field: auditpinfo_addr::ap_mask"]
        [::std::mem::offset_of!(auditpinfo_addr, ap_mask) - 8usize];
    ["Offset of field: auditpinfo_addr::ap_termid"]
        [::std::mem::offset_of!(auditpinfo_addr, ap_termid) - 16usize];
    ["Offset of field: auditpinfo_addr::ap_asid"]
        [::std::mem::offset_of!(auditpinfo_addr, ap_asid) - 40usize];
    ["Offset of field: auditpinfo_addr::ap_flags"]
        [::std::mem::offset_of!(auditpinfo_addr, ap_flags) - 48usize];
};
pub type auditpinfo_addr_t = auditpinfo_addr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_session {
    pub as_aia_p: *mut auditinfo_addr_t,
    pub as_mask: au_mask_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of au_session"][::std::mem::size_of::<au_session>() - 16usize];
    ["Alignment of au_session"][::std::mem::align_of::<au_session>() - 8usize];
    ["Offset of field: au_session::as_aia_p"]
        [::std::mem::offset_of!(au_session, as_aia_p) - 0usize];
    ["Offset of field: au_session::as_mask"][::std::mem::offset_of!(au_session, as_mask) - 8usize];
};
pub type au_session_t = au_session;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_expire_after {
    pub age: time_t,
    pub size: usize,
    pub op_type: ::std::os::raw::c_uchar,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of au_expire_after"][::std::mem::size_of::<au_expire_after>() - 24usize];
    ["Alignment of au_expire_after"][::std::mem::align_of::<au_expire_after>() - 8usize];
    ["Offset of field: au_expire_after::age"]
        [::std::mem::offset_of!(au_expire_after, age) - 0usize];
    ["Offset of field: au_expire_after::size"]
        [::std::mem::offset_of!(au_expire_after, size) - 8usize];
    ["Offset of field: au_expire_after::op_type"]
        [::std::mem::offset_of!(au_expire_after, op_type) - 16usize];
};
pub type au_expire_after_t = au_expire_after;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_token {
    _unused: [u8; 0],
}
pub type token_t = au_token;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_qctrl {
    pub aq_hiwater: ::std::os::raw::c_int,
    pub aq_lowater: ::std::os::raw::c_int,
    pub aq_bufsz: ::std::os::raw::c_int,
    pub aq_delay: ::std::os::raw::c_int,
    pub aq_minfree: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of au_qctrl"][::std::mem::size_of::<au_qctrl>() - 20usize];
    ["Alignment of au_qctrl"][::std::mem::align_of::<au_qctrl>() - 4usize];
    ["Offset of field: au_qctrl::aq_hiwater"]
        [::std::mem::offset_of!(au_qctrl, aq_hiwater) - 0usize];
    ["Offset of field: au_qctrl::aq_lowater"]
        [::std::mem::offset_of!(au_qctrl, aq_lowater) - 4usize];
    ["Offset of field: au_qctrl::aq_bufsz"][::std::mem::offset_of!(au_qctrl, aq_bufsz) - 8usize];
    ["Offset of field: au_qctrl::aq_delay"][::std::mem::offset_of!(au_qctrl, aq_delay) - 12usize];
    ["Offset of field: au_qctrl::aq_minfree"]
        [::std::mem::offset_of!(au_qctrl, aq_minfree) - 16usize];
};
pub type au_qctrl_t = au_qctrl;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct audit_stat {
    pub as_version: ::std::os::raw::c_uint,
    pub as_numevent: ::std::os::raw::c_uint,
    pub as_generated: ::std::os::raw::c_int,
    pub as_nonattrib: ::std::os::raw::c_int,
    pub as_kernel: ::std::os::raw::c_int,
    pub as_audit: ::std::os::raw::c_int,
    pub as_auditctl: ::std::os::raw::c_int,
    pub as_enqueue: ::std::os::raw::c_int,
    pub as_written: ::std::os::raw::c_int,
    pub as_wblocked: ::std::os::raw::c_int,
    pub as_rblocked: ::std::os::raw::c_int,
    pub as_dropped: ::std::os::raw::c_int,
    pub as_totalsize: ::std::os::raw::c_int,
    pub as_memused: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of audit_stat"][::std::mem::size_of::<audit_stat>() - 56usize];
    ["Alignment of audit_stat"][::std::mem::align_of::<audit_stat>() - 4usize];
    ["Offset of field: audit_stat::as_version"]
        [::std::mem::offset_of!(audit_stat, as_version) - 0usize];
    ["Offset of field: audit_stat::as_numevent"]
        [::std::mem::offset_of!(audit_stat, as_numevent) - 4usize];
    ["Offset of field: audit_stat::as_generated"]
        [::std::mem::offset_of!(audit_stat, as_generated) - 8usize];
    ["Offset of field: audit_stat::as_nonattrib"]
        [::std::mem::offset_of!(audit_stat, as_nonattrib) - 12usize];
    ["Offset of field: audit_stat::as_kernel"]
        [::std::mem::offset_of!(audit_stat, as_kernel) - 16usize];
    ["Offset of field: audit_stat::as_audit"]
        [::std::mem::offset_of!(audit_stat, as_audit) - 20usize];
    ["Offset of field: audit_stat::as_auditctl"]
        [::std::mem::offset_of!(audit_stat, as_auditctl) - 24usize];
    ["Offset of field: audit_stat::as_enqueue"]
        [::std::mem::offset_of!(audit_stat, as_enqueue) - 28usize];
    ["Offset of field: audit_stat::as_written"]
        [::std::mem::offset_of!(audit_stat, as_written) - 32usize];
    ["Offset of field: audit_stat::as_wblocked"]
        [::std::mem::offset_of!(audit_stat, as_wblocked) - 36usize];
    ["Offset of field: audit_stat::as_rblocked"]
        [::std::mem::offset_of!(audit_stat, as_rblocked) - 40usize];
    ["Offset of field: audit_stat::as_dropped"]
        [::std::mem::offset_of!(audit_stat, as_dropped) - 44usize];
    ["Offset of field: audit_stat::as_totalsize"]
        [::std::mem::offset_of!(audit_stat, as_totalsize) - 48usize];
    ["Offset of field: audit_stat::as_memused"]
        [::std::mem::offset_of!(audit_stat, as_memused) - 52usize];
};
pub type au_stat_t = audit_stat;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct audit_fstat {
    pub af_filesz: u_int64_t,
    pub af_currsz: u_int64_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of audit_fstat"][::std::mem::size_of::<audit_fstat>() - 16usize];
    ["Alignment of audit_fstat"][::std::mem::align_of::<audit_fstat>() - 8usize];
    ["Offset of field: audit_fstat::af_filesz"]
        [::std::mem::offset_of!(audit_fstat, af_filesz) - 0usize];
    ["Offset of field: audit_fstat::af_currsz"]
        [::std::mem::offset_of!(audit_fstat, af_currsz) - 8usize];
};
pub type au_fstat_t = audit_fstat;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct au_evclass_map {
    pub ec_number: au_event_t,
    pub ec_class: au_class_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of au_evclass_map"][::std::mem::size_of::<au_evclass_map>() - 8usize];
    ["Alignment of au_evclass_map"][::std::mem::align_of::<au_evclass_map>() - 4usize];
    ["Offset of field: au_evclass_map::ec_number"]
        [::std::mem::offset_of!(au_evclass_map, ec_number) - 0usize];
    ["Offset of field: au_evclass_map::ec_class"]
        [::std::mem::offset_of!(au_evclass_map, ec_class) - 4usize];
};
pub type au_evclass_map_t = au_evclass_map;
unsafe extern "C" {
    pub fn audit(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn auditon(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn auditctl(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getauid(arg1: *mut au_id_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn setauid(arg1: *const au_id_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getaudit_addr(
        arg1: *mut auditinfo_addr,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn setaudit_addr(
        arg1: *const auditinfo_addr,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getaudit(arg1: *mut auditinfo) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn setaudit(arg1: *const auditinfo) -> ::std::os::raw::c_int;
}
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type boolean_t = ::std::os::raw::c_uint;
pub type natural_t = __darwin_natural_t;
pub type integer_t = ::std::os::raw::c_int;
pub type vm_offset_t = usize;
pub type vm_size_t = usize;
pub type mach_vm_address_t = u64;
pub type mach_vm_offset_t = u64;
pub type mach_vm_size_t = u64;
pub type vm_map_offset_t = u64;
pub type vm_map_address_t = u64;
pub type vm_map_size_t = u64;
pub type mach_port_context_t = mach_vm_address_t;
pub type mach_port_name_t = natural_t;
pub type mach_port_name_array_t = *mut mach_port_name_t;
pub type mach_port_t = __darwin_mach_port_t;
pub type mach_port_array_t = *mut mach_port_t;
pub type mach_port_right_t = natural_t;
pub type mach_port_type_t = natural_t;
pub type mach_port_type_array_t = *mut mach_port_type_t;
pub type mach_port_urefs_t = natural_t;
pub type mach_port_delta_t = integer_t;
pub type mach_port_seqno_t = natural_t;
pub type mach_port_mscount_t = natural_t;
pub type mach_port_msgcount_t = natural_t;
pub type mach_port_rights_t = natural_t;
pub type mach_port_srights_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_status {
    pub mps_pset: mach_port_rights_t,
    pub mps_seqno: mach_port_seqno_t,
    pub mps_mscount: mach_port_mscount_t,
    pub mps_qlimit: mach_port_msgcount_t,
    pub mps_msgcount: mach_port_msgcount_t,
    pub mps_sorights: mach_port_rights_t,
    pub mps_srights: boolean_t,
    pub mps_pdrequest: boolean_t,
    pub mps_nsrequest: boolean_t,
    pub mps_flags: natural_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mach_port_status"][::std::mem::size_of::<mach_port_status>() - 40usize];
    ["Alignment of mach_port_status"][::std::mem::align_of::<mach_port_status>() - 4usize];
    ["Offset of field: mach_port_status::mps_pset"]
        [::std::mem::offset_of!(mach_port_status, mps_pset) - 0usize];
    ["Offset of field: mach_port_status::mps_seqno"]
        [::std::mem::offset_of!(mach_port_status, mps_seqno) - 4usize];
    ["Offset of field: mach_port_status::mps_mscount"]
        [::std::mem::offset_of!(mach_port_status, mps_mscount) - 8usize];
    ["Offset of field: mach_port_status::mps_qlimit"]
        [::std::mem::offset_of!(mach_port_status, mps_qlimit) - 12usize];
    ["Offset of field: mach_port_status::mps_msgcount"]
        [::std::mem::offset_of!(mach_port_status, mps_msgcount) - 16usize];
    ["Offset of field: mach_port_status::mps_sorights"]
        [::std::mem::offset_of!(mach_port_status, mps_sorights) - 20usize];
    ["Offset of field: mach_port_status::mps_srights"]
        [::std::mem::offset_of!(mach_port_status, mps_srights) - 24usize];
    ["Offset of field: mach_port_status::mps_pdrequest"]
        [::std::mem::offset_of!(mach_port_status, mps_pdrequest) - 28usize];
    ["Offset of field: mach_port_status::mps_nsrequest"]
        [::std::mem::offset_of!(mach_port_status, mps_nsrequest) - 32usize];
    ["Offset of field: mach_port_status::mps_flags"]
        [::std::mem::offset_of!(mach_port_status, mps_flags) - 36usize];
};
pub type mach_port_status_t = mach_port_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_limits {
    pub mpl_qlimit: mach_port_msgcount_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mach_port_limits"][::std::mem::size_of::<mach_port_limits>() - 4usize];
    ["Alignment of mach_port_limits"][::std::mem::align_of::<mach_port_limits>() - 4usize];
    ["Offset of field: mach_port_limits::mpl_qlimit"]
        [::std::mem::offset_of!(mach_port_limits, mpl_qlimit) - 0usize];
};
pub type mach_port_limits_t = mach_port_limits;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_info_ext {
    pub mpie_status: mach_port_status_t,
    pub mpie_boost_cnt: mach_port_msgcount_t,
    pub reserved: [u32; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mach_port_info_ext"][::std::mem::size_of::<mach_port_info_ext>() - 68usize];
    ["Alignment of mach_port_info_ext"][::std::mem::align_of::<mach_port_info_ext>() - 4usize];
    ["Offset of field: mach_port_info_ext::mpie_status"]
        [::std::mem::offset_of!(mach_port_info_ext, mpie_status) - 0usize];
    ["Offset of field: mach_port_info_ext::mpie_boost_cnt"]
        [::std::mem::offset_of!(mach_port_info_ext, mpie_boost_cnt) - 40usize];
    ["Offset of field: mach_port_info_ext::reserved"]
        [::std::mem::offset_of!(mach_port_info_ext, reserved) - 44usize];
};
pub type mach_port_info_ext_t = mach_port_info_ext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_guard_info {
    pub mpgi_guard: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mach_port_guard_info"][::std::mem::size_of::<mach_port_guard_info>() - 8usize];
    ["Alignment of mach_port_guard_info"][::std::mem::align_of::<mach_port_guard_info>() - 8usize];
    ["Offset of field: mach_port_guard_info::mpgi_guard"]
        [::std::mem::offset_of!(mach_port_guard_info, mpgi_guard) - 0usize];
};
pub type mach_port_guard_info_t = mach_port_guard_info;
pub type mach_port_info_t = *mut integer_t;
pub type mach_port_flavor_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_qos {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub len: natural_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mach_port_qos"][::std::mem::size_of::<mach_port_qos>() - 8usize];
    ["Alignment of mach_port_qos"][::std::mem::align_of::<mach_port_qos>() - 4usize];
    ["Offset of field: mach_port_qos::len"][::std::mem::offset_of!(mach_port_qos, len) - 4usize];
};
impl mach_port_qos {
    #[inline]
    pub fn name(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_name(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn name_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_name_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn prealloc(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_prealloc(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn prealloc_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_prealloc_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pad1(&self) -> boolean_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pad1_raw(this: *const Self) -> boolean_t {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                30u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pad1_raw(this: *mut Self, val: boolean_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                30u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        name: ::std::os::raw::c_uint,
        prealloc: ::std::os::raw::c_uint,
        pad1: boolean_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let name: u32 = unsafe { ::std::mem::transmute(name) };
            name as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let prealloc: u32 = unsafe { ::std::mem::transmute(prealloc) };
            prealloc as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let pad1: u32 = unsafe { ::std::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type mach_port_qos_t = mach_port_qos;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_service_port_info {
    pub mspi_string_name: [::std::os::raw::c_char; 255usize],
    pub mspi_domain_type: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mach_service_port_info"][::std::mem::size_of::<mach_service_port_info>() - 256usize];
    ["Alignment of mach_service_port_info"]
        [::std::mem::align_of::<mach_service_port_info>() - 1usize];
    ["Offset of field: mach_service_port_info::mspi_string_name"]
        [::std::mem::offset_of!(mach_service_port_info, mspi_string_name) - 0usize];
    ["Offset of field: mach_service_port_info::mspi_domain_type"]
        [::std::mem::offset_of!(mach_service_port_info, mspi_domain_type) - 255usize];
};
pub type mach_service_port_info_data_t = mach_service_port_info;
pub type mach_service_port_info_t = *mut mach_service_port_info;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mach_port_options {
    pub flags: u32,
    pub mpl: mach_port_limits_t,
    pub __bindgen_anon_1: mach_port_options__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mach_port_options__bindgen_ty_1 {
    pub reserved: [u64; 2usize],
    pub work_interval_port: mach_port_name_t,
    pub service_port_info: mach_service_port_info_t,
    pub service_port_name: mach_port_name_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mach_port_options__bindgen_ty_1"]
        [::std::mem::size_of::<mach_port_options__bindgen_ty_1>() - 16usize];
    ["Alignment of mach_port_options__bindgen_ty_1"]
        [::std::mem::align_of::<mach_port_options__bindgen_ty_1>() - 8usize];
    ["Offset of field: mach_port_options__bindgen_ty_1::reserved"]
        [::std::mem::offset_of!(mach_port_options__bindgen_ty_1, reserved) - 0usize];
    ["Offset of field: mach_port_options__bindgen_ty_1::work_interval_port"]
        [::std::mem::offset_of!(mach_port_options__bindgen_ty_1, work_interval_port) - 0usize];
    ["Offset of field: mach_port_options__bindgen_ty_1::service_port_info"]
        [::std::mem::offset_of!(mach_port_options__bindgen_ty_1, service_port_info) - 0usize];
    ["Offset of field: mach_port_options__bindgen_ty_1::service_port_name"]
        [::std::mem::offset_of!(mach_port_options__bindgen_ty_1, service_port_name) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mach_port_options"][::std::mem::size_of::<mach_port_options>() - 24usize];
    ["Alignment of mach_port_options"][::std::mem::align_of::<mach_port_options>() - 8usize];
    ["Offset of field: mach_port_options::flags"]
        [::std::mem::offset_of!(mach_port_options, flags) - 0usize];
    ["Offset of field: mach_port_options::mpl"]
        [::std::mem::offset_of!(mach_port_options, mpl) - 4usize];
};
pub type mach_port_options_t = mach_port_options;
pub type mach_port_options_ptr_t = *mut mach_port_options_t;
pub const mach_port_guard_exception_codes_kGUARD_EXC_DESTROY: mach_port_guard_exception_codes = 1;
pub const mach_port_guard_exception_codes_kGUARD_EXC_MOD_REFS: mach_port_guard_exception_codes = 2;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_OPTIONS:
    mach_port_guard_exception_codes = 3;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SET_CONTEXT: mach_port_guard_exception_codes =
    4;
pub const mach_port_guard_exception_codes_kGUARD_EXC_UNGUARDED: mach_port_guard_exception_codes = 8;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INCORRECT_GUARD:
    mach_port_guard_exception_codes = 16;
pub const mach_port_guard_exception_codes_kGUARD_EXC_IMMOVABLE: mach_port_guard_exception_codes =
    32;
pub const mach_port_guard_exception_codes_kGUARD_EXC_STRICT_REPLY: mach_port_guard_exception_codes =
    64;
pub const mach_port_guard_exception_codes_kGUARD_EXC_MSG_FILTERED: mach_port_guard_exception_codes =
    128;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_RIGHT:
    mach_port_guard_exception_codes = 256;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_NAME: mach_port_guard_exception_codes =
    512;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_VALUE:
    mach_port_guard_exception_codes = 1024;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_ARGUMENT:
    mach_port_guard_exception_codes = 2048;
pub const mach_port_guard_exception_codes_kGUARD_EXC_RIGHT_EXISTS: mach_port_guard_exception_codes =
    4096;
pub const mach_port_guard_exception_codes_kGUARD_EXC_KERN_NO_SPACE:
    mach_port_guard_exception_codes = 8192;
pub const mach_port_guard_exception_codes_kGUARD_EXC_KERN_FAILURE: mach_port_guard_exception_codes =
    16384;
pub const mach_port_guard_exception_codes_kGUARD_EXC_KERN_RESOURCE:
    mach_port_guard_exception_codes = 32768;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SEND_INVALID_REPLY:
    mach_port_guard_exception_codes = 65536;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SEND_INVALID_VOUCHER:
    mach_port_guard_exception_codes = 131072;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SEND_INVALID_RIGHT:
    mach_port_guard_exception_codes = 262144;
pub const mach_port_guard_exception_codes_kGUARD_EXC_RCV_INVALID_NAME:
    mach_port_guard_exception_codes = 524288;
pub const mach_port_guard_exception_codes_kGUARD_EXC_RCV_GUARDED_DESC:
    mach_port_guard_exception_codes = 1048576;
pub const mach_port_guard_exception_codes_kGUARD_EXC_MOD_REFS_NON_FATAL:
    mach_port_guard_exception_codes = 2097152;
pub const mach_port_guard_exception_codes_kGUARD_EXC_IMMOVABLE_NON_FATAL:
    mach_port_guard_exception_codes = 4194304;
pub const mach_port_guard_exception_codes_kGUARD_EXC_REQUIRE_REPLY_PORT_SEMANTICS:
    mach_port_guard_exception_codes = 8388608;
pub type mach_port_guard_exception_codes = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn audit_session_self() -> mach_port_name_t;
}
unsafe extern "C" {
    pub fn audit_session_join(port: mach_port_name_t) -> au_asid_t;
}
unsafe extern "C" {
    pub fn audit_session_port(
        asid: au_asid_t,
        portname: *mut mach_port_name_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct label {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ucred {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct posix_cred {
    _unused: [u8; 0],
}
pub type kauth_cred_t = *mut ucred;
pub type posix_cred_t = *mut posix_cred;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xucred {
    pub cr_version: u_int,
    pub cr_uid: uid_t,
    pub cr_ngroups: ::std::os::raw::c_short,
    pub cr_groups: [gid_t; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of xucred"][::std::mem::size_of::<xucred>() - 76usize];
    ["Alignment of xucred"][::std::mem::align_of::<xucred>() - 4usize];
    ["Offset of field: xucred::cr_version"][::std::mem::offset_of!(xucred, cr_version) - 0usize];
    ["Offset of field: xucred::cr_uid"][::std::mem::offset_of!(xucred, cr_uid) - 4usize];
    ["Offset of field: xucred::cr_ngroups"][::std::mem::offset_of!(xucred, cr_ngroups) - 8usize];
    ["Offset of field: xucred::cr_groups"][::std::mem::offset_of!(xucred, cr_groups) - 12usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_pselect$1050"]
    pub fn pselect(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *const timespec,
        arg6: *const sigset_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct kevent {
    pub ident: usize,
    pub filter: i16,
    pub flags: u16,
    pub fflags: u32,
    pub data: isize,
    pub udata: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kevent"][::std::mem::size_of::<kevent>() - 32usize];
    ["Alignment of kevent"][::std::mem::align_of::<kevent>() - 4usize];
    ["Offset of field: kevent::ident"][::std::mem::offset_of!(kevent, ident) - 0usize];
    ["Offset of field: kevent::filter"][::std::mem::offset_of!(kevent, filter) - 8usize];
    ["Offset of field: kevent::flags"][::std::mem::offset_of!(kevent, flags) - 10usize];
    ["Offset of field: kevent::fflags"][::std::mem::offset_of!(kevent, fflags) - 12usize];
    ["Offset of field: kevent::data"][::std::mem::offset_of!(kevent, data) - 16usize];
    ["Offset of field: kevent::udata"][::std::mem::offset_of!(kevent, udata) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kevent64_s {
    pub ident: u64,
    pub filter: i16,
    pub flags: u16,
    pub fflags: u32,
    pub data: i64,
    pub udata: u64,
    pub ext: [u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kevent64_s"][::std::mem::size_of::<kevent64_s>() - 48usize];
    ["Alignment of kevent64_s"][::std::mem::align_of::<kevent64_s>() - 8usize];
    ["Offset of field: kevent64_s::ident"][::std::mem::offset_of!(kevent64_s, ident) - 0usize];
    ["Offset of field: kevent64_s::filter"][::std::mem::offset_of!(kevent64_s, filter) - 8usize];
    ["Offset of field: kevent64_s::flags"][::std::mem::offset_of!(kevent64_s, flags) - 10usize];
    ["Offset of field: kevent64_s::fflags"][::std::mem::offset_of!(kevent64_s, fflags) - 12usize];
    ["Offset of field: kevent64_s::data"][::std::mem::offset_of!(kevent64_s, data) - 16usize];
    ["Offset of field: kevent64_s::udata"][::std::mem::offset_of!(kevent64_s, udata) - 24usize];
    ["Offset of field: kevent64_s::ext"][::std::mem::offset_of!(kevent64_s, ext) - 32usize];
};
pub const eNoteReapDeprecated: _bindgen_ty_1 = 268435456;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub const eNoteExitReparentedDeprecated: _bindgen_ty_2 = 524288;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct knote {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct klist {
    pub slh_first: *mut knote,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of klist"][::std::mem::size_of::<klist>() - 8usize];
    ["Alignment of klist"][::std::mem::align_of::<klist>() - 8usize];
    ["Offset of field: klist::slh_first"][::std::mem::offset_of!(klist, slh_first) - 0usize];
};
unsafe extern "C" {
    pub fn kqueue() -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn kevent(
        kq: ::std::os::raw::c_int,
        changelist: *const kevent,
        nchanges: ::std::os::raw::c_int,
        eventlist: *mut kevent,
        nevents: ::std::os::raw::c_int,
        timeout: *const timespec,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn kevent64(
        kq: ::std::os::raw::c_int,
        changelist: *const kevent64_s,
        nchanges: ::std::os::raw::c_int,
        eventlist: *mut kevent64_s,
        nevents: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_uint,
        timeout: *const timespec,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct session {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pgrp {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_ {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_ident {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct extern_proc {
    pub p_un: extern_proc__bindgen_ty_1,
    pub p_vmspace: *mut vmspace,
    pub p_sigacts: *mut sigacts,
    pub p_flag: ::std::os::raw::c_int,
    pub p_stat: ::std::os::raw::c_char,
    pub p_pid: pid_t,
    pub p_oppid: pid_t,
    pub p_dupfd: ::std::os::raw::c_int,
    pub user_stack: caddr_t,
    pub exit_thread: *mut ::std::os::raw::c_void,
    pub p_debugger: ::std::os::raw::c_int,
    pub sigwait: boolean_t,
    pub p_estcpu: u_int,
    pub p_cpticks: ::std::os::raw::c_int,
    pub p_pctcpu: fixpt_t,
    pub p_wchan: *mut ::std::os::raw::c_void,
    pub p_wmesg: *mut ::std::os::raw::c_char,
    pub p_swtime: u_int,
    pub p_slptime: u_int,
    pub p_realtimer: itimerval,
    pub p_rtime: timeval,
    pub p_uticks: u_quad_t,
    pub p_sticks: u_quad_t,
    pub p_iticks: u_quad_t,
    pub p_traceflag: ::std::os::raw::c_int,
    pub p_tracep: *mut vnode,
    pub p_siglist: ::std::os::raw::c_int,
    pub p_textvp: *mut vnode,
    pub p_holdcnt: ::std::os::raw::c_int,
    pub p_sigmask: sigset_t,
    pub p_sigignore: sigset_t,
    pub p_sigcatch: sigset_t,
    pub p_priority: u_char,
    pub p_usrpri: u_char,
    pub p_nice: ::std::os::raw::c_char,
    pub p_comm: [::std::os::raw::c_char; 17usize],
    pub p_pgrp: *mut pgrp,
    pub p_addr: *mut user,
    pub p_xstat: u_short,
    pub p_acflag: u_short,
    pub p_ru: *mut rusage,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union extern_proc__bindgen_ty_1 {
    pub p_st1: extern_proc__bindgen_ty_1__bindgen_ty_1,
    pub __p_starttime: timeval,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct extern_proc__bindgen_ty_1__bindgen_ty_1 {
    pub __p_forw: *mut proc_,
    pub __p_back: *mut proc_,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of extern_proc__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<extern_proc__bindgen_ty_1__bindgen_ty_1>() - 16usize];
    ["Alignment of extern_proc__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<extern_proc__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: extern_proc__bindgen_ty_1__bindgen_ty_1::__p_forw"]
        [::std::mem::offset_of!(extern_proc__bindgen_ty_1__bindgen_ty_1, __p_forw) - 0usize];
    ["Offset of field: extern_proc__bindgen_ty_1__bindgen_ty_1::__p_back"]
        [::std::mem::offset_of!(extern_proc__bindgen_ty_1__bindgen_ty_1, __p_back) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of extern_proc__bindgen_ty_1"]
        [::std::mem::size_of::<extern_proc__bindgen_ty_1>() - 16usize];
    ["Alignment of extern_proc__bindgen_ty_1"]
        [::std::mem::align_of::<extern_proc__bindgen_ty_1>() - 8usize];
    ["Offset of field: extern_proc__bindgen_ty_1::p_st1"]
        [::std::mem::offset_of!(extern_proc__bindgen_ty_1, p_st1) - 0usize];
    ["Offset of field: extern_proc__bindgen_ty_1::__p_starttime"]
        [::std::mem::offset_of!(extern_proc__bindgen_ty_1, __p_starttime) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of extern_proc"][::std::mem::size_of::<extern_proc>() - 296usize];
    ["Alignment of extern_proc"][::std::mem::align_of::<extern_proc>() - 8usize];
    ["Offset of field: extern_proc::p_un"][::std::mem::offset_of!(extern_proc, p_un) - 0usize];
    ["Offset of field: extern_proc::p_vmspace"]
        [::std::mem::offset_of!(extern_proc, p_vmspace) - 16usize];
    ["Offset of field: extern_proc::p_sigacts"]
        [::std::mem::offset_of!(extern_proc, p_sigacts) - 24usize];
    ["Offset of field: extern_proc::p_flag"][::std::mem::offset_of!(extern_proc, p_flag) - 32usize];
    ["Offset of field: extern_proc::p_stat"][::std::mem::offset_of!(extern_proc, p_stat) - 36usize];
    ["Offset of field: extern_proc::p_pid"][::std::mem::offset_of!(extern_proc, p_pid) - 40usize];
    ["Offset of field: extern_proc::p_oppid"]
        [::std::mem::offset_of!(extern_proc, p_oppid) - 44usize];
    ["Offset of field: extern_proc::p_dupfd"]
        [::std::mem::offset_of!(extern_proc, p_dupfd) - 48usize];
    ["Offset of field: extern_proc::user_stack"]
        [::std::mem::offset_of!(extern_proc, user_stack) - 56usize];
    ["Offset of field: extern_proc::exit_thread"]
        [::std::mem::offset_of!(extern_proc, exit_thread) - 64usize];
    ["Offset of field: extern_proc::p_debugger"]
        [::std::mem::offset_of!(extern_proc, p_debugger) - 72usize];
    ["Offset of field: extern_proc::sigwait"]
        [::std::mem::offset_of!(extern_proc, sigwait) - 76usize];
    ["Offset of field: extern_proc::p_estcpu"]
        [::std::mem::offset_of!(extern_proc, p_estcpu) - 80usize];
    ["Offset of field: extern_proc::p_cpticks"]
        [::std::mem::offset_of!(extern_proc, p_cpticks) - 84usize];
    ["Offset of field: extern_proc::p_pctcpu"]
        [::std::mem::offset_of!(extern_proc, p_pctcpu) - 88usize];
    ["Offset of field: extern_proc::p_wchan"]
        [::std::mem::offset_of!(extern_proc, p_wchan) - 96usize];
    ["Offset of field: extern_proc::p_wmesg"]
        [::std::mem::offset_of!(extern_proc, p_wmesg) - 104usize];
    ["Offset of field: extern_proc::p_swtime"]
        [::std::mem::offset_of!(extern_proc, p_swtime) - 112usize];
    ["Offset of field: extern_proc::p_slptime"]
        [::std::mem::offset_of!(extern_proc, p_slptime) - 116usize];
    ["Offset of field: extern_proc::p_realtimer"]
        [::std::mem::offset_of!(extern_proc, p_realtimer) - 120usize];
    ["Offset of field: extern_proc::p_rtime"]
        [::std::mem::offset_of!(extern_proc, p_rtime) - 152usize];
    ["Offset of field: extern_proc::p_uticks"]
        [::std::mem::offset_of!(extern_proc, p_uticks) - 168usize];
    ["Offset of field: extern_proc::p_sticks"]
        [::std::mem::offset_of!(extern_proc, p_sticks) - 176usize];
    ["Offset of field: extern_proc::p_iticks"]
        [::std::mem::offset_of!(extern_proc, p_iticks) - 184usize];
    ["Offset of field: extern_proc::p_traceflag"]
        [::std::mem::offset_of!(extern_proc, p_traceflag) - 192usize];
    ["Offset of field: extern_proc::p_tracep"]
        [::std::mem::offset_of!(extern_proc, p_tracep) - 200usize];
    ["Offset of field: extern_proc::p_siglist"]
        [::std::mem::offset_of!(extern_proc, p_siglist) - 208usize];
    ["Offset of field: extern_proc::p_textvp"]
        [::std::mem::offset_of!(extern_proc, p_textvp) - 216usize];
    ["Offset of field: extern_proc::p_holdcnt"]
        [::std::mem::offset_of!(extern_proc, p_holdcnt) - 224usize];
    ["Offset of field: extern_proc::p_sigmask"]
        [::std::mem::offset_of!(extern_proc, p_sigmask) - 228usize];
    ["Offset of field: extern_proc::p_sigignore"]
        [::std::mem::offset_of!(extern_proc, p_sigignore) - 232usize];
    ["Offset of field: extern_proc::p_sigcatch"]
        [::std::mem::offset_of!(extern_proc, p_sigcatch) - 236usize];
    ["Offset of field: extern_proc::p_priority"]
        [::std::mem::offset_of!(extern_proc, p_priority) - 240usize];
    ["Offset of field: extern_proc::p_usrpri"]
        [::std::mem::offset_of!(extern_proc, p_usrpri) - 241usize];
    ["Offset of field: extern_proc::p_nice"]
        [::std::mem::offset_of!(extern_proc, p_nice) - 242usize];
    ["Offset of field: extern_proc::p_comm"]
        [::std::mem::offset_of!(extern_proc, p_comm) - 243usize];
    ["Offset of field: extern_proc::p_pgrp"]
        [::std::mem::offset_of!(extern_proc, p_pgrp) - 264usize];
    ["Offset of field: extern_proc::p_addr"]
        [::std::mem::offset_of!(extern_proc, p_addr) - 272usize];
    ["Offset of field: extern_proc::p_xstat"]
        [::std::mem::offset_of!(extern_proc, p_xstat) - 280usize];
    ["Offset of field: extern_proc::p_acflag"]
        [::std::mem::offset_of!(extern_proc, p_acflag) - 282usize];
    ["Offset of field: extern_proc::p_ru"][::std::mem::offset_of!(extern_proc, p_ru) - 288usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vmspace {
    pub dummy: i32,
    pub dummy2: caddr_t,
    pub dummy3: [i32; 5usize],
    pub dummy4: [caddr_t; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vmspace"][::std::mem::size_of::<vmspace>() - 64usize];
    ["Alignment of vmspace"][::std::mem::align_of::<vmspace>() - 8usize];
    ["Offset of field: vmspace::dummy"][::std::mem::offset_of!(vmspace, dummy) - 0usize];
    ["Offset of field: vmspace::dummy2"][::std::mem::offset_of!(vmspace, dummy2) - 8usize];
    ["Offset of field: vmspace::dummy3"][::std::mem::offset_of!(vmspace, dummy3) - 16usize];
    ["Offset of field: vmspace::dummy4"][::std::mem::offset_of!(vmspace, dummy4) - 40usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ctlname {
    pub ctl_name: *mut ::std::os::raw::c_char,
    pub ctl_type: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ctlname"][::std::mem::size_of::<ctlname>() - 16usize];
    ["Alignment of ctlname"][::std::mem::align_of::<ctlname>() - 8usize];
    ["Offset of field: ctlname::ctl_name"][::std::mem::offset_of!(ctlname, ctl_name) - 0usize];
    ["Offset of field: ctlname::ctl_type"][::std::mem::offset_of!(ctlname, ctl_type) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _pcred {
    pub pc_lock: [::std::os::raw::c_char; 72usize],
    pub pc_ucred: *mut ucred,
    pub p_ruid: uid_t,
    pub p_svuid: uid_t,
    pub p_rgid: gid_t,
    pub p_svgid: gid_t,
    pub p_refcnt: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _pcred"][::std::mem::size_of::<_pcred>() - 104usize];
    ["Alignment of _pcred"][::std::mem::align_of::<_pcred>() - 8usize];
    ["Offset of field: _pcred::pc_lock"][::std::mem::offset_of!(_pcred, pc_lock) - 0usize];
    ["Offset of field: _pcred::pc_ucred"][::std::mem::offset_of!(_pcred, pc_ucred) - 72usize];
    ["Offset of field: _pcred::p_ruid"][::std::mem::offset_of!(_pcred, p_ruid) - 80usize];
    ["Offset of field: _pcred::p_svuid"][::std::mem::offset_of!(_pcred, p_svuid) - 84usize];
    ["Offset of field: _pcred::p_rgid"][::std::mem::offset_of!(_pcred, p_rgid) - 88usize];
    ["Offset of field: _pcred::p_svgid"][::std::mem::offset_of!(_pcred, p_svgid) - 92usize];
    ["Offset of field: _pcred::p_refcnt"][::std::mem::offset_of!(_pcred, p_refcnt) - 96usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ucred {
    pub cr_ref: i32,
    pub cr_uid: uid_t,
    pub cr_ngroups: ::std::os::raw::c_short,
    pub cr_groups: [gid_t; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ucred"][::std::mem::size_of::<_ucred>() - 76usize];
    ["Alignment of _ucred"][::std::mem::align_of::<_ucred>() - 4usize];
    ["Offset of field: _ucred::cr_ref"][::std::mem::offset_of!(_ucred, cr_ref) - 0usize];
    ["Offset of field: _ucred::cr_uid"][::std::mem::offset_of!(_ucred, cr_uid) - 4usize];
    ["Offset of field: _ucred::cr_ngroups"][::std::mem::offset_of!(_ucred, cr_ngroups) - 8usize];
    ["Offset of field: _ucred::cr_groups"][::std::mem::offset_of!(_ucred, cr_groups) - 12usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kinfo_proc {
    pub kp_proc: extern_proc,
    pub kp_eproc: kinfo_proc_eproc,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kinfo_proc_eproc {
    pub e_paddr: *mut proc_,
    pub e_sess: *mut session,
    pub e_pcred: _pcred,
    pub e_ucred: _ucred,
    pub e_vm: vmspace,
    pub e_ppid: pid_t,
    pub e_pgid: pid_t,
    pub e_jobc: ::std::os::raw::c_short,
    pub e_tdev: dev_t,
    pub e_tpgid: pid_t,
    pub e_tsess: *mut session,
    pub e_wmesg: [::std::os::raw::c_char; 8usize],
    pub e_xsize: segsz_t,
    pub e_xrssize: ::std::os::raw::c_short,
    pub e_xccount: ::std::os::raw::c_short,
    pub e_xswrss: ::std::os::raw::c_short,
    pub e_flag: i32,
    pub e_login: [::std::os::raw::c_char; 12usize],
    pub e_spare: [i32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_proc_eproc"][::std::mem::size_of::<kinfo_proc_eproc>() - 352usize];
    ["Alignment of kinfo_proc_eproc"][::std::mem::align_of::<kinfo_proc_eproc>() - 8usize];
    ["Offset of field: kinfo_proc_eproc::e_paddr"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_paddr) - 0usize];
    ["Offset of field: kinfo_proc_eproc::e_sess"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_sess) - 8usize];
    ["Offset of field: kinfo_proc_eproc::e_pcred"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_pcred) - 16usize];
    ["Offset of field: kinfo_proc_eproc::e_ucred"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_ucred) - 120usize];
    ["Offset of field: kinfo_proc_eproc::e_vm"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_vm) - 200usize];
    ["Offset of field: kinfo_proc_eproc::e_ppid"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_ppid) - 264usize];
    ["Offset of field: kinfo_proc_eproc::e_pgid"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_pgid) - 268usize];
    ["Offset of field: kinfo_proc_eproc::e_jobc"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_jobc) - 272usize];
    ["Offset of field: kinfo_proc_eproc::e_tdev"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_tdev) - 276usize];
    ["Offset of field: kinfo_proc_eproc::e_tpgid"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_tpgid) - 280usize];
    ["Offset of field: kinfo_proc_eproc::e_tsess"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_tsess) - 288usize];
    ["Offset of field: kinfo_proc_eproc::e_wmesg"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_wmesg) - 296usize];
    ["Offset of field: kinfo_proc_eproc::e_xsize"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_xsize) - 304usize];
    ["Offset of field: kinfo_proc_eproc::e_xrssize"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_xrssize) - 308usize];
    ["Offset of field: kinfo_proc_eproc::e_xccount"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_xccount) - 310usize];
    ["Offset of field: kinfo_proc_eproc::e_xswrss"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_xswrss) - 312usize];
    ["Offset of field: kinfo_proc_eproc::e_flag"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_flag) - 316usize];
    ["Offset of field: kinfo_proc_eproc::e_login"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_login) - 320usize];
    ["Offset of field: kinfo_proc_eproc::e_spare"]
        [::std::mem::offset_of!(kinfo_proc_eproc, e_spare) - 332usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_proc"][::std::mem::size_of::<kinfo_proc>() - 648usize];
    ["Alignment of kinfo_proc"][::std::mem::align_of::<kinfo_proc>() - 8usize];
    ["Offset of field: kinfo_proc::kp_proc"][::std::mem::offset_of!(kinfo_proc, kp_proc) - 0usize];
    ["Offset of field: kinfo_proc::kp_eproc"]
        [::std::mem::offset_of!(kinfo_proc, kp_eproc) - 296usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xsw_usage {
    pub xsu_total: u_int64_t,
    pub xsu_avail: u_int64_t,
    pub xsu_used: u_int64_t,
    pub xsu_pagesize: u_int32_t,
    pub xsu_encrypted: boolean_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of xsw_usage"][::std::mem::size_of::<xsw_usage>() - 32usize];
    ["Alignment of xsw_usage"][::std::mem::align_of::<xsw_usage>() - 8usize];
    ["Offset of field: xsw_usage::xsu_total"]
        [::std::mem::offset_of!(xsw_usage, xsu_total) - 0usize];
    ["Offset of field: xsw_usage::xsu_avail"]
        [::std::mem::offset_of!(xsw_usage, xsu_avail) - 8usize];
    ["Offset of field: xsw_usage::xsu_used"][::std::mem::offset_of!(xsw_usage, xsu_used) - 16usize];
    ["Offset of field: xsw_usage::xsu_pagesize"]
        [::std::mem::offset_of!(xsw_usage, xsu_pagesize) - 24usize];
    ["Offset of field: xsw_usage::xsu_encrypted"]
        [::std::mem::offset_of!(xsw_usage, xsu_encrypted) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct loadavg {
    pub ldavg: [fixpt_t; 3usize],
    pub fscale: ::std::os::raw::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of loadavg"][::std::mem::size_of::<loadavg>() - 24usize];
    ["Alignment of loadavg"][::std::mem::align_of::<loadavg>() - 8usize];
    ["Offset of field: loadavg::ldavg"][::std::mem::offset_of!(loadavg, ldavg) - 0usize];
    ["Offset of field: loadavg::fscale"][::std::mem::offset_of!(loadavg, fscale) - 16usize];
};
unsafe extern "C" {
    pub static mut averunnable: loadavg;
}
unsafe extern "C" {
    pub fn sysctl(
        arg1: *mut ::std::os::raw::c_int,
        arg2: u_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut usize,
        arg5: *mut ::std::os::raw::c_void,
        arg6: usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sysctlbyname(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut usize,
        arg4: *mut ::std::os::raw::c_void,
        arg5: usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sysctlnametomib(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_int,
        arg3: *mut usize,
    ) -> ::std::os::raw::c_int;
}
pub type sa_family_t = __uint8_t;
pub type socklen_t = __darwin_socklen_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of iovec"][::std::mem::size_of::<iovec>() - 16usize];
    ["Alignment of iovec"][::std::mem::align_of::<iovec>() - 8usize];
    ["Offset of field: iovec::iov_base"][::std::mem::offset_of!(iovec, iov_base) - 0usize];
    ["Offset of field: iovec::iov_len"][::std::mem::offset_of!(iovec, iov_len) - 8usize];
};
pub type sae_associd_t = __uint32_t;
pub type sae_connid_t = __uint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sa_endpoints {
    pub sae_srcif: ::std::os::raw::c_uint,
    pub sae_srcaddr: *const sockaddr,
    pub sae_srcaddrlen: socklen_t,
    pub sae_dstaddr: *const sockaddr,
    pub sae_dstaddrlen: socklen_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sa_endpoints"][::std::mem::size_of::<sa_endpoints>() - 40usize];
    ["Alignment of sa_endpoints"][::std::mem::align_of::<sa_endpoints>() - 8usize];
    ["Offset of field: sa_endpoints::sae_srcif"]
        [::std::mem::offset_of!(sa_endpoints, sae_srcif) - 0usize];
    ["Offset of field: sa_endpoints::sae_srcaddr"]
        [::std::mem::offset_of!(sa_endpoints, sae_srcaddr) - 8usize];
    ["Offset of field: sa_endpoints::sae_srcaddrlen"]
        [::std::mem::offset_of!(sa_endpoints, sae_srcaddrlen) - 16usize];
    ["Offset of field: sa_endpoints::sae_dstaddr"]
        [::std::mem::offset_of!(sa_endpoints, sae_dstaddr) - 24usize];
    ["Offset of field: sa_endpoints::sae_dstaddrlen"]
        [::std::mem::offset_of!(sa_endpoints, sae_dstaddrlen) - 32usize];
};
pub type sa_endpoints_t = sa_endpoints;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of linger"][::std::mem::size_of::<linger>() - 8usize];
    ["Alignment of linger"][::std::mem::align_of::<linger>() - 4usize];
    ["Offset of field: linger::l_onoff"][::std::mem::offset_of!(linger, l_onoff) - 0usize];
    ["Offset of field: linger::l_linger"][::std::mem::offset_of!(linger, l_linger) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct so_np_extensions {
    pub npx_flags: u_int32_t,
    pub npx_mask: u_int32_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of so_np_extensions"][::std::mem::size_of::<so_np_extensions>() - 8usize];
    ["Alignment of so_np_extensions"][::std::mem::align_of::<so_np_extensions>() - 4usize];
    ["Offset of field: so_np_extensions::npx_flags"]
        [::std::mem::offset_of!(so_np_extensions, npx_flags) - 0usize];
    ["Offset of field: so_np_extensions::npx_mask"]
        [::std::mem::offset_of!(so_np_extensions, npx_mask) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr {
    pub sa_len: __uint8_t,
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr"][::std::mem::size_of::<sockaddr>() - 16usize];
    ["Alignment of sockaddr"][::std::mem::align_of::<sockaddr>() - 1usize];
    ["Offset of field: sockaddr::sa_len"][::std::mem::offset_of!(sockaddr, sa_len) - 0usize];
    ["Offset of field: sockaddr::sa_family"][::std::mem::offset_of!(sockaddr, sa_family) - 1usize];
    ["Offset of field: sockaddr::sa_data"][::std::mem::offset_of!(sockaddr, sa_data) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sockaddr_header {
    pub sa_len: __uint8_t,
    pub sa_family: sa_family_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __sockaddr_header"][::std::mem::size_of::<__sockaddr_header>() - 2usize];
    ["Alignment of __sockaddr_header"][::std::mem::align_of::<__sockaddr_header>() - 1usize];
    ["Offset of field: __sockaddr_header::sa_len"]
        [::std::mem::offset_of!(__sockaddr_header, sa_len) - 0usize];
    ["Offset of field: __sockaddr_header::sa_family"]
        [::std::mem::offset_of!(__sockaddr_header, sa_family) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockproto {
    pub sp_family: __uint16_t,
    pub sp_protocol: __uint16_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockproto"][::std::mem::size_of::<sockproto>() - 4usize];
    ["Alignment of sockproto"][::std::mem::align_of::<sockproto>() - 2usize];
    ["Offset of field: sockproto::sp_family"]
        [::std::mem::offset_of!(sockproto, sp_family) - 0usize];
    ["Offset of field: sockproto::sp_protocol"]
        [::std::mem::offset_of!(sockproto, sp_protocol) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_len: __uint8_t,
    pub ss_family: sa_family_t,
    pub __ss_pad1: [::std::os::raw::c_char; 6usize],
    pub __ss_align: __int64_t,
    pub __ss_pad2: [::std::os::raw::c_char; 112usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr_storage"][::std::mem::size_of::<sockaddr_storage>() - 128usize];
    ["Alignment of sockaddr_storage"][::std::mem::align_of::<sockaddr_storage>() - 8usize];
    ["Offset of field: sockaddr_storage::ss_len"]
        [::std::mem::offset_of!(sockaddr_storage, ss_len) - 0usize];
    ["Offset of field: sockaddr_storage::ss_family"]
        [::std::mem::offset_of!(sockaddr_storage, ss_family) - 1usize];
    ["Offset of field: sockaddr_storage::__ss_pad1"]
        [::std::mem::offset_of!(sockaddr_storage, __ss_pad1) - 2usize];
    ["Offset of field: sockaddr_storage::__ss_align"]
        [::std::mem::offset_of!(sockaddr_storage, __ss_align) - 8usize];
    ["Offset of field: sockaddr_storage::__ss_pad2"]
        [::std::mem::offset_of!(sockaddr_storage, __ss_pad2) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: ::std::os::raw::c_int,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: socklen_t,
    pub msg_flags: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of msghdr"][::std::mem::size_of::<msghdr>() - 48usize];
    ["Alignment of msghdr"][::std::mem::align_of::<msghdr>() - 8usize];
    ["Offset of field: msghdr::msg_name"][::std::mem::offset_of!(msghdr, msg_name) - 0usize];
    ["Offset of field: msghdr::msg_namelen"][::std::mem::offset_of!(msghdr, msg_namelen) - 8usize];
    ["Offset of field: msghdr::msg_iov"][::std::mem::offset_of!(msghdr, msg_iov) - 16usize];
    ["Offset of field: msghdr::msg_iovlen"][::std::mem::offset_of!(msghdr, msg_iovlen) - 24usize];
    ["Offset of field: msghdr::msg_control"][::std::mem::offset_of!(msghdr, msg_control) - 32usize];
    ["Offset of field: msghdr::msg_controllen"]
        [::std::mem::offset_of!(msghdr, msg_controllen) - 40usize];
    ["Offset of field: msghdr::msg_flags"][::std::mem::offset_of!(msghdr, msg_flags) - 44usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cmsghdr {
    pub cmsg_len: socklen_t,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of cmsghdr"][::std::mem::size_of::<cmsghdr>() - 12usize];
    ["Alignment of cmsghdr"][::std::mem::align_of::<cmsghdr>() - 4usize];
    ["Offset of field: cmsghdr::cmsg_len"][::std::mem::offset_of!(cmsghdr, cmsg_len) - 0usize];
    ["Offset of field: cmsghdr::cmsg_level"][::std::mem::offset_of!(cmsghdr, cmsg_level) - 4usize];
    ["Offset of field: cmsghdr::cmsg_type"][::std::mem::offset_of!(cmsghdr, cmsg_type) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sf_hdtr {
    pub headers: *mut iovec,
    pub hdr_cnt: ::std::os::raw::c_int,
    pub trailers: *mut iovec,
    pub trl_cnt: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sf_hdtr"][::std::mem::size_of::<sf_hdtr>() - 32usize];
    ["Alignment of sf_hdtr"][::std::mem::align_of::<sf_hdtr>() - 8usize];
    ["Offset of field: sf_hdtr::headers"][::std::mem::offset_of!(sf_hdtr, headers) - 0usize];
    ["Offset of field: sf_hdtr::hdr_cnt"][::std::mem::offset_of!(sf_hdtr, hdr_cnt) - 8usize];
    ["Offset of field: sf_hdtr::trailers"][::std::mem::offset_of!(sf_hdtr, trailers) - 16usize];
    ["Offset of field: sf_hdtr::trl_cnt"][::std::mem::offset_of!(sf_hdtr, trl_cnt) - 24usize];
};
unsafe extern "C" {
    pub fn accept(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn bind(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn connect(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getpeername(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getsockname(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_void,
        arg5: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn listen(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn recv(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
    ) -> isize;
}
unsafe extern "C" {
    pub fn recvfrom(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
        arg5: *mut sockaddr,
        arg6: *mut socklen_t,
    ) -> isize;
}
unsafe extern "C" {
    pub fn recvmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *mut msghdr,
        arg3: ::std::os::raw::c_int,
    ) -> isize;
}
unsafe extern "C" {
    pub fn send(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
    ) -> isize;
}
unsafe extern "C" {
    pub fn sendmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *const msghdr,
        arg3: ::std::os::raw::c_int,
    ) -> isize;
}
unsafe extern "C" {
    pub fn sendto(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
        arg5: *const sockaddr,
        arg6: socklen_t,
    ) -> isize;
}
unsafe extern "C" {
    pub fn setsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_void,
        arg5: socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn shutdown(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sockatmark(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn socket(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn socketpair(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sendfile(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: off_t,
        arg4: *mut off_t,
        arg5: *mut sf_hdtr,
        arg6: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn pfctlinput(arg1: ::std::os::raw::c_int, arg2: *mut sockaddr);
}
unsafe extern "C" {
    pub fn connectx(
        arg1: ::std::os::raw::c_int,
        arg2: *const sa_endpoints_t,
        arg3: sae_associd_t,
        arg4: ::std::os::raw::c_uint,
        arg5: *const iovec,
        arg6: ::std::os::raw::c_uint,
        arg7: *mut usize,
        arg8: *mut sae_connid_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn disconnectx(
        arg1: ::std::os::raw::c_int,
        arg2: sae_associd_t,
        arg3: sae_connid_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in_addr"][::std::mem::size_of::<in_addr>() - 4usize];
    ["Alignment of in_addr"][::std::mem::align_of::<in_addr>() - 4usize];
    ["Offset of field: in_addr::s_addr"][::std::mem::offset_of!(in_addr, s_addr) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_len: __uint8_t,
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_char; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr_in"][::std::mem::size_of::<sockaddr_in>() - 16usize];
    ["Alignment of sockaddr_in"][::std::mem::align_of::<sockaddr_in>() - 4usize];
    ["Offset of field: sockaddr_in::sin_len"]
        [::std::mem::offset_of!(sockaddr_in, sin_len) - 0usize];
    ["Offset of field: sockaddr_in::sin_family"]
        [::std::mem::offset_of!(sockaddr_in, sin_family) - 1usize];
    ["Offset of field: sockaddr_in::sin_port"]
        [::std::mem::offset_of!(sockaddr_in, sin_port) - 2usize];
    ["Offset of field: sockaddr_in::sin_addr"]
        [::std::mem::offset_of!(sockaddr_in, sin_addr) - 4usize];
    ["Offset of field: sockaddr_in::sin_zero"]
        [::std::mem::offset_of!(sockaddr_in, sin_zero) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_opts {
    pub ip_dst: in_addr,
    pub ip_opts: [::std::os::raw::c_char; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ip_opts"][::std::mem::size_of::<ip_opts>() - 44usize];
    ["Alignment of ip_opts"][::std::mem::align_of::<ip_opts>() - 4usize];
    ["Offset of field: ip_opts::ip_dst"][::std::mem::offset_of!(ip_opts, ip_dst) - 0usize];
    ["Offset of field: ip_opts::ip_opts"][::std::mem::offset_of!(ip_opts, ip_opts) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreq {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ip_mreq"][::std::mem::size_of::<ip_mreq>() - 8usize];
    ["Alignment of ip_mreq"][::std::mem::align_of::<ip_mreq>() - 4usize];
    ["Offset of field: ip_mreq::imr_multiaddr"]
        [::std::mem::offset_of!(ip_mreq, imr_multiaddr) - 0usize];
    ["Offset of field: ip_mreq::imr_interface"]
        [::std::mem::offset_of!(ip_mreq, imr_interface) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreqn {
    pub imr_multiaddr: in_addr,
    pub imr_address: in_addr,
    pub imr_ifindex: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ip_mreqn"][::std::mem::size_of::<ip_mreqn>() - 12usize];
    ["Alignment of ip_mreqn"][::std::mem::align_of::<ip_mreqn>() - 4usize];
    ["Offset of field: ip_mreqn::imr_multiaddr"]
        [::std::mem::offset_of!(ip_mreqn, imr_multiaddr) - 0usize];
    ["Offset of field: ip_mreqn::imr_address"]
        [::std::mem::offset_of!(ip_mreqn, imr_address) - 4usize];
    ["Offset of field: ip_mreqn::imr_ifindex"]
        [::std::mem::offset_of!(ip_mreqn, imr_ifindex) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreq_source {
    pub imr_multiaddr: in_addr,
    pub imr_sourceaddr: in_addr,
    pub imr_interface: in_addr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ip_mreq_source"][::std::mem::size_of::<ip_mreq_source>() - 12usize];
    ["Alignment of ip_mreq_source"][::std::mem::align_of::<ip_mreq_source>() - 4usize];
    ["Offset of field: ip_mreq_source::imr_multiaddr"]
        [::std::mem::offset_of!(ip_mreq_source, imr_multiaddr) - 0usize];
    ["Offset of field: ip_mreq_source::imr_sourceaddr"]
        [::std::mem::offset_of!(ip_mreq_source, imr_sourceaddr) - 4usize];
    ["Offset of field: ip_mreq_source::imr_interface"]
        [::std::mem::offset_of!(ip_mreq_source, imr_interface) - 8usize];
};
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct group_req {
    pub gr_interface: u32,
    pub gr_group: sockaddr_storage,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of group_req"][::std::mem::size_of::<group_req>() - 132usize];
    ["Alignment of group_req"][::std::mem::align_of::<group_req>() - 4usize];
    ["Offset of field: group_req::gr_interface"]
        [::std::mem::offset_of!(group_req, gr_interface) - 0usize];
    ["Offset of field: group_req::gr_group"][::std::mem::offset_of!(group_req, gr_group) - 4usize];
};
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct group_source_req {
    pub gsr_interface: u32,
    pub gsr_group: sockaddr_storage,
    pub gsr_source: sockaddr_storage,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of group_source_req"][::std::mem::size_of::<group_source_req>() - 260usize];
    ["Alignment of group_source_req"][::std::mem::align_of::<group_source_req>() - 4usize];
    ["Offset of field: group_source_req::gsr_interface"]
        [::std::mem::offset_of!(group_source_req, gsr_interface) - 0usize];
    ["Offset of field: group_source_req::gsr_group"]
        [::std::mem::offset_of!(group_source_req, gsr_group) - 4usize];
    ["Offset of field: group_source_req::gsr_source"]
        [::std::mem::offset_of!(group_source_req, gsr_source) - 132usize];
};
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __msfilterreq {
    pub msfr_ifindex: u32,
    pub msfr_fmode: u32,
    pub msfr_nsrcs: u32,
    pub __msfr_align: u32,
    pub msfr_group: sockaddr_storage,
    pub msfr_srcs: *mut sockaddr_storage,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __msfilterreq"][::std::mem::size_of::<__msfilterreq>() - 152usize];
    ["Alignment of __msfilterreq"][::std::mem::align_of::<__msfilterreq>() - 4usize];
    ["Offset of field: __msfilterreq::msfr_ifindex"]
        [::std::mem::offset_of!(__msfilterreq, msfr_ifindex) - 0usize];
    ["Offset of field: __msfilterreq::msfr_fmode"]
        [::std::mem::offset_of!(__msfilterreq, msfr_fmode) - 4usize];
    ["Offset of field: __msfilterreq::msfr_nsrcs"]
        [::std::mem::offset_of!(__msfilterreq, msfr_nsrcs) - 8usize];
    ["Offset of field: __msfilterreq::__msfr_align"]
        [::std::mem::offset_of!(__msfilterreq, __msfr_align) - 12usize];
    ["Offset of field: __msfilterreq::msfr_group"]
        [::std::mem::offset_of!(__msfilterreq, msfr_group) - 16usize];
    ["Offset of field: __msfilterreq::msfr_srcs"]
        [::std::mem::offset_of!(__msfilterreq, msfr_srcs) - 144usize];
};
unsafe extern "C" {
    pub fn setipv4sourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: in_addr,
        arg3: in_addr,
        arg4: u32,
        arg5: u32,
        arg6: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getipv4sourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: in_addr,
        arg3: in_addr,
        arg4: *mut u32,
        arg5: *mut u32,
        arg6: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn setsourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: u32,
        arg3: *mut sockaddr,
        arg4: socklen_t,
        arg5: u32,
        arg6: u32,
        arg7: *mut sockaddr_storage,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getsourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: u32,
        arg3: *mut sockaddr,
        arg4: socklen_t,
        arg5: *mut u32,
        arg6: *mut u32,
        arg7: *mut sockaddr_storage,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_pktinfo {
    pub ipi_ifindex: ::std::os::raw::c_uint,
    pub ipi_spec_dst: in_addr,
    pub ipi_addr: in_addr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in_pktinfo"][::std::mem::size_of::<in_pktinfo>() - 12usize];
    ["Alignment of in_pktinfo"][::std::mem::align_of::<in_pktinfo>() - 4usize];
    ["Offset of field: in_pktinfo::ipi_ifindex"]
        [::std::mem::offset_of!(in_pktinfo, ipi_ifindex) - 0usize];
    ["Offset of field: in_pktinfo::ipi_spec_dst"]
        [::std::mem::offset_of!(in_pktinfo, ipi_spec_dst) - 4usize];
    ["Offset of field: in_pktinfo::ipi_addr"]
        [::std::mem::offset_of!(in_pktinfo, ipi_addr) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __u6_addr: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [__uint8_t; 16usize],
    pub __u6_addr16: [__uint16_t; 8usize],
    pub __u6_addr32: [__uint32_t; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in6_addr__bindgen_ty_1"][::std::mem::size_of::<in6_addr__bindgen_ty_1>() - 16usize];
    ["Alignment of in6_addr__bindgen_ty_1"]
        [::std::mem::align_of::<in6_addr__bindgen_ty_1>() - 4usize];
    ["Offset of field: in6_addr__bindgen_ty_1::__u6_addr8"]
        [::std::mem::offset_of!(in6_addr__bindgen_ty_1, __u6_addr8) - 0usize];
    ["Offset of field: in6_addr__bindgen_ty_1::__u6_addr16"]
        [::std::mem::offset_of!(in6_addr__bindgen_ty_1, __u6_addr16) - 0usize];
    ["Offset of field: in6_addr__bindgen_ty_1::__u6_addr32"]
        [::std::mem::offset_of!(in6_addr__bindgen_ty_1, __u6_addr32) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in6_addr"][::std::mem::size_of::<in6_addr>() - 16usize];
    ["Alignment of in6_addr"][::std::mem::align_of::<in6_addr>() - 4usize];
    ["Offset of field: in6_addr::__u6_addr"][::std::mem::offset_of!(in6_addr, __u6_addr) - 0usize];
};
pub type in6_addr_t = in6_addr;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_len: __uint8_t,
    pub sin6_family: sa_family_t,
    pub sin6_port: in_port_t,
    pub sin6_flowinfo: __uint32_t,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: __uint32_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr_in6"][::std::mem::size_of::<sockaddr_in6>() - 28usize];
    ["Alignment of sockaddr_in6"][::std::mem::align_of::<sockaddr_in6>() - 4usize];
    ["Offset of field: sockaddr_in6::sin6_len"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_len) - 0usize];
    ["Offset of field: sockaddr_in6::sin6_family"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_family) - 1usize];
    ["Offset of field: sockaddr_in6::sin6_port"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_port) - 2usize];
    ["Offset of field: sockaddr_in6::sin6_flowinfo"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_flowinfo) - 4usize];
    ["Offset of field: sockaddr_in6::sin6_addr"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_addr) - 8usize];
    ["Offset of field: sockaddr_in6::sin6_scope_id"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_scope_id) - 24usize];
};
unsafe extern "C" {
    pub static in6addr_any: in6_addr;
}
unsafe extern "C" {
    pub static in6addr_loopback: in6_addr;
}
unsafe extern "C" {
    pub static in6addr_nodelocal_allnodes: in6_addr;
}
unsafe extern "C" {
    pub static in6addr_linklocal_allnodes: in6_addr;
}
unsafe extern "C" {
    pub static in6addr_linklocal_allrouters: in6_addr;
}
unsafe extern "C" {
    pub static in6addr_linklocal_allv2routers: in6_addr;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ipv6_mreq {
    pub ipv6mr_multiaddr: in6_addr,
    pub ipv6mr_interface: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ipv6_mreq"][::std::mem::size_of::<ipv6_mreq>() - 20usize];
    ["Alignment of ipv6_mreq"][::std::mem::align_of::<ipv6_mreq>() - 4usize];
    ["Offset of field: ipv6_mreq::ipv6mr_multiaddr"]
        [::std::mem::offset_of!(ipv6_mreq, ipv6mr_multiaddr) - 0usize];
    ["Offset of field: ipv6_mreq::ipv6mr_interface"]
        [::std::mem::offset_of!(ipv6_mreq, ipv6mr_interface) - 16usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_pktinfo {
    pub ipi6_addr: in6_addr,
    pub ipi6_ifindex: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in6_pktinfo"][::std::mem::size_of::<in6_pktinfo>() - 20usize];
    ["Alignment of in6_pktinfo"][::std::mem::align_of::<in6_pktinfo>() - 4usize];
    ["Offset of field: in6_pktinfo::ipi6_addr"]
        [::std::mem::offset_of!(in6_pktinfo, ipi6_addr) - 0usize];
    ["Offset of field: in6_pktinfo::ipi6_ifindex"]
        [::std::mem::offset_of!(in6_pktinfo, ipi6_ifindex) - 16usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ip6_mtuinfo {
    pub ip6m_addr: sockaddr_in6,
    pub ip6m_mtu: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ip6_mtuinfo"][::std::mem::size_of::<ip6_mtuinfo>() - 32usize];
    ["Alignment of ip6_mtuinfo"][::std::mem::align_of::<ip6_mtuinfo>() - 4usize];
    ["Offset of field: ip6_mtuinfo::ip6m_addr"]
        [::std::mem::offset_of!(ip6_mtuinfo, ip6m_addr) - 0usize];
    ["Offset of field: ip6_mtuinfo::ip6m_mtu"]
        [::std::mem::offset_of!(ip6_mtuinfo, ip6m_mtu) - 28usize];
};
unsafe extern "C" {
    pub fn inet6_option_space(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_option_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *mut *mut cmsghdr,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_option_append(
        arg1: *mut cmsghdr,
        arg2: *const __uint8_t,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_option_alloc(
        arg1: *mut cmsghdr,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> *mut __uint8_t;
}
unsafe extern "C" {
    pub fn inet6_option_next(
        arg1: *const cmsghdr,
        arg2: *mut *mut __uint8_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_option_find(
        arg1: *const cmsghdr,
        arg2: *mut *mut __uint8_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rthdr_space(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> usize;
}
unsafe extern "C" {
    pub fn inet6_rthdr_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> *mut cmsghdr;
}
unsafe extern "C" {
    pub fn inet6_rthdr_add(
        arg1: *mut cmsghdr,
        arg2: *const in6_addr,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rthdr_lasthop(
        arg1: *mut cmsghdr,
        arg2: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rthdr_segments(arg1: *const cmsghdr) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rthdr_getaddr(arg1: *mut cmsghdr, arg2: ::std::os::raw::c_int) -> *mut in6_addr;
}
unsafe extern "C" {
    pub fn inet6_rthdr_getflags(
        arg1: *const cmsghdr,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_append(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: __uint8_t,
        arg5: socklen_t,
        arg6: __uint8_t,
        arg7: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_finish(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_set_val(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_next(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: *mut __uint8_t,
        arg5: *mut socklen_t,
        arg6: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_find(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: __uint8_t,
        arg5: *mut socklen_t,
        arg6: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_get_val(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rth_space(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> socklen_t;
}
unsafe extern "C" {
    pub fn inet6_rth_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn inet6_rth_add(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const in6_addr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rth_reverse(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rth_segments(arg1: *const ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rth_getaddr(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> *mut in6_addr;
}
unsafe extern "C" {
    pub fn bindresvport(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr_in,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn bindresvport_sa(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet_addr(arg1: *const ::std::os::raw::c_char) -> in_addr_t;
}
unsafe extern "C" {
    pub fn inet_ntoa(arg1: in_addr) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_ntop(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_char,
        arg4: socklen_t,
    ) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_pton(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn ascii2addr(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn addr2ascii(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_aton(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet_lnaof(arg1: in_addr) -> in_addr_t;
}
unsafe extern "C" {
    pub fn inet_makeaddr(arg1: in_addr_t, arg2: in_addr_t) -> in_addr;
}
unsafe extern "C" {
    pub fn inet_netof(arg1: in_addr) -> in_addr_t;
}
unsafe extern "C" {
    pub fn inet_network(arg1: *const ::std::os::raw::c_char) -> in_addr_t;
}
unsafe extern "C" {
    pub fn inet_net_ntop(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_char,
        arg5: __darwin_size_t,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_net_pton(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
        arg4: __darwin_size_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet_neta(
        arg1: in_addr_t,
        arg2: *mut ::std::os::raw::c_char,
        arg3: __darwin_size_t,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_nsap_addr(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_uchar,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn inet_nsap_ntoa(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_uchar,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_metrics {
    pub rmx_locks: u_int32_t,
    pub rmx_mtu: u_int32_t,
    pub rmx_hopcount: u_int32_t,
    pub rmx_expire: i32,
    pub rmx_recvpipe: u_int32_t,
    pub rmx_sendpipe: u_int32_t,
    pub rmx_ssthresh: u_int32_t,
    pub rmx_rtt: u_int32_t,
    pub rmx_rttvar: u_int32_t,
    pub rmx_pksent: u_int32_t,
    pub rmx_state: u_int32_t,
    pub rmx_filler: [u_int32_t; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rt_metrics"][::std::mem::size_of::<rt_metrics>() - 56usize];
    ["Alignment of rt_metrics"][::std::mem::align_of::<rt_metrics>() - 4usize];
    ["Offset of field: rt_metrics::rmx_locks"]
        [::std::mem::offset_of!(rt_metrics, rmx_locks) - 0usize];
    ["Offset of field: rt_metrics::rmx_mtu"][::std::mem::offset_of!(rt_metrics, rmx_mtu) - 4usize];
    ["Offset of field: rt_metrics::rmx_hopcount"]
        [::std::mem::offset_of!(rt_metrics, rmx_hopcount) - 8usize];
    ["Offset of field: rt_metrics::rmx_expire"]
        [::std::mem::offset_of!(rt_metrics, rmx_expire) - 12usize];
    ["Offset of field: rt_metrics::rmx_recvpipe"]
        [::std::mem::offset_of!(rt_metrics, rmx_recvpipe) - 16usize];
    ["Offset of field: rt_metrics::rmx_sendpipe"]
        [::std::mem::offset_of!(rt_metrics, rmx_sendpipe) - 20usize];
    ["Offset of field: rt_metrics::rmx_ssthresh"]
        [::std::mem::offset_of!(rt_metrics, rmx_ssthresh) - 24usize];
    ["Offset of field: rt_metrics::rmx_rtt"][::std::mem::offset_of!(rt_metrics, rmx_rtt) - 28usize];
    ["Offset of field: rt_metrics::rmx_rttvar"]
        [::std::mem::offset_of!(rt_metrics, rmx_rttvar) - 32usize];
    ["Offset of field: rt_metrics::rmx_pksent"]
        [::std::mem::offset_of!(rt_metrics, rmx_pksent) - 36usize];
    ["Offset of field: rt_metrics::rmx_state"]
        [::std::mem::offset_of!(rt_metrics, rmx_state) - 40usize];
    ["Offset of field: rt_metrics::rmx_filler"]
        [::std::mem::offset_of!(rt_metrics, rmx_filler) - 44usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rtstat {
    pub rts_badredirect: ::std::os::raw::c_short,
    pub rts_dynamic: ::std::os::raw::c_short,
    pub rts_newgateway: ::std::os::raw::c_short,
    pub rts_unreach: ::std::os::raw::c_short,
    pub rts_wildcard: ::std::os::raw::c_short,
    pub rts_badrtgwroute: ::std::os::raw::c_short,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rtstat"][::std::mem::size_of::<rtstat>() - 12usize];
    ["Alignment of rtstat"][::std::mem::align_of::<rtstat>() - 2usize];
    ["Offset of field: rtstat::rts_badredirect"]
        [::std::mem::offset_of!(rtstat, rts_badredirect) - 0usize];
    ["Offset of field: rtstat::rts_dynamic"][::std::mem::offset_of!(rtstat, rts_dynamic) - 2usize];
    ["Offset of field: rtstat::rts_newgateway"]
        [::std::mem::offset_of!(rtstat, rts_newgateway) - 4usize];
    ["Offset of field: rtstat::rts_unreach"][::std::mem::offset_of!(rtstat, rts_unreach) - 6usize];
    ["Offset of field: rtstat::rts_wildcard"]
        [::std::mem::offset_of!(rtstat, rts_wildcard) - 8usize];
    ["Offset of field: rtstat::rts_badrtgwroute"]
        [::std::mem::offset_of!(rtstat, rts_badrtgwroute) - 10usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_msghdr {
    pub rtm_msglen: u_short,
    pub rtm_version: u_char,
    pub rtm_type: u_char,
    pub rtm_index: u_short,
    pub rtm_flags: ::std::os::raw::c_int,
    pub rtm_addrs: ::std::os::raw::c_int,
    pub rtm_pid: pid_t,
    pub rtm_seq: ::std::os::raw::c_int,
    pub rtm_errno: ::std::os::raw::c_int,
    pub rtm_use: ::std::os::raw::c_int,
    pub rtm_inits: u_int32_t,
    pub rtm_rmx: rt_metrics,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rt_msghdr"][::std::mem::size_of::<rt_msghdr>() - 92usize];
    ["Alignment of rt_msghdr"][::std::mem::align_of::<rt_msghdr>() - 4usize];
    ["Offset of field: rt_msghdr::rtm_msglen"]
        [::std::mem::offset_of!(rt_msghdr, rtm_msglen) - 0usize];
    ["Offset of field: rt_msghdr::rtm_version"]
        [::std::mem::offset_of!(rt_msghdr, rtm_version) - 2usize];
    ["Offset of field: rt_msghdr::rtm_type"][::std::mem::offset_of!(rt_msghdr, rtm_type) - 3usize];
    ["Offset of field: rt_msghdr::rtm_index"]
        [::std::mem::offset_of!(rt_msghdr, rtm_index) - 4usize];
    ["Offset of field: rt_msghdr::rtm_flags"]
        [::std::mem::offset_of!(rt_msghdr, rtm_flags) - 8usize];
    ["Offset of field: rt_msghdr::rtm_addrs"]
        [::std::mem::offset_of!(rt_msghdr, rtm_addrs) - 12usize];
    ["Offset of field: rt_msghdr::rtm_pid"][::std::mem::offset_of!(rt_msghdr, rtm_pid) - 16usize];
    ["Offset of field: rt_msghdr::rtm_seq"][::std::mem::offset_of!(rt_msghdr, rtm_seq) - 20usize];
    ["Offset of field: rt_msghdr::rtm_errno"]
        [::std::mem::offset_of!(rt_msghdr, rtm_errno) - 24usize];
    ["Offset of field: rt_msghdr::rtm_use"][::std::mem::offset_of!(rt_msghdr, rtm_use) - 28usize];
    ["Offset of field: rt_msghdr::rtm_inits"]
        [::std::mem::offset_of!(rt_msghdr, rtm_inits) - 32usize];
    ["Offset of field: rt_msghdr::rtm_rmx"][::std::mem::offset_of!(rt_msghdr, rtm_rmx) - 36usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_msghdr2 {
    pub rtm_msglen: u_short,
    pub rtm_version: u_char,
    pub rtm_type: u_char,
    pub rtm_index: u_short,
    pub rtm_flags: ::std::os::raw::c_int,
    pub rtm_addrs: ::std::os::raw::c_int,
    pub rtm_refcnt: i32,
    pub rtm_parentflags: ::std::os::raw::c_int,
    pub rtm_reserved: ::std::os::raw::c_int,
    pub rtm_use: ::std::os::raw::c_int,
    pub rtm_inits: u_int32_t,
    pub rtm_rmx: rt_metrics,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rt_msghdr2"][::std::mem::size_of::<rt_msghdr2>() - 92usize];
    ["Alignment of rt_msghdr2"][::std::mem::align_of::<rt_msghdr2>() - 4usize];
    ["Offset of field: rt_msghdr2::rtm_msglen"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_msglen) - 0usize];
    ["Offset of field: rt_msghdr2::rtm_version"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_version) - 2usize];
    ["Offset of field: rt_msghdr2::rtm_type"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_type) - 3usize];
    ["Offset of field: rt_msghdr2::rtm_index"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_index) - 4usize];
    ["Offset of field: rt_msghdr2::rtm_flags"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_flags) - 8usize];
    ["Offset of field: rt_msghdr2::rtm_addrs"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_addrs) - 12usize];
    ["Offset of field: rt_msghdr2::rtm_refcnt"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_refcnt) - 16usize];
    ["Offset of field: rt_msghdr2::rtm_parentflags"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_parentflags) - 20usize];
    ["Offset of field: rt_msghdr2::rtm_reserved"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_reserved) - 24usize];
    ["Offset of field: rt_msghdr2::rtm_use"][::std::mem::offset_of!(rt_msghdr2, rtm_use) - 28usize];
    ["Offset of field: rt_msghdr2::rtm_inits"]
        [::std::mem::offset_of!(rt_msghdr2, rtm_inits) - 32usize];
    ["Offset of field: rt_msghdr2::rtm_rmx"][::std::mem::offset_of!(rt_msghdr2, rtm_rmx) - 36usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_addrinfo {
    pub rti_addrs: ::std::os::raw::c_int,
    pub rti_info: [*mut sockaddr; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rt_addrinfo"][::std::mem::size_of::<rt_addrinfo>() - 72usize];
    ["Alignment of rt_addrinfo"][::std::mem::align_of::<rt_addrinfo>() - 8usize];
    ["Offset of field: rt_addrinfo::rti_addrs"]
        [::std::mem::offset_of!(rt_addrinfo, rti_addrs) - 0usize];
    ["Offset of field: rt_addrinfo::rti_info"]
        [::std::mem::offset_of!(rt_addrinfo, rti_info) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_dl {
    pub sdl_len: u_char,
    pub sdl_family: u_char,
    pub sdl_index: u_short,
    pub sdl_type: u_char,
    pub sdl_nlen: u_char,
    pub sdl_alen: u_char,
    pub sdl_slen: u_char,
    pub sdl_data: [::std::os::raw::c_char; 12usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr_dl"][::std::mem::size_of::<sockaddr_dl>() - 20usize];
    ["Alignment of sockaddr_dl"][::std::mem::align_of::<sockaddr_dl>() - 2usize];
    ["Offset of field: sockaddr_dl::sdl_len"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_len) - 0usize];
    ["Offset of field: sockaddr_dl::sdl_family"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_family) - 1usize];
    ["Offset of field: sockaddr_dl::sdl_index"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_index) - 2usize];
    ["Offset of field: sockaddr_dl::sdl_type"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_type) - 4usize];
    ["Offset of field: sockaddr_dl::sdl_nlen"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_nlen) - 5usize];
    ["Offset of field: sockaddr_dl::sdl_alen"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_alen) - 6usize];
    ["Offset of field: sockaddr_dl::sdl_slen"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_slen) - 7usize];
    ["Offset of field: sockaddr_dl::sdl_data"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_data) - 8usize];
};
unsafe extern "C" {
    pub fn link_addr(arg1: *const ::std::os::raw::c_char, arg2: *mut sockaddr_dl);
}
unsafe extern "C" {
    pub fn link_ntoa(arg1: *const sockaddr_dl) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct net_event_data {
    pub if_family: u_int32_t,
    pub if_unit: u_int32_t,
    pub if_name: [::std::os::raw::c_char; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of net_event_data"][::std::mem::size_of::<net_event_data>() - 24usize];
    ["Alignment of net_event_data"][::std::mem::align_of::<net_event_data>() - 4usize];
    ["Offset of field: net_event_data::if_family"]
        [::std::mem::offset_of!(net_event_data, if_family) - 0usize];
    ["Offset of field: net_event_data::if_unit"]
        [::std::mem::offset_of!(net_event_data, if_unit) - 4usize];
    ["Offset of field: net_event_data::if_name"]
        [::std::mem::offset_of!(net_event_data, if_name) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval32 {
    pub tv_sec: __int32_t,
    pub tv_usec: __int32_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timeval32"][::std::mem::size_of::<timeval32>() - 8usize];
    ["Alignment of timeval32"][::std::mem::align_of::<timeval32>() - 4usize];
    ["Offset of field: timeval32::tv_sec"][::std::mem::offset_of!(timeval32, tv_sec) - 0usize];
    ["Offset of field: timeval32::tv_usec"][::std::mem::offset_of!(timeval32, tv_usec) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_data {
    pub ifi_type: u_char,
    pub ifi_typelen: u_char,
    pub ifi_physical: u_char,
    pub ifi_addrlen: u_char,
    pub ifi_hdrlen: u_char,
    pub ifi_recvquota: u_char,
    pub ifi_xmitquota: u_char,
    pub ifi_unused1: u_char,
    pub ifi_mtu: u_int32_t,
    pub ifi_metric: u_int32_t,
    pub ifi_baudrate: u_int32_t,
    pub ifi_ipackets: u_int32_t,
    pub ifi_ierrors: u_int32_t,
    pub ifi_opackets: u_int32_t,
    pub ifi_oerrors: u_int32_t,
    pub ifi_collisions: u_int32_t,
    pub ifi_ibytes: u_int32_t,
    pub ifi_obytes: u_int32_t,
    pub ifi_imcasts: u_int32_t,
    pub ifi_omcasts: u_int32_t,
    pub ifi_iqdrops: u_int32_t,
    pub ifi_noproto: u_int32_t,
    pub ifi_recvtiming: u_int32_t,
    pub ifi_xmittiming: u_int32_t,
    pub ifi_lastchange: timeval32,
    pub ifi_unused2: u_int32_t,
    pub ifi_hwassist: u_int32_t,
    pub ifi_reserved1: u_int32_t,
    pub ifi_reserved2: u_int32_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_data"][::std::mem::size_of::<if_data>() - 96usize];
    ["Alignment of if_data"][::std::mem::align_of::<if_data>() - 4usize];
    ["Offset of field: if_data::ifi_type"][::std::mem::offset_of!(if_data, ifi_type) - 0usize];
    ["Offset of field: if_data::ifi_typelen"]
        [::std::mem::offset_of!(if_data, ifi_typelen) - 1usize];
    ["Offset of field: if_data::ifi_physical"]
        [::std::mem::offset_of!(if_data, ifi_physical) - 2usize];
    ["Offset of field: if_data::ifi_addrlen"]
        [::std::mem::offset_of!(if_data, ifi_addrlen) - 3usize];
    ["Offset of field: if_data::ifi_hdrlen"][::std::mem::offset_of!(if_data, ifi_hdrlen) - 4usize];
    ["Offset of field: if_data::ifi_recvquota"]
        [::std::mem::offset_of!(if_data, ifi_recvquota) - 5usize];
    ["Offset of field: if_data::ifi_xmitquota"]
        [::std::mem::offset_of!(if_data, ifi_xmitquota) - 6usize];
    ["Offset of field: if_data::ifi_unused1"]
        [::std::mem::offset_of!(if_data, ifi_unused1) - 7usize];
    ["Offset of field: if_data::ifi_mtu"][::std::mem::offset_of!(if_data, ifi_mtu) - 8usize];
    ["Offset of field: if_data::ifi_metric"][::std::mem::offset_of!(if_data, ifi_metric) - 12usize];
    ["Offset of field: if_data::ifi_baudrate"]
        [::std::mem::offset_of!(if_data, ifi_baudrate) - 16usize];
    ["Offset of field: if_data::ifi_ipackets"]
        [::std::mem::offset_of!(if_data, ifi_ipackets) - 20usize];
    ["Offset of field: if_data::ifi_ierrors"]
        [::std::mem::offset_of!(if_data, ifi_ierrors) - 24usize];
    ["Offset of field: if_data::ifi_opackets"]
        [::std::mem::offset_of!(if_data, ifi_opackets) - 28usize];
    ["Offset of field: if_data::ifi_oerrors"]
        [::std::mem::offset_of!(if_data, ifi_oerrors) - 32usize];
    ["Offset of field: if_data::ifi_collisions"]
        [::std::mem::offset_of!(if_data, ifi_collisions) - 36usize];
    ["Offset of field: if_data::ifi_ibytes"][::std::mem::offset_of!(if_data, ifi_ibytes) - 40usize];
    ["Offset of field: if_data::ifi_obytes"][::std::mem::offset_of!(if_data, ifi_obytes) - 44usize];
    ["Offset of field: if_data::ifi_imcasts"]
        [::std::mem::offset_of!(if_data, ifi_imcasts) - 48usize];
    ["Offset of field: if_data::ifi_omcasts"]
        [::std::mem::offset_of!(if_data, ifi_omcasts) - 52usize];
    ["Offset of field: if_data::ifi_iqdrops"]
        [::std::mem::offset_of!(if_data, ifi_iqdrops) - 56usize];
    ["Offset of field: if_data::ifi_noproto"]
        [::std::mem::offset_of!(if_data, ifi_noproto) - 60usize];
    ["Offset of field: if_data::ifi_recvtiming"]
        [::std::mem::offset_of!(if_data, ifi_recvtiming) - 64usize];
    ["Offset of field: if_data::ifi_xmittiming"]
        [::std::mem::offset_of!(if_data, ifi_xmittiming) - 68usize];
    ["Offset of field: if_data::ifi_lastchange"]
        [::std::mem::offset_of!(if_data, ifi_lastchange) - 72usize];
    ["Offset of field: if_data::ifi_unused2"]
        [::std::mem::offset_of!(if_data, ifi_unused2) - 80usize];
    ["Offset of field: if_data::ifi_hwassist"]
        [::std::mem::offset_of!(if_data, ifi_hwassist) - 84usize];
    ["Offset of field: if_data::ifi_reserved1"]
        [::std::mem::offset_of!(if_data, ifi_reserved1) - 88usize];
    ["Offset of field: if_data::ifi_reserved2"]
        [::std::mem::offset_of!(if_data, ifi_reserved2) - 92usize];
};
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_data64 {
    pub ifi_type: u_char,
    pub ifi_typelen: u_char,
    pub ifi_physical: u_char,
    pub ifi_addrlen: u_char,
    pub ifi_hdrlen: u_char,
    pub ifi_recvquota: u_char,
    pub ifi_xmitquota: u_char,
    pub ifi_unused1: u_char,
    pub ifi_mtu: u_int32_t,
    pub ifi_metric: u_int32_t,
    pub ifi_baudrate: u_int64_t,
    pub ifi_ipackets: u_int64_t,
    pub ifi_ierrors: u_int64_t,
    pub ifi_opackets: u_int64_t,
    pub ifi_oerrors: u_int64_t,
    pub ifi_collisions: u_int64_t,
    pub ifi_ibytes: u_int64_t,
    pub ifi_obytes: u_int64_t,
    pub ifi_imcasts: u_int64_t,
    pub ifi_omcasts: u_int64_t,
    pub ifi_iqdrops: u_int64_t,
    pub ifi_noproto: u_int64_t,
    pub ifi_recvtiming: u_int32_t,
    pub ifi_xmittiming: u_int32_t,
    pub ifi_lastchange: timeval32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_data64"][::std::mem::size_of::<if_data64>() - 128usize];
    ["Alignment of if_data64"][::std::mem::align_of::<if_data64>() - 4usize];
    ["Offset of field: if_data64::ifi_type"][::std::mem::offset_of!(if_data64, ifi_type) - 0usize];
    ["Offset of field: if_data64::ifi_typelen"]
        [::std::mem::offset_of!(if_data64, ifi_typelen) - 1usize];
    ["Offset of field: if_data64::ifi_physical"]
        [::std::mem::offset_of!(if_data64, ifi_physical) - 2usize];
    ["Offset of field: if_data64::ifi_addrlen"]
        [::std::mem::offset_of!(if_data64, ifi_addrlen) - 3usize];
    ["Offset of field: if_data64::ifi_hdrlen"]
        [::std::mem::offset_of!(if_data64, ifi_hdrlen) - 4usize];
    ["Offset of field: if_data64::ifi_recvquota"]
        [::std::mem::offset_of!(if_data64, ifi_recvquota) - 5usize];
    ["Offset of field: if_data64::ifi_xmitquota"]
        [::std::mem::offset_of!(if_data64, ifi_xmitquota) - 6usize];
    ["Offset of field: if_data64::ifi_unused1"]
        [::std::mem::offset_of!(if_data64, ifi_unused1) - 7usize];
    ["Offset of field: if_data64::ifi_mtu"][::std::mem::offset_of!(if_data64, ifi_mtu) - 8usize];
    ["Offset of field: if_data64::ifi_metric"]
        [::std::mem::offset_of!(if_data64, ifi_metric) - 12usize];
    ["Offset of field: if_data64::ifi_baudrate"]
        [::std::mem::offset_of!(if_data64, ifi_baudrate) - 16usize];
    ["Offset of field: if_data64::ifi_ipackets"]
        [::std::mem::offset_of!(if_data64, ifi_ipackets) - 24usize];
    ["Offset of field: if_data64::ifi_ierrors"]
        [::std::mem::offset_of!(if_data64, ifi_ierrors) - 32usize];
    ["Offset of field: if_data64::ifi_opackets"]
        [::std::mem::offset_of!(if_data64, ifi_opackets) - 40usize];
    ["Offset of field: if_data64::ifi_oerrors"]
        [::std::mem::offset_of!(if_data64, ifi_oerrors) - 48usize];
    ["Offset of field: if_data64::ifi_collisions"]
        [::std::mem::offset_of!(if_data64, ifi_collisions) - 56usize];
    ["Offset of field: if_data64::ifi_ibytes"]
        [::std::mem::offset_of!(if_data64, ifi_ibytes) - 64usize];
    ["Offset of field: if_data64::ifi_obytes"]
        [::std::mem::offset_of!(if_data64, ifi_obytes) - 72usize];
    ["Offset of field: if_data64::ifi_imcasts"]
        [::std::mem::offset_of!(if_data64, ifi_imcasts) - 80usize];
    ["Offset of field: if_data64::ifi_omcasts"]
        [::std::mem::offset_of!(if_data64, ifi_omcasts) - 88usize];
    ["Offset of field: if_data64::ifi_iqdrops"]
        [::std::mem::offset_of!(if_data64, ifi_iqdrops) - 96usize];
    ["Offset of field: if_data64::ifi_noproto"]
        [::std::mem::offset_of!(if_data64, ifi_noproto) - 104usize];
    ["Offset of field: if_data64::ifi_recvtiming"]
        [::std::mem::offset_of!(if_data64, ifi_recvtiming) - 112usize];
    ["Offset of field: if_data64::ifi_xmittiming"]
        [::std::mem::offset_of!(if_data64, ifi_xmittiming) - 116usize];
    ["Offset of field: if_data64::ifi_lastchange"]
        [::std::mem::offset_of!(if_data64, ifi_lastchange) - 120usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifnet_interface_advisory {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifqueue {
    pub ifq_head: *mut ::std::os::raw::c_void,
    pub ifq_tail: *mut ::std::os::raw::c_void,
    pub ifq_len: ::std::os::raw::c_int,
    pub ifq_maxlen: ::std::os::raw::c_int,
    pub ifq_drops: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifqueue"][::std::mem::size_of::<ifqueue>() - 32usize];
    ["Alignment of ifqueue"][::std::mem::align_of::<ifqueue>() - 8usize];
    ["Offset of field: ifqueue::ifq_head"][::std::mem::offset_of!(ifqueue, ifq_head) - 0usize];
    ["Offset of field: ifqueue::ifq_tail"][::std::mem::offset_of!(ifqueue, ifq_tail) - 8usize];
    ["Offset of field: ifqueue::ifq_len"][::std::mem::offset_of!(ifqueue, ifq_len) - 16usize];
    ["Offset of field: ifqueue::ifq_maxlen"][::std::mem::offset_of!(ifqueue, ifq_maxlen) - 20usize];
    ["Offset of field: ifqueue::ifq_drops"][::std::mem::offset_of!(ifqueue, ifq_drops) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_clonereq {
    pub ifcr_total: ::std::os::raw::c_int,
    pub ifcr_count: ::std::os::raw::c_int,
    pub ifcr_buffer: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_clonereq"][::std::mem::size_of::<if_clonereq>() - 16usize];
    ["Alignment of if_clonereq"][::std::mem::align_of::<if_clonereq>() - 8usize];
    ["Offset of field: if_clonereq::ifcr_total"]
        [::std::mem::offset_of!(if_clonereq, ifcr_total) - 0usize];
    ["Offset of field: if_clonereq::ifcr_count"]
        [::std::mem::offset_of!(if_clonereq, ifcr_count) - 4usize];
    ["Offset of field: if_clonereq::ifcr_buffer"]
        [::std::mem::offset_of!(if_clonereq, ifcr_buffer) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_msghdr {
    pub ifm_msglen: ::std::os::raw::c_ushort,
    pub ifm_version: ::std::os::raw::c_uchar,
    pub ifm_type: ::std::os::raw::c_uchar,
    pub ifm_addrs: ::std::os::raw::c_int,
    pub ifm_flags: ::std::os::raw::c_int,
    pub ifm_index: ::std::os::raw::c_ushort,
    pub ifm_data: if_data,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_msghdr"][::std::mem::size_of::<if_msghdr>() - 112usize];
    ["Alignment of if_msghdr"][::std::mem::align_of::<if_msghdr>() - 4usize];
    ["Offset of field: if_msghdr::ifm_msglen"]
        [::std::mem::offset_of!(if_msghdr, ifm_msglen) - 0usize];
    ["Offset of field: if_msghdr::ifm_version"]
        [::std::mem::offset_of!(if_msghdr, ifm_version) - 2usize];
    ["Offset of field: if_msghdr::ifm_type"][::std::mem::offset_of!(if_msghdr, ifm_type) - 3usize];
    ["Offset of field: if_msghdr::ifm_addrs"]
        [::std::mem::offset_of!(if_msghdr, ifm_addrs) - 4usize];
    ["Offset of field: if_msghdr::ifm_flags"]
        [::std::mem::offset_of!(if_msghdr, ifm_flags) - 8usize];
    ["Offset of field: if_msghdr::ifm_index"]
        [::std::mem::offset_of!(if_msghdr, ifm_index) - 12usize];
    ["Offset of field: if_msghdr::ifm_data"][::std::mem::offset_of!(if_msghdr, ifm_data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifa_msghdr {
    pub ifam_msglen: ::std::os::raw::c_ushort,
    pub ifam_version: ::std::os::raw::c_uchar,
    pub ifam_type: ::std::os::raw::c_uchar,
    pub ifam_addrs: ::std::os::raw::c_int,
    pub ifam_flags: ::std::os::raw::c_int,
    pub ifam_index: ::std::os::raw::c_ushort,
    pub ifam_metric: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifa_msghdr"][::std::mem::size_of::<ifa_msghdr>() - 20usize];
    ["Alignment of ifa_msghdr"][::std::mem::align_of::<ifa_msghdr>() - 4usize];
    ["Offset of field: ifa_msghdr::ifam_msglen"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_msglen) - 0usize];
    ["Offset of field: ifa_msghdr::ifam_version"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_version) - 2usize];
    ["Offset of field: ifa_msghdr::ifam_type"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_type) - 3usize];
    ["Offset of field: ifa_msghdr::ifam_addrs"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_addrs) - 4usize];
    ["Offset of field: ifa_msghdr::ifam_flags"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_flags) - 8usize];
    ["Offset of field: ifa_msghdr::ifam_index"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_index) - 12usize];
    ["Offset of field: ifa_msghdr::ifam_metric"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_metric) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifma_msghdr {
    pub ifmam_msglen: ::std::os::raw::c_ushort,
    pub ifmam_version: ::std::os::raw::c_uchar,
    pub ifmam_type: ::std::os::raw::c_uchar,
    pub ifmam_addrs: ::std::os::raw::c_int,
    pub ifmam_flags: ::std::os::raw::c_int,
    pub ifmam_index: ::std::os::raw::c_ushort,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifma_msghdr"][::std::mem::size_of::<ifma_msghdr>() - 16usize];
    ["Alignment of ifma_msghdr"][::std::mem::align_of::<ifma_msghdr>() - 4usize];
    ["Offset of field: ifma_msghdr::ifmam_msglen"]
        [::std::mem::offset_of!(ifma_msghdr, ifmam_msglen) - 0usize];
    ["Offset of field: ifma_msghdr::ifmam_version"]
        [::std::mem::offset_of!(ifma_msghdr, ifmam_version) - 2usize];
    ["Offset of field: ifma_msghdr::ifmam_type"]
        [::std::mem::offset_of!(ifma_msghdr, ifmam_type) - 3usize];
    ["Offset of field: ifma_msghdr::ifmam_addrs"]
        [::std::mem::offset_of!(ifma_msghdr, ifmam_addrs) - 4usize];
    ["Offset of field: ifma_msghdr::ifmam_flags"]
        [::std::mem::offset_of!(ifma_msghdr, ifmam_flags) - 8usize];
    ["Offset of field: ifma_msghdr::ifmam_index"]
        [::std::mem::offset_of!(ifma_msghdr, ifmam_index) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_msghdr2 {
    pub ifm_msglen: u_short,
    pub ifm_version: u_char,
    pub ifm_type: u_char,
    pub ifm_addrs: ::std::os::raw::c_int,
    pub ifm_flags: ::std::os::raw::c_int,
    pub ifm_index: u_short,
    pub ifm_snd_len: ::std::os::raw::c_int,
    pub ifm_snd_maxlen: ::std::os::raw::c_int,
    pub ifm_snd_drops: ::std::os::raw::c_int,
    pub ifm_timer: ::std::os::raw::c_int,
    pub ifm_data: if_data64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_msghdr2"][::std::mem::size_of::<if_msghdr2>() - 160usize];
    ["Alignment of if_msghdr2"][::std::mem::align_of::<if_msghdr2>() - 4usize];
    ["Offset of field: if_msghdr2::ifm_msglen"]
        [::std::mem::offset_of!(if_msghdr2, ifm_msglen) - 0usize];
    ["Offset of field: if_msghdr2::ifm_version"]
        [::std::mem::offset_of!(if_msghdr2, ifm_version) - 2usize];
    ["Offset of field: if_msghdr2::ifm_type"]
        [::std::mem::offset_of!(if_msghdr2, ifm_type) - 3usize];
    ["Offset of field: if_msghdr2::ifm_addrs"]
        [::std::mem::offset_of!(if_msghdr2, ifm_addrs) - 4usize];
    ["Offset of field: if_msghdr2::ifm_flags"]
        [::std::mem::offset_of!(if_msghdr2, ifm_flags) - 8usize];
    ["Offset of field: if_msghdr2::ifm_index"]
        [::std::mem::offset_of!(if_msghdr2, ifm_index) - 12usize];
    ["Offset of field: if_msghdr2::ifm_snd_len"]
        [::std::mem::offset_of!(if_msghdr2, ifm_snd_len) - 16usize];
    ["Offset of field: if_msghdr2::ifm_snd_maxlen"]
        [::std::mem::offset_of!(if_msghdr2, ifm_snd_maxlen) - 20usize];
    ["Offset of field: if_msghdr2::ifm_snd_drops"]
        [::std::mem::offset_of!(if_msghdr2, ifm_snd_drops) - 24usize];
    ["Offset of field: if_msghdr2::ifm_timer"]
        [::std::mem::offset_of!(if_msghdr2, ifm_timer) - 28usize];
    ["Offset of field: if_msghdr2::ifm_data"]
        [::std::mem::offset_of!(if_msghdr2, ifm_data) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifma_msghdr2 {
    pub ifmam_msglen: u_short,
    pub ifmam_version: u_char,
    pub ifmam_type: u_char,
    pub ifmam_addrs: ::std::os::raw::c_int,
    pub ifmam_flags: ::std::os::raw::c_int,
    pub ifmam_index: u_short,
    pub ifmam_refcount: i32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifma_msghdr2"][::std::mem::size_of::<ifma_msghdr2>() - 20usize];
    ["Alignment of ifma_msghdr2"][::std::mem::align_of::<ifma_msghdr2>() - 4usize];
    ["Offset of field: ifma_msghdr2::ifmam_msglen"]
        [::std::mem::offset_of!(ifma_msghdr2, ifmam_msglen) - 0usize];
    ["Offset of field: ifma_msghdr2::ifmam_version"]
        [::std::mem::offset_of!(ifma_msghdr2, ifmam_version) - 2usize];
    ["Offset of field: ifma_msghdr2::ifmam_type"]
        [::std::mem::offset_of!(ifma_msghdr2, ifmam_type) - 3usize];
    ["Offset of field: ifma_msghdr2::ifmam_addrs"]
        [::std::mem::offset_of!(ifma_msghdr2, ifmam_addrs) - 4usize];
    ["Offset of field: ifma_msghdr2::ifmam_flags"]
        [::std::mem::offset_of!(ifma_msghdr2, ifmam_flags) - 8usize];
    ["Offset of field: ifma_msghdr2::ifmam_index"]
        [::std::mem::offset_of!(ifma_msghdr2, ifmam_index) - 12usize];
    ["Offset of field: ifma_msghdr2::ifmam_refcount"]
        [::std::mem::offset_of!(ifma_msghdr2, ifmam_refcount) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifdevmtu {
    pub ifdm_current: ::std::os::raw::c_int,
    pub ifdm_min: ::std::os::raw::c_int,
    pub ifdm_max: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifdevmtu"][::std::mem::size_of::<ifdevmtu>() - 12usize];
    ["Alignment of ifdevmtu"][::std::mem::align_of::<ifdevmtu>() - 4usize];
    ["Offset of field: ifdevmtu::ifdm_current"]
        [::std::mem::offset_of!(ifdevmtu, ifdm_current) - 0usize];
    ["Offset of field: ifdevmtu::ifdm_min"][::std::mem::offset_of!(ifdevmtu, ifdm_min) - 4usize];
    ["Offset of field: ifdevmtu::ifdm_max"][::std::mem::offset_of!(ifdevmtu, ifdm_max) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ifkpi {
    pub ifk_module_id: ::std::os::raw::c_uint,
    pub ifk_type: ::std::os::raw::c_uint,
    pub ifk_data: ifkpi__bindgen_ty_1,
}
#[repr(C, packed(4))]
#[derive(Copy, Clone)]
pub union ifkpi__bindgen_ty_1 {
    pub ifk_ptr: *mut ::std::os::raw::c_void,
    pub ifk_value: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifkpi__bindgen_ty_1"][::std::mem::size_of::<ifkpi__bindgen_ty_1>() - 8usize];
    ["Alignment of ifkpi__bindgen_ty_1"][::std::mem::align_of::<ifkpi__bindgen_ty_1>() - 4usize];
    ["Offset of field: ifkpi__bindgen_ty_1::ifk_ptr"]
        [::std::mem::offset_of!(ifkpi__bindgen_ty_1, ifk_ptr) - 0usize];
    ["Offset of field: ifkpi__bindgen_ty_1::ifk_value"]
        [::std::mem::offset_of!(ifkpi__bindgen_ty_1, ifk_value) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifkpi"][::std::mem::size_of::<ifkpi>() - 16usize];
    ["Alignment of ifkpi"][::std::mem::align_of::<ifkpi>() - 4usize];
    ["Offset of field: ifkpi::ifk_module_id"]
        [::std::mem::offset_of!(ifkpi, ifk_module_id) - 0usize];
    ["Offset of field: ifkpi::ifk_type"][::std::mem::offset_of!(ifkpi, ifk_type) - 4usize];
    ["Offset of field: ifkpi::ifk_data"][::std::mem::offset_of!(ifkpi, ifk_data) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ifreq {
    pub ifr_name: [::std::os::raw::c_char; 16usize],
    pub ifr_ifru: ifreq__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ifreq__bindgen_ty_1 {
    pub ifru_addr: sockaddr,
    pub ifru_dstaddr: sockaddr,
    pub ifru_broadaddr: sockaddr,
    pub ifru_flags: ::std::os::raw::c_short,
    pub ifru_metric: ::std::os::raw::c_int,
    pub ifru_mtu: ::std::os::raw::c_int,
    pub ifru_phys: ::std::os::raw::c_int,
    pub ifru_media: ::std::os::raw::c_int,
    pub ifru_intval: ::std::os::raw::c_int,
    pub ifru_data: caddr_t,
    pub ifru_devmtu: ifdevmtu,
    pub ifru_kpi: ifkpi,
    pub ifru_wake_flags: u_int32_t,
    pub ifru_route_refcnt: u_int32_t,
    pub ifru_cap: [::std::os::raw::c_int; 2usize],
    pub ifru_functional_type: u_int32_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifreq__bindgen_ty_1"][::std::mem::size_of::<ifreq__bindgen_ty_1>() - 16usize];
    ["Alignment of ifreq__bindgen_ty_1"][::std::mem::align_of::<ifreq__bindgen_ty_1>() - 8usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_addr"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_addr) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_dstaddr"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_dstaddr) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_broadaddr"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_broadaddr) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_flags"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_flags) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_metric"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_metric) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_mtu"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_mtu) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_phys"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_phys) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_media"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_media) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_intval"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_intval) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_data"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_data) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_devmtu"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_devmtu) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_kpi"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_kpi) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_wake_flags"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_wake_flags) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_route_refcnt"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_route_refcnt) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_cap"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_cap) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_functional_type"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_functional_type) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifreq"][::std::mem::size_of::<ifreq>() - 32usize];
    ["Alignment of ifreq"][::std::mem::align_of::<ifreq>() - 8usize];
    ["Offset of field: ifreq::ifr_name"][::std::mem::offset_of!(ifreq, ifr_name) - 0usize];
    ["Offset of field: ifreq::ifr_ifru"][::std::mem::offset_of!(ifreq, ifr_ifru) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifaliasreq {
    pub ifra_name: [::std::os::raw::c_char; 16usize],
    pub ifra_addr: sockaddr,
    pub ifra_broadaddr: sockaddr,
    pub ifra_mask: sockaddr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifaliasreq"][::std::mem::size_of::<ifaliasreq>() - 64usize];
    ["Alignment of ifaliasreq"][::std::mem::align_of::<ifaliasreq>() - 1usize];
    ["Offset of field: ifaliasreq::ifra_name"]
        [::std::mem::offset_of!(ifaliasreq, ifra_name) - 0usize];
    ["Offset of field: ifaliasreq::ifra_addr"]
        [::std::mem::offset_of!(ifaliasreq, ifra_addr) - 16usize];
    ["Offset of field: ifaliasreq::ifra_broadaddr"]
        [::std::mem::offset_of!(ifaliasreq, ifra_broadaddr) - 32usize];
    ["Offset of field: ifaliasreq::ifra_mask"]
        [::std::mem::offset_of!(ifaliasreq, ifra_mask) - 48usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rslvmulti_req {
    pub sa: *mut sockaddr,
    pub llsa: *mut *mut sockaddr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rslvmulti_req"][::std::mem::size_of::<rslvmulti_req>() - 16usize];
    ["Alignment of rslvmulti_req"][::std::mem::align_of::<rslvmulti_req>() - 8usize];
    ["Offset of field: rslvmulti_req::sa"][::std::mem::offset_of!(rslvmulti_req, sa) - 0usize];
    ["Offset of field: rslvmulti_req::llsa"][::std::mem::offset_of!(rslvmulti_req, llsa) - 8usize];
};
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct ifmediareq {
    pub ifm_name: [::std::os::raw::c_char; 16usize],
    pub ifm_current: ::std::os::raw::c_int,
    pub ifm_mask: ::std::os::raw::c_int,
    pub ifm_status: ::std::os::raw::c_int,
    pub ifm_active: ::std::os::raw::c_int,
    pub ifm_count: ::std::os::raw::c_int,
    pub ifm_ulist: *mut ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifmediareq"][::std::mem::size_of::<ifmediareq>() - 44usize];
    ["Alignment of ifmediareq"][::std::mem::align_of::<ifmediareq>() - 4usize];
    ["Offset of field: ifmediareq::ifm_name"]
        [::std::mem::offset_of!(ifmediareq, ifm_name) - 0usize];
    ["Offset of field: ifmediareq::ifm_current"]
        [::std::mem::offset_of!(ifmediareq, ifm_current) - 16usize];
    ["Offset of field: ifmediareq::ifm_mask"]
        [::std::mem::offset_of!(ifmediareq, ifm_mask) - 20usize];
    ["Offset of field: ifmediareq::ifm_status"]
        [::std::mem::offset_of!(ifmediareq, ifm_status) - 24usize];
    ["Offset of field: ifmediareq::ifm_active"]
        [::std::mem::offset_of!(ifmediareq, ifm_active) - 28usize];
    ["Offset of field: ifmediareq::ifm_count"]
        [::std::mem::offset_of!(ifmediareq, ifm_count) - 32usize];
    ["Offset of field: ifmediareq::ifm_ulist"]
        [::std::mem::offset_of!(ifmediareq, ifm_ulist) - 36usize];
};
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct ifdrv {
    pub ifd_name: [::std::os::raw::c_char; 16usize],
    pub ifd_cmd: ::std::os::raw::c_ulong,
    pub ifd_len: usize,
    pub ifd_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifdrv"][::std::mem::size_of::<ifdrv>() - 40usize];
    ["Alignment of ifdrv"][::std::mem::align_of::<ifdrv>() - 4usize];
    ["Offset of field: ifdrv::ifd_name"][::std::mem::offset_of!(ifdrv, ifd_name) - 0usize];
    ["Offset of field: ifdrv::ifd_cmd"][::std::mem::offset_of!(ifdrv, ifd_cmd) - 16usize];
    ["Offset of field: ifdrv::ifd_len"][::std::mem::offset_of!(ifdrv, ifd_len) - 24usize];
    ["Offset of field: ifdrv::ifd_data"][::std::mem::offset_of!(ifdrv, ifd_data) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifstat {
    pub ifs_name: [::std::os::raw::c_char; 16usize],
    pub ascii: [::std::os::raw::c_char; 801usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifstat"][::std::mem::size_of::<ifstat>() - 817usize];
    ["Alignment of ifstat"][::std::mem::align_of::<ifstat>() - 1usize];
    ["Offset of field: ifstat::ifs_name"][::std::mem::offset_of!(ifstat, ifs_name) - 0usize];
    ["Offset of field: ifstat::ascii"][::std::mem::offset_of!(ifstat, ascii) - 16usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ifconf {
    pub ifc_len: ::std::os::raw::c_int,
    pub ifc_ifcu: ifconf__bindgen_ty_1,
}
#[repr(C, packed(4))]
#[derive(Copy, Clone)]
pub union ifconf__bindgen_ty_1 {
    pub ifcu_buf: caddr_t,
    pub ifcu_req: *mut ifreq,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifconf__bindgen_ty_1"][::std::mem::size_of::<ifconf__bindgen_ty_1>() - 8usize];
    ["Alignment of ifconf__bindgen_ty_1"][::std::mem::align_of::<ifconf__bindgen_ty_1>() - 4usize];
    ["Offset of field: ifconf__bindgen_ty_1::ifcu_buf"]
        [::std::mem::offset_of!(ifconf__bindgen_ty_1, ifcu_buf) - 0usize];
    ["Offset of field: ifconf__bindgen_ty_1::ifcu_req"]
        [::std::mem::offset_of!(ifconf__bindgen_ty_1, ifcu_req) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifconf"][::std::mem::size_of::<ifconf>() - 12usize];
    ["Alignment of ifconf"][::std::mem::align_of::<ifconf>() - 4usize];
    ["Offset of field: ifconf::ifc_len"][::std::mem::offset_of!(ifconf, ifc_len) - 0usize];
    ["Offset of field: ifconf::ifc_ifcu"][::std::mem::offset_of!(ifconf, ifc_ifcu) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kev_dl_proto_data {
    pub link_data: net_event_data,
    pub proto_family: u_int32_t,
    pub proto_remaining_count: u_int32_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kev_dl_proto_data"][::std::mem::size_of::<kev_dl_proto_data>() - 32usize];
    ["Alignment of kev_dl_proto_data"][::std::mem::align_of::<kev_dl_proto_data>() - 4usize];
    ["Offset of field: kev_dl_proto_data::link_data"]
        [::std::mem::offset_of!(kev_dl_proto_data, link_data) - 0usize];
    ["Offset of field: kev_dl_proto_data::proto_family"]
        [::std::mem::offset_of!(kev_dl_proto_data, proto_family) - 24usize];
    ["Offset of field: kev_dl_proto_data::proto_remaining_count"]
        [::std::mem::offset_of!(kev_dl_proto_data, proto_remaining_count) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_nameindex {
    pub if_index: ::std::os::raw::c_uint,
    pub if_name: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_nameindex"][::std::mem::size_of::<if_nameindex>() - 16usize];
    ["Alignment of if_nameindex"][::std::mem::align_of::<if_nameindex>() - 8usize];
    ["Offset of field: if_nameindex::if_index"]
        [::std::mem::offset_of!(if_nameindex, if_index) - 0usize];
    ["Offset of field: if_nameindex::if_name"]
        [::std::mem::offset_of!(if_nameindex, if_name) - 8usize];
};
unsafe extern "C" {
    pub fn if_nametoindex(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn if_indextoname(
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn if_nameindex() -> *mut if_nameindex;
}
unsafe extern "C" {
    pub fn if_freenameindex(arg1: *mut if_nameindex);
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __va_list_tag"][::std::mem::size_of::<__va_list_tag>() - 24usize];
    ["Alignment of __va_list_tag"][::std::mem::align_of::<__va_list_tag>() - 8usize];
    ["Offset of field: __va_list_tag::gp_offset"]
        [::std::mem::offset_of!(__va_list_tag, gp_offset) - 0usize];
    ["Offset of field: __va_list_tag::fp_offset"]
        [::std::mem::offset_of!(__va_list_tag, fp_offset) - 4usize];
    ["Offset of field: __va_list_tag::overflow_arg_area"]
        [::std::mem::offset_of!(__va_list_tag, overflow_arg_area) - 8usize];
    ["Offset of field: __va_list_tag::reg_save_area"]
        [::std::mem::offset_of!(__va_list_tag, reg_save_area) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigacts {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vnode {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct user {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage {
    pub _address: u8,
}
