/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.FormatterDiagnostic;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class FormatterException
extends Exception {
    private final ImmutableList<FormatterDiagnostic> diagnostics;
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\R");

    public FormatterException(String message) {
        this(FormatterDiagnostic.create(message));
    }

    public FormatterException(FormatterDiagnostic diagnostic) {
        this(ImmutableList.of(diagnostic));
    }

    public FormatterException(Iterable<FormatterDiagnostic> diagnostics) {
        super(diagnostics.iterator().next().toString());
        this.diagnostics = ImmutableList.copyOf(diagnostics);
    }

    public List<FormatterDiagnostic> diagnostics() {
        return this.diagnostics;
    }

    public static FormatterException fromJavacDiagnostics(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return new FormatterException(Iterables.transform(diagnostics, FormatterException::toFormatterDiagnostic));
    }

    private static FormatterDiagnostic toFormatterDiagnostic(Diagnostic<?> input) {
        return FormatterDiagnostic.create((int)input.getLineNumber(), (int)input.getColumnNumber(), input.getMessage(Locale.ENGLISH));
    }

    public String formatDiagnostics(String path, String input) {
        List<String> lines = Splitter.on(NEWLINE_PATTERN).splitToList(input);
        StringBuilder sb = new StringBuilder();
        for (FormatterDiagnostic diagnostic : this.diagnostics()) {
            sb.append(path).append(":").append(diagnostic).append(System.lineSeparator());
            int line = diagnostic.line();
            int column = diagnostic.column();
            if (line == -1 || column == -1) continue;
            sb.append(CharMatcher.breakingWhitespace().trimTrailingFrom(lines.get(line - 1))).append(System.lineSeparator());
            sb.append(" ".repeat(column - 1)).append('^').append(System.lineSeparator());
        }
        return sb.toString();
    }
}

