package wopan

import (
	"bytes"
	"crypto/aes"
	"crypto/cipher"
	"errors"
)

// pkcs7Padding 填充
func pkcs7Padding(data []byte, blockSize int) []byte {
	//判断缺少几位长度。最少1，最多 blockSize
	padding := blockSize - len(data)%blockSize
	//补足位数。把切片[]byte{byte(padding)}复制padding个
	padText := bytes.Repeat([]byte{byte(padding)}, padding)
	return append(data, padText...)
}

// pkcs7UnPadding 填充的反向操作
func pkcs7UnPadding(data []byte) ([]byte, error) {
	length := len(data)
	if length == 0 {
		return nil, errors.New("加密字符串错误！")
	}
	//获取填充的个数
	unPadding := int(data[length-1])
	return data[:(length - unPadding)], nil
}

// AesEncrypt 加密
func AesEncrypt(data []byte, key []byte, iv []byte) ([]byte, error) {
	//创建加密实例
	block, err := aes.NewCipher(key)
	if err != nil {
		return nil, err
	}
	//判断加密快的大小
	blockSize := block.BlockSize()
	//填充
	encryptBytes := pkcs7Padding(data, blockSize)
	//初始化加密数据接收切片
	encrypted := make([]byte, len(encryptBytes))
	//使用cbc加密模式
	//blockMode := cipher.NewCBCEncrypter(block, key[:blockSize])
	blockMode := cipher.NewCBCEncrypter(block, iv)
	//执行加密
	blockMode.CryptBlocks(encrypted, encryptBytes)
	return encrypted, nil
}

// AesDecrypt 解密
func AesDecrypt(data []byte, key []byte, iv []byte) ([]byte, error) {
	//创建实例
	block, err := aes.NewCipher(key)
	if err != nil {
		return nil, err
	}
	//获取块的大小
	//blockSize := block.BlockSize()
	//使用cbc
	//blockMode := cipher.NewCBCDecrypter(block, key[:blockSize])
	blockMode := cipher.NewCBCDecrypter(block, iv)
	//初始化解密数据接收切片
	decrypted := make([]byte, len(data))
	//执行解密
	blockMode.CryptBlocks(decrypted, data)
	//去除填充
	decrypted, err = pkcs7UnPadding(decrypted)
	//decrypted = pkcs7Padding(decrypted, blockSize)
	if err != nil {
		return nil, err
	}
	return decrypted, nil
}
