// SPDX-License-Identifier: GPL-2.0 OR CDDL-1.0
/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or https://opensource.org/licenses/CDDL-1.0.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/* Copyright (c) 2023-2025 Chilledheart  */

//go:build freebsd
// +build freebsd

package main

import (
	"golang.org/x/sys/unix"
	"strconv"
	"strings"
)

func getFreebsdABI(defaultABI int) int {
	var utsname unix.Utsname
	err := unix.Uname(&utsname)
	if err != nil {
		return defaultABI
	}
	// kern.osrelease: 11.2-RELEASE-p4
	osrelease := string(utsname.Release[:])
	releases := strings.SplitN(osrelease, "-", 3)
	vers := strings.SplitN(releases[0], ".", 2)
	var ver int
	ver, err = strconv.Atoi(vers[0])
	if err != nil {
		return defaultABI
	}
	return ver
}
