// Copyright 2024 The ohos_hilog_sys Developers
//
// Licensed under the Apache License, Version 2.0, <LICENSE-APACHE or
// http://apache.org/licenses/LICENSE-2.0> or the MIT license <LICENSE-MIT or
// http://opensource.org/licenses/MIT>, at your option. This file may not be
// copied, modified, or distributed except according to those terms.

use std::os::raw;

#[allow(non_camel_case_types)]
pub type c_int = raw::c_int;
#[allow(non_camel_case_types)]
pub type c_uint = raw::c_uint;
#[allow(non_camel_case_types)]
pub type c_char = raw::c_char;

/* automatically generated by rust-bindgen 0.69.2 */

pub const LOG_DOMAIN: u32 = 0;

#[derive(Clone, Copy)]
#[repr(isize)]
pub enum LogType {
    #[allow(non_camel_case_types)]
    LOG_APP = 0
}

#[derive(Clone, Copy)]
#[repr(isize)]
pub enum LogLevel {
    DEBUG = 3,
    INFO = 4,
    WARN = 5,
    ERROR = 6,
    FATAL = 7,
}

#[link(name = "hilog_ndk.z")]
extern "C" {
    pub fn OH_LOG_Print(
        type_: LogType,
        level: LogLevel,
        domain: c_uint,
        tag: *const c_char,
        fmt: *const c_char,
        ...
    ) -> c_int;
    pub fn OH_LOG_IsLoggable(
        domain: c_uint,
        tag: *const c_char,
        level: LogLevel,
    ) -> bool;
}
