set(CMAKE_SYSTEM_NAME "Linux")
set(CMAKE_SYSTEM_PROCESSOR "${GCC_SYSTEM_PROCESSOR}" CACHE STRING "")
set(CMAKE_C_COMPILER_TARGET "${GCC_TARGET}" CACHE STRING "")
set(CMAKE_CXX_COMPILER_TARGET "${GCC_TARGET}" CACHE STRING "")
set(CMAKE_ASM_COMPILER_TARGET "${GCC_TARGET}" CACHE STRING "")

set(CMAKE_AR "${LLVM_SYSROOT}/bin/llvm-ar" CACHE FILEPATH "")
set(CMAKE_CXX_COMPILER_AR "${LLVM_SYSROOT}/bin/llvm-ar" CACHE FILEPATH "")
set(CMAKE_RANLIB "${LLVM_SYSROOT}/bin/llvm-ranlib" CACHE FILEPATH "")
set(CMAKE_CXX_COMPILER_RANLIB "${LLVM_SYSROOT}/bin/llvm-ranlib" CACHE FILEPATH "")

set(CMAKE_SYSROOT "${GCC_SYSROOT}" CACHE STRING "")

if (ENABLE_LLD)
  file(GLOB _GCC_SYSROOT "${CMAKE_SYSROOT}/lib/gcc/*/*.*.*")
  # fix up for loongarch sysroot
  if (CMAKE_SYSTEM_PROCESSOR STREQUAL "loongarch64")
    file(GLOB _GCC_SYSROOT "${CMAKE_SYSROOT}/../../lib/gcc/*/*.*.*")
    # required by loongarch64 sdk https://github.com/loongson/build-tools/releases
    if (NOT _GCC_SYSROOT)
      file(GLOB _GCC_SYSROOT "${CMAKE_SYSROOT}/../lib/gcc/*/*.*.*")
    endif()
  endif()
  # fix up for riscv64 and riscv32 sysroot
  if (CMAKE_SYSTEM_PROCESSOR MATCHES "riscv.*")
    file(GLOB _GCC_SYSROOT "${CMAKE_SYSROOT}/../lib/gcc/*/*.*.*")
  endif()
  # fix up for raw sysroot from docker
  if (NOT _GCC_SYSROOT)
    file(GLOB _GCC_SYSROOT "${CMAKE_SYSROOT}/usr/lib/gcc/*/*.*.*")
  endif()
  if (_GCC_SYSROOT)
    set(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} --gcc-install-dir=${_GCC_SYSROOT}")
    set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} --gcc-install-dir=${_GCC_SYSROOT}")
    set(CMAKE_REQUIRED_LINK_OPTIONS ${CMAKE_REQUIRED_LINK_OPTIONS} --gcc-install-dir=${_GCC_SYSROOT})
  endif()

  set(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} -fuse-ld=lld")
  set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -fuse-ld=lld")
  set(CMAKE_REQUIRED_LINK_OPTIONS ${CMAKE_REQUIRED_LINK_OPTIONS} -fuse-ld=lld)

  # see https://github.com/hukeyue/yass/actions/runs/17764358948/
  if (CMAKE_SYSTEM_PROCESSOR MATCHES "mips.*")
    set(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} -Wl,-z,execstack")
    set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -Wl,-z,execstack")
    set(CMAKE_REQUIRED_LINK_OPTIONS ${CMAKE_REQUIRED_LINK_OPTIONS} -Wl,-z,execstack)
  endif()
endif()

set(COMPILE_FLAGS)

if (ASM_CPU)
  list(APPEND COMPILE_FLAGS -mcpu=${ARM_CPU})
endif()

string(REPLACE ";" " " COMPILE_FLAGS "${COMPILE_FLAGS}")

set(_CMAKE_ASM_FLAGS_INITIAL "${CMAKE_ASM_FLAGS}" CACHE STRING "")
set(CMAKE_ASM_FLAGS "${_CMAKE_ASM_FLAGS_INITIAL} ${COMPILE_FLAGS}" CACHE STRING "" FORCE)

set(_CMAKE_C_FLAGS_INITIAL "${CMAKE_C_FLAGS}" CACHE STRING "")
set(CMAKE_C_FLAGS "${_CMAKE_C_FLAGS_INITIAL} ${COMPILE_FLAGS}" CACHE STRING "" FORCE)

set(_CMAKE_CXX_FLAGS_INITIAL "${CMAKE_CXX_FLAGS}" CACHE STRING "")
set(CMAKE_CXX_FLAGS "${_CMAKE_CXX_FLAGS_INITIAL} ${COMPILE_FLAGS}" CACHE STRING "" FORCE)

# target environment on the build host system
set(CMAKE_FIND_ROOT_PATH ${GCC_SYSROOT})

# modify default behavior of FIND_XXX() commands
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_PACKAGE ONLY)
