/* automatically generated by rust-bindgen 0.72.0 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val { byte | mask } else { byte & !mask }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const BSD: u32 = 199506;
pub const BSD4_3: u32 = 1;
pub const BSD4_4: u32 = 1;
pub const __NetBSD_Version__: u32 = 1001000000;
pub const NetBSD: u32 = 199905;
pub const WCHAR_MIN: i32 = -2147483648;
pub const WCHAR_MAX: u32 = 2147483647;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const _NETBSD_SOURCE: u32 = 1;
pub const __SIMPLELOCK_LOCKED: u32 = 1;
pub const __SIMPLELOCK_UNLOCKED: u32 = 0;
pub const _LITTLE_ENDIAN: u32 = 1234;
pub const _BIG_ENDIAN: u32 = 4321;
pub const _PDP_ENDIAN: u32 = 3412;
pub const _BYTE_ORDER: u32 = 1234;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const NODEVMAJOR: i32 = -1;
pub const __NFDBITS: u32 = 32;
pub const __NFDSHIFT: u32 = 5;
pub const __NFDMASK: u32 = 31;
pub const FD_SETSIZE: u32 = 256;
pub const NFDBITS: u32 = 32;
pub const NBBY: u32 = 8;
pub const _PT_MUTEX_MAGIC: u32 = 858980355;
pub const _PT_MUTEX_DEAD: u32 = 3735879683;
pub const _PT_MUTEXATTR_MAGIC: u32 = 1145307140;
pub const _PT_MUTEXATTR_DEAD: u32 = 3735879684;
pub const _PT_COND_MAGIC: u32 = 1431633925;
pub const _PT_COND_DEAD: u32 = 3735879685;
pub const _PT_CONDATTR_MAGIC: u32 = 1717960710;
pub const _PT_CONDATTR_DEAD: u32 = 3735879686;
pub const _PT_SPINLOCK_MAGIC: u32 = 2004287495;
pub const _PT_SPINLOCK_DEAD: u32 = 3735879687;
pub const _PT_SPINLOCK_PSHARED: u32 = 1;
pub const _PT_RWLOCK_MAGIC: u32 = 2576941065;
pub const _PT_RWLOCK_DEAD: u32 = 3735879689;
pub const _PT_RWLOCKATTR_MAGIC: u32 = 2576943369;
pub const _PT_RWLOCKATTR_DEAD: u32 = 3735881993;
pub const _PT_BARRIER_MAGIC: u32 = 2290614280;
pub const _PT_BARRIER_DEAD: u32 = 3735879688;
pub const _PT_BARRIERATTR_MAGIC: u32 = 2290616328;
pub const _PT_BARRIERATTR_DEAD: u32 = 3735881736;
pub const ARG_MAX: u32 = 262144;
pub const CHILD_MAX: u32 = 160;
pub const GID_MAX: u32 = 2147483647;
pub const LINK_MAX: u32 = 32767;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 511;
pub const NGROUPS_MAX: u32 = 16;
pub const UID_MAX: u32 = 2147483647;
pub const OPEN_MAX: u32 = 128;
pub const PATH_MAX: u32 = 1024;
pub const PIPE_BUF: u32 = 512;
pub const BC_DIM_MAX: u32 = 65535;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 255;
pub const LOGIN_NAME_MAX: u32 = 17;
pub const IOV_MAX: u32 = 1024;
pub const NZERO: u32 = 20;
pub const MAXCOMLEN: u32 = 16;
pub const MAXINTERP: u32 = 1024;
pub const MAXLOGNAME: u32 = 16;
pub const NCARGS: u32 = 262144;
pub const NGROUPS: u32 = 16;
pub const NOGROUP: u32 = 65535;
pub const MAXHOSTNAMELEN: u32 = 256;
pub const NOFILE: u32 = 128;
pub const MAXUPRC: u32 = 160;
pub const MAXCPUS: u32 = 256;
pub const MACHINE: &[u8; 6] = b"amd64\0";
pub const MACHINE_ARCH: &[u8; 7] = b"x86_64\0";
pub const STACK_ALIGNBYTES: u32 = 15;
pub const PGSHIFT: u32 = 12;
pub const NBPG: u32 = 4096;
pub const PGOFSET: u32 = 4095;
pub const MAXIOMEM: u64 = 281474976710655;
pub const MAXPHYSMEM: u64 = 17592186044416;
pub const KERNBASE: i32 = -2147483648;
pub const KERNTEXTOFF: i32 = -2145386496;
pub const KERNTEXTOFF_HI: u32 = 4294967295;
pub const KERNTEXTOFF_LO: u32 = 2149580800;
pub const KERNBASE_HI: u32 = 4294967295;
pub const KERNBASE_LO: u32 = 2147483648;
pub const SSIZE: u32 = 1;
pub const SINCR: u32 = 1;
pub const UPAGES: u32 = 5;
pub const USPACE: u32 = 20480;
pub const MSGBUFSIZE: u32 = 65536;
pub const MSIZE: u32 = 512;
pub const MCLSHIFT: u32 = 11;
pub const MCLBYTES: u32 = 2048;
pub const NFS_RSIZE: u32 = 32768;
pub const NFS_WSIZE: u32 = 32768;
pub const NKMEMPAGES_MAX_UNLIMITED: u32 = 1;
pub const CHAR_BIT: u32 = 8;
pub const UCHAR_MAX: u32 = 255;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: i32 = -1;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const SSIZE_MIN: i64 = -9223372036854775808;
pub const SIZE_T_MAX: i32 = -1;
pub const UQUAD_MAX: i32 = -1;
pub const QUAD_MAX: u64 = 9223372036854775807;
pub const QUAD_MIN: i64 = -9223372036854775808;
pub const LONG_BIT: u32 = 64;
pub const WORD_BIT: u32 = 32;
pub const COHERENCY_UNIT: u32 = 64;
pub const CACHE_LINE_SIZE: u32 = 64;
pub const _NSIG: u32 = 64;
pub const NSIG: u32 = 64;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const SIGPWR: u32 = 32;
pub const SIGRTMIN: u32 = 33;
pub const SIGRTMAX: u32 = 63;
pub const T_PRIVINFLT: u32 = 0;
pub const T_BPTFLT: u32 = 1;
pub const T_ARITHTRAP: u32 = 2;
pub const T_ASTFLT: u32 = 3;
pub const T_PROTFLT: u32 = 4;
pub const T_TRCTRAP: u32 = 5;
pub const T_PAGEFLT: u32 = 6;
pub const T_ALIGNFLT: u32 = 7;
pub const T_DIVIDE: u32 = 8;
pub const T_NMI: u32 = 9;
pub const T_OFLOW: u32 = 10;
pub const T_BOUND: u32 = 11;
pub const T_DNA: u32 = 12;
pub const T_DOUBLEFLT: u32 = 13;
pub const T_FPOPFLT: u32 = 14;
pub const T_TSSFLT: u32 = 15;
pub const T_SEGNPFLT: u32 = 16;
pub const T_STKFLT: u32 = 17;
pub const T_MCA: u32 = 18;
pub const T_XMM: u32 = 19;
pub const T_RESERVED: u32 = 20;
pub const T_USER: u32 = 256;
pub const TC_TSS: u32 = 2147483648;
pub const TC_FLAGMASK: u32 = 2147483648;
pub const _UC_UCONTEXT_ALIGN: i32 = -16;
pub const _UC_TLSBASE: u32 = 524288;
pub const _UC_SETSTACK: u32 = 65536;
pub const _UC_CLRSTACK: u32 = 131072;
pub const __UCONTEXT_SIZE: u32 = 784;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLOPN: u32 = 2;
pub const ILL_ILLADR: u32 = 3;
pub const ILL_ILLTRP: u32 = 4;
pub const ILL_PRVOPC: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_INTDIV: u32 = 1;
pub const FPE_INTOVF: u32 = 2;
pub const FPE_FLTDIV: u32 = 3;
pub const FPE_FLTOVF: u32 = 4;
pub const FPE_FLTUND: u32 = 5;
pub const FPE_FLTRES: u32 = 6;
pub const FPE_FLTINV: u32 = 7;
pub const FPE_FLTSUB: u32 = 8;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const TRAP_EXEC: u32 = 3;
pub const TRAP_CHLD: u32 = 4;
pub const TRAP_LWP: u32 = 5;
pub const TRAP_DBREG: u32 = 6;
pub const TRAP_SCE: u32 = 7;
pub const TRAP_SCX: u32 = 8;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SI_USER: u32 = 0;
pub const SI_QUEUE: i32 = -1;
pub const SI_TIMER: i32 = -2;
pub const SI_ASYNCIO: i32 = -3;
pub const SI_MESGQ: i32 = -4;
pub const SI_LWP: i32 = -5;
pub const SI_NOINFO: u32 = 32767;
pub const _UC_SIGMASK: u32 = 1;
pub const _UC_STACK: u32 = 2;
pub const _UC_CPU: u32 = 4;
pub const _UC_FPU: u32 = 8;
pub const _UC_MD: u32 = 1074724896;
pub const __SIGTRAMP_SIGCODE_VERSION: u32 = 0;
pub const __SIGTRAMP_SIGCONTEXT_VERSION_MIN: u32 = 1;
pub const __SIGTRAMP_SIGCONTEXT_VERSION_MAX: u32 = 1;
pub const __SIGTRAMP_SIGCONTEXT_VERSION: u32 = 1;
pub const __SIGTRAMP_SIGINFO_VERSION_MIN: u32 = 2;
pub const __SIGTRAMP_SIGINFO_VERSION_MAX: u32 = 2;
pub const __SIGTRAMP_SIGINFO_VERSION: u32 = 2;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_NOKERNINFO: u32 = 128;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 8192;
pub const SIGSTKSZ: u32 = 40960;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 2;
pub const SIGEV_SA: u32 = 3;
pub const DEV_BSHIFT: u32 = 9;
pub const DEV_BSIZE: u32 = 512;
pub const BLKDEV_IOSIZE: u32 = 2048;
pub const MAXPHYS: u32 = 65536;
pub const MAX_LWP_PER_PROC: u32 = 8000;
pub const PSWP: u32 = 0;
pub const PVM: u32 = 4;
pub const PINOD: u32 = 8;
pub const PRIBIO: u32 = 16;
pub const PVFS: u32 = 20;
pub const PZERO: u32 = 22;
pub const PSOCK: u32 = 24;
pub const PWAIT: u32 = 32;
pub const PLOCK: u32 = 36;
pub const PPAUSE: u32 = 40;
pub const PUSER: u32 = 50;
pub const MAXPRI: u32 = 127;
pub const PCATCH: u32 = 256;
pub const PNORELOCK: u32 = 512;
pub const PRI_COUNT: u32 = 224;
pub const PRI_NONE: i32 = -1;
pub const PRI_KERNEL_RT: u32 = 192;
pub const NPRI_KERNEL_RT: u32 = 32;
pub const MAXPRI_KERNEL_RT: u32 = 223;
pub const PRI_USER_RT: u32 = 128;
pub const NPRI_USER_RT: u32 = 64;
pub const MAXPRI_USER_RT: u32 = 191;
pub const PRI_KTHREAD: u32 = 96;
pub const NPRI_KTHREAD: u32 = 32;
pub const MAXPRI_KTHREAD: u32 = 127;
pub const PRI_KERNEL: u32 = 64;
pub const NPRI_KERNEL: u32 = 32;
pub const MAXPRI_KERNEL: u32 = 95;
pub const PRI_USER: u32 = 0;
pub const NPRI_USER: u32 = 64;
pub const MAXPRI_USER: u32 = 63;
pub const SCHED_PRI_MIN: u32 = 0;
pub const SCHED_PRI_MAX: u32 = 63;
pub const PRI_SOFTSERIAL: u32 = 223;
pub const PRI_XCALL: u32 = 127;
pub const PRI_IDLE: u32 = 0;
pub const CMASK: u32 = 18;
pub const MAXBSIZE: u32 = 65536;
pub const MAXFRAG: u32 = 8;
pub const MAXPATHLEN: u32 = 1024;
pub const MAXSYMLINKS: u32 = 32;
pub const KERNEL_NAME_MAX: u32 = 255;
pub const MINBUCKET: u32 = 5;
pub const MAXALLOCSAVE: u32 = 8192;
pub const FSHIFT: u32 = 11;
pub const FSCALE: u32 = 2048;
pub const MAXSLP: u32 = 20;
pub const UBC_WINSHIFT: u32 = 13;
pub const UBC_NWINS: u32 = 1024;
pub const MIN_LWP_ALIGNMENT: u32 = 64;
pub const LW_IDLE: u32 = 1;
pub const LW_LWPCTL: u32 = 2;
pub const LW_STIMO: u32 = 64;
pub const LW_SINTR: u32 = 128;
pub const LW_CATCHINTR: u32 = 256;
pub const LW_SYSTEM: u32 = 512;
pub const LW_SYSTEM_FPU: u32 = 1024;
pub const LW_DBGSUSPEND: u32 = 65536;
pub const LW_WSUSPEND: u32 = 131072;
pub const LW_BATCH: u32 = 262144;
pub const LW_WCORE: u32 = 524288;
pub const LW_WEXIT: u32 = 1048576;
pub const LW_PENDSIG: u32 = 16777216;
pub const LW_CANCELLED: u32 = 33554432;
pub const LW_WREBOOT: u32 = 134217728;
pub const LW_UNPARKED: u32 = 268435456;
pub const LW_RUMP_CLEAR: u32 = 1073741824;
pub const LW_RUMP_QEXIT: u32 = 2147483648;
pub const LP_KTRACTIVE: u32 = 1;
pub const LP_KTRCSW: u32 = 2;
pub const LP_KTRCSWUSER: u32 = 4;
pub const LP_OWEUPC: u32 = 16;
pub const LP_MPSAFE: u32 = 32;
pub const LP_INTR: u32 = 64;
pub const LP_SYSCTLWRITE: u32 = 128;
pub const LP_MUSTJOIN: u32 = 256;
pub const LP_SINGLESTEP: u32 = 1024;
pub const LP_TIMEINTR: u32 = 65536;
pub const LP_PREEMPTING: u32 = 131072;
pub const LP_RUNNING: u32 = 536870912;
pub const LP_TELEPORT: u32 = 1073741824;
pub const LP_BOUND: u32 = 2147483648;
pub const LPR_DETACHED: u32 = 8388608;
pub const LPR_CRMOD: u32 = 256;
pub const LPR_DRAINING: u32 = 2147483648;
pub const LW_USERRET: u32 = 152698882;
pub const LSIDL: u32 = 1;
pub const LSRUN: u32 = 2;
pub const LSSLEEP: u32 = 3;
pub const LSSTOP: u32 = 4;
pub const LSZOMB: u32 = 5;
pub const LSONPROC: u32 = 7;
pub const LSSUSPENDED: u32 = 8;
pub const LWP_DETACHED: u32 = 64;
pub const LWP_SUSPENDED: u32 = 128;
pub const LWP_VFORK: u32 = 2147483648;
pub const SIDL: u32 = 1;
pub const SACTIVE: u32 = 2;
pub const SDYING: u32 = 3;
pub const SSTOP: u32 = 4;
pub const SZOMB: u32 = 5;
pub const SDEAD: u32 = 6;
pub const PK_ADVLOCK: u32 = 1;
pub const PK_SYSTEM: u32 = 2;
pub const PK_SYSVSEM: u32 = 4;
pub const PK_SUGID: u32 = 256;
pub const PK_KMEM: u32 = 512;
pub const PK_EXEC: u32 = 16384;
pub const PK_NOCLDWAIT: u32 = 131072;
pub const PK_32: u32 = 262144;
pub const PK_CLDSIGIGN: u32 = 524288;
pub const PK_MARKER: u32 = 2147483648;
pub const PS_NOCLDSTOP: u32 = 8;
pub const PS_RUMP_LWPEXIT: u32 = 1024;
pub const PS_WCORE: u32 = 4096;
pub const PS_WEXIT: u32 = 8192;
pub const PS_STOPFORK: u32 = 8388608;
pub const PS_STOPEXEC: u32 = 16777216;
pub const PS_STOPEXIT: u32 = 33554432;
pub const PS_COREDUMP: u32 = 536870912;
pub const PS_CONTINUED: u32 = 1073741824;
pub const PS_STOPPING: u32 = 2147483648;
pub const PSL_TRACEFORK: u32 = 1;
pub const PSL_TRACEVFORK: u32 = 2;
pub const PSL_TRACEVFORK_DONE: u32 = 4;
pub const PSL_TRACELWP_CREATE: u32 = 8;
pub const PSL_TRACELWP_EXIT: u32 = 16;
pub const PSL_TRACEPOSIX_SPAWN: u32 = 32;
pub const PSL_TRACED: u32 = 2048;
pub const PSL_TRACEDCHILD: u32 = 4096;
pub const PSL_CHTRACED: u32 = 4194304;
pub const PSL_SYSCALL: u32 = 67108864;
pub const PSL_SYSCALLEMU: u32 = 134217728;
pub const PST_PROFIL: u32 = 32;
pub const PL_CONTROLT: u32 = 2;
pub const PL_PPWAIT: u32 = 16;
pub const PL_SIGCOMPAT: u32 = 512;
pub const PL_ORPHANPG: u32 = 536870912;
pub const VM_METER: u32 = 1;
pub const VM_LOADAVG: u32 = 2;
pub const VM_UVMEXP: u32 = 3;
pub const VM_NKMEMPAGES: u32 = 4;
pub const VM_UVMEXP2: u32 = 5;
pub const VM_ANONMIN: u32 = 6;
pub const VM_EXECMIN: u32 = 7;
pub const VM_FILEMIN: u32 = 8;
pub const VM_MAXSLP: u32 = 9;
pub const VM_USPACE: u32 = 10;
pub const VM_ANONMAX: u32 = 11;
pub const VM_EXECMAX: u32 = 12;
pub const VM_FILEMAX: u32 = 13;
pub const VM_MINADDRESS: u32 = 14;
pub const VM_MAXADDRESS: u32 = 15;
pub const VM_PROC: u32 = 16;
pub const VM_GUARD_SIZE: u32 = 17;
pub const VM_THREAD_GUARD_SIZE: u32 = 18;
pub const VM_PROC_MAP: u32 = 1;
pub const __bool_true_false_are_defined: u32 = 1;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const CTL_MAXNAME: u32 = 12;
pub const SYSCTL_NAMELEN: u32 = 32;
pub const CREATE_BASE: u32 = 1024;
pub const SYSCTL_DEFSIZE: u32 = 8;
pub const CTLTYPE_NODE: u32 = 1;
pub const CTLTYPE_INT: u32 = 2;
pub const CTLTYPE_STRING: u32 = 3;
pub const CTLTYPE_QUAD: u32 = 4;
pub const CTLTYPE_STRUCT: u32 = 5;
pub const CTLTYPE_BOOL: u32 = 6;
pub const CTLTYPE_LONG: u32 = 4;
pub const CTLFLAG_READONLY: u32 = 0;
pub const CTLFLAG_READWRITE: u32 = 112;
pub const CTLFLAG_ANYWRITE: u32 = 128;
pub const CTLFLAG_PRIVATE: u32 = 256;
pub const CTLFLAG_PERMANENT: u32 = 512;
pub const CTLFLAG_OWNDATA: u32 = 1024;
pub const CTLFLAG_IMMEDIATE: u32 = 2048;
pub const CTLFLAG_HEX: u32 = 4096;
pub const CTLFLAG_ROOT: u32 = 8192;
pub const CTLFLAG_ANYNUMBER: u32 = 16384;
pub const CTLFLAG_HIDDEN: u32 = 32768;
pub const CTLFLAG_ALIAS: u32 = 65536;
pub const CTLFLAG_MMAP: u32 = 131072;
pub const CTLFLAG_OWNDESC: u32 = 262144;
pub const CTLFLAG_UNSIGNED: u32 = 524288;
pub const SYSCTL_VERS_MASK: u32 = 4278190080;
pub const SYSCTL_VERS_0: u32 = 0;
pub const SYSCTL_VERS_1: u32 = 16777216;
pub const SYSCTL_VERSION: u32 = 16777216;
pub const SYSCTL_USERFLAGS: u32 = 40432;
pub const SYSCTL_TYPEMASK: u32 = 15;
pub const SYSCTL_FLAGMASK: u32 = 16777200;
pub const CTL_EOL: i32 = -1;
pub const CTL_QUERY: i32 = -2;
pub const CTL_CREATE: i32 = -3;
pub const CTL_CREATESYM: i32 = -4;
pub const CTL_DESTROY: i32 = -5;
pub const CTL_MMAP: i32 = -6;
pub const CTL_DESCRIBE: i32 = -7;
pub const CTL_UNSPEC: u32 = 0;
pub const CTL_KERN: u32 = 1;
pub const CTL_VM: u32 = 2;
pub const CTL_VFS: u32 = 3;
pub const CTL_NET: u32 = 4;
pub const CTL_DEBUG: u32 = 5;
pub const CTL_HW: u32 = 6;
pub const CTL_MACHDEP: u32 = 7;
pub const CTL_USER: u32 = 8;
pub const CTL_DDB: u32 = 9;
pub const CTL_PROC: u32 = 10;
pub const CTL_VENDOR: u32 = 11;
pub const CTL_EMUL: u32 = 12;
pub const CTL_SECURITY: u32 = 13;
pub const KERN_OSTYPE: u32 = 1;
pub const KERN_OSRELEASE: u32 = 2;
pub const KERN_OSREV: u32 = 3;
pub const KERN_VERSION: u32 = 4;
pub const KERN_MAXVNODES: u32 = 5;
pub const KERN_MAXPROC: u32 = 6;
pub const KERN_MAXFILES: u32 = 7;
pub const KERN_ARGMAX: u32 = 8;
pub const KERN_SECURELVL: u32 = 9;
pub const KERN_HOSTNAME: u32 = 10;
pub const KERN_HOSTID: u32 = 11;
pub const KERN_CLOCKRATE: u32 = 12;
pub const KERN_VNODE: u32 = 13;
pub const KERN_PROC: u32 = 14;
pub const KERN_FILE: u32 = 15;
pub const KERN_PROF: u32 = 16;
pub const KERN_POSIX1: u32 = 17;
pub const KERN_NGROUPS: u32 = 18;
pub const KERN_JOB_CONTROL: u32 = 19;
pub const KERN_SAVED_IDS: u32 = 20;
pub const KERN_OBOOTTIME: u32 = 21;
pub const KERN_DOMAINNAME: u32 = 22;
pub const KERN_MAXPARTITIONS: u32 = 23;
pub const KERN_RAWPARTITION: u32 = 24;
pub const KERN_NTPTIME: u32 = 25;
pub const KERN_TIMEX: u32 = 26;
pub const KERN_AUTONICETIME: u32 = 27;
pub const KERN_AUTONICEVAL: u32 = 28;
pub const KERN_RTC_OFFSET: u32 = 29;
pub const KERN_ROOT_DEVICE: u32 = 30;
pub const KERN_MSGBUFSIZE: u32 = 31;
pub const KERN_FSYNC: u32 = 32;
pub const KERN_OLDSYSVMSG: u32 = 33;
pub const KERN_OLDSYSVSEM: u32 = 34;
pub const KERN_OLDSYSVSHM: u32 = 35;
pub const KERN_OLDSHORTCORENAME: u32 = 36;
pub const KERN_SYNCHRONIZED_IO: u32 = 37;
pub const KERN_IOV_MAX: u32 = 38;
pub const KERN_MBUF: u32 = 39;
pub const KERN_MAPPED_FILES: u32 = 40;
pub const KERN_MEMLOCK: u32 = 41;
pub const KERN_MEMLOCK_RANGE: u32 = 42;
pub const KERN_MEMORY_PROTECTION: u32 = 43;
pub const KERN_LOGIN_NAME_MAX: u32 = 44;
pub const KERN_DEFCORENAME: u32 = 45;
pub const KERN_LOGSIGEXIT: u32 = 46;
pub const KERN_PROC2: u32 = 47;
pub const KERN_PROC_ARGS: u32 = 48;
pub const KERN_FSCALE: u32 = 49;
pub const KERN_CCPU: u32 = 50;
pub const KERN_CP_TIME: u32 = 51;
pub const KERN_OLDSYSVIPC_INFO: u32 = 52;
pub const KERN_MSGBUF: u32 = 53;
pub const KERN_CONSDEV: u32 = 54;
pub const KERN_MAXPTYS: u32 = 55;
pub const KERN_PIPE: u32 = 56;
pub const KERN_MAXPHYS: u32 = 57;
pub const KERN_SBMAX: u32 = 58;
pub const KERN_TKSTAT: u32 = 59;
pub const KERN_MONOTONIC_CLOCK: u32 = 60;
pub const KERN_URND: u32 = 61;
pub const KERN_LABELSECTOR: u32 = 62;
pub const KERN_LABELOFFSET: u32 = 63;
pub const KERN_LWP: u32 = 64;
pub const KERN_FORKFSLEEP: u32 = 65;
pub const KERN_POSIX_THREADS: u32 = 66;
pub const KERN_POSIX_SEMAPHORES: u32 = 67;
pub const KERN_POSIX_BARRIERS: u32 = 68;
pub const KERN_POSIX_TIMERS: u32 = 69;
pub const KERN_POSIX_SPIN_LOCKS: u32 = 70;
pub const KERN_POSIX_READER_WRITER_LOCKS: u32 = 71;
pub const KERN_DUMP_ON_PANIC: u32 = 72;
pub const KERN_SOMAXKVA: u32 = 73;
pub const KERN_ROOT_PARTITION: u32 = 74;
pub const KERN_DRIVERS: u32 = 75;
pub const KERN_BUF: u32 = 76;
pub const KERN_FILE2: u32 = 77;
pub const KERN_VERIEXEC: u32 = 78;
pub const KERN_CP_ID: u32 = 79;
pub const KERN_HARDCLOCK_TICKS: u32 = 80;
pub const KERN_ARND: u32 = 81;
pub const KERN_SYSVIPC: u32 = 82;
pub const KERN_BOOTTIME: u32 = 83;
pub const KERN_EVCNT: u32 = 84;
pub const KERN_SOFIXEDBUF: u32 = 85;
pub const KERN_PROC_ALL: u32 = 0;
pub const KERN_PROC_PID: u32 = 1;
pub const KERN_PROC_PGRP: u32 = 2;
pub const KERN_PROC_SESSION: u32 = 3;
pub const KERN_PROC_TTY: u32 = 4;
pub const KERN_PROC_UID: u32 = 5;
pub const KERN_PROC_RUID: u32 = 6;
pub const KERN_PROC_GID: u32 = 7;
pub const KERN_PROC_RGID: u32 = 8;
pub const KI_NGROUPS: u32 = 16;
pub const KI_MAXCOMLEN: u32 = 24;
pub const KI_WMESGLEN: u32 = 8;
pub const KI_MAXLOGNAME: u32 = 24;
pub const KI_MAXEMULLEN: u32 = 16;
pub const KI_LNAMELEN: u32 = 20;
pub const EPROC_CTTY: u32 = 1;
pub const EPROC_SLEADER: u32 = 2;
pub const P_ADVLOCK: u32 = 1;
pub const P_CONTROLT: u32 = 2;
pub const L_INMEM: u32 = 4;
pub const P_INMEM: u32 = 4;
pub const P_NOCLDSTOP: u32 = 8;
pub const P_PPWAIT: u32 = 16;
pub const P_PROFIL: u32 = 32;
pub const L_SELECT: u32 = 64;
pub const P_SELECT: u32 = 64;
pub const L_SINTR: u32 = 128;
pub const P_SINTR: u32 = 128;
pub const P_SUGID: u32 = 256;
pub const L_SYSTEM: u32 = 512;
pub const P_SYSTEM: u32 = 512;
pub const L_SA: u32 = 1024;
pub const P_SA: u32 = 1024;
pub const P_TRACED: u32 = 2048;
pub const P_WAITED: u32 = 4096;
pub const P_WEXIT: u32 = 8192;
pub const P_EXEC: u32 = 16384;
pub const P_OWEUPC: u32 = 32768;
pub const P_NOCLDWAIT: u32 = 131072;
pub const P_32: u32 = 262144;
pub const P_CLDSIGIGN: u32 = 524288;
pub const P_SYSTRACE: u32 = 2097152;
pub const P_CHTRACED: u32 = 4194304;
pub const P_STOPFORK: u32 = 8388608;
pub const P_STOPEXEC: u32 = 16777216;
pub const P_STOPEXIT: u32 = 33554432;
pub const P_SYSCALL: u32 = 67108864;
pub const L_DETACHED: u32 = 8388608;
pub const __SYSCTL_PROC_FLAG_BITS : & [u8 ; 187] = b"\x10\x01ADVLOCK\x02CONTROLT\x03INMEM\x04NOCLDSTOP\x05PPWAIT\x06PROFIL\x07SELECT\x08SINTR\tSUGID\nSYSTEM\x0BSA\x0CTRACED\rWAITED\x0EWEXIT\x0FEXEC\x10OWEUPC\x12NOCLDWAIT\x13P32\x14CLDSIGIGN\x16SYSTRACE\x17CHTRACED\x18STOPFORK\x19STOPEXEC\x1ASTOPEXIT\x1BSYSCALL\0" ;
pub const KERN_PROC_ARGV: u32 = 1;
pub const KERN_PROC_NARGV: u32 = 2;
pub const KERN_PROC_ENV: u32 = 3;
pub const KERN_PROC_NENV: u32 = 4;
pub const KERN_PROC_PATHNAME: u32 = 5;
pub const KERN_PROC_CWD: u32 = 6;
pub const KERN_SYSVIPC_INFO: u32 = 1;
pub const KERN_SYSVIPC_MSG: u32 = 2;
pub const KERN_SYSVIPC_SEM: u32 = 3;
pub const KERN_SYSVIPC_SHM: u32 = 4;
pub const KERN_SYSVIPC_SHMMAX: u32 = 5;
pub const KERN_SYSVIPC_SHMMNI: u32 = 6;
pub const KERN_SYSVIPC_SHMSEG: u32 = 7;
pub const KERN_SYSVIPC_SHMMAXPGS: u32 = 8;
pub const KERN_SYSVIPC_SHMUSEPHYS: u32 = 9;
pub const KERN_SYSVIPC_MSG_INFO: u32 = 4;
pub const KERN_SYSVIPC_SEM_INFO: u32 = 5;
pub const KERN_SYSVIPC_SHM_INFO: u32 = 6;
pub const KERN_TKSTAT_NIN: u32 = 1;
pub const KERN_TKSTAT_NOUT: u32 = 2;
pub const KERN_TKSTAT_CANCC: u32 = 3;
pub const KERN_TKSTAT_RAWCC: u32 = 4;
pub const KERN_BUF_ALL: u32 = 0;
pub const KERN_BUFSLOP: u32 = 20;
pub const KERN_FILE_BYFILE: u32 = 1;
pub const KERN_FILE_BYPID: u32 = 2;
pub const KERN_FILESLOP: u32 = 10;
pub const KERN_EVCNT_COUNT_ANY: u32 = 0;
pub const KERN_EVCNT_COUNT_NONZERO: u32 = 1;
pub const KVME_TYPE_NONE: u32 = 0;
pub const KVME_TYPE_OBJECT: u32 = 1;
pub const KVME_TYPE_VNODE: u32 = 2;
pub const KVME_TYPE_KERN: u32 = 3;
pub const KVME_TYPE_DEVICE: u32 = 4;
pub const KVME_TYPE_ANON: u32 = 5;
pub const KVME_TYPE_SUBMAP: u32 = 6;
pub const KVME_TYPE_UNKNOWN: u32 = 255;
pub const KVME_PROT_READ: u32 = 1;
pub const KVME_PROT_WRITE: u32 = 2;
pub const KVME_PROT_EXEC: u32 = 4;
pub const KVME_FLAG_COW: u32 = 1;
pub const KVME_FLAG_NEEDS_COPY: u32 = 2;
pub const KVME_FLAG_NOCOREDUMP: u32 = 4;
pub const KVME_FLAG_PAGEABLE: u32 = 8;
pub const KVME_FLAG_GROWS_UP: u32 = 16;
pub const KVME_FLAG_GROWS_DOWN: u32 = 32;
pub const HW_MACHINE: u32 = 1;
pub const HW_MODEL: u32 = 2;
pub const HW_NCPU: u32 = 3;
pub const HW_BYTEORDER: u32 = 4;
pub const HW_PHYSMEM: u32 = 5;
pub const HW_USERMEM: u32 = 6;
pub const HW_PAGESIZE: u32 = 7;
pub const HW_DISKNAMES: u32 = 8;
pub const HW_IOSTATS: u32 = 9;
pub const HW_MACHINE_ARCH: u32 = 10;
pub const HW_ALIGNBYTES: u32 = 11;
pub const HW_CNMAGIC: u32 = 12;
pub const HW_PHYSMEM64: u32 = 13;
pub const HW_USERMEM64: u32 = 14;
pub const HW_IOSTATNAMES: u32 = 15;
pub const HW_NCPUONLINE: u32 = 16;
pub const USER_CS_PATH: u32 = 1;
pub const USER_BC_BASE_MAX: u32 = 2;
pub const USER_BC_DIM_MAX: u32 = 3;
pub const USER_BC_SCALE_MAX: u32 = 4;
pub const USER_BC_STRING_MAX: u32 = 5;
pub const USER_COLL_WEIGHTS_MAX: u32 = 6;
pub const USER_EXPR_NEST_MAX: u32 = 7;
pub const USER_LINE_MAX: u32 = 8;
pub const USER_RE_DUP_MAX: u32 = 9;
pub const USER_POSIX2_VERSION: u32 = 10;
pub const USER_POSIX2_C_BIND: u32 = 11;
pub const USER_POSIX2_C_DEV: u32 = 12;
pub const USER_POSIX2_CHAR_TERM: u32 = 13;
pub const USER_POSIX2_FORT_DEV: u32 = 14;
pub const USER_POSIX2_FORT_RUN: u32 = 15;
pub const USER_POSIX2_LOCALEDEF: u32 = 16;
pub const USER_POSIX2_SW_DEV: u32 = 17;
pub const USER_POSIX2_UPE: u32 = 18;
pub const USER_STREAM_MAX: u32 = 19;
pub const USER_TZNAME_MAX: u32 = 20;
pub const USER_ATEXIT_MAX: u32 = 21;
pub const DDBCTL_RADIX: u32 = 1;
pub const DDBCTL_MAXOFF: u32 = 2;
pub const DDBCTL_MAXWIDTH: u32 = 3;
pub const DDBCTL_LINES: u32 = 4;
pub const DDBCTL_TABSTOPS: u32 = 5;
pub const DDBCTL_ONPANIC: u32 = 6;
pub const DDBCTL_FROMCONSOLE: u32 = 7;
pub const CTL_DEBUG_NAME: u32 = 0;
pub const CTL_DEBUG_VALUE: u32 = 1;
pub const PROC_PID_CORENAME: u32 = 1;
pub const PROC_PID_LIMIT: u32 = 2;
pub const PROC_PID_STOPFORK: u32 = 3;
pub const PROC_PID_STOPEXEC: u32 = 4;
pub const PROC_PID_STOPEXIT: u32 = 5;
pub const PROC_PID_PAXFLAGS: u32 = 6;
pub const PROC_PID_LIMIT_TYPE_SOFT: u32 = 1;
pub const PROC_PID_LIMIT_TYPE_HARD: u32 = 2;
pub const CTL_PROC_PAXFLAGS_ASLR: u32 = 1;
pub const CTL_PROC_PAXFLAGS_MPROTECT: u32 = 2;
pub const CTL_PROC_PAXFLAGS_GUARD: u32 = 4;
pub const EMUL_LINUX: u32 = 1;
pub const EMUL_LINUX32: u32 = 5;
pub const UIO_MAXIOV: u32 = 1024;
pub const SOCK_STREAM: u32 = 1;
pub const SOCK_DGRAM: u32 = 2;
pub const SOCK_RAW: u32 = 3;
pub const SOCK_RDM: u32 = 4;
pub const SOCK_SEQPACKET: u32 = 5;
pub const SOCK_CONN_DGRAM: u32 = 6;
pub const SOCK_DCCP: u32 = 6;
pub const SOCK_CLOEXEC: u32 = 268435456;
pub const SOCK_NONBLOCK: u32 = 536870912;
pub const SOCK_NOSIGPIPE: u32 = 1073741824;
pub const SOCK_FLAGS_MASK: u32 = 4026531840;
pub const SO_DEBUG: u32 = 1;
pub const SO_ACCEPTCONN: u32 = 2;
pub const SO_REUSEADDR: u32 = 4;
pub const SO_KEEPALIVE: u32 = 8;
pub const SO_DONTROUTE: u32 = 16;
pub const SO_BROADCAST: u32 = 32;
pub const SO_USELOOPBACK: u32 = 64;
pub const SO_LINGER: u32 = 128;
pub const SO_OOBINLINE: u32 = 256;
pub const SO_REUSEPORT: u32 = 512;
pub const SO_NOSIGPIPE: u32 = 2048;
pub const SO_ACCEPTFILTER: u32 = 4096;
pub const SO_TIMESTAMP: u32 = 8192;
pub const SO_RERROR: u32 = 16384;
pub const SO_DEFOPTS: u32 = 27645;
pub const __SO_OPTION_BITS : & [u8 ; 194] = b"\x10\x01SO_DEBUG\x02SO_ACCEPTCONN\x03SO_REUSEADDR\x04SO_KEEPALIVE\x05SO_DONTROUTE\x06SO_BROADCAST\x07SO_USELOOPBACK\x08SO_LINGER\tSO_OOBINLINE\nSO_REUSEPORT\x0BSO_OTIMESTAMP\x0CSO_NOSIGPIPE\rSO_ACCEPTFILTER\x0ESO_TIMESTAMP\x0FSO_RERROR\0" ;
pub const SO_SNDBUF: u32 = 4097;
pub const SO_RCVBUF: u32 = 4098;
pub const SO_SNDLOWAT: u32 = 4099;
pub const SO_RCVLOWAT: u32 = 4100;
pub const SO_ERROR: u32 = 4103;
pub const SO_TYPE: u32 = 4104;
pub const SO_OVERFLOWED: u32 = 4105;
pub const SO_NOHEADER: u32 = 4106;
pub const SO_SNDTIMEO: u32 = 4107;
pub const SO_RCVTIMEO: u32 = 4108;
pub const SOL_SOCKET: u32 = 65535;
pub const AF_UNSPEC: u32 = 0;
pub const AF_LOCAL: u32 = 1;
pub const AF_UNIX: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_IMPLINK: u32 = 3;
pub const AF_PUP: u32 = 4;
pub const AF_CHAOS: u32 = 5;
pub const AF_NS: u32 = 6;
pub const AF_ISO: u32 = 7;
pub const AF_OSI: u32 = 7;
pub const AF_ECMA: u32 = 8;
pub const AF_DATAKIT: u32 = 9;
pub const AF_CCITT: u32 = 10;
pub const AF_SNA: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_DLI: u32 = 13;
pub const AF_LAT: u32 = 14;
pub const AF_HYLINK: u32 = 15;
pub const AF_APPLETALK: u32 = 16;
pub const AF_OROUTE: u32 = 17;
pub const AF_LINK: u32 = 18;
pub const pseudo_AF_XTP: u32 = 19;
pub const AF_COIP: u32 = 20;
pub const AF_CNT: u32 = 21;
pub const pseudo_AF_RTIP: u32 = 22;
pub const AF_IPX: u32 = 23;
pub const AF_INET6: u32 = 24;
pub const pseudo_AF_PIP: u32 = 25;
pub const AF_ISDN: u32 = 26;
pub const AF_E164: u32 = 26;
pub const AF_NATM: u32 = 27;
pub const AF_ARP: u32 = 28;
pub const pseudo_AF_KEY: u32 = 29;
pub const pseudo_AF_HDRCMPLT: u32 = 30;
pub const AF_BLUETOOTH: u32 = 31;
pub const AF_IEEE80211: u32 = 32;
pub const AF_MPLS: u32 = 33;
pub const AF_ROUTE: u32 = 34;
pub const AF_CAN: u32 = 35;
pub const AF_ETHER: u32 = 36;
pub const AF_MAX: u32 = 37;
pub const _SS_MAXSIZE: u32 = 128;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_IMPLINK: u32 = 3;
pub const PF_PUP: u32 = 4;
pub const PF_CHAOS: u32 = 5;
pub const PF_NS: u32 = 6;
pub const PF_ISO: u32 = 7;
pub const PF_OSI: u32 = 7;
pub const PF_ECMA: u32 = 8;
pub const PF_DATAKIT: u32 = 9;
pub const PF_CCITT: u32 = 10;
pub const PF_SNA: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_DLI: u32 = 13;
pub const PF_LAT: u32 = 14;
pub const PF_HYLINK: u32 = 15;
pub const PF_APPLETALK: u32 = 16;
pub const PF_OROUTE: u32 = 17;
pub const PF_LINK: u32 = 18;
pub const PF_XTP: u32 = 19;
pub const PF_COIP: u32 = 20;
pub const PF_CNT: u32 = 21;
pub const PF_INET6: u32 = 24;
pub const PF_IPX: u32 = 23;
pub const PF_RTIP: u32 = 22;
pub const PF_PIP: u32 = 25;
pub const PF_ISDN: u32 = 26;
pub const PF_E164: u32 = 26;
pub const PF_NATM: u32 = 27;
pub const PF_ARP: u32 = 28;
pub const PF_KEY: u32 = 29;
pub const PF_BLUETOOTH: u32 = 31;
pub const PF_MPLS: u32 = 33;
pub const PF_ROUTE: u32 = 34;
pub const PF_CAN: u32 = 35;
pub const PF_ETHER: u32 = 36;
pub const PF_MAX: u32 = 37;
pub const PCB_SLOP: u32 = 20;
pub const PCB_ALL: u32 = 0;
pub const NET_RT_DUMP: u32 = 1;
pub const NET_RT_FLAGS: u32 = 2;
pub const NET_RT_OOOIFLIST: u32 = 3;
pub const NET_RT_OOIFLIST: u32 = 4;
pub const NET_RT_OIFLIST: u32 = 5;
pub const NET_RT_IFLIST: u32 = 6;
pub const SOMAXCONN: u32 = 128;
pub const MSG_OOB: u32 = 1;
pub const MSG_PEEK: u32 = 2;
pub const MSG_DONTROUTE: u32 = 4;
pub const MSG_EOR: u32 = 8;
pub const MSG_TRUNC: u32 = 16;
pub const MSG_CTRUNC: u32 = 32;
pub const MSG_WAITALL: u32 = 64;
pub const MSG_DONTWAIT: u32 = 128;
pub const MSG_BCAST: u32 = 256;
pub const MSG_MCAST: u32 = 512;
pub const MSG_NOSIGNAL: u32 = 1024;
pub const MSG_CMSG_CLOEXEC: u32 = 2048;
pub const MSG_NBIO: u32 = 4096;
pub const MSG_WAITFORONE: u32 = 8192;
pub const MSG_NOTIFICATION: u32 = 16384;
pub const MSG_USERFLAGS: u32 = 16777215;
pub const MSG_NAMEMBUF: u32 = 16777216;
pub const MSG_CONTROLMBUF: u32 = 33554432;
pub const MSG_IOVUSRSPACE: u32 = 67108864;
pub const MSG_LENUSRSPACE: u32 = 134217728;
pub const SCM_RIGHTS: u32 = 1;
pub const SCM_TIMESTAMP: u32 = 8;
pub const SCM_CREDS: u32 = 16;
pub const SHUT_RD: u32 = 0;
pub const SHUT_WR: u32 = 1;
pub const SHUT_RDWR: u32 = 2;
pub const IPPROTO_IP: u32 = 0;
pub const IPPROTO_HOPOPTS: u32 = 0;
pub const IPPROTO_ICMP: u32 = 1;
pub const IPPROTO_IGMP: u32 = 2;
pub const IPPROTO_GGP: u32 = 3;
pub const IPPROTO_IPV4: u32 = 4;
pub const IPPROTO_IPIP: u32 = 4;
pub const IPPROTO_TCP: u32 = 6;
pub const IPPROTO_EGP: u32 = 8;
pub const IPPROTO_PUP: u32 = 12;
pub const IPPROTO_UDP: u32 = 17;
pub const IPPROTO_IDP: u32 = 22;
pub const IPPROTO_TP: u32 = 29;
pub const IPPROTO_DCCP: u32 = 33;
pub const IPPROTO_IPV6: u32 = 41;
pub const IPPROTO_ROUTING: u32 = 43;
pub const IPPROTO_FRAGMENT: u32 = 44;
pub const IPPROTO_RSVP: u32 = 46;
pub const IPPROTO_GRE: u32 = 47;
pub const IPPROTO_ESP: u32 = 50;
pub const IPPROTO_AH: u32 = 51;
pub const IPPROTO_MOBILE: u32 = 55;
pub const IPPROTO_IPV6_ICMP: u32 = 58;
pub const IPPROTO_ICMPV6: u32 = 58;
pub const IPPROTO_NONE: u32 = 59;
pub const IPPROTO_DSTOPTS: u32 = 60;
pub const IPPROTO_EON: u32 = 80;
pub const IPPROTO_ETHERIP: u32 = 97;
pub const IPPROTO_ENCAP: u32 = 98;
pub const IPPROTO_PIM: u32 = 103;
pub const IPPROTO_IPCOMP: u32 = 108;
pub const IPPROTO_VRRP: u32 = 112;
pub const IPPROTO_CARP: u32 = 112;
pub const IPPROTO_L2TP: u32 = 115;
pub const IPPROTO_SCTP: u32 = 132;
pub const IPPROTO_PFSYNC: u32 = 240;
pub const IPPROTO_RAW: u32 = 255;
pub const IPPROTO_MAX: u32 = 256;
pub const IPPROTO_DONE: u32 = 257;
pub const CTL_IPPROTO_IPSEC: u32 = 258;
pub const IPPORT_RESERVED: u32 = 1024;
pub const IPPORT_ANONMIN: u32 = 49152;
pub const IPPORT_ANONMAX: u32 = 65535;
pub const IPPORT_RESERVEDMIN: u32 = 600;
pub const IPPORT_RESERVEDMAX: u32 = 1023;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSD_NSHIFT: u32 = 28;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const IP_OPTIONS: u32 = 1;
pub const IP_HDRINCL: u32 = 2;
pub const IP_TOS: u32 = 3;
pub const IP_TTL: u32 = 4;
pub const IP_RECVOPTS: u32 = 5;
pub const IP_RECVRETOPTS: u32 = 6;
pub const IP_RECVDSTADDR: u32 = 7;
pub const IP_RETOPTS: u32 = 8;
pub const IP_MULTICAST_IF: u32 = 9;
pub const IP_MULTICAST_TTL: u32 = 10;
pub const IP_MULTICAST_LOOP: u32 = 11;
pub const IP_ADD_MEMBERSHIP: u32 = 12;
pub const IP_DROP_MEMBERSHIP: u32 = 13;
pub const IP_PORTALGO: u32 = 18;
pub const IP_PORTRANGE: u32 = 19;
pub const IP_RECVIF: u32 = 20;
pub const IP_ERRORMTU: u32 = 21;
pub const IP_IPSEC_POLICY: u32 = 22;
pub const IP_RECVTTL: u32 = 23;
pub const IP_MINTTL: u32 = 24;
pub const IP_PKTINFO: u32 = 25;
pub const IP_RECVPKTINFO: u32 = 26;
pub const IP_BINDANY: u32 = 27;
pub const IP_SENDSRCADDR: u32 = 7;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MAX_MEMBERSHIPS: u32 = 20;
pub const IP_PORTRANGE_DEFAULT: u32 = 0;
pub const IP_PORTRANGE_HIGH: u32 = 1;
pub const IP_PORTRANGE_LOW: u32 = 2;
pub const IPCTL_FORWARDING: u32 = 1;
pub const IPCTL_SENDREDIRECTS: u32 = 2;
pub const IPCTL_DEFTTL: u32 = 3;
pub const IPCTL_FORWSRCRT: u32 = 5;
pub const IPCTL_DIRECTEDBCAST: u32 = 6;
pub const IPCTL_ALLOWSRCRT: u32 = 7;
pub const IPCTL_SUBNETSARELOCAL: u32 = 8;
pub const IPCTL_MTUDISC: u32 = 9;
pub const IPCTL_ANONPORTMIN: u32 = 10;
pub const IPCTL_ANONPORTMAX: u32 = 11;
pub const IPCTL_MTUDISCTIMEOUT: u32 = 12;
pub const IPCTL_MAXFLOWS: u32 = 13;
pub const IPCTL_HOSTZEROBROADCAST: u32 = 14;
pub const IPCTL_GIF_TTL: u32 = 15;
pub const IPCTL_LOWPORTMIN: u32 = 16;
pub const IPCTL_LOWPORTMAX: u32 = 17;
pub const IPCTL_MAXFRAGPACKETS: u32 = 18;
pub const IPCTL_GRE_TTL: u32 = 19;
pub const IPCTL_CHECKINTERFACE: u32 = 20;
pub const IPCTL_IFQ: u32 = 21;
pub const IPCTL_RANDOMID: u32 = 22;
pub const IPCTL_LOOPBACKCKSUM: u32 = 23;
pub const IPCTL_STATS: u32 = 24;
pub const IPCTL_DAD_COUNT: u32 = 25;
pub const __KAME_VERSION: &[u8; 15] = b"NetBSD-current\0";
pub const IPV6PORT_RESERVED: u32 = 1024;
pub const IPV6PORT_ANONMIN: u32 = 49152;
pub const IPV6PORT_ANONMAX: u32 = 65535;
pub const IPV6PORT_RESERVEDMIN: u32 = 600;
pub const IPV6PORT_RESERVEDMAX: u32 = 1023;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const __IPV6_ADDR_SCOPE_NODELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_LINKLOCAL: u32 = 2;
pub const __IPV6_ADDR_SCOPE_SITELOCAL: u32 = 5;
pub const __IPV6_ADDR_SCOPE_ORGLOCAL: u32 = 8;
pub const __IPV6_ADDR_SCOPE_GLOBAL: u32 = 14;
pub const IPV6_SOCKOPT_RESERVED1: u32 = 3;
pub const IPV6_UNICAST_HOPS: u32 = 4;
pub const IPV6_MULTICAST_IF: u32 = 9;
pub const IPV6_MULTICAST_HOPS: u32 = 10;
pub const IPV6_MULTICAST_LOOP: u32 = 11;
pub const IPV6_JOIN_GROUP: u32 = 12;
pub const IPV6_LEAVE_GROUP: u32 = 13;
pub const IPV6_PORTRANGE: u32 = 14;
pub const IPV6_PORTALGO: u32 = 17;
pub const ICMP6_FILTER: u32 = 18;
pub const IPV6_CHECKSUM: u32 = 26;
pub const IPV6_V6ONLY: u32 = 27;
pub const IPV6_IPSEC_POLICY: u32 = 28;
pub const IPV6_FAITH: u32 = 29;
pub const IPV6_RTHDRDSTOPTS: u32 = 35;
pub const IPV6_RECVPKTINFO: u32 = 36;
pub const IPV6_RECVHOPLIMIT: u32 = 37;
pub const IPV6_RECVRTHDR: u32 = 38;
pub const IPV6_RECVHOPOPTS: u32 = 39;
pub const IPV6_RECVDSTOPTS: u32 = 40;
pub const IPV6_USE_MIN_MTU: u32 = 42;
pub const IPV6_RECVPATHMTU: u32 = 43;
pub const IPV6_PATHMTU: u32 = 44;
pub const IPV6_PKTINFO: u32 = 46;
pub const IPV6_HOPLIMIT: u32 = 47;
pub const IPV6_NEXTHOP: u32 = 48;
pub const IPV6_HOPOPTS: u32 = 49;
pub const IPV6_DSTOPTS: u32 = 50;
pub const IPV6_RTHDR: u32 = 51;
pub const IPV6_RECVTCLASS: u32 = 57;
pub const IPV6_TCLASS: u32 = 61;
pub const IPV6_DONTFRAG: u32 = 62;
pub const IPV6_PREFER_TEMPADDR: u32 = 63;
pub const IPV6_BINDANY: u32 = 64;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IPV6_DEFAULT_MULTICAST_HOPS: u32 = 1;
pub const IPV6_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IPV6_PORTRANGE_DEFAULT: u32 = 0;
pub const IPV6_PORTRANGE_HIGH: u32 = 1;
pub const IPV6_PORTRANGE_LOW: u32 = 2;
pub const IPV6CTL_FORWARDING: u32 = 1;
pub const IPV6CTL_SENDREDIRECTS: u32 = 2;
pub const IPV6CTL_DEFHLIM: u32 = 3;
pub const IPV6CTL_FORWSRCRT: u32 = 5;
pub const IPV6CTL_STATS: u32 = 6;
pub const IPV6CTL_MRTSTATS: u32 = 7;
pub const IPV6CTL_MRTPROTO: u32 = 8;
pub const IPV6CTL_MAXFRAGPACKETS: u32 = 9;
pub const IPV6CTL_SOURCECHECK: u32 = 10;
pub const IPV6CTL_SOURCECHECK_LOGINT: u32 = 11;
pub const IPV6CTL_KEEPFAITH: u32 = 13;
pub const IPV6CTL_LOG_INTERVAL: u32 = 14;
pub const IPV6CTL_HDRNESTLIMIT: u32 = 15;
pub const IPV6CTL_DAD_COUNT: u32 = 16;
pub const IPV6CTL_AUTO_FLOWLABEL: u32 = 17;
pub const IPV6CTL_DEFMCASTHLIM: u32 = 18;
pub const IPV6CTL_GIF_HLIM: u32 = 19;
pub const IPV6CTL_KAME_VERSION: u32 = 20;
pub const IPV6CTL_USE_DEPRECATED: u32 = 21;
pub const IPV6CTL_V6ONLY: u32 = 24;
pub const IPV6CTL_ANONPORTMIN: u32 = 28;
pub const IPV6CTL_ANONPORTMAX: u32 = 29;
pub const IPV6CTL_LOWPORTMIN: u32 = 30;
pub const IPV6CTL_LOWPORTMAX: u32 = 31;
pub const IPV6CTL_AUTO_LINKLOCAL: u32 = 35;
pub const IPV6CTL_ADDRCTLPOLICY: u32 = 38;
pub const IPV6CTL_USE_DEFAULTZONE: u32 = 39;
pub const IPV6CTL_MAXFRAGS: u32 = 41;
pub const IPV6CTL_IFQ: u32 = 42;
pub const IPV6CTL_GIF_PMTU: u32 = 45;
pub const IPV6CTL_IPSEC_HLIM: u32 = 46;
pub const IPV6CTL_IPSEC_PMTU: u32 = 47;
pub const INET6_IS_ADDR_LINKLOCAL: u32 = 1;
pub const INET6_IS_ADDR_MC_LINKLOCAL: u32 = 2;
pub const INET6_IS_ADDR_SITELOCAL: u32 = 4;
pub const IF_NAMESIZE: u32 = 16;
pub const IFDESCRSIZE: u32 = 64;
pub const HOOKNAMSIZ: u32 = 128;
pub const DLT_NULL: u32 = 0;
pub const DLT_EN10MB: u32 = 1;
pub const DLT_EN3MB: u32 = 2;
pub const DLT_AX25: u32 = 3;
pub const DLT_PRONET: u32 = 4;
pub const DLT_CHAOS: u32 = 5;
pub const DLT_IEEE802: u32 = 6;
pub const DLT_ARCNET: u32 = 7;
pub const DLT_SLIP: u32 = 8;
pub const DLT_PPP: u32 = 9;
pub const DLT_FDDI: u32 = 10;
pub const DLT_ATM_RFC1483: u32 = 11;
pub const DLT_RAW: u32 = 12;
pub const DLT_SLIP_BSDOS: u32 = 13;
pub const DLT_PPP_BSDOS: u32 = 14;
pub const DLT_HIPPI: u32 = 15;
pub const DLT_HDLC: u32 = 16;
pub const DLT_OLD_PFLOG: u32 = 17;
pub const DLT_PFSYNC: u32 = 18;
pub const DLT_ATM_CLIP: u32 = 19;
pub const DLT_REDBACK_SMARTEDGE: u32 = 32;
pub const DLT_PPP_SERIAL: u32 = 50;
pub const DLT_PPP_ETHER: u32 = 51;
pub const DLT_SYMANTEC_FIREWALL: u32 = 99;
pub const DLT_MATCHING_MIN: u32 = 104;
pub const DLT_C_HDLC: u32 = 104;
pub const DLT_CHDLC: u32 = 104;
pub const DLT_IEEE802_11: u32 = 105;
pub const DLT_FRELAY: u32 = 107;
pub const DLT_LOOP: u32 = 108;
pub const DLT_ENC: u32 = 109;
pub const DLT_LINUX_SLL: u32 = 113;
pub const DLT_LTALK: u32 = 114;
pub const DLT_ECONET: u32 = 115;
pub const DLT_IPFILTER: u32 = 116;
pub const DLT_PFLOG: u32 = 117;
pub const DLT_CISCO_IOS: u32 = 118;
pub const DLT_PRISM_HEADER: u32 = 119;
pub const DLT_AIRONET_HEADER: u32 = 120;
pub const DLT_HHDLC: u32 = 121;
pub const DLT_IP_OVER_FC: u32 = 122;
pub const DLT_SUNATM: u32 = 123;
pub const DLT_RIO: u32 = 124;
pub const DLT_PCI_EXP: u32 = 125;
pub const DLT_AURORA: u32 = 126;
pub const DLT_IEEE802_11_RADIO: u32 = 127;
pub const DLT_TZSP: u32 = 128;
pub const DLT_ARCNET_LINUX: u32 = 129;
pub const DLT_JUNIPER_MLPPP: u32 = 130;
pub const DLT_JUNIPER_MLFR: u32 = 131;
pub const DLT_JUNIPER_ES: u32 = 132;
pub const DLT_JUNIPER_GGSN: u32 = 133;
pub const DLT_JUNIPER_MFR: u32 = 134;
pub const DLT_JUNIPER_ATM2: u32 = 135;
pub const DLT_JUNIPER_SERVICES: u32 = 136;
pub const DLT_JUNIPER_ATM1: u32 = 137;
pub const DLT_APPLE_IP_OVER_IEEE1394: u32 = 138;
pub const DLT_MTP2_WITH_PHDR: u32 = 139;
pub const DLT_MTP2: u32 = 140;
pub const DLT_MTP3: u32 = 141;
pub const DLT_SCCP: u32 = 142;
pub const DLT_DOCSIS: u32 = 143;
pub const DLT_LINUX_IRDA: u32 = 144;
pub const DLT_IBM_SP: u32 = 145;
pub const DLT_IBM_SN: u32 = 146;
pub const DLT_USER0: u32 = 147;
pub const DLT_USER1: u32 = 148;
pub const DLT_USER2: u32 = 149;
pub const DLT_USER3: u32 = 150;
pub const DLT_USER4: u32 = 151;
pub const DLT_USER5: u32 = 152;
pub const DLT_USER6: u32 = 153;
pub const DLT_USER7: u32 = 154;
pub const DLT_USER8: u32 = 155;
pub const DLT_USER9: u32 = 156;
pub const DLT_USER10: u32 = 157;
pub const DLT_USER11: u32 = 158;
pub const DLT_USER12: u32 = 159;
pub const DLT_USER13: u32 = 160;
pub const DLT_USER14: u32 = 161;
pub const DLT_USER15: u32 = 162;
pub const DLT_IEEE802_11_RADIO_AVS: u32 = 163;
pub const DLT_JUNIPER_MONITOR: u32 = 164;
pub const DLT_BACNET_MS_TP: u32 = 165;
pub const DLT_PPP_PPPD: u32 = 166;
pub const DLT_PPP_WITH_DIRECTION: u32 = 166;
pub const DLT_LINUX_PPP_WITHDIRECTION: u32 = 166;
pub const DLT_JUNIPER_PPPOE: u32 = 167;
pub const DLT_JUNIPER_PPPOE_ATM: u32 = 168;
pub const DLT_GPRS_LLC: u32 = 169;
pub const DLT_GPF_T: u32 = 170;
pub const DLT_GPF_F: u32 = 171;
pub const DLT_GCOM_T1E1: u32 = 172;
pub const DLT_GCOM_SERIAL: u32 = 173;
pub const DLT_JUNIPER_PIC_PEER: u32 = 174;
pub const DLT_ERF_ETH: u32 = 175;
pub const DLT_ERF_POS: u32 = 176;
pub const DLT_LINUX_LAPD: u32 = 177;
pub const DLT_JUNIPER_ETHER: u32 = 178;
pub const DLT_JUNIPER_PPP: u32 = 179;
pub const DLT_JUNIPER_FRELAY: u32 = 180;
pub const DLT_JUNIPER_CHDLC: u32 = 181;
pub const DLT_MFR: u32 = 182;
pub const DLT_JUNIPER_VP: u32 = 183;
pub const DLT_A429: u32 = 184;
pub const DLT_A653_ICM: u32 = 185;
pub const DLT_USB_FREEBSD: u32 = 186;
pub const DLT_USB: u32 = 186;
pub const DLT_BLUETOOTH_HCI_H4: u32 = 187;
pub const DLT_IEEE802_16_MAC_CPS: u32 = 188;
pub const DLT_USB_LINUX: u32 = 189;
pub const DLT_CAN20B: u32 = 190;
pub const DLT_IEEE802_15_4_LINUX: u32 = 191;
pub const DLT_PPI: u32 = 192;
pub const DLT_IEEE802_16_MAC_CPS_RADIO: u32 = 193;
pub const DLT_JUNIPER_ISM: u32 = 194;
pub const DLT_IEEE802_15_4_WITHFCS: u32 = 195;
pub const DLT_IEEE802_15_4: u32 = 195;
pub const DLT_SITA: u32 = 196;
pub const DLT_ERF: u32 = 197;
pub const DLT_RAIF1: u32 = 198;
pub const DLT_IPMB_KONTRON: u32 = 199;
pub const DLT_JUNIPER_ST: u32 = 200;
pub const DLT_BLUETOOTH_HCI_H4_WITH_PHDR: u32 = 201;
pub const DLT_AX25_KISS: u32 = 202;
pub const DLT_LAPD: u32 = 203;
pub const DLT_PPP_WITH_DIR: u32 = 204;
pub const DLT_C_HDLC_WITH_DIR: u32 = 205;
pub const DLT_FRELAY_WITH_DIR: u32 = 206;
pub const DLT_LAPB_WITH_DIR: u32 = 207;
pub const DLT_IPMB_LINUX: u32 = 209;
pub const DLT_FLEXRAY: u32 = 210;
pub const DLT_MOST: u32 = 211;
pub const DLT_LIN: u32 = 212;
pub const DLT_X2E_SERIAL: u32 = 213;
pub const DLT_X2E_XORAYA: u32 = 214;
pub const DLT_IEEE802_15_4_NONASK_PHY: u32 = 215;
pub const DLT_LINUX_EVDEV: u32 = 216;
pub const DLT_GSMTAP_UM: u32 = 217;
pub const DLT_GSMTAP_ABIS: u32 = 218;
pub const DLT_MPLS: u32 = 219;
pub const DLT_USB_LINUX_MMAPPED: u32 = 220;
pub const DLT_DECT: u32 = 221;
pub const DLT_AOS: u32 = 222;
pub const DLT_WIHART: u32 = 223;
pub const DLT_FC_2: u32 = 224;
pub const DLT_FC_2_WITH_FRAME_DELIMS: u32 = 225;
pub const DLT_IPNET: u32 = 226;
pub const DLT_CAN_SOCKETCAN: u32 = 227;
pub const DLT_IPV4: u32 = 228;
pub const DLT_IPV6: u32 = 229;
pub const DLT_IEEE802_15_4_NOFCS: u32 = 230;
pub const DLT_DBUS: u32 = 231;
pub const DLT_JUNIPER_VS: u32 = 232;
pub const DLT_JUNIPER_SRX_E2E: u32 = 233;
pub const DLT_JUNIPER_FIBRECHANNEL: u32 = 234;
pub const DLT_DVB_CI: u32 = 235;
pub const DLT_MUX27010: u32 = 236;
pub const DLT_STANAG_5066_D_PDU: u32 = 237;
pub const DLT_JUNIPER_ATM_CEMIC: u32 = 238;
pub const DLT_NFLOG: u32 = 239;
pub const DLT_NETANALYZER: u32 = 240;
pub const DLT_NETANALYZER_TRANSPARENT: u32 = 241;
pub const DLT_IPOIB: u32 = 242;
pub const DLT_MPEG_2_TS: u32 = 243;
pub const DLT_NG40: u32 = 244;
pub const DLT_NFC_LLCP: u32 = 245;
pub const DLT_INFINIBAND: u32 = 247;
pub const DLT_SCTP: u32 = 248;
pub const DLT_USBPCAP: u32 = 249;
pub const DLT_RTAC_SERIAL: u32 = 250;
pub const DLT_BLUETOOTH_LE_LL: u32 = 251;
pub const DLT_WIRESHARK_UPPER_PDU: u32 = 252;
pub const DLT_NETLINK: u32 = 253;
pub const DLT_BLUETOOTH_LINUX_MONITOR: u32 = 254;
pub const DLT_BLUETOOTH_BREDR_BB: u32 = 255;
pub const DLT_BLUETOOTH_LE_LL_WITH_PHDR: u32 = 256;
pub const DLT_PROFIBUS_DL: u32 = 257;
pub const DLT_PKTAP: u32 = 258;
pub const DLT_EPON: u32 = 259;
pub const DLT_IPMI_HPM_2: u32 = 260;
pub const DLT_ZWAVE_R1_R2: u32 = 261;
pub const DLT_ZWAVE_R3: u32 = 262;
pub const DLT_WATTSTOPPER_DLM: u32 = 263;
pub const DLT_ISO_14443: u32 = 264;
pub const DLT_RDS: u32 = 265;
pub const DLT_USB_DARWIN: u32 = 266;
pub const DLT_OPENFLOW: u32 = 267;
pub const DLT_SDLC: u32 = 268;
pub const DLT_TI_LLN_SNIFFER: u32 = 269;
pub const DLT_LORATAP: u32 = 270;
pub const DLT_VSOCK: u32 = 271;
pub const DLT_NORDIC_BLE: u32 = 272;
pub const DLT_DOCSIS31_XRA31: u32 = 273;
pub const DLT_ETHERNET_MPACKET: u32 = 274;
pub const DLT_DISPLAYPORT_AUX: u32 = 275;
pub const DLT_LINUX_SLL2: u32 = 276;
pub const DLT_MATCHING_MAX: u32 = 276;
pub const DLT_CLASS_NETBSD_RAWAF: u32 = 35913728;
pub const PFIL_IN: u32 = 1;
pub const PFIL_OUT: u32 = 2;
pub const PFIL_ALL: u32 = 3;
pub const PFIL_IFADDR: u32 = 8;
pub const PFIL_IFNET: u32 = 16;
pub const PFIL_IFNET_ATTACH: u32 = 0;
pub const PFIL_IFNET_DETACH: u32 = 1;
pub const PFIL_TYPE_AF: u32 = 1;
pub const PFIL_TYPE_IFNET: u32 = 2;
pub const ITIMER_REAL: u32 = 0;
pub const ITIMER_VIRTUAL: u32 = 1;
pub const ITIMER_PROF: u32 = 2;
pub const ITIMER_MONOTONIC: u32 = 3;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_VIRTUAL: u32 = 1;
pub const CLOCK_PROF: u32 = 2;
pub const CLOCK_MONOTONIC: u32 = 3;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 536870912;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 1073741824;
pub const TIMER_RELTIME: u32 = 0;
pub const TIMER_ABSTIME: u32 = 1;
pub const CLOCKS_PER_SEC: u32 = 100;
pub const TIME_UTC: u32 = 1;
pub const IFNAMSIZ: u32 = 16;
pub const LINK_STATE_UNKNOWN: u32 = 0;
pub const LINK_STATE_DOWN: u32 = 1;
pub const LINK_STATE_UP: u32 = 2;
pub const IFF_UP: u32 = 1;
pub const IFF_BROADCAST: u32 = 2;
pub const IFF_DEBUG: u32 = 4;
pub const IFF_LOOPBACK: u32 = 8;
pub const IFF_POINTOPOINT: u32 = 16;
pub const IFF_UNNUMBERED: u32 = 32;
pub const IFF_RUNNING: u32 = 64;
pub const IFF_NOARP: u32 = 128;
pub const IFF_PROMISC: u32 = 256;
pub const IFF_ALLMULTI: u32 = 512;
pub const IFF_OACTIVE: u32 = 1024;
pub const IFF_SIMPLEX: u32 = 2048;
pub const IFF_LINK0: u32 = 4096;
pub const IFF_LINK1: u32 = 8192;
pub const IFF_LINK2: u32 = 16384;
pub const IFF_MULTICAST: u32 = 32768;
pub const IFFBITS : & [u8 ; 128] = b"\x10\x01UP\x02BROADCAST\x03DEBUG\x04LOOPBACK\x05POINTOPOINT\x06UNNUMBERED\x07RUNNING\x08NOARP\tPROMISC\nALLMULTI\x0BOACTIVE\x0CSIMPLEX\rLINK0\x0ELINK1\x0FLINK2\x10MULTICAST\0" ;
pub const IFF_CANTCHANGE: u32 = 36690;
pub const IFCAP_TSOv4: u32 = 128;
pub const IFCAP_CSUM_IPv4_Rx: u32 = 256;
pub const IFCAP_CSUM_IPv4_Tx: u32 = 512;
pub const IFCAP_CSUM_TCPv4_Rx: u32 = 1024;
pub const IFCAP_CSUM_TCPv4_Tx: u32 = 2048;
pub const IFCAP_CSUM_UDPv4_Rx: u32 = 4096;
pub const IFCAP_CSUM_UDPv4_Tx: u32 = 8192;
pub const IFCAP_CSUM_TCPv6_Rx: u32 = 16384;
pub const IFCAP_CSUM_TCPv6_Tx: u32 = 32768;
pub const IFCAP_CSUM_UDPv6_Rx: u32 = 65536;
pub const IFCAP_CSUM_UDPv6_Tx: u32 = 131072;
pub const IFCAP_TSOv6: u32 = 262144;
pub const IFCAP_LRO: u32 = 524288;
pub const IFCAP_MASK: u32 = 1048448;
pub const IFCAPBITS : & [u8 ; 134] = b"\x10\x08TSO4\tIP4CSUM_Rx\nIP4CSUM_Tx\x0BTCP4CSUM_Rx\x0CTCP4CSUM_Tx\rUDP4CSUM_Rx\x0EUDP4CSUM_Tx\x0FTCP6CSUM_Rx\x10TCP6CSUM_Tx\x11UDP6CSUM_Rx\x12UDP6CSUM_Tx\x13TSO6\x14LRO\0" ;
pub const IFQ_MAXLEN: u32 = 256;
pub const IFNET_SLOWHZ: u32 = 1;
pub const IFA_DESTROYING: u32 = 2;
pub const IFAN_ARRIVAL: u32 = 0;
pub const IFAN_DEPARTURE: u32 = 1;
pub const IFLINKSTR_QUERYLEN: u32 = 1;
pub const IFLINKSTR_UNSET: u32 = 2;
pub const IFLR_PREFIX: u32 = 32768;
pub const IFLR_ACTIVE: u32 = 16384;
pub const IFLR_FACTORY: u32 = 8192;
pub const ARPHRD_ETHER: u32 = 1;
pub const ARPHRD_IEEE802: u32 = 6;
pub const ARPHRD_ARCNET: u32 = 7;
pub const ARPHRD_FRELAY: u32 = 15;
pub const ARPHRD_STRIP: u32 = 23;
pub const ARPHRD_IEEE1394: u32 = 24;
pub const ARPOP_REQUEST: u32 = 1;
pub const ARPOP_REPLY: u32 = 2;
pub const ARPOP_REVREQUEST: u32 = 3;
pub const ARPOP_REVREPLY: u32 = 4;
pub const ARPOP_INVREQUEST: u32 = 8;
pub const ARPOP_INVREPLY: u32 = 9;
pub const ATF_INUSE: u32 = 1;
pub const ATF_COM: u32 = 2;
pub const ATF_PERM: u32 = 4;
pub const ATF_PUBL: u32 = 8;
pub const ATF_USETRAILERS: u32 = 16;
pub const ARP_STAT_SNDTOTAL: u32 = 0;
pub const ARP_STAT_SNDREPLY: u32 = 1;
pub const ARP_STAT_SENDREQUEST: u32 = 2;
pub const ARP_STAT_RCVTOTAL: u32 = 3;
pub const ARP_STAT_RCVREQUEST: u32 = 4;
pub const ARP_STAT_RCVREPLY: u32 = 5;
pub const ARP_STAT_RCVMCAST: u32 = 6;
pub const ARP_STAT_RCVBADPROTO: u32 = 7;
pub const ARP_STAT_RCVBADLEN: u32 = 8;
pub const ARP_STAT_RCVZEROTPA: u32 = 9;
pub const ARP_STAT_RCVZEROSPA: u32 = 10;
pub const ARP_STAT_RCVNOINT: u32 = 11;
pub const ARP_STAT_RCVLOCALSHA: u32 = 12;
pub const ARP_STAT_RCVBCASTSHA: u32 = 13;
pub const ARP_STAT_RCVLOCALSPA: u32 = 14;
pub const ARP_STAT_RCVOVERPERM: u32 = 15;
pub const ARP_STAT_RCVOVERINT: u32 = 16;
pub const ARP_STAT_RCVOVER: u32 = 17;
pub const ARP_STAT_RCVLENCHG: u32 = 18;
pub const ARP_STAT_DFRTOTAL: u32 = 19;
pub const ARP_STAT_DFRSENT: u32 = 20;
pub const ARP_STAT_DFRDROPPED: u32 = 21;
pub const ARP_STAT_ALLOCFAIL: u32 = 22;
pub const ARP_NSTATS: u32 = 23;
pub const RTM_RTTUNIT: u32 = 1000000;
pub const RNF_NORMAL: u32 = 1;
pub const RNF_ROOT: u32 = 2;
pub const RNF_ACTIVE: u32 = 4;
pub const RTF_UP: u32 = 1;
pub const RTF_GATEWAY: u32 = 2;
pub const RTF_HOST: u32 = 4;
pub const RTF_REJECT: u32 = 8;
pub const RTF_DYNAMIC: u32 = 16;
pub const RTF_MODIFIED: u32 = 32;
pub const RTF_DONE: u32 = 64;
pub const RTF_MASK: u32 = 128;
pub const RTF_CONNECTED: u32 = 256;
pub const RTF_LLDATA: u32 = 1024;
pub const RTF_STATIC: u32 = 2048;
pub const RTF_BLACKHOLE: u32 = 4096;
pub const RTF_PROTO2: u32 = 16384;
pub const RTF_PROTO1: u32 = 32768;
pub const RTF_SRC: u32 = 65536;
pub const RTF_ANNOUNCE: u32 = 131072;
pub const RTF_LOCAL: u32 = 262144;
pub const RTF_BROADCAST: u32 = 524288;
pub const RTF_UPDATING: u32 = 1048576;
pub const RTF_DONTCHANGEIFA: u32 = 2097152;
pub const RTFBITS : & [u8 ; 162] = b"\x10\x01UP\x02GATEWAY\x03HOST\x04REJECT\x05DYNAMIC\x06MODIFIED\x07DONE\x08MASK_PRESENT\tCONNECTED\nXRESOLVE\x0BLLINFO\x0CSTATIC\rBLACKHOLE\x0ECLONED\x0FPROTO2\x10PROTO1\x11SRC\x12ANNOUNCE\x13LOCAL\x14BROADCAST\x15UPDATING\0" ;
pub const RTM_VERSION: u32 = 4;
pub const RTM_ADD: u32 = 1;
pub const RTM_DELETE: u32 = 2;
pub const RTM_CHANGE: u32 = 3;
pub const RTM_GET: u32 = 4;
pub const RTM_LOSING: u32 = 5;
pub const RTM_REDIRECT: u32 = 6;
pub const RTM_MISS: u32 = 7;
pub const RTM_LOCK: u32 = 8;
pub const RTM_OLDADD: u32 = 9;
pub const RTM_OLDDEL: u32 = 10;
pub const RTM_ONEWADDR: u32 = 12;
pub const RTM_ODELADDR: u32 = 13;
pub const RTM_OOIFINFO: u32 = 14;
pub const RTM_OIFINFO: u32 = 15;
pub const RTM_IFANNOUNCE: u32 = 16;
pub const RTM_IEEE80211: u32 = 17;
pub const RTM_SETGATE: u32 = 18;
pub const RTM_LLINFO_UPD: u32 = 19;
pub const RTM_IFINFO: u32 = 20;
pub const RTM_OCHGADDR: u32 = 21;
pub const RTM_NEWADDR: u32 = 22;
pub const RTM_DELADDR: u32 = 23;
pub const RTM_CHGADDR: u32 = 24;
pub const RO_MSGFILTER: u32 = 1;
pub const RO_MISSFILTER: u32 = 2;
pub const RO_FILTSA_MAX: u32 = 30;
pub const RTV_MTU: u32 = 1;
pub const RTV_HOPCOUNT: u32 = 2;
pub const RTV_EXPIRE: u32 = 4;
pub const RTV_RPIPE: u32 = 8;
pub const RTV_SPIPE: u32 = 16;
pub const RTV_SSTHRESH: u32 = 32;
pub const RTV_RTT: u32 = 64;
pub const RTV_RTTVAR: u32 = 128;
pub const RTVBITS: &[u8; 60] =
    b"\x10\x01MTU\x02HOPCOUNT\x03EXPIRE\x04RECVPIPE\x05SENDPIPE\x06SSTHRESH\x07RTT\x08RTTVAR\0";
pub const RTA_DST: u32 = 1;
pub const RTA_GATEWAY: u32 = 2;
pub const RTA_NETMASK: u32 = 4;
pub const RTA_GENMASK: u32 = 8;
pub const RTA_IFP: u32 = 16;
pub const RTA_IFA: u32 = 32;
pub const RTA_AUTHOR: u32 = 64;
pub const RTA_BRD: u32 = 128;
pub const RTA_TAG: u32 = 256;
pub const RTABITS: &[u8; 53] =
    b"\x10\x01DST\x02GATEWAY\x03NETMASK\x04GENMASK\x05IFP\x06IFA\x07AUTHOR\x08BRD\tTAG\0";
pub const RTAX_DST: u32 = 0;
pub const RTAX_GATEWAY: u32 = 1;
pub const RTAX_NETMASK: u32 = 2;
pub const RTAX_GENMASK: u32 = 3;
pub const RTAX_IFP: u32 = 4;
pub const RTAX_IFA: u32 = 5;
pub const RTAX_AUTHOR: u32 = 6;
pub const RTAX_BRD: u32 = 7;
pub const RTAX_TAG: u32 = 8;
pub const RTAX_MAX: u32 = 9;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __uintptr_t = ::std::os::raw::c_ulong;
pub type int_least8_t = ::std::os::raw::c_schar;
pub type uint_least8_t = ::std::os::raw::c_uchar;
pub type int_least16_t = ::std::os::raw::c_short;
pub type uint_least16_t = ::std::os::raw::c_ushort;
pub type int_least32_t = ::std::os::raw::c_int;
pub type uint_least32_t = ::std::os::raw::c_uint;
pub type int_least64_t = ::std::os::raw::c_long;
pub type uint_least64_t = ::std::os::raw::c_ulong;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type int_fast16_t = ::std::os::raw::c_short;
pub type uint_fast16_t = ::std::os::raw::c_ushort;
pub type int_fast32_t = ::std::os::raw::c_int;
pub type uint_fast32_t = ::std::os::raw::c_uint;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type __register_t = ::std::os::raw::c_long;
pub type __cpu_simple_lock_nv_t = ::std::os::raw::c_uchar;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __gid_t = __uint32_t;
pub type __in_addr_t = __uint32_t;
pub type __in_port_t = __uint16_t;
pub type __mode_t = __uint32_t;
pub type __accmode_t = __uint32_t;
pub type __off_t = __int64_t;
pub type __pid_t = __int32_t;
pub type __sa_family_t = __uint8_t;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __uid_t = __uint32_t;
pub type __fsblkcnt_t = __uint64_t;
pub type __fsfilcnt_t = __uint64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __tag_wctrans_t {
    _unused: [u8; 0],
}
pub type __wctrans_t = *mut __tag_wctrans_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __tag_wctype_t {
    _unused: [u8; 0],
}
pub type __wctype_t = *mut __tag_wctype_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstateL: __int64_t,
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __mbstate_t"][::std::mem::size_of::<__mbstate_t>() - 128usize];
    ["Alignment of __mbstate_t"][::std::mem::align_of::<__mbstate_t>() - 8usize];
    ["Offset of field: __mbstate_t::__mbstateL"]
        [::std::mem::offset_of!(__mbstate_t, __mbstateL) - 0usize];
    ["Offset of field: __mbstate_t::__mbstate8"]
        [::std::mem::offset_of!(__mbstate_t, __mbstate8) - 0usize];
};
pub type __va_list = __builtin_va_list;
pub type u_int8_t = u8;
pub type u_int16_t = u16;
pub type u_int32_t = u32;
pub type u_int64_t = u64;
pub type in_addr_t = __in_addr_t;
pub type in_port_t = __in_port_t;
unsafe extern "C" {
    pub fn htonl(arg1: u32) -> u32;
}
unsafe extern "C" {
    pub fn htons(arg1: u16) -> u16;
}
unsafe extern "C" {
    pub fn ntohl(arg1: u32) -> u32;
}
unsafe extern "C" {
    pub fn ntohs(arg1: u16) -> u16;
}
unsafe extern "C" {
    #[link_name = "\u{1}__bswap16"]
    pub fn bswap16(arg1: u16) -> u16;
}
unsafe extern "C" {
    #[link_name = "\u{1}__bswap32"]
    pub fn bswap32(arg1: u32) -> u32;
}
unsafe extern "C" {
    pub fn bswap64(arg1: u64) -> u64;
}
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type unchar = ::std::os::raw::c_uchar;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type ulong = ::std::os::raw::c_ulong;
pub type u_quad_t = u64;
pub type quad_t = i64;
pub type qaddr_t = *mut quad_t;
pub type longlong_t = i64;
pub type u_longlong_t = u64;
pub type blkcnt_t = i64;
pub type blksize_t = i32;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
pub type caddr_t = __caddr_t;
pub type daddr_t = i64;
pub type dev_t = u64;
pub type fixpt_t = u32;
pub type gid_t = __gid_t;
pub type id_t = u32;
pub type ino_t = u64;
pub type key_t = ::std::os::raw::c_long;
pub type mode_t = __mode_t;
pub type accmode_t = __accmode_t;
pub type nlink_t = u32;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type lwpid_t = i32;
pub type rlim_t = u64;
pub type segsz_t = i32;
pub type swblk_t = i32;
pub type uid_t = __uid_t;
pub type mqd_t = ::std::os::raw::c_int;
pub type cpuid_t = ::std::os::raw::c_ulong;
pub type psetid_t = ::std::os::raw::c_int;
pub type __cpu_simple_lock_t = __cpu_simple_lock_nv_t;
unsafe extern "C" {
    pub fn lseek(
        arg1: ::std::os::raw::c_int,
        arg2: __off_t,
        arg3: ::std::os::raw::c_int,
    ) -> __off_t;
}
unsafe extern "C" {
    pub fn ftruncate(arg1: ::std::os::raw::c_int, arg2: __off_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn truncate(arg1: *const ::std::os::raw::c_char, arg2: __off_t) -> ::std::os::raw::c_int;
}
pub type __devmajor_t = i32;
pub type __devminor_t = i32;
pub type clock_t = ::std::os::raw::c_uint;
pub type time_t = __int64_t;
pub type clockid_t = ::std::os::raw::c_int;
pub type timer_t = ::std::os::raw::c_int;
pub type suseconds_t = ::std::os::raw::c_int;
pub type useconds_t = ::std::os::raw::c_uint;
pub type __fd_mask = __uint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [__fd_mask; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of fd_set"][::std::mem::size_of::<fd_set>() - 32usize];
    ["Alignment of fd_set"][::std::mem::align_of::<fd_set>() - 4usize];
    ["Offset of field: fd_set::fds_bits"][::std::mem::offset_of!(fd_set, fds_bits) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kauth_cred {
    _unused: [u8; 0],
}
pub type kauth_cred_t = *mut kauth_cred;
pub type pri_t = ::std::os::raw::c_int;
pub type pthread_spin_t = __cpu_simple_lock_t;
pub type __pthread_spin_t = pthread_spin_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_queue_struct_t {
    pub ptqh_first: *mut __pthread_st,
    pub ptqh_last: *mut *mut __pthread_st,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_queue_struct_t"][::std::mem::size_of::<pthread_queue_struct_t>() - 16usize];
    ["Alignment of pthread_queue_struct_t"]
        [::std::mem::align_of::<pthread_queue_struct_t>() - 8usize];
    ["Offset of field: pthread_queue_struct_t::ptqh_first"]
        [::std::mem::offset_of!(pthread_queue_struct_t, ptqh_first) - 0usize];
    ["Offset of field: pthread_queue_struct_t::ptqh_last"]
        [::std::mem::offset_of!(pthread_queue_struct_t, ptqh_last) - 8usize];
};
pub type pthread_queue_t = pthread_queue_struct_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_st {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_spin_st {
    _unused: [u8; 0],
}
pub type pthread_t = *mut __pthread_st;
pub type pthread_attr_t = __pthread_attr_st;
pub type pthread_mutex_t = __pthread_mutex_st;
pub type pthread_mutexattr_t = __pthread_mutexattr_st;
pub type pthread_cond_t = __pthread_cond_st;
pub type pthread_condattr_t = __pthread_condattr_st;
pub type pthread_once_t = __pthread_once_st;
pub type pthread_spinlock_t = __pthread_spinlock_st;
pub type pthread_rwlock_t = __pthread_rwlock_st;
pub type pthread_rwlockattr_t = __pthread_rwlockattr_st;
pub type pthread_barrier_t = __pthread_barrier_st;
pub type pthread_barrierattr_t = __pthread_barrierattr_st;
pub type pthread_key_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_attr_st {
    pub pta_magic: ::std::os::raw::c_uint,
    pub pta_flags: ::std::os::raw::c_int,
    pub pta_private: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_attr_st"][::std::mem::size_of::<__pthread_attr_st>() - 16usize];
    ["Alignment of __pthread_attr_st"][::std::mem::align_of::<__pthread_attr_st>() - 8usize];
    ["Offset of field: __pthread_attr_st::pta_magic"]
        [::std::mem::offset_of!(__pthread_attr_st, pta_magic) - 0usize];
    ["Offset of field: __pthread_attr_st::pta_flags"]
        [::std::mem::offset_of!(__pthread_attr_st, pta_flags) - 4usize];
    ["Offset of field: __pthread_attr_st::pta_private"]
        [::std::mem::offset_of!(__pthread_attr_st, pta_private) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_mutex_st {
    pub ptm_magic: ::std::os::raw::c_uint,
    pub ptm_errorcheck: __pthread_spin_t,
    pub ptm_pad1: [u8; 3usize],
    pub __bindgen_anon_1: __pthread_mutex_st__bindgen_ty_1,
    pub ptm_pad2: [u8; 3usize],
    pub ptm_owner: pthread_t,
    pub ptm_waiters: *mut ::std::os::raw::c_void,
    pub ptm_recursed: ::std::os::raw::c_uint,
    pub ptm_spare2: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_mutex_st__bindgen_ty_1 {
    pub ptm_ceiling: ::std::os::raw::c_uchar,
    pub ptm_unused: __pthread_spin_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_mutex_st__bindgen_ty_1"]
        [::std::mem::size_of::<__pthread_mutex_st__bindgen_ty_1>() - 1usize];
    ["Alignment of __pthread_mutex_st__bindgen_ty_1"]
        [::std::mem::align_of::<__pthread_mutex_st__bindgen_ty_1>() - 1usize];
    ["Offset of field: __pthread_mutex_st__bindgen_ty_1::ptm_ceiling"]
        [::std::mem::offset_of!(__pthread_mutex_st__bindgen_ty_1, ptm_ceiling) - 0usize];
    ["Offset of field: __pthread_mutex_st__bindgen_ty_1::ptm_unused"]
        [::std::mem::offset_of!(__pthread_mutex_st__bindgen_ty_1, ptm_unused) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_mutex_st"][::std::mem::size_of::<__pthread_mutex_st>() - 48usize];
    ["Alignment of __pthread_mutex_st"][::std::mem::align_of::<__pthread_mutex_st>() - 8usize];
    ["Offset of field: __pthread_mutex_st::ptm_magic"]
        [::std::mem::offset_of!(__pthread_mutex_st, ptm_magic) - 0usize];
    ["Offset of field: __pthread_mutex_st::ptm_errorcheck"]
        [::std::mem::offset_of!(__pthread_mutex_st, ptm_errorcheck) - 4usize];
    ["Offset of field: __pthread_mutex_st::ptm_pad1"]
        [::std::mem::offset_of!(__pthread_mutex_st, ptm_pad1) - 5usize];
    ["Offset of field: __pthread_mutex_st::ptm_pad2"]
        [::std::mem::offset_of!(__pthread_mutex_st, ptm_pad2) - 9usize];
    ["Offset of field: __pthread_mutex_st::ptm_owner"]
        [::std::mem::offset_of!(__pthread_mutex_st, ptm_owner) - 16usize];
    ["Offset of field: __pthread_mutex_st::ptm_waiters"]
        [::std::mem::offset_of!(__pthread_mutex_st, ptm_waiters) - 24usize];
    ["Offset of field: __pthread_mutex_st::ptm_recursed"]
        [::std::mem::offset_of!(__pthread_mutex_st, ptm_recursed) - 32usize];
    ["Offset of field: __pthread_mutex_st::ptm_spare2"]
        [::std::mem::offset_of!(__pthread_mutex_st, ptm_spare2) - 40usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutexattr_st {
    pub ptma_magic: ::std::os::raw::c_uint,
    pub ptma_private: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_mutexattr_st"][::std::mem::size_of::<__pthread_mutexattr_st>() - 16usize];
    ["Alignment of __pthread_mutexattr_st"]
        [::std::mem::align_of::<__pthread_mutexattr_st>() - 8usize];
    ["Offset of field: __pthread_mutexattr_st::ptma_magic"]
        [::std::mem::offset_of!(__pthread_mutexattr_st, ptma_magic) - 0usize];
    ["Offset of field: __pthread_mutexattr_st::ptma_private"]
        [::std::mem::offset_of!(__pthread_mutexattr_st, ptma_private) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_st {
    pub ptc_magic: ::std::os::raw::c_uint,
    pub ptc_lock: __pthread_spin_t,
    pub ptc_waiters: *mut ::std::os::raw::c_void,
    pub ptc_spare: *mut ::std::os::raw::c_void,
    pub ptc_mutex: *mut pthread_mutex_t,
    pub ptc_private: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_cond_st"][::std::mem::size_of::<__pthread_cond_st>() - 40usize];
    ["Alignment of __pthread_cond_st"][::std::mem::align_of::<__pthread_cond_st>() - 8usize];
    ["Offset of field: __pthread_cond_st::ptc_magic"]
        [::std::mem::offset_of!(__pthread_cond_st, ptc_magic) - 0usize];
    ["Offset of field: __pthread_cond_st::ptc_lock"]
        [::std::mem::offset_of!(__pthread_cond_st, ptc_lock) - 4usize];
    ["Offset of field: __pthread_cond_st::ptc_waiters"]
        [::std::mem::offset_of!(__pthread_cond_st, ptc_waiters) - 8usize];
    ["Offset of field: __pthread_cond_st::ptc_spare"]
        [::std::mem::offset_of!(__pthread_cond_st, ptc_spare) - 16usize];
    ["Offset of field: __pthread_cond_st::ptc_mutex"]
        [::std::mem::offset_of!(__pthread_cond_st, ptc_mutex) - 24usize];
    ["Offset of field: __pthread_cond_st::ptc_private"]
        [::std::mem::offset_of!(__pthread_cond_st, ptc_private) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_condattr_st {
    pub ptca_magic: ::std::os::raw::c_uint,
    pub ptca_private: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_condattr_st"][::std::mem::size_of::<__pthread_condattr_st>() - 16usize];
    ["Alignment of __pthread_condattr_st"]
        [::std::mem::align_of::<__pthread_condattr_st>() - 8usize];
    ["Offset of field: __pthread_condattr_st::ptca_magic"]
        [::std::mem::offset_of!(__pthread_condattr_st, ptca_magic) - 0usize];
    ["Offset of field: __pthread_condattr_st::ptca_private"]
        [::std::mem::offset_of!(__pthread_condattr_st, ptca_private) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_once_st {
    pub pto_mutex: pthread_mutex_t,
    pub pto_done: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_once_st"][::std::mem::size_of::<__pthread_once_st>() - 56usize];
    ["Alignment of __pthread_once_st"][::std::mem::align_of::<__pthread_once_st>() - 8usize];
    ["Offset of field: __pthread_once_st::pto_mutex"]
        [::std::mem::offset_of!(__pthread_once_st, pto_mutex) - 0usize];
    ["Offset of field: __pthread_once_st::pto_done"]
        [::std::mem::offset_of!(__pthread_once_st, pto_done) - 48usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_spinlock_st {
    pub pts_magic: ::std::os::raw::c_uint,
    pub pts_spin: __pthread_spin_t,
    pub pts_flags: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_spinlock_st"][::std::mem::size_of::<__pthread_spinlock_st>() - 12usize];
    ["Alignment of __pthread_spinlock_st"]
        [::std::mem::align_of::<__pthread_spinlock_st>() - 4usize];
    ["Offset of field: __pthread_spinlock_st::pts_magic"]
        [::std::mem::offset_of!(__pthread_spinlock_st, pts_magic) - 0usize];
    ["Offset of field: __pthread_spinlock_st::pts_spin"]
        [::std::mem::offset_of!(__pthread_spinlock_st, pts_spin) - 4usize];
    ["Offset of field: __pthread_spinlock_st::pts_flags"]
        [::std::mem::offset_of!(__pthread_spinlock_st, pts_flags) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlock_st {
    pub ptr_magic: ::std::os::raw::c_uint,
    pub ptr_interlock: __pthread_spin_t,
    pub ptr_rblocked: pthread_queue_t,
    pub ptr_wblocked: pthread_queue_t,
    pub ptr_nreaders: ::std::os::raw::c_uint,
    pub ptr_owner: pthread_t,
    pub ptr_private: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_rwlock_st"][::std::mem::size_of::<__pthread_rwlock_st>() - 64usize];
    ["Alignment of __pthread_rwlock_st"][::std::mem::align_of::<__pthread_rwlock_st>() - 8usize];
    ["Offset of field: __pthread_rwlock_st::ptr_magic"]
        [::std::mem::offset_of!(__pthread_rwlock_st, ptr_magic) - 0usize];
    ["Offset of field: __pthread_rwlock_st::ptr_interlock"]
        [::std::mem::offset_of!(__pthread_rwlock_st, ptr_interlock) - 4usize];
    ["Offset of field: __pthread_rwlock_st::ptr_rblocked"]
        [::std::mem::offset_of!(__pthread_rwlock_st, ptr_rblocked) - 8usize];
    ["Offset of field: __pthread_rwlock_st::ptr_wblocked"]
        [::std::mem::offset_of!(__pthread_rwlock_st, ptr_wblocked) - 24usize];
    ["Offset of field: __pthread_rwlock_st::ptr_nreaders"]
        [::std::mem::offset_of!(__pthread_rwlock_st, ptr_nreaders) - 40usize];
    ["Offset of field: __pthread_rwlock_st::ptr_owner"]
        [::std::mem::offset_of!(__pthread_rwlock_st, ptr_owner) - 48usize];
    ["Offset of field: __pthread_rwlock_st::ptr_private"]
        [::std::mem::offset_of!(__pthread_rwlock_st, ptr_private) - 56usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlockattr_st {
    pub ptra_magic: ::std::os::raw::c_uint,
    pub ptra_private: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_rwlockattr_st"][::std::mem::size_of::<__pthread_rwlockattr_st>() - 16usize];
    ["Alignment of __pthread_rwlockattr_st"]
        [::std::mem::align_of::<__pthread_rwlockattr_st>() - 8usize];
    ["Offset of field: __pthread_rwlockattr_st::ptra_magic"]
        [::std::mem::offset_of!(__pthread_rwlockattr_st, ptra_magic) - 0usize];
    ["Offset of field: __pthread_rwlockattr_st::ptra_private"]
        [::std::mem::offset_of!(__pthread_rwlockattr_st, ptra_private) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_barrier_st {
    pub ptb_magic: ::std::os::raw::c_uint,
    pub ptb_lock: pthread_spin_t,
    pub ptb_waiters: pthread_queue_t,
    pub ptb_initcount: ::std::os::raw::c_uint,
    pub ptb_curcount: ::std::os::raw::c_uint,
    pub ptb_generation: ::std::os::raw::c_uint,
    pub ptb_private: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_barrier_st"][::std::mem::size_of::<__pthread_barrier_st>() - 48usize];
    ["Alignment of __pthread_barrier_st"][::std::mem::align_of::<__pthread_barrier_st>() - 8usize];
    ["Offset of field: __pthread_barrier_st::ptb_magic"]
        [::std::mem::offset_of!(__pthread_barrier_st, ptb_magic) - 0usize];
    ["Offset of field: __pthread_barrier_st::ptb_lock"]
        [::std::mem::offset_of!(__pthread_barrier_st, ptb_lock) - 4usize];
    ["Offset of field: __pthread_barrier_st::ptb_waiters"]
        [::std::mem::offset_of!(__pthread_barrier_st, ptb_waiters) - 8usize];
    ["Offset of field: __pthread_barrier_st::ptb_initcount"]
        [::std::mem::offset_of!(__pthread_barrier_st, ptb_initcount) - 24usize];
    ["Offset of field: __pthread_barrier_st::ptb_curcount"]
        [::std::mem::offset_of!(__pthread_barrier_st, ptb_curcount) - 28usize];
    ["Offset of field: __pthread_barrier_st::ptb_generation"]
        [::std::mem::offset_of!(__pthread_barrier_st, ptb_generation) - 32usize];
    ["Offset of field: __pthread_barrier_st::ptb_private"]
        [::std::mem::offset_of!(__pthread_barrier_st, ptb_private) - 40usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_barrierattr_st {
    pub ptba_magic: ::std::os::raw::c_uint,
    pub ptba_private: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_barrierattr_st"]
        [::std::mem::size_of::<__pthread_barrierattr_st>() - 16usize];
    ["Alignment of __pthread_barrierattr_st"]
        [::std::mem::align_of::<__pthread_barrierattr_st>() - 8usize];
    ["Offset of field: __pthread_barrierattr_st::ptba_magic"]
        [::std::mem::offset_of!(__pthread_barrierattr_st, ptba_magic) - 0usize];
    ["Offset of field: __pthread_barrierattr_st::ptba_private"]
        [::std::mem::offset_of!(__pthread_barrierattr_st, ptba_private) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigset_t {
    pub __bits: [__uint32_t; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigset_t"][::std::mem::size_of::<sigset_t>() - 16usize];
    ["Alignment of sigset_t"][::std::mem::align_of::<sigset_t>() - 4usize];
    ["Offset of field: sigset_t::__bits"][::std::mem::offset_of!(sigset_t, __bits) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: usize,
    pub ss_flags: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigaltstack"][::std::mem::size_of::<sigaltstack>() - 24usize];
    ["Alignment of sigaltstack"][::std::mem::align_of::<sigaltstack>() - 8usize];
    ["Offset of field: sigaltstack::ss_sp"][::std::mem::offset_of!(sigaltstack, ss_sp) - 0usize];
    ["Offset of field: sigaltstack::ss_size"]
        [::std::mem::offset_of!(sigaltstack, ss_size) - 8usize];
    ["Offset of field: sigaltstack::ss_flags"]
        [::std::mem::offset_of!(sigaltstack, ss_flags) - 16usize];
};
pub type stack_t = sigaltstack;
pub type sig_atomic_t = ::std::os::raw::c_int;
pub const _REG_RDI: _bindgen_ty_1 = 0;
pub const _REG_RSI: _bindgen_ty_1 = 1;
pub const _REG_RDX: _bindgen_ty_1 = 2;
pub const _REG_R10: _bindgen_ty_1 = 6;
pub const _REG_R8: _bindgen_ty_1 = 4;
pub const _REG_R9: _bindgen_ty_1 = 5;
pub const _REG_RCX: _bindgen_ty_1 = 3;
pub const _REG_R11: _bindgen_ty_1 = 7;
pub const _REG_R12: _bindgen_ty_1 = 8;
pub const _REG_R13: _bindgen_ty_1 = 9;
pub const _REG_R14: _bindgen_ty_1 = 10;
pub const _REG_R15: _bindgen_ty_1 = 11;
pub const _REG_RBP: _bindgen_ty_1 = 12;
pub const _REG_RBX: _bindgen_ty_1 = 13;
pub const _REG_RAX: _bindgen_ty_1 = 14;
pub const _REG_GS: _bindgen_ty_1 = 15;
pub const _REG_FS: _bindgen_ty_1 = 16;
pub const _REG_ES: _bindgen_ty_1 = 17;
pub const _REG_DS: _bindgen_ty_1 = 18;
pub const _REG_TRAPNO: _bindgen_ty_1 = 19;
pub const _REG_ERR: _bindgen_ty_1 = 20;
pub const _REG_RIP: _bindgen_ty_1 = 21;
pub const _REG_CS: _bindgen_ty_1 = 22;
pub const _REG_RFLAGS: _bindgen_ty_1 = 23;
pub const _REG_RSP: _bindgen_ty_1 = 24;
pub const _REG_SS: _bindgen_ty_1 = 25;
pub const _NGREG: _bindgen_ty_1 = 26;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub type __greg_t = ::std::os::raw::c_ulong;
pub type __gregset_t = [__greg_t; 26usize];
pub type __fpregset_t = [::std::os::raw::c_char; 512usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mcontext_t {
    pub __gregs: __gregset_t,
    pub _mc_tlsbase: __greg_t,
    pub __fpregs: __fpregset_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mcontext_t"][::std::mem::size_of::<mcontext_t>() - 728usize];
    ["Alignment of mcontext_t"][::std::mem::align_of::<mcontext_t>() - 8usize];
    ["Offset of field: mcontext_t::__gregs"][::std::mem::offset_of!(mcontext_t, __gregs) - 0usize];
    ["Offset of field: mcontext_t::_mc_tlsbase"]
        [::std::mem::offset_of!(mcontext_t, _mc_tlsbase) - 208usize];
    ["Offset of field: mcontext_t::__fpregs"]
        [::std::mem::offset_of!(mcontext_t, __fpregs) - 216usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigval"][::std::mem::size_of::<sigval>() - 8usize];
    ["Alignment of sigval"][::std::mem::align_of::<sigval>() - 8usize];
    ["Offset of field: sigval::sival_int"][::std::mem::offset_of!(sigval, sival_int) - 0usize];
    ["Offset of field: sigval::sival_ptr"][::std::mem::offset_of!(sigval, sival_ptr) - 0usize];
};
pub type sigval_t = sigval;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ksiginfo {
    pub _signo: ::std::os::raw::c_int,
    pub _code: ::std::os::raw::c_int,
    pub _errno: ::std::os::raw::c_int,
    pub _pad: ::std::os::raw::c_int,
    pub _reason: _ksiginfo__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _ksiginfo__bindgen_ty_1 {
    pub _rt: _ksiginfo__bindgen_ty_1__bindgen_ty_1,
    pub _child: _ksiginfo__bindgen_ty_1__bindgen_ty_2,
    pub _fault: _ksiginfo__bindgen_ty_1__bindgen_ty_3,
    pub _poll: _ksiginfo__bindgen_ty_1__bindgen_ty_4,
    pub _syscall: _ksiginfo__bindgen_ty_1__bindgen_ty_5,
    pub _ptrace_state: _ksiginfo__bindgen_ty_1__bindgen_ty_6,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ksiginfo__bindgen_ty_1__bindgen_ty_1 {
    pub _pid: __pid_t,
    pub _uid: __uid_t,
    pub _value: sigval_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ksiginfo__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_1>() - 16usize];
    ["Alignment of _ksiginfo__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_1::_pid"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_1, _pid) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_1::_uid"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_1, _uid) - 4usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_1::_value"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_1, _value) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ksiginfo__bindgen_ty_1__bindgen_ty_2 {
    pub _pid: __pid_t,
    pub _uid: __uid_t,
    pub _status: ::std::os::raw::c_int,
    pub _utime: clock_t,
    pub _stime: clock_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ksiginfo__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_2>() - 20usize];
    ["Alignment of _ksiginfo__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_2>() - 4usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_2::_pid"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_2, _pid) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_2::_uid"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_2, _uid) - 4usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_2::_status"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_2, _status) - 8usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_2::_utime"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_2, _utime) - 12usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_2::_stime"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_2, _stime) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ksiginfo__bindgen_ty_1__bindgen_ty_3 {
    pub _addr: *mut ::std::os::raw::c_void,
    pub _trap: ::std::os::raw::c_int,
    pub _trap2: ::std::os::raw::c_int,
    pub _trap3: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ksiginfo__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::size_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_3>() - 24usize];
    ["Alignment of _ksiginfo__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::align_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_3>() - 8usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_3::_addr"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_3, _addr) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_3::_trap"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_3, _trap) - 8usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_3::_trap2"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_3, _trap2) - 12usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_3::_trap3"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_3, _trap3) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ksiginfo__bindgen_ty_1__bindgen_ty_4 {
    pub _band: ::std::os::raw::c_long,
    pub _fd: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ksiginfo__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::size_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_4>() - 16usize];
    ["Alignment of _ksiginfo__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::align_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_4>() - 8usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_4::_band"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_4, _band) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_4::_fd"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_4, _fd) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ksiginfo__bindgen_ty_1__bindgen_ty_5 {
    pub _sysnum: ::std::os::raw::c_int,
    pub _retval: [::std::os::raw::c_int; 2usize],
    pub _error: ::std::os::raw::c_int,
    pub _args: [u64; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ksiginfo__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::size_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_5>() - 80usize];
    ["Alignment of _ksiginfo__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::align_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_5>() - 8usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_5::_sysnum"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_5, _sysnum) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_5::_retval"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_5, _retval) - 4usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_5::_error"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_5, _error) - 12usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_5::_args"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_5, _args) - 16usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ksiginfo__bindgen_ty_1__bindgen_ty_6 {
    pub _pe_report_event: ::std::os::raw::c_int,
    pub _option: _ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1 {
    pub _pe_other_pid: __pid_t,
    pub _pe_lwp: lwpid_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1"]
        [::std::mem::size_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1>() - 4usize];
    ["Alignment of _ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1"]
        [::std::mem::align_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1>() - 4usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1::_pe_other_pid"][::std::mem::offset_of!(
        _ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1,
        _pe_other_pid
    )
        - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1::_pe_lwp"][::std::mem::offset_of!(
        _ksiginfo__bindgen_ty_1__bindgen_ty_6__bindgen_ty_1,
        _pe_lwp
    ) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ksiginfo__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::size_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_6>() - 8usize];
    ["Alignment of _ksiginfo__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::align_of::<_ksiginfo__bindgen_ty_1__bindgen_ty_6>() - 4usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_6::_pe_report_event"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_6, _pe_report_event) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1__bindgen_ty_6::_option"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1__bindgen_ty_6, _option) - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ksiginfo__bindgen_ty_1"][::std::mem::size_of::<_ksiginfo__bindgen_ty_1>() - 80usize];
    ["Alignment of _ksiginfo__bindgen_ty_1"]
        [::std::mem::align_of::<_ksiginfo__bindgen_ty_1>() - 8usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1::_rt"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1, _rt) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1::_child"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1, _child) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1::_fault"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1, _fault) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1::_poll"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1, _poll) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1::_syscall"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1, _syscall) - 0usize];
    ["Offset of field: _ksiginfo__bindgen_ty_1::_ptrace_state"]
        [::std::mem::offset_of!(_ksiginfo__bindgen_ty_1, _ptrace_state) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _ksiginfo"][::std::mem::size_of::<_ksiginfo>() - 96usize];
    ["Alignment of _ksiginfo"][::std::mem::align_of::<_ksiginfo>() - 8usize];
    ["Offset of field: _ksiginfo::_signo"][::std::mem::offset_of!(_ksiginfo, _signo) - 0usize];
    ["Offset of field: _ksiginfo::_code"][::std::mem::offset_of!(_ksiginfo, _code) - 4usize];
    ["Offset of field: _ksiginfo::_errno"][::std::mem::offset_of!(_ksiginfo, _errno) - 8usize];
    ["Offset of field: _ksiginfo::_pad"][::std::mem::offset_of!(_ksiginfo, _pad) - 12usize];
    ["Offset of field: _ksiginfo::_reason"][::std::mem::offset_of!(_ksiginfo, _reason) - 16usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo {
    pub si_pad: [::std::os::raw::c_char; 128usize],
    pub _info: _ksiginfo,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of siginfo"][::std::mem::size_of::<siginfo>() - 128usize];
    ["Alignment of siginfo"][::std::mem::align_of::<siginfo>() - 8usize];
    ["Offset of field: siginfo::si_pad"][::std::mem::offset_of!(siginfo, si_pad) - 0usize];
    ["Offset of field: siginfo::_info"][::std::mem::offset_of!(siginfo, _info) - 0usize];
};
pub type siginfo_t = siginfo;
pub type ucontext_t = __ucontext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __ucontext {
    pub uc_flags: ::std::os::raw::c_uint,
    pub uc_link: *mut ucontext_t,
    pub uc_sigmask: sigset_t,
    pub uc_stack: stack_t,
    pub uc_mcontext: mcontext_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __ucontext"][::std::mem::size_of::<__ucontext>() - 784usize];
    ["Alignment of __ucontext"][::std::mem::align_of::<__ucontext>() - 8usize];
    ["Offset of field: __ucontext::uc_flags"]
        [::std::mem::offset_of!(__ucontext, uc_flags) - 0usize];
    ["Offset of field: __ucontext::uc_link"][::std::mem::offset_of!(__ucontext, uc_link) - 8usize];
    ["Offset of field: __ucontext::uc_sigmask"]
        [::std::mem::offset_of!(__ucontext, uc_sigmask) - 16usize];
    ["Offset of field: __ucontext::uc_stack"]
        [::std::mem::offset_of!(__ucontext, uc_stack) - 32usize];
    ["Offset of field: __ucontext::uc_mcontext"]
        [::std::mem::offset_of!(__ucontext, uc_mcontext) - 56usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub _sa_u: sigaction__bindgen_ty_1,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigaction__bindgen_ty_1 {
    pub _sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub _sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut siginfo_t,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigaction__bindgen_ty_1"][::std::mem::size_of::<sigaction__bindgen_ty_1>() - 8usize];
    ["Alignment of sigaction__bindgen_ty_1"]
        [::std::mem::align_of::<sigaction__bindgen_ty_1>() - 8usize];
    ["Offset of field: sigaction__bindgen_ty_1::_sa_handler"]
        [::std::mem::offset_of!(sigaction__bindgen_ty_1, _sa_handler) - 0usize];
    ["Offset of field: sigaction__bindgen_ty_1::_sa_sigaction"]
        [::std::mem::offset_of!(sigaction__bindgen_ty_1, _sa_sigaction) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigaction"][::std::mem::size_of::<sigaction>() - 32usize];
    ["Alignment of sigaction"][::std::mem::align_of::<sigaction>() - 8usize];
    ["Offset of field: sigaction::_sa_u"][::std::mem::offset_of!(sigaction, _sa_u) - 0usize];
    ["Offset of field: sigaction::sa_mask"][::std::mem::offset_of!(sigaction, sa_mask) - 8usize];
    ["Offset of field: sigaction::sa_flags"][::std::mem::offset_of!(sigaction, sa_flags) - 24usize];
};
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigstack"][::std::mem::size_of::<sigstack>() - 16usize];
    ["Alignment of sigstack"][::std::mem::align_of::<sigstack>() - 8usize];
    ["Offset of field: sigstack::ss_sp"][::std::mem::offset_of!(sigstack, ss_sp) - 0usize];
    ["Offset of field: sigstack::ss_onstack"]
        [::std::mem::offset_of!(sigstack, ss_onstack) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sigevent"][::std::mem::size_of::<sigevent>() - 32usize];
    ["Alignment of sigevent"][::std::mem::align_of::<sigevent>() - 8usize];
    ["Offset of field: sigevent::sigev_notify"]
        [::std::mem::offset_of!(sigevent, sigev_notify) - 0usize];
    ["Offset of field: sigevent::sigev_signo"]
        [::std::mem::offset_of!(sigevent, sigev_signo) - 4usize];
    ["Offset of field: sigevent::sigev_value"]
        [::std::mem::offset_of!(sigevent, sigev_value) - 8usize];
    ["Offset of field: sigevent::sigev_notify_function"]
        [::std::mem::offset_of!(sigevent, sigev_notify_function) - 16usize];
    ["Offset of field: sigevent::sigev_notify_attributes"]
        [::std::mem::offset_of!(sigevent, sigev_notify_attributes) - 24usize];
};
unsafe extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
unsafe extern "C" {
    pub fn sigqueue(
        arg1: __pid_t,
        arg2: ::std::os::raw::c_int,
        arg3: sigval,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn bsd_signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
unsafe extern "C" {
    pub fn sigqueueinfo(arg1: __pid_t, arg2: *const siginfo_t) -> ::std::os::raw::c_int;
}
pub type uvm_flag_t = ::std::os::raw::c_uint;
pub type vm_inherit_t = ::std::os::raw::c_int;
pub type voff_t = __off_t;
pub type pgoff_t = voff_t;
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of max_align_t"][::std::mem::size_of::<max_align_t>() - 32usize];
    ["Alignment of max_align_t"][::std::mem::align_of::<max_align_t>() - 16usize];
    ["Offset of field: max_align_t::__clang_max_align_nonce1"]
        [::std::mem::offset_of!(max_align_t, __clang_max_align_nonce1) - 0usize];
    ["Offset of field: max_align_t::__clang_max_align_nonce2"]
        [::std::mem::offset_of!(max_align_t, __clang_max_align_nonce2) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ctlname {
    pub ctl_name: *const ::std::os::raw::c_char,
    pub ctl_type: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ctlname"][::std::mem::size_of::<ctlname>() - 16usize];
    ["Alignment of ctlname"][::std::mem::align_of::<ctlname>() - 8usize];
    ["Offset of field: ctlname::ctl_name"][::std::mem::offset_of!(ctlname, ctl_name) - 0usize];
    ["Offset of field: ctlname::ctl_type"][::std::mem::offset_of!(ctlname, ctl_type) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct clockinfo {
    pub hz: ::std::os::raw::c_int,
    pub tick: ::std::os::raw::c_int,
    pub tickadj: ::std::os::raw::c_int,
    pub stathz: ::std::os::raw::c_int,
    pub profhz: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clockinfo"][::std::mem::size_of::<clockinfo>() - 20usize];
    ["Alignment of clockinfo"][::std::mem::align_of::<clockinfo>() - 4usize];
    ["Offset of field: clockinfo::hz"][::std::mem::offset_of!(clockinfo, hz) - 0usize];
    ["Offset of field: clockinfo::tick"][::std::mem::offset_of!(clockinfo, tick) - 4usize];
    ["Offset of field: clockinfo::tickadj"][::std::mem::offset_of!(clockinfo, tickadj) - 8usize];
    ["Offset of field: clockinfo::stathz"][::std::mem::offset_of!(clockinfo, stathz) - 12usize];
    ["Offset of field: clockinfo::profhz"][::std::mem::offset_of!(clockinfo, profhz) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ki_pcred {
    pub p_pad: *mut ::std::os::raw::c_void,
    pub p_ruid: __uid_t,
    pub p_svuid: __uid_t,
    pub p_rgid: __gid_t,
    pub p_svgid: __gid_t,
    pub p_refcnt: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ki_pcred"][::std::mem::size_of::<ki_pcred>() - 32usize];
    ["Alignment of ki_pcred"][::std::mem::align_of::<ki_pcred>() - 8usize];
    ["Offset of field: ki_pcred::p_pad"][::std::mem::offset_of!(ki_pcred, p_pad) - 0usize];
    ["Offset of field: ki_pcred::p_ruid"][::std::mem::offset_of!(ki_pcred, p_ruid) - 8usize];
    ["Offset of field: ki_pcred::p_svuid"][::std::mem::offset_of!(ki_pcred, p_svuid) - 12usize];
    ["Offset of field: ki_pcred::p_rgid"][::std::mem::offset_of!(ki_pcred, p_rgid) - 16usize];
    ["Offset of field: ki_pcred::p_svgid"][::std::mem::offset_of!(ki_pcred, p_svgid) - 20usize];
    ["Offset of field: ki_pcred::p_refcnt"][::std::mem::offset_of!(ki_pcred, p_refcnt) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ki_ucred {
    pub cr_ref: u32,
    pub cr_uid: __uid_t,
    pub cr_gid: __gid_t,
    pub cr_ngroups: u32,
    pub cr_groups: [__gid_t; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ki_ucred"][::std::mem::size_of::<ki_ucred>() - 80usize];
    ["Alignment of ki_ucred"][::std::mem::align_of::<ki_ucred>() - 4usize];
    ["Offset of field: ki_ucred::cr_ref"][::std::mem::offset_of!(ki_ucred, cr_ref) - 0usize];
    ["Offset of field: ki_ucred::cr_uid"][::std::mem::offset_of!(ki_ucred, cr_uid) - 4usize];
    ["Offset of field: ki_ucred::cr_gid"][::std::mem::offset_of!(ki_ucred, cr_gid) - 8usize];
    ["Offset of field: ki_ucred::cr_ngroups"]
        [::std::mem::offset_of!(ki_ucred, cr_ngroups) - 12usize];
    ["Offset of field: ki_ucred::cr_groups"][::std::mem::offset_of!(ki_ucred, cr_groups) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ki_sigset_t {
    pub __bits: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ki_sigset_t"][::std::mem::size_of::<ki_sigset_t>() - 16usize];
    ["Alignment of ki_sigset_t"][::std::mem::align_of::<ki_sigset_t>() - 4usize];
    ["Offset of field: ki_sigset_t::__bits"][::std::mem::offset_of!(ki_sigset_t, __bits) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kinfo_proc2 {
    pub p_forw: u64,
    pub p_back: u64,
    pub p_paddr: u64,
    pub p_addr: u64,
    pub p_fd: u64,
    pub p_cwdi: u64,
    pub p_stats: u64,
    pub p_limit: u64,
    pub p_vmspace: u64,
    pub p_sigacts: u64,
    pub p_sess: u64,
    pub p_tsess: u64,
    pub p_ru: u64,
    pub p_eflag: i32,
    pub p_exitsig: i32,
    pub p_flag: i32,
    pub p_pid: i32,
    pub p_ppid: i32,
    pub p_sid: i32,
    pub p__pgid: i32,
    pub p_tpgid: i32,
    pub p_uid: u32,
    pub p_ruid: u32,
    pub p_gid: u32,
    pub p_rgid: u32,
    pub p_groups: [u32; 16usize],
    pub p_ngroups: i16,
    pub p_jobc: i16,
    pub p_tdev: u32,
    pub p_estcpu: u32,
    pub p_rtime_sec: u32,
    pub p_rtime_usec: u32,
    pub p_cpticks: i32,
    pub p_pctcpu: u32,
    pub p_swtime: u32,
    pub p_slptime: u32,
    pub p_schedflags: i32,
    pub p_uticks: u64,
    pub p_sticks: u64,
    pub p_iticks: u64,
    pub p_tracep: u64,
    pub p_traceflag: i32,
    pub p_holdcnt: i32,
    pub p_siglist: ki_sigset_t,
    pub p_sigmask: ki_sigset_t,
    pub p_sigignore: ki_sigset_t,
    pub p_sigcatch: ki_sigset_t,
    pub p_stat: i8,
    pub p_priority: u8,
    pub p_usrpri: u8,
    pub p_nice: u8,
    pub p_xstat: u16,
    pub p_acflag: u16,
    pub p_comm: [::std::os::raw::c_char; 24usize],
    pub p_wmesg: [::std::os::raw::c_char; 8usize],
    pub p_wchan: u64,
    pub p_login: [::std::os::raw::c_char; 24usize],
    pub p_vm_rssize: i32,
    pub p_vm_tsize: i32,
    pub p_vm_dsize: i32,
    pub p_vm_ssize: i32,
    pub p_uvalid: i64,
    pub p_ustart_sec: u32,
    pub p_ustart_usec: u32,
    pub p_uutime_sec: u32,
    pub p_uutime_usec: u32,
    pub p_ustime_sec: u32,
    pub p_ustime_usec: u32,
    pub p_uru_maxrss: u64,
    pub p_uru_ixrss: u64,
    pub p_uru_idrss: u64,
    pub p_uru_isrss: u64,
    pub p_uru_minflt: u64,
    pub p_uru_majflt: u64,
    pub p_uru_nswap: u64,
    pub p_uru_inblock: u64,
    pub p_uru_oublock: u64,
    pub p_uru_msgsnd: u64,
    pub p_uru_msgrcv: u64,
    pub p_uru_nsignals: u64,
    pub p_uru_nvcsw: u64,
    pub p_uru_nivcsw: u64,
    pub p_uctime_sec: u32,
    pub p_uctime_usec: u32,
    pub p_cpuid: u64,
    pub p_realflag: u64,
    pub p_nlwps: u64,
    pub p_nrlwps: u64,
    pub p_realstat: u64,
    pub p_svuid: u32,
    pub p_svgid: u32,
    pub p_ename: [::std::os::raw::c_char; 16usize],
    pub p_vm_vsize: i64,
    pub p_vm_msize: i64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_proc2"][::std::mem::size_of::<kinfo_proc2>() - 680usize];
    ["Alignment of kinfo_proc2"][::std::mem::align_of::<kinfo_proc2>() - 8usize];
    ["Offset of field: kinfo_proc2::p_forw"][::std::mem::offset_of!(kinfo_proc2, p_forw) - 0usize];
    ["Offset of field: kinfo_proc2::p_back"][::std::mem::offset_of!(kinfo_proc2, p_back) - 8usize];
    ["Offset of field: kinfo_proc2::p_paddr"]
        [::std::mem::offset_of!(kinfo_proc2, p_paddr) - 16usize];
    ["Offset of field: kinfo_proc2::p_addr"][::std::mem::offset_of!(kinfo_proc2, p_addr) - 24usize];
    ["Offset of field: kinfo_proc2::p_fd"][::std::mem::offset_of!(kinfo_proc2, p_fd) - 32usize];
    ["Offset of field: kinfo_proc2::p_cwdi"][::std::mem::offset_of!(kinfo_proc2, p_cwdi) - 40usize];
    ["Offset of field: kinfo_proc2::p_stats"]
        [::std::mem::offset_of!(kinfo_proc2, p_stats) - 48usize];
    ["Offset of field: kinfo_proc2::p_limit"]
        [::std::mem::offset_of!(kinfo_proc2, p_limit) - 56usize];
    ["Offset of field: kinfo_proc2::p_vmspace"]
        [::std::mem::offset_of!(kinfo_proc2, p_vmspace) - 64usize];
    ["Offset of field: kinfo_proc2::p_sigacts"]
        [::std::mem::offset_of!(kinfo_proc2, p_sigacts) - 72usize];
    ["Offset of field: kinfo_proc2::p_sess"][::std::mem::offset_of!(kinfo_proc2, p_sess) - 80usize];
    ["Offset of field: kinfo_proc2::p_tsess"]
        [::std::mem::offset_of!(kinfo_proc2, p_tsess) - 88usize];
    ["Offset of field: kinfo_proc2::p_ru"][::std::mem::offset_of!(kinfo_proc2, p_ru) - 96usize];
    ["Offset of field: kinfo_proc2::p_eflag"]
        [::std::mem::offset_of!(kinfo_proc2, p_eflag) - 104usize];
    ["Offset of field: kinfo_proc2::p_exitsig"]
        [::std::mem::offset_of!(kinfo_proc2, p_exitsig) - 108usize];
    ["Offset of field: kinfo_proc2::p_flag"]
        [::std::mem::offset_of!(kinfo_proc2, p_flag) - 112usize];
    ["Offset of field: kinfo_proc2::p_pid"][::std::mem::offset_of!(kinfo_proc2, p_pid) - 116usize];
    ["Offset of field: kinfo_proc2::p_ppid"]
        [::std::mem::offset_of!(kinfo_proc2, p_ppid) - 120usize];
    ["Offset of field: kinfo_proc2::p_sid"][::std::mem::offset_of!(kinfo_proc2, p_sid) - 124usize];
    ["Offset of field: kinfo_proc2::p__pgid"]
        [::std::mem::offset_of!(kinfo_proc2, p__pgid) - 128usize];
    ["Offset of field: kinfo_proc2::p_tpgid"]
        [::std::mem::offset_of!(kinfo_proc2, p_tpgid) - 132usize];
    ["Offset of field: kinfo_proc2::p_uid"][::std::mem::offset_of!(kinfo_proc2, p_uid) - 136usize];
    ["Offset of field: kinfo_proc2::p_ruid"]
        [::std::mem::offset_of!(kinfo_proc2, p_ruid) - 140usize];
    ["Offset of field: kinfo_proc2::p_gid"][::std::mem::offset_of!(kinfo_proc2, p_gid) - 144usize];
    ["Offset of field: kinfo_proc2::p_rgid"]
        [::std::mem::offset_of!(kinfo_proc2, p_rgid) - 148usize];
    ["Offset of field: kinfo_proc2::p_groups"]
        [::std::mem::offset_of!(kinfo_proc2, p_groups) - 152usize];
    ["Offset of field: kinfo_proc2::p_ngroups"]
        [::std::mem::offset_of!(kinfo_proc2, p_ngroups) - 216usize];
    ["Offset of field: kinfo_proc2::p_jobc"]
        [::std::mem::offset_of!(kinfo_proc2, p_jobc) - 218usize];
    ["Offset of field: kinfo_proc2::p_tdev"]
        [::std::mem::offset_of!(kinfo_proc2, p_tdev) - 220usize];
    ["Offset of field: kinfo_proc2::p_estcpu"]
        [::std::mem::offset_of!(kinfo_proc2, p_estcpu) - 224usize];
    ["Offset of field: kinfo_proc2::p_rtime_sec"]
        [::std::mem::offset_of!(kinfo_proc2, p_rtime_sec) - 228usize];
    ["Offset of field: kinfo_proc2::p_rtime_usec"]
        [::std::mem::offset_of!(kinfo_proc2, p_rtime_usec) - 232usize];
    ["Offset of field: kinfo_proc2::p_cpticks"]
        [::std::mem::offset_of!(kinfo_proc2, p_cpticks) - 236usize];
    ["Offset of field: kinfo_proc2::p_pctcpu"]
        [::std::mem::offset_of!(kinfo_proc2, p_pctcpu) - 240usize];
    ["Offset of field: kinfo_proc2::p_swtime"]
        [::std::mem::offset_of!(kinfo_proc2, p_swtime) - 244usize];
    ["Offset of field: kinfo_proc2::p_slptime"]
        [::std::mem::offset_of!(kinfo_proc2, p_slptime) - 248usize];
    ["Offset of field: kinfo_proc2::p_schedflags"]
        [::std::mem::offset_of!(kinfo_proc2, p_schedflags) - 252usize];
    ["Offset of field: kinfo_proc2::p_uticks"]
        [::std::mem::offset_of!(kinfo_proc2, p_uticks) - 256usize];
    ["Offset of field: kinfo_proc2::p_sticks"]
        [::std::mem::offset_of!(kinfo_proc2, p_sticks) - 264usize];
    ["Offset of field: kinfo_proc2::p_iticks"]
        [::std::mem::offset_of!(kinfo_proc2, p_iticks) - 272usize];
    ["Offset of field: kinfo_proc2::p_tracep"]
        [::std::mem::offset_of!(kinfo_proc2, p_tracep) - 280usize];
    ["Offset of field: kinfo_proc2::p_traceflag"]
        [::std::mem::offset_of!(kinfo_proc2, p_traceflag) - 288usize];
    ["Offset of field: kinfo_proc2::p_holdcnt"]
        [::std::mem::offset_of!(kinfo_proc2, p_holdcnt) - 292usize];
    ["Offset of field: kinfo_proc2::p_siglist"]
        [::std::mem::offset_of!(kinfo_proc2, p_siglist) - 296usize];
    ["Offset of field: kinfo_proc2::p_sigmask"]
        [::std::mem::offset_of!(kinfo_proc2, p_sigmask) - 312usize];
    ["Offset of field: kinfo_proc2::p_sigignore"]
        [::std::mem::offset_of!(kinfo_proc2, p_sigignore) - 328usize];
    ["Offset of field: kinfo_proc2::p_sigcatch"]
        [::std::mem::offset_of!(kinfo_proc2, p_sigcatch) - 344usize];
    ["Offset of field: kinfo_proc2::p_stat"]
        [::std::mem::offset_of!(kinfo_proc2, p_stat) - 360usize];
    ["Offset of field: kinfo_proc2::p_priority"]
        [::std::mem::offset_of!(kinfo_proc2, p_priority) - 361usize];
    ["Offset of field: kinfo_proc2::p_usrpri"]
        [::std::mem::offset_of!(kinfo_proc2, p_usrpri) - 362usize];
    ["Offset of field: kinfo_proc2::p_nice"]
        [::std::mem::offset_of!(kinfo_proc2, p_nice) - 363usize];
    ["Offset of field: kinfo_proc2::p_xstat"]
        [::std::mem::offset_of!(kinfo_proc2, p_xstat) - 364usize];
    ["Offset of field: kinfo_proc2::p_acflag"]
        [::std::mem::offset_of!(kinfo_proc2, p_acflag) - 366usize];
    ["Offset of field: kinfo_proc2::p_comm"]
        [::std::mem::offset_of!(kinfo_proc2, p_comm) - 368usize];
    ["Offset of field: kinfo_proc2::p_wmesg"]
        [::std::mem::offset_of!(kinfo_proc2, p_wmesg) - 392usize];
    ["Offset of field: kinfo_proc2::p_wchan"]
        [::std::mem::offset_of!(kinfo_proc2, p_wchan) - 400usize];
    ["Offset of field: kinfo_proc2::p_login"]
        [::std::mem::offset_of!(kinfo_proc2, p_login) - 408usize];
    ["Offset of field: kinfo_proc2::p_vm_rssize"]
        [::std::mem::offset_of!(kinfo_proc2, p_vm_rssize) - 432usize];
    ["Offset of field: kinfo_proc2::p_vm_tsize"]
        [::std::mem::offset_of!(kinfo_proc2, p_vm_tsize) - 436usize];
    ["Offset of field: kinfo_proc2::p_vm_dsize"]
        [::std::mem::offset_of!(kinfo_proc2, p_vm_dsize) - 440usize];
    ["Offset of field: kinfo_proc2::p_vm_ssize"]
        [::std::mem::offset_of!(kinfo_proc2, p_vm_ssize) - 444usize];
    ["Offset of field: kinfo_proc2::p_uvalid"]
        [::std::mem::offset_of!(kinfo_proc2, p_uvalid) - 448usize];
    ["Offset of field: kinfo_proc2::p_ustart_sec"]
        [::std::mem::offset_of!(kinfo_proc2, p_ustart_sec) - 456usize];
    ["Offset of field: kinfo_proc2::p_ustart_usec"]
        [::std::mem::offset_of!(kinfo_proc2, p_ustart_usec) - 460usize];
    ["Offset of field: kinfo_proc2::p_uutime_sec"]
        [::std::mem::offset_of!(kinfo_proc2, p_uutime_sec) - 464usize];
    ["Offset of field: kinfo_proc2::p_uutime_usec"]
        [::std::mem::offset_of!(kinfo_proc2, p_uutime_usec) - 468usize];
    ["Offset of field: kinfo_proc2::p_ustime_sec"]
        [::std::mem::offset_of!(kinfo_proc2, p_ustime_sec) - 472usize];
    ["Offset of field: kinfo_proc2::p_ustime_usec"]
        [::std::mem::offset_of!(kinfo_proc2, p_ustime_usec) - 476usize];
    ["Offset of field: kinfo_proc2::p_uru_maxrss"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_maxrss) - 480usize];
    ["Offset of field: kinfo_proc2::p_uru_ixrss"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_ixrss) - 488usize];
    ["Offset of field: kinfo_proc2::p_uru_idrss"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_idrss) - 496usize];
    ["Offset of field: kinfo_proc2::p_uru_isrss"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_isrss) - 504usize];
    ["Offset of field: kinfo_proc2::p_uru_minflt"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_minflt) - 512usize];
    ["Offset of field: kinfo_proc2::p_uru_majflt"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_majflt) - 520usize];
    ["Offset of field: kinfo_proc2::p_uru_nswap"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_nswap) - 528usize];
    ["Offset of field: kinfo_proc2::p_uru_inblock"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_inblock) - 536usize];
    ["Offset of field: kinfo_proc2::p_uru_oublock"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_oublock) - 544usize];
    ["Offset of field: kinfo_proc2::p_uru_msgsnd"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_msgsnd) - 552usize];
    ["Offset of field: kinfo_proc2::p_uru_msgrcv"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_msgrcv) - 560usize];
    ["Offset of field: kinfo_proc2::p_uru_nsignals"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_nsignals) - 568usize];
    ["Offset of field: kinfo_proc2::p_uru_nvcsw"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_nvcsw) - 576usize];
    ["Offset of field: kinfo_proc2::p_uru_nivcsw"]
        [::std::mem::offset_of!(kinfo_proc2, p_uru_nivcsw) - 584usize];
    ["Offset of field: kinfo_proc2::p_uctime_sec"]
        [::std::mem::offset_of!(kinfo_proc2, p_uctime_sec) - 592usize];
    ["Offset of field: kinfo_proc2::p_uctime_usec"]
        [::std::mem::offset_of!(kinfo_proc2, p_uctime_usec) - 596usize];
    ["Offset of field: kinfo_proc2::p_cpuid"]
        [::std::mem::offset_of!(kinfo_proc2, p_cpuid) - 600usize];
    ["Offset of field: kinfo_proc2::p_realflag"]
        [::std::mem::offset_of!(kinfo_proc2, p_realflag) - 608usize];
    ["Offset of field: kinfo_proc2::p_nlwps"]
        [::std::mem::offset_of!(kinfo_proc2, p_nlwps) - 616usize];
    ["Offset of field: kinfo_proc2::p_nrlwps"]
        [::std::mem::offset_of!(kinfo_proc2, p_nrlwps) - 624usize];
    ["Offset of field: kinfo_proc2::p_realstat"]
        [::std::mem::offset_of!(kinfo_proc2, p_realstat) - 632usize];
    ["Offset of field: kinfo_proc2::p_svuid"]
        [::std::mem::offset_of!(kinfo_proc2, p_svuid) - 640usize];
    ["Offset of field: kinfo_proc2::p_svgid"]
        [::std::mem::offset_of!(kinfo_proc2, p_svgid) - 644usize];
    ["Offset of field: kinfo_proc2::p_ename"]
        [::std::mem::offset_of!(kinfo_proc2, p_ename) - 648usize];
    ["Offset of field: kinfo_proc2::p_vm_vsize"]
        [::std::mem::offset_of!(kinfo_proc2, p_vm_vsize) - 664usize];
    ["Offset of field: kinfo_proc2::p_vm_msize"]
        [::std::mem::offset_of!(kinfo_proc2, p_vm_msize) - 672usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kinfo_lwp {
    pub l_forw: u64,
    pub l_back: u64,
    pub l_laddr: u64,
    pub l_addr: u64,
    pub l_lid: i32,
    pub l_flag: i32,
    pub l_swtime: u32,
    pub l_slptime: u32,
    pub l_schedflags: i32,
    pub l_holdcnt: i32,
    pub l_priority: u8,
    pub l_usrpri: u8,
    pub l_stat: i8,
    pub l_pad1: i8,
    pub l_pad2: i32,
    pub l_wmesg: [::std::os::raw::c_char; 8usize],
    pub l_wchan: u64,
    pub l_cpuid: u64,
    pub l_rtime_sec: u32,
    pub l_rtime_usec: u32,
    pub l_cpticks: u32,
    pub l_pctcpu: u32,
    pub l_pid: u32,
    pub l_name: [::std::os::raw::c_char; 20usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_lwp"][::std::mem::size_of::<kinfo_lwp>() - 128usize];
    ["Alignment of kinfo_lwp"][::std::mem::align_of::<kinfo_lwp>() - 8usize];
    ["Offset of field: kinfo_lwp::l_forw"][::std::mem::offset_of!(kinfo_lwp, l_forw) - 0usize];
    ["Offset of field: kinfo_lwp::l_back"][::std::mem::offset_of!(kinfo_lwp, l_back) - 8usize];
    ["Offset of field: kinfo_lwp::l_laddr"][::std::mem::offset_of!(kinfo_lwp, l_laddr) - 16usize];
    ["Offset of field: kinfo_lwp::l_addr"][::std::mem::offset_of!(kinfo_lwp, l_addr) - 24usize];
    ["Offset of field: kinfo_lwp::l_lid"][::std::mem::offset_of!(kinfo_lwp, l_lid) - 32usize];
    ["Offset of field: kinfo_lwp::l_flag"][::std::mem::offset_of!(kinfo_lwp, l_flag) - 36usize];
    ["Offset of field: kinfo_lwp::l_swtime"][::std::mem::offset_of!(kinfo_lwp, l_swtime) - 40usize];
    ["Offset of field: kinfo_lwp::l_slptime"]
        [::std::mem::offset_of!(kinfo_lwp, l_slptime) - 44usize];
    ["Offset of field: kinfo_lwp::l_schedflags"]
        [::std::mem::offset_of!(kinfo_lwp, l_schedflags) - 48usize];
    ["Offset of field: kinfo_lwp::l_holdcnt"]
        [::std::mem::offset_of!(kinfo_lwp, l_holdcnt) - 52usize];
    ["Offset of field: kinfo_lwp::l_priority"]
        [::std::mem::offset_of!(kinfo_lwp, l_priority) - 56usize];
    ["Offset of field: kinfo_lwp::l_usrpri"][::std::mem::offset_of!(kinfo_lwp, l_usrpri) - 57usize];
    ["Offset of field: kinfo_lwp::l_stat"][::std::mem::offset_of!(kinfo_lwp, l_stat) - 58usize];
    ["Offset of field: kinfo_lwp::l_pad1"][::std::mem::offset_of!(kinfo_lwp, l_pad1) - 59usize];
    ["Offset of field: kinfo_lwp::l_pad2"][::std::mem::offset_of!(kinfo_lwp, l_pad2) - 60usize];
    ["Offset of field: kinfo_lwp::l_wmesg"][::std::mem::offset_of!(kinfo_lwp, l_wmesg) - 64usize];
    ["Offset of field: kinfo_lwp::l_wchan"][::std::mem::offset_of!(kinfo_lwp, l_wchan) - 72usize];
    ["Offset of field: kinfo_lwp::l_cpuid"][::std::mem::offset_of!(kinfo_lwp, l_cpuid) - 80usize];
    ["Offset of field: kinfo_lwp::l_rtime_sec"]
        [::std::mem::offset_of!(kinfo_lwp, l_rtime_sec) - 88usize];
    ["Offset of field: kinfo_lwp::l_rtime_usec"]
        [::std::mem::offset_of!(kinfo_lwp, l_rtime_usec) - 92usize];
    ["Offset of field: kinfo_lwp::l_cpticks"]
        [::std::mem::offset_of!(kinfo_lwp, l_cpticks) - 96usize];
    ["Offset of field: kinfo_lwp::l_pctcpu"]
        [::std::mem::offset_of!(kinfo_lwp, l_pctcpu) - 100usize];
    ["Offset of field: kinfo_lwp::l_pid"][::std::mem::offset_of!(kinfo_lwp, l_pid) - 104usize];
    ["Offset of field: kinfo_lwp::l_name"][::std::mem::offset_of!(kinfo_lwp, l_name) - 108usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kinfo_drivers {
    pub d_cmajor: __devmajor_t,
    pub d_bmajor: __devmajor_t,
    pub d_name: [::std::os::raw::c_char; 24usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_drivers"][::std::mem::size_of::<kinfo_drivers>() - 32usize];
    ["Alignment of kinfo_drivers"][::std::mem::align_of::<kinfo_drivers>() - 4usize];
    ["Offset of field: kinfo_drivers::d_cmajor"]
        [::std::mem::offset_of!(kinfo_drivers, d_cmajor) - 0usize];
    ["Offset of field: kinfo_drivers::d_bmajor"]
        [::std::mem::offset_of!(kinfo_drivers, d_bmajor) - 4usize];
    ["Offset of field: kinfo_drivers::d_name"]
        [::std::mem::offset_of!(kinfo_drivers, d_name) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct buf_sysctl {
    pub b_flags: u32,
    pub b_error: i32,
    pub b_prio: i32,
    pub b_dev: u32,
    pub b_bufsize: u64,
    pub b_bcount: u64,
    pub b_resid: u64,
    pub b_addr: u64,
    pub b_blkno: u64,
    pub b_rawblkno: u64,
    pub b_iodone: u64,
    pub b_proc: u64,
    pub b_vp: u64,
    pub b_saveaddr: u64,
    pub b_lblkno: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of buf_sysctl"][::std::mem::size_of::<buf_sysctl>() - 104usize];
    ["Alignment of buf_sysctl"][::std::mem::align_of::<buf_sysctl>() - 8usize];
    ["Offset of field: buf_sysctl::b_flags"][::std::mem::offset_of!(buf_sysctl, b_flags) - 0usize];
    ["Offset of field: buf_sysctl::b_error"][::std::mem::offset_of!(buf_sysctl, b_error) - 4usize];
    ["Offset of field: buf_sysctl::b_prio"][::std::mem::offset_of!(buf_sysctl, b_prio) - 8usize];
    ["Offset of field: buf_sysctl::b_dev"][::std::mem::offset_of!(buf_sysctl, b_dev) - 12usize];
    ["Offset of field: buf_sysctl::b_bufsize"]
        [::std::mem::offset_of!(buf_sysctl, b_bufsize) - 16usize];
    ["Offset of field: buf_sysctl::b_bcount"]
        [::std::mem::offset_of!(buf_sysctl, b_bcount) - 24usize];
    ["Offset of field: buf_sysctl::b_resid"][::std::mem::offset_of!(buf_sysctl, b_resid) - 32usize];
    ["Offset of field: buf_sysctl::b_addr"][::std::mem::offset_of!(buf_sysctl, b_addr) - 40usize];
    ["Offset of field: buf_sysctl::b_blkno"][::std::mem::offset_of!(buf_sysctl, b_blkno) - 48usize];
    ["Offset of field: buf_sysctl::b_rawblkno"]
        [::std::mem::offset_of!(buf_sysctl, b_rawblkno) - 56usize];
    ["Offset of field: buf_sysctl::b_iodone"]
        [::std::mem::offset_of!(buf_sysctl, b_iodone) - 64usize];
    ["Offset of field: buf_sysctl::b_proc"][::std::mem::offset_of!(buf_sysctl, b_proc) - 72usize];
    ["Offset of field: buf_sysctl::b_vp"][::std::mem::offset_of!(buf_sysctl, b_vp) - 80usize];
    ["Offset of field: buf_sysctl::b_saveaddr"]
        [::std::mem::offset_of!(buf_sysctl, b_saveaddr) - 88usize];
    ["Offset of field: buf_sysctl::b_lblkno"]
        [::std::mem::offset_of!(buf_sysctl, b_lblkno) - 96usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kinfo_file {
    pub ki_fileaddr: u64,
    pub ki_flag: u32,
    pub ki_iflags: u32,
    pub ki_ftype: u32,
    pub ki_count: u32,
    pub ki_msgcount: u32,
    pub ki_usecount: u32,
    pub ki_fucred: u64,
    pub ki_fuid: u32,
    pub ki_fgid: u32,
    pub ki_fops: u64,
    pub ki_foffset: u64,
    pub ki_fdata: u64,
    pub ki_vun: u64,
    pub ki_vsize: u64,
    pub ki_vtype: u32,
    pub ki_vtag: u32,
    pub ki_vdata: u64,
    pub ki_pid: u32,
    pub ki_fd: i32,
    pub ki_ofileflags: u32,
    pub _ki_padto64bits: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_file"][::std::mem::size_of::<kinfo_file>() - 120usize];
    ["Alignment of kinfo_file"][::std::mem::align_of::<kinfo_file>() - 8usize];
    ["Offset of field: kinfo_file::ki_fileaddr"]
        [::std::mem::offset_of!(kinfo_file, ki_fileaddr) - 0usize];
    ["Offset of field: kinfo_file::ki_flag"][::std::mem::offset_of!(kinfo_file, ki_flag) - 8usize];
    ["Offset of field: kinfo_file::ki_iflags"]
        [::std::mem::offset_of!(kinfo_file, ki_iflags) - 12usize];
    ["Offset of field: kinfo_file::ki_ftype"]
        [::std::mem::offset_of!(kinfo_file, ki_ftype) - 16usize];
    ["Offset of field: kinfo_file::ki_count"]
        [::std::mem::offset_of!(kinfo_file, ki_count) - 20usize];
    ["Offset of field: kinfo_file::ki_msgcount"]
        [::std::mem::offset_of!(kinfo_file, ki_msgcount) - 24usize];
    ["Offset of field: kinfo_file::ki_usecount"]
        [::std::mem::offset_of!(kinfo_file, ki_usecount) - 28usize];
    ["Offset of field: kinfo_file::ki_fucred"]
        [::std::mem::offset_of!(kinfo_file, ki_fucred) - 32usize];
    ["Offset of field: kinfo_file::ki_fuid"][::std::mem::offset_of!(kinfo_file, ki_fuid) - 40usize];
    ["Offset of field: kinfo_file::ki_fgid"][::std::mem::offset_of!(kinfo_file, ki_fgid) - 44usize];
    ["Offset of field: kinfo_file::ki_fops"][::std::mem::offset_of!(kinfo_file, ki_fops) - 48usize];
    ["Offset of field: kinfo_file::ki_foffset"]
        [::std::mem::offset_of!(kinfo_file, ki_foffset) - 56usize];
    ["Offset of field: kinfo_file::ki_fdata"]
        [::std::mem::offset_of!(kinfo_file, ki_fdata) - 64usize];
    ["Offset of field: kinfo_file::ki_vun"][::std::mem::offset_of!(kinfo_file, ki_vun) - 72usize];
    ["Offset of field: kinfo_file::ki_vsize"]
        [::std::mem::offset_of!(kinfo_file, ki_vsize) - 80usize];
    ["Offset of field: kinfo_file::ki_vtype"]
        [::std::mem::offset_of!(kinfo_file, ki_vtype) - 88usize];
    ["Offset of field: kinfo_file::ki_vtag"][::std::mem::offset_of!(kinfo_file, ki_vtag) - 92usize];
    ["Offset of field: kinfo_file::ki_vdata"]
        [::std::mem::offset_of!(kinfo_file, ki_vdata) - 96usize];
    ["Offset of field: kinfo_file::ki_pid"][::std::mem::offset_of!(kinfo_file, ki_pid) - 104usize];
    ["Offset of field: kinfo_file::ki_fd"][::std::mem::offset_of!(kinfo_file, ki_fd) - 108usize];
    ["Offset of field: kinfo_file::ki_ofileflags"]
        [::std::mem::offset_of!(kinfo_file, ki_ofileflags) - 112usize];
    ["Offset of field: kinfo_file::_ki_padto64bits"]
        [::std::mem::offset_of!(kinfo_file, _ki_padto64bits) - 116usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct evcnt_sysctl {
    pub ev_count: u64,
    pub ev_addr: u64,
    pub ev_parent: u64,
    pub ev_type: u8,
    pub ev_grouplen: u8,
    pub ev_namelen: u8,
    pub ev_len: u8,
    pub ev_strings: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of evcnt_sysctl"][::std::mem::size_of::<evcnt_sysctl>() - 32usize];
    ["Alignment of evcnt_sysctl"][::std::mem::align_of::<evcnt_sysctl>() - 8usize];
    ["Offset of field: evcnt_sysctl::ev_count"]
        [::std::mem::offset_of!(evcnt_sysctl, ev_count) - 0usize];
    ["Offset of field: evcnt_sysctl::ev_addr"]
        [::std::mem::offset_of!(evcnt_sysctl, ev_addr) - 8usize];
    ["Offset of field: evcnt_sysctl::ev_parent"]
        [::std::mem::offset_of!(evcnt_sysctl, ev_parent) - 16usize];
    ["Offset of field: evcnt_sysctl::ev_type"]
        [::std::mem::offset_of!(evcnt_sysctl, ev_type) - 24usize];
    ["Offset of field: evcnt_sysctl::ev_grouplen"]
        [::std::mem::offset_of!(evcnt_sysctl, ev_grouplen) - 25usize];
    ["Offset of field: evcnt_sysctl::ev_namelen"]
        [::std::mem::offset_of!(evcnt_sysctl, ev_namelen) - 26usize];
    ["Offset of field: evcnt_sysctl::ev_len"]
        [::std::mem::offset_of!(evcnt_sysctl, ev_len) - 27usize];
    ["Offset of field: evcnt_sysctl::ev_strings"]
        [::std::mem::offset_of!(evcnt_sysctl, ev_strings) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hashstat_sysctl {
    pub hash_name: [::std::os::raw::c_char; 32usize],
    pub hash_desc: [::std::os::raw::c_char; 32usize],
    pub hash_size: u64,
    pub hash_used: u64,
    pub hash_items: u64,
    pub hash_maxchain: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hashstat_sysctl"][::std::mem::size_of::<hashstat_sysctl>() - 96usize];
    ["Alignment of hashstat_sysctl"][::std::mem::align_of::<hashstat_sysctl>() - 8usize];
    ["Offset of field: hashstat_sysctl::hash_name"]
        [::std::mem::offset_of!(hashstat_sysctl, hash_name) - 0usize];
    ["Offset of field: hashstat_sysctl::hash_desc"]
        [::std::mem::offset_of!(hashstat_sysctl, hash_desc) - 32usize];
    ["Offset of field: hashstat_sysctl::hash_size"]
        [::std::mem::offset_of!(hashstat_sysctl, hash_size) - 64usize];
    ["Offset of field: hashstat_sysctl::hash_used"]
        [::std::mem::offset_of!(hashstat_sysctl, hash_used) - 72usize];
    ["Offset of field: hashstat_sysctl::hash_items"]
        [::std::mem::offset_of!(hashstat_sysctl, hash_items) - 80usize];
    ["Offset of field: hashstat_sysctl::hash_maxchain"]
        [::std::mem::offset_of!(hashstat_sysctl, hash_maxchain) - 88usize];
};
pub type hashstat_func_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut hashstat_sysctl, arg2: bool) -> ::std::os::raw::c_int,
>;
unsafe extern "C" {
    pub fn hashstat_register(arg1: *const ::std::os::raw::c_char, arg2: hashstat_func_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kinfo_vmentry {
    pub kve_start: u64,
    pub kve_end: u64,
    pub kve_offset: u64,
    pub kve_type: u32,
    pub kve_flags: u32,
    pub kve_count: u32,
    pub kve_wired_count: u32,
    pub kve_advice: u32,
    pub kve_attributes: u32,
    pub kve_protection: u32,
    pub kve_max_protection: u32,
    pub kve_ref_count: u32,
    pub kve_inheritance: u32,
    pub kve_vn_fileid: u64,
    pub kve_vn_size: u64,
    pub kve_vn_fsid: u64,
    pub kve_vn_rdev: u64,
    pub kve_vn_type: u32,
    pub kve_vn_mode: u32,
    pub kve_path: [::std::os::raw::c_char; 1024usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_vmentry"][::std::mem::size_of::<kinfo_vmentry>() - 1128usize];
    ["Alignment of kinfo_vmentry"][::std::mem::align_of::<kinfo_vmentry>() - 8usize];
    ["Offset of field: kinfo_vmentry::kve_start"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_start) - 0usize];
    ["Offset of field: kinfo_vmentry::kve_end"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_end) - 8usize];
    ["Offset of field: kinfo_vmentry::kve_offset"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_offset) - 16usize];
    ["Offset of field: kinfo_vmentry::kve_type"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_type) - 24usize];
    ["Offset of field: kinfo_vmentry::kve_flags"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_flags) - 28usize];
    ["Offset of field: kinfo_vmentry::kve_count"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_count) - 32usize];
    ["Offset of field: kinfo_vmentry::kve_wired_count"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_wired_count) - 36usize];
    ["Offset of field: kinfo_vmentry::kve_advice"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_advice) - 40usize];
    ["Offset of field: kinfo_vmentry::kve_attributes"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_attributes) - 44usize];
    ["Offset of field: kinfo_vmentry::kve_protection"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_protection) - 48usize];
    ["Offset of field: kinfo_vmentry::kve_max_protection"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_max_protection) - 52usize];
    ["Offset of field: kinfo_vmentry::kve_ref_count"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_ref_count) - 56usize];
    ["Offset of field: kinfo_vmentry::kve_inheritance"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_inheritance) - 60usize];
    ["Offset of field: kinfo_vmentry::kve_vn_fileid"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_vn_fileid) - 64usize];
    ["Offset of field: kinfo_vmentry::kve_vn_size"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_vn_size) - 72usize];
    ["Offset of field: kinfo_vmentry::kve_vn_fsid"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_vn_fsid) - 80usize];
    ["Offset of field: kinfo_vmentry::kve_vn_rdev"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_vn_rdev) - 88usize];
    ["Offset of field: kinfo_vmentry::kve_vn_type"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_vn_type) - 96usize];
    ["Offset of field: kinfo_vmentry::kve_vn_mode"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_vn_mode) - 100usize];
    ["Offset of field: kinfo_vmentry::kve_path"]
        [::std::mem::offset_of!(kinfo_vmentry, kve_path) - 104usize];
};
pub type sysctlfn = *mut ::std::os::raw::c_void;
unsafe extern "C" {
    pub fn sysctl(
        arg1: *const ::std::os::raw::c_int,
        arg2: u_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut usize,
        arg5: *const ::std::os::raw::c_void,
        arg6: usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sysctlbyname(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut usize,
        arg4: *const ::std::os::raw::c_void,
        arg5: usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sysctlgetmibinfo(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_int,
        arg3: *mut u_int,
        arg4: *mut ::std::os::raw::c_char,
        arg5: *mut usize,
        arg6: *mut *mut sysctlnode,
        arg7: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sysctlnametomib(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_int,
        arg3: *mut usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn proc_compare(
        arg1: *const kinfo_proc2,
        arg2: *const kinfo_lwp,
        arg3: *const kinfo_proc2,
        arg4: *const kinfo_lwp,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn asysctl(
        arg1: *const ::std::os::raw::c_int,
        arg2: usize,
        arg3: *mut usize,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn asysctlbyname(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut usize,
    ) -> *mut ::std::os::raw::c_void;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sysctlnode {
    pub sysctl_flags: u32,
    pub sysctl_num: i32,
    pub sysctl_name: [::std::os::raw::c_char; 32usize],
    pub sysctl_ver: u32,
    pub __rsvd: u32,
    pub sysctl_un: sysctlnode__bindgen_ty_1,
    pub _sysctl_size: sysctlnode__bindgen_ty_2,
    pub _sysctl_func: sysctlnode__bindgen_ty_3,
    pub _sysctl_parent: sysctlnode__bindgen_ty_4,
    pub _sysctl_desc: sysctlnode__bindgen_ty_5,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sysctlnode__bindgen_ty_1 {
    pub scu_child: sysctlnode__bindgen_ty_1__bindgen_ty_1,
    pub scu_data: sysctlnode__bindgen_ty_1__bindgen_ty_2,
    pub scu_alias: i32,
    pub scu_idata: i32,
    pub scu_qdata: u_quad_t,
    pub scu_bdata: bool,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sysctlnode__bindgen_ty_1__bindgen_ty_1 {
    pub suc_csize: u32,
    pub suc_clen: u32,
    pub _suc_child: sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub __sysc_upad: u64,
    pub __sysc_ustr: sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub __sysc_sdatum: *mut sysctlnode,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(
        ) - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>(
        ) - 8usize];
    [
        "Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1::__sysc_sdatum",
    ][::std::mem::offset_of!(
        sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
        __sysc_sdatum
    ) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1::__sysc_upad"][::std::mem::offset_of!(
        sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
        __sysc_upad
    )
        - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1::__sysc_ustr"][::std::mem::offset_of!(
        sysctlnode__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
        __sysc_ustr
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_1__bindgen_ty_1>() - 16usize];
    ["Alignment of sysctlnode__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_1::suc_csize"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1__bindgen_ty_1, suc_csize) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_1::suc_clen"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1__bindgen_ty_1, suc_clen) - 4usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_1::_suc_child"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1__bindgen_ty_1, _suc_child) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sysctlnode__bindgen_ty_1__bindgen_ty_2 {
    pub _sud_data: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
    pub _sud_offset: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    pub __sysc_upad: u64,
    pub __sysc_ustr: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1 {
    pub __sysc_sdatum: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1>(
        ) - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1>(
        ) - 8usize];
    [
        "Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1::__sysc_sdatum",
    ][::std::mem::offset_of!(
        sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
        __sysc_sdatum
    ) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1::__sysc_upad"][::std::mem::offset_of!(
        sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
        __sysc_upad
    )
        - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1::__sysc_ustr"][::std::mem::offset_of!(
        sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
        __sysc_ustr
    )
        - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2 {
    pub __sysc_upad: u64,
    pub __sysc_ustr: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1 {
    pub __sysc_sdatum: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1>(
        ) - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1>(
        ) - 8usize];
    [
        "Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1::__sysc_sdatum",
    ][::std::mem::offset_of!(
        sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1,
        __sysc_sdatum
    ) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2::__sysc_upad"][::std::mem::offset_of!(
        sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2,
        __sysc_upad
    )
        - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2::__sysc_ustr"][::std::mem::offset_of!(
        sysctlnode__bindgen_ty_1__bindgen_ty_2__bindgen_ty_2,
        __sysc_ustr
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2>() - 16usize];
    ["Alignment of sysctlnode__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_1__bindgen_ty_2>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_2::_sud_data"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1__bindgen_ty_2, _sud_data) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1__bindgen_ty_2::_sud_offset"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1__bindgen_ty_2, _sud_offset) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_1>() - 16usize];
    ["Alignment of sysctlnode__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_1>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_1::scu_child"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1, scu_child) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1::scu_data"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1, scu_data) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1::scu_alias"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1, scu_alias) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1::scu_idata"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1, scu_idata) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1::scu_qdata"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1, scu_qdata) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_1::scu_bdata"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_1, scu_bdata) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union sysctlnode__bindgen_ty_2 {
    pub __sysc_upad: u64,
    pub __sysc_ustr: sysctlnode__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysctlnode__bindgen_ty_2__bindgen_ty_1 {
    pub __sysc_sdatum: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_2__bindgen_ty_1>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_2__bindgen_ty_1>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_2__bindgen_ty_1::__sysc_sdatum"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_2__bindgen_ty_1, __sysc_sdatum) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_2"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_2>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_2"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_2>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_2::__sysc_upad"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_2, __sysc_upad) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_2::__sysc_ustr"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_2, __sysc_ustr) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union sysctlnode__bindgen_ty_3 {
    pub __sysc_upad: u64,
    pub __sysc_ustr: sysctlnode__bindgen_ty_3__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysctlnode__bindgen_ty_3__bindgen_ty_1 {
    pub __sysc_sdatum: sysctlfn,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_3__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_3__bindgen_ty_1>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_3__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_3__bindgen_ty_1>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_3__bindgen_ty_1::__sysc_sdatum"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_3__bindgen_ty_1, __sysc_sdatum) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_3"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_3>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_3"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_3>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_3::__sysc_upad"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_3, __sysc_upad) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_3::__sysc_ustr"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_3, __sysc_ustr) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union sysctlnode__bindgen_ty_4 {
    pub __sysc_upad: u64,
    pub __sysc_ustr: sysctlnode__bindgen_ty_4__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysctlnode__bindgen_ty_4__bindgen_ty_1 {
    pub __sysc_sdatum: *mut sysctlnode,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_4__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_4__bindgen_ty_1>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_4__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_4__bindgen_ty_1>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_4__bindgen_ty_1::__sysc_sdatum"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_4__bindgen_ty_1, __sysc_sdatum) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_4"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_4>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_4"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_4>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_4::__sysc_upad"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_4, __sysc_upad) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_4::__sysc_ustr"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_4, __sysc_ustr) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union sysctlnode__bindgen_ty_5 {
    pub __sysc_upad: u64,
    pub __sysc_ustr: sysctlnode__bindgen_ty_5__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysctlnode__bindgen_ty_5__bindgen_ty_1 {
    pub __sysc_sdatum: *const ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_5__bindgen_ty_1"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_5__bindgen_ty_1>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_5__bindgen_ty_1"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_5__bindgen_ty_1>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_5__bindgen_ty_1::__sysc_sdatum"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_5__bindgen_ty_1, __sysc_sdatum) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode__bindgen_ty_5"]
        [::std::mem::size_of::<sysctlnode__bindgen_ty_5>() - 8usize];
    ["Alignment of sysctlnode__bindgen_ty_5"]
        [::std::mem::align_of::<sysctlnode__bindgen_ty_5>() - 8usize];
    ["Offset of field: sysctlnode__bindgen_ty_5::__sysc_upad"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_5, __sysc_upad) - 0usize];
    ["Offset of field: sysctlnode__bindgen_ty_5::__sysc_ustr"]
        [::std::mem::offset_of!(sysctlnode__bindgen_ty_5, __sysc_ustr) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctlnode"][::std::mem::size_of::<sysctlnode>() - 96usize];
    ["Alignment of sysctlnode"][::std::mem::align_of::<sysctlnode>() - 8usize];
    ["Offset of field: sysctlnode::sysctl_flags"]
        [::std::mem::offset_of!(sysctlnode, sysctl_flags) - 0usize];
    ["Offset of field: sysctlnode::sysctl_num"]
        [::std::mem::offset_of!(sysctlnode, sysctl_num) - 4usize];
    ["Offset of field: sysctlnode::sysctl_name"]
        [::std::mem::offset_of!(sysctlnode, sysctl_name) - 8usize];
    ["Offset of field: sysctlnode::sysctl_ver"]
        [::std::mem::offset_of!(sysctlnode, sysctl_ver) - 40usize];
    ["Offset of field: sysctlnode::__rsvd"][::std::mem::offset_of!(sysctlnode, __rsvd) - 44usize];
    ["Offset of field: sysctlnode::sysctl_un"]
        [::std::mem::offset_of!(sysctlnode, sysctl_un) - 48usize];
    ["Offset of field: sysctlnode::_sysctl_size"]
        [::std::mem::offset_of!(sysctlnode, _sysctl_size) - 64usize];
    ["Offset of field: sysctlnode::_sysctl_func"]
        [::std::mem::offset_of!(sysctlnode, _sysctl_func) - 72usize];
    ["Offset of field: sysctlnode::_sysctl_parent"]
        [::std::mem::offset_of!(sysctlnode, _sysctl_parent) - 80usize];
    ["Offset of field: sysctlnode::_sysctl_desc"]
        [::std::mem::offset_of!(sysctlnode, _sysctl_desc) - 88usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysctldesc {
    pub descr_num: i32,
    pub descr_ver: u32,
    pub descr_len: u32,
    pub descr_str: [::std::os::raw::c_char; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sysctldesc"][::std::mem::size_of::<sysctldesc>() - 16usize];
    ["Alignment of sysctldesc"][::std::mem::align_of::<sysctldesc>() - 4usize];
    ["Offset of field: sysctldesc::descr_num"]
        [::std::mem::offset_of!(sysctldesc, descr_num) - 0usize];
    ["Offset of field: sysctldesc::descr_ver"]
        [::std::mem::offset_of!(sysctldesc, descr_ver) - 4usize];
    ["Offset of field: sysctldesc::descr_len"]
        [::std::mem::offset_of!(sysctldesc, descr_len) - 8usize];
    ["Offset of field: sysctldesc::descr_str"]
        [::std::mem::offset_of!(sysctldesc, descr_str) - 12usize];
};
pub type sa_family_t = __sa_family_t;
pub type socklen_t = __socklen_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of iovec"][::std::mem::size_of::<iovec>() - 16usize];
    ["Alignment of iovec"][::std::mem::align_of::<iovec>() - 8usize];
    ["Offset of field: iovec::iov_base"][::std::mem::offset_of!(iovec, iov_base) - 0usize];
    ["Offset of field: iovec::iov_len"][::std::mem::offset_of!(iovec, iov_len) - 8usize];
};
pub const uio_rw_UIO_READ: uio_rw = 0;
pub const uio_rw_UIO_WRITE: uio_rw = 1;
pub type uio_rw = ::std::os::raw::c_uint;
pub const uio_seg_UIO_USERSPACE: uio_seg = 0;
pub const uio_seg_UIO_SYSSPACE: uio_seg = 1;
pub type uio_seg = ::std::os::raw::c_uint;
unsafe extern "C" {
    pub fn preadv(
        arg1: ::std::os::raw::c_int,
        arg2: *const iovec,
        arg3: ::std::os::raw::c_int,
        arg4: __off_t,
    ) -> isize;
}
unsafe extern "C" {
    pub fn pwritev(
        arg1: ::std::os::raw::c_int,
        arg2: *const iovec,
        arg3: ::std::os::raw::c_int,
        arg4: __off_t,
    ) -> isize;
}
unsafe extern "C" {
    pub fn readv(
        arg1: ::std::os::raw::c_int,
        arg2: *const iovec,
        arg3: ::std::os::raw::c_int,
    ) -> isize;
}
unsafe extern "C" {
    pub fn writev(
        arg1: ::std::os::raw::c_int,
        arg2: *const iovec,
        arg3: ::std::os::raw::c_int,
    ) -> isize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of linger"][::std::mem::size_of::<linger>() - 8usize];
    ["Alignment of linger"][::std::mem::align_of::<linger>() - 4usize];
    ["Offset of field: linger::l_onoff"][::std::mem::offset_of!(linger, l_onoff) - 0usize];
    ["Offset of field: linger::l_linger"][::std::mem::offset_of!(linger, l_linger) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct accept_filter_arg {
    pub af_name: [::std::os::raw::c_char; 16usize],
    pub af_arg: [::std::os::raw::c_char; 240usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of accept_filter_arg"][::std::mem::size_of::<accept_filter_arg>() - 256usize];
    ["Alignment of accept_filter_arg"][::std::mem::align_of::<accept_filter_arg>() - 1usize];
    ["Offset of field: accept_filter_arg::af_name"]
        [::std::mem::offset_of!(accept_filter_arg, af_name) - 0usize];
    ["Offset of field: accept_filter_arg::af_arg"]
        [::std::mem::offset_of!(accept_filter_arg, af_arg) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr {
    pub sa_len: __uint8_t,
    pub sa_family: __sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr"][::std::mem::size_of::<sockaddr>() - 16usize];
    ["Alignment of sockaddr"][::std::mem::align_of::<sockaddr>() - 1usize];
    ["Offset of field: sockaddr::sa_len"][::std::mem::offset_of!(sockaddr, sa_len) - 0usize];
    ["Offset of field: sockaddr::sa_family"][::std::mem::offset_of!(sockaddr, sa_family) - 1usize];
    ["Offset of field: sockaddr::sa_data"][::std::mem::offset_of!(sockaddr, sa_data) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_len: __uint8_t,
    pub ss_family: __sa_family_t,
    pub __ss_pad1: [::std::os::raw::c_char; 6usize],
    pub __ss_align: __int64_t,
    pub __ss_pad2: [::std::os::raw::c_char; 112usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr_storage"][::std::mem::size_of::<sockaddr_storage>() - 128usize];
    ["Alignment of sockaddr_storage"][::std::mem::align_of::<sockaddr_storage>() - 8usize];
    ["Offset of field: sockaddr_storage::ss_len"]
        [::std::mem::offset_of!(sockaddr_storage, ss_len) - 0usize];
    ["Offset of field: sockaddr_storage::ss_family"]
        [::std::mem::offset_of!(sockaddr_storage, ss_family) - 1usize];
    ["Offset of field: sockaddr_storage::__ss_pad1"]
        [::std::mem::offset_of!(sockaddr_storage, __ss_pad1) - 2usize];
    ["Offset of field: sockaddr_storage::__ss_align"]
        [::std::mem::offset_of!(sockaddr_storage, __ss_align) - 8usize];
    ["Offset of field: sockaddr_storage::__ss_pad2"]
        [::std::mem::offset_of!(sockaddr_storage, __ss_pad2) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockcred {
    pub sc_pid: __pid_t,
    pub sc_uid: __uid_t,
    pub sc_euid: __uid_t,
    pub sc_gid: __gid_t,
    pub sc_egid: __gid_t,
    pub sc_ngroups: ::std::os::raw::c_int,
    pub sc_groups: [__gid_t; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockcred"][::std::mem::size_of::<sockcred>() - 28usize];
    ["Alignment of sockcred"][::std::mem::align_of::<sockcred>() - 4usize];
    ["Offset of field: sockcred::sc_pid"][::std::mem::offset_of!(sockcred, sc_pid) - 0usize];
    ["Offset of field: sockcred::sc_uid"][::std::mem::offset_of!(sockcred, sc_uid) - 4usize];
    ["Offset of field: sockcred::sc_euid"][::std::mem::offset_of!(sockcred, sc_euid) - 8usize];
    ["Offset of field: sockcred::sc_gid"][::std::mem::offset_of!(sockcred, sc_gid) - 12usize];
    ["Offset of field: sockcred::sc_egid"][::std::mem::offset_of!(sockcred, sc_egid) - 16usize];
    ["Offset of field: sockcred::sc_ngroups"]
        [::std::mem::offset_of!(sockcred, sc_ngroups) - 20usize];
    ["Offset of field: sockcred::sc_groups"][::std::mem::offset_of!(sockcred, sc_groups) - 24usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kinfo_pcb {
    pub ki_pcbaddr: __uint64_t,
    pub ki_ppcbaddr: __uint64_t,
    pub ki_sockaddr: __uint64_t,
    pub ki_family: __uint32_t,
    pub ki_type: __uint32_t,
    pub ki_protocol: __uint32_t,
    pub ki_pflags: __uint32_t,
    pub ki_sostate: __uint32_t,
    pub ki_prstate: __uint32_t,
    pub ki_tstate: __int32_t,
    pub ki_tflags: __uint32_t,
    pub ki_rcvq: __uint64_t,
    pub ki_sndq: __uint64_t,
    pub ki_s: kinfo_pcb__bindgen_ty_1,
    pub ki_d: kinfo_pcb__bindgen_ty_2,
    pub ki_inode: __uint64_t,
    pub ki_vnode: __uint64_t,
    pub ki_conn: __uint64_t,
    pub ki_refs: __uint64_t,
    pub ki_nextref: __uint64_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kinfo_pcb__bindgen_ty_1 {
    pub _kis_src: sockaddr,
    pub _kis_pad: [::std::os::raw::c_char; 264usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_pcb__bindgen_ty_1"]
        [::std::mem::size_of::<kinfo_pcb__bindgen_ty_1>() - 264usize];
    ["Alignment of kinfo_pcb__bindgen_ty_1"]
        [::std::mem::align_of::<kinfo_pcb__bindgen_ty_1>() - 1usize];
    ["Offset of field: kinfo_pcb__bindgen_ty_1::_kis_src"]
        [::std::mem::offset_of!(kinfo_pcb__bindgen_ty_1, _kis_src) - 0usize];
    ["Offset of field: kinfo_pcb__bindgen_ty_1::_kis_pad"]
        [::std::mem::offset_of!(kinfo_pcb__bindgen_ty_1, _kis_pad) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union kinfo_pcb__bindgen_ty_2 {
    pub _kid_dst: sockaddr,
    pub _kid_pad: [::std::os::raw::c_char; 264usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_pcb__bindgen_ty_2"]
        [::std::mem::size_of::<kinfo_pcb__bindgen_ty_2>() - 264usize];
    ["Alignment of kinfo_pcb__bindgen_ty_2"]
        [::std::mem::align_of::<kinfo_pcb__bindgen_ty_2>() - 1usize];
    ["Offset of field: kinfo_pcb__bindgen_ty_2::_kid_dst"]
        [::std::mem::offset_of!(kinfo_pcb__bindgen_ty_2, _kid_dst) - 0usize];
    ["Offset of field: kinfo_pcb__bindgen_ty_2::_kid_pad"]
        [::std::mem::offset_of!(kinfo_pcb__bindgen_ty_2, _kid_pad) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kinfo_pcb"][::std::mem::size_of::<kinfo_pcb>() - 640usize];
    ["Alignment of kinfo_pcb"][::std::mem::align_of::<kinfo_pcb>() - 8usize];
    ["Offset of field: kinfo_pcb::ki_pcbaddr"]
        [::std::mem::offset_of!(kinfo_pcb, ki_pcbaddr) - 0usize];
    ["Offset of field: kinfo_pcb::ki_ppcbaddr"]
        [::std::mem::offset_of!(kinfo_pcb, ki_ppcbaddr) - 8usize];
    ["Offset of field: kinfo_pcb::ki_sockaddr"]
        [::std::mem::offset_of!(kinfo_pcb, ki_sockaddr) - 16usize];
    ["Offset of field: kinfo_pcb::ki_family"]
        [::std::mem::offset_of!(kinfo_pcb, ki_family) - 24usize];
    ["Offset of field: kinfo_pcb::ki_type"][::std::mem::offset_of!(kinfo_pcb, ki_type) - 28usize];
    ["Offset of field: kinfo_pcb::ki_protocol"]
        [::std::mem::offset_of!(kinfo_pcb, ki_protocol) - 32usize];
    ["Offset of field: kinfo_pcb::ki_pflags"]
        [::std::mem::offset_of!(kinfo_pcb, ki_pflags) - 36usize];
    ["Offset of field: kinfo_pcb::ki_sostate"]
        [::std::mem::offset_of!(kinfo_pcb, ki_sostate) - 40usize];
    ["Offset of field: kinfo_pcb::ki_prstate"]
        [::std::mem::offset_of!(kinfo_pcb, ki_prstate) - 44usize];
    ["Offset of field: kinfo_pcb::ki_tstate"]
        [::std::mem::offset_of!(kinfo_pcb, ki_tstate) - 48usize];
    ["Offset of field: kinfo_pcb::ki_tflags"]
        [::std::mem::offset_of!(kinfo_pcb, ki_tflags) - 52usize];
    ["Offset of field: kinfo_pcb::ki_rcvq"][::std::mem::offset_of!(kinfo_pcb, ki_rcvq) - 56usize];
    ["Offset of field: kinfo_pcb::ki_sndq"][::std::mem::offset_of!(kinfo_pcb, ki_sndq) - 64usize];
    ["Offset of field: kinfo_pcb::ki_s"][::std::mem::offset_of!(kinfo_pcb, ki_s) - 72usize];
    ["Offset of field: kinfo_pcb::ki_d"][::std::mem::offset_of!(kinfo_pcb, ki_d) - 336usize];
    ["Offset of field: kinfo_pcb::ki_inode"]
        [::std::mem::offset_of!(kinfo_pcb, ki_inode) - 600usize];
    ["Offset of field: kinfo_pcb::ki_vnode"]
        [::std::mem::offset_of!(kinfo_pcb, ki_vnode) - 608usize];
    ["Offset of field: kinfo_pcb::ki_conn"][::std::mem::offset_of!(kinfo_pcb, ki_conn) - 616usize];
    ["Offset of field: kinfo_pcb::ki_refs"][::std::mem::offset_of!(kinfo_pcb, ki_refs) - 624usize];
    ["Offset of field: kinfo_pcb::ki_nextref"]
        [::std::mem::offset_of!(kinfo_pcb, ki_nextref) - 632usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: __socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: ::std::os::raw::c_int,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: __socklen_t,
    pub msg_flags: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of msghdr"][::std::mem::size_of::<msghdr>() - 48usize];
    ["Alignment of msghdr"][::std::mem::align_of::<msghdr>() - 8usize];
    ["Offset of field: msghdr::msg_name"][::std::mem::offset_of!(msghdr, msg_name) - 0usize];
    ["Offset of field: msghdr::msg_namelen"][::std::mem::offset_of!(msghdr, msg_namelen) - 8usize];
    ["Offset of field: msghdr::msg_iov"][::std::mem::offset_of!(msghdr, msg_iov) - 16usize];
    ["Offset of field: msghdr::msg_iovlen"][::std::mem::offset_of!(msghdr, msg_iovlen) - 24usize];
    ["Offset of field: msghdr::msg_control"][::std::mem::offset_of!(msghdr, msg_control) - 32usize];
    ["Offset of field: msghdr::msg_controllen"]
        [::std::mem::offset_of!(msghdr, msg_controllen) - 40usize];
    ["Offset of field: msghdr::msg_flags"][::std::mem::offset_of!(msghdr, msg_flags) - 44usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mmsghdr {
    pub msg_hdr: msghdr,
    pub msg_len: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mmsghdr"][::std::mem::size_of::<mmsghdr>() - 56usize];
    ["Alignment of mmsghdr"][::std::mem::align_of::<mmsghdr>() - 8usize];
    ["Offset of field: mmsghdr::msg_hdr"][::std::mem::offset_of!(mmsghdr, msg_hdr) - 0usize];
    ["Offset of field: mmsghdr::msg_len"][::std::mem::offset_of!(mmsghdr, msg_len) - 48usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cmsghdr {
    pub cmsg_len: __socklen_t,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of cmsghdr"][::std::mem::size_of::<cmsghdr>() - 12usize];
    ["Alignment of cmsghdr"][::std::mem::align_of::<cmsghdr>() - 4usize];
    ["Offset of field: cmsghdr::cmsg_len"][::std::mem::offset_of!(cmsghdr, cmsg_len) - 0usize];
    ["Offset of field: cmsghdr::cmsg_level"][::std::mem::offset_of!(cmsghdr, cmsg_level) - 4usize];
    ["Offset of field: cmsghdr::cmsg_type"][::std::mem::offset_of!(cmsghdr, cmsg_type) - 8usize];
};
unsafe extern "C" {
    pub fn accept(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn accept4(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut __socklen_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn bind(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn connect(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getpeername(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getsockname(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_void,
        arg5: *mut __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn getsockopt2(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_void,
        arg5: *mut __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn listen(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn paccept(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut __socklen_t,
        arg4: *const sigset_t,
        arg5: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn recv(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
    ) -> isize;
}
unsafe extern "C" {
    pub fn recvfrom(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
        arg5: *mut sockaddr,
        arg6: *mut __socklen_t,
    ) -> isize;
}
unsafe extern "C" {
    pub fn recvmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *mut msghdr,
        arg3: ::std::os::raw::c_int,
    ) -> isize;
}
unsafe extern "C" {
    pub fn send(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
    ) -> isize;
}
unsafe extern "C" {
    pub fn sendto(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
        arg5: *const sockaddr,
        arg6: __socklen_t,
    ) -> isize;
}
unsafe extern "C" {
    pub fn sendmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *const msghdr,
        arg3: ::std::os::raw::c_int,
    ) -> isize;
}
unsafe extern "C" {
    pub fn setsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_void,
        arg5: __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn shutdown(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sockatmark(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__socket30"]
    pub fn socket(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn socketpair(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sendmmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *mut mmsghdr,
        arg3: ::std::os::raw::c_uint,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn recvmmsg(
        arg1: ::std::os::raw::c_int,
        arg2: *mut mmsghdr,
        arg3: ::std::os::raw::c_uint,
        arg4: ::std::os::raw::c_uint,
        arg5: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr {
    pub s_addr: __in_addr_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in_addr"][::std::mem::size_of::<in_addr>() - 4usize];
    ["Alignment of in_addr"][::std::mem::align_of::<in_addr>() - 4usize];
    ["Offset of field: in_addr::s_addr"][::std::mem::offset_of!(in_addr, s_addr) - 0usize];
};
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct __ctassert0_struct {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __ctassert0_struct"][::std::mem::size_of::<__ctassert0_struct>() - 4usize];
    ["Alignment of __ctassert0_struct"][::std::mem::align_of::<__ctassert0_struct>() - 4usize];
};
impl __ctassert0_struct {
    #[inline]
    pub fn __ctassert0(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___ctassert0(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn __ctassert0_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set___ctassert0_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __ctassert0: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __ctassert0: u32 = unsafe { ::std::mem::transmute(__ctassert0) };
            __ctassert0 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_len: u8,
    pub sin_family: __sa_family_t,
    pub sin_port: __in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [__int8_t; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr_in"][::std::mem::size_of::<sockaddr_in>() - 16usize];
    ["Alignment of sockaddr_in"][::std::mem::align_of::<sockaddr_in>() - 4usize];
    ["Offset of field: sockaddr_in::sin_len"]
        [::std::mem::offset_of!(sockaddr_in, sin_len) - 0usize];
    ["Offset of field: sockaddr_in::sin_family"]
        [::std::mem::offset_of!(sockaddr_in, sin_family) - 1usize];
    ["Offset of field: sockaddr_in::sin_port"]
        [::std::mem::offset_of!(sockaddr_in, sin_port) - 2usize];
    ["Offset of field: sockaddr_in::sin_addr"]
        [::std::mem::offset_of!(sockaddr_in, sin_addr) - 4usize];
    ["Offset of field: sockaddr_in::sin_zero"]
        [::std::mem::offset_of!(sockaddr_in, sin_zero) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_opts {
    pub ip_dst: in_addr,
    pub ip_opts: [__int8_t; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ip_opts"][::std::mem::size_of::<ip_opts>() - 44usize];
    ["Alignment of ip_opts"][::std::mem::align_of::<ip_opts>() - 4usize];
    ["Offset of field: ip_opts::ip_dst"][::std::mem::offset_of!(ip_opts, ip_dst) - 0usize];
    ["Offset of field: ip_opts::ip_opts"][::std::mem::offset_of!(ip_opts, ip_opts) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_pktinfo {
    pub ipi_addr: in_addr,
    pub ipi_ifindex: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in_pktinfo"][::std::mem::size_of::<in_pktinfo>() - 8usize];
    ["Alignment of in_pktinfo"][::std::mem::align_of::<in_pktinfo>() - 4usize];
    ["Offset of field: in_pktinfo::ipi_addr"]
        [::std::mem::offset_of!(in_pktinfo, ipi_addr) - 0usize];
    ["Offset of field: in_pktinfo::ipi_ifindex"]
        [::std::mem::offset_of!(in_pktinfo, ipi_ifindex) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreq {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ip_mreq"][::std::mem::size_of::<ip_mreq>() - 8usize];
    ["Alignment of ip_mreq"][::std::mem::align_of::<ip_mreq>() - 4usize];
    ["Offset of field: ip_mreq::imr_multiaddr"]
        [::std::mem::offset_of!(ip_mreq, imr_multiaddr) - 0usize];
    ["Offset of field: ip_mreq::imr_interface"]
        [::std::mem::offset_of!(ip_mreq, imr_interface) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __u6_addr: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [__uint8_t; 16usize],
    pub __u6_addr16: [__uint16_t; 8usize],
    pub __u6_addr32: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in6_addr__bindgen_ty_1"][::std::mem::size_of::<in6_addr__bindgen_ty_1>() - 16usize];
    ["Alignment of in6_addr__bindgen_ty_1"]
        [::std::mem::align_of::<in6_addr__bindgen_ty_1>() - 4usize];
    ["Offset of field: in6_addr__bindgen_ty_1::__u6_addr8"]
        [::std::mem::offset_of!(in6_addr__bindgen_ty_1, __u6_addr8) - 0usize];
    ["Offset of field: in6_addr__bindgen_ty_1::__u6_addr16"]
        [::std::mem::offset_of!(in6_addr__bindgen_ty_1, __u6_addr16) - 0usize];
    ["Offset of field: in6_addr__bindgen_ty_1::__u6_addr32"]
        [::std::mem::offset_of!(in6_addr__bindgen_ty_1, __u6_addr32) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in6_addr"][::std::mem::size_of::<in6_addr>() - 16usize];
    ["Alignment of in6_addr"][::std::mem::align_of::<in6_addr>() - 4usize];
    ["Offset of field: in6_addr::__u6_addr"][::std::mem::offset_of!(in6_addr, __u6_addr) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_len: u8,
    pub sin6_family: __sa_family_t,
    pub sin6_port: __in_port_t,
    pub sin6_flowinfo: u32,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr_in6"][::std::mem::size_of::<sockaddr_in6>() - 28usize];
    ["Alignment of sockaddr_in6"][::std::mem::align_of::<sockaddr_in6>() - 4usize];
    ["Offset of field: sockaddr_in6::sin6_len"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_len) - 0usize];
    ["Offset of field: sockaddr_in6::sin6_family"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_family) - 1usize];
    ["Offset of field: sockaddr_in6::sin6_port"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_port) - 2usize];
    ["Offset of field: sockaddr_in6::sin6_flowinfo"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_flowinfo) - 4usize];
    ["Offset of field: sockaddr_in6::sin6_addr"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_addr) - 8usize];
    ["Offset of field: sockaddr_in6::sin6_scope_id"]
        [::std::mem::offset_of!(sockaddr_in6, sin6_scope_id) - 24usize];
};
unsafe extern "C" {
    pub static in6addr_any: in6_addr;
}
unsafe extern "C" {
    pub static in6addr_loopback: in6_addr;
}
unsafe extern "C" {
    pub static in6addr_nodelocal_allnodes: in6_addr;
}
unsafe extern "C" {
    pub static in6addr_linklocal_allnodes: in6_addr;
}
unsafe extern "C" {
    pub static in6addr_linklocal_allrouters: in6_addr;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ipv6_mreq {
    pub ipv6mr_multiaddr: in6_addr,
    pub ipv6mr_interface: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ipv6_mreq"][::std::mem::size_of::<ipv6_mreq>() - 20usize];
    ["Alignment of ipv6_mreq"][::std::mem::align_of::<ipv6_mreq>() - 4usize];
    ["Offset of field: ipv6_mreq::ipv6mr_multiaddr"]
        [::std::mem::offset_of!(ipv6_mreq, ipv6mr_multiaddr) - 0usize];
    ["Offset of field: ipv6_mreq::ipv6mr_interface"]
        [::std::mem::offset_of!(ipv6_mreq, ipv6mr_interface) - 16usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_pktinfo {
    pub ipi6_addr: in6_addr,
    pub ipi6_ifindex: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of in6_pktinfo"][::std::mem::size_of::<in6_pktinfo>() - 20usize];
    ["Alignment of in6_pktinfo"][::std::mem::align_of::<in6_pktinfo>() - 4usize];
    ["Offset of field: in6_pktinfo::ipi6_addr"]
        [::std::mem::offset_of!(in6_pktinfo, ipi6_addr) - 0usize];
    ["Offset of field: in6_pktinfo::ipi6_ifindex"]
        [::std::mem::offset_of!(in6_pktinfo, ipi6_ifindex) - 16usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ip6_mtuinfo {
    pub ip6m_addr: sockaddr_in6,
    pub ip6m_mtu: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ip6_mtuinfo"][::std::mem::size_of::<ip6_mtuinfo>() - 32usize];
    ["Alignment of ip6_mtuinfo"][::std::mem::align_of::<ip6_mtuinfo>() - 4usize];
    ["Offset of field: ip6_mtuinfo::ip6m_addr"]
        [::std::mem::offset_of!(ip6_mtuinfo, ip6m_addr) - 0usize];
    ["Offset of field: ip6_mtuinfo::ip6m_mtu"]
        [::std::mem::offset_of!(ip6_mtuinfo, ip6m_mtu) - 28usize];
};
unsafe extern "C" {
    pub fn in6_in_2_v4mapin6(arg1: *const in_addr, arg2: *mut in6_addr);
}
unsafe extern "C" {
    pub fn in6_sin6_2_sin(arg1: *mut sockaddr_in, arg2: *mut sockaddr_in6);
}
unsafe extern "C" {
    pub fn in6_sin_2_v4mapsin6(arg1: *const sockaddr_in, arg2: *mut sockaddr_in6);
}
unsafe extern "C" {
    pub fn in6_sin6_2_sin_in_sock(arg1: *mut sockaddr);
}
unsafe extern "C" {
    pub fn in6_sin_2_v4mapsin6_in_sock(arg1: *mut *mut sockaddr);
}
unsafe extern "C" {
    pub fn inet6_getscopeid(arg1: *mut sockaddr_in6, arg2: ::std::os::raw::c_int);
}
unsafe extern "C" {
    pub fn inet6_putscopeid(arg1: *mut sockaddr_in6, arg2: ::std::os::raw::c_int);
}
unsafe extern "C" {
    pub fn inet6_option_space(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_option_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *mut *mut cmsghdr,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_option_append(
        arg1: *mut cmsghdr,
        arg2: *const u8,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_option_alloc(
        arg1: *mut cmsghdr,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> *mut u8;
}
unsafe extern "C" {
    pub fn inet6_option_next(arg1: *const cmsghdr, arg2: *mut *mut u8) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_option_find(
        arg1: *const cmsghdr,
        arg2: *mut *mut u8,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rthdr_space(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> usize;
}
unsafe extern "C" {
    pub fn inet6_rthdr_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> *mut cmsghdr;
}
unsafe extern "C" {
    pub fn inet6_rthdr_add(
        arg1: *mut cmsghdr,
        arg2: *const in6_addr,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rthdr_lasthop(
        arg1: *mut cmsghdr,
        arg2: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rthdr_segments(arg1: *const cmsghdr) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rthdr_getaddr(arg1: *mut cmsghdr, arg2: ::std::os::raw::c_int) -> *mut in6_addr;
}
unsafe extern "C" {
    pub fn inet6_rthdr_getflags(
        arg1: *const cmsghdr,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_append(
        arg1: *mut ::std::os::raw::c_void,
        arg2: __socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: u8,
        arg5: __socklen_t,
        arg6: u8,
        arg7: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_finish(
        arg1: *mut ::std::os::raw::c_void,
        arg2: __socklen_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_set_val(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_next(
        arg1: *mut ::std::os::raw::c_void,
        arg2: __socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: *mut u8,
        arg5: *mut __socklen_t,
        arg6: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_find(
        arg1: *mut ::std::os::raw::c_void,
        arg2: __socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: u8,
        arg5: *mut __socklen_t,
        arg6: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_opt_get_val(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: __socklen_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rth_space(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int)
    -> __socklen_t;
}
unsafe extern "C" {
    pub fn inet6_rth_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: __socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn inet6_rth_add(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const in6_addr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rth_reverse(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rth_segments(arg1: *const ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet6_rth_getaddr(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> *mut in6_addr;
}
unsafe extern "C" {
    pub fn inet_addr(arg1: *const ::std::os::raw::c_char) -> __in_addr_t;
}
unsafe extern "C" {
    pub fn inet_lnaof(arg1: in_addr) -> __in_addr_t;
}
unsafe extern "C" {
    pub fn inet_makeaddr(arg1: __in_addr_t, arg2: __in_addr_t) -> in_addr;
}
unsafe extern "C" {
    pub fn inet_netof(arg1: in_addr) -> __in_addr_t;
}
unsafe extern "C" {
    pub fn inet_network(arg1: *const ::std::os::raw::c_char) -> __in_addr_t;
}
unsafe extern "C" {
    pub fn inet_ntoa(arg1: in_addr) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_ntop(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_char,
        arg4: __socklen_t,
    ) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_pton(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet_aton(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet_neta(
        arg1: u_long,
        arg2: *mut ::std::os::raw::c_char,
        arg3: usize,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_net_ntop(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_char,
        arg5: usize,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_net_pton(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
        arg4: usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet_cidr_ntop(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_char,
        arg5: usize,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn inet_cidr_pton(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn inet_nsap_addr(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut u_char,
        arg3: ::std::os::raw::c_int,
    ) -> u_int;
}
unsafe extern "C" {
    pub fn inet_nsap_ntoa(
        arg1: ::std::os::raw::c_int,
        arg2: *const u_char,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub const kmutex_type_t_MUTEX_SPIN: kmutex_type_t = 0;
pub const kmutex_type_t_MUTEX_ADAPTIVE: kmutex_type_t = 1;
pub const kmutex_type_t_MUTEX_DEFAULT: kmutex_type_t = 2;
pub const kmutex_type_t_MUTEX_DRIVER: kmutex_type_t = 3;
pub const kmutex_type_t_MUTEX_NODEBUG: kmutex_type_t = 4;
pub type kmutex_type_t = ::std::os::raw::c_uint;
pub type kmutex_t = kmutex;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kmutex {
    pub u: kmutex__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kmutex__bindgen_ty_1 {
    pub mtxa_owner: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kmutex__bindgen_ty_1"][::std::mem::size_of::<kmutex__bindgen_ty_1>() - 8usize];
    ["Alignment of kmutex__bindgen_ty_1"][::std::mem::align_of::<kmutex__bindgen_ty_1>() - 8usize];
    ["Offset of field: kmutex__bindgen_ty_1::mtxa_owner"]
        [::std::mem::offset_of!(kmutex__bindgen_ty_1, mtxa_owner) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kmutex"][::std::mem::size_of::<kmutex>() - 8usize];
    ["Alignment of kmutex"][::std::mem::align_of::<kmutex>() - 8usize];
    ["Offset of field: kmutex::u"][::std::mem::offset_of!(kmutex, u) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct khook_list {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hook_desc {
    _unused: [u8; 0],
}
pub type khook_list_t = khook_list;
pub type khook_t = hook_desc;
unsafe extern "C" {
    pub fn simplehook_create(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut khook_list_t;
}
unsafe extern "C" {
    pub fn simplehook_destroy(arg1: *mut khook_list_t);
}
unsafe extern "C" {
    pub fn simplehook_dohooks(arg1: *mut khook_list_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn simplehook_establish(
        arg1: *mut khook_list_t,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut khook_t;
}
unsafe extern "C" {
    pub fn simplehook_disestablish(
        arg1: *mut khook_list_t,
        arg2: *mut khook_t,
        arg3: *mut kmutex_t,
    );
}
unsafe extern "C" {
    pub fn simplehook_has_hooks(arg1: *mut khook_list_t) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mbuf {
    _unused: [u8; 0],
}
pub type pfil_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *mut *mut mbuf,
        arg3: *mut ifnet,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type pfil_ifunc_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_ulong,
        arg3: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfil_head {
    _unused: [u8; 0],
}
pub type pfil_head_t = pfil_head;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct altq_pktattr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tb_regulator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct top_cdnr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifaltq {
    pub ifq_head: *mut mbuf,
    pub ifq_tail: *mut mbuf,
    pub ifq_len: ::std::os::raw::c_int,
    pub ifq_maxlen: ::std::os::raw::c_int,
    pub ifq_drops: u64,
    pub ifq_lock: *mut kmutex_t,
    pub altq_type: ::std::os::raw::c_int,
    pub altq_flags: ::std::os::raw::c_int,
    pub altq_disc: *mut ::std::os::raw::c_void,
    pub altq_ifp: *mut ifnet,
    pub altq_enqueue: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ifaltq, arg2: *mut mbuf) -> ::std::os::raw::c_int,
    >,
    pub altq_dequeue: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ifaltq, arg2: ::std::os::raw::c_int) -> *mut mbuf,
    >,
    pub altq_request: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ifaltq,
            arg2: ::std::os::raw::c_int,
            arg3: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub altq_clfier: *mut ::std::os::raw::c_void,
    pub altq_classify: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut mbuf,
            arg3: ::std::os::raw::c_int,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub altq_tbr: *mut tb_regulator,
    pub altq_cdnr: *mut top_cdnr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifaltq"][::std::mem::size_of::<ifaltq>() - 120usize];
    ["Alignment of ifaltq"][::std::mem::align_of::<ifaltq>() - 8usize];
    ["Offset of field: ifaltq::ifq_head"][::std::mem::offset_of!(ifaltq, ifq_head) - 0usize];
    ["Offset of field: ifaltq::ifq_tail"][::std::mem::offset_of!(ifaltq, ifq_tail) - 8usize];
    ["Offset of field: ifaltq::ifq_len"][::std::mem::offset_of!(ifaltq, ifq_len) - 16usize];
    ["Offset of field: ifaltq::ifq_maxlen"][::std::mem::offset_of!(ifaltq, ifq_maxlen) - 20usize];
    ["Offset of field: ifaltq::ifq_drops"][::std::mem::offset_of!(ifaltq, ifq_drops) - 24usize];
    ["Offset of field: ifaltq::ifq_lock"][::std::mem::offset_of!(ifaltq, ifq_lock) - 32usize];
    ["Offset of field: ifaltq::altq_type"][::std::mem::offset_of!(ifaltq, altq_type) - 40usize];
    ["Offset of field: ifaltq::altq_flags"][::std::mem::offset_of!(ifaltq, altq_flags) - 44usize];
    ["Offset of field: ifaltq::altq_disc"][::std::mem::offset_of!(ifaltq, altq_disc) - 48usize];
    ["Offset of field: ifaltq::altq_ifp"][::std::mem::offset_of!(ifaltq, altq_ifp) - 56usize];
    ["Offset of field: ifaltq::altq_enqueue"]
        [::std::mem::offset_of!(ifaltq, altq_enqueue) - 64usize];
    ["Offset of field: ifaltq::altq_dequeue"]
        [::std::mem::offset_of!(ifaltq, altq_dequeue) - 72usize];
    ["Offset of field: ifaltq::altq_request"]
        [::std::mem::offset_of!(ifaltq, altq_request) - 80usize];
    ["Offset of field: ifaltq::altq_clfier"][::std::mem::offset_of!(ifaltq, altq_clfier) - 88usize];
    ["Offset of field: ifaltq::altq_classify"]
        [::std::mem::offset_of!(ifaltq, altq_classify) - 96usize];
    ["Offset of field: ifaltq::altq_tbr"][::std::mem::offset_of!(ifaltq, altq_tbr) - 104usize];
    ["Offset of field: ifaltq::altq_cdnr"][::std::mem::offset_of!(ifaltq, altq_cdnr) - 112usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: time_t,
    pub tv_usec: suseconds_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timeval"][::std::mem::size_of::<timeval>() - 16usize];
    ["Alignment of timeval"][::std::mem::align_of::<timeval>() - 8usize];
    ["Offset of field: timeval::tv_sec"][::std::mem::offset_of!(timeval, tv_sec) - 0usize];
    ["Offset of field: timeval::tv_usec"][::std::mem::offset_of!(timeval, tv_usec) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timespec"][::std::mem::size_of::<timespec>() - 16usize];
    ["Alignment of timespec"][::std::mem::align_of::<timespec>() - 8usize];
    ["Offset of field: timespec::tv_sec"][::std::mem::offset_of!(timespec, tv_sec) - 0usize];
    ["Offset of field: timespec::tv_nsec"][::std::mem::offset_of!(timespec, tv_nsec) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timezone {
    pub tz_minuteswest: ::std::os::raw::c_int,
    pub tz_dsttime: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timezone"][::std::mem::size_of::<timezone>() - 8usize];
    ["Alignment of timezone"][::std::mem::align_of::<timezone>() - 4usize];
    ["Offset of field: timezone::tz_minuteswest"]
        [::std::mem::offset_of!(timezone, tz_minuteswest) - 0usize];
    ["Offset of field: timezone::tz_dsttime"]
        [::std::mem::offset_of!(timezone, tz_dsttime) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bintime {
    pub sec: time_t,
    pub frac: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of bintime"][::std::mem::size_of::<bintime>() - 16usize];
    ["Alignment of bintime"][::std::mem::align_of::<bintime>() - 8usize];
    ["Offset of field: bintime::sec"][::std::mem::offset_of!(bintime, sec) - 0usize];
    ["Offset of field: bintime::frac"][::std::mem::offset_of!(bintime, frac) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerval {
    pub it_interval: timeval,
    pub it_value: timeval,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of itimerval"][::std::mem::size_of::<itimerval>() - 32usize];
    ["Alignment of itimerval"][::std::mem::align_of::<itimerval>() - 8usize];
    ["Offset of field: itimerval::it_interval"]
        [::std::mem::offset_of!(itimerval, it_interval) - 0usize];
    ["Offset of field: itimerval::it_value"][::std::mem::offset_of!(itimerval, it_value) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerspec {
    pub it_interval: timespec,
    pub it_value: timespec,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of itimerspec"][::std::mem::size_of::<itimerspec>() - 32usize];
    ["Alignment of itimerspec"][::std::mem::align_of::<itimerspec>() - 8usize];
    ["Offset of field: itimerspec::it_interval"]
        [::std::mem::offset_of!(itimerspec, it_interval) - 0usize];
    ["Offset of field: itimerspec::it_value"]
        [::std::mem::offset_of!(itimerspec, it_value) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of tm"][::std::mem::size_of::<tm>() - 56usize];
    ["Alignment of tm"][::std::mem::align_of::<tm>() - 8usize];
    ["Offset of field: tm::tm_sec"][::std::mem::offset_of!(tm, tm_sec) - 0usize];
    ["Offset of field: tm::tm_min"][::std::mem::offset_of!(tm, tm_min) - 4usize];
    ["Offset of field: tm::tm_hour"][::std::mem::offset_of!(tm, tm_hour) - 8usize];
    ["Offset of field: tm::tm_mday"][::std::mem::offset_of!(tm, tm_mday) - 12usize];
    ["Offset of field: tm::tm_mon"][::std::mem::offset_of!(tm, tm_mon) - 16usize];
    ["Offset of field: tm::tm_year"][::std::mem::offset_of!(tm, tm_year) - 20usize];
    ["Offset of field: tm::tm_wday"][::std::mem::offset_of!(tm, tm_wday) - 24usize];
    ["Offset of field: tm::tm_yday"][::std::mem::offset_of!(tm, tm_yday) - 28usize];
    ["Offset of field: tm::tm_isdst"][::std::mem::offset_of!(tm, tm_isdst) - 32usize];
    ["Offset of field: tm::tm_gmtoff"][::std::mem::offset_of!(tm, tm_gmtoff) - 40usize];
    ["Offset of field: tm::tm_zone"][::std::mem::offset_of!(tm, tm_zone) - 48usize];
};
unsafe extern "C" {
    pub fn asctime(arg1: *const tm) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn clock() -> clock_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__ctime50"]
    pub fn ctime(arg1: *const time_t) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[link_name = "\u{1}__difftime50"]
    pub fn difftime(arg1: time_t, arg2: time_t) -> f64;
}
unsafe extern "C" {
    #[link_name = "\u{1}__gmtime50"]
    pub fn gmtime(arg1: *const time_t) -> *mut tm;
}
unsafe extern "C" {
    #[link_name = "\u{1}__locatime50"]
    pub fn localtime(arg1: *const time_t) -> *mut tm;
}
unsafe extern "C" {
    #[link_name = "\u{1}__time50"]
    pub fn time(arg1: *mut time_t) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__mktime50"]
    pub fn mktime(arg1: *mut tm) -> time_t;
}
unsafe extern "C" {
    pub fn strftime(
        arg1: *mut ::std::os::raw::c_char,
        arg2: usize,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
    ) -> usize;
}
unsafe extern "C" {
    pub fn __sysconf(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_long;
}
unsafe extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 2usize];
}
unsafe extern "C" {
    #[link_name = "\u{1}__tzset50"]
    pub fn tzset();
}
unsafe extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__timezone13"]
    pub static mut timezone: ::std::os::raw::c_long;
}
unsafe extern "C" {
    pub fn strptime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut tm,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn getdate(arg1: *const ::std::os::raw::c_char) -> *mut tm;
}
unsafe extern "C" {
    pub static mut getdate_err: ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn clock_nanosleep(
        arg1: clockid_t,
        arg2: ::std::os::raw::c_int,
        arg3: *const timespec,
        arg4: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__clock_getres50"]
    pub fn clock_getres(arg1: clockid_t, arg2: *mut timespec) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__clock_gettime50"]
    pub fn clock_gettime(arg1: clockid_t, arg2: *mut timespec) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__clock_settime50"]
    pub fn clock_settime(arg1: clockid_t, arg2: *const timespec) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__nanosleep50"]
    pub fn nanosleep(arg1: *const timespec, arg2: *mut timespec) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__timer_gettime50"]
    pub fn timer_gettime(arg1: timer_t, arg2: *mut itimerspec) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__timer_settime50"]
    pub fn timer_settime(
        arg1: timer_t,
        arg2: ::std::os::raw::c_int,
        arg3: *const itimerspec,
        arg4: *mut itimerspec,
    ) -> ::std::os::raw::c_int;
}
pub const idtype_t_P_MYID: idtype_t = -1;
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_LWPID: idtype_t = 2;
pub const idtype_t_P_PPID: idtype_t = 3;
pub const idtype_t_P_PGID: idtype_t = 4;
pub const idtype_t_P_SID: idtype_t = 5;
pub const idtype_t_P_CID: idtype_t = 6;
pub const idtype_t_P_UID: idtype_t = 7;
pub const idtype_t_P_GID: idtype_t = 8;
pub const idtype_t_P_TASKID: idtype_t = 9;
pub const idtype_t_P_PROJID: idtype_t = 10;
pub const idtype_t_P_POOLID: idtype_t = 11;
pub const idtype_t_P_ZONEID: idtype_t = 12;
pub const idtype_t_P_CTID: idtype_t = 13;
pub const idtype_t_P_CPUID: idtype_t = 14;
pub const idtype_t_P_PSETID: idtype_t = 15;
pub const idtype_t__P_MAXIDTYPE: idtype_t = 2147483647;
pub type idtype_t = ::std::os::raw::c_int;
unsafe extern "C" {
    pub fn clock_getcpuclockid2(
        arg1: idtype_t,
        arg2: id_t,
        arg3: *mut clockid_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn clock_getcpuclockid(arg1: __pid_t, arg2: *mut clockid_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn timer_create(
        arg1: clockid_t,
        arg2: *mut sigevent,
        arg3: *mut timer_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn timer_delete(arg1: timer_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn timer_getoverrun(arg1: timer_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn asctime_r(
        arg1: *const tm,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[link_name = "\u{1}__ctime_r50"]
    pub fn ctime_r(
        arg1: *const time_t,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[link_name = "\u{1}__gmtime_r50"]
    pub fn gmtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
unsafe extern "C" {
    #[link_name = "\u{1}__localtime_r50"]
    pub fn localtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _locale {
    _unused: [u8; 0],
}
pub type locale_t = *mut _locale;
unsafe extern "C" {
    pub fn strftime_l(
        arg1: *mut ::std::os::raw::c_char,
        arg2: usize,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
        arg5: locale_t,
    ) -> usize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __state {
    _unused: [u8; 0],
}
pub type timezone_t = *mut __state;
unsafe extern "C" {
    #[link_name = "\u{1}__time2posix50"]
    pub fn time2posix(arg1: time_t) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__posix2time50"]
    pub fn posix2time(arg1: time_t) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__timegm50"]
    pub fn timegm(arg1: *mut tm) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__timeoff50"]
    pub fn timeoff(arg1: *mut tm, arg2: ::std::os::raw::c_long) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__timelocal50"]
    pub fn timelocal(arg1: *mut tm) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__offtime50"]
    pub fn offtime(arg1: *const time_t, arg2: ::std::os::raw::c_long) -> *mut tm;
}
unsafe extern "C" {
    #[link_name = "\u{1}__tzsetwall50"]
    pub fn tzsetwall();
}
unsafe extern "C" {
    #[link_name = "\u{1}__offtime_r50"]
    pub fn offtime_r(arg1: *const time_t, arg2: ::std::os::raw::c_long, arg3: *mut tm) -> *mut tm;
}
unsafe extern "C" {
    #[link_name = "\u{1}__localtime_rz50"]
    pub fn localtime_rz(arg1: timezone_t, arg2: *const time_t, arg3: *mut tm) -> *mut tm;
}
unsafe extern "C" {
    #[link_name = "\u{1}__ctime_rz50"]
    pub fn ctime_rz(
        arg1: timezone_t,
        arg2: *const time_t,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[link_name = "\u{1}__mktime_z50"]
    pub fn mktime_z(arg1: timezone_t, arg2: *mut tm) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__timelocal_z50"]
    pub fn timelocal_z(arg1: timezone_t, arg2: *mut tm) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__time2posix_z50"]
    pub fn time2posix_z(arg1: timezone_t, arg2: time_t) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__posix2time_z50"]
    pub fn posix2time_z(arg1: timezone_t, arg2: time_t) -> time_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__tzalloc50"]
    pub fn tzalloc(arg1: *const ::std::os::raw::c_char) -> timezone_t;
}
unsafe extern "C" {
    #[link_name = "\u{1}__tzfree50"]
    pub fn tzfree(arg1: timezone_t);
}
unsafe extern "C" {
    #[link_name = "\u{1}__tzgetname50"]
    pub fn tzgetname(
        arg1: timezone_t,
        arg2: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[link_name = "\u{1}__tzgetgmtoff50"]
    pub fn tzgetgmtoff(arg1: timezone_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_long;
}
unsafe extern "C" {
    pub fn strftime_lz(
        arg1: timezone_t,
        arg2: *mut ::std::os::raw::c_char,
        arg3: usize,
        arg4: *const ::std::os::raw::c_char,
        arg5: *const tm,
        arg6: locale_t,
    ) -> usize;
}
unsafe extern "C" {
    pub fn strftime_z(
        arg1: timezone_t,
        arg2: *mut ::std::os::raw::c_char,
        arg3: usize,
        arg4: *const ::std::os::raw::c_char,
        arg5: *const tm,
    ) -> usize;
}
unsafe extern "C" {
    pub fn strptime_l(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut tm,
        arg4: locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn timespec_get(ts: *mut timespec, base: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__pselect50"]
    pub fn pselect(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *const timespec,
        arg6: *const sigset_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__select50"]
    pub fn select(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__getitimer50"]
    pub fn getitimer(arg1: ::std::os::raw::c_int, arg2: *mut itimerval) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__gettimeofday50"]
    pub fn gettimeofday(
        arg1: *mut timeval,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__setitimer50"]
    pub fn setitimer(
        arg1: ::std::os::raw::c_int,
        arg2: *const itimerval,
        arg3: *mut itimerval,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__utimes50"]
    pub fn utimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__adjtime50"]
    pub fn adjtime(arg1: *const timeval, arg2: *mut timeval) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__futimes50"]
    pub fn futimes(arg1: ::std::os::raw::c_int, arg2: *const timeval) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__lutimes50"]
    pub fn lutimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}__settimeofday50"]
    pub fn settimeofday(
        arg1: *const timeval,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_ {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct socket {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ether_header {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_clone {
    pub ifc_list: if_clone__bindgen_ty_1,
    pub ifc_name: *const ::std::os::raw::c_char,
    pub ifc_namelen: usize,
    pub ifc_create: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut if_clone,
            arg2: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub ifc_destroy:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ifnet) -> ::std::os::raw::c_int>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_clone__bindgen_ty_1 {
    pub le_next: *mut if_clone,
    pub le_prev: *mut *mut if_clone,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_clone__bindgen_ty_1"][::std::mem::size_of::<if_clone__bindgen_ty_1>() - 16usize];
    ["Alignment of if_clone__bindgen_ty_1"]
        [::std::mem::align_of::<if_clone__bindgen_ty_1>() - 8usize];
    ["Offset of field: if_clone__bindgen_ty_1::le_next"]
        [::std::mem::offset_of!(if_clone__bindgen_ty_1, le_next) - 0usize];
    ["Offset of field: if_clone__bindgen_ty_1::le_prev"]
        [::std::mem::offset_of!(if_clone__bindgen_ty_1, le_prev) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_clone"][::std::mem::size_of::<if_clone>() - 48usize];
    ["Alignment of if_clone"][::std::mem::align_of::<if_clone>() - 8usize];
    ["Offset of field: if_clone::ifc_list"][::std::mem::offset_of!(if_clone, ifc_list) - 0usize];
    ["Offset of field: if_clone::ifc_name"][::std::mem::offset_of!(if_clone, ifc_name) - 16usize];
    ["Offset of field: if_clone::ifc_namelen"]
        [::std::mem::offset_of!(if_clone, ifc_namelen) - 24usize];
    ["Offset of field: if_clone::ifc_create"]
        [::std::mem::offset_of!(if_clone, ifc_create) - 32usize];
    ["Offset of field: if_clone::ifc_destroy"]
        [::std::mem::offset_of!(if_clone, ifc_destroy) - 40usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_clonereq {
    pub ifcr_total: ::std::os::raw::c_int,
    pub ifcr_count: ::std::os::raw::c_int,
    pub ifcr_buffer: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_clonereq"][::std::mem::size_of::<if_clonereq>() - 16usize];
    ["Alignment of if_clonereq"][::std::mem::align_of::<if_clonereq>() - 8usize];
    ["Offset of field: if_clonereq::ifcr_total"]
        [::std::mem::offset_of!(if_clonereq, ifcr_total) - 0usize];
    ["Offset of field: if_clonereq::ifcr_count"]
        [::std::mem::offset_of!(if_clonereq, ifcr_count) - 4usize];
    ["Offset of field: if_clonereq::ifcr_buffer"]
        [::std::mem::offset_of!(if_clonereq, ifcr_buffer) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_data {
    pub ifi_type: u_char,
    pub ifi_addrlen: u_char,
    pub ifi_hdrlen: u_char,
    pub ifi_link_state: ::std::os::raw::c_int,
    pub ifi_mtu: u64,
    pub ifi_metric: u64,
    pub ifi_baudrate: u64,
    pub ifi_ipackets: u64,
    pub ifi_ierrors: u64,
    pub ifi_opackets: u64,
    pub ifi_oerrors: u64,
    pub ifi_collisions: u64,
    pub ifi_ibytes: u64,
    pub ifi_obytes: u64,
    pub ifi_imcasts: u64,
    pub ifi_omcasts: u64,
    pub ifi_iqdrops: u64,
    pub ifi_noproto: u64,
    pub ifi_lastchange: timespec,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_data"][::std::mem::size_of::<if_data>() - 136usize];
    ["Alignment of if_data"][::std::mem::align_of::<if_data>() - 8usize];
    ["Offset of field: if_data::ifi_type"][::std::mem::offset_of!(if_data, ifi_type) - 0usize];
    ["Offset of field: if_data::ifi_addrlen"]
        [::std::mem::offset_of!(if_data, ifi_addrlen) - 1usize];
    ["Offset of field: if_data::ifi_hdrlen"][::std::mem::offset_of!(if_data, ifi_hdrlen) - 2usize];
    ["Offset of field: if_data::ifi_link_state"]
        [::std::mem::offset_of!(if_data, ifi_link_state) - 4usize];
    ["Offset of field: if_data::ifi_mtu"][::std::mem::offset_of!(if_data, ifi_mtu) - 8usize];
    ["Offset of field: if_data::ifi_metric"][::std::mem::offset_of!(if_data, ifi_metric) - 16usize];
    ["Offset of field: if_data::ifi_baudrate"]
        [::std::mem::offset_of!(if_data, ifi_baudrate) - 24usize];
    ["Offset of field: if_data::ifi_ipackets"]
        [::std::mem::offset_of!(if_data, ifi_ipackets) - 32usize];
    ["Offset of field: if_data::ifi_ierrors"]
        [::std::mem::offset_of!(if_data, ifi_ierrors) - 40usize];
    ["Offset of field: if_data::ifi_opackets"]
        [::std::mem::offset_of!(if_data, ifi_opackets) - 48usize];
    ["Offset of field: if_data::ifi_oerrors"]
        [::std::mem::offset_of!(if_data, ifi_oerrors) - 56usize];
    ["Offset of field: if_data::ifi_collisions"]
        [::std::mem::offset_of!(if_data, ifi_collisions) - 64usize];
    ["Offset of field: if_data::ifi_ibytes"][::std::mem::offset_of!(if_data, ifi_ibytes) - 72usize];
    ["Offset of field: if_data::ifi_obytes"][::std::mem::offset_of!(if_data, ifi_obytes) - 80usize];
    ["Offset of field: if_data::ifi_imcasts"]
        [::std::mem::offset_of!(if_data, ifi_imcasts) - 88usize];
    ["Offset of field: if_data::ifi_omcasts"]
        [::std::mem::offset_of!(if_data, ifi_omcasts) - 96usize];
    ["Offset of field: if_data::ifi_iqdrops"]
        [::std::mem::offset_of!(if_data, ifi_iqdrops) - 104usize];
    ["Offset of field: if_data::ifi_noproto"]
        [::std::mem::offset_of!(if_data, ifi_noproto) - 112usize];
    ["Offset of field: if_data::ifi_lastchange"]
        [::std::mem::offset_of!(if_data, ifi_lastchange) - 120usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_status_description {
    pub ifs_type: ::std::os::raw::c_uchar,
    pub ifs_state: ::std::os::raw::c_uchar,
    pub ifs_string: *const ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_status_description"][::std::mem::size_of::<if_status_description>() - 16usize];
    ["Alignment of if_status_description"]
        [::std::mem::align_of::<if_status_description>() - 8usize];
    ["Offset of field: if_status_description::ifs_type"]
        [::std::mem::offset_of!(if_status_description, ifs_type) - 0usize];
    ["Offset of field: if_status_description::ifs_state"]
        [::std::mem::offset_of!(if_status_description, ifs_state) - 1usize];
    ["Offset of field: if_status_description::ifs_string"]
        [::std::mem::offset_of!(if_status_description, ifs_string) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifqueue {
    pub ifq_head: *mut mbuf,
    pub ifq_tail: *mut mbuf,
    pub ifq_len: ::std::os::raw::c_int,
    pub ifq_maxlen: ::std::os::raw::c_int,
    pub ifq_drops: u64,
    pub ifq_lock: *mut kmutex_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifqueue"][::std::mem::size_of::<ifqueue>() - 40usize];
    ["Alignment of ifqueue"][::std::mem::align_of::<ifqueue>() - 8usize];
    ["Offset of field: ifqueue::ifq_head"][::std::mem::offset_of!(ifqueue, ifq_head) - 0usize];
    ["Offset of field: ifqueue::ifq_tail"][::std::mem::offset_of!(ifqueue, ifq_tail) - 8usize];
    ["Offset of field: ifqueue::ifq_len"][::std::mem::offset_of!(ifqueue, ifq_len) - 16usize];
    ["Offset of field: ifqueue::ifq_maxlen"][::std::mem::offset_of!(ifqueue, ifq_maxlen) - 20usize];
    ["Offset of field: ifqueue::ifq_drops"][::std::mem::offset_of!(ifqueue, ifq_drops) - 24usize];
    ["Offset of field: ifqueue::ifq_lock"][::std::mem::offset_of!(ifqueue, ifq_lock) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifnet_head {
    pub tqh_first: *mut ifnet,
    pub tqh_last: *mut *mut ifnet,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifnet_head"][::std::mem::size_of::<ifnet_head>() - 16usize];
    ["Alignment of ifnet_head"][::std::mem::align_of::<ifnet_head>() - 8usize];
    ["Offset of field: ifnet_head::tqh_first"]
        [::std::mem::offset_of!(ifnet_head, tqh_first) - 0usize];
    ["Offset of field: ifnet_head::tqh_last"]
        [::std::mem::offset_of!(ifnet_head, tqh_last) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bridge_softc {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bridge_iflist {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct callout {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct krwlock {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_percpuq {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_deferred_start {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in6_multi {
    _unused: [u8; 0],
}
pub type if_index_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ifnet {
    pub if_softc: *mut ::std::os::raw::c_void,
    pub if_list: ifnet__bindgen_ty_1,
    pub if_addrlist: ifnet__bindgen_ty_2,
    pub if_xname: [::std::os::raw::c_char; 16usize],
    pub if_pcount: ::std::os::raw::c_int,
    pub if_bpf: *mut bpf_if,
    pub if_index: if_index_t,
    pub if_timer: ::std::os::raw::c_short,
    pub if_flags: ::std::os::raw::c_ushort,
    pub if_extflags: ::std::os::raw::c_short,
    pub if_type: u_char,
    pub if_addrlen: u_char,
    pub if_hdrlen: u_char,
    pub if_link_state: ::std::os::raw::c_int,
    pub if_mtu: u64,
    pub if_metric: u64,
    pub if_baudrate: u64,
    pub if_lastchange: timespec,
    pub if_stats: *mut ::std::os::raw::c_void,
    pub if_output: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ifnet,
            arg2: *mut mbuf,
            arg3: *const sockaddr,
            arg4: *const rtentry,
        ) -> ::std::os::raw::c_int,
    >,
    pub _if_input: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ifnet, arg2: *mut mbuf)>,
    pub if_start: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ifnet)>,
    pub if_transmit: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ifnet, arg2: *mut mbuf) -> ::std::os::raw::c_int,
    >,
    pub if_ioctl: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ifnet,
            arg2: u_long,
            arg3: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub if_init:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ifnet) -> ::std::os::raw::c_int>,
    pub if_stop:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ifnet, arg2: ::std::os::raw::c_int)>,
    pub if_slowtimo: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ifnet)>,
    pub if_drain: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ifnet)>,
    pub if_bpf_mtap: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut bpf_if, arg2: *mut mbuf, arg3: u_int),
    >,
    pub if_snd: ifaltq,
    pub if_dl: *mut ifaddr,
    pub if_sadl: *const sockaddr_dl,
    pub if_hwdl: *mut ifaddr,
    pub if_broadcastaddr: *const u8,
    pub if_bridge: *mut bridge_softc,
    pub if_bridgeif: *mut bridge_iflist,
    pub if_dlt: ::std::os::raw::c_int,
    pub if_pfil: *mut pfil_head_t,
    pub if_capabilities: u64,
    pub if_capenable: u64,
    pub if_carp_ptr: ifnet__bindgen_ty_3,
    pub if_csum_flags_tx: ::std::os::raw::c_int,
    pub if_csum_flags_rx: ::std::os::raw::c_int,
    pub if_afdata: [*mut ::std::os::raw::c_void; 37usize],
    pub if_mowner: *mut mowner,
    pub if_lagg: *mut ::std::os::raw::c_void,
    pub if_npf_private: *mut ::std::os::raw::c_void,
    pub if_pf_kif: *mut ::std::os::raw::c_void,
    pub if_pf_groups: *mut ::std::os::raw::c_void,
    pub if_index_gen: u64,
    pub if_sysctl_log: *mut sysctllog,
    pub if_initaddr: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ifnet,
            arg2: *mut ifaddr,
            arg3: bool,
        ) -> ::std::os::raw::c_int,
    >,
    pub if_setflags: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ifnet, arg2: u_short) -> ::std::os::raw::c_int,
    >,
    pub if_ioctl_lock: *mut kmutex_t,
    pub if_description: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifnet__bindgen_ty_1 {
    pub tqe_next: *mut ifnet,
    pub tqe_prev: *mut *mut ifnet,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifnet__bindgen_ty_1"][::std::mem::size_of::<ifnet__bindgen_ty_1>() - 16usize];
    ["Alignment of ifnet__bindgen_ty_1"][::std::mem::align_of::<ifnet__bindgen_ty_1>() - 8usize];
    ["Offset of field: ifnet__bindgen_ty_1::tqe_next"]
        [::std::mem::offset_of!(ifnet__bindgen_ty_1, tqe_next) - 0usize];
    ["Offset of field: ifnet__bindgen_ty_1::tqe_prev"]
        [::std::mem::offset_of!(ifnet__bindgen_ty_1, tqe_prev) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifnet__bindgen_ty_2 {
    pub tqh_first: *mut ifaddr,
    pub tqh_last: *mut *mut ifaddr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifnet__bindgen_ty_2"][::std::mem::size_of::<ifnet__bindgen_ty_2>() - 16usize];
    ["Alignment of ifnet__bindgen_ty_2"][::std::mem::align_of::<ifnet__bindgen_ty_2>() - 8usize];
    ["Offset of field: ifnet__bindgen_ty_2::tqh_first"]
        [::std::mem::offset_of!(ifnet__bindgen_ty_2, tqh_first) - 0usize];
    ["Offset of field: ifnet__bindgen_ty_2::tqh_last"]
        [::std::mem::offset_of!(ifnet__bindgen_ty_2, tqh_last) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union ifnet__bindgen_ty_3 {
    pub carp_s: *mut ::std::os::raw::c_void,
    pub carp_d: *mut ifnet,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifnet__bindgen_ty_3"][::std::mem::size_of::<ifnet__bindgen_ty_3>() - 8usize];
    ["Alignment of ifnet__bindgen_ty_3"][::std::mem::align_of::<ifnet__bindgen_ty_3>() - 8usize];
    ["Offset of field: ifnet__bindgen_ty_3::carp_s"]
        [::std::mem::offset_of!(ifnet__bindgen_ty_3, carp_s) - 0usize];
    ["Offset of field: ifnet__bindgen_ty_3::carp_d"]
        [::std::mem::offset_of!(ifnet__bindgen_ty_3, carp_d) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifnet"][::std::mem::size_of::<ifnet>() - 816usize];
    ["Alignment of ifnet"][::std::mem::align_of::<ifnet>() - 8usize];
    ["Offset of field: ifnet::if_softc"][::std::mem::offset_of!(ifnet, if_softc) - 0usize];
    ["Offset of field: ifnet::if_list"][::std::mem::offset_of!(ifnet, if_list) - 8usize];
    ["Offset of field: ifnet::if_addrlist"][::std::mem::offset_of!(ifnet, if_addrlist) - 24usize];
    ["Offset of field: ifnet::if_xname"][::std::mem::offset_of!(ifnet, if_xname) - 40usize];
    ["Offset of field: ifnet::if_pcount"][::std::mem::offset_of!(ifnet, if_pcount) - 56usize];
    ["Offset of field: ifnet::if_bpf"][::std::mem::offset_of!(ifnet, if_bpf) - 64usize];
    ["Offset of field: ifnet::if_index"][::std::mem::offset_of!(ifnet, if_index) - 72usize];
    ["Offset of field: ifnet::if_timer"][::std::mem::offset_of!(ifnet, if_timer) - 74usize];
    ["Offset of field: ifnet::if_flags"][::std::mem::offset_of!(ifnet, if_flags) - 76usize];
    ["Offset of field: ifnet::if_extflags"][::std::mem::offset_of!(ifnet, if_extflags) - 78usize];
    ["Offset of field: ifnet::if_type"][::std::mem::offset_of!(ifnet, if_type) - 80usize];
    ["Offset of field: ifnet::if_addrlen"][::std::mem::offset_of!(ifnet, if_addrlen) - 81usize];
    ["Offset of field: ifnet::if_hdrlen"][::std::mem::offset_of!(ifnet, if_hdrlen) - 82usize];
    ["Offset of field: ifnet::if_link_state"]
        [::std::mem::offset_of!(ifnet, if_link_state) - 84usize];
    ["Offset of field: ifnet::if_mtu"][::std::mem::offset_of!(ifnet, if_mtu) - 88usize];
    ["Offset of field: ifnet::if_metric"][::std::mem::offset_of!(ifnet, if_metric) - 96usize];
    ["Offset of field: ifnet::if_baudrate"][::std::mem::offset_of!(ifnet, if_baudrate) - 104usize];
    ["Offset of field: ifnet::if_lastchange"]
        [::std::mem::offset_of!(ifnet, if_lastchange) - 112usize];
    ["Offset of field: ifnet::if_stats"][::std::mem::offset_of!(ifnet, if_stats) - 128usize];
    ["Offset of field: ifnet::if_output"][::std::mem::offset_of!(ifnet, if_output) - 136usize];
    ["Offset of field: ifnet::_if_input"][::std::mem::offset_of!(ifnet, _if_input) - 144usize];
    ["Offset of field: ifnet::if_start"][::std::mem::offset_of!(ifnet, if_start) - 152usize];
    ["Offset of field: ifnet::if_transmit"][::std::mem::offset_of!(ifnet, if_transmit) - 160usize];
    ["Offset of field: ifnet::if_ioctl"][::std::mem::offset_of!(ifnet, if_ioctl) - 168usize];
    ["Offset of field: ifnet::if_init"][::std::mem::offset_of!(ifnet, if_init) - 176usize];
    ["Offset of field: ifnet::if_stop"][::std::mem::offset_of!(ifnet, if_stop) - 184usize];
    ["Offset of field: ifnet::if_slowtimo"][::std::mem::offset_of!(ifnet, if_slowtimo) - 192usize];
    ["Offset of field: ifnet::if_drain"][::std::mem::offset_of!(ifnet, if_drain) - 200usize];
    ["Offset of field: ifnet::if_bpf_mtap"][::std::mem::offset_of!(ifnet, if_bpf_mtap) - 208usize];
    ["Offset of field: ifnet::if_snd"][::std::mem::offset_of!(ifnet, if_snd) - 216usize];
    ["Offset of field: ifnet::if_dl"][::std::mem::offset_of!(ifnet, if_dl) - 336usize];
    ["Offset of field: ifnet::if_sadl"][::std::mem::offset_of!(ifnet, if_sadl) - 344usize];
    ["Offset of field: ifnet::if_hwdl"][::std::mem::offset_of!(ifnet, if_hwdl) - 352usize];
    ["Offset of field: ifnet::if_broadcastaddr"]
        [::std::mem::offset_of!(ifnet, if_broadcastaddr) - 360usize];
    ["Offset of field: ifnet::if_bridge"][::std::mem::offset_of!(ifnet, if_bridge) - 368usize];
    ["Offset of field: ifnet::if_bridgeif"][::std::mem::offset_of!(ifnet, if_bridgeif) - 376usize];
    ["Offset of field: ifnet::if_dlt"][::std::mem::offset_of!(ifnet, if_dlt) - 384usize];
    ["Offset of field: ifnet::if_pfil"][::std::mem::offset_of!(ifnet, if_pfil) - 392usize];
    ["Offset of field: ifnet::if_capabilities"]
        [::std::mem::offset_of!(ifnet, if_capabilities) - 400usize];
    ["Offset of field: ifnet::if_capenable"]
        [::std::mem::offset_of!(ifnet, if_capenable) - 408usize];
    ["Offset of field: ifnet::if_carp_ptr"][::std::mem::offset_of!(ifnet, if_carp_ptr) - 416usize];
    ["Offset of field: ifnet::if_csum_flags_tx"]
        [::std::mem::offset_of!(ifnet, if_csum_flags_tx) - 424usize];
    ["Offset of field: ifnet::if_csum_flags_rx"]
        [::std::mem::offset_of!(ifnet, if_csum_flags_rx) - 428usize];
    ["Offset of field: ifnet::if_afdata"][::std::mem::offset_of!(ifnet, if_afdata) - 432usize];
    ["Offset of field: ifnet::if_mowner"][::std::mem::offset_of!(ifnet, if_mowner) - 728usize];
    ["Offset of field: ifnet::if_lagg"][::std::mem::offset_of!(ifnet, if_lagg) - 736usize];
    ["Offset of field: ifnet::if_npf_private"]
        [::std::mem::offset_of!(ifnet, if_npf_private) - 744usize];
    ["Offset of field: ifnet::if_pf_kif"][::std::mem::offset_of!(ifnet, if_pf_kif) - 752usize];
    ["Offset of field: ifnet::if_pf_groups"]
        [::std::mem::offset_of!(ifnet, if_pf_groups) - 760usize];
    ["Offset of field: ifnet::if_index_gen"]
        [::std::mem::offset_of!(ifnet, if_index_gen) - 768usize];
    ["Offset of field: ifnet::if_sysctl_log"]
        [::std::mem::offset_of!(ifnet, if_sysctl_log) - 776usize];
    ["Offset of field: ifnet::if_initaddr"][::std::mem::offset_of!(ifnet, if_initaddr) - 784usize];
    ["Offset of field: ifnet::if_setflags"][::std::mem::offset_of!(ifnet, if_setflags) - 792usize];
    ["Offset of field: ifnet::if_ioctl_lock"]
        [::std::mem::offset_of!(ifnet, if_ioctl_lock) - 800usize];
    ["Offset of field: ifnet::if_description"]
        [::std::mem::offset_of!(ifnet, if_description) - 808usize];
};
pub type ifnet_t = ifnet;
pub const if_stat_t_if_ipackets: if_stat_t = 0;
pub const if_stat_t_if_ierrors: if_stat_t = 1;
pub const if_stat_t_if_opackets: if_stat_t = 2;
pub const if_stat_t_if_oerrors: if_stat_t = 3;
pub const if_stat_t_if_collisions: if_stat_t = 4;
pub const if_stat_t_if_ibytes: if_stat_t = 5;
pub const if_stat_t_if_obytes: if_stat_t = 6;
pub const if_stat_t_if_imcasts: if_stat_t = 7;
pub const if_stat_t_if_omcasts: if_stat_t = 8;
pub const if_stat_t_if_iqdrops: if_stat_t = 9;
pub const if_stat_t_if_noproto: if_stat_t = 10;
pub const if_stat_t_IF_NSTATS: if_stat_t = 11;
pub type if_stat_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifaddr_data {
    pub ifad_inbytes: i64,
    pub ifad_outbytes: i64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifaddr_data"][::std::mem::size_of::<ifaddr_data>() - 16usize];
    ["Alignment of ifaddr_data"][::std::mem::align_of::<ifaddr_data>() - 8usize];
    ["Offset of field: ifaddr_data::ifad_inbytes"]
        [::std::mem::offset_of!(ifaddr_data, ifad_inbytes) - 0usize];
    ["Offset of field: ifaddr_data::ifad_outbytes"]
        [::std::mem::offset_of!(ifaddr_data, ifad_outbytes) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifaddr {
    pub ifa_addr: *mut sockaddr,
    pub ifa_dstaddr: *mut sockaddr,
    pub ifa_netmask: *mut sockaddr,
    pub ifa_ifp: *mut ifnet,
    pub ifa_list: ifaddr__bindgen_ty_1,
    pub ifa_data: ifaddr_data,
    pub ifa_rtrequest: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut rtentry,
            arg3: *const rt_addrinfo,
        ),
    >,
    pub ifa_flags: u_int,
    pub ifa_refcnt: ::std::os::raw::c_int,
    pub ifa_metric: ::std::os::raw::c_int,
    pub ifa_getifa: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ifaddr, arg2: *const sockaddr) -> *mut ifaddr,
    >,
    pub ifa_seqno: *mut u32,
    pub ifa_preference: i16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifaddr__bindgen_ty_1 {
    pub tqe_next: *mut ifaddr,
    pub tqe_prev: *mut *mut ifaddr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifaddr__bindgen_ty_1"][::std::mem::size_of::<ifaddr__bindgen_ty_1>() - 16usize];
    ["Alignment of ifaddr__bindgen_ty_1"][::std::mem::align_of::<ifaddr__bindgen_ty_1>() - 8usize];
    ["Offset of field: ifaddr__bindgen_ty_1::tqe_next"]
        [::std::mem::offset_of!(ifaddr__bindgen_ty_1, tqe_next) - 0usize];
    ["Offset of field: ifaddr__bindgen_ty_1::tqe_prev"]
        [::std::mem::offset_of!(ifaddr__bindgen_ty_1, tqe_prev) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifaddr"][::std::mem::size_of::<ifaddr>() - 112usize];
    ["Alignment of ifaddr"][::std::mem::align_of::<ifaddr>() - 8usize];
    ["Offset of field: ifaddr::ifa_addr"][::std::mem::offset_of!(ifaddr, ifa_addr) - 0usize];
    ["Offset of field: ifaddr::ifa_dstaddr"][::std::mem::offset_of!(ifaddr, ifa_dstaddr) - 8usize];
    ["Offset of field: ifaddr::ifa_netmask"][::std::mem::offset_of!(ifaddr, ifa_netmask) - 16usize];
    ["Offset of field: ifaddr::ifa_ifp"][::std::mem::offset_of!(ifaddr, ifa_ifp) - 24usize];
    ["Offset of field: ifaddr::ifa_list"][::std::mem::offset_of!(ifaddr, ifa_list) - 32usize];
    ["Offset of field: ifaddr::ifa_data"][::std::mem::offset_of!(ifaddr, ifa_data) - 48usize];
    ["Offset of field: ifaddr::ifa_rtrequest"]
        [::std::mem::offset_of!(ifaddr, ifa_rtrequest) - 64usize];
    ["Offset of field: ifaddr::ifa_flags"][::std::mem::offset_of!(ifaddr, ifa_flags) - 72usize];
    ["Offset of field: ifaddr::ifa_refcnt"][::std::mem::offset_of!(ifaddr, ifa_refcnt) - 76usize];
    ["Offset of field: ifaddr::ifa_metric"][::std::mem::offset_of!(ifaddr, ifa_metric) - 80usize];
    ["Offset of field: ifaddr::ifa_getifa"][::std::mem::offset_of!(ifaddr, ifa_getifa) - 88usize];
    ["Offset of field: ifaddr::ifa_seqno"][::std::mem::offset_of!(ifaddr, ifa_seqno) - 96usize];
    ["Offset of field: ifaddr::ifa_preference"]
        [::std::mem::offset_of!(ifaddr, ifa_preference) - 104usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_msghdr {
    pub ifm_msglen: u_short,
    pub ifm_version: u_char,
    pub ifm_type: u_char,
    pub ifm_addrs: ::std::os::raw::c_int,
    pub ifm_flags: ::std::os::raw::c_int,
    pub ifm_index: u_short,
    pub ifm_data: if_data,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_msghdr"][::std::mem::size_of::<if_msghdr>() - 152usize];
    ["Alignment of if_msghdr"][::std::mem::align_of::<if_msghdr>() - 8usize];
    ["Offset of field: if_msghdr::ifm_msglen"]
        [::std::mem::offset_of!(if_msghdr, ifm_msglen) - 0usize];
    ["Offset of field: if_msghdr::ifm_version"]
        [::std::mem::offset_of!(if_msghdr, ifm_version) - 2usize];
    ["Offset of field: if_msghdr::ifm_type"][::std::mem::offset_of!(if_msghdr, ifm_type) - 3usize];
    ["Offset of field: if_msghdr::ifm_addrs"]
        [::std::mem::offset_of!(if_msghdr, ifm_addrs) - 4usize];
    ["Offset of field: if_msghdr::ifm_flags"]
        [::std::mem::offset_of!(if_msghdr, ifm_flags) - 8usize];
    ["Offset of field: if_msghdr::ifm_index"]
        [::std::mem::offset_of!(if_msghdr, ifm_index) - 12usize];
    ["Offset of field: if_msghdr::ifm_data"][::std::mem::offset_of!(if_msghdr, ifm_data) - 16usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct ifa_msghdr {
    pub ifam_msglen: u_short,
    pub ifam_version: u_char,
    pub ifam_type: u_char,
    pub ifam_index: u_short,
    pub ifam_flags: ::std::os::raw::c_int,
    pub ifam_addrs: ::std::os::raw::c_int,
    pub ifam_pid: __pid_t,
    pub ifam_addrflags: ::std::os::raw::c_int,
    pub ifam_metric: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifa_msghdr"][::std::mem::size_of::<ifa_msghdr>() - 32usize];
    ["Alignment of ifa_msghdr"][::std::mem::align_of::<ifa_msghdr>() - 8usize];
    ["Offset of field: ifa_msghdr::ifam_msglen"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_msglen) - 0usize];
    ["Offset of field: ifa_msghdr::ifam_version"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_version) - 2usize];
    ["Offset of field: ifa_msghdr::ifam_type"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_type) - 3usize];
    ["Offset of field: ifa_msghdr::ifam_index"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_index) - 4usize];
    ["Offset of field: ifa_msghdr::ifam_flags"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_flags) - 8usize];
    ["Offset of field: ifa_msghdr::ifam_addrs"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_addrs) - 12usize];
    ["Offset of field: ifa_msghdr::ifam_pid"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_pid) - 16usize];
    ["Offset of field: ifa_msghdr::ifam_addrflags"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_addrflags) - 20usize];
    ["Offset of field: ifa_msghdr::ifam_metric"]
        [::std::mem::offset_of!(ifa_msghdr, ifam_metric) - 24usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct if_announcemsghdr {
    pub ifan_msglen: u_short,
    pub ifan_version: u_char,
    pub ifan_type: u_char,
    pub ifan_index: u_short,
    pub ifan_name: [::std::os::raw::c_char; 16usize],
    pub ifan_what: u_short,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_announcemsghdr"][::std::mem::size_of::<if_announcemsghdr>() - 24usize];
    ["Alignment of if_announcemsghdr"][::std::mem::align_of::<if_announcemsghdr>() - 8usize];
    ["Offset of field: if_announcemsghdr::ifan_msglen"]
        [::std::mem::offset_of!(if_announcemsghdr, ifan_msglen) - 0usize];
    ["Offset of field: if_announcemsghdr::ifan_version"]
        [::std::mem::offset_of!(if_announcemsghdr, ifan_version) - 2usize];
    ["Offset of field: if_announcemsghdr::ifan_type"]
        [::std::mem::offset_of!(if_announcemsghdr, ifan_type) - 3usize];
    ["Offset of field: if_announcemsghdr::ifan_index"]
        [::std::mem::offset_of!(if_announcemsghdr, ifan_index) - 4usize];
    ["Offset of field: if_announcemsghdr::ifan_name"]
        [::std::mem::offset_of!(if_announcemsghdr, ifan_name) - 6usize];
    ["Offset of field: if_announcemsghdr::ifan_what"]
        [::std::mem::offset_of!(if_announcemsghdr, ifan_what) - 22usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ifreq {
    pub ifr_name: [::std::os::raw::c_char; 16usize],
    pub ifr_ifru: ifreq__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ifreq__bindgen_ty_1 {
    pub ifru_addr: sockaddr,
    pub ifru_dstaddr: sockaddr,
    pub ifru_broadaddr: sockaddr,
    pub ifru_space: sockaddr_storage,
    pub ifru_flags: ::std::os::raw::c_short,
    pub ifru_addrflags: ::std::os::raw::c_int,
    pub ifru_metric: ::std::os::raw::c_int,
    pub ifru_mtu: ::std::os::raw::c_int,
    pub ifru_dlt: ::std::os::raw::c_int,
    pub ifru_value: u_int,
    pub ifru_data: *mut ::std::os::raw::c_void,
    pub ifru_b: ifreq__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifreq__bindgen_ty_1__bindgen_ty_1 {
    pub b_buflen: u32,
    pub b_buf: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifreq__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<ifreq__bindgen_ty_1__bindgen_ty_1>() - 16usize];
    ["Alignment of ifreq__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<ifreq__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: ifreq__bindgen_ty_1__bindgen_ty_1::b_buflen"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1__bindgen_ty_1, b_buflen) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1__bindgen_ty_1::b_buf"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1__bindgen_ty_1, b_buf) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifreq__bindgen_ty_1"][::std::mem::size_of::<ifreq__bindgen_ty_1>() - 128usize];
    ["Alignment of ifreq__bindgen_ty_1"][::std::mem::align_of::<ifreq__bindgen_ty_1>() - 8usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_addr"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_addr) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_dstaddr"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_dstaddr) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_broadaddr"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_broadaddr) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_space"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_space) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_flags"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_flags) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_addrflags"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_addrflags) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_metric"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_metric) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_mtu"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_mtu) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_dlt"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_dlt) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_value"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_value) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_data"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_data) - 0usize];
    ["Offset of field: ifreq__bindgen_ty_1::ifru_b"]
        [::std::mem::offset_of!(ifreq__bindgen_ty_1, ifru_b) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifreq"][::std::mem::size_of::<ifreq>() - 144usize];
    ["Alignment of ifreq"][::std::mem::align_of::<ifreq>() - 8usize];
    ["Offset of field: ifreq::ifr_name"][::std::mem::offset_of!(ifreq, ifr_name) - 0usize];
    ["Offset of field: ifreq::ifr_ifru"][::std::mem::offset_of!(ifreq, ifr_ifru) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifcapreq {
    pub ifcr_name: [::std::os::raw::c_char; 16usize],
    pub ifcr_capabilities: u64,
    pub ifcr_capenable: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifcapreq"][::std::mem::size_of::<ifcapreq>() - 32usize];
    ["Alignment of ifcapreq"][::std::mem::align_of::<ifcapreq>() - 8usize];
    ["Offset of field: ifcapreq::ifcr_name"][::std::mem::offset_of!(ifcapreq, ifcr_name) - 0usize];
    ["Offset of field: ifcapreq::ifcr_capabilities"]
        [::std::mem::offset_of!(ifcapreq, ifcr_capabilities) - 16usize];
    ["Offset of field: ifcapreq::ifcr_capenable"]
        [::std::mem::offset_of!(ifcapreq, ifcr_capenable) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifaliasreq {
    pub ifra_name: [::std::os::raw::c_char; 16usize],
    pub ifra_addr: sockaddr,
    pub ifra_dstaddr: sockaddr,
    pub ifra_mask: sockaddr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifaliasreq"][::std::mem::size_of::<ifaliasreq>() - 64usize];
    ["Alignment of ifaliasreq"][::std::mem::align_of::<ifaliasreq>() - 1usize];
    ["Offset of field: ifaliasreq::ifra_name"]
        [::std::mem::offset_of!(ifaliasreq, ifra_name) - 0usize];
    ["Offset of field: ifaliasreq::ifra_addr"]
        [::std::mem::offset_of!(ifaliasreq, ifra_addr) - 16usize];
    ["Offset of field: ifaliasreq::ifra_dstaddr"]
        [::std::mem::offset_of!(ifaliasreq, ifra_dstaddr) - 32usize];
    ["Offset of field: ifaliasreq::ifra_mask"]
        [::std::mem::offset_of!(ifaliasreq, ifra_mask) - 48usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifdatareq {
    pub ifdr_name: [::std::os::raw::c_char; 16usize],
    pub ifdr_data: if_data,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifdatareq"][::std::mem::size_of::<ifdatareq>() - 152usize];
    ["Alignment of ifdatareq"][::std::mem::align_of::<ifdatareq>() - 8usize];
    ["Offset of field: ifdatareq::ifdr_name"]
        [::std::mem::offset_of!(ifdatareq, ifdr_name) - 0usize];
    ["Offset of field: ifdatareq::ifdr_data"]
        [::std::mem::offset_of!(ifdatareq, ifdr_data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifmediareq {
    pub ifm_name: [::std::os::raw::c_char; 16usize],
    pub ifm_current: ::std::os::raw::c_int,
    pub ifm_mask: ::std::os::raw::c_int,
    pub ifm_status: ::std::os::raw::c_int,
    pub ifm_active: ::std::os::raw::c_int,
    pub ifm_count: ::std::os::raw::c_int,
    pub ifm_ulist: *mut ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifmediareq"][::std::mem::size_of::<ifmediareq>() - 48usize];
    ["Alignment of ifmediareq"][::std::mem::align_of::<ifmediareq>() - 8usize];
    ["Offset of field: ifmediareq::ifm_name"]
        [::std::mem::offset_of!(ifmediareq, ifm_name) - 0usize];
    ["Offset of field: ifmediareq::ifm_current"]
        [::std::mem::offset_of!(ifmediareq, ifm_current) - 16usize];
    ["Offset of field: ifmediareq::ifm_mask"]
        [::std::mem::offset_of!(ifmediareq, ifm_mask) - 20usize];
    ["Offset of field: ifmediareq::ifm_status"]
        [::std::mem::offset_of!(ifmediareq, ifm_status) - 24usize];
    ["Offset of field: ifmediareq::ifm_active"]
        [::std::mem::offset_of!(ifmediareq, ifm_active) - 28usize];
    ["Offset of field: ifmediareq::ifm_count"]
        [::std::mem::offset_of!(ifmediareq, ifm_count) - 32usize];
    ["Offset of field: ifmediareq::ifm_ulist"]
        [::std::mem::offset_of!(ifmediareq, ifm_ulist) - 40usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifdrv {
    pub ifd_name: [::std::os::raw::c_char; 16usize],
    pub ifd_cmd: ::std::os::raw::c_ulong,
    pub ifd_len: usize,
    pub ifd_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifdrv"][::std::mem::size_of::<ifdrv>() - 40usize];
    ["Alignment of ifdrv"][::std::mem::align_of::<ifdrv>() - 8usize];
    ["Offset of field: ifdrv::ifd_name"][::std::mem::offset_of!(ifdrv, ifd_name) - 0usize];
    ["Offset of field: ifdrv::ifd_cmd"][::std::mem::offset_of!(ifdrv, ifd_cmd) - 16usize];
    ["Offset of field: ifdrv::ifd_len"][::std::mem::offset_of!(ifdrv, ifd_len) - 24usize];
    ["Offset of field: ifdrv::ifd_data"][::std::mem::offset_of!(ifdrv, ifd_data) - 32usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ifconf {
    pub ifc_len: ::std::os::raw::c_int,
    pub ifc_ifcu: ifconf__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ifconf__bindgen_ty_1 {
    pub ifcu_buf: *mut ::std::os::raw::c_void,
    pub ifcu_req: *mut ifreq,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifconf__bindgen_ty_1"][::std::mem::size_of::<ifconf__bindgen_ty_1>() - 8usize];
    ["Alignment of ifconf__bindgen_ty_1"][::std::mem::align_of::<ifconf__bindgen_ty_1>() - 8usize];
    ["Offset of field: ifconf__bindgen_ty_1::ifcu_buf"]
        [::std::mem::offset_of!(ifconf__bindgen_ty_1, ifcu_buf) - 0usize];
    ["Offset of field: ifconf__bindgen_ty_1::ifcu_req"]
        [::std::mem::offset_of!(ifconf__bindgen_ty_1, ifcu_req) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ifconf"][::std::mem::size_of::<ifconf>() - 16usize];
    ["Alignment of ifconf"][::std::mem::align_of::<ifconf>() - 8usize];
    ["Offset of field: ifconf::ifc_len"][::std::mem::offset_of!(ifconf, ifc_len) - 0usize];
    ["Offset of field: ifconf::ifc_ifcu"][::std::mem::offset_of!(ifconf, ifc_ifcu) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_laddrreq {
    pub iflr_name: [::std::os::raw::c_char; 16usize],
    pub flags: ::std::os::raw::c_uint,
    pub prefixlen: ::std::os::raw::c_uint,
    pub addr: sockaddr_storage,
    pub dstaddr: sockaddr_storage,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_laddrreq"][::std::mem::size_of::<if_laddrreq>() - 280usize];
    ["Alignment of if_laddrreq"][::std::mem::align_of::<if_laddrreq>() - 8usize];
    ["Offset of field: if_laddrreq::iflr_name"]
        [::std::mem::offset_of!(if_laddrreq, iflr_name) - 0usize];
    ["Offset of field: if_laddrreq::flags"][::std::mem::offset_of!(if_laddrreq, flags) - 16usize];
    ["Offset of field: if_laddrreq::prefixlen"]
        [::std::mem::offset_of!(if_laddrreq, prefixlen) - 20usize];
    ["Offset of field: if_laddrreq::addr"][::std::mem::offset_of!(if_laddrreq, addr) - 24usize];
    ["Offset of field: if_laddrreq::dstaddr"]
        [::std::mem::offset_of!(if_laddrreq, dstaddr) - 152usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_addrprefreq {
    pub ifap_name: [::std::os::raw::c_char; 16usize],
    pub ifap_preference: i16,
    pub ifap_addr: sockaddr_storage,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_addrprefreq"][::std::mem::size_of::<if_addrprefreq>() - 152usize];
    ["Alignment of if_addrprefreq"][::std::mem::align_of::<if_addrprefreq>() - 8usize];
    ["Offset of field: if_addrprefreq::ifap_name"]
        [::std::mem::offset_of!(if_addrprefreq, ifap_name) - 0usize];
    ["Offset of field: if_addrprefreq::ifap_preference"]
        [::std::mem::offset_of!(if_addrprefreq, ifap_preference) - 16usize];
    ["Offset of field: if_addrprefreq::ifap_addr"]
        [::std::mem::offset_of!(if_addrprefreq, ifap_addr) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct arphdr {
    pub ar_hrd: u16,
    pub ar_pro: u16,
    pub ar_hln: u8,
    pub ar_pln: u8,
    pub ar_op: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of arphdr"][::std::mem::size_of::<arphdr>() - 8usize];
    ["Alignment of arphdr"][::std::mem::align_of::<arphdr>() - 2usize];
    ["Offset of field: arphdr::ar_hrd"][::std::mem::offset_of!(arphdr, ar_hrd) - 0usize];
    ["Offset of field: arphdr::ar_pro"][::std::mem::offset_of!(arphdr, ar_pro) - 2usize];
    ["Offset of field: arphdr::ar_hln"][::std::mem::offset_of!(arphdr, ar_hln) - 4usize];
    ["Offset of field: arphdr::ar_pln"][::std::mem::offset_of!(arphdr, ar_pln) - 5usize];
    ["Offset of field: arphdr::ar_op"][::std::mem::offset_of!(arphdr, ar_op) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct arpreq {
    pub arp_pa: sockaddr,
    pub arp_ha: sockaddr,
    pub arp_flags: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of arpreq"][::std::mem::size_of::<arpreq>() - 36usize];
    ["Alignment of arpreq"][::std::mem::align_of::<arpreq>() - 4usize];
    ["Offset of field: arpreq::arp_pa"][::std::mem::offset_of!(arpreq, arp_pa) - 0usize];
    ["Offset of field: arpreq::arp_ha"][::std::mem::offset_of!(arpreq, arp_ha) - 16usize];
    ["Offset of field: arpreq::arp_flags"][::std::mem::offset_of!(arpreq, arp_flags) - 32usize];
};
unsafe extern "C" {
    pub fn arp_stat_add(arg1: ::std::os::raw::c_int, arg2: u64);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_nameindex {
    pub if_index: ::std::os::raw::c_uint,
    pub if_name: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of if_nameindex"][::std::mem::size_of::<if_nameindex>() - 16usize];
    ["Alignment of if_nameindex"][::std::mem::align_of::<if_nameindex>() - 8usize];
    ["Offset of field: if_nameindex::if_index"]
        [::std::mem::offset_of!(if_nameindex, if_index) - 0usize];
    ["Offset of field: if_nameindex::if_name"]
        [::std::mem::offset_of!(if_nameindex, if_name) - 8usize];
};
unsafe extern "C" {
    pub fn if_nametoindex(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn if_indextoname(
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn if_nameindex() -> *mut if_nameindex;
}
unsafe extern "C" {
    pub fn if_freenameindex(arg1: *mut if_nameindex);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cpu_info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lwp {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct psref_class {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct psref_target {
    pub prt_class: *mut psref_class,
    pub prt_draining: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of psref_target"][::std::mem::size_of::<psref_target>() - 16usize];
    ["Alignment of psref_target"][::std::mem::align_of::<psref_target>() - 8usize];
    ["Offset of field: psref_target::prt_class"]
        [::std::mem::offset_of!(psref_target, prt_class) - 0usize];
    ["Offset of field: psref_target::prt_draining"]
        [::std::mem::offset_of!(psref_target, prt_draining) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct psref {
    pub psref_entry: psref__bindgen_ty_1,
    pub psref_debug: *mut ::std::os::raw::c_void,
    pub psref_target: *const psref_target,
    pub psref_lwp: *mut lwp,
    pub psref_cpu: *mut cpu_info,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct psref__bindgen_ty_1 {
    pub sle_next: *mut psref,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of psref__bindgen_ty_1"][::std::mem::size_of::<psref__bindgen_ty_1>() - 8usize];
    ["Alignment of psref__bindgen_ty_1"][::std::mem::align_of::<psref__bindgen_ty_1>() - 8usize];
    ["Offset of field: psref__bindgen_ty_1::sle_next"]
        [::std::mem::offset_of!(psref__bindgen_ty_1, sle_next) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of psref"][::std::mem::size_of::<psref>() - 40usize];
    ["Alignment of psref"][::std::mem::align_of::<psref>() - 8usize];
    ["Offset of field: psref::psref_entry"][::std::mem::offset_of!(psref, psref_entry) - 0usize];
    ["Offset of field: psref::psref_debug"][::std::mem::offset_of!(psref, psref_debug) - 8usize];
    ["Offset of field: psref::psref_target"][::std::mem::offset_of!(psref, psref_target) - 16usize];
    ["Offset of field: psref::psref_lwp"][::std::mem::offset_of!(psref, psref_lwp) - 24usize];
    ["Offset of field: psref::psref_cpu"][::std::mem::offset_of!(psref, psref_cpu) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct route {
    pub _ro_rt: *mut rtentry,
    pub ro_sa: *mut sockaddr,
    pub ro_rtcache_generation: u64,
    pub ro_psref: psref,
    pub ro_bound: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of route"][::std::mem::size_of::<route>() - 72usize];
    ["Alignment of route"][::std::mem::align_of::<route>() - 8usize];
    ["Offset of field: route::_ro_rt"][::std::mem::offset_of!(route, _ro_rt) - 0usize];
    ["Offset of field: route::ro_sa"][::std::mem::offset_of!(route, ro_sa) - 8usize];
    ["Offset of field: route::ro_rtcache_generation"]
        [::std::mem::offset_of!(route, ro_rtcache_generation) - 16usize];
    ["Offset of field: route::ro_psref"][::std::mem::offset_of!(route, ro_psref) - 24usize];
    ["Offset of field: route::ro_bound"][::std::mem::offset_of!(route, ro_bound) - 64usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_metrics {
    pub rmx_locks: u64,
    pub rmx_mtu: u64,
    pub rmx_hopcount: u64,
    pub rmx_recvpipe: u64,
    pub rmx_sendpipe: u64,
    pub rmx_ssthresh: u64,
    pub rmx_rtt: u64,
    pub rmx_rttvar: u64,
    pub rmx_expire: time_t,
    pub rmx_pksent: time_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rt_metrics"][::std::mem::size_of::<rt_metrics>() - 80usize];
    ["Alignment of rt_metrics"][::std::mem::align_of::<rt_metrics>() - 8usize];
    ["Offset of field: rt_metrics::rmx_locks"]
        [::std::mem::offset_of!(rt_metrics, rmx_locks) - 0usize];
    ["Offset of field: rt_metrics::rmx_mtu"][::std::mem::offset_of!(rt_metrics, rmx_mtu) - 8usize];
    ["Offset of field: rt_metrics::rmx_hopcount"]
        [::std::mem::offset_of!(rt_metrics, rmx_hopcount) - 16usize];
    ["Offset of field: rt_metrics::rmx_recvpipe"]
        [::std::mem::offset_of!(rt_metrics, rmx_recvpipe) - 24usize];
    ["Offset of field: rt_metrics::rmx_sendpipe"]
        [::std::mem::offset_of!(rt_metrics, rmx_sendpipe) - 32usize];
    ["Offset of field: rt_metrics::rmx_ssthresh"]
        [::std::mem::offset_of!(rt_metrics, rmx_ssthresh) - 40usize];
    ["Offset of field: rt_metrics::rmx_rtt"][::std::mem::offset_of!(rt_metrics, rmx_rtt) - 48usize];
    ["Offset of field: rt_metrics::rmx_rttvar"]
        [::std::mem::offset_of!(rt_metrics, rmx_rttvar) - 56usize];
    ["Offset of field: rt_metrics::rmx_expire"]
        [::std::mem::offset_of!(rt_metrics, rmx_expire) - 64usize];
    ["Offset of field: rt_metrics::rmx_pksent"]
        [::std::mem::offset_of!(rt_metrics, rmx_pksent) - 72usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct radix_node {
    pub rn_mklist: *mut radix_mask,
    pub rn_p: *mut radix_node,
    pub rn_b: ::std::os::raw::c_short,
    pub rn_bmask: ::std::os::raw::c_char,
    pub rn_flags: u_char,
    pub rn_u: radix_node__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union radix_node__bindgen_ty_1 {
    pub rn_leaf: radix_node__bindgen_ty_1__bindgen_ty_1,
    pub rn_node: radix_node__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct radix_node__bindgen_ty_1__bindgen_ty_1 {
    pub rn_Key: *const ::std::os::raw::c_char,
    pub rn_Mask: *const ::std::os::raw::c_char,
    pub rn_Dupedkey: *mut radix_node,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of radix_node__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<radix_node__bindgen_ty_1__bindgen_ty_1>() - 24usize];
    ["Alignment of radix_node__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<radix_node__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: radix_node__bindgen_ty_1__bindgen_ty_1::rn_Key"]
        [::std::mem::offset_of!(radix_node__bindgen_ty_1__bindgen_ty_1, rn_Key) - 0usize];
    ["Offset of field: radix_node__bindgen_ty_1__bindgen_ty_1::rn_Mask"]
        [::std::mem::offset_of!(radix_node__bindgen_ty_1__bindgen_ty_1, rn_Mask) - 8usize];
    ["Offset of field: radix_node__bindgen_ty_1__bindgen_ty_1::rn_Dupedkey"]
        [::std::mem::offset_of!(radix_node__bindgen_ty_1__bindgen_ty_1, rn_Dupedkey) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct radix_node__bindgen_ty_1__bindgen_ty_2 {
    pub rn_Off: ::std::os::raw::c_int,
    pub rn_L: *mut radix_node,
    pub rn_R: *mut radix_node,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of radix_node__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<radix_node__bindgen_ty_1__bindgen_ty_2>() - 24usize];
    ["Alignment of radix_node__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<radix_node__bindgen_ty_1__bindgen_ty_2>() - 8usize];
    ["Offset of field: radix_node__bindgen_ty_1__bindgen_ty_2::rn_Off"]
        [::std::mem::offset_of!(radix_node__bindgen_ty_1__bindgen_ty_2, rn_Off) - 0usize];
    ["Offset of field: radix_node__bindgen_ty_1__bindgen_ty_2::rn_L"]
        [::std::mem::offset_of!(radix_node__bindgen_ty_1__bindgen_ty_2, rn_L) - 8usize];
    ["Offset of field: radix_node__bindgen_ty_1__bindgen_ty_2::rn_R"]
        [::std::mem::offset_of!(radix_node__bindgen_ty_1__bindgen_ty_2, rn_R) - 16usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of radix_node__bindgen_ty_1"]
        [::std::mem::size_of::<radix_node__bindgen_ty_1>() - 24usize];
    ["Alignment of radix_node__bindgen_ty_1"]
        [::std::mem::align_of::<radix_node__bindgen_ty_1>() - 8usize];
    ["Offset of field: radix_node__bindgen_ty_1::rn_leaf"]
        [::std::mem::offset_of!(radix_node__bindgen_ty_1, rn_leaf) - 0usize];
    ["Offset of field: radix_node__bindgen_ty_1::rn_node"]
        [::std::mem::offset_of!(radix_node__bindgen_ty_1, rn_node) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of radix_node"][::std::mem::size_of::<radix_node>() - 48usize];
    ["Alignment of radix_node"][::std::mem::align_of::<radix_node>() - 8usize];
    ["Offset of field: radix_node::rn_mklist"]
        [::std::mem::offset_of!(radix_node, rn_mklist) - 0usize];
    ["Offset of field: radix_node::rn_p"][::std::mem::offset_of!(radix_node, rn_p) - 8usize];
    ["Offset of field: radix_node::rn_b"][::std::mem::offset_of!(radix_node, rn_b) - 16usize];
    ["Offset of field: radix_node::rn_bmask"]
        [::std::mem::offset_of!(radix_node, rn_bmask) - 18usize];
    ["Offset of field: radix_node::rn_flags"]
        [::std::mem::offset_of!(radix_node, rn_flags) - 19usize];
    ["Offset of field: radix_node::rn_u"][::std::mem::offset_of!(radix_node, rn_u) - 24usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct radix_mask {
    pub rm_b: ::std::os::raw::c_short,
    pub rm_unused: ::std::os::raw::c_char,
    pub rm_flags: u_char,
    pub rm_mklist: *mut radix_mask,
    pub rm_rmu: radix_mask__bindgen_ty_1,
    pub rm_refs: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union radix_mask__bindgen_ty_1 {
    pub rmu_mask: *const ::std::os::raw::c_char,
    pub rmu_leaf: *mut radix_node,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of radix_mask__bindgen_ty_1"]
        [::std::mem::size_of::<radix_mask__bindgen_ty_1>() - 8usize];
    ["Alignment of radix_mask__bindgen_ty_1"]
        [::std::mem::align_of::<radix_mask__bindgen_ty_1>() - 8usize];
    ["Offset of field: radix_mask__bindgen_ty_1::rmu_mask"]
        [::std::mem::offset_of!(radix_mask__bindgen_ty_1, rmu_mask) - 0usize];
    ["Offset of field: radix_mask__bindgen_ty_1::rmu_leaf"]
        [::std::mem::offset_of!(radix_mask__bindgen_ty_1, rmu_leaf) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of radix_mask"][::std::mem::size_of::<radix_mask>() - 32usize];
    ["Alignment of radix_mask"][::std::mem::align_of::<radix_mask>() - 8usize];
    ["Offset of field: radix_mask::rm_b"][::std::mem::offset_of!(radix_mask, rm_b) - 0usize];
    ["Offset of field: radix_mask::rm_unused"]
        [::std::mem::offset_of!(radix_mask, rm_unused) - 2usize];
    ["Offset of field: radix_mask::rm_flags"]
        [::std::mem::offset_of!(radix_mask, rm_flags) - 3usize];
    ["Offset of field: radix_mask::rm_mklist"]
        [::std::mem::offset_of!(radix_mask, rm_mklist) - 8usize];
    ["Offset of field: radix_mask::rm_rmu"][::std::mem::offset_of!(radix_mask, rm_rmu) - 16usize];
    ["Offset of field: radix_mask::rm_refs"][::std::mem::offset_of!(radix_mask, rm_refs) - 24usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct radix_node_head {
    pub rnh_treetop: *mut radix_node,
    pub rnh_addrsize: ::std::os::raw::c_int,
    pub rnh_pktsize: ::std::os::raw::c_int,
    pub rnh_addaddr: ::std::option::Option<
        unsafe extern "C" fn(
            v: *const ::std::os::raw::c_void,
            mask: *const ::std::os::raw::c_void,
            head: *mut radix_node_head,
            nodes: *mut radix_node,
        ) -> *mut radix_node,
    >,
    pub rnh_addpkt: ::std::option::Option<
        unsafe extern "C" fn(
            v: *const ::std::os::raw::c_void,
            mask: *const ::std::os::raw::c_void,
            head: *mut radix_node_head,
            nodes: *mut radix_node,
        ) -> *mut radix_node,
    >,
    pub rnh_deladdr: ::std::option::Option<
        unsafe extern "C" fn(
            v: *const ::std::os::raw::c_void,
            mask: *const ::std::os::raw::c_void,
            head: *mut radix_node_head,
        ) -> *mut radix_node,
    >,
    pub rnh_delpkt: ::std::option::Option<
        unsafe extern "C" fn(
            v: *const ::std::os::raw::c_void,
            mask: *const ::std::os::raw::c_void,
            head: *mut radix_node_head,
        ) -> *mut radix_node,
    >,
    pub rnh_matchaddr: ::std::option::Option<
        unsafe extern "C" fn(
            v: *const ::std::os::raw::c_void,
            head: *mut radix_node_head,
        ) -> *mut radix_node,
    >,
    pub rnh_lookup: ::std::option::Option<
        unsafe extern "C" fn(
            v: *const ::std::os::raw::c_void,
            mask: *const ::std::os::raw::c_void,
            head: *mut radix_node_head,
        ) -> *mut radix_node,
    >,
    pub rnh_matchpkt: ::std::option::Option<
        unsafe extern "C" fn(
            v: *const ::std::os::raw::c_void,
            head: *mut radix_node_head,
        ) -> *mut radix_node,
    >,
    pub rnh_nodes: [radix_node; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of radix_node_head"][::std::mem::size_of::<radix_node_head>() - 216usize];
    ["Alignment of radix_node_head"][::std::mem::align_of::<radix_node_head>() - 8usize];
    ["Offset of field: radix_node_head::rnh_treetop"]
        [::std::mem::offset_of!(radix_node_head, rnh_treetop) - 0usize];
    ["Offset of field: radix_node_head::rnh_addrsize"]
        [::std::mem::offset_of!(radix_node_head, rnh_addrsize) - 8usize];
    ["Offset of field: radix_node_head::rnh_pktsize"]
        [::std::mem::offset_of!(radix_node_head, rnh_pktsize) - 12usize];
    ["Offset of field: radix_node_head::rnh_addaddr"]
        [::std::mem::offset_of!(radix_node_head, rnh_addaddr) - 16usize];
    ["Offset of field: radix_node_head::rnh_addpkt"]
        [::std::mem::offset_of!(radix_node_head, rnh_addpkt) - 24usize];
    ["Offset of field: radix_node_head::rnh_deladdr"]
        [::std::mem::offset_of!(radix_node_head, rnh_deladdr) - 32usize];
    ["Offset of field: radix_node_head::rnh_delpkt"]
        [::std::mem::offset_of!(radix_node_head, rnh_delpkt) - 40usize];
    ["Offset of field: radix_node_head::rnh_matchaddr"]
        [::std::mem::offset_of!(radix_node_head, rnh_matchaddr) - 48usize];
    ["Offset of field: radix_node_head::rnh_lookup"]
        [::std::mem::offset_of!(radix_node_head, rnh_lookup) - 56usize];
    ["Offset of field: radix_node_head::rnh_matchpkt"]
        [::std::mem::offset_of!(radix_node_head, rnh_matchpkt) - 64usize];
    ["Offset of field: radix_node_head::rnh_nodes"]
        [::std::mem::offset_of!(radix_node_head, rnh_nodes) - 72usize];
};
unsafe extern "C" {
    pub fn rn_init();
}
unsafe extern "C" {
    pub fn rn_inithead(
        arg1: *mut *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn rn_delayedinit(arg1: *mut *mut ::std::os::raw::c_void, arg2: ::std::os::raw::c_int);
}
unsafe extern "C" {
    pub fn rn_inithead0(
        arg1: *mut radix_node_head,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn rn_refines(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn rn_walktree(
        arg1: *mut radix_node_head,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut radix_node,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn rn_search_matched(
        arg1: *mut radix_node_head,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut radix_node,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_addmask(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_addroute(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: *mut radix_node_head,
        arg4: *mut radix_node,
    ) -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_delete1(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: *mut radix_node_head,
        arg4: *mut radix_node,
    ) -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_delete(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: *mut radix_node_head,
    ) -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_insert(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut radix_node_head,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut radix_node,
    ) -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_lookup(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: *mut radix_node_head,
    ) -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_match(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut radix_node_head,
    ) -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_newpair(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: *mut radix_node,
    ) -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_search(arg1: *const ::std::os::raw::c_void, arg2: *mut radix_node)
    -> *mut radix_node;
}
unsafe extern "C" {
    pub fn rn_search_m(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut radix_node,
        arg3: *const ::std::os::raw::c_void,
    ) -> *mut radix_node;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rtentry {
    pub rt_nodes: [radix_node; 2usize],
    pub rt_gateway: *mut sockaddr,
    pub rt_flags: ::std::os::raw::c_int,
    pub rt_refcnt: ::std::os::raw::c_int,
    pub rt_use: u64,
    pub rt_ifp: *mut ifnet,
    pub rt_ifa: *mut ifaddr,
    pub rt_ifa_seqno: u32,
    pub rt_llinfo: *mut ::std::os::raw::c_void,
    pub rt_rmx: rt_metrics,
    pub rt_gwroute: *mut rtentry,
    pub rt_timer: rtentry__bindgen_ty_1,
    pub rt_parent: *mut rtentry,
    pub _rt_key: *mut sockaddr,
    pub rt_tag: *mut sockaddr,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rtentry__bindgen_ty_1 {
    pub lh_first: *mut rttimer,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rtentry__bindgen_ty_1"][::std::mem::size_of::<rtentry__bindgen_ty_1>() - 8usize];
    ["Alignment of rtentry__bindgen_ty_1"]
        [::std::mem::align_of::<rtentry__bindgen_ty_1>() - 8usize];
    ["Offset of field: rtentry__bindgen_ty_1::lh_first"]
        [::std::mem::offset_of!(rtentry__bindgen_ty_1, lh_first) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rtentry"][::std::mem::size_of::<rtentry>() - 272usize];
    ["Alignment of rtentry"][::std::mem::align_of::<rtentry>() - 8usize];
    ["Offset of field: rtentry::rt_nodes"][::std::mem::offset_of!(rtentry, rt_nodes) - 0usize];
    ["Offset of field: rtentry::rt_gateway"][::std::mem::offset_of!(rtentry, rt_gateway) - 96usize];
    ["Offset of field: rtentry::rt_flags"][::std::mem::offset_of!(rtentry, rt_flags) - 104usize];
    ["Offset of field: rtentry::rt_refcnt"][::std::mem::offset_of!(rtentry, rt_refcnt) - 108usize];
    ["Offset of field: rtentry::rt_use"][::std::mem::offset_of!(rtentry, rt_use) - 112usize];
    ["Offset of field: rtentry::rt_ifp"][::std::mem::offset_of!(rtentry, rt_ifp) - 120usize];
    ["Offset of field: rtentry::rt_ifa"][::std::mem::offset_of!(rtentry, rt_ifa) - 128usize];
    ["Offset of field: rtentry::rt_ifa_seqno"]
        [::std::mem::offset_of!(rtentry, rt_ifa_seqno) - 136usize];
    ["Offset of field: rtentry::rt_llinfo"][::std::mem::offset_of!(rtentry, rt_llinfo) - 144usize];
    ["Offset of field: rtentry::rt_rmx"][::std::mem::offset_of!(rtentry, rt_rmx) - 152usize];
    ["Offset of field: rtentry::rt_gwroute"]
        [::std::mem::offset_of!(rtentry, rt_gwroute) - 232usize];
    ["Offset of field: rtentry::rt_timer"][::std::mem::offset_of!(rtentry, rt_timer) - 240usize];
    ["Offset of field: rtentry::rt_parent"][::std::mem::offset_of!(rtentry, rt_parent) - 248usize];
    ["Offset of field: rtentry::_rt_key"][::std::mem::offset_of!(rtentry, _rt_key) - 256usize];
    ["Offset of field: rtentry::rt_tag"][::std::mem::offset_of!(rtentry, rt_tag) - 264usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ortentry {
    pub rt_hash: u32,
    pub rt_dst: sockaddr,
    pub rt_gateway: sockaddr,
    pub rt_flags: i16,
    pub rt_refcnt: i16,
    pub rt_use: u32,
    pub rt_ifp: *mut ifnet,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ortentry"][::std::mem::size_of::<ortentry>() - 56usize];
    ["Alignment of ortentry"][::std::mem::align_of::<ortentry>() - 8usize];
    ["Offset of field: ortentry::rt_hash"][::std::mem::offset_of!(ortentry, rt_hash) - 0usize];
    ["Offset of field: ortentry::rt_dst"][::std::mem::offset_of!(ortentry, rt_dst) - 4usize];
    ["Offset of field: ortentry::rt_gateway"]
        [::std::mem::offset_of!(ortentry, rt_gateway) - 20usize];
    ["Offset of field: ortentry::rt_flags"][::std::mem::offset_of!(ortentry, rt_flags) - 36usize];
    ["Offset of field: ortentry::rt_refcnt"][::std::mem::offset_of!(ortentry, rt_refcnt) - 38usize];
    ["Offset of field: ortentry::rt_use"][::std::mem::offset_of!(ortentry, rt_use) - 40usize];
    ["Offset of field: ortentry::rt_ifp"][::std::mem::offset_of!(ortentry, rt_ifp) - 48usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rtstat {
    pub rts_badredirect: u64,
    pub rts_dynamic: u64,
    pub rts_newgateway: u64,
    pub rts_unreach: u64,
    pub rts_wildcard: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rtstat"][::std::mem::size_of::<rtstat>() - 40usize];
    ["Alignment of rtstat"][::std::mem::align_of::<rtstat>() - 8usize];
    ["Offset of field: rtstat::rts_badredirect"]
        [::std::mem::offset_of!(rtstat, rts_badredirect) - 0usize];
    ["Offset of field: rtstat::rts_dynamic"][::std::mem::offset_of!(rtstat, rts_dynamic) - 8usize];
    ["Offset of field: rtstat::rts_newgateway"]
        [::std::mem::offset_of!(rtstat, rts_newgateway) - 16usize];
    ["Offset of field: rtstat::rts_unreach"][::std::mem::offset_of!(rtstat, rts_unreach) - 24usize];
    ["Offset of field: rtstat::rts_wildcard"]
        [::std::mem::offset_of!(rtstat, rts_wildcard) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_msghdr {
    pub rtm_msglen: u_short,
    pub rtm_version: u_char,
    pub rtm_type: u_char,
    pub rtm_index: u_short,
    pub rtm_flags: ::std::os::raw::c_int,
    pub rtm_addrs: ::std::os::raw::c_int,
    pub rtm_pid: __pid_t,
    pub rtm_seq: ::std::os::raw::c_int,
    pub rtm_errno: ::std::os::raw::c_int,
    pub rtm_use: ::std::os::raw::c_int,
    pub rtm_inits: ::std::os::raw::c_int,
    pub rtm_rmx: rt_metrics,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rt_msghdr"][::std::mem::size_of::<rt_msghdr>() - 120usize];
    ["Alignment of rt_msghdr"][::std::mem::align_of::<rt_msghdr>() - 8usize];
    ["Offset of field: rt_msghdr::rtm_msglen"]
        [::std::mem::offset_of!(rt_msghdr, rtm_msglen) - 0usize];
    ["Offset of field: rt_msghdr::rtm_version"]
        [::std::mem::offset_of!(rt_msghdr, rtm_version) - 2usize];
    ["Offset of field: rt_msghdr::rtm_type"][::std::mem::offset_of!(rt_msghdr, rtm_type) - 3usize];
    ["Offset of field: rt_msghdr::rtm_index"]
        [::std::mem::offset_of!(rt_msghdr, rtm_index) - 4usize];
    ["Offset of field: rt_msghdr::rtm_flags"]
        [::std::mem::offset_of!(rt_msghdr, rtm_flags) - 8usize];
    ["Offset of field: rt_msghdr::rtm_addrs"]
        [::std::mem::offset_of!(rt_msghdr, rtm_addrs) - 12usize];
    ["Offset of field: rt_msghdr::rtm_pid"][::std::mem::offset_of!(rt_msghdr, rtm_pid) - 16usize];
    ["Offset of field: rt_msghdr::rtm_seq"][::std::mem::offset_of!(rt_msghdr, rtm_seq) - 20usize];
    ["Offset of field: rt_msghdr::rtm_errno"]
        [::std::mem::offset_of!(rt_msghdr, rtm_errno) - 24usize];
    ["Offset of field: rt_msghdr::rtm_use"][::std::mem::offset_of!(rt_msghdr, rtm_use) - 28usize];
    ["Offset of field: rt_msghdr::rtm_inits"]
        [::std::mem::offset_of!(rt_msghdr, rtm_inits) - 32usize];
    ["Offset of field: rt_msghdr::rtm_rmx"][::std::mem::offset_of!(rt_msghdr, rtm_rmx) - 40usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_addrinfo {
    pub rti_addrs: ::std::os::raw::c_int,
    pub rti_info: [*const sockaddr; 9usize],
    pub rti_flags: ::std::os::raw::c_int,
    pub rti_ifa: *mut ifaddr,
    pub rti_ifp: *mut ifnet,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rt_addrinfo"][::std::mem::size_of::<rt_addrinfo>() - 104usize];
    ["Alignment of rt_addrinfo"][::std::mem::align_of::<rt_addrinfo>() - 8usize];
    ["Offset of field: rt_addrinfo::rti_addrs"]
        [::std::mem::offset_of!(rt_addrinfo, rti_addrs) - 0usize];
    ["Offset of field: rt_addrinfo::rti_info"]
        [::std::mem::offset_of!(rt_addrinfo, rti_info) - 8usize];
    ["Offset of field: rt_addrinfo::rti_flags"]
        [::std::mem::offset_of!(rt_addrinfo, rti_flags) - 80usize];
    ["Offset of field: rt_addrinfo::rti_ifa"]
        [::std::mem::offset_of!(rt_addrinfo, rti_ifa) - 88usize];
    ["Offset of field: rt_addrinfo::rti_ifp"]
        [::std::mem::offset_of!(rt_addrinfo, rti_ifp) - 96usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct route_cb {
    pub ip_count: ::std::os::raw::c_int,
    pub ip6_count: ::std::os::raw::c_int,
    pub unused1: ::std::os::raw::c_int,
    pub mpls_count: ::std::os::raw::c_int,
    pub any_count: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of route_cb"][::std::mem::size_of::<route_cb>() - 20usize];
    ["Alignment of route_cb"][::std::mem::align_of::<route_cb>() - 4usize];
    ["Offset of field: route_cb::ip_count"][::std::mem::offset_of!(route_cb, ip_count) - 0usize];
    ["Offset of field: route_cb::ip6_count"][::std::mem::offset_of!(route_cb, ip6_count) - 4usize];
    ["Offset of field: route_cb::unused1"][::std::mem::offset_of!(route_cb, unused1) - 8usize];
    ["Offset of field: route_cb::mpls_count"]
        [::std::mem::offset_of!(route_cb, mpls_count) - 12usize];
    ["Offset of field: route_cb::any_count"][::std::mem::offset_of!(route_cb, any_count) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rttimer {
    pub rtt_next: rttimer__bindgen_ty_1,
    pub rtt_link: rttimer__bindgen_ty_2,
    pub rtt_queue: *mut rttimer_queue,
    pub rtt_rt: *mut rtentry,
    pub rtt_func:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut rtentry, arg2: *mut rttimer)>,
    pub rtt_time: time_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rttimer__bindgen_ty_1 {
    pub tqe_next: *mut rttimer,
    pub tqe_prev: *mut *mut rttimer,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rttimer__bindgen_ty_1"][::std::mem::size_of::<rttimer__bindgen_ty_1>() - 16usize];
    ["Alignment of rttimer__bindgen_ty_1"]
        [::std::mem::align_of::<rttimer__bindgen_ty_1>() - 8usize];
    ["Offset of field: rttimer__bindgen_ty_1::tqe_next"]
        [::std::mem::offset_of!(rttimer__bindgen_ty_1, tqe_next) - 0usize];
    ["Offset of field: rttimer__bindgen_ty_1::tqe_prev"]
        [::std::mem::offset_of!(rttimer__bindgen_ty_1, tqe_prev) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rttimer__bindgen_ty_2 {
    pub le_next: *mut rttimer,
    pub le_prev: *mut *mut rttimer,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rttimer__bindgen_ty_2"][::std::mem::size_of::<rttimer__bindgen_ty_2>() - 16usize];
    ["Alignment of rttimer__bindgen_ty_2"]
        [::std::mem::align_of::<rttimer__bindgen_ty_2>() - 8usize];
    ["Offset of field: rttimer__bindgen_ty_2::le_next"]
        [::std::mem::offset_of!(rttimer__bindgen_ty_2, le_next) - 0usize];
    ["Offset of field: rttimer__bindgen_ty_2::le_prev"]
        [::std::mem::offset_of!(rttimer__bindgen_ty_2, le_prev) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rttimer"][::std::mem::size_of::<rttimer>() - 64usize];
    ["Alignment of rttimer"][::std::mem::align_of::<rttimer>() - 8usize];
    ["Offset of field: rttimer::rtt_next"][::std::mem::offset_of!(rttimer, rtt_next) - 0usize];
    ["Offset of field: rttimer::rtt_link"][::std::mem::offset_of!(rttimer, rtt_link) - 16usize];
    ["Offset of field: rttimer::rtt_queue"][::std::mem::offset_of!(rttimer, rtt_queue) - 32usize];
    ["Offset of field: rttimer::rtt_rt"][::std::mem::offset_of!(rttimer, rtt_rt) - 40usize];
    ["Offset of field: rttimer::rtt_func"][::std::mem::offset_of!(rttimer, rtt_func) - 48usize];
    ["Offset of field: rttimer::rtt_time"][::std::mem::offset_of!(rttimer, rtt_time) - 56usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rttimer_queue {
    pub rtq_timeout: ::std::os::raw::c_long,
    pub rtq_count: ::std::os::raw::c_ulong,
    pub rtq_head: rttimer_queue__bindgen_ty_1,
    pub rtq_link: rttimer_queue__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rttimer_queue__bindgen_ty_1 {
    pub tqh_first: *mut rttimer,
    pub tqh_last: *mut *mut rttimer,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rttimer_queue__bindgen_ty_1"]
        [::std::mem::size_of::<rttimer_queue__bindgen_ty_1>() - 16usize];
    ["Alignment of rttimer_queue__bindgen_ty_1"]
        [::std::mem::align_of::<rttimer_queue__bindgen_ty_1>() - 8usize];
    ["Offset of field: rttimer_queue__bindgen_ty_1::tqh_first"]
        [::std::mem::offset_of!(rttimer_queue__bindgen_ty_1, tqh_first) - 0usize];
    ["Offset of field: rttimer_queue__bindgen_ty_1::tqh_last"]
        [::std::mem::offset_of!(rttimer_queue__bindgen_ty_1, tqh_last) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rttimer_queue__bindgen_ty_2 {
    pub le_next: *mut rttimer_queue,
    pub le_prev: *mut *mut rttimer_queue,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rttimer_queue__bindgen_ty_2"]
        [::std::mem::size_of::<rttimer_queue__bindgen_ty_2>() - 16usize];
    ["Alignment of rttimer_queue__bindgen_ty_2"]
        [::std::mem::align_of::<rttimer_queue__bindgen_ty_2>() - 8usize];
    ["Offset of field: rttimer_queue__bindgen_ty_2::le_next"]
        [::std::mem::offset_of!(rttimer_queue__bindgen_ty_2, le_next) - 0usize];
    ["Offset of field: rttimer_queue__bindgen_ty_2::le_prev"]
        [::std::mem::offset_of!(rttimer_queue__bindgen_ty_2, le_prev) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of rttimer_queue"][::std::mem::size_of::<rttimer_queue>() - 48usize];
    ["Alignment of rttimer_queue"][::std::mem::align_of::<rttimer_queue>() - 8usize];
    ["Offset of field: rttimer_queue::rtq_timeout"]
        [::std::mem::offset_of!(rttimer_queue, rtq_timeout) - 0usize];
    ["Offset of field: rttimer_queue::rtq_count"]
        [::std::mem::offset_of!(rttimer_queue, rtq_count) - 8usize];
    ["Offset of field: rttimer_queue::rtq_head"]
        [::std::mem::offset_of!(rttimer_queue, rtq_head) - 16usize];
    ["Offset of field: rttimer_queue::rtq_link"]
        [::std::mem::offset_of!(rttimer_queue, rtq_link) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rtbl {
    _unused: [u8; 0],
}
pub type rtbl_t = rtbl;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dl_addr {
    pub dl_type: u8,
    pub dl_nlen: u8,
    pub dl_alen: u8,
    pub dl_slen: u8,
    pub dl_data: [::std::os::raw::c_char; 24usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dl_addr"][::std::mem::size_of::<dl_addr>() - 28usize];
    ["Alignment of dl_addr"][::std::mem::align_of::<dl_addr>() - 1usize];
    ["Offset of field: dl_addr::dl_type"][::std::mem::offset_of!(dl_addr, dl_type) - 0usize];
    ["Offset of field: dl_addr::dl_nlen"][::std::mem::offset_of!(dl_addr, dl_nlen) - 1usize];
    ["Offset of field: dl_addr::dl_alen"][::std::mem::offset_of!(dl_addr, dl_alen) - 2usize];
    ["Offset of field: dl_addr::dl_slen"][::std::mem::offset_of!(dl_addr, dl_slen) - 3usize];
    ["Offset of field: dl_addr::dl_data"][::std::mem::offset_of!(dl_addr, dl_data) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_dl {
    pub sdl_len: u8,
    pub sdl_family: __sa_family_t,
    pub sdl_index: u16,
    pub sdl_addr: dl_addr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of sockaddr_dl"][::std::mem::size_of::<sockaddr_dl>() - 32usize];
    ["Alignment of sockaddr_dl"][::std::mem::align_of::<sockaddr_dl>() - 2usize];
    ["Offset of field: sockaddr_dl::sdl_len"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_len) - 0usize];
    ["Offset of field: sockaddr_dl::sdl_family"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_family) - 1usize];
    ["Offset of field: sockaddr_dl::sdl_index"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_index) - 2usize];
    ["Offset of field: sockaddr_dl::sdl_addr"]
        [::std::mem::offset_of!(sockaddr_dl, sdl_addr) - 4usize];
};
unsafe extern "C" {
    pub fn link_addr(arg1: *const ::std::os::raw::c_char, arg2: *mut sockaddr_dl);
}
unsafe extern "C" {
    pub fn link_ntoa(arg1: *const sockaddr_dl) -> *mut ::std::os::raw::c_char;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __va_list_tag"][::std::mem::size_of::<__va_list_tag>() - 24usize];
    ["Alignment of __va_list_tag"][::std::mem::align_of::<__va_list_tag>() - 8usize];
    ["Offset of field: __va_list_tag::gp_offset"]
        [::std::mem::offset_of!(__va_list_tag, gp_offset) - 0usize];
    ["Offset of field: __va_list_tag::fp_offset"]
        [::std::mem::offset_of!(__va_list_tag, fp_offset) - 4usize];
    ["Offset of field: __va_list_tag::overflow_arg_area"]
        [::std::mem::offset_of!(__va_list_tag, overflow_arg_area) - 8usize];
    ["Offset of field: __va_list_tag::reg_save_area"]
        [::std::mem::offset_of!(__va_list_tag, reg_save_area) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_if {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mowner {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysctllog {
    pub _address: u8,
}
