// This file is @generated by prost-build.
/// ProfilesDictionary represents the profiles data shared across the
/// entire message being sent.
///
/// Note that all fields in this message MUST have a zero value encoded as the first element.
/// This allows for \_index fields pointing into the dictionary to use a 0 pointer value
/// to indicate 'null' / 'not set'. Unless otherwise defined, a 'zero value' message value
/// is one with all default field values, so as to minimize wire encoded size.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ProfilesDictionary {
    /// Mappings from address ranges to the image/binary/library mapped
    /// into that address range referenced by locations via Location.mapping_index.
    #[prost(message, repeated, tag = "1")]
    pub mapping_table: ::prost::alloc::vec::Vec<Mapping>,
    /// Locations referenced by samples via Stack.location_indices.
    #[prost(message, repeated, tag = "2")]
    pub location_table: ::prost::alloc::vec::Vec<Location>,
    /// Functions referenced by locations via Line.function_index.
    #[prost(message, repeated, tag = "3")]
    pub function_table: ::prost::alloc::vec::Vec<Function>,
    /// Links referenced by samples via Sample.link_index.
    #[prost(message, repeated, tag = "4")]
    pub link_table: ::prost::alloc::vec::Vec<Link>,
    /// A common table for strings referenced by various messages.
    /// string_table\[0\] must always be "".
    #[prost(string, repeated, tag = "5")]
    pub string_table: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// A common table for attributes referenced by various messages.
    /// It is a collection of key/value pairs. Note, global attributes
    /// like server name can be set using the resource API. Examples of attributes:
    ///
    /// ```text
    /// "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
    /// "/http/server_latency": 300
    /// "abc.com/myattribute": true
    /// "abc.com/score": 10.239
    /// ```
    ///
    /// The attribute values SHOULD NOT contain empty values.
    /// The attribute values SHOULD NOT contain bytes values.
    /// The attribute values SHOULD NOT contain array values different than array of string values, bool values, int values,
    /// double values.
    /// The attribute values SHOULD NOT contain kvlist values.
    /// The behavior of software that receives attributes containing such values can be unpredictable.
    /// These restrictions can change in a minor release.
    /// The restrictions take origin from the OpenTelemetry specification:
    /// <https://github.com/open-telemetry/opentelemetry-specification/blob/v1.47.0/specification/common/README.md#attribute.>
    #[prost(message, repeated, tag = "6")]
    pub attribute_table: ::prost::alloc::vec::Vec<KeyValueAndUnit>,
    /// Stacks referenced by samples via Sample.stack_index.
    #[prost(message, repeated, tag = "7")]
    pub stack_table: ::prost::alloc::vec::Vec<Stack>,
}
/// ProfilesData represents the profiles data that can be stored in persistent storage,
/// OR can be embedded by other protocols that transfer OTLP profiles data but do not
/// implement the OTLP protocol.
///
/// The main difference between this message and collector protocol is that
/// in this message there will not be any "control" or "metadata" specific to
/// OTLP protocol.
///
/// When new fields are added into this message, the OTLP request MUST be updated
/// as well.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ProfilesData {
    /// An array of ResourceProfiles.
    /// For data coming from an SDK profiler, this array will typically contain one
    /// element. Host-level profilers will usually create one ResourceProfile per
    /// container, as well as one additional ResourceProfile grouping all samples
    /// from non-containerized processes.
    /// Other resource groupings are possible as well and clarified via
    /// Resource.attributes and semantic conventions.
    /// Tools that visualize profiles should prefer displaying
    /// resources_profiles\[0\].scope_profiles\[0\].profiles\[0\] by default.
    #[prost(message, repeated, tag = "1")]
    pub resource_profiles: ::prost::alloc::vec::Vec<ResourceProfiles>,
    /// One instance of ProfilesDictionary
    #[prost(message, optional, tag = "2")]
    pub dictionary: ::core::option::Option<ProfilesDictionary>,
}
/// A collection of ScopeProfiles from a Resource.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceProfiles {
    /// The resource for the profiles in this message.
    /// If this field is not set then no resource info is known.
    #[prost(message, optional, tag = "1")]
    pub resource: ::core::option::Option<super::super::resource::v1::Resource>,
    /// A list of ScopeProfiles that originate from a resource.
    #[prost(message, repeated, tag = "2")]
    pub scope_profiles: ::prost::alloc::vec::Vec<ScopeProfiles>,
    /// The Schema URL, if known. This is the identifier of the Schema that the resource data
    /// is recorded in. Notably, the last part of the URL path is the version number of the
    /// schema: http\[s\]://server\[:port\]/path/<version>. To learn more about Schema URL see
    /// <https://opentelemetry.io/docs/specs/otel/schemas/#schema-url>
    /// This schema_url applies to the data in the "resource" field. It does not apply
    /// to the data in the "scope_profiles" field which have their own schema_url field.
    #[prost(string, tag = "3")]
    pub schema_url: ::prost::alloc::string::String,
}
/// A collection of Profiles produced by an InstrumentationScope.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ScopeProfiles {
    /// The instrumentation scope information for the profiles in this message.
    /// Semantically when InstrumentationScope isn't set, it is equivalent with
    /// an empty instrumentation scope name (unknown).
    #[prost(message, optional, tag = "1")]
    pub scope: ::core::option::Option<super::super::common::v1::InstrumentationScope>,
    /// A list of Profiles that originate from an instrumentation scope.
    #[prost(message, repeated, tag = "2")]
    pub profiles: ::prost::alloc::vec::Vec<Profile>,
    /// The Schema URL, if known. This is the identifier of the Schema that the profile data
    /// is recorded in. Notably, the last part of the URL path is the version number of the
    /// schema: http\[s\]://server\[:port\]/path/<version>. To learn more about Schema URL see
    /// <https://opentelemetry.io/docs/specs/otel/schemas/#schema-url>
    /// This schema_url applies to all profiles in the "profiles" field.
    #[prost(string, tag = "3")]
    pub schema_url: ::prost::alloc::string::String,
}
/// Represents a complete profile, including sample types, samples, mappings to
/// binaries, stacks, locations, functions, string table, and additional
/// metadata. It modifies and annotates pprof Profile with OpenTelemetry
/// specific fields.
///
/// Note that whilst fields in this message retain the name and field id from pprof in most cases
/// for ease of understanding data migration, it is not intended that pprof:Profile and
/// OpenTelemetry:Profile encoding be wire compatible.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Profile {
    /// The type and unit of all Sample.values in this profile.
    /// For a cpu or off-cpu profile this might be:
    /// \["cpu","nanoseconds"\] or \["off_cpu","nanoseconds"\]
    /// For a heap profile, this might be:
    /// \["allocated_objects","count"\] or \["allocated_space","bytes"\],
    #[prost(message, optional, tag = "1")]
    pub sample_type: ::core::option::Option<ValueType>,
    /// The set of samples recorded in this profile.
    #[prost(message, repeated, tag = "2")]
    pub sample: ::prost::alloc::vec::Vec<Sample>,
    /// Time of collection (UTC) represented as nanoseconds past the epoch.
    #[prost(fixed64, tag = "3")]
    pub time_unix_nano: u64,
    /// Duration of the profile, if a duration makes sense.
    #[prost(uint64, tag = "4")]
    pub duration_nano: u64,
    /// The kind of events between sampled occurrences.
    /// e.g \[ "cpu","cycles" \] or \[ "heap","bytes" \]
    #[prost(message, optional, tag = "5")]
    pub period_type: ::core::option::Option<ValueType>,
    /// The number of events between sampled occurrences.
    #[prost(int64, tag = "6")]
    pub period: i64,
    /// Free-form text associated with the profile. The text is displayed as is
    /// to the user by the tools that read profiles (e.g. by pprof). This field
    /// should not be used to store any machine-readable information, it is only
    /// for human-friendly content. The profile must stay functional if this field
    /// is cleaned.
    ///
    /// Indices into ProfilesDictionary.string_table.
    #[prost(int32, repeated, tag = "7")]
    pub comment_strindices: ::prost::alloc::vec::Vec<i32>,
    /// A globally unique identifier for a profile. The ID is a 16-byte array. An ID with
    /// all zeroes is considered invalid. It may be used for deduplication and signal
    /// correlation purposes. It is acceptable to treat two profiles with different values
    /// in this field as not equal, even if they represented the same object at an earlier
    /// time.
    /// This field is optional; an ID may be assigned to an ID-less profile in a later step.
    #[prost(bytes = "vec", tag = "8")]
    #[cfg_attr(
        feature = "with-serde",
        serde(
            serialize_with = "crate::proto::serializers::serialize_to_hex_string",
            deserialize_with = "crate::proto::serializers::deserialize_from_hex_string"
        )
    )]
    pub profile_id: ::prost::alloc::vec::Vec<u8>,
    /// dropped_attributes_count is the number of attributes that were discarded. Attributes
    /// can be discarded because their keys are too long or because there are too many
    /// attributes. If this value is 0, then no attributes were dropped.
    #[prost(uint32, tag = "9")]
    pub dropped_attributes_count: u32,
    /// Specifies format of the original payload. Common values are defined in semantic conventions. \[required if original_payload is present\]
    #[prost(string, tag = "10")]
    pub original_payload_format: ::prost::alloc::string::String,
    /// Original payload can be stored in this field. This can be useful for users who want to get the original payload.
    /// Formats such as JFR are highly extensible and can contain more information than what is defined in this spec.
    /// Inclusion of original payload should be configurable by the user. Default behavior should be to not include the original payload.
    /// If the original payload is in pprof format, it SHOULD not be included in this field.
    /// The field is optional, however if it is present then equivalent converted data should be populated in other fields
    /// of this message as far as is practicable.
    #[prost(bytes = "vec", tag = "11")]
    pub original_payload: ::prost::alloc::vec::Vec<u8>,
    /// References to attributes in attribute_table. \[optional\]
    #[prost(int32, repeated, tag = "12")]
    pub attribute_indices: ::prost::alloc::vec::Vec<i32>,
}
/// A pointer from a profile Sample to a trace Span.
/// Connects a profile sample to a trace span, identified by unique trace and span IDs.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Link {
    /// A unique identifier of a trace that this linked span is part of. The ID is a
    /// 16-byte array.
    #[prost(bytes = "vec", tag = "1")]
    pub trace_id: ::prost::alloc::vec::Vec<u8>,
    /// A unique identifier for the linked span. The ID is an 8-byte array.
    #[prost(bytes = "vec", tag = "2")]
    pub span_id: ::prost::alloc::vec::Vec<u8>,
}
/// ValueType describes the type and units of a value, with an optional aggregation temporality.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ValueType {
    /// Index into ProfilesDictionary.string_table.
    #[prost(int32, tag = "1")]
    pub type_strindex: i32,
    /// Index into ProfilesDictionary.string_table.
    #[prost(int32, tag = "2")]
    pub unit_strindex: i32,
    #[prost(enumeration = "AggregationTemporality", tag = "3")]
    pub aggregation_temporality: i32,
}
/// Each Sample records values encountered in some program context. The program
/// context is typically a stack trace, perhaps augmented with auxiliary
/// information like the thread-id, some indicator of a higher level request
/// being handled etc.
///
/// A Sample MUST have have at least one values or timestamps_unix_nano entry. If
/// both fields are populated, they MUST contain the same number of elements, and
/// the elements at the same index MUST refer to the same event.
///
/// Examples of different ways of representing a sample with the total value of 10:
///
/// Report of a stacktrace at 10 timestamps (consumers must assume the value is 1 for each point):
/// values: \[\]
/// timestamps_unix_nano: \[1, 2, 3, 4, 5, 6, 7, 8, 9, 10\]
///
/// Report of a stacktrace with an aggregated value without timestamps:
/// values: \[10\]
/// timestamps_unix_nano: \[\]
///
/// Report of a stacktrace at 4 timestamps where each point records a specific value:
/// values: \[2, 2, 3, 3\]
/// timestamps_unix_nano: \[1, 2, 3, 4\]
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Sample {
    /// Reference to stack in ProfilesDictionary.stack_table.
    #[prost(int32, tag = "1")]
    pub stack_index: i32,
    /// The type and unit of each value is defined by Profile.sample_type.
    #[prost(int64, repeated, tag = "2")]
    pub values: ::prost::alloc::vec::Vec<i64>,
    /// References to attributes in ProfilesDictionary.attribute_table. \[optional\]
    #[prost(int32, repeated, tag = "3")]
    pub attribute_indices: ::prost::alloc::vec::Vec<i32>,
    /// Reference to link in ProfilesDictionary.link_table. \[optional\]
    /// It can be unset / set to 0 if no link exists, as link_table\[0\] is always a 'null' default value.
    #[prost(int32, tag = "4")]
    pub link_index: i32,
    /// Timestamps associated with Sample represented in nanoseconds. These
    /// timestamps should fall within the Profile's time range.
    #[prost(fixed64, repeated, tag = "5")]
    #[cfg_attr(
        feature = "with-serde",
        serde(
            serialize_with = "crate::proto::serializers::serialize_vec_u64_to_string",
            deserialize_with = "crate::proto::serializers::deserialize_vec_string_to_vec_u64"
        )
    )]
    pub timestamps_unix_nano: ::prost::alloc::vec::Vec<u64>,
}
/// Describes the mapping of a binary in memory, including its address range,
/// file offset, and metadata like build ID
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Mapping {
    /// Address at which the binary (or DLL) is loaded into memory.
    #[prost(uint64, tag = "1")]
    pub memory_start: u64,
    /// The limit of the address range occupied by this mapping.
    #[prost(uint64, tag = "2")]
    pub memory_limit: u64,
    /// Offset in the binary that corresponds to the first mapped address.
    #[prost(uint64, tag = "3")]
    pub file_offset: u64,
    /// The object this entry is loaded from.  This can be a filename on
    /// disk for the main binary and shared libraries, or virtual
    /// abstractions like "\[vdso\]".
    ///
    /// Index into ProfilesDictionary.string_table.
    #[prost(int32, tag = "4")]
    pub filename_strindex: i32,
    /// References to attributes in ProfilesDictionary.attribute_table. \[optional\]
    #[prost(int32, repeated, tag = "5")]
    pub attribute_indices: ::prost::alloc::vec::Vec<i32>,
}
/// A Stack represents a stack trace as a list of locations.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Stack {
    /// References to locations in ProfilesDictionary.location_table.
    /// The first location is the leaf frame.
    #[prost(int32, repeated, tag = "1")]
    pub location_indices: ::prost::alloc::vec::Vec<i32>,
}
/// Describes function and line table debug information.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Location {
    /// Reference to mapping in ProfilesDictionary.mapping_table.
    /// It can be unset / set to 0 if the mapping is unknown or not applicable for
    /// this profile type, as mapping_table\[0\] is always a 'null' default mapping.
    #[prost(int32, tag = "1")]
    pub mapping_index: i32,
    /// The instruction address for this location, if available.  It
    /// should be within \[Mapping.memory_start...Mapping.memory_limit\]
    /// for the corresponding mapping. A non-leaf address may be in the
    /// middle of a call instruction. It is up to display tools to find
    /// the beginning of the instruction if necessary.
    #[prost(uint64, tag = "2")]
    pub address: u64,
    /// Multiple line indicates this location has inlined functions,
    /// where the last entry represents the caller into which the
    /// preceding entries were inlined.
    ///
    /// E.g., if memcpy() is inlined into printf:
    /// line\[0\].function_name == "memcpy"
    /// line\[1\].function_name == "printf"
    #[prost(message, repeated, tag = "3")]
    pub line: ::prost::alloc::vec::Vec<Line>,
    /// References to attributes in ProfilesDictionary.attribute_table. \[optional\]
    #[prost(int32, repeated, tag = "4")]
    pub attribute_indices: ::prost::alloc::vec::Vec<i32>,
}
/// Details a specific line in a source code, linked to a function.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Line {
    /// Reference to function in ProfilesDictionary.function_table.
    #[prost(int32, tag = "1")]
    pub function_index: i32,
    /// Line number in source code. 0 means unset.
    #[prost(int64, tag = "2")]
    pub line: i64,
    /// Column number in source code. 0 means unset.
    #[prost(int64, tag = "3")]
    pub column: i64,
}
/// Describes a function, including its human-readable name, system name,
/// source file, and starting line number in the source.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[cfg_attr(feature = "with-serde", serde(default))]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Function {
    /// Function name. Empty string if not available.
    #[prost(int32, tag = "1")]
    pub name_strindex: i32,
    /// Function name, as identified by the system. For instance,
    /// it can be a C++ mangled name. Empty string if not available.
    #[prost(int32, tag = "2")]
    pub system_name_strindex: i32,
    /// Source file containing the function. Empty string if not available.
    #[prost(int32, tag = "3")]
    pub filename_strindex: i32,
    /// Line number in source file. 0 means unset.
    #[prost(int64, tag = "4")]
    pub start_line: i64,
}
/// A custom 'dictionary native' style of encoding attributes which is more convenient
/// for profiles than opentelemetry.proto.common.v1.KeyValue
/// Specifically, uses the string table for keys and allows optional unit information.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct KeyValueAndUnit {
    #[prost(int32, tag = "1")]
    pub key_strindex: i32,
    #[prost(message, optional, tag = "2")]
    pub value: ::core::option::Option<super::super::common::v1::AnyValue>,
    /// zero indicates implicit (by semconv) or non-defined unit.
    #[prost(int32, tag = "3")]
    pub unit_strindex: i32,
}
/// Specifies the method of aggregating metric values, either DELTA (change since last report)
/// or CUMULATIVE (total since a fixed start time).
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum AggregationTemporality {
    /// UNSPECIFIED is the default AggregationTemporality, it MUST not be used.
    Unspecified = 0,
    /// * DELTA is an AggregationTemporality for a profiler which reports
    ///   changes since last report time. Successive metrics contain aggregation of
    ///   values from continuous and non-overlapping intervals.
    ///
    /// The values for a DELTA metric are based only on the time interval
    /// associated with one measurement cycle. There is no dependency on
    /// previous measurements like is the case for CUMULATIVE metrics.
    ///
    /// For example, consider a system measuring the number of requests that
    /// it receives and reports the sum of these requests every second as a
    /// DELTA metric:
    ///
    /// 1. The system starts receiving at time=t_0.
    /// 1. A request is received, the system measures 1 request.
    /// 1. A request is received, the system measures 1 request.
    /// 1. A request is received, the system measures 1 request.
    /// 1. The 1 second collection cycle ends. A metric is exported for the
    ///    number of requests received over the interval of time t_0 to
    ///    t_0+1 with a value of 3.
    /// 1. A request is received, the system measures 1 request.
    /// 1. A request is received, the system measures 1 request.
    /// 1. The 1 second collection cycle ends. A metric is exported for the
    ///    number of requests received over the interval of time t_0+1 to
    ///    t_0+2 with a value of 2.
    Delta = 1,
    /// * CUMULATIVE is an AggregationTemporality for a profiler which
    ///   reports changes since a fixed start time. This means that current values
    ///   of a CUMULATIVE metric depend on all previous measurements since the
    ///   start time. Because of this, the sender is required to retain this state
    ///   in some form. If this state is lost or invalidated, the CUMULATIVE metric
    ///   values MUST be reset and a new fixed start time following the last
    ///   reported measurement time sent MUST be used.
    ///
    /// For example, consider a system measuring the number of requests that
    /// it receives and reports the sum of these requests every second as a
    /// CUMULATIVE metric:
    ///
    /// 1. The system starts receiving at time=t_0.
    /// 1. A request is received, the system measures 1 request.
    /// 1. A request is received, the system measures 1 request.
    /// 1. A request is received, the system measures 1 request.
    /// 1. The 1 second collection cycle ends. A metric is exported for the
    ///    number of requests received over the interval of time t_0 to
    ///    t_0+1 with a value of 3.
    /// 1. A request is received, the system measures 1 request.
    /// 1. A request is received, the system measures 1 request.
    /// 1. The 1 second collection cycle ends. A metric is exported for the
    ///    number of requests received over the interval of time t_0 to
    ///    t_0+2 with a value of 5.
    /// 1. The system experiences a fault and loses state.
    /// 1. The system recovers and resumes receiving at time=t_1.
    /// 1. A request is received, the system measures 1 request.
    /// 1. The 1 second collection cycle ends. A metric is exported for the
    ///    number of requests received over the interval of time t_1 to
    ///    t_1+1 with a value of 1.
    ///
    /// Note: Even though, when reporting changes since last report time, using
    /// CUMULATIVE is valid, it is not recommended.
    Cumulative = 2,
}
impl AggregationTemporality {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "AGGREGATION_TEMPORALITY_UNSPECIFIED",
            Self::Delta => "AGGREGATION_TEMPORALITY_DELTA",
            Self::Cumulative => "AGGREGATION_TEMPORALITY_CUMULATIVE",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "AGGREGATION_TEMPORALITY_UNSPECIFIED" => Some(Self::Unspecified),
            "AGGREGATION_TEMPORALITY_DELTA" => Some(Self::Delta),
            "AGGREGATION_TEMPORALITY_CUMULATIVE" => Some(Self::Cumulative),
            _ => None,
        }
    }
}
