# Bollard Release Process

This document outlines the steps for releasing a new version of Bollard. Follow these instructions carefully to ensure a smooth release process.

## 1. Update and Publish Protobuf-Generated Files

### Steps for `bollard-buildkit-proto`

1. Navigate to `./codegen/proto`.
2. Check for transient dependency updates between `bollard` and `bollard-buildkit-proto` (e.g., `tonic`).
3. Run the following commands to fetch and generate the latest protobuf files:
   ```sh
   cargo run --bin fetch --features fetch
   cargo run --bin gen --features build
   ```
4. Verify that the build succeeds:
   - In the project root, attempt a build with the `buildkit` feature enabled.
   - Temporarily add a path dependency in `Cargo.toml` and update related transient dependencies to test the changes.
   - **Important:** Revert any path dependency and ensure version alignment in `Cargo.toml` before submitting a pull request.
5. Merge the pull request and reset the `master` branch.
6. Package and publish the crate:
   ```sh
   cargo package
   cargo publish
   ```
7. Create a PR and merge the changes.

## 2. Update and Publish Swagger-Generated Files

### Steps for `bollard-swagger`

1. Navigate to `./codegen/swagger`.
2. Check for transient dependency updates between `bollard` and `bollard-buildkit-proto` (e.g., `chrono`).
3. Identify the latest released API version:
   - Check the latest release tag on the [Moby GitHub repository](https://github.com/moby/moby/releases/).
   - Locate the most recent API documentation in `./docs/api`.
   - Copy the raw download URL and update `./codegen/swagger/pom.xml` accordingly.
4. Update the `packageVersion` field:
   - The first two numbers represent the Moby API version.
   - The third number corresponds to Bollard's internal codegen version.
   - The digits following `rc` match the Moby release tag.
   - Format: `[API-major].[API-minor].[bollard-codegen-version]-rc.[moby-tag-major][moby-tag-minor].[moby-tag-patch]`.
5. Modify `Cargo.mustache` to reference the new `bollard-buildkit-proto` version.
6. Generate the new Swagger bindings:
   ```sh
   mvn -D org.slf4j.simpleLogger.defaultLogLevel=warn clean compiler:compile generate-resources
   ```
7. Validate the build:
   - Run a build in the root directory.
   - Temporarily add a path dependency in `Cargo.toml` to verify correctness.
8. Merge the pull request and reset the `master` branch.
9. Package and publish the crate:
   ```sh
   cargo package
   cargo publish
   ```
10. Create a PR and merge the changes.

## 3. Update Bollard Crate and Documentation

1. Update `Cargo.toml`:
   - Modify dependencies to point to the latest versions of `bollard-buildkit-proto` and `bollard-stubs`.
2. Update `lib.rs` and `docker.rs` to match the new API version if changes were made in the Swagger release.
3. Modify `lib.rs` with any relevant documentation updates.
4. Regenerate the README:
   ```sh
   cargo readme --no-title > README.md
   ```

## 4. Publish the New Release

1. Bump the crate version as necessary.
2. Package and publish the release:
   ```sh
   cargo package
   cargo publish
   ```
3. Create a GitHub Release tag (this should be autogenerated).

Following these steps ensures consistency and reliability when publishing new versions of Bollard. If any issues arise, review the steps carefully or consult the project maintainers for guidance.


