// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// ignore_for_file: annotate_overrides
// ignore_for_file: unused_element
// ignore_for_file: unused_field

/// Class that represents some common Dart types.
///
/// NOTE: this code has been generated automatically.
///
class DartType {
  final String name;
  final bool isNullable;
  const DartType._withName(this.name, this.isNullable);
  factory DartType.fromDartConfig({
    bool enableFp = false,
    bool disableNesting = false,
  }) {
    if (enableFp && !disableNesting) {
      return DartType();
    } else if (!enableFp && !disableNesting) {
      return DartTypeNoFp();
    } else if (enableFp && disableNesting) {
      return DartTypeFlatTp();
    } else {
      return DartTypeNoFpFlatTp();
    }
  }
  const DartType() : name = "!", isNullable = false;

  String get dartName {
    return name + (isNullable ? "?" : "");
  }

  String toString() {
    return "DartType($dartName)";
  }

  static bool isListType(DartType tp) {
    return DartType._listTypes.contains(tp.toNonNullable());
  }

  static bool isSetType(DartType tp) {
    return DartType._setTypes.contains(tp.toNonNullable());
  }

  static bool isMapType(DartType tp) {
    return DartType._mapTypes.contains(tp.toNonNullable());
  }

  static bool isCollectionType(DartType tp) {
    return DartType._collectionTypes.contains(tp.toNonNullable());
  }

  static bool isGrowableType(DartType tp) {
    return DartType._growableTypes.contains(tp.toNonNullable());
  }

  static bool isComplexType(DartType tp) {
    return DartType._complexTypes.contains(tp.toNonNullable());
  }

  DartType toNullable() {
    if (isNullable) {
      return this;
    }
    for (var tp in _allTypes) {
      if (tp.isNullable && tp.name == name) return tp;
    }
    throw 'Fail toNullable $name $isNullable';
  }

  DartType toNonNullable() {
    if (!isNullable) {
      return this;
    }
    for (var tp in _allTypes) {
      if (!tp.isNullable && tp.name == name) return tp;
    }
    throw 'Fail toNonNullable $name $isNullable';
  }

  bool isInterfaceOfType(DartType tp, DartType iTp) {
    tp = tp.toNonNullable();
    iTp = iTp.toNonNullable();
    return _interfaceRels.containsKey(iTp) && _interfaceRels[iTp]!.contains(tp);
  }

  Set<DartType> get mapTypes {
    return _mapTypes;
  }

  bool isSpecializable(DartType tp) {
    return _interfaceRels.containsKey(tp.toNonNullable());
  }

  Set<DartType> interfaces(DartType tp) {
    tp = tp.toNonNullable();
    if (_interfaceRels.containsKey(tp)) {
      return _interfaceRels[tp]!;
    }
    throw "NotFound";
  }

  DartType indexType(DartType tp) {
    tp = tp.toNonNullable();
    if (_indexedBy.containsKey(tp)) {
      return _indexedBy[tp]!;
    }
    throw "NotFound";
  }

  Set<DartType> indexableElementTypes(DartType tp) {
    if (_indexableElementOf.containsKey(tp)) {
      return _indexableElementOf[tp]!;
    }
    throw "NotFound";
  }

  bool isIndexableElementType(DartType tp) {
    return _indexableElementOf.containsKey(tp);
  }

  DartType elementType(DartType tp) {
    tp = tp.toNonNullable();
    if (_subscriptsTo.containsKey(tp)) {
      return _subscriptsTo[tp]!;
    }
    throw "NotFound";
  }

  Set<DartType> get iterableTypes1 {
    return _iterableTypes1;
  }

  Set<String> uniOps(DartType tp) {
    if (_uniOps.containsKey(tp)) {
      return _uniOps[tp]!;
    }
    return <String>{};
  }

  Set<String> binOps(DartType tp) {
    if (_binOps.containsKey(tp)) {
      return _binOps[tp]!.keys.toSet();
    }
    return <String>{};
  }

  Set<List<DartType>> binOpParameters(DartType tp, String op) {
    if (_binOps.containsKey(tp) && _binOps[tp]!.containsKey(op)) {
      return _binOps[tp]![op]!;
    }
    throw "NotFound";
  }

  Set<String> assignOps(DartType tp) {
    if (_assignOps.containsKey(tp)) {
      return _assignOps[tp]!.keys.toSet();
    }
    return <String>{};
  }

  Set<DartType> assignOpRhs(DartType tp, String op) {
    if (_assignOps.containsKey(tp) && _assignOps[tp]!.containsKey(op)) {
      return _assignOps[tp]![op]!;
    }
    return <DartType>{};
  }

  bool hasConstructor(DartType tp) {
    tp = tp.toNonNullable();
    return _constructors.containsKey(tp);
  }

  Set<String> constructors(DartType tp) {
    tp = tp.toNonNullable();
    if (_constructors.containsKey(tp)) {
      return _constructors[tp]!.keys.toSet();
    }
    return <String>{};
  }

  List<DartType> constructorParameters(DartType tp, String constructor) {
    tp = tp.toNonNullable();
    if (_constructors.containsKey(tp) &&
        _constructors[tp]!.containsKey(constructor)) {
      return _constructors[tp]![constructor]!;
    }
    throw "NotFound";
  }

  Set<DartType> get allTypes {
    return _allTypes;
  }

  static const VOID = DartType._withName('void', false);
  static const VOID_NULLABLE = VOID;
  static const ENDIAN = DartType._withName('Endian', false);
  static const ENDIAN_NULLABLE = DartType._withName('Endian', true);
  static const BYTEDATA = DartType._withName('ByteData', false);
  static const BYTEDATA_NULLABLE = DartType._withName('ByteData', true);
  static const INT8LIST = DartType._withName('Int8List', false);
  static const INT8LIST_NULLABLE = DartType._withName('Int8List', true);
  static const UINT8LIST = DartType._withName('Uint8List', false);
  static const UINT8LIST_NULLABLE = DartType._withName('Uint8List', true);
  static const UINT8CLAMPEDLIST = DartType._withName('Uint8ClampedList', false);
  static const UINT8CLAMPEDLIST_NULLABLE = DartType._withName(
    'Uint8ClampedList',
    true,
  );
  static const INT16LIST = DartType._withName('Int16List', false);
  static const INT16LIST_NULLABLE = DartType._withName('Int16List', true);
  static const UINT16LIST = DartType._withName('Uint16List', false);
  static const UINT16LIST_NULLABLE = DartType._withName('Uint16List', true);
  static const INT32LIST = DartType._withName('Int32List', false);
  static const INT32LIST_NULLABLE = DartType._withName('Int32List', true);
  static const UINT32LIST = DartType._withName('Uint32List', false);
  static const UINT32LIST_NULLABLE = DartType._withName('Uint32List', true);
  static const INT64LIST = DartType._withName('Int64List', false);
  static const INT64LIST_NULLABLE = DartType._withName('Int64List', true);
  static const UINT64LIST = DartType._withName('Uint64List', false);
  static const UINT64LIST_NULLABLE = DartType._withName('Uint64List', true);
  static const FLOAT32LIST = DartType._withName('Float32List', false);
  static const FLOAT32LIST_NULLABLE = DartType._withName('Float32List', true);
  static const FLOAT64LIST = DartType._withName('Float64List', false);
  static const FLOAT64LIST_NULLABLE = DartType._withName('Float64List', true);
  static const FLOAT32X4LIST = DartType._withName('Float32x4List', false);
  static const FLOAT32X4LIST_NULLABLE = DartType._withName(
    'Float32x4List',
    true,
  );
  static const INT32X4LIST = DartType._withName('Int32x4List', false);
  static const INT32X4LIST_NULLABLE = DartType._withName('Int32x4List', true);
  static const FLOAT64X2LIST = DartType._withName('Float64x2List', false);
  static const FLOAT64X2LIST_NULLABLE = DartType._withName(
    'Float64x2List',
    true,
  );
  static const FLOAT32X4 = DartType._withName('Float32x4', false);
  static const FLOAT32X4_NULLABLE = DartType._withName('Float32x4', true);
  static const INT32X4 = DartType._withName('Int32x4', false);
  static const INT32X4_NULLABLE = DartType._withName('Int32x4', true);
  static const FLOAT64X2 = DartType._withName('Float64x2', false);
  static const FLOAT64X2_NULLABLE = DartType._withName('Float64x2', true);
  static const DEPRECATED = DartType._withName('Deprecated', false);
  static const DEPRECATED_NULLABLE = DartType._withName('Deprecated', true);
  static const BOOL = DartType._withName('bool', false);
  static const BOOL_NULLABLE = DartType._withName('bool', true);
  static const DOUBLE = DartType._withName('double', false);
  static const DOUBLE_NULLABLE = DartType._withName('double', true);
  static const DURATION = DartType._withName('Duration', false);
  static const DURATION_NULLABLE = DartType._withName('Duration', true);
  static const ERROR = DartType._withName('Error', false);
  static const ERROR_NULLABLE = DartType._withName('Error', true);
  static const ASSERTIONERROR = DartType._withName('AssertionError', false);
  static const ASSERTIONERROR_NULLABLE = DartType._withName(
    'AssertionError',
    true,
  );
  static const TYPEERROR = DartType._withName('TypeError', false);
  static const TYPEERROR_NULLABLE = DartType._withName('TypeError', true);
  static const ARGUMENTERROR = DartType._withName('ArgumentError', false);
  static const ARGUMENTERROR_NULLABLE = DartType._withName(
    'ArgumentError',
    true,
  );
  static const RANGEERROR = DartType._withName('RangeError', false);
  static const RANGEERROR_NULLABLE = DartType._withName('RangeError', true);
  static const INDEXERROR = DartType._withName('IndexError', false);
  static const INDEXERROR_NULLABLE = DartType._withName('IndexError', true);
  static const UNSUPPORTEDERROR = DartType._withName('UnsupportedError', false);
  static const UNSUPPORTEDERROR_NULLABLE = DartType._withName(
    'UnsupportedError',
    true,
  );
  static const UNIMPLEMENTEDERROR = DartType._withName(
    'UnimplementedError',
    false,
  );
  static const UNIMPLEMENTEDERROR_NULLABLE = DartType._withName(
    'UnimplementedError',
    true,
  );
  static const STATEERROR = DartType._withName('StateError', false);
  static const STATEERROR_NULLABLE = DartType._withName('StateError', true);
  static const CONCURRENTMODIFICATIONERROR = DartType._withName(
    'ConcurrentModificationError',
    false,
  );
  static const CONCURRENTMODIFICATIONERROR_NULLABLE = DartType._withName(
    'ConcurrentModificationError',
    true,
  );
  static const STACKOVERFLOWERROR = DartType._withName(
    'StackOverflowError',
    false,
  );
  static const STACKOVERFLOWERROR_NULLABLE = DartType._withName(
    'StackOverflowError',
    true,
  );
  static const EXCEPTION = DartType._withName('Exception', false);
  static const EXCEPTION_NULLABLE = DartType._withName('Exception', true);
  static const FORMATEXCEPTION = DartType._withName('FormatException', false);
  static const FORMATEXCEPTION_NULLABLE = DartType._withName(
    'FormatException',
    true,
  );
  static const INTEGERDIVISIONBYZEROEXCEPTION = DartType._withName(
    'IntegerDivisionByZeroException',
    false,
  );
  static const INTEGERDIVISIONBYZEROEXCEPTION_NULLABLE = DartType._withName(
    'IntegerDivisionByZeroException',
    true,
  );
  static const INT = DartType._withName('int', false);
  static const INT_NULLABLE = DartType._withName('int', true);
  static const NULL = DartType._withName('Null', false);
  static const NULL_NULLABLE = DartType._withName('Null', true);
  static const NUM = DartType._withName('num', false);
  static const NUM_NULLABLE = DartType._withName('num', true);
  static const REGEXP = DartType._withName('RegExp', false);
  static const REGEXP_NULLABLE = DartType._withName('RegExp', true);
  static const STRING = DartType._withName('String', false);
  static const STRING_NULLABLE = DartType._withName('String', true);
  static const RUNES = DartType._withName('Runes', false);
  static const RUNES_NULLABLE = DartType._withName('Runes', true);
  static const RUNEITERATOR = DartType._withName('RuneIterator', false);
  static const RUNEITERATOR_NULLABLE = DartType._withName('RuneIterator', true);
  static const STRINGBUFFER = DartType._withName('StringBuffer', false);
  static const STRINGBUFFER_NULLABLE = DartType._withName('StringBuffer', true);
  static const SYMBOL = DartType._withName('Symbol', false);
  static const SYMBOL_NULLABLE = DartType._withName('Symbol', true);
  static const LIST_BOOL = DartType._withName('List<bool>', false);
  static const LIST_BOOL_NULLABLE = DartType._withName('List<bool>', true);
  static const LIST_DOUBLE = DartType._withName('List<double>', false);
  static const LIST_DOUBLE_NULLABLE = DartType._withName('List<double>', true);
  static const LIST_INT = DartType._withName('List<int>', false);
  static const LIST_INT_NULLABLE = DartType._withName('List<int>', true);
  static const LIST_STRING = DartType._withName('List<String>', false);
  static const LIST_STRING_NULLABLE = DartType._withName('List<String>', true);
  static const SET_BOOL = DartType._withName('Set<bool>', false);
  static const SET_BOOL_NULLABLE = DartType._withName('Set<bool>', true);
  static const SET_DOUBLE = DartType._withName('Set<double>', false);
  static const SET_DOUBLE_NULLABLE = DartType._withName('Set<double>', true);
  static const SET_INT = DartType._withName('Set<int>', false);
  static const SET_INT_NULLABLE = DartType._withName('Set<int>', true);
  static const SET_STRING = DartType._withName('Set<String>', false);
  static const SET_STRING_NULLABLE = DartType._withName('Set<String>', true);
  static const EXPANDO_BOOL = DartType._withName('Expando<bool>', false);
  static const EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Expando<bool>',
    true,
  );
  static const EXPANDO_DOUBLE = DartType._withName('Expando<double>', false);
  static const EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Expando<double>',
    true,
  );
  static const EXPANDO_INT = DartType._withName('Expando<int>', false);
  static const EXPANDO_INT_NULLABLE = DartType._withName('Expando<int>', true);
  static const EXPANDO_STRING = DartType._withName('Expando<String>', false);
  static const EXPANDO_STRING_NULLABLE = DartType._withName(
    'Expando<String>',
    true,
  );
  static const WEAKREFERENCE_BOOL = DartType._withName(
    'WeakReference<bool>',
    false,
  );
  static const WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'WeakReference<bool>',
    true,
  );
  static const WEAKREFERENCE_DOUBLE = DartType._withName(
    'WeakReference<double>',
    false,
  );
  static const WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<double>',
    true,
  );
  static const WEAKREFERENCE_INT = DartType._withName(
    'WeakReference<int>',
    false,
  );
  static const WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'WeakReference<int>',
    true,
  );
  static const WEAKREFERENCE_STRING = DartType._withName(
    'WeakReference<String>',
    false,
  );
  static const WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'WeakReference<String>',
    true,
  );
  static const MAP_BOOL_BOOL = DartType._withName('Map<bool, bool>', false);
  static const MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<bool, bool>',
    true,
  );
  static const MAP_BOOL_DOUBLE = DartType._withName('Map<bool, double>', false);
  static const MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, double>',
    true,
  );
  static const MAP_BOOL_INT = DartType._withName('Map<bool, int>', false);
  static const MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<bool, int>',
    true,
  );
  static const MAP_BOOL_STRING = DartType._withName('Map<bool, String>', false);
  static const MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<bool, String>',
    true,
  );
  static const MAP_DOUBLE_BOOL = DartType._withName('Map<double, bool>', false);
  static const MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<double, bool>',
    true,
  );
  static const MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<double, double>',
    false,
  );
  static const MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, double>',
    true,
  );
  static const MAP_DOUBLE_INT = DartType._withName('Map<double, int>', false);
  static const MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<double, int>',
    true,
  );
  static const MAP_DOUBLE_STRING = DartType._withName(
    'Map<double, String>',
    false,
  );
  static const MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<double, String>',
    true,
  );
  static const MAP_INT_BOOL = DartType._withName('Map<int, bool>', false);
  static const MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<int, bool>',
    true,
  );
  static const MAP_INT_DOUBLE = DartType._withName('Map<int, double>', false);
  static const MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, double>',
    true,
  );
  static const MAP_INT_INT = DartType._withName('Map<int, int>', false);
  static const MAP_INT_INT_NULLABLE = DartType._withName('Map<int, int>', true);
  static const MAP_INT_STRING = DartType._withName('Map<int, String>', false);
  static const MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<int, String>',
    true,
  );
  static const MAP_STRING_BOOL = DartType._withName('Map<String, bool>', false);
  static const MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<String, bool>',
    true,
  );
  static const MAP_STRING_DOUBLE = DartType._withName(
    'Map<String, double>',
    false,
  );
  static const MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, double>',
    true,
  );
  static const MAP_STRING_INT = DartType._withName('Map<String, int>', false);
  static const MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<String, int>',
    true,
  );
  static const MAP_STRING_STRING = DartType._withName(
    'Map<String, String>',
    false,
  );
  static const MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<String, String>',
    true,
  );
  static const MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<bool, bool>',
    false,
  );
  static const MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, bool>',
    true,
  );
  static const MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<bool, double>',
    false,
  );
  static const MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, double>',
    true,
  );
  static const MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<bool, int>',
    false,
  );
  static const MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, int>',
    true,
  );
  static const MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<bool, String>',
    false,
  );
  static const MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, String>',
    true,
  );
  static const MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<double, bool>',
    false,
  );
  static const MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<double, bool>',
    true,
  );
  static const MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<double, double>',
    false,
  );
  static const MAPENTRY_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<double, double>',
    true,
  );
  static const MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<double, int>',
    false,
  );
  static const MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<double, int>',
    true,
  );
  static const MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<double, String>',
    false,
  );
  static const MAPENTRY_DOUBLE_STRING_NULLABLE = DartType._withName(
    'MapEntry<double, String>',
    true,
  );
  static const MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<int, bool>',
    false,
  );
  static const MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, bool>',
    true,
  );
  static const MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<int, double>',
    false,
  );
  static const MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, double>',
    true,
  );
  static const MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<int, int>',
    false,
  );
  static const MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<int, int>',
    true,
  );
  static const MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<int, String>',
    false,
  );
  static const MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<int, String>',
    true,
  );
  static const MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<String, bool>',
    false,
  );
  static const MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, bool>',
    true,
  );
  static const MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<String, double>',
    false,
  );
  static const MAPENTRY_STRING_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<String, double>',
    true,
  );
  static const MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<String, int>',
    false,
  );
  static const MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<String, int>',
    true,
  );
  static const MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<String, String>',
    false,
  );
  static const MAPENTRY_STRING_STRING_NULLABLE = DartType._withName(
    'MapEntry<String, String>',
    true,
  );
  static const LIST_LIST_BOOL = DartType._withName('List<List<bool>>', false);
  static const LIST_LIST_BOOL_NULLABLE = DartType._withName(
    'List<List<bool>>',
    true,
  );
  static const LIST_LIST_DOUBLE = DartType._withName(
    'List<List<double>>',
    false,
  );
  static const LIST_LIST_DOUBLE_NULLABLE = DartType._withName(
    'List<List<double>>',
    true,
  );
  static const LIST_LIST_INT = DartType._withName('List<List<int>>', false);
  static const LIST_LIST_INT_NULLABLE = DartType._withName(
    'List<List<int>>',
    true,
  );
  static const LIST_LIST_STRING = DartType._withName(
    'List<List<String>>',
    false,
  );
  static const LIST_LIST_STRING_NULLABLE = DartType._withName(
    'List<List<String>>',
    true,
  );
  static const LIST_SET_BOOL = DartType._withName('List<Set<bool>>', false);
  static const LIST_SET_BOOL_NULLABLE = DartType._withName(
    'List<Set<bool>>',
    true,
  );
  static const LIST_SET_INT = DartType._withName('List<Set<int>>', false);
  static const LIST_SET_INT_NULLABLE = DartType._withName(
    'List<Set<int>>',
    true,
  );
  static const LIST_SET_STRING = DartType._withName('List<Set<String>>', false);
  static const LIST_SET_STRING_NULLABLE = DartType._withName(
    'List<Set<String>>',
    true,
  );
  static const LIST_EXPANDO_BOOL = DartType._withName(
    'List<Expando<bool>>',
    false,
  );
  static const LIST_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'List<Expando<bool>>',
    true,
  );
  static const LIST_EXPANDO_DOUBLE = DartType._withName(
    'List<Expando<double>>',
    false,
  );
  static const LIST_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'List<Expando<double>>',
    true,
  );
  static const LIST_EXPANDO_INT = DartType._withName(
    'List<Expando<int>>',
    false,
  );
  static const LIST_EXPANDO_INT_NULLABLE = DartType._withName(
    'List<Expando<int>>',
    true,
  );
  static const LIST_EXPANDO_STRING = DartType._withName(
    'List<Expando<String>>',
    false,
  );
  static const LIST_EXPANDO_STRING_NULLABLE = DartType._withName(
    'List<Expando<String>>',
    true,
  );
  static const LIST_WEAKREFERENCE_BOOL = DartType._withName(
    'List<WeakReference<bool>>',
    false,
  );
  static const LIST_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'List<WeakReference<bool>>',
    true,
  );
  static const LIST_WEAKREFERENCE_DOUBLE = DartType._withName(
    'List<WeakReference<double>>',
    false,
  );
  static const LIST_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'List<WeakReference<double>>',
    true,
  );
  static const LIST_WEAKREFERENCE_STRING = DartType._withName(
    'List<WeakReference<String>>',
    false,
  );
  static const LIST_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'List<WeakReference<String>>',
    true,
  );
  static const LIST_MAP_BOOL_BOOL = DartType._withName(
    'List<Map<bool, bool>>',
    false,
  );
  static const LIST_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'List<Map<bool, bool>>',
    true,
  );
  static const LIST_MAP_BOOL_DOUBLE = DartType._withName(
    'List<Map<bool, double>>',
    false,
  );
  static const LIST_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'List<Map<bool, double>>',
    true,
  );
  static const LIST_MAP_BOOL_INT = DartType._withName(
    'List<Map<bool, int>>',
    false,
  );
  static const LIST_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'List<Map<bool, int>>',
    true,
  );
  static const LIST_MAP_BOOL_STRING = DartType._withName(
    'List<Map<bool, String>>',
    false,
  );
  static const LIST_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'List<Map<bool, String>>',
    true,
  );
  static const LIST_MAP_DOUBLE_BOOL = DartType._withName(
    'List<Map<double, bool>>',
    false,
  );
  static const LIST_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'List<Map<double, bool>>',
    true,
  );
  static const LIST_MAP_DOUBLE_DOUBLE = DartType._withName(
    'List<Map<double, double>>',
    false,
  );
  static const LIST_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'List<Map<double, double>>',
    true,
  );
  static const LIST_MAP_DOUBLE_INT = DartType._withName(
    'List<Map<double, int>>',
    false,
  );
  static const LIST_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'List<Map<double, int>>',
    true,
  );
  static const LIST_MAP_INT_BOOL = DartType._withName(
    'List<Map<int, bool>>',
    false,
  );
  static const LIST_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'List<Map<int, bool>>',
    true,
  );
  static const LIST_MAP_INT_DOUBLE = DartType._withName(
    'List<Map<int, double>>',
    false,
  );
  static const LIST_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'List<Map<int, double>>',
    true,
  );
  static const LIST_MAP_INT_INT = DartType._withName(
    'List<Map<int, int>>',
    false,
  );
  static const LIST_MAP_INT_INT_NULLABLE = DartType._withName(
    'List<Map<int, int>>',
    true,
  );
  static const LIST_MAP_INT_STRING = DartType._withName(
    'List<Map<int, String>>',
    false,
  );
  static const LIST_MAP_INT_STRING_NULLABLE = DartType._withName(
    'List<Map<int, String>>',
    true,
  );
  static const LIST_MAP_STRING_BOOL = DartType._withName(
    'List<Map<String, bool>>',
    false,
  );
  static const LIST_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'List<Map<String, bool>>',
    true,
  );
  static const LIST_MAP_STRING_DOUBLE = DartType._withName(
    'List<Map<String, double>>',
    false,
  );
  static const LIST_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'List<Map<String, double>>',
    true,
  );
  static const LIST_MAP_STRING_INT = DartType._withName(
    'List<Map<String, int>>',
    false,
  );
  static const LIST_MAP_STRING_INT_NULLABLE = DartType._withName(
    'List<Map<String, int>>',
    true,
  );
  static const LIST_MAP_STRING_STRING = DartType._withName(
    'List<Map<String, String>>',
    false,
  );
  static const LIST_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'List<Map<String, String>>',
    true,
  );
  static const LIST_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'List<MapEntry<bool, double>>',
    false,
  );
  static const LIST_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'List<MapEntry<bool, double>>',
    true,
  );
  static const LIST_MAPENTRY_BOOL_INT = DartType._withName(
    'List<MapEntry<bool, int>>',
    false,
  );
  static const LIST_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'List<MapEntry<bool, int>>',
    true,
  );
  static const LIST_MAPENTRY_BOOL_STRING = DartType._withName(
    'List<MapEntry<bool, String>>',
    false,
  );
  static const LIST_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'List<MapEntry<bool, String>>',
    true,
  );
  static const LIST_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'List<MapEntry<double, bool>>',
    false,
  );
  static const LIST_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'List<MapEntry<double, bool>>',
    true,
  );
  static const LIST_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'List<MapEntry<double, double>>',
    false,
  );
  static const LIST_MAPENTRY_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'List<MapEntry<double, double>>',
    true,
  );
  static const LIST_MAPENTRY_DOUBLE_INT = DartType._withName(
    'List<MapEntry<double, int>>',
    false,
  );
  static const LIST_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'List<MapEntry<double, int>>',
    true,
  );
  static const LIST_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'List<MapEntry<double, String>>',
    false,
  );
  static const LIST_MAPENTRY_DOUBLE_STRING_NULLABLE = DartType._withName(
    'List<MapEntry<double, String>>',
    true,
  );
  static const LIST_MAPENTRY_INT_BOOL = DartType._withName(
    'List<MapEntry<int, bool>>',
    false,
  );
  static const LIST_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'List<MapEntry<int, bool>>',
    true,
  );
  static const LIST_MAPENTRY_INT_INT = DartType._withName(
    'List<MapEntry<int, int>>',
    false,
  );
  static const LIST_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'List<MapEntry<int, int>>',
    true,
  );
  static const LIST_MAPENTRY_INT_STRING = DartType._withName(
    'List<MapEntry<int, String>>',
    false,
  );
  static const LIST_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'List<MapEntry<int, String>>',
    true,
  );
  static const LIST_MAPENTRY_STRING_BOOL = DartType._withName(
    'List<MapEntry<String, bool>>',
    false,
  );
  static const LIST_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'List<MapEntry<String, bool>>',
    true,
  );
  static const LIST_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'List<MapEntry<String, double>>',
    false,
  );
  static const LIST_MAPENTRY_STRING_DOUBLE_NULLABLE = DartType._withName(
    'List<MapEntry<String, double>>',
    true,
  );
  static const LIST_MAPENTRY_STRING_INT = DartType._withName(
    'List<MapEntry<String, int>>',
    false,
  );
  static const LIST_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'List<MapEntry<String, int>>',
    true,
  );
  static const LIST_MAPENTRY_STRING_STRING = DartType._withName(
    'List<MapEntry<String, String>>',
    false,
  );
  static const LIST_MAPENTRY_STRING_STRING_NULLABLE = DartType._withName(
    'List<MapEntry<String, String>>',
    true,
  );
  static const SET_LIST_BOOL = DartType._withName('Set<List<bool>>', false);
  static const SET_LIST_BOOL_NULLABLE = DartType._withName(
    'Set<List<bool>>',
    true,
  );
  static const SET_LIST_DOUBLE = DartType._withName('Set<List<double>>', false);
  static const SET_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Set<List<double>>',
    true,
  );
  static const SET_LIST_INT = DartType._withName('Set<List<int>>', false);
  static const SET_LIST_INT_NULLABLE = DartType._withName(
    'Set<List<int>>',
    true,
  );
  static const SET_LIST_STRING = DartType._withName('Set<List<String>>', false);
  static const SET_LIST_STRING_NULLABLE = DartType._withName(
    'Set<List<String>>',
    true,
  );
  static const SET_SET_BOOL = DartType._withName('Set<Set<bool>>', false);
  static const SET_SET_BOOL_NULLABLE = DartType._withName(
    'Set<Set<bool>>',
    true,
  );
  static const SET_SET_DOUBLE = DartType._withName('Set<Set<double>>', false);
  static const SET_SET_DOUBLE_NULLABLE = DartType._withName(
    'Set<Set<double>>',
    true,
  );
  static const SET_SET_INT = DartType._withName('Set<Set<int>>', false);
  static const SET_SET_INT_NULLABLE = DartType._withName('Set<Set<int>>', true);
  static const SET_EXPANDO_BOOL = DartType._withName(
    'Set<Expando<bool>>',
    false,
  );
  static const SET_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Set<Expando<bool>>',
    true,
  );
  static const SET_EXPANDO_DOUBLE = DartType._withName(
    'Set<Expando<double>>',
    false,
  );
  static const SET_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Set<Expando<double>>',
    true,
  );
  static const SET_EXPANDO_INT = DartType._withName('Set<Expando<int>>', false);
  static const SET_EXPANDO_INT_NULLABLE = DartType._withName(
    'Set<Expando<int>>',
    true,
  );
  static const SET_EXPANDO_STRING = DartType._withName(
    'Set<Expando<String>>',
    false,
  );
  static const SET_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Set<Expando<String>>',
    true,
  );
  static const SET_WEAKREFERENCE_BOOL = DartType._withName(
    'Set<WeakReference<bool>>',
    false,
  );
  static const SET_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Set<WeakReference<bool>>',
    true,
  );
  static const SET_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Set<WeakReference<double>>',
    false,
  );
  static const SET_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'Set<WeakReference<double>>',
    true,
  );
  static const SET_WEAKREFERENCE_INT = DartType._withName(
    'Set<WeakReference<int>>',
    false,
  );
  static const SET_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Set<WeakReference<int>>',
    true,
  );
  static const SET_WEAKREFERENCE_STRING = DartType._withName(
    'Set<WeakReference<String>>',
    false,
  );
  static const SET_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'Set<WeakReference<String>>',
    true,
  );
  static const SET_MAP_BOOL_DOUBLE = DartType._withName(
    'Set<Map<bool, double>>',
    false,
  );
  static const SET_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Set<Map<bool, double>>',
    true,
  );
  static const SET_MAP_BOOL_INT = DartType._withName(
    'Set<Map<bool, int>>',
    false,
  );
  static const SET_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Set<Map<bool, int>>',
    true,
  );
  static const SET_MAP_BOOL_STRING = DartType._withName(
    'Set<Map<bool, String>>',
    false,
  );
  static const SET_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Set<Map<bool, String>>',
    true,
  );
  static const SET_MAP_DOUBLE_BOOL = DartType._withName(
    'Set<Map<double, bool>>',
    false,
  );
  static const SET_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Set<Map<double, bool>>',
    true,
  );
  static const SET_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Set<Map<double, double>>',
    false,
  );
  static const SET_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Set<Map<double, double>>',
    true,
  );
  static const SET_MAP_DOUBLE_INT = DartType._withName(
    'Set<Map<double, int>>',
    false,
  );
  static const SET_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Set<Map<double, int>>',
    true,
  );
  static const SET_MAP_DOUBLE_STRING = DartType._withName(
    'Set<Map<double, String>>',
    false,
  );
  static const SET_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Set<Map<double, String>>',
    true,
  );
  static const SET_MAP_INT_BOOL = DartType._withName(
    'Set<Map<int, bool>>',
    false,
  );
  static const SET_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Set<Map<int, bool>>',
    true,
  );
  static const SET_MAP_INT_DOUBLE = DartType._withName(
    'Set<Map<int, double>>',
    false,
  );
  static const SET_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Set<Map<int, double>>',
    true,
  );
  static const SET_MAP_INT_STRING = DartType._withName(
    'Set<Map<int, String>>',
    false,
  );
  static const SET_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Set<Map<int, String>>',
    true,
  );
  static const SET_MAP_STRING_BOOL = DartType._withName(
    'Set<Map<String, bool>>',
    false,
  );
  static const SET_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Set<Map<String, bool>>',
    true,
  );
  static const SET_MAP_STRING_DOUBLE = DartType._withName(
    'Set<Map<String, double>>',
    false,
  );
  static const SET_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Set<Map<String, double>>',
    true,
  );
  static const SET_MAP_STRING_INT = DartType._withName(
    'Set<Map<String, int>>',
    false,
  );
  static const SET_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Set<Map<String, int>>',
    true,
  );
  static const SET_MAP_STRING_STRING = DartType._withName(
    'Set<Map<String, String>>',
    false,
  );
  static const SET_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Set<Map<String, String>>',
    true,
  );
  static const SET_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Set<MapEntry<bool, bool>>',
    false,
  );
  static const SET_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Set<MapEntry<bool, bool>>',
    true,
  );
  static const SET_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Set<MapEntry<bool, double>>',
    false,
  );
  static const SET_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Set<MapEntry<bool, double>>',
    true,
  );
  static const SET_MAPENTRY_BOOL_INT = DartType._withName(
    'Set<MapEntry<bool, int>>',
    false,
  );
  static const SET_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Set<MapEntry<bool, int>>',
    true,
  );
  static const SET_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Set<MapEntry<double, bool>>',
    false,
  );
  static const SET_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Set<MapEntry<double, bool>>',
    true,
  );
  static const SET_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Set<MapEntry<double, double>>',
    false,
  );
  static const SET_MAPENTRY_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Set<MapEntry<double, double>>',
    true,
  );
  static const SET_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Set<MapEntry<double, int>>',
    false,
  );
  static const SET_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Set<MapEntry<double, int>>',
    true,
  );
  static const SET_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Set<MapEntry<double, String>>',
    false,
  );
  static const SET_MAPENTRY_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Set<MapEntry<double, String>>',
    true,
  );
  static const SET_MAPENTRY_INT_BOOL = DartType._withName(
    'Set<MapEntry<int, bool>>',
    false,
  );
  static const SET_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Set<MapEntry<int, bool>>',
    true,
  );
  static const SET_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Set<MapEntry<int, double>>',
    false,
  );
  static const SET_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Set<MapEntry<int, double>>',
    true,
  );
  static const SET_MAPENTRY_INT_INT = DartType._withName(
    'Set<MapEntry<int, int>>',
    false,
  );
  static const SET_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Set<MapEntry<int, int>>',
    true,
  );
  static const SET_MAPENTRY_INT_STRING = DartType._withName(
    'Set<MapEntry<int, String>>',
    false,
  );
  static const SET_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Set<MapEntry<int, String>>',
    true,
  );
  static const SET_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Set<MapEntry<String, double>>',
    false,
  );
  static const SET_MAPENTRY_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Set<MapEntry<String, double>>',
    true,
  );
  static const SET_MAPENTRY_STRING_INT = DartType._withName(
    'Set<MapEntry<String, int>>',
    false,
  );
  static const SET_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Set<MapEntry<String, int>>',
    true,
  );
  static const SET_MAPENTRY_STRING_STRING = DartType._withName(
    'Set<MapEntry<String, String>>',
    false,
  );
  static const SET_MAPENTRY_STRING_STRING_NULLABLE = DartType._withName(
    'Set<MapEntry<String, String>>',
    true,
  );
  static const EXPANDO_LIST_BOOL = DartType._withName(
    'Expando<List<bool>>',
    false,
  );
  static const EXPANDO_LIST_BOOL_NULLABLE = DartType._withName(
    'Expando<List<bool>>',
    true,
  );
  static const EXPANDO_LIST_INT = DartType._withName(
    'Expando<List<int>>',
    false,
  );
  static const EXPANDO_LIST_INT_NULLABLE = DartType._withName(
    'Expando<List<int>>',
    true,
  );
  static const EXPANDO_LIST_STRING = DartType._withName(
    'Expando<List<String>>',
    false,
  );
  static const EXPANDO_LIST_STRING_NULLABLE = DartType._withName(
    'Expando<List<String>>',
    true,
  );
  static const EXPANDO_SET_BOOL = DartType._withName(
    'Expando<Set<bool>>',
    false,
  );
  static const EXPANDO_SET_BOOL_NULLABLE = DartType._withName(
    'Expando<Set<bool>>',
    true,
  );
  static const EXPANDO_SET_DOUBLE = DartType._withName(
    'Expando<Set<double>>',
    false,
  );
  static const EXPANDO_SET_DOUBLE_NULLABLE = DartType._withName(
    'Expando<Set<double>>',
    true,
  );
  static const EXPANDO_SET_INT = DartType._withName('Expando<Set<int>>', false);
  static const EXPANDO_SET_INT_NULLABLE = DartType._withName(
    'Expando<Set<int>>',
    true,
  );
  static const EXPANDO_SET_STRING = DartType._withName(
    'Expando<Set<String>>',
    false,
  );
  static const EXPANDO_SET_STRING_NULLABLE = DartType._withName(
    'Expando<Set<String>>',
    true,
  );
  static const EXPANDO_EXPANDO_BOOL = DartType._withName(
    'Expando<Expando<bool>>',
    false,
  );
  static const EXPANDO_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Expando<Expando<bool>>',
    true,
  );
  static const EXPANDO_EXPANDO_DOUBLE = DartType._withName(
    'Expando<Expando<double>>',
    false,
  );
  static const EXPANDO_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Expando<Expando<double>>',
    true,
  );
  static const EXPANDO_EXPANDO_STRING = DartType._withName(
    'Expando<Expando<String>>',
    false,
  );
  static const EXPANDO_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Expando<Expando<String>>',
    true,
  );
  static const EXPANDO_WEAKREFERENCE_BOOL = DartType._withName(
    'Expando<WeakReference<bool>>',
    false,
  );
  static const EXPANDO_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Expando<WeakReference<bool>>',
    true,
  );
  static const EXPANDO_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Expando<WeakReference<double>>',
    false,
  );
  static const EXPANDO_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'Expando<WeakReference<double>>',
    true,
  );
  static const EXPANDO_WEAKREFERENCE_INT = DartType._withName(
    'Expando<WeakReference<int>>',
    false,
  );
  static const EXPANDO_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Expando<WeakReference<int>>',
    true,
  );
  static const EXPANDO_WEAKREFERENCE_STRING = DartType._withName(
    'Expando<WeakReference<String>>',
    false,
  );
  static const EXPANDO_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'Expando<WeakReference<String>>',
    true,
  );
  static const EXPANDO_MAP_BOOL_BOOL = DartType._withName(
    'Expando<Map<bool, bool>>',
    false,
  );
  static const EXPANDO_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Expando<Map<bool, bool>>',
    true,
  );
  static const EXPANDO_MAP_BOOL_DOUBLE = DartType._withName(
    'Expando<Map<bool, double>>',
    false,
  );
  static const EXPANDO_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Expando<Map<bool, double>>',
    true,
  );
  static const EXPANDO_MAP_BOOL_INT = DartType._withName(
    'Expando<Map<bool, int>>',
    false,
  );
  static const EXPANDO_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Expando<Map<bool, int>>',
    true,
  );
  static const EXPANDO_MAP_DOUBLE_BOOL = DartType._withName(
    'Expando<Map<double, bool>>',
    false,
  );
  static const EXPANDO_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Expando<Map<double, bool>>',
    true,
  );
  static const EXPANDO_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Expando<Map<double, double>>',
    false,
  );
  static const EXPANDO_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Expando<Map<double, double>>',
    true,
  );
  static const EXPANDO_MAP_DOUBLE_INT = DartType._withName(
    'Expando<Map<double, int>>',
    false,
  );
  static const EXPANDO_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Expando<Map<double, int>>',
    true,
  );
  static const EXPANDO_MAP_DOUBLE_STRING = DartType._withName(
    'Expando<Map<double, String>>',
    false,
  );
  static const EXPANDO_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Expando<Map<double, String>>',
    true,
  );
  static const EXPANDO_MAP_INT_BOOL = DartType._withName(
    'Expando<Map<int, bool>>',
    false,
  );
  static const EXPANDO_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Expando<Map<int, bool>>',
    true,
  );
  static const EXPANDO_MAP_INT_DOUBLE = DartType._withName(
    'Expando<Map<int, double>>',
    false,
  );
  static const EXPANDO_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Expando<Map<int, double>>',
    true,
  );
  static const EXPANDO_MAP_INT_INT = DartType._withName(
    'Expando<Map<int, int>>',
    false,
  );
  static const EXPANDO_MAP_INT_INT_NULLABLE = DartType._withName(
    'Expando<Map<int, int>>',
    true,
  );
  static const EXPANDO_MAP_INT_STRING = DartType._withName(
    'Expando<Map<int, String>>',
    false,
  );
  static const EXPANDO_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Expando<Map<int, String>>',
    true,
  );
  static const EXPANDO_MAP_STRING_DOUBLE = DartType._withName(
    'Expando<Map<String, double>>',
    false,
  );
  static const EXPANDO_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Expando<Map<String, double>>',
    true,
  );
  static const EXPANDO_MAP_STRING_INT = DartType._withName(
    'Expando<Map<String, int>>',
    false,
  );
  static const EXPANDO_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Expando<Map<String, int>>',
    true,
  );
  static const EXPANDO_MAP_STRING_STRING = DartType._withName(
    'Expando<Map<String, String>>',
    false,
  );
  static const EXPANDO_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Expando<Map<String, String>>',
    true,
  );
  static const EXPANDO_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Expando<MapEntry<bool, bool>>',
    false,
  );
  static const EXPANDO_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Expando<MapEntry<bool, bool>>',
    true,
  );
  static const EXPANDO_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Expando<MapEntry<bool, double>>',
    false,
  );
  static const EXPANDO_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Expando<MapEntry<bool, double>>',
    true,
  );
  static const EXPANDO_MAPENTRY_BOOL_INT = DartType._withName(
    'Expando<MapEntry<bool, int>>',
    false,
  );
  static const EXPANDO_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Expando<MapEntry<bool, int>>',
    true,
  );
  static const EXPANDO_MAPENTRY_BOOL_STRING = DartType._withName(
    'Expando<MapEntry<bool, String>>',
    false,
  );
  static const EXPANDO_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'Expando<MapEntry<bool, String>>',
    true,
  );
  static const EXPANDO_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Expando<MapEntry<double, bool>>',
    false,
  );
  static const EXPANDO_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Expando<MapEntry<double, bool>>',
    true,
  );
  static const EXPANDO_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Expando<MapEntry<double, int>>',
    false,
  );
  static const EXPANDO_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Expando<MapEntry<double, int>>',
    true,
  );
  static const EXPANDO_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Expando<MapEntry<double, String>>',
    false,
  );
  static const EXPANDO_MAPENTRY_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Expando<MapEntry<double, String>>',
    true,
  );
  static const EXPANDO_MAPENTRY_INT_BOOL = DartType._withName(
    'Expando<MapEntry<int, bool>>',
    false,
  );
  static const EXPANDO_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Expando<MapEntry<int, bool>>',
    true,
  );
  static const EXPANDO_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Expando<MapEntry<int, double>>',
    false,
  );
  static const EXPANDO_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Expando<MapEntry<int, double>>',
    true,
  );
  static const EXPANDO_MAPENTRY_INT_INT = DartType._withName(
    'Expando<MapEntry<int, int>>',
    false,
  );
  static const EXPANDO_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Expando<MapEntry<int, int>>',
    true,
  );
  static const EXPANDO_MAPENTRY_INT_STRING = DartType._withName(
    'Expando<MapEntry<int, String>>',
    false,
  );
  static const EXPANDO_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Expando<MapEntry<int, String>>',
    true,
  );
  static const EXPANDO_MAPENTRY_STRING_BOOL = DartType._withName(
    'Expando<MapEntry<String, bool>>',
    false,
  );
  static const EXPANDO_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'Expando<MapEntry<String, bool>>',
    true,
  );
  static const EXPANDO_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Expando<MapEntry<String, double>>',
    false,
  );
  static const EXPANDO_MAPENTRY_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Expando<MapEntry<String, double>>',
    true,
  );
  static const EXPANDO_MAPENTRY_STRING_STRING = DartType._withName(
    'Expando<MapEntry<String, String>>',
    false,
  );
  static const EXPANDO_MAPENTRY_STRING_STRING_NULLABLE = DartType._withName(
    'Expando<MapEntry<String, String>>',
    true,
  );
  static const WEAKREFERENCE_LIST_BOOL = DartType._withName(
    'WeakReference<List<bool>>',
    false,
  );
  static const WEAKREFERENCE_LIST_BOOL_NULLABLE = DartType._withName(
    'WeakReference<List<bool>>',
    true,
  );
  static const WEAKREFERENCE_LIST_DOUBLE = DartType._withName(
    'WeakReference<List<double>>',
    false,
  );
  static const WEAKREFERENCE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<List<double>>',
    true,
  );
  static const WEAKREFERENCE_LIST_INT = DartType._withName(
    'WeakReference<List<int>>',
    false,
  );
  static const WEAKREFERENCE_LIST_INT_NULLABLE = DartType._withName(
    'WeakReference<List<int>>',
    true,
  );
  static const WEAKREFERENCE_LIST_STRING = DartType._withName(
    'WeakReference<List<String>>',
    false,
  );
  static const WEAKREFERENCE_LIST_STRING_NULLABLE = DartType._withName(
    'WeakReference<List<String>>',
    true,
  );
  static const WEAKREFERENCE_SET_DOUBLE = DartType._withName(
    'WeakReference<Set<double>>',
    false,
  );
  static const WEAKREFERENCE_SET_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<Set<double>>',
    true,
  );
  static const WEAKREFERENCE_SET_INT = DartType._withName(
    'WeakReference<Set<int>>',
    false,
  );
  static const WEAKREFERENCE_SET_INT_NULLABLE = DartType._withName(
    'WeakReference<Set<int>>',
    true,
  );
  static const WEAKREFERENCE_SET_STRING = DartType._withName(
    'WeakReference<Set<String>>',
    false,
  );
  static const WEAKREFERENCE_SET_STRING_NULLABLE = DartType._withName(
    'WeakReference<Set<String>>',
    true,
  );
  static const WEAKREFERENCE_EXPANDO_BOOL = DartType._withName(
    'WeakReference<Expando<bool>>',
    false,
  );
  static const WEAKREFERENCE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'WeakReference<Expando<bool>>',
    true,
  );
  static const WEAKREFERENCE_EXPANDO_DOUBLE = DartType._withName(
    'WeakReference<Expando<double>>',
    false,
  );
  static const WEAKREFERENCE_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<Expando<double>>',
    true,
  );
  static const WEAKREFERENCE_EXPANDO_INT = DartType._withName(
    'WeakReference<Expando<int>>',
    false,
  );
  static const WEAKREFERENCE_EXPANDO_INT_NULLABLE = DartType._withName(
    'WeakReference<Expando<int>>',
    true,
  );
  static const WEAKREFERENCE_EXPANDO_STRING = DartType._withName(
    'WeakReference<Expando<String>>',
    false,
  );
  static const WEAKREFERENCE_EXPANDO_STRING_NULLABLE = DartType._withName(
    'WeakReference<Expando<String>>',
    true,
  );
  static const WEAKREFERENCE_WEAKREFERENCE_BOOL = DartType._withName(
    'WeakReference<WeakReference<bool>>',
    false,
  );
  static const WEAKREFERENCE_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'WeakReference<WeakReference<bool>>',
    true,
  );
  static const WEAKREFERENCE_WEAKREFERENCE_INT = DartType._withName(
    'WeakReference<WeakReference<int>>',
    false,
  );
  static const WEAKREFERENCE_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'WeakReference<WeakReference<int>>',
    true,
  );
  static const WEAKREFERENCE_WEAKREFERENCE_STRING = DartType._withName(
    'WeakReference<WeakReference<String>>',
    false,
  );
  static const WEAKREFERENCE_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'WeakReference<WeakReference<String>>',
    true,
  );
  static const WEAKREFERENCE_MAP_BOOL_BOOL = DartType._withName(
    'WeakReference<Map<bool, bool>>',
    false,
  );
  static const WEAKREFERENCE_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'WeakReference<Map<bool, bool>>',
    true,
  );
  static const WEAKREFERENCE_MAP_BOOL_DOUBLE = DartType._withName(
    'WeakReference<Map<bool, double>>',
    false,
  );
  static const WEAKREFERENCE_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<Map<bool, double>>',
    true,
  );
  static const WEAKREFERENCE_MAP_BOOL_INT = DartType._withName(
    'WeakReference<Map<bool, int>>',
    false,
  );
  static const WEAKREFERENCE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'WeakReference<Map<bool, int>>',
    true,
  );
  static const WEAKREFERENCE_MAP_BOOL_STRING = DartType._withName(
    'WeakReference<Map<bool, String>>',
    false,
  );
  static const WEAKREFERENCE_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'WeakReference<Map<bool, String>>',
    true,
  );
  static const WEAKREFERENCE_MAP_DOUBLE_BOOL = DartType._withName(
    'WeakReference<Map<double, bool>>',
    false,
  );
  static const WEAKREFERENCE_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'WeakReference<Map<double, bool>>',
    true,
  );
  static const WEAKREFERENCE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'WeakReference<Map<double, double>>',
    false,
  );
  static const WEAKREFERENCE_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<Map<double, double>>',
    true,
  );
  static const WEAKREFERENCE_MAP_DOUBLE_STRING = DartType._withName(
    'WeakReference<Map<double, String>>',
    false,
  );
  static const WEAKREFERENCE_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'WeakReference<Map<double, String>>',
    true,
  );
  static const WEAKREFERENCE_MAP_INT_BOOL = DartType._withName(
    'WeakReference<Map<int, bool>>',
    false,
  );
  static const WEAKREFERENCE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'WeakReference<Map<int, bool>>',
    true,
  );
  static const WEAKREFERENCE_MAP_INT_DOUBLE = DartType._withName(
    'WeakReference<Map<int, double>>',
    false,
  );
  static const WEAKREFERENCE_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<Map<int, double>>',
    true,
  );
  static const WEAKREFERENCE_MAP_INT_INT = DartType._withName(
    'WeakReference<Map<int, int>>',
    false,
  );
  static const WEAKREFERENCE_MAP_INT_INT_NULLABLE = DartType._withName(
    'WeakReference<Map<int, int>>',
    true,
  );
  static const WEAKREFERENCE_MAP_INT_STRING = DartType._withName(
    'WeakReference<Map<int, String>>',
    false,
  );
  static const WEAKREFERENCE_MAP_INT_STRING_NULLABLE = DartType._withName(
    'WeakReference<Map<int, String>>',
    true,
  );
  static const WEAKREFERENCE_MAP_STRING_BOOL = DartType._withName(
    'WeakReference<Map<String, bool>>',
    false,
  );
  static const WEAKREFERENCE_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'WeakReference<Map<String, bool>>',
    true,
  );
  static const WEAKREFERENCE_MAP_STRING_DOUBLE = DartType._withName(
    'WeakReference<Map<String, double>>',
    false,
  );
  static const WEAKREFERENCE_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<Map<String, double>>',
    true,
  );
  static const WEAKREFERENCE_MAP_STRING_INT = DartType._withName(
    'WeakReference<Map<String, int>>',
    false,
  );
  static const WEAKREFERENCE_MAP_STRING_INT_NULLABLE = DartType._withName(
    'WeakReference<Map<String, int>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'WeakReference<MapEntry<bool, bool>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<bool, bool>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'WeakReference<MapEntry<bool, double>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<bool, double>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_BOOL_INT = DartType._withName(
    'WeakReference<MapEntry<bool, int>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<bool, int>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_BOOL_STRING = DartType._withName(
    'WeakReference<MapEntry<bool, String>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<bool, String>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'WeakReference<MapEntry<double, bool>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<double, bool>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'WeakReference<MapEntry<double, double>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('WeakReference<MapEntry<double, double>>', true);
  static const WEAKREFERENCE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'WeakReference<MapEntry<double, int>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<double, int>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'WeakReference<MapEntry<double, String>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('WeakReference<MapEntry<double, String>>', true);
  static const WEAKREFERENCE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'WeakReference<MapEntry<int, double>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<int, double>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_INT_INT = DartType._withName(
    'WeakReference<MapEntry<int, int>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<int, int>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_INT_STRING = DartType._withName(
    'WeakReference<MapEntry<int, String>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<int, String>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_STRING_BOOL = DartType._withName(
    'WeakReference<MapEntry<String, bool>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<String, bool>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'WeakReference<MapEntry<String, double>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('WeakReference<MapEntry<String, double>>', true);
  static const WEAKREFERENCE_MAPENTRY_STRING_INT = DartType._withName(
    'WeakReference<MapEntry<String, int>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'WeakReference<MapEntry<String, int>>',
    true,
  );
  static const WEAKREFERENCE_MAPENTRY_STRING_STRING = DartType._withName(
    'WeakReference<MapEntry<String, String>>',
    false,
  );
  static const WEAKREFERENCE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('WeakReference<MapEntry<String, String>>', true);
  static const MAP_BOOL_LIST_BOOL = DartType._withName(
    'Map<bool, List<bool>>',
    false,
  );
  static const MAP_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<bool, List<bool>>',
    true,
  );
  static const MAP_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<bool, List<double>>',
    false,
  );
  static const MAP_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, List<double>>',
    true,
  );
  static const MAP_BOOL_LIST_INT = DartType._withName(
    'Map<bool, List<int>>',
    false,
  );
  static const MAP_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<bool, List<int>>',
    true,
  );
  static const MAP_BOOL_LIST_STRING = DartType._withName(
    'Map<bool, List<String>>',
    false,
  );
  static const MAP_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<bool, List<String>>',
    true,
  );
  static const MAP_BOOL_SET_BOOL = DartType._withName(
    'Map<bool, Set<bool>>',
    false,
  );
  static const MAP_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<bool, Set<bool>>',
    true,
  );
  static const MAP_BOOL_SET_DOUBLE = DartType._withName(
    'Map<bool, Set<double>>',
    false,
  );
  static const MAP_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, Set<double>>',
    true,
  );
  static const MAP_BOOL_SET_STRING = DartType._withName(
    'Map<bool, Set<String>>',
    false,
  );
  static const MAP_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'Map<bool, Set<String>>',
    true,
  );
  static const MAP_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<bool, Expando<bool>>',
    false,
  );
  static const MAP_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<bool, Expando<bool>>',
    true,
  );
  static const MAP_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<bool, Expando<double>>',
    false,
  );
  static const MAP_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, Expando<double>>',
    true,
  );
  static const MAP_BOOL_EXPANDO_INT = DartType._withName(
    'Map<bool, Expando<int>>',
    false,
  );
  static const MAP_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<bool, Expando<int>>',
    true,
  );
  static const MAP_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<bool, Expando<String>>',
    false,
  );
  static const MAP_BOOL_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<bool, Expando<String>>',
    true,
  );
  static const MAP_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<bool, WeakReference<bool>>',
    false,
  );
  static const MAP_BOOL_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<bool, WeakReference<bool>>',
    true,
  );
  static const MAP_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<bool, WeakReference<double>>',
    false,
  );
  static const MAP_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, WeakReference<double>>',
    true,
  );
  static const MAP_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<bool, WeakReference<int>>',
    false,
  );
  static const MAP_BOOL_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<bool, WeakReference<int>>',
    true,
  );
  static const MAP_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<bool, Map<bool, bool>>',
    false,
  );
  static const MAP_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<bool, Map<bool, bool>>',
    true,
  );
  static const MAP_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<bool, Map<bool, double>>',
    false,
  );
  static const MAP_BOOL_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, Map<bool, double>>',
    true,
  );
  static const MAP_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<bool, Map<bool, int>>',
    false,
  );
  static const MAP_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<bool, Map<bool, int>>',
    true,
  );
  static const MAP_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<bool, Map<bool, String>>',
    false,
  );
  static const MAP_BOOL_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<bool, Map<bool, String>>',
    true,
  );
  static const MAP_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<bool, Map<double, bool>>',
    false,
  );
  static const MAP_BOOL_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<bool, Map<double, bool>>',
    true,
  );
  static const MAP_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<bool, Map<double, double>>',
    false,
  );
  static const MAP_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, Map<double, double>>',
    true,
  );
  static const MAP_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<bool, Map<double, int>>',
    false,
  );
  static const MAP_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<bool, Map<double, int>>',
    true,
  );
  static const MAP_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<bool, Map<double, String>>',
    false,
  );
  static const MAP_BOOL_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<bool, Map<double, String>>',
    true,
  );
  static const MAP_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<bool, Map<int, bool>>',
    false,
  );
  static const MAP_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<bool, Map<int, bool>>',
    true,
  );
  static const MAP_BOOL_MAP_INT_INT = DartType._withName(
    'Map<bool, Map<int, int>>',
    false,
  );
  static const MAP_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<bool, Map<int, int>>',
    true,
  );
  static const MAP_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<bool, Map<int, String>>',
    false,
  );
  static const MAP_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<bool, Map<int, String>>',
    true,
  );
  static const MAP_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<bool, Map<String, bool>>',
    false,
  );
  static const MAP_BOOL_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<bool, Map<String, bool>>',
    true,
  );
  static const MAP_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<bool, Map<String, double>>',
    false,
  );
  static const MAP_BOOL_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, Map<String, double>>',
    true,
  );
  static const MAP_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<bool, Map<String, int>>',
    false,
  );
  static const MAP_BOOL_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<bool, Map<String, int>>',
    true,
  );
  static const MAP_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<bool, Map<String, String>>',
    false,
  );
  static const MAP_BOOL_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<bool, Map<String, String>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<bool, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<bool, MapEntry<bool, double>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<bool, double>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<bool, MapEntry<bool, String>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<bool, String>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<bool, MapEntry<double, bool>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<double, bool>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<bool, MapEntry<double, double>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<double, double>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<bool, MapEntry<double, int>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<double, int>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<bool, MapEntry<double, String>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<double, String>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<bool, MapEntry<int, bool>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<int, bool>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<bool, MapEntry<int, double>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<int, double>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<bool, MapEntry<int, int>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<int, int>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<bool, MapEntry<String, bool>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<String, bool>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<bool, MapEntry<String, double>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<String, double>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<bool, MapEntry<String, int>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<String, int>>',
    true,
  );
  static const MAP_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<bool, MapEntry<String, String>>',
    false,
  );
  static const MAP_BOOL_MAPENTRY_STRING_STRING_NULLABLE = DartType._withName(
    'Map<bool, MapEntry<String, String>>',
    true,
  );
  static const MAP_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<double, List<double>>',
    false,
  );
  static const MAP_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, List<double>>',
    true,
  );
  static const MAP_DOUBLE_LIST_INT = DartType._withName(
    'Map<double, List<int>>',
    false,
  );
  static const MAP_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<double, List<int>>',
    true,
  );
  static const MAP_DOUBLE_LIST_STRING = DartType._withName(
    'Map<double, List<String>>',
    false,
  );
  static const MAP_DOUBLE_LIST_STRING_NULLABLE = DartType._withName(
    'Map<double, List<String>>',
    true,
  );
  static const MAP_DOUBLE_SET_BOOL = DartType._withName(
    'Map<double, Set<bool>>',
    false,
  );
  static const MAP_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<double, Set<bool>>',
    true,
  );
  static const MAP_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<double, Set<double>>',
    false,
  );
  static const MAP_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, Set<double>>',
    true,
  );
  static const MAP_DOUBLE_SET_INT = DartType._withName(
    'Map<double, Set<int>>',
    false,
  );
  static const MAP_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<double, Set<int>>',
    true,
  );
  static const MAP_DOUBLE_SET_STRING = DartType._withName(
    'Map<double, Set<String>>',
    false,
  );
  static const MAP_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'Map<double, Set<String>>',
    true,
  );
  static const MAP_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<double, Expando<bool>>',
    false,
  );
  static const MAP_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<double, Expando<bool>>',
    true,
  );
  static const MAP_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<double, Expando<int>>',
    false,
  );
  static const MAP_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<double, Expando<int>>',
    true,
  );
  static const MAP_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<double, Expando<String>>',
    false,
  );
  static const MAP_DOUBLE_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<double, Expando<String>>',
    true,
  );
  static const MAP_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<double, WeakReference<bool>>',
    false,
  );
  static const MAP_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<double, WeakReference<bool>>',
    true,
  );
  static const MAP_DOUBLE_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<double, WeakReference<double>>',
    false,
  );
  static const MAP_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, WeakReference<double>>',
    true,
  );
  static const MAP_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<double, WeakReference<int>>',
    false,
  );
  static const MAP_DOUBLE_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<double, WeakReference<int>>',
    true,
  );
  static const MAP_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'Map<double, WeakReference<String>>',
    false,
  );
  static const MAP_DOUBLE_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'Map<double, WeakReference<String>>',
    true,
  );
  static const MAP_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<double, Map<bool, bool>>',
    false,
  );
  static const MAP_DOUBLE_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<double, Map<bool, bool>>',
    true,
  );
  static const MAP_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<double, Map<bool, double>>',
    false,
  );
  static const MAP_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, Map<bool, double>>',
    true,
  );
  static const MAP_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<double, Map<bool, String>>',
    false,
  );
  static const MAP_DOUBLE_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<double, Map<bool, String>>',
    true,
  );
  static const MAP_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<double, Map<double, bool>>',
    false,
  );
  static const MAP_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<double, Map<double, bool>>',
    true,
  );
  static const MAP_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<double, Map<double, double>>',
    false,
  );
  static const MAP_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, Map<double, double>>',
    true,
  );
  static const MAP_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<double, Map<double, int>>',
    false,
  );
  static const MAP_DOUBLE_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<double, Map<double, int>>',
    true,
  );
  static const MAP_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'Map<double, Map<double, String>>',
    false,
  );
  static const MAP_DOUBLE_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<double, Map<double, String>>',
    true,
  );
  static const MAP_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<double, Map<int, bool>>',
    false,
  );
  static const MAP_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<double, Map<int, bool>>',
    true,
  );
  static const MAP_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<double, Map<int, double>>',
    false,
  );
  static const MAP_DOUBLE_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, Map<int, double>>',
    true,
  );
  static const MAP_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<double, Map<int, int>>',
    false,
  );
  static const MAP_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<double, Map<int, int>>',
    true,
  );
  static const MAP_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<double, Map<String, bool>>',
    false,
  );
  static const MAP_DOUBLE_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<double, Map<String, bool>>',
    true,
  );
  static const MAP_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<double, Map<String, double>>',
    false,
  );
  static const MAP_DOUBLE_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, Map<String, double>>',
    true,
  );
  static const MAP_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<double, Map<String, int>>',
    false,
  );
  static const MAP_DOUBLE_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<double, Map<String, int>>',
    true,
  );
  static const MAP_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<double, Map<String, String>>',
    false,
  );
  static const MAP_DOUBLE_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<double, Map<String, String>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<double, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<double, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<double, MapEntry<bool, double>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, MapEntry<bool, double>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<double, MapEntry<bool, int>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<double, MapEntry<bool, int>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<double, MapEntry<bool, String>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<double, MapEntry<bool, String>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<double, MapEntry<double, double>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, MapEntry<double, double>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<double, MapEntry<double, int>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<double, MapEntry<double, int>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<double, MapEntry<double, String>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<double, MapEntry<double, String>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<double, MapEntry<int, bool>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<double, MapEntry<int, bool>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<double, MapEntry<int, double>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<double, MapEntry<int, double>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<double, MapEntry<int, int>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<double, MapEntry<int, int>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'Map<double, MapEntry<int, String>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Map<double, MapEntry<int, String>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<double, MapEntry<String, bool>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<double, MapEntry<String, bool>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'Map<double, MapEntry<String, int>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Map<double, MapEntry<String, int>>',
    true,
  );
  static const MAP_DOUBLE_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<double, MapEntry<String, String>>',
    false,
  );
  static const MAP_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE = DartType._withName(
    'Map<double, MapEntry<String, String>>',
    true,
  );
  static const MAP_INT_LIST_BOOL = DartType._withName(
    'Map<int, List<bool>>',
    false,
  );
  static const MAP_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<int, List<bool>>',
    true,
  );
  static const MAP_INT_LIST_DOUBLE = DartType._withName(
    'Map<int, List<double>>',
    false,
  );
  static const MAP_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, List<double>>',
    true,
  );
  static const MAP_INT_LIST_INT = DartType._withName(
    'Map<int, List<int>>',
    false,
  );
  static const MAP_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<int, List<int>>',
    true,
  );
  static const MAP_INT_SET_BOOL = DartType._withName(
    'Map<int, Set<bool>>',
    false,
  );
  static const MAP_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<int, Set<bool>>',
    true,
  );
  static const MAP_INT_SET_DOUBLE = DartType._withName(
    'Map<int, Set<double>>',
    false,
  );
  static const MAP_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, Set<double>>',
    true,
  );
  static const MAP_INT_SET_INT = DartType._withName(
    'Map<int, Set<int>>',
    false,
  );
  static const MAP_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<int, Set<int>>',
    true,
  );
  static const MAP_INT_SET_STRING = DartType._withName(
    'Map<int, Set<String>>',
    false,
  );
  static const MAP_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<int, Set<String>>',
    true,
  );
  static const MAP_INT_EXPANDO_BOOL = DartType._withName(
    'Map<int, Expando<bool>>',
    false,
  );
  static const MAP_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<int, Expando<bool>>',
    true,
  );
  static const MAP_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<int, Expando<double>>',
    false,
  );
  static const MAP_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, Expando<double>>',
    true,
  );
  static const MAP_INT_EXPANDO_INT = DartType._withName(
    'Map<int, Expando<int>>',
    false,
  );
  static const MAP_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<int, Expando<int>>',
    true,
  );
  static const MAP_INT_EXPANDO_STRING = DartType._withName(
    'Map<int, Expando<String>>',
    false,
  );
  static const MAP_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<int, Expando<String>>',
    true,
  );
  static const MAP_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<int, WeakReference<double>>',
    false,
  );
  static const MAP_INT_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, WeakReference<double>>',
    true,
  );
  static const MAP_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<int, WeakReference<int>>',
    false,
  );
  static const MAP_INT_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<int, WeakReference<int>>',
    true,
  );
  static const MAP_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<int, WeakReference<String>>',
    false,
  );
  static const MAP_INT_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'Map<int, WeakReference<String>>',
    true,
  );
  static const MAP_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<int, Map<bool, bool>>',
    false,
  );
  static const MAP_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<int, Map<bool, bool>>',
    true,
  );
  static const MAP_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<int, Map<bool, double>>',
    false,
  );
  static const MAP_INT_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, Map<bool, double>>',
    true,
  );
  static const MAP_INT_MAP_BOOL_INT = DartType._withName(
    'Map<int, Map<bool, int>>',
    false,
  );
  static const MAP_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<int, Map<bool, int>>',
    true,
  );
  static const MAP_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<int, Map<bool, String>>',
    false,
  );
  static const MAP_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<int, Map<bool, String>>',
    true,
  );
  static const MAP_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<int, Map<double, bool>>',
    false,
  );
  static const MAP_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<int, Map<double, bool>>',
    true,
  );
  static const MAP_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<int, Map<double, int>>',
    false,
  );
  static const MAP_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<int, Map<double, int>>',
    true,
  );
  static const MAP_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<int, Map<double, String>>',
    false,
  );
  static const MAP_INT_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<int, Map<double, String>>',
    true,
  );
  static const MAP_INT_MAP_INT_BOOL = DartType._withName(
    'Map<int, Map<int, bool>>',
    false,
  );
  static const MAP_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<int, Map<int, bool>>',
    true,
  );
  static const MAP_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<int, Map<int, double>>',
    false,
  );
  static const MAP_INT_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, Map<int, double>>',
    true,
  );
  static const MAP_INT_MAP_INT_INT = DartType._withName(
    'Map<int, Map<int, int>>',
    false,
  );
  static const MAP_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<int, Map<int, int>>',
    true,
  );
  static const MAP_INT_MAP_INT_STRING = DartType._withName(
    'Map<int, Map<int, String>>',
    false,
  );
  static const MAP_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<int, Map<int, String>>',
    true,
  );
  static const MAP_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<int, Map<String, bool>>',
    false,
  );
  static const MAP_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<int, Map<String, bool>>',
    true,
  );
  static const MAP_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<int, Map<String, double>>',
    false,
  );
  static const MAP_INT_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, Map<String, double>>',
    true,
  );
  static const MAP_INT_MAP_STRING_STRING = DartType._withName(
    'Map<int, Map<String, String>>',
    false,
  );
  static const MAP_INT_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<int, Map<String, String>>',
    true,
  );
  static const MAP_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<int, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_INT_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<int, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<int, MapEntry<bool, double>>',
    false,
  );
  static const MAP_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, MapEntry<bool, double>>',
    true,
  );
  static const MAP_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<int, MapEntry<bool, int>>',
    false,
  );
  static const MAP_INT_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<int, MapEntry<bool, int>>',
    true,
  );
  static const MAP_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<int, MapEntry<bool, String>>',
    false,
  );
  static const MAP_INT_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<int, MapEntry<bool, String>>',
    true,
  );
  static const MAP_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<int, MapEntry<double, bool>>',
    false,
  );
  static const MAP_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<int, MapEntry<double, bool>>',
    true,
  );
  static const MAP_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<int, MapEntry<double, double>>',
    false,
  );
  static const MAP_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, MapEntry<double, double>>',
    true,
  );
  static const MAP_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<int, MapEntry<double, int>>',
    false,
  );
  static const MAP_INT_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<int, MapEntry<double, int>>',
    true,
  );
  static const MAP_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<int, MapEntry<int, bool>>',
    false,
  );
  static const MAP_INT_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<int, MapEntry<int, bool>>',
    true,
  );
  static const MAP_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<int, MapEntry<int, double>>',
    false,
  );
  static const MAP_INT_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, MapEntry<int, double>>',
    true,
  );
  static const MAP_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<int, MapEntry<int, int>>',
    false,
  );
  static const MAP_INT_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<int, MapEntry<int, int>>',
    true,
  );
  static const MAP_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<int, MapEntry<int, String>>',
    false,
  );
  static const MAP_INT_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Map<int, MapEntry<int, String>>',
    true,
  );
  static const MAP_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<int, MapEntry<String, bool>>',
    false,
  );
  static const MAP_INT_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<int, MapEntry<String, bool>>',
    true,
  );
  static const MAP_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<int, MapEntry<String, double>>',
    false,
  );
  static const MAP_INT_MAPENTRY_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<int, MapEntry<String, double>>',
    true,
  );
  static const MAP_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<int, MapEntry<String, int>>',
    false,
  );
  static const MAP_INT_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Map<int, MapEntry<String, int>>',
    true,
  );
  static const MAP_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<int, MapEntry<String, String>>',
    false,
  );
  static const MAP_INT_MAPENTRY_STRING_STRING_NULLABLE = DartType._withName(
    'Map<int, MapEntry<String, String>>',
    true,
  );
  static const MAP_STRING_LIST_BOOL = DartType._withName(
    'Map<String, List<bool>>',
    false,
  );
  static const MAP_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<String, List<bool>>',
    true,
  );
  static const MAP_STRING_LIST_DOUBLE = DartType._withName(
    'Map<String, List<double>>',
    false,
  );
  static const MAP_STRING_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, List<double>>',
    true,
  );
  static const MAP_STRING_LIST_INT = DartType._withName(
    'Map<String, List<int>>',
    false,
  );
  static const MAP_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<String, List<int>>',
    true,
  );
  static const MAP_STRING_LIST_STRING = DartType._withName(
    'Map<String, List<String>>',
    false,
  );
  static const MAP_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'Map<String, List<String>>',
    true,
  );
  static const MAP_STRING_SET_BOOL = DartType._withName(
    'Map<String, Set<bool>>',
    false,
  );
  static const MAP_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<String, Set<bool>>',
    true,
  );
  static const MAP_STRING_SET_INT = DartType._withName(
    'Map<String, Set<int>>',
    false,
  );
  static const MAP_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<String, Set<int>>',
    true,
  );
  static const MAP_STRING_SET_STRING = DartType._withName(
    'Map<String, Set<String>>',
    false,
  );
  static const MAP_STRING_SET_STRING_NULLABLE = DartType._withName(
    'Map<String, Set<String>>',
    true,
  );
  static const MAP_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<String, Expando<bool>>',
    false,
  );
  static const MAP_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<String, Expando<bool>>',
    true,
  );
  static const MAP_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<String, Expando<double>>',
    false,
  );
  static const MAP_STRING_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, Expando<double>>',
    true,
  );
  static const MAP_STRING_EXPANDO_INT = DartType._withName(
    'Map<String, Expando<int>>',
    false,
  );
  static const MAP_STRING_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<String, Expando<int>>',
    true,
  );
  static const MAP_STRING_EXPANDO_STRING = DartType._withName(
    'Map<String, Expando<String>>',
    false,
  );
  static const MAP_STRING_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<String, Expando<String>>',
    true,
  );
  static const MAP_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<String, WeakReference<bool>>',
    false,
  );
  static const MAP_STRING_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<String, WeakReference<bool>>',
    true,
  );
  static const MAP_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<String, WeakReference<double>>',
    false,
  );
  static const MAP_STRING_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, WeakReference<double>>',
    true,
  );
  static const MAP_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'Map<String, WeakReference<String>>',
    false,
  );
  static const MAP_STRING_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'Map<String, WeakReference<String>>',
    true,
  );
  static const MAP_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<String, Map<bool, bool>>',
    false,
  );
  static const MAP_STRING_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<String, Map<bool, bool>>',
    true,
  );
  static const MAP_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<String, Map<bool, double>>',
    false,
  );
  static const MAP_STRING_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, Map<bool, double>>',
    true,
  );
  static const MAP_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<String, Map<bool, int>>',
    false,
  );
  static const MAP_STRING_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<String, Map<bool, int>>',
    true,
  );
  static const MAP_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<String, Map<bool, String>>',
    false,
  );
  static const MAP_STRING_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<String, Map<bool, String>>',
    true,
  );
  static const MAP_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<String, Map<double, bool>>',
    false,
  );
  static const MAP_STRING_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<String, Map<double, bool>>',
    true,
  );
  static const MAP_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<String, Map<double, double>>',
    false,
  );
  static const MAP_STRING_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, Map<double, double>>',
    true,
  );
  static const MAP_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<String, Map<double, int>>',
    false,
  );
  static const MAP_STRING_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<String, Map<double, int>>',
    true,
  );
  static const MAP_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<String, Map<double, String>>',
    false,
  );
  static const MAP_STRING_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<String, Map<double, String>>',
    true,
  );
  static const MAP_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<String, Map<int, double>>',
    false,
  );
  static const MAP_STRING_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, Map<int, double>>',
    true,
  );
  static const MAP_STRING_MAP_INT_INT = DartType._withName(
    'Map<String, Map<int, int>>',
    false,
  );
  static const MAP_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<String, Map<int, int>>',
    true,
  );
  static const MAP_STRING_MAP_INT_STRING = DartType._withName(
    'Map<String, Map<int, String>>',
    false,
  );
  static const MAP_STRING_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<String, Map<int, String>>',
    true,
  );
  static const MAP_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<String, Map<String, bool>>',
    false,
  );
  static const MAP_STRING_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<String, Map<String, bool>>',
    true,
  );
  static const MAP_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<String, Map<String, double>>',
    false,
  );
  static const MAP_STRING_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, Map<String, double>>',
    true,
  );
  static const MAP_STRING_MAP_STRING_INT = DartType._withName(
    'Map<String, Map<String, int>>',
    false,
  );
  static const MAP_STRING_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<String, Map<String, int>>',
    true,
  );
  static const MAP_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<String, Map<String, String>>',
    false,
  );
  static const MAP_STRING_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<String, Map<String, String>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<String, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<String, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<String, MapEntry<bool, int>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<String, MapEntry<bool, int>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<String, MapEntry<bool, String>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<String, MapEntry<bool, String>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<String, MapEntry<double, bool>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<String, MapEntry<double, bool>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<String, MapEntry<double, double>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, MapEntry<double, double>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<String, MapEntry<double, int>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<String, MapEntry<double, int>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<String, MapEntry<double, String>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<String, MapEntry<double, String>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<String, MapEntry<int, bool>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<String, MapEntry<int, bool>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<String, MapEntry<int, double>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, MapEntry<int, double>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'Map<String, MapEntry<int, String>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Map<String, MapEntry<int, String>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<String, MapEntry<String, bool>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<String, MapEntry<String, bool>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<String, MapEntry<String, double>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<String, MapEntry<String, double>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'Map<String, MapEntry<String, int>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Map<String, MapEntry<String, int>>',
    true,
  );
  static const MAP_STRING_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<String, MapEntry<String, String>>',
    false,
  );
  static const MAP_STRING_MAPENTRY_STRING_STRING_NULLABLE = DartType._withName(
    'Map<String, MapEntry<String, String>>',
    true,
  );
  static const MAP_LIST_BOOL_BOOL = DartType._withName(
    'Map<List<bool>, bool>',
    false,
  );
  static const MAP_LIST_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, bool>',
    true,
  );
  static const MAP_LIST_BOOL_DOUBLE = DartType._withName(
    'Map<List<bool>, double>',
    false,
  );
  static const MAP_LIST_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, double>',
    true,
  );
  static const MAP_LIST_BOOL_INT = DartType._withName(
    'Map<List<bool>, int>',
    false,
  );
  static const MAP_LIST_BOOL_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, int>',
    true,
  );
  static const MAP_LIST_BOOL_LIST_BOOL = DartType._withName(
    'Map<List<bool>, List<bool>>',
    false,
  );
  static const MAP_LIST_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, List<bool>>',
    true,
  );
  static const MAP_LIST_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<List<bool>, List<double>>',
    false,
  );
  static const MAP_LIST_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, List<double>>',
    true,
  );
  static const MAP_LIST_BOOL_LIST_INT = DartType._withName(
    'Map<List<bool>, List<int>>',
    false,
  );
  static const MAP_LIST_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, List<int>>',
    true,
  );
  static const MAP_LIST_BOOL_LIST_STRING = DartType._withName(
    'Map<List<bool>, List<String>>',
    false,
  );
  static const MAP_LIST_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<List<bool>, List<String>>',
    true,
  );
  static const MAP_LIST_BOOL_SET_BOOL = DartType._withName(
    'Map<List<bool>, Set<bool>>',
    false,
  );
  static const MAP_LIST_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, Set<bool>>',
    true,
  );
  static const MAP_LIST_BOOL_SET_DOUBLE = DartType._withName(
    'Map<List<bool>, Set<double>>',
    false,
  );
  static const MAP_LIST_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, Set<double>>',
    true,
  );
  static const MAP_LIST_BOOL_SET_INT = DartType._withName(
    'Map<List<bool>, Set<int>>',
    false,
  );
  static const MAP_LIST_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, Set<int>>',
    true,
  );
  static const MAP_LIST_BOOL_SET_STRING = DartType._withName(
    'Map<List<bool>, Set<String>>',
    false,
  );
  static const MAP_LIST_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'Map<List<bool>, Set<String>>',
    true,
  );
  static const MAP_LIST_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<List<bool>, Expando<double>>',
    false,
  );
  static const MAP_LIST_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, Expando<double>>',
    true,
  );
  static const MAP_LIST_BOOL_EXPANDO_INT = DartType._withName(
    'Map<List<bool>, Expando<int>>',
    false,
  );
  static const MAP_LIST_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, Expando<int>>',
    true,
  );
  static const MAP_LIST_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<List<bool>, Expando<String>>',
    false,
  );
  static const MAP_LIST_BOOL_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<List<bool>, Expando<String>>',
    true,
  );
  static const MAP_LIST_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<List<bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_LIST_BOOL_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, WeakReference<bool>>',
    true,
  );
  static const MAP_LIST_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<List<bool>, WeakReference<double>>',
    false,
  );
  static const MAP_LIST_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, WeakReference<double>>',
    true,
  );
  static const MAP_LIST_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<List<bool>, WeakReference<int>>',
    false,
  );
  static const MAP_LIST_BOOL_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, WeakReference<int>>',
    true,
  );
  static const MAP_LIST_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'Map<List<bool>, WeakReference<String>>',
    false,
  );
  static const MAP_LIST_BOOL_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'Map<List<bool>, WeakReference<String>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<List<bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<bool, bool>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<List<bool>, Map<bool, int>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<bool, int>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<List<bool>, Map<bool, String>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<bool, String>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<List<bool>, Map<double, bool>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<double, bool>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<List<bool>, Map<double, double>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<double, double>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<List<bool>, Map<double, int>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<double, int>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<List<bool>, Map<double, String>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<double, String>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<List<bool>, Map<int, bool>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<int, bool>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<List<bool>, Map<int, double>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<int, double>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<List<bool>, Map<int, String>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<int, String>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<List<bool>, Map<String, bool>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<String, bool>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<List<bool>, Map<String, double>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<String, double>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<List<bool>, Map<String, int>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<String, int>>',
    true,
  );
  static const MAP_LIST_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<List<bool>, Map<String, String>>',
    false,
  );
  static const MAP_LIST_BOOL_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<List<bool>, Map<String, String>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<List<bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<List<bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<bool, double>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<List<bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<List<bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<double, bool>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<List<bool>, MapEntry<double, double>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<List<bool>, MapEntry<double, double>>', true);
  static const MAP_LIST_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<List<bool>, MapEntry<double, int>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<double, int>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<List<bool>, MapEntry<double, String>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<List<bool>, MapEntry<double, String>>', true);
  static const MAP_LIST_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<List<bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<List<bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<int, double>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<List<bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<int, int>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'Map<List<bool>, MapEntry<int, String>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<int, String>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<List<bool>, MapEntry<String, double>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<List<bool>, MapEntry<String, double>>', true);
  static const MAP_LIST_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<List<bool>, MapEntry<String, int>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Map<List<bool>, MapEntry<String, int>>',
    true,
  );
  static const MAP_LIST_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<List<bool>, MapEntry<String, String>>',
    false,
  );
  static const MAP_LIST_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<List<bool>, MapEntry<String, String>>', true);
  static const MAP_LIST_DOUBLE_BOOL = DartType._withName(
    'Map<List<double>, bool>',
    false,
  );
  static const MAP_LIST_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, bool>',
    true,
  );
  static const MAP_LIST_DOUBLE_DOUBLE = DartType._withName(
    'Map<List<double>, double>',
    false,
  );
  static const MAP_LIST_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<double>, double>',
    true,
  );
  static const MAP_LIST_DOUBLE_INT = DartType._withName(
    'Map<List<double>, int>',
    false,
  );
  static const MAP_LIST_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<List<double>, int>',
    true,
  );
  static const MAP_LIST_DOUBLE_STRING = DartType._withName(
    'Map<List<double>, String>',
    false,
  );
  static const MAP_LIST_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<List<double>, String>',
    true,
  );
  static const MAP_LIST_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<List<double>, List<bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, List<bool>>',
    true,
  );
  static const MAP_LIST_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<List<double>, List<double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<double>, List<double>>',
    true,
  );
  static const MAP_LIST_DOUBLE_LIST_STRING = DartType._withName(
    'Map<List<double>, List<String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_LIST_STRING_NULLABLE = DartType._withName(
    'Map<List<double>, List<String>>',
    true,
  );
  static const MAP_LIST_DOUBLE_SET_BOOL = DartType._withName(
    'Map<List<double>, Set<bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, Set<bool>>',
    true,
  );
  static const MAP_LIST_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<List<double>, Set<double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<double>, Set<double>>',
    true,
  );
  static const MAP_LIST_DOUBLE_SET_INT = DartType._withName(
    'Map<List<double>, Set<int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<List<double>, Set<int>>',
    true,
  );
  static const MAP_LIST_DOUBLE_SET_STRING = DartType._withName(
    'Map<List<double>, Set<String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'Map<List<double>, Set<String>>',
    true,
  );
  static const MAP_LIST_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<List<double>, Expando<bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, Expando<bool>>',
    true,
  );
  static const MAP_LIST_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<List<double>, Expando<double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<double>, Expando<double>>',
    true,
  );
  static const MAP_LIST_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<List<double>, Expando<int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<List<double>, Expando<int>>',
    true,
  );
  static const MAP_LIST_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<List<double>, WeakReference<bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, WeakReference<bool>>',
    true,
  );
  static const MAP_LIST_DOUBLE_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<List<double>, WeakReference<double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<List<double>, WeakReference<double>>', true);
  static const MAP_LIST_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<List<double>, WeakReference<int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<List<double>, WeakReference<int>>',
    true,
  );
  static const MAP_LIST_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'Map<List<double>, WeakReference<String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<List<double>, WeakReference<String>>', true);
  static const MAP_LIST_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<List<double>, Map<bool, bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, Map<bool, bool>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<List<double>, Map<bool, double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<double>, Map<bool, double>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<List<double>, Map<bool, int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<List<double>, Map<bool, int>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<List<double>, Map<bool, String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<List<double>, Map<bool, String>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<List<double>, Map<double, double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<double>, Map<double, double>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<List<double>, Map<double, int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<List<double>, Map<double, int>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'Map<List<double>, Map<double, String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<List<double>, Map<double, String>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<List<double>, Map<int, bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, Map<int, bool>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<List<double>, Map<int, double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<double>, Map<int, double>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<List<double>, Map<int, int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<List<double>, Map<int, int>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<List<double>, Map<int, String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<List<double>, Map<int, String>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<List<double>, Map<String, bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, Map<String, bool>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<List<double>, Map<String, int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<List<double>, Map<String, int>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<List<double>, Map<String, String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<List<double>, Map<String, String>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<List<double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<List<double>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<bool, double>>', true);
  static const MAP_LIST_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<List<double>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<List<double>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<List<double>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<bool, String>>', true);
  static const MAP_LIST_DOUBLE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<List<double>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<double, bool>>', true);
  static const MAP_LIST_DOUBLE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<List<double>, MapEntry<double, double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<double, double>>', true);
  static const MAP_LIST_DOUBLE_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<List<double>, MapEntry<double, String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<double, String>>', true);
  static const MAP_LIST_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<List<double>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<List<double>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<List<double>, MapEntry<int, double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<int, double>>', true);
  static const MAP_LIST_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<List<double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<List<double>, MapEntry<int, int>>',
    true,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'Map<List<double>, MapEntry<int, String>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<int, String>>', true);
  static const MAP_LIST_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<List<double>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<String, bool>>', true);
  static const MAP_LIST_DOUBLE_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<List<double>, MapEntry<String, double>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<String, double>>', true);
  static const MAP_LIST_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'Map<List<double>, MapEntry<String, int>>',
    false,
  );
  static const MAP_LIST_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<List<double>, MapEntry<String, int>>', true);
  static const MAP_LIST_INT_BOOL = DartType._withName(
    'Map<List<int>, bool>',
    false,
  );
  static const MAP_LIST_INT_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, bool>',
    true,
  );
  static const MAP_LIST_INT_DOUBLE = DartType._withName(
    'Map<List<int>, double>',
    false,
  );
  static const MAP_LIST_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<int>, double>',
    true,
  );
  static const MAP_LIST_INT_INT = DartType._withName(
    'Map<List<int>, int>',
    false,
  );
  static const MAP_LIST_INT_INT_NULLABLE = DartType._withName(
    'Map<List<int>, int>',
    true,
  );
  static const MAP_LIST_INT_STRING = DartType._withName(
    'Map<List<int>, String>',
    false,
  );
  static const MAP_LIST_INT_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, String>',
    true,
  );
  static const MAP_LIST_INT_LIST_BOOL = DartType._withName(
    'Map<List<int>, List<bool>>',
    false,
  );
  static const MAP_LIST_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, List<bool>>',
    true,
  );
  static const MAP_LIST_INT_LIST_DOUBLE = DartType._withName(
    'Map<List<int>, List<double>>',
    false,
  );
  static const MAP_LIST_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<int>, List<double>>',
    true,
  );
  static const MAP_LIST_INT_LIST_INT = DartType._withName(
    'Map<List<int>, List<int>>',
    false,
  );
  static const MAP_LIST_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<List<int>, List<int>>',
    true,
  );
  static const MAP_LIST_INT_LIST_STRING = DartType._withName(
    'Map<List<int>, List<String>>',
    false,
  );
  static const MAP_LIST_INT_LIST_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, List<String>>',
    true,
  );
  static const MAP_LIST_INT_SET_DOUBLE = DartType._withName(
    'Map<List<int>, Set<double>>',
    false,
  );
  static const MAP_LIST_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<int>, Set<double>>',
    true,
  );
  static const MAP_LIST_INT_SET_INT = DartType._withName(
    'Map<List<int>, Set<int>>',
    false,
  );
  static const MAP_LIST_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<List<int>, Set<int>>',
    true,
  );
  static const MAP_LIST_INT_SET_STRING = DartType._withName(
    'Map<List<int>, Set<String>>',
    false,
  );
  static const MAP_LIST_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, Set<String>>',
    true,
  );
  static const MAP_LIST_INT_EXPANDO_BOOL = DartType._withName(
    'Map<List<int>, Expando<bool>>',
    false,
  );
  static const MAP_LIST_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, Expando<bool>>',
    true,
  );
  static const MAP_LIST_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<List<int>, Expando<double>>',
    false,
  );
  static const MAP_LIST_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<int>, Expando<double>>',
    true,
  );
  static const MAP_LIST_INT_EXPANDO_INT = DartType._withName(
    'Map<List<int>, Expando<int>>',
    false,
  );
  static const MAP_LIST_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<List<int>, Expando<int>>',
    true,
  );
  static const MAP_LIST_INT_EXPANDO_STRING = DartType._withName(
    'Map<List<int>, Expando<String>>',
    false,
  );
  static const MAP_LIST_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, Expando<String>>',
    true,
  );
  static const MAP_LIST_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<List<int>, WeakReference<bool>>',
    false,
  );
  static const MAP_LIST_INT_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, WeakReference<bool>>',
    true,
  );
  static const MAP_LIST_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<List<int>, WeakReference<int>>',
    false,
  );
  static const MAP_LIST_INT_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<List<int>, WeakReference<int>>',
    true,
  );
  static const MAP_LIST_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<List<int>, WeakReference<String>>',
    false,
  );
  static const MAP_LIST_INT_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, WeakReference<String>>',
    true,
  );
  static const MAP_LIST_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<List<int>, Map<bool, bool>>',
    false,
  );
  static const MAP_LIST_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, Map<bool, bool>>',
    true,
  );
  static const MAP_LIST_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<List<int>, Map<bool, double>>',
    false,
  );
  static const MAP_LIST_INT_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<int>, Map<bool, double>>',
    true,
  );
  static const MAP_LIST_INT_MAP_BOOL_INT = DartType._withName(
    'Map<List<int>, Map<bool, int>>',
    false,
  );
  static const MAP_LIST_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<List<int>, Map<bool, int>>',
    true,
  );
  static const MAP_LIST_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<List<int>, Map<bool, String>>',
    false,
  );
  static const MAP_LIST_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, Map<bool, String>>',
    true,
  );
  static const MAP_LIST_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<List<int>, Map<double, bool>>',
    false,
  );
  static const MAP_LIST_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, Map<double, bool>>',
    true,
  );
  static const MAP_LIST_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<List<int>, Map<double, double>>',
    false,
  );
  static const MAP_LIST_INT_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<int>, Map<double, double>>',
    true,
  );
  static const MAP_LIST_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<List<int>, Map<double, int>>',
    false,
  );
  static const MAP_LIST_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<List<int>, Map<double, int>>',
    true,
  );
  static const MAP_LIST_INT_MAP_INT_BOOL = DartType._withName(
    'Map<List<int>, Map<int, bool>>',
    false,
  );
  static const MAP_LIST_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, Map<int, bool>>',
    true,
  );
  static const MAP_LIST_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<List<int>, Map<int, double>>',
    false,
  );
  static const MAP_LIST_INT_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<int>, Map<int, double>>',
    true,
  );
  static const MAP_LIST_INT_MAP_INT_INT = DartType._withName(
    'Map<List<int>, Map<int, int>>',
    false,
  );
  static const MAP_LIST_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<List<int>, Map<int, int>>',
    true,
  );
  static const MAP_LIST_INT_MAP_INT_STRING = DartType._withName(
    'Map<List<int>, Map<int, String>>',
    false,
  );
  static const MAP_LIST_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, Map<int, String>>',
    true,
  );
  static const MAP_LIST_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<List<int>, Map<String, bool>>',
    false,
  );
  static const MAP_LIST_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, Map<String, bool>>',
    true,
  );
  static const MAP_LIST_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<List<int>, Map<String, double>>',
    false,
  );
  static const MAP_LIST_INT_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<int>, Map<String, double>>',
    true,
  );
  static const MAP_LIST_INT_MAP_STRING_INT = DartType._withName(
    'Map<List<int>, Map<String, int>>',
    false,
  );
  static const MAP_LIST_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<List<int>, Map<String, int>>',
    true,
  );
  static const MAP_LIST_INT_MAP_STRING_STRING = DartType._withName(
    'Map<List<int>, Map<String, String>>',
    false,
  );
  static const MAP_LIST_INT_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, Map<String, String>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<List<int>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<bool, double>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<List<int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<List<int>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<bool, String>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<List<int>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<double, bool>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<List<int>, MapEntry<double, double>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<List<int>, MapEntry<double, double>>', true);
  static const MAP_LIST_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<List<int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<double, int>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<List<int>, MapEntry<double, String>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<List<int>, MapEntry<double, String>>', true);
  static const MAP_LIST_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<List<int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<List<int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<int, int>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<List<int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<int, String>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<List<int>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<String, bool>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<List<int>, MapEntry<String, double>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<List<int>, MapEntry<String, double>>', true);
  static const MAP_LIST_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<List<int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Map<List<int>, MapEntry<String, int>>',
    true,
  );
  static const MAP_LIST_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<List<int>, MapEntry<String, String>>',
    false,
  );
  static const MAP_LIST_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<List<int>, MapEntry<String, String>>', true);
  static const MAP_LIST_STRING_BOOL = DartType._withName(
    'Map<List<String>, bool>',
    false,
  );
  static const MAP_LIST_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, bool>',
    true,
  );
  static const MAP_LIST_STRING_DOUBLE = DartType._withName(
    'Map<List<String>, double>',
    false,
  );
  static const MAP_LIST_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<String>, double>',
    true,
  );
  static const MAP_LIST_STRING_STRING = DartType._withName(
    'Map<List<String>, String>',
    false,
  );
  static const MAP_LIST_STRING_STRING_NULLABLE = DartType._withName(
    'Map<List<String>, String>',
    true,
  );
  static const MAP_LIST_STRING_LIST_BOOL = DartType._withName(
    'Map<List<String>, List<bool>>',
    false,
  );
  static const MAP_LIST_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, List<bool>>',
    true,
  );
  static const MAP_LIST_STRING_LIST_DOUBLE = DartType._withName(
    'Map<List<String>, List<double>>',
    false,
  );
  static const MAP_LIST_STRING_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<String>, List<double>>',
    true,
  );
  static const MAP_LIST_STRING_LIST_INT = DartType._withName(
    'Map<List<String>, List<int>>',
    false,
  );
  static const MAP_LIST_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<List<String>, List<int>>',
    true,
  );
  static const MAP_LIST_STRING_LIST_STRING = DartType._withName(
    'Map<List<String>, List<String>>',
    false,
  );
  static const MAP_LIST_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'Map<List<String>, List<String>>',
    true,
  );
  static const MAP_LIST_STRING_SET_BOOL = DartType._withName(
    'Map<List<String>, Set<bool>>',
    false,
  );
  static const MAP_LIST_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, Set<bool>>',
    true,
  );
  static const MAP_LIST_STRING_SET_DOUBLE = DartType._withName(
    'Map<List<String>, Set<double>>',
    false,
  );
  static const MAP_LIST_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<String>, Set<double>>',
    true,
  );
  static const MAP_LIST_STRING_SET_INT = DartType._withName(
    'Map<List<String>, Set<int>>',
    false,
  );
  static const MAP_LIST_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<List<String>, Set<int>>',
    true,
  );
  static const MAP_LIST_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<List<String>, Expando<bool>>',
    false,
  );
  static const MAP_LIST_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, Expando<bool>>',
    true,
  );
  static const MAP_LIST_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<List<String>, Expando<double>>',
    false,
  );
  static const MAP_LIST_STRING_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<String>, Expando<double>>',
    true,
  );
  static const MAP_LIST_STRING_EXPANDO_INT = DartType._withName(
    'Map<List<String>, Expando<int>>',
    false,
  );
  static const MAP_LIST_STRING_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<List<String>, Expando<int>>',
    true,
  );
  static const MAP_LIST_STRING_EXPANDO_STRING = DartType._withName(
    'Map<List<String>, Expando<String>>',
    false,
  );
  static const MAP_LIST_STRING_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<List<String>, Expando<String>>',
    true,
  );
  static const MAP_LIST_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<List<String>, WeakReference<bool>>',
    false,
  );
  static const MAP_LIST_STRING_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, WeakReference<bool>>',
    true,
  );
  static const MAP_LIST_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<List<String>, WeakReference<double>>',
    false,
  );
  static const MAP_LIST_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<List<String>, WeakReference<double>>', true);
  static const MAP_LIST_STRING_WEAKREFERENCE_INT = DartType._withName(
    'Map<List<String>, WeakReference<int>>',
    false,
  );
  static const MAP_LIST_STRING_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<List<String>, WeakReference<int>>',
    true,
  );
  static const MAP_LIST_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'Map<List<String>, WeakReference<String>>',
    false,
  );
  static const MAP_LIST_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<List<String>, WeakReference<String>>', true);
  static const MAP_LIST_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<List<String>, Map<bool, double>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<String>, Map<bool, double>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<List<String>, Map<bool, int>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<List<String>, Map<bool, int>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<List<String>, Map<bool, String>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<List<String>, Map<bool, String>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<List<String>, Map<double, bool>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, Map<double, bool>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<List<String>, Map<double, double>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<String>, Map<double, double>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<List<String>, Map<double, int>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<List<String>, Map<double, int>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<List<String>, Map<double, String>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<List<String>, Map<double, String>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<List<String>, Map<int, bool>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, Map<int, bool>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_INT_INT = DartType._withName(
    'Map<List<String>, Map<int, int>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<List<String>, Map<int, int>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_INT_STRING = DartType._withName(
    'Map<List<String>, Map<int, String>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<List<String>, Map<int, String>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<List<String>, Map<String, bool>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, Map<String, bool>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<List<String>, Map<String, double>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<List<String>, Map<String, double>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_STRING_INT = DartType._withName(
    'Map<List<String>, Map<String, int>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<List<String>, Map<String, int>>',
    true,
  );
  static const MAP_LIST_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<List<String>, Map<String, String>>',
    false,
  );
  static const MAP_LIST_STRING_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<List<String>, Map<String, String>>',
    true,
  );
  static const MAP_LIST_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<List<String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_LIST_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<List<String>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<bool, double>>', true);
  static const MAP_LIST_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<List<String>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<bool, String>>', true);
  static const MAP_LIST_STRING_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<List<String>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<double, bool>>', true);
  static const MAP_LIST_STRING_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<List<String>, MapEntry<double, double>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<double, double>>', true);
  static const MAP_LIST_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<List<String>, MapEntry<double, int>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<double, int>>', true);
  static const MAP_LIST_STRING_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<List<String>, MapEntry<double, String>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<double, String>>', true);
  static const MAP_LIST_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<List<String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<List<String>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_LIST_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<List<String>, MapEntry<int, double>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<int, double>>', true);
  static const MAP_LIST_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<List<String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<List<String>, MapEntry<int, int>>',
    true,
  );
  static const MAP_LIST_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<List<String>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<String, bool>>', true);
  static const MAP_LIST_STRING_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<List<String>, MapEntry<String, double>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<String, double>>', true);
  static const MAP_LIST_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'Map<List<String>, MapEntry<String, int>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<String, int>>', true);
  static const MAP_LIST_STRING_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<List<String>, MapEntry<String, String>>',
    false,
  );
  static const MAP_LIST_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<List<String>, MapEntry<String, String>>', true);
  static const MAP_SET_BOOL_BOOL = DartType._withName(
    'Map<Set<bool>, bool>',
    false,
  );
  static const MAP_SET_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, bool>',
    true,
  );
  static const MAP_SET_BOOL_DOUBLE = DartType._withName(
    'Map<Set<bool>, double>',
    false,
  );
  static const MAP_SET_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, double>',
    true,
  );
  static const MAP_SET_BOOL_INT = DartType._withName(
    'Map<Set<bool>, int>',
    false,
  );
  static const MAP_SET_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, int>',
    true,
  );
  static const MAP_SET_BOOL_STRING = DartType._withName(
    'Map<Set<bool>, String>',
    false,
  );
  static const MAP_SET_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, String>',
    true,
  );
  static const MAP_SET_BOOL_LIST_BOOL = DartType._withName(
    'Map<Set<bool>, List<bool>>',
    false,
  );
  static const MAP_SET_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, List<bool>>',
    true,
  );
  static const MAP_SET_BOOL_LIST_INT = DartType._withName(
    'Map<Set<bool>, List<int>>',
    false,
  );
  static const MAP_SET_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, List<int>>',
    true,
  );
  static const MAP_SET_BOOL_LIST_STRING = DartType._withName(
    'Map<Set<bool>, List<String>>',
    false,
  );
  static const MAP_SET_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, List<String>>',
    true,
  );
  static const MAP_SET_BOOL_SET_BOOL = DartType._withName(
    'Map<Set<bool>, Set<bool>>',
    false,
  );
  static const MAP_SET_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, Set<bool>>',
    true,
  );
  static const MAP_SET_BOOL_SET_DOUBLE = DartType._withName(
    'Map<Set<bool>, Set<double>>',
    false,
  );
  static const MAP_SET_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, Set<double>>',
    true,
  );
  static const MAP_SET_BOOL_SET_INT = DartType._withName(
    'Map<Set<bool>, Set<int>>',
    false,
  );
  static const MAP_SET_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, Set<int>>',
    true,
  );
  static const MAP_SET_BOOL_SET_STRING = DartType._withName(
    'Map<Set<bool>, Set<String>>',
    false,
  );
  static const MAP_SET_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, Set<String>>',
    true,
  );
  static const MAP_SET_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<Set<bool>, Expando<bool>>',
    false,
  );
  static const MAP_SET_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, Expando<bool>>',
    true,
  );
  static const MAP_SET_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<Set<bool>, Expando<double>>',
    false,
  );
  static const MAP_SET_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, Expando<double>>',
    true,
  );
  static const MAP_SET_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<Set<bool>, Expando<String>>',
    false,
  );
  static const MAP_SET_BOOL_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, Expando<String>>',
    true,
  );
  static const MAP_SET_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Set<bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_SET_BOOL_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, WeakReference<bool>>',
    true,
  );
  static const MAP_SET_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Set<bool>, WeakReference<double>>',
    false,
  );
  static const MAP_SET_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, WeakReference<double>>',
    true,
  );
  static const MAP_SET_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<Set<bool>, WeakReference<int>>',
    false,
  );
  static const MAP_SET_BOOL_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, WeakReference<int>>',
    true,
  );
  static const MAP_SET_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Set<bool>, WeakReference<String>>',
    false,
  );
  static const MAP_SET_BOOL_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, WeakReference<String>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<Set<bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<bool, bool>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Set<bool>, Map<bool, double>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<bool, double>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<Set<bool>, Map<bool, int>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<bool, int>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Set<bool>, Map<double, bool>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<double, bool>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Set<bool>, Map<double, double>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<double, double>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<Set<bool>, Map<double, int>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<double, int>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Set<bool>, Map<double, String>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<double, String>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<Set<bool>, Map<int, bool>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<int, bool>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<Set<bool>, Map<int, double>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<int, double>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_INT_INT = DartType._withName(
    'Map<Set<bool>, Map<int, int>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<int, int>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<Set<bool>, Map<int, String>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<int, String>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Set<bool>, Map<String, double>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<String, double>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<Set<bool>, Map<String, int>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<String, int>>',
    true,
  );
  static const MAP_SET_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<Set<bool>, Map<String, String>>',
    false,
  );
  static const MAP_SET_BOOL_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, Map<String, String>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Set<bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Set<bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<bool, double>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Set<bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Set<bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<bool, String>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Set<bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<double, bool>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Set<bool>, MapEntry<double, int>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<double, int>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Set<bool>, MapEntry<double, String>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Set<bool>, MapEntry<double, String>>', true);
  static const MAP_SET_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Set<bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Set<bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<int, double>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<Set<bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<int, int>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Set<bool>, MapEntry<int, String>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<int, String>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Set<bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Set<bool>, MapEntry<String, bool>>',
    true,
  );
  static const MAP_SET_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Set<bool>, MapEntry<String, double>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Set<bool>, MapEntry<String, double>>', true);
  static const MAP_SET_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Set<bool>, MapEntry<String, String>>',
    false,
  );
  static const MAP_SET_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<Set<bool>, MapEntry<String, String>>', true);
  static const MAP_SET_DOUBLE_BOOL = DartType._withName(
    'Map<Set<double>, bool>',
    false,
  );
  static const MAP_SET_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<double>, bool>',
    true,
  );
  static const MAP_SET_DOUBLE_DOUBLE = DartType._withName(
    'Map<Set<double>, double>',
    false,
  );
  static const MAP_SET_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<double>, double>',
    true,
  );
  static const MAP_SET_DOUBLE_INT = DartType._withName(
    'Map<Set<double>, int>',
    false,
  );
  static const MAP_SET_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, int>',
    true,
  );
  static const MAP_SET_DOUBLE_STRING = DartType._withName(
    'Map<Set<double>, String>',
    false,
  );
  static const MAP_SET_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Set<double>, String>',
    true,
  );
  static const MAP_SET_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<Set<double>, List<bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Set<double>, List<bool>>',
    true,
  );
  static const MAP_SET_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<Set<double>, List<double>>',
    false,
  );
  static const MAP_SET_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<double>, List<double>>',
    true,
  );
  static const MAP_SET_DOUBLE_LIST_INT = DartType._withName(
    'Map<Set<double>, List<int>>',
    false,
  );
  static const MAP_SET_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, List<int>>',
    true,
  );
  static const MAP_SET_DOUBLE_SET_BOOL = DartType._withName(
    'Map<Set<double>, Set<bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Set<double>, Set<bool>>',
    true,
  );
  static const MAP_SET_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<Set<double>, Set<double>>',
    false,
  );
  static const MAP_SET_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<double>, Set<double>>',
    true,
  );
  static const MAP_SET_DOUBLE_SET_INT = DartType._withName(
    'Map<Set<double>, Set<int>>',
    false,
  );
  static const MAP_SET_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, Set<int>>',
    true,
  );
  static const MAP_SET_DOUBLE_SET_STRING = DartType._withName(
    'Map<Set<double>, Set<String>>',
    false,
  );
  static const MAP_SET_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'Map<Set<double>, Set<String>>',
    true,
  );
  static const MAP_SET_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<Set<double>, Expando<bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Set<double>, Expando<bool>>',
    true,
  );
  static const MAP_SET_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<Set<double>, Expando<double>>',
    false,
  );
  static const MAP_SET_DOUBLE_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<double>, Expando<double>>',
    true,
  );
  static const MAP_SET_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<Set<double>, Expando<int>>',
    false,
  );
  static const MAP_SET_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, Expando<int>>',
    true,
  );
  static const MAP_SET_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<Set<double>, Expando<String>>',
    false,
  );
  static const MAP_SET_DOUBLE_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Set<double>, Expando<String>>',
    true,
  );
  static const MAP_SET_DOUBLE_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Set<double>, WeakReference<double>>',
    false,
  );
  static const MAP_SET_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Set<double>, WeakReference<double>>', true);
  static const MAP_SET_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<Set<double>, WeakReference<int>>',
    false,
  );
  static const MAP_SET_DOUBLE_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, WeakReference<int>>',
    true,
  );
  static const MAP_SET_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Set<double>, WeakReference<String>>',
    false,
  );
  static const MAP_SET_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Set<double>, WeakReference<String>>', true);
  static const MAP_SET_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<Set<double>, Map<bool, bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<bool, bool>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Set<double>, Map<bool, double>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<bool, double>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<Set<double>, Map<bool, int>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<bool, int>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<Set<double>, Map<bool, String>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<bool, String>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Set<double>, Map<double, bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<double, bool>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Set<double>, Map<double, double>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<double, double>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Set<double>, Map<double, String>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<double, String>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<Set<double>, Map<int, bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<int, bool>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<Set<double>, Map<int, double>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<int, double>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<Set<double>, Map<int, int>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<int, int>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<Set<double>, Map<int, String>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<int, String>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<Set<double>, Map<String, bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<String, bool>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Set<double>, Map<String, double>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<String, double>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<Set<double>, Map<String, int>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, Map<String, int>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Set<double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Set<double>, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Set<double>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Set<double>, MapEntry<bool, double>>', true);
  static const MAP_SET_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Set<double>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Set<double>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Set<double>, MapEntry<bool, String>>', true);
  static const MAP_SET_DOUBLE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Set<double>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Set<double>, MapEntry<double, bool>>', true);
  static const MAP_SET_DOUBLE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Set<double>, MapEntry<double, double>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Set<double>, MapEntry<double, double>>', true);
  static const MAP_SET_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Set<double>, MapEntry<double, int>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, MapEntry<double, int>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Set<double>, MapEntry<double, String>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Set<double>, MapEntry<double, String>>', true);
  static const MAP_SET_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Set<double>, MapEntry<int, double>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<double>, MapEntry<int, double>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<Set<double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, MapEntry<int, int>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Set<double>, MapEntry<int, String>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Map<Set<double>, MapEntry<int, String>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Set<double>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Set<double>, MapEntry<String, bool>>', true);
  static const MAP_SET_DOUBLE_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Set<double>, MapEntry<String, double>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Set<double>, MapEntry<String, double>>', true);
  static const MAP_SET_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Set<double>, MapEntry<String, int>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Map<Set<double>, MapEntry<String, int>>',
    true,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Set<double>, MapEntry<String, String>>',
    false,
  );
  static const MAP_SET_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<Set<double>, MapEntry<String, String>>', true);
  static const MAP_SET_INT_BOOL = DartType._withName(
    'Map<Set<int>, bool>',
    false,
  );
  static const MAP_SET_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, bool>',
    true,
  );
  static const MAP_SET_INT_INT = DartType._withName(
    'Map<Set<int>, int>',
    false,
  );
  static const MAP_SET_INT_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, int>',
    true,
  );
  static const MAP_SET_INT_STRING = DartType._withName(
    'Map<Set<int>, String>',
    false,
  );
  static const MAP_SET_INT_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, String>',
    true,
  );
  static const MAP_SET_INT_LIST_BOOL = DartType._withName(
    'Map<Set<int>, List<bool>>',
    false,
  );
  static const MAP_SET_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, List<bool>>',
    true,
  );
  static const MAP_SET_INT_LIST_DOUBLE = DartType._withName(
    'Map<Set<int>, List<double>>',
    false,
  );
  static const MAP_SET_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, List<double>>',
    true,
  );
  static const MAP_SET_INT_LIST_INT = DartType._withName(
    'Map<Set<int>, List<int>>',
    false,
  );
  static const MAP_SET_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, List<int>>',
    true,
  );
  static const MAP_SET_INT_LIST_STRING = DartType._withName(
    'Map<Set<int>, List<String>>',
    false,
  );
  static const MAP_SET_INT_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, List<String>>',
    true,
  );
  static const MAP_SET_INT_SET_BOOL = DartType._withName(
    'Map<Set<int>, Set<bool>>',
    false,
  );
  static const MAP_SET_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, Set<bool>>',
    true,
  );
  static const MAP_SET_INT_SET_DOUBLE = DartType._withName(
    'Map<Set<int>, Set<double>>',
    false,
  );
  static const MAP_SET_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, Set<double>>',
    true,
  );
  static const MAP_SET_INT_SET_STRING = DartType._withName(
    'Map<Set<int>, Set<String>>',
    false,
  );
  static const MAP_SET_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, Set<String>>',
    true,
  );
  static const MAP_SET_INT_EXPANDO_BOOL = DartType._withName(
    'Map<Set<int>, Expando<bool>>',
    false,
  );
  static const MAP_SET_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, Expando<bool>>',
    true,
  );
  static const MAP_SET_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<Set<int>, Expando<double>>',
    false,
  );
  static const MAP_SET_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, Expando<double>>',
    true,
  );
  static const MAP_SET_INT_EXPANDO_INT = DartType._withName(
    'Map<Set<int>, Expando<int>>',
    false,
  );
  static const MAP_SET_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, Expando<int>>',
    true,
  );
  static const MAP_SET_INT_EXPANDO_STRING = DartType._withName(
    'Map<Set<int>, Expando<String>>',
    false,
  );
  static const MAP_SET_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, Expando<String>>',
    true,
  );
  static const MAP_SET_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Set<int>, WeakReference<bool>>',
    false,
  );
  static const MAP_SET_INT_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, WeakReference<bool>>',
    true,
  );
  static const MAP_SET_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Set<int>, WeakReference<double>>',
    false,
  );
  static const MAP_SET_INT_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, WeakReference<double>>',
    true,
  );
  static const MAP_SET_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<Set<int>, WeakReference<int>>',
    false,
  );
  static const MAP_SET_INT_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, WeakReference<int>>',
    true,
  );
  static const MAP_SET_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<Set<int>, Map<bool, bool>>',
    false,
  );
  static const MAP_SET_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<bool, bool>>',
    true,
  );
  static const MAP_SET_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Set<int>, Map<bool, double>>',
    false,
  );
  static const MAP_SET_INT_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<bool, double>>',
    true,
  );
  static const MAP_SET_INT_MAP_BOOL_INT = DartType._withName(
    'Map<Set<int>, Map<bool, int>>',
    false,
  );
  static const MAP_SET_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<bool, int>>',
    true,
  );
  static const MAP_SET_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<Set<int>, Map<bool, String>>',
    false,
  );
  static const MAP_SET_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<bool, String>>',
    true,
  );
  static const MAP_SET_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Set<int>, Map<double, bool>>',
    false,
  );
  static const MAP_SET_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<double, bool>>',
    true,
  );
  static const MAP_SET_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Set<int>, Map<double, double>>',
    false,
  );
  static const MAP_SET_INT_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<double, double>>',
    true,
  );
  static const MAP_SET_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<Set<int>, Map<double, int>>',
    false,
  );
  static const MAP_SET_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<double, int>>',
    true,
  );
  static const MAP_SET_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Set<int>, Map<double, String>>',
    false,
  );
  static const MAP_SET_INT_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<double, String>>',
    true,
  );
  static const MAP_SET_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<Set<int>, Map<int, double>>',
    false,
  );
  static const MAP_SET_INT_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<int, double>>',
    true,
  );
  static const MAP_SET_INT_MAP_INT_INT = DartType._withName(
    'Map<Set<int>, Map<int, int>>',
    false,
  );
  static const MAP_SET_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<int, int>>',
    true,
  );
  static const MAP_SET_INT_MAP_INT_STRING = DartType._withName(
    'Map<Set<int>, Map<int, String>>',
    false,
  );
  static const MAP_SET_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<int, String>>',
    true,
  );
  static const MAP_SET_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<Set<int>, Map<String, bool>>',
    false,
  );
  static const MAP_SET_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<String, bool>>',
    true,
  );
  static const MAP_SET_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Set<int>, Map<String, double>>',
    false,
  );
  static const MAP_SET_INT_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<String, double>>',
    true,
  );
  static const MAP_SET_INT_MAP_STRING_INT = DartType._withName(
    'Map<Set<int>, Map<String, int>>',
    false,
  );
  static const MAP_SET_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<String, int>>',
    true,
  );
  static const MAP_SET_INT_MAP_STRING_STRING = DartType._withName(
    'Map<Set<int>, Map<String, String>>',
    false,
  );
  static const MAP_SET_INT_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, Map<String, String>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Set<int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Set<int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Set<int>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<bool, String>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Set<int>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<double, bool>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Set<int>, MapEntry<double, double>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<double, double>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Set<int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<double, int>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Set<int>, MapEntry<double, String>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<double, String>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Set<int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Set<int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<int, double>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Set<int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<int, String>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Set<int>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<String, bool>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Set<int>, MapEntry<String, double>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<String, double>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Set<int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<String, int>>',
    true,
  );
  static const MAP_SET_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Set<int>, MapEntry<String, String>>',
    false,
  );
  static const MAP_SET_INT_MAPENTRY_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Set<int>, MapEntry<String, String>>',
    true,
  );
  static const MAP_SET_STRING_BOOL = DartType._withName(
    'Map<Set<String>, bool>',
    false,
  );
  static const MAP_SET_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, bool>',
    true,
  );
  static const MAP_SET_STRING_DOUBLE = DartType._withName(
    'Map<Set<String>, double>',
    false,
  );
  static const MAP_SET_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<String>, double>',
    true,
  );
  static const MAP_SET_STRING_INT = DartType._withName(
    'Map<Set<String>, int>',
    false,
  );
  static const MAP_SET_STRING_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, int>',
    true,
  );
  static const MAP_SET_STRING_STRING = DartType._withName(
    'Map<Set<String>, String>',
    false,
  );
  static const MAP_SET_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Set<String>, String>',
    true,
  );
  static const MAP_SET_STRING_LIST_DOUBLE = DartType._withName(
    'Map<Set<String>, List<double>>',
    false,
  );
  static const MAP_SET_STRING_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<String>, List<double>>',
    true,
  );
  static const MAP_SET_STRING_LIST_INT = DartType._withName(
    'Map<Set<String>, List<int>>',
    false,
  );
  static const MAP_SET_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, List<int>>',
    true,
  );
  static const MAP_SET_STRING_LIST_STRING = DartType._withName(
    'Map<Set<String>, List<String>>',
    false,
  );
  static const MAP_SET_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Set<String>, List<String>>',
    true,
  );
  static const MAP_SET_STRING_SET_BOOL = DartType._withName(
    'Map<Set<String>, Set<bool>>',
    false,
  );
  static const MAP_SET_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, Set<bool>>',
    true,
  );
  static const MAP_SET_STRING_SET_DOUBLE = DartType._withName(
    'Map<Set<String>, Set<double>>',
    false,
  );
  static const MAP_SET_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<String>, Set<double>>',
    true,
  );
  static const MAP_SET_STRING_SET_INT = DartType._withName(
    'Map<Set<String>, Set<int>>',
    false,
  );
  static const MAP_SET_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, Set<int>>',
    true,
  );
  static const MAP_SET_STRING_SET_STRING = DartType._withName(
    'Map<Set<String>, Set<String>>',
    false,
  );
  static const MAP_SET_STRING_SET_STRING_NULLABLE = DartType._withName(
    'Map<Set<String>, Set<String>>',
    true,
  );
  static const MAP_SET_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<Set<String>, Expando<bool>>',
    false,
  );
  static const MAP_SET_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, Expando<bool>>',
    true,
  );
  static const MAP_SET_STRING_EXPANDO_INT = DartType._withName(
    'Map<Set<String>, Expando<int>>',
    false,
  );
  static const MAP_SET_STRING_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, Expando<int>>',
    true,
  );
  static const MAP_SET_STRING_EXPANDO_STRING = DartType._withName(
    'Map<Set<String>, Expando<String>>',
    false,
  );
  static const MAP_SET_STRING_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Set<String>, Expando<String>>',
    true,
  );
  static const MAP_SET_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Set<String>, WeakReference<bool>>',
    false,
  );
  static const MAP_SET_STRING_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, WeakReference<bool>>',
    true,
  );
  static const MAP_SET_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Set<String>, WeakReference<double>>',
    false,
  );
  static const MAP_SET_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Set<String>, WeakReference<double>>', true);
  static const MAP_SET_STRING_WEAKREFERENCE_INT = DartType._withName(
    'Map<Set<String>, WeakReference<int>>',
    false,
  );
  static const MAP_SET_STRING_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, WeakReference<int>>',
    true,
  );
  static const MAP_SET_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Set<String>, WeakReference<String>>',
    false,
  );
  static const MAP_SET_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Set<String>, WeakReference<String>>', true);
  static const MAP_SET_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<Set<String>, Map<bool, bool>>',
    false,
  );
  static const MAP_SET_STRING_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<bool, bool>>',
    true,
  );
  static const MAP_SET_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Set<String>, Map<bool, double>>',
    false,
  );
  static const MAP_SET_STRING_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<bool, double>>',
    true,
  );
  static const MAP_SET_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<Set<String>, Map<bool, String>>',
    false,
  );
  static const MAP_SET_STRING_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<bool, String>>',
    true,
  );
  static const MAP_SET_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Set<String>, Map<double, bool>>',
    false,
  );
  static const MAP_SET_STRING_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<double, bool>>',
    true,
  );
  static const MAP_SET_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Set<String>, Map<double, double>>',
    false,
  );
  static const MAP_SET_STRING_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<double, double>>',
    true,
  );
  static const MAP_SET_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<Set<String>, Map<double, int>>',
    false,
  );
  static const MAP_SET_STRING_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<double, int>>',
    true,
  );
  static const MAP_SET_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Set<String>, Map<double, String>>',
    false,
  );
  static const MAP_SET_STRING_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<double, String>>',
    true,
  );
  static const MAP_SET_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<Set<String>, Map<int, bool>>',
    false,
  );
  static const MAP_SET_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<int, bool>>',
    true,
  );
  static const MAP_SET_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<Set<String>, Map<int, double>>',
    false,
  );
  static const MAP_SET_STRING_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<int, double>>',
    true,
  );
  static const MAP_SET_STRING_MAP_INT_INT = DartType._withName(
    'Map<Set<String>, Map<int, int>>',
    false,
  );
  static const MAP_SET_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<int, int>>',
    true,
  );
  static const MAP_SET_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<Set<String>, Map<String, bool>>',
    false,
  );
  static const MAP_SET_STRING_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<String, bool>>',
    true,
  );
  static const MAP_SET_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Set<String>, Map<String, double>>',
    false,
  );
  static const MAP_SET_STRING_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<String, double>>',
    true,
  );
  static const MAP_SET_STRING_MAP_STRING_INT = DartType._withName(
    'Map<Set<String>, Map<String, int>>',
    false,
  );
  static const MAP_SET_STRING_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<String, int>>',
    true,
  );
  static const MAP_SET_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<Set<String>, Map<String, String>>',
    false,
  );
  static const MAP_SET_STRING_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Set<String>, Map<String, String>>',
    true,
  );
  static const MAP_SET_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Set<String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_SET_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Set<String>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Set<String>, MapEntry<bool, double>>', true);
  static const MAP_SET_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Set<String>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_SET_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Set<String>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Set<String>, MapEntry<bool, String>>', true);
  static const MAP_SET_STRING_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Set<String>, MapEntry<double, double>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Set<String>, MapEntry<double, double>>', true);
  static const MAP_SET_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Set<String>, MapEntry<double, int>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, MapEntry<double, int>>',
    true,
  );
  static const MAP_SET_STRING_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Set<String>, MapEntry<double, String>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Set<String>, MapEntry<double, String>>', true);
  static const MAP_SET_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Set<String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Set<String>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_SET_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Set<String>, MapEntry<int, double>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Set<String>, MapEntry<int, double>>',
    true,
  );
  static const MAP_SET_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<Set<String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, MapEntry<int, int>>',
    true,
  );
  static const MAP_SET_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Set<String>, MapEntry<int, String>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'Map<Set<String>, MapEntry<int, String>>',
    true,
  );
  static const MAP_SET_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Set<String>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Set<String>, MapEntry<String, bool>>', true);
  static const MAP_SET_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Set<String>, MapEntry<String, int>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'Map<Set<String>, MapEntry<String, int>>',
    true,
  );
  static const MAP_SET_STRING_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Set<String>, MapEntry<String, String>>',
    false,
  );
  static const MAP_SET_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<Set<String>, MapEntry<String, String>>', true);
  static const MAP_EXPANDO_BOOL_BOOL = DartType._withName(
    'Map<Expando<bool>, bool>',
    false,
  );
  static const MAP_EXPANDO_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<bool>, bool>',
    true,
  );
  static const MAP_EXPANDO_BOOL_DOUBLE = DartType._withName(
    'Map<Expando<bool>, double>',
    false,
  );
  static const MAP_EXPANDO_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<bool>, double>',
    true,
  );
  static const MAP_EXPANDO_BOOL_INT = DartType._withName(
    'Map<Expando<bool>, int>',
    false,
  );
  static const MAP_EXPANDO_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Expando<bool>, int>',
    true,
  );
  static const MAP_EXPANDO_BOOL_STRING = DartType._withName(
    'Map<Expando<bool>, String>',
    false,
  );
  static const MAP_EXPANDO_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Expando<bool>, String>',
    true,
  );
  static const MAP_EXPANDO_BOOL_LIST_BOOL = DartType._withName(
    'Map<Expando<bool>, List<bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<bool>, List<bool>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<Expando<bool>, List<double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<bool>, List<double>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_LIST_STRING = DartType._withName(
    'Map<Expando<bool>, List<String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Expando<bool>, List<String>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_SET_BOOL = DartType._withName(
    'Map<Expando<bool>, Set<bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Set<bool>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_SET_DOUBLE = DartType._withName(
    'Map<Expando<bool>, Set<double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Set<double>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_SET_INT = DartType._withName(
    'Map<Expando<bool>, Set<int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Set<int>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_SET_STRING = DartType._withName(
    'Map<Expando<bool>, Set<String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Set<String>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<Expando<bool>, Expando<bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Expando<bool>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<Expando<bool>, Expando<double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Expando<double>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_EXPANDO_INT = DartType._withName(
    'Map<Expando<bool>, Expando<int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Expando<int>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Expando<bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Expando<bool>, WeakReference<bool>>', true);
  static const MAP_EXPANDO_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Expando<bool>, WeakReference<double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<bool>, WeakReference<double>>', true);
  static const MAP_EXPANDO_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<Expando<bool>, WeakReference<int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<Expando<bool>, WeakReference<int>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Expando<bool>, WeakReference<String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Expando<bool>, WeakReference<String>>', true);
  static const MAP_EXPANDO_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<Expando<bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<bool, bool>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Expando<bool>, Map<bool, double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<bool, double>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<Expando<bool>, Map<bool, int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<bool, int>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<Expando<bool>, Map<bool, String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<bool, String>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Expando<bool>, Map<double, double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<double, double>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<Expando<bool>, Map<double, int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<double, int>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Expando<bool>, Map<double, String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<double, String>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<Expando<bool>, Map<int, bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<int, bool>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<Expando<bool>, Map<int, double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<int, double>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_INT_INT = DartType._withName(
    'Map<Expando<bool>, Map<int, int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<int, int>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<Expando<bool>, Map<int, String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<int, String>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<Expando<bool>, Map<String, bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<String, bool>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Expando<bool>, Map<String, double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<String, double>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<Expando<bool>, Map<String, String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Expando<bool>, Map<String, String>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Expando<bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<bool, bool>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Expando<bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<bool, double>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Expando<bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Expando<bool>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Expando<bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<bool, String>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Expando<bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<double, bool>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Expando<bool>, MapEntry<double, double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<double, double>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Expando<bool>, MapEntry<double, int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<double, int>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Expando<bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<bool>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Expando<bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<int, double>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<Expando<bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<Expando<bool>, MapEntry<int, int>>',
    true,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Expando<bool>, MapEntry<int, String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<int, String>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Expando<bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<String, bool>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Expando<bool>, MapEntry<String, double>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<String, double>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Expando<bool>, MapEntry<String, int>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<String, int>>', true);
  static const MAP_EXPANDO_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Expando<bool>, MapEntry<String, String>>',
    false,
  );
  static const MAP_EXPANDO_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<Expando<bool>, MapEntry<String, String>>', true);
  static const MAP_EXPANDO_DOUBLE_DOUBLE = DartType._withName(
    'Map<Expando<double>, double>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<double>, double>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_INT = DartType._withName(
    'Map<Expando<double>, int>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Expando<double>, int>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_STRING = DartType._withName(
    'Map<Expando<double>, String>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Expando<double>, String>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<Expando<double>, List<bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<double>, List<bool>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<Expando<double>, List<double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<double>, List<double>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_LIST_INT = DartType._withName(
    'Map<Expando<double>, List<int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<Expando<double>, List<int>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_LIST_STRING = DartType._withName(
    'Map<Expando<double>, List<String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Expando<double>, List<String>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_SET_BOOL = DartType._withName(
    'Map<Expando<double>, Set<bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<double>, Set<bool>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_SET_INT = DartType._withName(
    'Map<Expando<double>, Set<int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<Expando<double>, Set<int>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_SET_STRING = DartType._withName(
    'Map<Expando<double>, Set<String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'Map<Expando<double>, Set<String>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<Expando<double>, Expando<bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<double>, Expando<bool>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<Expando<double>, Expando<double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<double>, Expando<double>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<Expando<double>, Expando<int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Expando<double>, Expando<int>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<Expando<double>, Expando<String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Expando<double>, Expando<String>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Expando<double>, WeakReference<bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Expando<double>, WeakReference<bool>>', true);
  static const MAP_EXPANDO_DOUBLE_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Expando<double>, WeakReference<double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<double>, WeakReference<double>>', true);
  static const MAP_EXPANDO_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Expando<double>, WeakReference<String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Expando<double>, WeakReference<String>>', true);
  static const MAP_EXPANDO_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<Expando<double>, Map<bool, bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<bool, bool>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Expando<double>, Map<bool, double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<bool, double>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<Expando<double>, Map<bool, int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<bool, int>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<Expando<double>, Map<bool, String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<bool, String>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Expando<double>, Map<double, bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<double, bool>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Expando<double>, Map<double, double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<double>, Map<double, double>>', true);
  static const MAP_EXPANDO_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<Expando<double>, Map<double, int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<double, int>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<Expando<double>, Map<int, bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<int, bool>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<Expando<double>, Map<int, double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<int, double>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<Expando<double>, Map<int, int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<int, int>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<Expando<double>, Map<int, String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<int, String>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<Expando<double>, Map<String, bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<String, bool>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Expando<double>, Map<String, double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<double>, Map<String, double>>', true);
  static const MAP_EXPANDO_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<Expando<double>, Map<String, int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Expando<double>, Map<String, int>>',
    true,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<Expando<double>, Map<String, String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Expando<double>, Map<String, String>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Expando<double>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<bool, double>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Expando<double>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<bool, int>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Expando<double>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<bool, String>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Expando<double>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<double, bool>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Expando<double>, MapEntry<double, double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Expando<double>, MapEntry<double, double>>',
        true,
      );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Expando<double>, MapEntry<double, int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<double, int>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Expando<double>, MapEntry<double, String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Expando<double>, MapEntry<double, String>>',
        true,
      );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Expando<double>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<int, bool>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<Expando<double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<int, int>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Expando<double>, MapEntry<int, String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<int, String>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Expando<double>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<String, bool>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Expando<double>, MapEntry<String, double>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Expando<double>, MapEntry<String, double>>',
        true,
      );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Expando<double>, MapEntry<String, int>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Expando<double>, MapEntry<String, int>>', true);
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Expando<double>, MapEntry<String, String>>',
    false,
  );
  static const MAP_EXPANDO_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Expando<double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_EXPANDO_INT_BOOL = DartType._withName(
    'Map<Expando<int>, bool>',
    false,
  );
  static const MAP_EXPANDO_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, bool>',
    true,
  );
  static const MAP_EXPANDO_INT_DOUBLE = DartType._withName(
    'Map<Expando<int>, double>',
    false,
  );
  static const MAP_EXPANDO_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<int>, double>',
    true,
  );
  static const MAP_EXPANDO_INT_INT = DartType._withName(
    'Map<Expando<int>, int>',
    false,
  );
  static const MAP_EXPANDO_INT_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, int>',
    true,
  );
  static const MAP_EXPANDO_INT_LIST_BOOL = DartType._withName(
    'Map<Expando<int>, List<bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, List<bool>>',
    true,
  );
  static const MAP_EXPANDO_INT_LIST_DOUBLE = DartType._withName(
    'Map<Expando<int>, List<double>>',
    false,
  );
  static const MAP_EXPANDO_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<int>, List<double>>',
    true,
  );
  static const MAP_EXPANDO_INT_LIST_INT = DartType._withName(
    'Map<Expando<int>, List<int>>',
    false,
  );
  static const MAP_EXPANDO_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, List<int>>',
    true,
  );
  static const MAP_EXPANDO_INT_LIST_STRING = DartType._withName(
    'Map<Expando<int>, List<String>>',
    false,
  );
  static const MAP_EXPANDO_INT_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Expando<int>, List<String>>',
    true,
  );
  static const MAP_EXPANDO_INT_SET_BOOL = DartType._withName(
    'Map<Expando<int>, Set<bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, Set<bool>>',
    true,
  );
  static const MAP_EXPANDO_INT_SET_DOUBLE = DartType._withName(
    'Map<Expando<int>, Set<double>>',
    false,
  );
  static const MAP_EXPANDO_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<int>, Set<double>>',
    true,
  );
  static const MAP_EXPANDO_INT_SET_INT = DartType._withName(
    'Map<Expando<int>, Set<int>>',
    false,
  );
  static const MAP_EXPANDO_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, Set<int>>',
    true,
  );
  static const MAP_EXPANDO_INT_SET_STRING = DartType._withName(
    'Map<Expando<int>, Set<String>>',
    false,
  );
  static const MAP_EXPANDO_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<Expando<int>, Set<String>>',
    true,
  );
  static const MAP_EXPANDO_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<Expando<int>, Expando<double>>',
    false,
  );
  static const MAP_EXPANDO_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<int>, Expando<double>>',
    true,
  );
  static const MAP_EXPANDO_INT_EXPANDO_INT = DartType._withName(
    'Map<Expando<int>, Expando<int>>',
    false,
  );
  static const MAP_EXPANDO_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, Expando<int>>',
    true,
  );
  static const MAP_EXPANDO_INT_EXPANDO_STRING = DartType._withName(
    'Map<Expando<int>, Expando<String>>',
    false,
  );
  static const MAP_EXPANDO_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Expando<int>, Expando<String>>',
    true,
  );
  static const MAP_EXPANDO_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Expando<int>, WeakReference<bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, WeakReference<bool>>',
    true,
  );
  static const MAP_EXPANDO_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Expando<int>, WeakReference<double>>',
    false,
  );
  static const MAP_EXPANDO_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<int>, WeakReference<double>>', true);
  static const MAP_EXPANDO_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<Expando<int>, WeakReference<int>>',
    false,
  );
  static const MAP_EXPANDO_INT_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, WeakReference<int>>',
    true,
  );
  static const MAP_EXPANDO_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Expando<int>, WeakReference<String>>',
    false,
  );
  static const MAP_EXPANDO_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Expando<int>, WeakReference<String>>', true);
  static const MAP_EXPANDO_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<Expando<int>, Map<bool, bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<bool, bool>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_BOOL_INT = DartType._withName(
    'Map<Expando<int>, Map<bool, int>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<bool, int>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<Expando<int>, Map<bool, String>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<bool, String>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Expando<int>, Map<double, bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<double, bool>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Expando<int>, Map<double, double>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<double, double>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<Expando<int>, Map<double, int>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<double, int>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Expando<int>, Map<double, String>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<double, String>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_INT_BOOL = DartType._withName(
    'Map<Expando<int>, Map<int, bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<int, bool>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<Expando<int>, Map<int, double>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<int, double>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_INT_STRING = DartType._withName(
    'Map<Expando<int>, Map<int, String>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<int, String>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<Expando<int>, Map<String, bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<String, bool>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Expando<int>, Map<String, double>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<String, double>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_STRING_INT = DartType._withName(
    'Map<Expando<int>, Map<String, int>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<String, int>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAP_STRING_STRING = DartType._withName(
    'Map<Expando<int>, Map<String, String>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Expando<int>, Map<String, String>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Expando<int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Expando<int>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<bool, double>>', true);
  static const MAP_EXPANDO_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Expando<int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Expando<int>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<double, bool>>', true);
  static const MAP_EXPANDO_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Expando<int>, MapEntry<double, double>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<double, double>>', true);
  static const MAP_EXPANDO_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Expando<int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<double, int>>', true);
  static const MAP_EXPANDO_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Expando<int>, MapEntry<double, String>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<double, String>>', true);
  static const MAP_EXPANDO_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Expando<int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<int>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Expando<int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<int, double>>', true);
  static const MAP_EXPANDO_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<Expando<int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<Expando<int>, MapEntry<int, int>>',
    true,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Expando<int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<int, String>>', true);
  static const MAP_EXPANDO_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Expando<int>, MapEntry<String, double>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<String, double>>', true);
  static const MAP_EXPANDO_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Expando<int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<String, int>>', true);
  static const MAP_EXPANDO_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Expando<int>, MapEntry<String, String>>',
    false,
  );
  static const MAP_EXPANDO_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<Expando<int>, MapEntry<String, String>>', true);
  static const MAP_EXPANDO_STRING_BOOL = DartType._withName(
    'Map<Expando<String>, bool>',
    false,
  );
  static const MAP_EXPANDO_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<String>, bool>',
    true,
  );
  static const MAP_EXPANDO_STRING_DOUBLE = DartType._withName(
    'Map<Expando<String>, double>',
    false,
  );
  static const MAP_EXPANDO_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<String>, double>',
    true,
  );
  static const MAP_EXPANDO_STRING_INT = DartType._withName(
    'Map<Expando<String>, int>',
    false,
  );
  static const MAP_EXPANDO_STRING_INT_NULLABLE = DartType._withName(
    'Map<Expando<String>, int>',
    true,
  );
  static const MAP_EXPANDO_STRING_STRING = DartType._withName(
    'Map<Expando<String>, String>',
    false,
  );
  static const MAP_EXPANDO_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Expando<String>, String>',
    true,
  );
  static const MAP_EXPANDO_STRING_LIST_BOOL = DartType._withName(
    'Map<Expando<String>, List<bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<String>, List<bool>>',
    true,
  );
  static const MAP_EXPANDO_STRING_LIST_INT = DartType._withName(
    'Map<Expando<String>, List<int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<Expando<String>, List<int>>',
    true,
  );
  static const MAP_EXPANDO_STRING_LIST_STRING = DartType._withName(
    'Map<Expando<String>, List<String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Expando<String>, List<String>>',
    true,
  );
  static const MAP_EXPANDO_STRING_SET_BOOL = DartType._withName(
    'Map<Expando<String>, Set<bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<String>, Set<bool>>',
    true,
  );
  static const MAP_EXPANDO_STRING_SET_DOUBLE = DartType._withName(
    'Map<Expando<String>, Set<double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<String>, Set<double>>',
    true,
  );
  static const MAP_EXPANDO_STRING_SET_INT = DartType._withName(
    'Map<Expando<String>, Set<int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<Expando<String>, Set<int>>',
    true,
  );
  static const MAP_EXPANDO_STRING_SET_STRING = DartType._withName(
    'Map<Expando<String>, Set<String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_SET_STRING_NULLABLE = DartType._withName(
    'Map<Expando<String>, Set<String>>',
    true,
  );
  static const MAP_EXPANDO_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<Expando<String>, Expando<bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<String>, Expando<bool>>',
    true,
  );
  static const MAP_EXPANDO_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<Expando<String>, Expando<double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<String>, Expando<double>>',
    true,
  );
  static const MAP_EXPANDO_STRING_EXPANDO_STRING = DartType._withName(
    'Map<Expando<String>, Expando<String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Expando<String>, Expando<String>>',
    true,
  );
  static const MAP_EXPANDO_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Expando<String>, WeakReference<bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Expando<String>, WeakReference<bool>>', true);
  static const MAP_EXPANDO_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Expando<String>, WeakReference<double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<String>, WeakReference<double>>', true);
  static const MAP_EXPANDO_STRING_WEAKREFERENCE_INT = DartType._withName(
    'Map<Expando<String>, WeakReference<int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Expando<String>, WeakReference<int>>', true);
  static const MAP_EXPANDO_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Expando<String>, WeakReference<String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Expando<String>, WeakReference<String>>', true);
  static const MAP_EXPANDO_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<Expando<String>, Map<bool, bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<bool, bool>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Expando<String>, Map<bool, double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<bool, double>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<Expando<String>, Map<bool, int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<bool, int>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Expando<String>, Map<double, bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<double, bool>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Expando<String>, Map<double, double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<String>, Map<double, double>>', true);
  static const MAP_EXPANDO_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<Expando<String>, Map<double, int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<double, int>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Expando<String>, Map<double, String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Expando<String>, Map<double, String>>', true);
  static const MAP_EXPANDO_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<Expando<String>, Map<int, bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<int, bool>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<Expando<String>, Map<int, double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<int, double>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_INT_INT = DartType._withName(
    'Map<Expando<String>, Map<int, int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<int, int>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_INT_STRING = DartType._withName(
    'Map<Expando<String>, Map<int, String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<int, String>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<Expando<String>, Map<String, bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<String, bool>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_STRING_INT = DartType._withName(
    'Map<Expando<String>, Map<String, int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Expando<String>, Map<String, int>>',
    true,
  );
  static const MAP_EXPANDO_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<Expando<String>, Map<String, String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Expando<String>, Map<String, String>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Expando<String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<bool, bool>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Expando<String>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<bool, double>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Expando<String>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<bool, int>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Expando<String>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<bool, String>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Expando<String>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<double, bool>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Expando<String>, MapEntry<double, double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Expando<String>, MapEntry<double, double>>',
        true,
      );
  static const MAP_EXPANDO_STRING_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Expando<String>, MapEntry<double, String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Expando<String>, MapEntry<double, String>>',
        true,
      );
  static const MAP_EXPANDO_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Expando<String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<int, bool>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Expando<String>, MapEntry<int, double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<int, double>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<Expando<String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<int, int>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Expando<String>, MapEntry<int, String>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<int, String>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Expando<String>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<String, bool>>', true);
  static const MAP_EXPANDO_STRING_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Expando<String>, MapEntry<String, double>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Expando<String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_EXPANDO_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Expando<String>, MapEntry<String, int>>',
    false,
  );
  static const MAP_EXPANDO_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Expando<String>, MapEntry<String, int>>', true);
  static const MAP_WEAKREFERENCE_BOOL_BOOL = DartType._withName(
    'Map<WeakReference<bool>, bool>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, bool>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, double>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, double>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_INT = DartType._withName(
    'Map<WeakReference<bool>, int>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, int>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_STRING = DartType._withName(
    'Map<WeakReference<bool>, String>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, String>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_LIST_BOOL = DartType._withName(
    'Map<WeakReference<bool>, List<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, List<bool>>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, List<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, List<double>>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_LIST_INT = DartType._withName(
    'Map<WeakReference<bool>, List<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, List<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_LIST_STRING = DartType._withName(
    'Map<WeakReference<bool>, List<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, List<String>>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_SET_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, Set<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, Set<double>>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_SET_INT = DartType._withName(
    'Map<WeakReference<bool>, Set<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, Set<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_SET_STRING = DartType._withName(
    'Map<WeakReference<bool>, Set<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, Set<String>>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<WeakReference<bool>, Expando<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Expando<bool>>', true);
  static const MAP_WEAKREFERENCE_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, Expando<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Expando<double>>', true);
  static const MAP_WEAKREFERENCE_BOOL_EXPANDO_INT = DartType._withName(
    'Map<WeakReference<bool>, Expando<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, Expando<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<WeakReference<bool>, Expando<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Expando<String>>', true);
  static const MAP_WEAKREFERENCE_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<WeakReference<bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, WeakReference<bool>>', true);
  static const MAP_WEAKREFERENCE_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<WeakReference<bool>, WeakReference<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, WeakReference<int>>', true);
  static const MAP_WEAKREFERENCE_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'Map<WeakReference<bool>, WeakReference<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, WeakReference<String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<WeakReference<bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<bool, bool>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, Map<bool, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<bool, double>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<WeakReference<bool>, Map<bool, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<bool, int>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<WeakReference<bool>, Map<bool, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<bool, String>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<WeakReference<bool>, Map<double, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<double, bool>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, Map<double, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<double, double>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<WeakReference<bool>, Map<double, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<double, String>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<WeakReference<bool>, Map<int, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<int, bool>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, Map<int, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<int, double>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_INT_INT = DartType._withName(
    'Map<WeakReference<bool>, Map<int, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<bool>, Map<int, int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<WeakReference<bool>, Map<int, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<int, String>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<WeakReference<bool>, Map<String, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<String, bool>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, Map<String, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<String, double>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<WeakReference<bool>, Map<String, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, Map<String, int>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, MapEntry<bool, int>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<double, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<double, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<double, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<double, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<double, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<double, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<int, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<WeakReference<bool>, MapEntry<int, int>>', true);
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<int, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<int, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<String, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<String, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<WeakReference<bool>, MapEntry<String, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<String, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<String, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<bool>, MapEntry<String, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_BOOL = DartType._withName(
    'Map<WeakReference<double>, bool>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<double>, bool>',
    true,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_DOUBLE = DartType._withName(
    'Map<WeakReference<double>, double>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<WeakReference<double>, double>',
    true,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_STRING = DartType._withName(
    'Map<WeakReference<double>, String>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<WeakReference<double>, String>',
    true,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<WeakReference<double>, List<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<double>, List<bool>>',
    true,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<WeakReference<double>, List<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<double>, List<double>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_LIST_INT = DartType._withName(
    'Map<WeakReference<double>, List<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<double>, List<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_LIST_STRING = DartType._withName(
    'Map<WeakReference<double>, List<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_LIST_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<double>, List<String>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_SET_BOOL = DartType._withName(
    'Map<WeakReference<double>, Set<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<double>, Set<bool>>',
    true,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<WeakReference<double>, Set<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_SET_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Set<double>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_SET_INT = DartType._withName(
    'Map<WeakReference<double>, Set<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<double>, Set<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<WeakReference<double>, Expando<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Expando<bool>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<WeakReference<double>, Expando<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Expando<double>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<WeakReference<double>, Expando<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Expando<int>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<WeakReference<double>, Expando<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Expando<String>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<WeakReference<double>, WeakReference<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, WeakReference<bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<WeakReference<double>, WeakReference<double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, WeakReference<double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<WeakReference<double>, WeakReference<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, WeakReference<int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<WeakReference<double>, WeakReference<String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, WeakReference<String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<WeakReference<double>, Map<bool, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<bool, double>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<WeakReference<double>, Map<bool, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<bool, int>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<WeakReference<double>, Map<bool, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<bool, String>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<WeakReference<double>, Map<double, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<double, bool>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<WeakReference<double>, Map<double, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, Map<double, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<WeakReference<double>, Map<double, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<double, int>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'Map<WeakReference<double>, Map<double, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, Map<double, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<WeakReference<double>, Map<int, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<int, bool>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<WeakReference<double>, Map<int, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<int, int>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<WeakReference<double>, Map<int, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<int, String>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<WeakReference<double>, Map<String, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<String, bool>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<WeakReference<double>, Map<String, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, Map<String, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<WeakReference<double>, Map<String, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<WeakReference<double>, Map<String, int>>', true);
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<WeakReference<double>, Map<String, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, Map<String, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<WeakReference<double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<double, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<double, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<double, int>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<double, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<double, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<double, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<WeakReference<double>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<int, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<int, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<WeakReference<double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<int, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<String, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<String, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<String, int>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<String, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<String, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_BOOL = DartType._withName(
    'Map<WeakReference<int>, bool>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, bool>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, double>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, double>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_INT = DartType._withName(
    'Map<WeakReference<int>, int>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, int>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_STRING = DartType._withName(
    'Map<WeakReference<int>, String>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_STRING_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, String>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_LIST_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, List<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, List<double>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_LIST_INT = DartType._withName(
    'Map<WeakReference<int>, List<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, List<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_LIST_STRING = DartType._withName(
    'Map<WeakReference<int>, List<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_LIST_STRING_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, List<String>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_SET_BOOL = DartType._withName(
    'Map<WeakReference<int>, Set<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, Set<bool>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_SET_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, Set<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, Set<double>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_SET_INT = DartType._withName(
    'Map<WeakReference<int>, Set<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, Set<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_SET_STRING = DartType._withName(
    'Map<WeakReference<int>, Set<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, Set<String>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_EXPANDO_BOOL = DartType._withName(
    'Map<WeakReference<int>, Expando<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, Expando<bool>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_EXPANDO_INT = DartType._withName(
    'Map<WeakReference<int>, Expando<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, Expando<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_EXPANDO_STRING = DartType._withName(
    'Map<WeakReference<int>, Expando<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Expando<String>>', true);
  static const MAP_WEAKREFERENCE_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<WeakReference<int>, WeakReference<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<int>, WeakReference<bool>>', true);
  static const MAP_WEAKREFERENCE_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, WeakReference<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, WeakReference<double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<WeakReference<int>, WeakReference<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<WeakReference<int>, WeakReference<int>>', true);
  static const MAP_WEAKREFERENCE_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<WeakReference<int>, WeakReference<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, WeakReference<String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<WeakReference<int>, Map<bool, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<bool, bool>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, Map<bool, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<bool, double>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<WeakReference<int>, Map<bool, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<bool, String>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<WeakReference<int>, Map<double, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<double, bool>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, Map<double, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<double, double>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<WeakReference<int>, Map<double, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<double, int>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<WeakReference<int>, Map<double, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<double, String>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_INT_BOOL = DartType._withName(
    'Map<WeakReference<int>, Map<int, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, Map<int, bool>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, Map<int, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<int, double>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_INT_INT = DartType._withName(
    'Map<WeakReference<int>, Map<int, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<int>, Map<int, int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_INT_STRING = DartType._withName(
    'Map<WeakReference<int>, Map<int, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<int, String>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, Map<String, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<String, double>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_STRING_INT = DartType._withName(
    'Map<WeakReference<int>, Map<String, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<String, int>>', true);
  static const MAP_WEAKREFERENCE_INT_MAP_STRING_STRING = DartType._withName(
    'Map<WeakReference<int>, Map<String, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<int>, Map<String, String>>', true);
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<WeakReference<int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<int>, MapEntry<bool, bool>>', true);
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<WeakReference<int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<WeakReference<int>, MapEntry<bool, int>>', true);
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<WeakReference<int>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<WeakReference<int>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<WeakReference<int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<double, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<double, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<double, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<WeakReference<int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<int>, MapEntry<int, bool>>', true);
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<WeakReference<int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<int, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<WeakReference<int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<WeakReference<int>, MapEntry<int, int>>', true);
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<WeakReference<int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<int, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<WeakReference<int>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<String, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<String, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<String, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<int>, MapEntry<String, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_BOOL = DartType._withName(
    'Map<WeakReference<String>, bool>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<String>, bool>',
    true,
  );
  static const MAP_WEAKREFERENCE_STRING_DOUBLE = DartType._withName(
    'Map<WeakReference<String>, double>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<WeakReference<String>, double>',
    true,
  );
  static const MAP_WEAKREFERENCE_STRING_INT = DartType._withName(
    'Map<WeakReference<String>, int>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<String>, int>',
    true,
  );
  static const MAP_WEAKREFERENCE_STRING_STRING = DartType._withName(
    'Map<WeakReference<String>, String>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_STRING_NULLABLE = DartType._withName(
    'Map<WeakReference<String>, String>',
    true,
  );
  static const MAP_WEAKREFERENCE_STRING_LIST_BOOL = DartType._withName(
    'Map<WeakReference<String>, List<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<String>, List<bool>>',
    true,
  );
  static const MAP_WEAKREFERENCE_STRING_LIST_DOUBLE = DartType._withName(
    'Map<WeakReference<String>, List<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<String>, List<double>>', true);
  static const MAP_WEAKREFERENCE_STRING_LIST_INT = DartType._withName(
    'Map<WeakReference<String>, List<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<String>, List<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_STRING_SET_BOOL = DartType._withName(
    'Map<WeakReference<String>, Set<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<WeakReference<String>, Set<bool>>',
    true,
  );
  static const MAP_WEAKREFERENCE_STRING_SET_DOUBLE = DartType._withName(
    'Map<WeakReference<String>, Set<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_SET_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Set<double>>', true);
  static const MAP_WEAKREFERENCE_STRING_SET_INT = DartType._withName(
    'Map<WeakReference<String>, Set<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<WeakReference<String>, Set<int>>',
    true,
  );
  static const MAP_WEAKREFERENCE_STRING_SET_STRING = DartType._withName(
    'Map<WeakReference<String>, Set<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_SET_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Set<String>>', true);
  static const MAP_WEAKREFERENCE_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<WeakReference<String>, Expando<bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Expando<bool>>', true);
  static const MAP_WEAKREFERENCE_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<WeakReference<String>, Expando<double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Expando<double>>', true);
  static const MAP_WEAKREFERENCE_STRING_EXPANDO_INT = DartType._withName(
    'Map<WeakReference<String>, Expando<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Expando<int>>', true);
  static const MAP_WEAKREFERENCE_STRING_EXPANDO_STRING = DartType._withName(
    'Map<WeakReference<String>, Expando<String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Expando<String>>', true);
  static const MAP_WEAKREFERENCE_STRING_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<WeakReference<String>, WeakReference<double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, WeakReference<double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_WEAKREFERENCE_INT = DartType._withName(
    'Map<WeakReference<String>, WeakReference<int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, WeakReference<int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<WeakReference<String>, WeakReference<String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, WeakReference<String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<WeakReference<String>, Map<bool, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<bool, bool>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<WeakReference<String>, Map<bool, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<bool, double>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<WeakReference<String>, Map<bool, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<bool, int>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<WeakReference<String>, Map<bool, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<bool, String>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<WeakReference<String>, Map<double, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<double, bool>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<WeakReference<String>, Map<double, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<double, int>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<WeakReference<String>, Map<double, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, Map<double, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<WeakReference<String>, Map<int, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<int, bool>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<WeakReference<String>, Map<int, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<int, double>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_INT_INT = DartType._withName(
    'Map<WeakReference<String>, Map<int, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<int, int>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_INT_STRING = DartType._withName(
    'Map<WeakReference<String>, Map<int, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<int, String>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<WeakReference<String>, Map<String, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<WeakReference<String>, Map<String, bool>>', true);
  static const MAP_WEAKREFERENCE_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<WeakReference<String>, Map<String, double>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, Map<String, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<WeakReference<String>, Map<String, String>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, Map<String, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<WeakReference<String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<WeakReference<String>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<double, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<double, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<double, int>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<double, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<WeakReference<String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<int, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<int, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<WeakReference<String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<int, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_INT_STRING =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<int, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<int, String>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<String, double>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<String, int>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<String, int>>',
        true,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<String, String>>',
        false,
      );
  static const MAP_WEAKREFERENCE_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<WeakReference<String>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_BOOL_BOOL_BOOL = DartType._withName(
    'Map<Map<bool, bool>, bool>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, bool>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_INT = DartType._withName(
    'Map<Map<bool, bool>, int>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, int>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_STRING = DartType._withName(
    'Map<Map<bool, bool>, String>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, String>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_LIST_BOOL = DartType._withName(
    'Map<Map<bool, bool>, List<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, List<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, List<double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, List<double>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_LIST_INT = DartType._withName(
    'Map<Map<bool, bool>, List<int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, List<int>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_LIST_STRING = DartType._withName(
    'Map<Map<bool, bool>, List<String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, List<String>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_SET_BOOL = DartType._withName(
    'Map<Map<bool, bool>, Set<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Set<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_SET_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, Set<double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Set<double>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_SET_STRING = DartType._withName(
    'Map<Map<bool, bool>, Set<String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Set<String>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<Map<bool, bool>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, Expando<double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Expando<double>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_EXPANDO_INT = DartType._withName(
    'Map<Map<bool, bool>, Expando<int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Expando<int>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<Map<bool, bool>, Expando<String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Expando<String>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<bool, bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, WeakReference<bool>>', true);
  static const MAP_MAP_BOOL_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, WeakReference<double>>', true);
  static const MAP_MAP_BOOL_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<bool, bool>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, WeakReference<int>>', true);
  static const MAP_MAP_BOOL_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<bool, bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<bool, double>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<Map<bool, bool>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<bool, bool>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<bool, String>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<bool, bool>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<double, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, Map<double, double>>', true);
  static const MAP_MAP_BOOL_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<bool, bool>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<bool, bool>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, Map<double, String>>', true);
  static const MAP_MAP_BOOL_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_INT_INT = DartType._withName(
    'Map<Map<bool, bool>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<Map<bool, bool>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<bool, bool>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<String, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, Map<String, double>>', true);
  static const MAP_MAP_BOOL_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<Map<bool, bool>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, bool>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<Map<bool, bool>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, Map<String, String>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<bool, int>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<bool, String>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<double, bool>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<bool, bool>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<double, int>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<bool, bool>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<int, bool>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<int, double>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<int, String>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<String, bool>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<bool, bool>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<bool, bool>, MapEntry<String, int>>', true);
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<bool, bool>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_BOOL_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<bool, bool>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_BOOL_DOUBLE_BOOL = DartType._withName(
    'Map<Map<bool, double>, bool>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, bool>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, double>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, double>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_INT = DartType._withName(
    'Map<Map<bool, double>, int>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, int>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<Map<bool, double>, List<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, List<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, List<double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, List<double>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_LIST_INT = DartType._withName(
    'Map<Map<bool, double>, List<int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, List<int>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_LIST_STRING = DartType._withName(
    'Map<Map<bool, double>, List<String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, List<String>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_SET_BOOL = DartType._withName(
    'Map<Map<bool, double>, Set<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Set<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, Set<double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Set<double>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_SET_INT = DartType._withName(
    'Map<Map<bool, double>, Set<int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Set<int>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_SET_STRING = DartType._withName(
    'Map<Map<bool, double>, Set<String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Set<String>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, Expando<double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Expando<double>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<Map<bool, double>, Expando<int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Expando<int>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<Map<bool, double>, Expando<String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Expando<String>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<bool, double>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, double>, WeakReference<bool>>', true);
  static const MAP_MAP_BOOL_DOUBLE_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, double>, WeakReference<double>>', true);
  static const MAP_MAP_BOOL_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<bool, double>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<bool, double>, WeakReference<int>>', true);
  static const MAP_MAP_BOOL_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<bool, double>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, double>, WeakReference<String>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<bool, double>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<Map<bool, double>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<bool, double>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, double>, Map<bool, String>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<bool, double>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, double>, Map<double, bool>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, double>, Map<double, double>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<bool, double>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<bool, double>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, double>, Map<double, String>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<Map<bool, double>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<Map<bool, double>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<bool, double>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, double>, Map<String, bool>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, double>, Map<String, double>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<Map<bool, double>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, double>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<Map<bool, double>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, double>, Map<String, String>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<bool, double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, double>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<bool, double>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<bool, double>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<bool, double>, MapEntry<bool, int>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<bool, double>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<bool, double>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<bool, double>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<bool, double>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<bool, double>, MapEntry<double, int>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<bool, double>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<bool, double>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<bool, double>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, double>, MapEntry<int, bool>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<bool, double>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, double>, MapEntry<int, double>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<bool, double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<bool, double>, MapEntry<int, int>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<bool, double>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, double>, MapEntry<int, String>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<bool, double>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<bool, double>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<bool, double>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<bool, double>, MapEntry<String, int>>', true);
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<bool, double>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_BOOL_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<bool, double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_BOOL_INT_BOOL = DartType._withName(
    'Map<Map<bool, int>, bool>',
    false,
  );
  static const MAP_MAP_BOOL_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, bool>',
    true,
  );
  static const MAP_MAP_BOOL_INT_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, double>',
    false,
  );
  static const MAP_MAP_BOOL_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, double>',
    true,
  );
  static const MAP_MAP_BOOL_INT_INT = DartType._withName(
    'Map<Map<bool, int>, int>',
    false,
  );
  static const MAP_MAP_BOOL_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, int>',
    true,
  );
  static const MAP_MAP_BOOL_INT_STRING = DartType._withName(
    'Map<Map<bool, int>, String>',
    false,
  );
  static const MAP_MAP_BOOL_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, String>',
    true,
  );
  static const MAP_MAP_BOOL_INT_LIST_BOOL = DartType._withName(
    'Map<Map<bool, int>, List<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, List<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_LIST_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, List<double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, List<double>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_LIST_STRING = DartType._withName(
    'Map<Map<bool, int>, List<String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, List<String>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_SET_BOOL = DartType._withName(
    'Map<Map<bool, int>, Set<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Set<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_SET_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, Set<double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Set<double>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_SET_INT = DartType._withName(
    'Map<Map<bool, int>, Set<int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Set<int>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_SET_STRING = DartType._withName(
    'Map<Map<bool, int>, Set<String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Set<String>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_EXPANDO_BOOL = DartType._withName(
    'Map<Map<bool, int>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, Expando<double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Expando<double>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_EXPANDO_INT = DartType._withName(
    'Map<Map<bool, int>, Expando<int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Expando<int>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<bool, int>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, int>, WeakReference<bool>>', true);
  static const MAP_MAP_BOOL_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, int>, WeakReference<double>>', true);
  static const MAP_MAP_BOOL_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<bool, int>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, WeakReference<int>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<bool, int>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, int>, WeakReference<String>>', true);
  static const MAP_MAP_BOOL_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<bool, int>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<bool, double>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_BOOL_INT = DartType._withName(
    'Map<Map<bool, int>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<bool, int>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<bool, String>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<double, double>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<bool, int>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<bool, int>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<double, String>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_INT_BOOL = DartType._withName(
    'Map<Map<bool, int>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_INT_INT = DartType._withName(
    'Map<Map<bool, int>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_INT_STRING = DartType._withName(
    'Map<Map<bool, int>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<bool, int>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<String, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_STRING_INT = DartType._withName(
    'Map<Map<bool, int>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAP_STRING_STRING = DartType._withName(
    'Map<Map<bool, int>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, Map<String, String>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<bool, int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<bool, double>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<bool, int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<bool, int>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<bool, String>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<bool, int>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<double, bool>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<double, double>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<bool, int>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<double, String>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<bool, int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<int, double>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<bool, int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, int>, MapEntry<int, int>>',
    true,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<bool, int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<int, String>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<bool, int>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<String, bool>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<bool, int>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<String, double>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<bool, int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<String, int>>', true);
  static const MAP_MAP_BOOL_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<bool, int>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_BOOL_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, int>, MapEntry<String, String>>', true);
  static const MAP_MAP_BOOL_STRING_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, double>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, double>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_INT = DartType._withName(
    'Map<Map<bool, String>, int>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, int>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_STRING = DartType._withName(
    'Map<Map<bool, String>, String>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, String>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_LIST_BOOL = DartType._withName(
    'Map<Map<bool, String>, List<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, List<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_LIST_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, List<double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, List<double>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_LIST_INT = DartType._withName(
    'Map<Map<bool, String>, List<int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, List<int>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_LIST_STRING = DartType._withName(
    'Map<Map<bool, String>, List<String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, List<String>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_SET_BOOL = DartType._withName(
    'Map<Map<bool, String>, Set<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Set<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_SET_INT = DartType._withName(
    'Map<Map<bool, String>, Set<int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Set<int>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_SET_STRING = DartType._withName(
    'Map<Map<bool, String>, Set<String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Set<String>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<Map<bool, String>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, Expando<double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Expando<double>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_EXPANDO_INT = DartType._withName(
    'Map<Map<bool, String>, Expando<int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Expando<int>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_EXPANDO_STRING = DartType._withName(
    'Map<Map<bool, String>, Expando<String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Expando<String>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<bool, String>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, String>, WeakReference<bool>>', true);
  static const MAP_MAP_BOOL_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, String>, WeakReference<double>>', true);
  static const MAP_MAP_BOOL_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<bool, String>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, String>, WeakReference<String>>', true);
  static const MAP_MAP_BOOL_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<bool, String>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, String>, Map<bool, double>>', true);
  static const MAP_MAP_BOOL_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<Map<bool, String>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<bool, String>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, String>, Map<bool, String>>', true);
  static const MAP_MAP_BOOL_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<bool, String>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, String>, Map<double, bool>>', true);
  static const MAP_MAP_BOOL_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, String>, Map<double, double>>', true);
  static const MAP_MAP_BOOL_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<bool, String>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<Map<bool, String>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_MAP_INT_INT = DartType._withName(
    'Map<Map<bool, String>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_MAP_INT_STRING = DartType._withName(
    'Map<Map<bool, String>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<bool, String>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, String>, Map<String, bool>>', true);
  static const MAP_MAP_BOOL_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<bool, String>, Map<String, double>>', true);
  static const MAP_MAP_BOOL_STRING_MAP_STRING_INT = DartType._withName(
    'Map<Map<bool, String>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<bool, String>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_BOOL_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<Map<bool, String>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, String>, Map<String, String>>', true);
  static const MAP_MAP_BOOL_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<bool, String>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<bool, String>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<bool, String>, MapEntry<bool, int>>', true);
  static const MAP_MAP_BOOL_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<bool, String>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<bool, String>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<bool, String>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<bool, String>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<bool, String>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<bool, String>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<bool, String>, MapEntry<double, int>>', true);
  static const MAP_MAP_BOOL_STRING_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<bool, String>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<bool, String>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<bool, String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<bool, String>, MapEntry<int, bool>>', true);
  static const MAP_MAP_BOOL_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<bool, String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<bool, String>, MapEntry<int, int>>', true);
  static const MAP_MAP_BOOL_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<bool, String>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<bool, String>, MapEntry<int, String>>', true);
  static const MAP_MAP_BOOL_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<bool, String>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<bool, String>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<bool, String>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<bool, String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<bool, String>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<bool, String>, MapEntry<String, int>>', true);
  static const MAP_MAP_BOOL_STRING_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<bool, String>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_BOOL_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<bool, String>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_BOOL_BOOL = DartType._withName(
    'Map<Map<double, bool>, bool>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, bool>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, double>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, double>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_STRING = DartType._withName(
    'Map<Map<double, bool>, String>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, String>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_LIST_BOOL = DartType._withName(
    'Map<Map<double, bool>, List<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, List<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, List<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, List<double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_LIST_INT = DartType._withName(
    'Map<Map<double, bool>, List<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, List<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_LIST_STRING = DartType._withName(
    'Map<Map<double, bool>, List<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, List<String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_SET_BOOL = DartType._withName(
    'Map<Map<double, bool>, Set<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Set<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_SET_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, Set<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Set<double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_SET_INT = DartType._withName(
    'Map<Map<double, bool>, Set<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Set<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<Map<double, bool>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, Expando<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Expando<double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_EXPANDO_INT = DartType._withName(
    'Map<Map<double, bool>, Expando<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Expando<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<Map<double, bool>, Expando<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Expando<String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<double, bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, bool>, WeakReference<bool>>', true);
  static const MAP_MAP_DOUBLE_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, bool>, WeakReference<double>>', true);
  static const MAP_MAP_DOUBLE_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<double, bool>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<double, bool>, WeakReference<int>>', true);
  static const MAP_MAP_DOUBLE_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<double, bool>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<double, bool>, WeakReference<String>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, bool>, Map<bool, double>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<Map<double, bool>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<double, bool>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<double, bool>, Map<bool, String>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<double, bool>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, bool>, Map<double, bool>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, bool>, Map<double, double>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<double, bool>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<double, bool>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<double, bool>, Map<double, String>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<Map<double, bool>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<Map<double, bool>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<double, bool>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, bool>, Map<String, bool>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, bool>, Map<String, double>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<Map<double, bool>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<double, bool>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<Map<double, bool>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<double, bool>, Map<String, String>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<double, bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, bool>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, bool>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<double, bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<double, bool>, MapEntry<bool, int>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<double, bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<double, bool>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, bool>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<double, bool>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<double, bool>, MapEntry<double, int>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<double, bool>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, bool>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<double, bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, bool>, MapEntry<int, bool>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, bool>, MapEntry<int, double>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<double, bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<double, bool>, MapEntry<int, int>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<double, bool>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<double, bool>, MapEntry<int, String>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<double, bool>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, bool>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<double, bool>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<double, bool>, MapEntry<String, int>>', true);
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<double, bool>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, bool>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_BOOL = DartType._withName(
    'Map<Map<double, double>, bool>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, double>, bool>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<double, double>, double>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, double>, double>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_INT = DartType._withName(
    'Map<Map<double, double>, int>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<double, double>, int>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_STRING = DartType._withName(
    'Map<Map<double, double>, String>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, double>, String>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<Map<double, double>, List<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, double>, List<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_LIST_INT = DartType._withName(
    'Map<Map<double, double>, List<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<double, double>, List<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_LIST_STRING = DartType._withName(
    'Map<Map<double, double>, List<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, double>, List<String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_SET_BOOL = DartType._withName(
    'Map<Map<double, double>, Set<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, double>, Set<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<Map<double, double>, Set<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, double>, Set<double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_SET_INT = DartType._withName(
    'Map<Map<double, double>, Set<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<double, double>, Set<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_SET_STRING = DartType._withName(
    'Map<Map<double, double>, Set<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, double>, Set<String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<Map<double, double>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, double>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<double, double>, Expando<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, double>, Expando<double>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<Map<double, double>, Expando<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<Map<double, double>, Expando<String>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<double, double>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, double>, WeakReference<bool>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<double, double>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, WeakReference<double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<double, double>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<double, double>, WeakReference<int>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<double, double>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, WeakReference<String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<double, double>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<bool, bool>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<double, double>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<bool, double>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<Map<double, double>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<double, double>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<double, double>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<double, bool>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<double, double>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<double, double>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<double, double>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<double, int>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<double, double>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<double, String>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<Map<double, double>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, double>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<double, double>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<int, double>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<Map<double, double>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<double, double>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<Map<double, double>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<int, String>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<double, double>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<String, double>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<Map<double, double>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<String, int>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<Map<double, double>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<double, double>, Map<String, String>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<double, double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<double, double>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<double, double>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<double, double>, MapEntry<bool, int>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<double, double>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<double, double>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<double, double>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<double, double>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, double>, MapEntry<int, bool>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<double, double>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<double, double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<double, double>, MapEntry<int, int>>', true);
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<double, double>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<double, double>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAP_DOUBLE_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_INT_BOOL = DartType._withName(
    'Map<Map<double, int>, bool>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, int>, bool>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_DOUBLE = DartType._withName(
    'Map<Map<double, int>, double>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, int>, double>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_INT = DartType._withName(
    'Map<Map<double, int>, int>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<double, int>, int>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_STRING = DartType._withName(
    'Map<Map<double, int>, String>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, int>, String>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_LIST_BOOL = DartType._withName(
    'Map<Map<double, int>, List<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, int>, List<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_LIST_DOUBLE = DartType._withName(
    'Map<Map<double, int>, List<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, int>, List<double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_LIST_INT = DartType._withName(
    'Map<Map<double, int>, List<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<double, int>, List<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_LIST_STRING = DartType._withName(
    'Map<Map<double, int>, List<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, int>, List<String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_SET_DOUBLE = DartType._withName(
    'Map<Map<double, int>, Set<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Set<double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_SET_INT = DartType._withName(
    'Map<Map<double, int>, Set<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Set<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_SET_STRING = DartType._withName(
    'Map<Map<double, int>, Set<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Set<String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_EXPANDO_BOOL = DartType._withName(
    'Map<Map<double, int>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<double, int>, Expando<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Expando<double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_EXPANDO_INT = DartType._withName(
    'Map<Map<double, int>, Expando<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Expando<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_EXPANDO_STRING = DartType._withName(
    'Map<Map<double, int>, Expando<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Expando<String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<double, int>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, int>, WeakReference<bool>>', true);
  static const MAP_MAP_DOUBLE_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<double, int>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<double, int>, WeakReference<int>>', true);
  static const MAP_MAP_DOUBLE_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<double, int>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<double, int>, WeakReference<String>>', true);
  static const MAP_MAP_DOUBLE_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<double, int>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<double, int>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<bool, double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_BOOL_INT = DartType._withName(
    'Map<Map<double, int>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<double, int>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<bool, String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<double, int>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<double, bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<double, int>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, int>, Map<double, double>>', true);
  static const MAP_MAP_DOUBLE_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<double, int>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<double, int>, Map<double, String>>', true);
  static const MAP_MAP_DOUBLE_INT_MAP_INT_BOOL = DartType._withName(
    'Map<Map<double, int>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<double, int>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_INT_INT = DartType._withName(
    'Map<Map<double, int>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_INT_STRING = DartType._withName(
    'Map<Map<double, int>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<double, int>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<String, bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<double, int>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, int>, Map<String, double>>', true);
  static const MAP_MAP_DOUBLE_INT_MAP_STRING_INT = DartType._withName(
    'Map<Map<double, int>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<double, int>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<double, int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<double, int>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<bool, double>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<double, int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<bool, int>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<double, int>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<bool, String>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<double, int>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<double, bool>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<double, int>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, int>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<double, int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<double, int>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<double, int>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, int>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<double, int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<int, double>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<double, int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<int, int>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<double, int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<int, String>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<double, int>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<String, bool>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<double, int>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, int>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<double, int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<double, int>, MapEntry<String, int>>', true);
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<double, int>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, int>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_BOOL = DartType._withName(
    'Map<Map<double, String>, bool>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, String>, bool>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_INT = DartType._withName(
    'Map<Map<double, String>, int>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<double, String>, int>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_STRING = DartType._withName(
    'Map<Map<double, String>, String>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, String>, String>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_LIST_BOOL = DartType._withName(
    'Map<Map<double, String>, List<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, String>, List<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_LIST_DOUBLE = DartType._withName(
    'Map<Map<double, String>, List<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, String>, List<double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_LIST_INT = DartType._withName(
    'Map<Map<double, String>, List<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<double, String>, List<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_LIST_STRING = DartType._withName(
    'Map<Map<double, String>, List<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, String>, List<String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_SET_BOOL = DartType._withName(
    'Map<Map<double, String>, Set<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, String>, Set<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_SET_DOUBLE = DartType._withName(
    'Map<Map<double, String>, Set<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<double, String>, Set<double>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_SET_STRING = DartType._withName(
    'Map<Map<double, String>, Set<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<double, String>, Set<String>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<Map<double, String>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, String>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<double, String>, Expando<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, String>, Expando<double>>', true);
  static const MAP_MAP_DOUBLE_STRING_EXPANDO_INT = DartType._withName(
    'Map<Map<double, String>, Expando<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<double, String>, Expando<int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_EXPANDO_STRING = DartType._withName(
    'Map<Map<double, String>, Expando<String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<Map<double, String>, Expando<String>>', true);
  static const MAP_MAP_DOUBLE_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<double, String>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, String>, WeakReference<bool>>', true);
  static const MAP_MAP_DOUBLE_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<double, String>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, WeakReference<double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<double, String>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<double, String>, WeakReference<int>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<double, String>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<bool, bool>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<double, String>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<bool, double>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<Map<double, String>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<double, String>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<double, String>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<bool, String>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<double, String>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<double, bool>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<double, String>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<double, double>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<double, String>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<double, int>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<double, String>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<double, String>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<Map<double, String>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<double, String>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_INT_INT = DartType._withName(
    'Map<Map<double, String>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<double, String>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_INT_STRING = DartType._withName(
    'Map<Map<double, String>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<int, String>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<double, String>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<String, bool>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<double, String>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<String, double>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_STRING_INT = DartType._withName(
    'Map<Map<double, String>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<String, int>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<Map<double, String>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<double, String>, Map<String, String>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<double, String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<double, String>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<double, String>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<double, String>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<double, String>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<double, String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<double, String>, MapEntry<int, bool>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<double, String>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<double, String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<double, String>, MapEntry<int, int>>', true);
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<double, String>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<double, String>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAP_DOUBLE_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<double, String>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_INT_BOOL_BOOL = DartType._withName(
    'Map<Map<int, bool>, bool>',
    false,
  );
  static const MAP_MAP_INT_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, bool>',
    true,
  );
  static const MAP_MAP_INT_BOOL_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, double>',
    false,
  );
  static const MAP_MAP_INT_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, double>',
    true,
  );
  static const MAP_MAP_INT_BOOL_INT = DartType._withName(
    'Map<Map<int, bool>, int>',
    false,
  );
  static const MAP_MAP_INT_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, int>',
    true,
  );
  static const MAP_MAP_INT_BOOL_STRING = DartType._withName(
    'Map<Map<int, bool>, String>',
    false,
  );
  static const MAP_MAP_INT_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, String>',
    true,
  );
  static const MAP_MAP_INT_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, List<double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, List<double>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_LIST_INT = DartType._withName(
    'Map<Map<int, bool>, List<int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, List<int>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_LIST_STRING = DartType._withName(
    'Map<Map<int, bool>, List<String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, List<String>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_SET_BOOL = DartType._withName(
    'Map<Map<int, bool>, Set<bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Set<bool>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_SET_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, Set<double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Set<double>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_SET_INT = DartType._withName(
    'Map<Map<int, bool>, Set<int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Set<int>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_SET_STRING = DartType._withName(
    'Map<Map<int, bool>, Set<String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Set<String>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<Map<int, bool>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_EXPANDO_INT = DartType._withName(
    'Map<Map<int, bool>, Expando<int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Expando<int>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<Map<int, bool>, Expando<String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Expando<String>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<int, bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, bool>, WeakReference<bool>>', true);
  static const MAP_MAP_INT_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, bool>, WeakReference<double>>', true);
  static const MAP_MAP_INT_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<int, bool>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, WeakReference<int>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<int, bool>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<int, bool>, WeakReference<String>>', true);
  static const MAP_MAP_INT_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<int, bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<bool, double>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<int, bool>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<bool, String>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<int, bool>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<double, bool>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<double, double>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<int, bool>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<int, bool>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<double, String>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<Map<int, bool>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_INT_INT = DartType._withName(
    'Map<Map<int, bool>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<int, bool>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<String, bool>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<String, double>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<Map<int, bool>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<Map<int, bool>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, Map<String, String>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<int, bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<bool, double>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<int, bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<int, bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<bool, String>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<double, double>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<int, bool>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<double, int>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<int, bool>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<double, String>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<int, bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<int, bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<int, double>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<int, bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<int, bool>, MapEntry<int, int>>',
    true,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<int, bool>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<int, String>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<int, bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<String, bool>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<int, bool>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<String, int>>', true);
  static const MAP_MAP_INT_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<int, bool>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_INT_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<int, bool>, MapEntry<String, String>>', true);
  static const MAP_MAP_INT_DOUBLE_BOOL = DartType._withName(
    'Map<Map<int, double>, bool>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, double>, bool>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<int, double>, double>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, double>, double>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_INT = DartType._withName(
    'Map<Map<int, double>, int>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<int, double>, int>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_STRING = DartType._withName(
    'Map<Map<int, double>, String>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, double>, String>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<Map<int, double>, List<bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, double>, List<bool>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<Map<int, double>, List<double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, double>, List<double>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_LIST_INT = DartType._withName(
    'Map<Map<int, double>, List<int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<int, double>, List<int>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_SET_BOOL = DartType._withName(
    'Map<Map<int, double>, Set<bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Set<bool>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<Map<int, double>, Set<double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Set<double>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_SET_INT = DartType._withName(
    'Map<Map<int, double>, Set<int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Set<int>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_SET_STRING = DartType._withName(
    'Map<Map<int, double>, Set<String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Set<String>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<Map<int, double>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<int, double>, Expando<double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Expando<double>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<Map<int, double>, Expando<int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Expando<int>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<Map<int, double>, Expando<String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Expando<String>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<int, double>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, double>, WeakReference<double>>', true);
  static const MAP_MAP_INT_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<int, double>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<int, double>, WeakReference<int>>', true);
  static const MAP_MAP_INT_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<int, double>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<int, double>, WeakReference<String>>', true);
  static const MAP_MAP_INT_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<int, double>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<int, double>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<bool, double>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<Map<int, double>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<int, double>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<bool, String>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<int, double>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<double, bool>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<int, double>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<int, double>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<int, double>, Map<double, String>>', true);
  static const MAP_MAP_INT_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<Map<int, double>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<int, double>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<Map<int, double>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<Map<int, double>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<int, double>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, double>, Map<String, bool>>',
    true,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<int, double>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, double>, Map<String, double>>', true);
  static const MAP_MAP_INT_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<Map<int, double>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<int, double>, Map<String, String>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<int, double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<int, double>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<bool, double>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<int, double>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<bool, int>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<int, double>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<bool, String>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<int, double>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<double, bool>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<int, double>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<int, double>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<int, double>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<double, int>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<int, double>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<int, bool>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<int, double>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<int, double>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<int, double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<int, int>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<int, double>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<int, String>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<int, double>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<String, bool>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<int, double>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<int, double>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<int, double>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<int, double>, MapEntry<String, int>>', true);
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<int, double>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_INT_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<int, double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_INT_INT_DOUBLE = DartType._withName(
    'Map<Map<int, int>, double>',
    false,
  );
  static const MAP_MAP_INT_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, int>, double>',
    true,
  );
  static const MAP_MAP_INT_INT_INT = DartType._withName(
    'Map<Map<int, int>, int>',
    false,
  );
  static const MAP_MAP_INT_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<int, int>, int>',
    true,
  );
  static const MAP_MAP_INT_INT_STRING = DartType._withName(
    'Map<Map<int, int>, String>',
    false,
  );
  static const MAP_MAP_INT_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, int>, String>',
    true,
  );
  static const MAP_MAP_INT_INT_LIST_BOOL = DartType._withName(
    'Map<Map<int, int>, List<bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, int>, List<bool>>',
    true,
  );
  static const MAP_MAP_INT_INT_LIST_DOUBLE = DartType._withName(
    'Map<Map<int, int>, List<double>>',
    false,
  );
  static const MAP_MAP_INT_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, int>, List<double>>',
    true,
  );
  static const MAP_MAP_INT_INT_LIST_INT = DartType._withName(
    'Map<Map<int, int>, List<int>>',
    false,
  );
  static const MAP_MAP_INT_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<int, int>, List<int>>',
    true,
  );
  static const MAP_MAP_INT_INT_LIST_STRING = DartType._withName(
    'Map<Map<int, int>, List<String>>',
    false,
  );
  static const MAP_MAP_INT_INT_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, int>, List<String>>',
    true,
  );
  static const MAP_MAP_INT_INT_SET_BOOL = DartType._withName(
    'Map<Map<int, int>, Set<bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Set<bool>>',
    true,
  );
  static const MAP_MAP_INT_INT_SET_INT = DartType._withName(
    'Map<Map<int, int>, Set<int>>',
    false,
  );
  static const MAP_MAP_INT_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Set<int>>',
    true,
  );
  static const MAP_MAP_INT_INT_SET_STRING = DartType._withName(
    'Map<Map<int, int>, Set<String>>',
    false,
  );
  static const MAP_MAP_INT_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Set<String>>',
    true,
  );
  static const MAP_MAP_INT_INT_EXPANDO_BOOL = DartType._withName(
    'Map<Map<int, int>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_INT_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<int, int>, Expando<double>>',
    false,
  );
  static const MAP_MAP_INT_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Expando<double>>',
    true,
  );
  static const MAP_MAP_INT_INT_EXPANDO_INT = DartType._withName(
    'Map<Map<int, int>, Expando<int>>',
    false,
  );
  static const MAP_MAP_INT_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Expando<int>>',
    true,
  );
  static const MAP_MAP_INT_INT_EXPANDO_STRING = DartType._withName(
    'Map<Map<int, int>, Expando<String>>',
    false,
  );
  static const MAP_MAP_INT_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Expando<String>>',
    true,
  );
  static const MAP_MAP_INT_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<int, int>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, int>, WeakReference<bool>>',
    true,
  );
  static const MAP_MAP_INT_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<int, int>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_INT_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, int>, WeakReference<double>>', true);
  static const MAP_MAP_INT_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<int, int>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_INT_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<int, int>, WeakReference<String>>', true);
  static const MAP_MAP_INT_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<int, int>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<int, int>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<bool, double>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_BOOL_INT = DartType._withName(
    'Map<Map<int, int>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<int, int>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<bool, String>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<int, int>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<double, bool>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<int, int>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<double, double>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<int, int>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<int, int>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<double, String>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<int, int>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_INT_INT = DartType._withName(
    'Map<Map<int, int>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_INT_STRING = DartType._withName(
    'Map<Map<int, int>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<int, int>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<String, bool>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<int, int>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<String, double>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_STRING_INT = DartType._withName(
    'Map<Map<int, int>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAP_STRING_STRING = DartType._withName(
    'Map<Map<int, int>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, int>, Map<String, String>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<int, int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, int>, MapEntry<bool, bool>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<int, int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<int, int>, MapEntry<bool, int>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<int, int>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<bool, String>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<int, int>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<double, bool>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<int, int>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<double, double>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<int, int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<double, int>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<int, int>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<double, String>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<int, int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, int>, MapEntry<int, bool>>',
    true,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<int, int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<int, double>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<int, int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<int, String>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<int, int>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<String, bool>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<int, int>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<String, double>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<int, int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<String, int>>', true);
  static const MAP_MAP_INT_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<int, int>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_INT_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<int, int>, MapEntry<String, String>>', true);
  static const MAP_MAP_INT_STRING_BOOL = DartType._withName(
    'Map<Map<int, String>, bool>',
    false,
  );
  static const MAP_MAP_INT_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, String>, bool>',
    true,
  );
  static const MAP_MAP_INT_STRING_DOUBLE = DartType._withName(
    'Map<Map<int, String>, double>',
    false,
  );
  static const MAP_MAP_INT_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, String>, double>',
    true,
  );
  static const MAP_MAP_INT_STRING_INT = DartType._withName(
    'Map<Map<int, String>, int>',
    false,
  );
  static const MAP_MAP_INT_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<int, String>, int>',
    true,
  );
  static const MAP_MAP_INT_STRING_LIST_BOOL = DartType._withName(
    'Map<Map<int, String>, List<bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, String>, List<bool>>',
    true,
  );
  static const MAP_MAP_INT_STRING_LIST_DOUBLE = DartType._withName(
    'Map<Map<int, String>, List<double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, String>, List<double>>',
    true,
  );
  static const MAP_MAP_INT_STRING_LIST_INT = DartType._withName(
    'Map<Map<int, String>, List<int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<int, String>, List<int>>',
    true,
  );
  static const MAP_MAP_INT_STRING_LIST_STRING = DartType._withName(
    'Map<Map<int, String>, List<String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, String>, List<String>>',
    true,
  );
  static const MAP_MAP_INT_STRING_SET_BOOL = DartType._withName(
    'Map<Map<int, String>, Set<bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Set<bool>>',
    true,
  );
  static const MAP_MAP_INT_STRING_SET_DOUBLE = DartType._withName(
    'Map<Map<int, String>, Set<double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Set<double>>',
    true,
  );
  static const MAP_MAP_INT_STRING_SET_INT = DartType._withName(
    'Map<Map<int, String>, Set<int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Set<int>>',
    true,
  );
  static const MAP_MAP_INT_STRING_SET_STRING = DartType._withName(
    'Map<Map<int, String>, Set<String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Set<String>>',
    true,
  );
  static const MAP_MAP_INT_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<int, String>, Expando<double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Expando<double>>',
    true,
  );
  static const MAP_MAP_INT_STRING_EXPANDO_INT = DartType._withName(
    'Map<Map<int, String>, Expando<int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Expando<int>>',
    true,
  );
  static const MAP_MAP_INT_STRING_EXPANDO_STRING = DartType._withName(
    'Map<Map<int, String>, Expando<String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Expando<String>>',
    true,
  );
  static const MAP_MAP_INT_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<int, String>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, String>, WeakReference<bool>>', true);
  static const MAP_MAP_INT_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<int, String>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, String>, WeakReference<double>>', true);
  static const MAP_MAP_INT_STRING_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<int, String>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<int, String>, WeakReference<int>>', true);
  static const MAP_MAP_INT_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<int, String>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<int, String>, WeakReference<String>>', true);
  static const MAP_MAP_INT_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<int, String>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<Map<int, String>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<int, String>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<bool, String>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<int, String>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<double, bool>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<int, String>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, String>, Map<double, double>>', true);
  static const MAP_MAP_INT_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<int, String>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<int, String>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<int, String>, Map<double, String>>', true);
  static const MAP_MAP_INT_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<Map<int, String>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<int, String>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_INT_STRING = DartType._withName(
    'Map<Map<int, String>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<int, String>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<String, bool>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<int, String>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, String>, Map<String, double>>', true);
  static const MAP_MAP_INT_STRING_MAP_STRING_INT = DartType._withName(
    'Map<Map<int, String>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<int, String>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_INT_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<Map<int, String>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<int, String>, Map<String, String>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<int, String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<int, String>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<bool, double>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<int, String>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<bool, int>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<int, String>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<double, bool>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<int, String>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<int, String>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_INT_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<int, String>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<double, int>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<int, String>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<int, String>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_INT_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<int, String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<int, bool>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<int, String>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<int, double>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<int, String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<int, int>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<int, String>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<int, String>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<int, String>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<int, String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_INT_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<int, String>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<int, String>, MapEntry<String, int>>', true);
  static const MAP_MAP_INT_STRING_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<int, String>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_INT_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<int, String>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_STRING_BOOL_BOOL = DartType._withName(
    'Map<Map<String, bool>, bool>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, bool>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, double>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, double>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_INT = DartType._withName(
    'Map<Map<String, bool>, int>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, int>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_STRING = DartType._withName(
    'Map<Map<String, bool>, String>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, String>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_LIST_BOOL = DartType._withName(
    'Map<Map<String, bool>, List<bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, List<bool>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, List<double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, List<double>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_LIST_STRING = DartType._withName(
    'Map<Map<String, bool>, List<String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, List<String>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_SET_BOOL = DartType._withName(
    'Map<Map<String, bool>, Set<bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Set<bool>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_SET_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, Set<double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Set<double>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_SET_INT = DartType._withName(
    'Map<Map<String, bool>, Set<int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Set<int>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_SET_STRING = DartType._withName(
    'Map<Map<String, bool>, Set<String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Set<String>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<Map<String, bool>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, Expando<double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Expando<double>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_EXPANDO_INT = DartType._withName(
    'Map<Map<String, bool>, Expando<int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Expando<int>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<String, bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, bool>, WeakReference<bool>>', true);
  static const MAP_MAP_STRING_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, bool>, WeakReference<double>>', true);
  static const MAP_MAP_STRING_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<String, bool>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<String, bool>, WeakReference<int>>', true);
  static const MAP_MAP_STRING_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<String, bool>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<String, bool>, WeakReference<String>>', true);
  static const MAP_MAP_STRING_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<String, bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, bool>, Map<bool, double>>', true);
  static const MAP_MAP_STRING_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<Map<String, bool>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<String, bool>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<String, bool>, Map<bool, String>>', true);
  static const MAP_MAP_STRING_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, bool>, Map<double, double>>', true);
  static const MAP_MAP_STRING_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<String, bool>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<String, bool>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<String, bool>, Map<double, String>>', true);
  static const MAP_MAP_STRING_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<Map<String, bool>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Map<int, double>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_MAP_INT_INT = DartType._withName(
    'Map<Map<String, bool>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<Map<String, bool>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<String, bool>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, bool>, Map<String, bool>>', true);
  static const MAP_MAP_STRING_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<Map<String, bool>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<String, bool>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_STRING_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<Map<String, bool>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<String, bool>, Map<String, String>>', true);
  static const MAP_MAP_STRING_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<String, bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, bool>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_STRING_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, bool>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<String, bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<String, bool>, MapEntry<bool, int>>', true);
  static const MAP_MAP_STRING_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<String, bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, bool>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<String, bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<String, bool>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, bool>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<String, bool>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, bool>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<String, bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, bool>, MapEntry<int, bool>>', true);
  static const MAP_MAP_STRING_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, bool>, MapEntry<int, double>>', true);
  static const MAP_MAP_STRING_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<String, bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<String, bool>, MapEntry<int, int>>', true);
  static const MAP_MAP_STRING_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<String, bool>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<String, bool>, MapEntry<int, String>>', true);
  static const MAP_MAP_STRING_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<String, bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<String, bool>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<String, bool>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, bool>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<String, bool>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_STRING_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<String, bool>, MapEntry<String, int>>', true);
  static const MAP_MAP_STRING_DOUBLE_BOOL = DartType._withName(
    'Map<Map<String, double>, bool>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, double>, bool>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<String, double>, double>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, double>, double>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_INT = DartType._withName(
    'Map<Map<String, double>, int>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<String, double>, int>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_STRING = DartType._withName(
    'Map<Map<String, double>, String>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, double>, String>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<Map<String, double>, List<bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, double>, List<bool>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<Map<String, double>, List<double>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, double>, List<double>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_LIST_INT = DartType._withName(
    'Map<Map<String, double>, List<int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<String, double>, List<int>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_LIST_STRING = DartType._withName(
    'Map<Map<String, double>, List<String>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, double>, List<String>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<Map<String, double>, Set<double>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, double>, Set<double>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_SET_INT = DartType._withName(
    'Map<Map<String, double>, Set<int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<String, double>, Set<int>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_SET_STRING = DartType._withName(
    'Map<Map<String, double>, Set<String>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, double>, Set<String>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<Map<String, double>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, double>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<String, double>, Expando<double>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, double>, Expando<double>>', true);
  static const MAP_MAP_STRING_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<Map<String, double>, Expando<int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<String, double>, Expando<int>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<Map<String, double>, Expando<String>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<Map<String, double>, Expando<String>>', true);
  static const MAP_MAP_STRING_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<String, double>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, double>, WeakReference<bool>>', true);
  static const MAP_MAP_STRING_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<String, double>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<String, double>, WeakReference<int>>', true);
  static const MAP_MAP_STRING_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<String, double>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, WeakReference<String>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<String, double>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<bool, bool>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<String, double>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<bool, double>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<Map<String, double>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<String, double>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<String, double>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<bool, String>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<String, double>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<double, bool>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<String, double>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<double, double>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<String, double>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<double, int>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<Map<String, double>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, double>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<String, double>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<int, double>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<Map<String, double>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<String, double>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<Map<String, double>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<int, String>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<String, double>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<String, bool>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<String, double>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<String, double>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<Map<String, double>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<String, int>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<Map<String, double>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<String, double>, Map<String, String>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<String, double>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<String, double>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<String, double>, MapEntry<bool, int>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<String, double>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<String, double>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<String, double>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<String, double>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, double>, MapEntry<int, bool>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<String, double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<String, double>, MapEntry<int, int>>', true);
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<String, double>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<String, double>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<String, double>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAP_STRING_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_STRING_INT_BOOL = DartType._withName(
    'Map<Map<String, int>, bool>',
    false,
  );
  static const MAP_MAP_STRING_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, int>, bool>',
    true,
  );
  static const MAP_MAP_STRING_INT_DOUBLE = DartType._withName(
    'Map<Map<String, int>, double>',
    false,
  );
  static const MAP_MAP_STRING_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, int>, double>',
    true,
  );
  static const MAP_MAP_STRING_INT_STRING = DartType._withName(
    'Map<Map<String, int>, String>',
    false,
  );
  static const MAP_MAP_STRING_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, int>, String>',
    true,
  );
  static const MAP_MAP_STRING_INT_LIST_BOOL = DartType._withName(
    'Map<Map<String, int>, List<bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, int>, List<bool>>',
    true,
  );
  static const MAP_MAP_STRING_INT_LIST_DOUBLE = DartType._withName(
    'Map<Map<String, int>, List<double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, int>, List<double>>',
    true,
  );
  static const MAP_MAP_STRING_INT_LIST_INT = DartType._withName(
    'Map<Map<String, int>, List<int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<String, int>, List<int>>',
    true,
  );
  static const MAP_MAP_STRING_INT_LIST_STRING = DartType._withName(
    'Map<Map<String, int>, List<String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, int>, List<String>>',
    true,
  );
  static const MAP_MAP_STRING_INT_SET_BOOL = DartType._withName(
    'Map<Map<String, int>, Set<bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Set<bool>>',
    true,
  );
  static const MAP_MAP_STRING_INT_SET_DOUBLE = DartType._withName(
    'Map<Map<String, int>, Set<double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Set<double>>',
    true,
  );
  static const MAP_MAP_STRING_INT_SET_INT = DartType._withName(
    'Map<Map<String, int>, Set<int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Set<int>>',
    true,
  );
  static const MAP_MAP_STRING_INT_EXPANDO_BOOL = DartType._withName(
    'Map<Map<String, int>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_STRING_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<String, int>, Expando<double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Expando<double>>',
    true,
  );
  static const MAP_MAP_STRING_INT_EXPANDO_INT = DartType._withName(
    'Map<Map<String, int>, Expando<int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Expando<int>>',
    true,
  );
  static const MAP_MAP_STRING_INT_EXPANDO_STRING = DartType._withName(
    'Map<Map<String, int>, Expando<String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Expando<String>>',
    true,
  );
  static const MAP_MAP_STRING_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<String, int>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, int>, WeakReference<bool>>', true);
  static const MAP_MAP_STRING_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<String, int>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, int>, WeakReference<double>>', true);
  static const MAP_MAP_STRING_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<String, int>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<String, int>, WeakReference<int>>', true);
  static const MAP_MAP_STRING_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<String, int>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('Map<Map<String, int>, WeakReference<String>>', true);
  static const MAP_MAP_STRING_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<String, int>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<bool, double>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_BOOL_INT = DartType._withName(
    'Map<Map<String, int>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<Map<String, int>, Map<bool, String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<bool, String>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<String, int>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<double, bool>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<String, int>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, int>, Map<double, double>>', true);
  static const MAP_MAP_STRING_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<String, int>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<double, int>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<String, int>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<String, int>, Map<double, String>>', true);
  static const MAP_MAP_STRING_INT_MAP_INT_BOOL = DartType._withName(
    'Map<Map<String, int>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_INT_INT = DartType._withName(
    'Map<Map<String, int>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_INT_STRING = DartType._withName(
    'Map<Map<String, int>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<int, String>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<Map<String, int>, Map<String, bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<String, bool>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<String, int>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, int>, Map<String, double>>', true);
  static const MAP_MAP_STRING_INT_MAP_STRING_INT = DartType._withName(
    'Map<Map<String, int>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<String, int>, Map<String, int>>',
    true,
  );
  static const MAP_MAP_STRING_INT_MAP_STRING_STRING = DartType._withName(
    'Map<Map<String, int>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<String, int>, Map<String, String>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<String, int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<bool, bool>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<String, int>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<bool, double>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<String, int>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<bool, String>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<String, int>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<double, bool>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<String, int>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, int>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAP_STRING_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<String, int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<double, int>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'Map<Map<String, int>, MapEntry<double, String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, int>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_STRING_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<String, int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<int, bool>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<String, int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<int, double>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<String, int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<int, int>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<String, int>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<String, bool>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<Map<String, int>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, int>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_STRING_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<Map<String, int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<String, int>, MapEntry<String, int>>', true);
  static const MAP_MAP_STRING_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<Map<String, int>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAP_STRING_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, int>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_BOOL = DartType._withName(
    'Map<Map<String, String>, bool>',
    false,
  );
  static const MAP_MAP_STRING_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, String>, bool>',
    true,
  );
  static const MAP_MAP_STRING_STRING_DOUBLE = DartType._withName(
    'Map<Map<String, String>, double>',
    false,
  );
  static const MAP_MAP_STRING_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, String>, double>',
    true,
  );
  static const MAP_MAP_STRING_STRING_INT = DartType._withName(
    'Map<Map<String, String>, int>',
    false,
  );
  static const MAP_MAP_STRING_STRING_INT_NULLABLE = DartType._withName(
    'Map<Map<String, String>, int>',
    true,
  );
  static const MAP_MAP_STRING_STRING_STRING = DartType._withName(
    'Map<Map<String, String>, String>',
    false,
  );
  static const MAP_MAP_STRING_STRING_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, String>, String>',
    true,
  );
  static const MAP_MAP_STRING_STRING_LIST_BOOL = DartType._withName(
    'Map<Map<String, String>, List<bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, String>, List<bool>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_LIST_INT = DartType._withName(
    'Map<Map<String, String>, List<int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<Map<String, String>, List<int>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_LIST_STRING = DartType._withName(
    'Map<Map<String, String>, List<String>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, String>, List<String>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_SET_BOOL = DartType._withName(
    'Map<Map<String, String>, Set<bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, String>, Set<bool>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_SET_DOUBLE = DartType._withName(
    'Map<Map<String, String>, Set<double>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<Map<String, String>, Set<double>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_SET_INT = DartType._withName(
    'Map<Map<String, String>, Set<int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<Map<String, String>, Set<int>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_SET_STRING = DartType._withName(
    'Map<Map<String, String>, Set<String>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_SET_STRING_NULLABLE = DartType._withName(
    'Map<Map<String, String>, Set<String>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<Map<String, String>, Expando<bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, String>, Expando<bool>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<Map<String, String>, Expando<double>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, String>, Expando<double>>', true);
  static const MAP_MAP_STRING_STRING_EXPANDO_STRING = DartType._withName(
    'Map<Map<String, String>, Expando<String>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<Map<String, String>, Expando<String>>', true);
  static const MAP_MAP_STRING_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<Map<String, String>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, String>, WeakReference<bool>>', true);
  static const MAP_MAP_STRING_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<Map<String, String>, WeakReference<double>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, WeakReference<double>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_WEAKREFERENCE_INT = DartType._withName(
    'Map<Map<String, String>, WeakReference<int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<Map<String, String>, WeakReference<int>>', true);
  static const MAP_MAP_STRING_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'Map<Map<String, String>, WeakReference<String>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, WeakReference<String>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<Map<String, String>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<bool, bool>>', true);
  static const MAP_MAP_STRING_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<Map<String, String>, Map<bool, double>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<bool, double>>', true);
  static const MAP_MAP_STRING_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<Map<String, String>, Map<bool, int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<Map<String, String>, Map<bool, int>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<Map<String, String>, Map<double, bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<double, bool>>', true);
  static const MAP_MAP_STRING_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<Map<String, String>, Map<double, double>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<double, double>>', true);
  static const MAP_MAP_STRING_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<Map<String, String>, Map<double, int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<double, int>>', true);
  static const MAP_MAP_STRING_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<Map<String, String>, Map<double, String>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<double, String>>', true);
  static const MAP_MAP_STRING_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<Map<String, String>, Map<int, bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<Map<String, String>, Map<int, bool>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<Map<String, String>, Map<int, double>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<int, double>>', true);
  static const MAP_MAP_STRING_STRING_MAP_INT_INT = DartType._withName(
    'Map<Map<String, String>, Map<int, int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<Map<String, String>, Map<int, int>>',
    true,
  );
  static const MAP_MAP_STRING_STRING_MAP_INT_STRING = DartType._withName(
    'Map<Map<String, String>, Map<int, String>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<int, String>>', true);
  static const MAP_MAP_STRING_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<Map<String, String>, Map<String, double>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<String, double>>', true);
  static const MAP_MAP_STRING_STRING_MAP_STRING_INT = DartType._withName(
    'Map<Map<String, String>, Map<String, int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<String, int>>', true);
  static const MAP_MAP_STRING_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<Map<String, String>, Map<String, String>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<Map<String, String>, Map<String, String>>', true);
  static const MAP_MAP_STRING_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<Map<String, String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<Map<String, String>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<Map<String, String>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<Map<String, String>, MapEntry<bool, int>>', true);
  static const MAP_MAP_STRING_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<Map<String, String>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<Map<String, String>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<Map<String, String>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<Map<String, String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<Map<String, String>, MapEntry<int, bool>>', true);
  static const MAP_MAP_STRING_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<Map<String, String>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<Map<String, String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<Map<String, String>, MapEntry<int, int>>', true);
  static const MAP_MAP_STRING_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'Map<Map<String, String>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<Map<String, String>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAP_STRING_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAP_STRING_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<Map<String, String>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, bool>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, bool>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, double>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, double>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, int>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, int>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_STRING = DartType._withName(
    'Map<MapEntry<bool, bool>, String>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, String>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_LIST_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, List<double>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_LIST_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_SET_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Set<double>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_SET_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_SET_STRING = DartType._withName(
    'Map<MapEntry<bool, bool>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Set<String>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Expando<bool>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Expando<double>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Expando<int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<bool, bool>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Expando<String>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, WeakReference<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, WeakReference<int>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'Map<MapEntry<bool, bool>, WeakReference<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<bool, double>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<bool, String>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<double, bool>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<int, double>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<int, int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<int, String>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<String, bool>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, Map<String, int>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, bool>, MapEntry<int, int>>', true);
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<MapEntry<bool, bool>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, bool>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, bool>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, double>, bool>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<bool, double>, int>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, double>, int>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<bool, double>, String>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, double>, String>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, double>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, double>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, List<double>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_LIST_INT = DartType._withName(
    'Map<MapEntry<bool, double>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, double>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_LIST_STRING = DartType._withName(
    'Map<MapEntry<bool, double>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, List<String>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_SET_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, double>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, double>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_SET_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Set<double>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_SET_STRING = DartType._withName(
    'Map<MapEntry<bool, double>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_SET_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Set<String>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Expando<bool>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, double>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Expando<double>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<bool, double>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Expando<int>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<bool, double>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Expando<String>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<bool, double>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, double>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, Map<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<bool, double>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<bool, double>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, Map<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, Map<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, double>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<bool, double>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Map<double, int>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<bool, double>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, double>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Map<int, double>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<bool, double>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Map<int, int>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<bool, double>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Map<int, String>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, Map<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, double>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<bool, double>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, double>, Map<String, int>>', true);
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<bool, double>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<bool, double>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<double, int>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<bool, double>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<int, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_INT_STRING =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<int, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<String, int>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, bool>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, bool>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, double>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, double>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_INT = DartType._withName(
    'Map<MapEntry<bool, int>, int>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, int>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, String>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, String>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, List<double>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_LIST_INT = DartType._withName(
    'Map<MapEntry<bool, int>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_LIST_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_LIST_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, List<String>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_SET_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, Set<double>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_SET_INT = DartType._withName(
    'Map<MapEntry<bool, int>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_SET_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, Set<String>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, Expando<bool>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<bool, int>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, Expando<int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Expando<String>>', true);
  static const MAP_MAPENTRY_BOOL_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, WeakReference<bool>>', true);
  static const MAP_MAPENTRY_BOOL_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, WeakReference<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<bool, int>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, WeakReference<int>>', true);
  static const MAP_MAPENTRY_BOOL_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, WeakReference<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<bool, double>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<bool, String>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<double, bool>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<double, double>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<bool, int>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<double, int>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<double, String>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, Map<int, bool>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<int, double>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<bool, int>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, int>, Map<int, int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<String, bool>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<String, double>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<bool, int>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<String, int>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, Map<String, String>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, MapEntry<bool, int>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, MapEntry<int, bool>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, int>, MapEntry<int, int>>', true);
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<MapEntry<bool, int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, int>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, bool>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, String>, bool>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, String>, double>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, String>, double>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_STRING_INT = DartType._withName(
    'Map<MapEntry<bool, String>, int>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, String>, int>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_STRING_STRING = DartType._withName(
    'Map<MapEntry<bool, String>, String>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, String>, String>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_STRING_LIST_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, String>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_STRING_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, String>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, List<double>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_LIST_STRING = DartType._withName(
    'Map<MapEntry<bool, String>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, List<String>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_SET_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, String>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_STRING_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, String>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_SET_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Set<double>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_SET_INT = DartType._withName(
    'Map<MapEntry<bool, String>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<bool, String>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_BOOL_STRING_SET_STRING = DartType._withName(
    'Map<MapEntry<bool, String>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_SET_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Set<String>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Expando<bool>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, String>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Expando<double>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<bool, String>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Expando<int>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<bool, String>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<bool, String>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, String>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, Map<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<bool, String>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<bool, String>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, Map<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, String>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<bool, String>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Map<double, int>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<bool, String>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, String>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Map<int, double>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<bool, String>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Map<int, int>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<bool, String>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<bool, String>, Map<int, String>>', true);
  static const MAP_MAPENTRY_BOOL_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, Map<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<bool, String>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<bool, String>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<bool, String>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<double, int>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<bool, String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<int, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<bool, String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_INT_STRING =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<int, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<String, int>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_BOOL_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<bool, String>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<double, bool>, double>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<double, bool>, double>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_INT = DartType._withName(
    'Map<MapEntry<double, bool>, int>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, bool>, int>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_STRING = DartType._withName(
    'Map<MapEntry<double, bool>, String>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<double, bool>, String>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_LIST_BOOL = DartType._withName(
    'Map<MapEntry<double, bool>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<double, bool>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<double, bool>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, List<double>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_LIST_INT = DartType._withName(
    'Map<MapEntry<double, bool>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, bool>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_LIST_STRING = DartType._withName(
    'Map<MapEntry<double, bool>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, List<String>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_SET_BOOL = DartType._withName(
    'Map<MapEntry<double, bool>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<double, bool>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_SET_INT = DartType._withName(
    'Map<MapEntry<double, bool>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, bool>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_SET_STRING = DartType._withName(
    'Map<MapEntry<double, bool>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_SET_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Set<String>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<double, bool>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Expando<bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<double, bool>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Expando<double>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<double, bool>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Expando<int>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<double, bool>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Expando<String>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<double, bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<double, bool>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<double, bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<double, bool>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, Map<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<double, bool>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<double, bool>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, Map<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<double, bool>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, Map<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<double, bool>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<double, bool>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Map<double, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<double, bool>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<double, bool>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Map<int, double>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<double, bool>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Map<int, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<double, bool>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Map<int, String>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<double, bool>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, Map<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<double, bool>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<double, bool>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, bool>, Map<String, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<double, bool>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<double, bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<double, int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<double, bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<double, bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_INT_STRING =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<int, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<String, int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, bool>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<double, double>, bool>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<double, double>, bool>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<double, double>, double>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<double, double>, double>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<double, double>, int>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, double>, int>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<MapEntry<double, double>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_LIST_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, List<bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<double, double>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, List<double>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_LIST_INT = DartType._withName(
    'Map<MapEntry<double, double>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_LIST_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, List<int>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_LIST_STRING = DartType._withName(
    'Map<MapEntry<double, double>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, List<String>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_SET_BOOL = DartType._withName(
    'Map<MapEntry<double, double>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_SET_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, Set<bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<double, double>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_SET_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, Set<double>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_SET_INT = DartType._withName(
    'Map<MapEntry<double, double>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, double>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_SET_STRING = DartType._withName(
    'Map<MapEntry<double, double>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_SET_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, Set<String>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<double, double>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Expando<double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<double, double>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, Expando<int>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<double, double>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_EXPANDO_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Expando<String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_WEAKREFERENCE_BOOL =
      DartType._withName(
        'Map<MapEntry<double, double>, WeakReference<bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, double>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_WEAKREFERENCE_INT =
      DartType._withName(
        'Map<MapEntry<double, double>, WeakReference<int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<double, double>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<double, double>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<double, double>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<double, double>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<double, double>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<double, double>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<double, double>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, double>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<double, double>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<double, double>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<double, double>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<double, double>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_BOOL_BOOL =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<bool, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_BOOL_INT =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<bool, int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<double, int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_INT_BOOL =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<int, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<int, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<double, double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_INT_STRING =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<int, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<String, int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, bool>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, bool>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<double, int>, double>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, double>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_INT = DartType._withName(
    'Map<MapEntry<double, int>, int>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, int>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_STRING = DartType._withName(
    'Map<MapEntry<double, int>, String>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, String>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_LIST_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_LIST_INT = DartType._withName(
    'Map<MapEntry<double, int>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_LIST_STRING = DartType._withName(
    'Map<MapEntry<double, int>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, List<String>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_SET_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<double, int>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, Set<double>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_SET_INT = DartType._withName(
    'Map<MapEntry<double, int>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_SET_STRING = DartType._withName(
    'Map<MapEntry<double, int>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<double, int>, Set<String>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Expando<bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<double, int>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Expando<double>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<double, int>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Expando<String>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, int>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<double, int>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<double, int>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<double, int>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<bool, double>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<double, int>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<double, bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<double, int>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<double, int>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<double, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<double, int>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<double, int>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<int, double>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<double, int>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<int, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<double, int>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<int, String>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<String, bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<double, int>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, int>, Map<String, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<double, int>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<double, int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<double, int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<double, int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<double, int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<MapEntry<double, int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<MapEntry<double, int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, int>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_BOOL = DartType._withName(
    'Map<MapEntry<double, String>, bool>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<double, String>, bool>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<double, String>, double>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<double, String>, double>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_INT = DartType._withName(
    'Map<MapEntry<double, String>, int>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, String>, int>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_STRING = DartType._withName(
    'Map<MapEntry<double, String>, String>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<double, String>, String>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_LIST_BOOL = DartType._withName(
    'Map<MapEntry<double, String>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_LIST_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, List<bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<double, String>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, List<double>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_LIST_INT = DartType._withName(
    'Map<MapEntry<double, String>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_LIST_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, List<int>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_LIST_STRING = DartType._withName(
    'Map<MapEntry<double, String>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, List<String>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<double, String>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_SET_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, Set<double>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_SET_INT = DartType._withName(
    'Map<MapEntry<double, String>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<double, String>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_SET_STRING = DartType._withName(
    'Map<MapEntry<double, String>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_SET_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, Set<String>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<double, String>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, Expando<bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<double, String>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Expando<double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<double, String>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, Expando<int>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<double, String>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_EXPANDO_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Expando<String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_WEAKREFERENCE_BOOL =
      DartType._withName(
        'Map<MapEntry<double, String>, WeakReference<bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_WEAKREFERENCE_INT =
      DartType._withName(
        'Map<MapEntry<double, String>, WeakReference<int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<double, String>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<double, String>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<double, String>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<double, String>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<double, String>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<double, String>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<double, String>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<double, String>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<double, String>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<double, String>, Map<int, int>>', true);
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<double, String>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<double, String>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<double, String>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAP_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, Map<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_BOOL_BOOL =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<bool, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_BOOL_INT =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<bool, int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<double, int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<int, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<double, String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_INT_STRING =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<int, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<String, int>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_DOUBLE_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<double, String>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, bool>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, bool>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, double>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, double>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_STRING = DartType._withName(
    'Map<MapEntry<int, bool>, String>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, String>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_LIST_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, List<double>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_LIST_INT = DartType._withName(
    'Map<MapEntry<int, bool>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_LIST_STRING = DartType._withName(
    'Map<MapEntry<int, bool>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, List<String>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_SET_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, Set<double>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_SET_INT = DartType._withName(
    'Map<MapEntry<int, bool>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, Expando<bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Expando<double>>', true);
  static const MAP_MAPENTRY_INT_BOOL_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<int, bool>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, Expando<int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<int, bool>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Expando<String>>', true);
  static const MAP_MAPENTRY_INT_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, WeakReference<bool>>', true);
  static const MAP_MAPENTRY_INT_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, WeakReference<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<int, bool>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, WeakReference<int>>', true);
  static const MAP_MAPENTRY_INT_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'Map<MapEntry<int, bool>, WeakReference<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<bool, double>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<int, bool>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, Map<bool, int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<int, bool>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<bool, String>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<double, bool>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<double, double>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<int, bool>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<double, int>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<int, bool>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<double, String>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, Map<int, bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<int, bool>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, bool>, Map<int, int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<int, bool>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<int, String>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<String, bool>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<String, double>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<int, bool>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<String, int>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<int, bool>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, Map<String, String>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, MapEntry<int, bool>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, bool>, MapEntry<int, int>>', true);
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'Map<MapEntry<int, bool>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_INT_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, bool>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<int, double>, bool>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, double>, bool>',
    true,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<int, double>, double>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<int, double>, double>',
    true,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<int, double>, int>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, double>, int>',
    true,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<int, double>, String>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<int, double>, String>',
    true,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<int, double>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, List<double>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_LIST_INT = DartType._withName(
    'Map<MapEntry<int, double>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, double>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_LIST_STRING = DartType._withName(
    'Map<MapEntry<int, double>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, List<String>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_SET_BOOL = DartType._withName(
    'Map<MapEntry<int, double>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, double>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<int, double>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<int, double>, Set<double>>',
    true,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_SET_INT = DartType._withName(
    'Map<MapEntry<int, double>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, double>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_SET_STRING = DartType._withName(
    'Map<MapEntry<int, double>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<int, double>, Set<String>>',
    true,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<int, double>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Expando<bool>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<int, double>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Expando<int>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<int, double>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Expando<String>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<int, double>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<int, double>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<int, double>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<int, double>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<int, double>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<int, double>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<bool, double>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<int, double>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<bool, String>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<int, double>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<double, bool>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<int, double>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<int, double>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<double, int>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<int, double>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<int, double>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<int, double>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<int, double>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<int, double>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<int, int>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<int, double>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<int, String>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<int, double>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<int, double>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, double>, Map<String, int>>', true);
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<int, double>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<int, double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<int, double>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<int, double>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<int, double>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<int, double>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<int, double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'Map<MapEntry<int, double>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_INT_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, bool>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, bool>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, double>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, double>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_INT = DartType._withName(
    'Map<MapEntry<int, int>, int>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, int>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_STRING = DartType._withName(
    'Map<MapEntry<int, int>, String>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, String>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_LIST_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, List<double>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_LIST_INT = DartType._withName(
    'Map<MapEntry<int, int>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_SET_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Set<double>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_SET_INT = DartType._withName(
    'Map<MapEntry<int, int>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_SET_STRING = DartType._withName(
    'Map<MapEntry<int, int>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Set<String>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Expando<bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Expando<double>>', true);
  static const MAP_MAPENTRY_INT_INT_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<int, int>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Expando<int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<int, int>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Expando<String>>', true);
  static const MAP_MAPENTRY_INT_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, WeakReference<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<int, int>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, WeakReference<int>>', true);
  static const MAP_MAPENTRY_INT_INT_WEAKREFERENCE_STRING = DartType._withName(
    'Map<MapEntry<int, int>, WeakReference<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Map<bool, bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<bool, double>>', true);
  static const MAP_MAPENTRY_INT_INT_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<int, int>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Map<bool, int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<int, int>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<bool, String>>', true);
  static const MAP_MAPENTRY_INT_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<double, bool>>', true);
  static const MAP_MAPENTRY_INT_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<int, int>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<double, int>>', true);
  static const MAP_MAPENTRY_INT_INT_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<int, int>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<double, String>>', true);
  static const MAP_MAPENTRY_INT_INT_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Map<int, bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<int, double>>', true);
  static const MAP_MAPENTRY_INT_INT_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<int, int>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, int>, Map<int, int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<int, int>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<int, String>>', true);
  static const MAP_MAPENTRY_INT_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<String, bool>>', true);
  static const MAP_MAPENTRY_INT_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<String, double>>', true);
  static const MAP_MAPENTRY_INT_INT_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<int, int>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAP_STRING_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, Map<String, String>>', true);
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, MapEntry<bool, bool>>', true);
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, MapEntry<bool, int>>', true);
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, MapEntry<int, bool>>', true);
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, int>, MapEntry<int, int>>', true);
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'Map<MapEntry<int, int>, MapEntry<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, int>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, bool>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, String>, bool>',
    true,
  );
  static const MAP_MAPENTRY_INT_STRING_INT = DartType._withName(
    'Map<MapEntry<int, String>, int>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, String>, int>',
    true,
  );
  static const MAP_MAPENTRY_INT_STRING_STRING = DartType._withName(
    'Map<MapEntry<int, String>, String>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<int, String>, String>',
    true,
  );
  static const MAP_MAPENTRY_INT_STRING_LIST_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, String>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_STRING_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<int, String>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, List<double>>', true);
  static const MAP_MAPENTRY_INT_STRING_LIST_INT = DartType._withName(
    'Map<MapEntry<int, String>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<int, String>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_INT_STRING_LIST_STRING = DartType._withName(
    'Map<MapEntry<int, String>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, List<String>>', true);
  static const MAP_MAPENTRY_INT_STRING_SET_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<int, String>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_INT_STRING_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<int, String>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<int, String>, Set<double>>',
    true,
  );
  static const MAP_MAPENTRY_INT_STRING_SET_STRING = DartType._withName(
    'Map<MapEntry<int, String>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_SET_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<int, String>, Set<String>>',
    true,
  );
  static const MAP_MAPENTRY_INT_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Expando<bool>>', true);
  static const MAP_MAPENTRY_INT_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<int, String>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Expando<double>>', true);
  static const MAP_MAPENTRY_INT_STRING_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<int, String>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Expando<int>>', true);
  static const MAP_MAPENTRY_INT_STRING_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<int, String>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Expando<String>>', true);
  static const MAP_MAPENTRY_INT_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<int, String>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_INT_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<int, String>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<int, String>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<bool, double>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<int, String>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<int, String>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<bool, String>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<double, bool>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<int, String>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<int, String>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<double, int>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<int, String>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<int, String>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<int, double>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<int, String>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<int, int>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<int, String>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<int, String>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<String, bool>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<int, String>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<int, String>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<int, String>, Map<String, int>>', true);
  static const MAP_MAPENTRY_INT_STRING_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<int, String>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<int, String>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<int, String>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<int, String>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<int, String>, MapEntry<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'Map<MapEntry<int, String>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'Map<MapEntry<int, String>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_INT_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<int, String>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, bool>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<String, bool>, bool>',
    true,
  );
  static const MAP_MAPENTRY_STRING_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<String, bool>, double>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<String, bool>, double>',
    true,
  );
  static const MAP_MAPENTRY_STRING_BOOL_INT = DartType._withName(
    'Map<MapEntry<String, bool>, int>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<String, bool>, int>',
    true,
  );
  static const MAP_MAPENTRY_STRING_BOOL_LIST_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<String, bool>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_BOOL_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<String, bool>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, List<double>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_LIST_INT = DartType._withName(
    'Map<MapEntry<String, bool>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<String, bool>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_BOOL_LIST_STRING = DartType._withName(
    'Map<MapEntry<String, bool>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, List<String>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_SET_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<String, bool>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_BOOL_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<String, bool>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_SET_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Set<double>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_SET_INT = DartType._withName(
    'Map<MapEntry<String, bool>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<String, bool>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_BOOL_SET_STRING = DartType._withName(
    'Map<MapEntry<String, bool>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_SET_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Set<String>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<String, bool>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Expando<double>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<String, bool>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Expando<int>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<String, bool>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Expando<String>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'Map<MapEntry<String, bool>, WeakReference<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<String, bool>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<String, bool>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<String, bool>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, Map<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, Map<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<String, bool>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<String, bool>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Map<double, int>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<String, bool>, Map<double, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<String, bool>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Map<int, double>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<String, bool>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Map<int, int>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, Map<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<String, bool>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<String, bool>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, bool>, Map<String, int>>', true);
  static const MAP_MAPENTRY_STRING_BOOL_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<String, bool>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<String, bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<double, int>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<String, bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<int, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<String, bool>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_INT_STRING =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<int, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<String, int>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, bool>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<String, double>, bool>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<String, double>, bool>',
    true,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<String, double>, double>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<String, double>, double>',
    true,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<String, double>, int>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<String, double>, int>',
    true,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_STRING = DartType._withName(
    'Map<MapEntry<String, double>, String>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<String, double>, String>',
    true,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_LIST_BOOL = DartType._withName(
    'Map<MapEntry<String, double>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_LIST_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, List<bool>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<String, double>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, List<double>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_LIST_STRING = DartType._withName(
    'Map<MapEntry<String, double>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, List<String>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_SET_BOOL = DartType._withName(
    'Map<MapEntry<String, double>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_SET_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, Set<bool>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<String, double>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_SET_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, Set<double>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_SET_INT = DartType._withName(
    'Map<MapEntry<String, double>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<String, double>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_SET_STRING = DartType._withName(
    'Map<MapEntry<String, double>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_SET_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, Set<String>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<String, double>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, Expando<bool>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<String, double>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Expando<double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<String, double>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, Expando<int>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_WEAKREFERENCE_BOOL =
      DartType._withName(
        'Map<MapEntry<String, double>, WeakReference<bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, double>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_WEAKREFERENCE_INT =
      DartType._withName(
        'Map<MapEntry<String, double>, WeakReference<int>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<String, double>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<String, double>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<String, double>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<String, double>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<String, double>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<String, double>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<String, double>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<String, double>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<String, double>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, double>, Map<int, int>>', true);
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<String, double>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<String, double>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<String, double>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_BOOL_BOOL =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<bool, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_BOOL_INT =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<bool, int>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_INT_BOOL =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<int, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<int, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<String, double>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_INT_STRING =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<int, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<String, int>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, double>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<String, int>, double>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<String, int>, double>',
    true,
  );
  static const MAP_MAPENTRY_STRING_INT_INT = DartType._withName(
    'Map<MapEntry<String, int>, int>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<String, int>, int>',
    true,
  );
  static const MAP_MAPENTRY_STRING_INT_STRING = DartType._withName(
    'Map<MapEntry<String, int>, String>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<String, int>, String>',
    true,
  );
  static const MAP_MAPENTRY_STRING_INT_LIST_BOOL = DartType._withName(
    'Map<MapEntry<String, int>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<String, int>, List<bool>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_INT_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<String, int>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, List<double>>', true);
  static const MAP_MAPENTRY_STRING_INT_LIST_INT = DartType._withName(
    'Map<MapEntry<String, int>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_LIST_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<String, int>, List<int>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_INT_LIST_STRING = DartType._withName(
    'Map<MapEntry<String, int>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, List<String>>', true);
  static const MAP_MAPENTRY_STRING_INT_SET_BOOL = DartType._withName(
    'Map<MapEntry<String, int>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_SET_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<String, int>, Set<bool>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_INT_SET_INT = DartType._withName(
    'Map<MapEntry<String, int>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<String, int>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_INT_SET_STRING = DartType._withName(
    'Map<MapEntry<String, int>, Set<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_SET_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<String, int>, Set<String>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_INT_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<String, int>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Expando<bool>>', true);
  static const MAP_MAPENTRY_STRING_INT_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<String, int>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Expando<double>>', true);
  static const MAP_MAPENTRY_STRING_INT_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<String, int>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Expando<int>>', true);
  static const MAP_MAPENTRY_STRING_INT_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<String, int>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_EXPANDO_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Expando<String>>', true);
  static const MAP_MAPENTRY_STRING_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'Map<MapEntry<String, int>, WeakReference<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, int>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<String, int>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAP_BOOL_BOOL = DartType._withName(
    'Map<MapEntry<String, int>, Map<bool, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<bool, bool>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<String, int>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<bool, double>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<String, int>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<String, int>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<bool, String>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<String, int>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<double, bool>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'Map<MapEntry<String, int>, Map<double, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<String, int>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<double, int>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<String, int>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<String, int>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<int, double>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_INT_INT = DartType._withName(
    'Map<MapEntry<String, int>, Map<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_INT_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<int, int>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<String, int>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_INT_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<int, String>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<String, int>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<String, bool>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<String, int>, Map<String, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<String, int>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_STRING_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, int>, Map<String, int>>', true);
  static const MAP_MAPENTRY_STRING_INT_MAP_STRING_STRING = DartType._withName(
    'Map<MapEntry<String, int>, Map<String, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'Map<MapEntry<String, int>, MapEntry<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<bool, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<String, int>, MapEntry<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'Map<MapEntry<String, int>, MapEntry<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<String, int>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_INT_STRING = DartType._withName(
    'Map<MapEntry<String, int>, MapEntry<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<String, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_STRING_INT = DartType._withName(
    'Map<MapEntry<String, int>, MapEntry<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, int>, MapEntry<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_BOOL = DartType._withName(
    'Map<MapEntry<String, String>, bool>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_BOOL_NULLABLE = DartType._withName(
    'Map<MapEntry<String, String>, bool>',
    true,
  );
  static const MAP_MAPENTRY_STRING_STRING_DOUBLE = DartType._withName(
    'Map<MapEntry<String, String>, double>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_DOUBLE_NULLABLE = DartType._withName(
    'Map<MapEntry<String, String>, double>',
    true,
  );
  static const MAP_MAPENTRY_STRING_STRING_STRING = DartType._withName(
    'Map<MapEntry<String, String>, String>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_STRING_NULLABLE = DartType._withName(
    'Map<MapEntry<String, String>, String>',
    true,
  );
  static const MAP_MAPENTRY_STRING_STRING_LIST_BOOL = DartType._withName(
    'Map<MapEntry<String, String>, List<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_LIST_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, List<bool>>', true);
  static const MAP_MAPENTRY_STRING_STRING_LIST_DOUBLE = DartType._withName(
    'Map<MapEntry<String, String>, List<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_LIST_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, List<double>>', true);
  static const MAP_MAPENTRY_STRING_STRING_LIST_INT = DartType._withName(
    'Map<MapEntry<String, String>, List<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_LIST_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, List<int>>', true);
  static const MAP_MAPENTRY_STRING_STRING_LIST_STRING = DartType._withName(
    'Map<MapEntry<String, String>, List<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_LIST_STRING_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, List<String>>', true);
  static const MAP_MAPENTRY_STRING_STRING_SET_BOOL = DartType._withName(
    'Map<MapEntry<String, String>, Set<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_SET_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, Set<bool>>', true);
  static const MAP_MAPENTRY_STRING_STRING_SET_DOUBLE = DartType._withName(
    'Map<MapEntry<String, String>, Set<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_SET_DOUBLE_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, Set<double>>', true);
  static const MAP_MAPENTRY_STRING_STRING_SET_INT = DartType._withName(
    'Map<MapEntry<String, String>, Set<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_SET_INT_NULLABLE = DartType._withName(
    'Map<MapEntry<String, String>, Set<int>>',
    true,
  );
  static const MAP_MAPENTRY_STRING_STRING_EXPANDO_BOOL = DartType._withName(
    'Map<MapEntry<String, String>, Expando<bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_EXPANDO_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, Expando<bool>>', true);
  static const MAP_MAPENTRY_STRING_STRING_EXPANDO_DOUBLE = DartType._withName(
    'Map<MapEntry<String, String>, Expando<double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Expando<double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_EXPANDO_INT = DartType._withName(
    'Map<MapEntry<String, String>, Expando<int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_EXPANDO_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, Expando<int>>', true);
  static const MAP_MAPENTRY_STRING_STRING_EXPANDO_STRING = DartType._withName(
    'Map<MapEntry<String, String>, Expando<String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_EXPANDO_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Expando<String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_WEAKREFERENCE_BOOL =
      DartType._withName(
        'Map<MapEntry<String, String>, WeakReference<bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, WeakReference<bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, String>, WeakReference<double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, WeakReference<double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_WEAKREFERENCE_INT =
      DartType._withName(
        'Map<MapEntry<String, String>, WeakReference<int>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, WeakReference<int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_WEAKREFERENCE_STRING =
      DartType._withName(
        'Map<MapEntry<String, String>, WeakReference<String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, WeakReference<String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'Map<MapEntry<String, String>, Map<bool, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_BOOL_INT = DartType._withName(
    'Map<MapEntry<String, String>, Map<bool, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_BOOL_INT_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, Map<bool, int>>', true);
  static const MAP_MAPENTRY_STRING_STRING_MAP_BOOL_STRING = DartType._withName(
    'Map<MapEntry<String, String>, Map<bool, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<bool, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'Map<MapEntry<String, String>, Map<double, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_DOUBLE_INT = DartType._withName(
    'Map<MapEntry<String, String>, Map<double, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_INT_BOOL = DartType._withName(
    'Map<MapEntry<String, String>, Map<int, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_INT_BOOL_NULLABLE =
      DartType._withName('Map<MapEntry<String, String>, Map<int, bool>>', true);
  static const MAP_MAPENTRY_STRING_STRING_MAP_INT_DOUBLE = DartType._withName(
    'Map<MapEntry<String, String>, Map<int, double>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_INT_STRING = DartType._withName(
    'Map<MapEntry<String, String>, Map<int, String>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_STRING_BOOL = DartType._withName(
    'Map<MapEntry<String, String>, Map<String, bool>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<String, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_STRING_INT = DartType._withName(
    'Map<MapEntry<String, String>, Map<String, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAP_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, Map<String, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_BOOL_BOOL =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<bool, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<bool, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<bool, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<bool, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_BOOL_INT =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<bool, int>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<bool, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<double, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<double, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<double, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<double, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<double, int>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<double, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<double, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<double, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_INT_BOOL =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<int, bool>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<int, bool>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<int, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<int, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_INT_INT = DartType._withName(
    'Map<MapEntry<String, String>, MapEntry<int, int>>',
    false,
  );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<int, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_INT_STRING =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<int, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<int, String>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<String, double>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<String, double>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_STRING_INT =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<String, int>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<String, int>>',
        true,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_STRING_STRING =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<String, String>>',
        false,
      );
  static const MAP_MAPENTRY_STRING_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'Map<MapEntry<String, String>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_BOOL_LIST_BOOL = DartType._withName(
    'MapEntry<bool, List<bool>>',
    false,
  );
  static const MAPENTRY_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, List<bool>>',
    true,
  );
  static const MAPENTRY_BOOL_LIST_INT = DartType._withName(
    'MapEntry<bool, List<int>>',
    false,
  );
  static const MAPENTRY_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, List<int>>',
    true,
  );
  static const MAPENTRY_BOOL_LIST_STRING = DartType._withName(
    'MapEntry<bool, List<String>>',
    false,
  );
  static const MAPENTRY_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, List<String>>',
    true,
  );
  static const MAPENTRY_BOOL_SET_BOOL = DartType._withName(
    'MapEntry<bool, Set<bool>>',
    false,
  );
  static const MAPENTRY_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, Set<bool>>',
    true,
  );
  static const MAPENTRY_BOOL_SET_DOUBLE = DartType._withName(
    'MapEntry<bool, Set<double>>',
    false,
  );
  static const MAPENTRY_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, Set<double>>',
    true,
  );
  static const MAPENTRY_BOOL_SET_INT = DartType._withName(
    'MapEntry<bool, Set<int>>',
    false,
  );
  static const MAPENTRY_BOOL_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, Set<int>>',
    true,
  );
  static const MAPENTRY_BOOL_SET_STRING = DartType._withName(
    'MapEntry<bool, Set<String>>',
    false,
  );
  static const MAPENTRY_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, Set<String>>',
    true,
  );
  static const MAPENTRY_BOOL_EXPANDO_BOOL = DartType._withName(
    'MapEntry<bool, Expando<bool>>',
    false,
  );
  static const MAPENTRY_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, Expando<bool>>',
    true,
  );
  static const MAPENTRY_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<bool, Expando<double>>',
    false,
  );
  static const MAPENTRY_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, Expando<double>>',
    true,
  );
  static const MAPENTRY_BOOL_EXPANDO_STRING = DartType._withName(
    'MapEntry<bool, Expando<String>>',
    false,
  );
  static const MAPENTRY_BOOL_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, Expando<String>>',
    true,
  );
  static const MAPENTRY_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<bool, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_BOOL_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, WeakReference<bool>>',
    true,
  );
  static const MAPENTRY_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<bool, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, WeakReference<double>>',
    true,
  );
  static const MAPENTRY_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<bool, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_BOOL_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, WeakReference<int>>',
    true,
  );
  static const MAPENTRY_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<bool, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_BOOL_WEAKREFERENCE_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, WeakReference<String>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<bool, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<bool, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<bool, double>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_BOOL_INT = DartType._withName(
    'MapEntry<bool, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<bool, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<double, bool>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<bool, Map<double, double>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<double, double>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<bool, Map<double, int>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<double, int>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<bool, Map<double, String>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<double, String>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_INT_BOOL = DartType._withName(
    'MapEntry<bool, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<bool, Map<int, double>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<int, double>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_INT_INT = DartType._withName(
    'MapEntry<bool, Map<int, int>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<int, int>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_INT_STRING = DartType._withName(
    'MapEntry<bool, Map<int, String>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<int, String>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<bool, Map<String, double>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<String, double>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_STRING_INT = DartType._withName(
    'MapEntry<bool, Map<String, int>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<String, int>>',
    true,
  );
  static const MAPENTRY_BOOL_MAP_STRING_STRING = DartType._withName(
    'MapEntry<bool, Map<String, String>>',
    false,
  );
  static const MAPENTRY_BOOL_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, Map<String, String>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<bool, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<bool, bool>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<bool, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<bool, double>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<bool, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<bool, int>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<bool, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<bool, String>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<bool, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<double, bool>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<bool, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<double, int>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<bool, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<bool, MapEntry<double, String>>', true);
  static const MAPENTRY_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<bool, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<int, bool>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<bool, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<int, double>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<bool, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<int, int>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<bool, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<int, String>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<bool, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<bool, MapEntry<String, bool>>',
    true,
  );
  static const MAPENTRY_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<bool, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<bool, MapEntry<String, double>>', true);
  static const MAPENTRY_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<bool, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<bool, MapEntry<String, String>>', true);
  static const MAPENTRY_DOUBLE_LIST_BOOL = DartType._withName(
    'MapEntry<double, List<bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<double, List<bool>>',
    true,
  );
  static const MAPENTRY_DOUBLE_LIST_DOUBLE = DartType._withName(
    'MapEntry<double, List<double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<double, List<double>>',
    true,
  );
  static const MAPENTRY_DOUBLE_LIST_INT = DartType._withName(
    'MapEntry<double, List<int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<double, List<int>>',
    true,
  );
  static const MAPENTRY_DOUBLE_LIST_STRING = DartType._withName(
    'MapEntry<double, List<String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<double, List<String>>',
    true,
  );
  static const MAPENTRY_DOUBLE_SET_DOUBLE = DartType._withName(
    'MapEntry<double, Set<double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<double, Set<double>>',
    true,
  );
  static const MAPENTRY_DOUBLE_SET_INT = DartType._withName(
    'MapEntry<double, Set<int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<double, Set<int>>',
    true,
  );
  static const MAPENTRY_DOUBLE_SET_STRING = DartType._withName(
    'MapEntry<double, Set<String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<double, Set<String>>',
    true,
  );
  static const MAPENTRY_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'MapEntry<double, Expando<bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<double, Expando<bool>>',
    true,
  );
  static const MAPENTRY_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<double, Expando<double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<double, Expando<double>>',
    true,
  );
  static const MAPENTRY_DOUBLE_EXPANDO_INT = DartType._withName(
    'MapEntry<double, Expando<int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<double, Expando<int>>',
    true,
  );
  static const MAPENTRY_DOUBLE_EXPANDO_STRING = DartType._withName(
    'MapEntry<double, Expando<String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<double, Expando<String>>',
    true,
  );
  static const MAPENTRY_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<double, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<double, WeakReference<bool>>',
    true,
  );
  static const MAPENTRY_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<double, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'MapEntry<double, WeakReference<int>>',
    true,
  );
  static const MAPENTRY_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<double, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<double, WeakReference<String>>', true);
  static const MAPENTRY_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<double, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<double, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<double, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<double, Map<bool, double>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'MapEntry<double, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<double, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<double, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<double, Map<bool, String>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<double, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<double, Map<double, bool>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<double, Map<double, double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<double, Map<double, double>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<double, Map<double, String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'MapEntry<double, Map<double, String>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'MapEntry<double, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<double, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<double, Map<int, double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<double, Map<int, double>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_INT_INT = DartType._withName(
    'MapEntry<double, Map<int, int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<double, Map<int, int>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_INT_STRING = DartType._withName(
    'MapEntry<double, Map<int, String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<double, Map<int, String>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<double, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<double, Map<String, bool>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<double, Map<String, double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<double, Map<String, double>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAP_STRING_INT = DartType._withName(
    'MapEntry<double, Map<String, int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAP_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<double, Map<String, int>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<double, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<double, MapEntry<bool, bool>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<double, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<bool, double>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<double, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<double, MapEntry<bool, int>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<double, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<bool, String>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<double, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<double, bool>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<double, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<double, double>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<double, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<double, int>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<double, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<double, String>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<double, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<int, double>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<double, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<double, MapEntry<int, int>>',
    true,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<double, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<int, String>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<double, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<String, bool>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<double, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<String, double>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<double, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<String, int>>', true);
  static const MAPENTRY_DOUBLE_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<double, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<double, MapEntry<String, String>>', true);
  static const MAPENTRY_INT_LIST_BOOL = DartType._withName(
    'MapEntry<int, List<bool>>',
    false,
  );
  static const MAPENTRY_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, List<bool>>',
    true,
  );
  static const MAPENTRY_INT_LIST_DOUBLE = DartType._withName(
    'MapEntry<int, List<double>>',
    false,
  );
  static const MAPENTRY_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, List<double>>',
    true,
  );
  static const MAPENTRY_INT_LIST_INT = DartType._withName(
    'MapEntry<int, List<int>>',
    false,
  );
  static const MAPENTRY_INT_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<int, List<int>>',
    true,
  );
  static const MAPENTRY_INT_LIST_STRING = DartType._withName(
    'MapEntry<int, List<String>>',
    false,
  );
  static const MAPENTRY_INT_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<int, List<String>>',
    true,
  );
  static const MAPENTRY_INT_SET_BOOL = DartType._withName(
    'MapEntry<int, Set<bool>>',
    false,
  );
  static const MAPENTRY_INT_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, Set<bool>>',
    true,
  );
  static const MAPENTRY_INT_SET_DOUBLE = DartType._withName(
    'MapEntry<int, Set<double>>',
    false,
  );
  static const MAPENTRY_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, Set<double>>',
    true,
  );
  static const MAPENTRY_INT_SET_STRING = DartType._withName(
    'MapEntry<int, Set<String>>',
    false,
  );
  static const MAPENTRY_INT_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<int, Set<String>>',
    true,
  );
  static const MAPENTRY_INT_EXPANDO_BOOL = DartType._withName(
    'MapEntry<int, Expando<bool>>',
    false,
  );
  static const MAPENTRY_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, Expando<bool>>',
    true,
  );
  static const MAPENTRY_INT_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<int, Expando<double>>',
    false,
  );
  static const MAPENTRY_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, Expando<double>>',
    true,
  );
  static const MAPENTRY_INT_EXPANDO_INT = DartType._withName(
    'MapEntry<int, Expando<int>>',
    false,
  );
  static const MAPENTRY_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<int, Expando<int>>',
    true,
  );
  static const MAPENTRY_INT_EXPANDO_STRING = DartType._withName(
    'MapEntry<int, Expando<String>>',
    false,
  );
  static const MAPENTRY_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<int, Expando<String>>',
    true,
  );
  static const MAPENTRY_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<int, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_INT_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, WeakReference<bool>>',
    true,
  );
  static const MAPENTRY_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<int, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_INT_WEAKREFERENCE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, WeakReference<double>>',
    true,
  );
  static const MAPENTRY_INT_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<int, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_INT_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'MapEntry<int, WeakReference<int>>',
    true,
  );
  static const MAPENTRY_INT_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<int, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<int, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_INT_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, Map<bool, double>>',
    true,
  );
  static const MAPENTRY_INT_MAP_BOOL_INT = DartType._withName(
    'MapEntry<int, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<int, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_INT_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<int, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<int, Map<bool, String>>',
    true,
  );
  static const MAPENTRY_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<int, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, Map<double, bool>>',
    true,
  );
  static const MAPENTRY_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<int, Map<double, double>>',
    false,
  );
  static const MAPENTRY_INT_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, Map<double, double>>',
    true,
  );
  static const MAPENTRY_INT_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<int, Map<double, int>>',
    false,
  );
  static const MAPENTRY_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<int, Map<double, int>>',
    true,
  );
  static const MAPENTRY_INT_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<int, Map<double, String>>',
    false,
  );
  static const MAPENTRY_INT_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'MapEntry<int, Map<double, String>>',
    true,
  );
  static const MAPENTRY_INT_MAP_INT_BOOL = DartType._withName(
    'MapEntry<int, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_INT_MAP_INT_INT = DartType._withName(
    'MapEntry<int, Map<int, int>>',
    false,
  );
  static const MAPENTRY_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<int, Map<int, int>>',
    true,
  );
  static const MAPENTRY_INT_MAP_INT_STRING = DartType._withName(
    'MapEntry<int, Map<int, String>>',
    false,
  );
  static const MAPENTRY_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<int, Map<int, String>>',
    true,
  );
  static const MAPENTRY_INT_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<int, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, Map<String, bool>>',
    true,
  );
  static const MAPENTRY_INT_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<int, Map<String, double>>',
    false,
  );
  static const MAPENTRY_INT_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, Map<String, double>>',
    true,
  );
  static const MAPENTRY_INT_MAP_STRING_INT = DartType._withName(
    'MapEntry<int, Map<String, int>>',
    false,
  );
  static const MAPENTRY_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<int, Map<String, int>>',
    true,
  );
  static const MAPENTRY_INT_MAP_STRING_STRING = DartType._withName(
    'MapEntry<int, Map<String, String>>',
    false,
  );
  static const MAPENTRY_INT_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'MapEntry<int, Map<String, String>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<int, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<bool, bool>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<int, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<bool, double>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<int, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<bool, String>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<int, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<double, bool>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<int, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<int, MapEntry<double, double>>', true);
  static const MAPENTRY_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<int, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<double, int>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<int, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<int, MapEntry<double, String>>', true);
  static const MAPENTRY_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<int, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<int, bool>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<int, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<int, double>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<int, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<int, int>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<int, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<String, bool>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<int, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<int, MapEntry<String, double>>', true);
  static const MAPENTRY_INT_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<int, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<int, MapEntry<String, int>>',
    true,
  );
  static const MAPENTRY_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<int, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<int, MapEntry<String, String>>', true);
  static const MAPENTRY_STRING_LIST_DOUBLE = DartType._withName(
    'MapEntry<String, List<double>>',
    false,
  );
  static const MAPENTRY_STRING_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<String, List<double>>',
    true,
  );
  static const MAPENTRY_STRING_LIST_INT = DartType._withName(
    'MapEntry<String, List<int>>',
    false,
  );
  static const MAPENTRY_STRING_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<String, List<int>>',
    true,
  );
  static const MAPENTRY_STRING_LIST_STRING = DartType._withName(
    'MapEntry<String, List<String>>',
    false,
  );
  static const MAPENTRY_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<String, List<String>>',
    true,
  );
  static const MAPENTRY_STRING_SET_BOOL = DartType._withName(
    'MapEntry<String, Set<bool>>',
    false,
  );
  static const MAPENTRY_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, Set<bool>>',
    true,
  );
  static const MAPENTRY_STRING_SET_DOUBLE = DartType._withName(
    'MapEntry<String, Set<double>>',
    false,
  );
  static const MAPENTRY_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<String, Set<double>>',
    true,
  );
  static const MAPENTRY_STRING_SET_INT = DartType._withName(
    'MapEntry<String, Set<int>>',
    false,
  );
  static const MAPENTRY_STRING_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<String, Set<int>>',
    true,
  );
  static const MAPENTRY_STRING_SET_STRING = DartType._withName(
    'MapEntry<String, Set<String>>',
    false,
  );
  static const MAPENTRY_STRING_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<String, Set<String>>',
    true,
  );
  static const MAPENTRY_STRING_EXPANDO_BOOL = DartType._withName(
    'MapEntry<String, Expando<bool>>',
    false,
  );
  static const MAPENTRY_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, Expando<bool>>',
    true,
  );
  static const MAPENTRY_STRING_EXPANDO_INT = DartType._withName(
    'MapEntry<String, Expando<int>>',
    false,
  );
  static const MAPENTRY_STRING_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<String, Expando<int>>',
    true,
  );
  static const MAPENTRY_STRING_EXPANDO_STRING = DartType._withName(
    'MapEntry<String, Expando<String>>',
    false,
  );
  static const MAPENTRY_STRING_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<String, Expando<String>>',
    true,
  );
  static const MAPENTRY_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<String, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_STRING_WEAKREFERENCE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, WeakReference<bool>>',
    true,
  );
  static const MAPENTRY_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<String, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<String, WeakReference<double>>', true);
  static const MAPENTRY_STRING_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<String, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_STRING_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'MapEntry<String, WeakReference<int>>',
    true,
  );
  static const MAPENTRY_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<String, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<String, WeakReference<String>>', true);
  static const MAPENTRY_STRING_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<String, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<String, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<String, Map<bool, double>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<String, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<String, Map<bool, String>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<String, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, Map<double, bool>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<String, Map<double, double>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<String, Map<double, double>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<String, Map<double, int>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<String, Map<double, int>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<String, Map<double, String>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'MapEntry<String, Map<double, String>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_INT_BOOL = DartType._withName(
    'MapEntry<String, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<String, Map<int, double>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<String, Map<int, double>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_INT_INT = DartType._withName(
    'MapEntry<String, Map<int, int>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<String, Map<int, int>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<String, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, Map<String, bool>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<String, Map<String, double>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<String, Map<String, double>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_STRING_INT = DartType._withName(
    'MapEntry<String, Map<String, int>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<String, Map<String, int>>',
    true,
  );
  static const MAPENTRY_STRING_MAP_STRING_STRING = DartType._withName(
    'MapEntry<String, Map<String, String>>',
    false,
  );
  static const MAPENTRY_STRING_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'MapEntry<String, Map<String, String>>',
    true,
  );
  static const MAPENTRY_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<String, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, MapEntry<bool, bool>>',
    true,
  );
  static const MAPENTRY_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<String, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<bool, double>>', true);
  static const MAPENTRY_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<String, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<String, MapEntry<bool, int>>',
    true,
  );
  static const MAPENTRY_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<String, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<bool, String>>', true);
  static const MAPENTRY_STRING_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<String, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<double, double>>', true);
  static const MAPENTRY_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<String, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<double, int>>', true);
  static const MAPENTRY_STRING_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<String, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<double, String>>', true);
  static const MAPENTRY_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<String, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<String, MapEntry<int, bool>>',
    true,
  );
  static const MAPENTRY_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<String, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<int, double>>', true);
  static const MAPENTRY_STRING_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<String, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<String, MapEntry<int, int>>',
    true,
  );
  static const MAPENTRY_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<String, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<int, String>>', true);
  static const MAPENTRY_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<String, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<String, bool>>', true);
  static const MAPENTRY_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<String, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<String, int>>', true);
  static const MAPENTRY_STRING_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<String, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<String, MapEntry<String, String>>', true);
  static const MAPENTRY_LIST_BOOL_BOOL = DartType._withName(
    'MapEntry<List<bool>, bool>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, bool>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, double>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, double>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_INT = DartType._withName(
    'MapEntry<List<bool>, int>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, int>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_STRING = DartType._withName(
    'MapEntry<List<bool>, String>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, String>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_LIST_BOOL = DartType._withName(
    'MapEntry<List<bool>, List<bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, List<bool>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_LIST_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, List<double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, List<double>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_LIST_INT = DartType._withName(
    'MapEntry<List<bool>, List<int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, List<int>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_SET_BOOL = DartType._withName(
    'MapEntry<List<bool>, Set<bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Set<bool>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_SET_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, Set<double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Set<double>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_SET_INT = DartType._withName(
    'MapEntry<List<bool>, Set<int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Set<int>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_SET_STRING = DartType._withName(
    'MapEntry<List<bool>, Set<String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Set<String>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_EXPANDO_BOOL = DartType._withName(
    'MapEntry<List<bool>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Expando<bool>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, Expando<double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Expando<double>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_EXPANDO_INT = DartType._withName(
    'MapEntry<List<bool>, Expando<int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Expando<int>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_EXPANDO_STRING = DartType._withName(
    'MapEntry<List<bool>, Expando<String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Expando<String>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<bool>, WeakReference<double>>', true);
  static const MAPENTRY_LIST_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<List<bool>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('MapEntry<List<bool>, WeakReference<int>>', true);
  static const MAPENTRY_LIST_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<List<bool>, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<List<bool>, WeakReference<String>>', true);
  static const MAPENTRY_LIST_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<List<bool>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<bool, double>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_BOOL_INT = DartType._withName(
    'MapEntry<List<bool>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<List<bool>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<bool, String>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<List<bool>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<double, bool>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<List<bool>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<double, int>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<List<bool>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<List<bool>, Map<double, String>>', true);
  static const MAPENTRY_LIST_BOOL_MAP_INT_BOOL = DartType._withName(
    'MapEntry<List<bool>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<int, double>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_INT_INT = DartType._withName(
    'MapEntry<List<bool>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<int, int>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_INT_STRING = DartType._withName(
    'MapEntry<List<bool>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<int, String>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<List<bool>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<bool>, Map<String, bool>>',
    true,
  );
  static const MAPENTRY_LIST_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<bool>, Map<String, double>>', true);
  static const MAPENTRY_LIST_BOOL_MAP_STRING_STRING = DartType._withName(
    'MapEntry<List<bool>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<List<bool>, Map<String, String>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<List<bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<bool, bool>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<bool, double>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<List<bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<bool, int>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<List<bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<bool, String>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<List<bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<double, bool>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<List<bool>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<List<bool>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<double, int>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<List<bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<int, bool>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<int, double>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<List<bool>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<int, int>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<List<bool>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<int, String>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<List<bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<String, bool>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<List<bool>, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<List<bool>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<List<bool>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<List<bool>, MapEntry<String, int>>', true);
  static const MAPENTRY_LIST_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<List<bool>, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_LIST_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<List<bool>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_LIST_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<List<double>, double>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<double>, double>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_INT = DartType._withName(
    'MapEntry<List<double>, int>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<List<double>, int>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_STRING = DartType._withName(
    'MapEntry<List<double>, String>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<double>, String>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_LIST_BOOL = DartType._withName(
    'MapEntry<List<double>, List<bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<double>, List<bool>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_LIST_DOUBLE = DartType._withName(
    'MapEntry<List<double>, List<double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<double>, List<double>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_LIST_INT = DartType._withName(
    'MapEntry<List<double>, List<int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<List<double>, List<int>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_LIST_STRING = DartType._withName(
    'MapEntry<List<double>, List<String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<double>, List<String>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_SET_BOOL = DartType._withName(
    'MapEntry<List<double>, Set<bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<double>, Set<bool>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_SET_INT = DartType._withName(
    'MapEntry<List<double>, Set<int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<List<double>, Set<int>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_SET_STRING = DartType._withName(
    'MapEntry<List<double>, Set<String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<double>, Set<String>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'MapEntry<List<double>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<double>, Expando<bool>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<List<double>, Expando<double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<double>, Expando<double>>', true);
  static const MAPENTRY_LIST_DOUBLE_EXPANDO_INT = DartType._withName(
    'MapEntry<List<double>, Expando<int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<List<double>, Expando<int>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_EXPANDO_STRING = DartType._withName(
    'MapEntry<List<double>, Expando<String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_EXPANDO_STRING_NULLABLE =
      DartType._withName('MapEntry<List<double>, Expando<String>>', true);
  static const MAPENTRY_LIST_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<List<double>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<double>, WeakReference<bool>>', true);
  static const MAPENTRY_LIST_DOUBLE_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<List<double>, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<double>, WeakReference<double>>', true);
  static const MAPENTRY_LIST_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<List<double>, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<List<double>, WeakReference<String>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<List<double>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<double>, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<List<double>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<bool, double>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'MapEntry<List<double>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<List<double>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<List<double>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<bool, String>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<List<double>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<double, bool>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<List<double>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<double, double>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<List<double>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<double, int>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<List<double>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<double, String>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<List<double>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<int, double>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_INT_INT = DartType._withName(
    'MapEntry<List<double>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<List<double>, Map<int, int>>',
    true,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_INT_STRING = DartType._withName(
    'MapEntry<List<double>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<int, String>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<List<double>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<String, bool>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<List<double>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<String, double>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_STRING_INT = DartType._withName(
    'MapEntry<List<double>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<String, int>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'MapEntry<List<double>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<List<double>, Map<String, String>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<List<double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<double>, MapEntry<bool, bool>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<List<double>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<List<double>, MapEntry<bool, int>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<List<double>, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<List<double>, MapEntry<bool, String>>',
        true,
      );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<List<double>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<List<double>, MapEntry<double, bool>>',
        true,
      );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<List<double>, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<List<double>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<List<double>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<List<double>, MapEntry<double, int>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<List<double>, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<List<double>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<List<double>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<double>, MapEntry<int, bool>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<List<double>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<double>, MapEntry<int, double>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<List<double>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<List<double>, MapEntry<int, String>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<List<double>, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<List<double>, MapEntry<String, bool>>',
        true,
      );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<List<double>, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<List<double>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<List<double>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<List<double>, MapEntry<String, int>>', true);
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<List<double>, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_LIST_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<List<double>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_LIST_INT_BOOL = DartType._withName(
    'MapEntry<List<int>, bool>',
    false,
  );
  static const MAPENTRY_LIST_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<int>, bool>',
    true,
  );
  static const MAPENTRY_LIST_INT_DOUBLE = DartType._withName(
    'MapEntry<List<int>, double>',
    false,
  );
  static const MAPENTRY_LIST_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<int>, double>',
    true,
  );
  static const MAPENTRY_LIST_INT_INT = DartType._withName(
    'MapEntry<List<int>, int>',
    false,
  );
  static const MAPENTRY_LIST_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<List<int>, int>',
    true,
  );
  static const MAPENTRY_LIST_INT_LIST_BOOL = DartType._withName(
    'MapEntry<List<int>, List<bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<int>, List<bool>>',
    true,
  );
  static const MAPENTRY_LIST_INT_LIST_DOUBLE = DartType._withName(
    'MapEntry<List<int>, List<double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<int>, List<double>>',
    true,
  );
  static const MAPENTRY_LIST_INT_LIST_INT = DartType._withName(
    'MapEntry<List<int>, List<int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<List<int>, List<int>>',
    true,
  );
  static const MAPENTRY_LIST_INT_LIST_STRING = DartType._withName(
    'MapEntry<List<int>, List<String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<int>, List<String>>',
    true,
  );
  static const MAPENTRY_LIST_INT_SET_BOOL = DartType._withName(
    'MapEntry<List<int>, Set<bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Set<bool>>',
    true,
  );
  static const MAPENTRY_LIST_INT_SET_DOUBLE = DartType._withName(
    'MapEntry<List<int>, Set<double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Set<double>>',
    true,
  );
  static const MAPENTRY_LIST_INT_SET_INT = DartType._withName(
    'MapEntry<List<int>, Set<int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Set<int>>',
    true,
  );
  static const MAPENTRY_LIST_INT_SET_STRING = DartType._withName(
    'MapEntry<List<int>, Set<String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Set<String>>',
    true,
  );
  static const MAPENTRY_LIST_INT_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<List<int>, Expando<double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Expando<double>>',
    true,
  );
  static const MAPENTRY_LIST_INT_EXPANDO_INT = DartType._withName(
    'MapEntry<List<int>, Expando<int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Expando<int>>',
    true,
  );
  static const MAPENTRY_LIST_INT_EXPANDO_STRING = DartType._withName(
    'MapEntry<List<int>, Expando<String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Expando<String>>',
    true,
  );
  static const MAPENTRY_LIST_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<List<int>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<int>, WeakReference<bool>>', true);
  static const MAPENTRY_LIST_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<List<int>, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<int>, WeakReference<double>>', true);
  static const MAPENTRY_LIST_INT_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<List<int>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('MapEntry<List<int>, WeakReference<int>>', true);
  static const MAPENTRY_LIST_INT_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<List<int>, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<List<int>, WeakReference<String>>', true);
  static const MAPENTRY_LIST_INT_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<List<int>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_BOOL_INT = DartType._withName(
    'MapEntry<List<int>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<List<int>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<bool, String>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<List<int>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<double, bool>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<List<int>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<int>, Map<double, double>>', true);
  static const MAPENTRY_LIST_INT_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<List<int>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<double, int>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<List<int>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<List<int>, Map<double, String>>', true);
  static const MAPENTRY_LIST_INT_MAP_INT_BOOL = DartType._withName(
    'MapEntry<List<int>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<List<int>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<int, double>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_INT_STRING = DartType._withName(
    'MapEntry<List<int>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<int, String>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<List<int>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<String, bool>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<List<int>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<int>, Map<String, double>>', true);
  static const MAPENTRY_LIST_INT_MAP_STRING_INT = DartType._withName(
    'MapEntry<List<int>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<List<int>, Map<String, int>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAP_STRING_STRING = DartType._withName(
    'MapEntry<List<int>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAP_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<List<int>, Map<String, String>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<List<int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<bool, bool>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<List<int>, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<bool, double>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<List<int>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<bool, int>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<List<int>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<double, bool>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<List<int>, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<double, double>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<List<int>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<double, int>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<List<int>, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<double, String>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<List<int>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<int, bool>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<List<int>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<int, double>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<List<int>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<List<int>, MapEntry<int, int>>',
    true,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<List<int>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<int, String>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<List<int>, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<String, double>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<List<int>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<String, int>>', true);
  static const MAPENTRY_LIST_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<List<int>, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_LIST_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<List<int>, MapEntry<String, String>>', true);
  static const MAPENTRY_LIST_STRING_BOOL = DartType._withName(
    'MapEntry<List<String>, bool>',
    false,
  );
  static const MAPENTRY_LIST_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<String>, bool>',
    true,
  );
  static const MAPENTRY_LIST_STRING_DOUBLE = DartType._withName(
    'MapEntry<List<String>, double>',
    false,
  );
  static const MAPENTRY_LIST_STRING_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<String>, double>',
    true,
  );
  static const MAPENTRY_LIST_STRING_INT = DartType._withName(
    'MapEntry<List<String>, int>',
    false,
  );
  static const MAPENTRY_LIST_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<List<String>, int>',
    true,
  );
  static const MAPENTRY_LIST_STRING_STRING = DartType._withName(
    'MapEntry<List<String>, String>',
    false,
  );
  static const MAPENTRY_LIST_STRING_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<String>, String>',
    true,
  );
  static const MAPENTRY_LIST_STRING_LIST_BOOL = DartType._withName(
    'MapEntry<List<String>, List<bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<String>, List<bool>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_LIST_DOUBLE = DartType._withName(
    'MapEntry<List<String>, List<double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<String>, List<double>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_LIST_STRING = DartType._withName(
    'MapEntry<List<String>, List<String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<String>, List<String>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_SET_BOOL = DartType._withName(
    'MapEntry<List<String>, Set<bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Set<bool>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_SET_DOUBLE = DartType._withName(
    'MapEntry<List<String>, Set<double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Set<double>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_SET_INT = DartType._withName(
    'MapEntry<List<String>, Set<int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Set<int>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_SET_STRING = DartType._withName(
    'MapEntry<List<String>, Set<String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Set<String>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_EXPANDO_BOOL = DartType._withName(
    'MapEntry<List<String>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Expando<bool>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<List<String>, Expando<double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<String>, Expando<double>>', true);
  static const MAPENTRY_LIST_STRING_EXPANDO_INT = DartType._withName(
    'MapEntry<List<String>, Expando<int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Expando<int>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<List<String>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<String>, WeakReference<bool>>', true);
  static const MAPENTRY_LIST_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<List<String>, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<String>, WeakReference<double>>', true);
  static const MAPENTRY_LIST_STRING_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<List<String>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('MapEntry<List<String>, WeakReference<int>>', true);
  static const MAPENTRY_LIST_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<List<String>, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<List<String>, WeakReference<String>>', true);
  static const MAPENTRY_LIST_STRING_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<List<String>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<List<String>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<bool, double>>', true);
  static const MAPENTRY_LIST_STRING_MAP_BOOL_INT = DartType._withName(
    'MapEntry<List<String>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<List<String>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<bool, String>>', true);
  static const MAPENTRY_LIST_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<List<String>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<double, double>>', true);
  static const MAPENTRY_LIST_STRING_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<List<String>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<double, int>>', true);
  static const MAPENTRY_LIST_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<List<String>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<double, String>>', true);
  static const MAPENTRY_LIST_STRING_MAP_INT_BOOL = DartType._withName(
    'MapEntry<List<String>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<List<String>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<int, double>>', true);
  static const MAPENTRY_LIST_STRING_MAP_INT_INT = DartType._withName(
    'MapEntry<List<String>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<List<String>, Map<int, int>>',
    true,
  );
  static const MAPENTRY_LIST_STRING_MAP_INT_STRING = DartType._withName(
    'MapEntry<List<String>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<int, String>>', true);
  static const MAPENTRY_LIST_STRING_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<List<String>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<String, bool>>', true);
  static const MAPENTRY_LIST_STRING_MAP_STRING_INT = DartType._withName(
    'MapEntry<List<String>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<String, int>>', true);
  static const MAPENTRY_LIST_STRING_MAP_STRING_STRING = DartType._withName(
    'MapEntry<List<String>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<List<String>, Map<String, String>>', true);
  static const MAPENTRY_LIST_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<List<String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<String>, MapEntry<bool, bool>>', true);
  static const MAPENTRY_LIST_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<List<String>, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<List<String>, MapEntry<bool, double>>',
        true,
      );
  static const MAPENTRY_LIST_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<List<String>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<List<String>, MapEntry<bool, int>>', true);
  static const MAPENTRY_LIST_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<List<String>, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<List<String>, MapEntry<bool, String>>',
        true,
      );
  static const MAPENTRY_LIST_STRING_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<List<String>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<List<String>, MapEntry<double, bool>>',
        true,
      );
  static const MAPENTRY_LIST_STRING_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<List<String>, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<List<String>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_LIST_STRING_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<List<String>, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<List<String>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_LIST_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<List<String>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<List<String>, MapEntry<int, bool>>', true);
  static const MAPENTRY_LIST_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<List<String>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<List<String>, MapEntry<int, double>>', true);
  static const MAPENTRY_LIST_STRING_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<List<String>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('MapEntry<List<String>, MapEntry<int, int>>', true);
  static const MAPENTRY_LIST_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<List<String>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<List<String>, MapEntry<int, String>>', true);
  static const MAPENTRY_LIST_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<List<String>, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<List<String>, MapEntry<String, bool>>',
        true,
      );
  static const MAPENTRY_LIST_STRING_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<List<String>, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<List<String>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_LIST_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<List<String>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_LIST_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<List<String>, MapEntry<String, int>>', true);
  static const MAPENTRY_SET_BOOL_BOOL = DartType._withName(
    'MapEntry<Set<bool>, bool>',
    false,
  );
  static const MAPENTRY_SET_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, bool>',
    true,
  );
  static const MAPENTRY_SET_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, double>',
    false,
  );
  static const MAPENTRY_SET_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, double>',
    true,
  );
  static const MAPENTRY_SET_BOOL_INT = DartType._withName(
    'MapEntry<Set<bool>, int>',
    false,
  );
  static const MAPENTRY_SET_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, int>',
    true,
  );
  static const MAPENTRY_SET_BOOL_STRING = DartType._withName(
    'MapEntry<Set<bool>, String>',
    false,
  );
  static const MAPENTRY_SET_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, String>',
    true,
  );
  static const MAPENTRY_SET_BOOL_LIST_BOOL = DartType._withName(
    'MapEntry<Set<bool>, List<bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, List<bool>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_LIST_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, List<double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, List<double>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_LIST_INT = DartType._withName(
    'MapEntry<Set<bool>, List<int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, List<int>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_LIST_STRING = DartType._withName(
    'MapEntry<Set<bool>, List<String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, List<String>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_SET_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, Set<double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Set<double>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_SET_INT = DartType._withName(
    'MapEntry<Set<bool>, Set<int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Set<int>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_SET_STRING = DartType._withName(
    'MapEntry<Set<bool>, Set<String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Set<String>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_EXPANDO_BOOL = DartType._withName(
    'MapEntry<Set<bool>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Expando<bool>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, Expando<double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Expando<double>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_EXPANDO_INT = DartType._withName(
    'MapEntry<Set<bool>, Expando<int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Expando<int>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_EXPANDO_STRING = DartType._withName(
    'MapEntry<Set<bool>, Expando<String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Expando<String>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<Set<bool>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, WeakReference<bool>>', true);
  static const MAPENTRY_SET_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<Set<bool>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, WeakReference<int>>', true);
  static const MAPENTRY_SET_BOOL_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<Set<bool>, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, WeakReference<String>>', true);
  static const MAPENTRY_SET_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<Set<bool>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<bool, double>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_BOOL_INT = DartType._withName(
    'MapEntry<Set<bool>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<Set<bool>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<bool, String>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Set<bool>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<double, bool>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, Map<double, double>>', true);
  static const MAPENTRY_SET_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<Set<bool>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<double, int>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_INT_BOOL = DartType._withName(
    'MapEntry<Set<bool>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<int, double>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_INT_INT = DartType._withName(
    'MapEntry<Set<bool>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<int, int>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_INT_STRING = DartType._withName(
    'MapEntry<Set<bool>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<int, String>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<Set<bool>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<String, bool>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, Map<String, double>>', true);
  static const MAPENTRY_SET_BOOL_MAP_STRING_INT = DartType._withName(
    'MapEntry<Set<bool>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, Map<String, int>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAP_STRING_STRING = DartType._withName(
    'MapEntry<Set<bool>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, Map<String, String>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<bool, double>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<bool, int>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<bool, String>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<double, bool>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<double, double>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<double, int>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<double, String>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<int, bool>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<int, int>>',
    true,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<int, String>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<String, bool>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<String, double>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<String, int>>', true);
  static const MAPENTRY_SET_BOOL_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<Set<bool>, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_SET_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<bool>, MapEntry<String, String>>', true);
  static const MAPENTRY_SET_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Set<double>, bool>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, bool>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, double>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, double>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_STRING = DartType._withName(
    'MapEntry<Set<double>, String>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, String>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_LIST_BOOL = DartType._withName(
    'MapEntry<Set<double>, List<bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, List<bool>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_LIST_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, List<double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, List<double>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_LIST_INT = DartType._withName(
    'MapEntry<Set<double>, List<int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, List<int>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_LIST_STRING = DartType._withName(
    'MapEntry<Set<double>, List<String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, List<String>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_SET_BOOL = DartType._withName(
    'MapEntry<Set<double>, Set<bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Set<bool>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_SET_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, Set<double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Set<double>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_SET_INT = DartType._withName(
    'MapEntry<Set<double>, Set<int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Set<int>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'MapEntry<Set<double>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Expando<bool>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, Expando<double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Expando<double>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_EXPANDO_INT = DartType._withName(
    'MapEntry<Set<double>, Expando<int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Expando<int>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_EXPANDO_STRING = DartType._withName(
    'MapEntry<Set<double>, Expando<String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Expando<String>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<Set<double>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<double>, WeakReference<bool>>', true);
  static const MAPENTRY_SET_DOUBLE_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<double>, WeakReference<double>>', true);
  static const MAPENTRY_SET_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<Set<double>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('MapEntry<Set<double>, WeakReference<int>>', true);
  static const MAPENTRY_SET_DOUBLE_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<Set<double>, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<double>, WeakReference<String>>', true);
  static const MAPENTRY_SET_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<double>, Map<bool, double>>', true);
  static const MAPENTRY_SET_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'MapEntry<Set<double>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<Set<double>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<double>, Map<bool, String>>', true);
  static const MAPENTRY_SET_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Set<double>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<double>, Map<double, bool>>', true);
  static const MAPENTRY_SET_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<double>, Map<double, double>>', true);
  static const MAPENTRY_SET_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<Set<double>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Map<double, int>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<Set<double>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<double>, Map<double, String>>', true);
  static const MAPENTRY_SET_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'MapEntry<Set<double>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_INT_INT = DartType._withName(
    'MapEntry<Set<double>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Map<int, int>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_INT_STRING = DartType._withName(
    'MapEntry<Set<double>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Map<int, String>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<Set<double>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<double>, Map<String, bool>>', true);
  static const MAPENTRY_SET_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<double>, Map<String, double>>', true);
  static const MAPENTRY_SET_DOUBLE_MAP_STRING_INT = DartType._withName(
    'MapEntry<Set<double>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<double>, Map<String, int>>',
    true,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'MapEntry<Set<double>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<double>, Map<String, String>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<Set<double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<bool, bool>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<bool, double>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<Set<double>, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<bool, String>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Set<double>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<double, bool>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Set<double>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<Set<double>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<double, int>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<Set<double>, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Set<double>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<Set<double>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<int, bool>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<int, double>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<Set<double>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<int, int>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<Set<double>, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<String, bool>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<Set<double>, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Set<double>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<Set<double>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<Set<double>, MapEntry<String, int>>', true);
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<Set<double>, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_SET_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Set<double>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_SET_INT_BOOL = DartType._withName(
    'MapEntry<Set<int>, bool>',
    false,
  );
  static const MAPENTRY_SET_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, bool>',
    true,
  );
  static const MAPENTRY_SET_INT_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, double>',
    false,
  );
  static const MAPENTRY_SET_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, double>',
    true,
  );
  static const MAPENTRY_SET_INT_INT = DartType._withName(
    'MapEntry<Set<int>, int>',
    false,
  );
  static const MAPENTRY_SET_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, int>',
    true,
  );
  static const MAPENTRY_SET_INT_STRING = DartType._withName(
    'MapEntry<Set<int>, String>',
    false,
  );
  static const MAPENTRY_SET_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, String>',
    true,
  );
  static const MAPENTRY_SET_INT_LIST_BOOL = DartType._withName(
    'MapEntry<Set<int>, List<bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, List<bool>>',
    true,
  );
  static const MAPENTRY_SET_INT_LIST_INT = DartType._withName(
    'MapEntry<Set<int>, List<int>>',
    false,
  );
  static const MAPENTRY_SET_INT_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, List<int>>',
    true,
  );
  static const MAPENTRY_SET_INT_LIST_STRING = DartType._withName(
    'MapEntry<Set<int>, List<String>>',
    false,
  );
  static const MAPENTRY_SET_INT_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, List<String>>',
    true,
  );
  static const MAPENTRY_SET_INT_SET_BOOL = DartType._withName(
    'MapEntry<Set<int>, Set<bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Set<bool>>',
    true,
  );
  static const MAPENTRY_SET_INT_SET_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, Set<double>>',
    false,
  );
  static const MAPENTRY_SET_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Set<double>>',
    true,
  );
  static const MAPENTRY_SET_INT_SET_INT = DartType._withName(
    'MapEntry<Set<int>, Set<int>>',
    false,
  );
  static const MAPENTRY_SET_INT_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Set<int>>',
    true,
  );
  static const MAPENTRY_SET_INT_SET_STRING = DartType._withName(
    'MapEntry<Set<int>, Set<String>>',
    false,
  );
  static const MAPENTRY_SET_INT_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Set<String>>',
    true,
  );
  static const MAPENTRY_SET_INT_EXPANDO_BOOL = DartType._withName(
    'MapEntry<Set<int>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Expando<bool>>',
    true,
  );
  static const MAPENTRY_SET_INT_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, Expando<double>>',
    false,
  );
  static const MAPENTRY_SET_INT_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Expando<double>>',
    true,
  );
  static const MAPENTRY_SET_INT_EXPANDO_STRING = DartType._withName(
    'MapEntry<Set<int>, Expando<String>>',
    false,
  );
  static const MAPENTRY_SET_INT_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Expando<String>>',
    true,
  );
  static const MAPENTRY_SET_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<Set<int>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<int>, WeakReference<bool>>', true);
  static const MAPENTRY_SET_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_SET_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<int>, WeakReference<double>>', true);
  static const MAPENTRY_SET_INT_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<Set<int>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_SET_INT_WEAKREFERENCE_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, WeakReference<int>>',
    true,
  );
  static const MAPENTRY_SET_INT_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<Set<int>, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_SET_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<int>, WeakReference<String>>', true);
  static const MAPENTRY_SET_INT_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<Set<int>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<bool, double>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_BOOL_INT = DartType._withName(
    'MapEntry<Set<int>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Set<int>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<double, bool>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<double, double>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<Set<int>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<double, int>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<Set<int>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_DOUBLE_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<double, String>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_INT_BOOL = DartType._withName(
    'MapEntry<Set<int>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<int, double>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_INT_INT = DartType._withName(
    'MapEntry<Set<int>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<int, int>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_INT_STRING = DartType._withName(
    'MapEntry<Set<int>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<int, String>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_STRING_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<String, double>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_STRING_INT = DartType._withName(
    'MapEntry<Set<int>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<String, int>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAP_STRING_STRING = DartType._withName(
    'MapEntry<Set<int>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAP_STRING_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, Map<String, String>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<Set<int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<bool, bool>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<bool, double>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<Set<int>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, MapEntry<bool, int>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<Set<int>, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<bool, String>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Set<int>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<double, bool>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<Set<int>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<double, int>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<Set<int>, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<double, String>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<Set<int>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, MapEntry<int, bool>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<int, double>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<Set<int>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<int>, MapEntry<int, int>>',
    true,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<Set<int>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<int, String>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<Set<int>, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<String, bool>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<Set<int>, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<String, double>>', true);
  static const MAPENTRY_SET_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<Set<int>, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_SET_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<int>, MapEntry<String, String>>', true);
  static const MAPENTRY_SET_STRING_BOOL = DartType._withName(
    'MapEntry<Set<String>, bool>',
    false,
  );
  static const MAPENTRY_SET_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, bool>',
    true,
  );
  static const MAPENTRY_SET_STRING_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, double>',
    false,
  );
  static const MAPENTRY_SET_STRING_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, double>',
    true,
  );
  static const MAPENTRY_SET_STRING_INT = DartType._withName(
    'MapEntry<Set<String>, int>',
    false,
  );
  static const MAPENTRY_SET_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, int>',
    true,
  );
  static const MAPENTRY_SET_STRING_STRING = DartType._withName(
    'MapEntry<Set<String>, String>',
    false,
  );
  static const MAPENTRY_SET_STRING_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, String>',
    true,
  );
  static const MAPENTRY_SET_STRING_LIST_BOOL = DartType._withName(
    'MapEntry<Set<String>, List<bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, List<bool>>',
    true,
  );
  static const MAPENTRY_SET_STRING_LIST_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, List<double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, List<double>>',
    true,
  );
  static const MAPENTRY_SET_STRING_LIST_INT = DartType._withName(
    'MapEntry<Set<String>, List<int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, List<int>>',
    true,
  );
  static const MAPENTRY_SET_STRING_SET_BOOL = DartType._withName(
    'MapEntry<Set<String>, Set<bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Set<bool>>',
    true,
  );
  static const MAPENTRY_SET_STRING_SET_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, Set<double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Set<double>>',
    true,
  );
  static const MAPENTRY_SET_STRING_SET_INT = DartType._withName(
    'MapEntry<Set<String>, Set<int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Set<int>>',
    true,
  );
  static const MAPENTRY_SET_STRING_SET_STRING = DartType._withName(
    'MapEntry<Set<String>, Set<String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Set<String>>',
    true,
  );
  static const MAPENTRY_SET_STRING_EXPANDO_BOOL = DartType._withName(
    'MapEntry<Set<String>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Expando<bool>>',
    true,
  );
  static const MAPENTRY_SET_STRING_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, Expando<double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_EXPANDO_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Expando<double>>',
    true,
  );
  static const MAPENTRY_SET_STRING_EXPANDO_INT = DartType._withName(
    'MapEntry<Set<String>, Expando<int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Expando<int>>',
    true,
  );
  static const MAPENTRY_SET_STRING_EXPANDO_STRING = DartType._withName(
    'MapEntry<Set<String>, Expando<String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_EXPANDO_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Expando<String>>',
    true,
  );
  static const MAPENTRY_SET_STRING_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<String>, WeakReference<double>>', true);
  static const MAPENTRY_SET_STRING_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<Set<String>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('MapEntry<Set<String>, WeakReference<int>>', true);
  static const MAPENTRY_SET_STRING_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<Set<String>, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<String>, WeakReference<String>>', true);
  static const MAPENTRY_SET_STRING_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<Set<String>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_SET_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<String>, Map<bool, double>>', true);
  static const MAPENTRY_SET_STRING_MAP_BOOL_INT = DartType._withName(
    'MapEntry<Set<String>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_SET_STRING_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<Set<String>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<String>, Map<bool, String>>', true);
  static const MAPENTRY_SET_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Set<String>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<String>, Map<double, bool>>', true);
  static const MAPENTRY_SET_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<String>, Map<double, double>>', true);
  static const MAPENTRY_SET_STRING_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<Set<String>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<String>, Map<double, String>>', true);
  static const MAPENTRY_SET_STRING_MAP_INT_BOOL = DartType._withName(
    'MapEntry<Set<String>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_SET_STRING_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Map<int, double>>',
    true,
  );
  static const MAPENTRY_SET_STRING_MAP_INT_INT = DartType._withName(
    'MapEntry<Set<String>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Map<int, int>>',
    true,
  );
  static const MAPENTRY_SET_STRING_MAP_INT_STRING = DartType._withName(
    'MapEntry<Set<String>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Map<int, String>>',
    true,
  );
  static const MAPENTRY_SET_STRING_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<Set<String>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<String>, Map<String, bool>>', true);
  static const MAPENTRY_SET_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<String>, Map<String, double>>', true);
  static const MAPENTRY_SET_STRING_MAP_STRING_INT = DartType._withName(
    'MapEntry<Set<String>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAP_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<Set<String>, Map<String, int>>',
    true,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<Set<String>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<bool, bool>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<bool, double>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<Set<String>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<bool, int>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<Set<String>, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<bool, String>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Set<String>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<double, bool>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Set<String>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_SET_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<Set<String>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<double, int>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_DOUBLE_STRING = DartType._withName(
    'MapEntry<Set<String>, MapEntry<double, String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Set<String>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_SET_STRING_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<int, double>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<Set<String>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<int, int>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<Set<String>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<int, String>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<Set<String>, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<String, bool>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<Set<String>, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Set<String>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_SET_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<Set<String>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<Set<String>, MapEntry<String, int>>', true);
  static const MAPENTRY_SET_STRING_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<Set<String>, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_SET_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Set<String>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, bool>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, bool>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_INT = DartType._withName(
    'MapEntry<Expando<bool>, int>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, int>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_STRING = DartType._withName(
    'MapEntry<Expando<bool>, String>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, String>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_LIST_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, List<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, List<bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_LIST_DOUBLE = DartType._withName(
    'MapEntry<Expando<bool>, List<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, List<double>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_LIST_INT = DartType._withName(
    'MapEntry<Expando<bool>, List<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, List<int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_LIST_STRING = DartType._withName(
    'MapEntry<Expando<bool>, List<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, List<String>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_SET_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, Set<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, Set<bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_SET_DOUBLE = DartType._withName(
    'MapEntry<Expando<bool>, Set<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, Set<double>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_SET_STRING = DartType._withName(
    'MapEntry<Expando<bool>, Set<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, Set<String>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_EXPANDO_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, Expando<bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<Expando<bool>, Expando<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Expando<double>>', true);
  static const MAPENTRY_EXPANDO_BOOL_EXPANDO_INT = DartType._withName(
    'MapEntry<Expando<bool>, Expando<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, Expando<int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_EXPANDO_STRING = DartType._withName(
    'MapEntry<Expando<bool>, Expando<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_EXPANDO_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Expando<String>>', true);
  static const MAPENTRY_EXPANDO_BOOL_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, WeakReference<bool>>', true);
  static const MAPENTRY_EXPANDO_BOOL_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<Expando<bool>, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, WeakReference<double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<Expando<bool>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, WeakReference<int>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<bool, bool>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Expando<bool>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<bool, double>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_BOOL_INT = DartType._withName(
    'MapEntry<Expando<bool>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<Expando<bool>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<bool, String>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<double, bool>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Expando<bool>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<double, double>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<Expando<bool>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<double, int>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<Expando<bool>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<double, String>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<Expando<bool>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<int, double>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_INT_INT = DartType._withName(
    'MapEntry<Expando<bool>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<bool>, Map<int, int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_INT_STRING = DartType._withName(
    'MapEntry<Expando<bool>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<int, String>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<String, bool>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<Expando<bool>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<String, double>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_STRING_INT = DartType._withName(
    'MapEntry<Expando<bool>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<String, int>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAP_STRING_STRING = DartType._withName(
    'MapEntry<Expando<bool>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, Map<String, String>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, MapEntry<bool, bool>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, MapEntry<bool, int>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<bool, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<double, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<double, double>>',
        false,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<double, int>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<double, String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<bool>, MapEntry<int, bool>>', true);
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<int, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<int, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<String, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<String, double>>',
        false,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<Expando<bool>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<String, int>>',
        true,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_STRING_STRING =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<String, String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<bool>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Expando<double>, bool>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<double>, bool>',
    true,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Expando<double>, double>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Expando<double>, double>',
    true,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_INT = DartType._withName(
    'MapEntry<Expando<double>, int>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<double>, int>',
    true,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_STRING = DartType._withName(
    'MapEntry<Expando<double>, String>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<double>, String>',
    true,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_LIST_DOUBLE = DartType._withName(
    'MapEntry<Expando<double>, List<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_LIST_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, List<double>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_LIST_INT = DartType._withName(
    'MapEntry<Expando<double>, List<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<double>, List<int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_LIST_STRING = DartType._withName(
    'MapEntry<Expando<double>, List<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_LIST_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, List<String>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_SET_BOOL = DartType._withName(
    'MapEntry<Expando<double>, Set<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<double>, Set<bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_SET_DOUBLE = DartType._withName(
    'MapEntry<Expando<double>, Set<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Expando<double>, Set<double>>',
    true,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_SET_INT = DartType._withName(
    'MapEntry<Expando<double>, Set<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<double>, Set<int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_SET_STRING = DartType._withName(
    'MapEntry<Expando<double>, Set<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<double>, Set<String>>',
    true,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'MapEntry<Expando<double>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_EXPANDO_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Expando<bool>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_EXPANDO_INT = DartType._withName(
    'MapEntry<Expando<double>, Expando<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_EXPANDO_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Expando<int>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_EXPANDO_STRING = DartType._withName(
    'MapEntry<Expando<double>, Expando<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_EXPANDO_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Expando<String>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<Expando<double>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, WeakReference<bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'MapEntry<Expando<double>, WeakReference<double>>',
        false,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, WeakReference<double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<Expando<double>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, WeakReference<int>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_WEAKREFERENCE_STRING =
      DartType._withName(
        'MapEntry<Expando<double>, WeakReference<String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, WeakReference<String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<Expando<double>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<bool, bool>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Expando<double>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<bool, double>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<Expando<double>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<bool, String>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Expando<double>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<double, bool>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Expando<double>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, Map<double, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<Expando<double>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<double, int>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<Expando<double>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, Map<double, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'MapEntry<Expando<double>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<int, bool>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<Expando<double>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<int, double>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_INT_INT = DartType._withName(
    'MapEntry<Expando<double>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_INT_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<int, int>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<Expando<double>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<String, bool>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<Expando<double>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, Map<String, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_STRING_INT = DartType._withName(
    'MapEntry<Expando<double>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, Map<String, int>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_STRING_STRING = DartType._withName(
    'MapEntry<Expando<double>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, Map<String, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<Expando<double>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<bool, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<bool, double>>',
        false,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<bool, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<Expando<double>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<bool, int>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<bool, String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<bool, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<double, double>>',
        false,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<Expando<double>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<double, int>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<double, String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<Expando<double>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<int, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<Expando<double>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<int, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<Expando<double>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<double>, MapEntry<int, int>>', true);
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<Expando<double>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<int, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<String, bool>>',
        false,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<String, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<Expando<double>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<String, int>>',
        true,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_STRING_STRING =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<String, String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_DOUBLE_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<double>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_INT_BOOL = DartType._withName(
    'MapEntry<Expando<int>, bool>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, bool>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, double>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, double>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_INT = DartType._withName(
    'MapEntry<Expando<int>, int>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, int>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_STRING = DartType._withName(
    'MapEntry<Expando<int>, String>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, String>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_LIST_BOOL = DartType._withName(
    'MapEntry<Expando<int>, List<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, List<bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_LIST_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, List<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_LIST_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, List<double>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_LIST_STRING = DartType._withName(
    'MapEntry<Expando<int>, List<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_LIST_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, List<String>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_SET_BOOL = DartType._withName(
    'MapEntry<Expando<int>, Set<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Set<bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_SET_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, Set<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_SET_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Set<double>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_SET_INT = DartType._withName(
    'MapEntry<Expando<int>, Set<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Set<int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_SET_STRING = DartType._withName(
    'MapEntry<Expando<int>, Set<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Set<String>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_EXPANDO_BOOL = DartType._withName(
    'MapEntry<Expando<int>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_EXPANDO_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Expando<bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, Expando<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Expando<double>>', true);
  static const MAPENTRY_EXPANDO_INT_EXPANDO_INT = DartType._withName(
    'MapEntry<Expando<int>, Expando<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_EXPANDO_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Expando<int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<Expando<int>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, WeakReference<bool>>', true);
  static const MAPENTRY_EXPANDO_INT_WEAKREFERENCE_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, WeakReference<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, WeakReference<double>>', true);
  static const MAPENTRY_EXPANDO_INT_WEAKREFERENCE_INT = DartType._withName(
    'MapEntry<Expando<int>, WeakReference<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, WeakReference<int>>', true);
  static const MAPENTRY_EXPANDO_INT_WEAKREFERENCE_STRING = DartType._withName(
    'MapEntry<Expando<int>, WeakReference<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, WeakReference<String>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<Expando<int>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Map<bool, bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<bool, double>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_BOOL_INT = DartType._withName(
    'MapEntry<Expando<int>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Map<bool, int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<Expando<int>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<bool, String>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<double, double>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<Expando<int>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<double, int>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_DOUBLE_STRING = DartType._withName(
    'MapEntry<Expando<int>, Map<double, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<double, String>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_INT_BOOL = DartType._withName(
    'MapEntry<Expando<int>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Map<int, bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<int, double>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_INT_INT = DartType._withName(
    'MapEntry<Expando<int>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<int>, Map<int, int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_INT_STRING = DartType._withName(
    'MapEntry<Expando<int>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<int, String>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<Expando<int>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<String, bool>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<String, double>>', true);
  static const MAPENTRY_EXPANDO_INT_MAP_STRING_STRING = DartType._withName(
    'MapEntry<Expando<int>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAP_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, Map<String, String>>', true);
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_BOOL_BOOL = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<bool, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, MapEntry<bool, bool>>', true);
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<bool, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<int>, MapEntry<bool, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, MapEntry<bool, int>>', true);
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_BOOL_STRING = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<bool, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<int>, MapEntry<bool, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<double, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<int>, MapEntry<double, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<double, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<int>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, MapEntry<double, int>>', true);
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, MapEntry<int, bool>>', true);
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_INT_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<int, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, MapEntry<int, double>>', true);
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, MapEntry<int, int>>', true);
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, MapEntry<int, String>>', true);
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_STRING_BOOL = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<String, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<int>, MapEntry<String, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_STRING_DOUBLE = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<String, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<int>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<int>, MapEntry<String, int>>', true);
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_STRING_STRING = DartType._withName(
    'MapEntry<Expando<int>, MapEntry<String, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<int>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_DOUBLE = DartType._withName(
    'MapEntry<Expando<String>, double>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<Expando<String>, double>',
    true,
  );
  static const MAPENTRY_EXPANDO_STRING_INT = DartType._withName(
    'MapEntry<Expando<String>, int>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<String>, int>',
    true,
  );
  static const MAPENTRY_EXPANDO_STRING_STRING = DartType._withName(
    'MapEntry<Expando<String>, String>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<String>, String>',
    true,
  );
  static const MAPENTRY_EXPANDO_STRING_LIST_BOOL = DartType._withName(
    'MapEntry<Expando<String>, List<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_LIST_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<String>, List<bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_STRING_LIST_DOUBLE = DartType._withName(
    'MapEntry<Expando<String>, List<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_LIST_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, List<double>>', true);
  static const MAPENTRY_EXPANDO_STRING_LIST_INT = DartType._withName(
    'MapEntry<Expando<String>, List<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_LIST_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<String>, List<int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_STRING_LIST_STRING = DartType._withName(
    'MapEntry<Expando<String>, List<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_LIST_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, List<String>>', true);
  static const MAPENTRY_EXPANDO_STRING_SET_BOOL = DartType._withName(
    'MapEntry<Expando<String>, Set<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_SET_BOOL_NULLABLE = DartType._withName(
    'MapEntry<Expando<String>, Set<bool>>',
    true,
  );
  static const MAPENTRY_EXPANDO_STRING_SET_INT = DartType._withName(
    'MapEntry<Expando<String>, Set<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<Expando<String>, Set<int>>',
    true,
  );
  static const MAPENTRY_EXPANDO_STRING_SET_STRING = DartType._withName(
    'MapEntry<Expando<String>, Set<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_SET_STRING_NULLABLE = DartType._withName(
    'MapEntry<Expando<String>, Set<String>>',
    true,
  );
  static const MAPENTRY_EXPANDO_STRING_EXPANDO_BOOL = DartType._withName(
    'MapEntry<Expando<String>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_EXPANDO_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Expando<bool>>', true);
  static const MAPENTRY_EXPANDO_STRING_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<Expando<String>, Expando<double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Expando<double>>', true);
  static const MAPENTRY_EXPANDO_STRING_EXPANDO_INT = DartType._withName(
    'MapEntry<Expando<String>, Expando<int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_EXPANDO_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Expando<int>>', true);
  static const MAPENTRY_EXPANDO_STRING_EXPANDO_STRING = DartType._withName(
    'MapEntry<Expando<String>, Expando<String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_EXPANDO_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Expando<String>>', true);
  static const MAPENTRY_EXPANDO_STRING_WEAKREFERENCE_BOOL = DartType._withName(
    'MapEntry<Expando<String>, WeakReference<bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, WeakReference<bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'MapEntry<Expando<String>, WeakReference<double>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, WeakReference<double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_WEAKREFERENCE_STRING =
      DartType._withName(
        'MapEntry<Expando<String>, WeakReference<String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, WeakReference<String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<Expando<String>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<bool, bool>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<Expando<String>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<bool, double>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_BOOL_INT = DartType._withName(
    'MapEntry<Expando<String>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<bool, int>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<Expando<String>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<bool, String>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<Expando<String>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<double, bool>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<Expando<String>, Map<double, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, Map<double, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<Expando<String>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<double, int>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_INT_BOOL = DartType._withName(
    'MapEntry<Expando<String>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<int, bool>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<Expando<String>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<int, double>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_INT_INT = DartType._withName(
    'MapEntry<Expando<String>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_INT_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<int, int>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_INT_STRING = DartType._withName(
    'MapEntry<Expando<String>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<int, String>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<Expando<String>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<String, bool>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_STRING_DOUBLE = DartType._withName(
    'MapEntry<Expando<String>, Map<String, double>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, Map<String, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAP_STRING_INT = DartType._withName(
    'MapEntry<Expando<String>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_STRING_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, Map<String, int>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAP_STRING_STRING = DartType._withName(
    'MapEntry<Expando<String>, Map<String, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, Map<String, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<bool, double>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<bool, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_BOOL_INT = DartType._withName(
    'MapEntry<Expando<String>, MapEntry<bool, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<bool, int>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<bool, String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<bool, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<double, bool>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<double, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<double, double>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_DOUBLE_INT = DartType._withName(
    'MapEntry<Expando<String>, MapEntry<double, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<double, int>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<double, String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_INT_BOOL = DartType._withName(
    'MapEntry<Expando<String>, MapEntry<int, bool>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<int, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<Expando<String>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName('MapEntry<Expando<String>, MapEntry<int, int>>', true);
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_INT_STRING = DartType._withName(
    'MapEntry<Expando<String>, MapEntry<int, String>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<int, String>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<String, bool>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<String, bool>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<String, double>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_STRING_INT = DartType._withName(
    'MapEntry<Expando<String>, MapEntry<String, int>>',
    false,
  );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<String, int>>',
        true,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_STRING_STRING =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<String, String>>',
        false,
      );
  static const MAPENTRY_EXPANDO_STRING_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<Expando<String>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_BOOL = DartType._withName(
    'MapEntry<WeakReference<bool>, bool>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_BOOL_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<bool>, bool>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<bool>, double>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<bool>, double>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_INT = DartType._withName(
    'MapEntry<WeakReference<bool>, int>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_INT_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<bool>, int>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_LIST_BOOL = DartType._withName(
    'MapEntry<WeakReference<bool>, List<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_LIST_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, List<bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_LIST_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<bool>, List<double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_LIST_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, List<double>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_LIST_INT = DartType._withName(
    'MapEntry<WeakReference<bool>, List<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_LIST_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, List<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_LIST_STRING = DartType._withName(
    'MapEntry<WeakReference<bool>, List<String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_LIST_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, List<String>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_SET_BOOL = DartType._withName(
    'MapEntry<WeakReference<bool>, Set<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_SET_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, Set<bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_SET_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<bool>, Set<double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_SET_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, Set<double>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_SET_INT = DartType._withName(
    'MapEntry<WeakReference<bool>, Set<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_SET_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, Set<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_SET_STRING = DartType._withName(
    'MapEntry<WeakReference<bool>, Set<String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_SET_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, Set<String>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<bool>, Expando<double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Expando<double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_EXPANDO_INT = DartType._withName(
    'MapEntry<WeakReference<bool>, Expando<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_EXPANDO_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, Expando<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_EXPANDO_STRING = DartType._withName(
    'MapEntry<WeakReference<bool>, Expando<String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_EXPANDO_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Expando<String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_WEAKREFERENCE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<bool>, WeakReference<bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, WeakReference<bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, WeakReference<double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, WeakReference<double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_WEAKREFERENCE_INT =
      DartType._withName(
        'MapEntry<WeakReference<bool>, WeakReference<int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, WeakReference<int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_WEAKREFERENCE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<bool>, WeakReference<String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, WeakReference<String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<bool, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_BOOL_INT = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, Map<bool, int>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<bool, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<double, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<double, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<double, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_DOUBLE_INT = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<double, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<double, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<double, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<double, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_INT_BOOL = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<bool>, Map<int, bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<int, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_INT_STRING = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<int, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<String, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_STRING_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<String, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<String, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_STRING_INT = DartType._withName(
    'MapEntry<WeakReference<bool>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<String, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_STRING_STRING =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<String, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, Map<String, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<bool, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<bool, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<bool, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<bool, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_INT =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<bool, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<bool, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<double, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<double, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<double, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<double, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<double, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<double, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_INT_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<int, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<int, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<int, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<int, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_INT_INT =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<int, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<int, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_INT_STRING =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<int, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<int, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<String, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_STRING_INT =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<String, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<String, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_STRING_STRING =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<String, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_BOOL_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<bool>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_BOOL = DartType._withName(
    'MapEntry<WeakReference<double>, bool>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_BOOL_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<double>, bool>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<double>, double>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<double>, double>', true);
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_INT = DartType._withName(
    'MapEntry<WeakReference<double>, int>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_INT_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<double>, int>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_STRING = DartType._withName(
    'MapEntry<WeakReference<double>, String>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<double>, String>', true);
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_LIST_BOOL = DartType._withName(
    'MapEntry<WeakReference<double>, List<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_LIST_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<double>, List<bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_LIST_INT = DartType._withName(
    'MapEntry<WeakReference<double>, List<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_LIST_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<double>, List<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_LIST_STRING = DartType._withName(
    'MapEntry<WeakReference<double>, List<String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_LIST_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<double>, List<String>>', true);
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_SET_BOOL = DartType._withName(
    'MapEntry<WeakReference<double>, Set<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_SET_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<double>, Set<bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_SET_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<double>, Set<double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_SET_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<double>, Set<double>>', true);
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_SET_INT = DartType._withName(
    'MapEntry<WeakReference<double>, Set<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_SET_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<double>, Set<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_SET_STRING = DartType._withName(
    'MapEntry<WeakReference<double>, Set<String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_SET_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<double>, Set<String>>', true);
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_EXPANDO_BOOL = DartType._withName(
    'MapEntry<WeakReference<double>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_EXPANDO_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Expando<bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_EXPANDO_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Expando<double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Expando<double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_EXPANDO_STRING =
      DartType._withName(
        'MapEntry<WeakReference<double>, Expando<String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_EXPANDO_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Expando<String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<double>, WeakReference<bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, WeakReference<bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, WeakReference<double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, WeakReference<double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_INT =
      DartType._withName(
        'MapEntry<WeakReference<double>, WeakReference<int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, WeakReference<int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<double>, WeakReference<String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, WeakReference<String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<WeakReference<double>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<bool, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_BOOL_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<bool, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<bool, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_BOOL_INT = DartType._withName(
    'MapEntry<WeakReference<double>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_BOOL_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<bool, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<double, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<double, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<double, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<double, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_INT =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<double, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<double, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<double, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<double, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_INT_BOOL = DartType._withName(
    'MapEntry<WeakReference<double>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_INT_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<int, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_INT_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<int, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<int, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_INT_INT = DartType._withName(
    'MapEntry<WeakReference<double>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_INT_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<int, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_INT_STRING =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<int, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<int, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_STRING_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<String, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<String, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_STRING_INT =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<String, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<String, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_STRING_STRING =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<String, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, Map<String, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<bool, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<bool, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<bool, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<bool, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_INT =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<bool, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<bool, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<bool, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<bool, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<double, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<double, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<double, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<double, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<int, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<int, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<int, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<int, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_INT =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<int, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<int, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_STRING =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<int, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<int, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<String, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<String, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<String, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_INT =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<String, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_DOUBLE_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<double>, MapEntry<String, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_BOOL = DartType._withName(
    'MapEntry<WeakReference<int>, bool>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_BOOL_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<int>, bool>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<int>, double>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_DOUBLE_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<int>, double>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_INT = DartType._withName(
    'MapEntry<WeakReference<int>, int>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_INT_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<int>, int>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_STRING = DartType._withName(
    'MapEntry<WeakReference<int>, String>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_STRING_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<int>, String>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_LIST_BOOL = DartType._withName(
    'MapEntry<WeakReference<int>, List<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_LIST_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, List<bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_LIST_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<int>, List<double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_LIST_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, List<double>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_LIST_INT = DartType._withName(
    'MapEntry<WeakReference<int>, List<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_LIST_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, List<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_LIST_STRING = DartType._withName(
    'MapEntry<WeakReference<int>, List<String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_LIST_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, List<String>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_SET_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<int>, Set<double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_SET_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Set<double>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_SET_INT = DartType._withName(
    'MapEntry<WeakReference<int>, Set<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_SET_INT_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<int>, Set<int>>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_SET_STRING = DartType._withName(
    'MapEntry<WeakReference<int>, Set<String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_SET_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Set<String>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_EXPANDO_BOOL = DartType._withName(
    'MapEntry<WeakReference<int>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_EXPANDO_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Expando<bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_EXPANDO_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<int>, Expando<double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Expando<double>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_EXPANDO_INT = DartType._withName(
    'MapEntry<WeakReference<int>, Expando<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_EXPANDO_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Expando<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_EXPANDO_STRING = DartType._withName(
    'MapEntry<WeakReference<int>, Expando<String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_EXPANDO_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Expando<String>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_WEAKREFERENCE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<int>, WeakReference<bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, WeakReference<bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_WEAKREFERENCE_INT =
      DartType._withName(
        'MapEntry<WeakReference<int>, WeakReference<int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, WeakReference<int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_WEAKREFERENCE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<int>, WeakReference<String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, WeakReference<String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_BOOL_BOOL = DartType._withName(
    'MapEntry<WeakReference<int>, Map<bool, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_BOOL_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Map<bool, bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_BOOL_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<int>, Map<bool, double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<bool, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_BOOL_INT = DartType._withName(
    'MapEntry<WeakReference<int>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_BOOL_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Map<bool, int>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_BOOL_STRING = DartType._withName(
    'MapEntry<WeakReference<int>, Map<bool, String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<bool, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_DOUBLE_BOOL = DartType._withName(
    'MapEntry<WeakReference<int>, Map<double, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<double, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<double, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<double, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<double, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<double, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_INT_BOOL = DartType._withName(
    'MapEntry<WeakReference<int>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_INT_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Map<int, bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_INT_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<int>, Map<int, double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<int, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_INT_INT = DartType._withName(
    'MapEntry<WeakReference<int>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_INT_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<int>, Map<int, int>>', true);
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_INT_STRING = DartType._withName(
    'MapEntry<WeakReference<int>, Map<int, String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<int, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_STRING_BOOL = DartType._withName(
    'MapEntry<WeakReference<int>, Map<String, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<String, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_STRING_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<String, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<String, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_STRING_INT = DartType._withName(
    'MapEntry<WeakReference<int>, Map<String, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAP_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, Map<String, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_BOOL_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<bool, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<bool, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<bool, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<bool, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_BOOL_INT =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<bool, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_BOOL_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<bool, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<bool, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<bool, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<double, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<double, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<double, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<double, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<double, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<double, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_INT_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<int, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_INT_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<int, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_INT_INT = DartType._withName(
    'MapEntry<WeakReference<int>, MapEntry<int, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_INT_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<int, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_INT_STRING =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<int, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<int, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_STRING_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<String, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<String, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_STRING_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<String, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<String, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_STRING_INT =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<String, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<String, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_STRING_STRING =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<String, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_INT_MAPENTRY_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<int>, MapEntry<String, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_BOOL = DartType._withName(
    'MapEntry<WeakReference<String>, bool>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_BOOL_NULLABLE = DartType._withName(
    'MapEntry<WeakReference<String>, bool>',
    true,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<String>, double>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, double>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_STRING = DartType._withName(
    'MapEntry<WeakReference<String>, String>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, String>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_LIST_BOOL = DartType._withName(
    'MapEntry<WeakReference<String>, List<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_LIST_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, List<bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_LIST_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<String>, List<double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_LIST_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, List<double>>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_LIST_INT = DartType._withName(
    'MapEntry<WeakReference<String>, List<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_LIST_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, List<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_LIST_STRING = DartType._withName(
    'MapEntry<WeakReference<String>, List<String>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_LIST_STRING_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, List<String>>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_SET_BOOL = DartType._withName(
    'MapEntry<WeakReference<String>, Set<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_SET_BOOL_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, Set<bool>>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_SET_DOUBLE = DartType._withName(
    'MapEntry<WeakReference<String>, Set<double>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_SET_DOUBLE_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, Set<double>>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_SET_INT = DartType._withName(
    'MapEntry<WeakReference<String>, Set<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_SET_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, Set<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_EXPANDO_BOOL = DartType._withName(
    'MapEntry<WeakReference<String>, Expando<bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_EXPANDO_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Expando<bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_EXPANDO_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Expando<double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_EXPANDO_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Expando<double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_EXPANDO_INT = DartType._withName(
    'MapEntry<WeakReference<String>, Expando<int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_EXPANDO_INT_NULLABLE =
      DartType._withName('MapEntry<WeakReference<String>, Expando<int>>', true);
  static const MAPENTRY_WEAKREFERENCE_STRING_EXPANDO_STRING =
      DartType._withName(
        'MapEntry<WeakReference<String>, Expando<String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_EXPANDO_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Expando<String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_WEAKREFERENCE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<String>, WeakReference<bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_WEAKREFERENCE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, WeakReference<bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_WEAKREFERENCE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, WeakReference<double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_WEAKREFERENCE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, WeakReference<double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_WEAKREFERENCE_INT =
      DartType._withName(
        'MapEntry<WeakReference<String>, WeakReference<int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_WEAKREFERENCE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, WeakReference<int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_WEAKREFERENCE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<String>, WeakReference<String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_WEAKREFERENCE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, WeakReference<String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_BOOL_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<bool, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<bool, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_BOOL_INT = DartType._withName(
    'MapEntry<WeakReference<String>, Map<bool, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_BOOL_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<bool, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_BOOL_STRING =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<bool, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<bool, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_DOUBLE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<double, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<double, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<double, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<double, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_DOUBLE_INT =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<double, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<double, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<double, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<double, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_INT_BOOL = DartType._withName(
    'MapEntry<WeakReference<String>, Map<int, bool>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_INT_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<int, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_INT_INT = DartType._withName(
    'MapEntry<WeakReference<String>, Map<int, int>>',
    false,
  );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_INT_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<int, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_INT_STRING =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<int, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_INT_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<int, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_STRING_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<String, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_STRING_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<String, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_STRING_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<String, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_STRING_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<String, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_STRING_INT =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<String, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_STRING_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<String, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_STRING_STRING =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<String, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAP_STRING_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, Map<String, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_BOOL_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<bool, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_BOOL_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<bool, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_BOOL_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<bool, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_BOOL_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<bool, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_BOOL_STRING =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<bool, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_BOOL_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<bool, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<double, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<double, bool>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_DOUBLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<double, double>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_DOUBLE_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<double, double>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_INT =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<double, int>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_INT_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<double, int>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_STRING =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<double, String>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_DOUBLE_STRING_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<double, String>>',
        true,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_INT_BOOL =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<int, bool>>',
        false,
      );
  static const MAPENTRY_WEAKREFERENCE_STRING_MAPENTRY_INT_BOOL_NULLABLE =
      DartType._withName(
        'MapEntry<WeakReference<String>, MapEntry<int, bool>>',
