// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// Contains the Dart FFI interface to the c-library defined in
// sdk/runtime/bin/ffi_test/ffi_test_functions.cc.
// The code contained in this class is intended to be added to Dart programs
// generated by dartfuzz.dart.
class DartFuzzFfiApi {
  static const ffiapi = '''

ffi.DynamicLibrary ffiTestFunctions =
    ffi.DynamicLibrary.open("libffi_test_functions.so");

typedef NativeBinaryOp = ffi.Int32 Function(ffi.Int32, ffi.Int32);
typedef BinaryOp = int Function(int, int);
BinaryOp sumPlus42 =
    ffiTestFunctions.lookupFunction<NativeBinaryOp, BinaryOp>("SumPlus42");

typedef NativeReturnMaxUint8 = ffi.Uint8 Function();
int Function() returnMaxUint8 = ffiTestFunctions
    .lookup("ReturnMaxUint8")
    .cast<ffi.NativeFunction<NativeReturnMaxUint8>>()
    .asFunction();

typedef NativeReturnMaxUint16 = ffi.Uint16 Function();
int Function() returnMaxUint16 = ffiTestFunctions
    .lookup("ReturnMaxUint16")
    .cast<ffi.NativeFunction<NativeReturnMaxUint16>>()
    .asFunction();

typedef NativeReturnMaxUint32 = ffi.Uint32 Function();
int Function() returnMaxUint32 = ffiTestFunctions
    .lookup("ReturnMaxUint32")
    .cast<ffi.NativeFunction<NativeReturnMaxUint32>>()
    .asFunction();

typedef NativeReturnMinInt8 = ffi.Int8 Function();
int Function() returnMinInt8 = ffiTestFunctions
    .lookup("ReturnMinInt8")
    .cast<ffi.NativeFunction<NativeReturnMinInt8>>()
    .asFunction();

typedef NativeReturnMinInt16 = ffi.Int16 Function();
int Function() returnMinInt16 = ffiTestFunctions
    .lookup("ReturnMinInt16")
    .cast<ffi.NativeFunction<NativeReturnMinInt16>>()
    .asFunction();

typedef NativeReturnMinInt32 = ffi.Int32 Function();
int Function() returnMinInt32 = ffiTestFunctions
    .lookup("ReturnMinInt32")
    .cast<ffi.NativeFunction<NativeReturnMinInt32>>()
    .asFunction();

typedef NativeTakeMaxUint8 = ffi.IntPtr Function(ffi.Uint8);
int Function(int) takeMaxUint8 = ffiTestFunctions
    .lookup("TakeMaxUint8")
    .cast<ffi.NativeFunction<NativeTakeMaxUint8>>()
    .asFunction();

typedef NativeTakeMaxUint16 = ffi.IntPtr Function(ffi.Uint16);
int Function(int) takeMaxUint16 = ffiTestFunctions
    .lookup("TakeMaxUint16")
    .cast<ffi.NativeFunction<NativeTakeMaxUint16>>()
    .asFunction();

typedef NativeTakeMaxUint32 = ffi.IntPtr Function(ffi.Uint32);
int Function(int) takeMaxUint32 = ffiTestFunctions
    .lookup("TakeMaxUint32")
    .cast<ffi.NativeFunction<NativeTakeMaxUint32>>()
    .asFunction();

typedef NativeTakeMinInt8 = ffi.IntPtr Function(ffi.Int8);
int Function(int) takeMinInt8 = ffiTestFunctions
    .lookup("TakeMinInt8")
    .cast<ffi.NativeFunction<NativeTakeMinInt8>>()
    .asFunction();

typedef NativeTakeMinInt16 = ffi.IntPtr Function(ffi.Int16);
int Function(int) takeMinInt16 = ffiTestFunctions
    .lookup("TakeMinInt16")
    .cast<ffi.NativeFunction<NativeTakeMinInt16>>()
    .asFunction();

typedef NativeTakeMinInt32 = ffi.IntPtr Function(ffi.Int32);
int Function(int) takeMinInt32 = ffiTestFunctions
    .lookup("TakeMinInt32")
    .cast<ffi.NativeFunction<NativeTakeMinInt32>>()
    .asFunction();

typedef NativeQuadOpSigned = ffi.Int64 Function(
    ffi.Int8, ffi.Int16, ffi.Int32, ffi.Int64);
typedef QuadOp = int Function(int, int, int, int);
typedef IntComputationType = ffi.Int64 Function(
    ffi.Int8, ffi.Int16, ffi.Int32, ffi.Int64);
QuadOp intComputation = ffiTestFunctions
    .lookupFunction<NativeQuadOpSigned, QuadOp>("IntComputation");

typedef NativeQuadOpUnsigned = ffi.Uint64 Function(
    ffi.Uint8, ffi.Uint16, ffi.Uint32, ffi.Uint64);
typedef UintComputationType = ffi.Uint64 Function(
    ffi.Uint8, ffi.Uint16, ffi.Uint32, ffi.Uint64);
QuadOp uintComputation = ffiTestFunctions
    .lookupFunction<NativeQuadOpUnsigned, QuadOp>("UintComputation");

typedef DoubleUnaryOp = double Function(double);
typedef NativeDoubleUnaryOp = ffi.Double Function(ffi.Double);
DoubleUnaryOp times1_337Double = ffiTestFunctions
    .lookupFunction<NativeDoubleUnaryOp, DoubleUnaryOp>("Times1_337Double");

typedef NativeFloatUnaryOp = ffi.Float Function(ffi.Float);
DoubleUnaryOp times1_337Float = ffiTestFunctions
    .lookupFunction<NativeFloatUnaryOp, DoubleUnaryOp>("Times1_337Float");

typedef DecenaryOp = int Function(
    int, int, int, int, int, int, int, int, int, int);
typedef NativeDecenaryOp = ffi.IntPtr Function(
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr);
DecenaryOp sumManyInts = ffiTestFunctions
    .lookupFunction<NativeDecenaryOp, DecenaryOp>("SumManyInts");

UndenaryOp sumManyIntsOdd = ffiTestFunctions
    .lookupFunction<NativeUndenaryOp, UndenaryOp>("SumManyIntsOdd");

typedef NativeDoubleDecenaryOp = ffi.Double Function(
    ffi.Double,
    ffi.Double,
    ffi.Double,
    ffi.Double,
    ffi.Double,
    ffi.Double,
    ffi.Double,
    ffi.Double,
    ffi.Double,
    ffi.Double);
typedef DoubleDecenaryOp = double Function(double, double, double, double,
    double, double, double, double, double, double);
DoubleDecenaryOp sumManyDoubles = ffiTestFunctions
    .lookupFunction<NativeDoubleDecenaryOp, DoubleDecenaryOp>("SumManyDoubles");

typedef NativeVigesimalOp = ffi.Double Function(
    ffi.IntPtr,
    ffi.Float,
    ffi.IntPtr,
    ffi.Double,
    ffi.IntPtr,
    ffi.Float,
    ffi.IntPtr,
    ffi.Double,
    ffi.IntPtr,
    ffi.Float,
    ffi.IntPtr,
    ffi.Double,
    ffi.IntPtr,
    ffi.Float,
    ffi.IntPtr,
    ffi.Double,
    ffi.IntPtr,
    ffi.Float,
    ffi.IntPtr,
    ffi.Double);
typedef VigesimalOp = double Function(
    int,
    double,
    int,
    double,
    int,
    double,
    int,
    double,
    int,
    double,
    int,
    double,
    int,
    double,
    int,
    double,
    int,
    double,
    int,
    double);
VigesimalOp sumManyNumbers = ffiTestFunctions
    .lookupFunction<NativeVigesimalOp, VigesimalOp>("SumManyNumbers");

typedef NativeSenaryOp = ffi.Int64 Function(
    ffi.Int8, ffi.Int16, ffi.Int32, ffi.Uint8, ffi.Uint16, ffi.Uint32);
typedef SenaryOp = int Function(int, int, int, int, int, int);
SenaryOp sumSmallNumbers = ffiTestFunctions
    .lookupFunction<NativeSenaryOp, SenaryOp>("SumSmallNumbers");

typedef NativeFloatPointerToBool = ffi.Uint8 Function(ffi.Pointer<ffi.Float>);
typedef FloatPointerToBool = int Function(ffi.Pointer<ffi.Float>);
FloatPointerToBool isRoughly1337 = ffiTestFunctions.lookupFunction<
    NativeFloatPointerToBool, FloatPointerToBool>("IsRoughly1337");

typedef NativeVoidToFloat = ffi.Float Function();
typedef VoidToDouble = double Function();
VoidToDouble inventFloatValue = ffiTestFunctions
    .lookupFunction<NativeVoidToFloat, VoidToDouble>("InventFloatValue");

typedef NullaryOp = int Function();
typedef NativeNullaryOp64 = ffi.Int64 Function();
final minInt64 =
    ffiTestFunctions.lookupFunction<NativeNullaryOp64, NullaryOp>("MinInt64");

typedef NativeNullaryOp32 = ffi.Int32 Function();
final minInt32 =
    ffiTestFunctions.lookupFunction<NativeNullaryOp32, NullaryOp>("MinInt32");

typedef NativeNullaryOpDouble = ffi.Double Function();
typedef NullaryOpDbl = double Function();
final smallDouble = ffiTestFunctions
    .lookupFunction<NativeNullaryOpDouble, NullaryOpDbl>("SmallDouble");

typedef NativeUndenaryOp = ffi.IntPtr Function(
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr,
    ffi.IntPtr);
typedef UndenaryOp = int Function(
    int, int, int, int, int, int, int, int, int, int, int);
final regress37069 = ffiTestFunctions
    .lookupFunction<NativeUndenaryOp, UndenaryOp>("Regress37069");
''';
}
