// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// NOTE: this code has been generated automatically.

import 'dartfuzz_type_table.dart';

/// Enum for different restrictions on parameters for library methods.
/// none - No restriction on the corresponding parameter.
/// small - Corresponding parameter should be a small value.
enum Restriction { none, small }

/// Class that represents Dart library methods.
///
/// The individual lists are organized by return type.
/// Proto is a list of DartTypes whose first element is the type of the
/// DartType of the receiver (DartType.VOID if none). The remaining elements are
/// DartTypes of the parameters. The second element is DartType.VOID if there
/// are no parameters.
class DartLib {
  final String name;
  final List<DartType> proto;
  final List<Restriction>? restrictions;
  final bool isMethod;
  const DartLib(this.name, this.proto, this.isMethod, {this.restrictions});
  Restriction getRestriction(int paramIndex) =>
      (restrictions == null) ? Restriction.none : restrictions![paramIndex];

  static final typeToLibraryMethods = {
    DartType.BOOL: boolLibs,
    DartType.BOOL_NULLABLE: boolLibsNullable,
    DartType.DEPRECATED: deprecatedLibs,
    DartType.DEPRECATED_NULLABLE: deprecatedLibsNullable,
    DartType.DOUBLE: doubleLibs,
    DartType.DOUBLE_NULLABLE: doubleLibsNullable,
    DartType.ENDIAN: endianLibs,
    DartType.ENDIAN_NULLABLE: endianLibsNullable,
    DartType.FLOAT32LIST: float32ListLibs,
    DartType.FLOAT32LIST_NULLABLE: float32ListLibsNullable,
    DartType.FLOAT32X4: float32x4Libs,
    DartType.FLOAT32X4LIST: float32x4ListLibs,
    DartType.FLOAT32X4LIST_NULLABLE: float32x4ListLibsNullable,
    DartType.FLOAT32X4_NULLABLE: float32x4LibsNullable,
    DartType.FLOAT64LIST: float64ListLibs,
    DartType.FLOAT64LIST_NULLABLE: float64ListLibsNullable,
    DartType.FLOAT64X2: float64x2Libs,
    DartType.FLOAT64X2LIST: float64x2ListLibs,
    DartType.FLOAT64X2LIST_NULLABLE: float64x2ListLibsNullable,
    DartType.FLOAT64X2_NULLABLE: float64x2LibsNullable,
    DartType.INT: intLibs,
    DartType.INT16LIST: int16ListLibs,
    DartType.INT16LIST_NULLABLE: int16ListLibsNullable,
    DartType.INT32LIST: int32ListLibs,
    DartType.INT32LIST_NULLABLE: int32ListLibsNullable,
    DartType.INT32X4: int32x4Libs,
    DartType.INT32X4LIST: int32x4ListLibs,
    DartType.INT32X4LIST_NULLABLE: int32x4ListLibsNullable,
    DartType.INT32X4_NULLABLE: int32x4LibsNullable,
    DartType.INT64LIST: int64ListLibs,
    DartType.INT64LIST_NULLABLE: int64ListLibsNullable,
    DartType.INT8LIST: int8ListLibs,
    DartType.INT8LIST_NULLABLE: int8ListLibsNullable,
    DartType.INT_NULLABLE: intLibsNullable,
    DartType.LIST_INT: listLibs,
    DartType.LIST_INT_NULLABLE: listLibsNullable,
    DartType.MAP_INT_STRING: mapLibs,
    DartType.MAP_INT_STRING_NULLABLE: mapLibsNullable,
    DartType.RUNEITERATOR: runeIteratorLibs,
    DartType.RUNEITERATOR_NULLABLE: runeIteratorLibsNullable,
    DartType.RUNES: runesLibs,
    DartType.RUNES_NULLABLE: runesLibsNullable,
    DartType.SET_INT: setLibs,
    DartType.SET_INT_NULLABLE: setLibsNullable,
    DartType.STRING: stringLibs,
    DartType.STRING_NULLABLE: stringLibsNullable,
    DartType.SYMBOL: symbolLibs,
    DartType.SYMBOL_NULLABLE: symbolLibsNullable,
    DartType.UINT16LIST: uint16ListLibs,
    DartType.UINT16LIST_NULLABLE: uint16ListLibsNullable,
    DartType.UINT32LIST: uint32ListLibs,
    DartType.UINT32LIST_NULLABLE: uint32ListLibsNullable,
    DartType.UINT64LIST: uint64ListLibs,
    DartType.UINT64LIST_NULLABLE: uint64ListLibsNullable,
    DartType.UINT8CLAMPEDLIST: uint8ClampedListLibs,
    DartType.UINT8CLAMPEDLIST_NULLABLE: uint8ClampedListLibsNullable,
    DartType.UINT8LIST: uint8ListLibs,
    DartType.UINT8LIST_NULLABLE: uint8ListLibsNullable,
    DartType.VOID_NULLABLE: voidLibsNullable,
  };
  static const typedDataFloatTypes = [
    DartType.FLOAT32LIST,
    DartType.FLOAT32X4,
    DartType.FLOAT32X4LIST,
    DartType.FLOAT64LIST,
    DartType.FLOAT64X2,
    DartType.FLOAT64X2LIST,
  ];
  static const boolLibs = [
    DartLib('NetworkInterface.listSupported', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('SecurityContext.alpnSupported', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('add', [DartType.SET_INT, DartType.INT], true),
    DartLib('bool.fromEnvironment', [DartType.VOID, DartType.STRING], true),
    DartLib('bool.hasEnvironment', [DartType.VOID, DartType.STRING], true),
    DartLib('bool.parse', [DartType.VOID, DartType.STRING], true),
    DartLib('endsWith', [DartType.STRING, DartType.STRING], true),
    DartLib('flagW', [DartType.INT32X4, DartType.VOID], false),
    DartLib('flagX', [DartType.INT32X4, DartType.VOID], false),
    DartLib('flagY', [DartType.INT32X4, DartType.VOID], false),
    DartLib('flagZ', [DartType.INT32X4, DartType.VOID], false),
    DartLib('hasMatch', [DartType.REGEXP, DartType.STRING], true),
    DartLib('isCaseSensitive', [DartType.REGEXP, DartType.VOID], false),
    DartLib('isDotAll', [DartType.REGEXP, DartType.VOID], false),
    DartLib('isEmpty', [DartType.MAP_INT_STRING, DartType.VOID], false),
    DartLib('isEmpty', [DartType.STRINGBUFFER, DartType.VOID], false),
    DartLib('isEmpty', [DartType.STRING, DartType.VOID], false),
    DartLib('isEven', [DartType.INT, DartType.VOID], false),
    DartLib('isFinite', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('isInfinite', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('isMultiLine', [DartType.REGEXP, DartType.VOID], false),
    DartLib('isNaN', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('isNegative', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('isNotEmpty', [DartType.MAP_INT_STRING, DartType.VOID], false),
    DartLib('isNotEmpty', [DartType.STRINGBUFFER, DartType.VOID], false),
    DartLib('isNotEmpty', [DartType.STRING, DartType.VOID], false),
    DartLib('isOdd', [DartType.INT, DartType.VOID], false),
    DartLib('isUnicode', [DartType.REGEXP, DartType.VOID], false),
    DartLib('moveNext', [DartType.RUNEITERATOR, DartType.VOID], true),
    DartLib('movePrevious', [DartType.RUNEITERATOR, DartType.VOID], true),
  ];
  static const boolLibsNullable = [
    DartLib('NetworkInterface.listSupported', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('SecurityContext.alpnSupported', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('add', [DartType.SET_INT, DartType.INT], true),
    DartLib('bool.fromEnvironment', [DartType.VOID, DartType.STRING], true),
    DartLib('bool.hasEnvironment', [DartType.VOID, DartType.STRING], true),
    DartLib('bool.parse', [DartType.VOID, DartType.STRING], true),
    DartLib('bool.tryParse', [DartType.VOID, DartType.STRING], true),
    DartLib('endsWith', [DartType.STRING, DartType.STRING], true),
    DartLib('flagW', [DartType.INT32X4, DartType.VOID], false),
    DartLib('flagX', [DartType.INT32X4, DartType.VOID], false),
    DartLib('flagY', [DartType.INT32X4, DartType.VOID], false),
    DartLib('flagZ', [DartType.INT32X4, DartType.VOID], false),
    DartLib('hasMatch', [DartType.REGEXP, DartType.STRING], true),
    DartLib('isCaseSensitive', [DartType.REGEXP, DartType.VOID], false),
    DartLib('isDotAll', [DartType.REGEXP, DartType.VOID], false),
    DartLib('isEmpty', [DartType.MAP_INT_STRING, DartType.VOID], false),
    DartLib('isEmpty', [DartType.STRINGBUFFER, DartType.VOID], false),
    DartLib('isEmpty', [DartType.STRING, DartType.VOID], false),
    DartLib('isEven', [DartType.INT, DartType.VOID], false),
    DartLib('isFinite', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('isInfinite', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('isMultiLine', [DartType.REGEXP, DartType.VOID], false),
    DartLib('isNaN', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('isNegative', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('isNotEmpty', [DartType.MAP_INT_STRING, DartType.VOID], false),
    DartLib('isNotEmpty', [DartType.STRINGBUFFER, DartType.VOID], false),
    DartLib('isNotEmpty', [DartType.STRING, DartType.VOID], false),
    DartLib('isOdd', [DartType.INT, DartType.VOID], false),
    DartLib('isUnicode', [DartType.REGEXP, DartType.VOID], false),
    DartLib('moveNext', [DartType.RUNEITERATOR, DartType.VOID], true),
    DartLib('movePrevious', [DartType.RUNEITERATOR, DartType.VOID], true),
  ];
  static const deprecatedLibs = [
    DartLib('deprecated', [DartType.VOID, DartType.VOID], false),
  ];
  static const deprecatedLibsNullable = [
    DartLib('deprecated', [DartType.VOID, DartType.VOID], false),
  ];
  static const doubleLibs = [
    DartLib('abs', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('abs', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('acos', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('asin', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('atan', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('atan2', [DartType.VOID, DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('ceilToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('ceilToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('ceilToDouble', [DartType.INT, DartType.VOID], true),
    DartLib('clamp', [DartType.DOUBLE, DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('cos', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('double.infinity', [DartType.VOID, DartType.VOID], false),
    DartLib('double.maxFinite', [DartType.VOID, DartType.VOID], false),
    DartLib('double.minPositive', [DartType.VOID, DartType.VOID], false),
    DartLib('double.nan', [DartType.VOID, DartType.VOID], false),
    DartLib('double.negativeInfinity', [DartType.VOID, DartType.VOID], false),
    DartLib('double.parse', [DartType.VOID, DartType.STRING], true),
    DartLib('e', [DartType.VOID, DartType.VOID], false),
    DartLib('exp', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('floorToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('floorToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('floorToDouble', [DartType.INT, DartType.VOID], true),
    DartLib('ln10', [DartType.VOID, DartType.VOID], false),
    DartLib('ln2', [DartType.VOID, DartType.VOID], false),
    DartLib('log', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('log10e', [DartType.VOID, DartType.VOID], false),
    DartLib('log2e', [DartType.VOID, DartType.VOID], false),
    DartLib('pi', [DartType.VOID, DartType.VOID], false),
    DartLib('pow', [DartType.VOID, DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('remainder', [DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('remainder', [DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('roundToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('roundToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('roundToDouble', [DartType.INT, DartType.VOID], true),
    DartLib('sign', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('sign', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('sin', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('sqrt', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('sqrt1_2', [DartType.VOID, DartType.VOID], false),
    DartLib('sqrt2', [DartType.VOID, DartType.VOID], false),
    DartLib('tan', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('toDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncateToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncateToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncateToDouble', [DartType.INT, DartType.VOID], true),
    DartLib('w', [DartType.FLOAT32X4, DartType.VOID], false),
    DartLib('x', [DartType.FLOAT32X4, DartType.VOID], false),
    DartLib('x', [DartType.FLOAT64X2, DartType.VOID], false),
    DartLib('y', [DartType.FLOAT32X4, DartType.VOID], false),
    DartLib('y', [DartType.FLOAT64X2, DartType.VOID], false),
    DartLib('z', [DartType.FLOAT32X4, DartType.VOID], false),
  ];
  static const doubleLibsNullable = [
    DartLib('abs', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('abs', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('acos', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('asin', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('atan', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('atan2', [DartType.VOID, DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('ceilToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('ceilToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('ceilToDouble', [DartType.INT, DartType.VOID], true),
    DartLib('clamp', [DartType.DOUBLE, DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('cos', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('double.infinity', [DartType.VOID, DartType.VOID], false),
    DartLib('double.maxFinite', [DartType.VOID, DartType.VOID], false),
    DartLib('double.minPositive', [DartType.VOID, DartType.VOID], false),
    DartLib('double.nan', [DartType.VOID, DartType.VOID], false),
    DartLib('double.negativeInfinity', [DartType.VOID, DartType.VOID], false),
    DartLib('double.parse', [DartType.VOID, DartType.STRING], true),
    DartLib('double.tryParse', [DartType.VOID, DartType.STRING], true),
    DartLib('e', [DartType.VOID, DartType.VOID], false),
    DartLib('end', [DartType.RANGEERROR, DartType.VOID], false),
    DartLib('exp', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('floorToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('floorToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('floorToDouble', [DartType.INT, DartType.VOID], true),
    DartLib('invalidValue', [DartType.RANGEERROR, DartType.VOID], false),
    DartLib('ln10', [DartType.VOID, DartType.VOID], false),
    DartLib('ln2', [DartType.VOID, DartType.VOID], false),
    DartLib('log', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('log10e', [DartType.VOID, DartType.VOID], false),
    DartLib('log2e', [DartType.VOID, DartType.VOID], false),
    DartLib('num.tryParse', [DartType.VOID, DartType.STRING], true),
    DartLib('pi', [DartType.VOID, DartType.VOID], false),
    DartLib('pow', [DartType.VOID, DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('remainder', [DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('remainder', [DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('roundToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('roundToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('roundToDouble', [DartType.INT, DartType.VOID], true),
    DartLib('sign', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('sign', [DartType.DOUBLE, DartType.VOID], false),
    DartLib('sin', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('sqrt', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('sqrt1_2', [DartType.VOID, DartType.VOID], false),
    DartLib('sqrt2', [DartType.VOID, DartType.VOID], false),
    DartLib('start', [DartType.RANGEERROR, DartType.VOID], false),
    DartLib('tan', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('toDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncateToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncateToDouble', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncateToDouble', [DartType.INT, DartType.VOID], true),
    DartLib('w', [DartType.FLOAT32X4, DartType.VOID], false),
    DartLib('x', [DartType.FLOAT32X4, DartType.VOID], false),
    DartLib('x', [DartType.FLOAT64X2, DartType.VOID], false),
    DartLib('y', [DartType.FLOAT32X4, DartType.VOID], false),
    DartLib('y', [DartType.FLOAT64X2, DartType.VOID], false),
    DartLib('z', [DartType.FLOAT32X4, DartType.VOID], false),
  ];
  static const endianLibs = [
    DartLib('Endian.big', [DartType.VOID, DartType.VOID], false),
    DartLib('Endian.host', [DartType.VOID, DartType.VOID], false),
    DartLib('Endian.little', [DartType.VOID, DartType.VOID], false),
  ];
  static const endianLibsNullable = [
    DartLib('Endian.big', [DartType.VOID, DartType.VOID], false),
    DartLib('Endian.host', [DartType.VOID, DartType.VOID], false),
    DartLib('Endian.little', [DartType.VOID, DartType.VOID], false),
  ];
  static const float32ListLibs = [
    DartLib('sublist', [
      DartType.FLOAT32LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const float32ListLibsNullable = [
    DartLib('sublist', [
      DartType.FLOAT32LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const float32x4Libs = [
    DartLib('Float32x4.fromFloat64x2', [
      DartType.VOID,
      DartType.FLOAT64X2,
    ], true),
    DartLib('Float32x4.fromInt32x4Bits', [
      DartType.VOID,
      DartType.INT32X4,
    ], true),
    DartLib('Float32x4.splat', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('Float32x4.zero', [DartType.VOID, DartType.VOID], true),
    DartLib('abs', [DartType.FLOAT32X4, DartType.VOID], true),
    DartLib('clamp', [
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
    ], true),
    DartLib('max', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('min', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('scale', [DartType.FLOAT32X4, DartType.DOUBLE], true),
    DartLib('select', [
      DartType.INT32X4,
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
    ], true),
    DartLib('shuffle', [DartType.FLOAT32X4, DartType.INT], true),
    DartLib('shuffleMix', [
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
      DartType.INT,
    ], true),
    DartLib('sqrt', [DartType.FLOAT32X4, DartType.VOID], true),
    DartLib('withW', [DartType.FLOAT32X4, DartType.DOUBLE], true),
    DartLib('withX', [DartType.FLOAT32X4, DartType.DOUBLE], true),
    DartLib('withY', [DartType.FLOAT32X4, DartType.DOUBLE], true),
    DartLib('withZ', [DartType.FLOAT32X4, DartType.DOUBLE], true),
  ];
  static const float32x4ListLibs = [
    DartLib('sublist', [
      DartType.FLOAT32X4LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const float32x4ListLibsNullable = [
    DartLib('sublist', [
      DartType.FLOAT32X4LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const float32x4LibsNullable = [
    DartLib('Float32x4.fromFloat64x2', [
      DartType.VOID,
      DartType.FLOAT64X2,
    ], true),
    DartLib('Float32x4.fromInt32x4Bits', [
      DartType.VOID,
      DartType.INT32X4,
    ], true),
    DartLib('Float32x4.splat', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('Float32x4.zero', [DartType.VOID, DartType.VOID], true),
    DartLib('abs', [DartType.FLOAT32X4, DartType.VOID], true),
    DartLib('clamp', [
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
    ], true),
    DartLib('max', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('min', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('scale', [DartType.FLOAT32X4, DartType.DOUBLE], true),
    DartLib('select', [
      DartType.INT32X4,
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
    ], true),
    DartLib('shuffle', [DartType.FLOAT32X4, DartType.INT], true),
    DartLib('shuffleMix', [
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
      DartType.INT,
    ], true),
    DartLib('sqrt', [DartType.FLOAT32X4, DartType.VOID], true),
    DartLib('withW', [DartType.FLOAT32X4, DartType.DOUBLE], true),
    DartLib('withX', [DartType.FLOAT32X4, DartType.DOUBLE], true),
    DartLib('withY', [DartType.FLOAT32X4, DartType.DOUBLE], true),
    DartLib('withZ', [DartType.FLOAT32X4, DartType.DOUBLE], true),
  ];
  static const float64ListLibs = [
    DartLib('sublist', [
      DartType.FLOAT64LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const float64ListLibsNullable = [
    DartLib('sublist', [
      DartType.FLOAT64LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const float64x2Libs = [
    DartLib('Float64x2.fromFloat32x4', [
      DartType.VOID,
      DartType.FLOAT32X4,
    ], true),
    DartLib('Float64x2.splat', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('Float64x2.zero', [DartType.VOID, DartType.VOID], true),
    DartLib('abs', [DartType.FLOAT64X2, DartType.VOID], true),
    DartLib('clamp', [
      DartType.FLOAT64X2,
      DartType.FLOAT64X2,
      DartType.FLOAT64X2,
    ], true),
    DartLib('max', [DartType.FLOAT64X2, DartType.FLOAT64X2], true),
    DartLib('min', [DartType.FLOAT64X2, DartType.FLOAT64X2], true),
    DartLib('scale', [DartType.FLOAT64X2, DartType.DOUBLE], true),
    DartLib('sqrt', [DartType.FLOAT64X2, DartType.VOID], true),
    DartLib('withX', [DartType.FLOAT64X2, DartType.DOUBLE], true),
    DartLib('withY', [DartType.FLOAT64X2, DartType.DOUBLE], true),
  ];
  static const float64x2ListLibs = [
    DartLib('sublist', [
      DartType.FLOAT64X2LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const float64x2ListLibsNullable = [
    DartLib('sublist', [
      DartType.FLOAT64X2LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const float64x2LibsNullable = [
    DartLib('Float64x2.fromFloat32x4', [
      DartType.VOID,
      DartType.FLOAT32X4,
    ], true),
    DartLib('Float64x2.splat', [DartType.VOID, DartType.DOUBLE], true),
    DartLib('Float64x2.zero', [DartType.VOID, DartType.VOID], true),
    DartLib('abs', [DartType.FLOAT64X2, DartType.VOID], true),
    DartLib('clamp', [
      DartType.FLOAT64X2,
      DartType.FLOAT64X2,
      DartType.FLOAT64X2,
    ], true),
    DartLib('max', [DartType.FLOAT64X2, DartType.FLOAT64X2], true),
    DartLib('min', [DartType.FLOAT64X2, DartType.FLOAT64X2], true),
    DartLib('scale', [DartType.FLOAT64X2, DartType.DOUBLE], true),
    DartLib('sqrt', [DartType.FLOAT64X2, DartType.VOID], true),
    DartLib('withX', [DartType.FLOAT64X2, DartType.DOUBLE], true),
    DartLib('withY', [DartType.FLOAT64X2, DartType.DOUBLE], true),
  ];
  static const intLibs = [
    DartLib('DateTime.april', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.august', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.daysPerWeek', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.december', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.february', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.friday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.january', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.july', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.june', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.march', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.may', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.monday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.monthsPerYear', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.november', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.october', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.saturday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.september', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.sunday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.thursday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.tuesday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.wednesday', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.hoursPerDay', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.microsecondsPerDay', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.microsecondsPerHour', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.microsecondsPerMillisecond', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.microsecondsPerMinute', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.microsecondsPerSecond', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.millisecondsPerDay', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.millisecondsPerHour', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.millisecondsPerMinute', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.millisecondsPerSecond', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.minutesPerDay', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.minutesPerHour', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.secondsPerDay', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.secondsPerHour', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.secondsPerMinute', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Float32x4.wwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Float64List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Float64x2List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('IndexError.check', [
      DartType.VOID,
      DartType.INT,
      DartType.INT,
    ], true),
    DartLib('Int16List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Int64List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('Int8List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('Isolate.beforeNextEvent', [DartType.VOID, DartType.VOID], false),
    DartLib('Isolate.immediate', [DartType.VOID, DartType.VOID], false),
    DartLib('OSError.noErrorCode', [DartType.VOID, DartType.VOID], false),
    DartLib('RangeError.checkNotNegative', [
      DartType.VOID,
      DartType.INT,
      DartType.STRING_NULLABLE,
      DartType.STRING_NULLABLE,
    ], true),
    DartLib('RangeError.checkValidRange', [
      DartType.VOID,
      DartType.INT,
      DartType.INT_NULLABLE,
      DartType.INT,
      DartType.STRING_NULLABLE,
      DartType.STRING_NULLABLE,
      DartType.STRING_NULLABLE,
    ], true),
    DartLib('RangeError.checkValueInInterval', [
      DartType.VOID,
      DartType.INT,
      DartType.INT,
      DartType.INT,
      DartType.STRING_NULLABLE,
      DartType.STRING_NULLABLE,
    ], true),
    DartLib('RawSocketOption.IPv4MulticastInterface', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('RawSocketOption.IPv6MulticastInterface', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('RawSocketOption.levelIPv4', [DartType.VOID, DartType.VOID], false),
    DartLib('RawSocketOption.levelIPv6', [DartType.VOID, DartType.VOID], false),
    DartLib('RawSocketOption.levelSocket', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('RawSocketOption.levelTcp', [DartType.VOID, DartType.VOID], false),
    DartLib('RawSocketOption.levelUdp', [DartType.VOID, DartType.VOID], false),
    DartLib('Uint16List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Uint32List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Uint64List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Uint8ClampedList.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Uint8List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.defaultLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.defaultMemLevel', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.defaultWindowBits', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.maxLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.maxMemLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.maxWindowBits', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.minLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.minMemLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.minWindowBits', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.strategyDefault', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.strategyFiltered', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.strategyFixed', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.strategyHuffmanOnly', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.strategyRle', [DartType.VOID, DartType.VOID], false),
    DartLib('abs', [DartType.INT, DartType.VOID], true),
    DartLib('bitLength', [DartType.INT, DartType.VOID], false),
    DartLib('ceil', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('ceil', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('ceil', [DartType.INT, DartType.VOID], true),
    DartLib('codeUnitAt', [DartType.STRING, DartType.INT], true),
    DartLib('compareTo', [DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('compareTo', [DartType.STRING, DartType.STRING], true),
    DartLib('current', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('currentSize', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('end', [DartType.INDEXERROR, DartType.VOID], false),
    DartLib('floor', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('floor', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('floor', [DartType.INT, DartType.VOID], true),
    DartLib('gcd', [DartType.INT, DartType.INT], true),
    DartLib('indexOf', [DartType.LIST_INT, DartType.INT, DartType.INT], true),
    DartLib('int.fromEnvironment', [DartType.VOID, DartType.STRING], true),
    DartLib('int.parse', [DartType.VOID, DartType.STRING], true),
    DartLib('invalidValue', [DartType.INDEXERROR, DartType.VOID], false),
    DartLib('last', [DartType.RUNES, DartType.VOID], false),
    DartLib('lastIndexOf', [
      DartType.LIST_INT,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('length', [DartType.INDEXERROR, DartType.VOID], false),
    DartLib('length', [DartType.LIST_INT, DartType.VOID], false),
    DartLib('length', [DartType.MAP_INT_STRING, DartType.VOID], false),
    DartLib('length', [DartType.STRINGBUFFER, DartType.VOID], false),
    DartLib('length', [DartType.STRING, DartType.VOID], false),
    DartLib('modInverse', [DartType.INT, DartType.INT], true),
    DartLib('modPow', [DartType.INT, DartType.INT, DartType.INT], true),
    DartLib('rawIndex', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('removeAt', [DartType.LIST_INT, DartType.INT], true),
    DartLib('removeLast', [DartType.LIST_INT, DartType.VOID], true),
    DartLib('round', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('round', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('round', [DartType.INT, DartType.VOID], true),
    DartLib('sign', [DartType.INT, DartType.VOID], false),
    DartLib('signMask', [DartType.FLOAT32X4, DartType.VOID], false),
    DartLib('signMask', [DartType.FLOAT64X2, DartType.VOID], false),
    DartLib('signMask', [DartType.INT32X4, DartType.VOID], false),
    DartLib('start', [DartType.INDEXERROR, DartType.VOID], false),
    DartLib('toInt', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('toSigned', [DartType.INT, DartType.INT], true),
    DartLib('toUnsigned', [DartType.INT, DartType.INT], true),
    DartLib('truncate', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncate', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncate', [DartType.INT, DartType.VOID], true),
    DartLib('unicodeBomCharacterRune', [DartType.VOID, DartType.VOID], false),
    DartLib('unicodeReplacementCharacterRune', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('w', [DartType.INT32X4, DartType.VOID], false),
    DartLib('x', [DartType.INT32X4, DartType.VOID], false),
    DartLib('y', [DartType.INT32X4, DartType.VOID], false),
    DartLib('z', [DartType.INT32X4, DartType.VOID], false),
  ];
  static const int16ListLibs = [
    DartLib('Int16List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.INT16LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const int16ListLibsNullable = [
    DartLib('Int16List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.INT16LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const int32ListLibs = [
    DartLib('Int32List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.INT32LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const int32ListLibsNullable = [
    DartLib('Int32List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.INT32LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const int32x4Libs = [
    DartLib('Int32x4.bool', [
      DartType.VOID,
      DartType.BOOL,
      DartType.BOOL,
      DartType.BOOL,
      DartType.BOOL,
    ], true),
    DartLib('Int32x4.fromFloat32x4Bits', [
      DartType.VOID,
      DartType.FLOAT32X4,
    ], true),
    DartLib('equal', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('greaterThan', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('greaterThanOrEqual', [
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
    ], true),
    DartLib('lessThan', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('lessThanOrEqual', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('notEqual', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('shuffle', [DartType.INT32X4, DartType.INT], true),
    DartLib('shuffleMix', [
      DartType.INT32X4,
      DartType.INT32X4,
      DartType.INT,
    ], true),
    DartLib('withFlagW', [DartType.INT32X4, DartType.BOOL], true),
    DartLib('withFlagX', [DartType.INT32X4, DartType.BOOL], true),
    DartLib('withFlagY', [DartType.INT32X4, DartType.BOOL], true),
    DartLib('withFlagZ', [DartType.INT32X4, DartType.BOOL], true),
    DartLib('withW', [DartType.INT32X4, DartType.INT], true),
    DartLib('withX', [DartType.INT32X4, DartType.INT], true),
    DartLib('withY', [DartType.INT32X4, DartType.INT], true),
    DartLib('withZ', [DartType.INT32X4, DartType.INT], true),
  ];
  static const int32x4ListLibs = [
    DartLib('sublist', [
      DartType.INT32X4LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const int32x4ListLibsNullable = [
    DartLib('sublist', [
      DartType.INT32X4LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const int32x4LibsNullable = [
    DartLib('Int32x4.bool', [
      DartType.VOID,
      DartType.BOOL,
      DartType.BOOL,
      DartType.BOOL,
      DartType.BOOL,
    ], true),
    DartLib('Int32x4.fromFloat32x4Bits', [
      DartType.VOID,
      DartType.FLOAT32X4,
    ], true),
    DartLib('equal', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('greaterThan', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('greaterThanOrEqual', [
      DartType.FLOAT32X4,
      DartType.FLOAT32X4,
    ], true),
    DartLib('lessThan', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('lessThanOrEqual', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('notEqual', [DartType.FLOAT32X4, DartType.FLOAT32X4], true),
    DartLib('shuffle', [DartType.INT32X4, DartType.INT], true),
    DartLib('shuffleMix', [
      DartType.INT32X4,
      DartType.INT32X4,
      DartType.INT,
    ], true),
    DartLib('withFlagW', [DartType.INT32X4, DartType.BOOL], true),
    DartLib('withFlagX', [DartType.INT32X4, DartType.BOOL], true),
    DartLib('withFlagY', [DartType.INT32X4, DartType.BOOL], true),
    DartLib('withFlagZ', [DartType.INT32X4, DartType.BOOL], true),
    DartLib('withW', [DartType.INT32X4, DartType.INT], true),
    DartLib('withX', [DartType.INT32X4, DartType.INT], true),
    DartLib('withY', [DartType.INT32X4, DartType.INT], true),
    DartLib('withZ', [DartType.INT32X4, DartType.INT], true),
  ];
  static const int64ListLibs = [
    DartLib('Int64List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.INT64LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const int64ListLibsNullable = [
    DartLib('Int64List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.INT64LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const int8ListLibs = [
    DartLib('Int8List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.INT8LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const int8ListLibsNullable = [
    DartLib('Int8List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.INT8LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const intLibsNullable = [
    DartLib('DateTime.april', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.august', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.daysPerWeek', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.december', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.february', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.friday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.january', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.july', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.june', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.march', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.may', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.monday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.monthsPerYear', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.november', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.october', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.saturday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.september', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.sunday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.thursday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.tuesday', [DartType.VOID, DartType.VOID], false),
    DartLib('DateTime.wednesday', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.hoursPerDay', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.microsecondsPerDay', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.microsecondsPerHour', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.microsecondsPerMillisecond', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.microsecondsPerMinute', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.microsecondsPerSecond', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.millisecondsPerDay', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.millisecondsPerHour', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.millisecondsPerMinute', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.millisecondsPerSecond', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Duration.minutesPerDay', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.minutesPerHour', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.secondsPerDay', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.secondsPerHour', [DartType.VOID, DartType.VOID], false),
    DartLib('Duration.secondsPerMinute', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Float32x4.wwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.wzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.xzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.ywzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.yzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4.zzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Float32x4List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Float64List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Float64x2List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('IndexError.check', [
      DartType.VOID,
      DartType.INT,
      DartType.INT,
    ], true),
    DartLib('Int16List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.wzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.xzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.ywzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.yzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zwzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zxzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zywx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zywy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zywz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zyzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzww', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzwx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzwy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzwz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzxw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzxx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzxy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzxz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzyw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzyx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzyy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzyz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzzw', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzzx', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzzy', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4.zzzz', [DartType.VOID, DartType.VOID], false),
    DartLib('Int32x4List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Int64List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('Int8List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('Isolate.beforeNextEvent', [DartType.VOID, DartType.VOID], false),
    DartLib('Isolate.immediate', [DartType.VOID, DartType.VOID], false),
    DartLib('OSError.noErrorCode', [DartType.VOID, DartType.VOID], false),
    DartLib('RangeError.checkNotNegative', [
      DartType.VOID,
      DartType.INT,
      DartType.STRING_NULLABLE,
      DartType.STRING_NULLABLE,
    ], true),
    DartLib('RangeError.checkValidRange', [
      DartType.VOID,
      DartType.INT,
      DartType.INT_NULLABLE,
      DartType.INT,
      DartType.STRING_NULLABLE,
      DartType.STRING_NULLABLE,
      DartType.STRING_NULLABLE,
    ], true),
    DartLib('RangeError.checkValueInInterval', [
      DartType.VOID,
      DartType.INT,
      DartType.INT,
      DartType.INT,
      DartType.STRING_NULLABLE,
      DartType.STRING_NULLABLE,
    ], true),
    DartLib('RawSocketOption.IPv4MulticastInterface', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('RawSocketOption.IPv6MulticastInterface', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('RawSocketOption.levelIPv4', [DartType.VOID, DartType.VOID], false),
    DartLib('RawSocketOption.levelIPv6', [DartType.VOID, DartType.VOID], false),
    DartLib('RawSocketOption.levelSocket', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('RawSocketOption.levelTcp', [DartType.VOID, DartType.VOID], false),
    DartLib('RawSocketOption.levelUdp', [DartType.VOID, DartType.VOID], false),
    DartLib('Uint16List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Uint32List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Uint64List.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Uint8ClampedList.bytesPerElement', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('Uint8List.bytesPerElement', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.defaultLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.defaultMemLevel', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.defaultWindowBits', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.maxLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.maxMemLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.maxWindowBits', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.minLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.minMemLevel', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.minWindowBits', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.strategyDefault', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.strategyFiltered', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.strategyFixed', [DartType.VOID, DartType.VOID], false),
    DartLib('ZLibOption.strategyHuffmanOnly', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('ZLibOption.strategyRle', [DartType.VOID, DartType.VOID], false),
    DartLib('abs', [DartType.INT, DartType.VOID], true),
    DartLib('bitLength', [DartType.INT, DartType.VOID], false),
    DartLib('ceil', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('ceil', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('ceil', [DartType.INT, DartType.VOID], true),
    DartLib('codeUnitAt', [DartType.STRING, DartType.INT], true),
    DartLib('compareTo', [DartType.DOUBLE, DartType.DOUBLE], true),
    DartLib('compareTo', [DartType.STRING, DartType.STRING], true),
    DartLib('current', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('currentSize', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('end', [DartType.INDEXERROR, DartType.VOID], false),
    DartLib('floor', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('floor', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('floor', [DartType.INT, DartType.VOID], true),
    DartLib('gcd', [DartType.INT, DartType.INT], true),
    DartLib('indexOf', [DartType.LIST_INT, DartType.INT, DartType.INT], true),
    DartLib('int.fromEnvironment', [DartType.VOID, DartType.STRING], true),
    DartLib('int.parse', [DartType.VOID, DartType.STRING], true),
    DartLib('int.tryParse', [DartType.VOID, DartType.STRING], true),
    DartLib('invalidValue', [DartType.INDEXERROR, DartType.VOID], false),
    DartLib('last', [DartType.RUNES, DartType.VOID], false),
    DartLib('lastIndexOf', [
      DartType.LIST_INT,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('length', [DartType.INDEXERROR, DartType.VOID], false),
    DartLib('length', [DartType.LIST_INT, DartType.VOID], false),
    DartLib('length', [DartType.MAP_INT_STRING, DartType.VOID], false),
    DartLib('length', [DartType.STRINGBUFFER, DartType.VOID], false),
    DartLib('length', [DartType.STRING, DartType.VOID], false),
    DartLib('modInverse', [DartType.INT, DartType.INT], true),
    DartLib('modPow', [DartType.INT, DartType.INT, DartType.INT], true),
    DartLib('offset', [DartType.FORMATEXCEPTION, DartType.VOID], false),
    DartLib('rawIndex', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('removeAt', [DartType.LIST_INT, DartType.INT], true),
    DartLib('removeLast', [DartType.LIST_INT, DartType.VOID], true),
    DartLib('round', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('round', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('round', [DartType.INT, DartType.VOID], true),
    DartLib('sign', [DartType.INT, DartType.VOID], false),
    DartLib('signMask', [DartType.FLOAT32X4, DartType.VOID], false),
    DartLib('signMask', [DartType.FLOAT64X2, DartType.VOID], false),
    DartLib('signMask', [DartType.INT32X4, DartType.VOID], false),
    DartLib('start', [DartType.INDEXERROR, DartType.VOID], false),
    DartLib('toInt', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('toSigned', [DartType.INT, DartType.INT], true),
    DartLib('toUnsigned', [DartType.INT, DartType.INT], true),
    DartLib('truncate', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncate', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('truncate', [DartType.INT, DartType.VOID], true),
    DartLib('unicodeBomCharacterRune', [DartType.VOID, DartType.VOID], false),
    DartLib('unicodeReplacementCharacterRune', [
      DartType.VOID,
      DartType.VOID,
    ], false),
    DartLib('w', [DartType.INT32X4, DartType.VOID], false),
    DartLib('x', [DartType.INT32X4, DartType.VOID], false),
    DartLib('y', [DartType.INT32X4, DartType.VOID], false),
    DartLib('z', [DartType.INT32X4, DartType.VOID], false),
  ];
  static const listLibs = [
    DartLib('List<int>.empty', [DartType.VOID, DartType.VOID], true),
    DartLib(
      'List<int>.filled',
      [DartType.VOID, DartType.INT, DartType.INT],
      true,
      restrictions: [Restriction.none, Restriction.small, Restriction.none],
    ),
    DartLib('Uri.parseIPv4Address', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.parseIPv6Address', [
      DartType.VOID,
      DartType.STRING,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('codeUnits', [DartType.STRING, DartType.VOID], false),
    DartLib('sublist', [
      DartType.LIST_INT,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const listLibsNullable = [
    DartLib('List<int>.empty', [DartType.VOID, DartType.VOID], true),
    DartLib(
      'List<int>.filled',
      [DartType.VOID, DartType.INT, DartType.INT],
      true,
      restrictions: [Restriction.none, Restriction.small, Restriction.none],
    ),
    DartLib('Uri.parseIPv4Address', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.parseIPv6Address', [
      DartType.VOID,
      DartType.STRING,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('codeUnits', [DartType.STRING, DartType.VOID], false),
    DartLib('sublist', [
      DartType.LIST_INT,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const mapLibs = [
    DartLib('Map<int, String>.from', [
      DartType.VOID,
      DartType.MAP_INT_STRING,
    ], true),
    DartLib('Map<int, String>.identity', [DartType.VOID, DartType.VOID], true),
    DartLib('Map<int, String>.of', [
      DartType.VOID,
      DartType.MAP_INT_STRING,
    ], true),
    DartLib('Map<int, String>.unmodifiable', [
      DartType.VOID,
      DartType.MAP_INT_STRING,
    ], true),
  ];
  static const mapLibsNullable = [
    DartLib('Map<int, String>.from', [
      DartType.VOID,
      DartType.MAP_INT_STRING,
    ], true),
    DartLib('Map<int, String>.identity', [DartType.VOID, DartType.VOID], true),
    DartLib('Map<int, String>.of', [
      DartType.VOID,
      DartType.MAP_INT_STRING,
    ], true),
    DartLib('Map<int, String>.unmodifiable', [
      DartType.VOID,
      DartType.MAP_INT_STRING,
    ], true),
  ];
  static const runeIteratorLibs = [
    DartLib('iterator', [DartType.RUNES, DartType.VOID], false),
  ];
  static const runeIteratorLibsNullable = [
    DartLib('iterator', [DartType.RUNES, DartType.VOID], false),
  ];
  static const runesLibs = [
    DartLib('runes', [DartType.STRING, DartType.VOID], false),
  ];
  static const runesLibsNullable = [
    DartLib('runes', [DartType.STRING, DartType.VOID], false),
  ];
  static const setLibs = [
    DartLib('Set<int>.identity', [DartType.VOID, DartType.VOID], true),
    DartLib('difference', [DartType.SET_INT, DartType.SET_INT], true),
    DartLib('intersection', [DartType.SET_INT, DartType.SET_INT], true),
    DartLib('toSet', [DartType.SET_INT, DartType.VOID], true),
    DartLib('union', [DartType.SET_INT, DartType.SET_INT], true),
  ];
  static const setLibsNullable = [
    DartLib('Set<int>.identity', [DartType.VOID, DartType.VOID], true),
    DartLib('difference', [DartType.SET_INT, DartType.SET_INT], true),
    DartLib('intersection', [DartType.SET_INT, DartType.SET_INT], true),
    DartLib('toSet', [DartType.SET_INT, DartType.VOID], true),
    DartLib('union', [DartType.SET_INT, DartType.SET_INT], true),
  ];
  static const stringLibs = [
    DartLib('ListBase.listToString', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('RegExp.escape', [DartType.VOID, DartType.STRING], true),
    DartLib('SetBase.setToString', [DartType.VOID, DartType.SET_INT], true),
    DartLib('String.fromCharCode', [DartType.VOID, DartType.INT], true),
    DartLib('String.fromEnvironment', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.decodeComponent', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.decodeFull', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.decodeQueryComponent', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.encodeComponent', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.encodeFull', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.encodeQueryComponent', [DartType.VOID, DartType.STRING], true),
    DartLib('base64Encode', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('base64UrlEncode', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('currentAsString', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('message', [DartType.DEPRECATED, DartType.VOID], false),
    DartLib('message', [DartType.FORMATEXCEPTION, DartType.VOID], false),
    DartLib('message', [DartType.STATEERROR, DartType.VOID], false),
    DartLib(
      'padLeft',
      [DartType.STRING, DartType.INT, DartType.STRING],
      true,
      restrictions: [Restriction.none, Restriction.small, Restriction.small],
    ),
    DartLib(
      'padRight',
      [DartType.STRING, DartType.INT, DartType.STRING],
      true,
      restrictions: [Restriction.none, Restriction.small, Restriction.small],
    ),
    DartLib('pattern', [DartType.REGEXP, DartType.VOID], false),
    DartLib('replaceRange', [
      DartType.STRING,
      DartType.INT,
      DartType.INT_NULLABLE,
      DartType.STRING,
    ], true),
    DartLib('string', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('string', [DartType.RUNES, DartType.VOID], false),
    DartLib('substring', [
      DartType.STRING,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('toLowerCase', [DartType.STRING, DartType.VOID], true),
    DartLib('toRadixString', [DartType.INT, DartType.INT], true),
    DartLib('toString', [DartType.ARGUMENTERROR, DartType.VOID], true),
    DartLib('toString', [DartType.BOOL, DartType.VOID], true),
    DartLib('toString', [
      DartType.CONCURRENTMODIFICATIONERROR,
      DartType.VOID,
    ], true),
    DartLib('toString', [DartType.DEPRECATED, DartType.VOID], true),
    DartLib('toString', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('toString', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('toString', [DartType.ERROR, DartType.VOID], true),
    DartLib('toString', [DartType.FORMATEXCEPTION, DartType.VOID], true),
    DartLib('toString', [DartType.INT, DartType.VOID], true),
    DartLib('toString', [
      DartType.INTEGERDIVISIONBYZEROEXCEPTION,
      DartType.VOID,
    ], true),
    DartLib('toString', [DartType.MAPENTRY_INT_STRING, DartType.VOID], true),
    DartLib('toString', [DartType.NULL, DartType.VOID], true),
    DartLib('toString', [DartType.STACKOVERFLOWERROR, DartType.VOID], true),
    DartLib('toString', [DartType.STATEERROR, DartType.VOID], true),
    DartLib('toString', [DartType.STRINGBUFFER, DartType.VOID], true),
    DartLib('toString', [DartType.UNIMPLEMENTEDERROR, DartType.VOID], true),
    DartLib('toString', [DartType.UNSUPPORTEDERROR, DartType.VOID], true),
    DartLib('toStringAsExponential', [
      DartType.DOUBLE,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('toStringAsFixed', [DartType.DOUBLE, DartType.INT], true),
    DartLib('toStringAsPrecision', [DartType.DOUBLE, DartType.INT], true),
    DartLib('toUpperCase', [DartType.STRING, DartType.VOID], true),
    DartLib('trim', [DartType.STRING, DartType.VOID], true),
    DartLib('trimLeft', [DartType.STRING, DartType.VOID], true),
    DartLib('trimRight', [DartType.STRING, DartType.VOID], true),
  ];
  static const stringLibsNullable = [
    DartLib('ListBase.listToString', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('RegExp.escape', [DartType.VOID, DartType.STRING], true),
    DartLib('SetBase.setToString', [DartType.VOID, DartType.SET_INT], true),
    DartLib('String.fromCharCode', [DartType.VOID, DartType.INT], true),
    DartLib('String.fromEnvironment', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.decodeComponent', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.decodeFull', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.decodeQueryComponent', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.encodeComponent', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.encodeFull', [DartType.VOID, DartType.STRING], true),
    DartLib('Uri.encodeQueryComponent', [DartType.VOID, DartType.STRING], true),
    DartLib('base64Encode', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('base64UrlEncode', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('currentAsString', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('message', [DartType.DEPRECATED, DartType.VOID], false),
    DartLib('message', [DartType.FORMATEXCEPTION, DartType.VOID], false),
    DartLib('message', [
      DartType.INTEGERDIVISIONBYZEROEXCEPTION,
      DartType.VOID,
    ], false),
    DartLib('message', [DartType.STATEERROR, DartType.VOID], false),
    DartLib('message', [DartType.UNIMPLEMENTEDERROR, DartType.VOID], false),
    DartLib('message', [DartType.UNSUPPORTEDERROR, DartType.VOID], false),
    DartLib('name', [DartType.ARGUMENTERROR, DartType.VOID], false),
    DartLib(
      'padLeft',
      [DartType.STRING, DartType.INT, DartType.STRING],
      true,
      restrictions: [Restriction.none, Restriction.small, Restriction.small],
    ),
    DartLib(
      'padRight',
      [DartType.STRING, DartType.INT, DartType.STRING],
      true,
      restrictions: [Restriction.none, Restriction.small, Restriction.small],
    ),
    DartLib('pattern', [DartType.REGEXP, DartType.VOID], false),
    DartLib('replaceRange', [
      DartType.STRING,
      DartType.INT,
      DartType.INT_NULLABLE,
      DartType.STRING,
    ], true),
    DartLib('string', [DartType.RUNEITERATOR, DartType.VOID], false),
    DartLib('string', [DartType.RUNES, DartType.VOID], false),
    DartLib('stringMatch', [DartType.REGEXP, DartType.STRING], true),
    DartLib('substring', [
      DartType.STRING,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('toLowerCase', [DartType.STRING, DartType.VOID], true),
    DartLib('toRadixString', [DartType.INT, DartType.INT], true),
    DartLib('toString', [DartType.ARGUMENTERROR, DartType.VOID], true),
    DartLib('toString', [DartType.BOOL, DartType.VOID], true),
    DartLib('toString', [
      DartType.CONCURRENTMODIFICATIONERROR,
      DartType.VOID,
    ], true),
    DartLib('toString', [DartType.DEPRECATED, DartType.VOID], true),
    DartLib('toString', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('toString', [DartType.DOUBLE, DartType.VOID], true),
    DartLib('toString', [DartType.ERROR, DartType.VOID], true),
    DartLib('toString', [DartType.FORMATEXCEPTION, DartType.VOID], true),
    DartLib('toString', [DartType.INT, DartType.VOID], true),
    DartLib('toString', [
      DartType.INTEGERDIVISIONBYZEROEXCEPTION,
      DartType.VOID,
    ], true),
    DartLib('toString', [DartType.MAPENTRY_INT_STRING, DartType.VOID], true),
    DartLib('toString', [DartType.NULL, DartType.VOID], true),
    DartLib('toString', [DartType.STACKOVERFLOWERROR, DartType.VOID], true),
    DartLib('toString', [DartType.STATEERROR, DartType.VOID], true),
    DartLib('toString', [DartType.STRINGBUFFER, DartType.VOID], true),
    DartLib('toString', [DartType.UNIMPLEMENTEDERROR, DartType.VOID], true),
    DartLib('toString', [DartType.UNSUPPORTEDERROR, DartType.VOID], true),
    DartLib('toStringAsExponential', [
      DartType.DOUBLE,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('toStringAsFixed', [DartType.DOUBLE, DartType.INT], true),
    DartLib('toStringAsPrecision', [DartType.DOUBLE, DartType.INT], true),
    DartLib('toUpperCase', [DartType.STRING, DartType.VOID], true),
    DartLib('trim', [DartType.STRING, DartType.VOID], true),
    DartLib('trimLeft', [DartType.STRING, DartType.VOID], true),
    DartLib('trimRight', [DartType.STRING, DartType.VOID], true),
  ];
  static const symbolLibs = [
    DartLib('Symbol.empty', [DartType.VOID, DartType.VOID], false),
    DartLib('Symbol.unaryMinus', [DartType.VOID, DartType.VOID], false),
  ];
  static const symbolLibsNullable = [
    DartLib('Symbol.empty', [DartType.VOID, DartType.VOID], false),
    DartLib('Symbol.unaryMinus', [DartType.VOID, DartType.VOID], false),
  ];
  static const uint16ListLibs = [
    DartLib('Uint16List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.UINT16LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const uint16ListLibsNullable = [
    DartLib('Uint16List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.UINT16LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const uint32ListLibs = [
    DartLib('Uint32List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.UINT32LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const uint32ListLibsNullable = [
    DartLib('Uint32List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.UINT32LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const uint64ListLibs = [
    DartLib('Uint64List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.UINT64LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const uint64ListLibsNullable = [
    DartLib('Uint64List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('sublist', [
      DartType.UINT64LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const uint8ClampedListLibs = [
    DartLib('Uint8ClampedList.fromList', [
      DartType.VOID,
      DartType.LIST_INT,
    ], true),
    DartLib('sublist', [
      DartType.UINT8CLAMPEDLIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const uint8ClampedListLibsNullable = [
    DartLib('Uint8ClampedList.fromList', [
      DartType.VOID,
      DartType.LIST_INT,
    ], true),
    DartLib('sublist', [
      DartType.UINT8CLAMPEDLIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const uint8ListLibs = [
    DartLib('Uint8List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('base64Decode', [DartType.VOID, DartType.STRING], true),
    DartLib('sublist', [
      DartType.UINT8LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const uint8ListLibsNullable = [
    DartLib('Uint8List.fromList', [DartType.VOID, DartType.LIST_INT], true),
    DartLib('base64Decode', [DartType.VOID, DartType.STRING], true),
    DartLib('sublist', [
      DartType.UINT8LIST,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
  ];
  static const voidLibs = [
    DartLib('add', [DartType.LIST_INT, DartType.INT], true),
    DartLib('addAll', [DartType.MAP_INT_STRING, DartType.MAP_INT_STRING], true),
    DartLib('clear', [DartType.LIST_INT, DartType.VOID], true),
    DartLib('clear', [DartType.MAP_INT_STRING, DartType.VOID], true),
    DartLib('clear', [DartType.SET_INT, DartType.VOID], true),
    DartLib('clear', [DartType.STRINGBUFFER, DartType.VOID], true),
    DartLib('fillRange', [
      DartType.LIST_INT,
      DartType.INT,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('insert', [DartType.LIST_INT, DartType.INT, DartType.INT], true),
    DartLib('removeRange', [
      DartType.LIST_INT,
      DartType.INT,
      DartType.INT,
    ], true),
    DartLib('reset', [DartType.RUNEITERATOR, DartType.INT], true),
    DartLib('writeCharCode', [DartType.STRINGBUFFER, DartType.INT], true),
  ];
  static const voidLibsNullable = [
    DartLib('add', [DartType.LIST_INT, DartType.INT], true),
    DartLib('addAll', [DartType.MAP_INT_STRING, DartType.MAP_INT_STRING], true),
    DartLib('clear', [DartType.LIST_INT, DartType.VOID], true),
    DartLib('clear', [DartType.MAP_INT_STRING, DartType.VOID], true),
    DartLib('clear', [DartType.SET_INT, DartType.VOID], true),
    DartLib('clear', [DartType.STRINGBUFFER, DartType.VOID], true),
    DartLib('fillRange', [
      DartType.LIST_INT,
      DartType.INT,
      DartType.INT,
      DartType.INT_NULLABLE,
    ], true),
    DartLib('insert', [DartType.LIST_INT, DartType.INT, DartType.INT], true),
    DartLib('removeRange', [
      DartType.LIST_INT,
      DartType.INT,
      DartType.INT,
    ], true),
    DartLib('reset', [DartType.RUNEITERATOR, DartType.INT], true),
    DartLib('writeCharCode', [DartType.STRINGBUFFER, DartType.INT], true),
  ];
}
