Minimize
========

The `minimize.py` script minimizes a program generated by `dartfuzz.dart`.

The Minimization is done in two phases:

1. Minimize statements.
2. Minimize expressions.


### Example

Generate a dart program that triggers a bug:

```
dart dartfuzz.dart --no-ffi --no-fp --seed 790976770 test.dart
```

Examine the bug (sample crash shown below):

```
dart --optimization_counter_threshold=1 test.dart

...
===== CRASH =====
si_signo=Segmentation fault(11), si_code=1, si_addr=(nil)
version=2.6.0-edge.de7ad46797d36a25e6d2800820f61f4af3bd1135 (Wed Sep 11 18:20:46 2019 +0000) on "linux_x64"
thread=183944, isolate=main(0x559bd215cc00)
...
  pc 0x0000559bd0e40a69 fp 0x00007f73d7a7de70 ../../../../sdk/out/ReleaseX64/dart+0x190ca69
-- End of DumpStackTrace
```

Pick a keyword identifying the bug in the output, e.g. "Segmentation".
This will be the `--err` parameter.
Determine whether the bug is deterministic.
If not, set the `--tries` parameter such that the number of tries triggers
the error at least once with high probability.


Minimize statements of the generated program:

#### Phase 1
```
python3 minimize.py \
    --dartfuzz "dart dartfuzz.dart --no-ffi --no-fp --seed 790976770" \
    --dart "dart --optimization_counter_threshold=1" \
    --testfile mini.dart \
    --err Segmentation \
    --tries 4 \
    --threads 4 \
    --typ s \
    --verbose

3fffffffffffffffffffffffffffffffffffffffffffffffff
error
7fffffffffffffffffffffffffffffffffffffffffffffffff
error
STOP
Best I could do is 198/198
dart dartfuzz.dart --no-ffi --no-fp --seed 790976770 mini.dart --mini --smask 0x7fffffffffffffffffffffffffffffffffffffffffffffffff --emask 0
```

We were able to eliminate all of the statements.
Taking a look at `mini.dart` we see that function parameters still remain.
These can be minimized in phase 2.

Minimize expressions of the generated program:

#### Phase 2
```
python3 minimize.py \
    --dartfuzz "dart dartfuzz.dart --no-ffi --no-fp --seed 790976770" \
    --dart "dart --optimization_counter_threshold=1" \
    --testfile mini.dart \
    --err Segmentation \
    --tries 4 \
    --threads 4 \
    --typ e \
    --verbose \
    --smask 0x7fffffffffffffffffffffffffffffffffffffffffffffffff
..
STOP
Best I could do is 4626/4628
dart dartfuzz.dart --no-ffi --no-fp --seed 790976770 mini.dart --mini --smask 0x7fffffffffffffffffffffffffffffffffffffffffffffffff \
    --emask 0x1ff...ff2ff...fff
```
