// Copyright (c) 2024, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// Regression test for https://github.com/dart-lang/sdk/issues/54486.
// Verifies that VM doesn't crash with an assertion failure in debug mode when
// generating a LoadIndexed instruction with a too-large constant index.

// Trimmed down a program generated by the Dart Project Fuzz Tester (1.101):
//   dart dartfuzz.dart --seed 1258834069 --no-fp --no-ffi --flat

import 'dart:typed_data';

import 'package:expect/expect.dart';

Int32x4List array = Int32x4List(22);

void foo0() => print(array[-(-33 >>> 8)]);
void foo1() => array[49] ^= Int32x4.bool(false, false, false, true);

main() {
  Expect.throws(foo0);
  Expect.throws(foo1);
}
