// Copyright (c) 2025, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// Verify that parameter type check can be removed using exact type
// even if call is not inferred as unchecked.

import 'package:vm/testing/il_matchers.dart';

class StackImpl {
  List<Object?> array = new List<Object?>.filled(8, null);
  int arrayLength;
  StackImpl(this.arrayLength);

  @override
  @pragma('vm:never-inline')
  @pragma('vm:testing:print-flow-graph')
  void push(Object value) {
    array[arrayLength++] = value;
    if (array.length == arrayLength) {
      _grow();
    }
  }

  @override
  @pragma('vm:never-inline')
  Object? pop() {
    final Object? value = array[--arrayLength];
    array[arrayLength] = null;
    return value;
  }

  @pragma('vm:never-inline')
  void _grow() {
    final int length = array.length;
    final List<Object?> newArray = new List<Object?>.filled(length * 2, null);
    newArray.setRange(0, length, array, 0);
    array = newArray;
  }
}

void matchIL$StackImpl$push(FlowGraph graph) {
  graph.match([
    match.block('Graph'),
    match.block('Function', [
      'this' << match.Parameter(index: 0),
      'value' << match.Parameter(index: 1),
      'array' << match.LoadField('this', slot: 'array'),
      'arrayLength' << match.LoadField('this', slot: 'arrayLength'),
      'arrayLength+1' << match.BinaryInt64Op('arrayLength', match.any),
      match.StoreField('this', 'arrayLength+1', slot: 'arrayLength'),
      // No AssertAssignable between these instructions.
      'length' <<
          match.LoadField(
            'array',
            slot: 'Array.length',
            skipUntilMatched: false,
          ),
      if (is32BitConfiguration) ...[
        'boxed_arrayLength' << match.BoxInt64('arrayLength'),
        match.GenericCheckBound('length', 'boxed_arrayLength'),
        match.StoreIndexed('array', 'boxed_arrayLength', 'value'),
      ] else ...[
        'unboxed_length' << match.UnboxInt64('length'),
        match.GenericCheckBound('unboxed_length', 'arrayLength'),
        match.StoreIndexed('array', 'arrayLength', 'value'),
      ],
      match.Branch(match.EqualityCompare(match.any, match.any, kind: '==')),
    ]),
  ]);
}

void main(List<String> args) {
  spoilAnalysis();
  int y = 0;
  for (String x in args) {
    y++;
  }
  var x = new StackImpl(y);
  for (int i = 0; i < 10; i++) {
    x.push(args);
    if (!identical(x.pop(), args)) throw ":(";
  }
}

void spoilAnalysis() {
  // Spoil type flow analysis of 'List.[]=' calls by
  // providing large number of different parameter types
  // (each constant is represented as a separate type).
  var l = new List<Object?>.filled(2, null);
  l[0] = 1;
  l[0] = 2;
  l[0] = 3;
  l[0] = 4;
  l[0] = 5;
  l[0] = 6;
  l[0] = 7;
  l[0] = 8;
  l[0] = 9;
  l[0] = 10;
  l[0] = 11;
  l[0] = 12;
  l[0] = 13;
  l[0] = 14;
  l[0] = 15;
  l[0] = 16;
  l[0] = 17;
  l[0] = 18;
  l[0] = 19;
  l[0] = 20;
  l[0] = 21;
  l[0] = 22;
  l[0] = 23;
  l[0] = 24;
  l[0] = 25;
  l[0] = 26;
  l[0] = 27;
  l[0] = 28;
  l[0] = 29;
  l[0] = 30;
  l[0] = 31;
  l[0] = 32;
  l[0] = 33;
  l[0] = 34;
  l[0] = 35;
  l[0] = 36;
  l[0] = 37;
  l[0] = 38;
  l[0] = 39;
  l[0] = 40;
  l[0] = 41;
  l[0] = 42;
  l[0] = 43;
  l[0] = 44;
  l[0] = 45;
  l[0] = 46;
  l[0] = 47;
  l[0] = 48;
  l[0] = 49;
  l[0] = 50;
  l[0] = 51;
  l[0] = 52;
  l[0] = 53;
  l[0] = 54;
  l[0] = 55;
  l[0] = 56;
  l[0] = 57;
  l[0] = 58;
  l[0] = 59;
  l[0] = 60;
  l[0] = 61;
  l[0] = 62;
  l[0] = 63;
  l[0] = 64;
  l[0] = 65;
  l[0] = 66;
  l[0] = 67;
  l[0] = 68;
  l[0] = 69;
  l[0] = 70;
  l[0] = 71;
  l[0] = 72;
  l[0] = 73;
  l[0] = 74;
  l[0] = 75;
  l[0] = 76;
  l[0] = 77;
  l[0] = 78;
  l[0] = 79;
  l[0] = 80;
  l[0] = 81;
  l[0] = 82;
  l[0] = 83;
  l[0] = 84;
  l[0] = 85;
  l[0] = 86;
  l[0] = 87;
  l[0] = 88;
  l[0] = 89;
  l[0] = 90;
  l[0] = 91;
  l[0] = 92;
  l[0] = 93;
  l[0] = 94;
  l[0] = 95;
  l[0] = 96;
  l[0] = 97;
  l[0] = 98;
  l[0] = 99;
  l[0] = 100;
  l[0] = 101;
  l[0] = 102;
  l[0] = 103;
  l[0] = 104;
  l[0] = 105;
  l[0] = 106;
  l[0] = 107;
  l[0] = 108;
  l[0] = 109;
  l[0] = 110;
  l[0] = 111;
  l[0] = 112;
  l[0] = 113;
  l[0] = 114;
  l[0] = 115;
  l[0] = 116;
  l[0] = 117;
  l[0] = 118;
  l[0] = 119;
  l[0] = 120;
  l[0] = 121;
  l[0] = 122;
  l[0] = 123;
  l[0] = 124;
  l[0] = 125;
  l[0] = 126;
  l[0] = 127;
  l[0] = 128;
  l[0] = 129;
  l[0] = 130;
  l[0] = 131;
  l[0] = 132;
  l[0] = 133;
  l[0] = 134;
  l[0] = 135;
  l[0] = 136;
  l[0] = 137;
  l[0] = 138;
  l[0] = 139;
  l[0] = 140;
  l[0] = 141;
  l[0] = 142;
  l[0] = 143;
  l[0] = 144;
  l[0] = 145;
  l[0] = 146;
  l[0] = 147;
  l[0] = 148;
  l[0] = 149;
  l[0] = 150;
  l[0] = 151;
  l[0] = 152;
  l[0] = 153;
  l[0] = 154;
  l[0] = 155;
  l[0] = 156;
  l[0] = 157;
  l[0] = 158;
  l[0] = 159;
  l[0] = 160;
  l[0] = 161;
  l[0] = 162;
  l[0] = 163;
  l[0] = 164;
  l[0] = 165;
  l[0] = 166;
  l[0] = 167;
  l[0] = 168;
  l[0] = 169;
  l[0] = 170;
  l[0] = 171;
  l[0] = 172;
  l[0] = 173;
  l[0] = 174;
  l[0] = 175;
  l[0] = 176;
  l[0] = 177;
  l[0] = 178;
  l[0] = 179;
  l[0] = 180;
  l[0] = 181;
  l[0] = 182;
  l[0] = 183;
  l[0] = 184;
  l[0] = 185;
  l[0] = 186;
  l[0] = 187;
  l[0] = 188;
  l[0] = 189;
  l[0] = 190;
  l[0] = 191;
  l[0] = 192;
  l[0] = 193;
  l[0] = 194;
  l[0] = 195;
  l[0] = 196;
  l[0] = 197;
  l[0] = 198;
  l[0] = 199;
  l[0] = 200;
  l[0] = 201;
  l[0] = 202;
  l[0] = 203;
  l[0] = 204;
  l[0] = 205;
  l[0] = 206;
  l[0] = 207;
  l[0] = 208;
  l[0] = 209;
  l[0] = 210;
  l[0] = 211;
  l[0] = 212;
  l[0] = 213;
  l[0] = 214;
  l[0] = 215;
  l[0] = 216;
  l[0] = 217;
  l[0] = 218;
  l[0] = 219;
  l[0] = 220;
  l[0] = 221;
  l[0] = 222;
  l[0] = 223;
  l[0] = 224;
  l[0] = 225;
  l[0] = 226;
  l[0] = 227;
  l[0] = 228;
  l[0] = 229;
  l[0] = 230;
  l[0] = 231;
  l[0] = 232;
  l[0] = 233;
  l[0] = 234;
  l[0] = 235;
  l[0] = 236;
  l[0] = 237;
  l[0] = 238;
  l[0] = 239;
  l[0] = 240;
  l[0] = 241;
  l[0] = 242;
  l[0] = 243;
  l[0] = 244;
  l[0] = 245;
  l[0] = 246;
  l[0] = 247;
  l[0] = 248;
  l[0] = 249;
  l[0] = 250;
  l[0] = 251;
  l[0] = 252;
  l[0] = 253;
  l[0] = 254;
  l[0] = 255;
  l[0] = 256;
  l[0] = 257;
  l[0] = 258;
  l[0] = 259;
  l[0] = 260;
  l[0] = 261;
  l[0] = 262;
  l[0] = 263;
  l[0] = 264;
  l[0] = 265;
  l[0] = 266;
  l[0] = 267;
  l[0] = 268;
  l[0] = 269;
  l[0] = 270;
  l[0] = 271;
  l[0] = 272;
  l[0] = 273;
  l[0] = 274;
  l[0] = 275;
  l[0] = 276;
  l[0] = 277;
  l[0] = 278;
  l[0] = 279;
  l[0] = 280;
  l[0] = 281;
  l[0] = 282;
  l[0] = 283;
  l[0] = 284;
  l[0] = 285;
  l[0] = 286;
  l[0] = 287;
  l[0] = 288;
  l[0] = 289;
  l[0] = 290;
  l[0] = 291;
  l[0] = 292;
  l[0] = 293;
  l[0] = 294;
  l[0] = 295;
  l[0] = 296;
  l[0] = 297;
  l[0] = 298;
  l[0] = 299;
  l[0] = 300;
  l[0] = 301;
  l[0] = 302;
  l[0] = 303;
  l[0] = 304;
  l[0] = 305;
  l[0] = 306;
  l[0] = 307;
  l[0] = 308;
  l[0] = 309;
  l[0] = 310;
  l[0] = 311;
  l[0] = 312;
  l[0] = 313;
  l[0] = 314;
  l[0] = 315;
  l[0] = 316;
  l[0] = 317;
  l[0] = 318;
  l[0] = 319;
  l[0] = 320;
  l[0] = 321;
  l[0] = 322;
  l[0] = 323;
  l[0] = 324;
  l[0] = 325;
  l[0] = 326;
  l[0] = 327;
  l[0] = 328;
  l[0] = 329;
  l[0] = 330;
  l[0] = 331;
  l[0] = 332;
  l[0] = 333;
  l[0] = 334;
  l[0] = 335;
  l[0] = 336;
  l[0] = 337;
  l[0] = 338;
  l[0] = 339;
  l[0] = 340;
  l[0] = 341;
  l[0] = 342;
  l[0] = 343;
  l[0] = 344;
  l[0] = 345;
  l[0] = 346;
  l[0] = 347;
  l[0] = 348;
  l[0] = 349;
  l[0] = 350;
  l[0] = 351;
  l[0] = 352;
  l[0] = 353;
  l[0] = 354;
  l[0] = 355;
  l[0] = 356;
  l[0] = 357;
  l[0] = 358;
  l[0] = 359;
  l[0] = 360;
  l[0] = 361;
  l[0] = 362;
  l[0] = 363;
  l[0] = 364;
  l[0] = 365;
  l[0] = 366;
  l[0] = 367;
  l[0] = 368;
  l[0] = 369;
  l[0] = 370;
  l[0] = 371;
  l[0] = 372;
  l[0] = 373;
  l[0] = 374;
  l[0] = 375;
  l[0] = 376;
  l[0] = 377;
  l[0] = 378;
  l[0] = 379;
  l[0] = 380;
  l[0] = 381;
  l[0] = 382;
  l[0] = 383;
  l[0] = 384;
  l[0] = 385;
  l[0] = 386;
  l[0] = 387;
  l[0] = 388;
  l[0] = 389;
  l[0] = 390;
  l[0] = 391;
  l[0] = 392;
  l[0] = 393;
  l[0] = 394;
  l[0] = 395;
  l[0] = 396;
  l[0] = 397;
  l[0] = 398;
  l[0] = 399;
  l[0] = 400;
  l[0] = 401;
  l[0] = 402;
  l[0] = 403;
  l[0] = 404;
  l[0] = 405;
  l[0] = 406;
  l[0] = 407;
  l[0] = 408;
  l[0] = 409;
  l[0] = 410;
  l[0] = 411;
  l[0] = 412;
  l[0] = 413;
  l[0] = 414;
  l[0] = 415;
  l[0] = 416;
  l[0] = 417;
  l[0] = 418;
  l[0] = 419;
  l[0] = 420;
  l[0] = 421;
  l[0] = 422;
  l[0] = 423;
  l[0] = 424;
  l[0] = 425;
  l[0] = 426;
  l[0] = 427;
  l[0] = 428;
  l[0] = 429;
  l[0] = 430;
  l[0] = 431;
  l[0] = 432;
  l[0] = 433;
  l[0] = 434;
  l[0] = 435;
  l[0] = 436;
  l[0] = 437;
  l[0] = 438;
  l[0] = 439;
  l[0] = 440;
  l[0] = 441;
  l[0] = 442;
  l[0] = 443;
  l[0] = 444;
  l[0] = 445;
  l[0] = 446;
  l[0] = 447;
  l[0] = 448;
  l[0] = 449;
  l[0] = 450;
  l[0] = 451;
  l[0] = 452;
  l[0] = 453;
  l[0] = 454;
  l[0] = 455;
  l[0] = 456;
  l[0] = 457;
  l[0] = 458;
  l[0] = 459;
  l[0] = 460;
  l[0] = 461;
  l[0] = 462;
  l[0] = 463;
  l[0] = 464;
  l[0] = 465;
  l[0] = 466;
  l[0] = 467;
  l[0] = 468;
  l[0] = 469;
  l[0] = 470;
  l[0] = 471;
  l[0] = 472;
  l[0] = 473;
  l[0] = 474;
  l[0] = 475;
  l[0] = 476;
  l[0] = 477;
  l[0] = 478;
  l[0] = 479;
  l[0] = 480;
  l[0] = 481;
  l[0] = 482;
  l[0] = 483;
  l[0] = 484;
  l[0] = 485;
  l[0] = 486;
  l[0] = 487;
  l[0] = 488;
  l[0] = 489;
  l[0] = 490;
  l[0] = 491;
  l[0] = 492;
  l[0] = 493;
  l[0] = 494;
  l[0] = 495;
  l[0] = 496;
  l[0] = 497;
  l[0] = 498;
  l[0] = 499;
  l[0] = 500;
  l[0] = 501;
  l[0] = 502;
  l[0] = 503;
  l[0] = 504;
  l[0] = 505;
  l[0] = 506;
  l[0] = 507;
  l[0] = 508;
  l[0] = 509;
  l[0] = 510;
  l[0] = 511;
  l[0] = 512;
  l[0] = 513;
  l[0] = 514;
  l[0] = 515;
  l[0] = 516;
  l[0] = 517;
  l[0] = 518;
  l[0] = 519;
  l[0] = 520;
  l[0] = 521;
  l[0] = 522;
  l[0] = 523;
  l[0] = 524;
  l[0] = 525;
  l[0] = 526;
  l[0] = 527;
  l[0] = 528;
  l[0] = 529;
  l[0] = 530;
  l[0] = 531;
  l[0] = 532;
  l[0] = 533;
  l[0] = 534;
  l[0] = 535;
  l[0] = 536;
  l[0] = 537;
  l[0] = 538;
  l[0] = 539;
  l[0] = 540;
  l[0] = 541;
  l[0] = 542;
  l[0] = 543;
  l[0] = 544;
  l[0] = 545;
  l[0] = 546;
  l[0] = 547;
  l[0] = 548;
  l[0] = 549;
  l[0] = 550;
  l[0] = 551;
  l[0] = 552;
  l[0] = 553;
  l[0] = 554;
  l[0] = 555;
  l[0] = 556;
  l[0] = 557;
  l[0] = 558;
  l[0] = 559;
  l[0] = 560;
  l[0] = 561;
  l[0] = 562;
  l[0] = 563;
  l[0] = 564;
  l[0] = 565;
  l[0] = 566;
  l[0] = 567;
  l[0] = 568;
  l[0] = 569;
  l[0] = 570;
  l[0] = 571;
  l[0] = 572;
  l[0] = 573;
  l[0] = 574;
  l[0] = 575;
  l[0] = 576;
  l[0] = 577;
  l[0] = 578;
  l[0] = 579;
  l[0] = 580;
  l[0] = 581;
  l[0] = 582;
  l[0] = 583;
  l[0] = 584;
  l[0] = 585;
  l[0] = 586;
  l[0] = 587;
  l[0] = 588;
  l[0] = 589;
  l[0] = 590;
  l[0] = 591;
  l[0] = 592;
  l[0] = 593;
  l[0] = 594;
  l[0] = 595;
  l[0] = 596;
  l[0] = 597;
  l[0] = 598;
  l[0] = 599;
  l[0] = 600;
  l[0] = 601;
  l[0] = 602;
  l[0] = 603;
  l[0] = 604;
  l[0] = 605;
  l[0] = 606;
  l[0] = 607;
  l[0] = 608;
  l[0] = 609;
  l[0] = 610;
  l[0] = 611;
  l[0] = 612;
  l[0] = 613;
  l[0] = 614;
  l[0] = 615;
  l[0] = 616;
  l[0] = 617;
  l[0] = 618;
  l[0] = 619;
  l[0] = 620;
  l[0] = 621;
  l[0] = 622;
  l[0] = 623;
  l[0] = 624;
  l[0] = 625;
  l[0] = 626;
  l[0] = 627;
  l[0] = 628;
  l[0] = 629;
  l[0] = 630;
  l[0] = 631;
  l[0] = 632;
  l[0] = 633;
  l[0] = 634;
  l[0] = 635;
  l[0] = 636;
  l[0] = 637;
  l[0] = 638;
  l[0] = 639;
  l[0] = 640;
  l[0] = 641;
  l[0] = 642;
  l[0] = 643;
  l[0] = 644;
  l[0] = 645;
  l[0] = 646;
  l[0] = 647;
  l[0] = 648;
  l[0] = 649;
  l[0] = 650;
  l[0] = 651;
  l[0] = 652;
  l[0] = 653;
  l[0] = 654;
  l[0] = 655;
  l[0] = 656;
  l[0] = 657;
  l[0] = 658;
  l[0] = 659;
  l[0] = 660;
  l[0] = 661;
  l[0] = 662;
  l[0] = 663;
  l[0] = 664;
  l[0] = 665;
  l[0] = 666;
  l[0] = 667;
  l[0] = 668;
  l[0] = 669;
  l[0] = 670;
  l[0] = 671;
  l[0] = 672;
  l[0] = 673;
  l[0] = 674;
  l[0] = 675;
  l[0] = 676;
  l[0] = 677;
  l[0] = 678;
  l[0] = 679;
  l[0] = 680;
  l[0] = 681;
  l[0] = 682;
  l[0] = 683;
  l[0] = 684;
  l[0] = 685;
  l[0] = 686;
  l[0] = 687;
  l[0] = 688;
  l[0] = 689;
  l[0] = 690;
  l[0] = 691;
  l[0] = 692;
  l[0] = 693;
  l[0] = 694;
  l[0] = 695;
  l[0] = 696;
  l[0] = 697;
  l[0] = 698;
  l[0] = 699;
  l[0] = 700;
  l[0] = 701;
  l[0] = 702;
  l[0] = 703;
  l[0] = 704;
  l[0] = 705;
  l[0] = 706;
  l[0] = 707;
  l[0] = 708;
  l[0] = 709;
  l[0] = 710;
  l[0] = 711;
  l[0] = 712;
  l[0] = 713;
  l[0] = 714;
  l[0] = 715;
  l[0] = 716;
  l[0] = 717;
  l[0] = 718;
  l[0] = 719;
  l[0] = 720;
  l[0] = 721;
  l[0] = 722;
  l[0] = 723;
  l[0] = 724;
  l[0] = 725;
  l[0] = 726;
  l[0] = 727;
  l[0] = 728;
  l[0] = 729;
  l[0] = 730;
  l[0] = 731;
  l[0] = 732;
  l[0] = 733;
  l[0] = 734;
  l[0] = 735;
  l[0] = 736;
  l[0] = 737;
  l[0] = 738;
  l[0] = 739;
  l[0] = 740;
  l[0] = 741;
  l[0] = 742;
  l[0] = 743;
  l[0] = 744;
  l[0] = 745;
  l[0] = 746;
  l[0] = 747;
  l[0] = 748;
  l[0] = 749;
  l[0] = 750;
  l[0] = 751;
  l[0] = 752;
  l[0] = 753;
  l[0] = 754;
  l[0] = 755;
  l[0] = 756;
  l[0] = 757;
  l[0] = 758;
  l[0] = 759;
  l[0] = 760;
  l[0] = 761;
  l[0] = 762;
  l[0] = 763;
  l[0] = 764;
  l[0] = 765;
  l[0] = 766;
  l[0] = 767;
  l[0] = 768;
  l[0] = 769;
  l[0] = 770;
  l[0] = 771;
  l[0] = 772;
  l[0] = 773;
  l[0] = 774;
  l[0] = 775;
  l[0] = 776;
  l[0] = 777;
  l[0] = 778;
  l[0] = 779;
  l[0] = 780;
  l[0] = 781;
  l[0] = 782;
  l[0] = 783;
  l[0] = 784;
  l[0] = 785;
  l[0] = 786;
  l[0] = 787;
  l[0] = 788;
  l[0] = 789;
  l[0] = 790;
  l[0] = 791;
  l[0] = 792;
  l[0] = 793;
  l[0] = 794;
  l[0] = 795;
  l[0] = 796;
  l[0] = 797;
  l[0] = 798;
  l[0] = 799;
  l[0] = 800;
  l[0] = 801;
  l[0] = 802;
  l[0] = 803;
  l[0] = 804;
  l[0] = 805;
  l[0] = 806;
  l[0] = 807;
  l[0] = 808;
  l[0] = 809;
  l[0] = 810;
  l[0] = 811;
  l[0] = 812;
  l[0] = 813;
  l[0] = 814;
  l[0] = 815;
  l[0] = 816;
  l[0] = 817;
  l[0] = 818;
  l[0] = 819;
  l[0] = 820;
  l[0] = 821;
  l[0] = 822;
  l[0] = 823;
  l[0] = 824;
  l[0] = 825;
  l[0] = 826;
  l[0] = 827;
  l[0] = 828;
  l[0] = 829;
  l[0] = 830;
  l[0] = 831;
  l[0] = 832;
  l[0] = 833;
  l[0] = 834;
  l[0] = 835;
  l[0] = 836;
  l[0] = 837;
  l[0] = 838;
  l[0] = 839;
  l[0] = 840;
  l[0] = 841;
  l[0] = 842;
  l[0] = 843;
  l[0] = 844;
  l[0] = 845;
  l[0] = 846;
  l[0] = 847;
  l[0] = 848;
  l[0] = 849;
  l[0] = 850;
  l[0] = 851;
  l[0] = 852;
  l[0] = 853;
  l[0] = 854;
  l[0] = 855;
  l[0] = 856;
  l[0] = 857;
  l[0] = 858;
  l[0] = 859;
  l[0] = 860;
  l[0] = 861;
  l[0] = 862;
  l[0] = 863;
  l[0] = 864;
  l[0] = 865;
  l[0] = 866;
  l[0] = 867;
  l[0] = 868;
  l[0] = 869;
  l[0] = 870;
  l[0] = 871;
  l[0] = 872;
  l[0] = 873;
  l[0] = 874;
  l[0] = 875;
  l[0] = 876;
  l[0] = 877;
  l[0] = 878;
  l[0] = 879;
  l[0] = 880;
  l[0] = 881;
  l[0] = 882;
  l[0] = 883;
  l[0] = 884;
  l[0] = 885;
  l[0] = 886;
  l[0] = 887;
  l[0] = 888;
  l[0] = 889;
  l[0] = 890;
  l[0] = 891;
  l[0] = 892;
  l[0] = 893;
  l[0] = 894;
  l[0] = 895;
  l[0] = 896;
  l[0] = 897;
  l[0] = 898;
  l[0] = 899;
  l[0] = 900;
  l[0] = 901;
  l[0] = 902;
  l[0] = 903;
  l[0] = 904;
  l[0] = 905;
  l[0] = 906;
  l[0] = 907;
  l[0] = 908;
  l[0] = 909;
  l[0] = 910;
  l[0] = 911;
  l[0] = 912;
  l[0] = 913;
  l[0] = 914;
  l[0] = 915;
  l[0] = 916;
  l[0] = 917;
  l[0] = 918;
  l[0] = 919;
  l[0] = 920;
  l[0] = 921;
  l[0] = 922;
  l[0] = 923;
  l[0] = 924;
  l[0] = 925;
  l[0] = 926;
  l[0] = 927;
  l[0] = 928;
  l[0] = 929;
  l[0] = 930;
  l[0] = 931;
  l[0] = 932;
  l[0] = 933;
  l[0] = 934;
  l[0] = 935;
  l[0] = 936;
  l[0] = 937;
  l[0] = 938;
  l[0] = 939;
  l[0] = 940;
  l[0] = 941;
  l[0] = 942;
  l[0] = 943;
  l[0] = 944;
  l[0] = 945;
  l[0] = 946;
  l[0] = 947;
  l[0] = 948;
  l[0] = 949;
  l[0] = 950;
  l[0] = 951;
  l[0] = 952;
  l[0] = 953;
  l[0] = 954;
  l[0] = 955;
  l[0] = 956;
  l[0] = 957;
  l[0] = 958;
  l[0] = 959;
  l[0] = 960;
  l[0] = 961;
  l[0] = 962;
  l[0] = 963;
  l[0] = 964;
  l[0] = 965;
  l[0] = 966;
  l[0] = 967;
  l[0] = 968;
  l[0] = 969;
  l[0] = 970;
  l[0] = 971;
  l[0] = 972;
  l[0] = 973;
  l[0] = 974;
  l[0] = 975;
  l[0] = 976;
  l[0] = 977;
  l[0] = 978;
  l[0] = 979;
  l[0] = 980;
  l[0] = 981;
  l[0] = 982;
  l[0] = 983;
  l[0] = 984;
  l[0] = 985;
  l[0] = 986;
  l[0] = 987;
  l[0] = 988;
  l[0] = 989;
  l[0] = 990;
  l[0] = 991;
  l[0] = 992;
  l[0] = 993;
  l[0] = 994;
  l[0] = 995;
  l[0] = 996;
  l[0] = 997;
  l[0] = 998;
  l[0] = 999;
  l[0] = 1000;
}
