// Copyright (c) 2025, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// DO NOT EDIT. This file is generated by runtime/tools/generate_dart_api_win_c.dart.

#include <windows.h>

#include <include/dart_api.h>
#include <include/dart_native_api.h>

typedef bool (*Dart_IsErrorType)(Dart_Handle);
typedef bool (*Dart_IsApiErrorType)(Dart_Handle);
typedef bool (*Dart_IsUnhandledExceptionErrorType)(Dart_Handle);
typedef bool (*Dart_IsCompilationErrorType)(Dart_Handle);
typedef bool (*Dart_IsFatalErrorType)(Dart_Handle);
typedef const char* (*Dart_GetErrorType)(Dart_Handle);
typedef bool (*Dart_ErrorHasExceptionType)(Dart_Handle);
typedef Dart_Handle (*Dart_ErrorGetExceptionType)(Dart_Handle);
typedef Dart_Handle (*Dart_ErrorGetStackTraceType)(Dart_Handle);
typedef Dart_Handle (*Dart_NewApiErrorType)(const char*);
typedef Dart_Handle (*Dart_NewCompilationErrorType)(const char*);
typedef Dart_Handle (*Dart_NewUnhandledExceptionErrorType)(Dart_Handle);
typedef void (*Dart_PropagateErrorType)(Dart_Handle);
typedef Dart_Handle (*Dart_ToStringType)(Dart_Handle);
typedef bool (*Dart_IdentityEqualsType)(Dart_Handle, Dart_Handle);
typedef Dart_Handle (*Dart_HandleFromPersistentType)(Dart_PersistentHandle);
typedef Dart_Handle (*Dart_HandleFromWeakPersistentType)(
    Dart_WeakPersistentHandle);
typedef Dart_PersistentHandle (*Dart_NewPersistentHandleType)(Dart_Handle);
typedef void (*Dart_SetPersistentHandleType)(Dart_PersistentHandle,
                                             Dart_Handle);
typedef void (*Dart_DeletePersistentHandleType)(Dart_PersistentHandle);
typedef Dart_WeakPersistentHandle (*Dart_NewWeakPersistentHandleType)(
    Dart_Handle,
    void*,
    intptr_t,
    Dart_HandleFinalizer);
typedef void (*Dart_DeleteWeakPersistentHandleType)(Dart_WeakPersistentHandle);
typedef Dart_FinalizableHandle (*Dart_NewFinalizableHandleType)(
    Dart_Handle,
    void*,
    intptr_t,
    Dart_HandleFinalizer);
typedef void (*Dart_DeleteFinalizableHandleType)(Dart_FinalizableHandle,
                                                 Dart_Handle);
typedef const char* (*Dart_VersionStringType)();
typedef void (*Dart_IsolateFlagsInitializeType)(Dart_IsolateFlags*);
typedef char* (*Dart_InitializeType)(Dart_InitializeParams*);
typedef char* (*Dart_CleanupType)();
typedef char* (*Dart_SetVMFlagsType)(int, const char**);
typedef bool (*Dart_IsVMFlagSetType)(const char*);
typedef Dart_Isolate (*Dart_CreateIsolateGroupType)(const char*,
                                                    const char*,
                                                    const uint8_t*,
                                                    const uint8_t*,
                                                    Dart_IsolateFlags*,
                                                    void*,
                                                    void*,
                                                    char**);
typedef Dart_Isolate (*Dart_CreateIsolateInGroupType)(
    Dart_Isolate,
    const char*,
    Dart_IsolateShutdownCallback,
    Dart_IsolateCleanupCallback,
    void*,
    char**);
typedef Dart_Isolate (*Dart_CreateIsolateGroupFromKernelType)(
    const char*,
    const char*,
    const uint8_t*,
    intptr_t,
    Dart_IsolateFlags*,
    void*,
    void*,
    char**);
typedef void (*Dart_ShutdownIsolateType)();
typedef Dart_Isolate (*Dart_CurrentIsolateType)();
typedef void* (*Dart_CurrentIsolateDataType)();
typedef void* (*Dart_IsolateDataType)(Dart_Isolate);
typedef Dart_IsolateGroup (*Dart_CurrentIsolateGroupType)();
typedef void* (*Dart_CurrentIsolateGroupDataType)();
typedef Dart_IsolateGroupId (*Dart_CurrentIsolateGroupIdType)();
typedef void* (*Dart_IsolateGroupDataType)(Dart_Isolate);
typedef Dart_Handle (*Dart_DebugNameType)();
typedef const char* (*Dart_DebugNameToCStringType)();
typedef const char* (*Dart_IsolateServiceIdType)(Dart_Isolate);
typedef void (*Dart_EnterIsolateType)(Dart_Isolate);
typedef void (*Dart_KillIsolateType)(Dart_Isolate);
typedef void (*Dart_NotifyIdleType)(int64_t);
typedef void (*Dart_EnableHeapSamplingType)();
typedef void (*Dart_DisableHeapSamplingType)();
typedef void (*Dart_RegisterHeapSamplingCallbackType)(
    Dart_HeapSamplingCreateCallback,
    Dart_HeapSamplingDeleteCallback);
typedef void (*Dart_ReportSurvivingAllocationsType)(
    Dart_HeapSamplingReportCallback,
    void*,
    bool);
typedef void (*Dart_SetHeapSamplingPeriodType)(intptr_t);
typedef void (*Dart_NotifyDestroyedType)();
typedef void (*Dart_NotifyLowMemoryType)();
typedef Dart_PerformanceMode (*Dart_SetPerformanceModeType)(
    Dart_PerformanceMode);
typedef void (*Dart_StartProfilingType)();
typedef void (*Dart_StopProfilingType)();
typedef void (*Dart_ThreadDisableProfilingType)();
typedef void (*Dart_ThreadEnableProfilingType)();
typedef void (*Dart_AddSymbolsType)(const char*, void*, intptr_t);
typedef void (*Dart_ExitIsolateType)();
typedef Dart_Handle (
    *Dart_CreateSnapshotType)(uint8_t**, intptr_t*, uint8_t**, intptr_t*, bool);
typedef bool (*Dart_IsKernelType)(const uint8_t*, intptr_t);
typedef bool (*Dart_IsBytecodeType)(const uint8_t*, intptr_t);
typedef char* (*Dart_IsolateMakeRunnableType)(Dart_Isolate);
typedef void (*Dart_SetMessageNotifyCallbackType)(Dart_MessageNotifyCallback);
typedef Dart_MessageNotifyCallback (*Dart_GetMessageNotifyCallbackType)();
typedef bool (*Dart_ShouldPauseOnStartType)();
typedef void (*Dart_SetShouldPauseOnStartType)(bool);
typedef bool (*Dart_IsPausedOnStartType)();
typedef void (*Dart_SetPausedOnStartType)(bool);
typedef bool (*Dart_ShouldPauseOnExitType)();
typedef void (*Dart_SetShouldPauseOnExitType)(bool);
typedef bool (*Dart_IsPausedOnExitType)();
typedef void (*Dart_SetPausedOnExitType)(bool);
typedef void (*Dart_SetStickyErrorType)(Dart_Handle);
typedef bool (*Dart_HasStickyErrorType)();
typedef Dart_Handle (*Dart_GetStickyErrorType)();
typedef Dart_Handle (*Dart_HandleMessageType)();
typedef bool (*Dart_HandleServiceMessagesType)();
typedef bool (*Dart_HasServiceMessagesType)();
typedef Dart_Handle (*Dart_RunLoopType)();
typedef bool (*Dart_RunLoopAsyncType)(bool, Dart_Port, Dart_Port, char**);
typedef Dart_Port (*Dart_GetMainPortIdType)();
typedef bool (*Dart_HasLivePortsType)();
typedef bool (*Dart_PostType)(Dart_Port, Dart_Handle);
typedef Dart_Handle (*Dart_NewSendPortType)(Dart_Port);
typedef Dart_Handle (*Dart_NewSendPortExType)(Dart_PortEx);
typedef Dart_Handle (*Dart_SendPortGetIdType)(Dart_Handle, Dart_Port*);
typedef Dart_Handle (*Dart_SendPortGetIdExType)(Dart_Handle, Dart_PortEx*);
typedef void (*Dart_SetCurrentThreadOwnsIsolateType)();
typedef bool (*Dart_GetCurrentThreadOwnsIsolateType)(Dart_Port);
typedef void (*Dart_EnterScopeType)();
typedef void (*Dart_ExitScopeType)();
typedef uint8_t* (*Dart_ScopeAllocateType)(intptr_t);
typedef Dart_Handle (*Dart_NullType)();
typedef bool (*Dart_IsNullType)(Dart_Handle);
typedef Dart_Handle (*Dart_EmptyStringType)();
typedef Dart_Handle (*Dart_TypeDynamicType)();
typedef Dart_Handle (*Dart_TypeVoidType)();
typedef Dart_Handle (*Dart_TypeNeverType)();
typedef Dart_Handle (*Dart_TypeStringType)();
typedef Dart_Handle (*Dart_TypeDoubleType)();
typedef Dart_Handle (*Dart_TypeIntType)();
typedef Dart_Handle (*Dart_TypeBooleanType)();
typedef Dart_Handle (*Dart_TypeObjectType)();
typedef Dart_Handle (*Dart_ObjectEqualsType)(Dart_Handle, Dart_Handle, bool*);
typedef Dart_Handle (*Dart_ObjectIsTypeType)(Dart_Handle, Dart_Handle, bool*);
typedef bool (*Dart_IsInstanceType)(Dart_Handle);
typedef bool (*Dart_IsNumberType)(Dart_Handle);
typedef bool (*Dart_IsIntegerType)(Dart_Handle);
typedef bool (*Dart_IsDoubleType)(Dart_Handle);
typedef bool (*Dart_IsBooleanType)(Dart_Handle);
typedef bool (*Dart_IsStringType)(Dart_Handle);
typedef bool (*Dart_IsStringLatin1Type)(Dart_Handle);
typedef bool (*Dart_IsListType)(Dart_Handle);
typedef bool (*Dart_IsMapType)(Dart_Handle);
typedef bool (*Dart_IsLibraryType)(Dart_Handle);
typedef bool (*Dart_IsTypeType)(Dart_Handle);
typedef bool (*Dart_IsFunctionType)(Dart_Handle);
typedef bool (*Dart_IsVariableType)(Dart_Handle);
typedef bool (*Dart_IsTypeVariableType)(Dart_Handle);
typedef bool (*Dart_IsClosureType)(Dart_Handle);
typedef bool (*Dart_IsTypedDataType)(Dart_Handle);
typedef bool (*Dart_IsByteBufferType)(Dart_Handle);
typedef bool (*Dart_IsFutureType)(Dart_Handle);
typedef Dart_Handle (*Dart_InstanceGetTypeType)(Dart_Handle);
typedef Dart_Handle (*Dart_ClassNameType)(Dart_Handle);
typedef Dart_Handle (*Dart_FunctionNameType)(Dart_Handle);
typedef Dart_Handle (*Dart_FunctionOwnerType)(Dart_Handle);
typedef Dart_Handle (*Dart_FunctionIsStaticType)(Dart_Handle, bool*);
typedef bool (*Dart_IsTearOffType)(Dart_Handle);
typedef Dart_Handle (*Dart_ClosureFunctionType)(Dart_Handle);
typedef Dart_Handle (*Dart_ClassLibraryType)(Dart_Handle);
typedef Dart_Handle (*Dart_IntegerFitsIntoInt64Type)(Dart_Handle, bool*);
typedef Dart_Handle (*Dart_IntegerFitsIntoUint64Type)(Dart_Handle, bool*);
typedef Dart_Handle (*Dart_NewIntegerType)(int64_t);
typedef Dart_Handle (*Dart_NewIntegerFromUint64Type)(uint64_t);
typedef Dart_Handle (*Dart_NewIntegerFromHexCStringType)(const char*);
typedef Dart_Handle (*Dart_IntegerToInt64Type)(Dart_Handle, int64_t*);
typedef Dart_Handle (*Dart_IntegerToUint64Type)(Dart_Handle, uint64_t*);
typedef Dart_Handle (*Dart_IntegerToHexCStringType)(Dart_Handle, const char**);
typedef Dart_Handle (*Dart_NewDoubleType)(double);
typedef Dart_Handle (*Dart_DoubleValueType)(Dart_Handle, double*);
typedef Dart_Handle (*Dart_GetStaticMethodClosureType)(Dart_Handle,
                                                       Dart_Handle,
                                                       Dart_Handle);
typedef Dart_Handle (*Dart_TrueType)();
typedef Dart_Handle (*Dart_FalseType)();
typedef Dart_Handle (*Dart_NewBooleanType)(bool);
typedef Dart_Handle (*Dart_BooleanValueType)(Dart_Handle, bool*);
typedef Dart_Handle (*Dart_StringLengthType)(Dart_Handle, intptr_t*);
typedef Dart_Handle (*Dart_StringUTF8LengthType)(Dart_Handle, intptr_t*);
typedef Dart_Handle (*Dart_NewStringFromCStringType)(const char*);
typedef Dart_Handle (*Dart_NewStringFromUTF8Type)(const uint8_t*, intptr_t);
typedef Dart_Handle (*Dart_NewStringFromUTF16Type)(const uint16_t*, intptr_t);
typedef Dart_Handle (*Dart_NewStringFromUTF32Type)(const int32_t*, intptr_t);
typedef Dart_Handle (*Dart_StringToCStringType)(Dart_Handle, const char**);
typedef Dart_Handle (*Dart_StringToUTF8Type)(Dart_Handle, uint8_t**, intptr_t*);
typedef Dart_Handle (*Dart_CopyUTF8EncodingOfStringType)(Dart_Handle,
                                                         uint8_t*,
                                                         intptr_t);
typedef Dart_Handle (*Dart_StringToLatin1Type)(Dart_Handle,
                                               uint8_t*,
                                               intptr_t*);
typedef Dart_Handle (*Dart_StringToUTF16Type)(Dart_Handle,
                                              uint16_t*,
                                              intptr_t*);
typedef Dart_Handle (*Dart_StringStorageSizeType)(Dart_Handle, intptr_t*);
typedef Dart_Handle (*Dart_StringGetPropertiesType)(Dart_Handle,
                                                    intptr_t*,
                                                    intptr_t*,
                                                    void**);
typedef Dart_Handle (*Dart_NewListType)(intptr_t);
typedef Dart_Handle (*Dart_NewListOfTypeType)(Dart_Handle, intptr_t);
typedef Dart_Handle (*Dart_NewListOfTypeFilledType)(Dart_Handle,
                                                    Dart_Handle,
                                                    intptr_t);
typedef Dart_Handle (*Dart_ListLengthType)(Dart_Handle, intptr_t*);
typedef Dart_Handle (*Dart_ListGetAtType)(Dart_Handle, intptr_t);
typedef Dart_Handle (*Dart_ListGetRangeType)(Dart_Handle,
                                             intptr_t,
                                             intptr_t,
                                             Dart_Handle*);
typedef Dart_Handle (*Dart_ListSetAtType)(Dart_Handle, intptr_t, Dart_Handle);
typedef Dart_Handle (*Dart_ListGetAsBytesType)(Dart_Handle,
                                               intptr_t,
                                               uint8_t*,
                                               intptr_t);
typedef Dart_Handle (*Dart_ListSetAsBytesType)(Dart_Handle,
                                               intptr_t,
                                               const uint8_t*,
                                               intptr_t);
typedef Dart_Handle (*Dart_MapGetAtType)(Dart_Handle, Dart_Handle);
typedef Dart_Handle (*Dart_MapContainsKeyType)(Dart_Handle, Dart_Handle);
typedef Dart_Handle (*Dart_MapKeysType)(Dart_Handle);
typedef Dart_Handle (*Dart_NewMapType)(Dart_Handle,
                                       Dart_Handle,
                                       Dart_Handle,
                                       Dart_Handle);
typedef Dart_TypedData_Type (*Dart_GetTypeOfTypedDataType)(Dart_Handle);
typedef Dart_TypedData_Type (*Dart_GetTypeOfExternalTypedDataType)(Dart_Handle);
typedef Dart_Handle (*Dart_NewTypedDataType)(Dart_TypedData_Type, intptr_t);
typedef Dart_Handle (*Dart_NewExternalTypedDataType)(Dart_TypedData_Type,
                                                     void*,
                                                     intptr_t);
typedef Dart_Handle (*Dart_NewExternalTypedDataWithFinalizerType)(
    Dart_TypedData_Type,
    void*,
    intptr_t,
    void*,
    intptr_t,
    Dart_HandleFinalizer);
typedef Dart_Handle (*Dart_NewUnmodifiableExternalTypedDataWithFinalizerType)(
    Dart_TypedData_Type,
    const void*,
    intptr_t,
    void*,
    intptr_t,
    Dart_HandleFinalizer);
typedef Dart_Handle (*Dart_NewByteBufferType)(Dart_Handle);
typedef Dart_Handle (*Dart_TypedDataAcquireDataType)(Dart_Handle,
                                                     Dart_TypedData_Type*,
                                                     void**,
                                                     intptr_t*);
typedef Dart_Handle (*Dart_TypedDataReleaseDataType)(Dart_Handle);
typedef Dart_Handle (*Dart_GetDataFromByteBufferType)(Dart_Handle);
typedef Dart_Handle (*Dart_NewType)(Dart_Handle,
                                    Dart_Handle,
                                    int,
                                    Dart_Handle*);
typedef Dart_Handle (*Dart_AllocateType)(Dart_Handle);
typedef Dart_Handle (*Dart_AllocateWithNativeFieldsType)(Dart_Handle,
                                                         intptr_t,
                                                         const intptr_t*);
typedef Dart_Handle (*Dart_InvokeType)(Dart_Handle,
                                       Dart_Handle,
                                       int,
                                       Dart_Handle*);
typedef Dart_Handle (*Dart_InvokeClosureType)(Dart_Handle, int, Dart_Handle*);
typedef Dart_Handle (*Dart_InvokeConstructorType)(Dart_Handle,
                                                  Dart_Handle,
                                                  int,
                                                  Dart_Handle*);
typedef Dart_Handle (*Dart_GetFieldType)(Dart_Handle, Dart_Handle);
typedef Dart_Handle (*Dart_SetFieldType)(Dart_Handle, Dart_Handle, Dart_Handle);
typedef Dart_Handle (*Dart_ThrowExceptionType)(Dart_Handle);
typedef Dart_Handle (*Dart_ReThrowExceptionType)(Dart_Handle, Dart_Handle);
typedef Dart_Handle (*Dart_GetNativeInstanceFieldCountType)(Dart_Handle, int*);
typedef Dart_Handle (*Dart_GetNativeInstanceFieldType)(Dart_Handle,
                                                       int,
                                                       intptr_t*);
typedef Dart_Handle (*Dart_SetNativeInstanceFieldType)(Dart_Handle,
                                                       int,
                                                       intptr_t);
typedef void* (*Dart_GetNativeIsolateGroupDataType)(Dart_NativeArguments);
typedef Dart_Handle (*Dart_GetNativeArgumentsType)(
    Dart_NativeArguments,
    int,
    const Dart_NativeArgument_Descriptor*,
    Dart_NativeArgument_Value*);
typedef Dart_Handle (*Dart_GetNativeArgumentType)(Dart_NativeArguments, int);
typedef int (*Dart_GetNativeArgumentCountType)(Dart_NativeArguments);
typedef Dart_Handle (*Dart_GetNativeFieldsOfArgumentType)(Dart_NativeArguments,
                                                          int,
                                                          int,
                                                          intptr_t*);
typedef Dart_Handle (*Dart_GetNativeReceiverType)(Dart_NativeArguments,
                                                  intptr_t*);
typedef Dart_Handle (*Dart_GetNativeStringArgumentType)(Dart_NativeArguments,
                                                        int,
                                                        void**);
typedef Dart_Handle (*Dart_GetNativeIntegerArgumentType)(Dart_NativeArguments,
                                                         int,
                                                         int64_t*);
typedef Dart_Handle (*Dart_GetNativeBooleanArgumentType)(Dart_NativeArguments,
                                                         int,
                                                         bool*);
typedef Dart_Handle (*Dart_GetNativeDoubleArgumentType)(Dart_NativeArguments,
                                                        int,
                                                        double*);
typedef void (*Dart_SetReturnValueType)(Dart_NativeArguments, Dart_Handle);
typedef void (*Dart_SetWeakHandleReturnValueType)(Dart_NativeArguments,
                                                  Dart_WeakPersistentHandle);
typedef void (*Dart_SetBooleanReturnValueType)(Dart_NativeArguments, bool);
typedef void (*Dart_SetIntegerReturnValueType)(Dart_NativeArguments, int64_t);
typedef void (*Dart_SetDoubleReturnValueType)(Dart_NativeArguments, double);
typedef Dart_Handle (*Dart_SetEnvironmentCallbackType)(
    Dart_EnvironmentCallback);
typedef Dart_Handle (*Dart_SetNativeResolverType)(Dart_Handle,
                                                  Dart_NativeEntryResolver,
                                                  Dart_NativeEntrySymbol);
typedef Dart_Handle (*Dart_GetNativeResolverType)(Dart_Handle,
                                                  Dart_NativeEntryResolver*);
typedef Dart_Handle (*Dart_GetNativeSymbolType)(Dart_Handle,
                                                Dart_NativeEntrySymbol*);
typedef Dart_Handle (*Dart_SetFfiNativeResolverType)(Dart_Handle,
                                                     Dart_FfiNativeResolver);
typedef void (*Dart_InitializeNativeAssetsResolverType)(NativeAssetsApi*);
typedef Dart_Handle (*Dart_SetLibraryTagHandlerType)(Dart_LibraryTagHandler);
typedef Dart_Handle (*Dart_SetDeferredLoadHandlerType)(
    Dart_DeferredLoadHandler);
typedef Dart_Handle (*Dart_DeferredLoadCompleteType)(intptr_t,
                                                     const uint8_t*,
                                                     const uint8_t*);
typedef Dart_Handle (*Dart_DeferredLoadCompleteErrorType)(intptr_t,
                                                          const char*,
                                                          bool);
typedef Dart_Handle (*Dart_LoadScriptFromKernelType)(const uint8_t*, intptr_t);
typedef Dart_Handle (*Dart_LoadScriptFromBytecodeType)(const uint8_t*,
                                                       intptr_t);
typedef Dart_Handle (*Dart_RootLibraryType)();
typedef Dart_Handle (*Dart_SetRootLibraryType)(Dart_Handle);
typedef Dart_Handle (*Dart_GetTypeType)(Dart_Handle,
                                        Dart_Handle,
                                        intptr_t,
                                        Dart_Handle*);
typedef Dart_Handle (*Dart_GetNullableTypeType)(Dart_Handle,
                                                Dart_Handle,
                                                intptr_t,
                                                Dart_Handle*);
typedef Dart_Handle (*Dart_GetNonNullableTypeType)(Dart_Handle,
                                                   Dart_Handle,
                                                   intptr_t,
                                                   Dart_Handle*);
typedef Dart_Handle (*Dart_TypeToNullableTypeType)(Dart_Handle);
typedef Dart_Handle (*Dart_TypeToNonNullableTypeType)(Dart_Handle);
typedef Dart_Handle (*Dart_IsNullableTypeType)(Dart_Handle, bool*);
typedef Dart_Handle (*Dart_IsNonNullableTypeType)(Dart_Handle, bool*);
typedef Dart_Handle (*Dart_GetClassType)(Dart_Handle, Dart_Handle);
typedef Dart_Handle (*Dart_LibraryUrlType)(Dart_Handle);
typedef Dart_Handle (*Dart_LibraryResolvedUrlType)(Dart_Handle);
typedef Dart_Handle (*Dart_GetLoadedLibrariesType)();
typedef Dart_Handle (*Dart_LookupLibraryType)(Dart_Handle);
typedef Dart_Handle (*Dart_LibraryHandleErrorType)(Dart_Handle, Dart_Handle);
typedef Dart_Handle (*Dart_LoadLibraryFromKernelType)(const uint8_t*, intptr_t);
typedef Dart_Handle (*Dart_LoadLibraryType)(Dart_Handle);
typedef Dart_Handle (*Dart_LoadLibraryFromBytecodeType)(Dart_Handle);
typedef Dart_Handle (*Dart_FinalizeLoadingType)(bool);
typedef Dart_Handle (*Dart_GetPeerType)(Dart_Handle, void**);
typedef Dart_Handle (*Dart_SetPeerType)(Dart_Handle, void*);
typedef bool (*Dart_IsKernelIsolateType)(Dart_Isolate);
typedef bool (*Dart_KernelIsolateIsRunningType)();
typedef Dart_Port (*Dart_KernelPortType)();
typedef Dart_KernelCompilationResult (*Dart_CompileToKernelType)(
    const char*,
    const uint8_t*,
    const intptr_t,
    bool,
    bool,
    bool,
    const char*,
    Dart_KernelCompilationVerbosityLevel);
typedef Dart_KernelCompilationResult (*Dart_KernelListDependenciesType)();
typedef void (*Dart_SetDartLibrarySourcesKernelType)(const uint8_t*,
                                                     const intptr_t);
typedef bool (*Dart_DetectNullSafetyType)(const char*,
                                          const char*,
                                          const char*,
                                          const uint8_t*,
                                          const uint8_t*,
                                          const uint8_t*,
                                          intptr_t);
typedef bool (*Dart_IsServiceIsolateType)(Dart_Isolate);
typedef bool (*Dart_WriteProfileToTimelineType)(Dart_Port, char**);
typedef Dart_Handle (*Dart_PrecompileType)();
typedef Dart_Handle (*Dart_LoadingUnitLibraryUrisType)(intptr_t);
typedef Dart_Handle (*Dart_CreateAppAOTSnapshotAsAssemblyType)(
    Dart_StreamingWriteCallback,
    void*,
    bool,
    void*);
typedef Dart_Handle (*Dart_CreateAppAOTSnapshotAsAssembliesType)(
    Dart_CreateLoadingUnitCallback,
    void*,
    bool,
    Dart_StreamingWriteCallback,
    Dart_StreamingCloseCallback);
typedef Dart_Handle (*Dart_CreateAppAOTSnapshotAsElfType)(
    Dart_StreamingWriteCallback,
    void*,
    bool,
    void*);
typedef Dart_Handle (*Dart_CreateAppAOTSnapshotAsElfsType)(
    Dart_CreateLoadingUnitCallback,
    void*,
    bool,
    Dart_StreamingWriteCallback,
    Dart_StreamingCloseCallback);
typedef Dart_Handle (*Dart_CreateAppAOTSnapshotAsBinaryType)(
    Dart_AotBinaryFormat,
    Dart_StreamingWriteCallback,
    void*,
    bool,
    void*,
    const char*,
    const char*);
typedef Dart_Handle (*Dart_CreateVMAOTSnapshotAsAssemblyType)(
    Dart_StreamingWriteCallback,
    void*);
typedef Dart_Handle (*Dart_SortClassesType)();
typedef Dart_Handle (*Dart_CreateAppJITSnapshotAsBlobsType)(uint8_t**,
                                                            intptr_t*,
                                                            uint8_t**,
                                                            intptr_t*);
typedef Dart_Handle (*Dart_GetObfuscationMapType)(uint8_t**, intptr_t*);
typedef bool (*Dart_IsPrecompiledRuntimeType)();
typedef void (*Dart_DumpNativeStackTraceType)(void*);
typedef void (*Dart_PrepareToAbortType)();
typedef void (*Dart_SetDwarfStackTraceFootnoteCallbackType)(
    Dart_DwarfStackTraceFootnoteCallback);
typedef bool (*Dart_PostCObjectType)(Dart_Port, Dart_CObject*);
typedef bool (*Dart_PostIntegerType)(Dart_Port, int64_t);
typedef Dart_Port (*Dart_NewNativePortType)(const char*,
                                            Dart_NativeMessageHandler,
                                            bool);
typedef Dart_Port (*Dart_NewConcurrentNativePortType)(const char*,
                                                      Dart_NativeMessageHandler,
                                                      intptr_t);
typedef bool (*Dart_CloseNativePortType)(Dart_Port);
typedef Dart_Handle (*Dart_CompileAllType)();
typedef Dart_Handle (*Dart_FinalizeAllClassesType)();
typedef void* (*Dart_ExecuteInternalCommandType)(const char*, void*);

static Dart_IsErrorType Dart_IsErrorFn = NULL;
static Dart_IsApiErrorType Dart_IsApiErrorFn = NULL;
static Dart_IsUnhandledExceptionErrorType Dart_IsUnhandledExceptionErrorFn =
    NULL;
static Dart_IsCompilationErrorType Dart_IsCompilationErrorFn = NULL;
static Dart_IsFatalErrorType Dart_IsFatalErrorFn = NULL;
static Dart_GetErrorType Dart_GetErrorFn = NULL;
static Dart_ErrorHasExceptionType Dart_ErrorHasExceptionFn = NULL;
static Dart_ErrorGetExceptionType Dart_ErrorGetExceptionFn = NULL;
static Dart_ErrorGetStackTraceType Dart_ErrorGetStackTraceFn = NULL;
static Dart_NewApiErrorType Dart_NewApiErrorFn = NULL;
static Dart_NewCompilationErrorType Dart_NewCompilationErrorFn = NULL;
static Dart_NewUnhandledExceptionErrorType Dart_NewUnhandledExceptionErrorFn =
    NULL;
static Dart_PropagateErrorType Dart_PropagateErrorFn = NULL;
static Dart_ToStringType Dart_ToStringFn = NULL;
static Dart_IdentityEqualsType Dart_IdentityEqualsFn = NULL;
static Dart_HandleFromPersistentType Dart_HandleFromPersistentFn = NULL;
static Dart_HandleFromWeakPersistentType Dart_HandleFromWeakPersistentFn = NULL;
static Dart_NewPersistentHandleType Dart_NewPersistentHandleFn = NULL;
static Dart_SetPersistentHandleType Dart_SetPersistentHandleFn = NULL;
static Dart_DeletePersistentHandleType Dart_DeletePersistentHandleFn = NULL;
static Dart_NewWeakPersistentHandleType Dart_NewWeakPersistentHandleFn = NULL;
static Dart_DeleteWeakPersistentHandleType Dart_DeleteWeakPersistentHandleFn =
    NULL;
static Dart_NewFinalizableHandleType Dart_NewFinalizableHandleFn = NULL;
static Dart_DeleteFinalizableHandleType Dart_DeleteFinalizableHandleFn = NULL;
static Dart_VersionStringType Dart_VersionStringFn = NULL;
static Dart_IsolateFlagsInitializeType Dart_IsolateFlagsInitializeFn = NULL;
static Dart_InitializeType Dart_InitializeFn = NULL;
static Dart_CleanupType Dart_CleanupFn = NULL;
static Dart_SetVMFlagsType Dart_SetVMFlagsFn = NULL;
static Dart_IsVMFlagSetType Dart_IsVMFlagSetFn = NULL;
static Dart_CreateIsolateGroupType Dart_CreateIsolateGroupFn = NULL;
static Dart_CreateIsolateInGroupType Dart_CreateIsolateInGroupFn = NULL;
static Dart_CreateIsolateGroupFromKernelType
    Dart_CreateIsolateGroupFromKernelFn = NULL;
static Dart_ShutdownIsolateType Dart_ShutdownIsolateFn = NULL;
static Dart_CurrentIsolateType Dart_CurrentIsolateFn = NULL;
static Dart_CurrentIsolateDataType Dart_CurrentIsolateDataFn = NULL;
static Dart_IsolateDataType Dart_IsolateDataFn = NULL;
static Dart_CurrentIsolateGroupType Dart_CurrentIsolateGroupFn = NULL;
static Dart_CurrentIsolateGroupDataType Dart_CurrentIsolateGroupDataFn = NULL;
static Dart_CurrentIsolateGroupIdType Dart_CurrentIsolateGroupIdFn = NULL;
static Dart_IsolateGroupDataType Dart_IsolateGroupDataFn = NULL;
static Dart_DebugNameType Dart_DebugNameFn = NULL;
static Dart_DebugNameToCStringType Dart_DebugNameToCStringFn = NULL;
static Dart_IsolateServiceIdType Dart_IsolateServiceIdFn = NULL;
static Dart_EnterIsolateType Dart_EnterIsolateFn = NULL;
static Dart_KillIsolateType Dart_KillIsolateFn = NULL;
static Dart_NotifyIdleType Dart_NotifyIdleFn = NULL;
static Dart_EnableHeapSamplingType Dart_EnableHeapSamplingFn = NULL;
static Dart_DisableHeapSamplingType Dart_DisableHeapSamplingFn = NULL;
static Dart_RegisterHeapSamplingCallbackType
    Dart_RegisterHeapSamplingCallbackFn = NULL;
static Dart_ReportSurvivingAllocationsType Dart_ReportSurvivingAllocationsFn =
    NULL;
static Dart_SetHeapSamplingPeriodType Dart_SetHeapSamplingPeriodFn = NULL;
static Dart_NotifyDestroyedType Dart_NotifyDestroyedFn = NULL;
static Dart_NotifyLowMemoryType Dart_NotifyLowMemoryFn = NULL;
static Dart_SetPerformanceModeType Dart_SetPerformanceModeFn = NULL;
static Dart_StartProfilingType Dart_StartProfilingFn = NULL;
static Dart_StopProfilingType Dart_StopProfilingFn = NULL;
static Dart_ThreadDisableProfilingType Dart_ThreadDisableProfilingFn = NULL;
static Dart_ThreadEnableProfilingType Dart_ThreadEnableProfilingFn = NULL;
static Dart_AddSymbolsType Dart_AddSymbolsFn = NULL;
static Dart_ExitIsolateType Dart_ExitIsolateFn = NULL;
static Dart_CreateSnapshotType Dart_CreateSnapshotFn = NULL;
static Dart_IsKernelType Dart_IsKernelFn = NULL;
static Dart_IsBytecodeType Dart_IsBytecodeFn = NULL;
static Dart_IsolateMakeRunnableType Dart_IsolateMakeRunnableFn = NULL;
static Dart_SetMessageNotifyCallbackType Dart_SetMessageNotifyCallbackFn = NULL;
static Dart_GetMessageNotifyCallbackType Dart_GetMessageNotifyCallbackFn = NULL;
static Dart_ShouldPauseOnStartType Dart_ShouldPauseOnStartFn = NULL;
static Dart_SetShouldPauseOnStartType Dart_SetShouldPauseOnStartFn = NULL;
static Dart_IsPausedOnStartType Dart_IsPausedOnStartFn = NULL;
static Dart_SetPausedOnStartType Dart_SetPausedOnStartFn = NULL;
static Dart_ShouldPauseOnExitType Dart_ShouldPauseOnExitFn = NULL;
static Dart_SetShouldPauseOnExitType Dart_SetShouldPauseOnExitFn = NULL;
static Dart_IsPausedOnExitType Dart_IsPausedOnExitFn = NULL;
static Dart_SetPausedOnExitType Dart_SetPausedOnExitFn = NULL;
static Dart_SetStickyErrorType Dart_SetStickyErrorFn = NULL;
static Dart_HasStickyErrorType Dart_HasStickyErrorFn = NULL;
static Dart_GetStickyErrorType Dart_GetStickyErrorFn = NULL;
static Dart_HandleMessageType Dart_HandleMessageFn = NULL;
static Dart_HandleServiceMessagesType Dart_HandleServiceMessagesFn = NULL;
static Dart_HasServiceMessagesType Dart_HasServiceMessagesFn = NULL;
static Dart_RunLoopType Dart_RunLoopFn = NULL;
static Dart_RunLoopAsyncType Dart_RunLoopAsyncFn = NULL;
static Dart_GetMainPortIdType Dart_GetMainPortIdFn = NULL;
static Dart_HasLivePortsType Dart_HasLivePortsFn = NULL;
static Dart_PostType Dart_PostFn = NULL;
static Dart_NewSendPortType Dart_NewSendPortFn = NULL;
static Dart_NewSendPortExType Dart_NewSendPortExFn = NULL;
static Dart_SendPortGetIdType Dart_SendPortGetIdFn = NULL;
static Dart_SendPortGetIdExType Dart_SendPortGetIdExFn = NULL;
static Dart_SetCurrentThreadOwnsIsolateType Dart_SetCurrentThreadOwnsIsolateFn =
    NULL;
static Dart_GetCurrentThreadOwnsIsolateType Dart_GetCurrentThreadOwnsIsolateFn =
    NULL;
static Dart_EnterScopeType Dart_EnterScopeFn = NULL;
static Dart_ExitScopeType Dart_ExitScopeFn = NULL;
static Dart_ScopeAllocateType Dart_ScopeAllocateFn = NULL;
static Dart_NullType Dart_NullFn = NULL;
static Dart_IsNullType Dart_IsNullFn = NULL;
static Dart_EmptyStringType Dart_EmptyStringFn = NULL;
static Dart_TypeDynamicType Dart_TypeDynamicFn = NULL;
static Dart_TypeVoidType Dart_TypeVoidFn = NULL;
static Dart_TypeNeverType Dart_TypeNeverFn = NULL;
static Dart_TypeStringType Dart_TypeStringFn = NULL;
static Dart_TypeDoubleType Dart_TypeDoubleFn = NULL;
static Dart_TypeIntType Dart_TypeIntFn = NULL;
static Dart_TypeBooleanType Dart_TypeBooleanFn = NULL;
static Dart_TypeObjectType Dart_TypeObjectFn = NULL;
static Dart_ObjectEqualsType Dart_ObjectEqualsFn = NULL;
static Dart_ObjectIsTypeType Dart_ObjectIsTypeFn = NULL;
static Dart_IsInstanceType Dart_IsInstanceFn = NULL;
static Dart_IsNumberType Dart_IsNumberFn = NULL;
static Dart_IsIntegerType Dart_IsIntegerFn = NULL;
static Dart_IsDoubleType Dart_IsDoubleFn = NULL;
static Dart_IsBooleanType Dart_IsBooleanFn = NULL;
static Dart_IsStringType Dart_IsStringFn = NULL;
static Dart_IsStringLatin1Type Dart_IsStringLatin1Fn = NULL;
static Dart_IsListType Dart_IsListFn = NULL;
static Dart_IsMapType Dart_IsMapFn = NULL;
static Dart_IsLibraryType Dart_IsLibraryFn = NULL;
static Dart_IsTypeType Dart_IsTypeFn = NULL;
static Dart_IsFunctionType Dart_IsFunctionFn = NULL;
static Dart_IsVariableType Dart_IsVariableFn = NULL;
static Dart_IsTypeVariableType Dart_IsTypeVariableFn = NULL;
static Dart_IsClosureType Dart_IsClosureFn = NULL;
static Dart_IsTypedDataType Dart_IsTypedDataFn = NULL;
static Dart_IsByteBufferType Dart_IsByteBufferFn = NULL;
static Dart_IsFutureType Dart_IsFutureFn = NULL;
static Dart_InstanceGetTypeType Dart_InstanceGetTypeFn = NULL;
static Dart_ClassNameType Dart_ClassNameFn = NULL;
static Dart_FunctionNameType Dart_FunctionNameFn = NULL;
static Dart_FunctionOwnerType Dart_FunctionOwnerFn = NULL;
static Dart_FunctionIsStaticType Dart_FunctionIsStaticFn = NULL;
static Dart_IsTearOffType Dart_IsTearOffFn = NULL;
static Dart_ClosureFunctionType Dart_ClosureFunctionFn = NULL;
static Dart_ClassLibraryType Dart_ClassLibraryFn = NULL;
static Dart_IntegerFitsIntoInt64Type Dart_IntegerFitsIntoInt64Fn = NULL;
static Dart_IntegerFitsIntoUint64Type Dart_IntegerFitsIntoUint64Fn = NULL;
static Dart_NewIntegerType Dart_NewIntegerFn = NULL;
static Dart_NewIntegerFromUint64Type Dart_NewIntegerFromUint64Fn = NULL;
static Dart_NewIntegerFromHexCStringType Dart_NewIntegerFromHexCStringFn = NULL;
static Dart_IntegerToInt64Type Dart_IntegerToInt64Fn = NULL;
static Dart_IntegerToUint64Type Dart_IntegerToUint64Fn = NULL;
static Dart_IntegerToHexCStringType Dart_IntegerToHexCStringFn = NULL;
static Dart_NewDoubleType Dart_NewDoubleFn = NULL;
static Dart_DoubleValueType Dart_DoubleValueFn = NULL;
static Dart_GetStaticMethodClosureType Dart_GetStaticMethodClosureFn = NULL;
static Dart_TrueType Dart_TrueFn = NULL;
static Dart_FalseType Dart_FalseFn = NULL;
static Dart_NewBooleanType Dart_NewBooleanFn = NULL;
static Dart_BooleanValueType Dart_BooleanValueFn = NULL;
static Dart_StringLengthType Dart_StringLengthFn = NULL;
static Dart_StringUTF8LengthType Dart_StringUTF8LengthFn = NULL;
static Dart_NewStringFromCStringType Dart_NewStringFromCStringFn = NULL;
static Dart_NewStringFromUTF8Type Dart_NewStringFromUTF8Fn = NULL;
static Dart_NewStringFromUTF16Type Dart_NewStringFromUTF16Fn = NULL;
static Dart_NewStringFromUTF32Type Dart_NewStringFromUTF32Fn = NULL;
static Dart_StringToCStringType Dart_StringToCStringFn = NULL;
static Dart_StringToUTF8Type Dart_StringToUTF8Fn = NULL;
static Dart_CopyUTF8EncodingOfStringType Dart_CopyUTF8EncodingOfStringFn = NULL;
static Dart_StringToLatin1Type Dart_StringToLatin1Fn = NULL;
static Dart_StringToUTF16Type Dart_StringToUTF16Fn = NULL;
static Dart_StringStorageSizeType Dart_StringStorageSizeFn = NULL;
static Dart_StringGetPropertiesType Dart_StringGetPropertiesFn = NULL;
static Dart_NewListType Dart_NewListFn = NULL;
static Dart_NewListOfTypeType Dart_NewListOfTypeFn = NULL;
static Dart_NewListOfTypeFilledType Dart_NewListOfTypeFilledFn = NULL;
static Dart_ListLengthType Dart_ListLengthFn = NULL;
static Dart_ListGetAtType Dart_ListGetAtFn = NULL;
static Dart_ListGetRangeType Dart_ListGetRangeFn = NULL;
static Dart_ListSetAtType Dart_ListSetAtFn = NULL;
static Dart_ListGetAsBytesType Dart_ListGetAsBytesFn = NULL;
static Dart_ListSetAsBytesType Dart_ListSetAsBytesFn = NULL;
static Dart_MapGetAtType Dart_MapGetAtFn = NULL;
static Dart_MapContainsKeyType Dart_MapContainsKeyFn = NULL;
static Dart_MapKeysType Dart_MapKeysFn = NULL;
static Dart_NewMapType Dart_NewMapFn = NULL;
static Dart_GetTypeOfTypedDataType Dart_GetTypeOfTypedDataFn = NULL;
static Dart_GetTypeOfExternalTypedDataType Dart_GetTypeOfExternalTypedDataFn =
    NULL;
static Dart_NewTypedDataType Dart_NewTypedDataFn = NULL;
static Dart_NewExternalTypedDataType Dart_NewExternalTypedDataFn = NULL;
static Dart_NewExternalTypedDataWithFinalizerType
    Dart_NewExternalTypedDataWithFinalizerFn = NULL;
static Dart_NewUnmodifiableExternalTypedDataWithFinalizerType
    Dart_NewUnmodifiableExternalTypedDataWithFinalizerFn = NULL;
static Dart_NewByteBufferType Dart_NewByteBufferFn = NULL;
static Dart_TypedDataAcquireDataType Dart_TypedDataAcquireDataFn = NULL;
static Dart_TypedDataReleaseDataType Dart_TypedDataReleaseDataFn = NULL;
static Dart_GetDataFromByteBufferType Dart_GetDataFromByteBufferFn = NULL;
static Dart_NewType Dart_NewFn = NULL;
static Dart_AllocateType Dart_AllocateFn = NULL;
static Dart_AllocateWithNativeFieldsType Dart_AllocateWithNativeFieldsFn = NULL;
static Dart_InvokeType Dart_InvokeFn = NULL;
static Dart_InvokeClosureType Dart_InvokeClosureFn = NULL;
static Dart_InvokeConstructorType Dart_InvokeConstructorFn = NULL;
static Dart_GetFieldType Dart_GetFieldFn = NULL;
static Dart_SetFieldType Dart_SetFieldFn = NULL;
static Dart_ThrowExceptionType Dart_ThrowExceptionFn = NULL;
static Dart_ReThrowExceptionType Dart_ReThrowExceptionFn = NULL;
static Dart_GetNativeInstanceFieldCountType Dart_GetNativeInstanceFieldCountFn =
    NULL;
static Dart_GetNativeInstanceFieldType Dart_GetNativeInstanceFieldFn = NULL;
static Dart_SetNativeInstanceFieldType Dart_SetNativeInstanceFieldFn = NULL;
static Dart_GetNativeIsolateGroupDataType Dart_GetNativeIsolateGroupDataFn =
    NULL;
static Dart_GetNativeArgumentsType Dart_GetNativeArgumentsFn = NULL;
static Dart_GetNativeArgumentType Dart_GetNativeArgumentFn = NULL;
static Dart_GetNativeArgumentCountType Dart_GetNativeArgumentCountFn = NULL;
static Dart_GetNativeFieldsOfArgumentType Dart_GetNativeFieldsOfArgumentFn =
    NULL;
static Dart_GetNativeReceiverType Dart_GetNativeReceiverFn = NULL;
static Dart_GetNativeStringArgumentType Dart_GetNativeStringArgumentFn = NULL;
static Dart_GetNativeIntegerArgumentType Dart_GetNativeIntegerArgumentFn = NULL;
static Dart_GetNativeBooleanArgumentType Dart_GetNativeBooleanArgumentFn = NULL;
static Dart_GetNativeDoubleArgumentType Dart_GetNativeDoubleArgumentFn = NULL;
static Dart_SetReturnValueType Dart_SetReturnValueFn = NULL;
static Dart_SetWeakHandleReturnValueType Dart_SetWeakHandleReturnValueFn = NULL;
static Dart_SetBooleanReturnValueType Dart_SetBooleanReturnValueFn = NULL;
static Dart_SetIntegerReturnValueType Dart_SetIntegerReturnValueFn = NULL;
static Dart_SetDoubleReturnValueType Dart_SetDoubleReturnValueFn = NULL;
static Dart_SetEnvironmentCallbackType Dart_SetEnvironmentCallbackFn = NULL;
static Dart_SetNativeResolverType Dart_SetNativeResolverFn = NULL;
static Dart_GetNativeResolverType Dart_GetNativeResolverFn = NULL;
static Dart_GetNativeSymbolType Dart_GetNativeSymbolFn = NULL;
static Dart_SetFfiNativeResolverType Dart_SetFfiNativeResolverFn = NULL;
static Dart_InitializeNativeAssetsResolverType
    Dart_InitializeNativeAssetsResolverFn = NULL;
static Dart_SetLibraryTagHandlerType Dart_SetLibraryTagHandlerFn = NULL;
static Dart_SetDeferredLoadHandlerType Dart_SetDeferredLoadHandlerFn = NULL;
static Dart_DeferredLoadCompleteType Dart_DeferredLoadCompleteFn = NULL;
static Dart_DeferredLoadCompleteErrorType Dart_DeferredLoadCompleteErrorFn =
    NULL;
static Dart_LoadScriptFromKernelType Dart_LoadScriptFromKernelFn = NULL;
static Dart_LoadScriptFromBytecodeType Dart_LoadScriptFromBytecodeFn = NULL;
static Dart_RootLibraryType Dart_RootLibraryFn = NULL;
static Dart_SetRootLibraryType Dart_SetRootLibraryFn = NULL;
static Dart_GetTypeType Dart_GetTypeFn = NULL;
static Dart_GetNullableTypeType Dart_GetNullableTypeFn = NULL;
static Dart_GetNonNullableTypeType Dart_GetNonNullableTypeFn = NULL;
static Dart_TypeToNullableTypeType Dart_TypeToNullableTypeFn = NULL;
static Dart_TypeToNonNullableTypeType Dart_TypeToNonNullableTypeFn = NULL;
static Dart_IsNullableTypeType Dart_IsNullableTypeFn = NULL;
static Dart_IsNonNullableTypeType Dart_IsNonNullableTypeFn = NULL;
static Dart_GetClassType Dart_GetClassFn = NULL;
static Dart_LibraryUrlType Dart_LibraryUrlFn = NULL;
static Dart_LibraryResolvedUrlType Dart_LibraryResolvedUrlFn = NULL;
static Dart_GetLoadedLibrariesType Dart_GetLoadedLibrariesFn = NULL;
static Dart_LookupLibraryType Dart_LookupLibraryFn = NULL;
static Dart_LibraryHandleErrorType Dart_LibraryHandleErrorFn = NULL;
static Dart_LoadLibraryFromKernelType Dart_LoadLibraryFromKernelFn = NULL;
static Dart_LoadLibraryType Dart_LoadLibraryFn = NULL;
static Dart_LoadLibraryFromBytecodeType Dart_LoadLibraryFromBytecodeFn = NULL;
static Dart_FinalizeLoadingType Dart_FinalizeLoadingFn = NULL;
static Dart_GetPeerType Dart_GetPeerFn = NULL;
static Dart_SetPeerType Dart_SetPeerFn = NULL;
static Dart_IsKernelIsolateType Dart_IsKernelIsolateFn = NULL;
static Dart_KernelIsolateIsRunningType Dart_KernelIsolateIsRunningFn = NULL;
static Dart_KernelPortType Dart_KernelPortFn = NULL;
static Dart_CompileToKernelType Dart_CompileToKernelFn = NULL;
static Dart_KernelListDependenciesType Dart_KernelListDependenciesFn = NULL;
static Dart_SetDartLibrarySourcesKernelType Dart_SetDartLibrarySourcesKernelFn =
    NULL;
static Dart_DetectNullSafetyType Dart_DetectNullSafetyFn = NULL;
static Dart_IsServiceIsolateType Dart_IsServiceIsolateFn = NULL;
static Dart_WriteProfileToTimelineType Dart_WriteProfileToTimelineFn = NULL;
static Dart_PrecompileType Dart_PrecompileFn = NULL;
static Dart_LoadingUnitLibraryUrisType Dart_LoadingUnitLibraryUrisFn = NULL;
static Dart_CreateAppAOTSnapshotAsAssemblyType
    Dart_CreateAppAOTSnapshotAsAssemblyFn = NULL;
static Dart_CreateAppAOTSnapshotAsAssembliesType
    Dart_CreateAppAOTSnapshotAsAssembliesFn = NULL;
static Dart_CreateAppAOTSnapshotAsElfType Dart_CreateAppAOTSnapshotAsElfFn =
    NULL;
static Dart_CreateAppAOTSnapshotAsElfsType Dart_CreateAppAOTSnapshotAsElfsFn =
    NULL;
static Dart_CreateAppAOTSnapshotAsBinaryType
    Dart_CreateAppAOTSnapshotAsBinaryFn = NULL;
static Dart_CreateVMAOTSnapshotAsAssemblyType
    Dart_CreateVMAOTSnapshotAsAssemblyFn = NULL;
static Dart_SortClassesType Dart_SortClassesFn = NULL;
static Dart_CreateAppJITSnapshotAsBlobsType Dart_CreateAppJITSnapshotAsBlobsFn =
    NULL;
static Dart_GetObfuscationMapType Dart_GetObfuscationMapFn = NULL;
static Dart_IsPrecompiledRuntimeType Dart_IsPrecompiledRuntimeFn = NULL;
static Dart_DumpNativeStackTraceType Dart_DumpNativeStackTraceFn = NULL;
static Dart_PrepareToAbortType Dart_PrepareToAbortFn = NULL;
static Dart_SetDwarfStackTraceFootnoteCallbackType
    Dart_SetDwarfStackTraceFootnoteCallbackFn = NULL;
static Dart_PostCObjectType Dart_PostCObjectFn = NULL;
static Dart_PostIntegerType Dart_PostIntegerFn = NULL;
static Dart_NewNativePortType Dart_NewNativePortFn = NULL;
static Dart_NewConcurrentNativePortType Dart_NewConcurrentNativePortFn = NULL;
static Dart_CloseNativePortType Dart_CloseNativePortFn = NULL;
static Dart_CompileAllType Dart_CompileAllFn = NULL;
static Dart_FinalizeAllClassesType Dart_FinalizeAllClassesFn = NULL;
static Dart_ExecuteInternalCommandType Dart_ExecuteInternalCommandFn = NULL;

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved) {
  if (fdwReason == DLL_PROCESS_ATTACH) {
    HMODULE process = GetModuleHandle(NULL);

    Dart_IsErrorFn = (Dart_IsErrorType)GetProcAddress(process, "Dart_IsError");
    Dart_IsApiErrorFn =
        (Dart_IsApiErrorType)GetProcAddress(process, "Dart_IsApiError");
    Dart_IsUnhandledExceptionErrorFn =
        (Dart_IsUnhandledExceptionErrorType)GetProcAddress(
            process, "Dart_IsUnhandledExceptionError");
    Dart_IsCompilationErrorFn = (Dart_IsCompilationErrorType)GetProcAddress(
        process, "Dart_IsCompilationError");
    Dart_IsFatalErrorFn =
        (Dart_IsFatalErrorType)GetProcAddress(process, "Dart_IsFatalError");
    Dart_GetErrorFn =
        (Dart_GetErrorType)GetProcAddress(process, "Dart_GetError");
    Dart_ErrorHasExceptionFn = (Dart_ErrorHasExceptionType)GetProcAddress(
        process, "Dart_ErrorHasException");
    Dart_ErrorGetExceptionFn = (Dart_ErrorGetExceptionType)GetProcAddress(
        process, "Dart_ErrorGetException");
    Dart_ErrorGetStackTraceFn = (Dart_ErrorGetStackTraceType)GetProcAddress(
        process, "Dart_ErrorGetStackTrace");
    Dart_NewApiErrorFn =
        (Dart_NewApiErrorType)GetProcAddress(process, "Dart_NewApiError");
    Dart_NewCompilationErrorFn = (Dart_NewCompilationErrorType)GetProcAddress(
        process, "Dart_NewCompilationError");
    Dart_NewUnhandledExceptionErrorFn =
        (Dart_NewUnhandledExceptionErrorType)GetProcAddress(
            process, "Dart_NewUnhandledExceptionError");
    Dart_PropagateErrorFn =
        (Dart_PropagateErrorType)GetProcAddress(process, "Dart_PropagateError");
    Dart_ToStringFn =
        (Dart_ToStringType)GetProcAddress(process, "Dart_ToString");
    Dart_IdentityEqualsFn =
        (Dart_IdentityEqualsType)GetProcAddress(process, "Dart_IdentityEquals");
    Dart_HandleFromPersistentFn = (Dart_HandleFromPersistentType)GetProcAddress(
        process, "Dart_HandleFromPersistent");
    Dart_HandleFromWeakPersistentFn =
        (Dart_HandleFromWeakPersistentType)GetProcAddress(
            process, "Dart_HandleFromWeakPersistent");
    Dart_NewPersistentHandleFn = (Dart_NewPersistentHandleType)GetProcAddress(
        process, "Dart_NewPersistentHandle");
    Dart_SetPersistentHandleFn = (Dart_SetPersistentHandleType)GetProcAddress(
        process, "Dart_SetPersistentHandle");
    Dart_DeletePersistentHandleFn =
        (Dart_DeletePersistentHandleType)GetProcAddress(
            process, "Dart_DeletePersistentHandle");
    Dart_NewWeakPersistentHandleFn =
        (Dart_NewWeakPersistentHandleType)GetProcAddress(
            process, "Dart_NewWeakPersistentHandle");
    Dart_DeleteWeakPersistentHandleFn =
        (Dart_DeleteWeakPersistentHandleType)GetProcAddress(
            process, "Dart_DeleteWeakPersistentHandle");
    Dart_NewFinalizableHandleFn = (Dart_NewFinalizableHandleType)GetProcAddress(
        process, "Dart_NewFinalizableHandle");
    Dart_DeleteFinalizableHandleFn =
        (Dart_DeleteFinalizableHandleType)GetProcAddress(
            process, "Dart_DeleteFinalizableHandle");
    Dart_VersionStringFn =
        (Dart_VersionStringType)GetProcAddress(process, "Dart_VersionString");
    Dart_IsolateFlagsInitializeFn =
        (Dart_IsolateFlagsInitializeType)GetProcAddress(
            process, "Dart_IsolateFlagsInitialize");
    Dart_InitializeFn =
        (Dart_InitializeType)GetProcAddress(process, "Dart_Initialize");
    Dart_CleanupFn = (Dart_CleanupType)GetProcAddress(process, "Dart_Cleanup");
    Dart_SetVMFlagsFn =
        (Dart_SetVMFlagsType)GetProcAddress(process, "Dart_SetVMFlags");
    Dart_IsVMFlagSetFn =
        (Dart_IsVMFlagSetType)GetProcAddress(process, "Dart_IsVMFlagSet");
    Dart_CreateIsolateGroupFn = (Dart_CreateIsolateGroupType)GetProcAddress(
        process, "Dart_CreateIsolateGroup");
    Dart_CreateIsolateInGroupFn = (Dart_CreateIsolateInGroupType)GetProcAddress(
        process, "Dart_CreateIsolateInGroup");
    Dart_CreateIsolateGroupFromKernelFn =
        (Dart_CreateIsolateGroupFromKernelType)GetProcAddress(
            process, "Dart_CreateIsolateGroupFromKernel");
    Dart_ShutdownIsolateFn = (Dart_ShutdownIsolateType)GetProcAddress(
        process, "Dart_ShutdownIsolate");
    Dart_CurrentIsolateFn =
        (Dart_CurrentIsolateType)GetProcAddress(process, "Dart_CurrentIsolate");
    Dart_CurrentIsolateDataFn = (Dart_CurrentIsolateDataType)GetProcAddress(
        process, "Dart_CurrentIsolateData");
    Dart_IsolateDataFn =
        (Dart_IsolateDataType)GetProcAddress(process, "Dart_IsolateData");
    Dart_CurrentIsolateGroupFn = (Dart_CurrentIsolateGroupType)GetProcAddress(
        process, "Dart_CurrentIsolateGroup");
    Dart_CurrentIsolateGroupDataFn =
        (Dart_CurrentIsolateGroupDataType)GetProcAddress(
            process, "Dart_CurrentIsolateGroupData");
    Dart_CurrentIsolateGroupIdFn =
        (Dart_CurrentIsolateGroupIdType)GetProcAddress(
            process, "Dart_CurrentIsolateGroupId");
    Dart_IsolateGroupDataFn = (Dart_IsolateGroupDataType)GetProcAddress(
        process, "Dart_IsolateGroupData");
    Dart_DebugNameFn =
        (Dart_DebugNameType)GetProcAddress(process, "Dart_DebugName");
    Dart_DebugNameToCStringFn = (Dart_DebugNameToCStringType)GetProcAddress(
        process, "Dart_DebugNameToCString");
    Dart_IsolateServiceIdFn = (Dart_IsolateServiceIdType)GetProcAddress(
        process, "Dart_IsolateServiceId");
    Dart_EnterIsolateFn =
        (Dart_EnterIsolateType)GetProcAddress(process, "Dart_EnterIsolate");
    Dart_KillIsolateFn =
        (Dart_KillIsolateType)GetProcAddress(process, "Dart_KillIsolate");
    Dart_NotifyIdleFn =
        (Dart_NotifyIdleType)GetProcAddress(process, "Dart_NotifyIdle");
    Dart_EnableHeapSamplingFn = (Dart_EnableHeapSamplingType)GetProcAddress(
        process, "Dart_EnableHeapSampling");
    Dart_DisableHeapSamplingFn = (Dart_DisableHeapSamplingType)GetProcAddress(
        process, "Dart_DisableHeapSampling");
    Dart_RegisterHeapSamplingCallbackFn =
        (Dart_RegisterHeapSamplingCallbackType)GetProcAddress(
            process, "Dart_RegisterHeapSamplingCallback");
    Dart_ReportSurvivingAllocationsFn =
        (Dart_ReportSurvivingAllocationsType)GetProcAddress(
            process, "Dart_ReportSurvivingAllocations");
    Dart_SetHeapSamplingPeriodFn =
        (Dart_SetHeapSamplingPeriodType)GetProcAddress(
            process, "Dart_SetHeapSamplingPeriod");
    Dart_NotifyDestroyedFn = (Dart_NotifyDestroyedType)GetProcAddress(
        process, "Dart_NotifyDestroyed");
    Dart_NotifyLowMemoryFn = (Dart_NotifyLowMemoryType)GetProcAddress(
        process, "Dart_NotifyLowMemory");
    Dart_SetPerformanceModeFn = (Dart_SetPerformanceModeType)GetProcAddress(
        process, "Dart_SetPerformanceMode");
    Dart_StartProfilingFn =
        (Dart_StartProfilingType)GetProcAddress(process, "Dart_StartProfiling");
    Dart_StopProfilingFn =
        (Dart_StopProfilingType)GetProcAddress(process, "Dart_StopProfiling");
    Dart_ThreadDisableProfilingFn =
        (Dart_ThreadDisableProfilingType)GetProcAddress(
            process, "Dart_ThreadDisableProfiling");
    Dart_ThreadEnableProfilingFn =
        (Dart_ThreadEnableProfilingType)GetProcAddress(
            process, "Dart_ThreadEnableProfiling");
    Dart_AddSymbolsFn =
        (Dart_AddSymbolsType)GetProcAddress(process, "Dart_AddSymbols");
    Dart_ExitIsolateFn =
        (Dart_ExitIsolateType)GetProcAddress(process, "Dart_ExitIsolate");
    Dart_CreateSnapshotFn =
        (Dart_CreateSnapshotType)GetProcAddress(process, "Dart_CreateSnapshot");
    Dart_IsKernelFn =
        (Dart_IsKernelType)GetProcAddress(process, "Dart_IsKernel");
    Dart_IsBytecodeFn =
        (Dart_IsBytecodeType)GetProcAddress(process, "Dart_IsBytecode");
    Dart_IsolateMakeRunnableFn = (Dart_IsolateMakeRunnableType)GetProcAddress(
        process, "Dart_IsolateMakeRunnable");
    Dart_SetMessageNotifyCallbackFn =
        (Dart_SetMessageNotifyCallbackType)GetProcAddress(
            process, "Dart_SetMessageNotifyCallback");
    Dart_GetMessageNotifyCallbackFn =
        (Dart_GetMessageNotifyCallbackType)GetProcAddress(
            process, "Dart_GetMessageNotifyCallback");
    Dart_ShouldPauseOnStartFn = (Dart_ShouldPauseOnStartType)GetProcAddress(
        process, "Dart_ShouldPauseOnStart");
    Dart_SetShouldPauseOnStartFn =
        (Dart_SetShouldPauseOnStartType)GetProcAddress(
            process, "Dart_SetShouldPauseOnStart");
    Dart_IsPausedOnStartFn = (Dart_IsPausedOnStartType)GetProcAddress(
        process, "Dart_IsPausedOnStart");
    Dart_SetPausedOnStartFn = (Dart_SetPausedOnStartType)GetProcAddress(
        process, "Dart_SetPausedOnStart");
    Dart_ShouldPauseOnExitFn = (Dart_ShouldPauseOnExitType)GetProcAddress(
        process, "Dart_ShouldPauseOnExit");
    Dart_SetShouldPauseOnExitFn = (Dart_SetShouldPauseOnExitType)GetProcAddress(
        process, "Dart_SetShouldPauseOnExit");
    Dart_IsPausedOnExitFn =
        (Dart_IsPausedOnExitType)GetProcAddress(process, "Dart_IsPausedOnExit");
    Dart_SetPausedOnExitFn = (Dart_SetPausedOnExitType)GetProcAddress(
        process, "Dart_SetPausedOnExit");
    Dart_SetStickyErrorFn =
        (Dart_SetStickyErrorType)GetProcAddress(process, "Dart_SetStickyError");
    Dart_HasStickyErrorFn =
        (Dart_HasStickyErrorType)GetProcAddress(process, "Dart_HasStickyError");
    Dart_GetStickyErrorFn =
        (Dart_GetStickyErrorType)GetProcAddress(process, "Dart_GetStickyError");
    Dart_HandleMessageFn =
        (Dart_HandleMessageType)GetProcAddress(process, "Dart_HandleMessage");
    Dart_HandleServiceMessagesFn =
        (Dart_HandleServiceMessagesType)GetProcAddress(
            process, "Dart_HandleServiceMessages");
    Dart_HasServiceMessagesFn = (Dart_HasServiceMessagesType)GetProcAddress(
        process, "Dart_HasServiceMessages");
    Dart_RunLoopFn = (Dart_RunLoopType)GetProcAddress(process, "Dart_RunLoop");
    Dart_RunLoopAsyncFn =
        (Dart_RunLoopAsyncType)GetProcAddress(process, "Dart_RunLoopAsync");
    Dart_GetMainPortIdFn =
        (Dart_GetMainPortIdType)GetProcAddress(process, "Dart_GetMainPortId");
    Dart_HasLivePortsFn =
        (Dart_HasLivePortsType)GetProcAddress(process, "Dart_HasLivePorts");
    Dart_PostFn = (Dart_PostType)GetProcAddress(process, "Dart_Post");
    Dart_NewSendPortFn =
        (Dart_NewSendPortType)GetProcAddress(process, "Dart_NewSendPort");
    Dart_NewSendPortExFn =
        (Dart_NewSendPortExType)GetProcAddress(process, "Dart_NewSendPortEx");
    Dart_SendPortGetIdFn =
        (Dart_SendPortGetIdType)GetProcAddress(process, "Dart_SendPortGetId");
    Dart_SendPortGetIdExFn = (Dart_SendPortGetIdExType)GetProcAddress(
        process, "Dart_SendPortGetIdEx");
    Dart_SetCurrentThreadOwnsIsolateFn =
        (Dart_SetCurrentThreadOwnsIsolateType)GetProcAddress(
            process, "Dart_SetCurrentThreadOwnsIsolate");
    Dart_GetCurrentThreadOwnsIsolateFn =
        (Dart_GetCurrentThreadOwnsIsolateType)GetProcAddress(
            process, "Dart_GetCurrentThreadOwnsIsolate");
    Dart_EnterScopeFn =
        (Dart_EnterScopeType)GetProcAddress(process, "Dart_EnterScope");
    Dart_ExitScopeFn =
        (Dart_ExitScopeType)GetProcAddress(process, "Dart_ExitScope");
    Dart_ScopeAllocateFn =
        (Dart_ScopeAllocateType)GetProcAddress(process, "Dart_ScopeAllocate");
    Dart_NullFn = (Dart_NullType)GetProcAddress(process, "Dart_Null");
    Dart_IsNullFn = (Dart_IsNullType)GetProcAddress(process, "Dart_IsNull");
    Dart_EmptyStringFn =
        (Dart_EmptyStringType)GetProcAddress(process, "Dart_EmptyString");
    Dart_TypeDynamicFn =
        (Dart_TypeDynamicType)GetProcAddress(process, "Dart_TypeDynamic");
    Dart_TypeVoidFn =
        (Dart_TypeVoidType)GetProcAddress(process, "Dart_TypeVoid");
    Dart_TypeNeverFn =
        (Dart_TypeNeverType)GetProcAddress(process, "Dart_TypeNever");
    Dart_TypeStringFn =
        (Dart_TypeStringType)GetProcAddress(process, "Dart_TypeString");
    Dart_TypeDoubleFn =
        (Dart_TypeDoubleType)GetProcAddress(process, "Dart_TypeDouble");
    Dart_TypeIntFn = (Dart_TypeIntType)GetProcAddress(process, "Dart_TypeInt");
    Dart_TypeBooleanFn =
        (Dart_TypeBooleanType)GetProcAddress(process, "Dart_TypeBoolean");
    Dart_TypeObjectFn =
        (Dart_TypeObjectType)GetProcAddress(process, "Dart_TypeObject");
    Dart_ObjectEqualsFn =
        (Dart_ObjectEqualsType)GetProcAddress(process, "Dart_ObjectEquals");
    Dart_ObjectIsTypeFn =
        (Dart_ObjectIsTypeType)GetProcAddress(process, "Dart_ObjectIsType");
    Dart_IsInstanceFn =
        (Dart_IsInstanceType)GetProcAddress(process, "Dart_IsInstance");
    Dart_IsNumberFn =
        (Dart_IsNumberType)GetProcAddress(process, "Dart_IsNumber");
    Dart_IsIntegerFn =
        (Dart_IsIntegerType)GetProcAddress(process, "Dart_IsInteger");
    Dart_IsDoubleFn =
        (Dart_IsDoubleType)GetProcAddress(process, "Dart_IsDouble");
    Dart_IsBooleanFn =
        (Dart_IsBooleanType)GetProcAddress(process, "Dart_IsBoolean");
    Dart_IsStringFn =
        (Dart_IsStringType)GetProcAddress(process, "Dart_IsString");
    Dart_IsStringLatin1Fn =
        (Dart_IsStringLatin1Type)GetProcAddress(process, "Dart_IsStringLatin1");
    Dart_IsListFn = (Dart_IsListType)GetProcAddress(process, "Dart_IsList");
    Dart_IsMapFn = (Dart_IsMapType)GetProcAddress(process, "Dart_IsMap");
    Dart_IsLibraryFn =
        (Dart_IsLibraryType)GetProcAddress(process, "Dart_IsLibrary");
    Dart_IsTypeFn = (Dart_IsTypeType)GetProcAddress(process, "Dart_IsType");
    Dart_IsFunctionFn =
        (Dart_IsFunctionType)GetProcAddress(process, "Dart_IsFunction");
    Dart_IsVariableFn =
        (Dart_IsVariableType)GetProcAddress(process, "Dart_IsVariable");
    Dart_IsTypeVariableFn =
        (Dart_IsTypeVariableType)GetProcAddress(process, "Dart_IsTypeVariable");
    Dart_IsClosureFn =
        (Dart_IsClosureType)GetProcAddress(process, "Dart_IsClosure");
    Dart_IsTypedDataFn =
        (Dart_IsTypedDataType)GetProcAddress(process, "Dart_IsTypedData");
    Dart_IsByteBufferFn =
        (Dart_IsByteBufferType)GetProcAddress(process, "Dart_IsByteBuffer");
    Dart_IsFutureFn =
        (Dart_IsFutureType)GetProcAddress(process, "Dart_IsFuture");
    Dart_InstanceGetTypeFn = (Dart_InstanceGetTypeType)GetProcAddress(
        process, "Dart_InstanceGetType");
    Dart_ClassNameFn =
        (Dart_ClassNameType)GetProcAddress(process, "Dart_ClassName");
    Dart_FunctionNameFn =
        (Dart_FunctionNameType)GetProcAddress(process, "Dart_FunctionName");
    Dart_FunctionOwnerFn =
        (Dart_FunctionOwnerType)GetProcAddress(process, "Dart_FunctionOwner");
    Dart_FunctionIsStaticFn = (Dart_FunctionIsStaticType)GetProcAddress(
        process, "Dart_FunctionIsStatic");
    Dart_IsTearOffFn =
        (Dart_IsTearOffType)GetProcAddress(process, "Dart_IsTearOff");
    Dart_ClosureFunctionFn = (Dart_ClosureFunctionType)GetProcAddress(
        process, "Dart_ClosureFunction");
    Dart_ClassLibraryFn =
        (Dart_ClassLibraryType)GetProcAddress(process, "Dart_ClassLibrary");
    Dart_IntegerFitsIntoInt64Fn = (Dart_IntegerFitsIntoInt64Type)GetProcAddress(
        process, "Dart_IntegerFitsIntoInt64");
    Dart_IntegerFitsIntoUint64Fn =
        (Dart_IntegerFitsIntoUint64Type)GetProcAddress(
            process, "Dart_IntegerFitsIntoUint64");
    Dart_NewIntegerFn =
        (Dart_NewIntegerType)GetProcAddress(process, "Dart_NewInteger");
    Dart_NewIntegerFromUint64Fn = (Dart_NewIntegerFromUint64Type)GetProcAddress(
        process, "Dart_NewIntegerFromUint64");
    Dart_NewIntegerFromHexCStringFn =
        (Dart_NewIntegerFromHexCStringType)GetProcAddress(
            process, "Dart_NewIntegerFromHexCString");
    Dart_IntegerToInt64Fn =
        (Dart_IntegerToInt64Type)GetProcAddress(process, "Dart_IntegerToInt64");
    Dart_IntegerToUint64Fn = (Dart_IntegerToUint64Type)GetProcAddress(
        process, "Dart_IntegerToUint64");
    Dart_IntegerToHexCStringFn = (Dart_IntegerToHexCStringType)GetProcAddress(
        process, "Dart_IntegerToHexCString");
    Dart_NewDoubleFn =
        (Dart_NewDoubleType)GetProcAddress(process, "Dart_NewDouble");
    Dart_DoubleValueFn =
        (Dart_DoubleValueType)GetProcAddress(process, "Dart_DoubleValue");
    Dart_GetStaticMethodClosureFn =
        (Dart_GetStaticMethodClosureType)GetProcAddress(
            process, "Dart_GetStaticMethodClosure");
    Dart_TrueFn = (Dart_TrueType)GetProcAddress(process, "Dart_True");
    Dart_FalseFn = (Dart_FalseType)GetProcAddress(process, "Dart_False");
    Dart_NewBooleanFn =
        (Dart_NewBooleanType)GetProcAddress(process, "Dart_NewBoolean");
    Dart_BooleanValueFn =
        (Dart_BooleanValueType)GetProcAddress(process, "Dart_BooleanValue");
    Dart_StringLengthFn =
        (Dart_StringLengthType)GetProcAddress(process, "Dart_StringLength");
    Dart_StringUTF8LengthFn = (Dart_StringUTF8LengthType)GetProcAddress(
        process, "Dart_StringUTF8Length");
    Dart_NewStringFromCStringFn = (Dart_NewStringFromCStringType)GetProcAddress(
        process, "Dart_NewStringFromCString");
    Dart_NewStringFromUTF8Fn = (Dart_NewStringFromUTF8Type)GetProcAddress(
        process, "Dart_NewStringFromUTF8");
    Dart_NewStringFromUTF16Fn = (Dart_NewStringFromUTF16Type)GetProcAddress(
        process, "Dart_NewStringFromUTF16");
    Dart_NewStringFromUTF32Fn = (Dart_NewStringFromUTF32Type)GetProcAddress(
        process, "Dart_NewStringFromUTF32");
    Dart_StringToCStringFn = (Dart_StringToCStringType)GetProcAddress(
        process, "Dart_StringToCString");
    Dart_StringToUTF8Fn =
        (Dart_StringToUTF8Type)GetProcAddress(process, "Dart_StringToUTF8");
    Dart_CopyUTF8EncodingOfStringFn =
        (Dart_CopyUTF8EncodingOfStringType)GetProcAddress(
            process, "Dart_CopyUTF8EncodingOfString");
    Dart_StringToLatin1Fn =
        (Dart_StringToLatin1Type)GetProcAddress(process, "Dart_StringToLatin1");
    Dart_StringToUTF16Fn =
        (Dart_StringToUTF16Type)GetProcAddress(process, "Dart_StringToUTF16");
    Dart_StringStorageSizeFn = (Dart_StringStorageSizeType)GetProcAddress(
        process, "Dart_StringStorageSize");
    Dart_StringGetPropertiesFn = (Dart_StringGetPropertiesType)GetProcAddress(
        process, "Dart_StringGetProperties");
    Dart_NewListFn = (Dart_NewListType)GetProcAddress(process, "Dart_NewList");
    Dart_NewListOfTypeFn =
        (Dart_NewListOfTypeType)GetProcAddress(process, "Dart_NewListOfType");
    Dart_NewListOfTypeFilledFn = (Dart_NewListOfTypeFilledType)GetProcAddress(
        process, "Dart_NewListOfTypeFilled");
    Dart_ListLengthFn =
        (Dart_ListLengthType)GetProcAddress(process, "Dart_ListLength");
    Dart_ListGetAtFn =
        (Dart_ListGetAtType)GetProcAddress(process, "Dart_ListGetAt");
    Dart_ListGetRangeFn =
        (Dart_ListGetRangeType)GetProcAddress(process, "Dart_ListGetRange");
    Dart_ListSetAtFn =
        (Dart_ListSetAtType)GetProcAddress(process, "Dart_ListSetAt");
    Dart_ListGetAsBytesFn =
        (Dart_ListGetAsBytesType)GetProcAddress(process, "Dart_ListGetAsBytes");
    Dart_ListSetAsBytesFn =
        (Dart_ListSetAsBytesType)GetProcAddress(process, "Dart_ListSetAsBytes");
    Dart_MapGetAtFn =
        (Dart_MapGetAtType)GetProcAddress(process, "Dart_MapGetAt");
    Dart_MapContainsKeyFn =
        (Dart_MapContainsKeyType)GetProcAddress(process, "Dart_MapContainsKey");
    Dart_MapKeysFn = (Dart_MapKeysType)GetProcAddress(process, "Dart_MapKeys");
    Dart_NewMapFn = (Dart_NewMapType)GetProcAddress(process, "Dart_NewMap");
    Dart_GetTypeOfTypedDataFn = (Dart_GetTypeOfTypedDataType)GetProcAddress(
        process, "Dart_GetTypeOfTypedData");
    Dart_GetTypeOfExternalTypedDataFn =
        (Dart_GetTypeOfExternalTypedDataType)GetProcAddress(
            process, "Dart_GetTypeOfExternalTypedData");
    Dart_NewTypedDataFn =
        (Dart_NewTypedDataType)GetProcAddress(process, "Dart_NewTypedData");
    Dart_NewExternalTypedDataFn = (Dart_NewExternalTypedDataType)GetProcAddress(
        process, "Dart_NewExternalTypedData");
    Dart_NewExternalTypedDataWithFinalizerFn =
        (Dart_NewExternalTypedDataWithFinalizerType)GetProcAddress(
            process, "Dart_NewExternalTypedDataWithFinalizer");
    Dart_NewUnmodifiableExternalTypedDataWithFinalizerFn =
        (Dart_NewUnmodifiableExternalTypedDataWithFinalizerType)GetProcAddress(
            process, "Dart_NewUnmodifiableExternalTypedDataWithFinalizer");
    Dart_NewByteBufferFn =
        (Dart_NewByteBufferType)GetProcAddress(process, "Dart_NewByteBuffer");
    Dart_TypedDataAcquireDataFn = (Dart_TypedDataAcquireDataType)GetProcAddress(
        process, "Dart_TypedDataAcquireData");
    Dart_TypedDataReleaseDataFn = (Dart_TypedDataReleaseDataType)GetProcAddress(
        process, "Dart_TypedDataReleaseData");
    Dart_GetDataFromByteBufferFn =
        (Dart_GetDataFromByteBufferType)GetProcAddress(
            process, "Dart_GetDataFromByteBuffer");
    Dart_NewFn = (Dart_NewType)GetProcAddress(process, "Dart_New");
    Dart_AllocateFn =
        (Dart_AllocateType)GetProcAddress(process, "Dart_Allocate");
    Dart_AllocateWithNativeFieldsFn =
        (Dart_AllocateWithNativeFieldsType)GetProcAddress(
            process, "Dart_AllocateWithNativeFields");
    Dart_InvokeFn = (Dart_InvokeType)GetProcAddress(process, "Dart_Invoke");
    Dart_InvokeClosureFn =
        (Dart_InvokeClosureType)GetProcAddress(process, "Dart_InvokeClosure");
    Dart_InvokeConstructorFn = (Dart_InvokeConstructorType)GetProcAddress(
        process, "Dart_InvokeConstructor");
    Dart_GetFieldFn =
        (Dart_GetFieldType)GetProcAddress(process, "Dart_GetField");
    Dart_SetFieldFn =
        (Dart_SetFieldType)GetProcAddress(process, "Dart_SetField");
    Dart_ThrowExceptionFn =
        (Dart_ThrowExceptionType)GetProcAddress(process, "Dart_ThrowException");
    Dart_ReThrowExceptionFn = (Dart_ReThrowExceptionType)GetProcAddress(
        process, "Dart_ReThrowException");
    Dart_GetNativeInstanceFieldCountFn =
        (Dart_GetNativeInstanceFieldCountType)GetProcAddress(
            process, "Dart_GetNativeInstanceFieldCount");
    Dart_GetNativeInstanceFieldFn =
        (Dart_GetNativeInstanceFieldType)GetProcAddress(
            process, "Dart_GetNativeInstanceField");
    Dart_SetNativeInstanceFieldFn =
        (Dart_SetNativeInstanceFieldType)GetProcAddress(
            process, "Dart_SetNativeInstanceField");
    Dart_GetNativeIsolateGroupDataFn =
        (Dart_GetNativeIsolateGroupDataType)GetProcAddress(
            process, "Dart_GetNativeIsolateGroupData");
    Dart_GetNativeArgumentsFn = (Dart_GetNativeArgumentsType)GetProcAddress(
        process, "Dart_GetNativeArguments");
    Dart_GetNativeArgumentFn = (Dart_GetNativeArgumentType)GetProcAddress(
        process, "Dart_GetNativeArgument");
    Dart_GetNativeArgumentCountFn =
        (Dart_GetNativeArgumentCountType)GetProcAddress(
            process, "Dart_GetNativeArgumentCount");
    Dart_GetNativeFieldsOfArgumentFn =
        (Dart_GetNativeFieldsOfArgumentType)GetProcAddress(
            process, "Dart_GetNativeFieldsOfArgument");
    Dart_GetNativeReceiverFn = (Dart_GetNativeReceiverType)GetProcAddress(
        process, "Dart_GetNativeReceiver");
    Dart_GetNativeStringArgumentFn =
        (Dart_GetNativeStringArgumentType)GetProcAddress(
            process, "Dart_GetNativeStringArgument");
    Dart_GetNativeIntegerArgumentFn =
        (Dart_GetNativeIntegerArgumentType)GetProcAddress(
            process, "Dart_GetNativeIntegerArgument");
    Dart_GetNativeBooleanArgumentFn =
        (Dart_GetNativeBooleanArgumentType)GetProcAddress(
            process, "Dart_GetNativeBooleanArgument");
    Dart_GetNativeDoubleArgumentFn =
        (Dart_GetNativeDoubleArgumentType)GetProcAddress(
            process, "Dart_GetNativeDoubleArgument");
    Dart_SetReturnValueFn =
        (Dart_SetReturnValueType)GetProcAddress(process, "Dart_SetReturnValue");
    Dart_SetWeakHandleReturnValueFn =
        (Dart_SetWeakHandleReturnValueType)GetProcAddress(
            process, "Dart_SetWeakHandleReturnValue");
    Dart_SetBooleanReturnValueFn =
        (Dart_SetBooleanReturnValueType)GetProcAddress(
            process, "Dart_SetBooleanReturnValue");
    Dart_SetIntegerReturnValueFn =
        (Dart_SetIntegerReturnValueType)GetProcAddress(
            process, "Dart_SetIntegerReturnValue");
    Dart_SetDoubleReturnValueFn = (Dart_SetDoubleReturnValueType)GetProcAddress(
        process, "Dart_SetDoubleReturnValue");
    Dart_SetEnvironmentCallbackFn =
        (Dart_SetEnvironmentCallbackType)GetProcAddress(
            process, "Dart_SetEnvironmentCallback");
    Dart_SetNativeResolverFn = (Dart_SetNativeResolverType)GetProcAddress(
        process, "Dart_SetNativeResolver");
    Dart_GetNativeResolverFn = (Dart_GetNativeResolverType)GetProcAddress(
        process, "Dart_GetNativeResolver");
    Dart_GetNativeSymbolFn = (Dart_GetNativeSymbolType)GetProcAddress(
        process, "Dart_GetNativeSymbol");
    Dart_SetFfiNativeResolverFn = (Dart_SetFfiNativeResolverType)GetProcAddress(
        process, "Dart_SetFfiNativeResolver");
    Dart_InitializeNativeAssetsResolverFn =
        (Dart_InitializeNativeAssetsResolverType)GetProcAddress(
            process, "Dart_InitializeNativeAssetsResolver");
    Dart_SetLibraryTagHandlerFn = (Dart_SetLibraryTagHandlerType)GetProcAddress(
        process, "Dart_SetLibraryTagHandler");
    Dart_SetDeferredLoadHandlerFn =
        (Dart_SetDeferredLoadHandlerType)GetProcAddress(
            process, "Dart_SetDeferredLoadHandler");
    Dart_DeferredLoadCompleteFn = (Dart_DeferredLoadCompleteType)GetProcAddress(
        process, "Dart_DeferredLoadComplete");
    Dart_DeferredLoadCompleteErrorFn =
        (Dart_DeferredLoadCompleteErrorType)GetProcAddress(
            process, "Dart_DeferredLoadCompleteError");
    Dart_LoadScriptFromKernelFn = (Dart_LoadScriptFromKernelType)GetProcAddress(
        process, "Dart_LoadScriptFromKernel");
    Dart_LoadScriptFromBytecodeFn =
        (Dart_LoadScriptFromBytecodeType)GetProcAddress(
            process, "Dart_LoadScriptFromBytecode");
    Dart_RootLibraryFn =
        (Dart_RootLibraryType)GetProcAddress(process, "Dart_RootLibrary");
    Dart_SetRootLibraryFn =
        (Dart_SetRootLibraryType)GetProcAddress(process, "Dart_SetRootLibrary");
    Dart_GetTypeFn = (Dart_GetTypeType)GetProcAddress(process, "Dart_GetType");
    Dart_GetNullableTypeFn = (Dart_GetNullableTypeType)GetProcAddress(
        process, "Dart_GetNullableType");
    Dart_GetNonNullableTypeFn = (Dart_GetNonNullableTypeType)GetProcAddress(
        process, "Dart_GetNonNullableType");
    Dart_TypeToNullableTypeFn = (Dart_TypeToNullableTypeType)GetProcAddress(
        process, "Dart_TypeToNullableType");
    Dart_TypeToNonNullableTypeFn =
        (Dart_TypeToNonNullableTypeType)GetProcAddress(
            process, "Dart_TypeToNonNullableType");
    Dart_IsNullableTypeFn =
        (Dart_IsNullableTypeType)GetProcAddress(process, "Dart_IsNullableType");
    Dart_IsNonNullableTypeFn = (Dart_IsNonNullableTypeType)GetProcAddress(
        process, "Dart_IsNonNullableType");
    Dart_GetClassFn =
        (Dart_GetClassType)GetProcAddress(process, "Dart_GetClass");
    Dart_LibraryUrlFn =
        (Dart_LibraryUrlType)GetProcAddress(process, "Dart_LibraryUrl");
    Dart_LibraryResolvedUrlFn = (Dart_LibraryResolvedUrlType)GetProcAddress(
        process, "Dart_LibraryResolvedUrl");
    Dart_GetLoadedLibrariesFn = (Dart_GetLoadedLibrariesType)GetProcAddress(
        process, "Dart_GetLoadedLibraries");
    Dart_LookupLibraryFn =
        (Dart_LookupLibraryType)GetProcAddress(process, "Dart_LookupLibrary");
    Dart_LibraryHandleErrorFn = (Dart_LibraryHandleErrorType)GetProcAddress(
        process, "Dart_LibraryHandleError");
    Dart_LoadLibraryFromKernelFn =
        (Dart_LoadLibraryFromKernelType)GetProcAddress(
            process, "Dart_LoadLibraryFromKernel");
    Dart_LoadLibraryFn =
        (Dart_LoadLibraryType)GetProcAddress(process, "Dart_LoadLibrary");
    Dart_LoadLibraryFromBytecodeFn =
        (Dart_LoadLibraryFromBytecodeType)GetProcAddress(
            process, "Dart_LoadLibraryFromBytecode");
    Dart_FinalizeLoadingFn = (Dart_FinalizeLoadingType)GetProcAddress(
        process, "Dart_FinalizeLoading");
    Dart_GetPeerFn = (Dart_GetPeerType)GetProcAddress(process, "Dart_GetPeer");
    Dart_SetPeerFn = (Dart_SetPeerType)GetProcAddress(process, "Dart_SetPeer");
    Dart_IsKernelIsolateFn = (Dart_IsKernelIsolateType)GetProcAddress(
        process, "Dart_IsKernelIsolate");
    Dart_KernelIsolateIsRunningFn =
        (Dart_KernelIsolateIsRunningType)GetProcAddress(
            process, "Dart_KernelIsolateIsRunning");
    Dart_KernelPortFn =
        (Dart_KernelPortType)GetProcAddress(process, "Dart_KernelPort");
    Dart_CompileToKernelFn = (Dart_CompileToKernelType)GetProcAddress(
        process, "Dart_CompileToKernel");
    Dart_KernelListDependenciesFn =
        (Dart_KernelListDependenciesType)GetProcAddress(
            process, "Dart_KernelListDependencies");
    Dart_SetDartLibrarySourcesKernelFn =
        (Dart_SetDartLibrarySourcesKernelType)GetProcAddress(
            process, "Dart_SetDartLibrarySourcesKernel");
    Dart_DetectNullSafetyFn = (Dart_DetectNullSafetyType)GetProcAddress(
        process, "Dart_DetectNullSafety");
    Dart_IsServiceIsolateFn = (Dart_IsServiceIsolateType)GetProcAddress(
        process, "Dart_IsServiceIsolate");
    Dart_WriteProfileToTimelineFn =
        (Dart_WriteProfileToTimelineType)GetProcAddress(
            process, "Dart_WriteProfileToTimeline");
    Dart_PrecompileFn =
        (Dart_PrecompileType)GetProcAddress(process, "Dart_Precompile");
    Dart_LoadingUnitLibraryUrisFn =
        (Dart_LoadingUnitLibraryUrisType)GetProcAddress(
            process, "Dart_LoadingUnitLibraryUris");
    Dart_CreateAppAOTSnapshotAsAssemblyFn =
        (Dart_CreateAppAOTSnapshotAsAssemblyType)GetProcAddress(
            process, "Dart_CreateAppAOTSnapshotAsAssembly");
    Dart_CreateAppAOTSnapshotAsAssembliesFn =
        (Dart_CreateAppAOTSnapshotAsAssembliesType)GetProcAddress(
            process, "Dart_CreateAppAOTSnapshotAsAssemblies");
    Dart_CreateAppAOTSnapshotAsElfFn =
        (Dart_CreateAppAOTSnapshotAsElfType)GetProcAddress(
            process, "Dart_CreateAppAOTSnapshotAsElf");
    Dart_CreateAppAOTSnapshotAsElfsFn =
        (Dart_CreateAppAOTSnapshotAsElfsType)GetProcAddress(
            process, "Dart_CreateAppAOTSnapshotAsElfs");
    Dart_CreateAppAOTSnapshotAsBinaryFn =
        (Dart_CreateAppAOTSnapshotAsBinaryType)GetProcAddress(
            process, "Dart_CreateAppAOTSnapshotAsBinary");
    Dart_CreateVMAOTSnapshotAsAssemblyFn =
        (Dart_CreateVMAOTSnapshotAsAssemblyType)GetProcAddress(
            process, "Dart_CreateVMAOTSnapshotAsAssembly");
    Dart_SortClassesFn =
        (Dart_SortClassesType)GetProcAddress(process, "Dart_SortClasses");
    Dart_CreateAppJITSnapshotAsBlobsFn =
        (Dart_CreateAppJITSnapshotAsBlobsType)GetProcAddress(
            process, "Dart_CreateAppJITSnapshotAsBlobs");
    Dart_GetObfuscationMapFn = (Dart_GetObfuscationMapType)GetProcAddress(
        process, "Dart_GetObfuscationMap");
    Dart_IsPrecompiledRuntimeFn = (Dart_IsPrecompiledRuntimeType)GetProcAddress(
        process, "Dart_IsPrecompiledRuntime");
    Dart_DumpNativeStackTraceFn = (Dart_DumpNativeStackTraceType)GetProcAddress(
        process, "Dart_DumpNativeStackTrace");
    Dart_PrepareToAbortFn =
        (Dart_PrepareToAbortType)GetProcAddress(process, "Dart_PrepareToAbort");
    Dart_SetDwarfStackTraceFootnoteCallbackFn =
        (Dart_SetDwarfStackTraceFootnoteCallbackType)GetProcAddress(
            process, "Dart_SetDwarfStackTraceFootnoteCallback");
    Dart_PostCObjectFn =
        (Dart_PostCObjectType)GetProcAddress(process, "Dart_PostCObject");
    Dart_PostIntegerFn =
        (Dart_PostIntegerType)GetProcAddress(process, "Dart_PostInteger");
    Dart_NewNativePortFn =
        (Dart_NewNativePortType)GetProcAddress(process, "Dart_NewNativePort");
    Dart_NewConcurrentNativePortFn =
        (Dart_NewConcurrentNativePortType)GetProcAddress(
            process, "Dart_NewConcurrentNativePort");
    Dart_CloseNativePortFn = (Dart_CloseNativePortType)GetProcAddress(
        process, "Dart_CloseNativePort");
    Dart_CompileAllFn =
        (Dart_CompileAllType)GetProcAddress(process, "Dart_CompileAll");
    Dart_FinalizeAllClassesFn = (Dart_FinalizeAllClassesType)GetProcAddress(
        process, "Dart_FinalizeAllClasses");
    Dart_ExecuteInternalCommandFn =
        (Dart_ExecuteInternalCommandType)GetProcAddress(
            process, "Dart_ExecuteInternalCommand");
  }

  return TRUE;
}

bool Dart_IsError(Dart_Handle handle) {
  return Dart_IsErrorFn(handle);
}

bool Dart_IsApiError(Dart_Handle handle) {
  return Dart_IsApiErrorFn(handle);
}

bool Dart_IsUnhandledExceptionError(Dart_Handle handle) {
  return Dart_IsUnhandledExceptionErrorFn(handle);
}

bool Dart_IsCompilationError(Dart_Handle handle) {
  return Dart_IsCompilationErrorFn(handle);
}

bool Dart_IsFatalError(Dart_Handle handle) {
  return Dart_IsFatalErrorFn(handle);
}

const char* Dart_GetError(Dart_Handle handle) {
  return Dart_GetErrorFn(handle);
}

bool Dart_ErrorHasException(Dart_Handle handle) {
  return Dart_ErrorHasExceptionFn(handle);
}

Dart_Handle Dart_ErrorGetException(Dart_Handle handle) {
  return Dart_ErrorGetExceptionFn(handle);
}

Dart_Handle Dart_ErrorGetStackTrace(Dart_Handle handle) {
  return Dart_ErrorGetStackTraceFn(handle);
}

Dart_Handle Dart_NewApiError(const char* error) {
  return Dart_NewApiErrorFn(error);
}

Dart_Handle Dart_NewCompilationError(const char* error) {
  return Dart_NewCompilationErrorFn(error);
}

Dart_Handle Dart_NewUnhandledExceptionError(Dart_Handle exception) {
  return Dart_NewUnhandledExceptionErrorFn(exception);
}

void Dart_PropagateError(Dart_Handle handle) {
  Dart_PropagateErrorFn(handle);
}

Dart_Handle Dart_ToString(Dart_Handle object) {
  return Dart_ToStringFn(object);
}

bool Dart_IdentityEquals(Dart_Handle obj1, Dart_Handle obj2) {
  return Dart_IdentityEqualsFn(obj1, obj2);
}

Dart_Handle Dart_HandleFromPersistent(Dart_PersistentHandle object) {
  return Dart_HandleFromPersistentFn(object);
}

Dart_Handle Dart_HandleFromWeakPersistent(Dart_WeakPersistentHandle object) {
  return Dart_HandleFromWeakPersistentFn(object);
}

Dart_PersistentHandle Dart_NewPersistentHandle(Dart_Handle object) {
  return Dart_NewPersistentHandleFn(object);
}

void Dart_SetPersistentHandle(Dart_PersistentHandle obj1, Dart_Handle obj2) {
  Dart_SetPersistentHandleFn(obj1, obj2);
}

void Dart_DeletePersistentHandle(Dart_PersistentHandle object) {
  Dart_DeletePersistentHandleFn(object);
}

Dart_WeakPersistentHandle Dart_NewWeakPersistentHandle(
    Dart_Handle object,
    void* peer,
    intptr_t external_allocation_size,
    Dart_HandleFinalizer callback) {
  return Dart_NewWeakPersistentHandleFn(object, peer, external_allocation_size,
                                        callback);
}

void Dart_DeleteWeakPersistentHandle(Dart_WeakPersistentHandle object) {
  Dart_DeleteWeakPersistentHandleFn(object);
}

Dart_FinalizableHandle Dart_NewFinalizableHandle(
    Dart_Handle object,
    void* peer,
    intptr_t external_allocation_size,
    Dart_HandleFinalizer callback) {
  return Dart_NewFinalizableHandleFn(object, peer, external_allocation_size,
                                     callback);
}

void Dart_DeleteFinalizableHandle(Dart_FinalizableHandle object,
                                  Dart_Handle strong_ref_to_object) {
  Dart_DeleteFinalizableHandleFn(object, strong_ref_to_object);
}

const char* Dart_VersionString() {
  return Dart_VersionStringFn();
}

void Dart_IsolateFlagsInitialize(Dart_IsolateFlags* flags) {
  Dart_IsolateFlagsInitializeFn(flags);
}

char* Dart_Initialize(Dart_InitializeParams* params) {
  return Dart_InitializeFn(params);
}

char* Dart_Cleanup() {
  return Dart_CleanupFn();
}

char* Dart_SetVMFlags(int argc, const char** argv) {
  return Dart_SetVMFlagsFn(argc, argv);
}

bool Dart_IsVMFlagSet(const char* flag_name) {
  return Dart_IsVMFlagSetFn(flag_name);
}

Dart_Isolate Dart_CreateIsolateGroup(
    const char* script_uri,
    const char* name,
    const uint8_t* isolate_snapshot_data,
    const uint8_t* isolate_snapshot_instructions,
    Dart_IsolateFlags* flags,
    void* isolate_group_data,
    void* isolate_data,
    char** error) {
  return Dart_CreateIsolateGroupFn(script_uri, name, isolate_snapshot_data,
                                   isolate_snapshot_instructions, flags,
                                   isolate_group_data, isolate_data, error);
}

Dart_Isolate Dart_CreateIsolateInGroup(
    Dart_Isolate group_member,
    const char* name,
    Dart_IsolateShutdownCallback shutdown_callback,
    Dart_IsolateCleanupCallback cleanup_callback,
    void* child_isolate_data,
    char** error) {
  return Dart_CreateIsolateInGroupFn(group_member, name, shutdown_callback,
                                     cleanup_callback, child_isolate_data,
                                     error);
}

Dart_Isolate Dart_CreateIsolateGroupFromKernel(const char* script_uri,
                                               const char* name,
                                               const uint8_t* kernel_buffer,
                                               intptr_t kernel_buffer_size,
                                               Dart_IsolateFlags* flags,
                                               void* isolate_group_data,
                                               void* isolate_data,
                                               char** error) {
  return Dart_CreateIsolateGroupFromKernelFn(
      script_uri, name, kernel_buffer, kernel_buffer_size, flags,
      isolate_group_data, isolate_data, error);
}

void Dart_ShutdownIsolate() {
  Dart_ShutdownIsolateFn();
}

Dart_Isolate Dart_CurrentIsolate() {
  return Dart_CurrentIsolateFn();
}

void* Dart_CurrentIsolateData() {
  return Dart_CurrentIsolateDataFn();
}

void* Dart_IsolateData(Dart_Isolate isolate) {
  return Dart_IsolateDataFn(isolate);
}

Dart_IsolateGroup Dart_CurrentIsolateGroup() {
  return Dart_CurrentIsolateGroupFn();
}

void* Dart_CurrentIsolateGroupData() {
  return Dart_CurrentIsolateGroupDataFn();
}

Dart_IsolateGroupId Dart_CurrentIsolateGroupId() {
  return Dart_CurrentIsolateGroupIdFn();
}

void* Dart_IsolateGroupData(Dart_Isolate isolate) {
  return Dart_IsolateGroupDataFn(isolate);
}

Dart_Handle Dart_DebugName() {
  return Dart_DebugNameFn();
}

const char* Dart_DebugNameToCString() {
  return Dart_DebugNameToCStringFn();
}

const char* Dart_IsolateServiceId(Dart_Isolate isolate) {
  return Dart_IsolateServiceIdFn(isolate);
}

void Dart_EnterIsolate(Dart_Isolate isolate) {
  Dart_EnterIsolateFn(isolate);
}

void Dart_KillIsolate(Dart_Isolate isolate) {
  Dart_KillIsolateFn(isolate);
}

void Dart_NotifyIdle(int64_t deadline) {
  Dart_NotifyIdleFn(deadline);
}

void Dart_EnableHeapSampling() {
  Dart_EnableHeapSamplingFn();
}

void Dart_DisableHeapSampling() {
  Dart_DisableHeapSamplingFn();
}

void Dart_RegisterHeapSamplingCallback(
    Dart_HeapSamplingCreateCallback create_callback,
    Dart_HeapSamplingDeleteCallback delete_callback) {
  Dart_RegisterHeapSamplingCallbackFn(create_callback, delete_callback);
}

void Dart_ReportSurvivingAllocations(Dart_HeapSamplingReportCallback callback,
                                     void* context,
                                     bool force_gc) {
  Dart_ReportSurvivingAllocationsFn(callback, context, force_gc);
}

void Dart_SetHeapSamplingPeriod(intptr_t bytes) {
  Dart_SetHeapSamplingPeriodFn(bytes);
}

void Dart_NotifyDestroyed() {
  Dart_NotifyDestroyedFn();
}

void Dart_NotifyLowMemory() {
  Dart_NotifyLowMemoryFn();
}

Dart_PerformanceMode Dart_SetPerformanceMode(Dart_PerformanceMode mode) {
  return Dart_SetPerformanceModeFn(mode);
}

void Dart_StartProfiling() {
  Dart_StartProfilingFn();
}

void Dart_StopProfiling() {
  Dart_StopProfilingFn();
}

void Dart_ThreadDisableProfiling() {
  Dart_ThreadDisableProfilingFn();
}

void Dart_ThreadEnableProfiling() {
  Dart_ThreadEnableProfilingFn();
}

void Dart_AddSymbols(const char* dso_name, void* buffer, intptr_t buffer_size) {
  Dart_AddSymbolsFn(dso_name, buffer, buffer_size);
}

void Dart_ExitIsolate() {
  Dart_ExitIsolateFn();
}

Dart_Handle Dart_CreateSnapshot(uint8_t** vm_snapshot_data_buffer,
                                intptr_t* vm_snapshot_data_size,
                                uint8_t** isolate_snapshot_data_buffer,
                                intptr_t* isolate_snapshot_data_size,
                                bool is_core) {
  return Dart_CreateSnapshotFn(vm_snapshot_data_buffer, vm_snapshot_data_size,
                               isolate_snapshot_data_buffer,
                               isolate_snapshot_data_size, is_core);
}

bool Dart_IsKernel(const uint8_t* buffer, intptr_t buffer_size) {
  return Dart_IsKernelFn(buffer, buffer_size);
}

bool Dart_IsBytecode(const uint8_t* buffer, intptr_t buffer_size) {
  return Dart_IsBytecodeFn(buffer, buffer_size);
}

char* Dart_IsolateMakeRunnable(Dart_Isolate isolate) {
  return Dart_IsolateMakeRunnableFn(isolate);
}

void Dart_SetMessageNotifyCallback(
    Dart_MessageNotifyCallback message_notify_callback) {
  Dart_SetMessageNotifyCallbackFn(message_notify_callback);
}

Dart_MessageNotifyCallback Dart_GetMessageNotifyCallback() {
  return Dart_GetMessageNotifyCallbackFn();
}

bool Dart_ShouldPauseOnStart() {
  return Dart_ShouldPauseOnStartFn();
}

void Dart_SetShouldPauseOnStart(bool should_pause) {
  Dart_SetShouldPauseOnStartFn(should_pause);
}

bool Dart_IsPausedOnStart() {
  return Dart_IsPausedOnStartFn();
}

void Dart_SetPausedOnStart(bool paused) {
  Dart_SetPausedOnStartFn(paused);
}

bool Dart_ShouldPauseOnExit() {
  return Dart_ShouldPauseOnExitFn();
}

void Dart_SetShouldPauseOnExit(bool should_pause) {
  Dart_SetShouldPauseOnExitFn(should_pause);
}

bool Dart_IsPausedOnExit() {
  return Dart_IsPausedOnExitFn();
}

void Dart_SetPausedOnExit(bool paused) {
  Dart_SetPausedOnExitFn(paused);
}

void Dart_SetStickyError(Dart_Handle error) {
  Dart_SetStickyErrorFn(error);
}

bool Dart_HasStickyError() {
  return Dart_HasStickyErrorFn();
}

Dart_Handle Dart_GetStickyError() {
  return Dart_GetStickyErrorFn();
}

Dart_Handle Dart_HandleMessage() {
  return Dart_HandleMessageFn();
}

bool Dart_HandleServiceMessages() {
  return Dart_HandleServiceMessagesFn();
}

bool Dart_HasServiceMessages() {
  return Dart_HasServiceMessagesFn();
}

Dart_Handle Dart_RunLoop() {
  return Dart_RunLoopFn();
}

bool Dart_RunLoopAsync(bool errors_are_fatal,
                       Dart_Port on_error_port,
                       Dart_Port on_exit_port,
                       char** error) {
  return Dart_RunLoopAsyncFn(errors_are_fatal, on_error_port, on_exit_port,
                             error);
}

Dart_Port Dart_GetMainPortId() {
  return Dart_GetMainPortIdFn();
}

bool Dart_HasLivePorts() {
  return Dart_HasLivePortsFn();
}

bool Dart_Post(Dart_Port port_id, Dart_Handle object) {
  return Dart_PostFn(port_id, object);
}

Dart_Handle Dart_NewSendPort(Dart_Port port_id) {
  return Dart_NewSendPortFn(port_id);
}

Dart_Handle Dart_NewSendPortEx(Dart_PortEx portex_id) {
  return Dart_NewSendPortExFn(portex_id);
}

Dart_Handle Dart_SendPortGetId(Dart_Handle port, Dart_Port* port_id) {
  return Dart_SendPortGetIdFn(port, port_id);
}

Dart_Handle Dart_SendPortGetIdEx(Dart_Handle port, Dart_PortEx* portex_id) {
  return Dart_SendPortGetIdExFn(port, portex_id);
}

void Dart_SetCurrentThreadOwnsIsolate() {
  Dart_SetCurrentThreadOwnsIsolateFn();
}

bool Dart_GetCurrentThreadOwnsIsolate(Dart_Port port) {
  return Dart_GetCurrentThreadOwnsIsolateFn(port);
}

void Dart_EnterScope() {
  Dart_EnterScopeFn();
}

void Dart_ExitScope() {
  Dart_ExitScopeFn();
}

uint8_t* Dart_ScopeAllocate(intptr_t size) {
  return Dart_ScopeAllocateFn(size);
}

Dart_Handle Dart_Null() {
  return Dart_NullFn();
}

bool Dart_IsNull(Dart_Handle object) {
  return Dart_IsNullFn(object);
}

Dart_Handle Dart_EmptyString() {
  return Dart_EmptyStringFn();
}

Dart_Handle Dart_TypeDynamic() {
  return Dart_TypeDynamicFn();
}

Dart_Handle Dart_TypeVoid() {
  return Dart_TypeVoidFn();
}

Dart_Handle Dart_TypeNever() {
  return Dart_TypeNeverFn();
}

Dart_Handle Dart_TypeString() {
  return Dart_TypeStringFn();
}

Dart_Handle Dart_TypeDouble() {
  return Dart_TypeDoubleFn();
}

Dart_Handle Dart_TypeInt() {
  return Dart_TypeIntFn();
}

Dart_Handle Dart_TypeBoolean() {
  return Dart_TypeBooleanFn();
}

Dart_Handle Dart_TypeObject() {
  return Dart_TypeObjectFn();
}

Dart_Handle Dart_ObjectEquals(Dart_Handle obj1, Dart_Handle obj2, bool* equal) {
  return Dart_ObjectEqualsFn(obj1, obj2, equal);
}

Dart_Handle Dart_ObjectIsType(Dart_Handle object,
                              Dart_Handle type,
                              bool* instanceof) {
  return Dart_ObjectIsTypeFn(object, type, instanceof);
}

bool Dart_IsInstance(Dart_Handle object) {
  return Dart_IsInstanceFn(object);
}

bool Dart_IsNumber(Dart_Handle object) {
  return Dart_IsNumberFn(object);
}

bool Dart_IsInteger(Dart_Handle object) {
  return Dart_IsIntegerFn(object);
}

bool Dart_IsDouble(Dart_Handle object) {
  return Dart_IsDoubleFn(object);
}

bool Dart_IsBoolean(Dart_Handle object) {
  return Dart_IsBooleanFn(object);
}

bool Dart_IsString(Dart_Handle object) {
  return Dart_IsStringFn(object);
}

bool Dart_IsStringLatin1(Dart_Handle object) {
  return Dart_IsStringLatin1Fn(object);
}

bool Dart_IsList(Dart_Handle object) {
  return Dart_IsListFn(object);
}

bool Dart_IsMap(Dart_Handle object) {
  return Dart_IsMapFn(object);
}

bool Dart_IsLibrary(Dart_Handle object) {
  return Dart_IsLibraryFn(object);
}

bool Dart_IsType(Dart_Handle handle) {
  return Dart_IsTypeFn(handle);
}

bool Dart_IsFunction(Dart_Handle handle) {
  return Dart_IsFunctionFn(handle);
}

bool Dart_IsVariable(Dart_Handle handle) {
  return Dart_IsVariableFn(handle);
}

bool Dart_IsTypeVariable(Dart_Handle handle) {
  return Dart_IsTypeVariableFn(handle);
}

bool Dart_IsClosure(Dart_Handle object) {
  return Dart_IsClosureFn(object);
}

bool Dart_IsTypedData(Dart_Handle object) {
  return Dart_IsTypedDataFn(object);
}

bool Dart_IsByteBuffer(Dart_Handle object) {
  return Dart_IsByteBufferFn(object);
}

bool Dart_IsFuture(Dart_Handle object) {
  return Dart_IsFutureFn(object);
}

Dart_Handle Dart_InstanceGetType(Dart_Handle instance) {
  return Dart_InstanceGetTypeFn(instance);
}

Dart_Handle Dart_ClassName(Dart_Handle cls_type) {
  return Dart_ClassNameFn(cls_type);
}

Dart_Handle Dart_FunctionName(Dart_Handle function) {
  return Dart_FunctionNameFn(function);
}

Dart_Handle Dart_FunctionOwner(Dart_Handle function) {
  return Dart_FunctionOwnerFn(function);
}

Dart_Handle Dart_FunctionIsStatic(Dart_Handle function, bool* is_static) {
  return Dart_FunctionIsStaticFn(function, is_static);
}

bool Dart_IsTearOff(Dart_Handle object) {
  return Dart_IsTearOffFn(object);
}

Dart_Handle Dart_ClosureFunction(Dart_Handle closure) {
  return Dart_ClosureFunctionFn(closure);
}

Dart_Handle Dart_ClassLibrary(Dart_Handle cls_type) {
  return Dart_ClassLibraryFn(cls_type);
}

Dart_Handle Dart_IntegerFitsIntoInt64(Dart_Handle integer, bool* fits) {
  return Dart_IntegerFitsIntoInt64Fn(integer, fits);
}

Dart_Handle Dart_IntegerFitsIntoUint64(Dart_Handle integer, bool* fits) {
  return Dart_IntegerFitsIntoUint64Fn(integer, fits);
}

Dart_Handle Dart_NewInteger(int64_t value) {
  return Dart_NewIntegerFn(value);
}

Dart_Handle Dart_NewIntegerFromUint64(uint64_t value) {
  return Dart_NewIntegerFromUint64Fn(value);
}

Dart_Handle Dart_NewIntegerFromHexCString(const char* value) {
  return Dart_NewIntegerFromHexCStringFn(value);
}

Dart_Handle Dart_IntegerToInt64(Dart_Handle integer, int64_t* value) {
  return Dart_IntegerToInt64Fn(integer, value);
}

Dart_Handle Dart_IntegerToUint64(Dart_Handle integer, uint64_t* value) {
  return Dart_IntegerToUint64Fn(integer, value);
}

Dart_Handle Dart_IntegerToHexCString(Dart_Handle integer, const char** value) {
  return Dart_IntegerToHexCStringFn(integer, value);
}

Dart_Handle Dart_NewDouble(double value) {
  return Dart_NewDoubleFn(value);
}

Dart_Handle Dart_DoubleValue(Dart_Handle double_obj, double* value) {
  return Dart_DoubleValueFn(double_obj, value);
}

Dart_Handle Dart_GetStaticMethodClosure(Dart_Handle library,
                                        Dart_Handle cls_type,
                                        Dart_Handle function_name) {
  return Dart_GetStaticMethodClosureFn(library, cls_type, function_name);
}

Dart_Handle Dart_True() {
  return Dart_TrueFn();
}

Dart_Handle Dart_False() {
  return Dart_FalseFn();
}

Dart_Handle Dart_NewBoolean(bool value) {
  return Dart_NewBooleanFn(value);
}

Dart_Handle Dart_BooleanValue(Dart_Handle boolean_obj, bool* value) {
  return Dart_BooleanValueFn(boolean_obj, value);
}

Dart_Handle Dart_StringLength(Dart_Handle str, intptr_t* length) {
  return Dart_StringLengthFn(str, length);
}

Dart_Handle Dart_StringUTF8Length(Dart_Handle str, intptr_t* length) {
  return Dart_StringUTF8LengthFn(str, length);
}

Dart_Handle Dart_NewStringFromCString(const char* str) {
  return Dart_NewStringFromCStringFn(str);
}

Dart_Handle Dart_NewStringFromUTF8(const uint8_t* utf8_array, intptr_t length) {
  return Dart_NewStringFromUTF8Fn(utf8_array, length);
}

Dart_Handle Dart_NewStringFromUTF16(const uint16_t* utf16_array,
                                    intptr_t length) {
  return Dart_NewStringFromUTF16Fn(utf16_array, length);
}

Dart_Handle Dart_NewStringFromUTF32(const int32_t* utf32_array,
                                    intptr_t length) {
  return Dart_NewStringFromUTF32Fn(utf32_array, length);
}

Dart_Handle Dart_StringToCString(Dart_Handle str, const char** cstr) {
  return Dart_StringToCStringFn(str, cstr);
}

Dart_Handle Dart_StringToUTF8(Dart_Handle str,
                              uint8_t** utf8_array,
                              intptr_t* length) {
  return Dart_StringToUTF8Fn(str, utf8_array, length);
}

Dart_Handle Dart_CopyUTF8EncodingOfString(Dart_Handle str,
                                          uint8_t* utf8_array,
                                          intptr_t length) {
  return Dart_CopyUTF8EncodingOfStringFn(str, utf8_array, length);
}

Dart_Handle Dart_StringToLatin1(Dart_Handle str,
                                uint8_t* latin1_array,
                                intptr_t* length) {
  return Dart_StringToLatin1Fn(str, latin1_array, length);
}

Dart_Handle Dart_StringToUTF16(Dart_Handle str,
                               uint16_t* utf16_array,
                               intptr_t* length) {
  return Dart_StringToUTF16Fn(str, utf16_array, length);
}

Dart_Handle Dart_StringStorageSize(Dart_Handle str, intptr_t* size) {
  return Dart_StringStorageSizeFn(str, size);
}

Dart_Handle Dart_StringGetProperties(Dart_Handle str,
                                     intptr_t* char_size,
                                     intptr_t* str_len,
                                     void** peer) {
  return Dart_StringGetPropertiesFn(str, char_size, str_len, peer);
}

Dart_Handle Dart_NewList(intptr_t length) {
  return Dart_NewListFn(length);
}

Dart_Handle Dart_NewListOfType(Dart_Handle element_type, intptr_t length) {
  return Dart_NewListOfTypeFn(element_type, length);
}

Dart_Handle Dart_NewListOfTypeFilled(Dart_Handle element_type,
                                     Dart_Handle fill_object,
                                     intptr_t length) {
  return Dart_NewListOfTypeFilledFn(element_type, fill_object, length);
}

Dart_Handle Dart_ListLength(Dart_Handle list, intptr_t* length) {
  return Dart_ListLengthFn(list, length);
}

Dart_Handle Dart_ListGetAt(Dart_Handle list, intptr_t index) {
  return Dart_ListGetAtFn(list, index);
}

Dart_Handle Dart_ListGetRange(Dart_Handle list,
                              intptr_t offset,
                              intptr_t length,
                              Dart_Handle* result) {
  return Dart_ListGetRangeFn(list, offset, length, result);
}

Dart_Handle Dart_ListSetAt(Dart_Handle list,
                           intptr_t index,
                           Dart_Handle value) {
  return Dart_ListSetAtFn(list, index, value);
}

Dart_Handle Dart_ListGetAsBytes(Dart_Handle list,
                                intptr_t offset,
                                uint8_t* native_array,
                                intptr_t length) {
  return Dart_ListGetAsBytesFn(list, offset, native_array, length);
}

Dart_Handle Dart_ListSetAsBytes(Dart_Handle list,
                                intptr_t offset,
                                const uint8_t* native_array,
                                intptr_t length) {
  return Dart_ListSetAsBytesFn(list, offset, native_array, length);
}

Dart_Handle Dart_MapGetAt(Dart_Handle map, Dart_Handle key) {
  return Dart_MapGetAtFn(map, key);
}

Dart_Handle Dart_MapContainsKey(Dart_Handle map, Dart_Handle key) {
  return Dart_MapContainsKeyFn(map, key);
}

Dart_Handle Dart_MapKeys(Dart_Handle map) {
  return Dart_MapKeysFn(map);
}

Dart_Handle Dart_NewMap(Dart_Handle keys_type,
                        Dart_Handle keys_handle,
                        Dart_Handle values_type,
                        Dart_Handle values_handle) {
  return Dart_NewMapFn(keys_type, keys_handle, values_type, values_handle);
}

Dart_TypedData_Type Dart_GetTypeOfTypedData(Dart_Handle object) {
  return Dart_GetTypeOfTypedDataFn(object);
}

Dart_TypedData_Type Dart_GetTypeOfExternalTypedData(Dart_Handle object) {
  return Dart_GetTypeOfExternalTypedDataFn(object);
}

Dart_Handle Dart_NewTypedData(Dart_TypedData_Type type, intptr_t length) {
  return Dart_NewTypedDataFn(type, length);
}

Dart_Handle Dart_NewExternalTypedData(Dart_TypedData_Type type,
                                      void* data,
                                      intptr_t length) {
  return Dart_NewExternalTypedDataFn(type, data, length);
}

Dart_Handle Dart_NewExternalTypedDataWithFinalizer(
    Dart_TypedData_Type type,
    void* data,
    intptr_t length,
    void* peer,
    intptr_t external_allocation_size,
    Dart_HandleFinalizer callback) {
  return Dart_NewExternalTypedDataWithFinalizerFn(
      type, data, length, peer, external_allocation_size, callback);
}

Dart_Handle Dart_NewUnmodifiableExternalTypedDataWithFinalizer(
    Dart_TypedData_Type type,
    const void* data,
    intptr_t length,
    void* peer,
    intptr_t external_allocation_size,
    Dart_HandleFinalizer callback) {
  return Dart_NewUnmodifiableExternalTypedDataWithFinalizerFn(
      type, data, length, peer, external_allocation_size, callback);
}

Dart_Handle Dart_NewByteBuffer(Dart_Handle typed_data) {
  return Dart_NewByteBufferFn(typed_data);
}

Dart_Handle Dart_TypedDataAcquireData(Dart_Handle object,
                                      Dart_TypedData_Type* type,
                                      void** data,
                                      intptr_t* len) {
  return Dart_TypedDataAcquireDataFn(object, type, data, len);
}

Dart_Handle Dart_TypedDataReleaseData(Dart_Handle object) {
  return Dart_TypedDataReleaseDataFn(object);
}

Dart_Handle Dart_GetDataFromByteBuffer(Dart_Handle byte_buffer) {
  return Dart_GetDataFromByteBufferFn(byte_buffer);
}

Dart_Handle Dart_New(Dart_Handle type,
                     Dart_Handle constructor_name,
                     int number_of_arguments,
                     Dart_Handle* arguments) {
  return Dart_NewFn(type, constructor_name, number_of_arguments, arguments);
}

Dart_Handle Dart_Allocate(Dart_Handle type) {
  return Dart_AllocateFn(type);
}

Dart_Handle Dart_AllocateWithNativeFields(Dart_Handle type,
                                          intptr_t num_native_fields,
                                          const intptr_t* native_fields) {
  return Dart_AllocateWithNativeFieldsFn(type, num_native_fields,
                                         native_fields);
}

Dart_Handle Dart_Invoke(Dart_Handle target,
                        Dart_Handle name,
                        int number_of_arguments,
                        Dart_Handle* arguments) {
  return Dart_InvokeFn(target, name, number_of_arguments, arguments);
}

Dart_Handle Dart_InvokeClosure(Dart_Handle closure,
                               int number_of_arguments,
                               Dart_Handle* arguments) {
  return Dart_InvokeClosureFn(closure, number_of_arguments, arguments);
}

Dart_Handle Dart_InvokeConstructor(Dart_Handle object,
                                   Dart_Handle name,
                                   int number_of_arguments,
                                   Dart_Handle* arguments) {
  return Dart_InvokeConstructorFn(object, name, number_of_arguments, arguments);
}

Dart_Handle Dart_GetField(Dart_Handle container, Dart_Handle name) {
  return Dart_GetFieldFn(container, name);
}

Dart_Handle Dart_SetField(Dart_Handle container,
                          Dart_Handle name,
                          Dart_Handle value) {
  return Dart_SetFieldFn(container, name, value);
}

Dart_Handle Dart_ThrowException(Dart_Handle exception) {
  return Dart_ThrowExceptionFn(exception);
}

Dart_Handle Dart_ReThrowException(Dart_Handle exception,
                                  Dart_Handle stacktrace) {
  return Dart_ReThrowExceptionFn(exception, stacktrace);
}

Dart_Handle Dart_GetNativeInstanceFieldCount(Dart_Handle obj, int* count) {
  return Dart_GetNativeInstanceFieldCountFn(obj, count);
}

Dart_Handle Dart_GetNativeInstanceField(Dart_Handle obj,
                                        int index,
                                        intptr_t* value) {
  return Dart_GetNativeInstanceFieldFn(obj, index, value);
}

Dart_Handle Dart_SetNativeInstanceField(Dart_Handle obj,
                                        int index,
                                        intptr_t value) {
  return Dart_SetNativeInstanceFieldFn(obj, index, value);
}

void* Dart_GetNativeIsolateGroupData(Dart_NativeArguments args) {
  return Dart_GetNativeIsolateGroupDataFn(args);
}

Dart_Handle Dart_GetNativeArguments(
    Dart_NativeArguments args,
    int num_arguments,
    const Dart_NativeArgument_Descriptor* arg_descriptors,
    Dart_NativeArgument_Value* arg_values) {
  return Dart_GetNativeArgumentsFn(args, num_arguments, arg_descriptors,
                                   arg_values);
}

Dart_Handle Dart_GetNativeArgument(Dart_NativeArguments args, int index) {
  return Dart_GetNativeArgumentFn(args, index);
}

int Dart_GetNativeArgumentCount(Dart_NativeArguments args) {
  return Dart_GetNativeArgumentCountFn(args);
}

Dart_Handle Dart_GetNativeFieldsOfArgument(Dart_NativeArguments args,
                                           int arg_index,
                                           int num_fields,
                                           intptr_t* field_values) {
  return Dart_GetNativeFieldsOfArgumentFn(args, arg_index, num_fields,
                                          field_values);
}

Dart_Handle Dart_GetNativeReceiver(Dart_NativeArguments args, intptr_t* value) {
  return Dart_GetNativeReceiverFn(args, value);
}

Dart_Handle Dart_GetNativeStringArgument(Dart_NativeArguments args,
                                         int arg_index,
                                         void** peer) {
  return Dart_GetNativeStringArgumentFn(args, arg_index, peer);
}

Dart_Handle Dart_GetNativeIntegerArgument(Dart_NativeArguments args,
                                          int index,
                                          int64_t* value) {
  return Dart_GetNativeIntegerArgumentFn(args, index, value);
}

Dart_Handle Dart_GetNativeBooleanArgument(Dart_NativeArguments args,
                                          int index,
                                          bool* value) {
  return Dart_GetNativeBooleanArgumentFn(args, index, value);
}

Dart_Handle Dart_GetNativeDoubleArgument(Dart_NativeArguments args,
                                         int index,
                                         double* value) {
  return Dart_GetNativeDoubleArgumentFn(args, index, value);
}

void Dart_SetReturnValue(Dart_NativeArguments args, Dart_Handle retval) {
  Dart_SetReturnValueFn(args, retval);
}

void Dart_SetWeakHandleReturnValue(Dart_NativeArguments args,
                                   Dart_WeakPersistentHandle rval) {
  Dart_SetWeakHandleReturnValueFn(args, rval);
}

void Dart_SetBooleanReturnValue(Dart_NativeArguments args, bool retval) {
  Dart_SetBooleanReturnValueFn(args, retval);
}

void Dart_SetIntegerReturnValue(Dart_NativeArguments args, int64_t retval) {
  Dart_SetIntegerReturnValueFn(args, retval);
}

void Dart_SetDoubleReturnValue(Dart_NativeArguments args, double retval) {
  Dart_SetDoubleReturnValueFn(args, retval);
}

Dart_Handle Dart_SetEnvironmentCallback(Dart_EnvironmentCallback callback) {
  return Dart_SetEnvironmentCallbackFn(callback);
}

Dart_Handle Dart_SetNativeResolver(Dart_Handle library,
                                   Dart_NativeEntryResolver resolver,
                                   Dart_NativeEntrySymbol symbol) {
  return Dart_SetNativeResolverFn(library, resolver, symbol);
}

Dart_Handle Dart_GetNativeResolver(Dart_Handle library,
                                   Dart_NativeEntryResolver* resolver) {
  return Dart_GetNativeResolverFn(library, resolver);
}

Dart_Handle Dart_GetNativeSymbol(Dart_Handle library,
                                 Dart_NativeEntrySymbol* resolver) {
  return Dart_GetNativeSymbolFn(library, resolver);
}

Dart_Handle Dart_SetFfiNativeResolver(Dart_Handle library,
                                      Dart_FfiNativeResolver resolver) {
  return Dart_SetFfiNativeResolverFn(library, resolver);
}

void Dart_InitializeNativeAssetsResolver(NativeAssetsApi* native_assets_api) {
  Dart_InitializeNativeAssetsResolverFn(native_assets_api);
}

Dart_Handle Dart_SetLibraryTagHandler(Dart_LibraryTagHandler handler) {
  return Dart_SetLibraryTagHandlerFn(handler);
}

Dart_Handle Dart_SetDeferredLoadHandler(Dart_DeferredLoadHandler handler) {
  return Dart_SetDeferredLoadHandlerFn(handler);
}

Dart_Handle Dart_DeferredLoadComplete(intptr_t loading_unit_id,
                                      const uint8_t* snapshot_data,
                                      const uint8_t* snapshot_instructions) {
  return Dart_DeferredLoadCompleteFn(loading_unit_id, snapshot_data,
                                     snapshot_instructions);
}

Dart_Handle Dart_DeferredLoadCompleteError(intptr_t loading_unit_id,
                                           const char* error_message,
                                           bool transient) {
  return Dart_DeferredLoadCompleteErrorFn(loading_unit_id, error_message,
                                          transient);
}

Dart_Handle Dart_LoadScriptFromKernel(const uint8_t* kernel_buffer,
                                      intptr_t kernel_size) {
  return Dart_LoadScriptFromKernelFn(kernel_buffer, kernel_size);
}

Dart_Handle Dart_LoadScriptFromBytecode(const uint8_t* kernel_buffer,
                                        intptr_t kernel_size) {
  return Dart_LoadScriptFromBytecodeFn(kernel_buffer, kernel_size);
}

Dart_Handle Dart_RootLibrary() {
  return Dart_RootLibraryFn();
}

Dart_Handle Dart_SetRootLibrary(Dart_Handle library) {
  return Dart_SetRootLibraryFn(library);
}

Dart_Handle Dart_GetType(Dart_Handle library,
                         Dart_Handle class_name,
                         intptr_t number_of_type_arguments,
                         Dart_Handle* type_arguments) {
  return Dart_GetTypeFn(library, class_name, number_of_type_arguments,
                        type_arguments);
}

Dart_Handle Dart_GetNullableType(Dart_Handle library,
                                 Dart_Handle class_name,
                                 intptr_t number_of_type_arguments,
                                 Dart_Handle* type_arguments) {
  return Dart_GetNullableTypeFn(library, class_name, number_of_type_arguments,
                                type_arguments);
}

Dart_Handle Dart_GetNonNullableType(Dart_Handle library,
                                    Dart_Handle class_name,
                                    intptr_t number_of_type_arguments,
                                    Dart_Handle* type_arguments) {
  return Dart_GetNonNullableTypeFn(library, class_name,
                                   number_of_type_arguments, type_arguments);
}

Dart_Handle Dart_TypeToNullableType(Dart_Handle type) {
  return Dart_TypeToNullableTypeFn(type);
}

Dart_Handle Dart_TypeToNonNullableType(Dart_Handle type) {
  return Dart_TypeToNonNullableTypeFn(type);
}

Dart_Handle Dart_IsNullableType(Dart_Handle type, bool* result) {
  return Dart_IsNullableTypeFn(type, result);
}

Dart_Handle Dart_IsNonNullableType(Dart_Handle type, bool* result) {
  return Dart_IsNonNullableTypeFn(type, result);
}

Dart_Handle Dart_GetClass(Dart_Handle library, Dart_Handle class_name) {
  return Dart_GetClassFn(library, class_name);
}

Dart_Handle Dart_LibraryUrl(Dart_Handle library) {
  return Dart_LibraryUrlFn(library);
}

Dart_Handle Dart_LibraryResolvedUrl(Dart_Handle library) {
  return Dart_LibraryResolvedUrlFn(library);
}

Dart_Handle Dart_GetLoadedLibraries() {
  return Dart_GetLoadedLibrariesFn();
}

Dart_Handle Dart_LookupLibrary(Dart_Handle url) {
  return Dart_LookupLibraryFn(url);
}

Dart_Handle Dart_LibraryHandleError(Dart_Handle library, Dart_Handle error) {
  return Dart_LibraryHandleErrorFn(library, error);
}

Dart_Handle Dart_LoadLibraryFromKernel(const uint8_t* kernel_buffer,
                                       intptr_t kernel_buffer_size) {
  return Dart_LoadLibraryFromKernelFn(kernel_buffer, kernel_buffer_size);
}

Dart_Handle Dart_LoadLibrary(Dart_Handle kernel_buffer) {
  return Dart_LoadLibraryFn(kernel_buffer);
}

Dart_Handle Dart_LoadLibraryFromBytecode(Dart_Handle bytecode_buffer) {
  return Dart_LoadLibraryFromBytecodeFn(bytecode_buffer);
}

Dart_Handle Dart_FinalizeLoading(bool complete_futures) {
  return Dart_FinalizeLoadingFn(complete_futures);
}

Dart_Handle Dart_GetPeer(Dart_Handle object, void** peer) {
  return Dart_GetPeerFn(object, peer);
}

Dart_Handle Dart_SetPeer(Dart_Handle object, void* peer) {
  return Dart_SetPeerFn(object, peer);
}

bool Dart_IsKernelIsolate(Dart_Isolate isolate) {
  return Dart_IsKernelIsolateFn(isolate);
}

bool Dart_KernelIsolateIsRunning() {
  return Dart_KernelIsolateIsRunningFn();
}

Dart_Port Dart_KernelPort() {
  return Dart_KernelPortFn();
}

Dart_KernelCompilationResult Dart_CompileToKernel(
    const char* script_uri,
    const uint8_t* platform_kernel,
    const intptr_t platform_kernel_size,
    bool incremental_compile,
    bool snapshot_compile,
    bool embed_sources,
    const char* package_config,
    Dart_KernelCompilationVerbosityLevel verbosity) {
  return Dart_CompileToKernelFn(
      script_uri, platform_kernel, platform_kernel_size, incremental_compile,
      snapshot_compile, embed_sources, package_config, verbosity);
}

Dart_KernelCompilationResult Dart_KernelListDependencies() {
  return Dart_KernelListDependenciesFn();
}

void Dart_SetDartLibrarySourcesKernel(const uint8_t* platform_kernel,
                                      const intptr_t platform_kernel_size) {
  Dart_SetDartLibrarySourcesKernelFn(platform_kernel, platform_kernel_size);
}

bool Dart_DetectNullSafety(const char* script_uri,
                           const char* package_config,
                           const char* original_working_directory,
                           const uint8_t* snapshot_data,
                           const uint8_t* snapshot_instructions,
                           const uint8_t* kernel_buffer,
                           intptr_t kernel_buffer_size) {
  return Dart_DetectNullSafetyFn(
      script_uri, package_config, original_working_directory, snapshot_data,
      snapshot_instructions, kernel_buffer, kernel_buffer_size);
}

bool Dart_IsServiceIsolate(Dart_Isolate isolate) {
  return Dart_IsServiceIsolateFn(isolate);
}

bool Dart_WriteProfileToTimeline(Dart_Port main_port, char** error) {
  return Dart_WriteProfileToTimelineFn(main_port, error);
}

Dart_Handle Dart_Precompile() {
  return Dart_PrecompileFn();
}

Dart_Handle Dart_LoadingUnitLibraryUris(intptr_t loading_unit_id) {
  return Dart_LoadingUnitLibraryUrisFn(loading_unit_id);
}

Dart_Handle Dart_CreateAppAOTSnapshotAsAssembly(
    Dart_StreamingWriteCallback callback,
    void* callback_data,
    bool stripped,
    void* debug_callback_data) {
  return Dart_CreateAppAOTSnapshotAsAssemblyFn(callback, callback_data,
                                               stripped, debug_callback_data);
}

Dart_Handle Dart_CreateAppAOTSnapshotAsAssemblies(
    Dart_CreateLoadingUnitCallback next_callback,
    void* next_callback_data,
    bool stripped,
    Dart_StreamingWriteCallback write_callback,
    Dart_StreamingCloseCallback close_callback) {
  return Dart_CreateAppAOTSnapshotAsAssembliesFn(
      next_callback, next_callback_data, stripped, write_callback,
      close_callback);
}

Dart_Handle Dart_CreateAppAOTSnapshotAsElf(Dart_StreamingWriteCallback callback,
                                           void* callback_data,
                                           bool stripped,
                                           void* debug_callback_data) {
  return Dart_CreateAppAOTSnapshotAsElfFn(callback, callback_data, stripped,
                                          debug_callback_data);
}

Dart_Handle Dart_CreateAppAOTSnapshotAsElfs(
    Dart_CreateLoadingUnitCallback next_callback,
    void* next_callback_data,
    bool stripped,
    Dart_StreamingWriteCallback write_callback,
    Dart_StreamingCloseCallback close_callback) {
  return Dart_CreateAppAOTSnapshotAsElfsFn(next_callback, next_callback_data,
                                           stripped, write_callback,
                                           close_callback);
}

Dart_Handle Dart_CreateAppAOTSnapshotAsBinary(
    Dart_AotBinaryFormat format,
    Dart_StreamingWriteCallback callback,
    void* callback_data,
    bool stripped,
    void* debug_callback_data,
    const char* identifier,
    const char* path) {
  return Dart_CreateAppAOTSnapshotAsBinaryFn(format, callback, callback_data,
                                             stripped, debug_callback_data,
                                             identifier, path);
}

Dart_Handle Dart_CreateVMAOTSnapshotAsAssembly(
    Dart_StreamingWriteCallback callback,
    void* callback_data) {
  return Dart_CreateVMAOTSnapshotAsAssemblyFn(callback, callback_data);
}

Dart_Handle Dart_SortClasses() {
  return Dart_SortClassesFn();
}

Dart_Handle Dart_CreateAppJITSnapshotAsBlobs(
    uint8_t** isolate_snapshot_data_buffer,
    intptr_t* isolate_snapshot_data_size,
    uint8_t** isolate_snapshot_instructions_buffer,
    intptr_t* isolate_snapshot_instructions_size) {
  return Dart_CreateAppJITSnapshotAsBlobsFn(
      isolate_snapshot_data_buffer, isolate_snapshot_data_size,
      isolate_snapshot_instructions_buffer, isolate_snapshot_instructions_size);
}

Dart_Handle Dart_GetObfuscationMap(uint8_t** buffer, intptr_t* buffer_length) {
  return Dart_GetObfuscationMapFn(buffer, buffer_length);
}

bool Dart_IsPrecompiledRuntime() {
  return Dart_IsPrecompiledRuntimeFn();
}

void Dart_DumpNativeStackTrace(void* context) {
  Dart_DumpNativeStackTraceFn(context);
}

void Dart_PrepareToAbort() {
  Dart_PrepareToAbortFn();
}

void Dart_SetDwarfStackTraceFootnoteCallback(
    Dart_DwarfStackTraceFootnoteCallback callback) {
  Dart_SetDwarfStackTraceFootnoteCallbackFn(callback);
}

bool Dart_PostCObject(Dart_Port port_id, Dart_CObject* message) {
  return Dart_PostCObjectFn(port_id, message);
}

bool Dart_PostInteger(Dart_Port port_id, int64_t message) {
  return Dart_PostIntegerFn(port_id, message);
}

Dart_Port Dart_NewNativePort(const char* name,
                             Dart_NativeMessageHandler handler,
                             bool handle_concurrently) {
  return Dart_NewNativePortFn(name, handler, handle_concurrently);
}

Dart_Port Dart_NewConcurrentNativePort(const char* name,
                                       Dart_NativeMessageHandler handler,
                                       intptr_t max_concurrency) {
  return Dart_NewConcurrentNativePortFn(name, handler, max_concurrency);
}

bool Dart_CloseNativePort(Dart_Port native_port_id) {
  return Dart_CloseNativePortFn(native_port_id);
}

Dart_Handle Dart_CompileAll() {
  return Dart_CompileAllFn();
}

Dart_Handle Dart_FinalizeAllClasses() {
  return Dart_FinalizeAllClassesFn();
}

void* Dart_ExecuteInternalCommand(const char* command, void* arg) {
  return Dart_ExecuteInternalCommandFn(command, arg);
}
