// Copyright (c) 2025, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// Regression test for https://dartbug.com/57048.

import 'dart:developer' show debugger;

import 'package:test/test.dart';
import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/evaluate_uninitialized_late_variable_test.dart
//
const LINE_A = 29;
// AUTOGENERATED END

({int? a}) getRecord() => (a: 1);

void testeeMain() {
  // ignore: prefer_final_locals
  late var x = getRecord();
  debugger(); // LINE_A
  print(x.a);
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    try {
      print(await service.evaluateInFrame(isolateId, 0, 'x.a'));
      fail('Expected evaluateInFrame to throw an RPCError');
    } on RPCError catch (e) {
      // TODO(57048): We currently pretend that uninitialized late variables
      // don't exist to avoid crashing when evaluating expressions that need to
      // access the late variables' values. The CFE team is working on a better
      // solution.
      expect(e.code, RPCErrorKind.kExpressionCompilationError.code);
      expect(e.message, 'Expression compilation error');
      expect(
        e.details,
        contains("Error: The variable 'x' "
            'is unavailable in this expression evaluation.'),
      );
    }
  },
];

Future<void> main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'evaluate_uninitialized_late_variable_test.dart',
      testeeConcurrent: testeeMain,
    );
