// Copyright (c) 2021, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

class S1 {
  int s;
  S1([int x = 0]) : s = x - 1;
}

class C1 extends S1 {
  int c;
  C1([super.x]) : c = x + 1; // Ok.
}

class S2 {
  int s;
  S2({int x = 0}) : s = x - 1;
}

class C2 extends S2 {
  int c;
  C2({super.x}) : c = x + 1; // Ok.
}

class S3 {
  int s;
  S3([int x = 0]) : s = x - 1;
}

class C3 extends S3 {
  int c;
  C3([super.x = 42]) : c = x + 1; // Ok.
}

class S4 {
  int s;
  S4({int x = 0}) : s = x - 1;
}

class C4 extends S4 {
  int c;
  C4({super.x = 42}) : c = x + 1; // Ok.
}

class S5 {
  num a;
  S5([num x = 3.14]) : a = x - 1;
}

class C5 extends S5 {
  C5([int super.x]); // Error.
}

class S6 {
  num? a;
  S6([num? x = 3.14]) : a = x;
}

class C6 extends S6 {
  int? b;
  C6([int? super.x]); // Ok.
}

class D6 extends C6 {
  D6([int super.x]); // Error
}

class S7 {
  int s;
  S7([int x = 0]) : s = x - 1;
}

class C7 extends S7 {
  int c;
  C7([super.x]) : c = x + 1;
}

class CC7 extends C7 {
  int cc;
  CC7([super.x]) : cc = x * 1;
}

class S8 {
  int s;
  S8([int x = 0]) : s = x - 1;
}

class CC8 extends C8 {
  int cc;
  CC8([super.x]) : cc = x * 1;
}

class C8 extends S8 {
  int c;
  C8([super.x]) : c = x + 1;
}

class CC9 extends C9 {
  int cc;
  CC9([super.x]) : cc = x * 1;
}

class C9 extends S9 {
  int c;
  C9([super.x]) : c = x + 1;
}

class S9 {
  int s;
  S9([int x = 0]) : s = x - 1;
}

class S5b {
  num a;
  S5b({num x = 3.14}) : a = x - 1;
}

class C5b extends S5b {
  C5b({int super.x}); // Error.
}

class S6b {
  num? a;
  S6b({num? x = 3.14}) : a = x;
}

class C6b extends S6b {
  int? b;
  C6b({int? super.x}); // Ok.
}

class D6b extends C6b {
  D6b({int super.x}); // Error
}

class S7b {
  int s;
  S7b({int x = 0}) : s = x - 1;
}

class C7b extends S7b {
  int c;
  C7b({super.x}) : c = x + 1;
}

class CC7b extends C7b {
  int cc;
  CC7b({super.x}) : cc = x * 1;
}

class S8b {
  final int s;
  const S8b({int x = 0}) : s = x - 1;
}

class CC8b extends C8b {
  final int cc;
  const CC8b({super.x}) : cc = x * 1;
}

class C8b extends S8b {
  final int c;
  const C8b({super.x}) : c = x + 1;
}

class CC9b extends C9b {
  int cc;
  CC9b({super.x}) : cc = x * 1;
}

class C9b extends S9b {
  int c;
  C9b({super.x}) : c = x + 1;
}

class S9b {
  int s;
  S9b({int x = 0}) : s = x - 1;
}

class Ap {
  Ap([num x = 3.14]);
}

class Bp extends Ap {
  Bp([int super.x]); // Error.
  Bp.req(int super.x); // Ok.
}

class An {
  An({num x = 3.14});
}

class Bn extends An {
  Bn({int super.x}); // Error.
  Bn.req({required int super.x}); // Ok.
}

main() {}
