// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:_fe_analyzer_shared/src/experiments/flags.dart';
import 'package:_fe_analyzer_shared/src/parser/assert.dart';
import 'package:_fe_analyzer_shared/src/parser/block_kind.dart';
import 'package:_fe_analyzer_shared/src/parser/constructor_reference_context.dart';
import 'package:_fe_analyzer_shared/src/parser/declaration_kind.dart';
import 'package:_fe_analyzer_shared/src/parser/directive_context.dart';
import 'package:_fe_analyzer_shared/src/parser/formal_parameter_kind.dart';
import 'package:_fe_analyzer_shared/src/parser/identifier_context.dart';
import 'package:_fe_analyzer_shared/src/parser/listener.dart' show Listener;
import 'package:_fe_analyzer_shared/src/parser/member_kind.dart';
import 'package:_fe_analyzer_shared/src/parser/parser.dart'
    show ConstantPatternContext, Parser;
import 'package:_fe_analyzer_shared/src/parser/parser_impl.dart'
    show AwaitOrYieldContext, ForPartsContext, PatternContext;
import 'package:_fe_analyzer_shared/src/parser/token_stream_rewriter.dart';
import 'package:_fe_analyzer_shared/src/parser/type_info.dart';
import 'package:_fe_analyzer_shared/src/scanner/token.dart';
import 'package:front_end/src/codes/cfe_codes.dart' as codes;
import 'package:front_end/src/source/diet_parser.dart'
    show useImplicitCreationExpressionInCfe;

// THIS FILE IS AUTO GENERATED BY 'test/parser_test_parser_creator.dart'
// Run this command to update it:
// 'dart pkg/front_end/test/parser_test_parser_creator.dart'

class TestParser extends Parser {
  int indent = 0;
  StringBuffer sb = new StringBuffer();
  final bool trace;
  bool _inhibitPrinting = false;

  TestParser(
    Listener listener,
    this.trace, {
    required bool allowPatterns,
    required bool enableEnhancedParts,
  }) : super(
         listener,
         useImplicitCreationExpression: useImplicitCreationExpressionInCfe,
         allowPatterns: allowPatterns,
         enableFeatureEnhancedParts: enableEnhancedParts,
       );

  String createTrace() {
    List<String> traceLines = StackTrace.current.toString().split("\n");
    for (int i = 0; i < traceLines.length; i++) {
      // Find first one that's not any of the denylisted ones.
      String line = traceLines[i];
      if (line.contains("parser_test_listener.dart:") ||
          line.contains("parser_suite.dart:") ||
          line.contains("parser_test_parser.dart:") ||
          line == "<asynchronous suspension>") {
        continue;
      }
      return line.substring(line.indexOf("(") + 1, line.lastIndexOf(")"));
    }
    return "N/A";
  }

  void doPrint(String s) {
    if (_inhibitPrinting) return;
    String traceString = "";
    if (trace) traceString = " (${createTrace()})";
    sb.writeln(("  " * indent) + s + traceString);
  }

  @override
  T inhibitPrinting<T>(T Function() callback) {
    bool previousInhibitPrinting = _inhibitPrinting;
    _inhibitPrinting = true;
    try {
      return callback();
    } finally {
      _inhibitPrinting = previousInhibitPrinting;
    }
  }

  @override
  Uri? get uri {
    doPrint('uri()');
    indent++;
    var result = super.uri;
    indent--;
    return result;
  }

  @override
  TokenStreamRewriter get rewriter {
    doPrint('rewriter()');
    indent++;
    var result = super.rewriter;
    indent--;
    return result;
  }

  @override
  bool get allowedToShortcutParseExpression {
    doPrint('allowedToShortcutParseExpression()');
    indent++;
    var result = super.allowedToShortcutParseExpression;
    indent--;
    return result;
  }

  @override
  bool get inGenerator {
    doPrint('inGenerator()');
    indent++;
    var result = super.inGenerator;
    indent--;
    return result;
  }

  @override
  bool get inAsync {
    doPrint('inAsync()');
    indent++;
    var result = super.inAsync;
    indent--;
    return result;
  }

  @override
  bool get inPlainSync {
    doPrint('inPlainSync()');
    indent++;
    var result = super.inPlainSync;
    indent--;
    return result;
  }

  @override
  bool get isBreakAllowed {
    doPrint('isBreakAllowed()');
    indent++;
    var result = super.isBreakAllowed;
    indent--;
    return result;
  }

  @override
  bool get isContinueAllowed {
    doPrint('isContinueAllowed()');
    indent++;
    var result = super.isContinueAllowed;
    indent--;
    return result;
  }

  @override
  bool get isContinueWithLabelAllowed {
    doPrint('isContinueWithLabelAllowed()');
    indent++;
    var result = super.isContinueWithLabelAllowed;
    indent--;
    return result;
  }

  @override
  Token parseUnit(Token token) {
    doPrint(
      'parseUnit('
      '$token)',
    );
    indent++;
    var result = super.parseUnit(token);
    indent--;
    return result;
  }

  @override
  Token parseDirectives(Token token) {
    doPrint(
      'parseDirectives('
      '$token)',
    );
    indent++;
    var result = super.parseDirectives(token);
    indent--;
    return result;
  }

  @override
  Token parseTopLevelDeclaration(Token token) {
    doPrint(
      'parseTopLevelDeclaration('
      '$token)',
    );
    indent++;
    var result = super.parseTopLevelDeclaration(token);
    indent--;
    return result;
  }

  @override
  Token parseTopLevelDeclarationImpl(
    Token token,
    DirectiveContext? directiveState,
  ) {
    doPrint(
      'parseTopLevelDeclarationImpl('
      '$token, '
      '$directiveState)',
    );
    indent++;
    var result = super.parseTopLevelDeclarationImpl(token, directiveState);
    indent--;
    return result;
  }

  @override
  Token parseTopLevelKeywordDeclaration(
    Token beginToken,
    Token modifierStart,
    Token keyword,
    Token? macroToken,
    Token? sealedToken,
    Token? baseToken,
    Token? interfaceToken,
    DirectiveContext? directiveState,
  ) {
    doPrint(
      'parseTopLevelKeywordDeclaration('
      '$beginToken, '
      '$modifierStart, '
      '$keyword, '
      '$macroToken, '
      '$sealedToken, '
      '$baseToken, '
      '$interfaceToken, '
      '$directiveState)',
    );
    indent++;
    var result = super.parseTopLevelKeywordDeclaration(
      beginToken,
      modifierStart,
      keyword,
      macroToken,
      sealedToken,
      baseToken,
      interfaceToken,
      directiveState,
    );
    indent--;
    return result;
  }

  @override
  Token parseLibraryAugmentation(Token augmentKeyword, Token libraryKeyword) {
    doPrint(
      'parseLibraryAugmentation('
      '$augmentKeyword, '
      '$libraryKeyword)',
    );
    indent++;
    var result = super.parseLibraryAugmentation(augmentKeyword, libraryKeyword);
    indent--;
    return result;
  }

  @override
  Token parseLibraryName(Token libraryKeyword) {
    doPrint(
      'parseLibraryName('
      '$libraryKeyword)',
    );
    indent++;
    var result = super.parseLibraryName(libraryKeyword);
    indent--;
    return result;
  }

  @override
  Token parseImportPrefixOpt(Token token) {
    doPrint(
      'parseImportPrefixOpt('
      '$token)',
    );
    indent++;
    var result = super.parseImportPrefixOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseImport(Token importKeyword) {
    doPrint(
      'parseImport('
      '$importKeyword)',
    );
    indent++;
    var result = super.parseImport(importKeyword);
    indent--;
    return result;
  }

  @override
  Token parseImportRecovery(Token token) {
    doPrint(
      'parseImportRecovery('
      '$token)',
    );
    indent++;
    var result = super.parseImportRecovery(token);
    indent--;
    return result;
  }

  @override
  Token parseConditionalUriStar(Token token) {
    doPrint(
      'parseConditionalUriStar('
      '$token)',
    );
    indent++;
    var result = super.parseConditionalUriStar(token);
    indent--;
    return result;
  }

  @override
  Token parseConditionalUri(Token token) {
    doPrint(
      'parseConditionalUri('
      '$token)',
    );
    indent++;
    var result = super.parseConditionalUri(token);
    indent--;
    return result;
  }

  @override
  Token parseDottedName(Token token) {
    doPrint(
      'parseDottedName('
      '$token)',
    );
    indent++;
    var result = super.parseDottedName(token);
    indent--;
    return result;
  }

  @override
  Token parseExport(Token exportKeyword) {
    doPrint(
      'parseExport('
      '$exportKeyword)',
    );
    indent++;
    var result = super.parseExport(exportKeyword);
    indent--;
    return result;
  }

  @override
  Token parseCombinatorStar(Token token) {
    doPrint(
      'parseCombinatorStar('
      '$token)',
    );
    indent++;
    var result = super.parseCombinatorStar(token);
    indent--;
    return result;
  }

  @override
  Token parseHide(Token token) {
    doPrint(
      'parseHide('
      '$token)',
    );
    indent++;
    var result = super.parseHide(token);
    indent--;
    return result;
  }

  @override
  Token parseShow(Token token) {
    doPrint(
      'parseShow('
      '$token)',
    );
    indent++;
    var result = super.parseShow(token);
    indent--;
    return result;
  }

  @override
  Token parseIdentifierList(Token token) {
    doPrint(
      'parseIdentifierList('
      '$token)',
    );
    indent++;
    var result = super.parseIdentifierList(token);
    indent--;
    return result;
  }

  @override
  Token parseTypeList(Token token) {
    doPrint(
      'parseTypeList('
      '$token)',
    );
    indent++;
    var result = super.parseTypeList(token);
    indent--;
    return result;
  }

  @override
  Token parsePartOrPartOf(Token partKeyword, DirectiveContext? directiveState) {
    doPrint(
      'parsePartOrPartOf('
      '$partKeyword, '
      '$directiveState)',
    );
    indent++;
    var result = super.parsePartOrPartOf(partKeyword, directiveState);
    indent--;
    return result;
  }

  @override
  Token parsePart(Token partKeyword) {
    doPrint(
      'parsePart('
      '$partKeyword)',
    );
    indent++;
    var result = super.parsePart(partKeyword);
    indent--;
    return result;
  }

  @override
  Token parsePartOf(Token partKeyword) {
    doPrint(
      'parsePartOf('
      '$partKeyword)',
    );
    indent++;
    var result = super.parsePartOf(partKeyword);
    indent--;
    return result;
  }

  @override
  Token parseMetadataStar(Token token) {
    doPrint(
      'parseMetadataStar('
      '$token)',
    );
    indent++;
    var result = super.parseMetadataStar(token);
    indent--;
    return result;
  }

  @override
  Token parseMetadata(Token token) {
    doPrint(
      'parseMetadata('
      '$token)',
    );
    indent++;
    var result = super.parseMetadata(token);
    indent--;
    return result;
  }

  @override
  Token parseScript(Token token) {
    doPrint(
      'parseScript('
      '$token)',
    );
    indent++;
    var result = super.parseScript(token);
    indent--;
    return result;
  }

  @override
  Token parseTypedef(Token? augmentToken, Token typedefKeyword) {
    doPrint(
      'parseTypedef('
      '$augmentToken, '
      '$typedefKeyword)',
    );
    indent++;
    var result = super.parseTypedef(augmentToken, typedefKeyword);
    indent--;
    return result;
  }

  @override
  Token parseMixinApplicationRest(Token token) {
    doPrint(
      'parseMixinApplicationRest('
      '$token)',
    );
    indent++;
    var result = super.parseMixinApplicationRest(token);
    indent--;
    return result;
  }

  @override
  Token parseClassWithClauseOpt(Token token) {
    doPrint(
      'parseClassWithClauseOpt('
      '$token)',
    );
    indent++;
    var result = super.parseClassWithClauseOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseEnumWithClauseOpt(Token token) {
    doPrint(
      'parseEnumWithClauseOpt('
      '$token)',
    );
    indent++;
    var result = super.parseEnumWithClauseOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseGetterOrFormalParameters(
    Token token,
    Token name,
    bool isGetter,
    MemberKind kind,
  ) {
    doPrint(
      'parseGetterOrFormalParameters('
      '$token, '
      '$name, '
      '$isGetter, '
      '$kind)',
    );
    indent++;
    var result = super.parseGetterOrFormalParameters(
      token,
      name,
      isGetter,
      kind,
    );
    indent--;
    return result;
  }

  @override
  Token parseFormalParametersOpt(Token token, MemberKind kind) {
    doPrint(
      'parseFormalParametersOpt('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.parseFormalParametersOpt(token, kind);
    indent--;
    return result;
  }

  @override
  Token skipFormalParameters(Token token, MemberKind kind) {
    doPrint(
      'skipFormalParameters('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.skipFormalParameters(token, kind);
    indent--;
    return result;
  }

  @override
  Token skipFormalParametersRest(Token token, MemberKind kind) {
    doPrint(
      'skipFormalParametersRest('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.skipFormalParametersRest(token, kind);
    indent--;
    return result;
  }

  @override
  Token parseRecordType(
    final Token start,
    Token token,
    bool isQuestionMarkPartOfType,
  ) {
    doPrint(
      'parseRecordType('
      '$start, '
      '$token, '
      '$isQuestionMarkPartOfType)',
    );
    indent++;
    var result = super.parseRecordType(start, token, isQuestionMarkPartOfType);
    indent--;
    return result;
  }

  @override
  Token parseRecordTypeField(
    Token token, {
    required bool identifierIsOptional,
  }) {
    doPrint(
      'parseRecordTypeField('
      '$token, '
      'identifierIsOptional: $identifierIsOptional)',
    );
    indent++;
    var result = super.parseRecordTypeField(
      token,
      identifierIsOptional: identifierIsOptional,
    );
    indent--;
    return result;
  }

  @override
  Token parseRecordTypeNamedFields(Token token) {
    doPrint(
      'parseRecordTypeNamedFields('
      '$token)',
    );
    indent++;
    var result = super.parseRecordTypeNamedFields(token);
    indent--;
    return result;
  }

  @override
  Token parseFormalParametersRequiredOpt(Token token, MemberKind kind) {
    doPrint(
      'parseFormalParametersRequiredOpt('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.parseFormalParametersRequiredOpt(token, kind);
    indent--;
    return result;
  }

  @override
  Token parseFormalParameters(Token token, MemberKind kind) {
    doPrint(
      'parseFormalParameters('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.parseFormalParameters(token, kind);
    indent--;
    return result;
  }

  @override
  Token parseFormalParametersRest(Token token, MemberKind kind) {
    doPrint(
      'parseFormalParametersRest('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.parseFormalParametersRest(token, kind);
    indent--;
    return result;
  }

  @override
  codes.Message missingParameterMessage(MemberKind kind) {
    doPrint(
      'missingParameterMessage('
      '$kind)',
    );
    indent++;
    var result = super.missingParameterMessage(kind);
    indent--;
    return result;
  }

  @override
  Token parseFormalParameter(
    Token token,
    FormalParameterKind parameterKind,
    MemberKind memberKind,
  ) {
    doPrint(
      'parseFormalParameter('
      '$token, '
      '$parameterKind, '
      '$memberKind)',
    );
    indent++;
    var result = super.parseFormalParameter(token, parameterKind, memberKind);
    indent--;
    return result;
  }

  @override
  Token parseOptionalPositionalParameters(Token token, MemberKind kind) {
    doPrint(
      'parseOptionalPositionalParameters('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.parseOptionalPositionalParameters(token, kind);
    indent--;
    return result;
  }

  @override
  Token parseOptionalNamedParameters(Token token, MemberKind kind) {
    doPrint(
      'parseOptionalNamedParameters('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.parseOptionalNamedParameters(token, kind);
    indent--;
    return result;
  }

  @override
  Token parseQualified(
    Token token,
    IdentifierContext context,
    IdentifierContext continuationContext,
  ) {
    doPrint(
      'parseQualified('
      '$token, '
      '$context, '
      '$continuationContext)',
    );
    indent++;
    var result = super.parseQualified(token, context, continuationContext);
    indent--;
    return result;
  }

  @override
  Token parseQualifiedRestOpt(
    Token token,
    IdentifierContext continuationContext,
  ) {
    doPrint(
      'parseQualifiedRestOpt('
      '$token, '
      '$continuationContext)',
    );
    indent++;
    var result = super.parseQualifiedRestOpt(token, continuationContext);
    indent--;
    return result;
  }

  @override
  Token parseQualifiedRest(Token token, IdentifierContext context) {
    doPrint(
      'parseQualifiedRest('
      '$token, '
      '$context)',
    );
    indent++;
    var result = super.parseQualifiedRest(token, context);
    indent--;
    return result;
  }

  @override
  Token skipBlock(Token token) {
    doPrint(
      'skipBlock('
      '$token)',
    );
    indent++;
    var result = super.skipBlock(token);
    indent--;
    return result;
  }

  @override
  Token parseEnum(Token beginToken, Token? augmentToken, Token enumKeyword) {
    doPrint(
      'parseEnum('
      '$beginToken, '
      '$augmentToken, '
      '$enumKeyword)',
    );
    indent++;
    var result = super.parseEnum(beginToken, augmentToken, enumKeyword);
    indent--;
    return result;
  }

  @override
  Token parseEnumHeaderOpt(Token token, Token enumKeyword) {
    doPrint(
      'parseEnumHeaderOpt('
      '$token, '
      '$enumKeyword)',
    );
    indent++;
    var result = super.parseEnumHeaderOpt(token, enumKeyword);
    indent--;
    return result;
  }

  @override
  Token? recoveryEnumWith(Token token, codes.Message message) {
    doPrint(
      'recoveryEnumWith('
      '$token, '
      '$message)',
    );
    indent++;
    var result = super.recoveryEnumWith(token, message);
    indent--;
    return result;
  }

  @override
  Token? recoveryEnumImplements(Token token, codes.Message message) {
    doPrint(
      'recoveryEnumImplements('
      '$token, '
      '$message)',
    );
    indent++;
    var result = super.recoveryEnumImplements(token, message);
    indent--;
    return result;
  }

  @override
  Token? recoverySmallLookAheadSkipTokens(
    final Token token,
    List<TokenType> lookFor,
  ) {
    doPrint(
      'recoverySmallLookAheadSkipTokens('
      '$token, '
      '$lookFor)',
    );
    indent++;
    var result = super.recoverySmallLookAheadSkipTokens(token, lookFor);
    indent--;
    return result;
  }

  @override
  Token parseEnumElement(Token token) {
    doPrint(
      'parseEnumElement('
      '$token)',
    );
    indent++;
    var result = super.parseEnumElement(token);
    indent--;
    return result;
  }

  @override
  Token parseClassOrNamedMixinApplication(
    Token beginToken,
    Token? abstractToken,
    Token? macroToken,
    Token? sealedToken,
    Token? baseToken,
    Token? interfaceToken,
    Token? finalToken,
    Token? augmentToken,
    Token? mixinToken,
    Token classKeyword,
  ) {
    doPrint(
      'parseClassOrNamedMixinApplication('
      '$beginToken, '
      '$abstractToken, '
      '$macroToken, '
      '$sealedToken, '
      '$baseToken, '
      '$interfaceToken, '
      '$finalToken, '
      '$augmentToken, '
      '$mixinToken, '
      '$classKeyword)',
    );
    indent++;
    var result = super.parseClassOrNamedMixinApplication(
      beginToken,
      abstractToken,
      macroToken,
      sealedToken,
      baseToken,
      interfaceToken,
      finalToken,
      augmentToken,
      mixinToken,
      classKeyword,
    );
    indent--;
    return result;
  }

  @override
  Token parseNamedMixinApplication(
    Token token,
    Token begin,
    Token classKeyword,
  ) {
    doPrint(
      'parseNamedMixinApplication('
      '$token, '
      '$begin, '
      '$classKeyword)',
    );
    indent++;
    var result = super.parseNamedMixinApplication(token, begin, classKeyword);
    indent--;
    return result;
  }

  @override
  Token parseClass(
    Token token,
    Token beginToken,
    Token classKeyword,
    String className,
  ) {
    doPrint(
      'parseClass('
      '$token, '
      '$beginToken, '
      '$classKeyword, '
      '$className)',
    );
    indent++;
    var result = super.parseClass(token, beginToken, classKeyword, className);
    indent--;
    return result;
  }

  @override
  Token parseClassHeaderOpt(Token token, Token begin, Token classKeyword) {
    doPrint(
      'parseClassHeaderOpt('
      '$token, '
      '$begin, '
      '$classKeyword)',
    );
    indent++;
    var result = super.parseClassHeaderOpt(token, begin, classKeyword);
    indent--;
    return result;
  }

  @override
  Token parseClassHeaderRecovery(Token token, Token begin, Token classKeyword) {
    doPrint(
      'parseClassHeaderRecovery('
      '$token, '
      '$begin, '
      '$classKeyword)',
    );
    indent++;
    var result = super.parseClassHeaderRecovery(token, begin, classKeyword);
    indent--;
    return result;
  }

  @override
  Token parseExtensionTypeHeaderRecovery(Token token, Token extensionKeyword) {
    doPrint(
      'parseExtensionTypeHeaderRecovery('
      '$token, '
      '$extensionKeyword)',
    );
    indent++;
    var result = super.parseExtensionTypeHeaderRecovery(
      token,
      extensionKeyword,
    );
    indent--;
    return result;
  }

  @override
  Token parseDeclarationHeaderRecoveryInternal(
    Token token,
    Token begin,
    Token declarationKeyword,
    DeclarationHeaderKind kind,
  ) {
    doPrint(
      'parseDeclarationHeaderRecoveryInternal('
      '$token, '
      '$begin, '
      '$declarationKeyword, '
      '$kind)',
    );
    indent++;
    var result = super.parseDeclarationHeaderRecoveryInternal(
      token,
      begin,
      declarationKeyword,
      kind,
    );
    indent--;
    return result;
  }

  @override
  Token parseClassExtendsOpt(Token token, DeclarationHeaderKind kind) {
    doPrint(
      'parseClassExtendsOpt('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.parseClassExtendsOpt(token, kind);
    indent--;
    return result;
  }

  @override
  Token parseClassExtendsSeenExtendsClause(
    Token extendsKeyword,
    Token token,
    DeclarationHeaderKind kind,
  ) {
    doPrint(
      'parseClassExtendsSeenExtendsClause('
      '$extendsKeyword, '
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.parseClassExtendsSeenExtendsClause(
      extendsKeyword,
      token,
      kind,
    );
    indent--;
    return result;
  }

  @override
  Token parseClassOrMixinOrEnumImplementsOpt(Token token) {
    doPrint(
      'parseClassOrMixinOrEnumImplementsOpt('
      '$token)',
    );
    indent++;
    var result = super.parseClassOrMixinOrEnumImplementsOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseMixin(
    Token beginToken,
    Token? augmentToken,
    Token? baseToken,
    Token mixinKeyword,
  ) {
    doPrint(
      'parseMixin('
      '$beginToken, '
      '$augmentToken, '
      '$baseToken, '
      '$mixinKeyword)',
    );
    indent++;
    var result = super.parseMixin(
      beginToken,
      augmentToken,
      baseToken,
      mixinKeyword,
    );
    indent--;
    return result;
  }

  @override
  Token parseMixinHeaderOpt(Token token, Token mixinKeyword) {
    doPrint(
      'parseMixinHeaderOpt('
      '$token, '
      '$mixinKeyword)',
    );
    indent++;
    var result = super.parseMixinHeaderOpt(token, mixinKeyword);
    indent--;
    return result;
  }

  @override
  Token parseMixinHeaderRecovery(
    Token token,
    Token mixinKeyword,
    Token headerStart,
  ) {
    doPrint(
      'parseMixinHeaderRecovery('
      '$token, '
      '$mixinKeyword, '
      '$headerStart)',
    );
    indent++;
    var result = super.parseMixinHeaderRecovery(
      token,
      mixinKeyword,
      headerStart,
    );
    indent--;
    return result;
  }

  @override
  Token parseMixinOnOpt(Token token) {
    doPrint(
      'parseMixinOnOpt('
      '$token)',
    );
    indent++;
    var result = super.parseMixinOnOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseMixinOn(Token token) {
    doPrint(
      'parseMixinOn('
      '$token)',
    );
    indent++;
    var result = super.parseMixinOn(token);
    indent--;
    return result;
  }

  @override
  Token parseExtension(
    Token beginToken,
    Token? augmentToken,
    Token extensionKeyword,
  ) {
    doPrint(
      'parseExtension('
      '$beginToken, '
      '$augmentToken, '
      '$extensionKeyword)',
    );
    indent++;
    var result = super.parseExtension(
      beginToken,
      augmentToken,
      extensionKeyword,
    );
    indent--;
    return result;
  }

  @override
  Token parseExtensionDeclaration(
    Token beginToken,
    Token token,
    Token? augmentToken,
    Token extensionKeyword,
  ) {
    doPrint(
      'parseExtensionDeclaration('
      '$beginToken, '
      '$token, '
      '$augmentToken, '
      '$extensionKeyword)',
    );
    indent++;
    var result = super.parseExtensionDeclaration(
      beginToken,
      token,
      augmentToken,
      extensionKeyword,
    );
    indent--;
    return result;
  }

  @override
  Token parseExtensionTypeDeclaration(
    Token beginToken,
    Token token,
    Token? augmentToken,
    Token extensionKeyword,
    Token typeKeyword,
  ) {
    doPrint(
      'parseExtensionTypeDeclaration('
      '$beginToken, '
      '$token, '
      '$augmentToken, '
      '$extensionKeyword, '
      '$typeKeyword)',
    );
    indent++;
    var result = super.parseExtensionTypeDeclaration(
      beginToken,
      token,
      augmentToken,
      extensionKeyword,
      typeKeyword,
    );
    indent--;
    return result;
  }

  @override
  Token parseStringPart(Token token) {
    doPrint(
      'parseStringPart('
      '$token)',
    );
    indent++;
    var result = super.parseStringPart(token);
    indent--;
    return result;
  }

  @override
  Token insertSyntheticIdentifier(
    Token token,
    IdentifierContext context, {
    codes.Message? message,
    Token? messageOnToken,
  }) {
    doPrint(
      'insertSyntheticIdentifier('
      '$token, '
      '$context, '
      'message: $message, '
      'messageOnToken: $messageOnToken)',
    );
    indent++;
    var result = super.insertSyntheticIdentifier(
      token,
      context,
      message: message,
      messageOnToken: messageOnToken,
    );
    indent--;
    return result;
  }

  @override
  Token ensureIdentifier(Token token, IdentifierContext context) {
    doPrint(
      'ensureIdentifier('
      '$token, '
      '$context)',
    );
    indent++;
    var result = super.ensureIdentifier(token, context);
    indent--;
    return result;
  }

  @override
  Token ensureIdentifierPotentiallyRecovered(
    Token token,
    IdentifierContext context,
    bool isRecovered,
  ) {
    doPrint(
      'ensureIdentifierPotentiallyRecovered('
      '$token, '
      '$context, '
      '$isRecovered)',
    );
    indent++;
    var result = super.ensureIdentifierPotentiallyRecovered(
      token,
      context,
      isRecovered,
    );
    indent--;
    return result;
  }

  @override
  bool notEofOrType(TokenType type, Token token) {
    doPrint(
      'notEofOrType('
      '$type, '
      '$token)',
    );
    indent++;
    var result = super.notEofOrType(type, token);
    indent--;
    return result;
  }

  @override
  Token parseTypeVariablesOpt(Token token) {
    doPrint(
      'parseTypeVariablesOpt('
      '$token)',
    );
    indent++;
    var result = super.parseTypeVariablesOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseTopLevelMember(Token token) {
    doPrint(
      'parseTopLevelMember('
      '$token)',
    );
    indent++;
    var result = super.parseTopLevelMember(token);
    indent--;
    return result;
  }

  @override
  Token parseTopLevelMemberImpl(Token token) {
    doPrint(
      'parseTopLevelMemberImpl('
      '$token)',
    );
    indent++;
    var result = super.parseTopLevelMemberImpl(token);
    indent--;
    return result;
  }

  @override
  Token parseFields(
    Token beforeStart,
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    Token beforeType,
    TypeInfo typeInfo,
    Token name,
    DeclarationKind kind,
    String? enclosingDeclarationName,
    bool nameIsRecovered,
  ) {
    doPrint(
      'parseFields('
      '$beforeStart, '
      '$abstractToken, '
      '$augmentToken, '
      '$externalToken, '
      '$staticToken, '
      '$covariantToken, '
      '$lateToken, '
      '$varFinalOrConst, '
      '$beforeType, '
      '$typeInfo, '
      '$name, '
      '$kind, '
      '$enclosingDeclarationName, '
      '$nameIsRecovered)',
    );
    indent++;
    var result = super.parseFields(
      beforeStart,
      abstractToken,
      augmentToken,
      externalToken,
      staticToken,
      covariantToken,
      lateToken,
      varFinalOrConst,
      beforeType,
      typeInfo,
      name,
      kind,
      enclosingDeclarationName,
      nameIsRecovered,
    );
    indent--;
    return result;
  }

  @override
  Token parseTopLevelMethod(
    Token beforeStart,
    Token? augmentToken,
    Token? externalToken,
    Token beforeType,
    TypeInfo typeInfo,
    Token? getOrSet,
    Token name,
    bool nameIsRecovered,
  ) {
    doPrint(
      'parseTopLevelMethod('
      '$beforeStart, '
      '$augmentToken, '
      '$externalToken, '
      '$beforeType, '
      '$typeInfo, '
      '$getOrSet, '
      '$name, '
      '$nameIsRecovered)',
    );
    indent++;
    var result = super.parseTopLevelMethod(
      beforeStart,
      augmentToken,
      externalToken,
      beforeType,
      typeInfo,
      getOrSet,
      name,
      nameIsRecovered,
    );
    indent--;
    return result;
  }

  @override
  Token parseMethodTypeVar(Token name) {
    doPrint(
      'parseMethodTypeVar('
      '$name)',
    );
    indent++;
    var result = super.parseMethodTypeVar(name);
    indent--;
    return result;
  }

  @override
  Token parseFieldInitializerOpt(
    Token token,
    Token name,
    Token? lateToken,
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? varFinalOrConst,
    DeclarationKind kind,
    String? enclosingDeclarationName,
  ) {
    doPrint(
      'parseFieldInitializerOpt('
      '$token, '
      '$name, '
      '$lateToken, '
      '$abstractToken, '
      '$augmentToken, '
      '$externalToken, '
      '$varFinalOrConst, '
      '$kind, '
      '$enclosingDeclarationName)',
    );
    indent++;
    var result = super.parseFieldInitializerOpt(
      token,
      name,
      lateToken,
      abstractToken,
      augmentToken,
      externalToken,
      varFinalOrConst,
      kind,
      enclosingDeclarationName,
    );
    indent--;
    return result;
  }

  @override
  Token parseVariableInitializerOpt(Token token) {
    doPrint(
      'parseVariableInitializerOpt('
      '$token)',
    );
    indent++;
    var result = super.parseVariableInitializerOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseInitializersOpt(Token token) {
    doPrint(
      'parseInitializersOpt('
      '$token)',
    );
    indent++;
    var result = super.parseInitializersOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseInitializers(Token token) {
    doPrint(
      'parseInitializers('
      '$token)',
    );
    indent++;
    var result = super.parseInitializers(token);
    indent--;
    return result;
  }

  @override
  Token parseInitializer(Token token) {
    doPrint(
      'parseInitializer('
      '$token)',
    );
    indent++;
    var result = super.parseInitializer(token);
    indent--;
    return result;
  }

  @override
  Token parseSuperInitializerExpression(final Token start) {
    doPrint(
      'parseSuperInitializerExpression('
      '$start)',
    );
    indent++;
    var result = super.parseSuperInitializerExpression(start);
    indent--;
    return result;
  }

  @override
  Token parseInitializerExpressionRest(Token token) {
    doPrint(
      'parseInitializerExpressionRest('
      '$token)',
    );
    indent++;
    var result = super.parseInitializerExpressionRest(token);
    indent--;
    return result;
  }

  @override
  Token ensureBlock(Token token, BlockKind? missingBlockKind) {
    doPrint(
      'ensureBlock('
      '$token, '
      '$missingBlockKind)',
    );
    indent++;
    var result = super.ensureBlock(token, missingBlockKind);
    indent--;
    return result;
  }

  @override
  Token insertBlock(Token token) {
    doPrint(
      'insertBlock('
      '$token)',
    );
    indent++;
    var result = super.insertBlock(token);
    indent--;
    return result;
  }

  @override
  Token ensureCloseParen(Token token, Token openParen) {
    doPrint(
      'ensureCloseParen('
      '$token, '
      '$openParen)',
    );
    indent++;
    var result = super.ensureCloseParen(token, openParen);
    indent--;
    return result;
  }

  @override
  Token ensureColon(Token token) {
    doPrint(
      'ensureColon('
      '$token)',
    );
    indent++;
    var result = super.ensureColon(token);
    indent--;
    return result;
  }

  @override
  Token ensureFunctionArrow(Token token) {
    doPrint(
      'ensureFunctionArrow('
      '$token)',
    );
    indent++;
    var result = super.ensureFunctionArrow(token);
    indent--;
    return result;
  }

  @override
  Token ensureLiteralString(Token token) {
    doPrint(
      'ensureLiteralString('
      '$token)',
    );
    indent++;
    var result = super.ensureLiteralString(token);
    indent--;
    return result;
  }

  @override
  Token ensureSemicolon(Token token) {
    doPrint(
      'ensureSemicolon('
      '$token)',
    );
    indent++;
    var result = super.ensureSemicolon(token);
    indent--;
    return result;
  }

  @override
  Token rewriteAndRecover(Token token, codes.Message message, Token newToken) {
    doPrint(
      'rewriteAndRecover('
      '$token, '
      '$message, '
      '$newToken)',
    );
    indent++;
    var result = super.rewriteAndRecover(token, message, newToken);
    indent--;
    return result;
  }

  @override
  Token rewriteSquareBrackets(Token token) {
    doPrint(
      'rewriteSquareBrackets('
      '$token)',
    );
    indent++;
    var result = super.rewriteSquareBrackets(token);
    indent--;
    return result;
  }

  @override
  Token skipUnexpectedTokenOpt(Token token, List<String> expectedNext) {
    doPrint(
      'skipUnexpectedTokenOpt('
      '$token, '
      '$expectedNext)',
    );
    indent++;
    var result = super.skipUnexpectedTokenOpt(token, expectedNext);
    indent--;
    return result;
  }

  @override
  Token parseNativeClause(Token token) {
    doPrint(
      'parseNativeClause('
      '$token)',
    );
    indent++;
    var result = super.parseNativeClause(token);
    indent--;
    return result;
  }

  @override
  Token skipClassOrMixinOrExtensionBody(Token token) {
    doPrint(
      'skipClassOrMixinOrExtensionBody('
      '$token)',
    );
    indent++;
    var result = super.skipClassOrMixinOrExtensionBody(token);
    indent--;
    return result;
  }

  @override
  Token parseClassOrMixinOrExtensionBody(
    Token token,
    DeclarationKind kind,
    String? enclosingDeclarationName,
  ) {
    doPrint(
      'parseClassOrMixinOrExtensionBody('
      '$token, '
      '$kind, '
      '$enclosingDeclarationName)',
    );
    indent++;
    var result = super.parseClassOrMixinOrExtensionBody(
      token,
      kind,
      enclosingDeclarationName,
    );
    indent--;
    return result;
  }

  @override
  bool isUnaryMinus(Token token) {
    doPrint(
      'isUnaryMinus('
      '$token)',
    );
    indent++;
    var result = super.isUnaryMinus(token);
    indent--;
    return result;
  }

  @override
  Token parseClassMember(Token token, String? className) {
    doPrint(
      'parseClassMember('
      '$token, '
      '$className)',
    );
    indent++;
    var result = super.parseClassMember(token, className);
    indent--;
    return result;
  }

  @override
  Token parseMixinMember(Token token, String mixinName) {
    doPrint(
      'parseMixinMember('
      '$token, '
      '$mixinName)',
    );
    indent++;
    var result = super.parseMixinMember(token, mixinName);
    indent--;
    return result;
  }

  @override
  Token parseExtensionMember(Token token, String extensionName) {
    doPrint(
      'parseExtensionMember('
      '$token, '
      '$extensionName)',
    );
    indent++;
    var result = super.parseExtensionMember(token, extensionName);
    indent--;
    return result;
  }

  @override
  bool isReservedKeyword(Token token) {
    doPrint(
      'isReservedKeyword('
      '$token)',
    );
    indent++;
    var result = super.isReservedKeyword(token);
    indent--;
    return result;
  }

  @override
  bool indicatesMethodOrField(Token token) {
    doPrint(
      'indicatesMethodOrField('
      '$token)',
    );
    indent++;
    var result = super.indicatesMethodOrField(token);
    indent--;
    return result;
  }

  @override
  Token parseClassOrMixinOrExtensionOrEnumMemberImpl(
    Token token,
    DeclarationKind kind,
    String? enclosingDeclarationName,
  ) {
    doPrint(
      'parseClassOrMixinOrExtensionOrEnumMemberImpl('
      '$token, '
      '$kind, '
      '$enclosingDeclarationName)',
    );
    indent++;
    var result = super.parseClassOrMixinOrExtensionOrEnumMemberImpl(
      token,
      kind,
      enclosingDeclarationName,
    );
    indent--;
    return result;
  }

  @override
  Token parseMethod(
    Token beforeStart,
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    Token beforeType,
    TypeInfo typeInfo,
    Token? getOrSet,
    Token name,
    DeclarationKind kind,
    String? enclosingDeclarationName,
    bool nameIsRecovered,
  ) {
    doPrint(
      'parseMethod('
      '$beforeStart, '
      '$abstractToken, '
      '$augmentToken, '
      '$externalToken, '
      '$staticToken, '
      '$covariantToken, '
      '$lateToken, '
      '$varFinalOrConst, '
      '$beforeType, '
      '$typeInfo, '
      '$getOrSet, '
      '$name, '
      '$kind, '
      '$enclosingDeclarationName, '
      '$nameIsRecovered)',
    );
    indent++;
    var result = super.parseMethod(
      beforeStart,
      abstractToken,
      augmentToken,
      externalToken,
      staticToken,
      covariantToken,
      lateToken,
      varFinalOrConst,
      beforeType,
      typeInfo,
      getOrSet,
      name,
      kind,
      enclosingDeclarationName,
      nameIsRecovered,
    );
    indent--;
    return result;
  }

  @override
  Token parseFactoryMethod(
    Token token,
    DeclarationKind kind,
    Token beforeStart,
    Token? externalToken,
    Token? staticOrCovariant,
    Token? varFinalOrConst,
  ) {
    doPrint(
      'parseFactoryMethod('
      '$token, '
      '$kind, '
      '$beforeStart, '
      '$externalToken, '
      '$staticOrCovariant, '
      '$varFinalOrConst)',
    );
    indent++;
    var result = super.parseFactoryMethod(
      token,
      kind,
      beforeStart,
      externalToken,
      staticOrCovariant,
      varFinalOrConst,
    );
    indent--;
    return result;
  }

  @override
  Token parseOperatorName(Token token) {
    doPrint(
      'parseOperatorName('
      '$token)',
    );
    indent++;
    var result = super.parseOperatorName(token);
    indent--;
    return result;
  }

  @override
  Token parseFunctionExpression(Token token) {
    doPrint(
      'parseFunctionExpression('
      '$token)',
    );
    indent++;
    var result = super.parseFunctionExpression(token);
    indent--;
    return result;
  }

  @override
  Token parseFunctionLiteral(
    Token start,
    Token beforeName,
    Token name,
    TypeInfo typeInfo,
    TypeParamOrArgInfo typeParam,
    IdentifierContext context,
  ) {
    doPrint(
      'parseFunctionLiteral('
      '$start, '
      '$beforeName, '
      '$name, '
      '$typeInfo, '
      '$typeParam, '
      '$context)',
    );
    indent++;
    var result = super.parseFunctionLiteral(
      start,
      beforeName,
      name,
      typeInfo,
      typeParam,
      context,
    );
    indent--;
    return result;
  }

  @override
  Token parseNamedFunctionRest(
    Token beforeName,
    Token begin,
    Token formals,
    bool isFunctionExpression,
  ) {
    doPrint(
      'parseNamedFunctionRest('
      '$beforeName, '
      '$begin, '
      '$formals, '
      '$isFunctionExpression)',
    );
    indent++;
    var result = super.parseNamedFunctionRest(
      beforeName,
      begin,
      formals,
      isFunctionExpression,
    );
    indent--;
    return result;
  }

  @override
  Token parseAsyncOptBody(
    Token token,
    bool ofFunctionExpression,
    bool allowAbstract,
  ) {
    doPrint(
      'parseAsyncOptBody('
      '$token, '
      '$ofFunctionExpression, '
      '$allowAbstract)',
    );
    indent++;
    var result = super.parseAsyncOptBody(
      token,
      ofFunctionExpression,
      allowAbstract,
    );
    indent--;
    return result;
  }

  @override
  Token parseConstructorReference(
    Token token,
    ConstructorReferenceContext constructorReferenceContext, [
    TypeParamOrArgInfo? typeArg,
  ]) {
    doPrint(
      'parseConstructorReference('
      '$token, '
      '$constructorReferenceContext, '
      '$typeArg)',
    );
    indent++;
    var result = super.parseConstructorReference(
      token,
      constructorReferenceContext,
      typeArg,
    );
    indent--;
    return result;
  }

  @override
  Token parseRedirectingFactoryBody(Token token) {
    doPrint(
      'parseRedirectingFactoryBody('
      '$token)',
    );
    indent++;
    var result = super.parseRedirectingFactoryBody(token);
    indent--;
    return result;
  }

  @override
  Token skipFunctionBody(Token token, bool isExpression, bool allowAbstract) {
    doPrint(
      'skipFunctionBody('
      '$token, '
      '$isExpression, '
      '$allowAbstract)',
    );
    indent++;
    var result = super.skipFunctionBody(token, isExpression, allowAbstract);
    indent--;
    return result;
  }

  @override
  Token parseFunctionBody(
    Token token,
    bool ofFunctionExpression,
    bool allowAbstract,
  ) {
    doPrint(
      'parseFunctionBody('
      '$token, '
      '$ofFunctionExpression, '
      '$allowAbstract)',
    );
    indent++;
    var result = super.parseFunctionBody(
      token,
      ofFunctionExpression,
      allowAbstract,
    );
    indent--;
    return result;
  }

  @override
  Token parseExpressionFunctionBody(Token token, bool ofFunctionExpression) {
    doPrint(
      'parseExpressionFunctionBody('
      '$token, '
      '$ofFunctionExpression)',
    );
    indent++;
    var result = super.parseExpressionFunctionBody(token, ofFunctionExpression);
    indent--;
    return result;
  }

  @override
  Token skipAsyncModifier(Token token) {
    doPrint(
      'skipAsyncModifier('
      '$token)',
    );
    indent++;
    var result = super.skipAsyncModifier(token);
    indent--;
    return result;
  }

  @override
  Token parseAsyncModifierOpt(Token token) {
    doPrint(
      'parseAsyncModifierOpt('
      '$token)',
    );
    indent++;
    var result = super.parseAsyncModifierOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseStatement(Token token) {
    doPrint(
      'parseStatement('
      '$token)',
    );
    indent++;
    var result = super.parseStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseStatementX(Token token) {
    doPrint(
      'parseStatementX('
      '$token)',
    );
    indent++;
    var result = super.parseStatementX(token);
    indent--;
    return result;
  }

  @override
  Token parseYieldStatement(Token token) {
    doPrint(
      'parseYieldStatement('
      '$token)',
    );
    indent++;
    var result = super.parseYieldStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseReturnStatement(Token token) {
    doPrint(
      'parseReturnStatement('
      '$token)',
    );
    indent++;
    var result = super.parseReturnStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseLabel(Token token) {
    doPrint(
      'parseLabel('
      '$token)',
    );
    indent++;
    var result = super.parseLabel(token);
    indent--;
    return result;
  }

  @override
  Token parseLabeledStatement(Token token) {
    doPrint(
      'parseLabeledStatement('
      '$token)',
    );
    indent++;
    var result = super.parseLabeledStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseExpressionStatement(Token token) {
    doPrint(
      'parseExpressionStatement('
      '$token)',
    );
    indent++;
    var result = super.parseExpressionStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseExpression(Token token) {
    doPrint(
      'parseExpression('
      '$token)',
    );
    indent++;
    var result = super.parseExpression(token);
    indent--;
    return result;
  }

  @override
  Token parseExpressionWithoutCascade(Token token) {
    doPrint(
      'parseExpressionWithoutCascade('
      '$token)',
    );
    indent++;
    var result = super.parseExpressionWithoutCascade(token);
    indent--;
    return result;
  }

  @override
  bool canParseAsConditional(Token question) {
    doPrint(
      'canParseAsConditional('
      '$question)',
    );
    indent++;
    var result = super.canParseAsConditional(question);
    indent--;
    return result;
  }

  @override
  Token parseConditionalExpressionRest(Token token) {
    doPrint(
      'parseConditionalExpressionRest('
      '$token)',
    );
    indent++;
    var result = super.parseConditionalExpressionRest(token);
    indent--;
    return result;
  }

  @override
  Token parsePrecedenceExpression(
    Token token,
    int precedence,
    bool allowCascades,
    ConstantPatternContext constantPatternContext,
  ) {
    doPrint(
      'parsePrecedenceExpression('
      '$token, '
      '$precedence, '
      '$allowCascades, '
      '$constantPatternContext)',
    );
    indent++;
    var result = super.parsePrecedenceExpression(
      token,
      precedence,
      allowCascades,
      constantPatternContext,
    );
    indent--;
    return result;
  }

  @override
  Token parseCascadeExpression(Token token) {
    doPrint(
      'parseCascadeExpression('
      '$token)',
    );
    indent++;
    var result = super.parseCascadeExpression(token);
    indent--;
    return result;
  }

  @override
  Token parseUnaryExpression(
    Token token,
    bool allowCascades,
    ConstantPatternContext constantPatternContext,
  ) {
    doPrint(
      'parseUnaryExpression('
      '$token, '
      '$allowCascades, '
      '$constantPatternContext)',
    );
    indent++;
    var result = super.parseUnaryExpression(
      token,
      allowCascades,
      constantPatternContext,
    );
    indent--;
    return result;
  }

  @override
  Token parseArgumentOrIndexStar(
    Token token,
    TypeParamOrArgInfo typeArg,
    bool checkedNullAware,
  ) {
    doPrint(
      'parseArgumentOrIndexStar('
      '$token, '
      '$typeArg, '
      '$checkedNullAware)',
    );
    indent++;
    var result = super.parseArgumentOrIndexStar(
      token,
      typeArg,
      checkedNullAware,
    );
    indent--;
    return result;
  }

  @override
  Token parsePrimary(
    Token token,
    IdentifierContext context,
    ConstantPatternContext constantPatternContext,
  ) {
    doPrint(
      'parsePrimary('
      '$token, '
      '$context, '
      '$constantPatternContext)',
    );
    indent++;
    var result = super.parsePrimary(token, context, constantPatternContext);
    indent--;
    return result;
  }

  @override
  Token parseParenthesizedExpressionFunctionLiteralOrRecordLiteral(
    Token token,
    ConstantPatternContext constantPatternContext,
  ) {
    doPrint(
      'parseParenthesizedExpressionFunctionLiteralOrRecordLiteral('
      '$token, '
      '$constantPatternContext)',
    );
    indent++;
    var result = super
        .parseParenthesizedExpressionFunctionLiteralOrRecordLiteral(
          token,
          constantPatternContext,
        );
    indent--;
    return result;
  }

  @override
  Token ensureParenthesizedCondition(Token token, {required bool allowCase}) {
    doPrint(
      'ensureParenthesizedCondition('
      '$token, '
      'allowCase: $allowCase)',
    );
    indent++;
    var result = super.ensureParenthesizedCondition(
      token,
      allowCase: allowCase,
    );
    indent--;
    return result;
  }

  @override
  Token parseParenthesizedExpressionOrRecordLiteral(
    Token token,
    Token? constKeywordForRecord,
    ConstantPatternContext constantPatternContext,
  ) {
    doPrint(
      'parseParenthesizedExpressionOrRecordLiteral('
      '$token, '
      '$constKeywordForRecord, '
      '$constantPatternContext)',
    );
    indent++;
    var result = super.parseParenthesizedExpressionOrRecordLiteral(
      token,
      constKeywordForRecord,
      constantPatternContext,
    );
    indent--;
    return result;
  }

  @override
  Token parseExpressionInParenthesisRest(
    Token token, {
    required bool allowCase,
  }) {
    doPrint(
      'parseExpressionInParenthesisRest('
      '$token, '
      'allowCase: $allowCase)',
    );
    indent++;
    var result = super.parseExpressionInParenthesisRest(
      token,
      allowCase: allowCase,
    );
    indent--;
    return result;
  }

  @override
  Token parseThisExpression(Token token, IdentifierContext context) {
    doPrint(
      'parseThisExpression('
      '$token, '
      '$context)',
    );
    indent++;
    var result = super.parseThisExpression(token, context);
    indent--;
    return result;
  }

  @override
  Token parseSuperExpression(Token token, IdentifierContext context) {
    doPrint(
      'parseSuperExpression('
      '$token, '
      '$context)',
    );
    indent++;
    var result = super.parseSuperExpression(token, context);
    indent--;
    return result;
  }

  @override
  Token parseAugmentSuperExpression(Token token, IdentifierContext context) {
    doPrint(
      'parseAugmentSuperExpression('
      '$token, '
      '$context)',
    );
    indent++;
    var result = super.parseAugmentSuperExpression(token, context);
    indent--;
    return result;
  }

  @override
  Token parseLiteralListSuffix(Token token, Token? constKeyword) {
    doPrint(
      'parseLiteralListSuffix('
      '$token, '
      '$constKeyword)',
    );
    indent++;
    var result = super.parseLiteralListSuffix(token, constKeyword);
    indent--;
    return result;
  }

  @override
  Token parseLiteralSetOrMapSuffix(Token token, Token? constKeyword) {
    doPrint(
      'parseLiteralSetOrMapSuffix('
      '$token, '
      '$constKeyword)',
    );
    indent++;
    var result = super.parseLiteralSetOrMapSuffix(token, constKeyword);
    indent--;
    return result;
  }

  @override
  Token parseLiteralFunctionSuffix(Token token) {
    doPrint(
      'parseLiteralFunctionSuffix('
      '$token)',
    );
    indent++;
    var result = super.parseLiteralFunctionSuffix(token);
    indent--;
    return result;
  }

  @override
  Token parseLiteralListSetMapOrFunction(
    final Token start,
    Token? constKeyword,
  ) {
    doPrint(
      'parseLiteralListSetMapOrFunction('
      '$start, '
      '$constKeyword)',
    );
    indent++;
    var result = super.parseLiteralListSetMapOrFunction(start, constKeyword);
    indent--;
    return result;
  }

  @override
  Token parseMapLiteralEntry(Token token) {
    doPrint(
      'parseMapLiteralEntry('
      '$token)',
    );
    indent++;
    var result = super.parseMapLiteralEntry(token);
    indent--;
    return result;
  }

  @override
  Token parseSendOrFunctionLiteral(
    Token token,
    IdentifierContext context,
    ConstantPatternContext constantPatternContext,
  ) {
    doPrint(
      'parseSendOrFunctionLiteral('
      '$token, '
      '$context, '
      '$constantPatternContext)',
    );
    indent++;
    var result = super.parseSendOrFunctionLiteral(
      token,
      context,
      constantPatternContext,
    );
    indent--;
    return result;
  }

  @override
  Token ensureArguments(Token token) {
    doPrint(
      'ensureArguments('
      '$token)',
    );
    indent++;
    var result = super.ensureArguments(token);
    indent--;
    return result;
  }

  @override
  Token parseConstructorInvocationArguments(Token token) {
    doPrint(
      'parseConstructorInvocationArguments('
      '$token)',
    );
    indent++;
    var result = super.parseConstructorInvocationArguments(token);
    indent--;
    return result;
  }

  @override
  Token parseNewExpression(Token token) {
    doPrint(
      'parseNewExpression('
      '$token)',
    );
    indent++;
    var result = super.parseNewExpression(token);
    indent--;
    return result;
  }

  @override
  Token parseImplicitCreationExpression(
    Token token,
    Token openAngleBracket,
    TypeParamOrArgInfo typeArg,
  ) {
    doPrint(
      'parseImplicitCreationExpression('
      '$token, '
      '$openAngleBracket, '
      '$typeArg)',
    );
    indent++;
    var result = super.parseImplicitCreationExpression(
      token,
      openAngleBracket,
      typeArg,
    );
    indent--;
    return result;
  }

  @override
  Token parseConstExpression(Token token) {
    doPrint(
      'parseConstExpression('
      '$token)',
    );
    indent++;
    var result = super.parseConstExpression(token);
    indent--;
    return result;
  }

  @override
  Token parseLiteralInt(Token token) {
    doPrint(
      'parseLiteralInt('
      '$token)',
    );
    indent++;
    var result = super.parseLiteralInt(token);
    indent--;
    return result;
  }

  @override
  Token parseLiteralIntWithSeparators(Token token) {
    doPrint(
      'parseLiteralIntWithSeparators('
      '$token)',
    );
    indent++;
    var result = super.parseLiteralIntWithSeparators(token);
    indent--;
    return result;
  }

  @override
  Token parseLiteralDouble(Token token) {
    doPrint(
      'parseLiteralDouble('
      '$token)',
    );
    indent++;
    var result = super.parseLiteralDouble(token);
    indent--;
    return result;
  }

  @override
  Token parseLiteralDoubleWithSeparators(Token token) {
    doPrint(
      'parseLiteralDoubleWithSeparators('
      '$token)',
    );
    indent++;
    var result = super.parseLiteralDoubleWithSeparators(token);
    indent--;
    return result;
  }

  @override
  Token parseLiteralString(Token token) {
    doPrint(
      'parseLiteralString('
      '$token)',
    );
    indent++;
    var result = super.parseLiteralString(token);
    indent--;
    return result;
  }

  @override
  Token parseLiteralSymbol(Token token) {
    doPrint(
      'parseLiteralSymbol('
      '$token)',
    );
    indent++;
    var result = super.parseLiteralSymbol(token);
    indent--;
    return result;
  }

  @override
  Token parseSingleLiteralString(Token token) {
    doPrint(
      'parseSingleLiteralString('
      '$token)',
    );
    indent++;
    var result = super.parseSingleLiteralString(token);
    indent--;
    return result;
  }

  @override
  Token parseIdentifierExpression(Token token) {
    doPrint(
      'parseIdentifierExpression('
      '$token)',
    );
    indent++;
    var result = super.parseIdentifierExpression(token);
    indent--;
    return result;
  }

  @override
  Token parseLiteralBool(Token token) {
    doPrint(
      'parseLiteralBool('
      '$token)',
    );
    indent++;
    var result = super.parseLiteralBool(token);
    indent--;
    return result;
  }

  @override
  Token parseLiteralNull(Token token) {
    doPrint(
      'parseLiteralNull('
      '$token)',
    );
    indent++;
    var result = super.parseLiteralNull(token);
    indent--;
    return result;
  }

  @override
  Token parseSend(
    Token token,
    IdentifierContext context,
    ConstantPatternContext constantPatternContext,
  ) {
    doPrint(
      'parseSend('
      '$token, '
      '$context, '
      '$constantPatternContext)',
    );
    indent++;
    var result = super.parseSend(token, context, constantPatternContext);
    indent--;
    return result;
  }

  @override
  Token skipArgumentsOpt(Token token) {
    doPrint(
      'skipArgumentsOpt('
      '$token)',
    );
    indent++;
    var result = super.skipArgumentsOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseArgumentsOptMetadata(Token token, bool hasTypeArguments) {
    doPrint(
      'parseArgumentsOptMetadata('
      '$token, '
      '$hasTypeArguments)',
    );
    indent++;
    var result = super.parseArgumentsOptMetadata(token, hasTypeArguments);
    indent--;
    return result;
  }

  @override
  Token parseArgumentsOpt(Token token) {
    doPrint(
      'parseArgumentsOpt('
      '$token)',
    );
    indent++;
    var result = super.parseArgumentsOpt(token);
    indent--;
    return result;
  }

  @override
  Token parseArguments(Token token) {
    doPrint(
      'parseArguments('
      '$token)',
    );
    indent++;
    var result = super.parseArguments(token);
    indent--;
    return result;
  }

  @override
  Token parseArgumentsRest(Token token) {
    doPrint(
      'parseArgumentsRest('
      '$token)',
    );
    indent++;
    var result = super.parseArgumentsRest(token);
    indent--;
    return result;
  }

  @override
  Token parseIsOperatorRest(Token token) {
    doPrint(
      'parseIsOperatorRest('
      '$token)',
    );
    indent++;
    var result = super.parseIsOperatorRest(token);
    indent--;
    return result;
  }

  @override
  TypeInfo computeTypeAfterIsOrAs(Token token) {
    doPrint(
      'computeTypeAfterIsOrAs('
      '$token)',
    );
    indent++;
    var result = super.computeTypeAfterIsOrAs(token);
    indent--;
    return result;
  }

  @override
  Token parseAsOperatorRest(Token token) {
    doPrint(
      'parseAsOperatorRest('
      '$token)',
    );
    indent++;
    var result = super.parseAsOperatorRest(token);
    indent--;
    return result;
  }

  @override
  Token skipChainedAsIsOperators(Token token) {
    doPrint(
      'skipChainedAsIsOperators('
      '$token)',
    );
    indent++;
    var result = super.skipChainedAsIsOperators(token);
    indent--;
    return result;
  }

  @override
  bool looksLikeLocalFunction(Token token) {
    doPrint(
      'looksLikeLocalFunction('
      '$token)',
    );
    indent++;
    var result = super.looksLikeLocalFunction(token);
    indent--;
    return result;
  }

  @override
  bool looksLikeFunctionBody(Token token) {
    doPrint(
      'looksLikeFunctionBody('
      '$token)',
    );
    indent++;
    var result = super.looksLikeFunctionBody(token);
    indent--;
    return result;
  }

  @override
  Token parseExpressionStatementOrConstDeclaration(final Token start) {
    doPrint(
      'parseExpressionStatementOrConstDeclaration('
      '$start)',
    );
    indent++;
    var result = super.parseExpressionStatementOrConstDeclaration(start);
    indent--;
    return result;
  }

  @override
  Token parseExpressionStatementOrDeclaration(
    final Token start, [
    ForPartsContext? forPartsContext,
  ]) {
    doPrint(
      'parseExpressionStatementOrDeclaration('
      '$start, '
      '$forPartsContext)',
    );
    indent++;
    var result = super.parseExpressionStatementOrDeclaration(
      start,
      forPartsContext,
    );
    indent--;
    return result;
  }

  @override
  Token parseExpressionStatementOrDeclarationAfterModifiers(
    Token beforeType,
    Token start,
    Token? lateToken,
    Token? varFinalOrConst,
    TypeInfo? typeInfo, [
    ForPartsContext? forPartsContext,
  ]) {
    doPrint(
      'parseExpressionStatementOrDeclarationAfterModifiers('
      '$beforeType, '
      '$start, '
      '$lateToken, '
      '$varFinalOrConst, '
      '$typeInfo, '
      '$forPartsContext)',
    );
    indent++;
    var result = super.parseExpressionStatementOrDeclarationAfterModifiers(
      beforeType,
      start,
      lateToken,
      varFinalOrConst,
      typeInfo,
      forPartsContext,
    );
    indent--;
    return result;
  }

  @override
  Token parseVariablesDeclarationRest(Token token, bool endWithSemicolon) {
    doPrint(
      'parseVariablesDeclarationRest('
      '$token, '
      '$endWithSemicolon)',
    );
    indent++;
    var result = super.parseVariablesDeclarationRest(token, endWithSemicolon);
    indent--;
    return result;
  }

  @override
  Token parseOptionallyInitializedIdentifier(Token token) {
    doPrint(
      'parseOptionallyInitializedIdentifier('
      '$token)',
    );
    indent++;
    var result = super.parseOptionallyInitializedIdentifier(token);
    indent--;
    return result;
  }

  @override
  Token parseIfStatement(Token token) {
    doPrint(
      'parseIfStatement('
      '$token)',
    );
    indent++;
    var result = super.parseIfStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseForStatement(Token token, Token? awaitToken) {
    doPrint(
      'parseForStatement('
      '$token, '
      '$awaitToken)',
    );
    indent++;
    var result = super.parseForStatement(token, awaitToken);
    indent--;
    return result;
  }

  @override
  Token parseForLoopPartsStart(
    Token? awaitToken,
    Token forToken,
    ForPartsContext forPartsContext,
  ) {
    doPrint(
      'parseForLoopPartsStart('
      '$awaitToken, '
      '$forToken, '
      '$forPartsContext)',
    );
    indent++;
    var result = super.parseForLoopPartsStart(
      awaitToken,
      forToken,
      forPartsContext,
    );
    indent--;
    return result;
  }

  @override
  Token parseForLoopPartsMid(Token token, Token? awaitToken, Token forToken) {
    doPrint(
      'parseForLoopPartsMid('
      '$token, '
      '$awaitToken, '
      '$forToken)',
    );
    indent++;
    var result = super.parseForLoopPartsMid(token, awaitToken, forToken);
    indent--;
    return result;
  }

  @override
  Token parseForRest(Token? awaitToken, Token token, Token forToken) {
    doPrint(
      'parseForRest('
      '$awaitToken, '
      '$token, '
      '$forToken)',
    );
    indent++;
    var result = super.parseForRest(awaitToken, token, forToken);
    indent--;
    return result;
  }

  @override
  Token parseForLoopPartsRest(Token token, Token forToken, Token? awaitToken) {
    doPrint(
      'parseForLoopPartsRest('
      '$token, '
      '$forToken, '
      '$awaitToken)',
    );
    indent++;
    var result = super.parseForLoopPartsRest(token, forToken, awaitToken);
    indent--;
    return result;
  }

  @override
  Token parseForInRest(
    Token token,
    Token? awaitToken,
    Token forToken,
    Token? patternKeyword,
    Token? identifier,
  ) {
    doPrint(
      'parseForInRest('
      '$token, '
      '$awaitToken, '
      '$forToken, '
      '$patternKeyword, '
      '$identifier)',
    );
    indent++;
    var result = super.parseForInRest(
      token,
      awaitToken,
      forToken,
      patternKeyword,
      identifier,
    );
    indent--;
    return result;
  }

  @override
  Token parseForInLoopPartsRest(
    Token token,
    Token? awaitToken,
    Token forToken,
    Token? patternKeyword,
    Token? identifier,
  ) {
    doPrint(
      'parseForInLoopPartsRest('
      '$token, '
      '$awaitToken, '
      '$forToken, '
      '$patternKeyword, '
      '$identifier)',
    );
    indent++;
    var result = super.parseForInLoopPartsRest(
      token,
      awaitToken,
      forToken,
      patternKeyword,
      identifier,
    );
    indent--;
    return result;
  }

  @override
  Token parseWhileStatement(Token token) {
    doPrint(
      'parseWhileStatement('
      '$token)',
    );
    indent++;
    var result = super.parseWhileStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseDoWhileStatement(Token token) {
    doPrint(
      'parseDoWhileStatement('
      '$token)',
    );
    indent++;
    var result = super.parseDoWhileStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseBlock(Token token, BlockKind blockKind) {
    doPrint(
      'parseBlock('
      '$token, '
      '$blockKind)',
    );
    indent++;
    var result = super.parseBlock(token, blockKind);
    indent--;
    return result;
  }

  @override
  Token parseInvalidBlock(Token token) {
    doPrint(
      'parseInvalidBlock('
      '$token)',
    );
    indent++;
    var result = super.parseInvalidBlock(token);
    indent--;
    return result;
  }

  @override
  bool looksLikeExpressionAfterAwaitOrYield(
    Token token,
    AwaitOrYieldContext context,
  ) {
    doPrint(
      'looksLikeExpressionAfterAwaitOrYield('
      '$token, '
      '$context)',
    );
    indent++;
    var result = super.looksLikeExpressionAfterAwaitOrYield(token, context);
    indent--;
    return result;
  }

  @override
  bool looksLikeAwaitExpression(Token token, AwaitOrYieldContext context) {
    doPrint(
      'looksLikeAwaitExpression('
      '$token, '
      '$context)',
    );
    indent++;
    var result = super.looksLikeAwaitExpression(token, context);
    indent--;
    return result;
  }

  @override
  bool looksLikeYieldStatement(Token token, AwaitOrYieldContext context) {
    doPrint(
      'looksLikeYieldStatement('
      '$token, '
      '$context)',
    );
    indent++;
    var result = super.looksLikeYieldStatement(token, context);
    indent--;
    return result;
  }

  @override
  Token parseAwaitExpression(Token token, bool allowCascades) {
    doPrint(
      'parseAwaitExpression('
      '$token, '
      '$allowCascades)',
    );
    indent++;
    var result = super.parseAwaitExpression(token, allowCascades);
    indent--;
    return result;
  }

  @override
  Token parseThrowExpression(Token token, bool allowCascades) {
    doPrint(
      'parseThrowExpression('
      '$token, '
      '$allowCascades)',
    );
    indent++;
    var result = super.parseThrowExpression(token, allowCascades);
    indent--;
    return result;
  }

  @override
  Token parseRethrowStatement(Token token) {
    doPrint(
      'parseRethrowStatement('
      '$token)',
    );
    indent++;
    var result = super.parseRethrowStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseTryStatement(Token token) {
    doPrint(
      'parseTryStatement('
      '$token)',
    );
    indent++;
    var result = super.parseTryStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseSwitchStatement(Token token) {
    doPrint(
      'parseSwitchStatement('
      '$token)',
    );
    indent++;
    var result = super.parseSwitchStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseSwitchBlock(Token token) {
    doPrint(
      'parseSwitchBlock('
      '$token)',
    );
    indent++;
    var result = super.parseSwitchBlock(token);
    indent--;
    return result;
  }

  @override
  Token peekPastLabels(Token token) {
    doPrint(
      'peekPastLabels('
      '$token)',
    );
    indent++;
    var result = super.peekPastLabels(token);
    indent--;
    return result;
  }

  @override
  Token parseStatementsInSwitchCase(
    Token token,
    Token peek,
    Token begin,
    int labelCount,
    int expressionCount,
    Token? defaultKeyword,
    Token? colonAfterDefault,
  ) {
    doPrint(
      'parseStatementsInSwitchCase('
      '$token, '
      '$peek, '
      '$begin, '
      '$labelCount, '
      '$expressionCount, '
      '$defaultKeyword, '
      '$colonAfterDefault)',
    );
    indent++;
    var result = super.parseStatementsInSwitchCase(
      token,
      peek,
      begin,
      labelCount,
      expressionCount,
      defaultKeyword,
      colonAfterDefault,
    );
    indent--;
    return result;
  }

  @override
  Token parseBreakStatement(Token token) {
    doPrint(
      'parseBreakStatement('
      '$token)',
    );
    indent++;
    var result = super.parseBreakStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseAssert(Token token, Assert kind) {
    doPrint(
      'parseAssert('
      '$token, '
      '$kind)',
    );
    indent++;
    var result = super.parseAssert(token, kind);
    indent--;
    return result;
  }

  @override
  Token parseAssertStatement(Token token) {
    doPrint(
      'parseAssertStatement('
      '$token)',
    );
    indent++;
    var result = super.parseAssertStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseContinueStatement(Token token) {
    doPrint(
      'parseContinueStatement('
      '$token)',
    );
    indent++;
    var result = super.parseContinueStatement(token);
    indent--;
    return result;
  }

  @override
  Token parseEmptyStatement(Token token) {
    doPrint(
      'parseEmptyStatement('
      '$token)',
    );
    indent++;
    var result = super.parseEmptyStatement(token);
    indent--;
    return result;
  }

  @override
  Token previousToken(Token beforeToken, Token token) {
    doPrint(
      'previousToken('
      '$beforeToken, '
      '$token)',
    );
    indent++;
    var result = super.previousToken(beforeToken, token);
    indent--;
    return result;
  }

  @override
  Token parseInvalidOperatorDeclaration(
    Token beforeStart,
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    Token beforeType,
    DeclarationKind kind,
    String? enclosingDeclarationName,
  ) {
    doPrint(
      'parseInvalidOperatorDeclaration('
      '$beforeStart, '
      '$abstractToken, '
      '$augmentToken, '
      '$externalToken, '
      '$staticToken, '
      '$covariantToken, '
      '$lateToken, '
      '$varFinalOrConst, '
      '$beforeType, '
      '$kind, '
      '$enclosingDeclarationName)',
    );
    indent++;
    var result = super.parseInvalidOperatorDeclaration(
      beforeStart,
      abstractToken,
      augmentToken,
      externalToken,
      staticToken,
      covariantToken,
      lateToken,
      varFinalOrConst,
      beforeType,
      kind,
      enclosingDeclarationName,
    );
    indent--;
    return result;
  }

  @override
  Token recoverFromInvalidMember(
    Token token,
    Token beforeStart,
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    Token beforeType,
    TypeInfo typeInfo,
    Token? getOrSet,
    DeclarationKind kind,
    String? enclosingDeclarationName,
  ) {
    doPrint(
      'recoverFromInvalidMember('
      '$token, '
      '$beforeStart, '
      '$abstractToken, '
      '$augmentToken, '
      '$externalToken, '
      '$staticToken, '
      '$covariantToken, '
      '$lateToken, '
      '$varFinalOrConst, '
      '$beforeType, '
      '$typeInfo, '
      '$getOrSet, '
      '$kind, '
      '$enclosingDeclarationName)',
    );
    indent++;
    var result = super.recoverFromInvalidMember(
      token,
      beforeStart,
      abstractToken,
      augmentToken,
      externalToken,
      staticToken,
      covariantToken,
      lateToken,
      varFinalOrConst,
      beforeType,
      typeInfo,
      getOrSet,
      kind,
      enclosingDeclarationName,
    );
    indent--;
    return result;
  }

  @override
  Token recoverFromStackOverflow(Token token) {
    doPrint(
      'recoverFromStackOverflow('
      '$token)',
    );
    indent++;
    var result = super.recoverFromStackOverflow(token);
    indent--;
    return result;
  }

  @override
  void reportRecoverableError(Token token, codes.Message message) {
    doPrint(
      'reportRecoverableError('
      '$token, '
      '$message)',
    );
    indent++;
    var result = super.reportRecoverableError(token, message);
    indent--;
    return result;
  }

  @override
  void reportRecoverableErrorWithEnd(
    Token startToken,
    Token endToken,
    codes.Message message,
  ) {
    doPrint(
      'reportRecoverableErrorWithEnd('
      '$startToken, '
      '$endToken, '
      '$message)',
    );
    indent++;
    var result = super.reportRecoverableErrorWithEnd(
      startToken,
      endToken,
      message,
    );
    indent--;
    return result;
  }

  @override
  void reportExperimentNotEnabled(
    ExperimentalFlag experimentalFlag,
    Token startToken,
    Token endToken,
  ) {
    doPrint(
      'reportExperimentNotEnabled('
      '$experimentalFlag, '
      '$startToken, '
      '$endToken)',
    );
    indent++;
    var result = super.reportExperimentNotEnabled(
      experimentalFlag,
      startToken,
      endToken,
    );
    indent--;
    return result;
  }

  @override
  void reportRecoverableErrorWithToken(Token token, dynamic template) {
    doPrint(
      'reportRecoverableErrorWithToken('
      '$token, '
      '$template)',
    );
    indent++;
    var result = super.reportRecoverableErrorWithToken(token, template);
    indent--;
    return result;
  }

  @override
  Token reportAllErrorTokens(Token token) {
    doPrint(
      'reportAllErrorTokens('
      '$token)',
    );
    indent++;
    var result = super.reportAllErrorTokens(token);
    indent--;
    return result;
  }

  @override
  Token skipErrorTokens(Token token) {
    doPrint(
      'skipErrorTokens('
      '$token)',
    );
    indent++;
    var result = super.skipErrorTokens(token);
    indent--;
    return result;
  }

  @override
  Token parseInvalidTopLevelDeclaration(Token token) {
    doPrint(
      'parseInvalidTopLevelDeclaration('
      '$token)',
    );
    indent++;
    var result = super.parseInvalidTopLevelDeclaration(token);
    indent--;
    return result;
  }

  @override
  Token reportAndSkipClassInClass(Token token) {
    doPrint(
      'reportAndSkipClassInClass('
      '$token)',
    );
    indent++;
    var result = super.reportAndSkipClassInClass(token);
    indent--;
    return result;
  }

  @override
  Token reportAndSkipEnumInClass(Token token) {
    doPrint(
      'reportAndSkipEnumInClass('
      '$token)',
    );
    indent++;
    var result = super.reportAndSkipEnumInClass(token);
    indent--;
    return result;
  }

  @override
  Token reportAndSkipTypedefInClass(Token token) {
    doPrint(
      'reportAndSkipTypedefInClass('
      '$token)',
    );
    indent++;
    var result = super.reportAndSkipTypedefInClass(token);
    indent--;
    return result;
  }

  @override
  Token link(BeginToken beginToken, Token endToken) {
    doPrint(
      'link('
      '$beginToken, '
      '$endToken)',
    );
    indent++;
    var result = super.link(beginToken, endToken);
    indent--;
    return result;
  }

  @override
  Token syntheticPreviousToken(Token token) {
    doPrint(
      'syntheticPreviousToken('
      '$token)',
    );
    indent++;
    var result = super.syntheticPreviousToken(token);
    indent--;
    return result;
  }

  @override
  Token? findDartDoc(Token token) {
    doPrint(
      'findDartDoc('
      '$token)',
    );
    indent++;
    var result = super.findDartDoc(token);
    indent--;
    return result;
  }

  @override
  Token parsePattern(
    Token token,
    PatternContext patternContext, {
    int precedence = 1,
  }) {
    doPrint(
      'parsePattern('
      '$token, '
      '$patternContext, '
      'precedence: $precedence)',
    );
    indent++;
    var result = super.parsePattern(
      token,
      patternContext,
      precedence: precedence,
    );
    indent--;
    return result;
  }

  @override
  Token parsePrimaryPattern(Token token, PatternContext patternContext) {
    doPrint(
      'parsePrimaryPattern('
      '$token, '
      '$patternContext)',
    );
    indent++;
    var result = super.parsePrimaryPattern(token, patternContext);
    indent--;
    return result;
  }

  @override
  Token parseVariablePattern(
    Token token,
    PatternContext patternContext, {
    TypeInfo typeInfo = noType,
  }) {
    doPrint(
      'parseVariablePattern('
      '$token, '
      '$patternContext, '
      'typeInfo: $typeInfo)',
    );
    indent++;
    var result = super.parseVariablePattern(
      token,
      patternContext,
      typeInfo: typeInfo,
    );
    indent--;
    return result;
  }

  @override
  Token parseListPatternSuffix(Token token, PatternContext patternContext) {
    doPrint(
      'parseListPatternSuffix('
      '$token, '
      '$patternContext)',
    );
    indent++;
    var result = super.parseListPatternSuffix(token, patternContext);
    indent--;
    return result;
  }

  @override
  Token parseMapPatternSuffix(Token token, PatternContext patternContext) {
    doPrint(
      'parseMapPatternSuffix('
      '$token, '
      '$patternContext)',
    );
    indent++;
    var result = super.parseMapPatternSuffix(token, patternContext);
    indent--;
    return result;
  }

  @override
  Token parseParenthesizedPatternOrRecordPattern(
    Token token,
    PatternContext patternContext,
  ) {
    doPrint(
      'parseParenthesizedPatternOrRecordPattern('
      '$token, '
      '$patternContext)',
    );
    indent++;
    var result = super.parseParenthesizedPatternOrRecordPattern(
      token,
      patternContext,
    );
    indent--;
    return result;
  }

  @override
  Token parseObjectPatternRest(Token token, PatternContext patternContext) {
    doPrint(
      'parseObjectPatternRest('
      '$token, '
      '$patternContext)',
    );
    indent++;
    var result = super.parseObjectPatternRest(token, patternContext);
    indent--;
    return result;
  }

  @override
  bool looksLikeOuterPatternEquals(Token token) {
    doPrint(
      'looksLikeOuterPatternEquals('
      '$token)',
    );
    indent++;
    var result = super.looksLikeOuterPatternEquals(token);
    indent--;
    return result;
  }

  @override
  Token? skipOuterPattern(Token token) {
    doPrint(
      'skipOuterPattern('
      '$token)',
    );
    indent++;
    var result = super.skipOuterPattern(token);
    indent--;
    return result;
  }

  @override
  Token? skipObjectPatternRest(Token token) {
    doPrint(
      'skipObjectPatternRest('
      '$token)',
    );
    indent++;
    var result = super.skipObjectPatternRest(token);
    indent--;
    return result;
  }

  @override
  Token parsePatternVariableDeclarationStatement(
    Token keyword,
    Token start,
    Token varOrFinal,
  ) {
    doPrint(
      'parsePatternVariableDeclarationStatement('
      '$keyword, '
      '$start, '
      '$varOrFinal)',
    );
    indent++;
    var result = super.parsePatternVariableDeclarationStatement(
      keyword,
      start,
      varOrFinal,
    );
    indent--;
    return result;
  }

  @override
  Token parsePatternAssignment(Token token) {
    doPrint(
      'parsePatternAssignment('
      '$token)',
    );
    indent++;
    var result = super.parsePatternAssignment(token);
    indent--;
    return result;
  }

  @override
  Token parseSwitchExpression(Token token) {
    doPrint(
      'parseSwitchExpression('
      '$token)',
    );
    indent++;
    var result = super.parseSwitchExpression(token);
    indent--;
    return result;
  }

  @override
  Token? findNextCommaOrSemicolon(Token token, Token limit) {
    doPrint(
      'findNextCommaOrSemicolon('
      '$token, '
      '$limit)',
    );
    indent++;
    var result = super.findNextCommaOrSemicolon(token, limit);
    indent--;
    return result;
  }
}
