// Copyright (c) 2020, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:_fe_analyzer_shared/src/experiments/flags.dart';
import 'package:_fe_analyzer_shared/src/parser/assert.dart';
import 'package:_fe_analyzer_shared/src/parser/block_kind.dart';
import 'package:_fe_analyzer_shared/src/parser/constructor_reference_context.dart';
import 'package:_fe_analyzer_shared/src/parser/declaration_kind.dart';
import 'package:_fe_analyzer_shared/src/parser/formal_parameter_kind.dart';
import 'package:_fe_analyzer_shared/src/parser/identifier_context.dart';
import 'package:_fe_analyzer_shared/src/parser/listener.dart';
import 'package:_fe_analyzer_shared/src/parser/member_kind.dart';
import 'package:_fe_analyzer_shared/src/scanner/error_token.dart';
import 'package:_fe_analyzer_shared/src/scanner/token.dart';

import '../base/messages.dart';

// ignore_for_file: lines_longer_than_80_chars

// THIS FILE IS AUTO GENERATED BY
// 'tool/parser_ast_helper_creator.dart'
// Run this command to update it:
// 'dart pkg/front_end/tool/parser_ast_helper_creator.dart'

abstract class ParserAstNode {
  final String what;
  final ParserAstType type;
  Map<String, Object?> get deprecatedArguments;
  List<ParserAstNode>? children;
  ParserAstNode? parent;

  ParserAstNode(this.what, this.type);

  R accept<R>(ParserAstVisitor<R> v);

  void visitChildren(ParserAstVisitor v) {
    List<ParserAstNode>? children = this.children;
    if (children == null) return;
    for (ParserAstNode child in children) {
      child.accept(v);
    }
  }

  void debugPrint() {
    StringBuffer sb = new StringBuffer();
    _debugPrintImpl(0, sb);
    print(sb.toString());
  }

  void _debugPrintImpl(int indentation, StringBuffer sb) {
    sb.write(" " * indentation);
    sb.write(what);
    sb.write(type.name);
    Token? tokenWithSmallestOffset;
    for (Object? value in deprecatedArguments.values) {
      if (value is Token) {
        if (tokenWithSmallestOffset == null ||
            value.charOffset < tokenWithSmallestOffset.charOffset) {
          tokenWithSmallestOffset = value;
        }
      }
    }
    if (tokenWithSmallestOffset != null) {
      sb.write(
        " (${tokenWithSmallestOffset.lexeme} @ "
        "${tokenWithSmallestOffset.charOffset})",
      );
    }
    sb.writeln();
    List<ParserAstNode>? children = this.children;
    if (children == null) return;
    for (ParserAstNode child in children) {
      child._debugPrintImpl(indentation + 2, sb);
    }
  }

  // TODO(jensj): Compare two ASTs.
}

abstract class BeginAndEndTokenParserAstNode implements ParserAstNode {
  Token get beginToken;
  Token get endToken;
}

enum ParserAstType { BEGIN, END, HANDLE }

abstract class AbstractParserAstListener implements Listener {
  List<ParserAstNode> data = [];

  void seen(ParserAstNode entry);

  @override
  void beginArguments(Token token) {
    ArgumentsBegin data = new ArgumentsBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void endArguments(int count, Token beginToken, Token endToken) {
    ArgumentsEnd data = new ArgumentsEnd(
      ParserAstType.END,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleObjectPatternFields(int count, Token beginToken, Token endToken) {
    ObjectPatternFieldsHandle data = new ObjectPatternFieldsHandle(
      ParserAstType.HANDLE,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleAsyncModifier(Token? asyncToken, Token? starToken) {
    AsyncModifierHandle data = new AsyncModifierHandle(
      ParserAstType.HANDLE,
      asyncToken: asyncToken,
      starToken: starToken,
    );
    seen(data);
  }

  @override
  void beginAwaitExpression(Token token) {
    AwaitExpressionBegin data = new AwaitExpressionBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endAwaitExpression(Token beginToken, Token endToken) {
    AwaitExpressionEnd data = new AwaitExpressionEnd(
      ParserAstType.END,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endInvalidAwaitExpression(
    Token beginToken,
    Token endToken,
    MessageCode errorCode,
  ) {
    InvalidAwaitExpressionEnd data = new InvalidAwaitExpressionEnd(
      ParserAstType.END,
      beginToken: beginToken,
      endToken: endToken,
      errorCode: errorCode,
    );
    seen(data);
  }

  @override
  void beginBlock(Token token, BlockKind blockKind) {
    BlockBegin data = new BlockBegin(
      ParserAstType.BEGIN,
      token: token,
      blockKind: blockKind,
    );
    seen(data);
  }

  @override
  void endBlock(
    int count,
    Token beginToken,
    Token endToken,
    BlockKind blockKind,
  ) {
    BlockEnd data = new BlockEnd(
      ParserAstType.END,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
      blockKind: blockKind,
    );
    seen(data);
  }

  @override
  void handleInvalidTopLevelBlock(Token token) {
    InvalidTopLevelBlockHandle data = new InvalidTopLevelBlockHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void beginCascade(Token token) {
    CascadeBegin data = new CascadeBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void endCascade() {
    CascadeEnd data = new CascadeEnd(ParserAstType.END);
    seen(data);
  }

  @override
  void beginCaseExpression(Token caseKeyword) {
    CaseExpressionBegin data = new CaseExpressionBegin(
      ParserAstType.BEGIN,
      caseKeyword: caseKeyword,
    );
    seen(data);
  }

  @override
  void endCaseExpression(Token caseKeyword, Token? when, Token colon) {
    CaseExpressionEnd data = new CaseExpressionEnd(
      ParserAstType.END,
      caseKeyword: caseKeyword,
      when: when,
      colon: colon,
    );
    seen(data);
  }

  @override
  void beginClassOrMixinOrExtensionBody(DeclarationKind kind, Token token) {
    ClassOrMixinOrExtensionBodyBegin data =
        new ClassOrMixinOrExtensionBodyBegin(
          ParserAstType.BEGIN,
          kind: kind,
          token: token,
        );
    seen(data);
  }

  @override
  void endClassOrMixinOrExtensionBody(
    DeclarationKind kind,
    int memberCount,
    Token beginToken,
    Token endToken,
  ) {
    ClassOrMixinOrExtensionBodyEnd data = new ClassOrMixinOrExtensionBodyEnd(
      ParserAstType.END,
      kind: kind,
      memberCount: memberCount,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginClassOrMixinOrNamedMixinApplicationPrelude(Token token) {
    ClassOrMixinOrNamedMixinApplicationPreludeBegin data =
        new ClassOrMixinOrNamedMixinApplicationPreludeBegin(
          ParserAstType.BEGIN,
          token: token,
        );
    seen(data);
  }

  @override
  void beginClassDeclaration(
    Token begin,
    Token? abstractToken,
    Token? macroToken,
    Token? sealedToken,
    Token? baseToken,
    Token? interfaceToken,
    Token? finalToken,
    Token? augmentToken,
    Token? mixinToken,
    Token name,
  ) {
    ClassDeclarationBegin data = new ClassDeclarationBegin(
      ParserAstType.BEGIN,
      begin: begin,
      abstractToken: abstractToken,
      macroToken: macroToken,
      sealedToken: sealedToken,
      baseToken: baseToken,
      interfaceToken: interfaceToken,
      finalToken: finalToken,
      augmentToken: augmentToken,
      mixinToken: mixinToken,
      name: name,
    );
    seen(data);
  }

  @override
  void handleClassExtends(Token? extendsKeyword, int typeCount) {
    ClassExtendsHandle data = new ClassExtendsHandle(
      ParserAstType.HANDLE,
      extendsKeyword: extendsKeyword,
      typeCount: typeCount,
    );
    seen(data);
  }

  @override
  void handleImplements(Token? implementsKeyword, int interfacesCount) {
    ImplementsHandle data = new ImplementsHandle(
      ParserAstType.HANDLE,
      implementsKeyword: implementsKeyword,
      interfacesCount: interfacesCount,
    );
    seen(data);
  }

  @override
  void handleClassHeader(Token begin, Token classKeyword, Token? nativeToken) {
    ClassHeaderHandle data = new ClassHeaderHandle(
      ParserAstType.HANDLE,
      begin: begin,
      classKeyword: classKeyword,
      nativeToken: nativeToken,
    );
    seen(data);
  }

  @override
  void handleRecoverDeclarationHeader(DeclarationHeaderKind kind) {
    RecoverDeclarationHeaderHandle data = new RecoverDeclarationHeaderHandle(
      ParserAstType.HANDLE,
      kind: kind,
    );
    seen(data);
  }

  @override
  void endClassDeclaration(Token beginToken, Token endToken) {
    ClassDeclarationEnd data = new ClassDeclarationEnd(
      ParserAstType.END,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginMixinDeclaration(
    Token beginToken,
    Token? augmentToken,
    Token? baseToken,
    Token mixinKeyword,
    Token name,
  ) {
    MixinDeclarationBegin data = new MixinDeclarationBegin(
      ParserAstType.BEGIN,
      beginToken: beginToken,
      augmentToken: augmentToken,
      baseToken: baseToken,
      mixinKeyword: mixinKeyword,
      name: name,
    );
    seen(data);
  }

  @override
  void handleMixinOn(Token? onKeyword, int typeCount) {
    MixinOnHandle data = new MixinOnHandle(
      ParserAstType.HANDLE,
      onKeyword: onKeyword,
      typeCount: typeCount,
    );
    seen(data);
  }

  @override
  void handleMixinHeader(Token mixinKeyword) {
    MixinHeaderHandle data = new MixinHeaderHandle(
      ParserAstType.HANDLE,
      mixinKeyword: mixinKeyword,
    );
    seen(data);
  }

  @override
  void handleRecoverMixinHeader() {
    RecoverMixinHeaderHandle data = new RecoverMixinHeaderHandle(
      ParserAstType.HANDLE,
    );
    seen(data);
  }

  @override
  void endMixinDeclaration(Token beginToken, Token endToken) {
    MixinDeclarationEnd data = new MixinDeclarationEnd(
      ParserAstType.END,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginUncategorizedTopLevelDeclaration(Token token) {
    UncategorizedTopLevelDeclarationBegin data =
        new UncategorizedTopLevelDeclarationBegin(
          ParserAstType.BEGIN,
          token: token,
        );
    seen(data);
  }

  @override
  void beginExtensionDeclarationPrelude(Token extensionKeyword) {
    ExtensionDeclarationPreludeBegin data =
        new ExtensionDeclarationPreludeBegin(
          ParserAstType.BEGIN,
          extensionKeyword: extensionKeyword,
        );
    seen(data);
  }

  @override
  void beginExtensionDeclaration(
    Token? augmentToken,
    Token extensionKeyword,
    Token? name,
  ) {
    ExtensionDeclarationBegin data = new ExtensionDeclarationBegin(
      ParserAstType.BEGIN,
      augmentToken: augmentToken,
      extensionKeyword: extensionKeyword,
      name: name,
    );
    seen(data);
  }

  @override
  void endExtensionDeclaration(
    Token beginToken,
    Token extensionKeyword,
    Token? onKeyword,
    Token endToken,
  ) {
    ExtensionDeclarationEnd data = new ExtensionDeclarationEnd(
      ParserAstType.END,
      beginToken: beginToken,
      extensionKeyword: extensionKeyword,
      onKeyword: onKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginExtensionTypeDeclaration(
    Token? augmentKeyword,
    Token extensionKeyword,
    Token name,
  ) {
    ExtensionTypeDeclarationBegin data = new ExtensionTypeDeclarationBegin(
      ParserAstType.BEGIN,
      augmentKeyword: augmentKeyword,
      extensionKeyword: extensionKeyword,
      name: name,
    );
    seen(data);
  }

  @override
  void endExtensionTypeDeclaration(
    Token beginToken,
    Token? augmentToken,
    Token extensionKeyword,
    Token typeKeyword,
    Token endToken,
  ) {
    ExtensionTypeDeclarationEnd data = new ExtensionTypeDeclarationEnd(
      ParserAstType.END,
      beginToken: beginToken,
      augmentToken: augmentToken,
      extensionKeyword: extensionKeyword,
      typeKeyword: typeKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginPrimaryConstructor(Token beginToken) {
    PrimaryConstructorBegin data = new PrimaryConstructorBegin(
      ParserAstType.BEGIN,
      beginToken: beginToken,
    );
    seen(data);
  }

  @override
  void endPrimaryConstructor(
    Token beginToken,
    Token? constKeyword,
    bool hasConstructorName,
  ) {
    PrimaryConstructorEnd data = new PrimaryConstructorEnd(
      ParserAstType.END,
      beginToken: beginToken,
      constKeyword: constKeyword,
      hasConstructorName: hasConstructorName,
    );
    seen(data);
  }

  @override
  void handleNoPrimaryConstructor(Token token, Token? constKeyword) {
    NoPrimaryConstructorHandle data = new NoPrimaryConstructorHandle(
      ParserAstType.HANDLE,
      token: token,
      constKeyword: constKeyword,
    );
    seen(data);
  }

  @override
  void beginCombinators(Token token) {
    CombinatorsBegin data = new CombinatorsBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endCombinators(int count) {
    CombinatorsEnd data = new CombinatorsEnd(ParserAstType.END, count: count);
    seen(data);
  }

  @override
  void beginCompilationUnit(Token token) {
    CompilationUnitBegin data = new CompilationUnitBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void handleDirectivesOnly() {
    DirectivesOnlyHandle data = new DirectivesOnlyHandle(ParserAstType.HANDLE);
    seen(data);
  }

  @override
  void endCompilationUnit(int count, Token token) {
    CompilationUnitEnd data = new CompilationUnitEnd(
      ParserAstType.END,
      count: count,
      token: token,
    );
    seen(data);
  }

  @override
  void beginConstLiteral(Token token) {
    ConstLiteralBegin data = new ConstLiteralBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endConstLiteral(Token endToken) {
    ConstLiteralEnd data = new ConstLiteralEnd(
      ParserAstType.END,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginConstructorReference(Token start) {
    ConstructorReferenceBegin data = new ConstructorReferenceBegin(
      ParserAstType.BEGIN,
      start: start,
    );
    seen(data);
  }

  @override
  void endConstructorReference(
    Token start,
    Token? periodBeforeName,
    Token endToken,
    ConstructorReferenceContext constructorReferenceContext,
  ) {
    ConstructorReferenceEnd data = new ConstructorReferenceEnd(
      ParserAstType.END,
      start: start,
      periodBeforeName: periodBeforeName,
      endToken: endToken,
      constructorReferenceContext: constructorReferenceContext,
    );
    seen(data);
  }

  @override
  void beginDoWhileStatement(Token token) {
    DoWhileStatementBegin data = new DoWhileStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endDoWhileStatement(
    Token doKeyword,
    Token whileKeyword,
    Token endToken,
  ) {
    DoWhileStatementEnd data = new DoWhileStatementEnd(
      ParserAstType.END,
      doKeyword: doKeyword,
      whileKeyword: whileKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginDoWhileStatementBody(Token token) {
    DoWhileStatementBodyBegin data = new DoWhileStatementBodyBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endDoWhileStatementBody(Token token) {
    DoWhileStatementBodyEnd data = new DoWhileStatementBodyEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void beginWhileStatementBody(Token token) {
    WhileStatementBodyBegin data = new WhileStatementBodyBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endWhileStatementBody(Token endToken) {
    WhileStatementBodyEnd data = new WhileStatementBodyEnd(
      ParserAstType.END,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginEnum(Token enumKeyword) {
    EnumBegin data = new EnumBegin(
      ParserAstType.BEGIN,
      enumKeyword: enumKeyword,
    );
    seen(data);
  }

  @override
  void endEnum(
    Token beginToken,
    Token enumKeyword,
    Token leftBrace,
    int memberCount,
    Token endToken,
  ) {
    EnumEnd data = new EnumEnd(
      ParserAstType.END,
      beginToken: beginToken,
      enumKeyword: enumKeyword,
      leftBrace: leftBrace,
      memberCount: memberCount,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endEnumConstructor(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    EnumConstructorEnd data = new EnumConstructorEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleEnumElements(Token elementsEndToken, int elementsCount) {
    EnumElementsHandle data = new EnumElementsHandle(
      ParserAstType.HANDLE,
      elementsEndToken: elementsEndToken,
      elementsCount: elementsCount,
    );
    seen(data);
  }

  @override
  void handleEnumHeader(
    Token? augmentToken,
    Token enumKeyword,
    Token leftBrace,
  ) {
    EnumHeaderHandle data = new EnumHeaderHandle(
      ParserAstType.HANDLE,
      augmentToken: augmentToken,
      enumKeyword: enumKeyword,
      leftBrace: leftBrace,
    );
    seen(data);
  }

  @override
  void handleEnumElement(Token beginToken, Token? augmentToken) {
    EnumElementHandle data = new EnumElementHandle(
      ParserAstType.HANDLE,
      beginToken: beginToken,
      augmentToken: augmentToken,
    );
    seen(data);
  }

  @override
  void endEnumFactoryMethod(
    Token beginToken,
    Token factoryKeyword,
    Token endToken,
  ) {
    EnumFactoryMethodEnd data = new EnumFactoryMethodEnd(
      ParserAstType.END,
      beginToken: beginToken,
      factoryKeyword: factoryKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginExport(Token token) {
    ExportBegin data = new ExportBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void endExport(Token exportKeyword, Token semicolon) {
    ExportEnd data = new ExportEnd(
      ParserAstType.END,
      exportKeyword: exportKeyword,
      semicolon: semicolon,
    );
    seen(data);
  }

  @override
  void handleExtraneousExpression(Token token, Message message) {
    ExtraneousExpressionHandle data = new ExtraneousExpressionHandle(
      ParserAstType.HANDLE,
      token: token,
      message: message,
    );
    seen(data);
  }

  @override
  void handleExpressionStatement(Token beginToken, Token endToken) {
    ExpressionStatementHandle data = new ExpressionStatementHandle(
      ParserAstType.HANDLE,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginFactoryMethod(
    DeclarationKind declarationKind,
    Token lastConsumed,
    Token? externalToken,
    Token? constToken,
  ) {
    FactoryMethodBegin data = new FactoryMethodBegin(
      ParserAstType.BEGIN,
      declarationKind: declarationKind,
      lastConsumed: lastConsumed,
      externalToken: externalToken,
      constToken: constToken,
    );
    seen(data);
  }

  @override
  void endClassFactoryMethod(
    Token beginToken,
    Token factoryKeyword,
    Token endToken,
  ) {
    ClassFactoryMethodEnd data = new ClassFactoryMethodEnd(
      ParserAstType.END,
      beginToken: beginToken,
      factoryKeyword: factoryKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endMixinFactoryMethod(
    Token beginToken,
    Token factoryKeyword,
    Token endToken,
  ) {
    MixinFactoryMethodEnd data = new MixinFactoryMethodEnd(
      ParserAstType.END,
      beginToken: beginToken,
      factoryKeyword: factoryKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endExtensionFactoryMethod(
    Token beginToken,
    Token factoryKeyword,
    Token endToken,
  ) {
    ExtensionFactoryMethodEnd data = new ExtensionFactoryMethodEnd(
      ParserAstType.END,
      beginToken: beginToken,
      factoryKeyword: factoryKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endExtensionTypeFactoryMethod(
    Token beginToken,
    Token factoryKeyword,
    Token endToken,
  ) {
    ExtensionTypeFactoryMethodEnd data = new ExtensionTypeFactoryMethodEnd(
      ParserAstType.END,
      beginToken: beginToken,
      factoryKeyword: factoryKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginFormalParameter(
    Token token,
    MemberKind kind,
    Token? requiredToken,
    Token? covariantToken,
    Token? varFinalOrConst,
  ) {
    FormalParameterBegin data = new FormalParameterBegin(
      ParserAstType.BEGIN,
      token: token,
      kind: kind,
      requiredToken: requiredToken,
      covariantToken: covariantToken,
      varFinalOrConst: varFinalOrConst,
    );
    seen(data);
  }

  @override
  void endFormalParameter(
    Token? thisKeyword,
    Token? superKeyword,
    Token? periodAfterThisOrSuper,
    Token nameToken,
    Token? initializerStart,
    Token? initializerEnd,
    FormalParameterKind kind,
    MemberKind memberKind,
  ) {
    FormalParameterEnd data = new FormalParameterEnd(
      ParserAstType.END,
      thisKeyword: thisKeyword,
      superKeyword: superKeyword,
      periodAfterThisOrSuper: periodAfterThisOrSuper,
      nameToken: nameToken,
      initializerStart: initializerStart,
      initializerEnd: initializerEnd,
      kind: kind,
      memberKind: memberKind,
    );
    seen(data);
  }

  @override
  void handleNoFormalParameters(Token token, MemberKind kind) {
    NoFormalParametersHandle data = new NoFormalParametersHandle(
      ParserAstType.HANDLE,
      token: token,
      kind: kind,
    );
    seen(data);
  }

  @override
  void beginFormalParameters(Token token, MemberKind kind) {
    FormalParametersBegin data = new FormalParametersBegin(
      ParserAstType.BEGIN,
      token: token,
      kind: kind,
    );
    seen(data);
  }

  @override
  void endFormalParameters(
    int count,
    Token beginToken,
    Token endToken,
    MemberKind kind,
  ) {
    FormalParametersEnd data = new FormalParametersEnd(
      ParserAstType.END,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
      kind: kind,
    );
    seen(data);
  }

  @override
  void endClassFields(
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    int count,
    Token beginToken,
    Token endToken,
  ) {
    ClassFieldsEnd data = new ClassFieldsEnd(
      ParserAstType.END,
      abstractToken: abstractToken,
      augmentToken: augmentToken,
      externalToken: externalToken,
      staticToken: staticToken,
      covariantToken: covariantToken,
      lateToken: lateToken,
      varFinalOrConst: varFinalOrConst,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endMixinFields(
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    int count,
    Token beginToken,
    Token endToken,
  ) {
    MixinFieldsEnd data = new MixinFieldsEnd(
      ParserAstType.END,
      abstractToken: abstractToken,
      augmentToken: augmentToken,
      externalToken: externalToken,
      staticToken: staticToken,
      covariantToken: covariantToken,
      lateToken: lateToken,
      varFinalOrConst: varFinalOrConst,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endExtensionFields(
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    int count,
    Token beginToken,
    Token endToken,
  ) {
    ExtensionFieldsEnd data = new ExtensionFieldsEnd(
      ParserAstType.END,
      abstractToken: abstractToken,
      augmentToken: augmentToken,
      externalToken: externalToken,
      staticToken: staticToken,
      covariantToken: covariantToken,
      lateToken: lateToken,
      varFinalOrConst: varFinalOrConst,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endExtensionTypeFields(
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    int count,
    Token beginToken,
    Token endToken,
  ) {
    ExtensionTypeFieldsEnd data = new ExtensionTypeFieldsEnd(
      ParserAstType.END,
      abstractToken: abstractToken,
      augmentToken: augmentToken,
      externalToken: externalToken,
      staticToken: staticToken,
      covariantToken: covariantToken,
      lateToken: lateToken,
      varFinalOrConst: varFinalOrConst,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endEnumFields(
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    int count,
    Token beginToken,
    Token endToken,
  ) {
    EnumFieldsEnd data = new EnumFieldsEnd(
      ParserAstType.END,
      abstractToken: abstractToken,
      augmentToken: augmentToken,
      externalToken: externalToken,
      staticToken: staticToken,
      covariantToken: covariantToken,
      lateToken: lateToken,
      varFinalOrConst: varFinalOrConst,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endEnumMethod(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    EnumMethodEnd data = new EnumMethodEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleForInitializerEmptyStatement(Token token) {
    ForInitializerEmptyStatementHandle data =
        new ForInitializerEmptyStatementHandle(
          ParserAstType.HANDLE,
          token: token,
        );
    seen(data);
  }

  @override
  void handleForInitializerExpressionStatement(Token token, bool forIn) {
    ForInitializerExpressionStatementHandle data =
        new ForInitializerExpressionStatementHandle(
          ParserAstType.HANDLE,
          token: token,
          forIn: forIn,
        );
    seen(data);
  }

  @override
  void handleForInitializerLocalVariableDeclaration(Token token, bool forIn) {
    ForInitializerLocalVariableDeclarationHandle data =
        new ForInitializerLocalVariableDeclarationHandle(
          ParserAstType.HANDLE,
          token: token,
          forIn: forIn,
        );
    seen(data);
  }

  @override
  void handleForInitializerPatternVariableAssignment(
    Token keyword,
    Token equals,
  ) {
    ForInitializerPatternVariableAssignmentHandle data =
        new ForInitializerPatternVariableAssignmentHandle(
          ParserAstType.HANDLE,
          keyword: keyword,
          equals: equals,
        );
    seen(data);
  }

  @override
  void beginForStatement(Token token) {
    ForStatementBegin data = new ForStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void handleForLoopParts(
    Token forKeyword,
    Token leftParen,
    Token leftSeparator,
    Token rightSeparator,
    int updateExpressionCount,
  ) {
    ForLoopPartsHandle data = new ForLoopPartsHandle(
      ParserAstType.HANDLE,
      forKeyword: forKeyword,
      leftParen: leftParen,
      leftSeparator: leftSeparator,
      rightSeparator: rightSeparator,
      updateExpressionCount: updateExpressionCount,
    );
    seen(data);
  }

  @override
  void endForStatement(Token endToken) {
    ForStatementEnd data = new ForStatementEnd(
      ParserAstType.END,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginForStatementBody(Token token) {
    ForStatementBodyBegin data = new ForStatementBodyBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endForStatementBody(Token endToken) {
    ForStatementBodyEnd data = new ForStatementBodyEnd(
      ParserAstType.END,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleForInLoopParts(
    Token? awaitToken,
    Token forToken,
    Token leftParenthesis,
    Token? patternKeyword,
    Token inKeyword,
  ) {
    ForInLoopPartsHandle data = new ForInLoopPartsHandle(
      ParserAstType.HANDLE,
      awaitToken: awaitToken,
      forToken: forToken,
      leftParenthesis: leftParenthesis,
      patternKeyword: patternKeyword,
      inKeyword: inKeyword,
    );
    seen(data);
  }

  @override
  void endForIn(Token endToken) {
    ForInEnd data = new ForInEnd(ParserAstType.END, endToken: endToken);
    seen(data);
  }

  @override
  void beginForInExpression(Token token) {
    ForInExpressionBegin data = new ForInExpressionBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endForInExpression(Token token) {
    ForInExpressionEnd data = new ForInExpressionEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void beginForInBody(Token token) {
    ForInBodyBegin data = new ForInBodyBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void endForInBody(Token endToken) {
    ForInBodyEnd data = new ForInBodyEnd(ParserAstType.END, endToken: endToken);
    seen(data);
  }

  @override
  void beginNamedFunctionExpression(Token token) {
    NamedFunctionExpressionBegin data = new NamedFunctionExpressionBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endNamedFunctionExpression(Token endToken) {
    NamedFunctionExpressionEnd data = new NamedFunctionExpressionEnd(
      ParserAstType.END,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginLocalFunctionDeclaration(Token token) {
    LocalFunctionDeclarationBegin data = new LocalFunctionDeclarationBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endLocalFunctionDeclaration(Token endToken) {
    LocalFunctionDeclarationEnd data = new LocalFunctionDeclarationEnd(
      ParserAstType.END,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginBlockFunctionBody(Token token) {
    BlockFunctionBodyBegin data = new BlockFunctionBodyBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endBlockFunctionBody(int count, Token beginToken, Token endToken) {
    BlockFunctionBodyEnd data = new BlockFunctionBodyEnd(
      ParserAstType.END,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleNoFunctionBody(Token token) {
    NoFunctionBodyHandle data = new NoFunctionBodyHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleFunctionBodySkipped(Token token, bool isExpressionBody) {
    FunctionBodySkippedHandle data = new FunctionBodySkippedHandle(
      ParserAstType.HANDLE,
      token: token,
      isExpressionBody: isExpressionBody,
    );
    seen(data);
  }

  @override
  void beginFunctionName(Token token) {
    FunctionNameBegin data = new FunctionNameBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endFunctionName(
    Token beginToken,
    Token token,
    bool isFunctionExpression,
  ) {
    FunctionNameEnd data = new FunctionNameEnd(
      ParserAstType.END,
      beginToken: beginToken,
      token: token,
      isFunctionExpression: isFunctionExpression,
    );
    seen(data);
  }

  @override
  void beginTypedef(Token token) {
    TypedefBegin data = new TypedefBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void endTypedef(
    Token? augmentToken,
    Token typedefKeyword,
    Token? equals,
    Token endToken,
  ) {
    TypedefEnd data = new TypedefEnd(
      ParserAstType.END,
      augmentToken: augmentToken,
      typedefKeyword: typedefKeyword,
      equals: equals,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleClassWithClause(Token withKeyword) {
    ClassWithClauseHandle data = new ClassWithClauseHandle(
      ParserAstType.HANDLE,
      withKeyword: withKeyword,
    );
    seen(data);
  }

  @override
  void handleClassNoWithClause() {
    ClassNoWithClauseHandle data = new ClassNoWithClauseHandle(
      ParserAstType.HANDLE,
    );
    seen(data);
  }

  @override
  void handleEnumWithClause(Token withKeyword) {
    EnumWithClauseHandle data = new EnumWithClauseHandle(
      ParserAstType.HANDLE,
      withKeyword: withKeyword,
    );
    seen(data);
  }

  @override
  void handleEnumNoWithClause() {
    EnumNoWithClauseHandle data = new EnumNoWithClauseHandle(
      ParserAstType.HANDLE,
    );
    seen(data);
  }

  @override
  void handleMixinWithClause(Token withKeyword) {
    MixinWithClauseHandle data = new MixinWithClauseHandle(
      ParserAstType.HANDLE,
      withKeyword: withKeyword,
    );
    seen(data);
  }

  @override
  void beginNamedMixinApplication(
    Token beginToken,
    Token? abstractToken,
    Token? macroToken,
    Token? sealedToken,
    Token? baseToken,
    Token? interfaceToken,
    Token? finalToken,
    Token? augmentToken,
    Token? mixinToken,
    Token name,
  ) {
    NamedMixinApplicationBegin data = new NamedMixinApplicationBegin(
      ParserAstType.BEGIN,
      beginToken: beginToken,
      abstractToken: abstractToken,
      macroToken: macroToken,
      sealedToken: sealedToken,
      baseToken: baseToken,
      interfaceToken: interfaceToken,
      finalToken: finalToken,
      augmentToken: augmentToken,
      mixinToken: mixinToken,
      name: name,
    );
    seen(data);
  }

  @override
  void handleNamedMixinApplicationWithClause(Token withKeyword) {
    NamedMixinApplicationWithClauseHandle data =
        new NamedMixinApplicationWithClauseHandle(
          ParserAstType.HANDLE,
          withKeyword: withKeyword,
        );
    seen(data);
  }

  @override
  void endNamedMixinApplication(
    Token begin,
    Token classKeyword,
    Token equals,
    Token? implementsKeyword,
    Token endToken,
  ) {
    NamedMixinApplicationEnd data = new NamedMixinApplicationEnd(
      ParserAstType.END,
      begin: begin,
      classKeyword: classKeyword,
      equals: equals,
      implementsKeyword: implementsKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginHide(Token hideKeyword) {
    HideBegin data = new HideBegin(
      ParserAstType.BEGIN,
      hideKeyword: hideKeyword,
    );
    seen(data);
  }

  @override
  void endHide(Token hideKeyword) {
    HideEnd data = new HideEnd(ParserAstType.END, hideKeyword: hideKeyword);
    seen(data);
  }

  @override
  void handleIdentifierList(int count) {
    IdentifierListHandle data = new IdentifierListHandle(
      ParserAstType.HANDLE,
      count: count,
    );
    seen(data);
  }

  @override
  void beginTypeList(Token token) {
    TypeListBegin data = new TypeListBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void endTypeList(int count) {
    TypeListEnd data = new TypeListEnd(ParserAstType.END, count: count);
    seen(data);
  }

  @override
  void beginIfStatement(Token token) {
    IfStatementBegin data = new IfStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endIfStatement(Token ifToken, Token? elseToken, Token endToken) {
    IfStatementEnd data = new IfStatementEnd(
      ParserAstType.END,
      ifToken: ifToken,
      elseToken: elseToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginThenStatement(Token token) {
    ThenStatementBegin data = new ThenStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endThenStatement(Token beginToken, Token endToken) {
    ThenStatementEnd data = new ThenStatementEnd(
      ParserAstType.END,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginElseStatement(Token token) {
    ElseStatementBegin data = new ElseStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endElseStatement(Token beginToken, Token endToken) {
    ElseStatementEnd data = new ElseStatementEnd(
      ParserAstType.END,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginImport(Token importKeyword) {
    ImportBegin data = new ImportBegin(
      ParserAstType.BEGIN,
      importKeyword: importKeyword,
    );
    seen(data);
  }

  @override
  void handleImportPrefix(Token? deferredKeyword, Token? asKeyword) {
    ImportPrefixHandle data = new ImportPrefixHandle(
      ParserAstType.HANDLE,
      deferredKeyword: deferredKeyword,
      asKeyword: asKeyword,
    );
    seen(data);
  }

  @override
  void endImport(Token importKeyword, Token? augmentToken, Token? semicolon) {
    ImportEnd data = new ImportEnd(
      ParserAstType.END,
      importKeyword: importKeyword,
      augmentToken: augmentToken,
      semicolon: semicolon,
    );
    seen(data);
  }

  @override
  void handleRecoverImport(Token? semicolon) {
    RecoverImportHandle data = new RecoverImportHandle(
      ParserAstType.HANDLE,
      semicolon: semicolon,
    );
    seen(data);
  }

  @override
  void beginConditionalUris(Token token) {
    ConditionalUrisBegin data = new ConditionalUrisBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endConditionalUris(int count) {
    ConditionalUrisEnd data = new ConditionalUrisEnd(
      ParserAstType.END,
      count: count,
    );
    seen(data);
  }

  @override
  void beginConditionalUri(Token ifKeyword) {
    ConditionalUriBegin data = new ConditionalUriBegin(
      ParserAstType.BEGIN,
      ifKeyword: ifKeyword,
    );
    seen(data);
  }

  @override
  void endConditionalUri(Token ifKeyword, Token leftParen, Token? equalSign) {
    ConditionalUriEnd data = new ConditionalUriEnd(
      ParserAstType.END,
      ifKeyword: ifKeyword,
      leftParen: leftParen,
      equalSign: equalSign,
    );
    seen(data);
  }

  @override
  void handleDottedName(int count, Token firstIdentifier) {
    DottedNameHandle data = new DottedNameHandle(
      ParserAstType.HANDLE,
      count: count,
      firstIdentifier: firstIdentifier,
    );
    seen(data);
  }

  @override
  void beginImplicitCreationExpression(Token token) {
    ImplicitCreationExpressionBegin data = new ImplicitCreationExpressionBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endImplicitCreationExpression(Token token, Token openAngleBracket) {
    ImplicitCreationExpressionEnd data = new ImplicitCreationExpressionEnd(
      ParserAstType.END,
      token: token,
      openAngleBracket: openAngleBracket,
    );
    seen(data);
  }

  @override
  void beginInitializedIdentifier(Token token) {
    InitializedIdentifierBegin data = new InitializedIdentifierBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endInitializedIdentifier(Token nameToken) {
    InitializedIdentifierEnd data = new InitializedIdentifierEnd(
      ParserAstType.END,
      nameToken: nameToken,
    );
    seen(data);
  }

  @override
  void beginFieldInitializer(Token token) {
    FieldInitializerBegin data = new FieldInitializerBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endFieldInitializer(Token assignment, Token endToken) {
    FieldInitializerEnd data = new FieldInitializerEnd(
      ParserAstType.END,
      assignment: assignment,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleNoFieldInitializer(Token token) {
    NoFieldInitializerHandle data = new NoFieldInitializerHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void beginVariableInitializer(Token token) {
    VariableInitializerBegin data = new VariableInitializerBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endVariableInitializer(Token assignmentOperator) {
    VariableInitializerEnd data = new VariableInitializerEnd(
      ParserAstType.END,
      assignmentOperator: assignmentOperator,
    );
    seen(data);
  }

  @override
  void handleNoVariableInitializer(Token token) {
    NoVariableInitializerHandle data = new NoVariableInitializerHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void beginInitializer(Token token) {
    InitializerBegin data = new InitializerBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endInitializer(Token endToken) {
    InitializerEnd data = new InitializerEnd(
      ParserAstType.END,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginInitializers(Token token) {
    InitializersBegin data = new InitializersBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endInitializers(int count, Token beginToken, Token endToken) {
    InitializersEnd data = new InitializersEnd(
      ParserAstType.END,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleNoInitializers() {
    NoInitializersHandle data = new NoInitializersHandle(ParserAstType.HANDLE);
    seen(data);
  }

  @override
  void handleInvalidExpression(Token token) {
    InvalidExpressionHandle data = new InvalidExpressionHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleInvalidFunctionBody(Token token) {
    InvalidFunctionBodyHandle data = new InvalidFunctionBodyHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleInvalidTypeReference(Token token) {
    InvalidTypeReferenceHandle data = new InvalidTypeReferenceHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleLabel(Token token) {
    LabelHandle data = new LabelHandle(ParserAstType.HANDLE, token: token);
    seen(data);
  }

  @override
  void beginLabeledStatement(Token token, int labelCount) {
    LabeledStatementBegin data = new LabeledStatementBegin(
      ParserAstType.BEGIN,
      token: token,
      labelCount: labelCount,
    );
    seen(data);
  }

  @override
  void endLabeledStatement(int labelCount) {
    LabeledStatementEnd data = new LabeledStatementEnd(
      ParserAstType.END,
      labelCount: labelCount,
    );
    seen(data);
  }

  @override
  void beginLibraryAugmentation(Token augmentKeyword, Token libraryKeyword) {
    LibraryAugmentationBegin data = new LibraryAugmentationBegin(
      ParserAstType.BEGIN,
      augmentKeyword: augmentKeyword,
      libraryKeyword: libraryKeyword,
    );
    seen(data);
  }

  @override
  void endLibraryAugmentation(
    Token augmentKeyword,
    Token libraryKeyword,
    Token semicolon,
  ) {
    LibraryAugmentationEnd data = new LibraryAugmentationEnd(
      ParserAstType.END,
      augmentKeyword: augmentKeyword,
      libraryKeyword: libraryKeyword,
      semicolon: semicolon,
    );
    seen(data);
  }

  @override
  void beginLibraryName(Token token) {
    LibraryNameBegin data = new LibraryNameBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endLibraryName(Token libraryKeyword, Token semicolon, bool hasName) {
    LibraryNameEnd data = new LibraryNameEnd(
      ParserAstType.END,
      libraryKeyword: libraryKeyword,
      semicolon: semicolon,
      hasName: hasName,
    );
    seen(data);
  }

  @override
  void handleLiteralMapEntry(
    Token colon,
    Token endToken, {
    Token? nullAwareKeyToken,
    Token? nullAwareValueToken,
  }) {
    LiteralMapEntryHandle data = new LiteralMapEntryHandle(
      ParserAstType.HANDLE,
      colon: colon,
      endToken: endToken,
      nullAwareKeyToken: nullAwareKeyToken,
      nullAwareValueToken: nullAwareValueToken,
    );
    seen(data);
  }

  @override
  void handleMapPatternEntry(Token colon, Token endToken) {
    MapPatternEntryHandle data = new MapPatternEntryHandle(
      ParserAstType.HANDLE,
      colon: colon,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginLiteralString(Token token) {
    LiteralStringBegin data = new LiteralStringBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void handleInterpolationExpression(Token leftBracket, Token? rightBracket) {
    InterpolationExpressionHandle data = new InterpolationExpressionHandle(
      ParserAstType.HANDLE,
      leftBracket: leftBracket,
      rightBracket: rightBracket,
    );
    seen(data);
  }

  @override
  void endLiteralString(int interpolationCount, Token endToken) {
    LiteralStringEnd data = new LiteralStringEnd(
      ParserAstType.END,
      interpolationCount: interpolationCount,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleAdjacentStringLiterals(Token startToken, int literalCount) {
    AdjacentStringLiteralsHandle data = new AdjacentStringLiteralsHandle(
      ParserAstType.HANDLE,
      startToken: startToken,
      literalCount: literalCount,
    );
    seen(data);
  }

  @override
  void beginMember() {
    MemberBegin data = new MemberBegin(ParserAstType.BEGIN);
    seen(data);
  }

  @override
  void handleInvalidMember(Token endToken) {
    InvalidMemberHandle data = new InvalidMemberHandle(
      ParserAstType.HANDLE,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endMember() {
    MemberEnd data = new MemberEnd(ParserAstType.END);
    seen(data);
  }

  @override
  void beginMethod(
    DeclarationKind declarationKind,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? varFinalOrConst,
    Token? getOrSet,
    Token name,
    String? enclosingDeclarationName,
  ) {
    MethodBegin data = new MethodBegin(
      ParserAstType.BEGIN,
      declarationKind: declarationKind,
      augmentToken: augmentToken,
      externalToken: externalToken,
      staticToken: staticToken,
      covariantToken: covariantToken,
      varFinalOrConst: varFinalOrConst,
      getOrSet: getOrSet,
      name: name,
      enclosingDeclarationName: enclosingDeclarationName,
    );
    seen(data);
  }

  @override
  void endClassMethod(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    ClassMethodEnd data = new ClassMethodEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endMixinMethod(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    MixinMethodEnd data = new MixinMethodEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endExtensionMethod(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    ExtensionMethodEnd data = new ExtensionMethodEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endExtensionTypeMethod(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    ExtensionTypeMethodEnd data = new ExtensionTypeMethodEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endClassConstructor(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    ClassConstructorEnd data = new ClassConstructorEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endMixinConstructor(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    MixinConstructorEnd data = new MixinConstructorEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endExtensionConstructor(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    ExtensionConstructorEnd data = new ExtensionConstructorEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endExtensionTypeConstructor(
    Token? getOrSet,
    Token beginToken,
    Token beginParam,
    Token? beginInitializers,
    Token endToken,
  ) {
    ExtensionTypeConstructorEnd data = new ExtensionTypeConstructorEnd(
      ParserAstType.END,
      getOrSet: getOrSet,
      beginToken: beginToken,
      beginParam: beginParam,
      beginInitializers: beginInitializers,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginMetadataStar(Token token) {
    MetadataStarBegin data = new MetadataStarBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endMetadataStar(int count) {
    MetadataStarEnd data = new MetadataStarEnd(ParserAstType.END, count: count);
    seen(data);
  }

  @override
  void beginMetadata(Token token) {
    MetadataBegin data = new MetadataBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void endMetadata(Token beginToken, Token? periodBeforeName, Token endToken) {
    MetadataEnd data = new MetadataEnd(
      ParserAstType.END,
      beginToken: beginToken,
      periodBeforeName: periodBeforeName,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginOptionalFormalParameters(Token token) {
    OptionalFormalParametersBegin data = new OptionalFormalParametersBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endOptionalFormalParameters(
    int count,
    Token beginToken,
    Token endToken,
    MemberKind kind,
  ) {
    OptionalFormalParametersEnd data = new OptionalFormalParametersEnd(
      ParserAstType.END,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
      kind: kind,
    );
    seen(data);
  }

  @override
  void beginPart(Token token) {
    PartBegin data = new PartBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void endPart(Token partKeyword, Token semicolon) {
    PartEnd data = new PartEnd(
      ParserAstType.END,
      partKeyword: partKeyword,
      semicolon: semicolon,
    );
    seen(data);
  }

  @override
  void beginPartOf(Token token) {
    PartOfBegin data = new PartOfBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void endPartOf(
    Token partKeyword,
    Token ofKeyword,
    Token semicolon,
    bool hasName,
  ) {
    PartOfEnd data = new PartOfEnd(
      ParserAstType.END,
      partKeyword: partKeyword,
      ofKeyword: ofKeyword,
      semicolon: semicolon,
      hasName: hasName,
    );
    seen(data);
  }

  @override
  void beginRedirectingFactoryBody(Token token) {
    RedirectingFactoryBodyBegin data = new RedirectingFactoryBodyBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endRedirectingFactoryBody(Token beginToken, Token endToken) {
    RedirectingFactoryBodyEnd data = new RedirectingFactoryBodyEnd(
      ParserAstType.END,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginReturnStatement(Token token) {
    ReturnStatementBegin data = new ReturnStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void handleNativeFunctionBody(Token nativeToken, Token semicolon) {
    NativeFunctionBodyHandle data = new NativeFunctionBodyHandle(
      ParserAstType.HANDLE,
      nativeToken: nativeToken,
      semicolon: semicolon,
    );
    seen(data);
  }

  @override
  void handleNativeFunctionBodyIgnored(Token nativeToken, Token semicolon) {
    NativeFunctionBodyIgnoredHandle data = new NativeFunctionBodyIgnoredHandle(
      ParserAstType.HANDLE,
      nativeToken: nativeToken,
      semicolon: semicolon,
    );
    seen(data);
  }

  @override
  void handleNativeFunctionBodySkipped(Token nativeToken, Token semicolon) {
    NativeFunctionBodySkippedHandle data = new NativeFunctionBodySkippedHandle(
      ParserAstType.HANDLE,
      nativeToken: nativeToken,
      semicolon: semicolon,
    );
    seen(data);
  }

  @override
  void handleEmptyFunctionBody(Token semicolon) {
    EmptyFunctionBodyHandle data = new EmptyFunctionBodyHandle(
      ParserAstType.HANDLE,
      semicolon: semicolon,
    );
    seen(data);
  }

  @override
  void handleExpressionFunctionBody(Token arrowToken, Token? endToken) {
    ExpressionFunctionBodyHandle data = new ExpressionFunctionBodyHandle(
      ParserAstType.HANDLE,
      arrowToken: arrowToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endReturnStatement(
    bool hasExpression,
    Token beginToken,
    Token endToken,
  ) {
    ReturnStatementEnd data = new ReturnStatementEnd(
      ParserAstType.END,
      hasExpression: hasExpression,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleSend(Token beginToken, Token endToken) {
    SendHandle data = new SendHandle(
      ParserAstType.HANDLE,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginShow(Token showKeyword) {
    ShowBegin data = new ShowBegin(
      ParserAstType.BEGIN,
      showKeyword: showKeyword,
    );
    seen(data);
  }

  @override
  void endShow(Token showKeyword) {
    ShowEnd data = new ShowEnd(ParserAstType.END, showKeyword: showKeyword);
    seen(data);
  }

  @override
  void beginSwitchStatement(Token token) {
    SwitchStatementBegin data = new SwitchStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endSwitchStatement(Token switchKeyword, Token endToken) {
    SwitchStatementEnd data = new SwitchStatementEnd(
      ParserAstType.END,
      switchKeyword: switchKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginSwitchExpression(Token token) {
    SwitchExpressionBegin data = new SwitchExpressionBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endSwitchExpression(Token switchKeyword, Token endToken) {
    SwitchExpressionEnd data = new SwitchExpressionEnd(
      ParserAstType.END,
      switchKeyword: switchKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginSwitchBlock(Token token) {
    SwitchBlockBegin data = new SwitchBlockBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endSwitchBlock(int caseCount, Token beginToken, Token endToken) {
    SwitchBlockEnd data = new SwitchBlockEnd(
      ParserAstType.END,
      caseCount: caseCount,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginSwitchExpressionBlock(Token token) {
    SwitchExpressionBlockBegin data = new SwitchExpressionBlockBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endSwitchExpressionBlock(
    int caseCount,
    Token beginToken,
    Token endToken,
  ) {
    SwitchExpressionBlockEnd data = new SwitchExpressionBlockEnd(
      ParserAstType.END,
      caseCount: caseCount,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginLiteralSymbol(Token token) {
    LiteralSymbolBegin data = new LiteralSymbolBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endLiteralSymbol(Token hashToken, int identifierCount) {
    LiteralSymbolEnd data = new LiteralSymbolEnd(
      ParserAstType.END,
      hashToken: hashToken,
      identifierCount: identifierCount,
    );
    seen(data);
  }

  @override
  void handleThrowExpression(Token throwToken, Token endToken) {
    ThrowExpressionHandle data = new ThrowExpressionHandle(
      ParserAstType.HANDLE,
      throwToken: throwToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginRethrowStatement(Token token) {
    RethrowStatementBegin data = new RethrowStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endRethrowStatement(Token rethrowToken, Token endToken) {
    RethrowStatementEnd data = new RethrowStatementEnd(
      ParserAstType.END,
      rethrowToken: rethrowToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endTopLevelDeclaration(Token endToken) {
    TopLevelDeclarationEnd data = new TopLevelDeclarationEnd(
      ParserAstType.END,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleInvalidTopLevelDeclaration(Token endToken) {
    InvalidTopLevelDeclarationHandle data =
        new InvalidTopLevelDeclarationHandle(
          ParserAstType.HANDLE,
          endToken: endToken,
        );
    seen(data);
  }

  @override
  void beginTopLevelMember(Token token) {
    TopLevelMemberBegin data = new TopLevelMemberBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void beginFields(
    DeclarationKind declarationKind,
    Token? abstractToken,
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    Token lastConsumed,
  ) {
    FieldsBegin data = new FieldsBegin(
      ParserAstType.BEGIN,
      declarationKind: declarationKind,
      abstractToken: abstractToken,
      augmentToken: augmentToken,
      externalToken: externalToken,
      staticToken: staticToken,
      covariantToken: covariantToken,
      lateToken: lateToken,
      varFinalOrConst: varFinalOrConst,
      lastConsumed: lastConsumed,
    );
    seen(data);
  }

  @override
  void endTopLevelFields(
    Token? augmentToken,
    Token? externalToken,
    Token? staticToken,
    Token? covariantToken,
    Token? lateToken,
    Token? varFinalOrConst,
    int count,
    Token beginToken,
    Token endToken,
  ) {
    TopLevelFieldsEnd data = new TopLevelFieldsEnd(
      ParserAstType.END,
      augmentToken: augmentToken,
      externalToken: externalToken,
      staticToken: staticToken,
      covariantToken: covariantToken,
      lateToken: lateToken,
      varFinalOrConst: varFinalOrConst,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginTopLevelMethod(
    Token lastConsumed,
    Token? augmentToken,
    Token? externalToken,
  ) {
    TopLevelMethodBegin data = new TopLevelMethodBegin(
      ParserAstType.BEGIN,
      lastConsumed: lastConsumed,
      augmentToken: augmentToken,
      externalToken: externalToken,
    );
    seen(data);
  }

  @override
  void endTopLevelMethod(Token beginToken, Token? getOrSet, Token endToken) {
    TopLevelMethodEnd data = new TopLevelMethodEnd(
      ParserAstType.END,
      beginToken: beginToken,
      getOrSet: getOrSet,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginTryStatement(Token token) {
    TryStatementBegin data = new TryStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void beginCatchClause(Token token) {
    CatchClauseBegin data = new CatchClauseBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endCatchClause(Token token) {
    CatchClauseEnd data = new CatchClauseEnd(ParserAstType.END, token: token);
    seen(data);
  }

  @override
  void handleCatchBlock(Token? onKeyword, Token? catchKeyword, Token? comma) {
    CatchBlockHandle data = new CatchBlockHandle(
      ParserAstType.HANDLE,
      onKeyword: onKeyword,
      catchKeyword: catchKeyword,
      comma: comma,
    );
    seen(data);
  }

  @override
  void handleFinallyBlock(Token finallyKeyword) {
    FinallyBlockHandle data = new FinallyBlockHandle(
      ParserAstType.HANDLE,
      finallyKeyword: finallyKeyword,
    );
    seen(data);
  }

  @override
  void endTryStatement(
    int catchCount,
    Token tryKeyword,
    Token? finallyKeyword,
    Token endToken,
  ) {
    TryStatementEnd data = new TryStatementEnd(
      ParserAstType.END,
      catchCount: catchCount,
      tryKeyword: tryKeyword,
      finallyKeyword: finallyKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleType(Token beginToken, Token? questionMark) {
    TypeHandle data = new TypeHandle(
      ParserAstType.HANDLE,
      beginToken: beginToken,
      questionMark: questionMark,
    );
    seen(data);
  }

  @override
  void handleNonNullAssertExpression(Token bang) {
    NonNullAssertExpressionHandle data = new NonNullAssertExpressionHandle(
      ParserAstType.HANDLE,
      bang: bang,
    );
    seen(data);
  }

  @override
  void handleNullAssertPattern(Token bang) {
    NullAssertPatternHandle data = new NullAssertPatternHandle(
      ParserAstType.HANDLE,
      bang: bang,
    );
    seen(data);
  }

  @override
  void handleNullCheckPattern(Token question) {
    NullCheckPatternHandle data = new NullCheckPatternHandle(
      ParserAstType.HANDLE,
      question: question,
    );
    seen(data);
  }

  @override
  void handleAssignedVariablePattern(Token variable) {
    AssignedVariablePatternHandle data = new AssignedVariablePatternHandle(
      ParserAstType.HANDLE,
      variable: variable,
    );
    seen(data);
  }

  @override
  void handleDeclaredVariablePattern(
    Token? keyword,
    Token variable, {
    required bool inAssignmentPattern,
  }) {
    DeclaredVariablePatternHandle data = new DeclaredVariablePatternHandle(
      ParserAstType.HANDLE,
      keyword: keyword,
      variable: variable,
      inAssignmentPattern: inAssignmentPattern,
    );
    seen(data);
  }

  @override
  void handleWildcardPattern(Token? keyword, Token wildcard) {
    WildcardPatternHandle data = new WildcardPatternHandle(
      ParserAstType.HANDLE,
      keyword: keyword,
      wildcard: wildcard,
    );
    seen(data);
  }

  @override
  void handleNoName(Token token) {
    NoNameHandle data = new NoNameHandle(ParserAstType.HANDLE, token: token);
    seen(data);
  }

  @override
  void beginRecordType(Token leftBracket) {
    RecordTypeBegin data = new RecordTypeBegin(
      ParserAstType.BEGIN,
      leftBracket: leftBracket,
    );
    seen(data);
  }

  @override
  void endRecordType(
    Token leftBracket,
    Token? questionMark,
    int count,
    bool hasNamedFields,
  ) {
    RecordTypeEnd data = new RecordTypeEnd(
      ParserAstType.END,
      leftBracket: leftBracket,
      questionMark: questionMark,
      count: count,
      hasNamedFields: hasNamedFields,
    );
    seen(data);
  }

  @override
  void beginRecordTypeEntry() {
    RecordTypeEntryBegin data = new RecordTypeEntryBegin(ParserAstType.BEGIN);
    seen(data);
  }

  @override
  void endRecordTypeEntry() {
    RecordTypeEntryEnd data = new RecordTypeEntryEnd(ParserAstType.END);
    seen(data);
  }

  @override
  void beginRecordTypeNamedFields(Token leftBracket) {
    RecordTypeNamedFieldsBegin data = new RecordTypeNamedFieldsBegin(
      ParserAstType.BEGIN,
      leftBracket: leftBracket,
    );
    seen(data);
  }

  @override
  void endRecordTypeNamedFields(int count, Token leftBracket) {
    RecordTypeNamedFieldsEnd data = new RecordTypeNamedFieldsEnd(
      ParserAstType.END,
      count: count,
      leftBracket: leftBracket,
    );
    seen(data);
  }

  @override
  void beginFunctionType(Token beginToken) {
    FunctionTypeBegin data = new FunctionTypeBegin(
      ParserAstType.BEGIN,
      beginToken: beginToken,
    );
    seen(data);
  }

  @override
  void endFunctionType(Token functionToken, Token? questionMark) {
    FunctionTypeEnd data = new FunctionTypeEnd(
      ParserAstType.END,
      functionToken: functionToken,
      questionMark: questionMark,
    );
    seen(data);
  }

  @override
  void beginTypeArguments(Token token) {
    TypeArgumentsBegin data = new TypeArgumentsBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endTypeArguments(int count, Token beginToken, Token endToken) {
    TypeArgumentsEnd data = new TypeArgumentsEnd(
      ParserAstType.END,
      count: count,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleInvalidTypeArguments(Token token) {
    InvalidTypeArgumentsHandle data = new InvalidTypeArgumentsHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleNoTypeArguments(Token token) {
    NoTypeArgumentsHandle data = new NoTypeArgumentsHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void beginTypeVariable(Token token) {
    TypeVariableBegin data = new TypeVariableBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void handleTypeVariablesDefined(Token token, int count) {
    TypeVariablesDefinedHandle data = new TypeVariablesDefinedHandle(
      ParserAstType.HANDLE,
      token: token,
      count: count,
    );
    seen(data);
  }

  @override
  void endTypeVariable(
    Token token,
    int index,
    Token? extendsOrSuper,
    Token? variance,
  ) {
    TypeVariableEnd data = new TypeVariableEnd(
      ParserAstType.END,
      token: token,
      index: index,
      extendsOrSuper: extendsOrSuper,
      variance: variance,
    );
    seen(data);
  }

  @override
  void beginTypeVariables(Token token) {
    TypeVariablesBegin data = new TypeVariablesBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endTypeVariables(Token beginToken, Token endToken) {
    TypeVariablesEnd data = new TypeVariablesEnd(
      ParserAstType.END,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginFunctionExpression(Token token) {
    FunctionExpressionBegin data = new FunctionExpressionBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endFunctionExpression(Token beginToken, Token endToken) {
    FunctionExpressionEnd data = new FunctionExpressionEnd(
      ParserAstType.END,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginVariablesDeclaration(
    Token token,
    Token? lateToken,
    Token? varFinalOrConst,
  ) {
    VariablesDeclarationBegin data = new VariablesDeclarationBegin(
      ParserAstType.BEGIN,
      token: token,
      lateToken: lateToken,
      varFinalOrConst: varFinalOrConst,
    );
    seen(data);
  }

  @override
  void endVariablesDeclaration(int count, Token? endToken) {
    VariablesDeclarationEnd data = new VariablesDeclarationEnd(
      ParserAstType.END,
      count: count,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginWhileStatement(Token token) {
    WhileStatementBegin data = new WhileStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endWhileStatement(Token whileKeyword, Token endToken) {
    WhileStatementEnd data = new WhileStatementEnd(
      ParserAstType.END,
      whileKeyword: whileKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginAsOperatorType(Token operator) {
    AsOperatorTypeBegin data = new AsOperatorTypeBegin(
      ParserAstType.BEGIN,
      operator: operator,
    );
    seen(data);
  }

  @override
  void endAsOperatorType(Token operator) {
    AsOperatorTypeEnd data = new AsOperatorTypeEnd(
      ParserAstType.END,
      operator: operator,
    );
    seen(data);
  }

  @override
  void handleAsOperator(Token operator) {
    AsOperatorHandle data = new AsOperatorHandle(
      ParserAstType.HANDLE,
      operator: operator,
    );
    seen(data);
  }

  @override
  void handleCastPattern(Token operator) {
    CastPatternHandle data = new CastPatternHandle(
      ParserAstType.HANDLE,
      operator: operator,
    );
    seen(data);
  }

  @override
  void handleAssignmentExpression(Token token, Token endToken) {
    AssignmentExpressionHandle data = new AssignmentExpressionHandle(
      ParserAstType.HANDLE,
      token: token,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginBinaryExpression(Token token) {
    BinaryExpressionBegin data = new BinaryExpressionBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endBinaryExpression(Token token, Token endToken) {
    BinaryExpressionEnd data = new BinaryExpressionEnd(
      ParserAstType.END,
      token: token,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginBinaryPattern(Token token) {
    BinaryPatternBegin data = new BinaryPatternBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endBinaryPattern(Token token) {
    BinaryPatternEnd data = new BinaryPatternEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void handleDotAccess(Token token, Token endToken, bool isNullAware) {
    DotAccessHandle data = new DotAccessHandle(
      ParserAstType.HANDLE,
      token: token,
      endToken: endToken,
      isNullAware: isNullAware,
    );
    seen(data);
  }

  @override
  void handleCascadeAccess(Token token, Token endToken, bool isNullAware) {
    CascadeAccessHandle data = new CascadeAccessHandle(
      ParserAstType.HANDLE,
      token: token,
      endToken: endToken,
      isNullAware: isNullAware,
    );
    seen(data);
  }

  @override
  void beginConditionalExpression(Token question) {
    ConditionalExpressionBegin data = new ConditionalExpressionBegin(
      ParserAstType.BEGIN,
      question: question,
    );
    seen(data);
  }

  @override
  void handleConditionalExpressionColon() {
    ConditionalExpressionColonHandle data =
        new ConditionalExpressionColonHandle(ParserAstType.HANDLE);
    seen(data);
  }

  @override
  void endConditionalExpression(Token question, Token colon, Token endToken) {
    ConditionalExpressionEnd data = new ConditionalExpressionEnd(
      ParserAstType.END,
      question: question,
      colon: colon,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginConstExpression(Token constKeyword) {
    ConstExpressionBegin data = new ConstExpressionBegin(
      ParserAstType.BEGIN,
      constKeyword: constKeyword,
    );
    seen(data);
  }

  @override
  void endConstExpression(Token token) {
    ConstExpressionEnd data = new ConstExpressionEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void handleConstFactory(Token constKeyword) {
    ConstFactoryHandle data = new ConstFactoryHandle(
      ParserAstType.HANDLE,
      constKeyword: constKeyword,
    );
    seen(data);
  }

  @override
  void beginForControlFlow(Token? awaitToken, Token forToken) {
    ForControlFlowBegin data = new ForControlFlowBegin(
      ParserAstType.BEGIN,
      awaitToken: awaitToken,
      forToken: forToken,
    );
    seen(data);
  }

  @override
  void endForControlFlow(Token token) {
    ForControlFlowEnd data = new ForControlFlowEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void endForInControlFlow(Token token) {
    ForInControlFlowEnd data = new ForInControlFlowEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void beginIfControlFlow(Token ifToken) {
    IfControlFlowBegin data = new IfControlFlowBegin(
      ParserAstType.BEGIN,
      ifToken: ifToken,
    );
    seen(data);
  }

  @override
  void handleThenControlFlow(Token token) {
    ThenControlFlowHandle data = new ThenControlFlowHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleElseControlFlow(Token elseToken) {
    ElseControlFlowHandle data = new ElseControlFlowHandle(
      ParserAstType.HANDLE,
      elseToken: elseToken,
    );
    seen(data);
  }

  @override
  void endIfControlFlow(Token token) {
    IfControlFlowEnd data = new IfControlFlowEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void endIfElseControlFlow(Token token) {
    IfElseControlFlowEnd data = new IfElseControlFlowEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void handleSpreadExpression(Token spreadToken) {
    SpreadExpressionHandle data = new SpreadExpressionHandle(
      ParserAstType.HANDLE,
      spreadToken: spreadToken,
    );
    seen(data);
  }

  @override
  void handleNullAwareElement(Token nullAwareToken) {
    NullAwareElementHandle data = new NullAwareElementHandle(
      ParserAstType.HANDLE,
      nullAwareToken: nullAwareToken,
    );
    seen(data);
  }

  @override
  void handleRestPattern(Token dots, {required bool hasSubPattern}) {
    RestPatternHandle data = new RestPatternHandle(
      ParserAstType.HANDLE,
      dots: dots,
      hasSubPattern: hasSubPattern,
    );
    seen(data);
  }

  @override
  void beginFunctionTypedFormalParameter(Token token) {
    FunctionTypedFormalParameterBegin data =
        new FunctionTypedFormalParameterBegin(
          ParserAstType.BEGIN,
          token: token,
        );
    seen(data);
  }

  @override
  void endFunctionTypedFormalParameter(Token nameToken, Token? question) {
    FunctionTypedFormalParameterEnd data = new FunctionTypedFormalParameterEnd(
      ParserAstType.END,
      nameToken: nameToken,
      question: question,
    );
    seen(data);
  }

  @override
  void handleIdentifier(Token token, IdentifierContext context) {
    IdentifierHandle data = new IdentifierHandle(
      ParserAstType.HANDLE,
      token: token,
      context: context,
    );
    seen(data);
  }

  @override
  void handleIndexedExpression(
    Token? question,
    Token openSquareBracket,
    Token closeSquareBracket,
  ) {
    IndexedExpressionHandle data = new IndexedExpressionHandle(
      ParserAstType.HANDLE,
      question: question,
      openSquareBracket: openSquareBracket,
      closeSquareBracket: closeSquareBracket,
    );
    seen(data);
  }

  @override
  void beginIsOperatorType(Token operator) {
    IsOperatorTypeBegin data = new IsOperatorTypeBegin(
      ParserAstType.BEGIN,
      operator: operator,
    );
    seen(data);
  }

  @override
  void endIsOperatorType(Token operator) {
    IsOperatorTypeEnd data = new IsOperatorTypeEnd(
      ParserAstType.END,
      operator: operator,
    );
    seen(data);
  }

  @override
  void handleIsOperator(Token isOperator, Token? not) {
    IsOperatorHandle data = new IsOperatorHandle(
      ParserAstType.HANDLE,
      isOperator: isOperator,
      not: not,
    );
    seen(data);
  }

  @override
  void handleLiteralBool(Token token) {
    LiteralBoolHandle data = new LiteralBoolHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleBreakStatement(
    bool hasTarget,
    Token breakKeyword,
    Token endToken,
  ) {
    BreakStatementHandle data = new BreakStatementHandle(
      ParserAstType.HANDLE,
      hasTarget: hasTarget,
      breakKeyword: breakKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleContinueStatement(
    bool hasTarget,
    Token continueKeyword,
    Token endToken,
  ) {
    ContinueStatementHandle data = new ContinueStatementHandle(
      ParserAstType.HANDLE,
      hasTarget: hasTarget,
      continueKeyword: continueKeyword,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleEmptyStatement(Token token) {
    EmptyStatementHandle data = new EmptyStatementHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void beginAssert(Token assertKeyword, Assert kind) {
    AssertBegin data = new AssertBegin(
      ParserAstType.BEGIN,
      assertKeyword: assertKeyword,
      kind: kind,
    );
    seen(data);
  }

  @override
  void endAssert(
    Token assertKeyword,
    Assert kind,
    Token leftParenthesis,
    Token? commaToken,
    Token endToken,
  ) {
    AssertEnd data = new AssertEnd(
      ParserAstType.END,
      assertKeyword: assertKeyword,
      kind: kind,
      leftParenthesis: leftParenthesis,
      commaToken: commaToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleLiteralDouble(Token token) {
    LiteralDoubleHandle data = new LiteralDoubleHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleLiteralDoubleWithSeparators(Token token) {
    LiteralDoubleWithSeparatorsHandle data =
        new LiteralDoubleWithSeparatorsHandle(
          ParserAstType.HANDLE,
          token: token,
        );
    seen(data);
  }

  @override
  void handleLiteralInt(Token token) {
    LiteralIntHandle data = new LiteralIntHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleLiteralIntWithSeparators(Token token) {
    LiteralIntWithSeparatorsHandle data = new LiteralIntWithSeparatorsHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleLiteralList(
    int count,
    Token leftBracket,
    Token? constKeyword,
    Token rightBracket,
  ) {
    LiteralListHandle data = new LiteralListHandle(
      ParserAstType.HANDLE,
      count: count,
      leftBracket: leftBracket,
      constKeyword: constKeyword,
      rightBracket: rightBracket,
    );
    seen(data);
  }

  @override
  void handleListPattern(int count, Token leftBracket, Token rightBracket) {
    ListPatternHandle data = new ListPatternHandle(
      ParserAstType.HANDLE,
      count: count,
      leftBracket: leftBracket,
      rightBracket: rightBracket,
    );
    seen(data);
  }

  @override
  void handleLiteralSetOrMap(
    int count,
    Token leftBrace,
    Token? constKeyword,
    Token rightBrace,
    bool hasSetEntry,
  ) {
    LiteralSetOrMapHandle data = new LiteralSetOrMapHandle(
      ParserAstType.HANDLE,
      count: count,
      leftBrace: leftBrace,
      constKeyword: constKeyword,
      rightBrace: rightBrace,
      hasSetEntry: hasSetEntry,
    );
    seen(data);
  }

  @override
  void handleMapPattern(int count, Token leftBrace, Token rightBrace) {
    MapPatternHandle data = new MapPatternHandle(
      ParserAstType.HANDLE,
      count: count,
      leftBrace: leftBrace,
      rightBrace: rightBrace,
    );
    seen(data);
  }

  @override
  void handleLiteralNull(Token token) {
    LiteralNullHandle data = new LiteralNullHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleNativeClause(Token nativeToken, bool hasName) {
    NativeClauseHandle data = new NativeClauseHandle(
      ParserAstType.HANDLE,
      nativeToken: nativeToken,
      hasName: hasName,
    );
    seen(data);
  }

  @override
  void handleNamedArgument(Token colon) {
    NamedArgumentHandle data = new NamedArgumentHandle(
      ParserAstType.HANDLE,
      colon: colon,
    );
    seen(data);
  }

  @override
  void handlePatternField(Token? colon) {
    PatternFieldHandle data = new PatternFieldHandle(
      ParserAstType.HANDLE,
      colon: colon,
    );
    seen(data);
  }

  @override
  void handleNamedRecordField(Token colon) {
    NamedRecordFieldHandle data = new NamedRecordFieldHandle(
      ParserAstType.HANDLE,
      colon: colon,
    );
    seen(data);
  }

  @override
  void beginNewExpression(Token token) {
    NewExpressionBegin data = new NewExpressionBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endNewExpression(Token token) {
    NewExpressionEnd data = new NewExpressionEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void handleNoArguments(Token token) {
    NoArgumentsHandle data = new NoArgumentsHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleNoConstructorReferenceContinuationAfterTypeArguments(Token token) {
    NoConstructorReferenceContinuationAfterTypeArgumentsHandle data =
        new NoConstructorReferenceContinuationAfterTypeArgumentsHandle(
          ParserAstType.HANDLE,
          token: token,
        );
    seen(data);
  }

  @override
  void handleNoTypeNameInConstructorReference(Token token) {
    NoTypeNameInConstructorReferenceHandle data =
        new NoTypeNameInConstructorReferenceHandle(
          ParserAstType.HANDLE,
          token: token,
        );
    seen(data);
  }

  @override
  void handleNoType(Token lastConsumed) {
    NoTypeHandle data = new NoTypeHandle(
      ParserAstType.HANDLE,
      lastConsumed: lastConsumed,
    );
    seen(data);
  }

  @override
  void handleNoTypeVariables(Token token) {
    NoTypeVariablesHandle data = new NoTypeVariablesHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleOperator(Token token) {
    OperatorHandle data = new OperatorHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleSwitchCaseNoWhenClause(Token token) {
    SwitchCaseNoWhenClauseHandle data = new SwitchCaseNoWhenClauseHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleSwitchExpressionCasePattern(Token token) {
    SwitchExpressionCasePatternHandle data =
        new SwitchExpressionCasePatternHandle(
          ParserAstType.HANDLE,
          token: token,
        );
    seen(data);
  }

  @override
  void handleSymbolVoid(Token token) {
    SymbolVoidHandle data = new SymbolVoidHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleOperatorName(Token operatorKeyword, Token token) {
    OperatorNameHandle data = new OperatorNameHandle(
      ParserAstType.HANDLE,
      operatorKeyword: operatorKeyword,
      token: token,
    );
    seen(data);
  }

  @override
  void handleInvalidOperatorName(Token operatorKeyword, Token token) {
    InvalidOperatorNameHandle data = new InvalidOperatorNameHandle(
      ParserAstType.HANDLE,
      operatorKeyword: operatorKeyword,
      token: token,
    );
    seen(data);
  }

  @override
  void handleParenthesizedCondition(Token token, Token? case_, Token? when) {
    ParenthesizedConditionHandle data = new ParenthesizedConditionHandle(
      ParserAstType.HANDLE,
      token: token,
      case_: case_,
      when: when,
    );
    seen(data);
  }

  @override
  void beginPattern(Token token) {
    PatternBegin data = new PatternBegin(ParserAstType.BEGIN, token: token);
    seen(data);
  }

  @override
  void beginPatternGuard(Token when) {
    PatternGuardBegin data = new PatternGuardBegin(
      ParserAstType.BEGIN,
      when: when,
    );
    seen(data);
  }

  @override
  void beginParenthesizedExpressionOrRecordLiteral(Token token) {
    ParenthesizedExpressionOrRecordLiteralBegin data =
        new ParenthesizedExpressionOrRecordLiteralBegin(
          ParserAstType.BEGIN,
          token: token,
        );
    seen(data);
  }

  @override
  void beginSwitchCaseWhenClause(Token when) {
    SwitchCaseWhenClauseBegin data = new SwitchCaseWhenClauseBegin(
      ParserAstType.BEGIN,
      when: when,
    );
    seen(data);
  }

  @override
  void endRecordLiteral(Token token, int count, Token? constKeyword) {
    RecordLiteralEnd data = new RecordLiteralEnd(
      ParserAstType.END,
      token: token,
      count: count,
      constKeyword: constKeyword,
    );
    seen(data);
  }

  @override
  void handleRecordPattern(Token token, int count) {
    RecordPatternHandle data = new RecordPatternHandle(
      ParserAstType.HANDLE,
      token: token,
      count: count,
    );
    seen(data);
  }

  @override
  void endPattern(Token token) {
    PatternEnd data = new PatternEnd(ParserAstType.END, token: token);
    seen(data);
  }

  @override
  void endPatternGuard(Token token) {
    PatternGuardEnd data = new PatternGuardEnd(ParserAstType.END, token: token);
    seen(data);
  }

  @override
  void endParenthesizedExpression(Token token) {
    ParenthesizedExpressionEnd data = new ParenthesizedExpressionEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void endSwitchCaseWhenClause(Token token) {
    SwitchCaseWhenClauseEnd data = new SwitchCaseWhenClauseEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }

  @override
  void handleParenthesizedPattern(Token token) {
    ParenthesizedPatternHandle data = new ParenthesizedPatternHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void beginConstantPattern(Token? constKeyword) {
    ConstantPatternBegin data = new ConstantPatternBegin(
      ParserAstType.BEGIN,
      constKeyword: constKeyword,
    );
    seen(data);
  }

  @override
  void endConstantPattern(Token? constKeyword) {
    ConstantPatternEnd data = new ConstantPatternEnd(
      ParserAstType.END,
      constKeyword: constKeyword,
    );
    seen(data);
  }

  @override
  void handleObjectPattern(
    Token firstIdentifier,
    Token? dot,
    Token? secondIdentifier,
  ) {
    ObjectPatternHandle data = new ObjectPatternHandle(
      ParserAstType.HANDLE,
      firstIdentifier: firstIdentifier,
      dot: dot,
      secondIdentifier: secondIdentifier,
    );
    seen(data);
  }

  @override
  void handleQualified(Token period) {
    QualifiedHandle data = new QualifiedHandle(
      ParserAstType.HANDLE,
      period: period,
    );
    seen(data);
  }

  @override
  void handleStringPart(Token token) {
    StringPartHandle data = new StringPartHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleSuperExpression(Token token, IdentifierContext context) {
    SuperExpressionHandle data = new SuperExpressionHandle(
      ParserAstType.HANDLE,
      token: token,
      context: context,
    );
    seen(data);
  }

  @override
  void handleAugmentSuperExpression(
    Token augmentToken,
    Token superToken,
    IdentifierContext context,
  ) {
    AugmentSuperExpressionHandle data = new AugmentSuperExpressionHandle(
      ParserAstType.HANDLE,
      augmentToken: augmentToken,
      superToken: superToken,
      context: context,
    );
    seen(data);
  }

  @override
  void beginSwitchCase(int labelCount, int expressionCount, Token beginToken) {
    SwitchCaseBegin data = new SwitchCaseBegin(
      ParserAstType.BEGIN,
      labelCount: labelCount,
      expressionCount: expressionCount,
      beginToken: beginToken,
    );
    seen(data);
  }

  @override
  void endSwitchCase(
    int labelCount,
    int expressionCount,
    Token? defaultKeyword,
    Token? colonAfterDefault,
    int statementCount,
    Token beginToken,
    Token endToken,
  ) {
    SwitchCaseEnd data = new SwitchCaseEnd(
      ParserAstType.END,
      labelCount: labelCount,
      expressionCount: expressionCount,
      defaultKeyword: defaultKeyword,
      colonAfterDefault: colonAfterDefault,
      statementCount: statementCount,
      beginToken: beginToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void beginSwitchExpressionCase() {
    SwitchExpressionCaseBegin data = new SwitchExpressionCaseBegin(
      ParserAstType.BEGIN,
    );
    seen(data);
  }

  @override
  void endSwitchExpressionCase(
    Token beginToken,
    Token? when,
    Token arrow,
    Token endToken,
  ) {
    SwitchExpressionCaseEnd data = new SwitchExpressionCaseEnd(
      ParserAstType.END,
      beginToken: beginToken,
      when: when,
      arrow: arrow,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleThisExpression(Token token, IdentifierContext context) {
    ThisExpressionHandle data = new ThisExpressionHandle(
      ParserAstType.HANDLE,
      token: token,
      context: context,
    );
    seen(data);
  }

  @override
  void handleUnaryPostfixAssignmentExpression(Token token) {
    UnaryPostfixAssignmentExpressionHandle data =
        new UnaryPostfixAssignmentExpressionHandle(
          ParserAstType.HANDLE,
          token: token,
        );
    seen(data);
  }

  @override
  void handleUnaryPrefixExpression(Token token) {
    UnaryPrefixExpressionHandle data = new UnaryPrefixExpressionHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleRelationalPattern(Token token) {
    RelationalPatternHandle data = new RelationalPatternHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleUnaryPrefixAssignmentExpression(Token token) {
    UnaryPrefixAssignmentExpressionHandle data =
        new UnaryPrefixAssignmentExpressionHandle(
          ParserAstType.HANDLE,
          token: token,
        );
    seen(data);
  }

  @override
  void beginFormalParameterDefaultValueExpression() {
    FormalParameterDefaultValueExpressionBegin data =
        new FormalParameterDefaultValueExpressionBegin(ParserAstType.BEGIN);
    seen(data);
  }

  @override
  void endFormalParameterDefaultValueExpression() {
    FormalParameterDefaultValueExpressionEnd data =
        new FormalParameterDefaultValueExpressionEnd(ParserAstType.END);
    seen(data);
  }

  @override
  void handleValuedFormalParameter(
    Token equals,
    Token token,
    FormalParameterKind kind,
  ) {
    ValuedFormalParameterHandle data = new ValuedFormalParameterHandle(
      ParserAstType.HANDLE,
      equals: equals,
      token: token,
      kind: kind,
    );
    seen(data);
  }

  @override
  void handleFormalParameterWithoutValue(Token token) {
    FormalParameterWithoutValueHandle data =
        new FormalParameterWithoutValueHandle(
          ParserAstType.HANDLE,
          token: token,
        );
    seen(data);
  }

  @override
  void handleVoidKeyword(Token token) {
    VoidKeywordHandle data = new VoidKeywordHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleVoidKeywordWithTypeArguments(Token token) {
    VoidKeywordWithTypeArgumentsHandle data =
        new VoidKeywordWithTypeArgumentsHandle(
          ParserAstType.HANDLE,
          token: token,
        );
    seen(data);
  }

  @override
  void beginYieldStatement(Token token) {
    YieldStatementBegin data = new YieldStatementBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endYieldStatement(Token yieldToken, Token? starToken, Token endToken) {
    YieldStatementEnd data = new YieldStatementEnd(
      ParserAstType.END,
      yieldToken: yieldToken,
      starToken: starToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void endInvalidYieldStatement(
    Token beginToken,
    Token? starToken,
    Token endToken,
    MessageCode errorCode,
  ) {
    InvalidYieldStatementEnd data = new InvalidYieldStatementEnd(
      ParserAstType.END,
      beginToken: beginToken,
      starToken: starToken,
      endToken: endToken,
      errorCode: errorCode,
    );
    seen(data);
  }

  @override
  void handleRecoverableError(
    Message message,
    Token startToken,
    Token endToken,
  ) {
    RecoverableErrorHandle data = new RecoverableErrorHandle(
      ParserAstType.HANDLE,
      message: message,
      startToken: startToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleExperimentNotEnabled(
    ExperimentalFlag experimentalFlag,
    Token startToken,
    Token endToken,
  ) {
    ExperimentNotEnabledHandle data = new ExperimentNotEnabledHandle(
      ParserAstType.HANDLE,
      experimentalFlag: experimentalFlag,
      startToken: startToken,
      endToken: endToken,
    );
    seen(data);
  }

  @override
  void handleErrorToken(ErrorToken token) {
    ErrorTokenHandle data = new ErrorTokenHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleUnescapeError(
    Message message,
    Token location,
    int stringOffset,
    int length,
  ) {
    UnescapeErrorHandle data = new UnescapeErrorHandle(
      ParserAstType.HANDLE,
      message: message,
      location: location,
      stringOffset: stringOffset,
      length: length,
    );
    seen(data);
  }

  @override
  void handleInvalidStatement(Token token, Message message) {
    InvalidStatementHandle data = new InvalidStatementHandle(
      ParserAstType.HANDLE,
      token: token,
      message: message,
    );
    seen(data);
  }

  @override
  void handleScript(Token token) {
    ScriptHandle data = new ScriptHandle(ParserAstType.HANDLE, token: token);
    seen(data);
  }

  @override
  void handleTypeArgumentApplication(Token openAngleBracket) {
    TypeArgumentApplicationHandle data = new TypeArgumentApplicationHandle(
      ParserAstType.HANDLE,
      openAngleBracket: openAngleBracket,
    );
    seen(data);
  }

  @override
  void handleNewAsIdentifier(Token token) {
    NewAsIdentifierHandle data = new NewAsIdentifierHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handlePatternVariableDeclarationStatement(
    Token keyword,
    Token equals,
    Token semicolon,
  ) {
    PatternVariableDeclarationStatementHandle data =
        new PatternVariableDeclarationStatementHandle(
          ParserAstType.HANDLE,
          keyword: keyword,
          equals: equals,
          semicolon: semicolon,
        );
    seen(data);
  }

  @override
  void handlePatternAssignment(Token equals) {
    PatternAssignmentHandle data = new PatternAssignmentHandle(
      ParserAstType.HANDLE,
      equals: equals,
    );
    seen(data);
  }

  @override
  void handleDotShorthandContext(Token token) {
    DotShorthandContextHandle data = new DotShorthandContextHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void handleDotShorthandHead(Token token) {
    DotShorthandHeadHandle data = new DotShorthandHeadHandle(
      ParserAstType.HANDLE,
      token: token,
    );
    seen(data);
  }

  @override
  void beginConstDotShorthand(Token token) {
    ConstDotShorthandBegin data = new ConstDotShorthandBegin(
      ParserAstType.BEGIN,
      token: token,
    );
    seen(data);
  }

  @override
  void endConstDotShorthand(Token token) {
    ConstDotShorthandEnd data = new ConstDotShorthandEnd(
      ParserAstType.END,
      token: token,
    );
    seen(data);
  }
}

class ArgumentsBegin extends ParserAstNode {
  final Token token;

  ArgumentsBegin(ParserAstType type, {required this.token})
    : super("Arguments", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitArgumentsBegin(this);
}

class ArgumentsEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ArgumentsEnd(
    ParserAstType type, {
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("Arguments", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitArgumentsEnd(this);
}

class ObjectPatternFieldsHandle extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ObjectPatternFieldsHandle(
    ParserAstType type, {
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("ObjectPatternFields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitObjectPatternFieldsHandle(this);
}

class AsyncModifierHandle extends ParserAstNode {
  final Token? asyncToken;
  final Token? starToken;

  AsyncModifierHandle(ParserAstType type, {this.asyncToken, this.starToken})
    : super("AsyncModifier", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "asyncToken": asyncToken,
    "starToken": starToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitAsyncModifierHandle(this);
}

class AwaitExpressionBegin extends ParserAstNode {
  final Token token;

  AwaitExpressionBegin(ParserAstType type, {required this.token})
    : super("AwaitExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitAwaitExpressionBegin(this);
}

class AwaitExpressionEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  AwaitExpressionEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("AwaitExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitAwaitExpressionEnd(this);
}

class InvalidAwaitExpressionEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;
  final MessageCode errorCode;

  InvalidAwaitExpressionEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
    required this.errorCode,
  }) : super("InvalidAwaitExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
    "errorCode": errorCode,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidAwaitExpressionEnd(this);
}

class BlockBegin extends ParserAstNode {
  final Token token;
  final BlockKind blockKind;

  BlockBegin(ParserAstType type, {required this.token, required this.blockKind})
    : super("Block", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "blockKind": blockKind,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitBlockBegin(this);
}

class BlockEnd extends ParserAstNode implements BeginAndEndTokenParserAstNode {
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;
  final BlockKind blockKind;

  BlockEnd(
    ParserAstType type, {
    required this.count,
    required this.beginToken,
    required this.endToken,
    required this.blockKind,
  }) : super("Block", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
    "blockKind": blockKind,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitBlockEnd(this);
}

class InvalidTopLevelBlockHandle extends ParserAstNode {
  final Token token;

  InvalidTopLevelBlockHandle(ParserAstType type, {required this.token})
    : super("InvalidTopLevelBlock", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidTopLevelBlockHandle(this);
}

class CascadeBegin extends ParserAstNode {
  final Token token;

  CascadeBegin(ParserAstType type, {required this.token})
    : super("Cascade", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCascadeBegin(this);
}

class CascadeEnd extends ParserAstNode {
  CascadeEnd(ParserAstType type) : super("Cascade", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCascadeEnd(this);
}

class CaseExpressionBegin extends ParserAstNode {
  final Token caseKeyword;

  CaseExpressionBegin(ParserAstType type, {required this.caseKeyword})
    : super("CaseExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"caseKeyword": caseKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCaseExpressionBegin(this);
}

class CaseExpressionEnd extends ParserAstNode {
  final Token caseKeyword;
  final Token? when;
  final Token colon;

  CaseExpressionEnd(
    ParserAstType type, {
    required this.caseKeyword,
    this.when,
    required this.colon,
  }) : super("CaseExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "caseKeyword": caseKeyword,
    "when": when,
    "colon": colon,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCaseExpressionEnd(this);
}

class ClassOrMixinOrExtensionBodyBegin extends ParserAstNode {
  final DeclarationKind kind;
  final Token token;

  ClassOrMixinOrExtensionBodyBegin(
    ParserAstType type, {
    required this.kind,
    required this.token,
  }) : super("ClassOrMixinOrExtensionBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "kind": kind,
    "token": token,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitClassOrMixinOrExtensionBodyBegin(this);
}

class ClassOrMixinOrExtensionBodyEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final DeclarationKind kind;
  final int memberCount;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ClassOrMixinOrExtensionBodyEnd(
    ParserAstType type, {
    required this.kind,
    required this.memberCount,
    required this.beginToken,
    required this.endToken,
  }) : super("ClassOrMixinOrExtensionBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "kind": kind,
    "memberCount": memberCount,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitClassOrMixinOrExtensionBodyEnd(this);
}

class ClassOrMixinOrNamedMixinApplicationPreludeBegin extends ParserAstNode {
  final Token token;

  ClassOrMixinOrNamedMixinApplicationPreludeBegin(
    ParserAstType type, {
    required this.token,
  }) : super("ClassOrMixinOrNamedMixinApplicationPrelude", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitClassOrMixinOrNamedMixinApplicationPreludeBegin(this);
}

class ClassDeclarationBegin extends ParserAstNode {
  final Token begin;
  final Token? abstractToken;
  final Token? macroToken;
  final Token? sealedToken;
  final Token? baseToken;
  final Token? interfaceToken;
  final Token? finalToken;
  final Token? augmentToken;
  final Token? mixinToken;
  final Token name;

  ClassDeclarationBegin(
    ParserAstType type, {
    required this.begin,
    this.abstractToken,
    this.macroToken,
    this.sealedToken,
    this.baseToken,
    this.interfaceToken,
    this.finalToken,
    this.augmentToken,
    this.mixinToken,
    required this.name,
  }) : super("ClassDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "begin": begin,
    "abstractToken": abstractToken,
    "macroToken": macroToken,
    "sealedToken": sealedToken,
    "baseToken": baseToken,
    "interfaceToken": interfaceToken,
    "finalToken": finalToken,
    "augmentToken": augmentToken,
    "mixinToken": mixinToken,
    "name": name,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassDeclarationBegin(this);
}

class ClassExtendsHandle extends ParserAstNode {
  final Token? extendsKeyword;
  final int typeCount;

  ClassExtendsHandle(
    ParserAstType type, {
    this.extendsKeyword,
    required this.typeCount,
  }) : super("ClassExtends", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "extendsKeyword": extendsKeyword,
    "typeCount": typeCount,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassExtendsHandle(this);
}

class ImplementsHandle extends ParserAstNode {
  final Token? implementsKeyword;
  final int interfacesCount;

  ImplementsHandle(
    ParserAstType type, {
    this.implementsKeyword,
    required this.interfacesCount,
  }) : super("Implements", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "implementsKeyword": implementsKeyword,
    "interfacesCount": interfacesCount,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitImplementsHandle(this);
}

class ClassHeaderHandle extends ParserAstNode {
  final Token begin;
  final Token classKeyword;
  final Token? nativeToken;

  ClassHeaderHandle(
    ParserAstType type, {
    required this.begin,
    required this.classKeyword,
    this.nativeToken,
  }) : super("ClassHeader", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "begin": begin,
    "classKeyword": classKeyword,
    "nativeToken": nativeToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassHeaderHandle(this);
}

class RecoverDeclarationHeaderHandle extends ParserAstNode {
  final DeclarationHeaderKind kind;

  RecoverDeclarationHeaderHandle(ParserAstType type, {required this.kind})
    : super("RecoverDeclarationHeader", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"kind": kind};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitRecoverDeclarationHeaderHandle(this);
}

class ClassDeclarationEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ClassDeclarationEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("ClassDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassDeclarationEnd(this);
}

class MixinDeclarationBegin extends ParserAstNode {
  final Token beginToken;
  final Token? augmentToken;
  final Token? baseToken;
  final Token mixinKeyword;
  final Token name;

  MixinDeclarationBegin(
    ParserAstType type, {
    required this.beginToken,
    this.augmentToken,
    this.baseToken,
    required this.mixinKeyword,
    required this.name,
  }) : super("MixinDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "augmentToken": augmentToken,
    "baseToken": baseToken,
    "mixinKeyword": mixinKeyword,
    "name": name,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMixinDeclarationBegin(this);
}

class MixinOnHandle extends ParserAstNode {
  final Token? onKeyword;
  final int typeCount;

  MixinOnHandle(ParserAstType type, {this.onKeyword, required this.typeCount})
    : super("MixinOn", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "onKeyword": onKeyword,
    "typeCount": typeCount,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMixinOnHandle(this);
}

class MixinHeaderHandle extends ParserAstNode {
  final Token mixinKeyword;

  MixinHeaderHandle(ParserAstType type, {required this.mixinKeyword})
    : super("MixinHeader", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "mixinKeyword": mixinKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMixinHeaderHandle(this);
}

class RecoverMixinHeaderHandle extends ParserAstNode {
  RecoverMixinHeaderHandle(ParserAstType type)
    : super("RecoverMixinHeader", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecoverMixinHeaderHandle(this);
}

class MixinDeclarationEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  MixinDeclarationEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("MixinDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMixinDeclarationEnd(this);
}

class UncategorizedTopLevelDeclarationBegin extends ParserAstNode {
  final Token token;

  UncategorizedTopLevelDeclarationBegin(
    ParserAstType type, {
    required this.token,
  }) : super("UncategorizedTopLevelDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitUncategorizedTopLevelDeclarationBegin(this);
}

class ExtensionDeclarationPreludeBegin extends ParserAstNode {
  final Token extensionKeyword;

  ExtensionDeclarationPreludeBegin(
    ParserAstType type, {
    required this.extensionKeyword,
  }) : super("ExtensionDeclarationPrelude", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "extensionKeyword": extensionKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitExtensionDeclarationPreludeBegin(this);
}

class ExtensionDeclarationBegin extends ParserAstNode {
  final Token? augmentToken;
  final Token extensionKeyword;
  final Token? name;

  ExtensionDeclarationBegin(
    ParserAstType type, {
    this.augmentToken,
    required this.extensionKeyword,
    this.name,
  }) : super("ExtensionDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "augmentToken": augmentToken,
    "extensionKeyword": extensionKeyword,
    "name": name,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExtensionDeclarationBegin(this);
}

class ExtensionDeclarationEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token extensionKeyword;
  final Token? onKeyword;
  @override
  final Token endToken;

  ExtensionDeclarationEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.extensionKeyword,
    this.onKeyword,
    required this.endToken,
  }) : super("ExtensionDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "extensionKeyword": extensionKeyword,
    "onKeyword": onKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExtensionDeclarationEnd(this);
}

class ExtensionTypeDeclarationBegin extends ParserAstNode {
  final Token? augmentKeyword;
  final Token extensionKeyword;
  final Token name;

  ExtensionTypeDeclarationBegin(
    ParserAstType type, {
    this.augmentKeyword,
    required this.extensionKeyword,
    required this.name,
  }) : super("ExtensionTypeDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "augmentKeyword": augmentKeyword,
    "extensionKeyword": extensionKeyword,
    "name": name,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitExtensionTypeDeclarationBegin(this);
}

class ExtensionTypeDeclarationEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token? augmentToken;
  final Token extensionKeyword;
  final Token typeKeyword;
  @override
  final Token endToken;

  ExtensionTypeDeclarationEnd(
    ParserAstType type, {
    required this.beginToken,
    this.augmentToken,
    required this.extensionKeyword,
    required this.typeKeyword,
    required this.endToken,
  }) : super("ExtensionTypeDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "augmentToken": augmentToken,
    "extensionKeyword": extensionKeyword,
    "typeKeyword": typeKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitExtensionTypeDeclarationEnd(this);
}

class PrimaryConstructorBegin extends ParserAstNode {
  final Token beginToken;

  PrimaryConstructorBegin(ParserAstType type, {required this.beginToken})
    : super("PrimaryConstructor", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"beginToken": beginToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPrimaryConstructorBegin(this);
}

class PrimaryConstructorEnd extends ParserAstNode {
  final Token beginToken;
  final Token? constKeyword;
  final bool hasConstructorName;

  PrimaryConstructorEnd(
    ParserAstType type, {
    required this.beginToken,
    this.constKeyword,
    required this.hasConstructorName,
  }) : super("PrimaryConstructor", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "constKeyword": constKeyword,
    "hasConstructorName": hasConstructorName,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPrimaryConstructorEnd(this);
}

class NoPrimaryConstructorHandle extends ParserAstNode {
  final Token token;
  final Token? constKeyword;

  NoPrimaryConstructorHandle(
    ParserAstType type, {
    required this.token,
    this.constKeyword,
  }) : super("NoPrimaryConstructor", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "constKeyword": constKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoPrimaryConstructorHandle(this);
}

class CombinatorsBegin extends ParserAstNode {
  final Token token;

  CombinatorsBegin(ParserAstType type, {required this.token})
    : super("Combinators", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCombinatorsBegin(this);
}

class CombinatorsEnd extends ParserAstNode {
  final int count;

  CombinatorsEnd(ParserAstType type, {required this.count})
    : super("Combinators", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"count": count};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCombinatorsEnd(this);
}

class CompilationUnitBegin extends ParserAstNode {
  final Token token;

  CompilationUnitBegin(ParserAstType type, {required this.token})
    : super("CompilationUnit", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCompilationUnitBegin(this);
}

class DirectivesOnlyHandle extends ParserAstNode {
  DirectivesOnlyHandle(ParserAstType type) : super("DirectivesOnly", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitDirectivesOnlyHandle(this);
}

class CompilationUnitEnd extends ParserAstNode {
  final int count;
  final Token token;

  CompilationUnitEnd(
    ParserAstType type, {
    required this.count,
    required this.token,
  }) : super("CompilationUnit", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "token": token,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCompilationUnitEnd(this);
}

class ConstLiteralBegin extends ParserAstNode {
  final Token token;

  ConstLiteralBegin(ParserAstType type, {required this.token})
    : super("ConstLiteral", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstLiteralBegin(this);
}

class ConstLiteralEnd extends ParserAstNode {
  final Token endToken;

  ConstLiteralEnd(ParserAstType type, {required this.endToken})
    : super("ConstLiteral", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstLiteralEnd(this);
}

class ConstructorReferenceBegin extends ParserAstNode {
  final Token start;

  ConstructorReferenceBegin(ParserAstType type, {required this.start})
    : super("ConstructorReference", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"start": start};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstructorReferenceBegin(this);
}

class ConstructorReferenceEnd extends ParserAstNode {
  final Token start;
  final Token? periodBeforeName;
  final Token endToken;
  final ConstructorReferenceContext constructorReferenceContext;

  ConstructorReferenceEnd(
    ParserAstType type, {
    required this.start,
    this.periodBeforeName,
    required this.endToken,
    required this.constructorReferenceContext,
  }) : super("ConstructorReference", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "start": start,
    "periodBeforeName": periodBeforeName,
    "endToken": endToken,
    "constructorReferenceContext": constructorReferenceContext,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstructorReferenceEnd(this);
}

class DoWhileStatementBegin extends ParserAstNode {
  final Token token;

  DoWhileStatementBegin(ParserAstType type, {required this.token})
    : super("DoWhileStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitDoWhileStatementBegin(this);
}

class DoWhileStatementEnd extends ParserAstNode {
  final Token doKeyword;
  final Token whileKeyword;
  final Token endToken;

  DoWhileStatementEnd(
    ParserAstType type, {
    required this.doKeyword,
    required this.whileKeyword,
    required this.endToken,
  }) : super("DoWhileStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "doKeyword": doKeyword,
    "whileKeyword": whileKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitDoWhileStatementEnd(this);
}

class DoWhileStatementBodyBegin extends ParserAstNode {
  final Token token;

  DoWhileStatementBodyBegin(ParserAstType type, {required this.token})
    : super("DoWhileStatementBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitDoWhileStatementBodyBegin(this);
}

class DoWhileStatementBodyEnd extends ParserAstNode {
  final Token token;

  DoWhileStatementBodyEnd(ParserAstType type, {required this.token})
    : super("DoWhileStatementBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitDoWhileStatementBodyEnd(this);
}

class WhileStatementBodyBegin extends ParserAstNode {
  final Token token;

  WhileStatementBodyBegin(ParserAstType type, {required this.token})
    : super("WhileStatementBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitWhileStatementBodyBegin(this);
}

class WhileStatementBodyEnd extends ParserAstNode {
  final Token endToken;

  WhileStatementBodyEnd(ParserAstType type, {required this.endToken})
    : super("WhileStatementBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitWhileStatementBodyEnd(this);
}

class EnumBegin extends ParserAstNode {
  final Token enumKeyword;

  EnumBegin(ParserAstType type, {required this.enumKeyword})
    : super("Enum", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"enumKeyword": enumKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumBegin(this);
}

class EnumEnd extends ParserAstNode implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token enumKeyword;
  final Token leftBrace;
  final int memberCount;
  @override
  final Token endToken;

  EnumEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.enumKeyword,
    required this.leftBrace,
    required this.memberCount,
    required this.endToken,
  }) : super("Enum", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "enumKeyword": enumKeyword,
    "leftBrace": leftBrace,
    "memberCount": memberCount,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumEnd(this);
}

class EnumConstructorEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  EnumConstructorEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("EnumConstructor", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumConstructorEnd(this);
}

class EnumElementsHandle extends ParserAstNode {
  final Token elementsEndToken;
  final int elementsCount;

  EnumElementsHandle(
    ParserAstType type, {
    required this.elementsEndToken,
    required this.elementsCount,
  }) : super("EnumElements", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "elementsEndToken": elementsEndToken,
    "elementsCount": elementsCount,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumElementsHandle(this);
}

class EnumHeaderHandle extends ParserAstNode {
  final Token? augmentToken;
  final Token enumKeyword;
  final Token leftBrace;

  EnumHeaderHandle(
    ParserAstType type, {
    this.augmentToken,
    required this.enumKeyword,
    required this.leftBrace,
  }) : super("EnumHeader", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "augmentToken": augmentToken,
    "enumKeyword": enumKeyword,
    "leftBrace": leftBrace,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumHeaderHandle(this);
}

class EnumElementHandle extends ParserAstNode {
  final Token beginToken;
  final Token? augmentToken;

  EnumElementHandle(
    ParserAstType type, {
    required this.beginToken,
    this.augmentToken,
  }) : super("EnumElement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "augmentToken": augmentToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumElementHandle(this);
}

class EnumFactoryMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token factoryKeyword;
  @override
  final Token endToken;

  EnumFactoryMethodEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.factoryKeyword,
    required this.endToken,
  }) : super("EnumFactoryMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "factoryKeyword": factoryKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumFactoryMethodEnd(this);
}

class ExportBegin extends ParserAstNode {
  final Token token;

  ExportBegin(ParserAstType type, {required this.token})
    : super("Export", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExportBegin(this);
}

class ExportEnd extends ParserAstNode {
  final Token exportKeyword;
  final Token semicolon;

  ExportEnd(
    ParserAstType type, {
    required this.exportKeyword,
    required this.semicolon,
  }) : super("Export", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "exportKeyword": exportKeyword,
    "semicolon": semicolon,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExportEnd(this);
}

class ExtraneousExpressionHandle extends ParserAstNode {
  final Token token;
  final Message message;

  ExtraneousExpressionHandle(
    ParserAstType type, {
    required this.token,
    required this.message,
  }) : super("ExtraneousExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "message": message,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExtraneousExpressionHandle(this);
}

class ExpressionStatementHandle extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ExpressionStatementHandle(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("ExpressionStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExpressionStatementHandle(this);
}

class FactoryMethodBegin extends ParserAstNode {
  final DeclarationKind declarationKind;
  final Token lastConsumed;
  final Token? externalToken;
  final Token? constToken;

  FactoryMethodBegin(
    ParserAstType type, {
    required this.declarationKind,
    required this.lastConsumed,
    this.externalToken,
    this.constToken,
  }) : super("FactoryMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "declarationKind": declarationKind,
    "lastConsumed": lastConsumed,
    "externalToken": externalToken,
    "constToken": constToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFactoryMethodBegin(this);
}

class ClassFactoryMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token factoryKeyword;
  @override
  final Token endToken;

  ClassFactoryMethodEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.factoryKeyword,
    required this.endToken,
  }) : super("ClassFactoryMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "factoryKeyword": factoryKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassFactoryMethodEnd(this);
}

class MixinFactoryMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token factoryKeyword;
  @override
  final Token endToken;

  MixinFactoryMethodEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.factoryKeyword,
    required this.endToken,
  }) : super("MixinFactoryMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "factoryKeyword": factoryKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMixinFactoryMethodEnd(this);
}

class ExtensionFactoryMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token factoryKeyword;
  @override
  final Token endToken;

  ExtensionFactoryMethodEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.factoryKeyword,
    required this.endToken,
  }) : super("ExtensionFactoryMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "factoryKeyword": factoryKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExtensionFactoryMethodEnd(this);
}

class ExtensionTypeFactoryMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token factoryKeyword;
  @override
  final Token endToken;

  ExtensionTypeFactoryMethodEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.factoryKeyword,
    required this.endToken,
  }) : super("ExtensionTypeFactoryMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "factoryKeyword": factoryKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitExtensionTypeFactoryMethodEnd(this);
}

class FormalParameterBegin extends ParserAstNode {
  final Token token;
  final MemberKind kind;
  final Token? requiredToken;
  final Token? covariantToken;
  final Token? varFinalOrConst;

  FormalParameterBegin(
    ParserAstType type, {
    required this.token,
    required this.kind,
    this.requiredToken,
    this.covariantToken,
    this.varFinalOrConst,
  }) : super("FormalParameter", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "kind": kind,
    "requiredToken": requiredToken,
    "covariantToken": covariantToken,
    "varFinalOrConst": varFinalOrConst,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFormalParameterBegin(this);
}

class FormalParameterEnd extends ParserAstNode {
  final Token? thisKeyword;
  final Token? superKeyword;
  final Token? periodAfterThisOrSuper;
  final Token nameToken;
  final Token? initializerStart;
  final Token? initializerEnd;
  final FormalParameterKind kind;
  final MemberKind memberKind;

  FormalParameterEnd(
    ParserAstType type, {
    this.thisKeyword,
    this.superKeyword,
    this.periodAfterThisOrSuper,
    required this.nameToken,
    this.initializerStart,
    this.initializerEnd,
    required this.kind,
    required this.memberKind,
  }) : super("FormalParameter", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "thisKeyword": thisKeyword,
    "superKeyword": superKeyword,
    "periodAfterThisOrSuper": periodAfterThisOrSuper,
    "nameToken": nameToken,
    "initializerStart": initializerStart,
    "initializerEnd": initializerEnd,
    "kind": kind,
    "memberKind": memberKind,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFormalParameterEnd(this);
}

class NoFormalParametersHandle extends ParserAstNode {
  final Token token;
  final MemberKind kind;

  NoFormalParametersHandle(
    ParserAstType type, {
    required this.token,
    required this.kind,
  }) : super("NoFormalParameters", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "kind": kind,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoFormalParametersHandle(this);
}

class FormalParametersBegin extends ParserAstNode {
  final Token token;
  final MemberKind kind;

  FormalParametersBegin(
    ParserAstType type, {
    required this.token,
    required this.kind,
  }) : super("FormalParameters", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "kind": kind,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFormalParametersBegin(this);
}

class FormalParametersEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;
  final MemberKind kind;

  FormalParametersEnd(
    ParserAstType type, {
    required this.count,
    required this.beginToken,
    required this.endToken,
    required this.kind,
  }) : super("FormalParameters", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
    "kind": kind,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFormalParametersEnd(this);
}

class ClassFieldsEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? abstractToken;
  final Token? augmentToken;
  final Token? externalToken;
  final Token? staticToken;
  final Token? covariantToken;
  final Token? lateToken;
  final Token? varFinalOrConst;
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ClassFieldsEnd(
    ParserAstType type, {
    this.abstractToken,
    this.augmentToken,
    this.externalToken,
    this.staticToken,
    this.covariantToken,
    this.lateToken,
    this.varFinalOrConst,
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("ClassFields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "abstractToken": abstractToken,
    "augmentToken": augmentToken,
    "externalToken": externalToken,
    "staticToken": staticToken,
    "covariantToken": covariantToken,
    "lateToken": lateToken,
    "varFinalOrConst": varFinalOrConst,
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassFieldsEnd(this);
}

class MixinFieldsEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? abstractToken;
  final Token? augmentToken;
  final Token? externalToken;
  final Token? staticToken;
  final Token? covariantToken;
  final Token? lateToken;
  final Token? varFinalOrConst;
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  MixinFieldsEnd(
    ParserAstType type, {
    this.abstractToken,
    this.augmentToken,
    this.externalToken,
    this.staticToken,
    this.covariantToken,
    this.lateToken,
    this.varFinalOrConst,
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("MixinFields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "abstractToken": abstractToken,
    "augmentToken": augmentToken,
    "externalToken": externalToken,
    "staticToken": staticToken,
    "covariantToken": covariantToken,
    "lateToken": lateToken,
    "varFinalOrConst": varFinalOrConst,
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMixinFieldsEnd(this);
}

class ExtensionFieldsEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? abstractToken;
  final Token? augmentToken;
  final Token? externalToken;
  final Token? staticToken;
  final Token? covariantToken;
  final Token? lateToken;
  final Token? varFinalOrConst;
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ExtensionFieldsEnd(
    ParserAstType type, {
    this.abstractToken,
    this.augmentToken,
    this.externalToken,
    this.staticToken,
    this.covariantToken,
    this.lateToken,
    this.varFinalOrConst,
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("ExtensionFields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "abstractToken": abstractToken,
    "augmentToken": augmentToken,
    "externalToken": externalToken,
    "staticToken": staticToken,
    "covariantToken": covariantToken,
    "lateToken": lateToken,
    "varFinalOrConst": varFinalOrConst,
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExtensionFieldsEnd(this);
}

class ExtensionTypeFieldsEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? abstractToken;
  final Token? augmentToken;
  final Token? externalToken;
  final Token? staticToken;
  final Token? covariantToken;
  final Token? lateToken;
  final Token? varFinalOrConst;
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ExtensionTypeFieldsEnd(
    ParserAstType type, {
    this.abstractToken,
    this.augmentToken,
    this.externalToken,
    this.staticToken,
    this.covariantToken,
    this.lateToken,
    this.varFinalOrConst,
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("ExtensionTypeFields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "abstractToken": abstractToken,
    "augmentToken": augmentToken,
    "externalToken": externalToken,
    "staticToken": staticToken,
    "covariantToken": covariantToken,
    "lateToken": lateToken,
    "varFinalOrConst": varFinalOrConst,
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExtensionTypeFieldsEnd(this);
}

class EnumFieldsEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? abstractToken;
  final Token? augmentToken;
  final Token? externalToken;
  final Token? staticToken;
  final Token? covariantToken;
  final Token? lateToken;
  final Token? varFinalOrConst;
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  EnumFieldsEnd(
    ParserAstType type, {
    this.abstractToken,
    this.augmentToken,
    this.externalToken,
    this.staticToken,
    this.covariantToken,
    this.lateToken,
    this.varFinalOrConst,
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("EnumFields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "abstractToken": abstractToken,
    "augmentToken": augmentToken,
    "externalToken": externalToken,
    "staticToken": staticToken,
    "covariantToken": covariantToken,
    "lateToken": lateToken,
    "varFinalOrConst": varFinalOrConst,
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumFieldsEnd(this);
}

class EnumMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  EnumMethodEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("EnumMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumMethodEnd(this);
}

class ForInitializerEmptyStatementHandle extends ParserAstNode {
  final Token token;

  ForInitializerEmptyStatementHandle(ParserAstType type, {required this.token})
    : super("ForInitializerEmptyStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitForInitializerEmptyStatementHandle(this);
}

class ForInitializerExpressionStatementHandle extends ParserAstNode {
  final Token token;
  final bool forIn;

  ForInitializerExpressionStatementHandle(
    ParserAstType type, {
    required this.token,
    required this.forIn,
  }) : super("ForInitializerExpressionStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "forIn": forIn,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitForInitializerExpressionStatementHandle(this);
}

class ForInitializerLocalVariableDeclarationHandle extends ParserAstNode {
  final Token token;
  final bool forIn;

  ForInitializerLocalVariableDeclarationHandle(
    ParserAstType type, {
    required this.token,
    required this.forIn,
  }) : super("ForInitializerLocalVariableDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "forIn": forIn,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitForInitializerLocalVariableDeclarationHandle(this);
}

class ForInitializerPatternVariableAssignmentHandle extends ParserAstNode {
  final Token keyword;
  final Token equals;

  ForInitializerPatternVariableAssignmentHandle(
    ParserAstType type, {
    required this.keyword,
    required this.equals,
  }) : super("ForInitializerPatternVariableAssignment", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "keyword": keyword,
    "equals": equals,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitForInitializerPatternVariableAssignmentHandle(this);
}

class ForStatementBegin extends ParserAstNode {
  final Token token;

  ForStatementBegin(ParserAstType type, {required this.token})
    : super("ForStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForStatementBegin(this);
}

class ForLoopPartsHandle extends ParserAstNode {
  final Token forKeyword;
  final Token leftParen;
  final Token leftSeparator;
  final Token rightSeparator;
  final int updateExpressionCount;

  ForLoopPartsHandle(
    ParserAstType type, {
    required this.forKeyword,
    required this.leftParen,
    required this.leftSeparator,
    required this.rightSeparator,
    required this.updateExpressionCount,
  }) : super("ForLoopParts", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "forKeyword": forKeyword,
    "leftParen": leftParen,
    "leftSeparator": leftSeparator,
    "rightSeparator": rightSeparator,
    "updateExpressionCount": updateExpressionCount,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForLoopPartsHandle(this);
}

class ForStatementEnd extends ParserAstNode {
  final Token endToken;

  ForStatementEnd(ParserAstType type, {required this.endToken})
    : super("ForStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForStatementEnd(this);
}

class ForStatementBodyBegin extends ParserAstNode {
  final Token token;

  ForStatementBodyBegin(ParserAstType type, {required this.token})
    : super("ForStatementBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForStatementBodyBegin(this);
}

class ForStatementBodyEnd extends ParserAstNode {
  final Token endToken;

  ForStatementBodyEnd(ParserAstType type, {required this.endToken})
    : super("ForStatementBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForStatementBodyEnd(this);
}

class ForInLoopPartsHandle extends ParserAstNode {
  final Token? awaitToken;
  final Token forToken;
  final Token leftParenthesis;
  final Token? patternKeyword;
  final Token inKeyword;

  ForInLoopPartsHandle(
    ParserAstType type, {
    this.awaitToken,
    required this.forToken,
    required this.leftParenthesis,
    this.patternKeyword,
    required this.inKeyword,
  }) : super("ForInLoopParts", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "awaitToken": awaitToken,
    "forToken": forToken,
    "leftParenthesis": leftParenthesis,
    "patternKeyword": patternKeyword,
    "inKeyword": inKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForInLoopPartsHandle(this);
}

class ForInEnd extends ParserAstNode {
  final Token endToken;

  ForInEnd(ParserAstType type, {required this.endToken}) : super("ForIn", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForInEnd(this);
}

class ForInExpressionBegin extends ParserAstNode {
  final Token token;

  ForInExpressionBegin(ParserAstType type, {required this.token})
    : super("ForInExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForInExpressionBegin(this);
}

class ForInExpressionEnd extends ParserAstNode {
  final Token token;

  ForInExpressionEnd(ParserAstType type, {required this.token})
    : super("ForInExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForInExpressionEnd(this);
}

class ForInBodyBegin extends ParserAstNode {
  final Token token;

  ForInBodyBegin(ParserAstType type, {required this.token})
    : super("ForInBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForInBodyBegin(this);
}

class ForInBodyEnd extends ParserAstNode {
  final Token endToken;

  ForInBodyEnd(ParserAstType type, {required this.endToken})
    : super("ForInBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForInBodyEnd(this);
}

class NamedFunctionExpressionBegin extends ParserAstNode {
  final Token token;

  NamedFunctionExpressionBegin(ParserAstType type, {required this.token})
    : super("NamedFunctionExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitNamedFunctionExpressionBegin(this);
}

class NamedFunctionExpressionEnd extends ParserAstNode {
  final Token endToken;

  NamedFunctionExpressionEnd(ParserAstType type, {required this.endToken})
    : super("NamedFunctionExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNamedFunctionExpressionEnd(this);
}

class LocalFunctionDeclarationBegin extends ParserAstNode {
  final Token token;

  LocalFunctionDeclarationBegin(ParserAstType type, {required this.token})
    : super("LocalFunctionDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitLocalFunctionDeclarationBegin(this);
}

class LocalFunctionDeclarationEnd extends ParserAstNode {
  final Token endToken;

  LocalFunctionDeclarationEnd(ParserAstType type, {required this.endToken})
    : super("LocalFunctionDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitLocalFunctionDeclarationEnd(this);
}

class BlockFunctionBodyBegin extends ParserAstNode {
  final Token token;

  BlockFunctionBodyBegin(ParserAstType type, {required this.token})
    : super("BlockFunctionBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitBlockFunctionBodyBegin(this);
}

class BlockFunctionBodyEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  BlockFunctionBodyEnd(
    ParserAstType type, {
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("BlockFunctionBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitBlockFunctionBodyEnd(this);
}

class NoFunctionBodyHandle extends ParserAstNode {
  final Token token;

  NoFunctionBodyHandle(ParserAstType type, {required this.token})
    : super("NoFunctionBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoFunctionBodyHandle(this);
}

class FunctionBodySkippedHandle extends ParserAstNode {
  final Token token;
  final bool isExpressionBody;

  FunctionBodySkippedHandle(
    ParserAstType type, {
    required this.token,
    required this.isExpressionBody,
  }) : super("FunctionBodySkipped", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "isExpressionBody": isExpressionBody,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFunctionBodySkippedHandle(this);
}

class FunctionNameBegin extends ParserAstNode {
  final Token token;

  FunctionNameBegin(ParserAstType type, {required this.token})
    : super("FunctionName", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFunctionNameBegin(this);
}

class FunctionNameEnd extends ParserAstNode {
  final Token beginToken;
  final Token token;
  final bool isFunctionExpression;

  FunctionNameEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.token,
    required this.isFunctionExpression,
  }) : super("FunctionName", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "token": token,
    "isFunctionExpression": isFunctionExpression,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFunctionNameEnd(this);
}

class TypedefBegin extends ParserAstNode {
  final Token token;

  TypedefBegin(ParserAstType type, {required this.token})
    : super("Typedef", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypedefBegin(this);
}

class TypedefEnd extends ParserAstNode {
  final Token? augmentToken;
  final Token typedefKeyword;
  final Token? equals;
  final Token endToken;

  TypedefEnd(
    ParserAstType type, {
    this.augmentToken,
    required this.typedefKeyword,
    this.equals,
    required this.endToken,
  }) : super("Typedef", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "augmentToken": augmentToken,
    "typedefKeyword": typedefKeyword,
    "equals": equals,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypedefEnd(this);
}

class ClassWithClauseHandle extends ParserAstNode {
  final Token withKeyword;

  ClassWithClauseHandle(ParserAstType type, {required this.withKeyword})
    : super("ClassWithClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"withKeyword": withKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassWithClauseHandle(this);
}

class ClassNoWithClauseHandle extends ParserAstNode {
  ClassNoWithClauseHandle(ParserAstType type)
    : super("ClassNoWithClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassNoWithClauseHandle(this);
}

class EnumWithClauseHandle extends ParserAstNode {
  final Token withKeyword;

  EnumWithClauseHandle(ParserAstType type, {required this.withKeyword})
    : super("EnumWithClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"withKeyword": withKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumWithClauseHandle(this);
}

class EnumNoWithClauseHandle extends ParserAstNode {
  EnumNoWithClauseHandle(ParserAstType type) : super("EnumNoWithClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEnumNoWithClauseHandle(this);
}

class MixinWithClauseHandle extends ParserAstNode {
  final Token withKeyword;

  MixinWithClauseHandle(ParserAstType type, {required this.withKeyword})
    : super("MixinWithClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"withKeyword": withKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMixinWithClauseHandle(this);
}

class NamedMixinApplicationBegin extends ParserAstNode {
  final Token beginToken;
  final Token? abstractToken;
  final Token? macroToken;
  final Token? sealedToken;
  final Token? baseToken;
  final Token? interfaceToken;
  final Token? finalToken;
  final Token? augmentToken;
  final Token? mixinToken;
  final Token name;

  NamedMixinApplicationBegin(
    ParserAstType type, {
    required this.beginToken,
    this.abstractToken,
    this.macroToken,
    this.sealedToken,
    this.baseToken,
    this.interfaceToken,
    this.finalToken,
    this.augmentToken,
    this.mixinToken,
    required this.name,
  }) : super("NamedMixinApplication", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "abstractToken": abstractToken,
    "macroToken": macroToken,
    "sealedToken": sealedToken,
    "baseToken": baseToken,
    "interfaceToken": interfaceToken,
    "finalToken": finalToken,
    "augmentToken": augmentToken,
    "mixinToken": mixinToken,
    "name": name,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNamedMixinApplicationBegin(this);
}

class NamedMixinApplicationWithClauseHandle extends ParserAstNode {
  final Token withKeyword;

  NamedMixinApplicationWithClauseHandle(
    ParserAstType type, {
    required this.withKeyword,
  }) : super("NamedMixinApplicationWithClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"withKeyword": withKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitNamedMixinApplicationWithClauseHandle(this);
}

class NamedMixinApplicationEnd extends ParserAstNode {
  final Token begin;
  final Token classKeyword;
  final Token equals;
  final Token? implementsKeyword;
  final Token endToken;

  NamedMixinApplicationEnd(
    ParserAstType type, {
    required this.begin,
    required this.classKeyword,
    required this.equals,
    this.implementsKeyword,
    required this.endToken,
  }) : super("NamedMixinApplication", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "begin": begin,
    "classKeyword": classKeyword,
    "equals": equals,
    "implementsKeyword": implementsKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNamedMixinApplicationEnd(this);
}

class HideBegin extends ParserAstNode {
  final Token hideKeyword;

  HideBegin(ParserAstType type, {required this.hideKeyword})
    : super("Hide", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"hideKeyword": hideKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitHideBegin(this);
}

class HideEnd extends ParserAstNode {
  final Token hideKeyword;

  HideEnd(ParserAstType type, {required this.hideKeyword})
    : super("Hide", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"hideKeyword": hideKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitHideEnd(this);
}

class IdentifierListHandle extends ParserAstNode {
  final int count;

  IdentifierListHandle(ParserAstType type, {required this.count})
    : super("IdentifierList", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"count": count};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIdentifierListHandle(this);
}

class TypeListBegin extends ParserAstNode {
  final Token token;

  TypeListBegin(ParserAstType type, {required this.token})
    : super("TypeList", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeListBegin(this);
}

class TypeListEnd extends ParserAstNode {
  final int count;

  TypeListEnd(ParserAstType type, {required this.count})
    : super("TypeList", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"count": count};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeListEnd(this);
}

class IfStatementBegin extends ParserAstNode {
  final Token token;

  IfStatementBegin(ParserAstType type, {required this.token})
    : super("IfStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIfStatementBegin(this);
}

class IfStatementEnd extends ParserAstNode {
  final Token ifToken;
  final Token? elseToken;
  final Token endToken;

  IfStatementEnd(
    ParserAstType type, {
    required this.ifToken,
    this.elseToken,
    required this.endToken,
  }) : super("IfStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "ifToken": ifToken,
    "elseToken": elseToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIfStatementEnd(this);
}

class ThenStatementBegin extends ParserAstNode {
  final Token token;

  ThenStatementBegin(ParserAstType type, {required this.token})
    : super("ThenStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitThenStatementBegin(this);
}

class ThenStatementEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ThenStatementEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("ThenStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitThenStatementEnd(this);
}

class ElseStatementBegin extends ParserAstNode {
  final Token token;

  ElseStatementBegin(ParserAstType type, {required this.token})
    : super("ElseStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitElseStatementBegin(this);
}

class ElseStatementEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ElseStatementEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("ElseStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitElseStatementEnd(this);
}

class ImportBegin extends ParserAstNode {
  final Token importKeyword;

  ImportBegin(ParserAstType type, {required this.importKeyword})
    : super("Import", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "importKeyword": importKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitImportBegin(this);
}

class ImportPrefixHandle extends ParserAstNode {
  final Token? deferredKeyword;
  final Token? asKeyword;

  ImportPrefixHandle(ParserAstType type, {this.deferredKeyword, this.asKeyword})
    : super("ImportPrefix", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "deferredKeyword": deferredKeyword,
    "asKeyword": asKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitImportPrefixHandle(this);
}

class ImportEnd extends ParserAstNode {
  final Token importKeyword;
  final Token? augmentToken;
  final Token? semicolon;

  ImportEnd(
    ParserAstType type, {
    required this.importKeyword,
    this.augmentToken,
    this.semicolon,
  }) : super("Import", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "importKeyword": importKeyword,
    "augmentToken": augmentToken,
    "semicolon": semicolon,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitImportEnd(this);
}

class RecoverImportHandle extends ParserAstNode {
  final Token? semicolon;

  RecoverImportHandle(ParserAstType type, {this.semicolon})
    : super("RecoverImport", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"semicolon": semicolon};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecoverImportHandle(this);
}

class ConditionalUrisBegin extends ParserAstNode {
  final Token token;

  ConditionalUrisBegin(ParserAstType type, {required this.token})
    : super("ConditionalUris", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConditionalUrisBegin(this);
}

class ConditionalUrisEnd extends ParserAstNode {
  final int count;

  ConditionalUrisEnd(ParserAstType type, {required this.count})
    : super("ConditionalUris", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"count": count};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConditionalUrisEnd(this);
}

class ConditionalUriBegin extends ParserAstNode {
  final Token ifKeyword;

  ConditionalUriBegin(ParserAstType type, {required this.ifKeyword})
    : super("ConditionalUri", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"ifKeyword": ifKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConditionalUriBegin(this);
}

class ConditionalUriEnd extends ParserAstNode {
  final Token ifKeyword;
  final Token leftParen;
  final Token? equalSign;

  ConditionalUriEnd(
    ParserAstType type, {
    required this.ifKeyword,
    required this.leftParen,
    this.equalSign,
  }) : super("ConditionalUri", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "ifKeyword": ifKeyword,
    "leftParen": leftParen,
    "equalSign": equalSign,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConditionalUriEnd(this);
}

class DottedNameHandle extends ParserAstNode {
  final int count;
  final Token firstIdentifier;

  DottedNameHandle(
    ParserAstType type, {
    required this.count,
    required this.firstIdentifier,
  }) : super("DottedName", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "firstIdentifier": firstIdentifier,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitDottedNameHandle(this);
}

class ImplicitCreationExpressionBegin extends ParserAstNode {
  final Token token;

  ImplicitCreationExpressionBegin(ParserAstType type, {required this.token})
    : super("ImplicitCreationExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitImplicitCreationExpressionBegin(this);
}

class ImplicitCreationExpressionEnd extends ParserAstNode {
  final Token token;
  final Token openAngleBracket;

  ImplicitCreationExpressionEnd(
    ParserAstType type, {
    required this.token,
    required this.openAngleBracket,
  }) : super("ImplicitCreationExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "openAngleBracket": openAngleBracket,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitImplicitCreationExpressionEnd(this);
}

class InitializedIdentifierBegin extends ParserAstNode {
  final Token token;

  InitializedIdentifierBegin(ParserAstType type, {required this.token})
    : super("InitializedIdentifier", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInitializedIdentifierBegin(this);
}

class InitializedIdentifierEnd extends ParserAstNode {
  final Token nameToken;

  InitializedIdentifierEnd(ParserAstType type, {required this.nameToken})
    : super("InitializedIdentifier", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"nameToken": nameToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInitializedIdentifierEnd(this);
}

class FieldInitializerBegin extends ParserAstNode {
  final Token token;

  FieldInitializerBegin(ParserAstType type, {required this.token})
    : super("FieldInitializer", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFieldInitializerBegin(this);
}

class FieldInitializerEnd extends ParserAstNode {
  final Token assignment;
  final Token endToken;

  FieldInitializerEnd(
    ParserAstType type, {
    required this.assignment,
    required this.endToken,
  }) : super("FieldInitializer", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "assignment": assignment,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFieldInitializerEnd(this);
}

class NoFieldInitializerHandle extends ParserAstNode {
  final Token token;

  NoFieldInitializerHandle(ParserAstType type, {required this.token})
    : super("NoFieldInitializer", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoFieldInitializerHandle(this);
}

class VariableInitializerBegin extends ParserAstNode {
  final Token token;

  VariableInitializerBegin(ParserAstType type, {required this.token})
    : super("VariableInitializer", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitVariableInitializerBegin(this);
}

class VariableInitializerEnd extends ParserAstNode {
  final Token assignmentOperator;

  VariableInitializerEnd(ParserAstType type, {required this.assignmentOperator})
    : super("VariableInitializer", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "assignmentOperator": assignmentOperator,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitVariableInitializerEnd(this);
}

class NoVariableInitializerHandle extends ParserAstNode {
  final Token token;

  NoVariableInitializerHandle(ParserAstType type, {required this.token})
    : super("NoVariableInitializer", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitNoVariableInitializerHandle(this);
}

class InitializerBegin extends ParserAstNode {
  final Token token;

  InitializerBegin(ParserAstType type, {required this.token})
    : super("Initializer", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInitializerBegin(this);
}

class InitializerEnd extends ParserAstNode {
  final Token endToken;

  InitializerEnd(ParserAstType type, {required this.endToken})
    : super("Initializer", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInitializerEnd(this);
}

class InitializersBegin extends ParserAstNode {
  final Token token;

  InitializersBegin(ParserAstType type, {required this.token})
    : super("Initializers", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInitializersBegin(this);
}

class InitializersEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  InitializersEnd(
    ParserAstType type, {
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("Initializers", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInitializersEnd(this);
}

class NoInitializersHandle extends ParserAstNode {
  NoInitializersHandle(ParserAstType type) : super("NoInitializers", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoInitializersHandle(this);
}

class InvalidExpressionHandle extends ParserAstNode {
  final Token token;

  InvalidExpressionHandle(ParserAstType type, {required this.token})
    : super("InvalidExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidExpressionHandle(this);
}

class InvalidFunctionBodyHandle extends ParserAstNode {
  final Token token;

  InvalidFunctionBodyHandle(ParserAstType type, {required this.token})
    : super("InvalidFunctionBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidFunctionBodyHandle(this);
}

class InvalidTypeReferenceHandle extends ParserAstNode {
  final Token token;

  InvalidTypeReferenceHandle(ParserAstType type, {required this.token})
    : super("InvalidTypeReference", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidTypeReferenceHandle(this);
}

class LabelHandle extends ParserAstNode {
  final Token token;

  LabelHandle(ParserAstType type, {required this.token}) : super("Label", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLabelHandle(this);
}

class LabeledStatementBegin extends ParserAstNode {
  final Token token;
  final int labelCount;

  LabeledStatementBegin(
    ParserAstType type, {
    required this.token,
    required this.labelCount,
  }) : super("LabeledStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "labelCount": labelCount,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLabeledStatementBegin(this);
}

class LabeledStatementEnd extends ParserAstNode {
  final int labelCount;

  LabeledStatementEnd(ParserAstType type, {required this.labelCount})
    : super("LabeledStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"labelCount": labelCount};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLabeledStatementEnd(this);
}

class LibraryAugmentationBegin extends ParserAstNode {
  final Token augmentKeyword;
  final Token libraryKeyword;

  LibraryAugmentationBegin(
    ParserAstType type, {
    required this.augmentKeyword,
    required this.libraryKeyword,
  }) : super("LibraryAugmentation", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "augmentKeyword": augmentKeyword,
    "libraryKeyword": libraryKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLibraryAugmentationBegin(this);
}

class LibraryAugmentationEnd extends ParserAstNode {
  final Token augmentKeyword;
  final Token libraryKeyword;
  final Token semicolon;

  LibraryAugmentationEnd(
    ParserAstType type, {
    required this.augmentKeyword,
    required this.libraryKeyword,
    required this.semicolon,
  }) : super("LibraryAugmentation", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "augmentKeyword": augmentKeyword,
    "libraryKeyword": libraryKeyword,
    "semicolon": semicolon,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLibraryAugmentationEnd(this);
}

class LibraryNameBegin extends ParserAstNode {
  final Token token;

  LibraryNameBegin(ParserAstType type, {required this.token})
    : super("LibraryName", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLibraryNameBegin(this);
}

class LibraryNameEnd extends ParserAstNode {
  final Token libraryKeyword;
  final Token semicolon;
  final bool hasName;

  LibraryNameEnd(
    ParserAstType type, {
    required this.libraryKeyword,
    required this.semicolon,
    required this.hasName,
  }) : super("LibraryName", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "libraryKeyword": libraryKeyword,
    "semicolon": semicolon,
    "hasName": hasName,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLibraryNameEnd(this);
}

class LiteralMapEntryHandle extends ParserAstNode {
  final Token colon;
  final Token endToken;
  final Token? nullAwareKeyToken;
  final Token? nullAwareValueToken;

  LiteralMapEntryHandle(
    ParserAstType type, {
    required this.colon,
    required this.endToken,
    this.nullAwareKeyToken,
    this.nullAwareValueToken,
  }) : super("LiteralMapEntry", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "colon": colon,
    "endToken": endToken,
    "nullAwareKeyToken": nullAwareKeyToken,
    "nullAwareValueToken": nullAwareValueToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralMapEntryHandle(this);
}

class MapPatternEntryHandle extends ParserAstNode {
  final Token colon;
  final Token endToken;

  MapPatternEntryHandle(
    ParserAstType type, {
    required this.colon,
    required this.endToken,
  }) : super("MapPatternEntry", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "colon": colon,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMapPatternEntryHandle(this);
}

class LiteralStringBegin extends ParserAstNode {
  final Token token;

  LiteralStringBegin(ParserAstType type, {required this.token})
    : super("LiteralString", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralStringBegin(this);
}

class InterpolationExpressionHandle extends ParserAstNode {
  final Token leftBracket;
  final Token? rightBracket;

  InterpolationExpressionHandle(
    ParserAstType type, {
    required this.leftBracket,
    this.rightBracket,
  }) : super("InterpolationExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "leftBracket": leftBracket,
    "rightBracket": rightBracket,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitInterpolationExpressionHandle(this);
}

class LiteralStringEnd extends ParserAstNode {
  final int interpolationCount;
  final Token endToken;

  LiteralStringEnd(
    ParserAstType type, {
    required this.interpolationCount,
    required this.endToken,
  }) : super("LiteralString", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "interpolationCount": interpolationCount,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralStringEnd(this);
}

class AdjacentStringLiteralsHandle extends ParserAstNode {
  final Token startToken;
  final int literalCount;

  AdjacentStringLiteralsHandle(
    ParserAstType type, {
    required this.startToken,
    required this.literalCount,
  }) : super("AdjacentStringLiterals", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "startToken": startToken,
    "literalCount": literalCount,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitAdjacentStringLiteralsHandle(this);
}

class MemberBegin extends ParserAstNode {
  MemberBegin(ParserAstType type) : super("Member", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMemberBegin(this);
}

class InvalidMemberHandle extends ParserAstNode {
  final Token endToken;

  InvalidMemberHandle(ParserAstType type, {required this.endToken})
    : super("InvalidMember", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidMemberHandle(this);
}

class MemberEnd extends ParserAstNode {
  MemberEnd(ParserAstType type) : super("Member", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMemberEnd(this);
}

class MethodBegin extends ParserAstNode {
  final DeclarationKind declarationKind;
  final Token? augmentToken;
  final Token? externalToken;
  final Token? staticToken;
  final Token? covariantToken;
  final Token? varFinalOrConst;
  final Token? getOrSet;
  final Token name;
  final String? enclosingDeclarationName;

  MethodBegin(
    ParserAstType type, {
    required this.declarationKind,
    this.augmentToken,
    this.externalToken,
    this.staticToken,
    this.covariantToken,
    this.varFinalOrConst,
    this.getOrSet,
    required this.name,
    this.enclosingDeclarationName,
  }) : super("Method", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "declarationKind": declarationKind,
    "augmentToken": augmentToken,
    "externalToken": externalToken,
    "staticToken": staticToken,
    "covariantToken": covariantToken,
    "varFinalOrConst": varFinalOrConst,
    "getOrSet": getOrSet,
    "name": name,
    "enclosingDeclarationName": enclosingDeclarationName,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMethodBegin(this);
}

class ClassMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  ClassMethodEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("ClassMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassMethodEnd(this);
}

class MixinMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  MixinMethodEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("MixinMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMixinMethodEnd(this);
}

class ExtensionMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  ExtensionMethodEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("ExtensionMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExtensionMethodEnd(this);
}

class ExtensionTypeMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  ExtensionTypeMethodEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("ExtensionTypeMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExtensionTypeMethodEnd(this);
}

class ClassConstructorEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  ClassConstructorEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("ClassConstructor", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitClassConstructorEnd(this);
}

class MixinConstructorEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  MixinConstructorEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("MixinConstructor", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMixinConstructorEnd(this);
}

class ExtensionConstructorEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  ExtensionConstructorEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("ExtensionConstructor", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExtensionConstructorEnd(this);
}

class ExtensionTypeConstructorEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? getOrSet;
  @override
  final Token beginToken;
  final Token beginParam;
  final Token? beginInitializers;
  @override
  final Token endToken;

  ExtensionTypeConstructorEnd(
    ParserAstType type, {
    this.getOrSet,
    required this.beginToken,
    required this.beginParam,
    this.beginInitializers,
    required this.endToken,
  }) : super("ExtensionTypeConstructor", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "getOrSet": getOrSet,
    "beginToken": beginToken,
    "beginParam": beginParam,
    "beginInitializers": beginInitializers,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitExtensionTypeConstructorEnd(this);
}

class MetadataStarBegin extends ParserAstNode {
  final Token token;

  MetadataStarBegin(ParserAstType type, {required this.token})
    : super("MetadataStar", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMetadataStarBegin(this);
}

class MetadataStarEnd extends ParserAstNode {
  final int count;

  MetadataStarEnd(ParserAstType type, {required this.count})
    : super("MetadataStar", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"count": count};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMetadataStarEnd(this);
}

class MetadataBegin extends ParserAstNode {
  final Token token;

  MetadataBegin(ParserAstType type, {required this.token})
    : super("Metadata", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMetadataBegin(this);
}

class MetadataEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token? periodBeforeName;
  @override
  final Token endToken;

  MetadataEnd(
    ParserAstType type, {
    required this.beginToken,
    this.periodBeforeName,
    required this.endToken,
  }) : super("Metadata", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "periodBeforeName": periodBeforeName,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMetadataEnd(this);
}

class OptionalFormalParametersBegin extends ParserAstNode {
  final Token token;

  OptionalFormalParametersBegin(ParserAstType type, {required this.token})
    : super("OptionalFormalParameters", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitOptionalFormalParametersBegin(this);
}

class OptionalFormalParametersEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;
  final MemberKind kind;

  OptionalFormalParametersEnd(
    ParserAstType type, {
    required this.count,
    required this.beginToken,
    required this.endToken,
    required this.kind,
  }) : super("OptionalFormalParameters", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
    "kind": kind,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitOptionalFormalParametersEnd(this);
}

class PartBegin extends ParserAstNode {
  final Token token;

  PartBegin(ParserAstType type, {required this.token}) : super("Part", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPartBegin(this);
}

class PartEnd extends ParserAstNode {
  final Token partKeyword;
  final Token semicolon;

  PartEnd(
    ParserAstType type, {
    required this.partKeyword,
    required this.semicolon,
  }) : super("Part", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "partKeyword": partKeyword,
    "semicolon": semicolon,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPartEnd(this);
}

class PartOfBegin extends ParserAstNode {
  final Token token;

  PartOfBegin(ParserAstType type, {required this.token})
    : super("PartOf", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPartOfBegin(this);
}

class PartOfEnd extends ParserAstNode {
  final Token partKeyword;
  final Token ofKeyword;
  final Token semicolon;
  final bool hasName;

  PartOfEnd(
    ParserAstType type, {
    required this.partKeyword,
    required this.ofKeyword,
    required this.semicolon,
    required this.hasName,
  }) : super("PartOf", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "partKeyword": partKeyword,
    "ofKeyword": ofKeyword,
    "semicolon": semicolon,
    "hasName": hasName,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPartOfEnd(this);
}

class RedirectingFactoryBodyBegin extends ParserAstNode {
  final Token token;

  RedirectingFactoryBodyBegin(ParserAstType type, {required this.token})
    : super("RedirectingFactoryBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitRedirectingFactoryBodyBegin(this);
}

class RedirectingFactoryBodyEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  RedirectingFactoryBodyEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("RedirectingFactoryBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRedirectingFactoryBodyEnd(this);
}

class ReturnStatementBegin extends ParserAstNode {
  final Token token;

  ReturnStatementBegin(ParserAstType type, {required this.token})
    : super("ReturnStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitReturnStatementBegin(this);
}

class NativeFunctionBodyHandle extends ParserAstNode {
  final Token nativeToken;
  final Token semicolon;

  NativeFunctionBodyHandle(
    ParserAstType type, {
    required this.nativeToken,
    required this.semicolon,
  }) : super("NativeFunctionBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "nativeToken": nativeToken,
    "semicolon": semicolon,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNativeFunctionBodyHandle(this);
}

class NativeFunctionBodyIgnoredHandle extends ParserAstNode {
  final Token nativeToken;
  final Token semicolon;

  NativeFunctionBodyIgnoredHandle(
    ParserAstType type, {
    required this.nativeToken,
    required this.semicolon,
  }) : super("NativeFunctionBodyIgnored", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "nativeToken": nativeToken,
    "semicolon": semicolon,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitNativeFunctionBodyIgnoredHandle(this);
}

class NativeFunctionBodySkippedHandle extends ParserAstNode {
  final Token nativeToken;
  final Token semicolon;

  NativeFunctionBodySkippedHandle(
    ParserAstType type, {
    required this.nativeToken,
    required this.semicolon,
  }) : super("NativeFunctionBodySkipped", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "nativeToken": nativeToken,
    "semicolon": semicolon,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitNativeFunctionBodySkippedHandle(this);
}

class EmptyFunctionBodyHandle extends ParserAstNode {
  final Token semicolon;

  EmptyFunctionBodyHandle(ParserAstType type, {required this.semicolon})
    : super("EmptyFunctionBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"semicolon": semicolon};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEmptyFunctionBodyHandle(this);
}

class ExpressionFunctionBodyHandle extends ParserAstNode {
  final Token arrowToken;
  final Token? endToken;

  ExpressionFunctionBodyHandle(
    ParserAstType type, {
    required this.arrowToken,
    this.endToken,
  }) : super("ExpressionFunctionBody", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "arrowToken": arrowToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitExpressionFunctionBodyHandle(this);
}

class ReturnStatementEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final bool hasExpression;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  ReturnStatementEnd(
    ParserAstType type, {
    required this.hasExpression,
    required this.beginToken,
    required this.endToken,
  }) : super("ReturnStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "hasExpression": hasExpression,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitReturnStatementEnd(this);
}

class SendHandle extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  SendHandle(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("Send", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSendHandle(this);
}

class ShowBegin extends ParserAstNode {
  final Token showKeyword;

  ShowBegin(ParserAstType type, {required this.showKeyword})
    : super("Show", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"showKeyword": showKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitShowBegin(this);
}

class ShowEnd extends ParserAstNode {
  final Token showKeyword;

  ShowEnd(ParserAstType type, {required this.showKeyword})
    : super("Show", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"showKeyword": showKeyword};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitShowEnd(this);
}

class SwitchStatementBegin extends ParserAstNode {
  final Token token;

  SwitchStatementBegin(ParserAstType type, {required this.token})
    : super("SwitchStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchStatementBegin(this);
}

class SwitchStatementEnd extends ParserAstNode {
  final Token switchKeyword;
  final Token endToken;

  SwitchStatementEnd(
    ParserAstType type, {
    required this.switchKeyword,
    required this.endToken,
  }) : super("SwitchStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "switchKeyword": switchKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchStatementEnd(this);
}

class SwitchExpressionBegin extends ParserAstNode {
  final Token token;

  SwitchExpressionBegin(ParserAstType type, {required this.token})
    : super("SwitchExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchExpressionBegin(this);
}

class SwitchExpressionEnd extends ParserAstNode {
  final Token switchKeyword;
  final Token endToken;

  SwitchExpressionEnd(
    ParserAstType type, {
    required this.switchKeyword,
    required this.endToken,
  }) : super("SwitchExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "switchKeyword": switchKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchExpressionEnd(this);
}

class SwitchBlockBegin extends ParserAstNode {
  final Token token;

  SwitchBlockBegin(ParserAstType type, {required this.token})
    : super("SwitchBlock", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchBlockBegin(this);
}

class SwitchBlockEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int caseCount;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  SwitchBlockEnd(
    ParserAstType type, {
    required this.caseCount,
    required this.beginToken,
    required this.endToken,
  }) : super("SwitchBlock", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "caseCount": caseCount,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchBlockEnd(this);
}

class SwitchExpressionBlockBegin extends ParserAstNode {
  final Token token;

  SwitchExpressionBlockBegin(ParserAstType type, {required this.token})
    : super("SwitchExpressionBlock", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchExpressionBlockBegin(this);
}

class SwitchExpressionBlockEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int caseCount;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  SwitchExpressionBlockEnd(
    ParserAstType type, {
    required this.caseCount,
    required this.beginToken,
    required this.endToken,
  }) : super("SwitchExpressionBlock", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "caseCount": caseCount,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchExpressionBlockEnd(this);
}

class LiteralSymbolBegin extends ParserAstNode {
  final Token token;

  LiteralSymbolBegin(ParserAstType type, {required this.token})
    : super("LiteralSymbol", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralSymbolBegin(this);
}

class LiteralSymbolEnd extends ParserAstNode {
  final Token hashToken;
  final int identifierCount;

  LiteralSymbolEnd(
    ParserAstType type, {
    required this.hashToken,
    required this.identifierCount,
  }) : super("LiteralSymbol", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "hashToken": hashToken,
    "identifierCount": identifierCount,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralSymbolEnd(this);
}

class ThrowExpressionHandle extends ParserAstNode {
  final Token throwToken;
  final Token endToken;

  ThrowExpressionHandle(
    ParserAstType type, {
    required this.throwToken,
    required this.endToken,
  }) : super("ThrowExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "throwToken": throwToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitThrowExpressionHandle(this);
}

class RethrowStatementBegin extends ParserAstNode {
  final Token token;

  RethrowStatementBegin(ParserAstType type, {required this.token})
    : super("RethrowStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRethrowStatementBegin(this);
}

class RethrowStatementEnd extends ParserAstNode {
  final Token rethrowToken;
  final Token endToken;

  RethrowStatementEnd(
    ParserAstType type, {
    required this.rethrowToken,
    required this.endToken,
  }) : super("RethrowStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "rethrowToken": rethrowToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRethrowStatementEnd(this);
}

class TopLevelDeclarationEnd extends ParserAstNode {
  final Token endToken;

  TopLevelDeclarationEnd(ParserAstType type, {required this.endToken})
    : super("TopLevelDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTopLevelDeclarationEnd(this);
}

class InvalidTopLevelDeclarationHandle extends ParserAstNode {
  final Token endToken;

  InvalidTopLevelDeclarationHandle(ParserAstType type, {required this.endToken})
    : super("InvalidTopLevelDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"endToken": endToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitInvalidTopLevelDeclarationHandle(this);
}

class TopLevelMemberBegin extends ParserAstNode {
  final Token token;

  TopLevelMemberBegin(ParserAstType type, {required this.token})
    : super("TopLevelMember", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTopLevelMemberBegin(this);
}

class FieldsBegin extends ParserAstNode {
  final DeclarationKind declarationKind;
  final Token? abstractToken;
  final Token? augmentToken;
  final Token? externalToken;
  final Token? staticToken;
  final Token? covariantToken;
  final Token? lateToken;
  final Token? varFinalOrConst;
  final Token lastConsumed;

  FieldsBegin(
    ParserAstType type, {
    required this.declarationKind,
    this.abstractToken,
    this.augmentToken,
    this.externalToken,
    this.staticToken,
    this.covariantToken,
    this.lateToken,
    this.varFinalOrConst,
    required this.lastConsumed,
  }) : super("Fields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "declarationKind": declarationKind,
    "abstractToken": abstractToken,
    "augmentToken": augmentToken,
    "externalToken": externalToken,
    "staticToken": staticToken,
    "covariantToken": covariantToken,
    "lateToken": lateToken,
    "varFinalOrConst": varFinalOrConst,
    "lastConsumed": lastConsumed,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFieldsBegin(this);
}

class TopLevelFieldsEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final Token? augmentToken;
  final Token? externalToken;
  final Token? staticToken;
  final Token? covariantToken;
  final Token? lateToken;
  final Token? varFinalOrConst;
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  TopLevelFieldsEnd(
    ParserAstType type, {
    this.augmentToken,
    this.externalToken,
    this.staticToken,
    this.covariantToken,
    this.lateToken,
    this.varFinalOrConst,
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("TopLevelFields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "augmentToken": augmentToken,
    "externalToken": externalToken,
    "staticToken": staticToken,
    "covariantToken": covariantToken,
    "lateToken": lateToken,
    "varFinalOrConst": varFinalOrConst,
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTopLevelFieldsEnd(this);
}

class TopLevelMethodBegin extends ParserAstNode {
  final Token lastConsumed;
  final Token? augmentToken;
  final Token? externalToken;

  TopLevelMethodBegin(
    ParserAstType type, {
    required this.lastConsumed,
    this.augmentToken,
    this.externalToken,
  }) : super("TopLevelMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "lastConsumed": lastConsumed,
    "augmentToken": augmentToken,
    "externalToken": externalToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTopLevelMethodBegin(this);
}

class TopLevelMethodEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token? getOrSet;
  @override
  final Token endToken;

  TopLevelMethodEnd(
    ParserAstType type, {
    required this.beginToken,
    this.getOrSet,
    required this.endToken,
  }) : super("TopLevelMethod", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "getOrSet": getOrSet,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTopLevelMethodEnd(this);
}

class TryStatementBegin extends ParserAstNode {
  final Token token;

  TryStatementBegin(ParserAstType type, {required this.token})
    : super("TryStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTryStatementBegin(this);
}

class CatchClauseBegin extends ParserAstNode {
  final Token token;

  CatchClauseBegin(ParserAstType type, {required this.token})
    : super("CatchClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCatchClauseBegin(this);
}

class CatchClauseEnd extends ParserAstNode {
  final Token token;

  CatchClauseEnd(ParserAstType type, {required this.token})
    : super("CatchClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCatchClauseEnd(this);
}

class CatchBlockHandle extends ParserAstNode {
  final Token? onKeyword;
  final Token? catchKeyword;
  final Token? comma;

  CatchBlockHandle(
    ParserAstType type, {
    this.onKeyword,
    this.catchKeyword,
    this.comma,
  }) : super("CatchBlock", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "onKeyword": onKeyword,
    "catchKeyword": catchKeyword,
    "comma": comma,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCatchBlockHandle(this);
}

class FinallyBlockHandle extends ParserAstNode {
  final Token finallyKeyword;

  FinallyBlockHandle(ParserAstType type, {required this.finallyKeyword})
    : super("FinallyBlock", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "finallyKeyword": finallyKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFinallyBlockHandle(this);
}

class TryStatementEnd extends ParserAstNode {
  final int catchCount;
  final Token tryKeyword;
  final Token? finallyKeyword;
  final Token endToken;

  TryStatementEnd(
    ParserAstType type, {
    required this.catchCount,
    required this.tryKeyword,
    this.finallyKeyword,
    required this.endToken,
  }) : super("TryStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "catchCount": catchCount,
    "tryKeyword": tryKeyword,
    "finallyKeyword": finallyKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTryStatementEnd(this);
}

class TypeHandle extends ParserAstNode {
  final Token beginToken;
  final Token? questionMark;

  TypeHandle(ParserAstType type, {required this.beginToken, this.questionMark})
    : super("Type", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "questionMark": questionMark,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeHandle(this);
}

class NonNullAssertExpressionHandle extends ParserAstNode {
  final Token bang;

  NonNullAssertExpressionHandle(ParserAstType type, {required this.bang})
    : super("NonNullAssertExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"bang": bang};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitNonNullAssertExpressionHandle(this);
}

class NullAssertPatternHandle extends ParserAstNode {
  final Token bang;

  NullAssertPatternHandle(ParserAstType type, {required this.bang})
    : super("NullAssertPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"bang": bang};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNullAssertPatternHandle(this);
}

class NullCheckPatternHandle extends ParserAstNode {
  final Token question;

  NullCheckPatternHandle(ParserAstType type, {required this.question})
    : super("NullCheckPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"question": question};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNullCheckPatternHandle(this);
}

class AssignedVariablePatternHandle extends ParserAstNode {
  final Token variable;

  AssignedVariablePatternHandle(ParserAstType type, {required this.variable})
    : super("AssignedVariablePattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"variable": variable};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitAssignedVariablePatternHandle(this);
}

class DeclaredVariablePatternHandle extends ParserAstNode {
  final Token? keyword;
  final Token variable;
  final bool inAssignmentPattern;

  DeclaredVariablePatternHandle(
    ParserAstType type, {
    this.keyword,
    required this.variable,
    required this.inAssignmentPattern,
  }) : super("DeclaredVariablePattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "keyword": keyword,
    "variable": variable,
    "inAssignmentPattern": inAssignmentPattern,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitDeclaredVariablePatternHandle(this);
}

class WildcardPatternHandle extends ParserAstNode {
  final Token? keyword;
  final Token wildcard;

  WildcardPatternHandle(
    ParserAstType type, {
    this.keyword,
    required this.wildcard,
  }) : super("WildcardPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "keyword": keyword,
    "wildcard": wildcard,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitWildcardPatternHandle(this);
}

class NoNameHandle extends ParserAstNode {
  final Token token;

  NoNameHandle(ParserAstType type, {required this.token})
    : super("NoName", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoNameHandle(this);
}

class RecordTypeBegin extends ParserAstNode {
  final Token leftBracket;

  RecordTypeBegin(ParserAstType type, {required this.leftBracket})
    : super("RecordType", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"leftBracket": leftBracket};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecordTypeBegin(this);
}

class RecordTypeEnd extends ParserAstNode {
  final Token leftBracket;
  final Token? questionMark;
  final int count;
  final bool hasNamedFields;

  RecordTypeEnd(
    ParserAstType type, {
    required this.leftBracket,
    this.questionMark,
    required this.count,
    required this.hasNamedFields,
  }) : super("RecordType", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "leftBracket": leftBracket,
    "questionMark": questionMark,
    "count": count,
    "hasNamedFields": hasNamedFields,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecordTypeEnd(this);
}

class RecordTypeEntryBegin extends ParserAstNode {
  RecordTypeEntryBegin(ParserAstType type) : super("RecordTypeEntry", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecordTypeEntryBegin(this);
}

class RecordTypeEntryEnd extends ParserAstNode {
  RecordTypeEntryEnd(ParserAstType type) : super("RecordTypeEntry", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecordTypeEntryEnd(this);
}

class RecordTypeNamedFieldsBegin extends ParserAstNode {
  final Token leftBracket;

  RecordTypeNamedFieldsBegin(ParserAstType type, {required this.leftBracket})
    : super("RecordTypeNamedFields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"leftBracket": leftBracket};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecordTypeNamedFieldsBegin(this);
}

class RecordTypeNamedFieldsEnd extends ParserAstNode {
  final int count;
  final Token leftBracket;

  RecordTypeNamedFieldsEnd(
    ParserAstType type, {
    required this.count,
    required this.leftBracket,
  }) : super("RecordTypeNamedFields", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "leftBracket": leftBracket,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecordTypeNamedFieldsEnd(this);
}

class FunctionTypeBegin extends ParserAstNode {
  final Token beginToken;

  FunctionTypeBegin(ParserAstType type, {required this.beginToken})
    : super("FunctionType", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"beginToken": beginToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFunctionTypeBegin(this);
}

class FunctionTypeEnd extends ParserAstNode {
  final Token functionToken;
  final Token? questionMark;

  FunctionTypeEnd(
    ParserAstType type, {
    required this.functionToken,
    this.questionMark,
  }) : super("FunctionType", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "functionToken": functionToken,
    "questionMark": questionMark,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFunctionTypeEnd(this);
}

class TypeArgumentsBegin extends ParserAstNode {
  final Token token;

  TypeArgumentsBegin(ParserAstType type, {required this.token})
    : super("TypeArguments", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeArgumentsBegin(this);
}

class TypeArgumentsEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int count;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  TypeArgumentsEnd(
    ParserAstType type, {
    required this.count,
    required this.beginToken,
    required this.endToken,
  }) : super("TypeArguments", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeArgumentsEnd(this);
}

class InvalidTypeArgumentsHandle extends ParserAstNode {
  final Token token;

  InvalidTypeArgumentsHandle(ParserAstType type, {required this.token})
    : super("InvalidTypeArguments", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidTypeArgumentsHandle(this);
}

class NoTypeArgumentsHandle extends ParserAstNode {
  final Token token;

  NoTypeArgumentsHandle(ParserAstType type, {required this.token})
    : super("NoTypeArguments", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoTypeArgumentsHandle(this);
}

class TypeVariableBegin extends ParserAstNode {
  final Token token;

  TypeVariableBegin(ParserAstType type, {required this.token})
    : super("TypeVariable", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeVariableBegin(this);
}

class TypeVariablesDefinedHandle extends ParserAstNode {
  final Token token;
  final int count;

  TypeVariablesDefinedHandle(
    ParserAstType type, {
    required this.token,
    required this.count,
  }) : super("TypeVariablesDefined", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "count": count,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeVariablesDefinedHandle(this);
}

class TypeVariableEnd extends ParserAstNode {
  final Token token;
  final int index;
  final Token? extendsOrSuper;
  final Token? variance;

  TypeVariableEnd(
    ParserAstType type, {
    required this.token,
    required this.index,
    this.extendsOrSuper,
    this.variance,
  }) : super("TypeVariable", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "index": index,
    "extendsOrSuper": extendsOrSuper,
    "variance": variance,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeVariableEnd(this);
}

class TypeVariablesBegin extends ParserAstNode {
  final Token token;

  TypeVariablesBegin(ParserAstType type, {required this.token})
    : super("TypeVariables", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeVariablesBegin(this);
}

class TypeVariablesEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  TypeVariablesEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("TypeVariables", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitTypeVariablesEnd(this);
}

class FunctionExpressionBegin extends ParserAstNode {
  final Token token;

  FunctionExpressionBegin(ParserAstType type, {required this.token})
    : super("FunctionExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFunctionExpressionBegin(this);
}

class FunctionExpressionEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  @override
  final Token endToken;

  FunctionExpressionEnd(
    ParserAstType type, {
    required this.beginToken,
    required this.endToken,
  }) : super("FunctionExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitFunctionExpressionEnd(this);
}

class VariablesDeclarationBegin extends ParserAstNode {
  final Token token;
  final Token? lateToken;
  final Token? varFinalOrConst;

  VariablesDeclarationBegin(
    ParserAstType type, {
    required this.token,
    this.lateToken,
    this.varFinalOrConst,
  }) : super("VariablesDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "lateToken": lateToken,
    "varFinalOrConst": varFinalOrConst,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitVariablesDeclarationBegin(this);
}

class VariablesDeclarationEnd extends ParserAstNode {
  final int count;
  final Token? endToken;

  VariablesDeclarationEnd(
    ParserAstType type, {
    required this.count,
    this.endToken,
  }) : super("VariablesDeclaration", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitVariablesDeclarationEnd(this);
}

class WhileStatementBegin extends ParserAstNode {
  final Token token;

  WhileStatementBegin(ParserAstType type, {required this.token})
    : super("WhileStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitWhileStatementBegin(this);
}

class WhileStatementEnd extends ParserAstNode {
  final Token whileKeyword;
  final Token endToken;

  WhileStatementEnd(
    ParserAstType type, {
    required this.whileKeyword,
    required this.endToken,
  }) : super("WhileStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "whileKeyword": whileKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitWhileStatementEnd(this);
}

class AsOperatorTypeBegin extends ParserAstNode {
  final Token operator;

  AsOperatorTypeBegin(ParserAstType type, {required this.operator})
    : super("AsOperatorType", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"operator": operator};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitAsOperatorTypeBegin(this);
}

class AsOperatorTypeEnd extends ParserAstNode {
  final Token operator;

  AsOperatorTypeEnd(ParserAstType type, {required this.operator})
    : super("AsOperatorType", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"operator": operator};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitAsOperatorTypeEnd(this);
}

class AsOperatorHandle extends ParserAstNode {
  final Token operator;

  AsOperatorHandle(ParserAstType type, {required this.operator})
    : super("AsOperator", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"operator": operator};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitAsOperatorHandle(this);
}

class CastPatternHandle extends ParserAstNode {
  final Token operator;

  CastPatternHandle(ParserAstType type, {required this.operator})
    : super("CastPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"operator": operator};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCastPatternHandle(this);
}

class AssignmentExpressionHandle extends ParserAstNode {
  final Token token;
  final Token endToken;

  AssignmentExpressionHandle(
    ParserAstType type, {
    required this.token,
    required this.endToken,
  }) : super("AssignmentExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitAssignmentExpressionHandle(this);
}

class BinaryExpressionBegin extends ParserAstNode {
  final Token token;

  BinaryExpressionBegin(ParserAstType type, {required this.token})
    : super("BinaryExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitBinaryExpressionBegin(this);
}

class BinaryExpressionEnd extends ParserAstNode {
  final Token token;
  final Token endToken;

  BinaryExpressionEnd(
    ParserAstType type, {
    required this.token,
    required this.endToken,
  }) : super("BinaryExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitBinaryExpressionEnd(this);
}

class BinaryPatternBegin extends ParserAstNode {
  final Token token;

  BinaryPatternBegin(ParserAstType type, {required this.token})
    : super("BinaryPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitBinaryPatternBegin(this);
}

class BinaryPatternEnd extends ParserAstNode {
  final Token token;

  BinaryPatternEnd(ParserAstType type, {required this.token})
    : super("BinaryPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitBinaryPatternEnd(this);
}

class DotAccessHandle extends ParserAstNode {
  final Token token;
  final Token endToken;
  final bool isNullAware;

  DotAccessHandle(
    ParserAstType type, {
    required this.token,
    required this.endToken,
    required this.isNullAware,
  }) : super("DotAccess", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "endToken": endToken,
    "isNullAware": isNullAware,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitDotAccessHandle(this);
}

class CascadeAccessHandle extends ParserAstNode {
  final Token token;
  final Token endToken;
  final bool isNullAware;

  CascadeAccessHandle(
    ParserAstType type, {
    required this.token,
    required this.endToken,
    required this.isNullAware,
  }) : super("CascadeAccess", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "endToken": endToken,
    "isNullAware": isNullAware,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitCascadeAccessHandle(this);
}

class ConditionalExpressionBegin extends ParserAstNode {
  final Token question;

  ConditionalExpressionBegin(ParserAstType type, {required this.question})
    : super("ConditionalExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"question": question};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConditionalExpressionBegin(this);
}

class ConditionalExpressionColonHandle extends ParserAstNode {
  ConditionalExpressionColonHandle(ParserAstType type)
    : super("ConditionalExpressionColon", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitConditionalExpressionColonHandle(this);
}

class ConditionalExpressionEnd extends ParserAstNode {
  final Token question;
  final Token colon;
  final Token endToken;

  ConditionalExpressionEnd(
    ParserAstType type, {
    required this.question,
    required this.colon,
    required this.endToken,
  }) : super("ConditionalExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "question": question,
    "colon": colon,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConditionalExpressionEnd(this);
}

class ConstExpressionBegin extends ParserAstNode {
  final Token constKeyword;

  ConstExpressionBegin(ParserAstType type, {required this.constKeyword})
    : super("ConstExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "constKeyword": constKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstExpressionBegin(this);
}

class ConstExpressionEnd extends ParserAstNode {
  final Token token;

  ConstExpressionEnd(ParserAstType type, {required this.token})
    : super("ConstExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstExpressionEnd(this);
}

class ConstFactoryHandle extends ParserAstNode {
  final Token constKeyword;

  ConstFactoryHandle(ParserAstType type, {required this.constKeyword})
    : super("ConstFactory", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "constKeyword": constKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstFactoryHandle(this);
}

class ForControlFlowBegin extends ParserAstNode {
  final Token? awaitToken;
  final Token forToken;

  ForControlFlowBegin(
    ParserAstType type, {
    this.awaitToken,
    required this.forToken,
  }) : super("ForControlFlow", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "awaitToken": awaitToken,
    "forToken": forToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForControlFlowBegin(this);
}

class ForControlFlowEnd extends ParserAstNode {
  final Token token;

  ForControlFlowEnd(ParserAstType type, {required this.token})
    : super("ForControlFlow", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForControlFlowEnd(this);
}

class ForInControlFlowEnd extends ParserAstNode {
  final Token token;

  ForInControlFlowEnd(ParserAstType type, {required this.token})
    : super("ForInControlFlow", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitForInControlFlowEnd(this);
}

class IfControlFlowBegin extends ParserAstNode {
  final Token ifToken;

  IfControlFlowBegin(ParserAstType type, {required this.ifToken})
    : super("IfControlFlow", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"ifToken": ifToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIfControlFlowBegin(this);
}

class ThenControlFlowHandle extends ParserAstNode {
  final Token token;

  ThenControlFlowHandle(ParserAstType type, {required this.token})
    : super("ThenControlFlow", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitThenControlFlowHandle(this);
}

class ElseControlFlowHandle extends ParserAstNode {
  final Token elseToken;

  ElseControlFlowHandle(ParserAstType type, {required this.elseToken})
    : super("ElseControlFlow", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"elseToken": elseToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitElseControlFlowHandle(this);
}

class IfControlFlowEnd extends ParserAstNode {
  final Token token;

  IfControlFlowEnd(ParserAstType type, {required this.token})
    : super("IfControlFlow", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIfControlFlowEnd(this);
}

class IfElseControlFlowEnd extends ParserAstNode {
  final Token token;

  IfElseControlFlowEnd(ParserAstType type, {required this.token})
    : super("IfElseControlFlow", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIfElseControlFlowEnd(this);
}

class SpreadExpressionHandle extends ParserAstNode {
  final Token spreadToken;

  SpreadExpressionHandle(ParserAstType type, {required this.spreadToken})
    : super("SpreadExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"spreadToken": spreadToken};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSpreadExpressionHandle(this);
}

class NullAwareElementHandle extends ParserAstNode {
  final Token nullAwareToken;

  NullAwareElementHandle(ParserAstType type, {required this.nullAwareToken})
    : super("NullAwareElement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "nullAwareToken": nullAwareToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNullAwareElementHandle(this);
}

class RestPatternHandle extends ParserAstNode {
  final Token dots;
  final bool hasSubPattern;

  RestPatternHandle(
    ParserAstType type, {
    required this.dots,
    required this.hasSubPattern,
  }) : super("RestPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "dots": dots,
    "hasSubPattern": hasSubPattern,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRestPatternHandle(this);
}

class FunctionTypedFormalParameterBegin extends ParserAstNode {
  final Token token;

  FunctionTypedFormalParameterBegin(ParserAstType type, {required this.token})
    : super("FunctionTypedFormalParameter", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitFunctionTypedFormalParameterBegin(this);
}

class FunctionTypedFormalParameterEnd extends ParserAstNode {
  final Token nameToken;
  final Token? question;

  FunctionTypedFormalParameterEnd(
    ParserAstType type, {
    required this.nameToken,
    this.question,
  }) : super("FunctionTypedFormalParameter", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "nameToken": nameToken,
    "question": question,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitFunctionTypedFormalParameterEnd(this);
}

class IdentifierHandle extends ParserAstNode {
  final Token token;
  final IdentifierContext context;

  IdentifierHandle(
    ParserAstType type, {
    required this.token,
    required this.context,
  }) : super("Identifier", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "context": context,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIdentifierHandle(this);
}

class IndexedExpressionHandle extends ParserAstNode {
  final Token? question;
  final Token openSquareBracket;
  final Token closeSquareBracket;

  IndexedExpressionHandle(
    ParserAstType type, {
    this.question,
    required this.openSquareBracket,
    required this.closeSquareBracket,
  }) : super("IndexedExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "question": question,
    "openSquareBracket": openSquareBracket,
    "closeSquareBracket": closeSquareBracket,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIndexedExpressionHandle(this);
}

class IsOperatorTypeBegin extends ParserAstNode {
  final Token operator;

  IsOperatorTypeBegin(ParserAstType type, {required this.operator})
    : super("IsOperatorType", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"operator": operator};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIsOperatorTypeBegin(this);
}

class IsOperatorTypeEnd extends ParserAstNode {
  final Token operator;

  IsOperatorTypeEnd(ParserAstType type, {required this.operator})
    : super("IsOperatorType", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"operator": operator};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIsOperatorTypeEnd(this);
}

class IsOperatorHandle extends ParserAstNode {
  final Token isOperator;
  final Token? not;

  IsOperatorHandle(ParserAstType type, {required this.isOperator, this.not})
    : super("IsOperator", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "isOperator": isOperator,
    "not": not,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitIsOperatorHandle(this);
}

class LiteralBoolHandle extends ParserAstNode {
  final Token token;

  LiteralBoolHandle(ParserAstType type, {required this.token})
    : super("LiteralBool", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralBoolHandle(this);
}

class BreakStatementHandle extends ParserAstNode {
  final bool hasTarget;
  final Token breakKeyword;
  final Token endToken;

  BreakStatementHandle(
    ParserAstType type, {
    required this.hasTarget,
    required this.breakKeyword,
    required this.endToken,
  }) : super("BreakStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "hasTarget": hasTarget,
    "breakKeyword": breakKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitBreakStatementHandle(this);
}

class ContinueStatementHandle extends ParserAstNode {
  final bool hasTarget;
  final Token continueKeyword;
  final Token endToken;

  ContinueStatementHandle(
    ParserAstType type, {
    required this.hasTarget,
    required this.continueKeyword,
    required this.endToken,
  }) : super("ContinueStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "hasTarget": hasTarget,
    "continueKeyword": continueKeyword,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitContinueStatementHandle(this);
}

class EmptyStatementHandle extends ParserAstNode {
  final Token token;

  EmptyStatementHandle(ParserAstType type, {required this.token})
    : super("EmptyStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitEmptyStatementHandle(this);
}

class AssertBegin extends ParserAstNode {
  final Token assertKeyword;
  final Assert kind;

  AssertBegin(
    ParserAstType type, {
    required this.assertKeyword,
    required this.kind,
  }) : super("Assert", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "assertKeyword": assertKeyword,
    "kind": kind,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitAssertBegin(this);
}

class AssertEnd extends ParserAstNode {
  final Token assertKeyword;
  final Assert kind;
  final Token leftParenthesis;
  final Token? commaToken;
  final Token endToken;

  AssertEnd(
    ParserAstType type, {
    required this.assertKeyword,
    required this.kind,
    required this.leftParenthesis,
    this.commaToken,
    required this.endToken,
  }) : super("Assert", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "assertKeyword": assertKeyword,
    "kind": kind,
    "leftParenthesis": leftParenthesis,
    "commaToken": commaToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitAssertEnd(this);
}

class LiteralDoubleHandle extends ParserAstNode {
  final Token token;

  LiteralDoubleHandle(ParserAstType type, {required this.token})
    : super("LiteralDouble", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralDoubleHandle(this);
}

class LiteralDoubleWithSeparatorsHandle extends ParserAstNode {
  final Token token;

  LiteralDoubleWithSeparatorsHandle(ParserAstType type, {required this.token})
    : super("LiteralDoubleWithSeparators", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitLiteralDoubleWithSeparatorsHandle(this);
}

class LiteralIntHandle extends ParserAstNode {
  final Token token;

  LiteralIntHandle(ParserAstType type, {required this.token})
    : super("LiteralInt", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralIntHandle(this);
}

class LiteralIntWithSeparatorsHandle extends ParserAstNode {
  final Token token;

  LiteralIntWithSeparatorsHandle(ParserAstType type, {required this.token})
    : super("LiteralIntWithSeparators", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitLiteralIntWithSeparatorsHandle(this);
}

class LiteralListHandle extends ParserAstNode {
  final int count;
  final Token leftBracket;
  final Token? constKeyword;
  final Token rightBracket;

  LiteralListHandle(
    ParserAstType type, {
    required this.count,
    required this.leftBracket,
    this.constKeyword,
    required this.rightBracket,
  }) : super("LiteralList", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "leftBracket": leftBracket,
    "constKeyword": constKeyword,
    "rightBracket": rightBracket,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralListHandle(this);
}

class ListPatternHandle extends ParserAstNode {
  final int count;
  final Token leftBracket;
  final Token rightBracket;

  ListPatternHandle(
    ParserAstType type, {
    required this.count,
    required this.leftBracket,
    required this.rightBracket,
  }) : super("ListPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "leftBracket": leftBracket,
    "rightBracket": rightBracket,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitListPatternHandle(this);
}

class LiteralSetOrMapHandle extends ParserAstNode {
  final int count;
  final Token leftBrace;
  final Token? constKeyword;
  final Token rightBrace;
  final bool hasSetEntry;

  LiteralSetOrMapHandle(
    ParserAstType type, {
    required this.count,
    required this.leftBrace,
    this.constKeyword,
    required this.rightBrace,
    required this.hasSetEntry,
  }) : super("LiteralSetOrMap", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "leftBrace": leftBrace,
    "constKeyword": constKeyword,
    "rightBrace": rightBrace,
    "hasSetEntry": hasSetEntry,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralSetOrMapHandle(this);
}

class MapPatternHandle extends ParserAstNode {
  final int count;
  final Token leftBrace;
  final Token rightBrace;

  MapPatternHandle(
    ParserAstType type, {
    required this.count,
    required this.leftBrace,
    required this.rightBrace,
  }) : super("MapPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "count": count,
    "leftBrace": leftBrace,
    "rightBrace": rightBrace,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitMapPatternHandle(this);
}

class LiteralNullHandle extends ParserAstNode {
  final Token token;

  LiteralNullHandle(ParserAstType type, {required this.token})
    : super("LiteralNull", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitLiteralNullHandle(this);
}

class NativeClauseHandle extends ParserAstNode {
  final Token nativeToken;
  final bool hasName;

  NativeClauseHandle(
    ParserAstType type, {
    required this.nativeToken,
    required this.hasName,
  }) : super("NativeClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "nativeToken": nativeToken,
    "hasName": hasName,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNativeClauseHandle(this);
}

class NamedArgumentHandle extends ParserAstNode {
  final Token colon;

  NamedArgumentHandle(ParserAstType type, {required this.colon})
    : super("NamedArgument", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"colon": colon};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNamedArgumentHandle(this);
}

class PatternFieldHandle extends ParserAstNode {
  final Token? colon;

  PatternFieldHandle(ParserAstType type, {this.colon})
    : super("PatternField", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"colon": colon};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPatternFieldHandle(this);
}

class NamedRecordFieldHandle extends ParserAstNode {
  final Token colon;

  NamedRecordFieldHandle(ParserAstType type, {required this.colon})
    : super("NamedRecordField", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"colon": colon};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNamedRecordFieldHandle(this);
}

class NewExpressionBegin extends ParserAstNode {
  final Token token;

  NewExpressionBegin(ParserAstType type, {required this.token})
    : super("NewExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNewExpressionBegin(this);
}

class NewExpressionEnd extends ParserAstNode {
  final Token token;

  NewExpressionEnd(ParserAstType type, {required this.token})
    : super("NewExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNewExpressionEnd(this);
}

class NoArgumentsHandle extends ParserAstNode {
  final Token token;

  NoArgumentsHandle(ParserAstType type, {required this.token})
    : super("NoArguments", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoArgumentsHandle(this);
}

class NoConstructorReferenceContinuationAfterTypeArgumentsHandle
    extends ParserAstNode {
  final Token token;

  NoConstructorReferenceContinuationAfterTypeArgumentsHandle(
    ParserAstType type, {
    required this.token,
  }) : super("NoConstructorReferenceContinuationAfterTypeArguments", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitNoConstructorReferenceContinuationAfterTypeArgumentsHandle(this);
}

class NoTypeNameInConstructorReferenceHandle extends ParserAstNode {
  final Token token;

  NoTypeNameInConstructorReferenceHandle(
    ParserAstType type, {
    required this.token,
  }) : super("NoTypeNameInConstructorReference", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitNoTypeNameInConstructorReferenceHandle(this);
}

class NoTypeHandle extends ParserAstNode {
  final Token lastConsumed;

  NoTypeHandle(ParserAstType type, {required this.lastConsumed})
    : super("NoType", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "lastConsumed": lastConsumed,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoTypeHandle(this);
}

class NoTypeVariablesHandle extends ParserAstNode {
  final Token token;

  NoTypeVariablesHandle(ParserAstType type, {required this.token})
    : super("NoTypeVariables", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNoTypeVariablesHandle(this);
}

class OperatorHandle extends ParserAstNode {
  final Token token;

  OperatorHandle(ParserAstType type, {required this.token})
    : super("Operator", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitOperatorHandle(this);
}

class SwitchCaseNoWhenClauseHandle extends ParserAstNode {
  final Token token;

  SwitchCaseNoWhenClauseHandle(ParserAstType type, {required this.token})
    : super("SwitchCaseNoWhenClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitSwitchCaseNoWhenClauseHandle(this);
}

class SwitchExpressionCasePatternHandle extends ParserAstNode {
  final Token token;

  SwitchExpressionCasePatternHandle(ParserAstType type, {required this.token})
    : super("SwitchExpressionCasePattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitSwitchExpressionCasePatternHandle(this);
}

class SymbolVoidHandle extends ParserAstNode {
  final Token token;

  SymbolVoidHandle(ParserAstType type, {required this.token})
    : super("SymbolVoid", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSymbolVoidHandle(this);
}

class OperatorNameHandle extends ParserAstNode {
  final Token operatorKeyword;
  final Token token;

  OperatorNameHandle(
    ParserAstType type, {
    required this.operatorKeyword,
    required this.token,
  }) : super("OperatorName", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "operatorKeyword": operatorKeyword,
    "token": token,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitOperatorNameHandle(this);
}

class InvalidOperatorNameHandle extends ParserAstNode {
  final Token operatorKeyword;
  final Token token;

  InvalidOperatorNameHandle(
    ParserAstType type, {
    required this.operatorKeyword,
    required this.token,
  }) : super("InvalidOperatorName", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "operatorKeyword": operatorKeyword,
    "token": token,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidOperatorNameHandle(this);
}

class ParenthesizedConditionHandle extends ParserAstNode {
  final Token token;
  final Token? case_;
  final Token? when;

  ParenthesizedConditionHandle(
    ParserAstType type, {
    required this.token,
    this.case_,
    this.when,
  }) : super("ParenthesizedCondition", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "case_": case_,
    "when": when,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitParenthesizedConditionHandle(this);
}

class PatternBegin extends ParserAstNode {
  final Token token;

  PatternBegin(ParserAstType type, {required this.token})
    : super("Pattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPatternBegin(this);
}

class PatternGuardBegin extends ParserAstNode {
  final Token when;

  PatternGuardBegin(ParserAstType type, {required this.when})
    : super("PatternGuard", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"when": when};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPatternGuardBegin(this);
}

class ParenthesizedExpressionOrRecordLiteralBegin extends ParserAstNode {
  final Token token;

  ParenthesizedExpressionOrRecordLiteralBegin(
    ParserAstType type, {
    required this.token,
  }) : super("ParenthesizedExpressionOrRecordLiteral", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitParenthesizedExpressionOrRecordLiteralBegin(this);
}

class SwitchCaseWhenClauseBegin extends ParserAstNode {
  final Token when;

  SwitchCaseWhenClauseBegin(ParserAstType type, {required this.when})
    : super("SwitchCaseWhenClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"when": when};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchCaseWhenClauseBegin(this);
}

class RecordLiteralEnd extends ParserAstNode {
  final Token token;
  final int count;
  final Token? constKeyword;

  RecordLiteralEnd(
    ParserAstType type, {
    required this.token,
    required this.count,
    this.constKeyword,
  }) : super("RecordLiteral", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "count": count,
    "constKeyword": constKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecordLiteralEnd(this);
}

class RecordPatternHandle extends ParserAstNode {
  final Token token;
  final int count;

  RecordPatternHandle(
    ParserAstType type, {
    required this.token,
    required this.count,
  }) : super("RecordPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "count": count,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecordPatternHandle(this);
}

class PatternEnd extends ParserAstNode {
  final Token token;

  PatternEnd(ParserAstType type, {required this.token})
    : super("Pattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPatternEnd(this);
}

class PatternGuardEnd extends ParserAstNode {
  final Token token;

  PatternGuardEnd(ParserAstType type, {required this.token})
    : super("PatternGuard", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPatternGuardEnd(this);
}

class ParenthesizedExpressionEnd extends ParserAstNode {
  final Token token;

  ParenthesizedExpressionEnd(ParserAstType type, {required this.token})
    : super("ParenthesizedExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitParenthesizedExpressionEnd(this);
}

class SwitchCaseWhenClauseEnd extends ParserAstNode {
  final Token token;

  SwitchCaseWhenClauseEnd(ParserAstType type, {required this.token})
    : super("SwitchCaseWhenClause", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchCaseWhenClauseEnd(this);
}

class ParenthesizedPatternHandle extends ParserAstNode {
  final Token token;

  ParenthesizedPatternHandle(ParserAstType type, {required this.token})
    : super("ParenthesizedPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitParenthesizedPatternHandle(this);
}

class ConstantPatternBegin extends ParserAstNode {
  final Token? constKeyword;

  ConstantPatternBegin(ParserAstType type, {this.constKeyword})
    : super("ConstantPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "constKeyword": constKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstantPatternBegin(this);
}

class ConstantPatternEnd extends ParserAstNode {
  final Token? constKeyword;

  ConstantPatternEnd(ParserAstType type, {this.constKeyword})
    : super("ConstantPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "constKeyword": constKeyword,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstantPatternEnd(this);
}

class ObjectPatternHandle extends ParserAstNode {
  final Token firstIdentifier;
  final Token? dot;
  final Token? secondIdentifier;

  ObjectPatternHandle(
    ParserAstType type, {
    required this.firstIdentifier,
    this.dot,
    this.secondIdentifier,
  }) : super("ObjectPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "firstIdentifier": firstIdentifier,
    "dot": dot,
    "secondIdentifier": secondIdentifier,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitObjectPatternHandle(this);
}

class QualifiedHandle extends ParserAstNode {
  final Token period;

  QualifiedHandle(ParserAstType type, {required this.period})
    : super("Qualified", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"period": period};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitQualifiedHandle(this);
}

class StringPartHandle extends ParserAstNode {
  final Token token;

  StringPartHandle(ParserAstType type, {required this.token})
    : super("StringPart", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitStringPartHandle(this);
}

class SuperExpressionHandle extends ParserAstNode {
  final Token token;
  final IdentifierContext context;

  SuperExpressionHandle(
    ParserAstType type, {
    required this.token,
    required this.context,
  }) : super("SuperExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "context": context,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSuperExpressionHandle(this);
}

class AugmentSuperExpressionHandle extends ParserAstNode {
  final Token augmentToken;
  final Token superToken;
  final IdentifierContext context;

  AugmentSuperExpressionHandle(
    ParserAstType type, {
    required this.augmentToken,
    required this.superToken,
    required this.context,
  }) : super("AugmentSuperExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "augmentToken": augmentToken,
    "superToken": superToken,
    "context": context,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitAugmentSuperExpressionHandle(this);
}

class SwitchCaseBegin extends ParserAstNode {
  final int labelCount;
  final int expressionCount;
  final Token beginToken;

  SwitchCaseBegin(
    ParserAstType type, {
    required this.labelCount,
    required this.expressionCount,
    required this.beginToken,
  }) : super("SwitchCase", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "labelCount": labelCount,
    "expressionCount": expressionCount,
    "beginToken": beginToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchCaseBegin(this);
}

class SwitchCaseEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  final int labelCount;
  final int expressionCount;
  final Token? defaultKeyword;
  final Token? colonAfterDefault;
  final int statementCount;
  @override
  final Token beginToken;
  @override
  final Token endToken;

  SwitchCaseEnd(
    ParserAstType type, {
    required this.labelCount,
    required this.expressionCount,
    this.defaultKeyword,
    this.colonAfterDefault,
    required this.statementCount,
    required this.beginToken,
    required this.endToken,
  }) : super("SwitchCase", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "labelCount": labelCount,
    "expressionCount": expressionCount,
    "defaultKeyword": defaultKeyword,
    "colonAfterDefault": colonAfterDefault,
    "statementCount": statementCount,
    "beginToken": beginToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchCaseEnd(this);
}

class SwitchExpressionCaseBegin extends ParserAstNode {
  SwitchExpressionCaseBegin(ParserAstType type)
    : super("SwitchExpressionCase", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchExpressionCaseBegin(this);
}

class SwitchExpressionCaseEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token? when;
  final Token arrow;
  @override
  final Token endToken;

  SwitchExpressionCaseEnd(
    ParserAstType type, {
    required this.beginToken,
    this.when,
    required this.arrow,
    required this.endToken,
  }) : super("SwitchExpressionCase", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "when": when,
    "arrow": arrow,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitSwitchExpressionCaseEnd(this);
}

class ThisExpressionHandle extends ParserAstNode {
  final Token token;
  final IdentifierContext context;

  ThisExpressionHandle(
    ParserAstType type, {
    required this.token,
    required this.context,
  }) : super("ThisExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "context": context,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitThisExpressionHandle(this);
}

class UnaryPostfixAssignmentExpressionHandle extends ParserAstNode {
  final Token token;

  UnaryPostfixAssignmentExpressionHandle(
    ParserAstType type, {
    required this.token,
  }) : super("UnaryPostfixAssignmentExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitUnaryPostfixAssignmentExpressionHandle(this);
}

class UnaryPrefixExpressionHandle extends ParserAstNode {
  final Token token;

  UnaryPrefixExpressionHandle(ParserAstType type, {required this.token})
    : super("UnaryPrefixExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitUnaryPrefixExpressionHandle(this);
}

class RelationalPatternHandle extends ParserAstNode {
  final Token token;

  RelationalPatternHandle(ParserAstType type, {required this.token})
    : super("RelationalPattern", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRelationalPatternHandle(this);
}

class UnaryPrefixAssignmentExpressionHandle extends ParserAstNode {
  final Token token;

  UnaryPrefixAssignmentExpressionHandle(
    ParserAstType type, {
    required this.token,
  }) : super("UnaryPrefixAssignmentExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitUnaryPrefixAssignmentExpressionHandle(this);
}

class FormalParameterDefaultValueExpressionBegin extends ParserAstNode {
  FormalParameterDefaultValueExpressionBegin(ParserAstType type)
    : super("FormalParameterDefaultValueExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitFormalParameterDefaultValueExpressionBegin(this);
}

class FormalParameterDefaultValueExpressionEnd extends ParserAstNode {
  FormalParameterDefaultValueExpressionEnd(ParserAstType type)
    : super("FormalParameterDefaultValueExpression", type);

  @override
  Map<String, Object?> get deprecatedArguments => {};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitFormalParameterDefaultValueExpressionEnd(this);
}

class ValuedFormalParameterHandle extends ParserAstNode {
  final Token equals;
  final Token token;
  final FormalParameterKind kind;

  ValuedFormalParameterHandle(
    ParserAstType type, {
    required this.equals,
    required this.token,
    required this.kind,
  }) : super("ValuedFormalParameter", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "equals": equals,
    "token": token,
    "kind": kind,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitValuedFormalParameterHandle(this);
}

class FormalParameterWithoutValueHandle extends ParserAstNode {
  final Token token;

  FormalParameterWithoutValueHandle(ParserAstType type, {required this.token})
    : super("FormalParameterWithoutValue", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitFormalParameterWithoutValueHandle(this);
}

class VoidKeywordHandle extends ParserAstNode {
  final Token token;

  VoidKeywordHandle(ParserAstType type, {required this.token})
    : super("VoidKeyword", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitVoidKeywordHandle(this);
}

class VoidKeywordWithTypeArgumentsHandle extends ParserAstNode {
  final Token token;

  VoidKeywordWithTypeArgumentsHandle(ParserAstType type, {required this.token})
    : super("VoidKeywordWithTypeArguments", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitVoidKeywordWithTypeArgumentsHandle(this);
}

class YieldStatementBegin extends ParserAstNode {
  final Token token;

  YieldStatementBegin(ParserAstType type, {required this.token})
    : super("YieldStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitYieldStatementBegin(this);
}

class YieldStatementEnd extends ParserAstNode {
  final Token yieldToken;
  final Token? starToken;
  final Token endToken;

  YieldStatementEnd(
    ParserAstType type, {
    required this.yieldToken,
    this.starToken,
    required this.endToken,
  }) : super("YieldStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "yieldToken": yieldToken,
    "starToken": starToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitYieldStatementEnd(this);
}

class InvalidYieldStatementEnd extends ParserAstNode
    implements BeginAndEndTokenParserAstNode {
  @override
  final Token beginToken;
  final Token? starToken;
  @override
  final Token endToken;
  final MessageCode errorCode;

  InvalidYieldStatementEnd(
    ParserAstType type, {
    required this.beginToken,
    this.starToken,
    required this.endToken,
    required this.errorCode,
  }) : super("InvalidYieldStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "beginToken": beginToken,
    "starToken": starToken,
    "endToken": endToken,
    "errorCode": errorCode,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidYieldStatementEnd(this);
}

class RecoverableErrorHandle extends ParserAstNode {
  final Message message;
  final Token startToken;
  final Token endToken;

  RecoverableErrorHandle(
    ParserAstType type, {
    required this.message,
    required this.startToken,
    required this.endToken,
  }) : super("RecoverableError", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "message": message,
    "startToken": startToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitRecoverableErrorHandle(this);
}

class ExperimentNotEnabledHandle extends ParserAstNode {
  final ExperimentalFlag experimentalFlag;
  final Token startToken;
  final Token endToken;

  ExperimentNotEnabledHandle(
    ParserAstType type, {
    required this.experimentalFlag,
    required this.startToken,
    required this.endToken,
  }) : super("ExperimentNotEnabled", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "experimentalFlag": experimentalFlag,
    "startToken": startToken,
    "endToken": endToken,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitExperimentNotEnabledHandle(this);
}

class ErrorTokenHandle extends ParserAstNode {
  final ErrorToken token;

  ErrorTokenHandle(ParserAstType type, {required this.token})
    : super("ErrorToken", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitErrorTokenHandle(this);
}

class UnescapeErrorHandle extends ParserAstNode {
  final Message message;
  final Token location;
  final int stringOffset;
  final int length;

  UnescapeErrorHandle(
    ParserAstType type, {
    required this.message,
    required this.location,
    required this.stringOffset,
    required this.length,
  }) : super("UnescapeError", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "message": message,
    "location": location,
    "stringOffset": stringOffset,
    "length": length,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitUnescapeErrorHandle(this);
}

class InvalidStatementHandle extends ParserAstNode {
  final Token token;
  final Message message;

  InvalidStatementHandle(
    ParserAstType type, {
    required this.token,
    required this.message,
  }) : super("InvalidStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "token": token,
    "message": message,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitInvalidStatementHandle(this);
}

class ScriptHandle extends ParserAstNode {
  final Token token;

  ScriptHandle(ParserAstType type, {required this.token})
    : super("Script", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitScriptHandle(this);
}

class TypeArgumentApplicationHandle extends ParserAstNode {
  final Token openAngleBracket;

  TypeArgumentApplicationHandle(
    ParserAstType type, {
    required this.openAngleBracket,
  }) : super("TypeArgumentApplication", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "openAngleBracket": openAngleBracket,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitTypeArgumentApplicationHandle(this);
}

class NewAsIdentifierHandle extends ParserAstNode {
  final Token token;

  NewAsIdentifierHandle(ParserAstType type, {required this.token})
    : super("NewAsIdentifier", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitNewAsIdentifierHandle(this);
}

class PatternVariableDeclarationStatementHandle extends ParserAstNode {
  final Token keyword;
  final Token equals;
  final Token semicolon;

  PatternVariableDeclarationStatementHandle(
    ParserAstType type, {
    required this.keyword,
    required this.equals,
    required this.semicolon,
  }) : super("PatternVariableDeclarationStatement", type);

  @override
  Map<String, Object?> get deprecatedArguments => {
    "keyword": keyword,
    "equals": equals,
    "semicolon": semicolon,
  };

  @override
  R accept<R>(ParserAstVisitor<R> v) =>
      v.visitPatternVariableDeclarationStatementHandle(this);
}

class PatternAssignmentHandle extends ParserAstNode {
  final Token equals;

  PatternAssignmentHandle(ParserAstType type, {required this.equals})
    : super("PatternAssignment", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"equals": equals};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitPatternAssignmentHandle(this);
}

class DotShorthandContextHandle extends ParserAstNode {
  final Token token;

  DotShorthandContextHandle(ParserAstType type, {required this.token})
    : super("DotShorthandContext", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitDotShorthandContextHandle(this);
}

class DotShorthandHeadHandle extends ParserAstNode {
  final Token token;

  DotShorthandHeadHandle(ParserAstType type, {required this.token})
    : super("DotShorthandHead", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitDotShorthandHeadHandle(this);
}

class ConstDotShorthandBegin extends ParserAstNode {
  final Token token;

  ConstDotShorthandBegin(ParserAstType type, {required this.token})
    : super("ConstDotShorthand", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstDotShorthandBegin(this);
}

class ConstDotShorthandEnd extends ParserAstNode {
  final Token token;

  ConstDotShorthandEnd(ParserAstType type, {required this.token})
    : super("ConstDotShorthand", type);

  @override
  Map<String, Object?> get deprecatedArguments => {"token": token};

  @override
  R accept<R>(ParserAstVisitor<R> v) => v.visitConstDotShorthandEnd(this);
}

abstract class ParserAstVisitor<R> {
  R visitArgumentsBegin(ArgumentsBegin node);
  R visitArgumentsEnd(ArgumentsEnd node);
  R visitObjectPatternFieldsHandle(ObjectPatternFieldsHandle node);
  R visitAsyncModifierHandle(AsyncModifierHandle node);
  R visitAwaitExpressionBegin(AwaitExpressionBegin node);
  R visitAwaitExpressionEnd(AwaitExpressionEnd node);
  R visitInvalidAwaitExpressionEnd(InvalidAwaitExpressionEnd node);
  R visitBlockBegin(BlockBegin node);
  R visitBlockEnd(BlockEnd node);
  R visitInvalidTopLevelBlockHandle(InvalidTopLevelBlockHandle node);
  R visitCascadeBegin(CascadeBegin node);
  R visitCascadeEnd(CascadeEnd node);
  R visitCaseExpressionBegin(CaseExpressionBegin node);
  R visitCaseExpressionEnd(CaseExpressionEnd node);
  R visitClassOrMixinOrExtensionBodyBegin(
    ClassOrMixinOrExtensionBodyBegin node,
  );
  R visitClassOrMixinOrExtensionBodyEnd(ClassOrMixinOrExtensionBodyEnd node);
  R visitClassOrMixinOrNamedMixinApplicationPreludeBegin(
    ClassOrMixinOrNamedMixinApplicationPreludeBegin node,
  );
  R visitClassDeclarationBegin(ClassDeclarationBegin node);
  R visitClassExtendsHandle(ClassExtendsHandle node);
  R visitImplementsHandle(ImplementsHandle node);
  R visitClassHeaderHandle(ClassHeaderHandle node);
  R visitRecoverDeclarationHeaderHandle(RecoverDeclarationHeaderHandle node);
  R visitClassDeclarationEnd(ClassDeclarationEnd node);
  R visitMixinDeclarationBegin(MixinDeclarationBegin node);
  R visitMixinOnHandle(MixinOnHandle node);
  R visitMixinHeaderHandle(MixinHeaderHandle node);
  R visitRecoverMixinHeaderHandle(RecoverMixinHeaderHandle node);
  R visitMixinDeclarationEnd(MixinDeclarationEnd node);
  R visitUncategorizedTopLevelDeclarationBegin(
    UncategorizedTopLevelDeclarationBegin node,
  );
  R visitExtensionDeclarationPreludeBegin(
    ExtensionDeclarationPreludeBegin node,
  );
  R visitExtensionDeclarationBegin(ExtensionDeclarationBegin node);
  R visitExtensionDeclarationEnd(ExtensionDeclarationEnd node);
  R visitExtensionTypeDeclarationBegin(ExtensionTypeDeclarationBegin node);
  R visitExtensionTypeDeclarationEnd(ExtensionTypeDeclarationEnd node);
  R visitPrimaryConstructorBegin(PrimaryConstructorBegin node);
  R visitPrimaryConstructorEnd(PrimaryConstructorEnd node);
  R visitNoPrimaryConstructorHandle(NoPrimaryConstructorHandle node);
  R visitCombinatorsBegin(CombinatorsBegin node);
  R visitCombinatorsEnd(CombinatorsEnd node);
  R visitCompilationUnitBegin(CompilationUnitBegin node);
  R visitDirectivesOnlyHandle(DirectivesOnlyHandle node);
  R visitCompilationUnitEnd(CompilationUnitEnd node);
  R visitConstLiteralBegin(ConstLiteralBegin node);
  R visitConstLiteralEnd(ConstLiteralEnd node);
  R visitConstructorReferenceBegin(ConstructorReferenceBegin node);
  R visitConstructorReferenceEnd(ConstructorReferenceEnd node);
  R visitDoWhileStatementBegin(DoWhileStatementBegin node);
  R visitDoWhileStatementEnd(DoWhileStatementEnd node);
  R visitDoWhileStatementBodyBegin(DoWhileStatementBodyBegin node);
  R visitDoWhileStatementBodyEnd(DoWhileStatementBodyEnd node);
  R visitWhileStatementBodyBegin(WhileStatementBodyBegin node);
  R visitWhileStatementBodyEnd(WhileStatementBodyEnd node);
  R visitEnumBegin(EnumBegin node);
  R visitEnumEnd(EnumEnd node);
  R visitEnumConstructorEnd(EnumConstructorEnd node);
  R visitEnumElementsHandle(EnumElementsHandle node);
  R visitEnumHeaderHandle(EnumHeaderHandle node);
  R visitEnumElementHandle(EnumElementHandle node);
  R visitEnumFactoryMethodEnd(EnumFactoryMethodEnd node);
  R visitExportBegin(ExportBegin node);
  R visitExportEnd(ExportEnd node);
  R visitExtraneousExpressionHandle(ExtraneousExpressionHandle node);
  R visitExpressionStatementHandle(ExpressionStatementHandle node);
  R visitFactoryMethodBegin(FactoryMethodBegin node);
  R visitClassFactoryMethodEnd(ClassFactoryMethodEnd node);
  R visitMixinFactoryMethodEnd(MixinFactoryMethodEnd node);
  R visitExtensionFactoryMethodEnd(ExtensionFactoryMethodEnd node);
  R visitExtensionTypeFactoryMethodEnd(ExtensionTypeFactoryMethodEnd node);
  R visitFormalParameterBegin(FormalParameterBegin node);
  R visitFormalParameterEnd(FormalParameterEnd node);
  R visitNoFormalParametersHandle(NoFormalParametersHandle node);
  R visitFormalParametersBegin(FormalParametersBegin node);
  R visitFormalParametersEnd(FormalParametersEnd node);
  R visitClassFieldsEnd(ClassFieldsEnd node);
  R visitMixinFieldsEnd(MixinFieldsEnd node);
  R visitExtensionFieldsEnd(ExtensionFieldsEnd node);
  R visitExtensionTypeFieldsEnd(ExtensionTypeFieldsEnd node);
  R visitEnumFieldsEnd(EnumFieldsEnd node);
  R visitEnumMethodEnd(EnumMethodEnd node);
  R visitForInitializerEmptyStatementHandle(
    ForInitializerEmptyStatementHandle node,
  );
  R visitForInitializerExpressionStatementHandle(
    ForInitializerExpressionStatementHandle node,
  );
  R visitForInitializerLocalVariableDeclarationHandle(
    ForInitializerLocalVariableDeclarationHandle node,
  );
  R visitForInitializerPatternVariableAssignmentHandle(
    ForInitializerPatternVariableAssignmentHandle node,
  );
  R visitForStatementBegin(ForStatementBegin node);
  R visitForLoopPartsHandle(ForLoopPartsHandle node);
  R visitForStatementEnd(ForStatementEnd node);
  R visitForStatementBodyBegin(ForStatementBodyBegin node);
  R visitForStatementBodyEnd(ForStatementBodyEnd node);
  R visitForInLoopPartsHandle(ForInLoopPartsHandle node);
  R visitForInEnd(ForInEnd node);
  R visitForInExpressionBegin(ForInExpressionBegin node);
  R visitForInExpressionEnd(ForInExpressionEnd node);
  R visitForInBodyBegin(ForInBodyBegin node);
  R visitForInBodyEnd(ForInBodyEnd node);
  R visitNamedFunctionExpressionBegin(NamedFunctionExpressionBegin node);
  R visitNamedFunctionExpressionEnd(NamedFunctionExpressionEnd node);
  R visitLocalFunctionDeclarationBegin(LocalFunctionDeclarationBegin node);
  R visitLocalFunctionDeclarationEnd(LocalFunctionDeclarationEnd node);
  R visitBlockFunctionBodyBegin(BlockFunctionBodyBegin node);
  R visitBlockFunctionBodyEnd(BlockFunctionBodyEnd node);
  R visitNoFunctionBodyHandle(NoFunctionBodyHandle node);
  R visitFunctionBodySkippedHandle(FunctionBodySkippedHandle node);
  R visitFunctionNameBegin(FunctionNameBegin node);
  R visitFunctionNameEnd(FunctionNameEnd node);
  R visitTypedefBegin(TypedefBegin node);
  R visitTypedefEnd(TypedefEnd node);
  R visitClassWithClauseHandle(ClassWithClauseHandle node);
  R visitClassNoWithClauseHandle(ClassNoWithClauseHandle node);
  R visitEnumWithClauseHandle(EnumWithClauseHandle node);
  R visitEnumNoWithClauseHandle(EnumNoWithClauseHandle node);
  R visitMixinWithClauseHandle(MixinWithClauseHandle node);
  R visitNamedMixinApplicationBegin(NamedMixinApplicationBegin node);
  R visitNamedMixinApplicationWithClauseHandle(
    NamedMixinApplicationWithClauseHandle node,
  );
  R visitNamedMixinApplicationEnd(NamedMixinApplicationEnd node);
  R visitHideBegin(HideBegin node);
  R visitHideEnd(HideEnd node);
  R visitIdentifierListHandle(IdentifierListHandle node);
  R visitTypeListBegin(TypeListBegin node);
  R visitTypeListEnd(TypeListEnd node);
  R visitIfStatementBegin(IfStatementBegin node);
  R visitIfStatementEnd(IfStatementEnd node);
  R visitThenStatementBegin(ThenStatementBegin node);
  R visitThenStatementEnd(ThenStatementEnd node);
  R visitElseStatementBegin(ElseStatementBegin node);
  R visitElseStatementEnd(ElseStatementEnd node);
  R visitImportBegin(ImportBegin node);
  R visitImportPrefixHandle(ImportPrefixHandle node);
  R visitImportEnd(ImportEnd node);
  R visitRecoverImportHandle(RecoverImportHandle node);
  R visitConditionalUrisBegin(ConditionalUrisBegin node);
  R visitConditionalUrisEnd(ConditionalUrisEnd node);
  R visitConditionalUriBegin(ConditionalUriBegin node);
  R visitConditionalUriEnd(ConditionalUriEnd node);
  R visitDottedNameHandle(DottedNameHandle node);
  R visitImplicitCreationExpressionBegin(ImplicitCreationExpressionBegin node);
  R visitImplicitCreationExpressionEnd(ImplicitCreationExpressionEnd node);
  R visitInitializedIdentifierBegin(InitializedIdentifierBegin node);
  R visitInitializedIdentifierEnd(InitializedIdentifierEnd node);
  R visitFieldInitializerBegin(FieldInitializerBegin node);
  R visitFieldInitializerEnd(FieldInitializerEnd node);
  R visitNoFieldInitializerHandle(NoFieldInitializerHandle node);
  R visitVariableInitializerBegin(VariableInitializerBegin node);
  R visitVariableInitializerEnd(VariableInitializerEnd node);
  R visitNoVariableInitializerHandle(NoVariableInitializerHandle node);
  R visitInitializerBegin(InitializerBegin node);
  R visitInitializerEnd(InitializerEnd node);
  R visitInitializersBegin(InitializersBegin node);
  R visitInitializersEnd(InitializersEnd node);
  R visitNoInitializersHandle(NoInitializersHandle node);
  R visitInvalidExpressionHandle(InvalidExpressionHandle node);
  R visitInvalidFunctionBodyHandle(InvalidFunctionBodyHandle node);
  R visitInvalidTypeReferenceHandle(InvalidTypeReferenceHandle node);
  R visitLabelHandle(LabelHandle node);
  R visitLabeledStatementBegin(LabeledStatementBegin node);
  R visitLabeledStatementEnd(LabeledStatementEnd node);
  R visitLibraryAugmentationBegin(LibraryAugmentationBegin node);
  R visitLibraryAugmentationEnd(LibraryAugmentationEnd node);
  R visitLibraryNameBegin(LibraryNameBegin node);
  R visitLibraryNameEnd(LibraryNameEnd node);
  R visitLiteralMapEntryHandle(LiteralMapEntryHandle node);
  R visitMapPatternEntryHandle(MapPatternEntryHandle node);
  R visitLiteralStringBegin(LiteralStringBegin node);
  R visitInterpolationExpressionHandle(InterpolationExpressionHandle node);
  R visitLiteralStringEnd(LiteralStringEnd node);
  R visitAdjacentStringLiteralsHandle(AdjacentStringLiteralsHandle node);
  R visitMemberBegin(MemberBegin node);
  R visitInvalidMemberHandle(InvalidMemberHandle node);
  R visitMemberEnd(MemberEnd node);
  R visitMethodBegin(MethodBegin node);
  R visitClassMethodEnd(ClassMethodEnd node);
  R visitMixinMethodEnd(MixinMethodEnd node);
  R visitExtensionMethodEnd(ExtensionMethodEnd node);
  R visitExtensionTypeMethodEnd(ExtensionTypeMethodEnd node);
  R visitClassConstructorEnd(ClassConstructorEnd node);
  R visitMixinConstructorEnd(MixinConstructorEnd node);
  R visitExtensionConstructorEnd(ExtensionConstructorEnd node);
  R visitExtensionTypeConstructorEnd(ExtensionTypeConstructorEnd node);
  R visitMetadataStarBegin(MetadataStarBegin node);
  R visitMetadataStarEnd(MetadataStarEnd node);
  R visitMetadataBegin(MetadataBegin node);
  R visitMetadataEnd(MetadataEnd node);
  R visitOptionalFormalParametersBegin(OptionalFormalParametersBegin node);
  R visitOptionalFormalParametersEnd(OptionalFormalParametersEnd node);
  R visitPartBegin(PartBegin node);
  R visitPartEnd(PartEnd node);
  R visitPartOfBegin(PartOfBegin node);
  R visitPartOfEnd(PartOfEnd node);
  R visitRedirectingFactoryBodyBegin(RedirectingFactoryBodyBegin node);
  R visitRedirectingFactoryBodyEnd(RedirectingFactoryBodyEnd node);
  R visitReturnStatementBegin(ReturnStatementBegin node);
  R visitNativeFunctionBodyHandle(NativeFunctionBodyHandle node);
  R visitNativeFunctionBodyIgnoredHandle(NativeFunctionBodyIgnoredHandle node);
  R visitNativeFunctionBodySkippedHandle(NativeFunctionBodySkippedHandle node);
  R visitEmptyFunctionBodyHandle(EmptyFunctionBodyHandle node);
  R visitExpressionFunctionBodyHandle(ExpressionFunctionBodyHandle node);
  R visitReturnStatementEnd(ReturnStatementEnd node);
  R visitSendHandle(SendHandle node);
  R visitShowBegin(ShowBegin node);
  R visitShowEnd(ShowEnd node);
  R visitSwitchStatementBegin(SwitchStatementBegin node);
  R visitSwitchStatementEnd(SwitchStatementEnd node);
  R visitSwitchExpressionBegin(SwitchExpressionBegin node);
  R visitSwitchExpressionEnd(SwitchExpressionEnd node);
  R visitSwitchBlockBegin(SwitchBlockBegin node);
  R visitSwitchBlockEnd(SwitchBlockEnd node);
  R visitSwitchExpressionBlockBegin(SwitchExpressionBlockBegin node);
  R visitSwitchExpressionBlockEnd(SwitchExpressionBlockEnd node);
  R visitLiteralSymbolBegin(LiteralSymbolBegin node);
  R visitLiteralSymbolEnd(LiteralSymbolEnd node);
  R visitThrowExpressionHandle(ThrowExpressionHandle node);
  R visitRethrowStatementBegin(RethrowStatementBegin node);
  R visitRethrowStatementEnd(RethrowStatementEnd node);
  R visitTopLevelDeclarationEnd(TopLevelDeclarationEnd node);
  R visitInvalidTopLevelDeclarationHandle(
    InvalidTopLevelDeclarationHandle node,
  );
  R visitTopLevelMemberBegin(TopLevelMemberBegin node);
  R visitFieldsBegin(FieldsBegin node);
  R visitTopLevelFieldsEnd(TopLevelFieldsEnd node);
  R visitTopLevelMethodBegin(TopLevelMethodBegin node);
  R visitTopLevelMethodEnd(TopLevelMethodEnd node);
  R visitTryStatementBegin(TryStatementBegin node);
  R visitCatchClauseBegin(CatchClauseBegin node);
  R visitCatchClauseEnd(CatchClauseEnd node);
  R visitCatchBlockHandle(CatchBlockHandle node);
  R visitFinallyBlockHandle(FinallyBlockHandle node);
  R visitTryStatementEnd(TryStatementEnd node);
  R visitTypeHandle(TypeHandle node);
  R visitNonNullAssertExpressionHandle(NonNullAssertExpressionHandle node);
  R visitNullAssertPatternHandle(NullAssertPatternHandle node);
  R visitNullCheckPatternHandle(NullCheckPatternHandle node);
  R visitAssignedVariablePatternHandle(AssignedVariablePatternHandle node);
  R visitDeclaredVariablePatternHandle(DeclaredVariablePatternHandle node);
  R visitWildcardPatternHandle(WildcardPatternHandle node);
  R visitNoNameHandle(NoNameHandle node);
  R visitRecordTypeBegin(RecordTypeBegin node);
  R visitRecordTypeEnd(RecordTypeEnd node);
  R visitRecordTypeEntryBegin(RecordTypeEntryBegin node);
  R visitRecordTypeEntryEnd(RecordTypeEntryEnd node);
  R visitRecordTypeNamedFieldsBegin(RecordTypeNamedFieldsBegin node);
  R visitRecordTypeNamedFieldsEnd(RecordTypeNamedFieldsEnd node);
  R visitFunctionTypeBegin(FunctionTypeBegin node);
  R visitFunctionTypeEnd(FunctionTypeEnd node);
  R visitTypeArgumentsBegin(TypeArgumentsBegin node);
  R visitTypeArgumentsEnd(TypeArgumentsEnd node);
  R visitInvalidTypeArgumentsHandle(InvalidTypeArgumentsHandle node);
  R visitNoTypeArgumentsHandle(NoTypeArgumentsHandle node);
  R visitTypeVariableBegin(TypeVariableBegin node);
  R visitTypeVariablesDefinedHandle(TypeVariablesDefinedHandle node);
  R visitTypeVariableEnd(TypeVariableEnd node);
  R visitTypeVariablesBegin(TypeVariablesBegin node);
  R visitTypeVariablesEnd(TypeVariablesEnd node);
  R visitFunctionExpressionBegin(FunctionExpressionBegin node);
  R visitFunctionExpressionEnd(FunctionExpressionEnd node);
  R visitVariablesDeclarationBegin(VariablesDeclarationBegin node);
  R visitVariablesDeclarationEnd(VariablesDeclarationEnd node);
  R visitWhileStatementBegin(WhileStatementBegin node);
  R visitWhileStatementEnd(WhileStatementEnd node);
  R visitAsOperatorTypeBegin(AsOperatorTypeBegin node);
  R visitAsOperatorTypeEnd(AsOperatorTypeEnd node);
  R visitAsOperatorHandle(AsOperatorHandle node);
  R visitCastPatternHandle(CastPatternHandle node);
  R visitAssignmentExpressionHandle(AssignmentExpressionHandle node);
  R visitBinaryExpressionBegin(BinaryExpressionBegin node);
  R visitBinaryExpressionEnd(BinaryExpressionEnd node);
  R visitBinaryPatternBegin(BinaryPatternBegin node);
  R visitBinaryPatternEnd(BinaryPatternEnd node);
  R visitDotAccessHandle(DotAccessHandle node);
  R visitCascadeAccessHandle(CascadeAccessHandle node);
  R visitConditionalExpressionBegin(ConditionalExpressionBegin node);
  R visitConditionalExpressionColonHandle(
    ConditionalExpressionColonHandle node,
  );
  R visitConditionalExpressionEnd(ConditionalExpressionEnd node);
  R visitConstExpressionBegin(ConstExpressionBegin node);
  R visitConstExpressionEnd(ConstExpressionEnd node);
  R visitConstFactoryHandle(ConstFactoryHandle node);
  R visitForControlFlowBegin(ForControlFlowBegin node);
  R visitForControlFlowEnd(ForControlFlowEnd node);
  R visitForInControlFlowEnd(ForInControlFlowEnd node);
  R visitIfControlFlowBegin(IfControlFlowBegin node);
  R visitThenControlFlowHandle(ThenControlFlowHandle node);
  R visitElseControlFlowHandle(ElseControlFlowHandle node);
  R visitIfControlFlowEnd(IfControlFlowEnd node);
  R visitIfElseControlFlowEnd(IfElseControlFlowEnd node);
  R visitSpreadExpressionHandle(SpreadExpressionHandle node);
  R visitNullAwareElementHandle(NullAwareElementHandle node);
  R visitRestPatternHandle(RestPatternHandle node);
  R visitFunctionTypedFormalParameterBegin(
    FunctionTypedFormalParameterBegin node,
  );
  R visitFunctionTypedFormalParameterEnd(FunctionTypedFormalParameterEnd node);
  R visitIdentifierHandle(IdentifierHandle node);
  R visitIndexedExpressionHandle(IndexedExpressionHandle node);
  R visitIsOperatorTypeBegin(IsOperatorTypeBegin node);
  R visitIsOperatorTypeEnd(IsOperatorTypeEnd node);
  R visitIsOperatorHandle(IsOperatorHandle node);
  R visitLiteralBoolHandle(LiteralBoolHandle node);
  R visitBreakStatementHandle(BreakStatementHandle node);
  R visitContinueStatementHandle(ContinueStatementHandle node);
  R visitEmptyStatementHandle(EmptyStatementHandle node);
  R visitAssertBegin(AssertBegin node);
  R visitAssertEnd(AssertEnd node);
  R visitLiteralDoubleHandle(LiteralDoubleHandle node);
  R visitLiteralDoubleWithSeparatorsHandle(
    LiteralDoubleWithSeparatorsHandle node,
  );
  R visitLiteralIntHandle(LiteralIntHandle node);
  R visitLiteralIntWithSeparatorsHandle(LiteralIntWithSeparatorsHandle node);
  R visitLiteralListHandle(LiteralListHandle node);
  R visitListPatternHandle(ListPatternHandle node);
  R visitLiteralSetOrMapHandle(LiteralSetOrMapHandle node);
  R visitMapPatternHandle(MapPatternHandle node);
  R visitLiteralNullHandle(LiteralNullHandle node);
  R visitNativeClauseHandle(NativeClauseHandle node);
  R visitNamedArgumentHandle(NamedArgumentHandle node);
  R visitPatternFieldHandle(PatternFieldHandle node);
  R visitNamedRecordFieldHandle(NamedRecordFieldHandle node);
  R visitNewExpressionBegin(NewExpressionBegin node);
  R visitNewExpressionEnd(NewExpressionEnd node);
  R visitNoArgumentsHandle(NoArgumentsHandle node);
  R visitNoConstructorReferenceContinuationAfterTypeArgumentsHandle(
    NoConstructorReferenceContinuationAfterTypeArgumentsHandle node,
  );
  R visitNoTypeNameInConstructorReferenceHandle(
    NoTypeNameInConstructorReferenceHandle node,
  );
  R visitNoTypeHandle(NoTypeHandle node);
  R visitNoTypeVariablesHandle(NoTypeVariablesHandle node);
  R visitOperatorHandle(OperatorHandle node);
  R visitSwitchCaseNoWhenClauseHandle(SwitchCaseNoWhenClauseHandle node);
  R visitSwitchExpressionCasePatternHandle(
    SwitchExpressionCasePatternHandle node,
  );
  R visitSymbolVoidHandle(SymbolVoidHandle node);
  R visitOperatorNameHandle(OperatorNameHandle node);
  R visitInvalidOperatorNameHandle(InvalidOperatorNameHandle node);
  R visitParenthesizedConditionHandle(ParenthesizedConditionHandle node);
  R visitPatternBegin(PatternBegin node);
  R visitPatternGuardBegin(PatternGuardBegin node);
  R visitParenthesizedExpressionOrRecordLiteralBegin(
    ParenthesizedExpressionOrRecordLiteralBegin node,
  );
  R visitSwitchCaseWhenClauseBegin(SwitchCaseWhenClauseBegin node);
  R visitRecordLiteralEnd(RecordLiteralEnd node);
  R visitRecordPatternHandle(RecordPatternHandle node);
  R visitPatternEnd(PatternEnd node);
  R visitPatternGuardEnd(PatternGuardEnd node);
  R visitParenthesizedExpressionEnd(ParenthesizedExpressionEnd node);
  R visitSwitchCaseWhenClauseEnd(SwitchCaseWhenClauseEnd node);
  R visitParenthesizedPatternHandle(ParenthesizedPatternHandle node);
  R visitConstantPatternBegin(ConstantPatternBegin node);
  R visitConstantPatternEnd(ConstantPatternEnd node);
  R visitObjectPatternHandle(ObjectPatternHandle node);
  R visitQualifiedHandle(QualifiedHandle node);
  R visitStringPartHandle(StringPartHandle node);
  R visitSuperExpressionHandle(SuperExpressionHandle node);
  R visitAugmentSuperExpressionHandle(AugmentSuperExpressionHandle node);
  R visitSwitchCaseBegin(SwitchCaseBegin node);
  R visitSwitchCaseEnd(SwitchCaseEnd node);
  R visitSwitchExpressionCaseBegin(SwitchExpressionCaseBegin node);
  R visitSwitchExpressionCaseEnd(SwitchExpressionCaseEnd node);
  R visitThisExpressionHandle(ThisExpressionHandle node);
  R visitUnaryPostfixAssignmentExpressionHandle(
    UnaryPostfixAssignmentExpressionHandle node,
  );
  R visitUnaryPrefixExpressionHandle(UnaryPrefixExpressionHandle node);
  R visitRelationalPatternHandle(RelationalPatternHandle node);
  R visitUnaryPrefixAssignmentExpressionHandle(
    UnaryPrefixAssignmentExpressionHandle node,
  );
  R visitFormalParameterDefaultValueExpressionBegin(
    FormalParameterDefaultValueExpressionBegin node,
  );
  R visitFormalParameterDefaultValueExpressionEnd(
    FormalParameterDefaultValueExpressionEnd node,
  );
  R visitValuedFormalParameterHandle(ValuedFormalParameterHandle node);
  R visitFormalParameterWithoutValueHandle(
    FormalParameterWithoutValueHandle node,
  );
  R visitVoidKeywordHandle(VoidKeywordHandle node);
  R visitVoidKeywordWithTypeArgumentsHandle(
    VoidKeywordWithTypeArgumentsHandle node,
  );
  R visitYieldStatementBegin(YieldStatementBegin node);
  R visitYieldStatementEnd(YieldStatementEnd node);
  R visitInvalidYieldStatementEnd(InvalidYieldStatementEnd node);
  R visitRecoverableErrorHandle(RecoverableErrorHandle node);
  R visitExperimentNotEnabledHandle(ExperimentNotEnabledHandle node);
  R visitErrorTokenHandle(ErrorTokenHandle node);
  R visitUnescapeErrorHandle(UnescapeErrorHandle node);
  R visitInvalidStatementHandle(InvalidStatementHandle node);
  R visitScriptHandle(ScriptHandle node);
  R visitTypeArgumentApplicationHandle(TypeArgumentApplicationHandle node);
  R visitNewAsIdentifierHandle(NewAsIdentifierHandle node);
  R visitPatternVariableDeclarationStatementHandle(
    PatternVariableDeclarationStatementHandle node,
  );
  R visitPatternAssignmentHandle(PatternAssignmentHandle node);
  R visitDotShorthandContextHandle(DotShorthandContextHandle node);
  R visitDotShorthandHeadHandle(DotShorthandHeadHandle node);
  R visitConstDotShorthandBegin(ConstDotShorthandBegin node);
  R visitConstDotShorthandEnd(ConstDotShorthandEnd node);
}

class RecursiveParserAstVisitor implements ParserAstVisitor<void> {
  @override
  void visitArgumentsBegin(ArgumentsBegin node) => node.visitChildren(this);

  @override
  void visitArgumentsEnd(ArgumentsEnd node) => node.visitChildren(this);

  @override
  void visitObjectPatternFieldsHandle(ObjectPatternFieldsHandle node) =>
      node.visitChildren(this);

  @override
  void visitAsyncModifierHandle(AsyncModifierHandle node) =>
      node.visitChildren(this);

  @override
  void visitAwaitExpressionBegin(AwaitExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitAwaitExpressionEnd(AwaitExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitInvalidAwaitExpressionEnd(InvalidAwaitExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitBlockBegin(BlockBegin node) => node.visitChildren(this);

  @override
  void visitBlockEnd(BlockEnd node) => node.visitChildren(this);

  @override
  void visitInvalidTopLevelBlockHandle(InvalidTopLevelBlockHandle node) =>
      node.visitChildren(this);

  @override
  void visitCascadeBegin(CascadeBegin node) => node.visitChildren(this);

  @override
  void visitCascadeEnd(CascadeEnd node) => node.visitChildren(this);

  @override
  void visitCaseExpressionBegin(CaseExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitCaseExpressionEnd(CaseExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitClassOrMixinOrExtensionBodyBegin(
    ClassOrMixinOrExtensionBodyBegin node,
  ) => node.visitChildren(this);

  @override
  void visitClassOrMixinOrExtensionBodyEnd(
    ClassOrMixinOrExtensionBodyEnd node,
  ) => node.visitChildren(this);

  @override
  void visitClassOrMixinOrNamedMixinApplicationPreludeBegin(
    ClassOrMixinOrNamedMixinApplicationPreludeBegin node,
  ) => node.visitChildren(this);

  @override
  void visitClassDeclarationBegin(ClassDeclarationBegin node) =>
      node.visitChildren(this);

  @override
  void visitClassExtendsHandle(ClassExtendsHandle node) =>
      node.visitChildren(this);

  @override
  void visitImplementsHandle(ImplementsHandle node) => node.visitChildren(this);

  @override
  void visitClassHeaderHandle(ClassHeaderHandle node) =>
      node.visitChildren(this);

  @override
  void visitRecoverDeclarationHeaderHandle(
    RecoverDeclarationHeaderHandle node,
  ) => node.visitChildren(this);

  @override
  void visitClassDeclarationEnd(ClassDeclarationEnd node) =>
      node.visitChildren(this);

  @override
  void visitMixinDeclarationBegin(MixinDeclarationBegin node) =>
      node.visitChildren(this);

  @override
  void visitMixinOnHandle(MixinOnHandle node) => node.visitChildren(this);

  @override
  void visitMixinHeaderHandle(MixinHeaderHandle node) =>
      node.visitChildren(this);

  @override
  void visitRecoverMixinHeaderHandle(RecoverMixinHeaderHandle node) =>
      node.visitChildren(this);

  @override
  void visitMixinDeclarationEnd(MixinDeclarationEnd node) =>
      node.visitChildren(this);

  @override
  void visitUncategorizedTopLevelDeclarationBegin(
    UncategorizedTopLevelDeclarationBegin node,
  ) => node.visitChildren(this);

  @override
  void visitExtensionDeclarationPreludeBegin(
    ExtensionDeclarationPreludeBegin node,
  ) => node.visitChildren(this);

  @override
  void visitExtensionDeclarationBegin(ExtensionDeclarationBegin node) =>
      node.visitChildren(this);

  @override
  void visitExtensionDeclarationEnd(ExtensionDeclarationEnd node) =>
      node.visitChildren(this);

  @override
  void visitExtensionTypeDeclarationBegin(ExtensionTypeDeclarationBegin node) =>
      node.visitChildren(this);

  @override
  void visitExtensionTypeDeclarationEnd(ExtensionTypeDeclarationEnd node) =>
      node.visitChildren(this);

  @override
  void visitPrimaryConstructorBegin(PrimaryConstructorBegin node) =>
      node.visitChildren(this);

  @override
  void visitPrimaryConstructorEnd(PrimaryConstructorEnd node) =>
      node.visitChildren(this);

  @override
  void visitNoPrimaryConstructorHandle(NoPrimaryConstructorHandle node) =>
      node.visitChildren(this);

  @override
  void visitCombinatorsBegin(CombinatorsBegin node) => node.visitChildren(this);

  @override
  void visitCombinatorsEnd(CombinatorsEnd node) => node.visitChildren(this);

  @override
  void visitCompilationUnitBegin(CompilationUnitBegin node) =>
      node.visitChildren(this);

  @override
  void visitDirectivesOnlyHandle(DirectivesOnlyHandle node) =>
      node.visitChildren(this);

  @override
  void visitCompilationUnitEnd(CompilationUnitEnd node) =>
      node.visitChildren(this);

  @override
  void visitConstLiteralBegin(ConstLiteralBegin node) =>
      node.visitChildren(this);

  @override
  void visitConstLiteralEnd(ConstLiteralEnd node) => node.visitChildren(this);

  @override
  void visitConstructorReferenceBegin(ConstructorReferenceBegin node) =>
      node.visitChildren(this);

  @override
  void visitConstructorReferenceEnd(ConstructorReferenceEnd node) =>
      node.visitChildren(this);

  @override
  void visitDoWhileStatementBegin(DoWhileStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitDoWhileStatementEnd(DoWhileStatementEnd node) =>
      node.visitChildren(this);

  @override
  void visitDoWhileStatementBodyBegin(DoWhileStatementBodyBegin node) =>
      node.visitChildren(this);

  @override
  void visitDoWhileStatementBodyEnd(DoWhileStatementBodyEnd node) =>
      node.visitChildren(this);

  @override
  void visitWhileStatementBodyBegin(WhileStatementBodyBegin node) =>
      node.visitChildren(this);

  @override
  void visitWhileStatementBodyEnd(WhileStatementBodyEnd node) =>
      node.visitChildren(this);

  @override
  void visitEnumBegin(EnumBegin node) => node.visitChildren(this);

  @override
  void visitEnumEnd(EnumEnd node) => node.visitChildren(this);

  @override
  void visitEnumConstructorEnd(EnumConstructorEnd node) =>
      node.visitChildren(this);

  @override
  void visitEnumElementsHandle(EnumElementsHandle node) =>
      node.visitChildren(this);

  @override
  void visitEnumHeaderHandle(EnumHeaderHandle node) => node.visitChildren(this);

  @override
  void visitEnumElementHandle(EnumElementHandle node) =>
      node.visitChildren(this);

  @override
  void visitEnumFactoryMethodEnd(EnumFactoryMethodEnd node) =>
      node.visitChildren(this);

  @override
  void visitExportBegin(ExportBegin node) => node.visitChildren(this);

  @override
  void visitExportEnd(ExportEnd node) => node.visitChildren(this);

  @override
  void visitExtraneousExpressionHandle(ExtraneousExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitExpressionStatementHandle(ExpressionStatementHandle node) =>
      node.visitChildren(this);

  @override
  void visitFactoryMethodBegin(FactoryMethodBegin node) =>
      node.visitChildren(this);

  @override
  void visitClassFactoryMethodEnd(ClassFactoryMethodEnd node) =>
      node.visitChildren(this);

  @override
  void visitMixinFactoryMethodEnd(MixinFactoryMethodEnd node) =>
      node.visitChildren(this);

  @override
  void visitExtensionFactoryMethodEnd(ExtensionFactoryMethodEnd node) =>
      node.visitChildren(this);

  @override
  void visitExtensionTypeFactoryMethodEnd(ExtensionTypeFactoryMethodEnd node) =>
      node.visitChildren(this);

  @override
  void visitFormalParameterBegin(FormalParameterBegin node) =>
      node.visitChildren(this);

  @override
  void visitFormalParameterEnd(FormalParameterEnd node) =>
      node.visitChildren(this);

  @override
  void visitNoFormalParametersHandle(NoFormalParametersHandle node) =>
      node.visitChildren(this);

  @override
  void visitFormalParametersBegin(FormalParametersBegin node) =>
      node.visitChildren(this);

  @override
  void visitFormalParametersEnd(FormalParametersEnd node) =>
      node.visitChildren(this);

  @override
  void visitClassFieldsEnd(ClassFieldsEnd node) => node.visitChildren(this);

  @override
  void visitMixinFieldsEnd(MixinFieldsEnd node) => node.visitChildren(this);

  @override
  void visitExtensionFieldsEnd(ExtensionFieldsEnd node) =>
      node.visitChildren(this);

  @override
  void visitExtensionTypeFieldsEnd(ExtensionTypeFieldsEnd node) =>
      node.visitChildren(this);

  @override
  void visitEnumFieldsEnd(EnumFieldsEnd node) => node.visitChildren(this);

  @override
  void visitEnumMethodEnd(EnumMethodEnd node) => node.visitChildren(this);

  @override
  void visitForInitializerEmptyStatementHandle(
    ForInitializerEmptyStatementHandle node,
  ) => node.visitChildren(this);

  @override
  void visitForInitializerExpressionStatementHandle(
    ForInitializerExpressionStatementHandle node,
  ) => node.visitChildren(this);

  @override
  void visitForInitializerLocalVariableDeclarationHandle(
    ForInitializerLocalVariableDeclarationHandle node,
  ) => node.visitChildren(this);

  @override
  void visitForInitializerPatternVariableAssignmentHandle(
    ForInitializerPatternVariableAssignmentHandle node,
  ) => node.visitChildren(this);

  @override
  void visitForStatementBegin(ForStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitForLoopPartsHandle(ForLoopPartsHandle node) =>
      node.visitChildren(this);

  @override
  void visitForStatementEnd(ForStatementEnd node) => node.visitChildren(this);

  @override
  void visitForStatementBodyBegin(ForStatementBodyBegin node) =>
      node.visitChildren(this);

  @override
  void visitForStatementBodyEnd(ForStatementBodyEnd node) =>
      node.visitChildren(this);

  @override
  void visitForInLoopPartsHandle(ForInLoopPartsHandle node) =>
      node.visitChildren(this);

  @override
  void visitForInEnd(ForInEnd node) => node.visitChildren(this);

  @override
  void visitForInExpressionBegin(ForInExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitForInExpressionEnd(ForInExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitForInBodyBegin(ForInBodyBegin node) => node.visitChildren(this);

  @override
  void visitForInBodyEnd(ForInBodyEnd node) => node.visitChildren(this);

  @override
  void visitNamedFunctionExpressionBegin(NamedFunctionExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitNamedFunctionExpressionEnd(NamedFunctionExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitLocalFunctionDeclarationBegin(LocalFunctionDeclarationBegin node) =>
      node.visitChildren(this);

  @override
  void visitLocalFunctionDeclarationEnd(LocalFunctionDeclarationEnd node) =>
      node.visitChildren(this);

  @override
  void visitBlockFunctionBodyBegin(BlockFunctionBodyBegin node) =>
      node.visitChildren(this);

  @override
  void visitBlockFunctionBodyEnd(BlockFunctionBodyEnd node) =>
      node.visitChildren(this);

  @override
  void visitNoFunctionBodyHandle(NoFunctionBodyHandle node) =>
      node.visitChildren(this);

  @override
  void visitFunctionBodySkippedHandle(FunctionBodySkippedHandle node) =>
      node.visitChildren(this);

  @override
  void visitFunctionNameBegin(FunctionNameBegin node) =>
      node.visitChildren(this);

  @override
  void visitFunctionNameEnd(FunctionNameEnd node) => node.visitChildren(this);

  @override
  void visitTypedefBegin(TypedefBegin node) => node.visitChildren(this);

  @override
  void visitTypedefEnd(TypedefEnd node) => node.visitChildren(this);

  @override
  void visitClassWithClauseHandle(ClassWithClauseHandle node) =>
      node.visitChildren(this);

  @override
  void visitClassNoWithClauseHandle(ClassNoWithClauseHandle node) =>
      node.visitChildren(this);

  @override
  void visitEnumWithClauseHandle(EnumWithClauseHandle node) =>
      node.visitChildren(this);

  @override
  void visitEnumNoWithClauseHandle(EnumNoWithClauseHandle node) =>
      node.visitChildren(this);

  @override
  void visitMixinWithClauseHandle(MixinWithClauseHandle node) =>
      node.visitChildren(this);

  @override
  void visitNamedMixinApplicationBegin(NamedMixinApplicationBegin node) =>
      node.visitChildren(this);

  @override
  void visitNamedMixinApplicationWithClauseHandle(
    NamedMixinApplicationWithClauseHandle node,
  ) => node.visitChildren(this);

  @override
  void visitNamedMixinApplicationEnd(NamedMixinApplicationEnd node) =>
      node.visitChildren(this);

  @override
  void visitHideBegin(HideBegin node) => node.visitChildren(this);

  @override
  void visitHideEnd(HideEnd node) => node.visitChildren(this);

  @override
  void visitIdentifierListHandle(IdentifierListHandle node) =>
      node.visitChildren(this);

  @override
  void visitTypeListBegin(TypeListBegin node) => node.visitChildren(this);

  @override
  void visitTypeListEnd(TypeListEnd node) => node.visitChildren(this);

  @override
  void visitIfStatementBegin(IfStatementBegin node) => node.visitChildren(this);

  @override
  void visitIfStatementEnd(IfStatementEnd node) => node.visitChildren(this);

  @override
  void visitThenStatementBegin(ThenStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitThenStatementEnd(ThenStatementEnd node) => node.visitChildren(this);

  @override
  void visitElseStatementBegin(ElseStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitElseStatementEnd(ElseStatementEnd node) => node.visitChildren(this);

  @override
  void visitImportBegin(ImportBegin node) => node.visitChildren(this);

  @override
  void visitImportPrefixHandle(ImportPrefixHandle node) =>
      node.visitChildren(this);

  @override
  void visitImportEnd(ImportEnd node) => node.visitChildren(this);

  @override
  void visitRecoverImportHandle(RecoverImportHandle node) =>
      node.visitChildren(this);

  @override
  void visitConditionalUrisBegin(ConditionalUrisBegin node) =>
      node.visitChildren(this);

  @override
  void visitConditionalUrisEnd(ConditionalUrisEnd node) =>
      node.visitChildren(this);

  @override
  void visitConditionalUriBegin(ConditionalUriBegin node) =>
      node.visitChildren(this);

  @override
  void visitConditionalUriEnd(ConditionalUriEnd node) =>
      node.visitChildren(this);

  @override
  void visitDottedNameHandle(DottedNameHandle node) => node.visitChildren(this);

  @override
  void visitImplicitCreationExpressionBegin(
    ImplicitCreationExpressionBegin node,
  ) => node.visitChildren(this);

  @override
  void visitImplicitCreationExpressionEnd(ImplicitCreationExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitInitializedIdentifierBegin(InitializedIdentifierBegin node) =>
      node.visitChildren(this);

  @override
  void visitInitializedIdentifierEnd(InitializedIdentifierEnd node) =>
      node.visitChildren(this);

  @override
  void visitFieldInitializerBegin(FieldInitializerBegin node) =>
      node.visitChildren(this);

  @override
  void visitFieldInitializerEnd(FieldInitializerEnd node) =>
      node.visitChildren(this);

  @override
  void visitNoFieldInitializerHandle(NoFieldInitializerHandle node) =>
      node.visitChildren(this);

  @override
  void visitVariableInitializerBegin(VariableInitializerBegin node) =>
      node.visitChildren(this);

  @override
  void visitVariableInitializerEnd(VariableInitializerEnd node) =>
      node.visitChildren(this);

  @override
  void visitNoVariableInitializerHandle(NoVariableInitializerHandle node) =>
      node.visitChildren(this);

  @override
  void visitInitializerBegin(InitializerBegin node) => node.visitChildren(this);

  @override
  void visitInitializerEnd(InitializerEnd node) => node.visitChildren(this);

  @override
  void visitInitializersBegin(InitializersBegin node) =>
      node.visitChildren(this);

  @override
  void visitInitializersEnd(InitializersEnd node) => node.visitChildren(this);

  @override
  void visitNoInitializersHandle(NoInitializersHandle node) =>
      node.visitChildren(this);

  @override
  void visitInvalidExpressionHandle(InvalidExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitInvalidFunctionBodyHandle(InvalidFunctionBodyHandle node) =>
      node.visitChildren(this);

  @override
  void visitInvalidTypeReferenceHandle(InvalidTypeReferenceHandle node) =>
      node.visitChildren(this);

  @override
  void visitLabelHandle(LabelHandle node) => node.visitChildren(this);

  @override
  void visitLabeledStatementBegin(LabeledStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitLabeledStatementEnd(LabeledStatementEnd node) =>
      node.visitChildren(this);

  @override
  void visitLibraryAugmentationBegin(LibraryAugmentationBegin node) =>
      node.visitChildren(this);

  @override
  void visitLibraryAugmentationEnd(LibraryAugmentationEnd node) =>
      node.visitChildren(this);

  @override
  void visitLibraryNameBegin(LibraryNameBegin node) => node.visitChildren(this);

  @override
  void visitLibraryNameEnd(LibraryNameEnd node) => node.visitChildren(this);

  @override
  void visitLiteralMapEntryHandle(LiteralMapEntryHandle node) =>
      node.visitChildren(this);

  @override
  void visitMapPatternEntryHandle(MapPatternEntryHandle node) =>
      node.visitChildren(this);

  @override
  void visitLiteralStringBegin(LiteralStringBegin node) =>
      node.visitChildren(this);

  @override
  void visitInterpolationExpressionHandle(InterpolationExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitLiteralStringEnd(LiteralStringEnd node) => node.visitChildren(this);

  @override
  void visitAdjacentStringLiteralsHandle(AdjacentStringLiteralsHandle node) =>
      node.visitChildren(this);

  @override
  void visitMemberBegin(MemberBegin node) => node.visitChildren(this);

  @override
  void visitInvalidMemberHandle(InvalidMemberHandle node) =>
      node.visitChildren(this);

  @override
  void visitMemberEnd(MemberEnd node) => node.visitChildren(this);

  @override
  void visitMethodBegin(MethodBegin node) => node.visitChildren(this);

  @override
  void visitClassMethodEnd(ClassMethodEnd node) => node.visitChildren(this);

  @override
  void visitMixinMethodEnd(MixinMethodEnd node) => node.visitChildren(this);

  @override
  void visitExtensionMethodEnd(ExtensionMethodEnd node) =>
      node.visitChildren(this);

  @override
  void visitExtensionTypeMethodEnd(ExtensionTypeMethodEnd node) =>
      node.visitChildren(this);

  @override
  void visitClassConstructorEnd(ClassConstructorEnd node) =>
      node.visitChildren(this);

  @override
  void visitMixinConstructorEnd(MixinConstructorEnd node) =>
      node.visitChildren(this);

  @override
  void visitExtensionConstructorEnd(ExtensionConstructorEnd node) =>
      node.visitChildren(this);

  @override
  void visitExtensionTypeConstructorEnd(ExtensionTypeConstructorEnd node) =>
      node.visitChildren(this);

  @override
  void visitMetadataStarBegin(MetadataStarBegin node) =>
      node.visitChildren(this);

  @override
  void visitMetadataStarEnd(MetadataStarEnd node) => node.visitChildren(this);

  @override
  void visitMetadataBegin(MetadataBegin node) => node.visitChildren(this);

  @override
  void visitMetadataEnd(MetadataEnd node) => node.visitChildren(this);

  @override
  void visitOptionalFormalParametersBegin(OptionalFormalParametersBegin node) =>
      node.visitChildren(this);

  @override
  void visitOptionalFormalParametersEnd(OptionalFormalParametersEnd node) =>
      node.visitChildren(this);

  @override
  void visitPartBegin(PartBegin node) => node.visitChildren(this);

  @override
  void visitPartEnd(PartEnd node) => node.visitChildren(this);

  @override
  void visitPartOfBegin(PartOfBegin node) => node.visitChildren(this);

  @override
  void visitPartOfEnd(PartOfEnd node) => node.visitChildren(this);

  @override
  void visitRedirectingFactoryBodyBegin(RedirectingFactoryBodyBegin node) =>
      node.visitChildren(this);

  @override
  void visitRedirectingFactoryBodyEnd(RedirectingFactoryBodyEnd node) =>
      node.visitChildren(this);

  @override
  void visitReturnStatementBegin(ReturnStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitNativeFunctionBodyHandle(NativeFunctionBodyHandle node) =>
      node.visitChildren(this);

  @override
  void visitNativeFunctionBodyIgnoredHandle(
    NativeFunctionBodyIgnoredHandle node,
  ) => node.visitChildren(this);

  @override
  void visitNativeFunctionBodySkippedHandle(
    NativeFunctionBodySkippedHandle node,
  ) => node.visitChildren(this);

  @override
  void visitEmptyFunctionBodyHandle(EmptyFunctionBodyHandle node) =>
      node.visitChildren(this);

  @override
  void visitExpressionFunctionBodyHandle(ExpressionFunctionBodyHandle node) =>
      node.visitChildren(this);

  @override
  void visitReturnStatementEnd(ReturnStatementEnd node) =>
      node.visitChildren(this);

  @override
  void visitSendHandle(SendHandle node) => node.visitChildren(this);

  @override
  void visitShowBegin(ShowBegin node) => node.visitChildren(this);

  @override
  void visitShowEnd(ShowEnd node) => node.visitChildren(this);

  @override
  void visitSwitchStatementBegin(SwitchStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitSwitchStatementEnd(SwitchStatementEnd node) =>
      node.visitChildren(this);

  @override
  void visitSwitchExpressionBegin(SwitchExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitSwitchExpressionEnd(SwitchExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitSwitchBlockBegin(SwitchBlockBegin node) => node.visitChildren(this);

  @override
  void visitSwitchBlockEnd(SwitchBlockEnd node) => node.visitChildren(this);

  @override
  void visitSwitchExpressionBlockBegin(SwitchExpressionBlockBegin node) =>
      node.visitChildren(this);

  @override
  void visitSwitchExpressionBlockEnd(SwitchExpressionBlockEnd node) =>
      node.visitChildren(this);

  @override
  void visitLiteralSymbolBegin(LiteralSymbolBegin node) =>
      node.visitChildren(this);

  @override
  void visitLiteralSymbolEnd(LiteralSymbolEnd node) => node.visitChildren(this);

  @override
  void visitThrowExpressionHandle(ThrowExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitRethrowStatementBegin(RethrowStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitRethrowStatementEnd(RethrowStatementEnd node) =>
      node.visitChildren(this);

  @override
  void visitTopLevelDeclarationEnd(TopLevelDeclarationEnd node) =>
      node.visitChildren(this);

  @override
  void visitInvalidTopLevelDeclarationHandle(
    InvalidTopLevelDeclarationHandle node,
  ) => node.visitChildren(this);

  @override
  void visitTopLevelMemberBegin(TopLevelMemberBegin node) =>
      node.visitChildren(this);

  @override
  void visitFieldsBegin(FieldsBegin node) => node.visitChildren(this);

  @override
  void visitTopLevelFieldsEnd(TopLevelFieldsEnd node) =>
      node.visitChildren(this);

  @override
  void visitTopLevelMethodBegin(TopLevelMethodBegin node) =>
      node.visitChildren(this);

  @override
  void visitTopLevelMethodEnd(TopLevelMethodEnd node) =>
      node.visitChildren(this);

  @override
  void visitTryStatementBegin(TryStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitCatchClauseBegin(CatchClauseBegin node) => node.visitChildren(this);

  @override
  void visitCatchClauseEnd(CatchClauseEnd node) => node.visitChildren(this);

  @override
  void visitCatchBlockHandle(CatchBlockHandle node) => node.visitChildren(this);

  @override
  void visitFinallyBlockHandle(FinallyBlockHandle node) =>
      node.visitChildren(this);

  @override
  void visitTryStatementEnd(TryStatementEnd node) => node.visitChildren(this);

  @override
  void visitTypeHandle(TypeHandle node) => node.visitChildren(this);

  @override
  void visitNonNullAssertExpressionHandle(NonNullAssertExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitNullAssertPatternHandle(NullAssertPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitNullCheckPatternHandle(NullCheckPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitAssignedVariablePatternHandle(AssignedVariablePatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitDeclaredVariablePatternHandle(DeclaredVariablePatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitWildcardPatternHandle(WildcardPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitNoNameHandle(NoNameHandle node) => node.visitChildren(this);

  @override
  void visitRecordTypeBegin(RecordTypeBegin node) => node.visitChildren(this);

  @override
  void visitRecordTypeEnd(RecordTypeEnd node) => node.visitChildren(this);

  @override
  void visitRecordTypeEntryBegin(RecordTypeEntryBegin node) =>
      node.visitChildren(this);

  @override
  void visitRecordTypeEntryEnd(RecordTypeEntryEnd node) =>
      node.visitChildren(this);

  @override
  void visitRecordTypeNamedFieldsBegin(RecordTypeNamedFieldsBegin node) =>
      node.visitChildren(this);

  @override
  void visitRecordTypeNamedFieldsEnd(RecordTypeNamedFieldsEnd node) =>
      node.visitChildren(this);

  @override
  void visitFunctionTypeBegin(FunctionTypeBegin node) =>
      node.visitChildren(this);

  @override
  void visitFunctionTypeEnd(FunctionTypeEnd node) => node.visitChildren(this);

  @override
  void visitTypeArgumentsBegin(TypeArgumentsBegin node) =>
      node.visitChildren(this);

  @override
  void visitTypeArgumentsEnd(TypeArgumentsEnd node) => node.visitChildren(this);

  @override
  void visitInvalidTypeArgumentsHandle(InvalidTypeArgumentsHandle node) =>
      node.visitChildren(this);

  @override
  void visitNoTypeArgumentsHandle(NoTypeArgumentsHandle node) =>
      node.visitChildren(this);

  @override
  void visitTypeVariableBegin(TypeVariableBegin node) =>
      node.visitChildren(this);

  @override
  void visitTypeVariablesDefinedHandle(TypeVariablesDefinedHandle node) =>
      node.visitChildren(this);

  @override
  void visitTypeVariableEnd(TypeVariableEnd node) => node.visitChildren(this);

  @override
  void visitTypeVariablesBegin(TypeVariablesBegin node) =>
      node.visitChildren(this);

  @override
  void visitTypeVariablesEnd(TypeVariablesEnd node) => node.visitChildren(this);

  @override
  void visitFunctionExpressionBegin(FunctionExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitFunctionExpressionEnd(FunctionExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitVariablesDeclarationBegin(VariablesDeclarationBegin node) =>
      node.visitChildren(this);

  @override
  void visitVariablesDeclarationEnd(VariablesDeclarationEnd node) =>
      node.visitChildren(this);

  @override
  void visitWhileStatementBegin(WhileStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitWhileStatementEnd(WhileStatementEnd node) =>
      node.visitChildren(this);

  @override
  void visitAsOperatorTypeBegin(AsOperatorTypeBegin node) =>
      node.visitChildren(this);

  @override
  void visitAsOperatorTypeEnd(AsOperatorTypeEnd node) =>
      node.visitChildren(this);

  @override
  void visitAsOperatorHandle(AsOperatorHandle node) => node.visitChildren(this);

  @override
  void visitCastPatternHandle(CastPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitAssignmentExpressionHandle(AssignmentExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitBinaryExpressionBegin(BinaryExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitBinaryExpressionEnd(BinaryExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitBinaryPatternBegin(BinaryPatternBegin node) =>
      node.visitChildren(this);

  @override
  void visitBinaryPatternEnd(BinaryPatternEnd node) => node.visitChildren(this);

  @override
  void visitDotAccessHandle(DotAccessHandle node) => node.visitChildren(this);

  @override
  void visitCascadeAccessHandle(CascadeAccessHandle node) =>
      node.visitChildren(this);

  @override
  void visitConditionalExpressionBegin(ConditionalExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitConditionalExpressionColonHandle(
    ConditionalExpressionColonHandle node,
  ) => node.visitChildren(this);

  @override
  void visitConditionalExpressionEnd(ConditionalExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitConstExpressionBegin(ConstExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitConstExpressionEnd(ConstExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitConstFactoryHandle(ConstFactoryHandle node) =>
      node.visitChildren(this);

  @override
  void visitForControlFlowBegin(ForControlFlowBegin node) =>
      node.visitChildren(this);

  @override
  void visitForControlFlowEnd(ForControlFlowEnd node) =>
      node.visitChildren(this);

  @override
  void visitForInControlFlowEnd(ForInControlFlowEnd node) =>
      node.visitChildren(this);

  @override
  void visitIfControlFlowBegin(IfControlFlowBegin node) =>
      node.visitChildren(this);

  @override
  void visitThenControlFlowHandle(ThenControlFlowHandle node) =>
      node.visitChildren(this);

  @override
  void visitElseControlFlowHandle(ElseControlFlowHandle node) =>
      node.visitChildren(this);

  @override
  void visitIfControlFlowEnd(IfControlFlowEnd node) => node.visitChildren(this);

  @override
  void visitIfElseControlFlowEnd(IfElseControlFlowEnd node) =>
      node.visitChildren(this);

  @override
  void visitSpreadExpressionHandle(SpreadExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitNullAwareElementHandle(NullAwareElementHandle node) =>
      node.visitChildren(this);

  @override
  void visitRestPatternHandle(RestPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitFunctionTypedFormalParameterBegin(
    FunctionTypedFormalParameterBegin node,
  ) => node.visitChildren(this);

  @override
  void visitFunctionTypedFormalParameterEnd(
    FunctionTypedFormalParameterEnd node,
  ) => node.visitChildren(this);

  @override
  void visitIdentifierHandle(IdentifierHandle node) => node.visitChildren(this);

  @override
  void visitIndexedExpressionHandle(IndexedExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitIsOperatorTypeBegin(IsOperatorTypeBegin node) =>
      node.visitChildren(this);

  @override
  void visitIsOperatorTypeEnd(IsOperatorTypeEnd node) =>
      node.visitChildren(this);

  @override
  void visitIsOperatorHandle(IsOperatorHandle node) => node.visitChildren(this);

  @override
  void visitLiteralBoolHandle(LiteralBoolHandle node) =>
      node.visitChildren(this);

  @override
  void visitBreakStatementHandle(BreakStatementHandle node) =>
      node.visitChildren(this);

  @override
  void visitContinueStatementHandle(ContinueStatementHandle node) =>
      node.visitChildren(this);

  @override
  void visitEmptyStatementHandle(EmptyStatementHandle node) =>
      node.visitChildren(this);

  @override
  void visitAssertBegin(AssertBegin node) => node.visitChildren(this);

  @override
  void visitAssertEnd(AssertEnd node) => node.visitChildren(this);

  @override
  void visitLiteralDoubleHandle(LiteralDoubleHandle node) =>
      node.visitChildren(this);

  @override
  void visitLiteralDoubleWithSeparatorsHandle(
    LiteralDoubleWithSeparatorsHandle node,
  ) => node.visitChildren(this);

  @override
  void visitLiteralIntHandle(LiteralIntHandle node) => node.visitChildren(this);

  @override
  void visitLiteralIntWithSeparatorsHandle(
    LiteralIntWithSeparatorsHandle node,
  ) => node.visitChildren(this);

  @override
  void visitLiteralListHandle(LiteralListHandle node) =>
      node.visitChildren(this);

  @override
  void visitListPatternHandle(ListPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitLiteralSetOrMapHandle(LiteralSetOrMapHandle node) =>
      node.visitChildren(this);

  @override
  void visitMapPatternHandle(MapPatternHandle node) => node.visitChildren(this);

  @override
  void visitLiteralNullHandle(LiteralNullHandle node) =>
      node.visitChildren(this);

  @override
  void visitNativeClauseHandle(NativeClauseHandle node) =>
      node.visitChildren(this);

  @override
  void visitNamedArgumentHandle(NamedArgumentHandle node) =>
      node.visitChildren(this);

  @override
  void visitPatternFieldHandle(PatternFieldHandle node) =>
      node.visitChildren(this);

  @override
  void visitNamedRecordFieldHandle(NamedRecordFieldHandle node) =>
      node.visitChildren(this);

  @override
  void visitNewExpressionBegin(NewExpressionBegin node) =>
      node.visitChildren(this);

  @override
  void visitNewExpressionEnd(NewExpressionEnd node) => node.visitChildren(this);

  @override
  void visitNoArgumentsHandle(NoArgumentsHandle node) =>
      node.visitChildren(this);

  @override
  void visitNoConstructorReferenceContinuationAfterTypeArgumentsHandle(
    NoConstructorReferenceContinuationAfterTypeArgumentsHandle node,
  ) => node.visitChildren(this);

  @override
  void visitNoTypeNameInConstructorReferenceHandle(
    NoTypeNameInConstructorReferenceHandle node,
  ) => node.visitChildren(this);

  @override
  void visitNoTypeHandle(NoTypeHandle node) => node.visitChildren(this);

  @override
  void visitNoTypeVariablesHandle(NoTypeVariablesHandle node) =>
      node.visitChildren(this);

  @override
  void visitOperatorHandle(OperatorHandle node) => node.visitChildren(this);

  @override
  void visitSwitchCaseNoWhenClauseHandle(SwitchCaseNoWhenClauseHandle node) =>
      node.visitChildren(this);

  @override
  void visitSwitchExpressionCasePatternHandle(
    SwitchExpressionCasePatternHandle node,
  ) => node.visitChildren(this);

  @override
  void visitSymbolVoidHandle(SymbolVoidHandle node) => node.visitChildren(this);

  @override
  void visitOperatorNameHandle(OperatorNameHandle node) =>
      node.visitChildren(this);

  @override
  void visitInvalidOperatorNameHandle(InvalidOperatorNameHandle node) =>
      node.visitChildren(this);

  @override
  void visitParenthesizedConditionHandle(ParenthesizedConditionHandle node) =>
      node.visitChildren(this);

  @override
  void visitPatternBegin(PatternBegin node) => node.visitChildren(this);

  @override
  void visitPatternGuardBegin(PatternGuardBegin node) =>
      node.visitChildren(this);

  @override
  void visitParenthesizedExpressionOrRecordLiteralBegin(
    ParenthesizedExpressionOrRecordLiteralBegin node,
  ) => node.visitChildren(this);

  @override
  void visitSwitchCaseWhenClauseBegin(SwitchCaseWhenClauseBegin node) =>
      node.visitChildren(this);

  @override
  void visitRecordLiteralEnd(RecordLiteralEnd node) => node.visitChildren(this);

  @override
  void visitRecordPatternHandle(RecordPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitPatternEnd(PatternEnd node) => node.visitChildren(this);

  @override
  void visitPatternGuardEnd(PatternGuardEnd node) => node.visitChildren(this);

  @override
  void visitParenthesizedExpressionEnd(ParenthesizedExpressionEnd node) =>
      node.visitChildren(this);

  @override
  void visitSwitchCaseWhenClauseEnd(SwitchCaseWhenClauseEnd node) =>
      node.visitChildren(this);

  @override
  void visitParenthesizedPatternHandle(ParenthesizedPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitConstantPatternBegin(ConstantPatternBegin node) =>
      node.visitChildren(this);

  @override
  void visitConstantPatternEnd(ConstantPatternEnd node) =>
      node.visitChildren(this);

  @override
  void visitObjectPatternHandle(ObjectPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitQualifiedHandle(QualifiedHandle node) => node.visitChildren(this);

  @override
  void visitStringPartHandle(StringPartHandle node) => node.visitChildren(this);

  @override
  void visitSuperExpressionHandle(SuperExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitAugmentSuperExpressionHandle(AugmentSuperExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitSwitchCaseBegin(SwitchCaseBegin node) => node.visitChildren(this);

  @override
  void visitSwitchCaseEnd(SwitchCaseEnd node) => node.visitChildren(this);

  @override
  void visitSwitchExpressionCaseBegin(SwitchExpressionCaseBegin node) =>
      node.visitChildren(this);

  @override
  void visitSwitchExpressionCaseEnd(SwitchExpressionCaseEnd node) =>
      node.visitChildren(this);

  @override
  void visitThisExpressionHandle(ThisExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitUnaryPostfixAssignmentExpressionHandle(
    UnaryPostfixAssignmentExpressionHandle node,
  ) => node.visitChildren(this);

  @override
  void visitUnaryPrefixExpressionHandle(UnaryPrefixExpressionHandle node) =>
      node.visitChildren(this);

  @override
  void visitRelationalPatternHandle(RelationalPatternHandle node) =>
      node.visitChildren(this);

  @override
  void visitUnaryPrefixAssignmentExpressionHandle(
    UnaryPrefixAssignmentExpressionHandle node,
  ) => node.visitChildren(this);

  @override
  void visitFormalParameterDefaultValueExpressionBegin(
    FormalParameterDefaultValueExpressionBegin node,
  ) => node.visitChildren(this);

  @override
  void visitFormalParameterDefaultValueExpressionEnd(
    FormalParameterDefaultValueExpressionEnd node,
  ) => node.visitChildren(this);

  @override
  void visitValuedFormalParameterHandle(ValuedFormalParameterHandle node) =>
      node.visitChildren(this);

  @override
  void visitFormalParameterWithoutValueHandle(
    FormalParameterWithoutValueHandle node,
  ) => node.visitChildren(this);

  @override
  void visitVoidKeywordHandle(VoidKeywordHandle node) =>
      node.visitChildren(this);

  @override
  void visitVoidKeywordWithTypeArgumentsHandle(
    VoidKeywordWithTypeArgumentsHandle node,
  ) => node.visitChildren(this);

  @override
  void visitYieldStatementBegin(YieldStatementBegin node) =>
      node.visitChildren(this);

  @override
  void visitYieldStatementEnd(YieldStatementEnd node) =>
      node.visitChildren(this);

  @override
  void visitInvalidYieldStatementEnd(InvalidYieldStatementEnd node) =>
      node.visitChildren(this);

  @override
  void visitRecoverableErrorHandle(RecoverableErrorHandle node) =>
      node.visitChildren(this);

  @override
  void visitExperimentNotEnabledHandle(ExperimentNotEnabledHandle node) =>
      node.visitChildren(this);

  @override
  void visitErrorTokenHandle(ErrorTokenHandle node) => node.visitChildren(this);

  @override
  void visitUnescapeErrorHandle(UnescapeErrorHandle node) =>
      node.visitChildren(this);

  @override
  void visitInvalidStatementHandle(InvalidStatementHandle node) =>
      node.visitChildren(this);

  @override
  void visitScriptHandle(ScriptHandle node) => node.visitChildren(this);

  @override
  void visitTypeArgumentApplicationHandle(TypeArgumentApplicationHandle node) =>
      node.visitChildren(this);

  @override
  void visitNewAsIdentifierHandle(NewAsIdentifierHandle node) =>
      node.visitChildren(this);

  @override
  void visitPatternVariableDeclarationStatementHandle(
    PatternVariableDeclarationStatementHandle node,
  ) => node.visitChildren(this);

  @override
  void visitPatternAssignmentHandle(PatternAssignmentHandle node) =>
      node.visitChildren(this);

  @override
  void visitDotShorthandContextHandle(DotShorthandContextHandle node) =>
      node.visitChildren(this);

  @override
  void visitDotShorthandHeadHandle(DotShorthandHeadHandle node) =>
      node.visitChildren(this);

  @override
  void visitConstDotShorthandBegin(ConstDotShorthandBegin node) =>
      node.visitChildren(this);

  @override
  void visitConstDotShorthandEnd(ConstDotShorthandEnd node) =>
      node.visitChildren(this);
}

class RecursiveParserAstVisitorWithDefaultNodeAsync
    implements ParserAstVisitor<Future<void>> {
  Future<void> defaultNode(ParserAstNode node) async {
    List<ParserAstNode>? children = node.children;
    if (children == null) return;
    for (ParserAstNode child in children) {
      await child.accept(this);
    }
  }

  @override
  Future<void> visitArgumentsBegin(ArgumentsBegin node) => defaultNode(node);

  @override
  Future<void> visitArgumentsEnd(ArgumentsEnd node) => defaultNode(node);

  @override
  Future<void> visitObjectPatternFieldsHandle(ObjectPatternFieldsHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitAsyncModifierHandle(AsyncModifierHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitAwaitExpressionBegin(AwaitExpressionBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitAwaitExpressionEnd(AwaitExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitInvalidAwaitExpressionEnd(InvalidAwaitExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitBlockBegin(BlockBegin node) => defaultNode(node);

  @override
  Future<void> visitBlockEnd(BlockEnd node) => defaultNode(node);

  @override
  Future<void> visitInvalidTopLevelBlockHandle(
    InvalidTopLevelBlockHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitCascadeBegin(CascadeBegin node) => defaultNode(node);

  @override
  Future<void> visitCascadeEnd(CascadeEnd node) => defaultNode(node);

  @override
  Future<void> visitCaseExpressionBegin(CaseExpressionBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitCaseExpressionEnd(CaseExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitClassOrMixinOrExtensionBodyBegin(
    ClassOrMixinOrExtensionBodyBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitClassOrMixinOrExtensionBodyEnd(
    ClassOrMixinOrExtensionBodyEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitClassOrMixinOrNamedMixinApplicationPreludeBegin(
    ClassOrMixinOrNamedMixinApplicationPreludeBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitClassDeclarationBegin(ClassDeclarationBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitClassExtendsHandle(ClassExtendsHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitImplementsHandle(ImplementsHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitClassHeaderHandle(ClassHeaderHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitRecoverDeclarationHeaderHandle(
    RecoverDeclarationHeaderHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitClassDeclarationEnd(ClassDeclarationEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitMixinDeclarationBegin(MixinDeclarationBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitMixinOnHandle(MixinOnHandle node) => defaultNode(node);

  @override
  Future<void> visitMixinHeaderHandle(MixinHeaderHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitRecoverMixinHeaderHandle(RecoverMixinHeaderHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitMixinDeclarationEnd(MixinDeclarationEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitUncategorizedTopLevelDeclarationBegin(
    UncategorizedTopLevelDeclarationBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitExtensionDeclarationPreludeBegin(
    ExtensionDeclarationPreludeBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitExtensionDeclarationBegin(ExtensionDeclarationBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitExtensionDeclarationEnd(ExtensionDeclarationEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitExtensionTypeDeclarationBegin(
    ExtensionTypeDeclarationBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitExtensionTypeDeclarationEnd(
    ExtensionTypeDeclarationEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitPrimaryConstructorBegin(PrimaryConstructorBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitPrimaryConstructorEnd(PrimaryConstructorEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitNoPrimaryConstructorHandle(
    NoPrimaryConstructorHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitCombinatorsBegin(CombinatorsBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitCombinatorsEnd(CombinatorsEnd node) => defaultNode(node);

  @override
  Future<void> visitCompilationUnitBegin(CompilationUnitBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitDirectivesOnlyHandle(DirectivesOnlyHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitCompilationUnitEnd(CompilationUnitEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitConstLiteralBegin(ConstLiteralBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitConstLiteralEnd(ConstLiteralEnd node) => defaultNode(node);

  @override
  Future<void> visitConstructorReferenceBegin(ConstructorReferenceBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitConstructorReferenceEnd(ConstructorReferenceEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitDoWhileStatementBegin(DoWhileStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitDoWhileStatementEnd(DoWhileStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitDoWhileStatementBodyBegin(DoWhileStatementBodyBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitDoWhileStatementBodyEnd(DoWhileStatementBodyEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitWhileStatementBodyBegin(WhileStatementBodyBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitWhileStatementBodyEnd(WhileStatementBodyEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitEnumBegin(EnumBegin node) => defaultNode(node);

  @override
  Future<void> visitEnumEnd(EnumEnd node) => defaultNode(node);

  @override
  Future<void> visitEnumConstructorEnd(EnumConstructorEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitEnumElementsHandle(EnumElementsHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitEnumHeaderHandle(EnumHeaderHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitEnumElementHandle(EnumElementHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitEnumFactoryMethodEnd(EnumFactoryMethodEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitExportBegin(ExportBegin node) => defaultNode(node);

  @override
  Future<void> visitExportEnd(ExportEnd node) => defaultNode(node);

  @override
  Future<void> visitExtraneousExpressionHandle(
    ExtraneousExpressionHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitExpressionStatementHandle(ExpressionStatementHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitFactoryMethodBegin(FactoryMethodBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitClassFactoryMethodEnd(ClassFactoryMethodEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitMixinFactoryMethodEnd(MixinFactoryMethodEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitExtensionFactoryMethodEnd(ExtensionFactoryMethodEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitExtensionTypeFactoryMethodEnd(
    ExtensionTypeFactoryMethodEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitFormalParameterBegin(FormalParameterBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitFormalParameterEnd(FormalParameterEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitNoFormalParametersHandle(NoFormalParametersHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitFormalParametersBegin(FormalParametersBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitFormalParametersEnd(FormalParametersEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitClassFieldsEnd(ClassFieldsEnd node) => defaultNode(node);

  @override
  Future<void> visitMixinFieldsEnd(MixinFieldsEnd node) => defaultNode(node);

  @override
  Future<void> visitExtensionFieldsEnd(ExtensionFieldsEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitExtensionTypeFieldsEnd(ExtensionTypeFieldsEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitEnumFieldsEnd(EnumFieldsEnd node) => defaultNode(node);

  @override
  Future<void> visitEnumMethodEnd(EnumMethodEnd node) => defaultNode(node);

  @override
  Future<void> visitForInitializerEmptyStatementHandle(
    ForInitializerEmptyStatementHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitForInitializerExpressionStatementHandle(
    ForInitializerExpressionStatementHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitForInitializerLocalVariableDeclarationHandle(
    ForInitializerLocalVariableDeclarationHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitForInitializerPatternVariableAssignmentHandle(
    ForInitializerPatternVariableAssignmentHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitForStatementBegin(ForStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitForLoopPartsHandle(ForLoopPartsHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitForStatementEnd(ForStatementEnd node) => defaultNode(node);

  @override
  Future<void> visitForStatementBodyBegin(ForStatementBodyBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitForStatementBodyEnd(ForStatementBodyEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitForInLoopPartsHandle(ForInLoopPartsHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitForInEnd(ForInEnd node) => defaultNode(node);

  @override
  Future<void> visitForInExpressionBegin(ForInExpressionBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitForInExpressionEnd(ForInExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitForInBodyBegin(ForInBodyBegin node) => defaultNode(node);

  @override
  Future<void> visitForInBodyEnd(ForInBodyEnd node) => defaultNode(node);

  @override
  Future<void> visitNamedFunctionExpressionBegin(
    NamedFunctionExpressionBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitNamedFunctionExpressionEnd(
    NamedFunctionExpressionEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitLocalFunctionDeclarationBegin(
    LocalFunctionDeclarationBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitLocalFunctionDeclarationEnd(
    LocalFunctionDeclarationEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitBlockFunctionBodyBegin(BlockFunctionBodyBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitBlockFunctionBodyEnd(BlockFunctionBodyEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitNoFunctionBodyHandle(NoFunctionBodyHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitFunctionBodySkippedHandle(FunctionBodySkippedHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitFunctionNameBegin(FunctionNameBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitFunctionNameEnd(FunctionNameEnd node) => defaultNode(node);

  @override
  Future<void> visitTypedefBegin(TypedefBegin node) => defaultNode(node);

  @override
  Future<void> visitTypedefEnd(TypedefEnd node) => defaultNode(node);

  @override
  Future<void> visitClassWithClauseHandle(ClassWithClauseHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitClassNoWithClauseHandle(ClassNoWithClauseHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitEnumWithClauseHandle(EnumWithClauseHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitEnumNoWithClauseHandle(EnumNoWithClauseHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitMixinWithClauseHandle(MixinWithClauseHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNamedMixinApplicationBegin(
    NamedMixinApplicationBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitNamedMixinApplicationWithClauseHandle(
    NamedMixinApplicationWithClauseHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitNamedMixinApplicationEnd(NamedMixinApplicationEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitHideBegin(HideBegin node) => defaultNode(node);

  @override
  Future<void> visitHideEnd(HideEnd node) => defaultNode(node);

  @override
  Future<void> visitIdentifierListHandle(IdentifierListHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitTypeListBegin(TypeListBegin node) => defaultNode(node);

  @override
  Future<void> visitTypeListEnd(TypeListEnd node) => defaultNode(node);

  @override
  Future<void> visitIfStatementBegin(IfStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitIfStatementEnd(IfStatementEnd node) => defaultNode(node);

  @override
  Future<void> visitThenStatementBegin(ThenStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitThenStatementEnd(ThenStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitElseStatementBegin(ElseStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitElseStatementEnd(ElseStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitImportBegin(ImportBegin node) => defaultNode(node);

  @override
  Future<void> visitImportPrefixHandle(ImportPrefixHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitImportEnd(ImportEnd node) => defaultNode(node);

  @override
  Future<void> visitRecoverImportHandle(RecoverImportHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitConditionalUrisBegin(ConditionalUrisBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitConditionalUrisEnd(ConditionalUrisEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitConditionalUriBegin(ConditionalUriBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitConditionalUriEnd(ConditionalUriEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitDottedNameHandle(DottedNameHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitImplicitCreationExpressionBegin(
    ImplicitCreationExpressionBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitImplicitCreationExpressionEnd(
    ImplicitCreationExpressionEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitInitializedIdentifierBegin(
    InitializedIdentifierBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitInitializedIdentifierEnd(InitializedIdentifierEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitFieldInitializerBegin(FieldInitializerBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitFieldInitializerEnd(FieldInitializerEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitNoFieldInitializerHandle(NoFieldInitializerHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitVariableInitializerBegin(VariableInitializerBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitVariableInitializerEnd(VariableInitializerEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitNoVariableInitializerHandle(
    NoVariableInitializerHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitInitializerBegin(InitializerBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitInitializerEnd(InitializerEnd node) => defaultNode(node);

  @override
  Future<void> visitInitializersBegin(InitializersBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitInitializersEnd(InitializersEnd node) => defaultNode(node);

  @override
  Future<void> visitNoInitializersHandle(NoInitializersHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitInvalidExpressionHandle(InvalidExpressionHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitInvalidFunctionBodyHandle(InvalidFunctionBodyHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitInvalidTypeReferenceHandle(
    InvalidTypeReferenceHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitLabelHandle(LabelHandle node) => defaultNode(node);

  @override
  Future<void> visitLabeledStatementBegin(LabeledStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitLabeledStatementEnd(LabeledStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitLibraryAugmentationBegin(LibraryAugmentationBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitLibraryAugmentationEnd(LibraryAugmentationEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitLibraryNameBegin(LibraryNameBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitLibraryNameEnd(LibraryNameEnd node) => defaultNode(node);

  @override
  Future<void> visitLiteralMapEntryHandle(LiteralMapEntryHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitMapPatternEntryHandle(MapPatternEntryHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitLiteralStringBegin(LiteralStringBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitInterpolationExpressionHandle(
    InterpolationExpressionHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitLiteralStringEnd(LiteralStringEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitAdjacentStringLiteralsHandle(
    AdjacentStringLiteralsHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitMemberBegin(MemberBegin node) => defaultNode(node);

  @override
  Future<void> visitInvalidMemberHandle(InvalidMemberHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitMemberEnd(MemberEnd node) => defaultNode(node);

  @override
  Future<void> visitMethodBegin(MethodBegin node) => defaultNode(node);

  @override
  Future<void> visitClassMethodEnd(ClassMethodEnd node) => defaultNode(node);

  @override
  Future<void> visitMixinMethodEnd(MixinMethodEnd node) => defaultNode(node);

  @override
  Future<void> visitExtensionMethodEnd(ExtensionMethodEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitExtensionTypeMethodEnd(ExtensionTypeMethodEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitClassConstructorEnd(ClassConstructorEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitMixinConstructorEnd(MixinConstructorEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitExtensionConstructorEnd(ExtensionConstructorEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitExtensionTypeConstructorEnd(
    ExtensionTypeConstructorEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitMetadataStarBegin(MetadataStarBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitMetadataStarEnd(MetadataStarEnd node) => defaultNode(node);

  @override
  Future<void> visitMetadataBegin(MetadataBegin node) => defaultNode(node);

  @override
  Future<void> visitMetadataEnd(MetadataEnd node) => defaultNode(node);

  @override
  Future<void> visitOptionalFormalParametersBegin(
    OptionalFormalParametersBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitOptionalFormalParametersEnd(
    OptionalFormalParametersEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitPartBegin(PartBegin node) => defaultNode(node);

  @override
  Future<void> visitPartEnd(PartEnd node) => defaultNode(node);

  @override
  Future<void> visitPartOfBegin(PartOfBegin node) => defaultNode(node);

  @override
  Future<void> visitPartOfEnd(PartOfEnd node) => defaultNode(node);

  @override
  Future<void> visitRedirectingFactoryBodyBegin(
    RedirectingFactoryBodyBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitRedirectingFactoryBodyEnd(RedirectingFactoryBodyEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitReturnStatementBegin(ReturnStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitNativeFunctionBodyHandle(NativeFunctionBodyHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNativeFunctionBodyIgnoredHandle(
    NativeFunctionBodyIgnoredHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitNativeFunctionBodySkippedHandle(
    NativeFunctionBodySkippedHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitEmptyFunctionBodyHandle(EmptyFunctionBodyHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitExpressionFunctionBodyHandle(
    ExpressionFunctionBodyHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitReturnStatementEnd(ReturnStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitSendHandle(SendHandle node) => defaultNode(node);

  @override
  Future<void> visitShowBegin(ShowBegin node) => defaultNode(node);

  @override
  Future<void> visitShowEnd(ShowEnd node) => defaultNode(node);

  @override
  Future<void> visitSwitchStatementBegin(SwitchStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitSwitchStatementEnd(SwitchStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitSwitchExpressionBegin(SwitchExpressionBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitSwitchExpressionEnd(SwitchExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitSwitchBlockBegin(SwitchBlockBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitSwitchBlockEnd(SwitchBlockEnd node) => defaultNode(node);

  @override
  Future<void> visitSwitchExpressionBlockBegin(
    SwitchExpressionBlockBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitSwitchExpressionBlockEnd(SwitchExpressionBlockEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitLiteralSymbolBegin(LiteralSymbolBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitLiteralSymbolEnd(LiteralSymbolEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitThrowExpressionHandle(ThrowExpressionHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitRethrowStatementBegin(RethrowStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitRethrowStatementEnd(RethrowStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitTopLevelDeclarationEnd(TopLevelDeclarationEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitInvalidTopLevelDeclarationHandle(
    InvalidTopLevelDeclarationHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitTopLevelMemberBegin(TopLevelMemberBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitFieldsBegin(FieldsBegin node) => defaultNode(node);

  @override
  Future<void> visitTopLevelFieldsEnd(TopLevelFieldsEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitTopLevelMethodBegin(TopLevelMethodBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitTopLevelMethodEnd(TopLevelMethodEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitTryStatementBegin(TryStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitCatchClauseBegin(CatchClauseBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitCatchClauseEnd(CatchClauseEnd node) => defaultNode(node);

  @override
  Future<void> visitCatchBlockHandle(CatchBlockHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitFinallyBlockHandle(FinallyBlockHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitTryStatementEnd(TryStatementEnd node) => defaultNode(node);

  @override
  Future<void> visitTypeHandle(TypeHandle node) => defaultNode(node);

  @override
  Future<void> visitNonNullAssertExpressionHandle(
    NonNullAssertExpressionHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitNullAssertPatternHandle(NullAssertPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNullCheckPatternHandle(NullCheckPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitAssignedVariablePatternHandle(
    AssignedVariablePatternHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitDeclaredVariablePatternHandle(
    DeclaredVariablePatternHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitWildcardPatternHandle(WildcardPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNoNameHandle(NoNameHandle node) => defaultNode(node);

  @override
  Future<void> visitRecordTypeBegin(RecordTypeBegin node) => defaultNode(node);

  @override
  Future<void> visitRecordTypeEnd(RecordTypeEnd node) => defaultNode(node);

  @override
  Future<void> visitRecordTypeEntryBegin(RecordTypeEntryBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitRecordTypeEntryEnd(RecordTypeEntryEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitRecordTypeNamedFieldsBegin(
    RecordTypeNamedFieldsBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitRecordTypeNamedFieldsEnd(RecordTypeNamedFieldsEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitFunctionTypeBegin(FunctionTypeBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitFunctionTypeEnd(FunctionTypeEnd node) => defaultNode(node);

  @override
  Future<void> visitTypeArgumentsBegin(TypeArgumentsBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitTypeArgumentsEnd(TypeArgumentsEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitInvalidTypeArgumentsHandle(
    InvalidTypeArgumentsHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitNoTypeArgumentsHandle(NoTypeArgumentsHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitTypeVariableBegin(TypeVariableBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitTypeVariablesDefinedHandle(
    TypeVariablesDefinedHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitTypeVariableEnd(TypeVariableEnd node) => defaultNode(node);

  @override
  Future<void> visitTypeVariablesBegin(TypeVariablesBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitTypeVariablesEnd(TypeVariablesEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitFunctionExpressionBegin(FunctionExpressionBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitFunctionExpressionEnd(FunctionExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitVariablesDeclarationBegin(VariablesDeclarationBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitVariablesDeclarationEnd(VariablesDeclarationEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitWhileStatementBegin(WhileStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitWhileStatementEnd(WhileStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitAsOperatorTypeBegin(AsOperatorTypeBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitAsOperatorTypeEnd(AsOperatorTypeEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitAsOperatorHandle(AsOperatorHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitCastPatternHandle(CastPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitAssignmentExpressionHandle(
    AssignmentExpressionHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitBinaryExpressionBegin(BinaryExpressionBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitBinaryExpressionEnd(BinaryExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitBinaryPatternBegin(BinaryPatternBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitBinaryPatternEnd(BinaryPatternEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitDotAccessHandle(DotAccessHandle node) => defaultNode(node);

  @override
  Future<void> visitCascadeAccessHandle(CascadeAccessHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitConditionalExpressionBegin(
    ConditionalExpressionBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitConditionalExpressionColonHandle(
    ConditionalExpressionColonHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitConditionalExpressionEnd(ConditionalExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitConstExpressionBegin(ConstExpressionBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitConstExpressionEnd(ConstExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitConstFactoryHandle(ConstFactoryHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitForControlFlowBegin(ForControlFlowBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitForControlFlowEnd(ForControlFlowEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitForInControlFlowEnd(ForInControlFlowEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitIfControlFlowBegin(IfControlFlowBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitThenControlFlowHandle(ThenControlFlowHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitElseControlFlowHandle(ElseControlFlowHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitIfControlFlowEnd(IfControlFlowEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitIfElseControlFlowEnd(IfElseControlFlowEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitSpreadExpressionHandle(SpreadExpressionHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNullAwareElementHandle(NullAwareElementHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitRestPatternHandle(RestPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitFunctionTypedFormalParameterBegin(
    FunctionTypedFormalParameterBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitFunctionTypedFormalParameterEnd(
    FunctionTypedFormalParameterEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitIdentifierHandle(IdentifierHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitIndexedExpressionHandle(IndexedExpressionHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitIsOperatorTypeBegin(IsOperatorTypeBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitIsOperatorTypeEnd(IsOperatorTypeEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitIsOperatorHandle(IsOperatorHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitLiteralBoolHandle(LiteralBoolHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitBreakStatementHandle(BreakStatementHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitContinueStatementHandle(ContinueStatementHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitEmptyStatementHandle(EmptyStatementHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitAssertBegin(AssertBegin node) => defaultNode(node);

  @override
  Future<void> visitAssertEnd(AssertEnd node) => defaultNode(node);

  @override
  Future<void> visitLiteralDoubleHandle(LiteralDoubleHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitLiteralDoubleWithSeparatorsHandle(
    LiteralDoubleWithSeparatorsHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitLiteralIntHandle(LiteralIntHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitLiteralIntWithSeparatorsHandle(
    LiteralIntWithSeparatorsHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitLiteralListHandle(LiteralListHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitListPatternHandle(ListPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitLiteralSetOrMapHandle(LiteralSetOrMapHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitMapPatternHandle(MapPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitLiteralNullHandle(LiteralNullHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNativeClauseHandle(NativeClauseHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNamedArgumentHandle(NamedArgumentHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitPatternFieldHandle(PatternFieldHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNamedRecordFieldHandle(NamedRecordFieldHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNewExpressionBegin(NewExpressionBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitNewExpressionEnd(NewExpressionEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitNoArgumentsHandle(NoArgumentsHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitNoConstructorReferenceContinuationAfterTypeArgumentsHandle(
    NoConstructorReferenceContinuationAfterTypeArgumentsHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitNoTypeNameInConstructorReferenceHandle(
    NoTypeNameInConstructorReferenceHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitNoTypeHandle(NoTypeHandle node) => defaultNode(node);

  @override
  Future<void> visitNoTypeVariablesHandle(NoTypeVariablesHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitOperatorHandle(OperatorHandle node) => defaultNode(node);

  @override
  Future<void> visitSwitchCaseNoWhenClauseHandle(
    SwitchCaseNoWhenClauseHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitSwitchExpressionCasePatternHandle(
    SwitchExpressionCasePatternHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitSymbolVoidHandle(SymbolVoidHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitOperatorNameHandle(OperatorNameHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitInvalidOperatorNameHandle(InvalidOperatorNameHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitParenthesizedConditionHandle(
    ParenthesizedConditionHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitPatternBegin(PatternBegin node) => defaultNode(node);

  @override
  Future<void> visitPatternGuardBegin(PatternGuardBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitParenthesizedExpressionOrRecordLiteralBegin(
    ParenthesizedExpressionOrRecordLiteralBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitSwitchCaseWhenClauseBegin(SwitchCaseWhenClauseBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitRecordLiteralEnd(RecordLiteralEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitRecordPatternHandle(RecordPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitPatternEnd(PatternEnd node) => defaultNode(node);

  @override
  Future<void> visitPatternGuardEnd(PatternGuardEnd node) => defaultNode(node);

  @override
  Future<void> visitParenthesizedExpressionEnd(
    ParenthesizedExpressionEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitSwitchCaseWhenClauseEnd(SwitchCaseWhenClauseEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitParenthesizedPatternHandle(
    ParenthesizedPatternHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitConstantPatternBegin(ConstantPatternBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitConstantPatternEnd(ConstantPatternEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitObjectPatternHandle(ObjectPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitQualifiedHandle(QualifiedHandle node) => defaultNode(node);

  @override
  Future<void> visitStringPartHandle(StringPartHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitSuperExpressionHandle(SuperExpressionHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitAugmentSuperExpressionHandle(
    AugmentSuperExpressionHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitSwitchCaseBegin(SwitchCaseBegin node) => defaultNode(node);

  @override
  Future<void> visitSwitchCaseEnd(SwitchCaseEnd node) => defaultNode(node);

  @override
  Future<void> visitSwitchExpressionCaseBegin(SwitchExpressionCaseBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitSwitchExpressionCaseEnd(SwitchExpressionCaseEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitThisExpressionHandle(ThisExpressionHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitUnaryPostfixAssignmentExpressionHandle(
    UnaryPostfixAssignmentExpressionHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitUnaryPrefixExpressionHandle(
    UnaryPrefixExpressionHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitRelationalPatternHandle(RelationalPatternHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitUnaryPrefixAssignmentExpressionHandle(
    UnaryPrefixAssignmentExpressionHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitFormalParameterDefaultValueExpressionBegin(
    FormalParameterDefaultValueExpressionBegin node,
  ) => defaultNode(node);

  @override
  Future<void> visitFormalParameterDefaultValueExpressionEnd(
    FormalParameterDefaultValueExpressionEnd node,
  ) => defaultNode(node);

  @override
  Future<void> visitValuedFormalParameterHandle(
    ValuedFormalParameterHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitFormalParameterWithoutValueHandle(
    FormalParameterWithoutValueHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitVoidKeywordHandle(VoidKeywordHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitVoidKeywordWithTypeArgumentsHandle(
    VoidKeywordWithTypeArgumentsHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitYieldStatementBegin(YieldStatementBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitYieldStatementEnd(YieldStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitInvalidYieldStatementEnd(InvalidYieldStatementEnd node) =>
      defaultNode(node);

  @override
  Future<void> visitRecoverableErrorHandle(RecoverableErrorHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitExperimentNotEnabledHandle(
    ExperimentNotEnabledHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitErrorTokenHandle(ErrorTokenHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitUnescapeErrorHandle(UnescapeErrorHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitInvalidStatementHandle(InvalidStatementHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitScriptHandle(ScriptHandle node) => defaultNode(node);

  @override
  Future<void> visitTypeArgumentApplicationHandle(
    TypeArgumentApplicationHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitNewAsIdentifierHandle(NewAsIdentifierHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitPatternVariableDeclarationStatementHandle(
    PatternVariableDeclarationStatementHandle node,
  ) => defaultNode(node);

  @override
  Future<void> visitPatternAssignmentHandle(PatternAssignmentHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitDotShorthandContextHandle(DotShorthandContextHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitDotShorthandHeadHandle(DotShorthandHeadHandle node) =>
      defaultNode(node);

  @override
  Future<void> visitConstDotShorthandBegin(ConstDotShorthandBegin node) =>
      defaultNode(node);

  @override
  Future<void> visitConstDotShorthandEnd(ConstDotShorthandEnd node) =>
      defaultNode(node);
}
